/* task_powerquad_benchmark.c */

#include "fsl_powerquad.h"
#include "core_portme.h"

/* disable or enable the powerquad on this core. */
#define APP_CFG_ENABLE_PQ_BENCHMARK_TASK 0 /* core1. */


#define FILTER_INPUT_LEN 512
#define FILTER_INPUTA_PRESCALER 9
#define DEMO_POWERQUAD   POWERQUAD

static int N = FILTER_INPUT_LEN;
static int32_t inputData[FILTER_INPUT_LEN * 2];
static int32_t cfftResult[FILTER_INPUT_LEN * 2];

volatile uint32_t gTaskPowerQuadCounter = 0u;

/* Initialize the PowerQuad and make it run. */
//__ramfunc
void Task_PowerQuad_Start(void)
{
#if APP_CFG_ENABLE_PQ_BENCHMARK_TASK /* run the powerquad benchmark task. */
    pq_config_t pq_cfg;

    inputData[0] = 10;
    inputData[2] = 30;
    inputData[4] = 10;
    inputData[6] = 30;
    inputData[8] = -50;
    inputData[10] = 70;

    gTaskPowerQuadCounter = 0u;
    PQ_Init(DEMO_POWERQUAD);

    /* Disable all the event and use the interrupts instead. */
    DEMO_POWERQUAD->EVENTEN = 0u; /* disable all the event and use the interrupts instead. */
    POWERQUAD->INTREN = POWERQUAD_INTREN_INTR_COMP_MASK
                      | POWERQUAD_INTREN_INTR_OFLOW_MASK; /* enable interrupts for DONE. */
    NVIC_EnableIRQ(PQ_IRQn);

    pq_cfg.inputAFormat = kPQ_32Bit;
    pq_cfg.inputAPrescale = FILTER_INPUTA_PRESCALER;
    pq_cfg.inputBFormat = kPQ_32Bit;
    pq_cfg.inputBPrescale = 0;
    pq_cfg.tmpFormat = kPQ_32Bit;
    pq_cfg.tmpPrescale = 0;
    pq_cfg.outputFormat = kPQ_32Bit;
    pq_cfg.outputPrescale = 0;
    pq_cfg.tmpBase = (uint32_t *)0xe0000000;
    pq_cfg.machineFormat = kPQ_32Bit;
    PQ_SetConfig(DEMO_POWERQUAD, &pq_cfg);

    PQ_TransformCFFT(DEMO_POWERQUAD, N, inputData, cfftResult);
    //PQ_WaitDone(DEMO_POWERQUAD);

    //for (uint32_t i = 0; i < N * 2; i++)
    //{
    //    EXAMPLE_ASSERT_TRUE(cfftRef[i] == cfftResult[i]);
    //}
#endif /* APP_CFG_ENABLE_PQ_BENCHMARK_TASK */  /* run the powerquad benchmark task. */
}

//__ramfunc
void Task_PowerQuad_EndHook(void)
{
#if APP_CFG_ENABLE_PQ_BENCHMARK_TASK
    //ee_printf("core 1 gTaskPowerQuadCounter: %d\r\n", gTaskPowerQuadCounter);
    NVIC_DisableIRQ(PQ_IRQn);
#endif /* APP_CFG_ENABLE_PQ_BENCHMARK_TASK */
}

/* ISR for PowerQuad. */
//__ramfunc
void PQ_IRQHandler(void)
{
    uint32_t flags = POWERQUAD->INTRSTAT; /* PQ_GetStatusFlags(). */

    /* A software workaround.
     * Use the OVERFLOW flag instead of DONE flag to detect the DONE interrupt.
     */
    if (POWERQUAD_INTREN_INTR_OFLOW_MASK == (POWERQUAD_INTREN_INTR_OFLOW_MASK & flags) )
    {
	    gTaskPowerQuadCounter++;
    	PQ_TransformCFFT(DEMO_POWERQUAD, N, inputData, cfftResult); /* start the new task. */
	}
    POWERQUAD->INTRSTAT = flags; /* PQ_ClearStatusFlags(). */

}

/* EOF. */

