/*------------------------------------------------------------------
    Automatically generated file for static configuration of the
                      ACIM FOC application

File Name: {FM_project_loc}/../source/m1_acim_appconfig.h 

Date:  February 28, 2019, 15:5:32
------------------------------------------------------------------*/
#ifndef _M1_ACIM_APPCONFIG_H_
#define _M1_ACIM_APPCONFIG_H_


/* motor & application parameters        
------------------------------------------------------------------
pole-pair number                         = 2 [-]
stator resistance                        = 25.223 [Ohms]
rotor resistance                         = 23.004 [Ohms]
stator inductance                        = 0.534 [H]
rotor inductance                         = 0.534 [H]
mutual inductance                        = 0.487 [H]
moment of inertia                        = 0.000873 [kg.m2]
mechanical time constant                 = 1.131 [s]
------------------------------------------------------------------*/
#define M1_MOTOR_PP                      (2)
#define M1_U_NOM                         FRAC16(0.531177829099)
#define M1_I_NOM                         FRAC16(0.1125)
#define M1_F_NOM                         FRAC16(0.5)
#define M1_R_S                           (25.223F)
#define M1_R_R                           (23.004F)
#define M1_L_S                           (0.534F)
#define M1_L_R                           (0.534F)
#define M1_L_M                           (0.487F)
/* application scales */                 
#define M1_I_MAX                         (8.0F)
#define M1_U_MAX                         (250.0F)
#define M1_U_DCB_MAX                     (433.0F)
#define M1_N_MAX                         (3000.0F)
/* fault thresholds */                   
#define M1_U_DCB_TRIP                    FRAC16(0.8)
#define M1_U_DCB_UNDERVOLTAGE            FRAC16(0.069284064665)
#define M1_U_DCB_OVERVOLTAGE             FRAC16(0.850115473441)
#define M1_N_OVERSPEED                   FRAC16(1.666666666667)
/* DC-bus voltage filter */              
#define M1_UDCB_IIR_B0                   FRAC32(0.015229513976)
#define M1_UDCB_IIR_B1                   FRAC32(0.015229513976)
#define M1_UDCB_IIR_A1                   FRAC32(0.469540972049)
/* application counters */               
#define M1_CALIB_DURATION                (200)
#define M1_FAULT_DURATION                (5000)
#define M1_FREEWHEEL_DURATION            (2000)

/* current loop control                  
------------------------------------------------------------------
loop bandwidth                           = 150 [Hz]
loop attenuation                         = 1 [-]
loop sample time                         = 0.0001 [sec]
------------------------------------------------------------------*/
#define M1_CLOOP_LIMIT                   FRAC16(0.9)
/* d-axis controller - parallel type */  
#define M1_D_KP_GAIN                     ACC32(4.61329030715734)
#define M1_D_KI_GAIN                     ACC32(0.2554315719883552)
/* q-axis controller - parallel type */  
#define M1_Q_KP_GAIN                     ACC32(4.61329030715734)
#define M1_Q_KI_GAIN                     ACC32(0.2554315719883552)

/* speed loop control                    
------------------------------------------------------------------
loop bandwidth                           = 2 [Hz]
loop attenuation                         = 1 [-]
loop sample time                         = 0.001 [sec]
------------------------------------------------------------------*/
/* speed controller - parallel type */   
#define M1_SPEED_PI_KP_GAIN              ACC32(0.12934140435785352)
#define M1_SPEED_PI_KI_GAIN              ACC32(0.0008509705848206032)
#define M1_SPEED_LIMIT_HIGH              FRAC16(0.1625)
#define M1_SPEED_LIMIT_LOW               FRAC16(-0.1625)
/* required speed limitations */         
#define M1_SPEED_RAMP_UP                 FRAC32(0.002)
#define M1_SPEED_RAMP_DOWN               FRAC32(0.002)
#define M1_SPEED_REQ_MAX                 FRAC16(1.0)
#define M1_SPEED_REQ_MIN                 FRAC16(0.033333333333)
/* speed filter parameters */            
#define M1_SPEED_IIR_B0                  FRAC32(0.001565876979)
#define M1_SPEED_IIR_B1                  FRAC32(0.001565876979)
#define M1_SPEED_IIR_A1                  FRAC32(0.496868246042)

/* flux loop control                     
------------------------------------------------------------------
maximal d-axis current                   
MTPA minimal d-axis current              = 0.1 [A]
MTPA maximal d-axis current              = 1.3 [A]
MTPA filter bandwidth                    = 10 [Hz]
FW control bandwidth                     = 0.25 [Hz]
FW filter bandwidth                      = 10 [Hz]
------------------------------------------------------------------*/
#define M1_FLUX_ID_MIN                   FRAC16(0.0125)
#define M1_FLUX_ID_MAX                   FRAC16(0.1625)
#define M1_FLUX_MTPA_FILT_COEFF          FRAC32(0.06089863257570738)
#define M1_FLUX_ID_START                 FRAC16(0.0375)
#define M1_FLUX_ID_START_MINPCT          FRAC16(0.95)
#define M1_FLUX_FW_ID_MIN                FRAC16(0.0125)
#define M1_FLUX_FW_KP_GAIN               ACC32(0.0748736170611945)
#define M1_FLUX_FW_KI_GAIN               ACC32(0.003225454469804716)
#define M1_FLUX_IIR_B0                   FRAC32(0.015229513976)
#define M1_FLUX_IIR_B1                   FRAC32(0.015229513976)
#define M1_FLUX_IIR_A1                   FRAC32(0.469540972049)

/* rotor flux observer                   
------------------------------------------------------------------*/
#define M1_RFO_COMP_KP_GAIN              ACC32(25.0)
#define M1_RFO_COMP_KI_GAIN              ACC32(0.01)
#define M1_RFO_KR_INV_GAIN               ACC32(1.096509240246)
#define M1_RFO_LS_TOT_LEAK_GAIN          ACC32(0.003153149897)
#define M1_RFO_PSI_RA1_GAIN              FRAC32(0.995710612933)
#define M1_RFO_PSI_RB1_GAIN              FRAC32(0.000067133771)
#define M1_RFO_PSI_SA1_GAIN              FRAC32(0.999372076006)
#define M1_RFO_PSI_SA2_GAIN              FRAC32(0.000099937208)
#define M1_RFO_RS_EST                    FRAC16(0.807136)
#define M1_RFO_TRQ_CNST                  ACC32(683.988764044944)
#define M1_MRAS_KP_GAIN                  ACC32(32750.0)
#define M1_MRAS_KI_GAIN                  ACC32(12500.0)
#define M1_MRAS_PSI_RA1                  FRAC32(0.995710612933)
#define M1_MRAS_PSI_RB1                  FRAC32(0.002097930337)
#define M1_MRAS_IMAX_GAIN                FRAC32(0.125)

/* scalar control                        
------------------------------------------------------------------*/
#define M1_SCALAR_VHZ_FACTOR_GAIN        FRAC16(0.92)
#define M1_SCALAR_VHZ_FACTOR_SHIFT       (0)
#define M1_SCALAR_INTEG_GAIN             ACC32(0.02)
#define M1_SCALAR_RAMP_UP                FRAC32(0.0002)
#define M1_SCALAR_RAMP_DOWN              FRAC32(0.0002)
#define M1_SCALAR_U_MIN                  FRAC16(0.1)

#endif /* _M1_ACIM_APPCONFIG_H_ */
/*
*######################################################################
*                           End of File
*######################################################################
*/
