/*
 * Flash_config.c
 *
 *  Created on: Jan 25, 2019
 *      Author: nxa22573
 */
#include "qs.h"

typedef struct 
{
	UWord8 tag[4];
	UWord32 crcStartAddress;
	UWord32 crcBytesCount;
	UWord32 crcExpectedCount;
	UWord8 enabledPeripherals;
	UWord8 i2cSlaveAddress;
	UWord16 peripheralDetectionTimeout;
	UWord8 reserved_2[2];
	UWord8 reserved_3[2];
	UWord8 reserved_4[4];
	UWord8 reserved_5;
	UWord8 reserved_6;
	UWord8 reserved_7;
	UWord8 reserved_8;
	UWord8 reserved_9[4];
	UWord8 reserved_10[4];
	UWord8 reserved_11;
	UWord8 canConfig1;
	UWord16 canConfig2;
	UWord16 canTxId;
	UWord16 canRxId;
	UWord8 reserved_12[4];
	UWord8 reserved_13[12];
}Bootloader_Cofiguration_Area_TYPE;

#ifndef FLASHOPT_NV_BACKKEY0_INIT
#define FLASHOPT_NV_BACKKEY0_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY1_INIT
#define FLASHOPT_NV_BACKKEY1_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY2_INIT
#define FLASHOPT_NV_BACKKEY2_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY3_INIT
#define FLASHOPT_NV_BACKKEY3_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY4_INIT
#define FLASHOPT_NV_BACKKEY4_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY5_INIT
#define FLASHOPT_NV_BACKKEY5_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY6_INIT
#define FLASHOPT_NV_BACKKEY6_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_BACKKEY7_INIT
#define FLASHOPT_NV_BACKKEY7_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_FPROT0_INIT
#define FLASHOPT_NV_FPROT0_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_FPROT1_INIT
#define FLASHOPT_NV_FPROT1_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_FPROT2_INIT
#define FLASHOPT_NV_FPROT2_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_FPROT3_INIT
#define FLASHOPT_NV_FPROT3_INIT 0xffU
#endif

#ifndef FLASHOPT_NV_FSEC_INIT
#define FLASHOPT_NV_FSEC_INIT 0xfeU
#endif

#ifndef FLASHOPT_NV_FOPT_INIT
#define FLASHOPT_NV_FOPT_INIT 0xffU
#endif

#ifndef FLASHOPT_BLDR_PERIPHERALS_INIT
#define FLASHOPT_BLDR_PERIPHERALS_INIT 0xffU
#endif

#ifndef FLASHOPT_BLDR_IIC_ADR_INIT
#define FLASHOPT_BLDR_IIC_ADR_INIT 0xffU
#endif

#ifndef FLASHOPT_BLDR_TOUT_INIT
#define FLASHOPT_BLDR_TOUT_INIT 2000
#endif

#ifndef FLASHOPT_BLDR_CAN1_CFG_INIT
#define FLASHOPT_BLDR_CAN1_CFG_INIT 0xffU
#endif

#ifndef FLASHOPT_BLDR_CAN2_CFG_INIT
#define FLASHOPT_BLDR_CAN2_CFG_INIT 0xffffU
#endif

#ifndef FLASHOPT_BLDR_CAN_TX_ID_INIT
#define FLASHOPT_BLDR_CAN_TX_ID_INIT 0xffffU
#endif

#ifndef FLASHOPT_BLDR_CAN_RX_ID_INIT
#define FLASHOPT_BLDR_CAN_RX_ID_INIT 0xffffU
#endif

#ifndef FLASHOPT_CRC_START_APP_INIT
#define FLASHOPT_CRC_START_APP_INIT 0xffffffffU
#endif

#ifndef FLASHOPT_CRC_EXP_VAL_INIT
#define FLASHOPT_CRC_EXP_VAL_INIT 0xffffffffU
#endif

#ifndef FLASHOPT_CRC_BYTE_COUNT_INIT
#define FLASHOPT_CRC_BYTE_COUNT_INIT 0xffffffffU
#endif


#pragma define_section reserved_FCF "reserved_FCF.text"  RX
#pragma section reserved_FCF begin
static const UWord8 _flash_config_field[] = {
		
        /* NV_BACKKEY3: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY3_INIT, \
        /* NV_BACKKEY2: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY2_INIT, \
        /* NV_BACKKEY1: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY1_INIT, \
        /* NV_BACKKEY0: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY0_INIT, \
        /* NV_BACKKEY7: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY7_INIT, \
        /* NV_BACKKEY6: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY6_INIT, \
        /* NV_BACKKEY5: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY5_INIT, \
        /* NV_BACKKEY4: KEY=0xFF */ \
        FLASHOPT_NV_BACKKEY4_INIT, \
        /* NV_FPROT3: PROT=0xFF */ \
        FLASHOPT_NV_FPROT3_INIT, \
        /* NV_FPROT2: PROT=0xFF */ \
        FLASHOPT_NV_FPROT2_INIT, \
        /* NV_FPROT1: PROT=0xFF */ \
        FLASHOPT_NV_FPROT1_INIT, \
        /* NV_FPROT0: PROT=0xFF */ \
        FLASHOPT_NV_FPROT0_INIT, \
        /* NV_FSEC: KEYEN=1,MEEN=3,FSLACC=3,SEC=2 (Note: set SEC to 00b for secure) */ \
        FLASHOPT_NV_FSEC_INIT, \
        /* NV_FOPT: FOPT[7:6] = 11b means boot from ROM, other value means boot from Flash */ \
        FLASHOPT_NV_FOPT_INIT, \
        /* Reserved */ \
        0xFFU, \
        /* Reserved */ \
        0xFFU
};
#pragma section reserved_FCF end

#pragma define_section reserved_BCA "reserved_BCA.text"  RX
#pragma section reserved_BCA begin
static const Bootloader_Cofiguration_Area_TYPE BCA_config = {
		
		/* tag */ \
		{'k', 'c', 'f', 'g'}, \
		/* crcStartAddress */ \
		FLASHOPT_CRC_START_APP_INIT, \
		/* crcByteCount */ \
		FLASHOPT_CRC_BYTE_COUNT_INIT, \
		/* crcExpectedValue */ \
		FLASHOPT_CRC_EXP_VAL_INIT, \
		/* Enabled Peripherals */ \
		FLASHOPT_BLDR_PERIPHERALS_INIT, \
		/* i2c slave address */ \
		FLASHOPT_BLDR_IIC_ADR_INIT, \
		/* peripheral detection timeout, in milliseconds */ \
		FLASHOPT_BLDR_TOUT_INIT, \
		/* reserved */ \
		{0xffU,0xffU}, \
		{0xffU,0xffU}, \
		{0xffU,0xffU,0xffU,0xffU}, \
		0xffU, \
		0xffU, \
		0xffU, \
		0xffU, \
		{0xffU,0xffU,0xffU,0xffU}, \
		{0xffU,0xffU,0xffU,0xffU}, \
		/* reserved */
		0xffU, \
		/* can config1 */ \
		FLASHOPT_BLDR_CAN1_CFG_INIT, \
		/* can config2 */ \
		FLASHOPT_BLDR_CAN2_CFG_INIT, \
		/* can TX Id */ \
		FLASHOPT_BLDR_CAN_TX_ID_INIT, \
		/* can RX Id */
		FLASHOPT_BLDR_CAN_RX_ID_INIT, \
		/* reserved */ \
		{0xffU,0xffU,0xffU,0xffU},	
		/* reserved */ \
		{0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU,0xffU}, \
};
		     
#pragma section reserved_BCA end
