/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"
#include "fsl_spifi.h"
#include "pin_mux.h"
#include "fsl_usart.h"
#include "app_spifi.h"
#include <stdbool.h>
/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define BOARD_LED_PORT 2U
#define BOARD_LED_PIN 2U

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
volatile uint32_t g_systickCounter = 1000U;

/*******************************************************************************
 * Code
 ******************************************************************************/
void SystemInitHook(void)
{
    BOARD_InitPins();
	BOARD_BootClockFROHF96M();
    app_spifi_init();
}

//void SysTick_Handler(void) __attribute__((section("fun_plaintext0")));
__attribute__ ((section(".fun_plaintext0"))) void SysTick_Handler(void)
{
    if (g_systickCounter != 0U)
    {
        g_systickCounter--;
    }
}

//void ns_ledtoggle(void) __attribute__((section("fun_plaintext0")));
__attribute__ ((section(".fun_plaintext0"))) void ns_ledtoggle(void)
{
    if (g_systickCounter == 0)
    {
        GPIO_PortToggle(GPIO, BOARD_LED_PORT, 1u << BOARD_LED_PIN);
        g_systickCounter = 1000;
    }
}

//void ns_print_with_banner(void) __attribute__((section("fun_plaintext1")));
__attribute__ ((section(".fun_plaintext1"))) void ns_print_with_banner(void)
{
    PRINTF("<NS-FLASH:>I'm from non-secure part of QSPI Flash.\r\n");
    PRINTF("<NS-FLASH:>My address: 0x%08X.\r\n", ns_print_with_banner);
}

//void sram0_print_with_banner(void) __attribute__((section("fun_sram0")));
__attribute__ ((section(".fun_sram0"))) void sram0_print_with_banner(void)
{
    PRINTF("<NS-SRAM0:>I'm loaded from QSPI Flash, and excuted from SRAM0.\r\n");
    PRINTF("<NS-SRAM0:>My execution address: 0x%08X.\r\n\r\n", sram0_print_with_banner);
}

//void sram1_print_with_banner(void) __attribute__((section("fun_sram1")));
__attribute__ ((section(".fun_sram1"))) void sram1_print_with_banner(void)
{
    PRINTF("<NS-SRAM1:>I'm loaded from QSPI Flash, and excuted from SRAM1.\r\n");
    PRINTF("<NS-SRAM1:>My execution address: 0x%08X.\r\n\r\n", sram1_print_with_banner);
}

//void sram2_print_with_banner(void) __attribute__((section("fun_sram2")));
__attribute__ ((section(".fun_sram2"))) void sram2_print_with_banner(void)
{
    PRINTF("<NS-SRAM2:>I'm loaded from QSPI Flash, and excuted from SRAM2.\r\n");
    PRINTF("<NS-SRAM2:>My execution address: 0x%08X.\r\n\r\n", sram2_print_with_banner);
}

//void sram3_print_with_banner(void) __attribute__((section("fun_sram3")));
__attribute__ ((section(".fun_sram3"))) void sram3_print_with_banner(void)
{
    PRINTF("<NS-SRAM3:>I'm loaded from QSPI Flash, and excuted from SRAM3.\r\n");
    PRINTF("<NS-SRAM3:>My execution address: 0x%08X.\r\n\r\n", sram3_print_with_banner);
}

/*!
 * @brief Main function
 */
int main(void)
{
    char ch;
    /* Define the init structure for the output LED pin*/
    gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput,
        0,
    };

    /* Init board hardware. */
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    BOARD_InitPins();
    BOARD_InitDebugConsole();

    /* Init output LED GPIO. */
    GPIO_PortInit(GPIO, BOARD_LED_PORT);
    GPIO_PinInit(GPIO, BOARD_LED_PORT, BOARD_LED_PIN, &led_config);

    PRINTF("<S:>The image has been loaded into SRAMX from flash by ROM code.\r\n");
    PRINTF("<S:>The encrypted image has been descrypted by ROM code.\r\n");
    PRINTF("<S:>Executed the image located in SRMAX.\r\n");

    PRINTF("<S:>Enable the SPIFI for executing the plain-text code located in flash.\r\n");

    PRINTF("<S:>Call a function located in flash(XIP).\r\n");
    PRINTF("\r\n");

    ns_print_with_banner();

    PRINTF("\r\n");
    sram0_print_with_banner();
    sram1_print_with_banner();
    sram2_print_with_banner();
    sram3_print_with_banner();

    PRINTF("<S:>The LED will blink per second.\r\n");

    SystemCoreClockUpdate();
    SysTick_Config(SystemCoreClock / 1000U);

    PRINTF("<S:>Enter any character, which will be echoed to terminal.\r\n");

    while (1)
    {
        if (kUSART_RxFifoNotEmptyFlag & USART_GetStatusFlags(USART0))
        {
            ch = USART_ReadByte(USART0);
            PUTCHAR(ch);
        }

        ns_ledtoggle();
    }
}
