/***********************************************************************
* $Id:: mw_usbd_msc.h 331 2012-08-09 18:54:34Z usb10131                       $
*
* Project: USB device ROM Stack
*
* Description:
*     Mass Storage Class definitions.
*
***********************************************************************
*   Copyright(C) 2011, NXP Semiconductor
*   All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.
**********************************************************************/

#ifndef __MSC_H__
#define __MSC_H__

#include "usbd.h"

/** \file
 *  \brief Mass Storage class (MSC) descriptors.
 *
 *  Definition of MSC class descriptors and their bit defines.
 *
 */

/* MSC Subclass Codes */
#define MSC_SUBCLASS_RBC 0x01
#define MSC_SUBCLASS_SFF8020I_MMC2 0x02
#define MSC_SUBCLASS_QIC157 0x03
#define MSC_SUBCLASS_UFI 0x04
#define MSC_SUBCLASS_SFF8070I 0x05
#define MSC_SUBCLASS_SCSI 0x06

/* MSC Protocol Codes */
#define MSC_PROTOCOL_CBI_INT 0x00
#define MSC_PROTOCOL_CBI_NOINT 0x01
#define MSC_PROTOCOL_BULK_ONLY 0x50

/* MSC Request Codes */
#define MSC_REQUEST_RESET 0xFF
#define MSC_REQUEST_GET_MAX_LUN 0xFE

/* MSC Bulk-only Stage */
#define MSC_BS_CBW 0                /* Command Block Wrapper */
#define MSC_BS_DATA_OUT 1           /* Data Out Phase */
#define MSC_BS_DATA_IN 2            /* Data In Phase */
#define MSC_BS_DATA_IN_LAST 3       /* Data In Last Phase */
#define MSC_BS_DATA_IN_LAST_STALL 4 /* Data In Last Phase with Stall */
#define MSC_BS_CSW 5                /* Command Status Wrapper */
#define MSC_BS_ERROR 6              /* Error */

/* Bulk-only Command Block Wrapper */
PRE_PACK struct POST_PACK _MSC_CBW
{
    uint32_t dSignature;
    uint32_t dTag;
    uint32_t dDataLength;
    uint8_t bmFlags;
    uint8_t bLUN;
    uint8_t bCBLength;
    uint8_t CB[16];
};
typedef struct _MSC_CBW MSC_CBW;

/* Bulk-only Command Status Wrapper */
PRE_PACK struct POST_PACK _MSC_CSW
{
    uint32_t dSignature;
    uint32_t dTag;
    uint32_t dDataResidue;
    uint8_t bStatus;
};
typedef struct _MSC_CSW MSC_CSW;

#define MSC_CBW_Signature 0x43425355
#define MSC_CSW_Signature 0x53425355

/* CSW Status Definitions */
#define CSW_CMD_PASSED 0x00
#define CSW_CMD_FAILED 0x01
#define CSW_PHASE_ERROR 0x02

/* SCSI Commands */
#define SCSI_TEST_UNIT_READY 0x00
#define SCSI_REQUEST_SENSE 0x03
#define SCSI_FORMAT_UNIT 0x04
#define SCSI_INQUIRY 0x12
#define SCSI_MODE_SELECT6 0x15
#define SCSI_MODE_SENSE6 0x1A
#define SCSI_START_STOP_UNIT 0x1B
#define SCSI_MEDIA_REMOVAL 0x1E
#define SCSI_READ_FORMAT_CAPACITIES 0x23
#define SCSI_READ_CAPACITY 0x25
#define SCSI_READ10 0x28
#define SCSI_WRITE10 0x2A
#define SCSI_VERIFY10 0x2F
#define SCSI_READ12 0xA8
#define SCSI_WRITE12 0xAA
#define SCSI_MODE_SELECT10 0x55
#define SCSI_MODE_SENSE10 0x5A

#endif /* __MSC_H__ */
