/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap Converter for emWin V5.22.                           *
*        Compiled Jul  4 2013, 12:18:24                              *
*        (c) 1998 - 2013 Segger Microcontroller GmbH && Co. KG       *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: amadablam2064522_1280                                 *
* Dimensions:  480 * 272                                             *
* NumColors:   16bpp: 65536                                          *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"
#include "images.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP images[MAX_NO_OF_IMGS];

IAR_IMGIN_SPIFI(location=0x10020000)
MDK_IMGIN_SPIFI(0x10020000)
static GUI_CONST_STORAGE unsigned short image1[] = {
  0x7CEF, 0x852F, 0x7D2F, 0x7D4F, 0x6CCD, 0x7D0E, 0x95F0, 0x8DD0, 0x85D0, 0x8DF0, 0x85AF, 0x85AF, 0x85F0, 0x96B2, 0x9F13, 0x9EF2, 0x8E90, 0x8EB0, 0x9F12, 0x9F12, 0x9EF2, 0x9F13, 0xA6F4, 0x8E52, 0x6D0E, 0x8590, 0x854F, 0x9E33, 0xA633, 0x95B2, 0x95B2, 
        0x9593, 0x9553, 0x8D34, 0x8D33, 0x8D33, 0x8531, 0x74AD, 0x7D0D, 0x7D0C, 0x7D2C, 0x752C, 0x752C, 0x752C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x852C, 0x852D, 0x8D2D, 0x8D2D, 0x8D4D, 0x954D, 0x956D, 0x956E, 0x956E, 0x954F, 0x8D0F, 0x7CCF, 0x6CAF, 
        0x648F, 0x648F, 0x64CF, 0x6CCF, 0x64EF, 0x64EF, 0x650F, 0x6D0E, 0x6D0F, 0x6D2F, 0x752F, 0x7530, 0x6D0F, 0x6CEF, 0x64AE, 0x5C6D, 0x5C6D, 0x6CEF, 0x7D90, 0x7DD0, 0x7DD0, 0x7DF0, 0x7DF0, 0x85F0, 0x85F1, 0x8E11, 0x8DF1, 0x8DF1, 0x8DD2, 0x8571, 
        0x7CCE, 0x746C, 0x742B, 0x6C09, 0x6C09, 0x6C6B, 0x852D, 0x8DAF, 0x9610, 0x9651, 0x9E72, 0x9E93, 0x9E73, 0x8DD1, 0x64AD, 0x4BEA, 0x4BA8, 0x4BA8, 0x53A8, 0x4BC8, 0x4BC8, 0x4BC7, 0x43C7, 0x43C7, 0x3BC8, 0x3BC7, 0x33C7, 0x33E8, 0x3408, 0x3408, 
        0x3428, 0x3C48, 0x4448, 0x4449, 0x4C69, 0x4C69, 0x5469, 0x5469, 0x5469, 0x5449, 0x5449, 0x4C49, 0x4C29, 0x4C29, 0x4408, 0x3BE8, 0x3BC8, 0x3387, 0x3367, 0x3347, 0x2B26, 0x2B26, 0x2B06, 0x2B07, 0x4B69, 0x63EB, 0x740B, 0x842B, 0x8C6B, 0x9C8C, 
        0x9CAC, 0xA4AC, 0x9CAC, 0x8C8B, 0x6C49, 0x5C09, 0x5C09, 0x6429, 0x644A, 0x648A, 0x6CAB, 0x6CCC, 0x64AC, 0x5C8C, 0x5C4C, 0x5C2B, 0x744C, 0x8C6D, 0x94AE, 0x94AD, 0x948D, 0x8C8D, 0x846C, 0x848D, 0x8CCE, 0x8D0F, 0x8D2F, 0x8D2F, 0x8D0F, 0x84EF, 
        0x84AE, 0x84AE, 0x848E, 0x848D, 0x84AD, 0x84AE, 0x84AE, 0x84AE, 0x84CE, 0x84EE, 0x7D0F, 0x7D0F, 0x7D0F, 0x7D2F, 0x7D2F, 0x7D2F, 0x750F, 0x74EF, 0x6CCE, 0x648D, 0x5C2C, 0x53EB, 0x4369, 0x3308, 0x2AE7, 0x22A6, 0x1A85, 0x1285, 0x1285, 0x1A85, 
        0x1AA4, 0x1AA4, 0x1AC5, 0x22E5, 0x1B05, 0x2305, 0x2325, 0x2325, 0x2345, 0x2B45, 0x2B46, 0x3366, 0x3366, 0x3386, 0x3386, 0x3386, 0x3386, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C27, 0x3C27, 0x3C28, 
        0x3C08, 0x3C08, 0x3C08, 0x4409, 0x4409, 0x4409, 0x4409, 0x4BE9, 0x4BCA, 0x4BAA, 0x4B89, 0x4B6A, 0x434A, 0x434A, 0x4329, 0x4309, 0x3AE9, 0x3AC9, 0x3AA8, 0x3AA8, 0x3AA8, 0x3A88, 0x3288, 0x3288, 0x3267, 0x3267, 0x2A67, 0x2A67, 0x2A66, 0x2266, 
        0x2266, 0x2245, 0x2245, 0x1A45, 0x2225, 0x1A04, 0x19E4, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x1143, 0x1123, 0x1102, 0x08E2, 0x08C2, 0x08C2, 0x08A2, 0x08A1, 0x00A1, 0x08A2, 0x00A1, 0x0082, 0x08A2, 0x08A2, 0x08A2, 0x08C2, 0x08E2, 0x0903, 0x1103, 
        0x1103, 0x1123, 0x1123, 0x1944, 0x1944, 0x1944, 0x1964, 0x1964, 0x1985, 0x1984, 0x1984, 0x19A4, 0x19A4, 0x19A5, 0x21C5, 0x21E5, 0x2205, 0x2225, 0x2245, 0x2266, 0x2266, 0x2286, 0x22A6, 0x22A8, 0x32EA, 0x432D, 0x5BB0, 0x63F2, 0x63F2, 0x63F2, 
        0x63F2, 0x5C12, 0x6432, 0x6452, 0x6452, 0x6452, 0x6472, 0x6472, 0x6C72, 0x6C72, 0x6C72, 0x6C93, 0x6C93, 0x74B3, 0x74B3, 0x74B2, 0x74D3, 0x74D3, 0x7CF3, 0x7D13, 0x7D33, 0x7D32, 0x7D32, 0x7D32, 0x7D12, 0x7D13, 0x8533, 0x8533, 0x8553, 0x8552, 
        0x8553, 0x8D73, 0x8D73, 0x9593, 0x95B4, 0x9DD4, 0x9DD4, 0x9DD4, 0x9DD4, 0x9DD3, 0x95B3, 0x9DF3, 0x9E14, 0x95D3, 0x8D92, 0x8DB2, 0x8DB2, 0x8DB3, 0x85B3, 0x8DD3, 0x8E13, 0x85B2, 0x752F, 0x5C2A, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC7, 0x4BA7, 
        0x4BA7, 0x4BA7, 0x4387, 0x4387, 0x3B48, 0x3B29, 0x432C, 0x53B1, 0x5BF2, 0x6C53, 0x74B3, 0x5C0E, 0x3329, 0x2B07, 0x2B27, 0x3347, 0x3B68, 0x43A8, 0x4BC9, 0x4BE9, 0x5409, 0x5409, 0x5C49, 0x5C49, 0x6469, 0x6489, 0x648A, 0x64AA, 0x64AA, 0x648A, 
        0x648A, 0x646A, 0x646B, 0x646B, 0x6C6C, 0x746C, 0x744C, 0x746C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CCC, 0x74AC, 0x7CAC, 0x7CCC, 0x84EC, 0x952D, 0x9D0D, 0xA50E, 0xAD2E, 0xAD2E, 0xAD2F, 0x9CCF, 0x9CD0, 0xA531, 0xADB3, 0xADD4, 
        0x9572, 0x7CAF, 0x6C4E, 0x644D, 0x642E, 0x644E, 0x5C4E, 0x5C2D, 0x5C0D, 0x540C, 0x53EC, 0x4BCB, 0x4BAB, 0x436A, 0x432A, 0x3B29, 0x3AE9, 0x3AE8, 0x32C8, 0x32C8, 0x32E8, 0x32C8, 0x32C8, 0x32C8, 0x32C9, 0x32C9, 0x32E9, 0x3AE9, 0x3AE9,
  0x7CEE, 0x7D0F, 0x7D2F, 0x8570, 0x7D4F, 0x7D2E, 0x856E, 0x85AF, 0x85D0, 0x8E11, 0x7D8F, 0x756E, 0x7DCF, 0x8E51, 0x96D2, 0x96D2, 0x8E70, 0x96B1, 0x96F2, 0x96D2, 0x96D2, 0x9F13, 0xA714, 0x9EF4, 0x85B0, 0x7D6F, 0xA673, 0xA633, 0x9DF2, 0x9591, 0x8D51, 
        0x8511, 0x7C91, 0x84F2, 0x7CB2, 0x9574, 0x95B3, 0x7D0E, 0x7D0D, 0x7D2D, 0x7D2C, 0x7D2C, 0x752C, 0x752C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x852C, 0x852D, 0x8D2D, 0x8D2D, 0x8D4D, 0x954D, 0x956D, 0x956D, 0x956E, 0x954E, 0x8D0F, 0x84EF, 0x6C8E, 
        0x646E, 0x648E, 0x64AF, 0x6CCF, 0x64EF, 0x64EF, 0x650F, 0x6D0E, 0x6D0F, 0x6D2F, 0x752F, 0x6D2F, 0x6D0F, 0x6CEF, 0x64CF, 0x5C6D, 0x5C6D, 0x6CEE, 0x7D90, 0x7DD0, 0x7DD0, 0x7DF0, 0x7DF0, 0x85F0, 0x85F1, 0x8E11, 0x8DF1, 0x8DD1, 0x8591, 0x7D0F, 
        0x748D, 0x744C, 0x740A, 0x6C09, 0x6C29, 0x748B, 0x8D6E, 0x9DF0, 0x9E31, 0x9E51, 0x9E72, 0xA6B3, 0x9E73, 0x85B0, 0x5C6C, 0x4BC9, 0x4388, 0x4B87, 0x4B88, 0x4B87, 0x4BA7, 0x43A7, 0x43A7, 0x3BA7, 0x3BC7, 0x33C7, 0x33C7, 0x33E8, 0x3408, 0x3408, 
        0x3428, 0x3C48, 0x4449, 0x4449, 0x4C69, 0x4C69, 0x5469, 0x5469, 0x546A, 0x546A, 0x5449, 0x5469, 0x4C49, 0x4C29, 0x4408, 0x43E8, 0x43C8, 0x3BA8, 0x3B87, 0x3347, 0x2B26, 0x2B26, 0x2B06, 0x3B47, 0x5BCA, 0x7C2C, 0x842C, 0x8C4C, 0x946B, 0x9C8C, 
        0x9CAC, 0x9CAC, 0x948C, 0x846A, 0x6429, 0x5C09, 0x5C29, 0x6449, 0x646A, 0x648A, 0x6CAB, 0x6CCC, 0x64AC, 0x5C6C, 0x5C4C, 0x644C, 0x746D, 0x8C8D, 0x8C8D, 0x8C6D, 0x8C6D, 0x848D, 0x84CE, 0x8D0F, 0x8D2F, 0x8D30, 0x8530, 0x7D0F, 0x7CCE, 0x7CAE, 
        0x748E, 0x7C8E, 0x7CAE, 0x84CE, 0x84CE, 0x84EE, 0x84EE, 0x84EE, 0x84EF, 0x7D0F, 0x7D0F, 0x7D0F, 0x7D0F, 0x7D0F, 0x7D0F, 0x74EE, 0x6CAE, 0x644D, 0x53EB, 0x436A, 0x32E8, 0x2AA7, 0x2266, 0x1A65, 0x1A45, 0x1245, 0x1265, 0x1265, 0x1285, 0x12A5, 
        0x1AC4, 0x1AC4, 0x22E5, 0x22E5, 0x2305, 0x2325, 0x2345, 0x2325, 0x2B45, 0x2B45, 0x2B45, 0x3366, 0x3386, 0x3386, 0x3386, 0x3386, 0x3B86, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C27, 0x3C27, 0x3C28, 
        0x3C08, 0x3C08, 0x3C08, 0x4409, 0x4409, 0x4409, 0x4409, 0x4BE9, 0x4BCA, 0x4BAA, 0x4BA9, 0x4B69, 0x4369, 0x4349, 0x4329, 0x4309, 0x3AE9, 0x3AC9, 0x3AA8, 0x3AA8, 0x3AA8, 0x3A88, 0x3288, 0x3288, 0x3267, 0x3287, 0x3287, 0x2A67, 0x2A66, 0x2266, 
        0x2266, 0x2246, 0x2245, 0x1A45, 0x2225, 0x1A04, 0x19E4, 0x11C4, 0x11A3, 0x1983, 0x1163, 0x1143, 0x1143, 0x1122, 0x1102, 0x08E2, 0x08C2, 0x08A2, 0x08A1, 0x00A1, 0x08A2, 0x00A1, 0x0082, 0x08A2, 0x08A2, 0x08A2, 0x08C2, 0x08E2, 0x0903, 0x1103, 
        0x1103, 0x1123, 0x1123, 0x1944, 0x1944, 0x1944, 0x1964, 0x1964, 0x1985, 0x1985, 0x19A5, 0x21C5, 0x21C5, 0x21E5, 0x21E6, 0x2225, 0x2225, 0x2245, 0x2265, 0x2286, 0x22A6, 0x22A6, 0x22C6, 0x2AC7, 0x2AC9, 0x3AEB, 0x4B2E, 0x5BB0, 0x63D1, 0x63F2, 
        0x63F2, 0x5BF1, 0x6412, 0x6432, 0x6452, 0x6472, 0x6472, 0x6472, 0x6C72, 0x6C72, 0x6C72, 0x6C72, 0x6C92, 0x6C92, 0x7492, 0x74B2, 0x74D3, 0x74D3, 0x74F3, 0x7CF3, 0x7D12, 0x7D12, 0x7D12, 0x7D12, 0x7D12, 0x7D12, 0x7D13, 0x8533, 0x8533, 0x8552, 
        0x8553, 0x8552, 0x8D73, 0x9594, 0x95B4, 0x95D4, 0x9DD4, 0x9DD3, 0x95B3, 0x9593, 0x8D92, 0x9DF3, 0x95D3, 0x8D92, 0x8DB2, 0x95D3, 0x8DB3, 0x8593, 0x85B3, 0x8DF3, 0x8E13, 0x7D91, 0x6CAD, 0x540A, 0x4BE8, 0x4BC8, 0x4BC8, 0x53E8, 0x4BC8, 0x4BC8, 
        0x4BC8, 0x4BC8, 0x4BA7, 0x4387, 0x4368, 0x3B6A, 0x4B6D, 0x53B1, 0x5BF2, 0x6C53, 0x6C72, 0x4BCC, 0x3308, 0x2B07, 0x2B27, 0x3327, 0x3B68, 0x4388, 0x4BC9, 0x4BE9, 0x5409, 0x5409, 0x5C49, 0x5C49, 0x6469, 0x6489, 0x648A, 0x64AA, 0x64AA, 0x648A, 
        0x648A, 0x646A, 0x646B, 0x6C4B, 0x6C4C, 0x746C, 0x746C, 0x7C6C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CCC, 0x7CCC, 0x7CCC, 0x84CC, 0x84EC, 0x952D, 0x9D4E, 0xAD4E, 0xAD6E, 0xB54F, 0xAD4F, 0xA50F, 0x9CEF, 0xAD72, 0xB5D4, 0xB614, 0x9D72, 
        0x7CAF, 0x6C4D, 0x640C, 0x640D, 0x5C0D, 0x5C0D, 0x5C0D, 0x53EC, 0x53EC, 0x4BCB, 0x43AB, 0x436A, 0x3B4A, 0x3B09, 0x3AE9, 0x32C8, 0x32A8, 0x32A8, 0x32A7, 0x32A8, 0x32C8, 0x32C8, 0x32C8, 0x32C8, 0x32C8, 0x32C8, 0x32C9, 0x32E9, 0x3AE9,
  0x7CAE, 0x7CEE, 0x750E, 0x8590, 0x7D4F, 0x7D2E, 0x856E, 0x858F, 0x8DF0, 0x8E11, 0x85AF, 0x7D6E, 0x7D8F, 0x8610, 0x8610, 0x9ED2, 0x9691, 0x96D1, 0x8EB0, 0x8E70, 0x8E70, 0x9EF2, 0x9EF4, 0x9ED3, 0x85D0, 0x752E, 0x9612, 0xA653, 0x9DF2, 0xA614, 0x9DB3, 
        0x9DB4, 0x8D53, 0x9574, 0x9595, 0x9595, 0x9DD4, 0x8530, 0x7D0E, 0x7D2D, 0x7D2C, 0x7D2C, 0x752C, 0x752C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x852C, 0x852D, 0x8D2C, 0x8D2D, 0x8D4D, 0x954D, 0x956D, 0x956D, 0x956E, 0x8D4E, 0x8D0F, 0x84CF, 0x748F, 
        0x646E, 0x646E, 0x648F, 0x6CEF, 0x6CEF, 0x650F, 0x650F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6CEF, 0x64CF, 0x648E, 0x5C4D, 0x64AE, 0x7530, 0x7DB0, 0x7DD0, 0x7DD0, 0x7DD0, 0x85D0, 0x85F1, 0x8E11, 0x8DF1, 0x85B2, 0x7D50, 0x6CAF, 
        0x6C6D, 0x6C2B, 0x6C0A, 0x6C09, 0x6C29, 0x74AB, 0x8D8F, 0x9E10, 0x9E31, 0x9E51, 0x9E72, 0xA6B3, 0x9E93, 0x85B0, 0x5C4C, 0x4388, 0x4367, 0x4367, 0x4367, 0x4367, 0x4387, 0x3B87, 0x3B87, 0x3BA7, 0x33A7, 0x33C7, 0x33C7, 0x33E7, 0x33E8, 0x3408, 
        0x3C28, 0x3C28, 0x4449, 0x4C49, 0x4C49, 0x5469, 0x546A, 0x5C69, 0x5C6A, 0x5C6A, 0x5C6A, 0x5C69, 0x5449, 0x5429, 0x4C28, 0x4C08, 0x43E8, 0x43C8, 0x3B88, 0x3367, 0x3347, 0x3327, 0x2B27, 0x4B68, 0x6C0B, 0x844C, 0x8C6C, 0x8C6C, 0x948B, 0x948C, 
        0x94AB, 0x94AC, 0x8C8B, 0x744A, 0x6409, 0x5C09, 0x5C29, 0x644A, 0x646B, 0x6C8B, 0x64AC, 0x648C, 0x5C6C, 0x5C6C, 0x5C4C, 0x642C, 0x742C, 0x7C4C, 0x7C4C, 0x844C, 0x848D, 0x84EE, 0x8D2F, 0x852F, 0x8530, 0x8530, 0x7D10, 0x7CEF, 0x74AE, 0x748E, 
        0x748E, 0x7CAE, 0x7CCF, 0x7CEE, 0x7CEE, 0x7CEF, 0x7CEF, 0x7D0F, 0x7D0F, 0x750F, 0x750F, 0x750F, 0x74EE, 0x6CCE, 0x648D, 0x5C2C, 0x4BAA, 0x3B49, 0x2AA7, 0x2266, 0x1205, 0x1204, 0x11E4, 0x1205, 0x1245, 0x1245, 0x1265, 0x1285, 0x12A5, 0x1AC5, 
        0x1AC5, 0x1AE5, 0x2305, 0x2305, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2B65, 0x2B66, 0x3386, 0x3386, 0x3386, 0x33A6, 0x3B86, 0x3BA7, 0x3BC6, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C28, 0x3C27, 0x3C27, 0x3C28, 0x3C28, 0x3C28, 
        0x3C28, 0x3C08, 0x4429, 0x4429, 0x4409, 0x4409, 0x4409, 0x4409, 0x4BE9, 0x4BCA, 0x43A9, 0x4389, 0x4369, 0x4349, 0x4329, 0x4309, 0x3B09, 0x3AE8, 0x3AC8, 0x3AA8, 0x3AA8, 0x3AA8, 0x3288, 0x3287, 0x32A7, 0x32A7, 0x3287, 0x2A87, 0x2A86, 0x2286, 
        0x2266, 0x2266, 0x1A65, 0x1A45, 0x2245, 0x1A24, 0x1A04, 0x11E4, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x1143, 0x1142, 0x1122, 0x0902, 0x08E2, 0x08C2, 0x08A2, 0x08A1, 0x08A2, 0x00A1, 0x0082, 0x08A2, 0x08A2, 0x08A2, 0x08C2, 0x08E2, 0x0903, 0x0903, 
        0x1103, 0x1123, 0x1123, 0x1944, 0x1944, 0x1944, 0x1964, 0x1984, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 0x21E6, 0x2A06, 0x2246, 0x2266, 0x2A66, 0x2A86, 0x22A6, 0x22C6, 0x22C6, 0x22E6, 0x2AE6, 0x2AE8, 0x330A, 0x432D, 0x4B4E, 0x5BB1, 0x63D1, 
        0x63D1, 0x5BD1, 0x5BD1, 0x6412, 0x6432, 0x6452, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6C72, 0x6C92, 0x6C92, 0x74B2, 0x74B3, 0x74D3, 0x74D3, 0x7CF2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7D12, 0x8512, 0x8512, 0x7D32, 
        0x8533, 0x8553, 0x8D93, 0x95B4, 0x95B4, 0x95D3, 0x95B3, 0x95B3, 0x9593, 0x8D92, 0x95B3, 0x95D3, 0x95B3, 0x95D3, 0x95D3, 0x8DB3, 0x8572, 0x8573, 0x8593, 0x85D3, 0x85D3, 0x7571, 0x648C, 0x540A, 0x53E9, 0x53E8, 0x4BE8, 0x53E8, 0x53E8, 0x53E8, 
        0x4BC8, 0x4BC8, 0x4BA7, 0x4B87, 0x4388, 0x436A, 0x53AE, 0x5BB1, 0x63F3, 0x6C53, 0x6451, 0x438B, 0x32E8, 0x2B07, 0x2B07, 0x3327, 0x3B47, 0x4388, 0x43C8, 0x4BE9, 0x5409, 0x5409, 0x5C29, 0x5C49, 0x5C69, 0x5C69, 0x5C8A, 0x648A, 0x648A, 0x5C8A, 
        0x648A, 0x646A, 0x6C6B, 0x744C, 0x744C, 0x744C, 0x7C6D, 0x746C, 0x7C8C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CCC, 0x84CC, 0x84CC, 0x84EC, 0x950D, 0xA54E, 0xAD6E, 0xB58F, 0xBD8F, 0xBD70, 0xAD0F, 0x9CCF, 0xA551, 0xADD3, 0xADF4, 0x9D92, 0x7CCF, 
        0x640D, 0x5BCC, 0x5BCC, 0x53CC, 0x53CC, 0x4BCC, 0x4BCC, 0x4BAC, 0x4BAB, 0x438B, 0x434A, 0x3B29, 0x3B09, 0x32C9, 0x32A8, 0x32A8, 0x32A8, 0x3288, 0x3288, 0x3288, 0x32A8, 0x32A8, 0x32A8, 0x32A8, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x3AE9,
  0x746D, 0x74AD, 0x750E, 0x8590, 0x74EE, 0x7D0E, 0x7D2D, 0x858E, 0x8E10, 0x8E11, 0x85CF, 0x8E10, 0x9692, 0x9692, 0x96B2, 0x9692, 0x7DAE, 0x9650, 0x9EF2, 0x9EF2, 0x9F12, 0x9EF3, 0x96D3, 0x96B3, 0x9E93, 0x7D6F, 0x750E, 0x9E32, 0x9612, 0x9DF3, 0x9E14, 
        0x9DF4, 0x8D93, 0x95B5, 0x95B5, 0x8D95, 0x95B4, 0x8D51, 0x74CD, 0x7D0D, 0x7D2D, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x7D2C, 0x7D2C, 0x852C, 0x852C, 0x8D2D, 0x8D2C, 0x8D4D, 0x954D, 0x956D, 0x956D, 0x954E, 0x8D2E, 0x8CEF, 0x84CF, 0x748F, 
        0x6C6E, 0x646E, 0x6C8F, 0x6CEF, 0x6CEF, 0x650F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6CEF, 0x6D0F, 0x6CEF, 0x6CEF, 0x64CF, 0x648E, 0x5C4D, 0x5C6E, 0x6CEF, 0x7590, 0x7DB0, 0x7DD0, 0x7DD0, 0x85D0, 0x8DF1, 0x8E11, 0x8E12, 0x8DB2, 0x7D31, 0x74AF, 
        0x6C4D, 0x6C0B, 0x6C0A, 0x6C09, 0x6C29, 0x7CCC, 0x8DAF, 0x9E30, 0x9651, 0x9E71, 0x9E92, 0xA6B3, 0x9E73, 0x8DB1, 0x5C4C, 0x3B48, 0x3B27, 0x3B26, 0x3B26, 0x3B46, 0x3B46, 0x3B47, 0x3B67, 0x3367, 0x3387, 0x3387, 0x33C7, 0x33C7, 0x33E8, 0x3408, 
        0x3C08, 0x3C28, 0x4449, 0x4C49, 0x5449, 0x5449, 0x5469, 0x5C69, 0x5C6A, 0x5C6A, 0x5C6A, 0x5C6A, 0x5C4A, 0x5429, 0x5429, 0x4C09, 0x43E8, 0x43C8, 0x43A8, 0x3B67, 0x3347, 0x3347, 0x3347, 0x53A9, 0x742B, 0x8C6C, 0x948C, 0x948C, 0x8CAC, 0x94AB, 
        0x94AB, 0x8CAB, 0x848B, 0x6C2A, 0x6409, 0x5C09, 0x5C29, 0x644A, 0x646B, 0x648B, 0x5C6C, 0x5C6C, 0x5C4C, 0x5C4C, 0x642C, 0x6C2C, 0x742C, 0x7C4D, 0x7C8D, 0x84AE, 0x84EF, 0x852F, 0x852F, 0x852F, 0x7D50, 0x7D50, 0x7D30, 0x7D0F, 0x74EF, 0x74CF, 
        0x7CCF, 0x7CCF, 0x7CEF, 0x7CEF, 0x7CEF, 0x7CEF, 0x7D0F, 0x750F, 0x750F, 0x750E, 0x6CEE, 0x648D, 0x5C2C, 0x4BCB, 0x4369, 0x32E8, 0x2A87, 0x1A26, 0x11E4, 0x11C4, 0x11C4, 0x11E4, 0x11E4, 0x1205, 0x1245, 0x1245, 0x1265, 0x1285, 0x12A5, 0x1AC5, 
        0x1AE5, 0x1B05, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2365, 0x2365, 0x2B65, 0x2B86, 0x3386, 0x3386, 0x3386, 0x33A6, 0x3BA7, 0x3BA7, 0x3BC6, 0x3BC6, 0x3BC7, 0x3BE7, 0x3BE7, 0x4407, 0x4407, 0x3C08, 0x3C27, 0x3C27, 0x3C28, 0x3C28, 0x3C28, 
        0x3C28, 0x3C08, 0x4429, 0x4429, 0x4409, 0x4409, 0x4409, 0x4409, 0x43E9, 0x43C9, 0x43C9, 0x43A9, 0x4389, 0x4369, 0x4349, 0x4329, 0x3B09, 0x3AE8, 0x3AC8, 0x3AC8, 0x3AA8, 0x3AA8, 0x32A8, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x2AA7, 0x2AA7, 0x2286, 
        0x2286, 0x2286, 0x1A65, 0x1A65, 0x1A65, 0x1A45, 0x1A24, 0x1204, 0x11E4, 0x11C3, 0x11C3, 0x11A3, 0x1163, 0x1162, 0x1122, 0x1122, 0x1102, 0x08E2, 0x08C2, 0x00C1, 0x00A1, 0x00A1, 0x00A2, 0x08A2, 0x08A2, 0x08A2, 0x08C2, 0x08E2, 0x08E3, 0x0903, 
        0x1103, 0x1123, 0x1123, 0x1944, 0x1944, 0x1964, 0x1964, 0x1985, 0x21A5, 0x21C6, 0x21C6, 0x21E6, 0x21E6, 0x2A06, 0x2A26, 0x2A66, 0x2A66, 0x2A86, 0x2AA6, 0x22C6, 0x22E6, 0x2B06, 0x2B26, 0x2B26, 0x3328, 0x3329, 0x432B, 0x4B4D, 0x536F, 0x5BD1, 
        0x63D1, 0x5BD1, 0x5BD1, 0x5BD1, 0x5C11, 0x6452, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6C72, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x74B2, 0x74B3, 0x74D2, 0x74F2, 0x74F2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7D12, 0x7CF2, 0x7D12, 
        0x8533, 0x8D73, 0x8D94, 0x9594, 0x9593, 0x95B3, 0x95B3, 0x9593, 0x8D72, 0x95B3, 0x9DD3, 0x95D3, 0x95B3, 0x95B3, 0x8DB3, 0x8573, 0x8552, 0x8573, 0x85B4, 0x85B3, 0x85D3, 0x7571, 0x648C, 0x540A, 0x5409, 0x53E8, 0x5408, 0x5408, 0x5409, 0x53E9, 
        0x53C8, 0x53C9, 0x53A8, 0x4B88, 0x4389, 0x4B6B, 0x5BCF, 0x63F2, 0x6413, 0x6C52, 0x5C10, 0x3309, 0x2AE8, 0x2B07, 0x2B07, 0x3327, 0x3B48, 0x4388, 0x43A8, 0x4BC8, 0x4BE9, 0x5408, 0x5429, 0x5C49, 0x5C69, 0x5C69, 0x5C8A, 0x648A, 0x648A, 0x5C8A, 
        0x5C8A, 0x648B, 0x6C8C, 0x744C, 0x7C4C, 0x7C4C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CAC, 0x7CAC, 0x7CCC, 0x84CC, 0x8CEC, 0x950D, 0xA54E, 0xB56F, 0xBD8F, 0xBD8F, 0xC590, 0xBD50, 0xA4AE, 0x9CF0, 0xADB3, 0xADF4, 0x9D92, 0x7CAF, 0x63ED, 
        0x53AC, 0x538B, 0x536B, 0x4B8B, 0x4B8B, 0x438B, 0x438B, 0x436B, 0x436B, 0x3B2A, 0x3B09, 0x32E9, 0x32C8, 0x32A8, 0x2A88, 0x2A68, 0x2A68, 0x2A68, 0x2A68, 0x3288, 0x3288, 0x32A8, 0x32A8, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x3AE9,
  0x7CCE, 0x7CEE, 0x8550, 0x8DB1, 0x7D0E, 0x6CCC, 0x6CEC, 0x85AF, 0x8E10, 0x85F0, 0x7DAE, 0x85F0, 0x9672, 0x96B2, 0x9ED3, 0x8E10, 0x754D, 0x9651, 0x9EF2, 0x9EF2, 0x9EF2, 0x9F13, 0x9F13, 0x9EF3, 0x9EB3, 0x6D2D, 0x752E, 0x9E52, 0x9632, 0x8DD2, 0x8571, 
        0x95F4, 0x8DB3, 0x8DD4, 0x8DB5, 0x8574, 0x8553, 0x8531, 0x74EE, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D2C, 0x852C, 0x852D, 0x8D2D, 0x8D4D, 0x8D6D, 0x956E, 0x954E, 0x954E, 0x8D0E, 0x84EE, 0x7CAF, 
        0x746F, 0x6C6F, 0x6C8F, 0x6CCF, 0x6CEF, 0x650F, 0x650F, 0x650F, 0x650F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6CEF, 0x64EF, 0x64CF, 0x64AF, 0x5C4E, 0x544D, 0x64AE, 0x754F, 0x7DB0, 0x7DB0, 0x7DB0, 0x7DD0, 0x8611, 0x8E12, 0x8E13, 0x8DB2, 0x8531, 0x74CF, 
        0x746D, 0x6C2B, 0x6C0A, 0x6C09, 0x6429, 0x7CEC, 0x95CF, 0x9650, 0x9651, 0x9E71, 0xA692, 0xAEB3, 0xA673, 0x8591, 0x5C2C, 0x3308, 0x2AE6, 0x32E6, 0x3306, 0x3306, 0x3326, 0x2B26, 0x2B46, 0x2B46, 0x2B66, 0x2B67, 0x2B87, 0x2BA7, 0x33C7, 0x33E8, 
        0x3C08, 0x4428, 0x4429, 0x4C49, 0x5449, 0x5469, 0x5469, 0x5C6A, 0x5C6A, 0x646A, 0x5C6A, 0x5C6A, 0x5C6A, 0x544A, 0x5429, 0x4C29, 0x4C08, 0x43C8, 0x43A8, 0x3B88, 0x3B67, 0x3B47, 0x4388, 0x640A, 0x848C, 0x94AD, 0x94AC, 0x94AC, 0x94CC, 0x94CC, 
        0x8CCB, 0x8CAB, 0x7C6A, 0x6C29, 0x5C09, 0x5C09, 0x5C29, 0x646A, 0x646B, 0x5C4B, 0x5C4C, 0x5C2C, 0x5C2C, 0x644C, 0x642C, 0x6C4D, 0x7CAE, 0x7CEE, 0x850F, 0x7D0F, 0x7D0F, 0x7D2F, 0x7D2F, 0x7D4F, 0x7D4F, 0x7D4F, 0x7D4F, 0x7D2F, 0x750F, 0x7CEF, 
        0x7CEF, 0x74EF, 0x750F, 0x74EF, 0x74EF, 0x74EF, 0x74EF, 0x74EF, 0x6CAE, 0x646D, 0x53EB, 0x436A, 0x3B08, 0x2AA7, 0x2246, 0x19E5, 0x19C5, 0x11A4, 0x11C4, 0x11C4, 0x11C4, 0x11E4, 0x1204, 0x1A25, 0x1245, 0x1265, 0x1A85, 0x12A5, 0x1AC5, 0x1AE5, 
        0x1B05, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2365, 0x2365, 0x2365, 0x2B85, 0x2B86, 0x2B86, 0x3386, 0x33A6, 0x3BA6, 0x3BA6, 0x3BC7, 0x3BC6, 0x3BC6, 0x3BC6, 0x3BC6, 0x3BE7, 0x4407, 0x4407, 0x3C08, 0x3C27, 0x3C27, 0x3C27, 0x3C27, 0x3C28, 
        0x3C28, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x3C09, 0x4409, 0x4409, 0x4409, 0x3BE9, 0x3BC9, 0x43C9, 0x43A9, 0x4389, 0x3B69, 0x3B29, 0x3B29, 0x3B08, 0x3AE8, 0x3AC8, 0x3AA8, 0x3AA8, 0x32A8, 0x32A7, 0x32A7, 0x32A7, 0x2AA7, 0x2AA7, 0x2AA6, 0x2AC6, 
        0x22C6, 0x22A5, 0x1AA5, 0x1A85, 0x2285, 0x1A65, 0x1A64, 0x1A44, 0x1A04, 0x1203, 0x11E3, 0x11C3, 0x11A3, 0x1182, 0x1162, 0x0942, 0x1122, 0x0902, 0x08E2, 0x08E2, 0x08C2, 0x00A1, 0x00A2, 0x00A2, 0x00A2, 0x08A2, 0x08C2, 0x08C2, 0x08E3, 0x08E3, 
        0x08E3, 0x1103, 0x1104, 0x1944, 0x1964, 0x1964, 0x2185, 0x21C5, 0x21C5, 0x21E6, 0x21E6, 0x2206, 0x2A26, 0x2226, 0x2A46, 0x2266, 0x2A86, 0x2AA6, 0x2AE6, 0x2AE6, 0x2B06, 0x2B26, 0x2B46, 0x2B46, 0x3347, 0x3368, 0x3B6A, 0x436C, 0x536E, 0x5B90, 
        0x63D1, 0x63D1, 0x63D1, 0x63D1, 0x63F1, 0x6432, 0x6452, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x74B2, 0x74B2, 0x74D2, 0x74D2, 0x74D2, 0x74F2, 0x74F2, 0x7CF2, 0x7CF2, 0x7CF2, 0x7D12, 0x8533, 
        0x8D53, 0x8D73, 0x8D94, 0x9594, 0x9593, 0x9593, 0x9593, 0x8D52, 0x8D73, 0x95D3, 0x9DD3, 0x9DD3, 0x95B3, 0x9593, 0x8552, 0x8552, 0x7D53, 0x7D93, 0x7DB4, 0x85F3, 0x85F3, 0x7570, 0x5C8C, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x644A, 
        0x6C4B, 0x644C, 0x5C0B, 0x53AA, 0x4369, 0x4B6C, 0x6410, 0x6412, 0x6C33, 0x6C53, 0x5BCF, 0x32C8, 0x32C8, 0x2AE7, 0x32E7, 0x3307, 0x3B48, 0x3B68, 0x4388, 0x43A8, 0x4BE8, 0x53E8, 0x5409, 0x5429, 0x5C49, 0x5C69, 0x5C69, 0x5C6A, 0x5C8A, 0x5C8A, 
        0x5C8A, 0x646B, 0x746C, 0x7C6D, 0x7C4C, 0x7C6C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x84CC, 0x84CB, 0x84CB, 0x8CEC, 0x9D0D, 0xA54E, 0xB56F, 0xBD8F, 0xC58E, 0xC5AF, 0xC570, 0xB50F, 0x9C8F, 0xAD52, 0xADF3, 0x9DD3, 0x7CF0, 0x5BEC, 0x4B6B, 
        0x4B4A, 0x4B4A, 0x432A, 0x432A, 0x432B, 0x434A, 0x3B2A, 0x3B0A, 0x330A, 0x32E9, 0x32C8, 0x2AA8, 0x2A88, 0x2A68, 0x2A67, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A68, 0x3288, 0x3288, 0x32A8, 0x32A9, 0x32C9, 0x32C9, 0x32C9, 0x3AC8, 0x3AC9,
  0x84EF, 0x7D0F, 0x7D2F, 0x7D2F, 0x74ED, 0x74CC, 0x7D4E, 0x8DF0, 0x8E30, 0x860F, 0x7DCF, 0x7DCF, 0x8651, 0x8E72, 0x8E72, 0x85F0, 0x9E72, 0xA6D3, 0x9EF3, 0x9EF2, 0x96D1, 0x9F13, 0x9F13, 0xA713, 0xA714, 0x9E72, 0x7D8F, 0x9672, 0x9E73, 0x9653, 0x9E53, 
        0x9E34, 0x8DD3, 0x85B3, 0x8594, 0x7D53, 0x8553, 0x8DB3, 0x7D2F, 0x7D0E, 0x7D0D, 0x7D0D, 0x7D2D, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D2C, 0x7D0C, 0x852D, 0x852D, 0x8D4D, 0x8D6D, 0x956E, 0x956E, 0x954E, 0x8D2E, 0x8D0E, 0x84CF, 
        0x7CB0, 0x6C6F, 0x6C8F, 0x6CAF, 0x6CEF, 0x6CEF, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D2F, 0x6D2F, 0x6D2F, 0x6D0F, 0x6D0F, 0x6CEF, 0x64AF, 0x5C6E, 0x544D, 0x5C6D, 0x6D0F, 0x7590, 0x75B0, 0x7DB0, 0x7DF0, 0x8611, 0x8E12, 0x8DF3, 0x8DB3, 0x7D31, 0x7CD0, 
        0x746D, 0x6C2B, 0x6C0A, 0x6409, 0x6449, 0x7D0C, 0x95CF, 0x9651, 0x9651, 0x9E91, 0xA6B2, 0xAED4, 0xA693, 0x8D92, 0x5C2D, 0x32E7, 0x2AA6, 0x2AA6, 0x2AC6, 0x2AC6, 0x2AE6, 0x2B06, 0x2306, 0x2326, 0x2346, 0x2346, 0x2367, 0x2BA7, 0x33C7, 0x33E7, 
        0x3C08, 0x4428, 0x4428, 0x4C49, 0x5449, 0x5469, 0x5C69, 0x5C6A, 0x648A, 0x648A, 0x648A, 0x5C6A, 0x5C6A, 0x5C6A, 0x5449, 0x4C29, 0x4C09, 0x4BE8, 0x43C8, 0x4BA8, 0x4388, 0x4368, 0x5BE9, 0x7C8C, 0x94CD, 0x9CCD, 0x9CEC, 0x94CC, 0x94EC, 0x94EC, 
        0x8CEC, 0x84AB, 0x746A, 0x6429, 0x5C09, 0x5C09, 0x5C2A, 0x5C4B, 0x5C4B, 0x5C2B, 0x540B, 0x540C, 0x5C2C, 0x642C, 0x6C4D, 0x74AE, 0x7CEF, 0x7D0F, 0x7D2F, 0x7D2F, 0x7D2F, 0x752E, 0x752E, 0x754F, 0x754F, 0x7D4F, 0x7D4F, 0x7D2F, 0x750F, 0x750F, 
        0x750F, 0x750F, 0x74EF, 0x6CCE, 0x6CCE, 0x6CAE, 0x646D, 0x5C2C, 0x53AB, 0x4329, 0x32A7, 0x2246, 0x1A06, 0x11C5, 0x11A4, 0x1184, 0x1184, 0x11A4, 0x19A5, 0x19C5, 0x19E5, 0x1A05, 0x1A25, 0x1A44, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 
        0x1B25, 0x2345, 0x2345, 0x2365, 0x2365, 0x2365, 0x2365, 0x2365, 0x2365, 0x2B86, 0x2B86, 0x2BA6, 0x33A6, 0x33A6, 0x3BA6, 0x3BC7, 0x3BC7, 0x43A7, 0x3BA6, 0x3BA6, 0x3BC6, 0x3BE6, 0x3BE7, 0x4407, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C28, 0x3C28, 
        0x3C28, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3C08, 0x4409, 0x4409, 0x4409, 0x43E9, 0x3BE9, 0x43C9, 0x43A9, 0x3B89, 0x3B68, 0x3B48, 0x3B29, 0x3B28, 0x3AE8, 0x3AC8, 0x3AC8, 0x3AC8, 0x32C8, 0x32A8, 0x32A7, 0x32A7, 0x2AC7, 0x2AC7, 0x2AC6, 0x2AC6, 
        0x22C6, 0x22C5, 0x1AC5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1A84, 0x1A64, 0x1A44, 0x1243, 0x1203, 0x11E3, 0x11C3, 0x11A3, 0x1182, 0x1162, 0x1142, 0x0922, 0x0902, 0x08E2, 0x08E2, 0x00C2, 0x00A1, 0x00A2, 0x00A2, 0x00C2, 0x00C2, 0x08C3, 0x08C3, 0x08E3, 
        0x08E3, 0x0903, 0x1104, 0x1944, 0x1964, 0x1985, 0x21A5, 0x21C5, 0x21E5, 0x21E6, 0x2206, 0x2226, 0x2A46, 0x2245, 0x2A65, 0x2286, 0x2AA6, 0x2AC6, 0x2AE6, 0x2B06, 0x2B26, 0x2B46, 0x2B66, 0x2B66, 0x2B66, 0x3387, 0x3B89, 0x436B, 0x4B6D, 0x536E, 
        0x5BB0, 0x63D0, 0x63D1, 0x63D1, 0x5BF1, 0x6412, 0x6432, 0x6C72, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6472, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x74B2, 0x74B2, 0x74B2, 0x74D2, 0x74D2, 0x74F2, 0x74D2, 0x74D2, 0x7CF2, 0x7D12, 0x8533, 0x8533, 
        0x8D53, 0x8D73, 0x8D73, 0x8D93, 0x8D93, 0x8D73, 0x8D72, 0x8D73, 0x95B3, 0x95D3, 0x95D3, 0x95B3, 0x95B3, 0x8D73, 0x7D12, 0x7D13, 0x7D53, 0x7D94, 0x7DD4, 0x8614, 0x8613, 0x7570, 0x5C6B, 0x5C29, 0x5C29, 0x5C29, 0x5C09, 0x5C09, 0x644B, 0x7CCD, 
        0x850F, 0x8510, 0x7CEF, 0x6C8D, 0x5C2D, 0x642F, 0x6C31, 0x6C33, 0x6C33, 0x6C32, 0x4B6D, 0x2AA8, 0x2AA7, 0x2AC7, 0x2AC7, 0x32E7, 0x3327, 0x3B47, 0x3B68, 0x4388, 0x4BC8, 0x4BE8, 0x5408, 0x5429, 0x5449, 0x5449, 0x5469, 0x5C69, 0x5C6A, 0x5C6A, 
        0x646A, 0x6C6C, 0x7C6D, 0x7C4C, 0x7C4C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CAC, 0x84CC, 0x8CEC, 0x8CEC, 0x9D0D, 0xA52E, 0xB54E, 0xBD8F, 0xC58F, 0xCD8F, 0xC58F, 0xBD50, 0xACEF, 0x9CF0, 0xADB3, 0xA5F3, 0x8510, 0x640C, 0x4B6A, 0x4329, 
        0x430A, 0x4309, 0x3AEA, 0x3AEA, 0x3AEA, 0x32EA, 0x32E9, 0x32C9, 0x2AA9, 0x2A88, 0x2A68, 0x2A67, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A68, 0x3288, 0x3288, 0x32A9, 0x32A9, 0x32A9, 0x32A8, 0x32A8, 0x32A8,
  0x7CCE, 0x7D0F, 0x750F, 0x7D4F, 0x74ED, 0x6C8B, 0x7D4E, 0x8DF0, 0x8610, 0x7E10, 0x75CE, 0x75CF, 0x7E10, 0x8651, 0x9693, 0xA6D4, 0xAF14, 0xAF14, 0xA6F3, 0x9F13, 0x9EF2, 0x8E70, 0x8E50, 0xA734, 0xA714, 0x9EB3, 0x7D8F, 0x8E31, 0x9E93, 0x9652, 0x9E73, 
        0x9E54, 0x8DD3, 0x7D92, 0x7D53, 0x7512, 0x7512, 0x7D11, 0x7D30, 0x7CED, 0x7D0D, 0x7D0D, 0x7D2D, 0x7D2C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x852D, 0x852D, 0x8D4D, 0x8D6D, 0x956E, 0x956E, 0x954E, 0x8D4E, 0x8D2E, 0x84EF, 
        0x7CCF, 0x74AF, 0x6C8F, 0x64AF, 0x64CF, 0x6CF0, 0x6D10, 0x6D10, 0x6D30, 0x6D30, 0x6D30, 0x6D4F, 0x6D2F, 0x6D0F, 0x6D0F, 0x64CF, 0x5C8E, 0x5C4E, 0x546D, 0x64CE, 0x756F, 0x7590, 0x75B0, 0x7DF1, 0x8611, 0x8E12, 0x8DF2, 0x8592, 0x7D31, 0x74D0, 
        0x748E, 0x6C4C, 0x6C2A, 0x6C29, 0x6C6A, 0x854D, 0x95F0, 0x9651, 0x9671, 0xA692, 0xAEB3, 0xB6D4, 0xA694, 0x8592, 0x5C0D, 0x2AC7, 0x2286, 0x2265, 0x2285, 0x22A5, 0x22C6, 0x22C6, 0x22E6, 0x2306, 0x2326, 0x2326, 0x2346, 0x2B87, 0x33A7, 0x33C7, 
        0x3BE8, 0x4408, 0x4428, 0x4C29, 0x5449, 0x5469, 0x5C69, 0x5C6A, 0x648A, 0x648A, 0x648A, 0x5C6A, 0x5C6A, 0x5C69, 0x5C49, 0x5429, 0x4C09, 0x4BE8, 0x4BE9, 0x5BEA, 0x5BEA, 0x5BC9, 0x744B, 0x8CCD, 0x9CED, 0x9CED, 0x9CEC, 0x9CEC, 0x94EC, 0x94EC, 
        0x8CCC, 0x7C8B, 0x6C4A, 0x6409, 0x5409, 0x5409, 0x5C2A, 0x5C2A, 0x542B, 0x540B, 0x5C0C, 0x644D, 0x646E, 0x6C6E, 0x6CAE, 0x74CF, 0x7CEF, 0x7D0F, 0x7D2F, 0x7D2F, 0x752F, 0x750F, 0x750F, 0x754F, 0x752F, 0x7D2F, 0x752F, 0x750F, 0x750E, 0x74EF, 
        0x74EF, 0x6CCE, 0x6CAE, 0x646D, 0x5C2C, 0x4BAA, 0x434A, 0x3AE9, 0x2A87, 0x2226, 0x19E5, 0x11A5, 0x1184, 0x1164, 0x1184, 0x1164, 0x1184, 0x11A4, 0x19C5, 0x19E5, 0x1A05, 0x1A25, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 
        0x1B45, 0x2345, 0x2365, 0x2385, 0x2385, 0x2385, 0x2385, 0x2365, 0x2385, 0x2B86, 0x2B86, 0x2B86, 0x3386, 0x3BA7, 0x3BA7, 0x3BC7, 0x3BC7, 0x43C7, 0x43A7, 0x43A6, 0x3BC6, 0x3BC6, 0x3BE7, 0x4407, 0x3C07, 0x3C07, 0x4427, 0x3C27, 0x3C28, 0x3C28, 
        0x3C28, 0x3C48, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3C29, 0x4429, 0x4429, 0x4409, 0x4409, 0x43E9, 0x43C9, 0x3BA8, 0x3B88, 0x3B48, 0x3B28, 0x3B28, 0x3B08, 0x3AE8, 0x3AE8, 0x3AC8, 0x3AC8, 0x32C8, 0x32C7, 0x32C7, 0x2AC7, 0x2AC7, 0x2AE6, 0x2AE6, 
        0x22E6, 0x22E6, 0x1AE5, 0x1AE5, 0x1AC5, 0x1AC4, 0x1AA4, 0x1A84, 0x1264, 0x1263, 0x1243, 0x1203, 0x11E3, 0x11C3, 0x11A3, 0x0982, 0x1163, 0x1143, 0x1122, 0x0902, 0x08E2, 0x08E2, 0x08C1, 0x08A2, 0x08C2, 0x08C2, 0x00C2, 0x08C2, 0x08C2, 0x08E3, 
        0x08E3, 0x0903, 0x1103, 0x1144, 0x1984, 0x19A5, 0x21C5, 0x21E5, 0x2205, 0x2225, 0x2225, 0x2245, 0x2266, 0x2266, 0x2A86, 0x2AA6, 0x2AE6, 0x2B06, 0x2B06, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x2B86, 0x2B86, 0x3387, 0x3B88, 0x4389, 0x436B, 0x4B6D, 
        0x536E, 0x5BD0, 0x63D1, 0x63D1, 0x63D1, 0x5BD1, 0x63F1, 0x6C52, 0x6C72, 0x6C72, 0x6472, 0x6472, 0x6472, 0x6472, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x6CB2, 0x6CB2, 0x6CD2, 0x74D2, 0x74D2, 0x74D2, 0x74D2, 0x7CF2, 0x8533, 0x8533, 0x8533, 
        0x8553, 0x8553, 0x8D73, 0x8D73, 0x8D73, 0x8D72, 0x8D72, 0x9593, 0x95B4, 0x95D3, 0x95B3, 0x95B3, 0x8D73, 0x7CF1, 0x7CD2, 0x7D13, 0x7553, 0x7D94, 0x7DD4, 0x8634, 0x8633, 0x754F, 0x5C6B, 0x5C29, 0x5C29, 0x5C29, 0x5C29, 0x642A, 0x6C4C, 0x746E, 
        0x7CAF, 0x8530, 0x7D51, 0x7D30, 0x74F0, 0x6CB1, 0x6C72, 0x6C53, 0x6C54, 0x6C11, 0x430B, 0x2A67, 0x2A87, 0x2AA7, 0x2AA7, 0x32C7, 0x3307, 0x3347, 0x3B67, 0x4387, 0x43A8, 0x4BC8, 0x4BE8, 0x4C08, 0x5429, 0x5429, 0x5449, 0x5449, 0x546A, 0x5C6A, 
        0x646A, 0x6C8C, 0x7C6C, 0x7C4C, 0x7C6C, 0x7C8C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CAC, 0x84AC, 0x8CEC, 0x94EC, 0x9D0D, 0xA52D, 0xB54E, 0xBD6F, 0xC58F, 0xC58F, 0xCD8F, 0xC56F, 0xACEF, 0xA510, 0xAD72, 0xADD3, 0x8D51, 0x644D, 0x434A, 0x3AE9, 0x3AC9, 
        0x32C9, 0x32C9, 0x32A9, 0x32A9, 0x3289, 0x2AA9, 0x2A88, 0x2A88, 0x2A68, 0x2A48, 0x2227, 0x2227, 0x2227, 0x2A27, 0x2A27, 0x2A07, 0x2A07, 0x2A27, 0x2A27, 0x2A47, 0x2A68, 0x3268, 0x3288, 0x3288, 0x3289, 0x32A9, 0x3288, 0x32A8, 0x3AA8,
  0x7CAE, 0x74CE, 0x750E, 0x85B1, 0x750E, 0x6CCC, 0x858F, 0x7DAF, 0x75AE, 0x8630, 0x7E30, 0x75EF, 0x75D0, 0x8631, 0x9693, 0xA6D4, 0xAEF4, 0xAEF4, 0xA6D3, 0xA713, 0xA713, 0x9ED2, 0x9EF2, 0xA713, 0xA6F3, 0x8E30, 0x6D2D, 0x85CF, 0x9672, 0x9672, 0x9653, 
        0x9653, 0x8DF3, 0x7D92, 0x7552, 0x7553, 0x85B4, 0x8593, 0x8571, 0x74ED, 0x7D0D, 0x7D0D, 0x7D2C, 0x7D0C, 0x7D0C, 0x7D0C, 0x750C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x852C, 0x850C, 0x8D2D, 0x8D6D, 0x956E, 0x956D, 0x954D, 0x8D2E, 0x8D2E, 0x850E, 
        0x84EE, 0x7CCE, 0x74AF, 0x6C8E, 0x648E, 0x64AF, 0x6CF0, 0x6D10, 0x7530, 0x7530, 0x7530, 0x7550, 0x7530, 0x6D2F, 0x6D10, 0x6CEF, 0x64CF, 0x5C8E, 0x5C6E, 0x5C8D, 0x650F, 0x756F, 0x75B0, 0x7E11, 0x8611, 0x8612, 0x85D2, 0x7D72, 0x7511, 0x74F0, 
        0x7CCF, 0x748D, 0x6C2B, 0x6C4B, 0x74AC, 0x8D6E, 0x9E11, 0x9E51, 0x9E71, 0xA692, 0xAEB3, 0xB6D4, 0xAE74, 0x8552, 0x4BAC, 0x2A87, 0x2245, 0x1A45, 0x1A45, 0x2265, 0x2285, 0x2285, 0x22C6, 0x22E6, 0x2306, 0x2306, 0x2346, 0x2B67, 0x3387, 0x33A7, 
        0x3BE8, 0x4408, 0x4408, 0x4C29, 0x5449, 0x5469, 0x5C69, 0x5C6A, 0x648A, 0x648A, 0x648A, 0x648A, 0x5C6A, 0x5C69, 0x5C49, 0x5429, 0x4C09, 0x4BE9, 0x5C09, 0x742B, 0x7C4B, 0x846C, 0x94AD, 0x9CED, 0xA50D, 0xA4ED, 0x9CEC, 0x9CEC, 0x94EC, 0x94EC, 
        0x8CCC, 0x746A, 0x6C2A, 0x5C09, 0x5409, 0x5409, 0x540A, 0x540A, 0x540B, 0x5C2C, 0x646D, 0x6CAF, 0x74AF, 0x74CF, 0x74CF, 0x74EF, 0x7D0F, 0x7D2F, 0x7D2F, 0x750F, 0x750F, 0x750F, 0x752F, 0x752F, 0x750F, 0x750F, 0x750F, 0x750E, 0x74EE, 0x6CAE, 
        0x6C8E, 0x5C4D, 0x53EC, 0x436A, 0x3AE8, 0x2AA7, 0x2A46, 0x1A05, 0x19C5, 0x19A5, 0x1184, 0x1165, 0x1164, 0x1164, 0x1164, 0x1985, 0x1985, 0x19A4, 0x19C5, 0x19E5, 0x2205, 0x1A25, 0x1A45, 0x1A65, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 
        0x1B45, 0x2365, 0x2385, 0x2385, 0x23A5, 0x2385, 0x2385, 0x2385, 0x2386, 0x2B86, 0x2B86, 0x3386, 0x3386, 0x3BA7, 0x3BA7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x3BC7, 0x3BC7, 0x43E7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C28, 0x3C28, 
        0x3C28, 0x3C48, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C29, 0x3C28, 0x3C29, 0x3C29, 0x4409, 0x4409, 0x43E9, 0x3BC9, 0x3BA9, 0x3B68, 0x3348, 0x3328, 0x3308, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E7, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B06, 
        0x2B06, 0x2306, 0x1B05, 0x1B05, 0x1B05, 0x1AE5, 0x1AE4, 0x1AC4, 0x1AA4, 0x1283, 0x1263, 0x1243, 0x1223, 0x11E3, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x1143, 0x0922, 0x0902, 0x0902, 0x08E2, 0x08C2, 0x08C2, 0x08C2, 0x00C2, 0x08C2, 0x08C2, 0x08C2, 
        0x08E3, 0x08E3, 0x1103, 0x1144, 0x1985, 0x19C5, 0x19E5, 0x2205, 0x2225, 0x2245, 0x2245, 0x2265, 0x2A66, 0x2286, 0x2AA6, 0x2AC6, 0x2B06, 0x2B26, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA7, 0x33A7, 0x3B89, 0x438A, 0x436B, 
        0x4B6D, 0x538F, 0x5BD1, 0x63D1, 0x63D1, 0x5BD1, 0x5BD1, 0x6411, 0x6452, 0x6C92, 0x6C92, 0x6C92, 0x6472, 0x6471, 0x6471, 0x6C72, 0x6C72, 0x6C91, 0x6C92, 0x6CB2, 0x6CB2, 0x74D2, 0x74D2, 0x74F2, 0x74F2, 0x7CF3, 0x8513, 0x8533, 0x8532, 0x8532, 
        0x8532, 0x8552, 0x8D73, 0x8D73, 0x8552, 0x8D52, 0x8D93, 0x95B3, 0x95B3, 0x95B3, 0x95B3, 0x9573, 0x8511, 0x7CB1, 0x74B2, 0x74F3, 0x7534, 0x7D94, 0x7DF4, 0x8653, 0x8653, 0x756F, 0x5C6A, 0x5C29, 0x6449, 0x6429, 0x642A, 0x642B, 0x6C4C, 0x6C2D, 
        0x642D, 0x6C8F, 0x7531, 0x7531, 0x7531, 0x74F2, 0x6C93, 0x6C73, 0x6C33, 0x5BAF, 0x3AAA, 0x2A47, 0x2A67, 0x2A86, 0x2A86, 0x2AC6, 0x32E7, 0x3327, 0x3B47, 0x3B67, 0x4388, 0x43A7, 0x4BC8, 0x4BE8, 0x4C09, 0x4C29, 0x5429, 0x5449, 0x5449, 0x5C6A, 
        0x646B, 0x746C, 0x7C4C, 0x744C, 0x746C, 0x7C8C, 0x7CAC, 0x7CAC, 0x7CAC, 0x84AC, 0x8CCC, 0x94ED, 0x9D0D, 0xA52D, 0xB54E, 0xBD6F, 0xC58F, 0xCD8F, 0xCD6F, 0xC54F, 0xB50E, 0xA4EF, 0xAD92, 0xADD4, 0x9572, 0x6C6E, 0x436A, 0x32E8, 0x32C8, 0x32A8, 
        0x2A88, 0x2A88, 0x2A88, 0x2A68, 0x2A48, 0x2248, 0x2247, 0x2227, 0x2227, 0x2207, 0x1A07, 0x2207, 0x2207, 0x2207, 0x2A07, 0x2A07, 0x2A07, 0x2A07, 0x2A27, 0x2A27, 0x2A48, 0x3268, 0x3268, 0x3268, 0x3288, 0x3288, 0x3288, 0x3288, 0x3288,
  0x748E, 0x6C6D, 0x6CAD, 0x7D70, 0x6CED, 0x6CCD, 0x85D0, 0x7DCF, 0x758E, 0x7DEF, 0x8671, 0x7E10, 0x75AF, 0x758F, 0x85F1, 0x9E73, 0xAEF4, 0xB714, 0xAED3, 0xAEF3, 0xAF34, 0xAF54, 0x9EF2, 0x9F13, 0x9EF3, 0x9692, 0x8E51, 0x758E, 0x8E31, 0x9692, 0x8E31, 
        0x8E12, 0x85B1, 0x85D3, 0x7572, 0x7D73, 0x85D4, 0x7D92, 0x7510, 0x74CD, 0x7D0D, 0x7D0D, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x750C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x7D0C, 0x852C, 0x852C, 0x956D, 0x956E, 0x956D, 0x954D, 0x8D2D, 0x8D2D, 0x852E, 
        0x850D, 0x7CEE, 0x74CE, 0x6C8E, 0x6C8E, 0x648F, 0x6CAF, 0x6CD0, 0x6CF0, 0x7510, 0x7531, 0x7570, 0x7550, 0x6D30, 0x6D30, 0x6D0F, 0x6CEF, 0x64AF, 0x5C8E, 0x5C6D, 0x64AE, 0x6D2F, 0x7590, 0x7DF1, 0x8611, 0x7DF1, 0x7DB1, 0x7551, 0x6D10, 0x7531, 
        0x7D10, 0x7CCE, 0x6C6C, 0x6C6C, 0x7CEE, 0x95B0, 0x9E11, 0x9651, 0x9E51, 0xA672, 0xB6B3, 0xB6D4, 0xAE54, 0x7D11, 0x434B, 0x2247, 0x1A05, 0x1A05, 0x1A04, 0x1A25, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC6, 0x1B06, 0x2326, 0x2B46, 0x2B87, 0x33A7, 
        0x33C7, 0x3BE8, 0x4408, 0x4C28, 0x5429, 0x5C49, 0x5C69, 0x5C69, 0x648A, 0x648A, 0x648A, 0x648A, 0x5C6A, 0x5C6A, 0x5C49, 0x5429, 0x4C09, 0x5409, 0x6C4A, 0x8C8C, 0x948D, 0x9CAD, 0xA4CD, 0xA4ED, 0xA50D, 0xA50D, 0x9D0C, 0x9D0C, 0x9CEC, 0x94EC, 
        0x8CCB, 0x6C4A, 0x6409, 0x53E9, 0x540A, 0x540A, 0x5C0A, 0x540B, 0x540B, 0x646D, 0x6CAE, 0x74CF, 0x74EF, 0x74EE, 0x74EF, 0x750F, 0x752F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750E, 0x74EF, 0x74CE, 0x6CAE, 0x6C8E, 0x642D, 
        0x53AB, 0x434A, 0x32C8, 0x2A87, 0x2226, 0x19E6, 0x19A5, 0x19A5, 0x1985, 0x1164, 0x1164, 0x1964, 0x1964, 0x1164, 0x1964, 0x1984, 0x1984, 0x19C5, 0x19E5, 0x1A05, 0x1A25, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 0x1B45, 
        0x1B65, 0x1B85, 0x1B85, 0x2385, 0x23A5, 0x23A5, 0x2385, 0x2385, 0x2385, 0x2B86, 0x2B86, 0x3386, 0x3386, 0x3B86, 0x3B86, 0x3B87, 0x3B87, 0x43A7, 0x43A7, 0x43A6, 0x43A7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3BE7, 0x3C07, 0x3C27, 0x3C07, 0x3C27, 0x3C27, 
        0x3C27, 0x3C27, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x4409, 0x4409, 0x3BE9, 0x3BA9, 0x3B89, 0x3B68, 0x3348, 0x3328, 0x3307, 0x32E8, 0x32E8, 0x32E8, 0x32E7, 0x32E7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE6, 0x2B06, 
        0x2306, 0x2306, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x1B04, 0x12E4, 0x1AC4, 0x12A4, 0x1284, 0x1263, 0x1243, 0x1223, 0x1203, 0x11E3, 0x11A3, 0x1183, 0x1163, 0x1143, 0x1123, 0x0902, 0x0902, 0x08C2, 0x08C2, 0x08C2, 0x08C2, 0x08C2, 0x08E2, 0x08E3, 
        0x08E3, 0x1103, 0x1123, 0x1144, 0x1984, 0x19E5, 0x1A05, 0x2225, 0x2225, 0x2265, 0x2266, 0x2286, 0x22A6, 0x22C6, 0x2AC6, 0x2AE6, 0x2306, 0x2B26, 0x2346, 0x2B66, 0x2B86, 0x2B86, 0x2BA7, 0x2BA6, 0x33A6, 0x33A7, 0x33A7, 0x33A8, 0x3BA8, 0x3B6A, 
        0x436B, 0x4B6D, 0x538F, 0x5BD0, 0x5BD1, 0x5BD1, 0x5BD1, 0x5BD1, 0x6411, 0x6452, 0x6C92, 0x6C92, 0x6472, 0x6471, 0x6471, 0x6491, 0x6C91, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x74D2, 0x74F2, 0x74F2, 0x7CF2, 0x7D12, 0x7D12, 0x7D12, 0x7D12, 
        0x8532, 0x8552, 0x8552, 0x8532, 0x8532, 0x8D73, 0x8D93, 0x9592, 0x9592, 0x95B3, 0x9DB3, 0x8D53, 0x7C91, 0x7C72, 0x74B3, 0x74D4, 0x7534, 0x7594, 0x7DF4, 0x7E53, 0x8653, 0x758E, 0x5C8A, 0x5C49, 0x5C49, 0x644A, 0x644A, 0x6C2B, 0x6C0C, 0x63EC, 
        0x5BCC, 0x5C0D, 0x6CD0, 0x6D31, 0x6D31, 0x6CF2, 0x6C92, 0x6C72, 0x6C31, 0x4B2C, 0x3248, 0x2A47, 0x2A46, 0x2A66, 0x2A66, 0x2AA6, 0x2AC6, 0x3307, 0x3327, 0x3B47, 0x4368, 0x4388, 0x43A8, 0x43E8, 0x4BE8, 0x4C09, 0x4C29, 0x542A, 0x644B, 0x646B, 
        0x6C6C, 0x746C, 0x744C, 0x746C, 0x748C, 0x7CAC, 0x7CAC, 0x84AC, 0x84CC, 0x8CCC, 0x94ED, 0xA50D, 0xAD2D, 0xB54E, 0xBD6E, 0xC58F, 0xCD8F, 0xCD8F, 0xC570, 0xB50F, 0xA4CF, 0xAD71, 0xADF3, 0x9DB2, 0x748E, 0x436A, 0x32E8, 0x2AC7, 0x2AA7, 0x2A87, 
        0x2267, 0x2A67, 0x2247, 0x2227, 0x2227, 0x1A07, 0x19E7, 0x19E7, 0x19C7, 0x19C6, 0x19C6, 0x19E7, 0x21E7, 0x21E7, 0x21E7, 0x2207, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x3248, 0x3268, 0x3248, 0x3268, 0x3268, 0x3268, 0x3288, 0x3288,
  0x748E, 0x6C4D, 0x6C8D, 0x752F, 0x64AD, 0x6CED, 0x7DD0, 0x7DEF, 0x7DEF, 0x7DEF, 0x7E0F, 0x75CF, 0x756F, 0x756F, 0x6CED, 0x9E52, 0xB714, 0xAEF4, 0xAED3, 0xAED4, 0xA6F3, 0xA713, 0x96B1, 0x96D2, 0x96D2, 0x9ED3, 0x96B2, 0x6D4D, 0x6D6D, 0x6D6E, 0x756E, 
        0x758F, 0x8E33, 0x7DB2, 0x7551, 0x7572, 0x7DB3, 0x7DD3, 0x7D71, 0x74CD, 0x74ED, 0x7D0D, 0x7D0C, 0x7D0C, 0x750C, 0x750C, 0x750C, 0x7D0C, 0x7D0C, 0x7D2C, 0x7D2C, 0x7D0C, 0x852C, 0x852C, 0x954D, 0x956D, 0x956D, 0x954D, 0x8D4D, 0x8D4D, 0x852D, 
        0x852D, 0x7D0D, 0x74CD, 0x6CAD, 0x6C8E, 0x6C8E, 0x6C6F, 0x6C8F, 0x6CB0, 0x7510, 0x7551, 0x7D71, 0x7570, 0x6D50, 0x6D30, 0x6D2F, 0x6D0F, 0x64EF, 0x64AE, 0x5C4E, 0x546E, 0x64CE, 0x7570, 0x7DF1, 0x7DF1, 0x7DD1, 0x75B1, 0x6D30, 0x6D11, 0x8572, 
        0x8551, 0x84F0, 0x748E, 0x748D, 0x854F, 0x95F1, 0x9631, 0x9651, 0x9E51, 0xA672, 0xB6B3, 0xBEB4, 0xA614, 0x74B0, 0x430A, 0x19E6, 0x19C5, 0x19E4, 0x11E4, 0x1A04, 0x1A24, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AE6, 0x2306, 0x2347, 0x2B67, 0x3387, 
        0x33A7, 0x3BE7, 0x4408, 0x4C08, 0x5429, 0x5449, 0x5C49, 0x5C69, 0x5C6A, 0x648A, 0x648A, 0x648A, 0x5C8A, 0x5C6A, 0x5C49, 0x5429, 0x5429, 0x5C2A, 0x7C6B, 0x9CAD, 0xA4AD, 0xA4CD, 0xA4CD, 0xA4ED, 0xA50C, 0x9D0C, 0x9D0C, 0x9D0C, 0x9CEC, 0x94CC, 
        0x848B, 0x6C2A, 0x5C0A, 0x53EA, 0x5C2B, 0x646C, 0x646C, 0x644D, 0x646D, 0x6CAE, 0x6CCE, 0x74EF, 0x74EE, 0x74EE, 0x750E, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x750F, 0x7CEF, 0x74EF, 0x74CE, 0x6C8E, 0x644E, 0x5BEC, 0x4B8B, 0x4329, 
        0x32A8, 0x2A67, 0x2206, 0x19C6, 0x19A5, 0x1985, 0x1985, 0x1965, 0x1965, 0x1965, 0x1965, 0x1964, 0x1964, 0x1164, 0x1964, 0x1964, 0x1985, 0x19C5, 0x19E5, 0x1A05, 0x1A25, 0x1A45, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 0x1B45, 0x1B45, 
        0x1B65, 0x1B85, 0x1BA5, 0x1BA5, 0x23A5, 0x23A5, 0x2385, 0x2385, 0x2385, 0x2B86, 0x3386, 0x3386, 0x3386, 0x3386, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x4386, 0x43A7, 0x43A7, 0x43C7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 
        0x3C27, 0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C29, 0x3C29, 0x3C29, 0x4409, 0x4409, 0x3BE9, 0x3BC9, 0x3BA8, 0x3388, 0x3368, 0x3328, 0x3307, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE6, 0x2B06, 
        0x2B06, 0x2326, 0x2326, 0x1B25, 0x1B25, 0x1B44, 0x1324, 0x1304, 0x1B04, 0x12E4, 0x12C4, 0x12A3, 0x1263, 0x1243, 0x1223, 0x11E3, 0x11C3, 0x09A3, 0x1183, 0x1163, 0x0943, 0x0923, 0x1102, 0x08E2, 0x08C2, 0x08C2, 0x08C2, 0x08C2, 0x08E2, 0x08E3, 
        0x0903, 0x1123, 0x1143, 0x1184, 0x11A4, 0x19E4, 0x1A25, 0x1A45, 0x2245, 0x2265, 0x2285, 0x2286, 0x22C6, 0x22C6, 0x22E6, 0x2306, 0x2326, 0x2326, 0x2346, 0x2B66, 0x2B86, 0x2B86, 0x2BA6, 0x2BA6, 0x33A6, 0x33A6, 0x33A7, 0x33A7, 0x3BA8, 0x3B89, 
        0x436A, 0x434C, 0x4B4D, 0x538F, 0x5BD0, 0x5BD1, 0x5BD1, 0x5BB1, 0x5BD0, 0x5C11, 0x6472, 0x6C92, 0x6C92, 0x6C92, 0x6C92, 0x6491, 0x6C91, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CD2, 0x74D1, 0x74F2, 0x7CF2, 0x7D12, 0x7D12, 0x7D12, 0x7D12, 
        0x8532, 0x8532, 0x8512, 0x8532, 0x8D53, 0x8D93, 0x8D93, 0x8D92, 0x95B3, 0x95D3, 0x9DB3, 0x8D12, 0x7C71, 0x7C73, 0x7493, 0x74D4, 0x7534, 0x7594, 0x7E14, 0x7E54, 0x8652, 0x6D4E, 0x5C8A, 0x5C49, 0x5C29, 0x644A, 0x642A, 0x6C2B, 0x6BEC, 0x63CB, 
        0x5BCC, 0x540D, 0x64CF, 0x6D51, 0x6D31, 0x64F1, 0x5C92, 0x6451, 0x5BCF, 0x42CA, 0x2A47, 0x2A46, 0x2A26, 0x2A46, 0x2A66, 0x2A86, 0x2AA6, 0x2AE7, 0x3307, 0x3B47, 0x3B67, 0x3B87, 0x4388, 0x43C8, 0x4BE8, 0x4C09, 0x4C09, 0x5C2A, 0x644C, 0x6C4C, 
        0x744C, 0x7C4C, 0x7C4C, 0x746C, 0x7C8C, 0x7CAC, 0x84AC, 0x84CC, 0x8CCC, 0x94ED, 0x9D0D, 0xA52D, 0xAD4D, 0xBD6E, 0xC58E, 0xCD8F, 0xCDAF, 0xCDAF, 0xC550, 0xA4CE, 0xA510, 0xA5D3, 0x9DD3, 0x74CE, 0x4BAA, 0x32E8, 0x2AC7, 0x2AA7, 0x2287, 0x2267, 
        0x2247, 0x2227, 0x1A26, 0x1A06, 0x19E6, 0x19C6, 0x19C6, 0x19A6, 0x19A6, 0x19C6, 0x19C6, 0x19C6, 0x19C6, 0x21E7, 0x21E7, 0x2207, 0x2A27, 0x2A27, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x3248, 0x3268, 0x3268, 0x3268, 0x3268,
  0x6C4E, 0x6C4D, 0x74CE, 0x752F, 0x6CCE, 0x756F, 0x7D8F, 0x7DF0, 0x7E0F, 0x7DEF, 0x75CF, 0x6D6E, 0x7DB0, 0x7D90, 0x8E11, 0xA6B4, 0xAEF4, 0xAED4, 0xA693, 0xA693, 0xA6D3, 0xA6F3, 0xA6F3, 0x9EF2, 0x9691, 0x8E71, 0x96B2, 0x75AE, 0x758E, 0x7E10, 0x8630, 
        0x8611, 0x85F2, 0x6D30, 0x64CF, 0x6D51, 0x75B3, 0x7E13, 0x8DD3, 0x74EE, 0x7CED, 0x7CED, 0x7CEC, 0x7D0C, 0x750C, 0x750C, 0x7D0C, 0x7D0C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x852C, 0x8D4D, 0x956D, 0x954D, 0x954D, 0x8D4D, 0x8D2D, 0x852D, 
        0x7D2D, 0x750D, 0x74ED, 0x6CAD, 0x6C8D, 0x6C6E, 0x6C6E, 0x646F, 0x6C8F, 0x74F0, 0x7531, 0x7D71, 0x7571, 0x7550, 0x7550, 0x7530, 0x6D30, 0x6D10, 0x64CF, 0x5C6F, 0x544E, 0x5CAE, 0x6D30, 0x7DD1, 0x7DF1, 0x75D1, 0x7590, 0x6510, 0x6D10, 0x7D31, 
        0x8531, 0x7CF0, 0x74AF, 0x7CCF, 0x8D71, 0x9611, 0x9632, 0x9651, 0x9E51, 0xA652, 0xB693, 0xB694, 0x9DB3, 0x6C0E, 0x3A89, 0x19C6, 0x11A5, 0x11A4, 0x19C4, 0x19C4, 0x1A04, 0x1A25, 0x1A45, 0x1A65, 0x1AA6, 0x1AC6, 0x22E6, 0x2327, 0x2B47, 0x3367, 
        0x33A7, 0x3BC7, 0x43E8, 0x4C08, 0x5429, 0x5429, 0x5449, 0x5C69, 0x5C69, 0x5C8A, 0x648A, 0x5C8A, 0x5C8A, 0x5C6A, 0x5449, 0x5429, 0x5C2A, 0x6C4B, 0x848C, 0x9C8C, 0xA4AC, 0xA4AC, 0xA4AC, 0xA4ED, 0xA50D, 0xA4EC, 0x9CEC, 0x9CEC, 0x94CC, 0x8CAB, 
        0x846B, 0x640A, 0x5C0A, 0x5C2B, 0x646C, 0x6CAD, 0x6CAD, 0x6CAE, 0x6CAE, 0x6CAE, 0x6CEE, 0x74EE, 0x74EE, 0x74EE, 0x750E, 0x750F, 0x750F, 0x74EF, 0x74EF, 0x74EF, 0x750F, 0x74EF, 0x74CF, 0x6C8E, 0x642D, 0x53CC, 0x4B6B, 0x3AE9, 0x3288, 0x2A47, 
        0x21E6, 0x19C6, 0x19A5, 0x1985, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1965, 0x1985, 0x19A5, 0x19C5, 0x19E5, 0x2225, 0x2245, 0x2265, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 0x1B45, 0x1B65, 
        0x1B85, 0x1BA5, 0x1BA5, 0x1BA5, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x2BA6, 0x2B86, 0x2B86, 0x3386, 0x3386, 0x3366, 0x3366, 0x3B66, 0x3B66, 0x3B66, 0x4366, 0x4387, 0x43A7, 0x43A7, 0x3BC7, 0x3BC7, 0x43E7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 
        0x3C27, 0x3C47, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C48, 0x3C28, 0x3C29, 0x3C29, 0x3C09, 0x3C09, 0x3C09, 0x3BE9, 0x3BA8, 0x3B88, 0x3368, 0x3348, 0x3327, 0x2B07, 0x2B07, 0x2B07, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B06, 0x2B26, 
        0x2326, 0x2326, 0x2346, 0x1B45, 0x1B45, 0x1B65, 0x1B45, 0x1B44, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x1284, 0x1264, 0x1243, 0x1223, 0x11E3, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x1143, 0x1123, 0x0903, 0x08E2, 0x08E2, 0x08C2, 0x08C2, 0x08E2, 0x08E3, 
        0x0903, 0x1143, 0x1164, 0x1184, 0x11C4, 0x1A04, 0x1A25, 0x2245, 0x2265, 0x2265, 0x2285, 0x22A6, 0x22C6, 0x22E6, 0x22E6, 0x2306, 0x2326, 0x2346, 0x2366, 0x2386, 0x2386, 0x2BA7, 0x2BA7, 0x2BA7, 0x33A6, 0x33A7, 0x3387, 0x33A7, 0x33A7, 0x3B88, 
        0x438A, 0x436C, 0x4B4D, 0x4B4E, 0x536F, 0x5BB0, 0x5BD1, 0x5BD1, 0x5BD0, 0x5BF0, 0x6431, 0x6C72, 0x6C92, 0x6C92, 0x6C92, 0x6471, 0x6C91, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CB2, 0x74D1, 0x74D1, 0x74D2, 0x74F2, 0x7D12, 0x7D12, 0x7D12, 
        0x7D11, 0x7D12, 0x8532, 0x8552, 0x8D73, 0x8D72, 0x8D73, 0x95B3, 0x95D3, 0x95D3, 0x9593, 0x84D2, 0x7C52, 0x7453, 0x7493, 0x74D3, 0x6D34, 0x7594, 0x7E14, 0x7E54, 0x7E32, 0x652D, 0x5C6A, 0x5C49, 0x5C29, 0x5C29, 0x642A, 0x642B, 0x63EB, 0x63CB, 
        0x5BCB, 0x5C6E, 0x6510, 0x6551, 0x6551, 0x5CD1, 0x5C71, 0x5C30, 0x434C, 0x3289, 0x2A27, 0x2A26, 0x2225, 0x2A26, 0x2A46, 0x2A66, 0x2A86, 0x2AC6, 0x32E7, 0x3B27, 0x3B48, 0x3B67, 0x3B88, 0x43A8, 0x43C8, 0x43C9, 0x4BE9, 0x5C2B, 0x6C6D, 0x744D, 
        0x7C4D, 0x7C4D, 0x7C4C, 0x7C8C, 0x7CAC, 0x84AC, 0x84CC, 0x8CCC, 0x94CC, 0x9CED, 0xA50E, 0xAD4D, 0xB54E, 0xBD6E, 0xC58F, 0xCD8F, 0xCDAF, 0xC590, 0xACEE, 0x9CAE, 0xA592, 0x95D3, 0x7D0F, 0x540B, 0x3307, 0x22C6, 0x22A6, 0x2286, 0x1A66, 0x1A46, 
        0x1A26, 0x1A06, 0x1205, 0x11E5, 0x11C5, 0x11C5, 0x1185, 0x19A5, 0x19A6, 0x19A6, 0x19A6, 0x19A6, 0x19C6, 0x21C6, 0x21E7, 0x2207, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x3248, 0x3268,
  0x748E, 0x6C6D, 0x6CCE, 0x752F, 0x7570, 0x7D90, 0x6D4E, 0x75AF, 0x7E0F, 0x7DEF, 0x75EF, 0x6D8E, 0x85F1, 0x7DD0, 0x9653, 0xB736, 0xB735, 0xAEF4, 0xAED4, 0xA693, 0x9E72, 0xA713, 0xA713, 0x9EF2, 0x8E71, 0x8E71, 0x9692, 0x75CF, 0x6DAE, 0x7E30, 0x8651, 
        0x7E31, 0x8611, 0x7DF2, 0x75D2, 0x6D91, 0x6DB2, 0x8634, 0x8E34, 0x74EE, 0x74ED, 0x7CEC, 0x7CEC, 0x7D0C, 0x750C, 0x750C, 0x7D0C, 0x7D0C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x852C, 0x8D4D, 0x956D, 0x8D4D, 0x8D4D, 0x8D4D, 0x8D4D, 0x852D, 
        0x7D2C, 0x74EC, 0x6CEC, 0x6CAC, 0x6C8D, 0x6C6D, 0x6C4E, 0x644E, 0x646E, 0x6C8F, 0x6CCF, 0x7510, 0x7530, 0x7530, 0x7530, 0x7530, 0x7530, 0x7530, 0x6CF0, 0x64AF, 0x5C6E, 0x5C8E, 0x64EF, 0x7590, 0x75B1, 0x75B0, 0x6D50, 0x64F0, 0x6D10, 0x7531, 
        0x8531, 0x7D11, 0x7CAF, 0x84F0, 0x95B1, 0x9E32, 0x9652, 0x9652, 0x9E52, 0xA652, 0xAE73, 0xAE33, 0x9551, 0x5BAD, 0x3248, 0x19A6, 0x11A5, 0x19A4, 0x19A4, 0x19C4, 0x19E4, 0x1A05, 0x1A25, 0x1A65, 0x1A86, 0x22A6, 0x22E6, 0x2B07, 0x2B47, 0x2B67, 
        0x3387, 0x3BC7, 0x3BC8, 0x4BE8, 0x4C08, 0x5429, 0x5429, 0x5C49, 0x5C69, 0x5C69, 0x5C69, 0x5C89, 0x5C8A, 0x5C6A, 0x5449, 0x5429, 0x642A, 0x7C4B, 0x946C, 0x9C8C, 0xA48C, 0xA48C, 0xA4AC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x94AC, 0x8C8C, 
        0x7C2B, 0x640B, 0x642B, 0x646C, 0x64AD, 0x6CAE, 0x6CAE, 0x6CAE, 0x6CAE, 0x6CCE, 0x6CCE, 0x74EE, 0x750F, 0x750F, 0x750E, 0x750F, 0x74EF, 0x74EF, 0x74EF, 0x74EF, 0x74CF, 0x6C8E, 0x642D, 0x53AB, 0x4B4A, 0x3AC9, 0x3288, 0x2A27, 0x2207, 0x21C6, 
        0x19A6, 0x1185, 0x1185, 0x1985, 0x1965, 0x1965, 0x1965, 0x1985, 0x1965, 0x1965, 0x1985, 0x2185, 0x2185, 0x1985, 0x1985, 0x19A5, 0x21C5, 0x21E5, 0x2205, 0x2225, 0x2245, 0x2265, 0x1A85, 0x1AA5, 0x1AE5, 0x1B05, 0x1B25, 0x1B45, 0x1B65, 0x1B85, 
        0x1B85, 0x1BA5, 0x1BA5, 0x1BA5, 0x23A5, 0x1BA5, 0x23A6, 0x23A6, 0x2B86, 0x2B86, 0x2B66, 0x3366, 0x3366, 0x3366, 0x3346, 0x3346, 0x3B46, 0x3B46, 0x3B67, 0x4387, 0x43A7, 0x43A7, 0x3BA7, 0x3BC7, 0x3BE7, 0x3BE7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 
        0x3C27, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C29, 0x3C29, 0x3C29, 0x3C09, 0x3C09, 0x3BE9, 0x3BA8, 0x3B88, 0x3368, 0x3348, 0x3327, 0x3307, 0x32E7, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B26, 
        0x2326, 0x2346, 0x2366, 0x2365, 0x1B65, 0x1B65, 0x1B65, 0x1B65, 0x1B44, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x1284, 0x1263, 0x1243, 0x1223, 0x09E3, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x0943, 0x0923, 0x0903, 0x0902, 0x08E2, 0x08E2, 0x08E2, 0x08E3, 
        0x1103, 0x1144, 0x1164, 0x19A4, 0x11E4, 0x1204, 0x1A45, 0x1A45, 0x2265, 0x2285, 0x22A5, 0x22C6, 0x22E6, 0x22E5, 0x2306, 0x2326, 0x2346, 0x2346, 0x2366, 0x2386, 0x2386, 0x2BA7, 0x2BA7, 0x2BA7, 0x33A6, 0x33A7, 0x3387, 0x3387, 0x33A7, 0x3B88, 
        0x3B69, 0x434B, 0x434C, 0x432D, 0x4B6E, 0x5BB0, 0x5BD0, 0x5BD0, 0x5BD1, 0x5BD0, 0x5BF1, 0x6411, 0x6431, 0x6451, 0x6C92, 0x6C92, 0x6CB2, 0x64B1, 0x6CB1, 0x6CB2, 0x6CB2, 0x6CB2, 0x6CD2, 0x74D2, 0x74D1, 0x74D2, 0x74F2, 0x7CF1, 0x7D12, 0x7CF1, 
        0x7D11, 0x8532, 0x8552, 0x8D73, 0x8552, 0x8D72, 0x95B3, 0x95D3, 0x9DD3, 0x95D3, 0x8D53, 0x7C71, 0x7432, 0x7433, 0x7474, 0x6CB4, 0x7514, 0x7594, 0x7DF4, 0x7E53, 0x7E12, 0x650D, 0x5C6A, 0x5C49, 0x5C29, 0x5C29, 0x5C0A, 0x640A, 0x5BCA, 0x5BCB, 
        0x5C0C, 0x64CF, 0x6D51, 0x6571, 0x5D30, 0x5CB0, 0x5C70, 0x4BCE, 0x32CA, 0x2A48, 0x2A27, 0x2226, 0x2205, 0x2205, 0x2225, 0x2246, 0x2A66, 0x2A86, 0x2AC6, 0x32E7, 0x3B27, 0x3B47, 0x3B68, 0x3B88, 0x43A8, 0x4BC9, 0x53EA, 0x6C6C, 0x848E, 0x846D, 
        0x844D, 0x7C6D, 0x7C6C, 0x7C8C, 0x7CAC, 0x84AC, 0x8CCC, 0x8CCC, 0x94CC, 0x9CED, 0xAD2D, 0xB54E, 0xBD6E, 0xC58F, 0xCD8F, 0xCD90, 0xC590, 0xB52F, 0x9CAE, 0x9D51, 0x9DD2, 0x7D70, 0x5C6C, 0x3B68, 0x2B07, 0x22C6, 0x1AA6, 0x1A86, 0x1A66, 0x1246, 
        0x1226, 0x1205, 0x11E5, 0x11C5, 0x11C5, 0x11A5, 0x1185, 0x1985, 0x19A5, 0x19A6, 0x19A6, 0x19A6, 0x19C6, 0x21C6, 0x21E7, 0x2207, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A47, 0x2A47,
  0x748E, 0x6CAD, 0x6CCD, 0x6D2E, 0x756F, 0x6D2E, 0x6D2D, 0x7DF0, 0x7DEF, 0x75CF, 0x6D8E, 0x6D8E, 0x7DAF, 0x85F0, 0x8E52, 0xAF35, 0xBF77, 0xB756, 0xAEF5, 0x9652, 0x85CF, 0x9E92, 0x9EF3, 0x9ED2, 0x96D2, 0x96B2, 0x8E71, 0x7E10, 0x6D8E, 0x7610, 0x7E50, 
        0x7E50, 0x7E51, 0x7E52, 0x7612, 0x6DB1, 0x6DB1, 0x7E34, 0x8633, 0x74EE, 0x74ED, 0x74EC, 0x7CEC, 0x750C, 0x750C, 0x750C, 0x750C, 0x7D0C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x852C, 0x8D4D, 0x8D4D, 0x8D2D, 0x8D2D, 0x8D4D, 0x852D, 0x7D2D, 
        0x750C, 0x6CEC, 0x6CCC, 0x64AC, 0x64AC, 0x6C8D, 0x648D, 0x646D, 0x646E, 0x646E, 0x646E, 0x648F, 0x6CAF, 0x6CAF, 0x6CB0, 0x6CF0, 0x7511, 0x7511, 0x6CF0, 0x64B0, 0x5C8F, 0x544E, 0x5C8F, 0x6D30, 0x7571, 0x7571, 0x6D10, 0x6CF0, 0x7531, 0x7D52, 
        0x8552, 0x7D11, 0x7CF0, 0x8551, 0x95D2, 0x9E32, 0x9E52, 0x9E32, 0x9E32, 0xA633, 0xB653, 0xADF3, 0x84D1, 0x4B2B, 0x2A08, 0x21A6, 0x1985, 0x1984, 0x19A4, 0x19A4, 0x19C4, 0x1A05, 0x1A25, 0x1A25, 0x1A66, 0x2286, 0x22C6, 0x22E6, 0x2B27, 0x3347, 
        0x3367, 0x3B87, 0x43C7, 0x43E8, 0x43E8, 0x4C08, 0x4C29, 0x5429, 0x5449, 0x5469, 0x5C69, 0x5C69, 0x5C6A, 0x5C6A, 0x544A, 0x5C4A, 0x6C4A, 0x8C6C, 0x946C, 0x9C8C, 0x9C8C, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x948C, 0x8C6C, 0x8C6C, 0x844C, 0x7C2C, 
        0x742C, 0x642C, 0x644D, 0x6C8D, 0x6CAE, 0x6CAE, 0x6CAE, 0x6CCE, 0x6CCE, 0x6CCE, 0x6CCE, 0x74EF, 0x750F, 0x750F, 0x74EF, 0x74EF, 0x74EF, 0x74CF, 0x6CAF, 0x6C8E, 0x644D, 0x53EC, 0x4B6A, 0x4309, 0x32A8, 0x2A67, 0x2A27, 0x21E6, 0x21C6, 0x21A6, 
        0x1986, 0x1985, 0x1985, 0x1985, 0x1985, 0x1985, 0x1985, 0x19A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21C5, 0x21C5, 0x21E5, 0x21E5, 0x2205, 0x2205, 0x2245, 0x2266, 0x2266, 0x2285, 0x22A5, 0x22E5, 0x1B05, 0x1B25, 0x1B45, 0x1B65, 0x1B65, 
        0x1B85, 0x1BA5, 0x1BA5, 0x1BA5, 0x23A6, 0x1BA5, 0x23A6, 0x2386, 0x2386, 0x2B66, 0x2B66, 0x3366, 0x3346, 0x3346, 0x3326, 0x3326, 0x3326, 0x3B27, 0x3B67, 0x4387, 0x4387, 0x43A7, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3BE7, 0x3BE7, 0x3C07, 0x3C07, 
        0x3C27, 0x4428, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C08, 0x3C08, 0x3C09, 0x3BE8, 0x3BA8, 0x3B88, 0x3368, 0x3348, 0x3328, 0x3307, 0x32E7, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B07, 0x2B26, 
        0x2B26, 0x2346, 0x2366, 0x2385, 0x2385, 0x1B85, 0x1B65, 0x1B65, 0x1B65, 0x1B44, 0x1B24, 0x1304, 0x12E4, 0x12C4, 0x12A4, 0x1263, 0x1243, 0x1203, 0x11E3, 0x11C3, 0x11A3, 0x1183, 0x1163, 0x0943, 0x0923, 0x0903, 0x08E3, 0x08E2, 0x08E2, 0x0903, 
        0x1123, 0x1164, 0x1984, 0x19C4, 0x1204, 0x1224, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x22C6, 0x22E6, 0x2306, 0x2326, 0x2326, 0x2346, 0x2366, 0x2366, 0x2386, 0x2386, 0x2B86, 0x2B87, 0x2B87, 0x2B87, 0x3387, 0x3387, 0x3387, 0x3387, 0x3388, 
        0x3388, 0x3B2A, 0x3B0B, 0x3B0C, 0x4B6E, 0x53AF, 0x5BD0, 0x5BF0, 0x5BF0, 0x63F1, 0x5BD1, 0x5BD1, 0x6411, 0x6452, 0x6C93, 0x74D3, 0x74F2, 0x6CD1, 0x6CD1, 0x6CB1, 0x6CB1, 0x6CB1, 0x74D1, 0x74D1, 0x74F1, 0x74F2, 0x74F2, 0x7CF2, 0x74F1, 0x7D11, 
        0x8552, 0x8573, 0x8D73, 0x8572, 0x8D72, 0x9593, 0x95B3, 0x9DD3, 0x9DD3, 0x9593, 0x84D2, 0x7411, 0x7412, 0x7433, 0x6C53, 0x6CB3, 0x7514, 0x7574, 0x7DF3, 0x8633, 0x8612, 0x6D2E, 0x5C6A, 0x5C49, 0x5C29, 0x5C29, 0x5C09, 0x5BEA, 0x53CA, 0x53EB, 
        0x5C6D, 0x6D0F, 0x6D51, 0x6550, 0x5CF0, 0x5C90, 0x540F, 0x3B2B, 0x2A68, 0x2A47, 0x2A27, 0x2A06, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 0x2286, 0x2AA6, 0x2AC7, 0x3307, 0x3347, 0x3B68, 0x3B88, 0x4388, 0x4BA9, 0x640B, 0x7C8D, 0x8C8E, 0x848E, 
        0x7C6D, 0x7C8C, 0x7C8C, 0x7CAC, 0x84CC, 0x84CC, 0x8CCC, 0x8CCC, 0x94EC, 0xA50D, 0xAD2E, 0xBD6E, 0xC56F, 0xC58F, 0xCD90, 0xC550, 0xB4EE, 0x946D, 0x9510, 0xA5B2, 0x9571, 0x6CCE, 0x43E9, 0x2B47, 0x2B26, 0x22E6, 0x1AC5, 0x1A86, 0x1A65, 0x1245, 
        0x1225, 0x1205, 0x11E5, 0x11E5, 0x11C5, 0x11A5, 0x11A5, 0x1185, 0x1185, 0x19A6, 0x19A6, 0x19A6, 0x19A6, 0x19C6, 0x21E7, 0x21E7, 0x2207, 0x2A27, 0x2A27, 0x2A27, 0x2A48, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x6CAD, 0x6CCD, 0x6CCD, 0x6D2E, 0x756F, 0x6D4E, 0x6D4E, 0x7DF0, 0x7E0F, 0x75CF, 0x654D, 0x656E, 0x6D6E, 0x8610, 0x8E51, 0xA6D4, 0xB776, 0xBF77, 0xAEF5, 0xA6D4, 0x9EB2, 0x9EB2, 0x9ED3, 0x96D2, 0x96B1, 0x8E91, 0x7E10, 0x8671, 0x656D, 0x6DCE, 0x7650, 
        0x7650, 0x7630, 0x6E10, 0x6E11, 0x65D1, 0x65D1, 0x7E53, 0x7E13, 0x6CEE, 0x7CED, 0x750C, 0x74EC, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D0C, 0x7D0C, 0x7D0C, 0x852D, 0x8D4D, 0x8D2D, 0x8D2D, 0x852D, 0x852D, 0x7D2D, 
        0x750C, 0x6CEC, 0x64CC, 0x64CC, 0x64AC, 0x64AC, 0x64AD, 0x648D, 0x648D, 0x5C4D, 0x5C4D, 0x644E, 0x6C6F, 0x6C4F, 0x644F, 0x6CB0, 0x6CD0, 0x74F0, 0x6CD0, 0x6CB0, 0x648F, 0x5C4F, 0x5C6F, 0x64AF, 0x6D11, 0x6D11, 0x6CF0, 0x6D11, 0x7D52, 0x7D52, 
        0x7D52, 0x7D11, 0x7D31, 0x8D92, 0x9612, 0x9652, 0x9E52, 0x9E32, 0xA632, 0xAE33, 0xB634, 0xA5B3, 0x7C70, 0x42EB, 0x21E7, 0x21A6, 0x1985, 0x1984, 0x19A4, 0x19A4, 0x19A4, 0x19E5, 0x1A05, 0x1A05, 0x1A45, 0x2286, 0x22A6, 0x22E6, 0x2B07, 0x2B27, 
        0x3347, 0x3367, 0x3BA7, 0x43C8, 0x43E8, 0x43E8, 0x4C08, 0x4C28, 0x4C48, 0x4C49, 0x5449, 0x5469, 0x5469, 0x544A, 0x5449, 0x5C4A, 0x744B, 0x946C, 0x9C6D, 0x9C8D, 0x9CAD, 0x9CAC, 0x9CAC, 0x94AC, 0x8C6C, 0x842B, 0x7C2B, 0x7C2B, 0x742B, 0x742C, 
        0x6C2C, 0x642D, 0x646D, 0x6C8D, 0x6CAE, 0x6CCE, 0x6CCE, 0x6CCE, 0x6CCE, 0x6CCE, 0x74EF, 0x750F, 0x750F, 0x74EF, 0x74EF, 0x74CF, 0x748E, 0x646E, 0x642D, 0x53CB, 0x4B6A, 0x3B29, 0x3AE8, 0x32C8, 0x3288, 0x2A47, 0x2A06, 0x29E6, 0x21E6, 0x21A6, 
        0x19A5, 0x19A5, 0x1985, 0x1985, 0x1985, 0x19A5, 0x21A5, 0x21C5, 0x21C5, 0x21C5, 0x21C5, 0x21E6, 0x21E6, 0x2206, 0x2205, 0x2205, 0x2225, 0x2225, 0x2245, 0x2266, 0x2266, 0x2286, 0x22A5, 0x22C5, 0x22E5, 0x1B05, 0x2325, 0x1B45, 0x1B65, 0x2386, 
        0x23A6, 0x1BA5, 0x1BA6, 0x1BA6, 0x1BA5, 0x23A5, 0x2386, 0x2386, 0x2386, 0x2365, 0x2B45, 0x2B46, 0x3326, 0x3326, 0x3326, 0x3306, 0x3306, 0x3B06, 0x3B47, 0x3B67, 0x3B67, 0x4387, 0x43A7, 0x3BA7, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 
        0x3C08, 0x4428, 0x4448, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3BE8, 0x33C8, 0x33A8, 0x3388, 0x3368, 0x3348, 0x3328, 0x3307, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B06, 0x2B27, 
        0x2B26, 0x2346, 0x2366, 0x2386, 0x2385, 0x23A5, 0x1B85, 0x1B65, 0x1B65, 0x1B64, 0x1344, 0x1B24, 0x1B04, 0x12E4, 0x12C4, 0x1283, 0x1263, 0x1244, 0x1203, 0x11E3, 0x11C3, 0x1183, 0x0983, 0x0963, 0x0943, 0x0923, 0x0903, 0x0903, 0x0903, 0x1123, 
        0x1143, 0x1164, 0x11A4, 0x11E4, 0x1224, 0x1244, 0x1A64, 0x1A85, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE5, 0x1B05, 0x2325, 0x2326, 0x1B46, 0x1B46, 0x2366, 0x2366, 0x2386, 0x2386, 0x2386, 0x2386, 0x2B86, 0x2B86, 0x2B67, 0x2B67, 0x2B67, 0x3387, 0x3388, 
        0x3388, 0x3B2A, 0x3B2B, 0x3B0B, 0x432D, 0x4B6E, 0x53AF, 0x5BF0, 0x5BF0, 0x63F0, 0x5BD1, 0x5BD1, 0x5BD1, 0x5C11, 0x6C72, 0x74D3, 0x7513, 0x7532, 0x6CF1, 0x6CD1, 0x6CB1, 0x6CD1, 0x74D1, 0x74D1, 0x74F1, 0x74F1, 0x74D1, 0x74F1, 0x7D12, 0x8532, 
        0x8572, 0x8572, 0x8D73, 0x8D73, 0x8DB3, 0x95B3, 0x95D3, 0x95D3, 0x95B3, 0x8D52, 0x7451, 0x6BD0, 0x6BD2, 0x6BF2, 0x6C33, 0x6C73, 0x6CF4, 0x7574, 0x75D3, 0x7E12, 0x7DB1, 0x6CCD, 0x5C4A, 0x5C29, 0x5C08, 0x5C08, 0x53E9, 0x53C9, 0x4BCA, 0x5C2C, 
        0x64AE, 0x6D30, 0x6550, 0x5D30, 0x54D0, 0x546F, 0x43AD, 0x32CA, 0x2A48, 0x2A47, 0x2A26, 0x2206, 0x21E6, 0x19E6, 0x1A06, 0x2226, 0x2246, 0x2266, 0x2AA7, 0x2AC7, 0x3307, 0x3327, 0x3347, 0x3B67, 0x4388, 0x53A9, 0x742C, 0x848D, 0x8C6D, 0x848D, 
        0x7C8D, 0x7CAC, 0x7CCD, 0x84CC, 0x84CC, 0x8CCC, 0x8CCC, 0x8CCC, 0x94EC, 0xA50D, 0xAD4E, 0xC58F, 0xCD8F, 0xCD8F, 0xCD90, 0xACEE, 0x9C8D, 0x9CEF, 0x9D71, 0x9591, 0x74CD, 0x540A, 0x3BA8, 0x2B67, 0x2326, 0x1B06, 0x1AE6, 0x1AA6, 0x1A85, 0x1265, 
        0x1245, 0x1225, 0x1205, 0x11E5, 0x11C6, 0x11C5, 0x11A5, 0x11A5, 0x11A5, 0x19A6, 0x19A6, 0x19A6, 0x19C6, 0x19E7, 0x21E7, 0x2207, 0x2A28, 0x2A27, 0x2A27, 0x2A27, 0x2A48, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x6CAD, 0x648C, 0x64CC, 0x6D4E, 0x7DD0, 0x758E, 0x75AF, 0x7E10, 0x7E10, 0x75CF, 0x6D8E, 0x656D, 0x650D, 0x7DF0, 0x8E72, 0x9693, 0xA6F5, 0xAF15, 0xA6F5, 0xA6D4, 0x9EB2, 0x9691, 0x96B1, 0x8E91, 0x8670, 0x8670, 0x7E50, 0x75EF, 0x5D4D, 0x4CEB, 0x65EE, 
        0x6E4F, 0x6E30, 0x660F, 0x6610, 0x65F0, 0x558F, 0x65B1, 0x7E12, 0x6CCD, 0x7CED, 0x750C, 0x74EC, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x7D2C, 0x7D2C, 0x750C, 0x750C, 0x7D0C, 0x7D0C, 0x852D, 0x8D4D, 0x8D4D, 0x8D4D, 0x852D, 0x852D, 0x750C, 
        0x6D0C, 0x6CEC, 0x64CB, 0x64CB, 0x64CB, 0x64CC, 0x64AC, 0x64AC, 0x5C8C, 0x5C6C, 0x5C4C, 0x644E, 0x642E, 0x640E, 0x640E, 0x642F, 0x644F, 0x644F, 0x644F, 0x644F, 0x644F, 0x6470, 0x6470, 0x648F, 0x6CB0, 0x6CD0, 0x6CD0, 0x6CF1, 0x7532, 0x7D32, 
        0x7D31, 0x7D31, 0x8572, 0x8DD2, 0x9633, 0x9632, 0x9632, 0x9E32, 0xA633, 0xB654, 0xBE35, 0xA593, 0x7450, 0x3ACA, 0x21C7, 0x1985, 0x1985, 0x1984, 0x1984, 0x19A4, 0x19A4, 0x19C5, 0x21E5, 0x19E5, 0x1A25, 0x2266, 0x2286, 0x2AA7, 0x2AE7, 0x2B07, 
        0x3347, 0x3367, 0x3B67, 0x3BA8, 0x43C8, 0x43E8, 0x43E8, 0x4408, 0x4C28, 0x4C28, 0x4C48, 0x4C49, 0x4C49, 0x4C49, 0x4C29, 0x5C2A, 0x744B, 0x944C, 0x9C6D, 0x9C8D, 0x9C8D, 0x9CAD, 0x94AC, 0x948C, 0x844C, 0x742B, 0x744C, 0x744C, 0x742C, 0x6C2D, 
        0x6C2D, 0x642D, 0x646E, 0x64AE, 0x6CAE, 0x6CCE, 0x6CCE, 0x6CCE, 0x6CCE, 0x74EF, 0x74EF, 0x7CEF, 0x74CF, 0x74CF, 0x6C8E, 0x6C4D, 0x5C0C, 0x53AB, 0x4B4A, 0x4329, 0x3B08, 0x32E8, 0x32C7, 0x32A7, 0x3287, 0x2A67, 0x2A26, 0x2A06, 0x2A06, 0x21C6, 
        0x21C6, 0x21C5, 0x19C5, 0x19A5, 0x19C5, 0x19E5, 0x19E5, 0x2206, 0x2206, 0x2206, 0x2226, 0x2226, 0x2226, 0x2226, 0x2246, 0x2246, 0x2246, 0x2266, 0x2266, 0x2286, 0x2286, 0x22A6, 0x22C6, 0x22E6, 0x22E5, 0x2305, 0x2325, 0x1B46, 0x1B66, 0x2386, 
        0x2386, 0x1BA6, 0x1BA6, 0x1BA5, 0x1B85, 0x2385, 0x2386, 0x2386, 0x2366, 0x2345, 0x2B45, 0x2B46, 0x2B26, 0x3326, 0x3306, 0x3306, 0x3306, 0x3306, 0x3B47, 0x3B47, 0x3B67, 0x3B87, 0x3B87, 0x3B87, 0x3BA7, 0x3BA7, 0x3BA7, 0x3BC7, 0x3BE7, 0x4408, 
        0x4408, 0x4428, 0x4428, 0x4448, 0x4448, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3428, 0x3428, 0x3C08, 0x3BE8, 0x3BC8, 0x33A8, 0x33A8, 0x3388, 0x3368, 0x3348, 0x3328, 0x2B07, 0x2AE7, 0x2AE7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 
        0x2B26, 0x2346, 0x2366, 0x2386, 0x2385, 0x23A5, 0x1BA5, 0x1B85, 0x1B85, 0x1B85, 0x1B64, 0x1B44, 0x1B24, 0x1B04, 0x12E4, 0x12A4, 0x1284, 0x1264, 0x1224, 0x0A03, 0x11E3, 0x11C3, 0x0983, 0x0983, 0x1163, 0x0943, 0x0923, 0x0923, 0x0923, 0x1143, 
        0x1163, 0x1184, 0x11C4, 0x1204, 0x1244, 0x1264, 0x1A84, 0x1AA5, 0x1AA5, 0x1AE5, 0x1AE5, 0x1B05, 0x1B05, 0x1B45, 0x1B45, 0x1B46, 0x1B66, 0x1B66, 0x1B66, 0x1B66, 0x2366, 0x2366, 0x2366, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B67, 0x3367, 0x3368, 
        0x3368, 0x3349, 0x3329, 0x3B2A, 0x3B0B, 0x430C, 0x4B6D, 0x5BCF, 0x5BF0, 0x5BF0, 0x5BF0, 0x5BF1, 0x5BF1, 0x5BF1, 0x6451, 0x6CB2, 0x74F3, 0x7D33, 0x7D32, 0x7511, 0x6CD1, 0x6CB1, 0x74D1, 0x74D1, 0x6CB1, 0x6CB1, 0x6CD1, 0x7D12, 0x8532, 0x8552, 
        0x8552, 0x8572, 0x8D93, 0x8D93, 0x95B3, 0x95B3, 0x95B3, 0x95B3, 0x9593, 0x7CD1, 0x63CF, 0x6BB0, 0x6BB1, 0x7413, 0x6C53, 0x6C73, 0x6CF4, 0x7574, 0x7DF4, 0x8633, 0x7DB1, 0x64CC, 0x5C4A, 0x5409, 0x5C09, 0x5C08, 0x53E9, 0x53EA, 0x540B, 0x6CAE, 
        0x6D10, 0x6D51, 0x6530, 0x5CEF, 0x54AF, 0x4BEE, 0x330B, 0x2A89, 0x2A48, 0x2A27, 0x2A06, 0x2206, 0x21E6, 0x2206, 0x2206, 0x2226, 0x2246, 0x2266, 0x2286, 0x2AA7, 0x2AE7, 0x3307, 0x3327, 0x3B48, 0x4368, 0x5BAA, 0x7C4C, 0x8C6D, 0x8C8D, 0x848D, 
        0x7C8C, 0x7CCC, 0x84CC, 0x84CC, 0x8CCC, 0x8CCC, 0x8CCC, 0x94ED, 0xA50D, 0xAD2D, 0xB54E, 0xC58F, 0xCD8F, 0xCD90, 0xBD2F, 0xA4CF, 0xA551, 0xA5B2, 0x9591, 0x74EE, 0x542A, 0x3BC8, 0x33A7, 0x2B86, 0x2366, 0x2346, 0x1B06, 0x1AE6, 0x1AA6, 0x1A85, 
        0x1A65, 0x1245, 0x1A05, 0x1A05, 0x19E6, 0x19C6, 0x19C5, 0x19A6, 0x19A6, 0x19A6, 0x19A6, 0x19C6, 0x19C6, 0x19E7, 0x21E7, 0x2207, 0x2A28, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x648D, 0x5C6C, 0x64CC, 0x6D4E, 0x75CF, 0x652D, 0x75AE, 0x7DF0, 0x7E10, 0x75EF, 0x658E, 0x654D, 0x656E, 0x7E10, 0x8E72, 0x8E52, 0x9693, 0x9ED4, 0x9EB3, 0x9693, 0x9671, 0x8E71, 0x8E71, 0x8690, 0x7E2F, 0x7E2F, 0x760F, 0x75CF, 0x656D, 0x5D6D, 0x65EE, 
        0x660F, 0x662F, 0x660F, 0x5DEF, 0x5DF0, 0x6611, 0x7653, 0x6D90, 0x648C, 0x7CED, 0x750C, 0x750D, 0x750C, 0x750C, 0x750C, 0x7D2C, 0x7D2C, 0x7D2C, 0x7D2C, 0x750C, 0x750C, 0x7D0C, 0x7D0C, 0x852D, 0x854D, 0x8D4D, 0x852D, 0x852D, 0x7D0C, 0x750C, 
        0x6D0C, 0x64EC, 0x64CB, 0x64CB, 0x64CB, 0x64CC, 0x64CC, 0x5CAC, 0x548B, 0x546B, 0x544C, 0x642D, 0x640E, 0x63EE, 0x63CE, 0x5BCE, 0x5BAD, 0x53AD, 0x5BCE, 0x5C0E, 0x642F, 0x6470, 0x6C90, 0x6C70, 0x6C70, 0x6C90, 0x6CB1, 0x6CF1, 0x74F1, 0x7511, 
        0x7511, 0x7D31, 0x8592, 0x8DD2, 0x9613, 0x9632, 0x9632, 0x9612, 0xA633, 0xBE54, 0xBE55, 0xA594, 0x7470, 0x42EA, 0x21C6, 0x1985, 0x1984, 0x1984, 0x1984, 0x1984, 0x19A4, 0x21C4, 0x21C5, 0x21C5, 0x21E5, 0x2226, 0x2266, 0x2A87, 0x2AC7, 0x2AE7, 
        0x2B27, 0x3347, 0x3367, 0x3B88, 0x3BA8, 0x3BC8, 0x3BE8, 0x43E8, 0x4408, 0x4428, 0x4C28, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x5C2A, 0x7C4C, 0x944C, 0x946D, 0x944C, 0x8C2B, 0x8C2B, 0x8C2B, 0x844B, 0x7C2B, 0x744C, 0x6C4D, 0x6C6D, 0x6C4D, 0x6C4D, 
        0x646D, 0x646E, 0x6CAE, 0x6CCE, 0x6CCF, 0x74CF, 0x74EF, 0x74CF, 0x74CF, 0x74CF, 0x74AF, 0x74AF, 0x6C6E, 0x642D, 0x53CB, 0x538A, 0x4B6A, 0x4329, 0x3B09, 0x3AE8, 0x32C7, 0x32C7, 0x2AA7, 0x32A7, 0x3287, 0x3287, 0x2A67, 0x2A46, 0x2A26, 0x2206, 
        0x2206, 0x2206, 0x2206, 0x1A06, 0x19E6, 0x1A06, 0x1A06, 0x2226, 0x2246, 0x2246, 0x2246, 0x2266, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x2305, 0x2305, 0x2345, 0x1B46, 0x1B66, 0x1B86, 
        0x1B86, 0x1BA6, 0x1BA5, 0x1B85, 0x1B85, 0x1B85, 0x2365, 0x2365, 0x2345, 0x2345, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2B06, 0x32E6, 0x32E6, 0x32E6, 0x3B27, 0x3B47, 0x3B47, 0x3B67, 0x3B67, 0x3B87, 0x3B87, 0x3BA7, 0x3BA7, 0x3BA7, 0x3BC7, 0x3C07, 
        0x4408, 0x4428, 0x4428, 0x4448, 0x4448, 0x3C48, 0x3C48, 0x3C48, 0x3C48, 0x3428, 0x3408, 0x3408, 0x3BE8, 0x33C8, 0x33A8, 0x33A8, 0x3388, 0x3368, 0x3348, 0x3308, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 
        0x2B26, 0x2346, 0x2366, 0x2386, 0x2385, 0x23A5, 0x23A5, 0x1BA5, 0x1BA5, 0x1B85, 0x1B85, 0x1B44, 0x1B44, 0x1B24, 0x1304, 0x12C4, 0x12A4, 0x1284, 0x1244, 0x1224, 0x1204, 0x11C3, 0x11C3, 0x0983, 0x0963, 0x0963, 0x0943, 0x0943, 0x1143, 0x1163, 
        0x1184, 0x11A4, 0x11E4, 0x1224, 0x1244, 0x1264, 0x1A84, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B05, 0x1B25, 0x1B45, 0x1B45, 0x1B45, 0x1B46, 0x1B46, 0x1B46, 0x1B46, 0x1B46, 0x2346, 0x2346, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B67, 0x3367, 0x3368, 
        0x3388, 0x3348, 0x3349, 0x3329, 0x3B0A, 0x3AEA, 0x3AEB, 0x4B4D, 0x53AF, 0x5BCF, 0x5BD0, 0x5BF1, 0x63F1, 0x5BF0, 0x6411, 0x6451, 0x6CB2, 0x7512, 0x7D33, 0x7D32, 0x7512, 0x74D1, 0x6CD1, 0x6CB1, 0x6C90, 0x6CB1, 0x7CF2, 0x8532, 0x8552, 0x8532, 
        0x8552, 0x8D93, 0x8DB3, 0x8DB3, 0x95B3, 0x8DB3, 0x8D93, 0x8D93, 0x8D52, 0x7CD1, 0x7451, 0x7411, 0x7413, 0x7C74, 0x7474, 0x6CB3, 0x7514, 0x7D94, 0x7DF4, 0x8633, 0x75B0, 0x5C8B, 0x5429, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5C2B, 0x6CCE, 0x7530, 
        0x7551, 0x6D51, 0x5D10, 0x54CF, 0x4C4E, 0x3B4B, 0x2AC9, 0x2A89, 0x2A48, 0x2A27, 0x2206, 0x2206, 0x21E6, 0x1A06, 0x1A06, 0x1A06, 0x2226, 0x2246, 0x2266, 0x2286, 0x2AA7, 0x2AE7, 0x3307, 0x3B28, 0x4368, 0x5B8A, 0x842C, 0x8C6D, 0x848D, 0x848D, 
        0x7CAC, 0x84CD, 0x84CC, 0x84EC, 0x8CEC, 0x94EC, 0x94EC, 0x9D0D, 0xAD2E, 0xB56E, 0xBD8F, 0xC58F, 0xCD90, 0xC570, 0xACEF, 0x9D10, 0x9DB3, 0x95D3, 0x7D30, 0x5C6C, 0x43E9, 0x3BC8, 0x33C7, 0x2BA7, 0x2386, 0x2366, 0x1B26, 0x1B06, 0x1AE6, 0x1AA6, 
        0x1A86, 0x1A45, 0x1A26, 0x1A25, 0x1A06, 0x19E6, 0x19C6, 0x19C6, 0x19A6, 0x19A6, 0x19C6, 0x19C6, 0x21C7, 0x21E7, 0x2207, 0x2207, 0x2A28, 0x2A27, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x5C4C, 0x542B, 0x5CCC, 0x6D6E, 0x6DAF, 0x654D, 0x6D6D, 0x75CF, 0x75EF, 0x75EF, 0x658D, 0x5D2C, 0x5D4D, 0x6DAF, 0x7E31, 0x7E31, 0x8E72, 0x9ED3, 0x9EF4, 0x9ED3, 0x8E91, 0x8650, 0x7E50, 0x7E70, 0x760E, 0x6DEE, 0x762F, 0x760F, 0x5D4D, 0x5D8D, 0x65EE, 
        0x662F, 0x660F, 0x55AD, 0x55CE, 0x5DF0, 0x6611, 0x7E73, 0x650E, 0x74CD, 0x7CED, 0x7CEC, 0x7D0C, 0x7D0C, 0x750C, 0x750C, 0x7D2C, 0x7D2C, 0x750C, 0x750C, 0x750C, 0x750C, 0x74EC, 0x7D0C, 0x852D, 0x852D, 0x852D, 0x852D, 0x7D0D, 0x7D0C, 0x6D0C, 
        0x6CEC, 0x64EB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CCB, 0x54AB, 0x548B, 0x4C6B, 0x544B, 0x642C, 0x640D, 0x6BEE, 0x6BCE, 0x63CE, 0x5BAD, 0x5BCD, 0x5BEE, 0x5C0F, 0x5C0F, 0x6430, 0x6C70, 0x6470, 0x6470, 0x6470, 0x6CB1, 0x6CD1, 0x74F1, 0x7511, 
        0x7531, 0x8592, 0x8DD3, 0x8E12, 0x8E12, 0x9612, 0x9612, 0x9E13, 0xAE54, 0xBE75, 0xBE76, 0xAE15, 0x7CD1, 0x432B, 0x21E7, 0x19A5, 0x1985, 0x1985, 0x1984, 0x21A4, 0x21A4, 0x19A5, 0x21C5, 0x21C5, 0x21E5, 0x21E5, 0x2A26, 0x2266, 0x2AA7, 0x2AC7, 
        0x2B07, 0x3327, 0x3347, 0x3367, 0x3BA7, 0x3BA7, 0x3BC7, 0x3BC7, 0x3C07, 0x3C08, 0x3C08, 0x4408, 0x4408, 0x4408, 0x4C09, 0x5C0A, 0x6C0B, 0x7C0C, 0x7C0C, 0x7C0B, 0x73EB, 0x73CA, 0x73EA, 0x740B, 0x6C2C, 0x6C4C, 0x6C6D, 0x6C8D, 0x6C8D, 0x6C6D, 
        0x648E, 0x6C8E, 0x6CAE, 0x74AF, 0x74CF, 0x7CF0, 0x74F0, 0x74CF, 0x6CAF, 0x6C8E, 0x644D, 0x5C0D, 0x53CC, 0x4BAA, 0x4369, 0x4349, 0x3B28, 0x3308, 0x32E7, 0x32E7, 0x32C7, 0x2AC6, 0x2AA6, 0x2AA7, 0x2AA7, 0x3287, 0x3287, 0x2A67, 0x2A67, 0x2A46, 
        0x2A47, 0x2246, 0x2226, 0x1A26, 0x1A26, 0x2246, 0x2266, 0x2266, 0x2266, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x2306, 0x2306, 0x2326, 0x2346, 0x2346, 0x1B46, 0x1B66, 0x1B86, 
        0x1B86, 0x1B65, 0x1B65, 0x1B65, 0x1B65, 0x1B65, 0x1B45, 0x2345, 0x2345, 0x2325, 0x2325, 0x2B06, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x32C6, 0x32E6, 0x3307, 0x3327, 0x3B27, 0x3B47, 0x3B67, 0x3B87, 0x3B87, 0x3B87, 0x3BA7, 0x33A6, 0x33C7, 0x3BE7, 
        0x3C07, 0x3C27, 0x3C28, 0x4448, 0x4448, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3BE7, 0x33C8, 0x33C8, 0x33A8, 0x3388, 0x3368, 0x3348, 0x3328, 0x3308, 0x2AE8, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE6, 0x2B06, 0x2B06, 
        0x2B26, 0x2346, 0x2366, 0x2386, 0x2386, 0x2385, 0x23A5, 0x23A5, 0x23A6, 0x23A5, 0x1B85, 0x1B65, 0x1B65, 0x1B44, 0x1B24, 0x1B04, 0x12C4, 0x12A4, 0x1284, 0x1244, 0x1224, 0x11E3, 0x11C3, 0x11A3, 0x1183, 0x1183, 0x1163, 0x1163, 0x1163, 0x1184, 
        0x11A4, 0x11C4, 0x19E4, 0x1A24, 0x1264, 0x1284, 0x1AA4, 0x1AA4, 0x1AC4, 0x1B05, 0x1B05, 0x1B25, 0x1B45, 0x1B45, 0x1B65, 0x1B66, 0x1B46, 0x1B46, 0x1B46, 0x1B46, 0x1B26, 0x2326, 0x2326, 0x2326, 0x2B26, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x3368, 
        0x3368, 0x3368, 0x3348, 0x3328, 0x3309, 0x32EA, 0x3AEA, 0x3AEB, 0x432C, 0x536E, 0x5BAF, 0x5BD0, 0x5BD0, 0x63F0, 0x63F0, 0x6410, 0x6451, 0x6CB1, 0x7512, 0x7D53, 0x7D32, 0x74D1, 0x6CB0, 0x74D1, 0x74D1, 0x7CF2, 0x7D12, 0x8532, 0x8532, 0x8552, 
        0x8592, 0x8DB3, 0x8DB3, 0x8DB3, 0x8DB2, 0x8DB3, 0x8D92, 0x8D72, 0x8552, 0x7CF2, 0x7492, 0x7432, 0x7453, 0x7474, 0x6C94, 0x6CF4, 0x7554, 0x75B4, 0x7E14, 0x8633, 0x6D6F, 0x546B, 0x5409, 0x5409, 0x5409, 0x540A, 0x540A, 0x64CE, 0x7550, 0x7571, 
        0x6D51, 0x6530, 0x5CF0, 0x548F, 0x43CC, 0x2AE9, 0x2AA8, 0x2A88, 0x2A47, 0x2A27, 0x2206, 0x21E6, 0x21E6, 0x21E6, 0x21E6, 0x2206, 0x2226, 0x2226, 0x2247, 0x2287, 0x2AA7, 0x2AA7, 0x32E7, 0x3B08, 0x4B48, 0x63AB, 0x844D, 0x8C6D, 0x848D, 0x7C8D, 
        0x84CD, 0x84CD, 0x8CED, 0x8CEC, 0x8CEC, 0x94EC, 0x9D0D, 0xA52D, 0xB56E, 0xBD8E, 0xC58F, 0xCD90, 0xC570, 0xACEF, 0x94CF, 0x9D72, 0x9DD3, 0x8D51, 0x64AD, 0x4BE9, 0x3BE8, 0x33C7, 0x33C7, 0x2BC7, 0x2B86, 0x2366, 0x1B46, 0x1B26, 0x1B06, 0x1AC6, 
        0x1AA5, 0x1A85, 0x1A45, 0x1A25, 0x1A26, 0x1A06, 0x19E6, 0x19C6, 0x19C6, 0x19C6, 0x21C6, 0x21C7, 0x21E7, 0x2207, 0x2207, 0x2A28, 0x2A28, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x5C4B, 0x4C2A, 0x5CCC, 0x6D6E, 0x6DAF, 0x6D8E, 0x6D6D, 0x6DAE, 0x75EE, 0x6DCE, 0x656D, 0x552C, 0x554C, 0x658E, 0x7610, 0x75F0, 0x7E31, 0x8E92, 0x96B3, 0x96D3, 0x8671, 0x7E4F, 0x762F, 0x762F, 0x6E2F, 0x6E0E, 0x6E0F, 0x6DEF, 0x5D8D, 0x554D, 0x5DAD, 
        0x558C, 0x4D8C, 0x4D8D, 0x4DAE, 0x5DF0, 0x6631, 0x7633, 0x64CD, 0x74CD, 0x74EC, 0x7CEC, 0x7CEC, 0x7D0C, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x74EC, 0x74EC, 0x7D0C, 0x852D, 0x852D, 0x852D, 0x7D0C, 0x750C, 0x750C, 0x6D0C, 
        0x64EB, 0x5CEB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CCB, 0x54AB, 0x4C8A, 0x546B, 0x544B, 0x642C, 0x6C2D, 0x742E, 0x740E, 0x6BEE, 0x63EE, 0x6C2F, 0x6C70, 0x6C70, 0x6450, 0x6C50, 0x6C71, 0x6C70, 0x6450, 0x6470, 0x6CB1, 0x6CD1, 0x6CF1, 0x7531, 
        0x7D72, 0x85B3, 0x8DF3, 0x8DF2, 0x8DF2, 0x95F2, 0x95F2, 0xA613, 0xAE54, 0xBE95, 0xBE96, 0xB635, 0x8511, 0x4B6C, 0x2207, 0x19A5, 0x19A5, 0x19A5, 0x2184, 0x2184, 0x19A4, 0x21C5, 0x21C5, 0x21C5, 0x21E5, 0x21E5, 0x2A05, 0x2246, 0x2A86, 0x2AA7, 
        0x2AE7, 0x3307, 0x3327, 0x3367, 0x3367, 0x3387, 0x33A7, 0x33C7, 0x3BE7, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3C08, 0x4BEA, 0x5C0B, 0x6C0B, 0x6C0C, 0x740C, 0x740C, 0x6C0C, 0x6BEB, 0x6C0B, 0x6C2C, 0x6C6D, 0x6C6D, 0x6C8E, 0x6CAE, 0x6CCE, 0x6CCE, 
        0x6CAE, 0x6C8E, 0x6C8E, 0x74AF, 0x74CF, 0x7CD0, 0x74AF, 0x6C6E, 0x642D, 0x5C0D, 0x53AB, 0x4B8A, 0x436A, 0x3B49, 0x3328, 0x3307, 0x3307, 0x2B07, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AA6, 0x2AA6, 0x2AA7, 0x3287, 0x2AA7, 0x2A87, 0x2A87, 
        0x2A67, 0x2266, 0x2286, 0x2286, 0x1A86, 0x1A86, 0x22A6, 0x1AA6, 0x1AA6, 0x22C6, 0x22C6, 0x22E6, 0x22E7, 0x22E7, 0x22E7, 0x22E7, 0x22E7, 0x22E7, 0x22E7, 0x2307, 0x2307, 0x2327, 0x2327, 0x2326, 0x2326, 0x2346, 0x2346, 0x1B46, 0x1B66, 0x1B66, 
        0x1B65, 0x1B65, 0x1B65, 0x1B65, 0x1B45, 0x1B45, 0x1B25, 0x1B25, 0x2305, 0x2305, 0x2305, 0x22E6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x32E6, 0x32E7, 0x3307, 0x3327, 0x3B47, 0x3B67, 0x3B67, 0x3B87, 0x3B86, 0x3BA6, 0x3BC7, 0x3BE7, 
        0x3C07, 0x3C27, 0x3C27, 0x4448, 0x4448, 0x4448, 0x4448, 0x3C28, 0x3C28, 0x3C08, 0x3BE8, 0x33E7, 0x33C7, 0x33A8, 0x3387, 0x3367, 0x3348, 0x3328, 0x3308, 0x32E8, 0x2AC7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x22A7, 0x22A6, 0x22E6, 0x2AE6, 0x2B06, 
        0x2B26, 0x2B26, 0x2346, 0x2366, 0x2386, 0x2386, 0x23A5, 0x23A6, 0x23A6, 0x23A5, 0x23A5, 0x1B85, 0x1B65, 0x1B45, 0x1B24, 0x1B04, 0x12E4, 0x12C4, 0x12A4, 0x1284, 0x1244, 0x1223, 0x1204, 0x11E3, 0x11A3, 0x11A3, 0x1183, 0x1183, 0x1184, 0x11A4, 
        0x11A4, 0x11E4, 0x1A04, 0x1A24, 0x1264, 0x1284, 0x1AA4, 0x1AC4, 0x1AE5, 0x1B05, 0x1B24, 0x1B24, 0x1B45, 0x1B45, 0x1B65, 0x1B45, 0x1B46, 0x1B46, 0x1B46, 0x1B26, 0x1B26, 0x2326, 0x2326, 0x2326, 0x2B27, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x3368, 
        0x3368, 0x3368, 0x3348, 0x3348, 0x3328, 0x32E9, 0x32E9, 0x32EA, 0x3AEB, 0x430C, 0x4B4D, 0x538F, 0x5BCF, 0x5BD0, 0x63F0, 0x63F0, 0x6410, 0x6431, 0x6C91, 0x74D2, 0x74F2, 0x6CB1, 0x6CD1, 0x7D12, 0x7D32, 0x7D12, 0x7D12, 0x7D31, 0x8572, 0x8592, 
        0x8592, 0x8DB2, 0x8DB2, 0x8DB2, 0x8DB2, 0x8DB2, 0x8592, 0x8552, 0x8532, 0x7CD1, 0x7472, 0x7432, 0x7453, 0x7474, 0x6C94, 0x6CF4, 0x7554, 0x75B4, 0x7DF3, 0x8632, 0x6D4E, 0x546A, 0x4C29, 0x4C09, 0x5409, 0x540A, 0x5C4B, 0x7530, 0x7571, 0x6D51, 
        0x6530, 0x6510, 0x5CCF, 0x440D, 0x334A, 0x2AE9, 0x32A8, 0x2A88, 0x2A47, 0x2A27, 0x2A07, 0x2206, 0x21E6, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x1A26, 0x2226, 0x2267, 0x2A87, 0x2AA7, 0x32E8, 0x4329, 0x5369, 0x73EC, 0x8C6D, 0x8C8D, 0x848D, 0x84AD, 
        0x84CD, 0x8CED, 0x8CED, 0x8CED, 0x94ED, 0x9D0D, 0xA54E, 0xB56E, 0xBD6F, 0xC58F, 0xC58F, 0xC570, 0xBD0F, 0x946D, 0x9D30, 0x9DB3, 0x8D71, 0x6CAD, 0x4C2A, 0x43E9, 0x3BE8, 0x33E7, 0x33E7, 0x33C7, 0x2BA6, 0x2386, 0x2366, 0x2346, 0x2306, 0x22E6, 
        0x22C6, 0x1A86, 0x1A66, 0x1A46, 0x1A26, 0x1A26, 0x1A06, 0x19E6, 0x19E6, 0x21E7, 0x21E7, 0x21E7, 0x21E7, 0x2207, 0x2228, 0x2A28, 0x2A28, 0x2A28, 0x2A27, 0x2A47, 0x2A47, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x4C4B, 0x4C6B, 0x54CB, 0x5D4D, 0x6DAF, 0x6DCF, 0x54CB, 0x6D6D, 0x6DCE, 0x6DCE, 0x5D6D, 0x552C, 0x554C, 0x5D8D, 0x6DEF, 0x6DCF, 0x7610, 0x7E30, 0x75F0, 0x658D, 0x75EF, 0x760E, 0x6E0E, 0x65EE, 0x65EE, 0x65EE, 0x65EE, 0x65CE, 0x5D6D, 0x4D0C, 0x4D4B, 
        0x452B, 0x558D, 0x55CE, 0x4DAE, 0x55AF, 0x6E32, 0x6DF1, 0x64CD, 0x74AD, 0x74EC, 0x7CEC, 0x7CEC, 0x7D0C, 0x7D0C, 0x7D0C, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x74EC, 0x74EC, 0x750C, 0x852D, 0x852D, 0x7D0C, 0x7D0C, 0x6CEC, 0x6CEB, 0x64EB, 
        0x5CEB, 0x5CEB, 0x54CB, 0x5CCB, 0x5CCB, 0x5CCB, 0x54CB, 0x54AA, 0x4C8A, 0x546B, 0x546B, 0x642C, 0x6C4D, 0x746E, 0x744F, 0x6C2F, 0x6C2E, 0x7490, 0x74D1, 0x74F1, 0x74F1, 0x6CD0, 0x6CD1, 0x6C91, 0x6470, 0x6450, 0x6C91, 0x6CD1, 0x6CF1, 0x7551, 
        0x7D92, 0x85D2, 0x85F3, 0x8DD3, 0x8DD2, 0x95D3, 0x95D3, 0xA5F3, 0xAE55, 0xBE95, 0xBEB6, 0xB655, 0x8511, 0x4B4B, 0x2207, 0x21C6, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21C5, 0x21C5, 0x21C5, 0x21C5, 0x2205, 0x2226, 0x2A66, 0x2AA6, 
        0x2AC7, 0x2AE7, 0x3307, 0x3347, 0x3367, 0x3367, 0x3387, 0x33C7, 0x33C7, 0x33C8, 0x3BE8, 0x3BE8, 0x3BE8, 0x4409, 0x4C2B, 0x5C2C, 0x642C, 0x640C, 0x6C2C, 0x642C, 0x6C2C, 0x642C, 0x642C, 0x6C6D, 0x6CAE, 0x6CCE, 0x6CCF, 0x750F, 0x750F, 0x6CEF, 
        0x6CAF, 0x6C8F, 0x6C8F, 0x74AF, 0x74AF, 0x748F, 0x6C4E, 0x5BCC, 0x53AB, 0x4B8B, 0x436A, 0x4349, 0x3B28, 0x3307, 0x3307, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AA6, 0x2AA6, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 
        0x2AA7, 0x2AA7, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x22E6, 0x22E6, 0x2307, 0x2327, 0x2327, 0x2B27, 0x2B27, 0x2B27, 0x2B27, 0x2B27, 0x2B47, 0x2B47, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2367, 0x2366, 0x2366, 0x2366, 0x1B66, 
        0x1B66, 0x1B66, 0x1B46, 0x1B46, 0x1B25, 0x1B25, 0x1B05, 0x1B05, 0x2305, 0x22E5, 0x22E6, 0x22C6, 0x22C6, 0x2AA6, 0x2AA6, 0x2A86, 0x2A86, 0x2AA6, 0x32C6, 0x2AE7, 0x3307, 0x3327, 0x3B47, 0x3B47, 0x3B67, 0x3B87, 0x3BA7, 0x3BA6, 0x3BC7, 0x3BE7, 
        0x3BE7, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x4428, 0x4428, 0x3C28, 0x3C28, 0x3C08, 0x3C07, 0x3BC7, 0x33C7, 0x3388, 0x3367, 0x3367, 0x3327, 0x3308, 0x3307, 0x2AC7, 0x2AA7, 0x2AA7, 0x2A87, 0x2A87, 0x2A87, 0x2287, 0x2AA7, 0x2AC6, 0x2AC6, 0x2AE6, 
        0x2B06, 0x2B26, 0x2346, 0x2346, 0x2365, 0x2386, 0x2386, 0x23A6, 0x23A5, 0x23C5, 0x23A5, 0x1BA5, 0x2385, 0x1B65, 0x1B45, 0x1B25, 0x1B24, 0x1B05, 0x1AC5, 0x1AA4, 0x1284, 0x1244, 0x1224, 0x1204, 0x11E4, 0x11C4, 0x11A4, 0x11A4, 0x11A4, 0x11C4, 
        0x11C4, 0x1A04, 0x1204, 0x1A44, 0x1A64, 0x1284, 0x1AA4, 0x1AC4, 0x1AE5, 0x1B05, 0x1B24, 0x1B24, 0x1B45, 0x1B45, 0x1B45, 0x1B45, 0x1B46, 0x1B46, 0x1B26, 0x1B26, 0x1B26, 0x2326, 0x2326, 0x2327, 0x2307, 0x2B27, 0x2B27, 0x2B47, 0x2B67, 0x3368, 
        0x3368, 0x3368, 0x3348, 0x3348, 0x3328, 0x3308, 0x3309, 0x3309, 0x330A, 0x3B0A, 0x3B2B, 0x432C, 0x4B6E, 0x53AF, 0x5BD0, 0x5BF0, 0x5BF0, 0x5BF0, 0x5C11, 0x6471, 0x6C91, 0x6CB1, 0x74F2, 0x8533, 0x7D32, 0x74D1, 0x7D11, 0x8572, 0x8592, 0x8592, 
        0x8592, 0x8592, 0x8592, 0x8592, 0x8592, 0x8D92, 0x8572, 0x8532, 0x74F1, 0x6C90, 0x6C51, 0x6C32, 0x7453, 0x7453, 0x6C94, 0x6CF4, 0x6D54, 0x7593, 0x75D3, 0x7E12, 0x650D, 0x4C4A, 0x4C29, 0x4C09, 0x542A, 0x5C6C, 0x6D0E, 0x7571, 0x7571, 0x6D30, 
        0x6D30, 0x6510, 0x546E, 0x3B6B, 0x3309, 0x32C8, 0x2AA8, 0x2A87, 0x2A47, 0x2A27, 0x2A07, 0x2206, 0x2206, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x2206, 0x2226, 0x2267, 0x2A87, 0x2AA7, 0x3AE8, 0x5BAB, 0x63CB, 0x844D, 0x8C8D, 0x8C8D, 0x8CAD, 0x84CD, 
        0x8CED, 0x950D, 0x950D, 0x950D, 0x9D0D, 0xA52E, 0xAD6E, 0xBD8F, 0xC58F, 0xC58F, 0xC58F, 0xBD2F, 0x9C8D, 0x9CCF, 0x9D92, 0x9572, 0x74CE, 0x542B, 0x43E8, 0x43E8, 0x3BC7, 0x33E7, 0x2BE7, 0x2BC7, 0x2BA6, 0x2B86, 0x2366, 0x2346, 0x2326, 0x2306, 
        0x22E6, 0x22A6, 0x1A86, 0x1A66, 0x1A46, 0x1A26, 0x1A26, 0x2206, 0x2206, 0x21E7, 0x21E7, 0x21E7, 0x2207, 0x2228, 0x2A28, 0x2A28, 0x2A48, 0x2A48, 0x2A48, 0x2A47, 0x2A47, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x442A, 0x444A, 0x448A, 0x4CEB, 0x5D8D, 0x6DCE, 0x656D, 0x656D, 0x6DCE, 0x6DAE, 0x5D6C, 0x554C, 0x554C, 0x5D6D, 0x65CE, 0x65CF, 0x6DCF, 0x6DEF, 0x75EF, 0x760F, 0x6E0F, 0x6E0E, 0x660E, 0x5DED, 0x5DCD, 0x5DCD, 0x5DAD, 0x5D6D, 0x44AA, 0x4D0C, 0x556C, 
        0x558C, 0x55AD, 0x55AE, 0x55AE, 0x55AF, 0x5D90, 0x6590, 0x5C8D, 0x74AD, 0x74CC, 0x7CEC, 0x7CEC, 0x7D0C, 0x750C, 0x750C, 0x750C, 0x750C, 0x74EC, 0x750C, 0x750C, 0x750C, 0x74EC, 0x750C, 0x7D2C, 0x850D, 0x7D0C, 0x74EC, 0x6CEB, 0x64CB, 0x5CCB, 
        0x5CCB, 0x5CEB, 0x54CB, 0x54CB, 0x5CEB, 0x54CB, 0x54CB, 0x4CAA, 0x4C8B, 0x548B, 0x546B, 0x644C, 0x6C6D, 0x748E, 0x7C6F, 0x6C2F, 0x6C4F, 0x74B0, 0x7D11, 0x7D51, 0x7D51, 0x7531, 0x6D10, 0x6CB1, 0x6450, 0x5C30, 0x6470, 0x6CD1, 0x6CF1, 0x7552, 
        0x7D93, 0x7DD2, 0x85D2, 0x85B2, 0x8DD2, 0x8DB2, 0x95B3, 0xA5F4, 0xAE35, 0xBEB6, 0xBEB6, 0xAE35, 0x74D0, 0x430B, 0x2207, 0x21E6, 0x21C6, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 0x2206, 0x2226, 0x2A86, 
        0x2AA6, 0x2AC7, 0x2AE7, 0x3327, 0x3347, 0x3367, 0x3367, 0x33A7, 0x33A7, 0x33A8, 0x3BC8, 0x3BC9, 0x43E9, 0x4C2A, 0x544C, 0x5C4C, 0x644D, 0x644C, 0x644C, 0x644C, 0x644D, 0x644D, 0x644D, 0x648D, 0x6CCE, 0x6CCF, 0x6CEF, 0x6D0F, 0x6CF0, 0x6CAF, 
        0x646F, 0x6C6F, 0x6C90, 0x7490, 0x6C6F, 0x640D, 0x53AC, 0x4B6B, 0x434A, 0x3B49, 0x3B29, 0x3328, 0x3307, 0x3307, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AA7, 0x2AA7, 0x2AC7, 0x32C7, 0x2AC7, 
        0x32C7, 0x2AC7, 0x2AE7, 0x22E7, 0x2307, 0x2307, 0x2327, 0x2327, 0x2327, 0x2327, 0x2B47, 0x2B47, 0x2B67, 0x2B67, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2387, 0x2387, 0x2387, 0x2387, 0x2386, 
        0x1B66, 0x1B46, 0x1B46, 0x1B26, 0x1B05, 0x1B05, 0x1AE5, 0x22E5, 0x22C5, 0x22C5, 0x22C5, 0x22A5, 0x2285, 0x2286, 0x2286, 0x2A86, 0x2A66, 0x2A86, 0x2AA6, 0x2AC6, 0x2AE6, 0x3306, 0x3327, 0x3B47, 0x3B67, 0x3B87, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BE7, 
        0x3BE7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x4428, 0x3C28, 0x3C28, 0x3C08, 0x3BE7, 0x33C7, 0x33A7, 0x3388, 0x3367, 0x3347, 0x3327, 0x32E7, 0x32E7, 0x2AC7, 0x2AA7, 0x2A87, 0x2A67, 0x2A67, 0x2A67, 0x2A87, 0x2AA7, 0x2AA7, 0x2AC6, 0x2AE6, 
        0x2AE6, 0x2B06, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x2386, 0x23A6, 0x23A6, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x1B85, 0x1B65, 0x1B45, 0x1B25, 0x1B05, 0x1B05, 0x1AC5, 0x12A4, 0x1264, 0x1244, 0x1224, 0x1204, 0x11E4, 0x11E4, 0x11C4, 0x11C4, 0x11E4, 
        0x19E4, 0x1A04, 0x1224, 0x1A64, 0x1A64, 0x1AA4, 0x1AA4, 0x1AC5, 0x1AE5, 0x1B05, 0x1B24, 0x1B24, 0x1B25, 0x1B45, 0x1B45, 0x1B45, 0x1B46, 0x1B26, 0x1B26, 0x1B26, 0x1B26, 0x1B26, 0x2306, 0x2307, 0x2307, 0x2B27, 0x2B28, 0x2B48, 0x3368, 0x3368, 
        0x3368, 0x3368, 0x3368, 0x3348, 0x3348, 0x3328, 0x3328, 0x3329, 0x3329, 0x330A, 0x3B2A, 0x3B2B, 0x436C, 0x4B8E, 0x53AF, 0x5BB0, 0x5BB0, 0x5BD0, 0x5BF1, 0x6431, 0x6431, 0x6C92, 0x7CF3, 0x7D13, 0x74F1, 0x74F1, 0x7D32, 0x8572, 0x8572, 0x7D72, 
        0x8572, 0x8572, 0x8592, 0x8592, 0x8572, 0x8572, 0x8552, 0x7CF1, 0x6CB0, 0x6C50, 0x6C51, 0x6C32, 0x7433, 0x7453, 0x6C94, 0x6CF4, 0x6D53, 0x6D73, 0x75D2, 0x75D1, 0x5CED, 0x4C2A, 0x4C29, 0x544A, 0x5C8C, 0x6D0E, 0x7D70, 0x7571, 0x6D51, 0x6D50, 
        0x7551, 0x64D0, 0x4BCC, 0x332A, 0x3309, 0x32E8, 0x2AA8, 0x2A87, 0x2A67, 0x2A47, 0x2A27, 0x2A07, 0x2206, 0x2207, 0x2207, 0x2207, 0x2207, 0x2227, 0x2247, 0x2267, 0x2A87, 0x32A7, 0x42E8, 0x63EC, 0x744D, 0x8C6E, 0x948E, 0x94AD, 0x8CCD, 0x8CED, 
        0x94ED, 0x950D, 0x9D0D, 0x9D0D, 0xA52D, 0xAD4E, 0xB58F, 0xC5AF, 0xC58F, 0xC56F, 0xC54F, 0xA4AE, 0x9CCF, 0xA593, 0x9DB3, 0x7D10, 0x5C4C, 0x43C9, 0x3BC8, 0x3BC7, 0x33E7, 0x33E7, 0x2BE6, 0x2BC7, 0x2BA6, 0x2BA6, 0x2B86, 0x2366, 0x2346, 0x2306, 
        0x22E6, 0x22C6, 0x22A6, 0x2286, 0x2266, 0x1A46, 0x2226, 0x2227, 0x2207, 0x2207, 0x2A28, 0x2A28, 0x2A28, 0x2A28, 0x2A48, 0x2A48, 0x3269, 0x3248, 0x3248, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27, 0x2A27, 0x2A27,
  0x3C29, 0x3C28, 0x3C69, 0x44A9, 0x4CEA, 0x5D6C, 0x658D, 0x654D, 0x658D, 0x656D, 0x552C, 0x4CEB, 0x4D4C, 0x556C, 0x5DCE, 0x5DCE, 0x65CE, 0x65CE, 0x6DEF, 0x6E0F, 0x660E, 0x660E, 0x662E, 0x5E0E, 0x55CD, 0x55AD, 0x558D, 0x556D, 0x550C, 0x44CB, 0x4D4C, 
        0x558D, 0x4D8D, 0x4DAE, 0x4DAF, 0x558F, 0x65D1, 0x5CEE, 0x5C8C, 0x6CAC, 0x74CC, 0x74CC, 0x74EC, 0x7CEC, 0x74EC, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x750C, 0x74EC, 0x74EC, 0x74EC, 0x7D0C, 0x7D0C, 0x74EC, 0x6CCB, 0x64CB, 0x64CB, 0x5CCB, 
        0x5CCB, 0x54CB, 0x54CA, 0x54CB, 0x54CB, 0x54AB, 0x54AB, 0x54AB, 0x4C8B, 0x548B, 0x546B, 0x5C4C, 0x6C6D, 0x748E, 0x746E, 0x6C2E, 0x640E, 0x646F, 0x6CCF, 0x7530, 0x7571, 0x7550, 0x6D30, 0x6CB1, 0x6450, 0x5C10, 0x6450, 0x6CD1, 0x6D11, 0x6D51, 
        0x75B2, 0x7DB2, 0x85D2, 0x85B2, 0x8DB2, 0x8DB2, 0x95D3, 0xA614, 0xAE55, 0xB6B6, 0xB6B6, 0x9E14, 0x6C6F, 0x3AEA, 0x2207, 0x19E6, 0x21C5, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 0x2206, 0x2246, 
        0x2A86, 0x2AA7, 0x2AC7, 0x2B07, 0x3327, 0x3347, 0x3347, 0x3368, 0x3B88, 0x3BA9, 0x43CA, 0x4C0B, 0x542B, 0x544B, 0x546C, 0x5C6D, 0x5C6D, 0x5C4C, 0x5C4C, 0x5C6C, 0x646D, 0x646D, 0x646D, 0x648E, 0x6CCE, 0x6CCF, 0x6CEF, 0x6CCF, 0x64AF, 0x646F, 
        0x644F, 0x6C6F, 0x6C70, 0x6C4F, 0x5BED, 0x4BAB, 0x436A, 0x4349, 0x3B49, 0x3329, 0x3308, 0x2B07, 0x2B07, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 
        0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x2B27, 0x2327, 0x2347, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B88, 0x3388, 0x3388, 0x2B88, 0x2BA8, 0x2BA8, 0x2BA7, 0x2BA7, 0x2BA8, 0x2BA8, 0x2BA8, 0x2BA7, 0x23A7, 0x2387, 0x2387, 0x2387, 0x2387, 
        0x1B66, 0x1B66, 0x1B46, 0x1B25, 0x1B05, 0x1AE5, 0x1AE5, 0x1AC5, 0x22A5, 0x22A5, 0x2285, 0x2285, 0x2265, 0x2266, 0x2266, 0x2266, 0x2266, 0x2A86, 0x2AA6, 0x2AC6, 0x2AE6, 0x2B06, 0x3326, 0x3347, 0x3B67, 0x3B87, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BE7, 
        0x3BE7, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x3BE8, 0x3BC7, 0x3BA7, 0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E7, 0x32C7, 0x2AA7, 0x2A87, 0x2A67, 0x2A67, 0x2A47, 0x2A47, 0x2A67, 0x2A87, 0x2AA7, 0x2AC7, 0x2AC6, 
        0x2AE6, 0x2B06, 0x2B26, 0x2B26, 0x2B66, 0x2B66, 0x2B86, 0x2B86, 0x23A6, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x1B85, 0x1B65, 0x1B45, 0x1B25, 0x1B05, 0x1AE5, 0x1AA4, 0x1284, 0x1264, 0x1264, 0x1244, 0x1224, 0x1204, 0x11E4, 0x1204, 0x1204, 
        0x1204, 0x1A24, 0x1A44, 0x1A64, 0x1A84, 0x1AA4, 0x1AC5, 0x1AE5, 0x1B05, 0x1B24, 0x1B24, 0x1B24, 0x1B24, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B26, 0x1B06, 0x1B06, 0x1B06, 0x2307, 0x22E7, 0x2307, 0x2307, 0x2B07, 0x2B28, 0x2B28, 0x3348, 0x3348, 
        0x3368, 0x3368, 0x3348, 0x3348, 0x3348, 0x3348, 0x3348, 0x3349, 0x3B49, 0x3B49, 0x3B49, 0x434A, 0x436B, 0x436C, 0x4B4E, 0x4B4E, 0x4B4E, 0x53B0, 0x5BD0, 0x5BD1, 0x6411, 0x6432, 0x6C52, 0x6C72, 0x74B2, 0x7D12, 0x8552, 0x8551, 0x7D51, 0x7D31, 
        0x7D31, 0x7D51, 0x8572, 0x8552, 0x7D31, 0x7D31, 0x7D11, 0x74B0, 0x6C6F, 0x6C70, 0x7472, 0x7432, 0x6C33, 0x6C53, 0x6C74, 0x7514, 0x7554, 0x6DB3, 0x75D2, 0x75D1, 0x5CED, 0x4C0A, 0x542B, 0x5C8C, 0x6D0F, 0x7550, 0x7551, 0x6D31, 0x6D11, 0x6D31, 
        0x6D11, 0x542D, 0x3B8A, 0x3329, 0x3309, 0x32E8, 0x2AC8, 0x2AA7, 0x2A87, 0x2A67, 0x2A47, 0x2A27, 0x2A27, 0x2A07, 0x2207, 0x2227, 0x2227, 0x2227, 0x2247, 0x2A67, 0x2A88, 0x3A88, 0x4B2A, 0x742D, 0x8C8E, 0x94AE, 0x94CE, 0x94EE, 0x94ED, 0x950D, 
        0x950D, 0x9D0D, 0x9D0D, 0x9D0D, 0xAD4E, 0xB56E, 0xC58F, 0xC58F, 0xC56F, 0xBD4F, 0xA4CE, 0x948E, 0x9D52, 0x9DB3, 0x8530, 0x646D, 0x43C9, 0x3BA8, 0x3BA8, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x2BC7, 0x2BA6, 0x2BA6, 0x2B86, 0x2B87, 0x2366, 0x2326, 
        0x2306, 0x22E6, 0x22C6, 0x22A6, 0x2286, 0x2266, 0x2266, 0x2247, 0x2247, 0x2A47, 0x2A48, 0x2A48, 0x2A48, 0x2A68, 0x2A69, 0x2A69, 0x3269, 0x3268, 0x3268, 0x3268, 0x3268, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27, 0x2A27,
  0x3C29, 0x3428, 0x3C68, 0x3CA9, 0x44CA, 0x554C, 0x656D, 0x54AA, 0x5D4D, 0x5D4D, 0x552C, 0x450B, 0x4D2B, 0x4D4B, 0x55AD, 0x5DCE, 0x5DAE, 0x5DAE, 0x65EE, 0x660E, 0x5DEE, 0x5DCD, 0x5DED, 0x4DAC, 0x4D8C, 0x4D8C, 0x4D6C, 0x4D4C, 0x550C, 0x4CEB, 0x450B, 
        0x558D, 0x454C, 0x4D8D, 0x4D8E, 0x5DD0, 0x6590, 0x548C, 0x646C, 0x6C8C, 0x74AC, 0x74CC, 0x74CC, 0x74EC, 0x74EC, 0x7D0C, 0x7D0C, 0x7D0C, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x750C, 0x74EC, 0x6CEC, 0x6CCB, 0x64CB, 0x64CB, 0x5CCB, 
        0x54CB, 0x54CA, 0x54CB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x4C8A, 0x548B, 0x546B, 0x544B, 0x646C, 0x6C8D, 0x6C4E, 0x5BCD, 0x4B8B, 0x4BAC, 0x4C0C, 0x5CAE, 0x650F, 0x6D2F, 0x6D30, 0x64F0, 0x5C70, 0x5410, 0x5C30, 0x64B1, 0x6D11, 0x6D51, 
        0x7591, 0x7DB2, 0x85B2, 0x85B2, 0x8DD3, 0x95D3, 0x9DF3, 0xA634, 0xAE75, 0xB695, 0xB696, 0x95D3, 0x5C2E, 0x32C9, 0x2207, 0x21E6, 0x21E5, 0x21E5, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x2185, 0x2185, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 0x2A26, 
        0x2A47, 0x2A87, 0x2AA7, 0x2AE7, 0x2B07, 0x3327, 0x3328, 0x3B48, 0x4389, 0x4BAA, 0x53EB, 0x540C, 0x5C4C, 0x544C, 0x546C, 0x546C, 0x546C, 0x544C, 0x5C6C, 0x5C8D, 0x64AD, 0x648D, 0x64AE, 0x64AE, 0x6CCE, 0x6CCF, 0x6CD0, 0x64AF, 0x644F, 0x642F, 
        0x6450, 0x6C70, 0x642F, 0x5BCD, 0x4B8B, 0x436A, 0x3B49, 0x3328, 0x3328, 0x2B28, 0x2B07, 0x2B07, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2B07, 
        0x2B27, 0x2B28, 0x2B48, 0x2B48, 0x2B67, 0x2B87, 0x2B88, 0x2BA8, 0x2BC7, 0x2BC7, 0x2BC8, 0x2BC7, 0x2BC8, 0x33C8, 0x33C8, 0x33C8, 0x33C8, 0x2BC8, 0x2BC8, 0x2BE8, 0x2BE8, 0x2BE8, 0x2BE8, 0x2BE8, 0x2BC8, 0x2BC8, 0x2BC8, 0x2BA7, 0x23A7, 0x23A7, 
        0x2387, 0x2386, 0x2346, 0x2345, 0x1B05, 0x1AE5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1A85, 0x2265, 0x2265, 0x2245, 0x2245, 0x2245, 0x2245, 0x2246, 0x2266, 0x2286, 0x22A5, 0x2AC6, 0x2AE6, 0x3306, 0x3346, 0x3B66, 0x3B87, 0x3BA7, 0x3BC7, 0x3BE7, 0x3BE7, 
        0x3BE7, 0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BA8, 0x3387, 0x3367, 0x3367, 0x3347, 0x3307, 0x32E7, 0x32C7, 0x2AA7, 0x2A87, 0x2A67, 0x2247, 0x2247, 0x2227, 0x2247, 0x2A46, 0x2A66, 0x2A86, 0x2286, 0x2AA6, 
        0x2AC6, 0x22E6, 0x2306, 0x2326, 0x2B46, 0x2B46, 0x2B66, 0x2B86, 0x2BA6, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x1B85, 0x1B65, 0x1B65, 0x1B45, 0x1B25, 0x1B04, 0x1AC4, 0x12A4, 0x12A5, 0x1284, 0x1264, 0x1244, 0x1224, 0x1224, 0x1224, 0x1204, 
        0x1224, 0x1244, 0x1264, 0x1A84, 0x1AA4, 0x1AC4, 0x1AC4, 0x1AE5, 0x1B04, 0x1B24, 0x1B24, 0x1B24, 0x1B24, 0x1B25, 0x1B25, 0x1B25, 0x1B06, 0x1B06, 0x1B06, 0x1B06, 0x1B06, 0x22E7, 0x22E7, 0x2307, 0x2B08, 0x2B08, 0x3328, 0x3328, 0x3348, 0x3348, 
        0x3369, 0x3389, 0x3368, 0x3368, 0x3368, 0x3368, 0x3B88, 0x3B88, 0x3B88, 0x3B89, 0x3B89, 0x3B6A, 0x438A, 0x434B, 0x4B4D, 0x4B6E, 0x536E, 0x5390, 0x53B0, 0x53B0, 0x5BD0, 0x5BF1, 0x6411, 0x6C52, 0x74B2, 0x7D12, 0x8552, 0x7D31, 0x7511, 0x74F0, 
        0x7D11, 0x7D31, 0x7D31, 0x7511, 0x74F1, 0x74D1, 0x6C70, 0x644F, 0x6C70, 0x74B1, 0x7492, 0x7432, 0x6C13, 0x6C53, 0x7494, 0x7514, 0x7574, 0x6DB3, 0x75D2, 0x6DB0, 0x54CC, 0x43EA, 0x544C, 0x6CEE, 0x7530, 0x7531, 0x6D11, 0x6CF1, 0x6CF1, 0x6D11, 
        0x648F, 0x43CB, 0x3B6A, 0x3329, 0x3308, 0x32E8, 0x2AC8, 0x32A8, 0x32A8, 0x3288, 0x3288, 0x2A67, 0x2A47, 0x2A27, 0x2A27, 0x2A47, 0x2A47, 0x2A47, 0x2A68, 0x2A67, 0x2A88, 0x3A88, 0x5B4B, 0x844E, 0x9CAE, 0x9CCE, 0x9CEE, 0x950E, 0x950D, 0x950D, 
        0x9D0D, 0x9D0D, 0xA50D, 0xA52E, 0xAD4E, 0xBD6F, 0xC58F, 0xC58F, 0xC54F, 0xB4EE, 0x944D, 0x8C8F, 0x9552, 0x8531, 0x646D, 0x43CA, 0x3B88, 0x3388, 0x33A7, 0x33A7, 0x33A7, 0x33C7, 0x33A7, 0x2BC7, 0x2BA6, 0x2B86, 0x2B86, 0x2387, 0x2366, 0x2346, 
        0x2326, 0x2306, 0x22E6, 0x22C6, 0x22A7, 0x22A7, 0x2287, 0x2A87, 0x2A87, 0x2A68, 0x2A68, 0x2A68, 0x2A89, 0x2A69, 0x2A69, 0x2A69, 0x3269, 0x3268, 0x3268, 0x3268, 0x3268, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A48, 0x2A27, 0x2A27,
  0x3C49, 0x3C48, 0x3C68, 0x3CA9, 0x44EA, 0x552C, 0x5D4C, 0x5D2C, 0x656D, 0x5D4D, 0x552C, 0x4D2C, 0x4D4B, 0x452B, 0x452B, 0x55AD, 0x55AD, 0x55AD, 0x5DCD, 0x558C, 0x55CD, 0x55CD, 0x55CD, 0x4DAC, 0x458C, 0x456C, 0x454C, 0x4D2C, 0x4D0C, 0x4D0C, 0x44EB, 
        0x450B, 0x452C, 0x4D8E, 0x558F, 0x65D0, 0x5CEE, 0x5C6C, 0x646C, 0x6C6C, 0x748C, 0x74AC, 0x74CC, 0x74CC, 0x74EC, 0x7D0C, 0x7D0C, 0x7D0C, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x6CCC, 0x6CCB, 0x64CB, 0x5CCB, 0x5CCB, 
        0x54AB, 0x54CB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x4C8A, 0x4C8B, 0x546B, 0x546B, 0x648C, 0x6C6D, 0x6C2D, 0x538C, 0x3AE9, 0x2AC8, 0x3308, 0x43CB, 0x546D, 0x5CEF, 0x652F, 0x64F0, 0x5C70, 0x5410, 0x5C30, 0x5CB0, 0x6510, 0x6550, 
        0x6D91, 0x7DB2, 0x85D3, 0x85D2, 0x8DD3, 0x95D3, 0x9E13, 0xA634, 0xAE75, 0xB695, 0xAE75, 0x8572, 0x53EC, 0x2AA8, 0x2226, 0x2206, 0x2206, 0x21E5, 0x21E5, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 0x2206, 
        0x2246, 0x2267, 0x2A87, 0x2AA7, 0x2AE7, 0x32E7, 0x3307, 0x3B08, 0x4B6A, 0x53CB, 0x540C, 0x5C2D, 0x5C4D, 0x546C, 0x546C, 0x544C, 0x544C, 0x544C, 0x546C, 0x5CAD, 0x64AD, 0x64AE, 0x64CE, 0x64CE, 0x6CCF, 0x6CAF, 0x6CAF, 0x5C4F, 0x5C2F, 0x5C0F, 
        0x6430, 0x640F, 0x53AD, 0x4B6B, 0x3B4A, 0x3B29, 0x3329, 0x2B28, 0x2B07, 0x2AE7, 0x22E7, 0x22E6, 0x22E6, 0x22E6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x32C6, 0x32E7, 0x2AE7, 0x2B07, 0x2B07, 0x2B28, 
        0x2B48, 0x2B68, 0x2B88, 0x2B88, 0x2BA8, 0x2BC8, 0x2BC8, 0x2BE8, 0x3408, 0x3408, 0x3408, 0x3408, 0x2C08, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x3408, 0x2BE8, 0x2BE8, 0x2BC8, 0x2BA8, 
        0x2BA7, 0x2B87, 0x2367, 0x2326, 0x2305, 0x1AE5, 0x1AC5, 0x1AA5, 0x1A85, 0x1A65, 0x1A45, 0x1A45, 0x2225, 0x2225, 0x1A25, 0x1A25, 0x2225, 0x2246, 0x2266, 0x2AA5, 0x2AC6, 0x2AE6, 0x3306, 0x3346, 0x3B66, 0x3B87, 0x3BC7, 0x3BC7, 0x43E7, 0x3BE7, 
        0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3BE7, 0x3BE7, 0x3BE7, 0x3BC7, 0x3BC8, 0x3BA8, 0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x2AE7, 0x2AA7, 0x2A87, 0x2A67, 0x2A47, 0x2247, 0x2227, 0x2206, 0x2226, 0x2226, 0x2A46, 0x2266, 0x2286, 0x2286, 
        0x2AA6, 0x22C6, 0x22E6, 0x2306, 0x2326, 0x2B26, 0x2B66, 0x2B86, 0x2B86, 0x23A5, 0x23A5, 0x23A5, 0x23C5, 0x23C5, 0x23A5, 0x2385, 0x2365, 0x1B65, 0x1B45, 0x1B24, 0x1AE5, 0x1AC5, 0x12A5, 0x12A4, 0x1284, 0x1264, 0x1A64, 0x1244, 0x1244, 0x1224, 
        0x1244, 0x1244, 0x1A64, 0x1A85, 0x1AA4, 0x1AC5, 0x22E5, 0x22E5, 0x1B04, 0x1B04, 0x1B24, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B05, 0x1B06, 0x1B06, 0x1B06, 0x22E6, 0x22E7, 0x22E7, 0x2AE8, 0x2B08, 0x2B08, 0x3328, 0x3328, 0x3328, 0x3349, 0x3B49, 
        0x3B69, 0x3B69, 0x3B89, 0x3B88, 0x3B88, 0x3B88, 0x3BA8, 0x3BA8, 0x3BC8, 0x43A9, 0x43A9, 0x43A9, 0x43AA, 0x4BAC, 0x53AE, 0x53AF, 0x53AF, 0x538F, 0x53AF, 0x538F, 0x5390, 0x53B0, 0x5BF1, 0x6432, 0x6C72, 0x7CD2, 0x7D12, 0x74F1, 0x74D0, 0x74F1, 
        0x7D11, 0x7CF1, 0x74F1, 0x74D1, 0x6C91, 0x642F, 0x5C0F, 0x7490, 0x7491, 0x7471, 0x7451, 0x6C11, 0x6C13, 0x7454, 0x74B4, 0x7534, 0x7594, 0x6DB3, 0x75D2, 0x6D8F, 0x548C, 0x4C0A, 0x5C6D, 0x7510, 0x7531, 0x6D11, 0x6CF1, 0x6CD1, 0x6CF1, 0x64D0, 
        0x4C0D, 0x3B8A, 0x3B69, 0x3B49, 0x3328, 0x3308, 0x32E8, 0x32C8, 0x32C8, 0x32C8, 0x32A8, 0x3288, 0x2A68, 0x3268, 0x2A48, 0x2A67, 0x2A67, 0x2A48, 0x2A68, 0x2A88, 0x3288, 0x3AA9, 0x636C, 0x946F, 0xA4CF, 0x9CEE, 0xA50E, 0x9D0E, 0x9D0D, 0x9D0D, 
        0x9D0D, 0x9D0D, 0xA50D, 0xAD2E, 0xB54E, 0xBD6F, 0xC58F, 0xC56F, 0xB52F, 0xA48E, 0x8C6E, 0x9D31, 0x8D31, 0x6C8E, 0x4BCA, 0x3B68, 0x3367, 0x3367, 0x2B87, 0x2B87, 0x2B87, 0x33A7, 0x33A7, 0x2BA7, 0x2BA6, 0x2BA7, 0x2B87, 0x2387, 0x2366, 0x2346, 
        0x2346, 0x2346, 0x2326, 0x22E6, 0x22C7, 0x22C7, 0x2AA7, 0x2AA7, 0x2AA8, 0x2AA8, 0x2AA8, 0x2AA8, 0x32A8, 0x3289, 0x3288, 0x3288, 0x3288, 0x3288, 0x2A88, 0x3268, 0x2A68, 0x2A68, 0x2A68, 0x3268, 0x3268, 0x2A68, 0x2A48, 0x2A48, 0x2A47,
  0x3C69, 0x3C48, 0x3448, 0x3C89, 0x44EA, 0x4D0B, 0x5D2C, 0x652D, 0x5D4D, 0x5D2D, 0x552C, 0x4D0C, 0x452B, 0x452B, 0x454C, 0x4DAD, 0x4D8D, 0x4D8D, 0x4DAD, 0x4DAD, 0x55CD, 0x4DCD, 0x45CC, 0x45AC, 0x458C, 0x456B, 0x454C, 0x44EB, 0x3C69, 0x4D0C, 0x44CA, 
        0x3CEA, 0x452C, 0x4D8E, 0x5DAF, 0x658F, 0x5CCD, 0x6C8D, 0x6C6D, 0x6C6C, 0x6C6C, 0x748C, 0x74AC, 0x74CC, 0x74EC, 0x7CEC, 0x7CEC, 0x7CEC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x6CCB, 0x64CB, 0x64CB, 0x5CCB, 0x5CAB, 
        0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AA, 0x548B, 0x548B, 0x548B, 0x5C8C, 0x6C8D, 0x6C4D, 0x53AC, 0x32C9, 0x2267, 0x2266, 0x2AE7, 0x43CA, 0x548D, 0x5CEE, 0x5CEF, 0x5CB0, 0x5C50, 0x5430, 0x5C8F, 0x5CF0, 0x6550, 
        0x6D91, 0x7DD2, 0x7DD2, 0x85D2, 0x8DD3, 0x95F3, 0x9E14, 0xA654, 0xAE75, 0xAE95, 0xA634, 0x7D31, 0x4BAB, 0x2287, 0x1A26, 0x2206, 0x2206, 0x2205, 0x21E5, 0x21C5, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E6, 
        0x2226, 0x2A47, 0x2A67, 0x2A87, 0x2AA7, 0x32C7, 0x32E7, 0x3AE8, 0x4B4A, 0x53CC, 0x5C0C, 0x5C4D, 0x5C4D, 0x546D, 0x546D, 0x546C, 0x546C, 0x546C, 0x546C, 0x5CAD, 0x64AE, 0x64AE, 0x64CE, 0x6CCF, 0x6CCF, 0x6CAF, 0x646F, 0x5C2F, 0x53EF, 0x5BEF, 
        0x53CE, 0x4B8D, 0x434B, 0x3B2A, 0x3309, 0x3308, 0x2B08, 0x2B07, 0x22E6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x22C6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x32E6, 0x32E7, 0x32E7, 0x3307, 0x3307, 0x3328, 0x3348, 
        0x3368, 0x2B88, 0x2BA8, 0x2BC8, 0x33E8, 0x2BE8, 0x3408, 0x3428, 0x3448, 0x3448, 0x3448, 0x3448, 0x3448, 0x3448, 0x3C48, 0x3C49, 0x3449, 0x3449, 0x3449, 0x3449, 0x3449, 0x3449, 0x3429, 0x3429, 0x3429, 0x3429, 0x3409, 0x3408, 0x33E8, 0x33E8, 
        0x2BC8, 0x2BA7, 0x2B67, 0x2B46, 0x2306, 0x22E6, 0x22A6, 0x1A85, 0x1A66, 0x1A66, 0x1A25, 0x1A25, 0x1A05, 0x1A05, 0x1A05, 0x1A05, 0x1A25, 0x2246, 0x2266, 0x2AA6, 0x2AC6, 0x2AE6, 0x3306, 0x3346, 0x3B66, 0x3BA7, 0x3BA7, 0x3BC7, 0x43E7, 0x3C07, 
        0x3BE7, 0x3C07, 0x3C07, 0x3BE7, 0x3BE7, 0x3BE7, 0x3BE7, 0x3BC7, 0x3BC7, 0x3BA8, 0x3B87, 0x3367, 0x3367, 0x3347, 0x3307, 0x2AE7, 0x2AC7, 0x2AA7, 0x2A67, 0x2A47, 0x2227, 0x2207, 0x2206, 0x2206, 0x2206, 0x2226, 0x2226, 0x2246, 0x2266, 0x2286, 
        0x2286, 0x22A6, 0x22C6, 0x22E6, 0x2306, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x2B86, 0x23A5, 0x2BA5, 0x23A5, 0x23A5, 0x23A5, 0x23A5, 0x2385, 0x2365, 0x1B45, 0x1B25, 0x1B25, 0x1B05, 0x1AC5, 0x12C4, 0x1AA4, 0x1A85, 0x1A85, 0x1A65, 0x1264, 0x1244, 
        0x1264, 0x1264, 0x1A84, 0x1AA5, 0x1AA5, 0x22C5, 0x22E5, 0x2305, 0x2305, 0x1B25, 0x2325, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x2306, 0x2306, 0x2306, 0x2307, 0x2307, 0x2B07, 0x2B08, 0x2B08, 0x3328, 0x3329, 0x3329, 0x3B29, 0x3B49, 0x3B49, 0x3B69, 
        0x3B69, 0x3B69, 0x3B89, 0x3B89, 0x3BA9, 0x3BA9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x4BCA, 0x53EC, 0x53CD, 0x53AE, 0x538E, 0x538E, 0x538F, 0x538F, 0x538F, 0x53B0, 0x5BB0, 0x63F1, 0x6432, 0x6C72, 0x7492, 0x7491, 0x74B1, 0x74B2, 
        0x74B1, 0x7491, 0x6C70, 0x6C50, 0x640F, 0x5BCE, 0x5BCE, 0x6430, 0x6C50, 0x6C71, 0x7451, 0x6C12, 0x6C33, 0x7474, 0x74D4, 0x7534, 0x7574, 0x6DB3, 0x75D2, 0x654F, 0x4C6C, 0x4C2B, 0x64CF, 0x7511, 0x6D11, 0x64D1, 0x64D1, 0x6CF1, 0x6CF1, 0x5C6E, 
        0x43AB, 0x3B69, 0x3B69, 0x3B48, 0x3B28, 0x3B08, 0x3308, 0x32E8, 0x32E8, 0x32E8, 0x32C8, 0x32A8, 0x32A8, 0x3288, 0x3288, 0x2A68, 0x2A68, 0x3268, 0x3268, 0x3288, 0x32A8, 0x42C9, 0x6BAC, 0xA4D0, 0xAD0F, 0xAD0F, 0xA52E, 0x9D2E, 0x9D0D, 0x9D0D, 
        0x9D0D, 0xA50D, 0xA50D, 0xB52E, 0xBD6F, 0xC58F, 0xC570, 0xBD4F, 0xA4CE, 0x8C4E, 0x94D1, 0x9532, 0x748F, 0x4BCB, 0x3B49, 0x3348, 0x3347, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x33A7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2387, 0x2387, 0x2367, 
        0x2367, 0x2346, 0x2346, 0x2307, 0x2B07, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AC8, 0x32C8, 0x32C8, 0x32C8, 0x32C9, 0x32A9, 0x32A9, 0x3288, 0x3288, 0x3288, 0x2A88, 0x3288, 0x3268, 0x3268, 0x3268, 0x3268, 0x3268, 0x2A68, 0x2A68, 0x2A48, 0x2A48,
  0x3C69, 0x3C49, 0x2C07, 0x3468, 0x3CA9, 0x44CA, 0x4CEB, 0x4CCB, 0x54EC, 0x5D0C, 0x4CEB, 0x44EB, 0x3D0B, 0x3D2B, 0x456C, 0x458D, 0x458D, 0x458D, 0x45AD, 0x4DCD, 0x4DCD, 0x45CD, 0x45CC, 0x45AD, 0x458C, 0x454C, 0x450C, 0x3CAB, 0x3C8A, 0x44AB, 0x3C8A, 
        0x4D2C, 0x4D4C, 0x558E, 0x6DAF, 0x6D0E, 0x6CCD, 0x7C8D, 0x748D, 0x746D, 0x746C, 0x748C, 0x748D, 0x74AD, 0x74CC, 0x7CEC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 0x74CC, 0x74EC, 0x74EC, 0x6CCB, 0x6CCB, 0x64CB, 0x64CB, 0x5CCB, 0x54AB, 
        0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x548B, 0x5C8C, 0x6C8D, 0x6C4D, 0x5BCC, 0x3AE9, 0x2A67, 0x2246, 0x2266, 0x3328, 0x4C0C, 0x5CAE, 0x5CEF, 0x5CCF, 0x548F, 0x544F, 0x544F, 0x5CB0, 0x5D30, 
        0x6D70, 0x7591, 0x7DB2, 0x85D2, 0x8DD3, 0x95F3, 0x9E13, 0xA654, 0xAE75, 0xAE75, 0x9E14, 0x74D0, 0x436B, 0x2287, 0x1A26, 0x1A25, 0x2206, 0x2205, 0x21E5, 0x21E5, 0x21C5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21E5, 
        0x21E6, 0x2226, 0x2A46, 0x2A87, 0x2AA7, 0x2AA7, 0x32C7, 0x32C8, 0x434A, 0x53CC, 0x5C2D, 0x5C4D, 0x5C4D, 0x546D, 0x546C, 0x546C, 0x546C, 0x548C, 0x5C8C, 0x5CAD, 0x64AE, 0x64AE, 0x6CAF, 0x6CAF, 0x6CAF, 0x646F, 0x5C2F, 0x540F, 0x53CF, 0x53CF, 
        0x4B6D, 0x434B, 0x3B2A, 0x3309, 0x3308, 0x2B08, 0x2B07, 0x22E7, 0x22C6, 0x22C6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AE6, 0x2AE6, 0x32E6, 0x32E7, 0x3307, 0x3307, 0x3327, 0x3348, 0x3368, 
        0x3388, 0x33A8, 0x33C8, 0x33E8, 0x3408, 0x3428, 0x3428, 0x3469, 0x3C69, 0x3C89, 0x3C89, 0x3C89, 0x3C69, 0x3C89, 0x3C89, 0x3C89, 0x3C89, 0x3C89, 0x3C89, 0x3C69, 0x3C69, 0x3C69, 0x3C69, 0x3C69, 0x3C49, 0x3C49, 0x3C49, 0x3C29, 0x3409, 0x3408, 
        0x33E8, 0x33C8, 0x3388, 0x2B67, 0x2B27, 0x22E7, 0x22A6, 0x2286, 0x2266, 0x2246, 0x1A25, 0x2205, 0x2205, 0x19E5, 0x1A05, 0x1A05, 0x2225, 0x2245, 0x2286, 0x2AA6, 0x2AC6, 0x32E6, 0x3306, 0x3346, 0x3B67, 0x3B87, 0x43A7, 0x43C7, 0x43E7, 0x43E7, 
        0x4407, 0x3C07, 0x3C07, 0x3BE7, 0x3BE7, 0x33E7, 0x33C7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3367, 0x3367, 0x3327, 0x3308, 0x32E8, 0x2AC7, 0x2A87, 0x2A67, 0x2A47, 0x2227, 0x2206, 0x2206, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 0x2266, 
        0x2286, 0x22A6, 0x22C6, 0x22E6, 0x2AE6, 0x2B26, 0x2B46, 0x2B86, 0x2B86, 0x2BA6, 0x2BA6, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2386, 0x2366, 0x2365, 0x2345, 0x1B25, 0x1B05, 0x1AE5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1A85, 0x1264, 
        0x1284, 0x1A85, 0x1AA5, 0x22A5, 0x22A5, 0x22E5, 0x22E5, 0x2305, 0x2305, 0x2325, 0x2325, 0x2325, 0x2325, 0x2325, 0x2326, 0x2306, 0x2306, 0x2B07, 0x2B07, 0x2B07, 0x3328, 0x3328, 0x3329, 0x3B29, 0x3B29, 0x3B29, 0x3B49, 0x3B49, 0x3B69, 0x3B69, 
        0x3B69, 0x4389, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x43E9, 0x43E9, 0x4BE9, 0x4BE9, 0x4BE9, 0x4BEA, 0x4BEB, 0x53CB, 0x53CB, 0x53CB, 0x53AC, 0x53AC, 0x4B8C, 0x4B8C, 0x4B6E, 0x5370, 0x5391, 0x5BB1, 0x63F2, 0x6C32, 0x6C52, 0x7472, 0x7472, 
        0x6C51, 0x5BEF, 0x5BAE, 0x5BCF, 0x640F, 0x6C10, 0x7451, 0x7471, 0x7450, 0x7451, 0x7452, 0x7432, 0x7433, 0x7494, 0x74D4, 0x7534, 0x6D73, 0x6D92, 0x6DB2, 0x652F, 0x544C, 0x544D, 0x6CF0, 0x7511, 0x6CD1, 0x64D1, 0x6CF1, 0x6D11, 0x64B0, 0x4C0C, 
        0x3B8A, 0x3B69, 0x3B49, 0x3B48, 0x3B28, 0x3B28, 0x3308, 0x3B08, 0x32E8, 0x3AE8, 0x3AC8, 0x3AC8, 0x3AA8, 0x32A8, 0x3288, 0x3288, 0x3288, 0x3288, 0x3288, 0x3288, 0x3AA9, 0x42CA, 0x73CD, 0xACF0, 0xB50F, 0xAD2E, 0xA52D, 0x9D2D, 0x9D2D, 0x9D0D, 
        0x9D0D, 0xA50D, 0xAD2D, 0xBD6F, 0xC58F, 0xC58F, 0xC54F, 0xACCE, 0x9CAF, 0x9D11, 0x9512, 0x7C8F, 0x53EC, 0x3B49, 0x3328, 0x3348, 0x2B47, 0x2B47, 0x2B67, 0x3367, 0x2B67, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2B87, 0x2B87, 
        0x2387, 0x2367, 0x2347, 0x2327, 0x2B27, 0x2B07, 0x2B07, 0x2B08, 0x2B08, 0x2AE8, 0x32E8, 0x32C8, 0x32C9, 0x32A9, 0x32A8, 0x2AA8, 0x2A88, 0x2A88, 0x2A88, 0x3288, 0x3288, 0x3288, 0x3288, 0x3288, 0x3288, 0x2A68, 0x2A68, 0x2A68, 0x2A48,
  0x3C69, 0x3C69, 0x3448, 0x3448, 0x3468, 0x3CA9, 0x4D0B, 0x54EB, 0x54CC, 0x5CEC, 0x4CCB, 0x44AA, 0x3CEA, 0x3D0A, 0x3D4B, 0x3D6C, 0x3D6D, 0x3D6C, 0x45AD, 0x45CD, 0x45CD, 0x45CD, 0x45CC, 0x45CD, 0x458D, 0x454C, 0x452C, 0x4CEC, 0x448A, 0x4CAB, 0x3C6A, 
        0x44CA, 0x556D, 0x658E, 0x6D4E, 0x74ED, 0x7CCD, 0x84AD, 0x84AD, 0x7C8D, 0x7C8D, 0x7C8D, 0x746D, 0x748D, 0x74AD, 0x74CD, 0x74CD, 0x74ED, 0x7CEC, 0x74EC, 0x74EC, 0x74EC, 0x74CC, 0x74EC, 0x6CEC, 0x6CCB, 0x6CCB, 0x64CB, 0x5CAB, 0x5CAB, 0x54AB, 
        0x54CB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AA, 0x54AA, 0x54AA, 0x54AB, 0x54AB, 0x54AB, 0x5CAB, 0x648C, 0x6C8D, 0x6C4D, 0x5BCC, 0x4309, 0x3288, 0x2246, 0x2246, 0x2A87, 0x438A, 0x544D, 0x5CCE, 0x5CCF, 0x548F, 0x546E, 0x542F, 0x5470, 0x5CCF, 
        0x6530, 0x6D51, 0x7591, 0x7DB2, 0x85D2, 0x8E13, 0x9633, 0xA654, 0xA675, 0xA675, 0x95D3, 0x6C8F, 0x3B4A, 0x2287, 0x1A46, 0x1A25, 0x2225, 0x2205, 0x21E5, 0x21E5, 0x21C5, 0x21C5, 0x21C5, 0x21A5, 0x2185, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 
        0x21E5, 0x2206, 0x2226, 0x2A66, 0x2A87, 0x2A87, 0x2AA7, 0x32C8, 0x434A, 0x53CC, 0x540D, 0x5C4D, 0x546D, 0x548C, 0x548C, 0x54AC, 0x54AC, 0x54AC, 0x5CAD, 0x5CAD, 0x64AE, 0x64AE, 0x648F, 0x646F, 0x644F, 0x5C2F, 0x53EF, 0x53EF, 0x4BCF, 0x438E, 
        0x3B4B, 0x332A, 0x3309, 0x2B08, 0x2B08, 0x2B07, 0x2AE7, 0x22C7, 0x22A6, 0x22A6, 0x1AA6, 0x1AA6, 0x22A6, 0x22A6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x32C6, 0x32C6, 0x32E6, 0x32E6, 0x32E6, 0x32E7, 0x3307, 0x3327, 0x3347, 0x3367, 0x3367, 
        0x33A7, 0x33C8, 0x33E8, 0x3408, 0x3428, 0x3448, 0x3469, 0x3C69, 0x3C89, 0x3C89, 0x3C89, 0x3CA9, 0x3CA9, 0x3CA9, 0x3CA9, 0x44A9, 0x44AA, 0x44AA, 0x44AA, 0x44AA, 0x44AA, 0x44AA, 0x448A, 0x448A, 0x448A, 0x3C6A, 0x3C6A, 0x3C49, 0x3C29, 0x3C29, 
        0x3409, 0x33E8, 0x33A8, 0x2B88, 0x2B47, 0x2AE7, 0x2AA7, 0x2286, 0x2266, 0x2225, 0x2205, 0x21E5, 0x21E5, 0x19E5, 0x19E5, 0x1A05, 0x2245, 0x2266, 0x2A86, 0x2AA6, 0x32E6, 0x3306, 0x3B06, 0x3B47, 0x3B87, 0x3BA7, 0x43A7, 0x43C7, 0x43E7, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BE7, 0x33C7, 0x33C7, 0x33A7, 0x3387, 0x3387, 0x3367, 0x3347, 0x2B27, 0x2B07, 0x2AC7, 0x2AA7, 0x2A67, 0x2A46, 0x2226, 0x2206, 0x2A06, 0x21E6, 0x21E6, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 
        0x2266, 0x2286, 0x22A5, 0x2AC6, 0x2AE6, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BA6, 0x2386, 0x2386, 0x2366, 0x2346, 0x2326, 0x2306, 0x1AE5, 0x1AE5, 0x1AC5, 0x22C5, 0x22C5, 0x1AA5, 0x1AA5, 
        0x1AA5, 0x1AA5, 0x1AC5, 0x22C5, 0x22C5, 0x22E5, 0x2305, 0x2305, 0x2325, 0x2325, 0x2325, 0x2326, 0x2326, 0x2326, 0x2B06, 0x2B26, 0x2B27, 0x3327, 0x3327, 0x3328, 0x3B28, 0x3B29, 0x3B29, 0x3B29, 0x3B29, 0x3B29, 0x4349, 0x434A, 0x4369, 0x4369, 
        0x4389, 0x43AA, 0x43CA, 0x43EA, 0x43EA, 0x4BEA, 0x4C09, 0x4C09, 0x4C0A, 0x4C09, 0x4C09, 0x4C0A, 0x4C0A, 0x4BEA, 0x53EA, 0x4BEA, 0x53EA, 0x53CA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4B6C, 0x4B4E, 0x4B50, 0x5371, 0x5BB2, 0x63D2, 0x6C12, 0x6C12, 0x6C31, 
        0x63CF, 0x5BAF, 0x63EF, 0x7471, 0x7C91, 0x7C92, 0x7CB2, 0x7CD2, 0x7CB1, 0x7471, 0x7452, 0x7433, 0x7453, 0x7494, 0x6CF3, 0x6D33, 0x6573, 0x6571, 0x6571, 0x6510, 0x5C6E, 0x6490, 0x74F2, 0x6CD1, 0x6CD1, 0x64D1, 0x6D11, 0x6CF1, 0x5C6E, 0x3B8A, 
        0x3B69, 0x3B69, 0x3B49, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x3B08, 0x3B08, 0x3AE8, 0x3AE9, 0x3AC9, 0x3AC9, 0x32A9, 0x32A8, 0x32A8, 0x3288, 0x3288, 0x3A88, 0x3A89, 0x3AA9, 0x42CA, 0x7BED, 0xACEF, 0xB52F, 0xAD2E, 0xA52E, 0xA52D, 0x9D0D, 0x9D0D, 
        0xA50D, 0xA50D, 0xB54E, 0xC58F, 0xC58F, 0xC56F, 0xB50F, 0xA4AE, 0xA531, 0x9D52, 0x84D0, 0x5BCB, 0x3B29, 0x3328, 0x3328, 0x2B27, 0x2B27, 0x2B47, 0x2B67, 0x3367, 0x3367, 0x3387, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2B87, 
        0x2B87, 0x2B87, 0x2B67, 0x2B47, 0x2B47, 0x2B28, 0x2B28, 0x2B28, 0x3328, 0x3308, 0x3308, 0x32E8, 0x32E8, 0x32C9, 0x32C8, 0x32C8, 0x32A8, 0x32A8, 0x32A8, 0x32A9, 0x32A9, 0x32A8, 0x32A8, 0x32A8, 0x32A9, 0x2A89, 0x2A88, 0x2A68, 0x2A68,
  0x3C69, 0x3C49, 0x3448, 0x2C48, 0x2C47, 0x3468, 0x3C49, 0x54EC, 0x5CEC, 0x54CC, 0x44AB, 0x3C8A, 0x34C9, 0x350A, 0x350A, 0x350A, 0x352B, 0x354C, 0x3D8C, 0x3DAC, 0x3DAD, 0x3DAD, 0x3DAD, 0x45AD, 0x458D, 0x456D, 0x452D, 0x44CB, 0x448B, 0x448B, 0x446A, 
        0x44AB, 0x6DAF, 0x75AF, 0x6CED, 0x7CCD, 0x84AD, 0x8CAD, 0x8CAD, 0x8CAD, 0x84AE, 0x848D, 0x7C6D, 0x7C6D, 0x748D, 0x74AD, 0x74CD, 0x74CD, 0x7CEC, 0x74EC, 0x74EC, 0x74CC, 0x74CC, 0x74EC, 0x6CEC, 0x6CCC, 0x64CB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CAB, 
        0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AA, 0x54AA, 0x54AA, 0x54AB, 0x54AB, 0x54AB, 0x5CAB, 0x648C, 0x6C8C, 0x6C4D, 0x5BCC, 0x42E9, 0x32A8, 0x2A67, 0x2246, 0x2A66, 0x3B09, 0x540C, 0x54AE, 0x54CF, 0x54AF, 0x546E, 0x542F, 0x544F, 0x54AF, 
        0x5CEF, 0x6530, 0x7571, 0x7D92, 0x85D2, 0x8DF2, 0x9633, 0x9E54, 0xA674, 0xA654, 0x8592, 0x5C4E, 0x3329, 0x22A6, 0x1A65, 0x1A45, 0x1A45, 0x1A25, 0x1A05, 0x19E5, 0x19C5, 0x21E5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21C6, 
        0x21C6, 0x21E6, 0x2206, 0x2246, 0x2A66, 0x2A87, 0x2A87, 0x3AC8, 0x432A, 0x4B8B, 0x53EC, 0x542D, 0x544C, 0x546C, 0x548C, 0x54AC, 0x54AD, 0x5CCD, 0x5CCD, 0x64CE, 0x64CE, 0x6CCF, 0x648F, 0x5C2F, 0x53EE, 0x53EF, 0x53CF, 0x53D0, 0x4BCF, 0x436D, 
        0x330A, 0x2B09, 0x2B08, 0x2AE8, 0x2AE7, 0x2AC7, 0x2AC7, 0x22A7, 0x22A6, 0x2286, 0x2286, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x2AA6, 0x2AA6, 0x2AA6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AE6, 0x32E6, 0x32E6, 0x3307, 0x3307, 0x3327, 0x3347, 0x3367, 0x3388, 
        0x33A8, 0x33C8, 0x3408, 0x3C08, 0x3428, 0x3449, 0x3469, 0x3C89, 0x3CA9, 0x3CA9, 0x3CA9, 0x3CC9, 0x3CCA, 0x3CCA, 0x44CA, 0x44CA, 0x44CA, 0x44CA, 0x44CA, 0x44EA, 0x4CEB, 0x4CCB, 0x4CCB, 0x4CAB, 0x44AA, 0x448A, 0x448A, 0x446A, 0x444A, 0x3C49, 
        0x3C09, 0x3BE9, 0x3BC9, 0x3388, 0x2B48, 0x3307, 0x2AC7, 0x2AA7, 0x2A46, 0x2225, 0x2205, 0x2205, 0x2205, 0x19E5, 0x1A05, 0x2225, 0x2245, 0x2266, 0x2AA6, 0x2AC6, 0x32E6, 0x3B06, 0x3B27, 0x3B47, 0x3B67, 0x43A7, 0x43C7, 0x43C7, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x33C7, 0x33A7, 0x3387, 0x3387, 0x3367, 0x3347, 0x2B47, 0x2B07, 0x2AE7, 0x2AC7, 0x2A87, 0x2A67, 0x2A47, 0x2226, 0x2206, 0x21E6, 0x21E6, 0x21C6, 0x21C6, 0x21E6, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x2226, 
        0x2246, 0x2266, 0x2285, 0x22A6, 0x2AE6, 0x2B06, 0x2B26, 0x2B66, 0x2B86, 0x33A6, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B66, 0x2B26, 0x2326, 0x2306, 0x2305, 0x22E5, 0x22E5, 0x22E5, 0x22C5, 0x1AC5, 
        0x1AC5, 0x1AC5, 0x1AC5, 0x22C5, 0x22E5, 0x2305, 0x2B25, 0x2B25, 0x2326, 0x2326, 0x2B26, 0x2B26, 0x2B26, 0x2B27, 0x2B27, 0x2B27, 0x3327, 0x3328, 0x3B28, 0x3B28, 0x3B49, 0x4329, 0x4329, 0x4329, 0x4329, 0x4329, 0x432A, 0x436A, 0x436A, 0x4389, 
        0x438A, 0x43CA, 0x43EA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4C0A, 0x5409, 0x5409, 0x4C09, 0x4BE9, 0x4BE9, 0x4BE9, 0x4BC9, 0x4BC9, 0x4B8B, 0x4B6C, 0x4B4E, 0x5370, 0x5372, 0x5BB2, 0x63D3, 0x6BF2, 0x63F1, 
        0x63AF, 0x6C31, 0x84D3, 0x8D13, 0x84F2, 0x84D2, 0x84F2, 0x84F2, 0x84F2, 0x7CB1, 0x7452, 0x7433, 0x7473, 0x7494, 0x6CF3, 0x6D33, 0x6552, 0x6571, 0x6571, 0x6510, 0x64B0, 0x74D1, 0x74D2, 0x6CB1, 0x6CB1, 0x64F1, 0x6D11, 0x64D0, 0x4C0C, 0x3B89, 
        0x3B69, 0x3B69, 0x3B68, 0x3B48, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B08, 0x3B09, 0x3B09, 0x3AE9, 0x3AC9, 0x3AC9, 0x32C8, 0x32A8, 0x32A8, 0x3AA8, 0x3AA8, 0x3AA9, 0x3AC9, 0x4AEA, 0x7C0D, 0xACEF, 0xBD2F, 0xB56F, 0xAD6E, 0xA54E, 0xA52D, 0xA50D, 
        0xA52E, 0xB56E, 0xBD8F, 0xC58F, 0xC56F, 0xBD2E, 0xA4AD, 0xA510, 0x9D52, 0x8511, 0x5C0D, 0x3B29, 0x2AE8, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2B47, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BA7, 0x2BA7, 0x2BA7, 
        0x2BA7, 0x2B87, 0x2B87, 0x2B67, 0x2B68, 0x2B48, 0x2B48, 0x2B48, 0x3348, 0x3328, 0x3328, 0x3308, 0x3309, 0x32E9, 0x32C8, 0x32C8, 0x32C8, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32C9, 0x32A9, 0x2A88, 0x2A88, 0x2A88,
  0x4469, 0x3C69, 0x3448, 0x2C48, 0x2C27, 0x3448, 0x3C69, 0x4CAB, 0x4C8B, 0x4C6B, 0x446A, 0x3C8A, 0x3CEA, 0x3D0A, 0x3D4B, 0x3D6C, 0x354C, 0x354C, 0x356C, 0x358C, 0x35AC, 0x3DAD, 0x358C, 0x3D8C, 0x3D2C, 0x454D, 0x4D4D, 0x44AB, 0x4CAC, 0x4CAC, 0x54CC, 
        0x5CEC, 0x652D, 0x6CEC, 0x74CC, 0x84CD, 0x8CCD, 0x94AD, 0x94AD, 0x8C8D, 0x8CAD, 0x8C8D, 0x846D, 0x7C4E, 0x7C8E, 0x7CAE, 0x7CAD, 0x7CCD, 0x7CED, 0x7CEC, 0x74EC, 0x74CC, 0x74CC, 0x74EC, 0x6CEC, 0x6CEC, 0x64CC, 0x64CB, 0x5CCB, 0x5CCB, 0x5CAB, 
        0x5CAB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x548A, 0x548A, 0x548A, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x5C8B, 0x6C6C, 0x6C4C, 0x5BAB, 0x42E9, 0x32A8, 0x2A68, 0x2A47, 0x2A47, 0x32A8, 0x4BAB, 0x546D, 0x54CF, 0x54CF, 0x548F, 0x542E, 0x542E, 0x546F, 
        0x54AF, 0x6510, 0x6D51, 0x7591, 0x7DB2, 0x85F2, 0x9633, 0x9E54, 0x9E74, 0x9E34, 0x8571, 0x5C4D, 0x3329, 0x22C6, 0x1A85, 0x1A65, 0x1A45, 0x1A45, 0x1A25, 0x1A05, 0x19E5, 0x21E5, 0x21C5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21A5, 0x21C5, 0x21C5, 
        0x21C6, 0x21C6, 0x2206, 0x2226, 0x2A46, 0x2A46, 0x2A67, 0x32A8, 0x3AE9, 0x434A, 0x43AB, 0x4C0C, 0x544C, 0x546C, 0x548D, 0x5CCD, 0x5CCD, 0x5CED, 0x64EE, 0x64CF, 0x6CEF, 0x6CCF, 0x648F, 0x5C0F, 0x53CE, 0x53AF, 0x53D0, 0x53F0, 0x4BCF, 0x3B4C, 
        0x32EA, 0x2AE8, 0x2AE8, 0x2AC7, 0x2AC7, 0x2AA7, 0x22A6, 0x2286, 0x2286, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x2A86, 0x2AA6, 0x2AA6, 0x2AA6, 0x2AC6, 0x2AC6, 0x2AE6, 0x32E6, 0x32E6, 0x3306, 0x3307, 0x3327, 0x3347, 0x3367, 0x3367, 0x33A8, 
        0x33C8, 0x3BE8, 0x3C08, 0x3C28, 0x3C48, 0x3C69, 0x3C69, 0x3C89, 0x3CA9, 0x44CA, 0x44CA, 0x44EA, 0x44EA, 0x44EA, 0x44EA, 0x4D0A, 0x4D0A, 0x4D0A, 0x4D0A, 0x4D0B, 0x4D0B, 0x4CEB, 0x54EB, 0x4CEB, 0x4CCB, 0x4CCB, 0x4CAB, 0x4C8B, 0x448A, 0x446A, 
        0x444A, 0x3C29, 0x3BE9, 0x33A8, 0x3368, 0x3308, 0x2AC7, 0x2AA7, 0x2A46, 0x2226, 0x2205, 0x2205, 0x2206, 0x1A06, 0x2206, 0x2226, 0x2266, 0x2A86, 0x2AA6, 0x32C6, 0x3307, 0x3B27, 0x3B47, 0x3B67, 0x3B67, 0x43A7, 0x43C7, 0x43E7, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BA7, 0x33A7, 0x3386, 0x3367, 0x3367, 0x3347, 0x2B27, 0x2B07, 0x2AC7, 0x2AA7, 0x2A87, 0x2A67, 0x2A47, 0x2226, 0x2206, 0x21E6, 0x21C6, 0x21C6, 0x21C6, 0x21C6, 0x21C6, 0x21C6, 0x21E6, 0x2206, 0x2226, 
        0x2226, 0x2266, 0x2286, 0x22A6, 0x2AC6, 0x2AE6, 0x2B26, 0x3347, 0x3387, 0x33A7, 0x33A7, 0x33C7, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x2BC6, 0x2BA6, 0x2B86, 0x2B86, 0x2B46, 0x2346, 0x2326, 0x2326, 0x2306, 0x2305, 0x22E5, 0x22E5, 0x22E5, 
        0x22E5, 0x22E6, 0x22E6, 0x22E5, 0x2B06, 0x2B26, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B47, 0x2B27, 0x2B27, 0x2B47, 0x3347, 0x3328, 0x3328, 0x3B28, 0x3B29, 0x4349, 0x4329, 0x4329, 0x4329, 0x4329, 0x4329, 0x4329, 0x4329, 0x434A, 0x436A, 0x438A, 
        0x43AA, 0x4BEA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C2A, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x5409, 0x5409, 0x5409, 0x4C09, 0x4C09, 0x4BE9, 0x4BE8, 0x4BE9, 0x4BC9, 0x4BAA, 0x4B8B, 0x4B6D, 0x536F, 0x5371, 0x5B92, 0x63D3, 0x6BF3, 0x6BF2, 
        0x6BF1, 0x7CB2, 0x8D34, 0x8D33, 0x8D12, 0x84F2, 0x8512, 0x8D13, 0x8512, 0x7CB1, 0x7472, 0x7453, 0x7473, 0x74B4, 0x6CF3, 0x6D13, 0x6552, 0x6571, 0x6551, 0x6D31, 0x6D11, 0x74F2, 0x6CD2, 0x6CB2, 0x6CD1, 0x6D12, 0x6D11, 0x5C6E, 0x3BAA, 0x3B69, 
        0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x3B69, 0x4349, 0x3B49, 0x3B29, 0x3B29, 0x4329, 0x4309, 0x4309, 0x4309, 0x3AE9, 0x3AE9, 0x3AC9, 0x3AC9, 0x3AC9, 0x3AC9, 0x42E9, 0x4B2B, 0x5B4B, 0x8C4E, 0xB510, 0xBD4F, 0xB56F, 0xAD6E, 0xAD4E, 0xA54E, 0xAD4E, 
        0xB56F, 0xBD8F, 0xC58F, 0xBD6F, 0xBD2F, 0xACCE, 0x948E, 0x9D11, 0x8CF1, 0x642D, 0x434A, 0x2AE8, 0x2AC7, 0x22E7, 0x2AE7, 0x2307, 0x2B07, 0x2B47, 0x2B47, 0x2B67, 0x2B67, 0x2B87, 0x2B88, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 0x2BC7, 0x2BC7, 
        0x2BC7, 0x2BA7, 0x2B87, 0x2B67, 0x3368, 0x3368, 0x3368, 0x3368, 0x3348, 0x3348, 0x3329, 0x3329, 0x3329, 0x3309, 0x32E8, 0x32E8, 0x32E8, 0x32C9, 0x32C9, 0x32E9, 0x32E9, 0x32E9, 0x32E9, 0x32E9, 0x32E9, 0x32C9, 0x2AC9, 0x2AA8, 0x2A88,
  0x4449, 0x3C49, 0x3C49, 0x3448, 0x3448, 0x3468, 0x3C69, 0x446A, 0x444A, 0x444A, 0x3C49, 0x3449, 0x34C9, 0x3D0A, 0x3D2B, 0x3D4C, 0x3D2C, 0x352C, 0x352B, 0x352B, 0x3D8C, 0x3D8D, 0x3D8C, 0x3D8C, 0x456D, 0x456D, 0x4D2D, 0x4CEC, 0x54EC, 0x54ED, 0x5CED, 
        0x6D2E, 0x6CEC, 0x74CC, 0x7CAC, 0x84AC, 0x8CAC, 0x94AC, 0x94AC, 0x94AD, 0x948D, 0x948D, 0x846D, 0x846E, 0x7C6E, 0x7C8E, 0x7C8E, 0x74AE, 0x74CD, 0x74CC, 0x74CC, 0x74CC, 0x74EC, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CEC, 0x64EC, 0x64CC, 0x64CB, 0x5CCB, 
        0x5CCB, 0x5CCB, 0x5CAB, 0x5CAB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x548B, 0x5C6B, 0x646C, 0x6C4C, 0x5B8B, 0x42E9, 0x3AA9, 0x3288, 0x3267, 0x2A67, 0x32A8, 0x436A, 0x544D, 0x5CAE, 0x5CCF, 0x548F, 0x4C2E, 0x4C2E, 0x4C2E, 
        0x546F, 0x5CCF, 0x6D51, 0x7591, 0x7DB2, 0x85D2, 0x8E13, 0x9653, 0x9E74, 0x9613, 0x7D51, 0x544D, 0x3349, 0x22E6, 0x1AC5, 0x1AA5, 0x1A64, 0x1A65, 0x1A45, 0x1A25, 0x1A05, 0x19E5, 0x21C5, 0x21C5, 0x21A5, 0x19A5, 0x19A5, 0x19A5, 0x21A5, 0x21A5, 
        0x21A6, 0x21C6, 0x21E6, 0x21E6, 0x2A06, 0x2A26, 0x2A47, 0x3267, 0x3288, 0x3AE9, 0x3B2A, 0x43CB, 0x4C0C, 0x546D, 0x5C8D, 0x5CCE, 0x64CE, 0x64EE, 0x6CEF, 0x6CEF, 0x6CEF, 0x6CAF, 0x646F, 0x53CF, 0x4B8F, 0x53B0, 0x53F0, 0x53EF, 0x438D, 0x3B0B, 
        0x32C9, 0x2AC8, 0x2AC7, 0x2AA7, 0x2AA6, 0x2286, 0x2286, 0x2266, 0x2266, 0x2246, 0x2266, 0x2266, 0x2266, 0x2A86, 0x2A86, 0x2A86, 0x2A86, 0x2AA6, 0x2AC6, 0x2AC6, 0x2AE6, 0x32E6, 0x3307, 0x3307, 0x3327, 0x3347, 0x3347, 0x3368, 0x3388, 0x33A8, 
        0x33C8, 0x3BE8, 0x3C08, 0x3C49, 0x3C49, 0x3C69, 0x3C89, 0x3CA9, 0x44C9, 0x44CA, 0x44EA, 0x4CEA, 0x4D0A, 0x4D0A, 0x4D0A, 0x550B, 0x550B, 0x552B, 0x552B, 0x552B, 0x550B, 0x550C, 0x550C, 0x550C, 0x550C, 0x54EC, 0x54CC, 0x4CAB, 0x4CAB, 0x4C6B, 
        0x4C4A, 0x442A, 0x4409, 0x3BC9, 0x3B89, 0x3328, 0x32E7, 0x2AA7, 0x2A86, 0x2A46, 0x2226, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 0x2A66, 0x2AA6, 0x32C6, 0x32E7, 0x3B07, 0x3B27, 0x3B47, 0x3B67, 0x4387, 0x43A7, 0x43C7, 0x43E7, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3387, 0x3367, 0x3347, 0x2B26, 0x2B07, 0x2AE7, 0x2AC7, 0x2AA7, 0x2A67, 0x2A67, 0x2A46, 0x2226, 0x2A06, 0x21E6, 0x21C6, 0x21A6, 0x21C6, 0x21C6, 0x21C6, 0x21C6, 0x19C6, 0x19C6, 0x2206, 
        0x2226, 0x2246, 0x2266, 0x2A86, 0x2AC6, 0x2AE7, 0x2B07, 0x3347, 0x3367, 0x3387, 0x33A7, 0x33A7, 0x33A7, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x33C7, 0x33A6, 0x2BA6, 0x2B86, 0x2B86, 0x2B66, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2B06, 
        0x2B06, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B47, 0x3347, 0x3347, 0x3367, 0x3367, 0x3347, 0x3347, 0x3347, 0x3347, 0x3348, 0x3B28, 0x3B28, 0x3B28, 0x4329, 0x4329, 0x4329, 0x4309, 0x4329, 0x4329, 0x4329, 0x4329, 0x4349, 0x436A, 0x438A, 0x4BAA, 
        0x4BCA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C2A, 0x544A, 0x544A, 0x5449, 0x5449, 0x5449, 0x5429, 0x5429, 0x5429, 0x5409, 0x5409, 0x5408, 0x4C08, 0x4BE9, 0x4BE9, 0x4BC9, 0x4BC9, 0x4BA9, 0x4BA9, 0x4B6C, 0x538E, 0x5BB1, 0x5B93, 0x63B3, 0x6BD4, 0x7413, 
        0x7432, 0x7CB1, 0x8D53, 0x8D52, 0x84F1, 0x84F1, 0x8512, 0x8D32, 0x8532, 0x7CD1, 0x7452, 0x7473, 0x7493, 0x74D3, 0x6CF3, 0x6532, 0x6552, 0x6571, 0x6D71, 0x6D31, 0x6D12, 0x74F2, 0x6CD2, 0x6CD2, 0x6D12, 0x6D32, 0x64F0, 0x4BEC, 0x3B69, 0x3B89, 
        0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B89, 0x4369, 0x4369, 0x4369, 0x4369, 0x4349, 0x4329, 0x4329, 0x4309, 0x3B09, 0x3AE9, 0x3AE9, 0x3AC9, 0x3AC9, 0x3AC9, 0x4B0A, 0x63CD, 0x73ED, 0xA4D0, 0xB550, 0xBD6F, 0xB58F, 0xAD6E, 0xA54E, 0xAD4E, 0xB58F, 
        0xBDAF, 0xC5AF, 0xC58F, 0xBD4E, 0xACEE, 0x9C4D, 0x8C6E, 0x7C8F, 0x6C2E, 0x436A, 0x32E8, 0x2AC7, 0x22C7, 0x22C7, 0x22E7, 0x2307, 0x2307, 0x2327, 0x2B47, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 
        0x2BC7, 0x2BA7, 0x2BA7, 0x33A8, 0x3388, 0x3388, 0x3388, 0x3388, 0x3389, 0x3B69, 0x3349, 0x3B49, 0x3329, 0x3309, 0x3309, 0x3308, 0x3309, 0x32E9, 0x32E9, 0x3309, 0x3309, 0x3309, 0x3309, 0x3309, 0x3309, 0x32E9, 0x2AE9, 0x2AC9, 0x2AC8,
  0x4408, 0x4429, 0x3C49, 0x3C48, 0x3C48, 0x3448, 0x3C48, 0x3C69, 0x4CAB, 0x3C2A, 0x3C4A, 0x3429, 0x3489, 0x34EA, 0x3D2B, 0x3D2C, 0x3D2C, 0x3D2C, 0x3D2C, 0x3D4C, 0x3D6C, 0x3D6C, 0x3D6C, 0x3D6C, 0x454C, 0x4D4D, 0x4D2D, 0x552D, 0x5D2D, 0x75AF, 0x8652, 
        0x754E, 0x7CED, 0x7CAC, 0x84AC, 0x84AC, 0x8CAB, 0x8C8B, 0x8C8C, 0x948C, 0x948C, 0x8C8D, 0x8C8D, 0x846E, 0x846E, 0x7C6E, 0x7C6E, 0x746E, 0x748D, 0x74AC, 0x6CAC, 0x6CCC, 0x74EC, 0x6CED, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CEC, 0x64EC, 0x64CC, 0x64CB, 
        0x64CB, 0x5CAB, 0x5CCB, 0x5CCB, 0x5CAB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x54AB, 0x4CAB, 0x5C8B, 0x5C6B, 0x644C, 0x642C, 0x5B8C, 0x4AEA, 0x3AC9, 0x3AA8, 0x3267, 0x3287, 0x3288, 0x434A, 0x5C2D, 0x64AF, 0x5CCF, 0x548F, 0x4C2E, 0x4C0E, 0x4C2F, 
        0x544F, 0x5CAF, 0x6D30, 0x7571, 0x7DB2, 0x85D2, 0x8E13, 0x9653, 0x9E74, 0x8E13, 0x7551, 0x4C4D, 0x2B69, 0x2306, 0x1AE5, 0x1AC4, 0x1A84, 0x1A84, 0x1A64, 0x1A24, 0x1A04, 0x19E4, 0x19C5, 0x19C5, 0x19A5, 0x19A5, 0x1985, 0x1985, 0x1985, 0x1985, 
        0x21A5, 0x21A5, 0x21C6, 0x21C6, 0x21E6, 0x2A06, 0x2A26, 0x2A47, 0x2A47, 0x3288, 0x32C9, 0x3B6A, 0x4BCC, 0x542D, 0x5C6D, 0x64AE, 0x6CCE, 0x6CEE, 0x6CEF, 0x6CCF, 0x6CAF, 0x644F, 0x5C0F, 0x4B8F, 0x4B8F, 0x53D0, 0x53D0, 0x4BAF, 0x3B4C, 0x32EA, 
        0x2AA8, 0x2AA8, 0x2AA7, 0x2AA7, 0x2286, 0x2266, 0x2266, 0x2246, 0x2246, 0x2246, 0x2266, 0x2266, 0x2A66, 0x2A86, 0x2A86, 0x2A86, 0x32A6, 0x2AA6, 0x32C6, 0x32C6, 0x32C6, 0x32E7, 0x3307, 0x3307, 0x3327, 0x3347, 0x3367, 0x3B68, 0x3388, 0x3BA8, 
        0x3BC8, 0x3BE8, 0x3C08, 0x3C49, 0x3C69, 0x3C69, 0x4489, 0x44A9, 0x44C9, 0x44CA, 0x4CEA, 0x4D0A, 0x4D0A, 0x4D0A, 0x552B, 0x552B, 0x552B, 0x552B, 0x5D2B, 0x5D4C, 0x5D4C, 0x5D4C, 0x5D4C, 0x5D2C, 0x5D2C, 0x5D0C, 0x5D0C, 0x54CC, 0x54AB, 0x548B, 
        0x4C4A, 0x4C4A, 0x440A, 0x43C9, 0x3B89, 0x3B48, 0x3308, 0x2AC7, 0x2A86, 0x2A66, 0x2226, 0x2206, 0x2206, 0x2226, 0x2A46, 0x2A66, 0x2A87, 0x32A7, 0x32E7, 0x3B07, 0x3B27, 0x3B47, 0x3B67, 0x4387, 0x4387, 0x43A7, 0x43C7, 0x43E7, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BC7, 0x3387, 0x3387, 0x3367, 0x3347, 0x2B26, 0x2B06, 0x2AE7, 0x2AC7, 0x2AA7, 0x2A67, 0x2A47, 0x2A27, 0x2A26, 0x2A06, 0x21E6, 0x21C6, 0x21A6, 0x21A6, 0x21A6, 0x21C6, 0x21C6, 0x19C6, 0x19C6, 0x19E6, 
        0x2206, 0x2226, 0x2266, 0x2A86, 0x2AC6, 0x32E7, 0x3327, 0x3347, 0x3367, 0x3387, 0x3387, 0x33A7, 0x33A7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x2B67, 0x2B67, 0x2B47, 0x2B47, 0x2B47, 0x2B47, 0x3327, 
        0x3347, 0x3347, 0x3347, 0x3347, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3347, 0x3B47, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 0x4328, 0x4329, 0x4329, 0x4309, 0x4309, 0x4309, 0x4329, 0x432A, 0x4B2A, 0x4B4A, 0x4B4A, 0x4B8A, 0x4BAA, 0x4BCA, 
        0x4BCA, 0x4C0A, 0x4C0A, 0x4C2A, 0x4C2A, 0x544A, 0x544A, 0x5449, 0x5449, 0x5449, 0x5429, 0x5429, 0x5429, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BA9, 0x4BA9, 0x4B89, 0x4B6A, 0x536D, 0x5BD1, 0x63B3, 0x63B4, 0x6BD4, 0x7413, 
        0x7432, 0x7CB1, 0x8D52, 0x8D52, 0x8511, 0x8511, 0x8511, 0x8D32, 0x8D33, 0x7CD2, 0x7473, 0x7473, 0x74B3, 0x74D3, 0x6D13, 0x6532, 0x6572, 0x6571, 0x6D72, 0x6D32, 0x6D12, 0x7513, 0x6CF2, 0x6D12, 0x6D32, 0x6D31, 0x5C8E, 0x3BAA, 0x3B89, 0x3B88, 
        0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3B89, 0x43A9, 0x4389, 0x4389, 0x4369, 0x3B49, 0x3B49, 0x3B29, 0x3B29, 0x4309, 0x3B09, 0x3AE9, 0x3AE9, 0x3ACA, 0x42C9, 0x534B, 0x7C2E, 0x9CD0, 0xB530, 0xBD70, 0xC5B0, 0xB5AF, 0xAD8F, 0xA54E, 0xB56E, 0xBD8F, 
        0xC5AF, 0xC58F, 0xC56F, 0xB50E, 0x9C8E, 0x8C4E, 0x7C6F, 0x6C0D, 0x434A, 0x32E8, 0x2AC7, 0x22C7, 0x22C6, 0x22C6, 0x22E7, 0x2307, 0x2307, 0x2327, 0x2B47, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 
        0x2BC7, 0x2BA8, 0x2BA8, 0x33A8, 0x33A8, 0x33A8, 0x33A8, 0x3BA9, 0x3B89, 0x3B89, 0x3B69, 0x3B49, 0x3349, 0x3329, 0x3328, 0x3328, 0x3329, 0x3309, 0x3309, 0x3309, 0x3309, 0x3309, 0x3309, 0x3329, 0x3329, 0x3329, 0x3309, 0x3309, 0x3309,
  0x4BE8, 0x4BE8, 0x4408, 0x4C6A, 0x448A, 0x3448, 0x3C28, 0x4449, 0x54AC, 0x444A, 0x3C2A, 0x3449, 0x3489, 0x3CCA, 0x3D0B, 0x3D0B, 0x3D2C, 0x3D0C, 0x3D2C, 0x3D2C, 0x3D4C, 0x3D4C, 0x3D4C, 0x454C, 0x454C, 0x4D2D, 0x554D, 0x656E, 0x75F0, 0x8672, 0x8E72, 
        0x7D4E, 0x7CEC, 0x84CC, 0x84AC, 0x84AB, 0x84AB, 0x8C8B, 0x8C8B, 0x948B, 0x948C, 0x8C8C, 0x8C8D, 0x8C6D, 0x846D, 0x846D, 0x7C6E, 0x746E, 0x746D, 0x6C8D, 0x6C8C, 0x6CAC, 0x74CD, 0x6CCD, 0x6CED, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CCC, 0x64CB, 
        0x64CB, 0x64CB, 0x64CB, 0x64CB, 0x5CAB, 0x5CAB, 0x5CAB, 0x5CAB, 0x54AB, 0x54AB, 0x54AB, 0x5C8B, 0x5C6B, 0x644C, 0x640D, 0x5B8C, 0x532B, 0x4B0A, 0x3AC9, 0x3AA8, 0x3AA8, 0x3AC8, 0x4B6A, 0x5C2D, 0x64AF, 0x5CCF, 0x548F, 0x4C2E, 0x4C0E, 0x4C0F, 
        0x542F, 0x5CB0, 0x6D11, 0x7551, 0x7D92, 0x7DD2, 0x8612, 0x9653, 0x9674, 0x8E33, 0x6D50, 0x442C, 0x2B48, 0x1B26, 0x1B05, 0x1AC4, 0x1AA4, 0x1284, 0x1284, 0x1A44, 0x1A04, 0x19E4, 0x19C4, 0x19A4, 0x19A5, 0x19A5, 0x1984, 0x1965, 0x1985, 0x1965, 
        0x1985, 0x21A5, 0x21A5, 0x21C6, 0x21E6, 0x2A06, 0x2A06, 0x2A27, 0x2A47, 0x2A67, 0x32A8, 0x32E9, 0x434A, 0x4BAB, 0x5C2D, 0x646E, 0x6CAE, 0x6CAE, 0x6CAF, 0x6C6F, 0x5C2E, 0x53CE, 0x4B8E, 0x434F, 0x4B90, 0x53D0, 0x53D0, 0x4B8E, 0x32EA, 0x32A9, 
        0x2A88, 0x2A88, 0x2A87, 0x2A87, 0x2266, 0x2266, 0x2246, 0x2226, 0x2246, 0x2246, 0x2266, 0x2A86, 0x2A86, 0x2A86, 0x3286, 0x32A6, 0x32A6, 0x2AC6, 0x32C6, 0x32C6, 0x32E7, 0x32E7, 0x3307, 0x3327, 0x3B47, 0x3B48, 0x3B68, 0x3B88, 0x3B88, 0x3BA8, 
        0x3BC8, 0x3BE8, 0x3C08, 0x4449, 0x4469, 0x4489, 0x4489, 0x44A9, 0x44C9, 0x4CCA, 0x4CEA, 0x4D0A, 0x4D0A, 0x550A, 0x552B, 0x552B, 0x5D2B, 0x5D4B, 0x5D4C, 0x5D4C, 0x5D4C, 0x5D4C, 0x654C, 0x5D4C, 0x5D4C, 0x5D2C, 0x5D0C, 0x5CEC, 0x54AC, 0x548B, 
        0x4C6A, 0x4C4A, 0x440A, 0x43C9, 0x3B89, 0x3B48, 0x3308, 0x32C7, 0x2AA7, 0x2A66, 0x2A26, 0x2226, 0x2226, 0x2A46, 0x2A66, 0x2A87, 0x32A7, 0x32C7, 0x3B07, 0x3B27, 0x3B47, 0x4367, 0x4367, 0x4387, 0x43A7, 0x43A7, 0x43C7, 0x43E7, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE6, 0x3BC7, 0x3BA7, 0x3386, 0x3387, 0x3367, 0x3347, 0x3326, 0x2B07, 0x2AE7, 0x2AC7, 0x2AA7, 0x2A67, 0x2A67, 0x2A47, 0x2A27, 0x2A06, 0x21E6, 0x21C6, 0x21A6, 0x21A6, 0x21A6, 0x21A6, 0x21C6, 0x19C6, 0x19C6, 0x19E6, 
        0x2206, 0x2226, 0x2A46, 0x2A67, 0x2AA7, 0x32C7, 0x3327, 0x3347, 0x3367, 0x3387, 0x33A7, 0x3BA7, 0x33C7, 0x33C7, 0x33C7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BC8, 0x3BC8, 0x3BA8, 0x3388, 0x3B88, 0x3387, 0x3387, 0x3367, 0x3367, 0x3B67, 
        0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B67, 0x3B68, 0x3B67, 0x3B67, 0x3B68, 0x3B68, 0x3B48, 0x3B48, 0x3B48, 0x4348, 0x4328, 0x4329, 0x4329, 0x4329, 0x4309, 0x4309, 0x4309, 0x4B29, 0x4329, 0x4B2A, 0x4B4A, 0x4B6A, 0x4B8A, 0x4BAA, 0x4BCA, 
        0x4BEA, 0x4C0A, 0x4C0A, 0x542A, 0x544A, 0x544A, 0x5449, 0x5429, 0x5429, 0x5429, 0x5429, 0x5429, 0x5409, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BA8, 0x43A8, 0x4389, 0x4389, 0x4389, 0x4B8B, 0x5BD1, 0x6BF4, 0x6BF4, 0x6BD4, 0x7413, 
        0x7432, 0x7CB1, 0x8552, 0x8D52, 0x8511, 0x84F1, 0x8511, 0x8532, 0x8D33, 0x7CD2, 0x7452, 0x7473, 0x74B3, 0x74D3, 0x6D13, 0x6552, 0x6572, 0x6571, 0x6D72, 0x6D32, 0x6D12, 0x74F3, 0x6CF2, 0x6D32, 0x6D52, 0x64F0, 0x440B, 0x3B89, 0x3B89, 0x3BA8, 
        0x3BA8, 0x3BA9, 0x3BA9, 0x43C9, 0x43A9, 0x43A9, 0x43A9, 0x4389, 0x4369, 0x3B69, 0x3B49, 0x3B49, 0x3B29, 0x4309, 0x3B09, 0x3AE9, 0x3AE9, 0x42EA, 0x42E9, 0x6BAC, 0x9CB0, 0xB531, 0xBD50, 0xBDB0, 0xC5AF, 0xBDAF, 0xB58F, 0xAD6E, 0xB56F, 0xBD8F, 
        0xC58F, 0xC56F, 0xBD2E, 0xA4AE, 0x944D, 0x7C4E, 0x6C0D, 0x4B6A, 0x32E8, 0x2AC7, 0x22C7, 0x22C6, 0x22C6, 0x22C6, 0x22E7, 0x22E7, 0x2307, 0x2327, 0x2B47, 0x2B67, 0x2B67, 0x2387, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 
        0x2BE7, 0x2BC8, 0x33C8, 0x33E8, 0x33E8, 0x3BE9, 0x3BC9, 0x3BC9, 0x3BCA, 0x3BA9, 0x3B89, 0x3B69, 0x3369, 0x3349, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3329, 0x3349, 0x3349, 0x3329, 0x3329,
  0x4BA8, 0x4BC8, 0x4BC8, 0x4409, 0x3C08, 0x3408, 0x3408, 0x4449, 0x4C8B, 0x4C6B, 0x3C2A, 0x3449, 0x3C8A, 0x3CCA, 0x3CEB, 0x3D0B, 0x3D0C, 0x3D0C, 0x3D0C, 0x450C, 0x452C, 0x452C, 0x452C, 0x452C, 0x452C, 0x556D, 0x65AE, 0x7610, 0x8691, 0x8EB2, 0x9692, 
        0x7D2D, 0x7CCC, 0x84CC, 0x84CB, 0x84AB, 0x84AB, 0x84AB, 0x848B, 0x8C8B, 0x8C8B, 0x8CAC, 0x8C8C, 0x8C8C, 0x8C6D, 0x846D, 0x846E, 0x7C4E, 0x744D, 0x6C6D, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CCD, 0x6CCD, 0x6CED, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CCC, 
        0x64CB, 0x64CB, 0x64CB, 0x64CB, 0x64AB, 0x5CAB, 0x5CAB, 0x5CAB, 0x5CAB, 0x5CAB, 0x54AB, 0x5C6B, 0x646B, 0x642C, 0x640C, 0x5BAC, 0x536B, 0x4B0A, 0x42E9, 0x3AA9, 0x3AC8, 0x42E9, 0x4B6B, 0x5C2D, 0x64AF, 0x64CF, 0x5CAF, 0x542F, 0x4BEE, 0x4BEF, 
        0x542F, 0x5C8F, 0x64F0, 0x7531, 0x7D92, 0x7DD2, 0x8612, 0x8E53, 0x8E53, 0x8613, 0x6530, 0x3C0B, 0x2368, 0x1B26, 0x1B05, 0x1AE4, 0x1AC4, 0x12A4, 0x1284, 0x1264, 0x1224, 0x1204, 0x11C4, 0x11A4, 0x19A4, 0x1984, 0x1984, 0x1965, 0x1965, 0x1985, 
        0x1985, 0x1985, 0x21A5, 0x21C5, 0x21E6, 0x21E6, 0x2A06, 0x2A27, 0x3247, 0x3288, 0x3AC9, 0x3AA9, 0x32A8, 0x3AE9, 0x4B6B, 0x5BED, 0x642D, 0x642E, 0x642E, 0x5BED, 0x53AD, 0x4B4D, 0x4B4E, 0x4B4F, 0x4B90, 0x53D0, 0x53CF, 0x432C, 0x32AA, 0x2A88, 
        0x2A88, 0x2A87, 0x2A67, 0x2A66, 0x2266, 0x2246, 0x2225, 0x2226, 0x2246, 0x2266, 0x2A86, 0x2AA6, 0x32A6, 0x32A6, 0x32A6, 0x32A6, 0x32A6, 0x32C6, 0x32C6, 0x32C6, 0x32E7, 0x3307, 0x3327, 0x3B27, 0x3B48, 0x3B48, 0x3B68, 0x3B88, 0x3BA8, 0x3BA8, 
        0x3BC8, 0x43E9, 0x4409, 0x4449, 0x4469, 0x4489, 0x44A9, 0x44C9, 0x4CC9, 0x4CCA, 0x4CEA, 0x4D0A, 0x4D0A, 0x550A, 0x552B, 0x5D2B, 0x5D4B, 0x5D4B, 0x5D4C, 0x5D6C, 0x656C, 0x656C, 0x656C, 0x654D, 0x654D, 0x654D, 0x5D0C, 0x5CEC, 0x5CAC, 0x548B, 
        0x546B, 0x4C4A, 0x4C0A, 0x43C9, 0x3B89, 0x3B48, 0x3308, 0x32E7, 0x2AA7, 0x2A86, 0x2A46, 0x2A46, 0x2A46, 0x2A46, 0x2A67, 0x32A7, 0x32C7, 0x3AE7, 0x3B07, 0x3B47, 0x4347, 0x4367, 0x4387, 0x43A7, 0x43A7, 0x43C7, 0x4BE8, 0x4BE8, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x4407, 0x3BE6, 0x3BC7, 0x3BA6, 0x3386, 0x3367, 0x3367, 0x3347, 0x3327, 0x3307, 0x2AE7, 0x2AC7, 0x2AA7, 0x2A67, 0x2A67, 0x2A47, 0x2A27, 0x2A06, 0x21E6, 0x21C6, 0x21A6, 0x21A6, 0x21A6, 0x21C6, 0x21C6, 0x21C7, 0x19C6, 0x21E6, 
        0x2207, 0x2A27, 0x2A47, 0x2A67, 0x32A7, 0x32C7, 0x3307, 0x3328, 0x3B47, 0x3B68, 0x3BA8, 0x3BC8, 0x3BC8, 0x3BE8, 0x3BE8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E9, 0x43E9, 0x43C9, 0x43C9, 0x43A8, 0x3BA8, 0x3BA8, 0x3B88, 0x4388, 
        0x4388, 0x4388, 0x4388, 0x4388, 0x3B88, 0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x4368, 0x4368, 0x4368, 0x4348, 0x4348, 0x4348, 0x4328, 0x4329, 0x4329, 0x4B29, 0x4B09, 0x4B09, 0x4309, 0x4B29, 0x4B2A, 0x4B4A, 0x4B6A, 0x4B8A, 0x4B8A, 0x4BAA, 0x4BCA, 
        0x4BEA, 0x4C0A, 0x4C2A, 0x542A, 0x544A, 0x4C2A, 0x4C29, 0x4C29, 0x5429, 0x5429, 0x5409, 0x5409, 0x5409, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x43C8, 0x43A8, 0x43A8, 0x4388, 0x4388, 0x4388, 0x4389, 0x4B6A, 0x5BAF, 0x6C13, 0x6C14, 0x6BF4, 0x7434, 
        0x7452, 0x7491, 0x8511, 0x8552, 0x8531, 0x8511, 0x8511, 0x8532, 0x8512, 0x7CB2, 0x7452, 0x7473, 0x74B3, 0x74F3, 0x6D33, 0x6552, 0x6572, 0x6571, 0x6D52, 0x6D52, 0x7512, 0x74F2, 0x6CF2, 0x7552, 0x6D32, 0x548E, 0x3BCA, 0x3B89, 0x3BA8, 0x3BA8, 
        0x3BC8, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43A9, 0x4389, 0x3B89, 0x3B69, 0x3B69, 0x3B49, 0x3B49, 0x4329, 0x4309, 0x430A, 0x430A, 0x42EA, 0x530A, 0x7BED, 0xACF0, 0xBD30, 0xCD70, 0xC5AF, 0xC5AF, 0xBDAF, 0xBD8F, 0xB56E, 0xBD6F, 0xC58F, 
        0xC56F, 0xBD4E, 0xACED, 0x942D, 0x7C0D, 0x742E, 0x5B8C, 0x3AE8, 0x2AC7, 0x22C7, 0x22C7, 0x22C7, 0x22C6, 0x22E7, 0x22E7, 0x2307, 0x2307, 0x2327, 0x2B48, 0x2367, 0x2367, 0x2387, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 
        0x2BE8, 0x33E8, 0x3409, 0x3C09, 0x3C09, 0x3C09, 0x3C09, 0x3BEA, 0x3BEA, 0x3BCA, 0x3BA9, 0x3B89, 0x3B89, 0x3B69, 0x3349, 0x3349, 0x3349, 0x3329, 0x3329, 0x3329, 0x3329, 0x3349, 0x3349, 0x3349, 0x3369, 0x3369, 0x3369, 0x3369, 0x3369,
  0x53A8, 0x4BA8, 0x4BA8, 0x4BE8, 0x4C49, 0x4469, 0x4469, 0x4C8A, 0x446A, 0x446A, 0x3C4A, 0x3449, 0x3469, 0x348A, 0x34AA, 0x3CAB, 0x3CAB, 0x3CCB, 0x3CEB, 0x450C, 0x452C, 0x4D4C, 0x4D6D, 0x558D, 0x5DCE, 0x65EF, 0x6E30, 0x7E70, 0x86D1, 0x8ED2, 0x9692, 
        0x7D0D, 0x7CEC, 0x8CCC, 0x84CC, 0x84CB, 0x84AB, 0x84AB, 0x84AB, 0x84AB, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C6C, 0x8C8D, 0x846D, 0x846E, 0x7C4D, 0x746D, 0x746D, 0x746D, 0x748D, 0x6CAD, 0x6CAD, 0x6CED, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CCC, 
        0x6CCC, 0x6CCB, 0x64CB, 0x64CB, 0x64CB, 0x64CB, 0x64CB, 0x5CCB, 0x5CAB, 0x5CAB, 0x5C8B, 0x5C8B, 0x646B, 0x642C, 0x63EC, 0x63CC, 0x5B6C, 0x4B0A, 0x42E9, 0x42C9, 0x3AC8, 0x42E9, 0x4B6B, 0x642E, 0x6CAF, 0x64CF, 0x64AF, 0x544F, 0x4C0E, 0x4BEE, 
        0x4C0F, 0x546F, 0x64B0, 0x6D11, 0x7571, 0x7DB2, 0x85F2, 0x8E33, 0x8E53, 0x7E12, 0x652F, 0x3C2B, 0x2368, 0x1B26, 0x1B25, 0x1B05, 0x12E4, 0x12C4, 0x12A4, 0x1264, 0x1244, 0x1204, 0x11E4, 0x11C4, 0x11A4, 0x1184, 0x1984, 0x1964, 0x1964, 0x1965, 
        0x1965, 0x1985, 0x2185, 0x21A5, 0x21C6, 0x21E6, 0x2A06, 0x2A06, 0x2A27, 0x3A88, 0x3A89, 0x3268, 0x3248, 0x3268, 0x3AA9, 0x534C, 0x5B6C, 0x538C, 0x538D, 0x536D, 0x4B2D, 0x430D, 0x4B2F, 0x4B70, 0x53B1, 0x53D0, 0x4B8E, 0x3AEB, 0x3289, 0x3268, 
        0x2A68, 0x2A67, 0x2A47, 0x2A46, 0x2226, 0x2226, 0x2226, 0x2246, 0x2246, 0x2A66, 0x2A86, 0x32A6, 0x32A6, 0x32A6, 0x32A6, 0x32C6, 0x3AC7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B27, 0x3B47, 0x3B48, 0x3B68, 0x3B68, 0x3B88, 0x3BA8, 0x43A9, 
        0x43C9, 0x43E9, 0x4429, 0x4449, 0x4469, 0x4489, 0x4CA9, 0x4CA9, 0x4CCA, 0x4CCA, 0x4CEA, 0x4CEA, 0x4CEA, 0x550A, 0x550B, 0x552B, 0x5D2B, 0x5D4C, 0x5D4C, 0x654C, 0x654C, 0x656C, 0x656D, 0x654C, 0x654C, 0x654C, 0x650C, 0x64EC, 0x5CCC, 0x54AB, 
        0x546A, 0x4C4A, 0x4C0A, 0x43C9, 0x4389, 0x3B68, 0x3B28, 0x32E8, 0x32C7, 0x2AA7, 0x2A67, 0x2A67, 0x2A67, 0x2A87, 0x32A7, 0x32C7, 0x32E8, 0x3B08, 0x3B27, 0x3B47, 0x4367, 0x4387, 0x43A7, 0x43A7, 0x4BC8, 0x4BE8, 0x4BE7, 0x4C07, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x3C07, 0x3BE7, 0x3BC7, 0x3BA7, 0x3387, 0x3367, 0x3366, 0x3347, 0x3326, 0x3307, 0x2AE7, 0x2AA7, 0x2A87, 0x2A67, 0x2A67, 0x2A47, 0x2A27, 0x2207, 0x21E6, 0x21C6, 0x21C6, 0x21A6, 0x21A6, 0x21A6, 0x21A6, 0x21A7, 0x21C7, 0x21E7, 
        0x21E7, 0x2A07, 0x2A47, 0x3268, 0x3288, 0x3AC9, 0x434A, 0x434A, 0x4349, 0x4369, 0x43A9, 0x43C9, 0x43E9, 0x43E9, 0x4409, 0x4C29, 0x4C29, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4BE9, 0x4BE9, 0x4BC9, 0x4BC9, 0x43C9, 0x43C9, 0x43A9, 0x43A9, 
        0x43A8, 0x43A8, 0x43A9, 0x43A9, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4368, 0x4368, 0x4368, 0x4348, 0x4348, 0x4329, 0x4329, 0x4329, 0x4309, 0x4B09, 0x4B09, 0x4B09, 0x4B2A, 0x4B4A, 0x4B4A, 0x4B6A, 0x4B8A, 0x4BAA, 0x4BCA, 0x4BEA, 
        0x4BEA, 0x4C0A, 0x4C0A, 0x4C2A, 0x544A, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x5409, 0x4C09, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x43A8, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x436A, 0x538E, 0x6412, 0x6BF4, 0x6BF4, 0x7414, 
        0x7452, 0x7490, 0x7D11, 0x8552, 0x8551, 0x8511, 0x8511, 0x8512, 0x84F2, 0x7C71, 0x7452, 0x7453, 0x6C93, 0x6CF3, 0x6532, 0x6552, 0x6552, 0x6551, 0x6D51, 0x6D32, 0x6D12, 0x6CF2, 0x6D12, 0x7552, 0x6510, 0x4C2C, 0x3BC9, 0x3BA9, 0x3BC8, 0x3BC8, 
        0x3BC9, 0x43C9, 0x43C9, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x3BA9, 0x3B89, 0x3B69, 0x3B69, 0x3B69, 0x4349, 0x4349, 0x4329, 0x4309, 0x430A, 0x4B0A, 0x6B8C, 0x948F, 0xB510, 0xC550, 0xCD8F, 0xCDAF, 0xC5AF, 0xC5AF, 0xBD8E, 0xBD8E, 0xBD6F, 0xBD6F, 
        0xBD4E, 0xAD0E, 0x9C8D, 0x7C0D, 0x6BCD, 0x5BAC, 0x4B09, 0x32C7, 0x2AC7, 0x22C6, 0x22C7, 0x22E6, 0x22E7, 0x2307, 0x2307, 0x2307, 0x2327, 0x2B47, 0x2B48, 0x2B67, 0x2B67, 0x2387, 0x2B87, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 0x2BE7, 0x33E8, 0x3408, 
        0x3408, 0x3429, 0x3429, 0x3C29, 0x3C29, 0x3C29, 0x440A, 0x440A, 0x43EA, 0x43CA, 0x43C9, 0x3BA9, 0x3B89, 0x3B89, 0x3369, 0x3349, 0x3349, 0x3349, 0x3348, 0x3348, 0x3348, 0x3348, 0x3348, 0x3368, 0x3B89, 0x3B89, 0x3BA9, 0x3BA9, 0x3BA9,
  0x4B87, 0x4BA7, 0x4B87, 0x4BC8, 0x546A, 0x54CA, 0x54CA, 0x4CAB, 0x4C8B, 0x446A, 0x3C4A, 0x3C6A, 0x3C8A, 0x3CAA, 0x3CCB, 0x44CB, 0x44EC, 0x450C, 0x4D4D, 0x558E, 0x55AE, 0x5DCE, 0x660F, 0x662F, 0x6E4F, 0x7670, 0x7E90, 0x86B1, 0x86F1, 0x8ED2, 0x9672, 
        0x7D0D, 0x84EC, 0x8CEC, 0x84EC, 0x84CC, 0x84CB, 0x84AB, 0x84AB, 0x84AB, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8D, 0x848D, 0x7C6D, 0x7C6E, 0x744D, 0x746D, 0x746D, 0x6C6D, 0x6CAD, 0x6CCD, 0x74ED, 0x74EC, 0x74EC, 0x74EC, 0x74EC, 
        0x6CEC, 0x6CCC, 0x6CCC, 0x6CCC, 0x6CCC, 0x64CC, 0x64CB, 0x5CCB, 0x5CCB, 0x5CAB, 0x5C8B, 0x5C6B, 0x644C, 0x642C, 0x63EC, 0x6BCD, 0x5B6C, 0x4B2A, 0x4B0A, 0x42E9, 0x42E9, 0x42E9, 0x536B, 0x644E, 0x6CCF, 0x6CF0, 0x64B0, 0x5C6F, 0x4C0E, 0x43CE, 
        0x4BEE, 0x544F, 0x5C90, 0x6CF1, 0x7551, 0x7592, 0x7DD2, 0x8633, 0x8633, 0x7DF2, 0x652F, 0x3C2B, 0x2367, 0x1B46, 0x1B46, 0x1325, 0x1304, 0x12C4, 0x12A4, 0x1284, 0x1264, 0x1224, 0x1204, 0x11C4, 0x11A4, 0x1184, 0x1984, 0x1964, 0x1164, 0x1164, 
        0x1964, 0x1964, 0x1985, 0x2185, 0x21A5, 0x21C5, 0x21E6, 0x2A06, 0x2A27, 0x3268, 0x3268, 0x3248, 0x3248, 0x3248, 0x3A89, 0x4AEB, 0x4B0B, 0x4B0B, 0x4B0C, 0x4B0C, 0x4B2D, 0x430E, 0x4B4F, 0x5390, 0x53D1, 0x53D0, 0x4B4D, 0x32AA, 0x3268, 0x2A48, 
        0x2A47, 0x2A47, 0x2A26, 0x2A26, 0x2226, 0x2225, 0x2226, 0x2226, 0x2246, 0x2A66, 0x2A86, 0x32A6, 0x32C6, 0x3AC6, 0x3AC7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3AE7, 0x3AE7, 0x3B07, 0x4327, 0x4347, 0x4348, 0x3B48, 0x4368, 0x4388, 0x4388, 
        0x43C9, 0x43E9, 0x4409, 0x4429, 0x4449, 0x4C69, 0x4C89, 0x4CA9, 0x4CAA, 0x4CC9, 0x4CCA, 0x4CCA, 0x4CEA, 0x4CEA, 0x550A, 0x550B, 0x552B, 0x5D2B, 0x5D4C, 0x654C, 0x654C, 0x654C, 0x654C, 0x654C, 0x654C, 0x652C, 0x650C, 0x5CEC, 0x5CCC, 0x548B, 
        0x546B, 0x4C4A, 0x4C0A, 0x43C9, 0x4389, 0x3B69, 0x3B28, 0x3308, 0x32C7, 0x32A7, 0x3287, 0x2A87, 0x3287, 0x3287, 0x32A7, 0x32C7, 0x3AE8, 0x3B08, 0x3B28, 0x3B48, 0x4367, 0x4387, 0x43A8, 0x4BC8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C07, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BA7, 0x3B87, 0x3387, 0x3367, 0x3366, 0x3327, 0x3326, 0x3307, 0x32E7, 0x2AC7, 0x2AA7, 0x2A87, 0x2A67, 0x2A47, 0x2A27, 0x2207, 0x21E7, 0x21E7, 0x21C7, 0x21A7, 0x21A6, 0x21A6, 0x21A7, 0x21A7, 0x21C7, 0x29C7, 
        0x29E8, 0x29E8, 0x3228, 0x42AA, 0x6BD0, 0x8CD5, 0x9537, 0x8D16, 0x7CB3, 0x6C50, 0x53CC, 0x4BCA, 0x4BEA, 0x4BEA, 0x4C0A, 0x542A, 0x542A, 0x540A, 0x540A, 0x540A, 0x540A, 0x540A, 0x540A, 0x53EA, 0x53EA, 0x4BEA, 0x4BEA, 0x4BC9, 0x4BC9, 0x4BA9, 
        0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x43A9, 0x4B89, 0x43A8, 0x4B89, 0x4B89, 0x4389, 0x4368, 0x4368, 0x4348, 0x4349, 0x4329, 0x4329, 0x4329, 0x4309, 0x4B09, 0x4B09, 0x4B09, 0x4B2A, 0x4B4A, 0x4B4A, 0x538A, 0x538A, 0x4BAA, 0x53EA, 0x53EA, 
        0x4C0A, 0x4C0A, 0x4C0A, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4C09, 0x4C09, 0x4BE8, 0x4BE8, 0x4BC8, 0x43C8, 0x43A8, 0x4388, 0x4368, 0x3B68, 0x3B48, 0x3B68, 0x3B68, 0x3B67, 0x4368, 0x4349, 0x538D, 0x63F1, 0x63D4, 0x6BF4, 0x6BF4, 
        0x7432, 0x7490, 0x7CF0, 0x8572, 0x8551, 0x7D31, 0x8511, 0x8512, 0x84D2, 0x7C52, 0x7412, 0x7432, 0x6C93, 0x64F3, 0x6532, 0x6552, 0x6532, 0x6531, 0x6D52, 0x6D32, 0x6D12, 0x6D12, 0x7532, 0x6D32, 0x5CAE, 0x3BEB, 0x33C9, 0x3BC9, 0x3BC9, 0x3BE9, 
        0x3BE9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43C9, 0x3BC9, 0x3BA9, 0x3BA9, 0x3B89, 0x3B89, 0x4369, 0x4369, 0x4369, 0x4349, 0x4349, 0x432A, 0x4B4B, 0x7C2E, 0xA4F0, 0xBD30, 0xC56F, 0xC58F, 0xCDAF, 0xC5AF, 0xC5AF, 0xC5AF, 0xC58F, 0xBD6F, 0xBD4F, 
        0xB52E, 0xA4CE, 0x8C4D, 0x6BCC, 0x534B, 0x430A, 0x32C8, 0x2AA7, 0x22A7, 0x22C6, 0x22C6, 0x22E6, 0x22E7, 0x2307, 0x2B07, 0x2327, 0x2327, 0x2B47, 0x2B68, 0x2B67, 0x2B67, 0x2B87, 0x2BA7, 0x2BC7, 0x2BC7, 0x2BC7, 0x2BE7, 0x3408, 0x3408, 0x3428, 
        0x3429, 0x3C49, 0x3C49, 0x3C4A, 0x444A, 0x444A, 0x442A, 0x440A, 0x440A, 0x43E9, 0x43C9, 0x3BC9, 0x3BA9, 0x3B89, 0x3389, 0x3369, 0x3348, 0x3348, 0x3348, 0x3348, 0x3348, 0x3348, 0x3368, 0x3B88, 0x3BA9, 0x3BA9, 0x3BC9, 0x3BC9, 0x3BE9,
  0x4B87, 0x4B87, 0x4B87, 0x4B87, 0x5449, 0x5CCA, 0x54EB, 0x54CB, 0x4CCB, 0x4CCB, 0x4CCB, 0x4CCC, 0x4CEC, 0x4D2C, 0x552D, 0x554D, 0x556D, 0x556D, 0x5DAE, 0x65EE, 0x662F, 0x664F, 0x6E50, 0x6E70, 0x6E70, 0x76B0, 0x7EB0, 0x7ED1, 0x86F1, 0x8EF2, 0x8E51, 
        0x7CEC, 0x84CC, 0x8CCC, 0x84CC, 0x84CC, 0x84CC, 0x84CB, 0x84AB, 0x84AB, 0x848B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8CAC, 0x8C8C, 0x848D, 0x848D, 0x7C6D, 0x7C4D, 0x6C4D, 0x6C4D, 0x6C6D, 0x6CAD, 0x74CD, 0x74ED, 0x74EC, 0x74EC, 0x74EC, 
        0x6CEC, 0x6CEC, 0x6CEC, 0x6CCC, 0x6CCC, 0x64CC, 0x64CC, 0x64CB, 0x64CB, 0x5CAB, 0x5CAB, 0x5C6B, 0x644B, 0x642C, 0x63EC, 0x63CC, 0x5B8B, 0x532A, 0x4B2A, 0x4309, 0x4309, 0x4329, 0x538B, 0x6C4E, 0x74D0, 0x6CF0, 0x64D0, 0x5C6F, 0x540F, 0x4BCE, 
        0x4BCE, 0x542F, 0x5C70, 0x64D0, 0x6D11, 0x7572, 0x7DB2, 0x85F2, 0x8612, 0x75B2, 0x5D0F, 0x3C0B, 0x2368, 0x1B46, 0x1B46, 0x1B45, 0x1B04, 0x12E4, 0x12C4, 0x12A4, 0x1264, 0x1244, 0x1204, 0x11E4, 0x11C4, 0x11A4, 0x1164, 0x1144, 0x1144, 0x1144, 
        0x1144, 0x1964, 0x1964, 0x1985, 0x2185, 0x21C5, 0x21E6, 0x2A06, 0x2A27, 0x3247, 0x3248, 0x3228, 0x3228, 0x3248, 0x3A69, 0x42AA, 0x42CA, 0x42CA, 0x42CB, 0x4B0C, 0x4B2E, 0x4B2E, 0x4B4F, 0x5391, 0x53B0, 0x53AF, 0x430C, 0x3269, 0x3248, 0x2A47, 
        0x2A47, 0x2A26, 0x2A26, 0x2206, 0x2206, 0x2226, 0x2226, 0x2246, 0x2A66, 0x2A66, 0x32A6, 0x32A6, 0x3AE6, 0x3AE7, 0x3AE7, 0x3AE7, 0x4307, 0x4307, 0x4307, 0x4307, 0x3B07, 0x3AE7, 0x3B07, 0x3B07, 0x4327, 0x3B27, 0x3B48, 0x3B48, 0x4368, 0x4388, 
        0x43A8, 0x43C8, 0x43E9, 0x4429, 0x4449, 0x4469, 0x4C89, 0x4C89, 0x4CA9, 0x4CA9, 0x4CC9, 0x4CCA, 0x4CCA, 0x4CEA, 0x550A, 0x550B, 0x552B, 0x5D2B, 0x5D4B, 0x654C, 0x654C, 0x654C, 0x654D, 0x654C, 0x654C, 0x652C, 0x5D0C, 0x5CEB, 0x5CAB, 0x54AB, 
        0x546B, 0x4C4A, 0x4C0A, 0x43C9, 0x4389, 0x3B69, 0x3B28, 0x3308, 0x32C7, 0x32A7, 0x3287, 0x3287, 0x3287, 0x3287, 0x32A7, 0x32C7, 0x3AE7, 0x3B08, 0x3B28, 0x4368, 0x4388, 0x43A8, 0x43C8, 0x4BC8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C07, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BA7, 0x3B87, 0x3387, 0x3367, 0x3366, 0x3347, 0x3327, 0x3327, 0x32E7, 0x32C7, 0x32A7, 0x2A87, 0x3267, 0x2A67, 0x2A47, 0x2A07, 0x21E7, 0x21E7, 0x21C7, 0x19A7, 0x21A7, 0x21A7, 0x21A7, 0x21A7, 0x2187, 0x21A8, 
        0x320A, 0x4AAD, 0x6BB3, 0x8C98, 0x94BA, 0x949C, 0x94BC, 0x94BB, 0x94BA, 0x94F8, 0x7C94, 0x640E, 0x5BCC, 0x53EB, 0x540B, 0x542A, 0x542A, 0x542B, 0x540B, 0x540B, 0x540B, 0x540A, 0x53EA, 0x53EA, 0x53EA, 0x53EA, 0x53EA, 0x4BCA, 0x4BC9, 0x4BA9, 
        0x4BA9, 0x4BC9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA8, 0x4BA9, 0x4B88, 0x4389, 0x4369, 0x4369, 0x4349, 0x4329, 0x4329, 0x4B29, 0x4B29, 0x4B09, 0x4B09, 0x4B2A, 0x4B2A, 0x4B4A, 0x4B6A, 0x4B8B, 0x538B, 0x4BAA, 0x53EA, 0x53EA, 
        0x4C0A, 0x4C0A, 0x4C0A, 0x4C09, 0x4C09, 0x4C09, 0x4C08, 0x4C09, 0x4C08, 0x4BE9, 0x4BE8, 0x4BE8, 0x43C8, 0x43A8, 0x4388, 0x4388, 0x3B68, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B47, 0x3B47, 0x3B48, 0x4349, 0x4B4C, 0x63D0, 0x63D3, 0x6BD4, 0x6BF3, 
        0x7432, 0x7490, 0x7CF0, 0x8572, 0x8551, 0x7D31, 0x8511, 0x8512, 0x7CB2, 0x7432, 0x7432, 0x6C53, 0x6CB3, 0x6D13, 0x6532, 0x6552, 0x6532, 0x6512, 0x6D32, 0x6D12, 0x6D12, 0x6D12, 0x6D32, 0x6511, 0x4C4D, 0x33CA, 0x33C9, 0x3BC9, 0x3BC9, 0x3BE9, 
        0x3BE9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x3BC9, 0x3BC9, 0x3BA9, 0x3BA9, 0x4389, 0x4389, 0x4389, 0x4369, 0x436A, 0x434A, 0x434A, 0x536B, 0x8C6E, 0xB530, 0xC550, 0xC58F, 0xC5AF, 0xC5AF, 0xC5AF, 0xC5AF, 0xC5AF, 0xC58F, 0xBD6F, 0xB52E, 
        0xACEE, 0x948E, 0x73EC, 0x5B4B, 0x3AC9, 0x32A8, 0x2AA7, 0x2AA7, 0x22A7, 0x22C6, 0x22C6, 0x22E6, 0x2307, 0x2307, 0x2327, 0x2327, 0x2347, 0x2367, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BC7, 0x33E8, 0x3428, 0x3C28, 0x3C49, 
        0x3C49, 0x4469, 0x4469, 0x446A, 0x446A, 0x4C4A, 0x4C4A, 0x442A, 0x440A, 0x43EA, 0x43E9, 0x43C9, 0x3BC9, 0x3BA9, 0x3389, 0x3389, 0x3369, 0x3348, 0x3348, 0x3348, 0x3348, 0x3368, 0x3368, 0x3B88, 0x3BA9, 0x3BC8, 0x3BC9, 0x3BC9, 0x3BE9,
  0x4B67, 0x4B67, 0x4B67, 0x4366, 0x4C08, 0x5CCB, 0x5CEB, 0x5CEB, 0x54EC, 0x550C, 0x550C, 0x550C, 0x552D, 0x556D, 0x5D8D, 0x5DAD, 0x5DAD, 0x5DCE, 0x660E, 0x662F, 0x664F, 0x6E6F, 0x6E90, 0x6E90, 0x76B0, 0x76D0, 0x76D0, 0x7ED1, 0x86F2, 0x8ED3, 0x85F0, 
        0x7CCC, 0x84CC, 0x84CC, 0x84CC, 0x84CC, 0x84CC, 0x7CAB, 0x84AB, 0x84AB, 0x848B, 0x848B, 0x8C8B, 0x8C8B, 0x8CAB, 0x8CAB, 0x8C8B, 0x8CAC, 0x8CAD, 0x8CAD, 0x848D, 0x7C6D, 0x744D, 0x6C4D, 0x6C4D, 0x6C8D, 0x74CD, 0x74CD, 0x74CC, 0x74CC, 0x74EC, 
        0x74EC, 0x74EC, 0x6CEC, 0x74CC, 0x6CEC, 0x6CEC, 0x64CC, 0x64CB, 0x64CC, 0x64AB, 0x648B, 0x5C6B, 0x5C4B, 0x640C, 0x640C, 0x63CC, 0x5B8B, 0x4B4A, 0x4B4A, 0x4329, 0x4329, 0x4329, 0x538B, 0x6C4E, 0x74D0, 0x7510, 0x6CF0, 0x6490, 0x5C2F, 0x53EF, 
        0x4BAE, 0x540F, 0x5C4F, 0x6490, 0x6CF1, 0x7531, 0x7D92, 0x85B2, 0x7DD2, 0x7571, 0x5CCE, 0x33EA, 0x2367, 0x1B46, 0x1B45, 0x1B45, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x1284, 0x1264, 0x1224, 0x11E4, 0x11C4, 0x11A4, 0x1184, 0x1144, 0x1143, 0x1143, 
        0x1143, 0x1143, 0x1964, 0x1964, 0x1985, 0x21A5, 0x21C6, 0x2A06, 0x2A27, 0x3247, 0x3247, 0x2A28, 0x3228, 0x3228, 0x3268, 0x3A69, 0x3A89, 0x3A89, 0x42AA, 0x4AEC, 0x532E, 0x4B2F, 0x4B50, 0x5391, 0x53B0, 0x53AF, 0x3AEC, 0x3268, 0x3247, 0x2A27, 
        0x2A26, 0x2A06, 0x2A06, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 0x2A66, 0x2A86, 0x32A6, 0x32C7, 0x3AE7, 0x3AE7, 0x4307, 0x4327, 0x4328, 0x4327, 0x4327, 0x4327, 0x4307, 0x3AE7, 0x3B07, 0x3B07, 0x4307, 0x3B07, 0x3B28, 0x4328, 0x4348, 0x4368, 
        0x4388, 0x43A8, 0x43C9, 0x4409, 0x4429, 0x4449, 0x4C69, 0x4C89, 0x4CA9, 0x4CA9, 0x4CA9, 0x4CC9, 0x4CC9, 0x4CCA, 0x54EA, 0x550B, 0x550B, 0x5D2B, 0x5D4B, 0x5D4C, 0x654C, 0x654C, 0x654C, 0x654C, 0x652C, 0x652C, 0x5D0C, 0x5CEB, 0x5CCB, 0x548B, 
        0x546A, 0x4C4A, 0x4C0A, 0x43C9, 0x4389, 0x3B48, 0x3B28, 0x32E8, 0x32C7, 0x32A7, 0x32A6, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x32C7, 0x3AE7, 0x3B08, 0x3B48, 0x4368, 0x4388, 0x43A8, 0x43C8, 0x4BC8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C07, 0x4407, 0x4407, 
        0x4407, 0x4407, 0x3BE7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3387, 0x3367, 0x3366, 0x3347, 0x3347, 0x3327, 0x3307, 0x32E7, 0x32C7, 0x32A7, 0x3288, 0x2A67, 0x2A47, 0x2A27, 0x2A07, 0x21E7, 0x21E7, 0x21C7, 0x21A7, 0x2187, 0x2187, 0x320B, 0x6351, 0x7BF5, 
        0x8C57, 0x949A, 0x945C, 0x943D, 0x941D, 0x8C1D, 0x8C1E, 0x8C1E, 0x8C1D, 0x8C3B, 0x949A, 0x8CB7, 0x7C94, 0x6C10, 0x5BED, 0x5C0C, 0x5C0B, 0x5C0B, 0x5C0B, 0x5C0B, 0x5C0B, 0x5C0B, 0x5BEB, 0x5BEB, 0x5BEB, 0x5BEB, 0x53CB, 0x53CA, 0x53CA, 0x4BA9, 
        0x4BCA, 0x53CA, 0x53CA, 0x53C9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x4B89, 0x4389, 0x4369, 0x4B49, 0x4B49, 0x4B49, 0x4B29, 0x4B29, 0x4B09, 0x4B0A, 0x4B2A, 0x4B2A, 0x4B4A, 0x4B6B, 0x4B8B, 0x4BAB, 0x4BAA, 0x53CA, 0x53CA, 
        0x4BEA, 0x4C0A, 0x4BEA, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C08, 0x4BE8, 0x4BE9, 0x4BC8, 0x43A8, 0x43A8, 0x4388, 0x3B68, 0x3B48, 0x3B48, 0x3B28, 0x3307, 0x3307, 0x3308, 0x3B27, 0x3B48, 0x3B48, 0x4349, 0x4B6B, 0x5BAF, 0x63B3, 0x6BD4, 0x7414, 
        0x7453, 0x7491, 0x7CF0, 0x7D52, 0x7D51, 0x7D31, 0x8511, 0x8512, 0x7CB2, 0x7432, 0x7452, 0x7493, 0x74D4, 0x6D13, 0x6532, 0x6532, 0x6511, 0x6CF2, 0x6CF2, 0x6D12, 0x6D12, 0x6D32, 0x6D32, 0x5CAF, 0x3BEB, 0x33A9, 0x33C9, 0x3BC9, 0x3BE9, 0x3BE9, 
        0x3BE9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x3BC9, 0x43E9, 0x3BC9, 0x43CA, 0x43CA, 0x43AA, 0x43AA, 0x4B8A, 0x4B8A, 0x4B6A, 0x4B6A, 0x5B8B, 0x948E, 0xBD51, 0xCD70, 0xC5AF, 0xCDAF, 0xC5CF, 0xC5AF, 0xC5AF, 0xC5AF, 0xBD6F, 0xBD4E, 0xAD0E, 
        0x9CAD, 0x842E, 0x638C, 0x42C9, 0x3288, 0x2A87, 0x2AA6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x2307, 0x2307, 0x2327, 0x2347, 0x2347, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2BA8, 0x2BC8, 0x33C8, 0x33E8, 0x3C08, 0x3C29, 0x3C49, 0x3C69, 
        0x4469, 0x4C8A, 0x4C8A, 0x4C8A, 0x4C8A, 0x4C6A, 0x4C4A, 0x4C4A, 0x442A, 0x4C0A, 0x43E9, 0x43E9, 0x3BC9, 0x3BA9, 0x3BA9, 0x3389, 0x3389, 0x3369, 0x3348, 0x3348, 0x3348, 0x3368, 0x3368, 0x3B88, 0x3BC9, 0x3BC8, 0x43E9, 0x43E9, 0x43E9,
  0x4367, 0x4346, 0x4347, 0x4346, 0x3B86, 0x5CCB, 0x5CEB, 0x5D0B, 0x550C, 0x552C, 0x552C, 0x554C, 0x556D, 0x558D, 0x5DAD, 0x5DCD, 0x5DED, 0x5E0E, 0x662E, 0x664E, 0x666F, 0x6E8F, 0x6EAF, 0x6EB0, 0x76D0, 0x76D0, 0x76D0, 0x7ED0, 0x86D2, 0x8E93, 0x7D2E, 
        0x7C8C, 0x7C8C, 0x848C, 0x84AC, 0x84AC, 0x84AC, 0x84AC, 0x7CAB, 0x84AB, 0x84AB, 0x84AB, 0x84AB, 0x84AB, 0x84AB, 0x84AB, 0x8C8B, 0x8C8C, 0x8CAC, 0x8CAD, 0x848D, 0x846D, 0x7C4E, 0x744E, 0x744E, 0x6C6D, 0x6CAD, 0x6CCD, 0x6CCC, 0x6CCC, 0x74CC, 
        0x74CC, 0x74EC, 0x6CEC, 0x74EC, 0x6CEC, 0x6CEC, 0x6CEC, 0x6CCC, 0x64CB, 0x64AB, 0x648B, 0x5C6B, 0x5C4B, 0x642C, 0x640C, 0x63EC, 0x538B, 0x4B6A, 0x4B4A, 0x4349, 0x4329, 0x4329, 0x4B6A, 0x642D, 0x6CAF, 0x74F0, 0x74F1, 0x6CB0, 0x5C50, 0x540F, 
        0x4BCE, 0x4BEE, 0x544F, 0x5C70, 0x64D0, 0x7511, 0x7D72, 0x85B2, 0x7D92, 0x6D31, 0x548D, 0x33CA, 0x2367, 0x1B66, 0x1B45, 0x1345, 0x1324, 0x1324, 0x1304, 0x12C4, 0x12A4, 0x1264, 0x1244, 0x1203, 0x11E3, 0x11A3, 0x1184, 0x1163, 0x1143, 0x1143, 
        0x1143, 0x1143, 0x1944, 0x1964, 0x1965, 0x19A5, 0x21C6, 0x29E6, 0x2A06, 0x2A27, 0x2A47, 0x2A27, 0x3228, 0x3248, 0x3248, 0x3A69, 0x3A69, 0x3A69, 0x42AA, 0x4AEC, 0x532E, 0x534F, 0x4B70, 0x53B0, 0x53D0, 0x4B6E, 0x3ACB, 0x3269, 0x3247, 0x2A27, 
        0x2A06, 0x21E6, 0x21E6, 0x2206, 0x2206, 0x2226, 0x2226, 0x2246, 0x2A66, 0x2A86, 0x32A6, 0x3AE7, 0x3AE7, 0x3AE7, 0x4307, 0x4328, 0x4328, 0x4328, 0x4328, 0x4328, 0x4308, 0x4307, 0x3AE7, 0x3AE7, 0x42E7, 0x3AE7, 0x3B07, 0x4308, 0x4328, 0x4348, 
        0x4388, 0x43A8, 0x43C8, 0x43E8, 0x4408, 0x4428, 0x4449, 0x4C89, 0x4C89, 0x4CA9, 0x4CA9, 0x4CC9, 0x4CCA, 0x4CCA, 0x54EA, 0x54EA, 0x550B, 0x5D0B, 0x5D2B, 0x5D2C, 0x5D2C, 0x652C, 0x652C, 0x652C, 0x652C, 0x650C, 0x5CEB, 0x5CCB, 0x5CAB, 0x548B, 
        0x546B, 0x4C4A, 0x4C0A, 0x43E9, 0x4389, 0x3B68, 0x3B28, 0x3307, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x3AC7, 0x3AE7, 0x3B28, 0x3B48, 0x4368, 0x4388, 0x43A7, 0x43C8, 0x4BC8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE7, 0x4408, 0x4407, 
        0x4407, 0x3C07, 0x3BE7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3387, 0x3367, 0x3367, 0x3347, 0x3347, 0x3347, 0x3328, 0x3308, 0x32E8, 0x32C8, 0x32A8, 0x32A8, 0x3288, 0x3248, 0x2A28, 0x2A08, 0x29E8, 0x21A7, 0x2188, 0x3A2C, 0x6B93, 0x8C59, 0x947B, 0x943B, 
        0x8C3C, 0x8BFD, 0x8BDE, 0x8BDE, 0x8BDE, 0x83DE, 0x83DE, 0x83DE, 0x83DE, 0x83DE, 0x8BFD, 0x8C3C, 0x8C7B, 0x8CB8, 0x8494, 0x7C72, 0x7C71, 0x7C71, 0x7C91, 0x7471, 0x7470, 0x7450, 0x6C30, 0x6C2F, 0x640E, 0x63EC, 0x5BEB, 0x5BCB, 0x5BCB, 0x53CA, 
        0x53CA, 0x53CA, 0x53CA, 0x53C9, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BA9, 0x4BA9, 0x4B89, 0x4B89, 0x4369, 0x4369, 0x4B49, 0x4B49, 0x4B49, 0x4B29, 0x4B29, 0x4309, 0x4B2A, 0x4B2A, 0x4B2A, 0x4B4B, 0x4B6C, 0x538D, 0x5BCE, 0x53CE, 0x53CD, 0x53CC, 
        0x4BCB, 0x4BCB, 0x4BCA, 0x4BEA, 0x4BE9, 0x4C09, 0x43E9, 0x4BE9, 0x43E8, 0x43C8, 0x43A8, 0x4388, 0x4368, 0x4348, 0x3B48, 0x3B28, 0x3B08, 0x3B08, 0x32E8, 0x32E8, 0x32E8, 0x3307, 0x3B28, 0x3B48, 0x4369, 0x4B6B, 0x5BAF, 0x63B2, 0x63D4, 0x7435, 
        0x7473, 0x7491, 0x74F0, 0x7D51, 0x7D51, 0x7D31, 0x8512, 0x84F2, 0x7451, 0x7431, 0x7472, 0x74B3, 0x74F3, 0x7533, 0x6D32, 0x6512, 0x64D2, 0x64D2, 0x6CF2, 0x6D12, 0x6D32, 0x6D32, 0x6511, 0x4C4C, 0x3BC9, 0x33A9, 0x33C9, 0x3BE9, 0x3BE9, 0x3BE9, 
        0x3BE9, 0x4409, 0x4409, 0x3C09, 0x3C09, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43C9, 0x43CA, 0x43CA, 0x4BAA, 0x4BAA, 0x4B8A, 0x4B8A, 0x4B6A, 0x63AB, 0x9CAF, 0xC551, 0xCD90, 0xCDB0, 0xCDCF, 0xCDCF, 0xC5AF, 0xC5AF, 0xBD8F, 0xBD4E, 0xB52E, 0xA4CE, 
        0x944D, 0x73AC, 0x532B, 0x3AA9, 0x2A88, 0x2A87, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x2306, 0x2327, 0x2327, 0x2347, 0x2367, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BA7, 0x2BA8, 0x33C8, 0x33E8, 0x3C08, 0x3C29, 0x3C49, 0x4469, 0x448A, 
        0x448A, 0x4CAA, 0x4C8A, 0x4C8A, 0x4C8B, 0x546B, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C0A, 0x43E9, 0x43E9, 0x43C9, 0x3BC9, 0x3BA9, 0x33A9, 0x3389, 0x3368, 0x3348, 0x3348, 0x3368, 0x3368, 0x3B88, 0x3BA8, 0x3BC9, 0x43E8, 0x4409, 0x4409, 0x4409,
  0x4346, 0x4346, 0x4346, 0x3B46, 0x3326, 0x4C29, 0x5CEB, 0x550B, 0x552C, 0x552C, 0x554C, 0x556D, 0x558D, 0x5DAD, 0x55CD, 0x55CD, 0x5DED, 0x5E0D, 0x662E, 0x666E, 0x668F, 0x6EAF, 0x6EAF, 0x6ECF, 0x76CF, 0x76CF, 0x76AF, 0x7ED0, 0x86B1, 0x8631, 0x642B, 
        0x6BEA, 0x740B, 0x7C2B, 0x7C4B, 0x7C6C, 0x7C6B, 0x7C8B, 0x7C8B, 0x7C8B, 0x7CAB, 0x84AB, 0x7CAB, 0x7CAB, 0x84AB, 0x848B, 0x848B, 0x848B, 0x8CAC, 0x8CAC, 0x8CAD, 0x848D, 0x846D, 0x7C4E, 0x746E, 0x746E, 0x6C8D, 0x6CAD, 0x6CCD, 0x6CCC, 0x6CCC, 
        0x74CC, 0x74CC, 0x74ED, 0x74CC, 0x74CC, 0x6CEC, 0x6CEC, 0x6CCC, 0x6CCC, 0x6CAC, 0x648C, 0x5C6B, 0x5C4B, 0x5C2C, 0x640C, 0x63EC, 0x53AB, 0x4B8A, 0x4B6A, 0x4B6A, 0x4349, 0x4329, 0x4349, 0x5BCC, 0x6C6E, 0x74D0, 0x74F1, 0x6CB1, 0x6470, 0x5C0F, 
        0x4BCE, 0x4BEE, 0x542F, 0x5C6F, 0x64B0, 0x74F1, 0x7D52, 0x8593, 0x7D92, 0x6D10, 0x4C6D, 0x33AA, 0x2367, 0x1B66, 0x1B65, 0x1365, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x1284, 0x1244, 0x1224, 0x11E3, 0x11C3, 0x1183, 0x1163, 0x1163, 0x1143, 
        0x1143, 0x1143, 0x1143, 0x1944, 0x1964, 0x1985, 0x21C5, 0x21E6, 0x2A06, 0x2A27, 0x2A47, 0x2A27, 0x3227, 0x3248, 0x3268, 0x3268, 0x3A68, 0x3A89, 0x42AA, 0x4AEC, 0x532E, 0x534F, 0x5370, 0x53B0, 0x53D0, 0x4B4D, 0x32AA, 0x3269, 0x2A48, 0x2A27, 
        0x2A06, 0x21E6, 0x21E6, 0x21E6, 0x21E6, 0x2206, 0x2226, 0x2A46, 0x2A66, 0x3286, 0x32A6, 0x3AC6, 0x3AE7, 0x4307, 0x4327, 0x4327, 0x4B28, 0x4347, 0x4348, 0x4328, 0x4328, 0x42E8, 0x3AE7, 0x3AE7, 0x3AC7, 0x3AC7, 0x3AE7, 0x3B07, 0x3B28, 0x4348, 
        0x4368, 0x4388, 0x43A8, 0x43E8, 0x4408, 0x4428, 0x4448, 0x4469, 0x4C89, 0x4C89, 0x4C89, 0x4CA9, 0x4CA9, 0x4CAA, 0x4CCA, 0x54CA, 0x54EA, 0x54EB, 0x550B, 0x5D0B, 0x5D0C, 0x5D2C, 0x5D0C, 0x5D0C, 0x5D0C, 0x5D0B, 0x5CEB, 0x5CCB, 0x54AB, 0x548B, 
        0x4C6A, 0x4C4A, 0x440A, 0x43C9, 0x3B89, 0x3B68, 0x3B28, 0x32E7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x3AA7, 0x3AC7, 0x3AE7, 0x4328, 0x4348, 0x4368, 0x4388, 0x43A7, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BE8, 0x43E8, 0x43E7, 0x4407, 0x4407, 
        0x4407, 0x3BE7, 0x3BE7, 0x3BC7, 0x33A7, 0x33A7, 0x3387, 0x3387, 0x3367, 0x3367, 0x3347, 0x3348, 0x3328, 0x3308, 0x3308, 0x3AE8, 0x32E8, 0x32C8, 0x3AA9, 0x3A69, 0x3229, 0x29E9, 0x31EA, 0x4ACF, 0x73D5, 0x949A, 0x947C, 0x941D, 0x8BDE, 0x83BD, 
        0x83BD, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x83BE, 0x8BBE, 0x8BDE, 0x8C3C, 0x947B, 0x949A, 0x949A, 0x9499, 0x94B9, 0x94B9, 0x94B9, 0x8C99, 0x8C99, 0x8C98, 0x8497, 0x7C73, 0x7431, 0x6C0F, 0x63ED, 0x5BEC, 
        0x5BCB, 0x53EB, 0x53CB, 0x53EA, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BA9, 0x4BA9, 0x4B89, 0x4369, 0x4369, 0x4349, 0x4349, 0x4B49, 0x4329, 0x4B29, 0x4309, 0x4309, 0x430A, 0x432A, 0x430C, 0x536F, 0x63D2, 0x6BF5, 0x6C16, 0x6C16, 0x6C14, 0x6C13, 
        0x6411, 0x6410, 0x5C0F, 0x5C0E, 0x53EC, 0x4BEA, 0x43C9, 0x43C9, 0x43A8, 0x4388, 0x4368, 0x4368, 0x4B89, 0x4BAA, 0x53AB, 0x4B6A, 0x4B8A, 0x4BAB, 0x3B29, 0x32E8, 0x32E7, 0x32E7, 0x3B08, 0x3B28, 0x4368, 0x4B4A, 0x5B8E, 0x63B2, 0x63D4, 0x6C35, 
        0x7453, 0x7472, 0x74D1, 0x7D31, 0x7D51, 0x7D11, 0x8512, 0x7CB2, 0x6C31, 0x6C31, 0x6C72, 0x74B2, 0x74D2, 0x6CF2, 0x64F1, 0x64D1, 0x64B1, 0x5C91, 0x64D2, 0x6D12, 0x6D52, 0x6D52, 0x5CCF, 0x3BCA, 0x33A9, 0x33C8, 0x3BC9, 0x3BE9, 0x3BE9, 0x3BE9, 
        0x3C09, 0x4409, 0x4409, 0x4409, 0x4409, 0x4409, 0x43E9, 0x43E9, 0x43EA, 0x43C9, 0x43CA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4B8A, 0x4B8A, 0x4B6A, 0x63AB, 0xA4CF, 0xC571, 0xD5B0, 0xCDD0, 0xCDD0, 0xCDAF, 0xC5AF, 0xC58F, 0xBD4E, 0xB50E, 0xACEE, 0x948D, 
        0x8C2D, 0x73CD, 0x5B6C, 0x3AC9, 0x32A8, 0x2A87, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22E6, 0x2306, 0x2326, 0x2327, 0x2B47, 0x2367, 0x2367, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x2BC7, 0x33C8, 0x33E8, 0x3C08, 0x3C29, 0x4449, 0x446A, 0x448A, 0x4CAA, 
        0x4CAA, 0x4CAA, 0x4CAA, 0x54AB, 0x548B, 0x546A, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C0A, 0x440A, 0x43E9, 0x43C9, 0x3BC9, 0x3BC9, 0x33A9, 0x3389, 0x3368, 0x3348, 0x3368, 0x3368, 0x3368, 0x3B88, 0x3BA8, 0x43C9, 0x43E8, 0x4409, 0x4429, 0x4C29,
  0x3B26, 0x3B26, 0x3B26, 0x3B26, 0x3305, 0x3B66, 0x5CCA, 0x5D0B, 0x5D2B, 0x5D2C, 0x5D4C, 0x556C, 0x558C, 0x55AD, 0x55CD, 0x55CD, 0x55ED, 0x5E0D, 0x5E2D, 0x666E, 0x6E8F, 0x6EAF, 0x6EAF, 0x6EAF, 0x6EAF, 0x76AF, 0x768F, 0x7E90, 0x8692, 0x6CED, 0x4307, 
        0x5328, 0x5B48, 0x6389, 0x63A9, 0x6BCA, 0x6BEA, 0x6C2A, 0x744B, 0x7C8B, 0x7C8B, 0x7CAB, 0x7CAB, 0x7CAB, 0x7C8B, 0x7C8B, 0x848B, 0x848B, 0x8C8B, 0x8CAC, 0x8CAC, 0x8C8C, 0x848D, 0x846D, 0x7C6D, 0x748D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x6CAC, 
        0x6CAC, 0x74CD, 0x74CD, 0x74CD, 0x74CC, 0x6CEC, 0x6CEC, 0x6CCC, 0x6CCC, 0x6CAC, 0x648C, 0x646B, 0x644B, 0x642C, 0x640C, 0x63EB, 0x53AA, 0x53AA, 0x4B89, 0x4B69, 0x4369, 0x4349, 0x4329, 0x538A, 0x5C0D, 0x6CAF, 0x74D0, 0x6CD1, 0x6490, 0x5C2F, 
        0x4BEE, 0x4BEE, 0x542E, 0x5C4F, 0x64B0, 0x6CF1, 0x7D52, 0x8593, 0x8593, 0x6D10, 0x4C6D, 0x2B89, 0x2367, 0x1B66, 0x1B65, 0x1365, 0x1345, 0x1345, 0x1324, 0x1304, 0x12C4, 0x1284, 0x1264, 0x1224, 0x1203, 0x11C3, 0x1183, 0x1183, 0x1163, 0x1163, 
        0x1143, 0x1143, 0x1143, 0x1164, 0x1164, 0x1984, 0x19C5, 0x21E6, 0x2A06, 0x2A27, 0x2A47, 0x2A47, 0x3248, 0x3268, 0x3268, 0x3288, 0x3A88, 0x3A89, 0x42A9, 0x4AEC, 0x530E, 0x532F, 0x5370, 0x53B1, 0x53D0, 0x434D, 0x32AA, 0x3268, 0x2A48, 0x2A27, 
        0x2A06, 0x21E6, 0x21C6, 0x19C5, 0x21C5, 0x2206, 0x2226, 0x2A46, 0x2A66, 0x3286, 0x32A6, 0x3AC6, 0x3AE7, 0x4307, 0x4327, 0x4328, 0x4B48, 0x4347, 0x4348, 0x4328, 0x4308, 0x42E8, 0x3AC8, 0x3AC7, 0x3AC7, 0x3AA7, 0x3AC7, 0x3AE7, 0x3B07, 0x3B28, 
        0x4368, 0x4388, 0x43A8, 0x43C8, 0x43E8, 0x4408, 0x4428, 0x4448, 0x4469, 0x4469, 0x4489, 0x4489, 0x4489, 0x4C89, 0x4CAA, 0x4CCA, 0x54CA, 0x54CA, 0x54EB, 0x5CEB, 0x5CEB, 0x5D0B, 0x5D0B, 0x5CEB, 0x5CEB, 0x5CEB, 0x54CB, 0x54AB, 0x54AB, 0x546A, 
        0x4C4A, 0x4429, 0x43E9, 0x3BC9, 0x3B88, 0x3B68, 0x3328, 0x32E7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x3AA7, 0x3AC7, 0x3AE7, 0x3B28, 0x4348, 0x4368, 0x4388, 0x4BA8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BE8, 0x43E7, 0x4407, 0x4407, 0x4407, 
        0x4407, 0x3BE7, 0x3BC7, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x3BA7, 0x3387, 0x3367, 0x3367, 0x3B48, 0x3B48, 0x3B28, 0x3B29, 0x3B09, 0x3AE9, 0x3AAA, 0x3A8A, 0x428C, 0x52EF, 0x6B93, 0x8457, 0x949B, 0x947C, 0x8C1D, 0x8BDD, 0x83BE, 0x7B9E, 0x7B9E, 
        0x7B9E, 0x7B9E, 0x7B9D, 0x7BBD, 0x7BBE, 0x83DE, 0x83DE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7B9E, 0x839E, 0x83BE, 0x83DE, 0x83FD, 0x8BFD, 0x8C1D, 0x8C1D, 0x8C1D, 0x8C1D, 0x8BFD, 0x83FD, 0x83FD, 0x83FD, 0x83FC, 0x8C3B, 0x8C59, 0x8C78, 0x7C75, 0x7432, 
        0x63EF, 0x5BCD, 0x53CC, 0x53CB, 0x53CA, 0x4BAA, 0x4BCA, 0x4BC9, 0x4BA9, 0x4BA9, 0x4B89, 0x4369, 0x4369, 0x4349, 0x4349, 0x4349, 0x4329, 0x4329, 0x4309, 0x4309, 0x42EA, 0x4B0D, 0x5B72, 0x6376, 0x6B79, 0x6B5B, 0x6B5B, 0x6B7A, 0x6B7A, 0x6B99, 
        0x6BB8, 0x73D7, 0x6BF6, 0x6C16, 0x6C34, 0x5C10, 0x4BAB, 0x4389, 0x4388, 0x4388, 0x4BCA, 0x5C2C, 0x644D, 0x6C4E, 0x6C6F, 0x6C6F, 0x74B0, 0x74D0, 0x644E, 0x53CC, 0x4349, 0x3B08, 0x3B08, 0x3B28, 0x4368, 0x4B4A, 0x536D, 0x5B91, 0x63B3, 0x6C14, 
        0x7453, 0x7472, 0x7CD1, 0x7D32, 0x7D31, 0x7D11, 0x8512, 0x7CB1, 0x6C10, 0x6C31, 0x6C71, 0x6CB2, 0x6CD2, 0x6CD1, 0x64D1, 0x64B1, 0x6491, 0x6CB2, 0x6CF2, 0x6D12, 0x6D52, 0x6531, 0x4C6D, 0x33A9, 0x33A8, 0x33C8, 0x3BE8, 0x3C08, 0x3C08, 0x3C09, 
        0x4429, 0x4429, 0x4429, 0x4429, 0x4409, 0x4409, 0x4409, 0x4409, 0x43E9, 0x43E9, 0x4BE9, 0x4BE9, 0x4BCA, 0x4BAA, 0x4B8A, 0x4B6A, 0x4B8A, 0x73EC, 0xACEF, 0xC590, 0xD5B0, 0xCDD0, 0xCDAF, 0xC5AF, 0xC58F, 0xBD4E, 0xB50E, 0xACEE, 0x9CAD, 0x948E, 
        0x842E, 0x638C, 0x42A9, 0x2A67, 0x2267, 0x2266, 0x1A86, 0x1AA6, 0x22C6, 0x1AC6, 0x1AE6, 0x2306, 0x2326, 0x2326, 0x2B47, 0x2367, 0x2387, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x33C7, 0x33E8, 0x3408, 0x3C29, 0x3C49, 0x4469, 0x448A, 0x4C8A, 0x4CAA, 
        0x4CAA, 0x54AA, 0x548A, 0x548B, 0x548B, 0x548A, 0x546A, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C0A, 0x43E9, 0x43E9, 0x43C9, 0x3BC9, 0x3BA9, 0x3389, 0x3368, 0x3348, 0x3348, 0x3368, 0x3368, 0x3B88, 0x3BA8, 0x43C9, 0x43E8, 0x4C09, 0x4C09, 0x4C29,
  0x3306, 0x3306, 0x3306, 0x3306, 0x32E5, 0x2B04, 0x4407, 0x5CEB, 0x550B, 0x552B, 0x552B, 0x554B, 0x556C, 0x558C, 0x55AC, 0x55CC, 0x55CC, 0x55EC, 0x560D, 0x5E4D, 0x668E, 0x6E8F, 0x6E8F, 0x6E8F, 0x6E6F, 0x6E6F, 0x6E6F, 0x7E50, 0x7E10, 0x3B47, 0x2A65, 
        0x3A65, 0x4286, 0x4AC7, 0x4AC6, 0x4B07, 0x5327, 0x5B68, 0x63A9, 0x6C2B, 0x746B, 0x7C8B, 0x7C8B, 0x7C8B, 0x748B, 0x748B, 0x7C8A, 0x7C8A, 0x848B, 0x848B, 0x848B, 0x8C8C, 0x848C, 0x848D, 0x7C8D, 0x7C8D, 0x74AD, 0x74AD, 0x6CAD, 0x6CAD, 0x6CAD, 
        0x6CAD, 0x74AD, 0x74AD, 0x74CD, 0x74CD, 0x74ED, 0x74EC, 0x74CC, 0x6CCC, 0x6CAC, 0x6CAC, 0x646B, 0x644B, 0x642C, 0x640B, 0x5BEB, 0x53CA, 0x53AA, 0x4B89, 0x4B89, 0x4369, 0x4349, 0x4348, 0x4B6A, 0x53CC, 0x646E, 0x74B0, 0x74B0, 0x6C90, 0x6430, 
        0x53EF, 0x4BEE, 0x542F, 0x5C4F, 0x64B0, 0x6CF1, 0x7552, 0x7D93, 0x7D72, 0x6CF0, 0x4C4D, 0x3389, 0x2367, 0x1B66, 0x1365, 0x1365, 0x1365, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12A4, 0x1284, 0x1244, 0x1203, 0x11C3, 0x11A4, 0x1184, 0x1164, 0x1163, 
        0x1163, 0x1163, 0x1163, 0x1164, 0x1164, 0x19A4, 0x19C5, 0x21E6, 0x2A26, 0x2A47, 0x2A47, 0x2A47, 0x2A67, 0x3268, 0x3288, 0x32A8, 0x32A8, 0x3AA9, 0x42C9, 0x4AEC, 0x530E, 0x532F, 0x5390, 0x53B0, 0x53AF, 0x432D, 0x32A9, 0x2A68, 0x2A48, 0x2A27, 
        0x2A06, 0x21E6, 0x21C6, 0x19C5, 0x21C5, 0x19E6, 0x2226, 0x2246, 0x2A66, 0x3286, 0x32A6, 0x3AC6, 0x3AE7, 0x4307, 0x4327, 0x4347, 0x4B48, 0x4347, 0x4347, 0x4328, 0x4308, 0x42E8, 0x3AC7, 0x3AC7, 0x3AA7, 0x3AA7, 0x3AA7, 0x3AC7, 0x3AE7, 0x3B28, 
        0x4348, 0x3B67, 0x4388, 0x43C8, 0x43E8, 0x4408, 0x4408, 0x4428, 0x4448, 0x4469, 0x4469, 0x4469, 0x4489, 0x4C89, 0x4C8A, 0x4CAA, 0x4CAA, 0x54CA, 0x54CA, 0x54CB, 0x54EB, 0x54EB, 0x54EB, 0x54EB, 0x54EB, 0x54CB, 0x54AB, 0x54AA, 0x548A, 0x4C6A, 
        0x442A, 0x4409, 0x3BC9, 0x3BA9, 0x3368, 0x3348, 0x3308, 0x32E7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x3AA7, 0x3AA7, 0x3AC8, 0x3AE7, 0x3B08, 0x4348, 0x4368, 0x4388, 0x4BA8, 0x4BC8, 0x4BC8, 0x43C8, 0x43E7, 0x43E7, 0x4407, 0x43E7, 0x43E7, 
        0x4407, 0x3BE7, 0x3BC7, 0x3BC7, 0x3BA7, 0x33A7, 0x3BA7, 0x3BA7, 0x3BA7, 0x3B88, 0x3388, 0x3B68, 0x3B48, 0x3B29, 0x3B0A, 0x430C, 0x534E, 0x63D1, 0x7C55, 0x8C98, 0x949A, 0x947C, 0x8C5C, 0x8C3D, 0x8BFD, 0x83BE, 0x7B7E, 0x737E, 0x737E, 0x737E, 
        0x737E, 0x739E, 0x739E, 0x73BD, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x83BE, 0x83BE, 0x83BE, 0x83DE, 0x83DE, 0x83BE, 0x83BE, 0x839E, 0x7B9E, 0x7B9E, 0x7B9E, 0x839D, 0x83BD, 0x83DC, 0x841C, 0x843A, 
        0x7C57, 0x7455, 0x7473, 0x6C51, 0x640E, 0x53AC, 0x4B8A, 0x4BAA, 0x4BA9, 0x4B89, 0x4B89, 0x4369, 0x4349, 0x4349, 0x4349, 0x4329, 0x4329, 0x4309, 0x4309, 0x42EB, 0x4AED, 0x5B73, 0x6358, 0x6B1B, 0x6AFD, 0x62DE, 0x62DE, 0x62FD, 0x6AFD, 0x6B1D, 
        0x6B1D, 0x6B3C, 0x6B5B, 0x737B, 0x73BA, 0x6C16, 0x53AF, 0x438A, 0x4BAA, 0x53EB, 0x53EB, 0x53AB, 0x538B, 0x538C, 0x5BAC, 0x63EE, 0x746F, 0x74B0, 0x74B0, 0x6C8F, 0x6C6E, 0x5BEC, 0x4B8A, 0x4349, 0x4368, 0x4B4A, 0x534C, 0x5B70, 0x63B3, 0x6C15, 
        0x7454, 0x7472, 0x7CD1, 0x7D11, 0x7531, 0x7D11, 0x7CF1, 0x7CB1, 0x6C50, 0x6C71, 0x74D2, 0x74F2, 0x74F2, 0x6CF1, 0x6CD1, 0x6CD1, 0x6CF2, 0x7513, 0x6D13, 0x6D12, 0x6D31, 0x5CEF, 0x3BEB, 0x33A8, 0x33C8, 0x33E8, 0x3C08, 0x3C08, 0x4428, 0x4429, 
        0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4409, 0x4409, 0x4409, 0x440A, 0x4C09, 0x4BE9, 0x4BC9, 0x4BC9, 0x4BA9, 0x4B89, 0x4B89, 0x5BEC, 0x846E, 0xB530, 0xCD91, 0xCDB0, 0xCDB0, 0xC5AF, 0xC58F, 0xBD6F, 0xB52E, 0xACEE, 0x9CAE, 0x948E, 0x846E, 
        0x6B8C, 0x42A9, 0x3248, 0x2A47, 0x2246, 0x1A45, 0x1A65, 0x1AA6, 0x1AC6, 0x1AC6, 0x1AE6, 0x2326, 0x2326, 0x2346, 0x2367, 0x2387, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x33C7, 0x33E8, 0x3408, 0x3C29, 0x3C49, 0x4469, 0x4489, 0x4CAA, 0x4CAA, 0x54AB, 
        0x54AB, 0x54AA, 0x548A, 0x548B, 0x548B, 0x548B, 0x546A, 0x546A, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C0A, 0x43E9, 0x43E9, 0x3BC9, 0x3BA9, 0x3369, 0x3368, 0x3348, 0x3348, 0x3348, 0x3368, 0x3388, 0x3BA8, 0x43C9, 0x43E8, 0x4C09, 0x4C09, 0x4C29,
  0x3305, 0x3305, 0x3305, 0x32E5, 0x32E5, 0x2AE4, 0x2AE4, 0x4C69, 0x54EA, 0x550B, 0x550B, 0x552B, 0x554B, 0x556C, 0x558C, 0x558C, 0x55AC, 0x55CC, 0x55CD, 0x5E0D, 0x664E, 0x666E, 0x666F, 0x6E4E, 0x664F, 0x6E2F, 0x6E2F, 0x7630, 0x548B, 0x2264, 0x2A44, 
        0x2A24, 0x2A24, 0x3244, 0x3245, 0x3265, 0x3A85, 0x42C6, 0x4B28, 0x5BA9, 0x6C0A, 0x744B, 0x744B, 0x746B, 0x746B, 0x746B, 0x746B, 0x746B, 0x7C6B, 0x7C8B, 0x848B, 0x8C8B, 0x848C, 0x848C, 0x7C8C, 0x7C8D, 0x748D, 0x748D, 0x6C8D, 0x6C8D, 0x6C8D, 
        0x6C8D, 0x6C8D, 0x74AD, 0x74CD, 0x74CD, 0x74ED, 0x74EC, 0x74CC, 0x74CC, 0x6CAC, 0x6CAC, 0x6C8C, 0x644C, 0x642B, 0x640B, 0x5BEB, 0x53CA, 0x4BAA, 0x4BA9, 0x4B89, 0x4389, 0x4369, 0x4349, 0x4349, 0x4B8A, 0x5C0D, 0x6C8F, 0x74B0, 0x6C90, 0x6450, 
        0x5C0F, 0x4BEE, 0x542E, 0x546F, 0x64B0, 0x6CF1, 0x7552, 0x7D72, 0x7D72, 0x6D11, 0x4C6D, 0x33AA, 0x2387, 0x1B66, 0x1385, 0x1365, 0x1365, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x1284, 0x1264, 0x1223, 0x11E3, 0x11A4, 0x1184, 0x1184, 0x1163, 
        0x1164, 0x1163, 0x1163, 0x1184, 0x1184, 0x19C5, 0x19E5, 0x2206, 0x2226, 0x2246, 0x2A67, 0x2A67, 0x2A67, 0x2A87, 0x32A8, 0x32A8, 0x32A8, 0x3AC9, 0x42EA, 0x4B0C, 0x530E, 0x4B2F, 0x5390, 0x53B0, 0x4B8E, 0x3B0C, 0x3289, 0x3268, 0x2A48, 0x2A47, 
        0x2A26, 0x2206, 0x21E6, 0x19E5, 0x19E5, 0x19E5, 0x2205, 0x2246, 0x2A66, 0x3286, 0x3AA6, 0x3AC6, 0x3AE6, 0x3AE7, 0x4327, 0x4327, 0x4347, 0x4347, 0x4B48, 0x4328, 0x4308, 0x3AE8, 0x3AC7, 0x32A7, 0x32A7, 0x32A7, 0x3AA7, 0x3AC7, 0x3AC7, 0x3B07, 
        0x4327, 0x3B47, 0x3B67, 0x4387, 0x43C8, 0x43E8, 0x4408, 0x4428, 0x4428, 0x4449, 0x4449, 0x4449, 0x4C69, 0x4C69, 0x4C8A, 0x4C8A, 0x4CAA, 0x54AA, 0x4CAA, 0x54AB, 0x54CB, 0x54CB, 0x54CB, 0x54CB, 0x54CB, 0x54AB, 0x4C8A, 0x4C8A, 0x4C6A, 0x4C4A, 
        0x4429, 0x4409, 0x3BC8, 0x3BA8, 0x3348, 0x3328, 0x3308, 0x32E7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32A7, 0x3AA7, 0x3AC8, 0x3AE8, 0x3AE8, 0x4328, 0x4348, 0x4368, 0x4388, 0x43A8, 0x43A8, 0x43C8, 0x43C8, 0x43E7, 0x43E7, 0x43E7, 0x43E7, 0x43E7, 
        0x3BE7, 0x3BE7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x3BC8, 0x3BA8, 0x3B88, 0x3B69, 0x3349, 0x436B, 0x53CF, 0x6C53, 0x84B7, 0x94DA, 0x8CBB, 0x8C7C, 0x8C5C, 0x8C3D, 0x8C1D, 0x83FD, 0x83DE, 0x83DE, 0x7BBE, 0x737E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x73BE, 0x7BBE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7B9E, 0x739E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7B9E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7BBD, 
        0x7BDB, 0x7C1B, 0x7C3A, 0x7C78, 0x8497, 0x7473, 0x5BEF, 0x4BAB, 0x4B8A, 0x4B89, 0x4389, 0x4369, 0x4349, 0x4349, 0x4349, 0x4329, 0x4329, 0x430A, 0x430B, 0x4B0F, 0x5B56, 0x633A, 0x631C, 0x62FD, 0x62DE, 0x62BE, 0x62BE, 0x62DE, 0x6ADE, 0x6AFE, 
        0x6AFD, 0x731D, 0x731E, 0x731E, 0x733D, 0x73BA, 0x63D4, 0x53CE, 0x5BEC, 0x4B6A, 0x3AE9, 0x3AA9, 0x3AA9, 0x3AA9, 0x3A89, 0x3A8A, 0x42EB, 0x53AD, 0x642F, 0x6C70, 0x6CB0, 0x74AF, 0x6C8F, 0x53EC, 0x4BAA, 0x536A, 0x5B6D, 0x5B70, 0x63B3, 0x6C14, 
        0x7434, 0x7473, 0x74D2, 0x7D11, 0x7510, 0x6CF0, 0x6CF0, 0x74F1, 0x6CF1, 0x6CF1, 0x6CF1, 0x6CF1, 0x6CD1, 0x6CB1, 0x6CB1, 0x6CF2, 0x74F3, 0x6D13, 0x6D12, 0x6D32, 0x6531, 0x548D, 0x33A9, 0x33A8, 0x33C8, 0x3BE8, 0x3C08, 0x4428, 0x4429, 0x4429, 
        0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4409, 0x4C0A, 0x4C0A, 0x4C09, 0x4BE9, 0x4BC9, 0x4BC9, 0x4B89, 0x4B69, 0x538A, 0x6C2C, 0x94CF, 0xBD71, 0xCDB1, 0xCDB0, 0xC58F, 0xBD6E, 0xB52E, 0xAD0E, 0xA4CD, 0x9CAD, 0x8C6D, 0x7C2D, 0x638B, 
        0x42C9, 0x3247, 0x2A27, 0x2227, 0x2246, 0x1A45, 0x1A85, 0x1AA5, 0x1AC6, 0x1AC6, 0x22E6, 0x2326, 0x2346, 0x2367, 0x2B67, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x33E7, 0x3408, 0x3408, 0x3C29, 0x4449, 0x4469, 0x446A, 0x4C8A, 0x4CAA, 0x54AA, 0x54AA, 
        0x5CAB, 0x54AA, 0x548A, 0x548A, 0x5C8B, 0x5C8B, 0x5C8B, 0x546B, 0x546A, 0x544A, 0x4C2A, 0x4C0A, 0x4C09, 0x43E9, 0x3BC9, 0x3BA9, 0x3368, 0x3368, 0x3368, 0x3348, 0x3368, 0x3368, 0x3B88, 0x3BA8, 0x43C8, 0x4BE8, 0x4BE9, 0x4C09, 0x4C29,
  0x2B05, 0x2B05, 0x2AE5, 0x2AE5, 0x2AC5, 0x2AC4, 0x22C4, 0x3325, 0x4C89, 0x4CCA, 0x550B, 0x4D0B, 0x4D2B, 0x4D2B, 0x4D2B, 0x4D6C, 0x4D6C, 0x558C, 0x558C, 0x5DCD, 0x5E0D, 0x662E, 0x662E, 0x660E, 0x660E, 0x660E, 0x6E0F, 0x6D6E, 0x2AE6, 0x2244, 0x2A24, 
        0x2224, 0x2224, 0x2224, 0x2224, 0x2A45, 0x2A85, 0x32A6, 0x3AC7, 0x4B28, 0x5B89, 0x63CA, 0x6C0A, 0x6C2B, 0x6C2B, 0x6C4B, 0x6C4B, 0x6C4B, 0x746A, 0x746B, 0x7C6B, 0x7C6B, 0x848B, 0x7C8C, 0x7C8C, 0x7C8C, 0x7C8D, 0x7C6D, 0x746D, 0x6C4D, 0x6C6E, 
        0x746E, 0x746E, 0x748E, 0x74AE, 0x74CD, 0x74CD, 0x74CD, 0x74CC, 0x74CD, 0x74CC, 0x74AC, 0x6C8C, 0x6C4C, 0x6C2B, 0x640B, 0x5BEB, 0x53CA, 0x4BCA, 0x4BA9, 0x43A9, 0x4389, 0x4369, 0x4369, 0x4329, 0x4329, 0x53AB, 0x642D, 0x6C6F, 0x6C70, 0x6C50, 
        0x5C2F, 0x4C0E, 0x4C2E, 0x546F, 0x5CB0, 0x6D11, 0x7571, 0x7D92, 0x7D72, 0x6D31, 0x546E, 0x3BEA, 0x2387, 0x1B86, 0x1385, 0x1365, 0x1364, 0x1365, 0x1344, 0x1324, 0x1304, 0x12C4, 0x12A4, 0x1284, 0x1243, 0x11E3, 0x11C4, 0x11A4, 0x1183, 0x1184, 
        0x1184, 0x1984, 0x1184, 0x11A4, 0x19C4, 0x19E5, 0x1A05, 0x2206, 0x2246, 0x2246, 0x2266, 0x2267, 0x2A87, 0x2AA7, 0x2AA7, 0x32C8, 0x32C8, 0x3AE9, 0x430A, 0x4B0C, 0x4B0E, 0x4B4F, 0x5390, 0x5390, 0x4B8E, 0x3AEB, 0x3289, 0x3268, 0x2A47, 0x2A47, 
        0x2A26, 0x2206, 0x21E6, 0x19E5, 0x19E5, 0x19E5, 0x2205, 0x2A25, 0x2A66, 0x3286, 0x3AC6, 0x3AC6, 0x3AE6, 0x3AE6, 0x4307, 0x4307, 0x4327, 0x4327, 0x4328, 0x4328, 0x4308, 0x3AE7, 0x3AA7, 0x3287, 0x3287, 0x3286, 0x3A87, 0x3AA7, 0x3AC7, 0x3AE7, 
        0x3B07, 0x4327, 0x4347, 0x4367, 0x4387, 0x43C7, 0x43E8, 0x4408, 0x4408, 0x4428, 0x4429, 0x4429, 0x4C4A, 0x546B, 0x548B, 0x4C8A, 0x4C8A, 0x4C8A, 0x4C8A, 0x4CAB, 0x54AB, 0x54AA, 0x54AA, 0x4CAB, 0x4CAA, 0x4C8B, 0x4C8A, 0x4C6A, 0x4C6A, 0x4429, 
        0x4409, 0x3BE8, 0x3BC8, 0x3B88, 0x3348, 0x3328, 0x3307, 0x2AE7, 0x32C7, 0x32C7, 0x32A7, 0x32A7, 0x3AC7, 0x3AC8, 0x3AC8, 0x3AE8, 0x4308, 0x4328, 0x4349, 0x4369, 0x4388, 0x43A8, 0x43A8, 0x43A8, 0x43C8, 0x43C7, 0x43E7, 0x43E7, 0x43E7, 0x43E7, 
        0x3BE7, 0x3BE7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x3BC8, 0x3BA9, 0x3B89, 0x4BCD, 0x6452, 0x7CD6, 0x8CDA, 0x8CBC, 0x8C7C, 0x8C3D, 0x841D, 0x83DE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBD, 0x7BBE, 0x739E, 0x6B7E, 0x6B5E, 0x637E, 0x635E, 
        0x635E, 0x6B5E, 0x6B7E, 0x6B9E, 0x739E, 0x73BE, 0x7BBE, 0x7BBE, 0x7BBE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x737E, 0x735E, 0x735D, 0x735E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 
        0x737E, 0x739E, 0x7BBD, 0x7BDD, 0x7C1C, 0x845A, 0x7C78, 0x7474, 0x5BEF, 0x4B8B, 0x436A, 0x4349, 0x4329, 0x4329, 0x4329, 0x4309, 0x430A, 0x430C, 0x5351, 0x6356, 0x633B, 0x62FD, 0x62FD, 0x62FD, 0x5ADE, 0x62BD, 0x62DE, 0x6AFE, 0x6AFE, 0x72FE, 
        0x731E, 0x731E, 0x731E, 0x731D, 0x731D, 0x735C, 0x6BB8, 0x532F, 0x432C, 0x42CA, 0x3A89, 0x3268, 0x3269, 0x3269, 0x3249, 0x3249, 0x2A28, 0x3269, 0x432B, 0x5BEE, 0x6C6F, 0x6C8F, 0x6C8F, 0x646E, 0x5C0C, 0x5BCC, 0x5B8D, 0x5B6F, 0x6393, 0x6C14, 
        0x7454, 0x7473, 0x74B2, 0x74F1, 0x6CD0, 0x6CCF, 0x6D10, 0x6D31, 0x6D31, 0x6510, 0x64F0, 0x64D0, 0x6490, 0x6491, 0x6CD2, 0x74F3, 0x6D13, 0x6D13, 0x6D32, 0x6D31, 0x650F, 0x442B, 0x2BA8, 0x33A8, 0x33E8, 0x3C08, 0x4428, 0x4429, 0x4429, 0x4449, 
        0x4449, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4C29, 0x4C0A, 0x4C0A, 0x4C09, 0x4BE9, 0x4BC9, 0x4BA9, 0x4B89, 0x4B69, 0x5BAA, 0x7C6D, 0xA50F, 0xC591, 0xCDB1, 0xCDB0, 0xBD6E, 0xB52E, 0xACED, 0xA4CD, 0x948D, 0x844D, 0x6BCB, 0x532A, 0x3AA8, 
        0x2A67, 0x2A27, 0x2A27, 0x2226, 0x1A46, 0x1A45, 0x1A85, 0x1AA5, 0x1AC6, 0x1AC6, 0x2306, 0x2326, 0x2346, 0x2B67, 0x2B87, 0x2BA7, 0x2BC7, 0x33C7, 0x33E7, 0x3408, 0x3408, 0x3C28, 0x3C49, 0x4449, 0x446A, 0x4C8A, 0x4CAA, 0x54AA, 0x54AA, 0x54AA, 
        0x5CAB, 0x5CAA, 0x5CAA, 0x5C8A, 0x5C8B, 0x5C8B, 0x5C8B, 0x546B, 0x546B, 0x544A, 0x4C2A, 0x4C2A, 0x4C09, 0x43E9, 0x3BC8, 0x3388, 0x3388, 0x3368, 0x3348, 0x3348, 0x3368, 0x3367, 0x3B67, 0x3B88, 0x43A8, 0x4BC8, 0x4BE8, 0x4C09, 0x4C09,
  0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AC5, 0x2AC4, 0x2AC4, 0x22C4, 0x3365, 0x4C89, 0x4CAA, 0x4CCA, 0x4D0A, 0x4D0A, 0x4D0B, 0x4D2B, 0x4D2B, 0x4D4B, 0x4D4B, 0x558C, 0x5DCD, 0x5DCD, 0x65CD, 0x65CD, 0x65CD, 0x65CE, 0x6DCF, 0x3BC9, 0x2264, 0x2A44, 0x2A24, 
        0x2223, 0x1A23, 0x1A23, 0x1A24, 0x2264, 0x2A85, 0x2AA6, 0x32C6, 0x42E7, 0x4B28, 0x5369, 0x5B89, 0x63CA, 0x63EA, 0x640A, 0x640A, 0x6C2A, 0x6C4A, 0x6C4B, 0x746B, 0x746B, 0x7C6B, 0x7C8B, 0x7C6C, 0x7C6C, 0x7C8C, 0x7C6D, 0x744D, 0x746E, 0x6C4E, 
        0x6C4E, 0x6C6E, 0x6C6E, 0x748E, 0x74AE, 0x74CD, 0x74ED, 0x74CD, 0x74CD, 0x74CD, 0x74AD, 0x748C, 0x6C4C, 0x6C2C, 0x640B, 0x5BEB, 0x53CA, 0x4BCA, 0x4BA9, 0x43A9, 0x43A9, 0x4389, 0x4369, 0x4349, 0x4349, 0x538B, 0x5BCC, 0x640D, 0x6C4F, 0x644F, 
        0x642F, 0x540E, 0x4C2E, 0x546F, 0x5CB0, 0x6510, 0x6D51, 0x7572, 0x7571, 0x6D31, 0x548E, 0x3BEB, 0x2387, 0x1B86, 0x1B65, 0x1365, 0x1365, 0x1345, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12A4, 0x1284, 0x1243, 0x1204, 0x11E4, 0x11A4, 0x11A4, 0x11A4, 
        0x19A4, 0x19A4, 0x19A4, 0x19C4, 0x19E5, 0x1A05, 0x2226, 0x2246, 0x2266, 0x2266, 0x2266, 0x2286, 0x2AA7, 0x2AA7, 0x2AC7, 0x2AC8, 0x32E8, 0x3AE9, 0x430B, 0x4B0C, 0x530E, 0x4B2F, 0x5390, 0x538F, 0x4B6D, 0x32CA, 0x2AA8, 0x2A88, 0x2A67, 0x2A47, 
        0x2226, 0x2206, 0x21E6, 0x19E5, 0x19E5, 0x19E5, 0x2205, 0x2A25, 0x2A66, 0x3286, 0x3AA6, 0x3AC6, 0x3AE6, 0x3AE6, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x4307, 0x3B07, 0x3AE8, 0x3AC7, 0x32A7, 0x3266, 0x3266, 0x3246, 0x3267, 0x3A87, 0x3A87, 0x3AC7, 
        0x3AE7, 0x3B07, 0x3B27, 0x3B47, 0x3B67, 0x3BA7, 0x3BC7, 0x3BE8, 0x43E8, 0x43E9, 0x4C0B, 0x64D0, 0x7513, 0x7D54, 0x7D54, 0x6D11, 0x5CCE, 0x546C, 0x4C8B, 0x4C8B, 0x4C8B, 0x4C8B, 0x4C8A, 0x4CAA, 0x4C8A, 0x4C8A, 0x4C6A, 0x4C6A, 0x444A, 0x4429, 
        0x3C09, 0x3BE9, 0x3BA8, 0x3B88, 0x3348, 0x3328, 0x2B08, 0x2AE8, 0x32C8, 0x32C8, 0x32C8, 0x3AC8, 0x3AC8, 0x3AC8, 0x3AE8, 0x4308, 0x4308, 0x4328, 0x4348, 0x4369, 0x4389, 0x4388, 0x4388, 0x4388, 0x43A8, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BE7, 
        0x3BC7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33C7, 0x3BC8, 0x3BA9, 0x4BAC, 0x6453, 0x84D9, 0x84BB, 0x847C, 0x8C5D, 0x841E, 0x83FE, 0x83DE, 0x7BBE, 0x7BBE, 0x73BE, 0x739E, 0x739D, 0x739D, 0x739E, 0x739E, 0x6B9E, 0x6B7E, 0x637E, 0x637E, 0x635E, 
        0x635E, 0x635E, 0x6B7E, 0x6B7E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x6B7E, 0x739E, 0x739E, 0x739D, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x735E, 0x735E, 0x735E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B5E, 
        0x6B5E, 0x737E, 0x739E, 0x737E, 0x739E, 0x73BD, 0x7BFC, 0x7C3B, 0x7458, 0x6433, 0x4B8D, 0x3B29, 0x3B29, 0x4309, 0x3AEA, 0x42EC, 0x5330, 0x6374, 0x6357, 0x631B, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62DD, 0x6ADE, 0x6AFE, 0x72FE, 0x731E, 
        0x731E, 0x72FE, 0x72FD, 0x731E, 0x72FE, 0x6AFD, 0x6B3A, 0x5B54, 0x5B91, 0x4B0D, 0x42CC, 0x3A8A, 0x3249, 0x2A49, 0x2A28, 0x2A28, 0x2A28, 0x2A28, 0x3289, 0x430B, 0x5BEE, 0x644F, 0x646E, 0x646E, 0x644D, 0x642D, 0x5BED, 0x5BAF, 0x6392, 0x6C14, 
        0x7455, 0x7493, 0x7CD2, 0x74F1, 0x6CF0, 0x6D10, 0x6D30, 0x6D50, 0x650F, 0x5CEF, 0x5CAF, 0x5C6F, 0x5C50, 0x6C91, 0x74D3, 0x7513, 0x7533, 0x6D33, 0x6D52, 0x6551, 0x54CE, 0x33C9, 0x2BA8, 0x33C8, 0x33E8, 0x3C08, 0x4429, 0x4429, 0x4449, 0x4C49, 
        0x4C49, 0x4449, 0x4449, 0x4429, 0x4429, 0x4C29, 0x4C2A, 0x4C0A, 0x4C0A, 0x4BE9, 0x4BC9, 0x4BA9, 0x4B89, 0x4369, 0x4369, 0x63EB, 0x8CAE, 0xAD50, 0xC5B1, 0xC5B0, 0xC58F, 0xB56E, 0xAD0E, 0x9CCD, 0x94AD, 0x846D, 0x6BCC, 0x4B2A, 0x32A8, 0x2A47, 
        0x2246, 0x2226, 0x2226, 0x1A26, 0x1A45, 0x1A45, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE6, 0x2306, 0x2326, 0x2366, 0x2B87, 0x2B87, 0x2BA7, 0x33C7, 0x33C7, 0x33E7, 0x3408, 0x3C28, 0x3C28, 0x3C49, 0x4469, 0x446A, 0x4C8A, 0x4CAA, 0x54AA, 0x54AA, 0x54AA, 
        0x5CAA, 0x5CAA, 0x5CAA, 0x5CAA, 0x5CAB, 0x5C8B, 0x5C8B, 0x5C8B, 0x5C6B, 0x546B, 0x544A, 0x4C29, 0x4C09, 0x43E9, 0x3BA8, 0x3388, 0x3368, 0x3348, 0x3348, 0x3348, 0x3348, 0x3368, 0x3367, 0x3B67, 0x3B88, 0x43A8, 0x4BC8, 0x4BE8, 0x4C09,
  0x2AE5, 0x2AE5, 0x2AE5, 0x2AC5, 0x2AC4, 0x2AA4, 0x2AA4, 0x22C4, 0x22C3, 0x2B45, 0x4C49, 0x4CAA, 0x4CCA, 0x44CA, 0x44CA, 0x44EA, 0x44EA, 0x4D0A, 0x4D2B, 0x4D4B, 0x558C, 0x5D8C, 0x5DAD, 0x65AD, 0x65CD, 0x6DCF, 0x652E, 0x2264, 0x2224, 0x2A24, 0x2223, 
        0x2223, 0x1A43, 0x1A43, 0x1A44, 0x2264, 0x2285, 0x2AA5, 0x32C6, 0x3AE7, 0x4327, 0x4B48, 0x5368, 0x5B89, 0x5BA9, 0x5BA9, 0x5BCA, 0x5BEA, 0x640A, 0x642A, 0x6C4A, 0x746B, 0x746B, 0x746B, 0x746B, 0x7C8C, 0x7C8C, 0x7C8C, 0x7C6D, 0x7C6E, 0x746E, 
        0x6C4F, 0x6C4F, 0x6C6E, 0x748E, 0x74AE, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74AD, 0x6C8C, 0x6C4C, 0x6C2C, 0x640B, 0x5BEB, 0x53CA, 0x4BCA, 0x4BC9, 0x43A9, 0x43A9, 0x4389, 0x4369, 0x4349, 0x4B69, 0x538B, 0x5BAB, 0x5BAC, 0x5BED, 0x640F, 
        0x640F, 0x4C2E, 0x4C2E, 0x546F, 0x5CAF, 0x64F0, 0x6D51, 0x7571, 0x7571, 0x6D31, 0x5CAE, 0x3BEA, 0x2387, 0x1B86, 0x1B86, 0x1B65, 0x1B65, 0x1365, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x12A4, 0x1264, 0x1223, 0x11E4, 0x11C4, 0x11C4, 0x19C4, 
        0x19C4, 0x19C4, 0x19E4, 0x19E4, 0x2205, 0x2245, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x22A6, 0x2AA6, 0x2AC7, 0x2AC7, 0x32E8, 0x3308, 0x3B09, 0x432B, 0x4B0D, 0x4B0E, 0x4B2F, 0x5390, 0x53AF, 0x434C, 0x32E9, 0x2AA8, 0x2A88, 0x2A87, 0x2A67, 
        0x2247, 0x2206, 0x2206, 0x19E5, 0x19E5, 0x19E5, 0x2205, 0x2A26, 0x2A66, 0x3286, 0x32A6, 0x32C6, 0x3AC6, 0x3AC6, 0x3AE6, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3AE7, 0x3AE7, 0x32A7, 0x3287, 0x3266, 0x2A46, 0x2A46, 0x3246, 0x3267, 0x3287, 0x3AA7, 
        0x3AC7, 0x3AE7, 0x3B07, 0x3B27, 0x3B47, 0x3B87, 0x3BA7, 0x3BC8, 0x3BC8, 0x43CB, 0x7493, 0x8519, 0x8CDB, 0x84BA, 0x84BA, 0x84F9, 0x8537, 0x74F3, 0x546D, 0x4C6B, 0x4C6B, 0x4C6B, 0x4C6A, 0x448A, 0x448A, 0x446A, 0x444A, 0x444A, 0x442A, 0x4409, 
        0x3BE9, 0x3BC9, 0x3BA9, 0x3B88, 0x3348, 0x3308, 0x32E8, 0x32C8, 0x32A9, 0x32A8, 0x32A9, 0x3289, 0x32A9, 0x3AC9, 0x3AC9, 0x3AE9, 0x4309, 0x4329, 0x4328, 0x4349, 0x4368, 0x4368, 0x3B68, 0x3B88, 0x3B88, 0x3BA7, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BC7, 
        0x3BC7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33C8, 0x3BA9, 0x4BEE, 0x7496, 0x849B, 0x845D, 0x841D, 0x7BFE, 0x83DE, 0x7BBE, 0x7BDE, 0x7BBE, 0x739E, 0x739E, 0x739E, 0x737E, 0x6B9E, 0x6B9E, 0x737E, 0x737E, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x635E, 
        0x635E, 0x635E, 0x637E, 0x6B7E, 0x6B9E, 0x739E, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x635D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x739D, 0x73BD, 0x73FC, 0x745A, 0x6C75, 0x4B6E, 0x32CB, 0x3ACB, 0x4B2E, 0x6394, 0x6377, 0x631A, 0x62FB, 0x62DD, 0x62FE, 0x6B1E, 0x6B1E, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x72FE, 0x731E, 0x731E, 
        0x731E, 0x731E, 0x72FD, 0x6ADD, 0x6ADE, 0x62BD, 0x62DC, 0x6B5A, 0x6B98, 0x73D6, 0x6BD5, 0x6392, 0x530F, 0x3A6B, 0x2A29, 0x2A08, 0x2A08, 0x2A08, 0x2A49, 0x3289, 0x432B, 0x5C0E, 0x644F, 0x646E, 0x646E, 0x646D, 0x644E, 0x63F0, 0x63B2, 0x6C35, 
        0x7455, 0x7C93, 0x7CD3, 0x74F1, 0x6CF0, 0x6D10, 0x6530, 0x652F, 0x5CEE, 0x5CCF, 0x5CAF, 0x5C70, 0x6471, 0x6CB2, 0x74F3, 0x7533, 0x6D53, 0x6D53, 0x6D52, 0x6530, 0x446C, 0x2BA8, 0x2BC8, 0x33E8, 0x3C08, 0x3C08, 0x4429, 0x4449, 0x4C69, 0x4C69, 
        0x4C69, 0x4C49, 0x4C49, 0x4C49, 0x4C49, 0x4C29, 0x4C2A, 0x4C0A, 0x4C0A, 0x4BE9, 0x4BC9, 0x4BA9, 0x4B69, 0x4368, 0x4369, 0x6C2D, 0x94EF, 0xB551, 0xC591, 0xC5B0, 0xBD8F, 0xAD4E, 0xA4EE, 0x94CD, 0x848D, 0x742D, 0x536B, 0x3AA9, 0x2A47, 0x2A27, 
        0x2226, 0x2226, 0x2226, 0x1A46, 0x1A45, 0x1265, 0x1A85, 0x1AA5, 0x1AC6, 0x1AE6, 0x2306, 0x2346, 0x2366, 0x2B87, 0x2BA7, 0x33C7, 0x33C7, 0x33E7, 0x3407, 0x3428, 0x3C28, 0x3C48, 0x3C69, 0x4469, 0x4489, 0x4CAA, 0x4CAA, 0x54AA, 0x54AA, 0x54AA, 
        0x5CAA, 0x5CAA, 0x5CAA, 0x5CAA, 0x5CAB, 0x5CAB, 0x5CAB, 0x5C8B, 0x5C8B, 0x546B, 0x544A, 0x4C29, 0x4C09, 0x43C8, 0x3BA8, 0x3388, 0x3367, 0x3348, 0x2B48, 0x3348, 0x3348, 0x3348, 0x3368, 0x3B67, 0x3B88, 0x4388, 0x43A8, 0x43C8, 0x4BE9,
  0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AA4, 0x22A4, 0x2AA4, 0x2AA4, 0x22A3, 0x22A3, 0x2304, 0x4428, 0x448A, 0x44AA, 0x44AA, 0x44AA, 0x44CA, 0x44CA, 0x450A, 0x4D2B, 0x554B, 0x558C, 0x5DAD, 0x65AD, 0x6DCE, 0x75EF, 0x752F, 0x6C8D, 0x5389, 0x3285, 0x2243, 
        0x2243, 0x1A43, 0x1A43, 0x1A43, 0x1A64, 0x22A5, 0x2AC5, 0x2AC6, 0x32E6, 0x3B27, 0x4347, 0x4348, 0x4B68, 0x4B68, 0x5388, 0x5388, 0x53A9, 0x53C9, 0x5BEA, 0x640A, 0x642A, 0x6C6B, 0x6C6B, 0x748B, 0x748C, 0x7C8C, 0x7CAC, 0x84AD, 0x84AE, 0x7C8E, 
        0x7C4F, 0x744F, 0x6C4F, 0x6C6E, 0x6C6E, 0x6C8E, 0x6CAD, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x6C6C, 0x6C4C, 0x6C2C, 0x63EB, 0x5BEA, 0x53CA, 0x4BC9, 0x4BA9, 0x43A9, 0x43A8, 0x4388, 0x3B68, 0x4349, 0x4B8A, 0x5BCB, 0x5BCC, 0x4B6B, 0x53AC, 0x5BEE, 
        0x640E, 0x540E, 0x4C2E, 0x4C4E, 0x5C8F, 0x5CF0, 0x6D30, 0x6D71, 0x7571, 0x7551, 0x5CCE, 0x442B, 0x33A9, 0x33C8, 0x2BE7, 0x23A6, 0x1B65, 0x1B65, 0x1345, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x12A4, 0x1284, 0x1244, 0x1204, 0x1204, 0x11E4, 0x19E4, 
        0x19E4, 0x19E4, 0x1A04, 0x2225, 0x2245, 0x2265, 0x2286, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x2AE7, 0x2AE7, 0x3308, 0x3B28, 0x432A, 0x4B2B, 0x532E, 0x4B0E, 0x5370, 0x53B0, 0x4BAE, 0x3B4B, 0x32E9, 0x32C8, 0x2AA8, 0x2A87, 0x2A67, 
        0x2A47, 0x2226, 0x2206, 0x1A06, 0x19E5, 0x1A05, 0x2205, 0x2245, 0x2A65, 0x2A85, 0x32A5, 0x32A5, 0x32C5, 0x3AC6, 0x3AC6, 0x3AE6, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x32C7, 0x32A7, 0x3267, 0x2A46, 0x2A46, 0x2A26, 0x2A26, 0x3246, 0x3267, 0x3287, 
        0x3AA7, 0x3AC7, 0x3B07, 0x3B27, 0x3B47, 0x3B67, 0x3B87, 0x3BA7, 0x43A9, 0x6431, 0x849A, 0x843C, 0x7BFD, 0x7BDD, 0x7BDE, 0x7BFD, 0x7C5C, 0x84BA, 0x7CF6, 0x64B0, 0x4C4C, 0x4C4B, 0x4C4A, 0x446A, 0x444A, 0x444A, 0x442A, 0x440A, 0x440A, 0x43CA, 
        0x3BAA, 0x3BAA, 0x43AA, 0x4B8C, 0x53CE, 0x53CE, 0x5BF0, 0x63F1, 0x6412, 0x6C12, 0x6C12, 0x6C12, 0x6C12, 0x63B0, 0x536F, 0x4B2D, 0x430B, 0x3B0A, 0x3B09, 0x3B29, 0x4348, 0x3B48, 0x3B48, 0x3B68, 0x3B68, 0x3B87, 0x3BA7, 0x3BC7, 0x33C7, 0x33C7, 
        0x33C7, 0x33E7, 0x33C7, 0x33C7, 0x33A8, 0x3BAB, 0x5C31, 0x7CD8, 0x847C, 0x843D, 0x83FE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x635E, 
        0x635E, 0x635E, 0x637E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x739E, 0x739E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x635E, 0x6B5E, 0x633E, 0x633E, 0x635E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x635E, 
        0x635E, 0x635E, 0x635E, 0x6B5E, 0x637E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x73DD, 0x745B, 0x6C37, 0x4B51, 0x5B73, 0x6396, 0x6359, 0x631B, 0x62DC, 0x62BD, 0x62DD, 0x6AFE, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x731E, 0x72FE, 0x72FE, 0x731E, 0x731E, 
        0x72FE, 0x6AFE, 0x6ADD, 0x62DD, 0x629D, 0x629E, 0x62DD, 0x6B1D, 0x6B5C, 0x737C, 0x739B, 0x7BBA, 0x73F8, 0x6BB4, 0x4AEF, 0x322A, 0x29E9, 0x2A09, 0x2A29, 0x326A, 0x3AAA, 0x4B4C, 0x5C0E, 0x644F, 0x648F, 0x648E, 0x646F, 0x6430, 0x63F2, 0x7435, 
        0x7455, 0x7473, 0x74B2, 0x74D0, 0x6CF0, 0x650F, 0x64EF, 0x5CCF, 0x5CAE, 0x5C8F, 0x6470, 0x6451, 0x6C72, 0x74D3, 0x7D14, 0x7534, 0x6D53, 0x6D53, 0x6D72, 0x5CEF, 0x3BEA, 0x2BA8, 0x33C8, 0x33E8, 0x3C08, 0x3C28, 0x4449, 0x4C69, 0x4C69, 0x4C69, 
        0x4C69, 0x4C49, 0x4C49, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C29, 0x5409, 0x5409, 0x4BC9, 0x4BA9, 0x4B89, 0x4368, 0x4348, 0x4B69, 0x742D, 0x9CF0, 0xB551, 0xBD70, 0xBD6F, 0xB54F, 0xA50E, 0x9CCE, 0x8C8D, 0x7C2D, 0x638B, 0x42C9, 0x2A68, 0x2227, 0x2226, 
        0x2226, 0x1A26, 0x1A26, 0x1A46, 0x1A65, 0x1265, 0x12A5, 0x1AA5, 0x1AE6, 0x1B06, 0x2326, 0x2366, 0x2386, 0x2B87, 0x2BA7, 0x2BC7, 0x33E7, 0x3407, 0x3428, 0x3C28, 0x3C48, 0x3C49, 0x3C69, 0x4469, 0x4C89, 0x4CAA, 0x54AA, 0x548A, 0x548A, 0x548A, 
        0x5C8A, 0x5CAA, 0x5CAA, 0x5CAB, 0x5CCB, 0x5CAB, 0x5CAB, 0x5CAB, 0x5C8B, 0x546B, 0x544A, 0x4C29, 0x4BE9, 0x43C8, 0x3B88, 0x3B68, 0x3347, 0x3347, 0x3348, 0x2B48, 0x2B48, 0x3348, 0x3348, 0x3B48, 0x3B68, 0x4388, 0x4388, 0x43A8, 0x4BC8,
  0x2AE5, 0x2AE5, 0x2AE5, 0x2AE4, 0x2AC4, 0x2AA4, 0x2AA4, 0x2A84, 0x2284, 0x2AC4, 0x43A7, 0x5CAB, 0x4C6A, 0x4CAA, 0x44CA, 0x44CA, 0x44CA, 0x44EB, 0x450B, 0x4D4B, 0x556C, 0x5DAD, 0x5DCD, 0x65CE, 0x75EF, 0x7E11, 0x5C4C, 0x32A6, 0x3286, 0x3265, 0x2243, 
        0x2243, 0x1A43, 0x1A43, 0x1A63, 0x1A84, 0x22A4, 0x22C5, 0x2AE5, 0x3306, 0x3B26, 0x3B47, 0x4367, 0x4367, 0x4387, 0x4B88, 0x4B88, 0x4B88, 0x4BA8, 0x53A9, 0x53C9, 0x5BEA, 0x642B, 0x6C4B, 0x6C6C, 0x748C, 0x7CAC, 0x84CD, 0x8CCD, 0x8CCE, 0x84AE, 
        0x848E, 0x7C8E, 0x7C4F, 0x744E, 0x6C6E, 0x6C6E, 0x6C6E, 0x748D, 0x74AD, 0x74AD, 0x748D, 0x6C6D, 0x6C2C, 0x640B, 0x5BEB, 0x53CA, 0x53C9, 0x4BC9, 0x43C8, 0x43A8, 0x43A8, 0x3B88, 0x3B68, 0x3B68, 0x53CA, 0x640C, 0x5BEC, 0x4B6A, 0x4B6B, 0x5BCD, 
        0x63EE, 0x5C0E, 0x4C0E, 0x4C2E, 0x548F, 0x5CEF, 0x6530, 0x6D51, 0x6D71, 0x7551, 0x6510, 0x5C8E, 0x4C0B, 0x442A, 0x3C09, 0x23A6, 0x1B65, 0x1B45, 0x1324, 0x1324, 0x1304, 0x12E4, 0x12C4, 0x12A4, 0x1283, 0x1244, 0x1224, 0x1204, 0x1204, 0x1A04, 
        0x1A04, 0x1A04, 0x1A24, 0x1A45, 0x1A45, 0x2265, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x2B07, 0x2B07, 0x3327, 0x3B49, 0x4B6B, 0x538D, 0x5B6F, 0x5370, 0x5390, 0x53CF, 0x43AD, 0x3B2A, 0x3308, 0x32E8, 0x2AC7, 0x2AA7, 0x2A87, 
        0x2266, 0x2226, 0x2226, 0x1A06, 0x1A05, 0x1A25, 0x2225, 0x2245, 0x2A65, 0x2A65, 0x2A85, 0x2AA5, 0x32A5, 0x32A5, 0x3AC6, 0x3AC6, 0x3AE6, 0x3AE6, 0x3AE7, 0x32C7, 0x32A7, 0x3287, 0x3267, 0x2A46, 0x2A26, 0x2A06, 0x2A26, 0x2A26, 0x3246, 0x3287, 
        0x32A7, 0x32C7, 0x32E6, 0x3306, 0x3B26, 0x3B47, 0x3B67, 0x4388, 0x4B6D, 0x8499, 0x8C3D, 0x83FD, 0x7BBE, 0x7B9E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BFD, 0x845C, 0x84D8, 0x6CD3, 0x5C6E, 0x4C2C, 0x442B, 0x4C0B, 0x4C0B, 0x4C0C, 0x542E, 0x5C4F, 0x6471, 
        0x6C92, 0x74D4, 0x7CD6, 0x84D8, 0x8CD9, 0x8CB9, 0x8CBA, 0x8C9A, 0x8C7B, 0x8C7B, 0x8C7B, 0x8C7B, 0x8C7B, 0x8CBA, 0x8CB9, 0x84B8, 0x7C96, 0x7453, 0x63F0, 0x538D, 0x4B6B, 0x4349, 0x3B48, 0x3B48, 0x3367, 0x3B87, 0x33A7, 0x33A7, 0x33C7, 0x33C7, 
        0x33C7, 0x33C7, 0x33C8, 0x33A8, 0x43CD, 0x6C95, 0x84BB, 0x847D, 0x841E, 0x7BFE, 0x7BDE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x635E, 0x635E, 
        0x635E, 0x635E, 0x635E, 0x637E, 0x637E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B7E, 0x6B7E, 0x635D, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635D, 0x635D, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 
        0x635E, 0x635E, 0x635E, 0x635E, 0x635D, 0x635E, 0x635E, 0x637E, 0x637E, 0x6B9D, 0x73DD, 0x7C3C, 0x741B, 0x6B9A, 0x633B, 0x62FC, 0x62BD, 0x62BD, 0x62BE, 0x62FE, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x72FE, 0x72FE, 
        0x72DE, 0x6ADE, 0x62BE, 0x5A9D, 0x5A9D, 0x62BE, 0x62DE, 0x6B1D, 0x6B3D, 0x6B3D, 0x733D, 0x735D, 0x737D, 0x7BDB, 0x73F8, 0x63B4, 0x42AE, 0x2A0A, 0x2A29, 0x3249, 0x3A8A, 0x3AEA, 0x4B8C, 0x644E, 0x648F, 0x648F, 0x646F, 0x5C30, 0x6412, 0x6C35, 
        0x7455, 0x7C94, 0x74D2, 0x6CF0, 0x64F0, 0x5CEF, 0x5CAF, 0x546E, 0x542F, 0x5C30, 0x6431, 0x6431, 0x6C72, 0x74D4, 0x7D34, 0x7554, 0x6D53, 0x6D53, 0x6D51, 0x548D, 0x33A9, 0x33A7, 0x33C7, 0x3BE8, 0x3C08, 0x3C28, 0x4448, 0x4C69, 0x4C69, 0x4C69, 
        0x4C49, 0x4C49, 0x4449, 0x4C2A, 0x4C29, 0x4C29, 0x4C09, 0x4BE9, 0x4BC9, 0x4BA9, 0x4B89, 0x4368, 0x4348, 0x4328, 0x4B49, 0x63CB, 0x8C8E, 0xAD30, 0xB550, 0xAD4F, 0xA50E, 0x9CCD, 0x94AE, 0x846E, 0x6BEC, 0x4B0A, 0x3288, 0x2227, 0x2226, 0x1A26, 
        0x1A26, 0x1A26, 0x1A26, 0x1A45, 0x1265, 0x1265, 0x1AA5, 0x1AC5, 0x1AE6, 0x1B26, 0x2346, 0x2386, 0x2B86, 0x2BA6, 0x2BC7, 0x2BE7, 0x3407, 0x3407, 0x3428, 0x3C28, 0x3C48, 0x3C49, 0x3C69, 0x4489, 0x4C89, 0x4CAA, 0x4C8A, 0x548A, 0x548A, 0x548A, 
        0x548A, 0x54AA, 0x54AA, 0x5CAB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CAB, 0x54AB, 0x546A, 0x4C2A, 0x4C29, 0x43E9, 0x3BA8, 0x3B88, 0x3B67, 0x3347, 0x3347, 0x2B27, 0x2B07, 0x2B07, 0x2B27, 0x3327, 0x3348, 0x3B48, 0x3B68, 0x4388, 0x4388, 0x43A8,
  0x2AE5, 0x2AE5, 0x2AE5, 0x2AE4, 0x2AC4, 0x2AA4, 0x2AA4, 0x2A84, 0x2264, 0x2284, 0x2AC5, 0x1AA3, 0x2B45, 0x4CAA, 0x4CEA, 0x4CEA, 0x450B, 0x4D2B, 0x4D4B, 0x556C, 0x55AD, 0x5DCD, 0x660E, 0x6E0F, 0x760F, 0x75F0, 0x4BEB, 0x2A65, 0x2A45, 0x2A44, 0x2263, 
        0x2263, 0x1A63, 0x1A63, 0x1A63, 0x1A83, 0x22A4, 0x22E5, 0x2AE5, 0x3326, 0x3B46, 0x3B67, 0x4387, 0x43A7, 0x43A7, 0x4BA7, 0x43A8, 0x4BA8, 0x4BA8, 0x4B88, 0x4B88, 0x4BA9, 0x53EA, 0x642B, 0x6C6B, 0x748C, 0x7CCC, 0x8CED, 0x94ED, 0x950E, 0x94EE, 
        0x8CCE, 0x8CAF, 0x848F, 0x746E, 0x6C6E, 0x6C4E, 0x6C4E, 0x6C4D, 0x6C6D, 0x6C8D, 0x6C6D, 0x6C4D, 0x6C2C, 0x640B, 0x5BCA, 0x53C9, 0x4BC9, 0x4BC8, 0x43C8, 0x43A8, 0x3BA8, 0x3B88, 0x3B68, 0x4388, 0x540B, 0x6C4C, 0x63EC, 0x4B6A, 0x4329, 0x538C, 
        0x5BCD, 0x5BEE, 0x540E, 0x4C0D, 0x544E, 0x5CCF, 0x6510, 0x6D51, 0x6D71, 0x7571, 0x6D30, 0x5CAE, 0x4C0B, 0x43EA, 0x33C8, 0x2386, 0x1B65, 0x1B45, 0x1B45, 0x1B24, 0x1304, 0x12E4, 0x12C4, 0x12C4, 0x1284, 0x1264, 0x1244, 0x1224, 0x1224, 0x1204, 
        0x1A04, 0x1A24, 0x1A44, 0x1A64, 0x1A84, 0x1A85, 0x22A5, 0x22E6, 0x22E6, 0x22E5, 0x22E5, 0x22E6, 0x2306, 0x2326, 0x2B27, 0x3348, 0x3B89, 0x4BAC, 0x538D, 0x5B8F, 0x5B90, 0x53D0, 0x53CF, 0x438C, 0x332A, 0x3308, 0x32E7, 0x2AC7, 0x2AA7, 0x2AA7, 
        0x2266, 0x2246, 0x1A26, 0x1A25, 0x1A25, 0x1A25, 0x2225, 0x2245, 0x2245, 0x2265, 0x2A85, 0x2A85, 0x2AA5, 0x32A5, 0x32A6, 0x32C6, 0x32C6, 0x32C6, 0x32C6, 0x32A6, 0x2AA7, 0x2A67, 0x2A46, 0x2A26, 0x2A06, 0x2206, 0x2A06, 0x2A26, 0x2A46, 0x2A66, 
        0x3286, 0x32C6, 0x2AC6, 0x32E6, 0x3306, 0x3326, 0x3B47, 0x4348, 0x5B91, 0x8C5B, 0x8BFE, 0x83BE, 0x7B9E, 0x7B9E, 0x739E, 0x737E, 0x737E, 0x739E, 0x7BBE, 0x7C1D, 0x849A, 0x84F8, 0x7D16, 0x7D15, 0x7CF5, 0x7CF6, 0x84F7, 0x84F8, 0x84D9, 0x84BA, 
        0x84BA, 0x847C, 0x847C, 0x843D, 0x841D, 0x841D, 0x83FE, 0x83FE, 0x83DE, 0x83DE, 0x83DE, 0x83DE, 0x83DE, 0x83FD, 0x841D, 0x843D, 0x845C, 0x847B, 0x849A, 0x8499, 0x7CB6, 0x6C73, 0x5C10, 0x4BAD, 0x438A, 0x3B88, 0x33A7, 0x33A7, 0x33C7, 0x33C7, 
        0x33C7, 0x33C7, 0x3389, 0x4BCE, 0x7497, 0x7C7B, 0x7C3D, 0x7C1E, 0x7BDE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x5B5E, 0x5B5E, 0x635E, 
        0x635E, 0x635E, 0x5B5D, 0x635E, 0x635E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x635E, 0x635D, 0x635D, 0x635E, 0x5B5E, 0x5B3E, 0x633E, 0x5B3D, 0x633E, 0x633E, 0x635E, 0x5B5D, 0x5B3D, 0x5B5D, 0x635D, 0x635E, 0x635E, 0x635E, 0x5B5E, 
        0x5B3E, 0x5B3E, 0x5B3E, 0x633E, 0x5B3E, 0x635E, 0x635E, 0x635E, 0x637E, 0x637E, 0x6BBE, 0x73DE, 0x73DE, 0x739D, 0x631D, 0x62DD, 0x5ABD, 0x5ABD, 0x62DD, 0x6AFE, 0x6B1E, 0x6B1E, 0x6AFE, 0x6B1E, 0x6B1E, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x72DE, 
        0x6ADE, 0x62BD, 0x5A9D, 0x5ABD, 0x5ADE, 0x62DE, 0x62FE, 0x631D, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x733E, 0x737D, 0x7BBC, 0x7BFA, 0x73D7, 0x5311, 0x3A6B, 0x324A, 0x326A, 0x3ACA, 0x432B, 0x5BED, 0x646F, 0x648F, 0x648F, 0x5C30, 0x5BF2, 0x6C34, 
        0x7475, 0x74B4, 0x74F2, 0x6CF0, 0x5CCF, 0x5CCF, 0x548F, 0x5C4F, 0x5C30, 0x6411, 0x6411, 0x6411, 0x6C52, 0x74D3, 0x7514, 0x7553, 0x6D52, 0x6532, 0x5CF0, 0x440B, 0x2B67, 0x33A7, 0x33C7, 0x3BE8, 0x3C08, 0x4428, 0x4449, 0x4C49, 0x4C69, 0x4C49, 
        0x4C49, 0x4C49, 0x4C29, 0x4C29, 0x4C09, 0x4C09, 0x4BE9, 0x4BC9, 0x43A8, 0x4B88, 0x4368, 0x4348, 0x4348, 0x4328, 0x4328, 0x5B6A, 0x844D, 0xA50F, 0xAD2F, 0xA50E, 0x9CCE, 0x94AE, 0x94CF, 0x8CAF, 0x740E, 0x532B, 0x3288, 0x2247, 0x2226, 0x1A26, 
        0x1A26, 0x1A25, 0x1A25, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC6, 0x1AE6, 0x2326, 0x2346, 0x2386, 0x2BA6, 0x2BA7, 0x2BC7, 0x33E7, 0x3407, 0x3407, 0x3C28, 0x3C48, 0x3C48, 0x3C69, 0x3C69, 0x4489, 0x4489, 0x4C89, 0x4C69, 0x5469, 0x5489, 0x5469, 
        0x548A, 0x548A, 0x54AA, 0x54AB, 0x5CCB, 0x5CCB, 0x5CCB, 0x54AB, 0x548B, 0x546A, 0x4C29, 0x4C09, 0x43E9, 0x3BA8, 0x3B88, 0x3B68, 0x3B47, 0x3327, 0x2B07, 0x2B07, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x3327, 0x3B48, 0x3B48, 0x4388, 0x4388,
  0x32E5, 0x32E5, 0x32E5, 0x2AE5, 0x2AC4, 0x2AA4, 0x2A84, 0x2284, 0x2264, 0x2264, 0x2263, 0x1A63, 0x1AA3, 0x4428, 0x550B, 0x4D0B, 0x4D2B, 0x4D4B, 0x4D6C, 0x558C, 0x5DED, 0x5E0E, 0x662E, 0x6E2F, 0x7630, 0x7E11, 0x544C, 0x2A65, 0x2A65, 0x2A64, 0x2263, 
        0x2283, 0x1A63, 0x1A83, 0x1A83, 0x1AA4, 0x22C4, 0x2AE5, 0x3305, 0x3326, 0x3B46, 0x4367, 0x4387, 0x43A7, 0x43C7, 0x4BC7, 0x4BC8, 0x4BC8, 0x4BC8, 0x43A8, 0x4388, 0x4388, 0x4BC9, 0x53EA, 0x642B, 0x6C6C, 0x7CAD, 0x8CED, 0x950D, 0x9D2E, 0x9D0F, 
        0x950F, 0x8CEE, 0x84AE, 0x7C8E, 0x746E, 0x744E, 0x6C2E, 0x6C0E, 0x6C2E, 0x6C4D, 0x6C4D, 0x6C2D, 0x6C0C, 0x640B, 0x5BCA, 0x53C9, 0x4BC8, 0x43C8, 0x43A7, 0x43A7, 0x3BA7, 0x3B87, 0x3B67, 0x4388, 0x5C0B, 0x6C6D, 0x640C, 0x436A, 0x3B09, 0x4B4A, 
        0x53AC, 0x5BED, 0x540D, 0x4C0D, 0x4C2D, 0x54AF, 0x6510, 0x6D50, 0x7571, 0x7571, 0x6D51, 0x5CAE, 0x4BEB, 0x3BA9, 0x2B67, 0x2366, 0x1B45, 0x1B65, 0x1B65, 0x1B45, 0x1325, 0x1305, 0x12E4, 0x12C4, 0x12A4, 0x1284, 0x1264, 0x1244, 0x1244, 0x1224, 
        0x1A44, 0x1A44, 0x1A64, 0x1A84, 0x1AA4, 0x1AA5, 0x1AC5, 0x22E5, 0x2305, 0x2305, 0x2305, 0x2326, 0x2326, 0x2346, 0x2B47, 0x3368, 0x438A, 0x4BAC, 0x53AE, 0x5B90, 0x5BD1, 0x53F0, 0x53EF, 0x438C, 0x3B49, 0x3328, 0x3307, 0x2AE7, 0x2AC7, 0x22A7, 
        0x2286, 0x2266, 0x1A25, 0x1A25, 0x1A25, 0x1A25, 0x2245, 0x2245, 0x2245, 0x2265, 0x2A65, 0x2A85, 0x2A85, 0x2A85, 0x32A6, 0x32A6, 0x32A6, 0x2AA6, 0x2AA6, 0x2AA6, 0x2A86, 0x2A46, 0x2226, 0x2206, 0x2206, 0x21E5, 0x21E6, 0x2206, 0x2A26, 0x2A46, 
        0x2A66, 0x2AA6, 0x2AC6, 0x32C6, 0x32E6, 0x3307, 0x3B27, 0x3AE9, 0x6394, 0x83FD, 0x83BE, 0x839E, 0x7B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x737E, 0x737E, 0x7BDD, 0x7C3C, 0x847B, 0x8C9B, 0x8C9B, 0x847C, 0x845C, 0x843C, 0x841C, 0x7BFD, 
        0x7BDD, 0x83DD, 0x83DE, 0x83BE, 0x7BBE, 0x7BBE, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BDD, 0x7BFD, 0x7C1D, 0x843C, 0x843B, 0x7C79, 0x7C97, 0x74B4, 0x6490, 0x4C0C, 0x3BA9, 0x33A8, 0x33A7, 
        0x33A7, 0x3389, 0x53F0, 0x7CB8, 0x7C5C, 0x7C1E, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x6BBE, 0x73BE, 0x73BE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x637E, 0x639E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x635D, 
        0x635D, 0x635E, 0x5B5D, 0x5B5E, 0x635E, 0x635E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x5B3E, 0x5B3E, 0x5B3D, 0x5B3D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 
        0x5B3E, 0x5B3E, 0x5B3D, 0x5B3D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B5E, 0x5B5E, 0x637E, 0x639E, 0x6BBE, 0x73DE, 0x73BE, 0x6B5E, 0x5ADD, 0x5ABD, 0x5A9D, 0x5ADD, 0x6AFE, 0x6B3E, 0x6B1E, 0x6AFE, 0x6AFD, 0x6AFE, 0x6ADE, 0x6ADE, 0x6ADD, 0x6ADE, 0x6ADE, 
        0x6ABD, 0x629D, 0x5A9D, 0x5ABE, 0x5ADE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x6B1E, 0x6B1E, 0x733E, 0x735D, 0x7B7C, 0x7BBB, 0x7BF9, 0x6BB5, 0x4B0F, 0x3A8B, 0x3AAA, 0x430A, 0x538C, 0x642E, 0x6CB0, 0x6490, 0x5C50, 0x53F1, 0x6413, 
        0x7475, 0x74D4, 0x6CF2, 0x6510, 0x5CEF, 0x54CF, 0x548F, 0x6450, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C72, 0x74D4, 0x7D34, 0x7553, 0x6D52, 0x6511, 0x54AE, 0x33A9, 0x2B67, 0x33A7, 0x33C7, 0x3BE7, 0x3C08, 0x4428, 0x4449, 0x4449, 0x4C49, 0x4C49, 
        0x4449, 0x4C29, 0x4C29, 0x4C09, 0x4C09, 0x4BE9, 0x43C9, 0x43A9, 0x4388, 0x4388, 0x4368, 0x4348, 0x4348, 0x4328, 0x4328, 0x5B8A, 0x8C6E, 0xA50F, 0xA50F, 0x9CCE, 0x94AE, 0x94CF, 0x94D0, 0x7C6F, 0x638D, 0x4AEA, 0x3288, 0x2A47, 0x2226, 0x2226, 
        0x1A26, 0x1A25, 0x1A25, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC6, 0x1B06, 0x2326, 0x2366, 0x2B86, 0x2BA6, 0x2BC7, 0x2BC7, 0x33E7, 0x3407, 0x3C27, 0x3C48, 0x3C48, 0x3C68, 0x3C69, 0x3C69, 0x4489, 0x4489, 0x4C89, 0x4C69, 0x5469, 0x5489, 0x5469, 
        0x546A, 0x548A, 0x54AA, 0x54AB, 0x5CCB, 0x54AB, 0x54AB, 0x548B, 0x548A, 0x4C6A, 0x4C29, 0x4409, 0x43E8, 0x43A8, 0x3B88, 0x3B68, 0x3B48, 0x3327, 0x2B07, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x3307, 0x3B28, 0x3B48, 0x3B68,
  0x32E5, 0x32E5, 0x32E5, 0x2AC4, 0x2AA4, 0x2AA4, 0x2A84, 0x2264, 0x2244, 0x2244, 0x2244, 0x1A63, 0x1A83, 0x3366, 0x5D0B, 0x552B, 0x4D4B, 0x556C, 0x558C, 0x55AC, 0x5DED, 0x5E0E, 0x662E, 0x6E4E, 0x762F, 0x7E11, 0x6D0F, 0x42E8, 0x2A65, 0x2A64, 0x2283, 
        0x1A83, 0x2283, 0x1A83, 0x1AA3, 0x22C4, 0x22C4, 0x2AE5, 0x3305, 0x3B46, 0x3B66, 0x4386, 0x4BA7, 0x4BC7, 0x4BE7, 0x4BE7, 0x4BE8, 0x4BE8, 0x4BE8, 0x43C8, 0x43A8, 0x4388, 0x3B88, 0x43A9, 0x53CA, 0x5C0B, 0x6C4C, 0x7CAC, 0x8CED, 0x950E, 0x9D0E, 
        0x9D0E, 0x94EE, 0x8CAE, 0x848E, 0x7C6F, 0x744F, 0x742E, 0x6C0E, 0x6C0E, 0x6C0E, 0x6C0D, 0x6C0D, 0x6BED, 0x63EC, 0x5BCA, 0x53C9, 0x4BC8, 0x43A7, 0x43A7, 0x3BA7, 0x3BA7, 0x3387, 0x3387, 0x43A9, 0x5C4B, 0x6C6C, 0x5C0B, 0x4369, 0x3B08, 0x4309, 
        0x5BAC, 0x6C4E, 0x5C0E, 0x53ED, 0x4C0D, 0x548E, 0x5CEF, 0x6530, 0x6D71, 0x7571, 0x7551, 0x64CF, 0x4C2C, 0x3BA9, 0x2B67, 0x2346, 0x1B45, 0x1B65, 0x1B45, 0x1B45, 0x1B25, 0x1B05, 0x1305, 0x12E4, 0x12C4, 0x12A4, 0x1284, 0x1264, 0x1264, 0x1264, 
        0x1A64, 0x1A64, 0x1A84, 0x1AA4, 0x1AA4, 0x1AC5, 0x1AE5, 0x1B05, 0x1B05, 0x1B05, 0x2325, 0x2346, 0x2366, 0x2B66, 0x2B87, 0x3B88, 0x43AA, 0x53AD, 0x53AE, 0x5BB0, 0x5C11, 0x5C10, 0x53EE, 0x438C, 0x3B4A, 0x3328, 0x3307, 0x2B07, 0x2AE7, 0x2AC6, 
        0x2286, 0x2266, 0x2245, 0x1A45, 0x2225, 0x2245, 0x2245, 0x2245, 0x2246, 0x2266, 0x2265, 0x2285, 0x2A85, 0x2A85, 0x2AA5, 0x32A6, 0x2AA6, 0x2A86, 0x2A86, 0x2A86, 0x2A66, 0x2246, 0x2206, 0x2206, 0x21E5, 0x19C5, 0x21C5, 0x21E6, 0x2206, 0x2226, 
        0x2A46, 0x2A86, 0x2AA6, 0x2AA6, 0x32C6, 0x32E6, 0x3307, 0x3ACA, 0x6B96, 0x83BD, 0x837E, 0x7B7E, 0x7B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x735E, 0x735E, 0x737E, 0x739D, 0x7BDD, 0x83FD, 0x83DE, 0x83DE, 0x83DE, 0x7BBD, 0x7B9D, 0x7B9E, 
        0x7B9E, 0x7B9E, 0x7B9E, 0x7B7E, 0x7B7E, 0x7B7E, 0x737E, 0x735E, 0x737E, 0x7B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x739E, 0x739E, 0x7BBE, 0x7BBD, 0x7BDD, 0x7BDD, 0x73FB, 0x7458, 0x6C76, 0x5C32, 0x43CC, 0x3389, 
        0x338A, 0x5C31, 0x7C99, 0x7C5D, 0x7BFE, 0x73DE, 0x73BE, 0x73DE, 0x73DE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x5B5E, 
        0x5B5E, 0x5B5E, 0x5B5D, 0x635E, 0x635E, 0x635E, 0x6B7E, 0x637E, 0x635E, 0x5B3E, 0x5B3E, 0x5B1D, 0x5B1D, 0x5B1D, 0x531E, 0x531E, 0x531E, 0x531E, 0x5B1D, 0x5B1D, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 
        0x5B3E, 0x5B3E, 0x531D, 0x5B1D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B5E, 0x5B5E, 0x637E, 0x639E, 0x6BBE, 0x73BE, 0x73BE, 0x6B9E, 0x633D, 0x62DD, 0x5ABD, 0x62DD, 0x6B1E, 0x6B3D, 0x6B1E, 0x6AFD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADD, 0x6ADD, 0x6ABE, 0x62BE, 
        0x62BE, 0x62BE, 0x62BE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x6B1E, 0x6B1E, 0x733E, 0x733D, 0x737D, 0x7B9C, 0x7BDA, 0x7BF7, 0x5B71, 0x42EC, 0x42EB, 0x4B4C, 0x5BCD, 0x6C90, 0x6490, 0x5C70, 0x53F1, 0x5C13, 
        0x6474, 0x6CD3, 0x6512, 0x6510, 0x5D0F, 0x5CEF, 0x5C6F, 0x6431, 0x6C52, 0x7452, 0x7473, 0x7493, 0x74B3, 0x7D14, 0x7D74, 0x7593, 0x7592, 0x5D10, 0x440B, 0x2B47, 0x2B67, 0x3387, 0x33C7, 0x3BE8, 0x4408, 0x4429, 0x4429, 0x4449, 0x4449, 0x4C29, 
        0x4C29, 0x4C09, 0x4409, 0x43E9, 0x43C9, 0x43C9, 0x43A9, 0x4389, 0x4388, 0x4368, 0x4368, 0x4348, 0x4348, 0x4328, 0x4328, 0x63CB, 0x8C8F, 0x9CEF, 0x9CAF, 0x948E, 0x94AF, 0x8CCF, 0x7C4E, 0x5B6B, 0x42C9, 0x3268, 0x2A47, 0x2247, 0x2226, 0x1A46, 
        0x1A25, 0x1A45, 0x1A45, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AE6, 0x1B06, 0x2326, 0x2B66, 0x2B86, 0x2BA6, 0x33C7, 0x33E7, 0x3407, 0x3C27, 0x3C27, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x4489, 0x4489, 0x4469, 0x4C69, 0x546A, 0x546A, 0x546A, 
        0x5489, 0x548A, 0x54AA, 0x54AA, 0x54AB, 0x54AB, 0x548A, 0x548A, 0x4C6A, 0x4C4A, 0x4429, 0x4409, 0x43E8, 0x43C8, 0x3BA8, 0x3B88, 0x3B68, 0x3327, 0x3307, 0x2B07, 0x22E7, 0x22C7, 0x22C7, 0x22C7, 0x2AC7, 0x2AE7, 0x3307, 0x3307, 0x3B28,
  0x32E5, 0x32E5, 0x2AE5, 0x2AC4, 0x2AA4, 0x2A84, 0x2A84, 0x2264, 0x2244, 0x2224, 0x2244, 0x2244, 0x1A63, 0x2B25, 0x54EB, 0x552B, 0x4D2B, 0x558C, 0x55AC, 0x55AC, 0x5DED, 0x5DED, 0x660E, 0x6E2E, 0x764F, 0x7E31, 0x64AE, 0x3285, 0x2A85, 0x2A84, 0x1A83, 
        0x1A83, 0x2283, 0x1AA3, 0x22C3, 0x22C4, 0x2AE4, 0x3305, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x4BA7, 0x4BC7, 0x53E7, 0x53E8, 0x53E8, 0x4C08, 0x4BE8, 0x4BE7, 0x43C8, 0x3BA8, 0x3B68, 0x3B68, 0x4389, 0x4BAA, 0x5BEB, 0x6C4C, 0x748C, 0x84AD, 0x8CCD, 
        0x8CAD, 0x8CAD, 0x848E, 0x846E, 0x7C6E, 0x7C4E, 0x742F, 0x73EF, 0x6BCF, 0x6BEF, 0x63CE, 0x6BEE, 0x6BED, 0x5BCB, 0x53A9, 0x4BA8, 0x4BC7, 0x43A7, 0x43A7, 0x3BA7, 0x3387, 0x3387, 0x3387, 0x4BE9, 0x644C, 0x6C4D, 0x5C0C, 0x4369, 0x3B28, 0x4329, 
        0x5BCC, 0x640D, 0x5BED, 0x53ED, 0x53ED, 0x544E, 0x5CAF, 0x6510, 0x6D51, 0x7572, 0x7571, 0x6510, 0x4C4C, 0x33A9, 0x2B67, 0x2366, 0x2366, 0x2365, 0x2365, 0x1B45, 0x1B25, 0x1B25, 0x1B25, 0x1304, 0x12E4, 0x12C4, 0x1AA4, 0x1AA4, 0x1A84, 0x1284, 
        0x1284, 0x1284, 0x1284, 0x1AA4, 0x1AC4, 0x1AE5, 0x1B05, 0x1B25, 0x1B25, 0x1B45, 0x2345, 0x2366, 0x2386, 0x2386, 0x2B87, 0x3BA8, 0x4BAB, 0x53AD, 0x5BAF, 0x5BF0, 0x6431, 0x6C50, 0x642E, 0x4BAC, 0x3B69, 0x3B48, 0x3307, 0x3307, 0x2AE7, 0x2AC6, 
        0x2A86, 0x2A86, 0x2266, 0x2245, 0x2245, 0x2246, 0x2245, 0x2245, 0x2266, 0x2266, 0x2266, 0x2285, 0x2285, 0x2A85, 0x2A85, 0x2A85, 0x2A85, 0x2A86, 0x2286, 0x2A66, 0x2A46, 0x2226, 0x2206, 0x21E6, 0x19C5, 0x19C5, 0x19A5, 0x21C5, 0x21E6, 0x2206, 
        0x2226, 0x2246, 0x2A86, 0x2A86, 0x2AA6, 0x32C7, 0x32E7, 0x42AC, 0x7398, 0x839E, 0x835E, 0x7B7E, 0x7B7E, 0x7B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x735E, 0x735D, 0x735E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7B9E, 0x737E, 0x737E, 0x7B7E, 
        0x7B7E, 0x7B5E, 0x7B5E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x735E, 0x6B5E, 0x6B5E, 0x735E, 0x735E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x735E, 0x6B5D, 0x6B7C, 0x6BBA, 0x63F7, 0x6434, 0x53F2, 
        0x6434, 0x7C9A, 0x7C3D, 0x7BFE, 0x73DE, 0x73DE, 0x73BE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x63BE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x637E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 
        0x5B5E, 0x5B5E, 0x5B5D, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x5B3E, 0x5B1E, 0x531E, 0x531E, 0x5B1D, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x531E, 0x5B1E, 0x5B1E, 0x531D, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x531E, 
        0x531E, 0x531E, 0x531E, 0x531D, 0x533E, 0x533E, 0x5B3E, 0x5B5E, 0x5B5E, 0x637E, 0x639E, 0x6B9E, 0x73BE, 0x73DE, 0x73BE, 0x739E, 0x631D, 0x62FD, 0x733E, 0x7B7E, 0x7B9E, 0x6B3E, 0x62DD, 0x6ADD, 0x6ADE, 0x6ADE, 0x6ADE, 0x62DD, 0x62DE, 0x62BE, 
        0x62DE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x631E, 0x6B1E, 0x6B3E, 0x6B3E, 0x6B3D, 0x733E, 0x7B7D, 0x7BDB, 0x7C19, 0x7434, 0x5BB0, 0x534D, 0x536C, 0x5BEE, 0x6490, 0x5C70, 0x4BF1, 0x4BF2, 
        0x5C73, 0x64F3, 0x6532, 0x5D50, 0x5D4F, 0x5D10, 0x64B0, 0x6C51, 0x6C52, 0x7472, 0x7493, 0x74B3, 0x74F3, 0x7D54, 0x7DB4, 0x7DD3, 0x75B2, 0x54AE, 0x2B88, 0x2B46, 0x2B67, 0x3387, 0x33A7, 0x3BE8, 0x4408, 0x4429, 0x4429, 0x4429, 0x4429, 0x4C29, 
        0x4409, 0x43E9, 0x43C9, 0x43C9, 0x43A9, 0x43A9, 0x4388, 0x4368, 0x3B68, 0x3B68, 0x3B48, 0x3B28, 0x4328, 0x4328, 0x4B49, 0x744D, 0x94D0, 0x9CD0, 0x948F, 0x8C8F, 0x846F, 0x6BEC, 0x534A, 0x3AA8, 0x3267, 0x2A47, 0x2247, 0x2246, 0x1A46, 0x1A45, 
        0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1265, 0x1A85, 0x1AC5, 0x1AE5, 0x2306, 0x2346, 0x2B86, 0x2BA6, 0x2BC6, 0x33E7, 0x3407, 0x3407, 0x3C27, 0x3C27, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x4489, 0x4468, 0x4468, 0x4469, 0x4C69, 0x5469, 0x4C6A, 
        0x4C69, 0x4C89, 0x548A, 0x548A, 0x548A, 0x4C8A, 0x4C8A, 0x4C6A, 0x4C69, 0x4449, 0x4409, 0x4408, 0x43E8, 0x43C8, 0x43C8, 0x3B88, 0x3B68, 0x3348, 0x3327, 0x2B07, 0x22C7, 0x22C7, 0x22C7, 0x22A7, 0x22A7, 0x2AC7, 0x2AE7, 0x32E7, 0x3307,
  0x32E5, 0x32E5, 0x2AC5, 0x2AA4, 0x2A85, 0x2A85, 0x2264, 0x2244, 0x2224, 0x2224, 0x2224, 0x2224, 0x2244, 0x3B66, 0x5CCB, 0x552B, 0x4D4B, 0x452A, 0x4D6B, 0x55AC, 0x55ED, 0x664E, 0x664E, 0x664E, 0x6E4F, 0x6DD0, 0x750F, 0x3286, 0x2A85, 0x2A84, 0x2283, 
        0x22A3, 0x1AA3, 0x22C3, 0x22E3, 0x2AE4, 0x2B05, 0x3325, 0x3B25, 0x4366, 0x4386, 0x4BA6, 0x53C7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x5407, 0x53E7, 0x4BE7, 0x43C8, 0x43A8, 0x3B67, 0x3B68, 0x3B49, 0x4369, 0x4B8A, 0x5BCA, 0x640B, 0x6C2B, 0x7C4C, 
        0x7C4C, 0x742C, 0x742C, 0x740C, 0x740D, 0x73ED, 0x73EE, 0x73CF, 0x6BAF, 0x6BAF, 0x63AF, 0x6BCE, 0x63CD, 0x5BAB, 0x5389, 0x4BA8, 0x4BC7, 0x43C7, 0x43C7, 0x3BA7, 0x3386, 0x3387, 0x3BA8, 0x4C0A, 0x644C, 0x6C4D, 0x5C0C, 0x4369, 0x3328, 0x4308, 
        0x538B, 0x63CC, 0x5BCD, 0x53CD, 0x53CD, 0x540E, 0x5C8F, 0x64F0, 0x6D51, 0x7571, 0x7572, 0x6D30, 0x546D, 0x3389, 0x2367, 0x2366, 0x2365, 0x2365, 0x2365, 0x1B45, 0x1B45, 0x1B45, 0x1B25, 0x1B24, 0x1B05, 0x1AE5, 0x1AC5, 0x1AC5, 0x1AA5, 0x1AA4, 
        0x1AA4, 0x1AA4, 0x12A4, 0x12C4, 0x1AE5, 0x1B05, 0x1B25, 0x1B25, 0x1B45, 0x1B45, 0x2365, 0x2386, 0x2386, 0x23A6, 0x2BA7, 0x43A9, 0x4BAB, 0x53AE, 0x5BCF, 0x6411, 0x6C91, 0x74D1, 0x74B0, 0x5C0D, 0x4369, 0x3B48, 0x3327, 0x3307, 0x32E7, 0x2AC6, 
        0x2AA6, 0x2A86, 0x2265, 0x2245, 0x2245, 0x2246, 0x2245, 0x2266, 0x2266, 0x2266, 0x2265, 0x2285, 0x2285, 0x2285, 0x2285, 0x2A85, 0x2285, 0x2286, 0x2266, 0x2266, 0x2266, 0x2226, 0x2206, 0x21E6, 0x19C5, 0x19C5, 0x19A5, 0x19A5, 0x21C5, 0x21E5, 
        0x2206, 0x2226, 0x2266, 0x2A86, 0x2A86, 0x2AA7, 0x32A8, 0x42AE, 0x83FB, 0x839E, 0x7B7E, 0x7B7E, 0x737E, 0x739E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x735E, 0x733D, 0x733D, 0x735D, 0x735E, 0x735D, 0x735D, 0x735E, 0x735E, 0x735E, 
        0x735E, 0x733E, 0x733E, 0x733E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B1E, 0x62FD, 0x62FD, 0x635C, 0x6BBA, 0x743A, 
        0x7C5C, 0x7C1D, 0x73FE, 0x73DE, 0x73BE, 0x6BBE, 0x6B9E, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7D, 0x5B7E, 0x5B7E, 0x5B5E, 
        0x5B5E, 0x5B5E, 0x5B3E, 0x5B5E, 0x635E, 0x635E, 0x635E, 0x633E, 0x5B3E, 0x5B1E, 0x5AFE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x531E, 
        0x531E, 0x531E, 0x531E, 0x531E, 0x531D, 0x531D, 0x5B3E, 0x5B5E, 0x5B5E, 0x637E, 0x639E, 0x6B9E, 0x6B9E, 0x73BE, 0x73BE, 0x739E, 0x737E, 0x737E, 0x7B9E, 0x83BE, 0x7BBE, 0x6B1D, 0x62DD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BE, 0x62DE, 0x62BE, 
        0x62BE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FE, 0x62FD, 0x62FE, 0x62FE, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x6B1E, 0x6B3D, 0x737D, 0x7BDC, 0x843A, 0x8498, 0x7C55, 0x63D1, 0x5BCF, 0x6470, 0x5C71, 0x4BF1, 0x4BD1, 
        0x5452, 0x64F3, 0x6532, 0x5D50, 0x5D50, 0x5D30, 0x6CD1, 0x6C92, 0x6C72, 0x6C92, 0x74B2, 0x6CD2, 0x6CF3, 0x7554, 0x75B4, 0x7DF3, 0x6D91, 0x3C4B, 0x2347, 0x2B26, 0x2B67, 0x3387, 0x33A7, 0x3BC8, 0x43E8, 0x4409, 0x4409, 0x4409, 0x4409, 0x4409, 
        0x43E9, 0x43C9, 0x43A9, 0x43A9, 0x4389, 0x4389, 0x4368, 0x3B48, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x4349, 0x5BCC, 0x84AF, 0x94D0, 0x94B0, 0x8C6F, 0x7C0E, 0x5B8B, 0x42E9, 0x32A8, 0x2A87, 0x2A67, 0x2A66, 0x2266, 0x1A66, 0x1A45, 0x1A65, 
        0x1245, 0x1245, 0x1A45, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x1B05, 0x2326, 0x2366, 0x2B86, 0x2BA6, 0x33C6, 0x33E7, 0x3407, 0x3427, 0x3C27, 0x3C27, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x4468, 0x4468, 0x4468, 0x4469, 0x4C69, 0x4C69, 0x4C69, 
        0x4C69, 0x4C89, 0x4C89, 0x4C8A, 0x4C8A, 0x4C8A, 0x4469, 0x4469, 0x4449, 0x4429, 0x4408, 0x4408, 0x43E8, 0x43E8, 0x43C8, 0x3BA8, 0x3B68, 0x3B48, 0x3327, 0x2AE7, 0x2AC7, 0x22C7, 0x22A7, 0x22A7, 0x22A7, 0x2AA7, 0x2AA7, 0x2AC7, 0x32E7,
  0x32C5, 0x32C5, 0x2AC5, 0x2AA4, 0x2A85, 0x2A65, 0x2244, 0x2244, 0x2225, 0x2224, 0x2204, 0x2224, 0x2244, 0x2AE5, 0x2B25, 0x550B, 0x554B, 0x4D6B, 0x4D8B, 0x4DAC, 0x55ED, 0x5E4E, 0x664E, 0x6E6F, 0x6E4F, 0x6DF0, 0x7D50, 0x32A6, 0x2A45, 0x2A64, 0x2284, 
        0x22A4, 0x22A3, 0x22C4, 0x22E4, 0x2B04, 0x3305, 0x3B25, 0x3B46, 0x4366, 0x4BA6, 0x53A6, 0x53C7, 0x53E7, 0x53E7, 0x53E7, 0x5407, 0x5407, 0x5408, 0x4C07, 0x4BE8, 0x43A7, 0x3B87, 0x3B67, 0x3B48, 0x3B28, 0x3B29, 0x4369, 0x4B69, 0x53A9, 0x53A9, 
        0x53A9, 0x53A9, 0x5B8A, 0x5B8A, 0x636B, 0x6BAC, 0x6BAD, 0x6B8F, 0x6B8F, 0x638F, 0x638F, 0x63CE, 0x63CD, 0x5BAB, 0x5389, 0x4B87, 0x43A7, 0x43C7, 0x43C7, 0x43C7, 0x3B87, 0x3B87, 0x43C9, 0x544B, 0x646C, 0x6C4D, 0x5C0C, 0x3B89, 0x3328, 0x4328, 
        0x538A, 0x5BAC, 0x5BAC, 0x5BAD, 0x53AD, 0x4BED, 0x544E, 0x5CCF, 0x6D10, 0x7551, 0x7571, 0x6D30, 0x548D, 0x33A9, 0x2B67, 0x2366, 0x2365, 0x2365, 0x2365, 0x2365, 0x2345, 0x2345, 0x2345, 0x1B25, 0x1B25, 0x1B05, 0x1AE5, 0x1AE5, 0x1AC5, 0x1AC5, 
        0x1AA4, 0x1AC4, 0x1AC4, 0x12E5, 0x1B05, 0x1B25, 0x1B45, 0x1B45, 0x1B65, 0x2365, 0x2366, 0x2386, 0x23A6, 0x23A6, 0x33A7, 0x43AA, 0x53AC, 0x5BAE, 0x63F0, 0x6C51, 0x74D1, 0x7D11, 0x74D0, 0x5C2D, 0x4389, 0x3B48, 0x3327, 0x3307, 0x3307, 0x32C7, 
        0x2AA6, 0x2A86, 0x2266, 0x2245, 0x2245, 0x2245, 0x2245, 0x2266, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x2285, 0x2285, 0x2285, 0x2285, 0x2285, 0x2266, 0x2266, 0x2266, 0x2226, 0x2206, 0x21E6, 0x19C5, 0x19C5, 0x19A5, 0x19A5, 0x19C5, 0x19E5, 
        0x2206, 0x2206, 0x2246, 0x2A66, 0x2A66, 0x2A87, 0x3268, 0x6333, 0x8BFD, 0x839E, 0x7B7E, 0x7B7E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x737E, 0x737E, 0x735E, 0x735E, 0x6B3D, 0x6B3D, 0x733D, 0x733E, 0x735D, 0x735D, 0x735E, 0x733E, 0x6B3E, 
        0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x633D, 0x633D, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5D, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B3E, 0x631E, 0x62FD, 0x62FD, 0x5ADD, 0x62DE, 0x6B3E, 0x739D, 0x73FD, 
        0x73FE, 0x73DE, 0x73DE, 0x73BE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7D, 0x5B5E, 0x5B7E, 0x5B5E, 
        0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x633E, 0x635E, 0x635D, 0x633E, 0x5B3E, 0x5B1E, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x4AFD, 0x4AFE, 0x4AFE, 0x52DE, 0x4ADD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x4AFD, 0x52FE, 0x52FE, 0x4B1E, 
        0x4B1E, 0x4AFD, 0x4AFD, 0x52FE, 0x52FE, 0x531D, 0x533E, 0x5B5E, 0x635E, 0x639E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x737E, 0x737E, 0x7BBE, 0x7BDE, 0x7B9E, 0x733D, 0x62FD, 0x62DE, 0x62BD, 0x629D, 0x629D, 0x629D, 0x62BE, 0x62DE, 0x62BE, 
        0x62BE, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x5ADD, 0x5AFE, 0x5AFE, 0x62FE, 0x631E, 0x631E, 0x631D, 0x631E, 0x631D, 0x631D, 0x631E, 0x62FE, 0x631E, 0x6B3D, 0x6B3E, 0x737E, 0x7BBD, 0x83FC, 0x843A, 0x8458, 0x7474, 0x6C92, 0x5C91, 0x4C10, 0x4BF1, 
        0x5452, 0x64F3, 0x6532, 0x5D70, 0x5D50, 0x5D30, 0x6CF1, 0x6CB1, 0x6C92, 0x6C92, 0x6CB2, 0x6CD2, 0x6CF2, 0x6D33, 0x75B3, 0x75F3, 0x5D50, 0x33EA, 0x1B26, 0x2326, 0x2B67, 0x3387, 0x33A7, 0x3BC8, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 
        0x43C9, 0x43A9, 0x4389, 0x4369, 0x4368, 0x3B48, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x4B8A, 0x746E, 0x8CD0, 0x8CD0, 0x846F, 0x7C2E, 0x638C, 0x430A, 0x32A8, 0x2AA8, 0x2AA7, 0x2A86, 0x2286, 0x2286, 0x1A86, 0x1A65, 0x1265, 
        0x1265, 0x1245, 0x1A65, 0x1A65, 0x1A85, 0x1AC5, 0x1AE5, 0x1B06, 0x2346, 0x2366, 0x2B86, 0x2BC6, 0x33E7, 0x33E7, 0x3407, 0x3427, 0x3C27, 0x3C27, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x4468, 0x4468, 0x4468, 0x4468, 0x4469, 0x4C49, 0x4C69, 
        0x4C69, 0x4C69, 0x4C89, 0x4C6A, 0x4C69, 0x4469, 0x4449, 0x4449, 0x4429, 0x4429, 0x4429, 0x4408, 0x4408, 0x43E8, 0x43C8, 0x43A8, 0x3B88, 0x3B68, 0x3327, 0x2B07, 0x2AE7, 0x22C7, 0x22A7, 0x22A7, 0x22A7, 0x22A7, 0x2287, 0x2AA7, 0x2AC7,
  0x32C5, 0x32C5, 0x2AA5, 0x2A84, 0x2A84, 0x2264, 0x2244, 0x2224, 0x2225, 0x1A04, 0x1A04, 0x2204, 0x2224, 0x2A84, 0x2B05, 0x54CB, 0x554C, 0x4D6B, 0x4D8B, 0x4DAC, 0x55ED, 0x5E4E, 0x666F, 0x6E6F, 0x764F, 0x7630, 0x7D70, 0x642C, 0x63EB, 0x642C, 0x3B27, 
        0x22A4, 0x22C4, 0x22C4, 0x2AE4, 0x3305, 0x3325, 0x3B26, 0x4346, 0x4B66, 0x4B87, 0x53A7, 0x5BC7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5C07, 0x5407, 0x5407, 0x4C07, 0x4BE7, 0x43C7, 0x3BA7, 0x3367, 0x3347, 0x3307, 0x2B07, 0x3307, 0x3307, 0x3327, 0x3307, 
        0x3307, 0x3AE7, 0x3AE7, 0x4B29, 0x5B4B, 0x638C, 0x6B6D, 0x6B6E, 0x634F, 0x634F, 0x636F, 0x63AF, 0x63CE, 0x5BAC, 0x4B8A, 0x4368, 0x3B86, 0x43A7, 0x43C7, 0x43E8, 0x43C8, 0x43C8, 0x542A, 0x5C6C, 0x648C, 0x6C6C, 0x540B, 0x3B89, 0x3328, 0x4328, 
        0x4B69, 0x536B, 0x5B8C, 0x5B8C, 0x538C, 0x4BAD, 0x540E, 0x5C6F, 0x6CD0, 0x7551, 0x7571, 0x6D30, 0x5CAE, 0x3BEA, 0x2B87, 0x2B86, 0x2B86, 0x2B85, 0x2B65, 0x2365, 0x2365, 0x2B45, 0x2345, 0x2345, 0x2325, 0x1B25, 0x1B05, 0x1B05, 0x1AE5, 0x1AE5, 
        0x1AE4, 0x1AE5, 0x1AE5, 0x1B05, 0x1B25, 0x1B25, 0x1B45, 0x1B66, 0x1B86, 0x2386, 0x23A6, 0x23A6, 0x2BC6, 0x2BC7, 0x3BC8, 0x4BAB, 0x53AD, 0x5BCF, 0x6431, 0x7491, 0x7CF1, 0x7CF0, 0x74CF, 0x5C0C, 0x4389, 0x3B47, 0x3B27, 0x3327, 0x3307, 0x32E7, 
        0x2AA6, 0x2A86, 0x2A66, 0x2A66, 0x2246, 0x2245, 0x2245, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x2286, 0x2286, 0x2285, 0x2285, 0x2285, 0x2285, 0x2266, 0x2266, 0x2246, 0x2226, 0x2206, 0x21E6, 0x21C5, 0x21C5, 0x19A5, 0x19A5, 0x19A5, 0x19C5, 
        0x19E6, 0x2206, 0x2226, 0x2A47, 0x2A67, 0x3287, 0x3A6B, 0x8C3A, 0x8BFE, 0x7B9E, 0x7B7E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x735E, 0x6B5E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 
        0x6B1E, 0x631D, 0x631D, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631D, 0x631D, 0x633E, 0x633E, 0x633D, 0x633D, 0x633D, 0x635D, 0x635E, 0x635D, 0x635D, 0x633D, 0x633E, 0x631E, 0x62FD, 0x62FD, 0x62FD, 0x62FD, 0x6B3E, 0x739E, 0x73DE, 0x73DE, 
        0x73BE, 0x6BBD, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x639E, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7D, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 
        0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B5E, 0x5B5D, 0x5B3E, 0x5B1D, 0x531D, 0x52FD, 0x52FE, 0x52FD, 0x52FD, 0x4ADD, 0x4ADD, 0x4ADE, 0x4ADE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4AFE, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFE, 
        0x4AFE, 0x4AFE, 0x4AFE, 0x4AFD, 0x4AFD, 0x531D, 0x5B3E, 0x5B5E, 0x637E, 0x637E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 0x737D, 0x7BBE, 0x83FE, 0x7BBE, 0x735D, 0x6B1D, 0x62DD, 0x629E, 0x629D, 0x5A9D, 0x5A9D, 0x5A9D, 0x62BE, 0x5ABE, 0x62DE, 
        0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DD, 0x5AFD, 0x5AFE, 0x62FE, 0x62FE, 0x62FE, 0x631E, 0x631E, 0x631E, 0x5AFE, 0x5AFD, 0x631E, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x735E, 0x737E, 0x7BBD, 0x841B, 0x8479, 0x74B6, 0x64B3, 0x5431, 0x4BF1, 
        0x5432, 0x5CB2, 0x6511, 0x5D50, 0x5D50, 0x6550, 0x6D11, 0x6CF1, 0x6CB2, 0x6C92, 0x6CD2, 0x6CF2, 0x6D12, 0x6D52, 0x75B3, 0x75D2, 0x5D0E, 0x2BA8, 0x2326, 0x2B26, 0x2B67, 0x3387, 0x3BA7, 0x3BC8, 0x43C8, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43A9, 
        0x43A9, 0x4389, 0x3B68, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x3308, 0x3308, 0x3B08, 0x3B08, 0x4328, 0x5BCC, 0x7C8F, 0x8C90, 0x846F, 0x7C4F, 0x6BEE, 0x4B4B, 0x32E9, 0x2AA7, 0x22C7, 0x22C7, 0x22C6, 0x22A6, 0x1AA6, 0x1A85, 0x1A85, 0x1285, 
        0x1265, 0x1265, 0x1A65, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B25, 0x2346, 0x2386, 0x2BA6, 0x2BC6, 0x33C7, 0x33E7, 0x3407, 0x3427, 0x3C27, 0x3C47, 0x3C48, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x4468, 0x4469, 0x4469, 0x4449, 0x4449, 
        0x4469, 0x4469, 0x4449, 0x4449, 0x4449, 0x4449, 0x4449, 0x4429, 0x3C28, 0x4429, 0x4429, 0x4408, 0x4408, 0x4408, 0x43E8, 0x43A8, 0x3BA8, 0x3B68, 0x3B47, 0x3327, 0x2AE7, 0x2AC7, 0x22A6, 0x22A7, 0x22A7, 0x2287, 0x2287, 0x2A87, 0x2AA7,
  0x32C5, 0x2AA5, 0x2A85, 0x2A64, 0x2A64, 0x2244, 0x2224, 0x2204, 0x1A04, 0x1A04, 0x1A04, 0x2204, 0x2224, 0x32A5, 0x3B67, 0x43E8, 0x554B, 0x4D6B, 0x4D6B, 0x4DAC, 0x55ED, 0x664E, 0x666F, 0x6E6F, 0x764F, 0x7630, 0x85D1, 0x7CEF, 0x63EC, 0x4B49, 0x2AA5, 
        0x22A4, 0x22C4, 0x22E4, 0x2B04, 0x3325, 0x3B25, 0x4346, 0x4B66, 0x4B66, 0x53A7, 0x53C7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE8, 0x5C07, 0x5407, 0x5407, 0x4C07, 0x43E7, 0x3BA7, 0x3386, 0x3366, 0x2B26, 0x2B06, 0x22E6, 0x22E5, 0x22C5, 0x22C5, 
        0x22A5, 0x2AA6, 0x3AE8, 0x4B2A, 0x534B, 0x5B4B, 0x5B0B, 0x530B, 0x52EC, 0x5B4E, 0x5B6F, 0x6390, 0x63AF, 0x5BCD, 0x53AB, 0x4368, 0x3B66, 0x3B86, 0x3BA7, 0x43C8, 0x4C08, 0x4C09, 0x5C6B, 0x64AC, 0x64AD, 0x646C, 0x540B, 0x4389, 0x3B48, 0x3B27, 
        0x4328, 0x4B2A, 0x534B, 0x536B, 0x534C, 0x538D, 0x53CE, 0x5C2F, 0x64B0, 0x7530, 0x7551, 0x6D30, 0x64CF, 0x442B, 0x33A8, 0x33A7, 0x2B86, 0x2B86, 0x2B85, 0x2B85, 0x2B85, 0x2B65, 0x2B65, 0x2345, 0x2345, 0x2325, 0x1B25, 0x1B25, 0x1B05, 0x1B05, 
        0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x1B45, 0x1B45, 0x1B65, 0x2386, 0x23A6, 0x23A6, 0x23A6, 0x23C6, 0x2BC6, 0x33E7, 0x43C9, 0x4BAB, 0x53AD, 0x5BF0, 0x6C51, 0x74B1, 0x74D0, 0x748E, 0x644C, 0x4BCA, 0x4388, 0x3B67, 0x3347, 0x3327, 0x3307, 0x32E6, 
        0x2AA6, 0x2A86, 0x2A66, 0x2A66, 0x2246, 0x2246, 0x2246, 0x2266, 0x2266, 0x2286, 0x2286, 0x2286, 0x22A6, 0x2286, 0x2286, 0x2286, 0x2265, 0x2265, 0x1A65, 0x2266, 0x2245, 0x2226, 0x2206, 0x21E5, 0x21E5, 0x21C6, 0x21A6, 0x19A6, 0x19A6, 0x19A5, 
        0x19A5, 0x19E5, 0x2206, 0x2A27, 0x2A47, 0x3248, 0x6B92, 0x9C9D, 0x8BDE, 0x7B9E, 0x7B9E, 0x739E, 0x739E, 0x737E, 0x737E, 0x739E, 0x737E, 0x735E, 0x735E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B1E, 0x631E, 0x631E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 
        0x631E, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x631E, 0x631E, 0x62FE, 0x5AFD, 0x5B1D, 0x631D, 0x631E, 0x633E, 0x633D, 0x633D, 0x633D, 0x633D, 0x633D, 0x633D, 0x631D, 0x631D, 0x631D, 0x737E, 0x739E, 0x737E, 0x737E, 0x73BE, 0x73BE, 0x73BE, 0x739E, 
        0x739E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B9E, 0x5B9E, 0x63BD, 0x63BD, 0x63BE, 0x63BD, 0x639E, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7D, 0x5B5D, 0x5B5E, 0x5B5E, 0x5B5E, 
        0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B3D, 0x531D, 0x52FD, 0x52FE, 0x4ADE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ABE, 0x42BD, 0x42BD, 0x42BD, 0x4ABD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4AFE, 0x4AFD, 0x4AFD, 0x4AFE, 0x4AFE, 
        0x4AFE, 0x4ADE, 0x4AFE, 0x4AFD, 0x52FD, 0x531E, 0x5B3E, 0x635E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B5D, 0x737D, 0x7BBE, 0x83FE, 0x83FE, 0x83DE, 0x737E, 0x6B1D, 0x62BD, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 0x5ABD, 0x5ADE, 
        0x5ADE, 0x62DE, 0x62DE, 0x5ADD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5AFE, 0x62FE, 0x631E, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x631E, 0x631E, 0x633D, 0x6B3D, 0x6B3E, 0x735E, 0x737E, 0x7BBD, 0x7BFC, 0x7C5B, 0x7498, 0x6474, 0x53F2, 
        0x5412, 0x5C92, 0x64F1, 0x6531, 0x5D50, 0x5D30, 0x6D31, 0x74F2, 0x6CD2, 0x6CB2, 0x6CD2, 0x6D12, 0x6D32, 0x6D72, 0x6DB2, 0x6D91, 0x54AC, 0x2B67, 0x2326, 0x2B26, 0x2B67, 0x3387, 0x3BA7, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x43A8, 0x43A8, 0x4388, 
        0x4388, 0x3B68, 0x3B48, 0x3B28, 0x3B28, 0x3308, 0x3308, 0x3308, 0x32E8, 0x32E8, 0x3AE8, 0x3B08, 0x53AB, 0x746F, 0x8470, 0x8430, 0x8450, 0x740F, 0x53AC, 0x3B29, 0x2AC8, 0x22E7, 0x1AE7, 0x22E6, 0x1AE6, 0x1AC6, 0x1AC6, 0x1AA5, 0x1AA5, 0x1AA5, 
        0x1AA5, 0x1A85, 0x1A85, 0x1AA5, 0x1AC5, 0x1AE5, 0x1B05, 0x1B25, 0x2366, 0x2386, 0x2BA6, 0x2BA6, 0x33C7, 0x33E7, 0x3C07, 0x3427, 0x3C27, 0x3C47, 0x3C48, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C48, 0x3C48, 0x3C68, 0x3C69, 0x4468, 0x4468, 0x4449, 
        0x4449, 0x3C49, 0x3C49, 0x3C29, 0x3C29, 0x4429, 0x3C28, 0x3C28, 0x3C28, 0x4429, 0x4429, 0x4408, 0x4408, 0x4408, 0x43E8, 0x43C8, 0x43A8, 0x3B88, 0x3B47, 0x3327, 0x3307, 0x2AE7, 0x2AC7, 0x22A6, 0x22A6, 0x2286, 0x2286, 0x2286, 0x2A87,
  0x32A5, 0x2A85, 0x2A65, 0x2A65, 0x2244, 0x2224, 0x2224, 0x2204, 0x19E4, 0x19E4, 0x19E4, 0x21E4, 0x2A24, 0x3AA6, 0x2A84, 0x4408, 0x550B, 0x554B, 0x4D6B, 0x4D8B, 0x55CC, 0x5E0D, 0x5E2E, 0x664E, 0x6E4F, 0x7630, 0x7DB1, 0x6C8E, 0x3287, 0x3266, 0x2AA5, 
        0x22A4, 0x22A4, 0x2AC4, 0x2B05, 0x3325, 0x3B46, 0x4346, 0x4B66, 0x5387, 0x53A7, 0x5BC7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE8, 0x5C07, 0x5407, 0x5407, 0x4C07, 0x4BE7, 0x3BC6, 0x3386, 0x3366, 0x2B46, 0x2B06, 0x22E5, 0x1AC5, 0x1AA4, 0x1AA4, 
        0x2285, 0x2AA7, 0x3B09, 0x4309, 0x4B0A, 0x4AE9, 0x4AA9, 0x42AA, 0x42CB, 0x530D, 0x5B4F, 0x5B90, 0x63AF, 0x5BCF, 0x5BCC, 0x4BA9, 0x3B67, 0x3B66, 0x3B86, 0x3BA7, 0x4C08, 0x544A, 0x648B, 0x64AC, 0x64AD, 0x646C, 0x540A, 0x3B88, 0x3B47, 0x3327, 
        0x3B27, 0x4308, 0x4B29, 0x534A, 0x532B, 0x4B6D, 0x53AD, 0x540E, 0x64AF, 0x6CF0, 0x6D10, 0x6CEF, 0x64AE, 0x544C, 0x43E9, 0x3BA7, 0x33A6, 0x33A6, 0x33A6, 0x3386, 0x3385, 0x2B86, 0x2B85, 0x2B65, 0x2345, 0x2345, 0x2345, 0x2325, 0x2325, 0x1B25, 
        0x1B25, 0x1B25, 0x1B25, 0x1B45, 0x1B65, 0x1B85, 0x2386, 0x23A6, 0x23A6, 0x23A6, 0x23C6, 0x2BC6, 0x33C7, 0x3BC8, 0x43CA, 0x438C, 0x4BAE, 0x5C10, 0x6C71, 0x74B0, 0x6C8E, 0x5C2C, 0x53CA, 0x4389, 0x3B68, 0x3B47, 0x3347, 0x3327, 0x3307, 0x32E7, 
        0x2AA6, 0x2A86, 0x2A66, 0x2A66, 0x2266, 0x2246, 0x2246, 0x2246, 0x2266, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x2286, 0x2286, 0x2286, 0x2265, 0x1A65, 0x1A65, 0x1A45, 0x2245, 0x2225, 0x2205, 0x2205, 0x21E5, 0x21C6, 0x21C6, 0x21A6, 0x21A6, 0x21A6, 
        0x21A6, 0x21C6, 0x29E6, 0x2A07, 0x3228, 0x320A, 0x9479, 0x9C9E, 0x83BE, 0x7B9E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x735E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B1E, 0x631E, 0x631E, 0x631E, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 
        0x62FE, 0x62FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x62FD, 0x631E, 0x631D, 0x631D, 0x633D, 0x6B3D, 0x6B5D, 0x6B5D, 0x737E, 0x6B3D, 0x6B3D, 0x6B3D, 0x83FE, 0x7BBE, 0x7BBD, 0x7BDE, 0x73BE, 0x739E, 0x739E, 0x739E, 0x6B7E, 
        0x6B7E, 0x6B9E, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x5B7E, 0x5B7E, 0x5B7D, 0x5B7E, 0x5B7E, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x63BE, 0x5B9E, 0x5B9E, 0x63BE, 0x5B9E, 0x5B7E, 0x537E, 0x5B7E, 0x5B5D, 0x5B5E, 0x5B5E, 0x5B5E, 
        0x5B5E, 0x5B3D, 0x5B3D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x531E, 0x52FD, 0x52DE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABD, 0x42BE, 0x42BD, 0x42BD, 0x42BE, 0x42BD, 0x42BD, 0x42BD, 0x42DD, 0x42DE, 0x42DE, 0x4ADE, 0x4AFE, 0x42DD, 
        0x4ADD, 0x4ADD, 0x4ADD, 0x4AFD, 0x531D, 0x5B3E, 0x635E, 0x637E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B3E, 0x6B5D, 0x739E, 0x83FE, 0x83FE, 0x7BDE, 0x7BDE, 0x7BBE, 0x6B5E, 0x62DD, 0x5A7E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5ABD, 0x5ADE, 
        0x5ADE, 0x62DE, 0x62DE, 0x5ADE, 0x5ADE, 0x5AFE, 0x5AFD, 0x5B1E, 0x5B1E, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1E, 0x5B1E, 0x633D, 0x633D, 0x6B1E, 0x6B3E, 0x735E, 0x737E, 0x7B7E, 0x7BDD, 0x7C3C, 0x7499, 0x6C77, 
        0x5C33, 0x5C72, 0x5CD1, 0x5D30, 0x5D30, 0x5D30, 0x6511, 0x6D11, 0x6CF1, 0x6CD1, 0x64D1, 0x6512, 0x6D32, 0x6D72, 0x6DB2, 0x6570, 0x446B, 0x2347, 0x2326, 0x2B26, 0x2B47, 0x3367, 0x3388, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 
        0x3B68, 0x3B48, 0x3B28, 0x3B08, 0x3308, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x3AE8, 0x3AE8, 0x4B4A, 0x6C2E, 0x8470, 0x8430, 0x8431, 0x7C30, 0x63CE, 0x434A, 0x2AE8, 0x22E7, 0x1AE7, 0x1B06, 0x1AE6, 0x1AE6, 0x1AE6, 0x1AE6, 0x1AC5, 0x1AC5, 0x1AC5, 
        0x1AC5, 0x1AA5, 0x1AA5, 0x1AC5, 0x1AE5, 0x1AE5, 0x1B25, 0x1B45, 0x2365, 0x2386, 0x2BA6, 0x33C6, 0x33E6, 0x33E6, 0x3C07, 0x3427, 0x3C27, 0x3C47, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C48, 
        0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x3C28, 0x4429, 0x4429, 0x4429, 0x4429, 0x4408, 0x43E8, 0x43C8, 0x3BA8, 0x3B88, 0x3B67, 0x3347, 0x3307, 0x32E7, 0x2AC7, 0x2AC7, 0x22A6, 0x2286, 0x2286, 0x2286, 0x2286,
  0x3AA6, 0x2A85, 0x2A65, 0x2A45, 0x2244, 0x2224, 0x2204, 0x2204, 0x19E4, 0x19C4, 0x19C4, 0x21E4, 0x2A25, 0x4B28, 0x74CD, 0x6CED, 0x54CB, 0x4D0A, 0x4D4B, 0x4D4B, 0x4D6B, 0x55ED, 0x5E2D, 0x664E, 0x5DEE, 0x6E30, 0x7DD1, 0x8572, 0x5BCC, 0x3AC7, 0x2AA5, 
        0x2AA4, 0x22C4, 0x2AC5, 0x2B05, 0x3326, 0x3B46, 0x4366, 0x4B67, 0x5387, 0x5BA7, 0x5BC7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5C07, 0x5407, 0x5407, 0x4C07, 0x4BE7, 0x3BC6, 0x33A6, 0x3386, 0x2B66, 0x2B25, 0x2305, 0x1AE4, 0x1AC4, 0x1AA4, 
        0x22A5, 0x2AC7, 0x32E8, 0x32E8, 0x3AA8, 0x3A88, 0x3A88, 0x3A89, 0x42AA, 0x4AEC, 0x532E, 0x5B70, 0x5BAF, 0x63EF, 0x5C0D, 0x53EB, 0x3B88, 0x3367, 0x3366, 0x3B86, 0x43E8, 0x5C6A, 0x64AC, 0x64AC, 0x64AC, 0x5C6C, 0x4BEA, 0x3B88, 0x3347, 0x3326, 
        0x3B26, 0x4327, 0x4328, 0x4B29, 0x4B2A, 0x4B2C, 0x4B8D, 0x53ED, 0x648E, 0x64CF, 0x64CF, 0x64AE, 0x5C8D, 0x5C4C, 0x4C0A, 0x43C8, 0x3BA7, 0x3BC6, 0x3BC6, 0x33A6, 0x33A6, 0x33A6, 0x2B86, 0x2B86, 0x2B65, 0x2B65, 0x2345, 0x2345, 0x2345, 0x2345, 
        0x2345, 0x1B45, 0x2345, 0x2365, 0x2385, 0x2385, 0x23A6, 0x23C6, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BC6, 0x33C7, 0x3BC8, 0x43AA, 0x438D, 0x53CE, 0x5C50, 0x6C91, 0x6C8F, 0x5C0C, 0x4BA9, 0x4388, 0x3B68, 0x3B47, 0x3B47, 0x3327, 0x3327, 0x3307, 0x32E7, 
        0x2AA6, 0x2AA7, 0x2A66, 0x2A66, 0x2266, 0x2A46, 0x2246, 0x2246, 0x2266, 0x2286, 0x22A7, 0x22A7, 0x2AA7, 0x22A6, 0x22A6, 0x2286, 0x2265, 0x2265, 0x1A65, 0x1A45, 0x2245, 0x2225, 0x2205, 0x2206, 0x2206, 0x21E6, 0x21E6, 0x21C6, 0x21C6, 0x21C6, 
        0x21A6, 0x21A6, 0x21A6, 0x29C7, 0x3209, 0x6352, 0xA4DC, 0x9C7E, 0x83BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x6B5E, 0x6B3E, 0x6B3E, 0x631D, 0x6B3E, 0x631E, 0x631D, 0x631E, 0x5AFD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 
        0x5AFE, 0x5AFD, 0x5AFD, 0x5ADE, 0x5ADE, 0x5ADD, 0x5ADD, 0x62DE, 0x62FE, 0x631D, 0x631E, 0x6B3E, 0x735E, 0x739E, 0x7BBE, 0x83DE, 0x83FE, 0x83FE, 0x83FE, 0x8C3E, 0x947F, 0x841E, 0x7B7D, 0x8C3E, 0x8C1E, 0x7B9E, 0x739D, 0x737E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5BBE, 0x5B9E, 0x5B9E, 0x63BE, 0x5B9E, 0x5B7E, 0x537E, 0x537E, 0x537E, 0x5B7E, 0x535E, 0x5B5E, 
        0x5B3E, 0x5B3D, 0x5B3D, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B1E, 0x531E, 0x52FE, 0x52FE, 0x4ADE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABD, 0x42BD, 0x42BD, 0x429D, 0x429D, 0x429D, 0x42BE, 0x429D, 0x42BD, 0x42BD, 0x42BD, 0x42BE, 0x42BE, 0x42DD, 0x42DD, 0x42DD, 
        0x4ADD, 0x4ADD, 0x52FE, 0x5B1E, 0x633E, 0x635E, 0x637E, 0x637E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x737D, 0x7BFE, 0x83FF, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BDE, 0x7B9E, 0x6B1D, 0x5A7E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5ABD, 0x5ADE, 
        0x5ADE, 0x5ABD, 0x5ABD, 0x5ADE, 0x5ADE, 0x5AFE, 0x5AFD, 0x5B1E, 0x631E, 0x5B1E, 0x5AFD, 0x5AFE, 0x5AFE, 0x5B1D, 0x5B1D, 0x5B1D, 0x531D, 0x5B1D, 0x5B1D, 0x633D, 0x633D, 0x631E, 0x6B1E, 0x6B3E, 0x733E, 0x735E, 0x735E, 0x7BBE, 0x7C3C, 0x7C9B, 
        0x6C76, 0x6473, 0x64D1, 0x5D10, 0x5D0F, 0x550F, 0x6510, 0x6D11, 0x6CF1, 0x64D1, 0x64F1, 0x6531, 0x6552, 0x6D92, 0x6DB2, 0x6550, 0x442A, 0x2346, 0x2326, 0x2B26, 0x2B47, 0x3367, 0x3388, 0x3B87, 0x3B87, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 
        0x3B68, 0x3B48, 0x3B28, 0x3308, 0x32E8, 0x32E8, 0x3B28, 0x4369, 0x4BAB, 0x53AB, 0x538B, 0x63EC, 0x6C4F, 0x7C30, 0x8431, 0x8451, 0x740F, 0x536C, 0x3309, 0x2307, 0x2307, 0x2307, 0x1B06, 0x1B06, 0x1B06, 0x1B06, 0x1B05, 0x1AE5, 0x1AE5, 0x1AE5, 
        0x1AE5, 0x1AC5, 0x1AC5, 0x1AE5, 0x1AE5, 0x1B05, 0x1B45, 0x1B45, 0x2365, 0x23A6, 0x2BC6, 0x33C6, 0x33E6, 0x33E6, 0x3C07, 0x3427, 0x3C27, 0x3C47, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x4428, 0x4429, 0x4429, 0x4429, 0x4429, 0x4409, 0x43E8, 0x43C8, 0x3BA8, 0x3B88, 0x3B68, 0x3348, 0x3327, 0x3307, 0x32E7, 0x2AC7, 0x2AC7, 0x2AA7, 0x2286, 0x2286, 0x2286,
  0x4B49, 0x3286, 0x2A45, 0x2A45, 0x2224, 0x2204, 0x21E4, 0x19E4, 0x19C4, 0x19A4, 0x19C4, 0x21C4, 0x2A05, 0x5369, 0x3AC6, 0x2284, 0x33A6, 0x550B, 0x552B, 0x4D4B, 0x4D6C, 0x55CD, 0x5E2D, 0x664E, 0x662F, 0x7630, 0x7DF1, 0x8571, 0x536B, 0x3287, 0x2A85, 
        0x2AA5, 0x2AC4, 0x2AC4, 0x2B05, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x5387, 0x5BC7, 0x5BC7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5C07, 0x5407, 0x5407, 0x4C07, 0x4C07, 0x3BE6, 0x33C6, 0x33A6, 0x2B85, 0x2B45, 0x2B25, 0x2304, 0x1AC4, 0x1AA4, 
        0x22A5, 0x22C6, 0x2AA6, 0x2AA6, 0x2A86, 0x2A87, 0x3287, 0x3287, 0x3AA8, 0x42CB, 0x4B0D, 0x536F, 0x5BB0, 0x63F0, 0x640E, 0x5C0C, 0x43AA, 0x3B87, 0x3B86, 0x3B87, 0x43E8, 0x546A, 0x5CAB, 0x64AC, 0x64AC, 0x5C6C, 0x4BE9, 0x3B67, 0x3347, 0x3326, 
        0x3B26, 0x3B27, 0x4328, 0x4329, 0x4309, 0x432B, 0x4B6C, 0x4BCD, 0x5C6E, 0x64AE, 0x64AE, 0x5C8E, 0x5C8E, 0x648E, 0x542B, 0x43E9, 0x43C7, 0x43C7, 0x3BC7, 0x3BC6, 0x3BA6, 0x33A6, 0x33A6, 0x3386, 0x3385, 0x2B85, 0x2B65, 0x2B65, 0x2365, 0x2365, 
        0x2365, 0x2365, 0x2385, 0x2385, 0x2386, 0x2386, 0x2BA6, 0x2BC7, 0x3C08, 0x3C08, 0x3C08, 0x33C7, 0x33C8, 0x3BC9, 0x43CB, 0x4BAD, 0x53EF, 0x6470, 0x6C90, 0x644E, 0x4BAA, 0x4388, 0x3B67, 0x3B47, 0x3B47, 0x3347, 0x3326, 0x3327, 0x3307, 0x32E7, 
        0x32A7, 0x2AA7, 0x2A67, 0x2A67, 0x2A66, 0x2A46, 0x2A46, 0x2A66, 0x2A67, 0x2A67, 0x2A87, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x22A6, 0x2286, 0x2265, 0x1A65, 0x1A65, 0x2245, 0x2226, 0x2226, 0x2206, 0x2206, 0x21E6, 0x21E7, 0x21E7, 0x21C7, 0x21C7, 
        0x21A7, 0x3A4A, 0x634F, 0x6350, 0x94B7, 0xA4FC, 0x9CBD, 0x945E, 0x7BBE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B1E, 0x6B1E, 0x631E, 0x62FE, 0x5AFE, 0x5AFD, 0x5ADD, 0x5ADD, 0x5ADE, 0x5ADD, 
        0x5ADE, 0x5ADE, 0x52DD, 0x52DD, 0x5ADD, 0x5ADD, 0x62FD, 0x631D, 0x6B5D, 0x739E, 0x7BBE, 0x83DE, 0x83FE, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 0x8C5E, 0x8C5E, 0x7BBE, 0x7B9D, 0x9CBF, 0x8C5E, 0x739D, 0x6B7D, 0x6B7D, 0x6B7E, 0x6B7E, 
        0x635E, 0x637E, 0x637E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x537E, 0x5B7E, 0x535E, 0x535E, 
        0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B3E, 0x5B1E, 0x5B1E, 0x531E, 0x52FE, 0x52FD, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABE, 0x42BE, 0x42BE, 0x429E, 0x429E, 0x429D, 0x3A9D, 0x429D, 0x429D, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42DD, 
        0x4ADD, 0x52FD, 0x5B1E, 0x633E, 0x635E, 0x6B7E, 0x6B5E, 0x635E, 0x635E, 0x633E, 0x633E, 0x6B3E, 0x6B5D, 0x7BDE, 0x841F, 0x7BDE, 0x7BBE, 0x7BBE, 0x73BE, 0x7BBE, 0x7BBE, 0x739E, 0x62DD, 0x5A9D, 0x529D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5ABD, 0x5ABE, 
        0x5ABD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5AFD, 0x5AFD, 0x5AFD, 0x5AFE, 0x52FE, 0x52FE, 0x52FE, 0x5B1D, 0x5B1D, 0x631D, 0x631D, 0x631E, 0x633E, 0x6B3E, 0x6B3E, 0x6B3E, 0x735D, 0x7B7E, 0x7BDE, 0x7C3D, 
        0x747A, 0x6C96, 0x64D2, 0x6510, 0x5D0F, 0x550F, 0x5D10, 0x6D31, 0x6D11, 0x6D11, 0x6511, 0x6531, 0x6D71, 0x6D92, 0x6DB2, 0x652F, 0x440A, 0x2327, 0x2307, 0x2B27, 0x3347, 0x3347, 0x3367, 0x3367, 0x3367, 0x3B67, 0x3B67, 0x3B68, 0x3B68, 0x3B48, 
        0x3B48, 0x3B28, 0x3B08, 0x3308, 0x3B08, 0x434A, 0x5BEC, 0x6C4E, 0x6C4E, 0x6C4E, 0x6C4E, 0x746F, 0x7430, 0x8451, 0x8C92, 0x7C71, 0x63EE, 0x4369, 0x3328, 0x2B47, 0x2327, 0x2347, 0x1B26, 0x1B26, 0x1B26, 0x1B06, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 
        0x1B05, 0x1AE5, 0x1AE5, 0x1AE5, 0x1B05, 0x1B25, 0x1B46, 0x2345, 0x2365, 0x2B86, 0x2BC6, 0x2BC6, 0x33E6, 0x33E6, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C68, 0x3C48, 0x3C48, 0x3C28, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x4428, 0x4428, 0x4C29, 0x4C28, 0x4C29, 0x4C09, 0x4408, 0x43E8, 0x43C8, 0x43A8, 0x3B88, 0x3B68, 0x3B48, 0x3B28, 0x3307, 0x32E7, 0x2AC7, 0x2AC7, 0x2AA7, 0x2A87, 0x2287,
  0x6C4E, 0x4B2A, 0x3246, 0x2A25, 0x2205, 0x21E4, 0x19C4, 0x19C4, 0x19A4, 0x19A4, 0x19A4, 0x21C4, 0x21E4, 0x3AC7, 0x3AA6, 0x2A64, 0x22C4, 0x54CA, 0x554B, 0x4D6B, 0x4D8C, 0x55AD, 0x5E0D, 0x664F, 0x6E50, 0x7630, 0x7611, 0x7D71, 0x5BCC, 0x3267, 0x2A85, 
        0x2AA5, 0x2AA5, 0x2AC5, 0x2B05, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x53A7, 0x5BC7, 0x5BC7, 0x5BE7, 0x63E7, 0x63E7, 0x63E7, 0x5BE7, 0x5BE7, 0x5407, 0x5407, 0x4C07, 0x4C07, 0x43E6, 0x3BC6, 0x33A6, 0x3385, 0x3365, 0x2B25, 0x2B05, 0x22E4, 0x22C4, 
        0x22C4, 0x22A4, 0x22A5, 0x22A5, 0x22A5, 0x2AA5, 0x2AA5, 0x2AA6, 0x32A7, 0x3AE9, 0x430B, 0x534D, 0x5B8F, 0x63D0, 0x640F, 0x5C0D, 0x4BCB, 0x43A9, 0x3B87, 0x3B87, 0x43E8, 0x544A, 0x5CAB, 0x5CAC, 0x5CAC, 0x546B, 0x43C9, 0x3B67, 0x3346, 0x3326, 
        0x3B26, 0x3B26, 0x4327, 0x4328, 0x4329, 0x430A, 0x4B4B, 0x4BAC, 0x542D, 0x5C6D, 0x5C8E, 0x5CAE, 0x64AF, 0x6CCE, 0x5C8C, 0x4C0A, 0x43E8, 0x43E8, 0x43E7, 0x43C7, 0x3BA6, 0x3BA6, 0x33A6, 0x33A6, 0x33A6, 0x33A5, 0x2B85, 0x2B85, 0x2B85, 0x2385, 
        0x2385, 0x2385, 0x23A5, 0x23A6, 0x2386, 0x2BA6, 0x2BA6, 0x33E7, 0x4429, 0x4C4A, 0x4C4A, 0x440A, 0x43EA, 0x4BCB, 0x4BCC, 0x53CE, 0x5C0F, 0x6470, 0x648F, 0x540C, 0x4389, 0x3B88, 0x3B67, 0x3347, 0x3346, 0x3326, 0x3327, 0x3327, 0x3307, 0x32E7, 
        0x32C7, 0x32A7, 0x3287, 0x2A87, 0x2A67, 0x2A67, 0x2A66, 0x2A67, 0x2A67, 0x2A67, 0x2A87, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x22A7, 0x2286, 0x2286, 0x2266, 0x2266, 0x2246, 0x2246, 0x2246, 0x2226, 0x2A06, 0x21E7, 0x29E7, 0x21E7, 0x21A7, 0x2187, 
        0x2147, 0x6B91, 0xAD7B, 0xAD3B, 0xA49D, 0x9C9D, 0x9C7E, 0x8C3E, 0x7BBE, 0x7BBE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B1E, 0x62FD, 0x62FE, 0x5ADE, 0x5ADE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 
        0x5ADE, 0x52DD, 0x52DE, 0x5ADD, 0x631D, 0x7BBF, 0x7BDF, 0x7BFE, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x8C1E, 0x841E, 0x841E, 0x841E, 0x841E, 0x83FE, 0x841E, 0x8C5E, 0x841E, 0x735E, 0x735D, 0x949F, 0x947E, 0x7BBE, 0x6B5D, 0x635D, 0x635E, 0x635E, 
        0x635E, 0x635E, 0x5B5E, 0x5B5E, 0x5B5E, 0x533E, 0x533E, 0x535E, 0x535E, 0x5B5E, 0x535E, 0x535E, 0x537E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B9E, 0x5B9E, 0x5B9E, 0x639E, 0x5B9E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B7E, 0x535E, 0x535D, 
        0x533D, 0x533E, 0x531D, 0x531D, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x52FD, 0x4ADD, 0x4ABE, 0x4ABE, 0x429E, 0x429E, 0x429E, 0x429E, 0x429D, 0x429D, 0x3A9D, 0x3A9D, 0x42BE, 0x42BE, 0x429D, 0x429E, 0x42BE, 0x42BE, 0x42BD, 0x42DD, 0x4ADE, 
        0x52FE, 0x5B1E, 0x5B3E, 0x635E, 0x637E, 0x635E, 0x6B5E, 0x635E, 0x633E, 0x633E, 0x633D, 0x6B5E, 0x6B5D, 0x7C1E, 0x841E, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x737E, 0x62FD, 0x527D, 0x527D, 0x529D, 0x5A9D, 0x5A9E, 0x5ABD, 
        0x5ABD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x5AFD, 0x5B1D, 0x5B1D, 0x5B1D, 0x631E, 0x633D, 0x6B3E, 0x6B3E, 0x6B3D, 0x735E, 0x737E, 0x7B9E, 0x7BFD, 
        0x7C5C, 0x7499, 0x64B4, 0x64F1, 0x550F, 0x54EF, 0x5D10, 0x6531, 0x6D31, 0x6D31, 0x6531, 0x6551, 0x6D91, 0x6DB1, 0x6DB1, 0x652F, 0x548C, 0x3BCA, 0x2B48, 0x2B27, 0x3347, 0x3347, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3B68, 0x3B68, 0x3B48, 
        0x3B28, 0x3B28, 0x3B08, 0x3B08, 0x434A, 0x5BED, 0x642E, 0x6C2E, 0x63ED, 0x63CD, 0x742F, 0x7C70, 0x7C30, 0x8472, 0x8471, 0x6C0E, 0x4B8B, 0x3348, 0x3347, 0x2B67, 0x2B47, 0x2347, 0x2346, 0x2346, 0x1B46, 0x2326, 0x1B26, 0x1B26, 0x1B26, 0x1B25, 
        0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x1B46, 0x2345, 0x2366, 0x2B86, 0x2BA6, 0x2BC6, 0x33E6, 0x33E6, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C47, 0x3C47, 0x3C68, 0x3C68, 0x3C68, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3468, 0x3468, 0x3C68, 
        0x3C68, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C08, 0x3C08, 0x3C28, 0x4428, 0x4428, 0x4C28, 0x4C28, 0x4C29, 0x4C28, 0x4408, 0x43E8, 0x43E8, 0x43C8, 0x43A8, 0x4388, 0x3B68, 0x3B48, 0x3327, 0x3307, 0x32E7, 0x32E7, 0x32C7, 0x2AA7, 0x2A87,
  0x84D0, 0x6C0D, 0x4AE9, 0x3226, 0x2A05, 0x21E4, 0x19C4, 0x19A4, 0x19A4, 0x19A4, 0x19A4, 0x19A4, 0x21C4, 0x2205, 0x3AA6, 0x2A84, 0x2283, 0x4448, 0x4D2B, 0x4D6B, 0x4D8C, 0x55CC, 0x5E0D, 0x664F, 0x6E4F, 0x6E30, 0x7611, 0x7D91, 0x74B0, 0x5BCC, 0x3AE7, 
        0x2AA5, 0x2AC5, 0x2AE5, 0x2B05, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x53A7, 0x5BC7, 0x5BE7, 0x5BE7, 0x63E7, 0x63E7, 0x63E7, 0x5BE7, 0x5BE7, 0x5407, 0x5407, 0x4C07, 0x4C07, 0x43E6, 0x3BC6, 0x33A5, 0x33A5, 0x3365, 0x2B45, 0x2B25, 0x2B04, 0x22E4, 
        0x22C4, 0x22C4, 0x22A4, 0x22A5, 0x2285, 0x22A5, 0x2AA5, 0x2AA6, 0x32C6, 0x3AE8, 0x430A, 0x4B4D, 0x5B6F, 0x63AF, 0x63EF, 0x5C0E, 0x53ED, 0x4BAA, 0x4388, 0x3BA8, 0x43E8, 0x4C49, 0x548A, 0x54AB, 0x54AB, 0x546B, 0x43C8, 0x3B87, 0x3346, 0x3346, 
        0x3B46, 0x3B46, 0x4347, 0x4348, 0x4B29, 0x430A, 0x430A, 0x436B, 0x4BEC, 0x544D, 0x5C8E, 0x5CAE, 0x64EF, 0x64EE, 0x64CD, 0x544B, 0x4C09, 0x4BE8, 0x4BE7, 0x43E7, 0x43C7, 0x3BC6, 0x3BA6, 0x33A6, 0x33A6, 0x33A5, 0x2BA5, 0x2BA5, 0x2BA5, 0x2385, 
        0x2385, 0x23A5, 0x23A6, 0x23A6, 0x23A6, 0x23A6, 0x2BA6, 0x33E7, 0x4429, 0x4C4B, 0x544B, 0x542B, 0x540C, 0x53EC, 0x53CD, 0x53EF, 0x5C30, 0x6470, 0x5C4E, 0x4BCB, 0x3B68, 0x3B67, 0x3366, 0x3346, 0x3346, 0x3326, 0x3327, 0x3327, 0x3307, 0x32E7, 
        0x32C8, 0x32C8, 0x32A7, 0x3287, 0x3287, 0x2A87, 0x2A67, 0x2A67, 0x2A67, 0x3287, 0x3287, 0x32A7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2286, 0x2286, 0x2266, 0x2266, 0x2246, 0x2246, 0x2226, 0x2A26, 0x2A07, 0x2A07, 0x29E8, 0x31E9, 0x52CE, 0x6B72, 
        0x7BB5, 0x9459, 0xA4BD, 0xA4BE, 0x9C3E, 0x9C3E, 0x8C3E, 0x83FE, 0x7BDE, 0x7BBE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B1E, 0x62FE, 0x62FE, 0x62DE, 0x5ADE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 
        0x52BD, 0x52BD, 0x52BD, 0x631D, 0x7BBE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x83FE, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 0x83FD, 0x7BDE, 0x7BFE, 0x7BFE, 0x73BE, 0x6B3E, 0x62FD, 0x83FE, 0x8C3E, 0x841E, 0x73BE, 0x6B7D, 0x635D, 0x635E, 
        0x5B5D, 0x5B5E, 0x5B3E, 0x533E, 0x533E, 0x533E, 0x533E, 0x533E, 0x535E, 0x535E, 0x535E, 0x535E, 0x5B5D, 0x5B5E, 0x5B5D, 0x5B7D, 0x5B7D, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x5B9E, 0x5B9E, 0x5B7E, 0x5B7E, 0x537E, 0x5B5E, 0x535E, 0x535E, 
        0x533D, 0x531D, 0x531D, 0x531E, 0x531E, 0x531D, 0x52FE, 0x52FD, 0x4ADD, 0x4ADD, 0x4ABD, 0x4A9D, 0x429E, 0x429D, 0x427D, 0x427D, 0x3A7D, 0x3A9D, 0x429D, 0x429D, 0x3A9D, 0x429E, 0x429E, 0x3A9D, 0x429E, 0x429D, 0x42BD, 0x42DE, 0x4ADD, 0x531E, 
        0x5B3E, 0x5B3E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x633E, 0x633E, 0x633E, 0x633D, 0x6B5E, 0x737D, 0x843E, 0x7C1E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x7BDE, 0x6B7E, 0x5ABD, 0x527D, 0x527D, 0x529D, 0x5A9E, 0x5A9D, 
        0x5A9D, 0x5ABD, 0x5ABD, 0x5ADD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x633E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x737E, 0x7BDE, 
        0x7C1D, 0x7C7B, 0x6C96, 0x64F1, 0x54F0, 0x54EF, 0x5CF0, 0x6531, 0x6D51, 0x6D51, 0x6D51, 0x6571, 0x6D91, 0x6DB1, 0x6D91, 0x5CCE, 0x546C, 0x4C0B, 0x3368, 0x2B27, 0x2B47, 0x3347, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3B68, 0x3B68, 0x3B48, 
        0x3B48, 0x3B28, 0x3B08, 0x3B29, 0x538B, 0x6C4E, 0x744E, 0x6C0D, 0x5B8C, 0x6BEE, 0x8491, 0x8471, 0x8471, 0x8472, 0x6C0F, 0x538B, 0x3B49, 0x3348, 0x3367, 0x2B67, 0x2B67, 0x2367, 0x2366, 0x2366, 0x2366, 0x2346, 0x2346, 0x1B26, 0x1B26, 0x2325, 
        0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x2346, 0x2346, 0x2366, 0x2B86, 0x2BC6, 0x2BC6, 0x33E7, 0x33E7, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C47, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C68, 0x3C48, 0x3C48, 0x3C48, 0x3C28, 0x3C28, 0x3C28, 0x4428, 0x4428, 0x4428, 0x4C28, 0x4C29, 0x4C29, 0x4C29, 0x4C08, 0x4BE8, 0x4BE8, 0x4BC8, 0x43A8, 0x4388, 0x3B68, 0x3B68, 0x3B48, 0x3327, 0x3307, 0x32E7, 0x32E7, 0x2AC7, 0x2AA7,
  0x8D31, 0x84B0, 0x6BCD, 0x4288, 0x4AC9, 0x3AA8, 0x21C4, 0x19A4, 0x1984, 0x19A4, 0x19A4, 0x19A4, 0x19E4, 0x2204, 0x3285, 0x32C5, 0x22A4, 0x3386, 0x4D2B, 0x4D4B, 0x4D8B, 0x55CC, 0x5E0D, 0x664E, 0x6E4F, 0x6E30, 0x7611, 0x7DB2, 0x8511, 0x5BAC, 0x32C7, 
        0x2AA5, 0x2AC5, 0x2AE5, 0x2B05, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x53A7, 0x5BC7, 0x5BC7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE7, 0x53E7, 0x5407, 0x4C07, 0x4C07, 0x43E6, 0x3BC6, 0x3BC6, 0x33A6, 0x3385, 0x3365, 0x2B25, 0x2B04, 0x22E4, 
        0x22C4, 0x22C4, 0x1AA4, 0x22A4, 0x22A4, 0x22A4, 0x2AC5, 0x2AC5, 0x32C6, 0x3AE7, 0x3B09, 0x4B4B, 0x534D, 0x5B8E, 0x5BCF, 0x5BEF, 0x5C0E, 0x53EC, 0x43AA, 0x4388, 0x43E8, 0x544A, 0x54AB, 0x54CB, 0x54AC, 0x546B, 0x43C8, 0x3B87, 0x3367, 0x3B66, 
        0x3B66, 0x3B46, 0x4347, 0x4B68, 0x4B69, 0x4B2A, 0x42EA, 0x3B2A, 0x43AB, 0x4C2D, 0x548D, 0x5CAE, 0x650F, 0x6D0F, 0x6CEE, 0x5C8C, 0x5429, 0x4C08, 0x4BE8, 0x4BE7, 0x43E7, 0x43C7, 0x3BC6, 0x3BC6, 0x3BA6, 0x33A5, 0x2BA5, 0x2BA5, 0x2BA5, 0x23A5, 
        0x23A5, 0x23A5, 0x23A6, 0x23A6, 0x23A6, 0x2BA6, 0x2BA6, 0x33C7, 0x43E9, 0x4C2B, 0x544C, 0x542C, 0x5C0D, 0x53ED, 0x53CE, 0x5BEF, 0x5C30, 0x5C4F, 0x540D, 0x43AA, 0x3348, 0x3346, 0x3346, 0x3346, 0x3346, 0x3326, 0x3327, 0x3307, 0x3307, 0x32E7, 
        0x3AE8, 0x32C8, 0x32C8, 0x32A8, 0x32A8, 0x32A8, 0x3288, 0x3288, 0x3288, 0x3287, 0x3287, 0x32A7, 0x32A7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2286, 0x2286, 0x2266, 0x2246, 0x2246, 0x2246, 0x2A27, 0x2A07, 0x21C7, 0x3A4B, 0x7C15, 0x9CBB, 0x9C9C, 
        0x9C7D, 0x9C5D, 0x9C5E, 0x943E, 0x941E, 0x941E, 0x83FE, 0x7BBE, 0x7BBE, 0x7BBE, 0x73BE, 0x6BBE, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B3E, 0x6B1E, 0x6B1E, 0x62FE, 0x62DE, 0x5ADE, 0x5ABE, 0x529E, 0x529E, 0x4A9D, 0x529E, 0x529E, 0x52BD, 
        0x52BD, 0x52BE, 0x5ADD, 0x737E, 0x83DE, 0x7BFE, 0x83FE, 0x841E, 0x7BFE, 0x83FE, 0x83FE, 0x7BDD, 0x83DE, 0x83FE, 0x83FE, 0x83DE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BDE, 0x6B9E, 0x631E, 0x5ABD, 0x6B5D, 0x7BDD, 0x83FE, 0x83FF, 0x73DE, 0x6B7E, 0x635D, 
        0x635D, 0x5B3E, 0x5B3E, 0x531D, 0x531E, 0x531E, 0x4B1E, 0x533E, 0x533E, 0x533E, 0x533E, 0x5B5D, 0x639E, 0x6BBE, 0x73FE, 0x741E, 0x7C3F, 0x7C3F, 0x7C1F, 0x73FE, 0x6BDE, 0x6BDE, 0x63BE, 0x5B7E, 0x5B5E, 0x537E, 0x535E, 0x5B5E, 0x535E, 0x533E, 
        0x533E, 0x531D, 0x531E, 0x52FE, 0x52FE, 0x4AFD, 0x4AFD, 0x4ADD, 0x4ADD, 0x4ABD, 0x4ABD, 0x42BD, 0x429D, 0x427D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A9D, 0x429D, 0x429D, 0x429E, 0x429E, 0x3A9D, 0x429E, 0x429D, 0x42BD, 0x4ADD, 0x52FE, 0x5B1E, 
        0x5B3E, 0x633D, 0x635D, 0x635D, 0x635D, 0x635E, 0x635E, 0x633E, 0x633E, 0x633E, 0x633D, 0x6B3E, 0x6B7D, 0x843E, 0x7BFD, 0x73BE, 0x6BBE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x7BDE, 0x7BBE, 0x6B5E, 0x5ABD, 0x527D, 0x527D, 0x529E, 0x5A9D, 
        0x5A9D, 0x5ABD, 0x5ABD, 0x5ADD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B3D, 0x6B3E, 0x6B5D, 0x737E, 0x73BE, 
        0x7BFD, 0x7C5C, 0x7479, 0x64D2, 0x54F0, 0x54CF, 0x5CF0, 0x5D10, 0x6551, 0x6D51, 0x6D71, 0x6591, 0x6D91, 0x6DB1, 0x6D50, 0x64CE, 0x542C, 0x43AA, 0x3328, 0x2B27, 0x2B47, 0x3347, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3B68, 0x3368, 0x3B48, 
        0x3348, 0x3B28, 0x3B28, 0x4349, 0x5BEC, 0x84B0, 0x8CB0, 0x7C4E, 0x6BCD, 0x8CB1, 0x94D2, 0x8CB2, 0x84B2, 0x7470, 0x5BED, 0x3B49, 0x3348, 0x3368, 0x3388, 0x3387, 0x2B87, 0x2B87, 0x2B87, 0x2386, 0x2386, 0x2366, 0x2366, 0x2346, 0x2346, 0x2346, 
        0x2346, 0x2346, 0x2345, 0x2345, 0x2345, 0x1B26, 0x2346, 0x2346, 0x2366, 0x2B86, 0x2BA6, 0x2BC6, 0x33C7, 0x33E7, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C47, 0x3C47, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C68, 0x3C68, 0x3C48, 0x3C48, 0x4448, 0x4428, 0x4428, 0x4428, 0x4428, 0x4428, 0x4C28, 0x4C29, 0x4C29, 0x4C29, 0x4C08, 0x4C08, 0x4BE8, 0x4BE9, 0x4BC8, 0x43A8, 0x4388, 0x4388, 0x3B68, 0x3B48, 0x3327, 0x3307, 0x3307, 0x32E7, 0x32E7,
  0x9591, 0x9531, 0x84AF, 0x636B, 0x3A47, 0x5B8C, 0x4B0A, 0x21A5, 0x1984, 0x1984, 0x1984, 0x19A4, 0x19C4, 0x19E4, 0x2A45, 0x3AE6, 0x32E5, 0x22E4, 0x4CCA, 0x4D4B, 0x4D6B, 0x55AC, 0x55ED, 0x662E, 0x6E2F, 0x6E30, 0x75F1, 0x7D92, 0x8532, 0x534B, 0x3286, 
        0x32A6, 0x2AC5, 0x2AE5, 0x2B05, 0x3325, 0x3B46, 0x4366, 0x4B87, 0x53A7, 0x53C7, 0x5BE8, 0x5BE7, 0x5BE7, 0x5BE7, 0x5BE8, 0x5BE8, 0x53E7, 0x53E7, 0x4BE7, 0x4C07, 0x4BE7, 0x43E6, 0x43C6, 0x3BC6, 0x3BA6, 0x3385, 0x3345, 0x2B45, 0x2B24, 0x2304, 
        0x22E4, 0x22E4, 0x22C4, 0x22C4, 0x22C4, 0x22C4, 0x2AE5, 0x2AE5, 0x32E5, 0x32E6, 0x3AE7, 0x4309, 0x4B4B, 0x536D, 0x5BAF, 0x5BCF, 0x5BEF, 0x5BED, 0x4BCB, 0x43A9, 0x4BE9, 0x548B, 0x5CCB, 0x54CB, 0x54AC, 0x548B, 0x43E8, 0x3B87, 0x3366, 0x3B66, 
        0x3B66, 0x3B66, 0x4367, 0x4B88, 0x538A, 0x4B2A, 0x42EA, 0x3B0A, 0x436A, 0x4BEC, 0x4C4C, 0x54AD, 0x5CEE, 0x652F, 0x6D0E, 0x64CC, 0x544A, 0x5408, 0x4C08, 0x4C07, 0x43E7, 0x43E7, 0x3BE6, 0x3BE6, 0x33C6, 0x33C6, 0x2BA5, 0x2BA5, 0x23A5, 0x2BA5, 
        0x2BA5, 0x2BA5, 0x23C6, 0x23C6, 0x23A6, 0x2BA6, 0x2BC6, 0x33C7, 0x3BC8, 0x4C0A, 0x542B, 0x5C2D, 0x5C0D, 0x5BEE, 0x5BEF, 0x5C0F, 0x5C30, 0x5C2E, 0x4BCC, 0x3B89, 0x3347, 0x2B46, 0x2B46, 0x3346, 0x3346, 0x3326, 0x3327, 0x3307, 0x3307, 0x32E8, 
        0x32E8, 0x3AC8, 0x3AC8, 0x3AC8, 0x3AC8, 0x3AC8, 0x3AA8, 0x3AA8, 0x3AA8, 0x3AA8, 0x3AA8, 0x32C8, 0x32C8, 0x32C8, 0x2AA7, 0x2AA7, 0x2AA7, 0x2A86, 0x2286, 0x2266, 0x2266, 0x2A46, 0x2A27, 0x21E7, 0x42CC, 0x6BB2, 0x9499, 0x947C, 0x943D, 0x8C1E, 
        0x8BFE, 0x93FE, 0x93FE, 0x8BFE, 0x8BFE, 0x8BFE, 0x7BDD, 0x7BBE, 0x7BDE, 0x73BE, 0x73BE, 0x73BE, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B3E, 0x6B1E, 0x631E, 0x62FE, 0x62DE, 0x5ADE, 0x5ABE, 0x529E, 0x529E, 0x4A9D, 0x4A9E, 0x4A9E, 0x4A9E, 0x529E, 
        0x52BD, 0x5ABD, 0x6B3D, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x6B9E, 0x5B3E, 0x52BD, 0x52BE, 0x633E, 0x739E, 0x7BDE, 0x7BDE, 0x7BFF, 0x739E, 
        0x635D, 0x633D, 0x531D, 0x4B1D, 0x4B1E, 0x4B1D, 0x531D, 0x531D, 0x533D, 0x5B5D, 0x639E, 0x73FE, 0x7C3F, 0x7C3F, 0x7C3E, 0x7C3E, 0x7C5E, 0x845F, 0x845F, 0x7C5E, 0x7C5E, 0x7C3E, 0x741E, 0x639E, 0x5B5E, 0x535E, 0x535E, 0x535E, 0x533E, 0x533E, 
        0x531D, 0x531D, 0x52FE, 0x52FE, 0x4AFE, 0x4ADD, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x429D, 0x429D, 0x427D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A9D, 0x3A9D, 0x3A7D, 0x3A9D, 0x3A9D, 0x429D, 0x4ABE, 0x4AFE, 0x52FE, 0x5B1E, 0x5B3E, 
        0x633E, 0x633E, 0x635E, 0x633E, 0x635E, 0x635E, 0x633E, 0x633E, 0x633E, 0x633E, 0x635D, 0x6B5D, 0x6B7D, 0x7C1E, 0x7BFE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x6B3E, 0x5ABD, 0x529D, 0x529D, 0x529D, 
        0x529D, 0x52BE, 0x52BD, 0x52BD, 0x5ADE, 0x52FD, 0x5AFE, 0x5AFE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x6B3E, 0x6B5E, 0x737E, 0x739E, 
        0x7BDE, 0x7C1D, 0x747A, 0x64D4, 0x5CF0, 0x54CF, 0x54CF, 0x5D10, 0x6551, 0x6D71, 0x6D71, 0x6591, 0x65B1, 0x6D91, 0x6530, 0x64AE, 0x5C4D, 0x4BCA, 0x3328, 0x2B27, 0x2B47, 0x2B47, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3368, 0x3368, 0x3B68, 
        0x3348, 0x3B28, 0x3B28, 0x4B4A, 0x6C2D, 0x8CF1, 0x94D1, 0x846F, 0x8470, 0x8C91, 0x8CB1, 0x8CD2, 0x84D2, 0x6C4E, 0x4BAB, 0x3B49, 0x3B89, 0x3BA9, 0x3BC9, 0x3BC9, 0x33A8, 0x33A8, 0x2BA7, 0x2B87, 0x2B86, 0x2386, 0x2366, 0x2366, 0x2366, 0x2366, 
        0x2366, 0x2346, 0x2345, 0x1B45, 0x1B45, 0x1B46, 0x2346, 0x2366, 0x2366, 0x2B86, 0x2BA6, 0x2BC6, 0x33C6, 0x33E7, 0x3407, 0x3C07, 0x3C07, 0x3C27, 0x3C47, 0x3C47, 0x3C47, 0x3C48, 0x3C48, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C68, 0x3C68, 0x3C68, 0x3C48, 0x3C48, 0x4428, 0x4428, 0x4428, 0x4428, 0x4C28, 0x4C29, 0x4C29, 0x4C29, 0x5409, 0x5408, 0x4C09, 0x4C09, 0x4BE9, 0x4BC8, 0x4BC8, 0x43A8, 0x4388, 0x4368, 0x3B67, 0x3B47, 0x3B28, 0x3307, 0x32E8, 0x32E7,
  0x95B0, 0x9571, 0x9510, 0x848F, 0x52E9, 0x52EA, 0x73EE, 0x3A68, 0x1964, 0x1964, 0x1984, 0x21A4, 0x19C4, 0x21E4, 0x2244, 0x32C6, 0x32E6, 0x2AE4, 0x4429, 0x550C, 0x4D0B, 0x44EA, 0x55AD, 0x5E0E, 0x6E10, 0x6E11, 0x6D90, 0x6D30, 0x7D11, 0x640E, 0x42E9, 
        0x32A7, 0x32A6, 0x32C5, 0x32E5, 0x3305, 0x3B26, 0x4366, 0x4387, 0x4BA7, 0x53C7, 0x53C8, 0x5BE8, 0x5BE8, 0x5BE7, 0x5BE8, 0x5BE7, 0x53E7, 0x53E7, 0x4BE7, 0x4BE7, 0x43C6, 0x43C6, 0x43C6, 0x3BA6, 0x3385, 0x3385, 0x3365, 0x2B45, 0x2B24, 0x2B04, 
        0x2304, 0x22E4, 0x22E4, 0x22E4, 0x22E4, 0x22E4, 0x2AE5, 0x32E5, 0x32E5, 0x3306, 0x3B06, 0x3B08, 0x4B4A, 0x536C, 0x5B8E, 0x5BAF, 0x5BCF, 0x5BEF, 0x5BED, 0x4BCA, 0x4C0A, 0x54AB, 0x54CB, 0x54AB, 0x54AB, 0x548B, 0x43E9, 0x3387, 0x3366, 0x3366, 
        0x3B66, 0x3B66, 0x4367, 0x4B88, 0x4B69, 0x4B2A, 0x4B0A, 0x430A, 0x434A, 0x43CB, 0x4C2C, 0x548D, 0x5CEE, 0x650E, 0x6D2E, 0x64ED, 0x5C6A, 0x5429, 0x4C08, 0x4C07, 0x4C07, 0x4407, 0x4406, 0x3BE6, 0x33E6, 0x33C6, 0x2BC5, 0x2BC5, 0x2BA5, 0x2BC5, 
        0x2BC5, 0x23C5, 0x23C5, 0x2BC5, 0x2BC6, 0x2BC6, 0x2BA6, 0x33C7, 0x33A8, 0x4BE9, 0x540B, 0x5C2D, 0x5C2E, 0x5C2E, 0x5C0F, 0x5C2F, 0x5C4F, 0x542E, 0x43CB, 0x3368, 0x2B47, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x3307, 0x32E7, 0x32E8, 0x32E8, 
        0x3AC8, 0x3AE8, 0x3AC8, 0x3AC8, 0x3AC9, 0x3AC8, 0x3AE9, 0x3AC8, 0x3AC8, 0x3AC9, 0x3AC8, 0x3AC8, 0x3AC8, 0x32C8, 0x32C8, 0x2AA7, 0x2AA7, 0x2AA7, 0x2A87, 0x2A66, 0x2A47, 0x2A47, 0x42CC, 0x73F4, 0x94D9, 0x9CBC, 0x947D, 0x8C1D, 0x8BDE, 0x83DE, 
        0x83DE, 0x83DE, 0x8BDE, 0x83DE, 0x83DE, 0x83DE, 0x7BBE, 0x7BBE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B7D, 0x633E, 0x633E, 0x62FE, 0x62FE, 0x62DE, 0x62DE, 0x5ABE, 0x529E, 0x529D, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7E, 0x529E, 0x529E, 
        0x5ABD, 0x6B5E, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x73DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x6B9E, 0x5B3E, 0x52DE, 0x4A7D, 0x52DE, 0x633D, 0x6B7E, 0x73BE, 0x7BFF, 0x7BFE, 
        0x73BE, 0x635D, 0x52FD, 0x4AFD, 0x531D, 0x531E, 0x5B5E, 0x639E, 0x6BDE, 0x741E, 0x7C3E, 0x7C1E, 0x7C1E, 0x7C1E, 0x843E, 0x7C3E, 0x7C3E, 0x843E, 0x845F, 0x845E, 0x845E, 0x7C3E, 0x7C3E, 0x6BDE, 0x637E, 0x533E, 0x533E, 0x533E, 0x531E, 0x4B1E, 
        0x4B1E, 0x531E, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADD, 0x4ABD, 0x42BD, 0x42BD, 0x4A9D, 0x429D, 0x429D, 0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A9D, 0x429D, 0x4ADE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 
        0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x6B5E, 0x737D, 0x7BDE, 0x7BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x739E, 0x6B3E, 0x5ADD, 0x529D, 0x529D, 
        0x529D, 0x529E, 0x52BE, 0x52BD, 0x52DD, 0x52DD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B3E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x635E, 0x6B7E, 0x737E, 
        0x73BE, 0x7BFE, 0x7C7C, 0x6CD6, 0x5CD1, 0x54D0, 0x54CF, 0x5D10, 0x6571, 0x6D92, 0x6D91, 0x6DD2, 0x6DD1, 0x6D91, 0x6530, 0x542C, 0x3B69, 0x3B28, 0x3308, 0x2B27, 0x2B27, 0x2B47, 0x2B47, 0x2B67, 0x3367, 0x3367, 0x3367, 0x3367, 0x3368, 0x3368, 
        0x3368, 0x3B28, 0x3B28, 0x538A, 0x7C6E, 0x9CF1, 0xA532, 0xA533, 0x94F2, 0x8CD2, 0x8CD2, 0x8D12, 0x7CD0, 0x5C2D, 0x4BCB, 0x4BEB, 0x4C0B, 0x440B, 0x440A, 0x440A, 0x3BE9, 0x3BE9, 0x33C8, 0x2BA7, 0x2B87, 0x2386, 0x2386, 0x2386, 0x2366, 0x2386, 
        0x2366, 0x2365, 0x2345, 0x1B45, 0x1B45, 0x1B45, 0x2366, 0x2365, 0x2366, 0x2386, 0x2386, 0x2BA6, 0x2BC6, 0x33C6, 0x33E7, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C47, 0x3C47, 0x3C47, 0x3C48, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 0x3C68, 
        0x3C68, 0x3C68, 0x3C68, 0x3C48, 0x3C48, 0x4448, 0x4448, 0x4448, 0x4448, 0x4C29, 0x4C29, 0x4C28, 0x4C08, 0x5409, 0x4C08, 0x4BE8, 0x4BE8, 0x53E8, 0x4BE8, 0x4BC8, 0x4BA8, 0x4388, 0x4388, 0x4367, 0x3B47, 0x3B47, 0x3B27, 0x3307, 0x32E7,
  0x95CF, 0x95B0, 0x9570, 0x9510, 0x7C2E, 0x638C, 0x742F, 0x6BCE, 0x3207, 0x1964, 0x1984, 0x21C4, 0x21E5, 0x2204, 0x2224, 0x32C6, 0x32C5, 0x3B26, 0x3BA8, 0x54CB, 0x4CEB, 0x554D, 0x558D, 0x5DCE, 0x5DCE, 0x65AF, 0x6DB0, 0x6D50, 0x8573, 0x7490, 0x5B8C, 
        0x3286, 0x2AA6, 0x32C5, 0x32E5, 0x3305, 0x3326, 0x3B66, 0x4387, 0x4BA7, 0x53C7, 0x53E7, 0x53E8, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x4BE7, 0x4BE7, 0x43C7, 0x43C6, 0x43C6, 0x3BA6, 0x3BA5, 0x3385, 0x3385, 0x3365, 0x2B45, 0x2B24, 0x2B04, 
        0x2304, 0x2304, 0x2304, 0x2304, 0x2304, 0x2B04, 0x2B05, 0x3305, 0x3305, 0x3B06, 0x3B27, 0x4328, 0x4329, 0x4B4B, 0x536D, 0x5B8E, 0x63CF, 0x63EF, 0x5C0F, 0x5C2D, 0x544C, 0x548C, 0x54CC, 0x54AB, 0x54AB, 0x548B, 0x4429, 0x3387, 0x3366, 0x3366, 
        0x3366, 0x3B66, 0x4367, 0x4B88, 0x4B69, 0x4B2A, 0x430A, 0x430A, 0x3B4A, 0x43AB, 0x4C0B, 0x4C6C, 0x5CCD, 0x650E, 0x652E, 0x650D, 0x548A, 0x5429, 0x4C08, 0x4C07, 0x4C07, 0x4407, 0x4406, 0x3C06, 0x33E6, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x23C5, 0x23C5, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x33A7, 0x33A7, 0x3BC8, 0x4C0A, 0x544C, 0x5C4D, 0x5C4E, 0x5C2F, 0x5C2F, 0x5C2F, 0x540C, 0x3B8A, 0x3368, 0x2B46, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2B07, 0x2B07, 0x2AE7, 0x32C7, 0x32C8, 
        0x32C8, 0x3AC8, 0x3AC8, 0x3AC8, 0x42C9, 0x42C8, 0x42C9, 0x42E9, 0x42E9, 0x3AC9, 0x3AC9, 0x3AE8, 0x3AC8, 0x32C8, 0x32C8, 0x32C8, 0x2AA7, 0x2AA7, 0x2A87, 0x2A67, 0x2A28, 0x536F, 0x8CB9, 0x949C, 0x945D, 0x943E, 0x8C1E, 0x83FE, 0x83BE, 0x7BBE, 
        0x7BBE, 0x7BDE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x635D, 0x633E, 0x631E, 0x5AFE, 0x5ADE, 0x5ABE, 0x5ABE, 0x529E, 0x527D, 0x4A7D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A5D, 0x527D, 0x5ABD, 
        0x735E, 0x7BDE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73DE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x637E, 0x5B5E, 0x531E, 0x429D, 0x429D, 0x52DD, 0x631D, 0x6B7E, 0x7BBE, 0x7BDE, 
        0x7BDE, 0x739E, 0x633D, 0x635E, 0x6B9E, 0x6BBE, 0x73DE, 0x73FE, 0x73DD, 0x73DD, 0x73DD, 0x7BDD, 0x7BDE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C3E, 0x843E, 0x845E, 0x843E, 0x845E, 0x843E, 0x7C3E, 0x741E, 0x6BBE, 0x533D, 0x531E, 0x531E, 0x4B1E, 0x4B1D, 
        0x4AFD, 0x4B1E, 0x4AFE, 0x4ADE, 0x4ADD, 0x4ABD, 0x42BD, 0x429D, 0x429D, 0x429D, 0x429D, 0x427D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x427D, 0x429D, 0x4ABD, 0x52FE, 0x52FE, 0x5B1E, 0x5B1E, 0x5B1E, 0x631D, 
        0x631E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x633E, 0x633E, 0x6B5E, 0x6B5E, 0x6B7D, 0x73BD, 0x73BE, 0x73BE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BDE, 0x6BBE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B3E, 0x5ADD, 0x529D, 
        0x529E, 0x529E, 0x529E, 0x52BD, 0x52BD, 0x52DD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x633E, 0x633E, 0x633E, 0x633D, 0x635D, 0x6B5E, 0x737E, 
        0x739E, 0x73DE, 0x7C5C, 0x74B8, 0x64D3, 0x54D0, 0x54CF, 0x5D10, 0x6551, 0x6D91, 0x6DB2, 0x6DD2, 0x6DD1, 0x6DB1, 0x650F, 0x43CA, 0x2B07, 0x3307, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2B47, 0x2B47, 0x3367, 0x3367, 0x3367, 0x3367, 0x3368, 0x3368, 
        0x3368, 0x3B48, 0x3B49, 0x5C0C, 0x8CD0, 0xB5B3, 0xC616, 0xB5B5, 0x9D33, 0x94F2, 0x8D12, 0x8D52, 0x74F0, 0x648E, 0x5C4D, 0x5C4D, 0x4C2B, 0x43EA, 0x43EA, 0x3BCA, 0x3BE9, 0x3BE9, 0x33C8, 0x2BA7, 0x2B87, 0x2B86, 0x2386, 0x2386, 0x2386, 0x2386, 
        0x2386, 0x2365, 0x2365, 0x2365, 0x1B45, 0x1B45, 0x2345, 0x2365, 0x2365, 0x2366, 0x2386, 0x2B86, 0x2BA6, 0x2BC6, 0x33C7, 0x33E6, 0x3407, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3C47, 0x3C47, 0x3C48, 0x4448, 0x4468, 0x4468, 0x4468, 0x4468, 0x4488, 
        0x4488, 0x4468, 0x4468, 0x4448, 0x4448, 0x4448, 0x4448, 0x4448, 0x4448, 0x4C29, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BA8, 0x4388, 0x4388, 0x4367, 0x3B47, 0x3B47, 0x3B27, 0x3B07, 0x32E7,
  0x95CE, 0x95AF, 0x9D90, 0x9D71, 0x9511, 0x7C2E, 0x8490, 0x8490, 0x6BCD, 0x42A9, 0x3206, 0x3A67, 0x3A87, 0x2A05, 0x2A24, 0x3285, 0x4327, 0x53A9, 0x43A8, 0x4C4A, 0x654D, 0x658E, 0x5D8D, 0x5DAE, 0x65CF, 0x554E, 0x6DB1, 0x7DB2, 0x8593, 0x84D2, 0x5BAD, 
        0x5BAB, 0x4308, 0x2AC5, 0x2AE5, 0x3305, 0x3326, 0x3B66, 0x4387, 0x4387, 0x4BA7, 0x53C7, 0x53E7, 0x53E7, 0x53E8, 0x53E8, 0x53E8, 0x53E7, 0x4BE7, 0x4BC7, 0x43C6, 0x43A6, 0x3BA6, 0x3BA5, 0x3385, 0x3385, 0x3385, 0x3365, 0x3345, 0x2B24, 0x2B24, 
        0x2324, 0x2B04, 0x2304, 0x2304, 0x2B04, 0x2B04, 0x2B05, 0x3306, 0x3B47, 0x4B88, 0x53A9, 0x53AA, 0x538A, 0x538B, 0x5B8D, 0x5BAE, 0x63CF, 0x63EF, 0x640F, 0x5C4E, 0x5C8D, 0x54AC, 0x54CC, 0x54CC, 0x54CC, 0x5CAC, 0x546B, 0x43E8, 0x3BA7, 0x3BA7, 
        0x3B86, 0x3B86, 0x4387, 0x4387, 0x4B68, 0x4329, 0x4309, 0x3B09, 0x3B29, 0x438B, 0x43EB, 0x4C4C, 0x54AD, 0x5CED, 0x650D, 0x650D, 0x5C8B, 0x5429, 0x4C08, 0x4C07, 0x4407, 0x4407, 0x4406, 0x3C06, 0x33E6, 0x33E5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x2BC5, 0x2BE5, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BA6, 0x33A7, 0x3BC8, 0x440A, 0x544C, 0x544D, 0x544E, 0x542E, 0x542E, 0x540D, 0x43AA, 0x3B68, 0x2B47, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2AE7, 0x2AC7, 0x32C7, 0x32C7, 
        0x32C8, 0x3AC8, 0x3AC8, 0x3AC8, 0x42C9, 0x42C8, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x3AE9, 0x3AE9, 0x3AE8, 0x3AE8, 0x32E8, 0x32C8, 0x32A8, 0x2A88, 0x3269, 0x5B71, 0x94BA, 0x8C3D, 0x8BFE, 0x8BDE, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 
        0x73BE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B7E, 0x6B7D, 0x635E, 0x633D, 0x62FE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5A9E, 0x527D, 0x4A7D, 0x4A5D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x5A9D, 0x737E, 
        0x7BDE, 0x83FE, 0x83FE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x73FE, 0x73DE, 0x73DE, 0x6BBE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x6BBE, 0x6BBE, 0x639E, 0x5B7E, 0x531E, 0x4ADE, 0x427D, 0x4A7D, 0x52BD, 0x5AFD, 0x633D, 0x6B5D, 
        0x737E, 0x6B5E, 0x6B7E, 0x635E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B9E, 0x739E, 0x739D, 0x73BD, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C3E, 0x7C3E, 0x7C3E, 0x7C1E, 0x7C1E, 0x73FE, 0x5B7D, 0x531D, 0x531E, 0x4B1E, 0x4B1E, 
        0x4AFD, 0x4AFE, 0x4ADD, 0x4ABD, 0x4ABD, 0x42BD, 0x429D, 0x429D, 0x427D, 0x427D, 0x427D, 0x3A7D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x323D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A5D, 0x427D, 0x4ABD, 0x52DD, 0x52DE, 0x52FE, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1D, 
        0x5B1D, 0x5B3E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x6B5E, 0x6B5E, 0x6B7D, 0x739D, 0x73DE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x633E, 0x52BD, 
        0x529E, 0x529E, 0x52BE, 0x52BE, 0x52BD, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x531E, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B5E, 
        0x737E, 0x73BE, 0x743D, 0x7499, 0x64D3, 0x5CF1, 0x54F0, 0x5D10, 0x6551, 0x6571, 0x6DB2, 0x6DB2, 0x6DB1, 0x6DB1, 0x5CCE, 0x3BA9, 0x2B07, 0x2B07, 0x2B07, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x2B47, 0x3367, 0x3367, 0x3367, 0x3367, 0x3368, 0x3368, 
        0x3368, 0x3348, 0x4389, 0x644D, 0x8D10, 0xB5B3, 0xC5D4, 0xAD53, 0x9D12, 0x8D12, 0x8D32, 0x8551, 0x7510, 0x64CE, 0x5C8D, 0x542B, 0x43CA, 0x3BA9, 0x3BA9, 0x3BA9, 0x33A8, 0x33C8, 0x33A8, 0x2BA7, 0x2BA7, 0x2BA6, 0x2BA6, 0x2386, 0x2386, 0x23A6, 
        0x2386, 0x2385, 0x2365, 0x2365, 0x1B65, 0x1B45, 0x1B45, 0x2345, 0x2345, 0x2365, 0x2366, 0x2B86, 0x2B86, 0x2BA6, 0x33C6, 0x33E6, 0x33E6, 0x3406, 0x3C07, 0x3C27, 0x3C27, 0x3C47, 0x3C48, 0x4448, 0x4448, 0x4448, 0x4C68, 0x4C68, 0x4C68, 0x4C68, 
        0x4C68, 0x4469, 0x4469, 0x4469, 0x4469, 0x4469, 0x4448, 0x4449, 0x4449, 0x4C29, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BA8, 0x4BA8, 0x4388, 0x4367, 0x4347, 0x3B47, 0x3B27, 0x3B07, 0x3AE7,
  0x8DCE, 0x95AF, 0x95B0, 0x9DB1, 0x9D91, 0x9531, 0x9511, 0x8CD1, 0x84B0, 0x6BCD, 0x3A47, 0x4AA8, 0x6BED, 0x3AA7, 0x2A45, 0x42E7, 0x4327, 0x3AE6, 0x5C0A, 0x648C, 0x546B, 0x5D2D, 0x5D6D, 0x5DAE, 0x65EF, 0x6E11, 0x7612, 0x7DF3, 0x85B3, 0x8533, 0x6C2F, 
        0x42C9, 0x32A6, 0x32C6, 0x32E5, 0x3306, 0x3326, 0x3B66, 0x3B67, 0x4387, 0x4BA7, 0x4BC7, 0x53C7, 0x53E7, 0x53E7, 0x53E7, 0x53E8, 0x53E7, 0x4BE7, 0x43C7, 0x43A6, 0x3BA6, 0x3B86, 0x3B86, 0x3385, 0x3365, 0x3365, 0x3365, 0x3345, 0x2B24, 0x2B24, 
        0x2324, 0x2B24, 0x2B04, 0x2305, 0x2B05, 0x3325, 0x3326, 0x4367, 0x53C9, 0x5BEA, 0x5C0B, 0x642B, 0x642B, 0x640C, 0x640E, 0x63EF, 0x63EF, 0x6C10, 0x6C30, 0x6C6F, 0x64AF, 0x64CE, 0x5CED, 0x5CEC, 0x5CED, 0x64ED, 0x5CAC, 0x544A, 0x4C09, 0x4C08, 
        0x43E8, 0x3BA7, 0x3B87, 0x4387, 0x4387, 0x4348, 0x3B28, 0x3B09, 0x3B09, 0x3B6A, 0x43CB, 0x4C2C, 0x548C, 0x5CCD, 0x5CED, 0x650D, 0x5CCC, 0x5449, 0x4C08, 0x4C07, 0x4407, 0x4407, 0x4406, 0x3BE6, 0x33E6, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BA6, 0x33A7, 0x3BC8, 0x442A, 0x546C, 0x546D, 0x4C4D, 0x4C2E, 0x4C0D, 0x43AB, 0x3348, 0x2B27, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2AE6, 0x2AE7, 0x2AC7, 0x2AC7, 
        0x32A8, 0x32C8, 0x3AC8, 0x3AC9, 0x42C9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x3AE9, 0x3AE9, 0x3AE8, 0x32C8, 0x32C8, 0x3289, 0x6BB2, 0x949A, 0x8C5C, 0x83FD, 0x7BBE, 0x7BBE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73BE, 
        0x73BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x7BBE, 0x73BE, 0x739E, 0x739E, 0x739E, 0x737E, 0x6B7E, 0x6B5E, 0x633E, 0x631D, 0x5AFE, 0x5ADE, 0x5ABD, 0x5A9D, 0x529D, 0x4A7D, 0x4A5D, 0x425D, 0x423D, 0x423D, 0x425D, 0x529D, 0x737E, 0x7BDE, 
        0x83DE, 0x83DE, 0x83DE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x637E, 0x5B5E, 0x531E, 0x4ADE, 0x4A9D, 0x4A9D, 0x52BD, 0x5ABD, 0x5ADD, 
        0x5ADD, 0x5AFD, 0x5AFD, 0x5AFE, 0x631E, 0x631D, 0x633E, 0x6B5E, 0x6B5E, 0x6B7E, 0x737E, 0x6B9E, 0x739E, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C1E, 0x73FE, 0x637D, 0x531E, 0x531E, 0x4B1E, 0x4B1D, 
        0x4AFE, 0x4ADE, 0x42BE, 0x42BE, 0x42BD, 0x429E, 0x429D, 0x427D, 0x427D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A3D, 0x323D, 0x323D, 0x323D, 0x3A3D, 0x3A3D, 0x3A5D, 0x427D, 0x4A9E, 0x4ABD, 0x52DE, 0x52FE, 0x52FE, 0x531D, 0x5B1D, 0x5B1D, 0x5B1D, 
        0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1E, 0x5B1E, 0x5B3D, 0x5B3E, 0x633E, 0x633E, 0x6B5E, 0x6B5E, 0x6B5D, 0x739D, 0x7BFE, 0x73BE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6BBE, 0x73BE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x633E, 
        0x52BD, 0x529E, 0x52BE, 0x4ABE, 0x4ABD, 0x52BD, 0x52DD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x631E, 0x631E, 0x633E, 0x6B3E, 0x6B5E, 
        0x6B7E, 0x739E, 0x73FD, 0x7479, 0x64B4, 0x5CF1, 0x5CF0, 0x5D30, 0x6551, 0x6591, 0x6D91, 0x6D91, 0x6D71, 0x6D50, 0x548D, 0x3369, 0x2B07, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x3367, 0x3387, 0x3387, 0x3367, 0x3367, 
        0x3368, 0x3368, 0x4BAA, 0x6C6D, 0x8D10, 0xA551, 0xA552, 0x9D12, 0x9532, 0x8D52, 0x8572, 0x7D51, 0x6CEF, 0x5C8C, 0x4C2B, 0x43C9, 0x3BC9, 0x3BA9, 0x3BA8, 0x3BA8, 0x33A8, 0x3BA8, 0x33A7, 0x33A7, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2386, 0x2386, 
        0x2385, 0x2385, 0x2365, 0x2365, 0x2345, 0x1B25, 0x1B45, 0x1B45, 0x1B45, 0x2346, 0x2346, 0x2366, 0x2386, 0x2B86, 0x2BA6, 0x33C6, 0x33C7, 0x33E6, 0x3C07, 0x3C27, 0x3C27, 0x4428, 0x4448, 0x4448, 0x4448, 0x4C68, 0x4C68, 0x4C68, 0x4C68, 0x4C68, 
        0x4C68, 0x4C89, 0x4C89, 0x4C69, 0x4C69, 0x4C69, 0x4469, 0x4449, 0x4449, 0x4C29, 0x4C28, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BA8, 0x4BA8, 0x4388, 0x4367, 0x4347, 0x4347, 0x3B27, 0x3B27, 0x3B08,
  0x8DCE, 0x8DCE, 0x95CF, 0x95B0, 0x95B1, 0x9D91, 0x9551, 0x9531, 0x8CD1, 0x8470, 0x52EA, 0x4268, 0x7C4F, 0x6BED, 0x4B29, 0x4B28, 0x42E6, 0x4B68, 0x5BEA, 0x540A, 0x64CD, 0x652D, 0x5D6D, 0x5DAE, 0x65EF, 0x6E31, 0x7631, 0x7E12, 0x85F3, 0x8593, 0x7471, 
        0x3AA9, 0x32A7, 0x3AC6, 0x32E6, 0x3326, 0x3326, 0x3B66, 0x3B66, 0x4386, 0x43A7, 0x4BA7, 0x4BC8, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x43C7, 0x3BA6, 0x3BA6, 0x3B86, 0x3B86, 0x3365, 0x3365, 0x3365, 0x2B45, 0x3325, 0x2B24, 0x2B24, 
        0x2304, 0x2304, 0x2304, 0x2305, 0x2B25, 0x3B67, 0x4BC9, 0x53EA, 0x5C0B, 0x642B, 0x642C, 0x6C4C, 0x6C4C, 0x6C4C, 0x744E, 0x6C4F, 0x6C2F, 0x6C30, 0x6C50, 0x6C90, 0x6CAF, 0x64CF, 0x64EE, 0x5CED, 0x5D0D, 0x64ED, 0x64ED, 0x64CC, 0x5CAC, 0x5C8B, 
        0x544A, 0x43C8, 0x3BA7, 0x43A7, 0x43A7, 0x3B67, 0x3B48, 0x3B28, 0x3B09, 0x3B4A, 0x438B, 0x4C0C, 0x4C4C, 0x54AD, 0x5CED, 0x650D, 0x64EC, 0x546A, 0x4C08, 0x4407, 0x4407, 0x4407, 0x3BE6, 0x3BE6, 0x33E6, 0x33C6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BC6, 0x2BC6, 0x33C6, 0x33C7, 0x3C09, 0x4C4B, 0x4C8C, 0x446D, 0x444D, 0x442D, 0x43EB, 0x3B89, 0x3348, 0x2B47, 0x2B47, 0x2B66, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B07, 0x2AE7, 0x2AE7, 0x2AC7, 0x32A7, 
        0x32A8, 0x32C8, 0x3AC8, 0x42C9, 0x42C9, 0x4AE9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x4309, 0x4309, 0x42E9, 0x42E9, 0x3AE9, 0x3AAA, 0x530F, 0x949B, 0x943D, 0x83FE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BDE, 0x73DE, 0x73BE, 0x73BE, 
        0x73BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x739E, 0x739E, 0x739E, 0x737E, 0x6B7E, 0x6B5E, 0x633E, 0x631E, 0x62FE, 0x5ADE, 0x52DE, 0x52BE, 0x529E, 0x529E, 0x4A7D, 0x4A5D, 0x423D, 0x423D, 0x423D, 0x4A7D, 0x735E, 0x7BDE, 0x83DE, 
        0x83FE, 0x83FE, 0x83FE, 0x7BFE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x5B5E, 0x533E, 0x4AFE, 0x4ADD, 0x4ABD, 0x4A9D, 0x529D, 0x52BE, 
        0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x5ADE, 0x5AFD, 0x631E, 0x633E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B7D, 0x6B9E, 0x6B9E, 0x6B9E, 0x6BBE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x73FE, 0x637E, 0x531E, 0x4AFE, 0x4AFD, 0x4AFD, 
        0x4AFE, 0x4ADD, 0x42BE, 0x42BE, 0x429D, 0x429D, 0x427D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5E, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x321D, 0x3A3D, 0x3A3D, 0x425D, 0x4A9E, 0x4ABD, 0x4ADD, 0x52FE, 0x52FE, 0x52FD, 0x531D, 0x531D, 0x531D, 0x531D, 
        0x531D, 0x531D, 0x531D, 0x531D, 0x531D, 0x531D, 0x5B1D, 0x5B3D, 0x5B3D, 0x633D, 0x633D, 0x6B3E, 0x6B5E, 0x737D, 0x7B9D, 0x7BDE, 0x7BDE, 0x73DE, 0x6BBE, 0x639E, 0x639E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6BDE, 0x73DE, 0x73BE, 0x73DE, 0x73DE, 0x6B9E, 
        0x5B1D, 0x4ABD, 0x4A9E, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ADD, 0x52DD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x531E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x631E, 0x631E, 0x633E, 0x6B3E, 0x6B5E, 
        0x6B5E, 0x737E, 0x73DE, 0x745B, 0x64B5, 0x5D11, 0x5CF0, 0x5D31, 0x6571, 0x6591, 0x6571, 0x6571, 0x6D51, 0x6D30, 0x546D, 0x3348, 0x2B07, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x3367, 0x3367, 0x3367, 
        0x3367, 0x3368, 0x53EB, 0x6CAE, 0x8D10, 0x9D11, 0x9531, 0x9532, 0x8D52, 0x8572, 0x7D51, 0x6CEF, 0x5C8C, 0x440A, 0x3BC9, 0x3BC9, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x33A8, 0x33A7, 0x33A7, 0x2BA6, 0x2B86, 0x2BA6, 0x2B86, 0x2386, 0x2386, 0x2385, 
        0x2385, 0x2385, 0x2365, 0x2345, 0x2345, 0x1B25, 0x1B25, 0x1B45, 0x1B45, 0x1B45, 0x2346, 0x2366, 0x2366, 0x2B86, 0x2B86, 0x2BA6, 0x33C6, 0x33E7, 0x33E7, 0x3C07, 0x3C27, 0x4428, 0x4448, 0x4428, 0x4C48, 0x4C48, 0x4C68, 0x5468, 0x5468, 0x5468, 
        0x5468, 0x5469, 0x5469, 0x4C69, 0x4C69, 0x4C69, 0x4C69, 0x4449, 0x4449, 0x4429, 0x4428, 0x4408, 0x4408, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BA8, 0x4388, 0x4387, 0x4367, 0x4347, 0x4347, 0x3B47, 0x3B28,
  0x85CE, 0x8DCE, 0x8DCF, 0x95D0, 0x95B0, 0x9590, 0x9570, 0x9550, 0x8D10, 0x8CD0, 0x73CD, 0x52A9, 0x7C0E, 0x7C2F, 0x534A, 0x4B08, 0x42E6, 0x4327, 0x4327, 0x4BC9, 0x5CAC, 0x5D0D, 0x5D4D, 0x5DAE, 0x65EF, 0x6610, 0x7631, 0x7E12, 0x85F3, 0x8593, 0x7CD3, 
        0x4B0B, 0x32A7, 0x3AC7, 0x32C6, 0x3306, 0x3326, 0x3B46, 0x3B46, 0x3B66, 0x4387, 0x43A7, 0x4BC7, 0x4BC7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x43E7, 0x43C7, 0x3BA6, 0x3B86, 0x3B86, 0x3365, 0x3345, 0x3345, 0x3345, 0x2B44, 0x2B24, 0x2B24, 0x2304, 
        0x2304, 0x2304, 0x2305, 0x2B05, 0x3B67, 0x4BEA, 0x5C0B, 0x53EA, 0x5BEA, 0x5C0B, 0x5C0B, 0x63EB, 0x640B, 0x640C, 0x6C4D, 0x744E, 0x744F, 0x746F, 0x7470, 0x6C90, 0x6CD0, 0x6CF0, 0x6D0F, 0x652E, 0x650E, 0x650D, 0x64ED, 0x64ED, 0x64ED, 0x64EC, 
        0x5CAC, 0x544A, 0x4C09, 0x4409, 0x43C8, 0x3BA7, 0x3B68, 0x3B48, 0x3B29, 0x3B29, 0x3B6A, 0x43CB, 0x4C2C, 0x4C8C, 0x5CCD, 0x5CED, 0x64ED, 0x548A, 0x4408, 0x4407, 0x43E7, 0x3BE6, 0x3BE6, 0x3BE6, 0x33E5, 0x33E6, 0x2BE5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BC6, 0x2BC6, 0x33C7, 0x33E7, 0x4449, 0x4C8B, 0x4CAC, 0x446D, 0x444D, 0x442C, 0x3BCB, 0x3369, 0x2B47, 0x2B67, 0x2B67, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B27, 0x2B06, 0x2B07, 0x2AE7, 0x2AC7, 0x32C7, 
        0x32A8, 0x32C8, 0x3AC8, 0x42C9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x4AE9, 0x4AE9, 0x42E9, 0x4309, 0x4309, 0x4309, 0x42E9, 0x42E9, 0x42AC, 0x8457, 0x9C7D, 0x941E, 0x83FE, 0x7BDE, 0x7BDE, 0x7BBE, 0x73BE, 0x73BE, 0x73DE, 0x73BE, 0x73BE, 
        0x73BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B3E, 0x631E, 0x62FE, 0x5AFE, 0x5ADE, 0x52BE, 0x529E, 0x529E, 0x4A7E, 0x4A5D, 0x425D, 0x423D, 0x421D, 0x4A3D, 0x6B3E, 0x7BDE, 0x83DE, 0x7BFE, 
        0x841E, 0x7BFE, 0x7BFE, 0x7BFE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x5B7E, 0x5B5E, 0x533E, 0x4B1E, 0x4AFD, 0x4ADD, 0x4ABD, 0x4A9D, 0x52BD, 
        0x52BE, 0x52BE, 0x52BD, 0x529E, 0x52BE, 0x52DD, 0x5AFD, 0x631E, 0x631E, 0x633D, 0x633E, 0x635E, 0x637E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6BDE, 0x6BDE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x73DE, 0x635E, 0x531D, 0x52FD, 0x4AFD, 0x4AFD, 
        0x4ADE, 0x42BE, 0x42BE, 0x429D, 0x429D, 0x427D, 0x427D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5E, 0x3A5E, 0x3A3E, 0x321D, 0x321D, 0x321D, 0x321D, 0x3A1D, 0x3A5D, 0x427D, 0x4A9E, 0x4ABD, 0x52DE, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 
        0x52FD, 0x531E, 0x531E, 0x531D, 0x531D, 0x52FD, 0x5B1D, 0x5B1D, 0x5B3D, 0x633D, 0x633E, 0x6B5E, 0x735E, 0x7B7D, 0x7BBD, 0x83DE, 0x83FE, 0x7BDE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x6BBE, 0x6BBE, 0x6BDE, 0x6BDE, 0x73BE, 0x73DE, 0x73DE, 0x73BE, 
        0x6B7E, 0x52BD, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ADD, 0x4ADD, 0x52FE, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x633E, 0x633E, 0x633E, 0x633E, 0x6B3E, 
        0x6B5E, 0x737E, 0x73BE, 0x743C, 0x6CB7, 0x6512, 0x5D11, 0x5D51, 0x6571, 0x6571, 0x6571, 0x6D71, 0x6D71, 0x6D30, 0x4C2C, 0x3328, 0x2AE7, 0x22E7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B27, 0x2B27, 0x2B46, 0x2B66, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x3367, 
        0x3367, 0x3BA9, 0x5C6C, 0x74EF, 0x8D30, 0x9551, 0x9572, 0x9592, 0x8D72, 0x7D51, 0x6CEE, 0x548C, 0x4C2A, 0x3BE9, 0x3BC9, 0x3BC8, 0x3BA8, 0x33C8, 0x33A8, 0x33C8, 0x33C7, 0x33A7, 0x33A7, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2385, 0x2385, 
        0x2385, 0x2385, 0x2365, 0x2345, 0x2345, 0x1B25, 0x1B45, 0x1B45, 0x1B45, 0x1B45, 0x2346, 0x2346, 0x2366, 0x2366, 0x2386, 0x2B86, 0x2BA6, 0x33C6, 0x33C7, 0x33E7, 0x3C07, 0x3C28, 0x4428, 0x4428, 0x4C48, 0x4C48, 0x5469, 0x5469, 0x5469, 0x5469, 
        0x5469, 0x5468, 0x5469, 0x5469, 0x4C69, 0x4C69, 0x4C69, 0x4C49, 0x4448, 0x4428, 0x4428, 0x4408, 0x4408, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BA8, 0x4388, 0x4368, 0x4367, 0x4347, 0x4347, 0x3B47, 0x3B28,
  0x85CE, 0x85CE, 0x8DCF, 0x95D0, 0x8DCF, 0x8DAF, 0x8D90, 0x8D70, 0x8D50, 0x9510, 0x846F, 0x632B, 0x844F, 0x7C6F, 0x63AC, 0x42C8, 0x42C7, 0x42E7, 0x4B48, 0x53EA, 0x544B, 0x5D0D, 0x554D, 0x5D8D, 0x556D, 0x5D8E, 0x6E31, 0x7612, 0x7DF2, 0x8593, 0x84D3, 
        0x63AE, 0x3AA8, 0x4B29, 0x5389, 0x4348, 0x3B06, 0x3B26, 0x3B46, 0x3B66, 0x4386, 0x43A7, 0x43C7, 0x43C7, 0x4BE7, 0x4BE7, 0x43E7, 0x43E7, 0x43C7, 0x43A6, 0x3BA6, 0x3B86, 0x3B86, 0x3365, 0x3345, 0x3325, 0x3345, 0x2B24, 0x2B24, 0x2B24, 0x2304, 
        0x2304, 0x2305, 0x2B25, 0x3B67, 0x4BEA, 0x5C0B, 0x53CB, 0x53AA, 0x5389, 0x5389, 0x5389, 0x5389, 0x5389, 0x5BCA, 0x63EB, 0x6C2C, 0x6C4D, 0x746E, 0x748F, 0x74AF, 0x74D0, 0x6D10, 0x6D30, 0x6D4F, 0x652E, 0x650E, 0x6CED, 0x64ED, 0x6D0D, 0x6D0D, 
        0x650D, 0x64EC, 0x5CAB, 0x546B, 0x4C29, 0x3BC8, 0x3B88, 0x3B68, 0x3B49, 0x3B29, 0x3B2A, 0x438B, 0x4BEB, 0x4C4C, 0x54CD, 0x5CED, 0x64ED, 0x5CAB, 0x4429, 0x3C07, 0x3BE6, 0x3BE6, 0x3BE6, 0x33E6, 0x33E5, 0x33E5, 0x2BE5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BC6, 0x33C6, 0x33C6, 0x3C08, 0x446A, 0x54AB, 0x4CAD, 0x448D, 0x446D, 0x442C, 0x33AA, 0x3388, 0x2B67, 0x2B87, 0x2B87, 0x2B86, 0x2B86, 0x2B66, 0x3366, 0x3327, 0x2B07, 0x2B07, 0x2AE7, 0x32C7, 0x32C7, 
        0x32A8, 0x32C8, 0x3AC8, 0x42C9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x4AE9, 0x4AE9, 0x42E9, 0x4309, 0x4B09, 0x4B09, 0x42EA, 0x42CA, 0x6B73, 0x9C9C, 0x943E, 0x8BFE, 0x83FE, 0x83DE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 
        0x73BE, 0x73BE, 0x73BE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B3E, 0x631D, 0x62FD, 0x5AFD, 0x5ADD, 0x52BD, 0x529E, 0x529E, 0x4A7D, 0x4A7D, 0x4A5D, 0x423D, 0x421D, 0x421D, 0x631E, 0x7BDE, 0x83DE, 0x83FE, 0x7C1E, 
        0x7C1E, 0x7C1E, 0x7C1E, 0x7BFE, 0x7BFE, 0x73FE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x5B7E, 0x5B5E, 0x533E, 0x531E, 0x4B1E, 0x4AFE, 0x4ADD, 0x429D, 0x4ABD, 
        0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABE, 0x4ABD, 0x52DE, 0x5AFE, 0x5AFE, 0x5B1E, 0x633E, 0x633E, 0x635E, 0x637E, 0x637E, 0x639E, 0x639E, 0x6BBE, 0x6BDE, 0x6BDE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x6BBE, 0x5B3D, 0x52FD, 0x52FE, 0x4AFE, 0x4ADD, 
        0x4ABE, 0x42BE, 0x429D, 0x429D, 0x427D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x3A1D, 0x425D, 0x427E, 0x4A9E, 0x4ABD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 
        0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1D, 0x631D, 0x6B3E, 0x6B5E, 0x737E, 0x7B9E, 0x83DE, 0x8BFE, 0x83FE, 0x73BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x6BBE, 0x6BBE, 0x6BBE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 
        0x6BBE, 0x52FE, 0x4ABD, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 0x4ADD, 0x52DD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633D, 
        0x6B3D, 0x6B5E, 0x739E, 0x7C3C, 0x74B9, 0x6513, 0x5D11, 0x5D50, 0x6570, 0x6571, 0x6571, 0x6D51, 0x6D31, 0x6CF0, 0x542D, 0x3B6A, 0x2B08, 0x22C7, 0x22C7, 0x2AE7, 0x2B06, 0x2B07, 0x2B27, 0x2B46, 0x2B46, 0x2B66, 0x2B67, 0x2B66, 0x2B87, 0x3367, 
        0x3367, 0x440A, 0x6CCD, 0x852F, 0x9571, 0x9D92, 0x95B2, 0x8DB2, 0x8591, 0x6D0F, 0x546C, 0x3C09, 0x3BE9, 0x3BE9, 0x3BC9, 0x3BC8, 0x3BA8, 0x33C8, 0x33C8, 0x33C7, 0x33C7, 0x33A7, 0x33A6, 0x2BA6, 0x2B86, 0x2B86, 0x2B85, 0x2365, 0x2365, 0x2385, 
        0x2385, 0x2365, 0x2365, 0x2345, 0x2345, 0x1B45, 0x2345, 0x1B45, 0x1B45, 0x1B25, 0x1B25, 0x2346, 0x2346, 0x2366, 0x2366, 0x2B86, 0x2B86, 0x33A6, 0x33C6, 0x33E7, 0x3C07, 0x3C07, 0x4428, 0x4C28, 0x4C48, 0x5448, 0x5468, 0x5469, 0x5469, 0x5469, 
        0x5469, 0x5469, 0x5469, 0x5468, 0x5449, 0x4C49, 0x4C48, 0x4C48, 0x4428, 0x4428, 0x4428, 0x4408, 0x4408, 0x4BE8, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BA8, 0x4388, 0x4368, 0x4367, 0x4348, 0x4347, 0x3B47, 0x3B28,
  0x85CE, 0x85CE, 0x85CF, 0x8DCF, 0x85CF, 0x85AF, 0x8D8F, 0x8D8F, 0x8D70, 0x9550, 0x94F1, 0x846F, 0x8CB0, 0x8490, 0x7C6F, 0x5B8B, 0x4AE8, 0x42E7, 0x5369, 0x53A9, 0x540A, 0x5CCD, 0x5D2D, 0x556D, 0x5D6E, 0x6E10, 0x7611, 0x7612, 0x7DD2, 0x7D73, 0x84F3, 
        0x7450, 0x7470, 0x9DB4, 0x8D31, 0x5C0B, 0x3B07, 0x3B26, 0x3B26, 0x3B66, 0x3B86, 0x43A7, 0x43A7, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x3BC7, 0x3BA6, 0x3BA6, 0x3B86, 0x3366, 0x3366, 0x3345, 0x2B25, 0x3325, 0x2B24, 0x2B04, 0x2B04, 0x2304, 
        0x2304, 0x2305, 0x3B67, 0x540A, 0x540B, 0x53CA, 0x4B89, 0x4368, 0x4348, 0x4348, 0x4347, 0x4347, 0x4B68, 0x4B88, 0x53A9, 0x5BEA, 0x640B, 0x642C, 0x6C6E, 0x74AF, 0x74F0, 0x7510, 0x7530, 0x6D50, 0x6D4F, 0x6D2E, 0x650E, 0x650D, 0x650D, 0x6D2D, 
        0x6D2D, 0x6D2D, 0x650D, 0x64ED, 0x5CAB, 0x4409, 0x43A8, 0x3B88, 0x3B49, 0x3B29, 0x3B09, 0x3B4A, 0x43CB, 0x4C2C, 0x548D, 0x5CCD, 0x64ED, 0x5CCC, 0x4C49, 0x3C08, 0x3BC7, 0x3BE6, 0x33E6, 0x33E5, 0x33C5, 0x33C5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 
        0x33C5, 0x2BC5, 0x33C6, 0x2BC6, 0x2BC6, 0x2BC6, 0x33C6, 0x33E7, 0x3C28, 0x4CAB, 0x54CC, 0x4CAD, 0x448D, 0x446D, 0x3C0B, 0x33A9, 0x2B88, 0x2B87, 0x3387, 0x3387, 0x3387, 0x3367, 0x3366, 0x3367, 0x3347, 0x2B27, 0x2B07, 0x2AE7, 0x32E7, 0x32C7, 
        0x32C8, 0x32C8, 0x3AC8, 0x3AC9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x42E9, 0x4AE9, 0x4309, 0x4309, 0x4309, 0x42EA, 0x4AAC, 0x8C39, 0x945D, 0x8C1E, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x6BDE, 0x73DE, 
        0x6BBE, 0x73BE, 0x739E, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x631E, 0x62FE, 0x5AFE, 0x5ADE, 0x52BD, 0x529D, 0x4A7D, 0x4A7E, 0x4A5D, 0x4A5D, 0x4A3E, 0x4A3E, 0x4A1D, 0x5ABD, 0x7BBE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7C1E, 
        0x7C1E, 0x7C1E, 0x7C1E, 0x7C1E, 0x7BFE, 0x73FE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x5B7E, 0x5B5E, 0x535E, 0x533E, 0x531D, 0x4AFD, 0x4AFD, 0x42BD, 0x4A9D, 
        0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABE, 0x4ABE, 0x4ADE, 0x52FE, 0x52FE, 0x52FE, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B5E, 0x5B5E, 0x637E, 0x637E, 0x639E, 0x6B9E, 0x6BBE, 0x6BBE, 0x6BDE, 0x73DE, 0x6BDE, 0x6B9E, 0x5B1E, 0x52DD, 0x52FE, 0x4ADE, 0x4ABD, 
        0x42BE, 0x429D, 0x429D, 0x427D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x3A3D, 0x425E, 0x4A7E, 0x4A9E, 0x4ABD, 0x52DD, 0x52DD, 0x52FD, 0x52DE, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 
        0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x5AFE, 0x631E, 0x6B3E, 0x735E, 0x7B9E, 0x8BDE, 0x8BFE, 0x83FE, 0x73BE, 0x637E, 0x637E, 0x5B7D, 0x5B7D, 0x639E, 0x639E, 0x639E, 0x6BBE, 0x6BBE, 0x73BE, 0x73DE, 0x73DE, 0x6BDE, 
        0x6BBE, 0x635E, 0x52BD, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 0x4ADD, 0x52DD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x531E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x631E, 0x633E, 0x633E, 
        0x633E, 0x6B5D, 0x737E, 0x741D, 0x747B, 0x6CF5, 0x5D12, 0x5D51, 0x5D50, 0x6571, 0x6571, 0x6551, 0x6D31, 0x6CD0, 0x5C4E, 0x438B, 0x32E8, 0x2AC7, 0x2AC7, 0x22C6, 0x2AE6, 0x2B06, 0x2B26, 0x2B26, 0x2B26, 0x2B46, 0x2B66, 0x2B67, 0x3367, 0x3367, 
        0x3B68, 0x5C6C, 0x7D0F, 0x8D50, 0x9592, 0x9DD3, 0x9DD3, 0x8DD2, 0x752F, 0x546C, 0x4409, 0x3BE9, 0x3BE8, 0x3BE9, 0x3BC8, 0x3BC8, 0x33A8, 0x33C8, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2365, 0x2365, 0x2365, 
        0x2365, 0x2365, 0x2345, 0x2345, 0x2345, 0x1B45, 0x2345, 0x2345, 0x2345, 0x1B25, 0x2325, 0x2345, 0x2345, 0x2345, 0x2346, 0x2366, 0x2B86, 0x2B86, 0x33A6, 0x33C7, 0x33E7, 0x3C07, 0x4407, 0x4428, 0x4C48, 0x5448, 0x5448, 0x5448, 0x5448, 0x5448, 
        0x5448, 0x5469, 0x5469, 0x5449, 0x5449, 0x4C48, 0x4C48, 0x4C28, 0x4428, 0x4428, 0x4428, 0x4408, 0x4408, 0x43E8, 0x43E8, 0x43C8, 0x43C8, 0x43C8, 0x4BC8, 0x4BC8, 0x43A8, 0x43A8, 0x4388, 0x4368, 0x4367, 0x4347, 0x4347, 0x3B48, 0x3B28,
  0x7DCE, 0x7DCE, 0x7DCE, 0x7DCE, 0x85CE, 0x7DAE, 0x85AE, 0x858F, 0x8D8F, 0x9570, 0x9D51, 0x9D31, 0x9511, 0x8CF1, 0x8CD1, 0x7C6E, 0x63AB, 0x4B28, 0x42E7, 0x4B28, 0x5C2B, 0x64CD, 0x5D0E, 0x5D2E, 0x5D6E, 0x658F, 0x5D4E, 0x6DD1, 0x7DB3, 0x8573, 0x84F3, 
        0x7C92, 0x638D, 0x42A9, 0x4309, 0x3AE8, 0x3AE7, 0x3B07, 0x3B47, 0x3B66, 0x3B87, 0x4387, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BA6, 0x3386, 0x3386, 0x3366, 0x3366, 0x3345, 0x2B25, 0x2B25, 0x2B04, 0x2B04, 0x2304, 0x22E4, 
        0x22E5, 0x3326, 0x4BC9, 0x542B, 0x53CA, 0x4B89, 0x4348, 0x3B27, 0x3B26, 0x3B26, 0x3B46, 0x4347, 0x4367, 0x4367, 0x4B88, 0x53A9, 0x5BEA, 0x5C0B, 0x642B, 0x6C8D, 0x74CE, 0x7D0F, 0x7D30, 0x7550, 0x6D4F, 0x6D4F, 0x6D2E, 0x650E, 0x650D, 0x652D, 
        0x6D2E, 0x6D2E, 0x6D2E, 0x6D2E, 0x650D, 0x5CAC, 0x542A, 0x4BEA, 0x4389, 0x434A, 0x3B09, 0x432A, 0x436B, 0x4BEB, 0x544C, 0x5CAD, 0x5CCD, 0x5CCC, 0x4C8B, 0x4408, 0x3BC7, 0x33C6, 0x33E6, 0x33C5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33A5, 
        0x33C5, 0x33A5, 0x33C6, 0x33E6, 0x33E6, 0x33E6, 0x33E7, 0x3C07, 0x4449, 0x54EC, 0x54CC, 0x4CAD, 0x448D, 0x444C, 0x3C0A, 0x33A8, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x3387, 0x3387, 0x3367, 0x3367, 0x3347, 0x2B47, 0x2B27, 0x2B07, 0x32E7, 0x32E7, 
        0x32E8, 0x3AE8, 0x3AE8, 0x3AE8, 0x42E9, 0x42E9, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x42E9, 0x42E9, 0x4ACA, 0x5AF0, 0x9C7C, 0x941E, 0x8BFE, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 
        0x6BBE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x635E, 0x633E, 0x631D, 0x5AFD, 0x5AFE, 0x5ABE, 0x52BE, 0x529D, 0x4A7D, 0x4A5D, 0x425D, 0x4A5D, 0x4A3D, 0x4A3E, 0x4A1E, 0x5A5D, 0x7B9E, 0x83DE, 0x83FE, 0x83FE, 0x841E, 0x7C1E, 
        0x7C1E, 0x7C3E, 0x7C3E, 0x7C1E, 0x7BFE, 0x73FE, 0x6BDE, 0x6BDE, 0x6BBE, 0x63BE, 0x63BE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x5B7E, 0x5B7E, 0x5B5E, 0x535D, 0x533E, 0x533D, 0x531D, 0x4B1D, 0x4ADD, 0x429D, 
        0x4A9D, 0x4ABE, 0x4A9E, 0x4A9D, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ADE, 0x4AFE, 0x52FE, 0x52FE, 0x5B1E, 0x5B3E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B7E, 0x637E, 0x639E, 0x639E, 0x6B9E, 0x6BBE, 0x6BBE, 0x6B9E, 0x637E, 0x52FE, 0x4ABD, 0x52DE, 0x4ADE, 0x4ABE, 
        0x429D, 0x429D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A1D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x39FD, 0x423E, 0x425E, 0x4A7E, 0x4A9E, 0x4A9E, 0x4ABE, 0x4ABD, 0x52DD, 0x4ABE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4AFD, 
        0x4AFD, 0x4AFD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52DD, 0x5AFE, 0x631E, 0x6B5E, 0x7B7E, 0x8BBE, 0x93FE, 0x8C1E, 0x7B9E, 0x6B7E, 0x637E, 0x5B7E, 0x537D, 0x5B7D, 0x5B7E, 0x639E, 0x639E, 0x639E, 0x6BBE, 0x6BBE, 0x6BDE, 0x6BDE, 0x6BDE, 
        0x6BDE, 0x6B9E, 0x5B1E, 0x4ABD, 0x4A9D, 0x429D, 0x4ABD, 0x4ABD, 0x52DD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x531E, 0x531D, 0x531D, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x631E, 0x633E, 0x633E, 
        0x633E, 0x635E, 0x6B7E, 0x73DE, 0x745C, 0x6CD7, 0x6512, 0x5D51, 0x5D71, 0x5D71, 0x5D71, 0x6D51, 0x7552, 0x64AF, 0x4BAB, 0x2AC8, 0x2A87, 0x2AA7, 0x2AA7, 0x2AC6, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x2B26, 0x2B26, 0x2B46, 0x2B47, 0x3347, 0x3B47, 
        0x540A, 0x74EF, 0x8530, 0x9591, 0x9DD3, 0xA613, 0x9DF3, 0x8570, 0x5C8C, 0x43E9, 0x3BE9, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BC8, 0x33A7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x33A7, 0x2B86, 0x2B86, 0x2B66, 0x2366, 0x2366, 0x2365, 0x2345, 0x2345, 
        0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x1B45, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x2345, 0x2345, 0x2366, 0x2B66, 0x2B86, 0x33A6, 0x33C6, 0x3BE7, 0x3C07, 0x4408, 0x4C28, 0x4C28, 0x5448, 0x5448, 0x5448, 0x5448, 
        0x5448, 0x5448, 0x5448, 0x5448, 0x4C48, 0x4C48, 0x4C48, 0x4428, 0x4428, 0x4428, 0x3C08, 0x4408, 0x3BE8, 0x43E8, 0x43E8, 0x43C8, 0x43C7, 0x43C7, 0x43C8, 0x43A7, 0x43A8, 0x4388, 0x4388, 0x4367, 0x3B67, 0x4347, 0x3B47, 0x3B28, 0x3B28,
  0x7DAE, 0x7DCE, 0x7DCE, 0x7DCE, 0x7DCE, 0x7DAE, 0x7DAE, 0x7DAE, 0x8DAF, 0x95B0, 0x9D91, 0x9D91, 0x9D71, 0x9531, 0x8D10, 0x8CD0, 0x744E, 0x5329, 0x4AE7, 0x744D, 0x9592, 0x750F, 0x5CCD, 0x5D0D, 0x5D4E, 0x658F, 0x65B0, 0x6570, 0x6D71, 0x7D73, 0x7CF3, 
        0x7471, 0x7C51, 0x530B, 0x42E9, 0x3AC7, 0x3AE7, 0x3B07, 0x3B26, 0x3B46, 0x3B67, 0x3B87, 0x4387, 0x3B87, 0x3BA7, 0x3B87, 0x3BA7, 0x3BA7, 0x3BA6, 0x3BA6, 0x33A6, 0x3386, 0x3366, 0x3366, 0x3346, 0x2B45, 0x2B25, 0x2B05, 0x2305, 0x22E5, 0x22E5, 
        0x2B05, 0x4388, 0x4BEA, 0x4BCA, 0x4368, 0x3B27, 0x3306, 0x3326, 0x3326, 0x3345, 0x3B66, 0x3B66, 0x3B66, 0x4387, 0x4387, 0x4B87, 0x4BA8, 0x53C8, 0x5C0A, 0x642B, 0x6C8D, 0x74CE, 0x7D0F, 0x7D2F, 0x754F, 0x754F, 0x6D2F, 0x6D2E, 0x650E, 0x652E, 
        0x652E, 0x6D2E, 0x6D2E, 0x6D2E, 0x6D2E, 0x6D0D, 0x64CD, 0x64AD, 0x5C2C, 0x4B8B, 0x430A, 0x3B0A, 0x434A, 0x43AB, 0x4C0C, 0x548D, 0x5CAD, 0x5CCC, 0x54AB, 0x4429, 0x33C7, 0x33E6, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 
        0x33C5, 0x33C6, 0x33C6, 0x33E6, 0x33E6, 0x33E7, 0x3BE7, 0x3C08, 0x4C8B, 0x54EC, 0x54CD, 0x4CAD, 0x448D, 0x444C, 0x3BE9, 0x33C8, 0x3BA7, 0x33A7, 0x3BA7, 0x3BA7, 0x33A7, 0x33A7, 0x3387, 0x3387, 0x3367, 0x3347, 0x2B27, 0x2B07, 0x3307, 0x32E7, 
        0x32E8, 0x3AE8, 0x3AE8, 0x3AE8, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x42E9, 0x42E9, 0x4ACB, 0x6B33, 0x945D, 0x93FE, 0x8BFE, 0x83FE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x635E, 0x633E, 0x5B3D, 0x5AFE, 0x5AFE, 0x5ADD, 0x52BE, 0x529E, 0x4A7D, 0x4A5D, 0x4A5D, 0x423D, 0x423D, 0x421D, 0x49FD, 0x521D, 0x7B7E, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x7C1E, 
        0x7C1E, 0x7C3E, 0x7C3E, 0x7C1E, 0x7BFE, 0x73FE, 0x6BDE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x5B5E, 0x5B5E, 0x5B3E, 0x533E, 0x533D, 0x533D, 0x531D, 0x531D, 0x4ADD, 0x42BD, 
        0x429D, 0x429D, 0x429E, 0x429D, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABE, 0x4ADD, 0x4AFE, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x533D, 0x533D, 0x5B5E, 0x5B5E, 0x637D, 0x637E, 0x637E, 0x639E, 0x639E, 0x637E, 0x5B5E, 0x52DD, 0x4A9D, 0x4ABD, 0x4ADE, 0x4ABE, 
        0x427D, 0x427D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31DD, 0x31DD, 0x31FD, 0x3A1D, 0x423E, 0x425E, 0x425D, 0x4A7E, 0x4A9E, 0x4A9E, 0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ADD, 0x4ADD, 
        0x4ADD, 0x4ADD, 0x4ADD, 0x4AFD, 0x4AFD, 0x52DE, 0x52DE, 0x52DD, 0x62FE, 0x6B3E, 0x735E, 0x839E, 0x8BBE, 0x93FE, 0x8BDE, 0x6B7D, 0x635D, 0x5B5E, 0x535E, 0x535E, 0x535E, 0x537D, 0x5B7E, 0x639E, 0x639E, 0x639E, 0x6BBE, 0x6BBE, 0x6BDE, 0x6BDE, 
        0x6BDE, 0x6B9E, 0x637E, 0x52FE, 0x4ABD, 0x429D, 0x42BD, 0x4ABD, 0x4ADE, 0x4AFE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x5B1D, 0x5B1D, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B3E, 
        0x633E, 0x635E, 0x6B7E, 0x73DE, 0x743D, 0x6CB8, 0x6513, 0x5D51, 0x5D71, 0x5D71, 0x6571, 0x6D72, 0x7572, 0x64AF, 0x3B4A, 0x2266, 0x2266, 0x2266, 0x2A87, 0x22A6, 0x22A6, 0x22C6, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x2B26, 0x2B26, 0x3327, 0x4BEA, 
        0x74EE, 0x8510, 0x9571, 0x9DB2, 0xA5F3, 0xA613, 0x95B2, 0x6CCD, 0x4C0A, 0x3BC9, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BC8, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x3387, 0x2B87, 0x2B87, 0x2B66, 0x2B66, 0x2346, 0x2346, 0x2346, 0x2345, 0x2345, 0x1B45, 
        0x1B45, 0x1B45, 0x2345, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x2345, 0x2345, 0x2345, 0x2B66, 0x2B86, 0x33A6, 0x33C6, 0x3BE7, 0x4407, 0x4408, 0x4C28, 0x4C28, 0x5448, 0x5448, 0x5448, 
        0x5448, 0x5448, 0x5448, 0x5428, 0x4C48, 0x4C28, 0x4428, 0x4428, 0x4428, 0x4408, 0x3C08, 0x4408, 0x3BE8, 0x43E8, 0x43E8, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x43A7, 0x4387, 0x4388, 0x3B68, 0x3B67, 0x3B67, 0x4368, 0x3B47, 0x3B48, 0x3B28,
  0x75AE, 0x75AE, 0x75AD, 0x75CE, 0x75CE, 0x75AE, 0x75AE, 0x7DAE, 0x85AE, 0x8DAF, 0x95B0, 0x9DB1, 0x9D91, 0x9570, 0x9530, 0x8D10, 0x84D0, 0x63CC, 0x5B6A, 0x6BEC, 0x7CAF, 0x74AE, 0x5C8D, 0x54CC, 0x5D2E, 0x658F, 0x65B0, 0x6DD1, 0x6D91, 0x7532, 0x8554, 
        0x8534, 0x7C92, 0x4B0B, 0x42A9, 0x3A87, 0x3AC7, 0x3B07, 0x3B27, 0x3B47, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3386, 0x3386, 0x3386, 0x3366, 0x3366, 0x2B45, 0x2B25, 0x2B25, 0x2305, 0x2B05, 0x2B05, 
        0x3347, 0x4BC9, 0x4389, 0x3B48, 0x3307, 0x2B06, 0x2AE6, 0x3305, 0x3325, 0x3345, 0x3B66, 0x3B66, 0x3B86, 0x4386, 0x43A7, 0x43A7, 0x4BA7, 0x4BC7, 0x53E8, 0x5C0A, 0x6C4B, 0x74AD, 0x7CEF, 0x7D0F, 0x7D2F, 0x7D2F, 0x752F, 0x6D2F, 0x6D0E, 0x6D0E, 
        0x650E, 0x6D2E, 0x6D2E, 0x6D2E, 0x6D2E, 0x6D2E, 0x6D0E, 0x6CEE, 0x6CAE, 0x5BED, 0x4B2A, 0x430A, 0x432A, 0x436B, 0x4BEC, 0x544C, 0x5C8D, 0x5CAD, 0x54AC, 0x4C6A, 0x3BE8, 0x33E7, 0x33C6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 0x33C5, 0x33A5, 
        0x33C6, 0x33C6, 0x3BE6, 0x3BE6, 0x3BE6, 0x3BE7, 0x3BE7, 0x4429, 0x54AC, 0x54ED, 0x4CCD, 0x4CAD, 0x448D, 0x444B, 0x3BE9, 0x3BC8, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3B87, 0x3387, 0x3367, 0x3367, 0x3347, 0x3327, 0x3307, 0x3307, 
        0x3307, 0x3308, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x4309, 0x42EA, 0x4AEA, 0x4AAC, 0x7355, 0x941D, 0x8BFD, 0x8BFE, 0x83FE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x633D, 0x633E, 0x5B1D, 0x5AFD, 0x5ADD, 0x52BD, 0x529E, 0x527E, 0x4A7D, 0x4A5D, 0x4A3D, 0x423D, 0x421D, 0x41FD, 0x49FD, 0x62BE, 0x83DE, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 
        0x7C3E, 0x7C3E, 0x7C3E, 0x7C1E, 0x73FE, 0x73FE, 0x6BDE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x5B7E, 0x5B5E, 0x5B5D, 0x5B5E, 0x533E, 0x533D, 0x533D, 0x533D, 0x531D, 0x52FD, 0x4ADD, 0x42BD, 
        0x429D, 0x429D, 0x429D, 0x429D, 0x42BE, 0x42BE, 0x42BE, 0x4A9D, 0x4ABD, 0x4ADD, 0x4ADD, 0x4AFE, 0x4AFE, 0x52FE, 0x52FD, 0x531D, 0x531D, 0x533E, 0x5B3E, 0x5B5E, 0x5B5E, 0x5B7E, 0x637E, 0x5B5E, 0x533E, 0x4ABD, 0x427D, 0x427D, 0x4ABE, 0x4A9D, 
        0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x321D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x29DD, 0x29DD, 0x31DD, 0x31FD, 0x3A1D, 0x423D, 0x425D, 0x425D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 
        0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x52DD, 0x52DD, 0x631E, 0x735E, 0x7B7E, 0x839E, 0x8BDE, 0x93FE, 0x83BE, 0x635D, 0x5B5D, 0x533E, 0x535E, 0x4B5E, 0x4B5E, 0x535E, 0x537E, 0x5B9E, 0x5B9E, 0x639E, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 
        0x6BDE, 0x6BBE, 0x6B9E, 0x635E, 0x4ADD, 0x429D, 0x42BD, 0x4ABD, 0x4ADD, 0x4ADD, 0x4AFD, 0x4AFD, 0x4AFD, 0x52FD, 0x4AFD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x5AFD, 0x5B1D, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 
        0x5B3E, 0x635E, 0x6B9E, 0x6BBE, 0x741D, 0x749A, 0x64F4, 0x6551, 0x5D71, 0x5D71, 0x6572, 0x6D92, 0x7572, 0x5C8E, 0x3309, 0x2246, 0x2246, 0x2246, 0x2A67, 0x2286, 0x2286, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x2AE6, 0x2B06, 0x2B07, 0x4B89, 0x74EF, 
        0x8D71, 0x8D51, 0x9D92, 0xA5D3, 0xAE13, 0x9DD2, 0x7D0E, 0x540A, 0x43C9, 0x3BC8, 0x3BC8, 0x33C8, 0x33C8, 0x33C8, 0x33C8, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x2B87, 0x2B87, 0x2B67, 0x2B46, 0x2346, 0x2326, 0x2326, 0x2325, 0x1B25, 0x1B25, 0x1B25, 
        0x1B25, 0x1B24, 0x1B25, 0x1B25, 0x1B25, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x1B25, 0x1B25, 0x1B25, 0x2345, 0x2345, 0x2345, 0x2365, 0x2B86, 0x2B86, 0x33A6, 0x33C7, 0x3BE7, 0x43E7, 0x4C07, 0x4C28, 0x5428, 0x5428, 0x5428, 
        0x5428, 0x5428, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4428, 0x4408, 0x4408, 0x3C08, 0x3BE8, 0x3BE8, 0x43E8, 0x3BE8, 0x43C7, 0x43C7, 0x43C7, 0x3BA7, 0x3BA7, 0x3B87, 0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B48, 0x3B48, 0x3B28,
  0x6D8E, 0x6D8E, 0x6D8E, 0x75AE, 0x75AE, 0x75AE, 0x75AE, 0x75AE, 0x85AE, 0x8DCF, 0x95B0, 0x95B0, 0x9DB0, 0x9590, 0x9570, 0x9551, 0x8D11, 0x7C6E, 0x534A, 0x6C0C, 0x8CF0, 0x7CCF, 0x6C8E, 0x5CCD, 0x5D2E, 0x5D6F, 0x65AF, 0x6DD1, 0x75D2, 0x7DB3, 0x8574, 
        0x8554, 0x8CF4, 0x5B6D, 0x4B4B, 0x534A, 0x4308, 0x3B07, 0x3B27, 0x3B27, 0x3B47, 0x3B67, 0x4367, 0x3B67, 0x3B67, 0x3B66, 0x3B67, 0x3B67, 0x3B66, 0x3386, 0x3386, 0x3386, 0x3366, 0x3366, 0x3366, 0x2B45, 0x2B26, 0x2B26, 0x2B25, 0x2B26, 0x3327, 
        0x3B68, 0x3B48, 0x3327, 0x2B06, 0x22C6, 0x22E5, 0x2AE5, 0x2B25, 0x3325, 0x3345, 0x3B66, 0x3B86, 0x3B86, 0x3BA6, 0x43A6, 0x43C6, 0x43C7, 0x4BC7, 0x4BC8, 0x53E9, 0x642A, 0x748C, 0x7CCE, 0x7CEE, 0x7D0F, 0x7D0F, 0x750F, 0x750F, 0x6D0F, 0x6D0F, 
        0x6D0F, 0x650E, 0x6D0E, 0x6D0E, 0x6D0E, 0x6D2E, 0x6D0E, 0x74EF, 0x74CF, 0x6C6F, 0x5BCD, 0x4B2B, 0x432A, 0x436B, 0x4BCB, 0x4C2C, 0x546D, 0x5CAD, 0x54AC, 0x548B, 0x4409, 0x33E7, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 0x33A5, 
        0x33C6, 0x3BE6, 0x3BE6, 0x3BE6, 0x3BE6, 0x3C07, 0x4408, 0x4C6A, 0x5CCC, 0x54ED, 0x4CCD, 0x44AD, 0x448C, 0x444A, 0x3C09, 0x43E8, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3BA7, 0x3387, 0x3367, 0x3347, 0x3347, 0x3327, 0x3328, 
        0x3B28, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x4308, 0x4309, 0x4309, 0x4309, 0x42E9, 0x4309, 0x4309, 0x42E9, 0x42EA, 0x42EA, 0x4A8C, 0x7336, 0x941D, 0x93FE, 0x8BFE, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x631E, 0x5AFD, 0x5ADE, 0x52BD, 0x529E, 0x529E, 0x4A7D, 0x4A5D, 0x4A3D, 0x423D, 0x421D, 0x41FD, 0x41FD, 0x4A3D, 0x737E, 0x83FE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 
        0x843E, 0x7C3E, 0x7C1E, 0x7C1E, 0x73FE, 0x73FE, 0x6BDE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x635E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x531E, 0x531E, 0x4B1D, 0x4B1D, 0x531D, 0x4AFD, 0x4ADD, 0x42BD, 
        0x429D, 0x3A7D, 0x3A7D, 0x427D, 0x427E, 0x429D, 0x429D, 0x429D, 0x429D, 0x42BD, 0x4ABE, 0x4ABD, 0x4ADD, 0x4ADD, 0x4ADE, 0x4AFE, 0x52FE, 0x531E, 0x531E, 0x533E, 0x5B3E, 0x5B5E, 0x5B5E, 0x533E, 0x531E, 0x4ABD, 0x427D, 0x425D, 0x4A9D, 0x429D, 
        0x425D, 0x3A3D, 0x3A3D, 0x3A5D, 0x427D, 0x425D, 0x3A3D, 0x3A3D, 0x3A1D, 0x31FD, 0x31FD, 0x31DD, 0x29BD, 0x29BD, 0x31DD, 0x31FD, 0x3A1D, 0x3A1D, 0x423D, 0x423D, 0x425D, 0x427D, 0x427D, 0x429D, 0x429D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 
        0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ADD, 0x4ADD, 0x52DD, 0x5AFE, 0x6B3E, 0x735E, 0x839E, 0x8BBE, 0x8BDE, 0x8BDE, 0x737D, 0x5B3D, 0x535D, 0x533E, 0x4B3E, 0x4B3E, 0x4B3E, 0x535E, 0x535E, 0x5B7E, 0x5B9E, 0x639E, 0x63BE, 0x6BBE, 0x6BBE, 0x6BBE, 
        0x6BDE, 0x6BBE, 0x6BBE, 0x6B9E, 0x5B1D, 0x4ABD, 0x429D, 0x42BD, 0x42BD, 0x4ADD, 0x4ADD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x531E, 0x5B3E, 0x5B3E, 0x5B3E, 
        0x5B3E, 0x5B5E, 0x639E, 0x6BBE, 0x741E, 0x749A, 0x64F5, 0x6552, 0x6571, 0x6571, 0x6572, 0x6D72, 0x7571, 0x5C6E, 0x32C8, 0x2226, 0x2226, 0x2246, 0x2246, 0x2266, 0x2266, 0x2286, 0x2AA6, 0x2AA6, 0x22C6, 0x2AC6, 0x2AE7, 0x3B28, 0x644D, 0x8530, 
        0x9571, 0x9D72, 0xA5B2, 0xA5D3, 0xA5D3, 0x852F, 0x5C4B, 0x43A8, 0x3BA8, 0x3BA8, 0x3BA8, 0x33C7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3387, 0x2B87, 0x2B67, 0x2B67, 0x2B47, 0x2346, 0x2326, 0x2306, 0x1B06, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 
        0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1AE5, 0x1AE5, 0x1AE5, 0x1AE5, 0x1B05, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x2345, 0x2345, 0x2345, 0x2B66, 0x2B86, 0x2B86, 0x33A6, 0x3BC7, 0x3BE7, 0x4407, 0x4C07, 0x4C28, 0x4C28, 0x4C28, 
        0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4428, 0x4408, 0x4408, 0x3C08, 0x3C08, 0x3BE8, 0x3BE7, 0x3BE8, 0x3BE7, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3BA7, 0x3B88, 0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x3B48, 0x3B48, 0x3B48,
  0x758F, 0x6D6E, 0x6D8E, 0x6D8E, 0x6DAE, 0x6DAE, 0x75AE, 0x75AE, 0x85AE, 0x8DCF, 0x95CF, 0x95CF, 0x95D0, 0x95B0, 0x9590, 0x9570, 0x9551, 0x8CF0, 0x6BEC, 0x7C8F, 0x8D31, 0x8D31, 0x74CF, 0x5C8C, 0x5D2E, 0x5D6E, 0x658F, 0x65B0, 0x75D2, 0x7DB3, 0x8573, 
        0x8D54, 0x8D14, 0x7C92, 0x5B8C, 0x4B4A, 0x4308, 0x3B07, 0x3B07, 0x3B27, 0x3B47, 0x3B47, 0x4367, 0x4367, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B66, 0x3366, 0x3366, 0x3367, 0x3367, 0x3366, 0x2B66, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x3B47, 
        0x3327, 0x3307, 0x2AE6, 0x22E5, 0x22E5, 0x22E5, 0x2305, 0x2B25, 0x2B45, 0x3345, 0x3B65, 0x3B86, 0x3BA6, 0x43A6, 0x43C6, 0x43E6, 0x43E7, 0x4BC7, 0x4BC8, 0x53E8, 0x5C09, 0x6C6B, 0x748C, 0x74CD, 0x7CCE, 0x7CCF, 0x7CCF, 0x7CEF, 0x74EF, 0x74EF, 
        0x6CEF, 0x6CEF, 0x64EE, 0x64CE, 0x64CE, 0x64EE, 0x64EE, 0x6CEF, 0x74EF, 0x74AF, 0x644E, 0x538C, 0x432B, 0x434B, 0x43AB, 0x4C0C, 0x544C, 0x5C8D, 0x5C8C, 0x548B, 0x4429, 0x33E7, 0x2BC6, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 0x33C5, 
        0x33C6, 0x3BE6, 0x3BE6, 0x3BE6, 0x3BE7, 0x4407, 0x4C28, 0x54AC, 0x5CCD, 0x54ED, 0x4CCD, 0x4CAD, 0x4C8C, 0x444A, 0x4409, 0x43E8, 0x43E8, 0x43E8, 0x43E7, 0x43E7, 0x43C7, 0x43C7, 0x43A7, 0x3BA7, 0x3B87, 0x3367, 0x3367, 0x3367, 0x3347, 0x3B27, 
        0x3B28, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x4308, 0x4308, 0x4309, 0x42E9, 0x42E9, 0x4308, 0x42E9, 0x42E9, 0x42EA, 0x42CA, 0x428C, 0x7356, 0x941E, 0x941E, 0x8BFE, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 0x637E, 0x635E, 0x633E, 0x5B1E, 0x5AFE, 0x5ADE, 0x52BE, 0x529E, 0x529E, 0x4A7D, 0x4A5D, 0x423D, 0x423D, 0x421D, 0x41FD, 0x41FC, 0x62DD, 0x7BDE, 0x83FE, 0x83FE, 0x7C1E, 0x841E, 0x843E, 0x843E, 0x843E, 
        0x7C3E, 0x7C3E, 0x7C1E, 0x7C1E, 0x73FE, 0x6BFE, 0x6BDE, 0x63BE, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x533E, 0x531E, 0x531E, 0x531E, 0x4B1E, 0x4AFD, 0x4AFD, 0x42DD, 0x42BD, 
        0x3A9D, 0x3A7D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A7D, 0x429D, 0x429D, 0x429D, 0x429D, 0x429E, 0x429D, 0x42BD, 0x4ABD, 0x4ABE, 0x4ABE, 0x4ADE, 0x4AFD, 0x4AFE, 0x52FE, 0x531E, 0x531E, 0x533E, 0x531D, 0x4AFE, 0x42BD, 0x3A5D, 0x3A1D, 0x425D, 0x4A9E, 
        0x425D, 0x3A1D, 0x427D, 0x5B1E, 0x635E, 0x5B3E, 0x5B1E, 0x52DE, 0x4A9D, 0x3A3D, 0x31FD, 0x29BD, 0x299D, 0x299D, 0x29BD, 0x31DD, 0x39FD, 0x3A1D, 0x3A3D, 0x3A3D, 0x425D, 0x425D, 0x427D, 0x427D, 0x427D, 0x429D, 0x429D, 0x429D, 0x429D, 0x42BD, 
        0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x52DD, 0x5ADD, 0x631E, 0x6B3E, 0x7B5E, 0x839E, 0x8BBE, 0x8BDE, 0x83DE, 0x635D, 0x533E, 0x4B3D, 0x4B3E, 0x4B3E, 0x4B3E, 0x4B3E, 0x4B5E, 0x535E, 0x537E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x6BDE, 
        0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x637E, 0x4ADD, 0x429D, 0x42BD, 0x42BD, 0x42DD, 0x42DD, 0x4ADD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x52FE, 0x52FE, 0x531E, 0x531E, 0x531E, 0x533E, 0x533E, 0x5B3E, 
        0x5B3E, 0x5B5E, 0x639E, 0x6BDE, 0x6C1E, 0x6C7B, 0x64F5, 0x6552, 0x6572, 0x6572, 0x6572, 0x6D72, 0x7571, 0x544D, 0x2AC8, 0x1A26, 0x2226, 0x2226, 0x2226, 0x2226, 0x2246, 0x2266, 0x2286, 0x22A6, 0x22A6, 0x2AA7, 0x3B28, 0x642D, 0x8510, 0x9531, 
        0xA572, 0xADB3, 0xADB3, 0xA5B2, 0x8D51, 0x6C6D, 0x4BC9, 0x3B88, 0x33A7, 0x33A7, 0x33C7, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x3387, 0x3387, 0x3387, 0x2B67, 0x2B67, 0x2B46, 0x2326, 0x2326, 0x2306, 0x1B05, 0x1B05, 0x1AE5, 0x1AE5, 0x1AE5, 0x12E4, 
        0x12E4, 0x12E4, 0x12E4, 0x12E4, 0x12E4, 0x12E4, 0x12E4, 0x1AC4, 0x1AC4, 0x1AC5, 0x1AC5, 0x1AE4, 0x1AE5, 0x1B05, 0x1B05, 0x1B05, 0x2325, 0x2325, 0x2345, 0x2B45, 0x2B66, 0x2B66, 0x2B86, 0x33A6, 0x3BC7, 0x43E7, 0x4407, 0x4C28, 0x4C28, 0x4C28, 
        0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4427, 0x4428, 0x3C08, 0x3C08, 0x3C08, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 0x3B48, 0x3B48, 0x3B48, 0x3B49,
  0x75AF, 0x6D6E, 0x6D8E, 0x6D8E, 0x6DAE, 0x6DAE, 0x6DAE, 0x75AE, 0x85CE, 0x8DEF, 0x8DCF, 0x95CF, 0x95D0, 0x95D0, 0x95B0, 0x9590, 0x9571, 0x9531, 0x84CF, 0x9531, 0x9551, 0x8D51, 0x74CF, 0x5C8D, 0x5D0D, 0x5D2E, 0x5D4E, 0x658F, 0x6DB1, 0x7592, 0x7D52, 
        0x8534, 0x8514, 0x7C92, 0x42CA, 0x3AA8, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3B27, 0x3B27, 0x3B47, 0x3B46, 0x3B46, 0x3B46, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3347, 0x3347, 0x3347, 0x3346, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x3306, 
        0x2AE6, 0x2AE6, 0x2AE6, 0x22E5, 0x22E5, 0x22E5, 0x2305, 0x2B05, 0x2B25, 0x3345, 0x3B65, 0x3B86, 0x3BA6, 0x43A6, 0x43C6, 0x43E6, 0x4BE7, 0x4BE7, 0x4BE8, 0x53C8, 0x53E8, 0x5C09, 0x642B, 0x746C, 0x7CAD, 0x7CAE, 0x7CAE, 0x7CAF, 0x7CAF, 0x74CF, 
        0x74CF, 0x6CCF, 0x6CAF, 0x64AF, 0x64AE, 0x64AE, 0x64CE, 0x6CEE, 0x74EF, 0x74CF, 0x6C8F, 0x5BCD, 0x432B, 0x3B4A, 0x438B, 0x43EB, 0x4C0C, 0x544C, 0x548C, 0x548B, 0x4429, 0x33C7, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 0x33C6, 
        0x3BE6, 0x3BE6, 0x3C06, 0x3C06, 0x3C07, 0x4408, 0x4C49, 0x5CCC, 0x5CCD, 0x4CCD, 0x4CAD, 0x4CAD, 0x4C8B, 0x4C4A, 0x4C09, 0x4C08, 0x4C08, 0x4C08, 0x4C07, 0x4BE7, 0x4BE7, 0x43C7, 0x43A7, 0x3BA7, 0x3B87, 0x3B67, 0x3367, 0x3367, 0x3347, 0x3347, 
        0x3B27, 0x3B28, 0x3B28, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x42E9, 0x42E8, 0x42E9, 0x42E9, 0x42E9, 0x42CA, 0x426C, 0x7B77, 0x941E, 0x93FE, 0x8BFE, 0x8BFE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x635E, 0x5B3E, 0x5B1E, 0x52FE, 0x52BD, 0x529D, 0x4A9D, 0x4A7D, 0x4A5D, 0x4A5D, 0x423E, 0x421E, 0x421D, 0x41FD, 0x4A3C, 0x737E, 0x83DE, 0x83FE, 0x841E, 0x7C1E, 0x843E, 0x843E, 0x843E, 0x7C3E, 
        0x7C1E, 0x7C3E, 0x7C1E, 0x7BFE, 0x73FE, 0x6BDE, 0x6BDE, 0x63BE, 0x639E, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x637E, 0x637E, 0x635E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x531D, 0x531E, 0x52FE, 0x4AFE, 0x4AFE, 0x4ADD, 0x42DD, 0x42DD, 0x42BE, 
        0x3A9D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x427D, 0x427D, 0x427D, 0x427D, 0x429D, 0x429D, 0x429D, 0x429D, 0x42BD, 0x42BE, 0x4ADD, 0x4ADE, 0x4ADD, 0x4AFD, 0x52FE, 0x52FD, 0x4AFD, 0x42BD, 0x429D, 0x3A5D, 0x3A1D, 0x3A3D, 0x52BE, 
        0x4ABE, 0x423C, 0x52BD, 0x633E, 0x633E, 0x5B1E, 0x5B1D, 0x531E, 0x52DE, 0x4ABE, 0x427E, 0x3A3D, 0x31BD, 0x297D, 0x299D, 0x31DD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x427D, 0x427D, 0x427D, 0x429D, 0x429E, 
        0x429D, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x52DD, 0x62FE, 0x6B1E, 0x733E, 0x7B7E, 0x839E, 0x8BBE, 0x8BDE, 0x7B9E, 0x5B3D, 0x531E, 0x4B1E, 0x4B1E, 0x4B3E, 0x433E, 0x4B3E, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x6BBE, 
        0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x639E, 0x531D, 0x429D, 0x429D, 0x42BD, 0x42DD, 0x42DD, 0x42FD, 0x4AFD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4B1E, 0x531D, 0x531D, 0x531E, 0x531E, 0x531E, 0x533E, 0x533E, 
        0x533E, 0x5B5E, 0x5B9E, 0x63DE, 0x6C1E, 0x6C7B, 0x64F6, 0x6552, 0x6572, 0x6572, 0x6572, 0x7592, 0x7551, 0x5C4D, 0x32E9, 0x2226, 0x21E6, 0x2206, 0x2226, 0x2226, 0x2226, 0x2246, 0x2266, 0x2286, 0x2266, 0x32E8, 0x644D, 0x8531, 0x9552, 0xA552, 
        0xAD93, 0xADB3, 0xA593, 0x9571, 0x748E, 0x53EA, 0x3B88, 0x3387, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x33A7, 0x3387, 0x2B67, 0x2B67, 0x2B67, 0x2B46, 0x2B26, 0x2326, 0x2326, 0x2306, 0x1AE5, 0x1AE5, 0x12C5, 0x1AC5, 0x12C4, 0x12C4, 
        0x12C4, 0x12C4, 0x12C4, 0x12C4, 0x12C4, 0x12C4, 0x12C4, 0x12A4, 0x12C4, 0x1AC4, 0x1AC4, 0x1AC4, 0x1AC5, 0x1AE5, 0x1B05, 0x1B05, 0x2325, 0x2325, 0x2325, 0x2346, 0x2B45, 0x2B45, 0x2B66, 0x3386, 0x33C7, 0x3BE7, 0x4407, 0x4C07, 0x4C28, 0x4C28, 
        0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4427, 0x4428, 0x3C08, 0x3C08, 0x3C07, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B49,
  0x758F, 0x6D6E, 0x6D6E, 0x6D8E, 0x6DAE, 0x6DAE, 0x6DAD, 0x6DAD, 0x7DAE, 0x85CE, 0x8DCF, 0x95CF, 0x95CF, 0x95AF, 0x95B0, 0x95B0, 0x9591, 0x9571, 0x9571, 0x9591, 0x9DB2, 0x95B2, 0x7D0F, 0x5C8D, 0x5CCD, 0x54ED, 0x550E, 0x656F, 0x6D70, 0x7592, 0x6CF1, 
        0x7D13, 0x84D4, 0x84B3, 0x536D, 0x3AA8, 0x3AC7, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3B27, 0x3B26, 0x3B26, 0x3B26, 0x3B26, 0x3B26, 0x3B26, 0x3B26, 0x3326, 0x3327, 0x3347, 0x3346, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2AE6, 0x2AE6, 
        0x2AE6, 0x2AE6, 0x22E5, 0x22E5, 0x22E5, 0x2305, 0x2305, 0x2B05, 0x2B45, 0x3345, 0x3B85, 0x3B85, 0x3BA5, 0x43C6, 0x43C6, 0x43E6, 0x4BE6, 0x4BE7, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x63EA, 0x6C2B, 0x746D, 0x7C8E, 0x848E, 0x7C8F, 0x7C8F, 0x7C8F, 
        0x748F, 0x748F, 0x6C8F, 0x6C8F, 0x6C8F, 0x648E, 0x648E, 0x64AE, 0x6CCF, 0x74CF, 0x6C8F, 0x5C0E, 0x434B, 0x3B4A, 0x3B6A, 0x43CB, 0x4BEC, 0x544C, 0x546C, 0x548C, 0x444A, 0x33C7, 0x2BA6, 0x2BA5, 0x2BC4, 0x2BC5, 0x2BC5, 0x2BC5, 0x33C5, 0x3BE5, 
        0x3BE6, 0x3BE6, 0x3C06, 0x3C06, 0x4407, 0x4C28, 0x548A, 0x5CCD, 0x5CCD, 0x4CCD, 0x4CAD, 0x4CAC, 0x4C6B, 0x4C2A, 0x4C08, 0x4C08, 0x5408, 0x5407, 0x5407, 0x4BE7, 0x4BE7, 0x4BC7, 0x43A7, 0x43A7, 0x3B87, 0x3B67, 0x3B67, 0x3B67, 0x3347, 0x3347, 
        0x3327, 0x3B28, 0x3B28, 0x3B28, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3AE8, 0x3AE8, 0x3AE8, 0x3AE9, 0x42C9, 0x42E9, 0x42CA, 0x4A8D, 0x7B98, 0x93FE, 0x8BDE, 0x8BDE, 0x83DE, 0x83DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x633E, 0x5B1E, 0x52DE, 0x4ABD, 0x4A9D, 0x4A7D, 0x4A5D, 0x425D, 0x423D, 0x421D, 0x421D, 0x41FD, 0x4A1D, 0x62DE, 0x7BBE, 0x83FE, 0x83FE, 0x841E, 0x7C1E, 0x7C1E, 0x7C3E, 0x7C3E, 0x7C3E, 
        0x7C1E, 0x7C1E, 0x7C1E, 0x73FE, 0x73FE, 0x6BDE, 0x6BDE, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x635E, 0x635E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B1E, 0x531E, 0x531D, 0x531D, 0x531E, 0x4AFE, 0x4ADE, 0x4ADE, 0x42BD, 0x42BD, 0x42BD, 0x3A9D, 
        0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A9D, 0x427E, 0x429E, 0x429D, 0x429D, 0x429D, 0x42BD, 0x42BD, 0x42BD, 0x429D, 0x3A7D, 0x3A5D, 0x323D, 0x31FD, 0x39FD, 0x4A9E, 
        0x5AFE, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFD, 0x52DD, 0x52BD, 0x52DD, 0x4ABD, 0x4ABE, 0x427D, 0x427D, 0x425E, 0x3A1E, 0x31DD, 0x31DD, 0x39FD, 0x31FD, 0x39FD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x427E, 0x427E, 
        0x429E, 0x4A9E, 0x4A9E, 0x4A9D, 0x52BD, 0x5ADE, 0x62FE, 0x6B3E, 0x735E, 0x7B7E, 0x83BE, 0x83BE, 0x83DE, 0x6B5D, 0x533E, 0x4B1E, 0x4B1E, 0x4B1E, 0x4B1E, 0x433E, 0x4B3E, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x639E, 0x63BE, 0x63BE, 
        0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x63BE, 0x5B5E, 0x42BD, 0x42BD, 0x42BE, 0x42BE, 0x42DD, 0x42DD, 0x42FD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4B1E, 0x4B1E, 0x4B1D, 0x531E, 0x533E, 0x533E, 0x531E, 0x533E, 0x533E, 
        0x533E, 0x5B5E, 0x639E, 0x6BDE, 0x6BFE, 0x747B, 0x64F6, 0x6552, 0x6572, 0x6571, 0x6D72, 0x7592, 0x7D72, 0x648E, 0x3B0A, 0x2206, 0x21C6, 0x21E5, 0x21E6, 0x1A06, 0x2206, 0x2226, 0x2246, 0x2246, 0x32A7, 0x642D, 0x8511, 0x9552, 0xA552, 0xAD73, 
        0xB593, 0xAD93, 0x9D51, 0x7C8E, 0x53AA, 0x3B88, 0x3367, 0x2B87, 0x2BA7, 0x2BA7, 0x2BC7, 0x2BA7, 0x2BA6, 0x33A7, 0x2B87, 0x3387, 0x2B67, 0x2B67, 0x2B47, 0x2B26, 0x2B26, 0x2326, 0x2306, 0x1AE6, 0x1AE5, 0x1AC5, 0x12A5, 0x12A4, 0x12A4, 0x12A4, 
        0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x1AA4, 0x1AC4, 0x1AC4, 0x1AC4, 0x1AC5, 0x1AE5, 0x1B05, 0x1B05, 0x1B05, 0x1B25, 0x2325, 0x2325, 0x2345, 0x2B45, 0x2B66, 0x2B86, 0x33A6, 0x3BC7, 0x3BE7, 0x4407, 0x4428, 0x4C28, 
        0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4427, 0x3C08, 0x3C07, 0x3C08, 0x3C07, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA7, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 0x4368, 0x4368, 0x3B68, 0x3B69,
  0x758F, 0x6D6F, 0x6D6E, 0x6D6E, 0x6D8E, 0x6D8E, 0x6D8D, 0x6D8D, 0x7DAE, 0x85AE, 0x85AE, 0x8DAF, 0x8DCF, 0x8DCF, 0x95AF, 0x95B0, 0x95B0, 0x95B0, 0x9590, 0x9591, 0x850E, 0x95D1, 0x8D70, 0x750F, 0x5CCD, 0x54CD, 0x5D2E, 0x5D4E, 0x652F, 0x7592, 0x7D73, 
        0x74F2, 0x7CD3, 0x84B3, 0x6BEF, 0x3AA8, 0x3AC7, 0x3AE7, 0x3AE7, 0x3B07, 0x4307, 0x3B07, 0x3B06, 0x3B07, 0x3B06, 0x3B06, 0x3B27, 0x3B27, 0x3B27, 0x3327, 0x3326, 0x3326, 0x3326, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2305, 0x22E5, 
        0x22E5, 0x22E5, 0x22E5, 0x22E5, 0x22E5, 0x2305, 0x2304, 0x2B25, 0x2B45, 0x3365, 0x3B85, 0x3B85, 0x3BA5, 0x43C6, 0x43C6, 0x4BE6, 0x4BE7, 0x4C07, 0x5407, 0x53E7, 0x53E8, 0x53E8, 0x5BC9, 0x63EA, 0x6C0B, 0x744D, 0x7C6E, 0x846E, 0x7C6F, 0x7C4F, 
        0x744F, 0x744F, 0x746F, 0x7470, 0x746F, 0x6C6E, 0x648E, 0x64AE, 0x6CAF, 0x6CAF, 0x6C8F, 0x5C0E, 0x436B, 0x3B2A, 0x3B6A, 0x43AB, 0x43EB, 0x4C0C, 0x546C, 0x548C, 0x4C6B, 0x33E8, 0x2BA6, 0x2BA5, 0x2BA5, 0x2BC5, 0x2BC5, 0x33C5, 0x33C5, 0x3BE6, 
        0x3BE6, 0x3BE6, 0x4406, 0x4407, 0x4C08, 0x5449, 0x5C8B, 0x5CCD, 0x54CD, 0x4CCD, 0x4CAD, 0x54AC, 0x546A, 0x4C29, 0x4C08, 0x5408, 0x5407, 0x5407, 0x53E7, 0x53E7, 0x4BC7, 0x4BC7, 0x43A7, 0x43A7, 0x4387, 0x3B87, 0x3B67, 0x3B67, 0x3367, 0x3347, 
        0x3347, 0x3B27, 0x3B28, 0x3307, 0x3307, 0x3B08, 0x3B08, 0x3AE8, 0x3AE8, 0x3AE8, 0x3AE8, 0x3AC8, 0x3AC9, 0x3AC9, 0x42C9, 0x4A8D, 0x8BDA, 0x93DE, 0x8BDE, 0x8BDE, 0x83DE, 0x83DE, 0x7BDE, 0x7BBE, 0x7BBE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x52FE, 0x52BE, 0x4A9E, 0x4A7D, 0x425D, 0x425D, 0x423D, 0x423D, 0x3A1D, 0x41FD, 0x41FD, 0x525D, 0x739F, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C3E, 0x7C3E, 
        0x7C1E, 0x7C1E, 0x741E, 0x73FE, 0x6BDE, 0x6BDE, 0x6BBE, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B5D, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B1E, 0x531E, 0x52FE, 0x52FE, 0x52FD, 0x4AFD, 0x4AFD, 0x4AFE, 0x42DD, 0x42BD, 0x42BD, 0x42BD, 0x3A9D, 0x3A9D, 
        0x3A7D, 0x325D, 0x325D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x325D, 0x325D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7E, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x31DD, 0x31DD, 0x3A1D, 
        0x529E, 0x52DE, 0x52BE, 0x529D, 0x529D, 0x4A9D, 0x4A7D, 0x4A9D, 0x4A9D, 0x427D, 0x427D, 0x427D, 0x4A9E, 0x531E, 0x4ABE, 0x39FD, 0x39DD, 0x31DD, 0x31DD, 0x31DD, 0x31FD, 0x31FD, 0x321D, 0x3A1E, 0x3A3D, 0x3A5E, 0x3A5D, 0x3A5E, 0x3A5D, 0x427E, 
        0x429E, 0x429E, 0x4A9E, 0x4A9D, 0x5ADE, 0x62FE, 0x6B1E, 0x6B3E, 0x735E, 0x7B7E, 0x83BE, 0x8BDE, 0x7BDE, 0x5B3D, 0x4B1E, 0x431E, 0x4B1E, 0x431E, 0x433D, 0x433E, 0x433E, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B7E, 0x5B9E, 0x639E, 0x639E, 0x63BE, 
        0x6BBE, 0x6BDE, 0x6BDE, 0x6BDE, 0x63BE, 0x5B7E, 0x4ADD, 0x42BD, 0x42BE, 0x42DE, 0x42DD, 0x42DD, 0x42DD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4B1D, 0x4B1D, 0x4B1E, 0x4B1E, 0x4B1E, 0x531E, 0x4B3E, 0x4B3E, 0x533E, 0x535E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x6BFE, 0x747B, 0x6CF6, 0x6572, 0x6572, 0x6571, 0x6D92, 0x7D92, 0x7D51, 0x646E, 0x3B0A, 0x2206, 0x21C5, 0x21C5, 0x21C6, 0x19E6, 0x19E6, 0x2206, 0x2226, 0x32A8, 0x642E, 0x8532, 0x9553, 0xA532, 0xAD53, 0xAD73, 
        0xB593, 0xAD93, 0x8CF0, 0x5BEB, 0x4348, 0x3347, 0x3367, 0x2B67, 0x2B87, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B87, 0x2B86, 0x2B67, 0x2B66, 0x2B67, 0x2B46, 0x2326, 0x2306, 0x2306, 0x1AE6, 0x1AE5, 0x1AC5, 0x12A5, 0x12A5, 0x1284, 0x1284, 0x1284, 
        0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1AA4, 0x1AA4, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE5, 0x1AE5, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2345, 0x2B45, 0x2B66, 0x2B86, 0x33A6, 0x3BC7, 0x3BE7, 0x4407, 0x4408, 0x4C28, 
        0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4428, 0x4427, 0x3C08, 0x3C07, 0x3C08, 0x3C08, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC7, 0x3BC8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x4369, 0x4369, 0x3B89, 0x4369,
  0x7570, 0x6D6F, 0x6D6E, 0x6D6E, 0x6D6E, 0x6D8E, 0x6D8E, 0x6D8D, 0x7D8E, 0x7DAE, 0x85AE, 0x8DAE, 0x8DCE, 0x8DAF, 0x95AF, 0x95B0, 0x95B0, 0x95B0, 0x95B0, 0x95B0, 0x9590, 0x95B0, 0x8D90, 0x7D4F, 0x64CD, 0x5CED, 0x5D2E, 0x5D2E, 0x5D0F, 0x7571, 0x7D93, 
        0x8574, 0x7CF4, 0x84B4, 0x7C92, 0x42EA, 0x3AC8, 0x3AE7, 0x3AE7, 0x3B06, 0x4307, 0x3B06, 0x3B06, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3327, 0x3327, 0x3326, 0x3326, 0x3326, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B05, 0x2305, 0x22E5, 
        0x22E5, 0x22E5, 0x22E5, 0x2305, 0x2304, 0x2304, 0x2325, 0x2B45, 0x2B45, 0x3365, 0x3B85, 0x3BA5, 0x43A6, 0x43C6, 0x4BC6, 0x4BE6, 0x4C06, 0x5407, 0x5407, 0x5407, 0x53E7, 0x53E7, 0x5BE8, 0x5BE9, 0x63EA, 0x6C0B, 0x7C4D, 0x7C4E, 0x846E, 0x844F, 
        0x7C4F, 0x7C2F, 0x7C50, 0x7C50, 0x7470, 0x746F, 0x6C8F, 0x6CAF, 0x6CAF, 0x6CAF, 0x6C8F, 0x5C2E, 0x4BAC, 0x3B2A, 0x3B4A, 0x43AB, 0x43CB, 0x4C0C, 0x4C4C, 0x548D, 0x4C8C, 0x4449, 0x33C7, 0x2BA5, 0x2BA5, 0x2BC5, 0x2BC5, 0x33C5, 0x33E5, 0x3BE5, 
        0x3C06, 0x4406, 0x4407, 0x4407, 0x4C28, 0x546A, 0x5CAC, 0x5CCD, 0x4CCD, 0x4CCD, 0x4CAD, 0x548C, 0x544A, 0x5429, 0x5408, 0x5408, 0x5C07, 0x5407, 0x53E7, 0x53E7, 0x4BC7, 0x4BC7, 0x43A7, 0x43A7, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3367, 0x3347, 
        0x3347, 0x3347, 0x3327, 0x3307, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x32E8, 0x32C8, 0x3AC8, 0x3AC8, 0x3AC8, 0x3AC9, 0x3AC9, 0x4A8D, 0x8BFA, 0x93FE, 0x8BDE, 0x83BE, 0x83DE, 0x83BE, 0x7BDE, 0x7BDE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B7E, 0x6B7E, 0x635E, 0x633E, 0x5B1D, 0x52FE, 0x52BD, 0x4A9D, 0x4A7D, 0x425D, 0x423D, 0x423D, 0x421D, 0x421D, 0x41FD, 0x41FD, 0x62FD, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C3E, 0x7C1E, 
        0x741E, 0x741E, 0x73FE, 0x6BFE, 0x6BDE, 0x6BDE, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5D, 0x5B3E, 0x5B3E, 0x531E, 0x52FE, 0x4AFD, 0x4ADD, 0x4AFD, 0x4AFD, 0x4ADD, 0x42DD, 0x42BD, 0x3A9D, 0x3A9D, 0x3A9D, 0x3A9D, 0x3A7D, 
        0x325D, 0x323D, 0x323D, 0x325D, 0x3A5D, 0x3A5D, 0x3A5D, 0x325D, 0x325D, 0x323D, 0x323D, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29DD, 0x31BD, 0x31DD, 
        0x39DD, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x425D, 0x427D, 0x425D, 0x425D, 0x4A7E, 0x5B5E, 0x5B3E, 0x39FD, 0x39BD, 0x31BD, 0x31BD, 0x31BD, 0x31DD, 0x31DD, 0x31FD, 0x31FD, 0x321D, 0x321D, 0x323D, 0x3A3D, 0x3A5D, 0x425D, 
        0x427D, 0x427D, 0x427D, 0x52BD, 0x5AFD, 0x62FE, 0x6B3E, 0x735E, 0x737E, 0x7B9E, 0x83BE, 0x8BDE, 0x7BBE, 0x531D, 0x4B1E, 0x431E, 0x431E, 0x431E, 0x433D, 0x433D, 0x433D, 0x4B5D, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x5B9E, 0x63BE, 
        0x6BBE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x637E, 0x531E, 0x42BE, 0x42BE, 0x42BE, 0x42DD, 0x42DD, 0x42DD, 0x4ADD, 0x4ADD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4B1E, 0x4B1E, 0x4B1D, 0x4B1D, 0x4B1E, 0x4B1E, 0x4B1E, 0x4B3D, 0x4B3D, 0x4B3D, 0x4B5D, 0x535E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x6BFE, 0x747B, 0x6D15, 0x6572, 0x6572, 0x6551, 0x6D72, 0x7572, 0x7511, 0x5C0D, 0x32A9, 0x21E6, 0x19C5, 0x21A5, 0x21C6, 0x19C6, 0x19E6, 0x2206, 0x430A, 0x7490, 0x8D32, 0x9D53, 0xA532, 0xAD13, 0xAD33, 0xB553, 
        0xB573, 0x9D51, 0x746D, 0x4368, 0x3327, 0x2B46, 0x2B66, 0x2B67, 0x2386, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B46, 0x2B46, 0x2326, 0x2326, 0x2306, 0x1AE6, 0x1AE6, 0x1AC5, 0x1AA5, 0x12A5, 0x1284, 0x0A84, 0x0A84, 0x1264, 
        0x1264, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x1AA5, 0x1AA5, 0x1AA4, 0x1AC5, 0x1AE5, 0x22E5, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2B45, 0x2B45, 0x2B66, 0x2B86, 0x33A6, 0x33C7, 0x3BE7, 0x3C07, 0x4408, 0x4428, 
        0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4428, 0x4428, 0x4428, 0x4428, 0x4428, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC7, 0x3BC8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B89, 0x4389, 0x4389, 0x43A9,
  0x6D2F, 0x754F, 0x6D6E, 0x6D6E, 0x6D6D, 0x6D6E, 0x6D8D, 0x6D6D, 0x758D, 0x7D8E, 0x7DAE, 0x85AE, 0x8DAE, 0x8DCE, 0x95CF, 0x95CF, 0x95D0, 0x95D0, 0x95D0, 0x95D0, 0x95D0, 0x95D0, 0x8DAF, 0x856F, 0x6CED, 0x5CCC, 0x5D0D, 0x5D4E, 0x656F, 0x6D71, 0x7D92, 
        0x8574, 0x84F4, 0x7473, 0x8493, 0x5B8D, 0x3AA8, 0x3AC7, 0x3AE7, 0x3AE7, 0x42E7, 0x3AE6, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3307, 0x3327, 0x3327, 0x3306, 0x3327, 0x3326, 0x3326, 0x2B26, 0x2B26, 0x2B26, 0x2B25, 0x2B25, 0x2305, 
        0x2305, 0x2305, 0x2305, 0x2305, 0x2305, 0x2325, 0x2B25, 0x2B45, 0x2B45, 0x3365, 0x3B85, 0x3BA5, 0x43A6, 0x43C6, 0x4BC6, 0x4BE6, 0x4C06, 0x5407, 0x5407, 0x5407, 0x5407, 0x53E7, 0x53E7, 0x53C8, 0x5BE9, 0x63EA, 0x6BEB, 0x740C, 0x844E, 0x8C6F, 
        0x8470, 0x8450, 0x7C2F, 0x7C30, 0x7C50, 0x746F, 0x6C6F, 0x6C8F, 0x6C8F, 0x6C8F, 0x6C8F, 0x5C2E, 0x53ED, 0x436B, 0x3B4A, 0x3B6A, 0x43AB, 0x4BEC, 0x4C2C, 0x548D, 0x54AC, 0x4C8B, 0x3C08, 0x2BA6, 0x2BA5, 0x2BC5, 0x33C5, 0x33E5, 0x3BE5, 0x3BE5, 
        0x4406, 0x4406, 0x4407, 0x4C07, 0x4C28, 0x5C6B, 0x64CD, 0x5CED, 0x4CCD, 0x44CD, 0x4CAD, 0x5C8C, 0x544A, 0x5429, 0x5C08, 0x5C08, 0x5C27, 0x5C07, 0x53E7, 0x53E7, 0x4BC7, 0x4BC7, 0x43A7, 0x43A7, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3367, 0x3347, 
        0x3347, 0x3327, 0x3307, 0x3307, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x32E7, 0x32C7, 0x32C7, 0x32A7, 0x32C8, 0x3AC8, 0x3AC8, 0x426D, 0x83DA, 0x8BDE, 0x8BBE, 0x83BE, 0x83BE, 0x7BBE, 0x7BBE, 0x7BDE, 0x7BBE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x633E, 0x5B1D, 0x52DE, 0x52BD, 0x4A9D, 0x4A5D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x41FD, 0x4A5D, 0x739F, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x741E, 0x741E, 
        0x741E, 0x6BFE, 0x6BFE, 0x6BFE, 0x6BDE, 0x63BE, 0x63BE, 0x5B9E, 0x5B9D, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5D, 0x5B3D, 0x5B3E, 0x5B1E, 0x52FE, 0x4ADE, 0x4ADD, 0x4ABD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x3A9D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 
        0x323D, 0x323D, 0x323D, 0x323D, 0x323D, 0x3A3D, 0x3A3D, 0x323D, 0x323D, 0x323D, 0x321D, 0x321D, 0x323E, 0x323D, 0x323D, 0x323D, 0x323D, 0x323D, 0x323D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x29DD, 0x29BD, 0x29BD, 0x31DD, 
        0x39DD, 0x39DD, 0x39DD, 0x41FD, 0x41FD, 0x39FD, 0x41FD, 0x421D, 0x421D, 0x423D, 0x425D, 0x4A5D, 0x529E, 0x5AFE, 0x5AFD, 0x529D, 0x4A3D, 0x41FD, 0x39DD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31DD, 0x31DD, 0x31FD, 0x321D, 0x323D, 0x3A3D, 0x3A5D, 
        0x425D, 0x425D, 0x427D, 0x5ADD, 0x62FD, 0x6B1E, 0x733E, 0x735E, 0x7B9E, 0x83BE, 0x83DE, 0x8C3E, 0x7BFE, 0x531D, 0x431E, 0x431E, 0x431E, 0x431E, 0x433D, 0x433E, 0x433D, 0x435E, 0x4B5E, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B7E, 0x5B9E, 0x639E, 
        0x63BE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BDE, 0x639E, 0x5B3E, 0x42BD, 0x42BE, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42FD, 0x42FD, 0x4AFD, 0x4B1D, 0x4B1D, 0x4B1D, 0x4B1E, 0x4B1E, 0x4B1E, 0x4B3D, 0x4B3D, 0x4B3D, 0x4B5D, 0x535E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x6BFE, 0x747B, 0x6D15, 0x6572, 0x6572, 0x6551, 0x6D31, 0x7552, 0x6CD0, 0x53CC, 0x3288, 0x21E6, 0x19C5, 0x21A5, 0x21A6, 0x19C6, 0x21E6, 0x3AC9, 0x7C90, 0x9D73, 0x9D53, 0xA533, 0xA4F2, 0xAD12, 0xAD12, 0xAD33, 
        0xAD53, 0x84AF, 0x5BAA, 0x3307, 0x2B26, 0x2B26, 0x2346, 0x2B66, 0x2386, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B46, 0x2326, 0x2326, 0x2306, 0x22E5, 0x1AC6, 0x1AC5, 0x1AA5, 0x12A5, 0x1284, 0x1284, 0x1264, 0x0A64, 0x1244, 
        0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1284, 0x1A85, 0x1AA5, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE5, 0x22E5, 0x2305, 0x2305, 0x2305, 0x2326, 0x2B46, 0x2B66, 0x2B66, 0x3386, 0x3386, 0x33A6, 0x33C7, 0x3BC7, 0x3C07, 0x4408, 0x4428, 
        0x4C28, 0x4C28, 0x4C28, 0x4428, 0x4428, 0x4C28, 0x4428, 0x4428, 0x4428, 0x3C28, 0x3C08, 0x3C08, 0x3C08, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BC8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x4389, 0x43A9, 0x43A9, 0x43A9, 0x43C9,
  0x64AE, 0x6D2F, 0x6D6E, 0x6D6E, 0x6D4D, 0x6D6E, 0x6D6D, 0x6D6D, 0x758D, 0x758D, 0x7D8E, 0x85AE, 0x8DAE, 0x95AE, 0x95CF, 0x95CF, 0x95AF, 0x95CF, 0x95CF, 0x95CF, 0x95CF, 0x95D0, 0x95CF, 0x858F, 0x6D0D, 0x5CCC, 0x5CED, 0x5D2E, 0x654F, 0x6D70, 0x7592, 
        0x7D73, 0x8534, 0x84D4, 0x84B4, 0x7410, 0x42C9, 0x42C8, 0x42C7, 0x3AC7, 0x3AE6, 0x3AC6, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3307, 0x3307, 0x3307, 0x3307, 0x3327, 0x3327, 0x3327, 0x3327, 0x3306, 0x3326, 0x2B26, 0x2B26, 0x2B25, 0x2B25, 0x2325, 
        0x2325, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2B45, 0x2B45, 0x3365, 0x3B65, 0x3B86, 0x3BA6, 0x43A6, 0x43C6, 0x43C6, 0x4BE6, 0x4C06, 0x53E6, 0x53E7, 0x5406, 0x5406, 0x53E7, 0x53E7, 0x53E8, 0x53C8, 0x5BC9, 0x63CA, 0x6BEB, 0x7C2D, 0x846E, 
        0x8C6F, 0x8C50, 0x842F, 0x842F, 0x7C30, 0x7C30, 0x746F, 0x748F, 0x6C8F, 0x6C8F, 0x6C8F, 0x646F, 0x5C2E, 0x4B8C, 0x3B2A, 0x3B4A, 0x438B, 0x43CB, 0x4C2C, 0x546C, 0x54AC, 0x4CAB, 0x3C29, 0x2BC6, 0x2BA5, 0x2BC5, 0x33C5, 0x33E5, 0x3BE6, 0x43E6, 
        0x4406, 0x4406, 0x4C07, 0x4C28, 0x5449, 0x5C8B, 0x64CD, 0x54CD, 0x4CCD, 0x4CCD, 0x54AD, 0x5C6B, 0x542A, 0x5C08, 0x5C08, 0x5C08, 0x5C07, 0x5BE8, 0x53E8, 0x53C8, 0x4BC7, 0x4BA7, 0x43A7, 0x43A7, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3B67, 0x3367, 
        0x3347, 0x3327, 0x3307, 0x3307, 0x3307, 0x2AE6, 0x32E7, 0x32E7, 0x32C7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32C8, 0x3AC8, 0x426D, 0x6B37, 0x8BBE, 0x8BBE, 0x83BE, 0x83DE, 0x83BE, 0x7BBE, 0x7BDE, 0x7BBE, 0x73BE, 0x739E, 0x739E, 0x73BE, 0x73BE, 
        0x73BE, 0x73BE, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x5B3E, 0x5AFD, 0x52DE, 0x52BD, 0x4A7D, 0x425D, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x49FD, 0x631E, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73FE, 0x73FE, 0x741E, 0x741E, 0x741E, 0x741E, 
        0x73FE, 0x6BFE, 0x6BDE, 0x6BDE, 0x63BE, 0x63BE, 0x639E, 0x5B9E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5AFE, 0x52DE, 0x4ABD, 0x42BD, 0x429E, 0x429D, 0x429D, 0x429D, 0x3A9D, 0x3A7D, 0x3A5D, 0x325D, 0x323D, 0x323D, 0x323D, 
        0x323D, 0x323D, 0x3A5D, 0x3A5E, 0x321D, 0x323D, 0x323D, 0x3A1D, 0x3A3D, 0x3A5D, 0x323D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x29FD, 0x29DD, 0x29DD, 0x29DD, 0x21BD, 0x29BD, 0x29BD, 
        0x31BD, 0x39BD, 0x39BD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x421D, 0x4A5D, 0x52BD, 0x5B1E, 0x5B1E, 0x633E, 0x6B3E, 0x6B5E, 0x631E, 0x62FE, 0x5ADE, 0x529E, 0x425E, 0x39DD, 0x31BD, 0x31BD, 0x29DD, 0x29DD, 0x29DD, 0x31FD, 0x321D, 0x321D, 0x3A3D, 
        0x3A3D, 0x425D, 0x4A7D, 0x5AFE, 0x6B1E, 0x6B3E, 0x735E, 0x737E, 0x7BBE, 0x83DE, 0x8C1E, 0x947E, 0x841E, 0x531D, 0x42FD, 0x42FE, 0x431E, 0x431E, 0x431E, 0x433D, 0x433D, 0x433D, 0x4B5E, 0x4B3E, 0x4B5E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x5B9E, 
        0x63BE, 0x63BE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 0x5B5E, 0x42BD, 0x42BD, 0x42DE, 0x42DD, 0x42DD, 0x3ADD, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42FD, 0x42FD, 0x4B1D, 0x4B1D, 0x4B1D, 0x431E, 0x4B1E, 0x4B1E, 0x4B3D, 0x4B3D, 0x4B3D, 0x4B5D, 0x535E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x6BFE, 0x747B, 0x6D15, 0x6572, 0x6572, 0x6551, 0x6D31, 0x7531, 0x6C6F, 0x434A, 0x2A27, 0x21C6, 0x21A5, 0x21A5, 0x19A5, 0x3268, 0x538C, 0x7C90, 0x9533, 0x9D33, 0xA4F2, 0xA4D2, 0xA4D2, 0xACF2, 0xB533, 0xB553, 
        0x94D0, 0x63CB, 0x3B07, 0x2B06, 0x2306, 0x2326, 0x2346, 0x2B66, 0x2386, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2B46, 0x2326, 0x2306, 0x22E6, 0x22E5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1285, 0x1264, 0x1264, 0x1244, 0x1244, 0x0A24, 
        0x1244, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1265, 0x1265, 0x1A85, 0x1AA5, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE5, 0x22E5, 0x2305, 0x2305, 0x2326, 0x2B46, 0x2B66, 0x2B66, 0x3386, 0x3386, 0x33A6, 0x33A7, 0x33C7, 0x3BC7, 0x3C07, 0x4407, 0x4427, 
        0x4428, 0x4448, 0x4448, 0x4C48, 0x4C48, 0x4C48, 0x4C48, 0x4428, 0x4428, 0x4428, 0x4408, 0x4408, 0x4408, 0x43E8, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BC8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x43A9, 0x43A9, 0x43A9, 0x43C9, 0x43C9,
  0x540B, 0x6CEE, 0x756F, 0x6D6E, 0x6D6E, 0x6D6E, 0x6D6D, 0x6D4D, 0x6D6D, 0x756D, 0x7D6D, 0x7D8D, 0x8DAE, 0x8DAE, 0x95AF, 0x95AF, 0x95AF, 0x95CF, 0x95CF, 0x95CF, 0x9DCF, 0x95CF, 0x95CF, 0x858F, 0x754E, 0x64ED, 0x5CCD, 0x5CED, 0x5D2E, 0x6550, 0x7571, 
        0x7D73, 0x8534, 0x84F4, 0x8494, 0x7C52, 0x6BCE, 0x530A, 0x42E8, 0x3AC7, 0x3AE7, 0x3AC6, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x32E7, 0x3307, 0x3307, 0x3307, 0x3307, 0x3307, 0x3307, 0x3306, 0x3306, 0x2B26, 0x2B26, 0x2B26, 0x2B25, 0x2B25, 
        0x2B25, 0x2325, 0x2325, 0x2325, 0x2325, 0x2B45, 0x2B45, 0x3345, 0x3365, 0x3B65, 0x3B86, 0x3BA6, 0x43A6, 0x43C6, 0x4BC6, 0x4BE6, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53C8, 0x53A8, 0x5BA9, 0x63A9, 0x6BEB, 0x742C, 
        0x844E, 0x8C4F, 0x844F, 0x842F, 0x842F, 0x7C30, 0x7450, 0x7470, 0x748F, 0x6C8F, 0x6C8F, 0x646F, 0x5C2E, 0x4BAC, 0x3B2A, 0x3B2A, 0x436B, 0x43AB, 0x440B, 0x4C4C, 0x548C, 0x4C8C, 0x444A, 0x33C7, 0x2BA6, 0x33C5, 0x33C5, 0x3BE5, 0x3BE6, 0x4406, 
        0x4C06, 0x4C06, 0x4C07, 0x5428, 0x5449, 0x5CAC, 0x5CCD, 0x54CD, 0x4CCD, 0x4CCD, 0x548D, 0x5C4B, 0x5C09, 0x5C08, 0x6408, 0x5C08, 0x5C07, 0x5BE8, 0x53E8, 0x53C8, 0x4BC7, 0x4BA7, 0x4BA7, 0x43A7, 0x43A7, 0x4387, 0x4387, 0x3B67, 0x3B47, 0x3B47, 
        0x3347, 0x3327, 0x3307, 0x2B06, 0x2B06, 0x2AE6, 0x2AE7, 0x2AC6, 0x2AC7, 0x32C7, 0x32C7, 0x32A7, 0x32A7, 0x32A7, 0x32C8, 0x3A6B, 0x5272, 0x837D, 0x8B9E, 0x83BE, 0x83BE, 0x83BE, 0x7BBE, 0x7BBE, 0x7BBE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 
        0x739E, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x631E, 0x5AFD, 0x52BE, 0x529D, 0x4A7D, 0x425D, 0x421D, 0x3A1D, 0x3A1D, 0x41FD, 0x421D, 0x525D, 0x737E, 0x7BBE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 
        0x6BFE, 0x6BDE, 0x6BDE, 0x6BBE, 0x63BE, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x5B3D, 0x531D, 0x5AFE, 0x52FE, 0x4ADE, 0x4ABD, 0x429D, 0x427D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A3D, 0x323D, 0x321D, 0x321D, 
        0x3A3D, 0x52FD, 0x63BE, 0x637F, 0x425D, 0x31FD, 0x3A3D, 0x52FD, 0x637E, 0x639E, 0x531E, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x29FD, 0x29FD, 0x29FD, 0x2A1D, 0x321D, 0x31FD, 0x29FD, 0x29FD, 0x29DD, 0x29DD, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 
        0x421E, 0x4A7E, 0x52BE, 0x52BE, 0x52BE, 0x5ABE, 0x5ADE, 0x5AFE, 0x635E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B3E, 0x631E, 0x62FE, 0x5ABE, 0x4A7E, 0x39FE, 0x31BD, 0x29BD, 0x29BD, 0x29DD, 0x29DD, 0x31FD, 0x321D, 0x321D, 
        0x3A1D, 0x425D, 0x52BE, 0x631E, 0x6B3E, 0x735E, 0x7B7E, 0x7B9E, 0x83BE, 0x8BFE, 0x945E, 0x94BE, 0x843E, 0x531D, 0x42FD, 0x42FE, 0x431E, 0x431E, 0x431E, 0x433E, 0x433E, 0x433E, 0x4B3E, 0x4B5E, 0x4B5E, 0x535E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 
        0x63BE, 0x63BE, 0x63BE, 0x6BDE, 0x6BDE, 0x6BBE, 0x5B7E, 0x42DD, 0x3ABD, 0x3ABE, 0x42DD, 0x3ADD, 0x3ADD, 0x42DD, 0x42DD, 0x42FD, 0x42FE, 0x42FD, 0x42FD, 0x42FD, 0x42FD, 0x42FD, 0x431E, 0x431E, 0x4B1E, 0x4B1D, 0x4B3E, 0x4B3D, 0x4B3E, 0x535E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x73FE, 0x747B, 0x6D15, 0x6D72, 0x6D72, 0x6552, 0x6D32, 0x7D32, 0x6C90, 0x4B2A, 0x2A27, 0x21C6, 0x21A6, 0x21A6, 0x29C7, 0x5B8D, 0x84D2, 0x9533, 0x9D33, 0x9CD2, 0xA4B2, 0xA4B2, 0xACD2, 0xAD12, 0xB573, 0x9D32, 
        0x742D, 0x3B08, 0x2AC6, 0x2AE6, 0x2306, 0x2325, 0x2346, 0x2346, 0x2386, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B46, 0x2B46, 0x2326, 0x2305, 0x22E6, 0x22E6, 0x1AC5, 0x1AA5, 0x1AA5, 0x1284, 0x1264, 0x1244, 0x1244, 0x0A24, 0x1224, 
        0x1224, 0x1244, 0x1264, 0x1265, 0x1A65, 0x1A65, 0x1A65, 0x1A85, 0x1A85, 0x1AA5, 0x1AA5, 0x1AC5, 0x22E5, 0x22E5, 0x2305, 0x2325, 0x2B26, 0x2B46, 0x2B66, 0x2B66, 0x3386, 0x3386, 0x33A7, 0x33C7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x4407, 0x4427, 
        0x4428, 0x4C28, 0x4C48, 0x4C48, 0x4C48, 0x4C48, 0x4C48, 0x4C48, 0x4C28, 0x4428, 0x4428, 0x4408, 0x4408, 0x4408, 0x43E8, 0x3BE8, 0x3BC8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x43A9, 0x43A9, 0x43C9, 0x43C9, 0x4BE9,
  0x53CB, 0x5C4C, 0x754F, 0x756F, 0x6D6E, 0x6D6E, 0x6D6D, 0x6D4D, 0x6D4D, 0x6D6D, 0x756D, 0x7D8E, 0x85AE, 0x8DAE, 0x95AE, 0x95AF, 0x95AF, 0x95AF, 0x95CF, 0x95CF, 0x9DCF, 0x95CF, 0x95CF, 0x858F, 0x7D6E, 0x752E, 0x5CAC, 0x54AD, 0x650E, 0x652F, 0x6D31, 
        0x7D52, 0x7D33, 0x7CF4, 0x8494, 0x7C53, 0x73F0, 0x5B4C, 0x534A, 0x42C7, 0x3AC7, 0x3AC7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3307, 0x3307, 0x3306, 0x3306, 0x3306, 0x3306, 0x2B06, 0x2B26, 0x2B26, 0x2B26, 0x2B25, 
        0x2B25, 0x2B25, 0x2325, 0x2325, 0x2B45, 0x2B45, 0x2B45, 0x3365, 0x3365, 0x3B65, 0x3B86, 0x43A6, 0x43A6, 0x43A6, 0x4BC7, 0x4BC6, 0x4BE7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E8, 0x53C8, 0x53C8, 0x5BA8, 0x63A9, 0x6BCA, 
        0x740C, 0x842E, 0x842E, 0x842F, 0x840F, 0x840F, 0x7C30, 0x7C50, 0x7470, 0x6C90, 0x6C8F, 0x6C8F, 0x644E, 0x53ED, 0x436B, 0x3B2A, 0x3B6A, 0x43AB, 0x43EB, 0x4C4C, 0x4C6C, 0x4C8C, 0x4C4B, 0x3BE8, 0x33C7, 0x33C6, 0x33C6, 0x3BE6, 0x43E6, 0x4406, 
        0x4C26, 0x4C07, 0x5407, 0x5428, 0x5C6A, 0x5CAC, 0x5CCD, 0x54CD, 0x4CAE, 0x4CAD, 0x548C, 0x644A, 0x6429, 0x5C08, 0x5C08, 0x5BE7, 0x5BE7, 0x5BE8, 0x53C8, 0x53C8, 0x4BC7, 0x4BA8, 0x4B88, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 
        0x3347, 0x3327, 0x3307, 0x3306, 0x3306, 0x2AE6, 0x2AE6, 0x32C6, 0x32C6, 0x32C7, 0x2AC7, 0x2AC7, 0x32C7, 0x32A7, 0x32A8, 0x3AAA, 0x422F, 0x6298, 0x8B9E, 0x8BBE, 0x83BE, 0x83BE, 0x7BBE, 0x7BBE, 0x7B9E, 0x739E, 0x739E, 0x739E, 0x739E, 0x6B9E, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x635E, 0x631E, 0x5AFE, 0x52BE, 0x4A9E, 0x425D, 0x423D, 0x421D, 0x3A1D, 0x39FD, 0x41FD, 0x4A1D, 0x62DE, 0x7B9E, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x6BFE, 
        0x6BDE, 0x6BDE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x5B9E, 0x5B7E, 0x5B5E, 0x5B5D, 0x533D, 0x531E, 0x52FD, 0x52FD, 0x52DD, 0x4ABE, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3E, 0x3A1D, 0x321D, 0x321D, 0x3A3D, 
        0x5B1E, 0x6BDE, 0x73DE, 0x6BDE, 0x5AFD, 0x52DD, 0x637E, 0x6BBE, 0x6BDE, 0x6BDE, 0x5B5E, 0x3A3D, 0x29DD, 0x29FD, 0x29DD, 0x29DD, 0x29DD, 0x29FD, 0x29FD, 0x29FD, 0x29FD, 0x29FD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x31BD, 0x3A1D, 0x4A9E, 0x5B1E, 
        0x637E, 0x6B9E, 0x739E, 0x737E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x737E, 0x6B5E, 0x6B3E, 0x62FE, 0x5AFE, 0x5ADE, 0x4A7E, 0x421E, 0x31DD, 0x29BD, 0x29BD, 0x29BD, 0x29DD, 0x31DD, 0x31FD, 
        0x3A1D, 0x529D, 0x62FE, 0x6B3E, 0x735E, 0x7B5E, 0x839E, 0x83BE, 0x8BFE, 0x941E, 0x9C7E, 0x9CDE, 0x845E, 0x531D, 0x42DD, 0x3ADD, 0x3AFD, 0x431D, 0x431E, 0x431E, 0x431E, 0x4B3E, 0x4B3E, 0x4B5E, 0x4B5E, 0x4B5E, 0x537E, 0x535E, 0x537E, 0x5B7E, 
        0x639E, 0x63BE, 0x63BE, 0x63BE, 0x6BBE, 0x63BE, 0x639E, 0x42FD, 0x3ABD, 0x3ABE, 0x3ADD, 0x3ADD, 0x3ADD, 0x42DD, 0x42DD, 0x42DD, 0x42DD, 0x42FD, 0x42FD, 0x42FD, 0x42FD, 0x431D, 0x431D, 0x431E, 0x431E, 0x431E, 0x4B1E, 0x4B1E, 0x4B3E, 0x4B5E, 
        0x535E, 0x5B7E, 0x639E, 0x6BDE, 0x741E, 0x747B, 0x6D15, 0x6D73, 0x6D52, 0x6D52, 0x7512, 0x7D12, 0x74B0, 0x53AC, 0x3AA9, 0x2A07, 0x21C6, 0x21A6, 0x42CB, 0x7C91, 0x9533, 0x9D33, 0x9CF2, 0x9C92, 0x9C92, 0xA4B3, 0xACD3, 0xAD53, 0xAD73, 0x84CF, 
        0x538A, 0x2AC6, 0x2AC6, 0x22C6, 0x22E5, 0x2325, 0x2345, 0x2346, 0x2366, 0x2386, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2B66, 0x2346, 0x2326, 0x2306, 0x22E5, 0x22E6, 0x1AC6, 0x1AA5, 0x1AA5, 0x1AA5, 0x1284, 0x1264, 0x1244, 0x0A24, 0x0A24, 0x1224, 
        0x1224, 0x1244, 0x1A44, 0x1A64, 0x1A65, 0x1A65, 0x1A85, 0x1A85, 0x1A85, 0x1AA5, 0x22C5, 0x22C5, 0x22E6, 0x22E5, 0x2306, 0x2B26, 0x2B46, 0x2B66, 0x3386, 0x3386, 0x33A6, 0x33A7, 0x33C7, 0x3BC7, 0x3BC7, 0x3BE7, 0x43E7, 0x4407, 0x4407, 0x4428, 
        0x4C48, 0x4C48, 0x4C48, 0x4C49, 0x4C49, 0x4C48, 0x4C48, 0x4C48, 0x4C28, 0x4C29, 0x4428, 0x4C09, 0x4C08, 0x4408, 0x43E8, 0x43E8, 0x3BC8, 0x3BA8, 0x3BA8, 0x43A8, 0x3B88, 0x3B88, 0x3B88, 0x43A8, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x4BE9,
  0x53AA, 0x540B, 0x6D0E, 0x754F, 0x756E, 0x6D4E, 0x6D4D, 0x654D, 0x6D4D, 0x6D4D, 0x756D, 0x7D8E, 0x858E, 0x8DAE, 0x95AE, 0x958F, 0x95AE, 0x95AF, 0x9DCF, 0x9DCF, 0x9DCF, 0x95CF, 0x95CF, 0x8D8F, 0x856E, 0x7D4E, 0x64AD, 0x5C8D, 0x650F, 0x650F, 0x6D10, 
        0x7531, 0x7D13, 0x7CD3, 0x7C94, 0x8474, 0x7C32, 0x634D, 0x5B6B, 0x42C7, 0x3AC7, 0x3AC7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3307, 0x3307, 0x3327, 0x3306, 0x3306, 0x3326, 0x2B26, 0x2B46, 0x2B46, 0x2B46, 0x2B45, 
        0x2B25, 0x2B25, 0x2B25, 0x2B45, 0x2B45, 0x2B45, 0x2B65, 0x3365, 0x3365, 0x3B85, 0x3B86, 0x4386, 0x43A6, 0x43A6, 0x4BA7, 0x4BC7, 0x53C7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53C7, 0x53C7, 0x53C8, 0x53C8, 0x5BA8, 0x5BA9, 
        0x63AA, 0x6BCB, 0x7BED, 0x840E, 0x840F, 0x840F, 0x7C2F, 0x7C50, 0x7C70, 0x7490, 0x7490, 0x6C8F, 0x644F, 0x5C0E, 0x4B8C, 0x3B2A, 0x3B4A, 0x3B8A, 0x43CB, 0x4C0B, 0x4C4C, 0x4C6C, 0x4C6B, 0x4429, 0x3BC7, 0x33C6, 0x3BC6, 0x3BE6, 0x4406, 0x4C06, 
        0x4C27, 0x4C07, 0x5427, 0x5C29, 0x648B, 0x5CAD, 0x54CD, 0x54CE, 0x4CAE, 0x54AD, 0x546C, 0x644A, 0x5C29, 0x5C28, 0x5C08, 0x5BE8, 0x5BE8, 0x5BE8, 0x53C8, 0x53C8, 0x4BA8, 0x4B88, 0x4B88, 0x4387, 0x4387, 0x4367, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 
        0x3347, 0x3327, 0x3327, 0x3306, 0x3306, 0x3306, 0x32E7, 0x32C6, 0x32C6, 0x32C7, 0x2AC7, 0x2AC7, 0x32C7, 0x32C7, 0x32C7, 0x3AC9, 0x3A6D, 0x4213, 0x7B5C, 0x8BBE, 0x83BE, 0x83BE, 0x83BE, 0x7BBE, 0x7BBE, 0x73BE, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 
        0x6B7E, 0x6B9E, 0x6B7E, 0x6B7E, 0x635E, 0x633E, 0x631E, 0x5AFE, 0x52BE, 0x4A9D, 0x425D, 0x423D, 0x421D, 0x39FD, 0x39FD, 0x41FD, 0x4A1D, 0x6B5E, 0x7BBE, 0x7BBE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73FE, 0x6BDE, 
        0x6BDE, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x639E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B3D, 0x531D, 0x52FE, 0x52FE, 0x52BD, 0x4ABD, 0x4A9D, 0x425D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x323D, 0x323D, 0x3A1D, 0x423D, 0x423D, 0x423D, 0x4A9E, 0x5B5E, 
        0x6B9D, 0x739D, 0x73BD, 0x739E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B9D, 0x6B9E, 0x6B9E, 0x5B1D, 0x425D, 0x29DD, 0x29DD, 0x29BD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x31DD, 0x3A3D, 0x52FE, 0x637F, 0x73BF, 0x73DE, 
        0x73DE, 0x7BDE, 0x7BDE, 0x7BBE, 0x7BDE, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BBE, 0x739E, 0x737E, 0x6B5E, 0x6B3E, 0x631E, 0x62FE, 0x5ADE, 0x529E, 0x4A5E, 0x3A1D, 0x31BD, 0x299D, 0x299D, 0x29BD, 0x31BD, 0x31DD, 
        0x425D, 0x5ADE, 0x6B1E, 0x735E, 0x7B7E, 0x7B7E, 0x83BE, 0x8BBE, 0x8BFE, 0x945E, 0x9CBF, 0x9CDF, 0x847E, 0x533D, 0x42DD, 0x3ADD, 0x3AFD, 0x3AFD, 0x431E, 0x433E, 0x433E, 0x4B3E, 0x4B3E, 0x4B3D, 0x4B5E, 0x4B5E, 0x4B5E, 0x535E, 0x535E, 0x5B7E, 
        0x5B9E, 0x639E, 0x63BE, 0x63BE, 0x6BBE, 0x63BE, 0x639E, 0x4AFD, 0x3ABD, 0x3ABD, 0x3ADD, 0x3ADD, 0x3ADD, 0x42DE, 0x42FE, 0x42FD, 0x3AFD, 0x42FE, 0x42FD, 0x42FD, 0x42FD, 0x431D, 0x431D, 0x431E, 0x433E, 0x433E, 0x4B3D, 0x4B3D, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B7E, 0x63BE, 0x6BFE, 0x741E, 0x747B, 0x6CF6, 0x6D53, 0x6D53, 0x6D33, 0x7512, 0x7D12, 0x74B0, 0x5BCD, 0x430A, 0x3268, 0x2A07, 0x2A07, 0x63AE, 0x8CF3, 0x9D13, 0x9CF2, 0x9C91, 0x9C72, 0xA472, 0xA492, 0xACF3, 0xAD73, 0x9511, 0x63EB, 
        0x32C6, 0x22A5, 0x22C5, 0x22C6, 0x22E5, 0x2305, 0x2326, 0x2346, 0x2366, 0x2366, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2B66, 0x2346, 0x2326, 0x2305, 0x22E5, 0x22E5, 0x1AC5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1284, 0x1264, 0x1244, 0x1224, 0x1224, 0x1224, 
        0x1224, 0x1A44, 0x1A44, 0x1A64, 0x1A65, 0x1A65, 0x1A85, 0x1A85, 0x1A85, 0x1AA5, 0x22C5, 0x22E6, 0x22E6, 0x2306, 0x2B26, 0x2B46, 0x2B66, 0x2B86, 0x3386, 0x33A6, 0x33C6, 0x3BC7, 0x3BE7, 0x3BE7, 0x3BE7, 0x4407, 0x4408, 0x4427, 0x4428, 0x4C28, 
        0x4C48, 0x4C48, 0x5448, 0x5469, 0x5469, 0x5449, 0x5449, 0x4C49, 0x4C28, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4409, 0x43E8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x43A8, 0x3B88, 0x3B88, 0x3B88, 0x43A8, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x4BE9,
  0x53A9, 0x5C2B, 0x648D, 0x752F, 0x754E, 0x6D4E, 0x6D4D, 0x652D, 0x6D4D, 0x6D6D, 0x756D, 0x7D6E, 0x858E, 0x8D8E, 0x95AE, 0x958E, 0x95AE, 0x95AF, 0x9DCF, 0xAE51, 0xA5F0, 0x95AE, 0x95AF, 0x8D8F, 0x856E, 0x7D4E, 0x6CAD, 0x6CAE, 0x6CEF, 0x6D10, 0x6CF0, 
        0x6CF0, 0x74D2, 0x7CB3, 0x7C94, 0x8474, 0x8453, 0x6B8F, 0x5B2B, 0x42C8, 0x42C7, 0x42E7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3307, 0x3307, 0x3327, 0x3327, 0x3327, 0x3326, 0x3326, 0x3346, 0x2B46, 0x2B66, 0x2B45, 
        0x2B45, 0x2B45, 0x2B45, 0x2B45, 0x2B65, 0x2B65, 0x3365, 0x3386, 0x3B86, 0x3B86, 0x4386, 0x4386, 0x4B86, 0x4BA7, 0x4BA6, 0x4BC7, 0x4BC7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53C7, 0x4BC7, 0x4BC7, 0x4BA7, 0x4BA7, 0x4BA7, 0x53A8, 0x5388, 
        0x5388, 0x5B69, 0x638B, 0x73AC, 0x7BEE, 0x840E, 0x840F, 0x7C2F, 0x7C50, 0x7490, 0x7490, 0x6C8F, 0x644F, 0x5C2E, 0x4BAC, 0x3B4A, 0x3B2A, 0x3B6A, 0x43AB, 0x43EB, 0x4C4C, 0x4C6C, 0x4C8C, 0x4C6B, 0x4408, 0x3BC6, 0x3BC6, 0x3BE6, 0x4406, 0x4C07, 
        0x4C07, 0x5427, 0x5C48, 0x646A, 0x64AC, 0x5CCD, 0x54CE, 0x54AE, 0x4CCE, 0x54AD, 0x5C6C, 0x644A, 0x6449, 0x5C28, 0x6408, 0x5BE8, 0x5BE8, 0x5BC8, 0x53C8, 0x53A7, 0x4BA8, 0x4B88, 0x4B88, 0x4367, 0x4367, 0x3B67, 0x3B67, 0x3B68, 0x3B47, 0x3B47, 
        0x3B47, 0x3B27, 0x3327, 0x3327, 0x3307, 0x3306, 0x3306, 0x2B06, 0x2AE6, 0x32E7, 0x2AE7, 0x32C7, 0x32C7, 0x32C7, 0x32E7, 0x3AE8, 0x42CB, 0x424F, 0x6297, 0x8BBE, 0x8BBE, 0x83BE, 0x83DE, 0x83BE, 0x83BE, 0x7BBE, 0x7BBE, 0x739E, 0x737E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x5AFE, 0x52BE, 0x4A7D, 0x425D, 0x423D, 0x421D, 0x39FD, 0x41FE, 0x41FD, 0x4A1D, 0x6B5E, 0x7BBE, 0x7BBE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x6BFE, 0x6BFE, 0x6BFE, 0x6BDE, 0x6BDE, 
        0x63BE, 0x63BE, 0x63BE, 0x639E, 0x5B9E, 0x639E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x5B3E, 0x531E, 0x52DE, 0x52BE, 0x4ABE, 0x4A9E, 0x427D, 0x423D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A3D, 0x427D, 0x52DD, 0x6B3E, 0x739E, 0x73BE, 0x6B7E, 0x633E, 0x635E, 
        0x6B5D, 0x6B5D, 0x6B3D, 0x633D, 0x631D, 0x633D, 0x635D, 0x6B5E, 0x6B5E, 0x631D, 0x52BD, 0x4ABE, 0x425D, 0x29BD, 0x29BD, 0x21BD, 0x21BD, 0x21BD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29BD, 0x3A1D, 0x5B1E, 0x6BBE, 0x73FE, 0x7C1E, 0x841E, 0x83FE, 
        0x841E, 0x841E, 0x841E, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BBE, 0x739E, 0x737E, 0x6B5E, 0x6B3E, 0x631E, 0x62FE, 0x5ADE, 0x529D, 0x4A5D, 0x3A3E, 0x31DD, 0x29BD, 0x297D, 0x297D, 0x319D, 0x39FD, 
        0x52BE, 0x631E, 0x733E, 0x737E, 0x7B9E, 0x839E, 0x83BE, 0x8BDE, 0x8C1E, 0x9C9E, 0xA4DF, 0x9CFE, 0x8C9E, 0x5B5D, 0x42DE, 0x3ADD, 0x3ADD, 0x3AFD, 0x3B1E, 0x431E, 0x433E, 0x4B3E, 0x4B3E, 0x4B5E, 0x4B5E, 0x4B5E, 0x4B5E, 0x535E, 0x535E, 0x537E, 
        0x5B9E, 0x639E, 0x639E, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x4AFD, 0x3ABD, 0x3ABD, 0x32DD, 0x3ADD, 0x3ADD, 0x3ADD, 0x42FE, 0x3AFD, 0x3AFD, 0x42FE, 0x42FD, 0x42FD, 0x42FD, 0x42FD, 0x431E, 0x431D, 0x433D, 0x433D, 0x4B3D, 0x4B3D, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x63BE, 0x6BFE, 0x743E, 0x745C, 0x6CB6, 0x6D13, 0x7533, 0x6D13, 0x7513, 0x7D12, 0x74B0, 0x5BCD, 0x42E9, 0x3268, 0x3A68, 0x5B4C, 0x8492, 0x94F2, 0x9CB2, 0x9C91, 0xA492, 0xA472, 0xA473, 0xACB3, 0xAD33, 0xA573, 0x746E, 0x4328, 
        0x2A85, 0x22A5, 0x22C5, 0x22C5, 0x22E5, 0x1B05, 0x2306, 0x2346, 0x2366, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2346, 0x2346, 0x2326, 0x2305, 0x22E5, 0x22E5, 0x1AC5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1284, 0x1265, 0x1244, 0x1224, 0x1224, 0x1224, 
        0x1224, 0x1A44, 0x1A44, 0x1A45, 0x1A65, 0x1A65, 0x1A85, 0x1A85, 0x22A5, 0x22A5, 0x22C6, 0x22E6, 0x2306, 0x2B06, 0x2B26, 0x2B46, 0x2B66, 0x3386, 0x33A6, 0x33C7, 0x3BC7, 0x3BE7, 0x4407, 0x4407, 0x4407, 0x4407, 0x4C28, 0x4C28, 0x4C48, 0x4C48, 
        0x5448, 0x5448, 0x5469, 0x5469, 0x5469, 0x5469, 0x5449, 0x5449, 0x5429, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x43E8, 0x43E8, 0x43C8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x43A8, 0x43A9, 0x43C9, 0x4BC9, 0x4BE9, 0x4BE9,
  0x5BA9, 0x5BEA, 0x646C, 0x64AD, 0x752E, 0x6D2E, 0x6D2E, 0x6D2D, 0x6D4D, 0x6D4D, 0x756D, 0x7D6D, 0x856E, 0x8D8E, 0x958E, 0x958E, 0x9DAE, 0x9DAF, 0x9DAF, 0xA5F0, 0x9DCF, 0x9DAF, 0x95AE, 0x8D8E, 0x856E, 0x854E, 0x7D0E, 0x74AE, 0x8551, 0x7D31, 0x648F, 
        0x6CB0, 0x642F, 0x74B3, 0x7C94, 0x7C53, 0x7C53, 0x7C11, 0x5B2C, 0x42A8, 0x4AE8, 0x5369, 0x42E7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3B27, 0x3B27, 0x3B27, 0x3B27, 0x3B27, 0x3327, 0x3347, 0x3346, 0x3366, 0x3366, 0x2B66, 
        0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x3366, 0x3386, 0x3386, 0x3B86, 0x3B86, 0x4386, 0x4386, 0x4386, 0x4B86, 0x4BA7, 0x4BA7, 0x4BC7, 0x4BC7, 0x4BC7, 0x53C7, 0x53C7, 0x53C7, 0x4BC7, 0x4BA7, 0x43A7, 0x43A7, 0x4BA7, 0x43A7, 0x4B87, 0x4B87, 
        0x4B88, 0x5368, 0x5369, 0x5B6A, 0x6BAC, 0x7BCD, 0x840E, 0x842F, 0x844F, 0x7C70, 0x748F, 0x6C8F, 0x646F, 0x5C2E, 0x53CD, 0x436B, 0x3B2A, 0x3B4A, 0x438B, 0x43EB, 0x442B, 0x4C6C, 0x548C, 0x548B, 0x4C29, 0x3BE7, 0x3BC6, 0x43E6, 0x4BE7, 0x4C07, 
        0x5427, 0x5C28, 0x5C69, 0x648B, 0x6CAD, 0x5CCE, 0x54CE, 0x54CE, 0x54CE, 0x5CAD, 0x5C6B, 0x644A, 0x6449, 0x5C49, 0x5C29, 0x5C08, 0x5BE8, 0x5BC8, 0x53C8, 0x53A8, 0x4B88, 0x4B88, 0x4367, 0x4367, 0x3B67, 0x3B47, 0x3B67, 0x3B48, 0x3B48, 0x3B48, 
        0x3B47, 0x3B47, 0x3327, 0x3327, 0x3307, 0x3307, 0x3306, 0x3306, 0x32E6, 0x32E7, 0x32E7, 0x32E7, 0x32E7, 0x32E7, 0x32E8, 0x3AE8, 0x42EA, 0x428D, 0x5253, 0x83BD, 0x8BDE, 0x8BDE, 0x8BDE, 0x83DE, 0x83FE, 0x83FE, 0x83DE, 0x7BBE, 0x7B9E, 0x739E, 
        0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x5ADE, 0x529E, 0x4A7D, 0x423D, 0x423D, 0x421D, 0x39FD, 0x41FD, 0x41FD, 0x4A1D, 0x6B7E, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 
        0x639E, 0x639E, 0x639E, 0x639E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x5B5E, 0x533E, 0x531E, 0x52FE, 0x52DE, 0x4A9E, 0x4A7D, 0x4A5D, 0x423D, 0x421D, 0x423D, 0x529D, 0x631D, 0x73BE, 0x7BFE, 0x7BDE, 0x739E, 0x737D, 0x6B5D, 0x5ABD, 0x52BD, 0x52BD, 
        0x5ABD, 0x52BD, 0x529D, 0x529D, 0x529D, 0x5ABD, 0x5B1D, 0x631E, 0x5B1E, 0x52DD, 0x4A7D, 0x4A9D, 0x5B1E, 0x425D, 0x31BD, 0x299C, 0x219D, 0x219D, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 0x423D, 0x6B7F, 0x841E, 0x843E, 0x8C3E, 0x8C5E, 0x8C5E, 0x8C5E, 
        0x8C5E, 0x8C3E, 0x8C3E, 0x843E, 0x841E, 0x841E, 0x841E, 0x841E, 0x7C1E, 0x841E, 0x7BFE, 0x7BFE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x631E, 0x5ADE, 0x5ADE, 0x529D, 0x4A5D, 0x423E, 0x39FD, 0x31DD, 0x299D, 0x297D, 0x31BD, 0x527E, 
        0x631E, 0x6B3E, 0x735E, 0x7B7E, 0x7B9E, 0x83BE, 0x8BDE, 0x8BFE, 0x943E, 0x9CBE, 0xA4FF, 0x9CFE, 0x8CBE, 0x5B7D, 0x3ABD, 0x3ADD, 0x3ADD, 0x3ADD, 0x3AFE, 0x431E, 0x431E, 0x433E, 0x4B3E, 0x433D, 0x433D, 0x4B5E, 0x4B5E, 0x4B5E, 0x537D, 0x537D, 
        0x5B9E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x4B1E, 0x3A9D, 0x3A9D, 0x3ABD, 0x3ABD, 0x3ADD, 0x3ADD, 0x42FE, 0x3AFD, 0x3AFD, 0x42FE, 0x42FE, 0x431D, 0x431E, 0x431D, 0x431E, 0x433E, 0x4B3D, 0x4B3E, 0x4B5D, 0x4B5D, 0x4B5E, 0x537E, 
        0x5B7E, 0x639E, 0x63DE, 0x6BFE, 0x743E, 0x745C, 0x6C97, 0x6CF3, 0x7513, 0x7513, 0x7513, 0x7D12, 0x74B0, 0x5BAC, 0x3AC9, 0x42C9, 0x63CD, 0x84B1, 0x9CF3, 0x9CD3, 0x9C92, 0xA472, 0xAC92, 0xAC93, 0xACB3, 0xAD13, 0xAD74, 0x8CF0, 0x5BCB, 0x32A6, 
        0x2285, 0x22A5, 0x22C5, 0x22E5, 0x22E5, 0x1B05, 0x2305, 0x2325, 0x2345, 0x2366, 0x2B66, 0x2B66, 0x2366, 0x2B46, 0x2346, 0x2326, 0x2326, 0x2305, 0x2305, 0x22E5, 0x1AC5, 0x22C5, 0x1AA5, 0x1AA5, 0x1A85, 0x1A64, 0x1244, 0x1224, 0x1224, 0x1224, 
        0x1224, 0x1A44, 0x1A44, 0x1A44, 0x1A65, 0x1A65, 0x1A85, 0x2285, 0x22A5, 0x22C5, 0x22E6, 0x2AE6, 0x2B06, 0x2B26, 0x3346, 0x3366, 0x3386, 0x3BA7, 0x3BC7, 0x3BC7, 0x3BE7, 0x4407, 0x4408, 0x4427, 0x4C28, 0x4C28, 0x5448, 0x5448, 0x5448, 0x5468, 
        0x5469, 0x5469, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C49, 0x5449, 0x5429, 0x5429, 0x4C29, 0x4C29, 0x4C09, 0x43E8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x43A8, 0x43C9, 0x43C9, 0x4BE9, 0x4BE9, 0x540A,
  0x5BA8, 0x5BA9, 0x6C2C, 0x644D, 0x6CCE, 0x752E, 0x6D2E, 0x652D, 0x6D2D, 0x6D4D, 0x756D, 0x7D6D, 0x856D, 0x8D6E, 0x8D8E, 0x958E, 0x9DAE, 0x9DAE, 0x9DAF, 0x9DAE, 0x9D8E, 0x9DAF, 0x958E, 0x8D8E, 0x8D6E, 0x854E, 0x7CEE, 0x7CCF, 0x8D51, 0x8D72, 0x7D31, 
        0x74F1, 0x6C71, 0x74B2, 0x7C93, 0x7432, 0x8474, 0x7C32, 0x73AF, 0x94F1, 0x7C6E, 0x63AA, 0x42E7, 0x42C7, 0x3AE7, 0x3AE7, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3B27, 0x3B27, 0x3B27, 0x3B47, 0x3B47, 0x3B67, 0x3367, 0x3367, 0x3367, 0x3366, 
        0x3366, 0x3366, 0x3366, 0x3366, 0x3386, 0x3386, 0x3386, 0x3B86, 0x3B86, 0x3BA6, 0x4386, 0x43A6, 0x43A6, 0x43A6, 0x4BA6, 0x43A6, 0x4BA7, 0x4BA7, 0x4BC7, 0x4BC7, 0x4BC7, 0x4BC7, 0x4BA7, 0x43A7, 0x4386, 0x4386, 0x4386, 0x3B66, 0x4366, 0x4367, 
        0x4367, 0x4367, 0x4B68, 0x5349, 0x5B4A, 0x6B6B, 0x73AD, 0x840E, 0x844F, 0x846F, 0x7C8F, 0x7490, 0x6C6F, 0x644F, 0x540E, 0x438C, 0x3B2A, 0x3B2A, 0x436B, 0x43CB, 0x4BEB, 0x4C4C, 0x546C, 0x548C, 0x4C6B, 0x4408, 0x3BC6, 0x43E6, 0x4C07, 0x4C07, 
        0x5428, 0x5C29, 0x5C6A, 0x648C, 0x6CAD, 0x5CCE, 0x5CCE, 0x54CE, 0x54ED, 0x5CAC, 0x5C8B, 0x646A, 0x6449, 0x5C49, 0x5C29, 0x5C08, 0x53E8, 0x53C8, 0x53C8, 0x4BA8, 0x4B88, 0x4368, 0x4347, 0x3B47, 0x3B47, 0x3B47, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 
        0x3B47, 0x3B47, 0x3327, 0x3327, 0x3327, 0x3327, 0x3307, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x32E7, 0x3AE7, 0x3AE8, 0x3AE8, 0x3AE7, 0x42E9, 0x428C, 0x4210, 0x7B5B, 0x8BDE, 0x8BDE, 0x8BFE, 0x8BFE, 0x8BDE, 0x8BDE, 0x8BFE, 0x8C1F, 0x8C1F, 0x7BBE, 
        0x739D, 0x6B7D, 0x6B7E, 0x6B5E, 0x633E, 0x633E, 0x5B1E, 0x52FE, 0x4ABD, 0x4A7D, 0x423D, 0x421D, 0x3A1D, 0x421D, 0x41FD, 0x41FD, 0x4A3D, 0x737E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BDE, 0x6BBE, 
        0x639E, 0x639E, 0x637E, 0x637E, 0x5B5E, 0x535E, 0x5B5E, 0x533E, 0x533E, 0x531E, 0x52FD, 0x52DE, 0x52BE, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A3D, 0x5ABD, 0x6B7E, 0x83FE, 0x8C3F, 0x7BDE, 0x6B5D, 0x62BD, 0x523C, 0x527C, 0x6B3E, 0x4A3C, 0x41FD, 0x39FD, 
        0x41FD, 0x421D, 0x421D, 0x4A3D, 0x4A3D, 0x527D, 0x52BE, 0x5ABE, 0x52BD, 0x4A5D, 0x421D, 0x421C, 0x5AFD, 0x633E, 0x5AFE, 0x52BD, 0x4A9D, 0x4A5D, 0x421D, 0x39FD, 0x39BD, 0x41FC, 0x739E, 0x8C3F, 0x945E, 0x947E, 0x947E, 0x947E, 0x947E, 0x947E, 
        0x947E, 0x947E, 0x8C7E, 0x8C7E, 0x8C5E, 0x8C5E, 0x843E, 0x843E, 0x841E, 0x7C1E, 0x7BFE, 0x7BDE, 0x73DE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x633E, 0x5B1E, 0x5ADE, 0x52BE, 0x4A7E, 0x4A5E, 0x423D, 0x421D, 0x39FD, 0x31BD, 0x297C, 0x4A3E, 0x631E, 
        0x6B3E, 0x735E, 0x7B7E, 0x7B7E, 0x7B9E, 0x83BE, 0x83DE, 0x8C1E, 0x949E, 0x9CFF, 0xA51E, 0x9D1E, 0x8CDE, 0x63BE, 0x3ABD, 0x3ADD, 0x3ADD, 0x3ADD, 0x3AFE, 0x3B1D, 0x431D, 0x431D, 0x433D, 0x433E, 0x433E, 0x4B5E, 0x4B5E, 0x4B5E, 0x4B5D, 0x537E, 
        0x537E, 0x5B9E, 0x5B9E, 0x639E, 0x63BE, 0x63BE, 0x639E, 0x531E, 0x429E, 0x3ABD, 0x3ABD, 0x3ADD, 0x3ADE, 0x3ADE, 0x42FE, 0x42FE, 0x42FE, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431E, 0x431E, 0x4B3E, 0x4B3E, 0x4B5E, 0x4B5D, 0x4B5D, 0x537E, 0x5B7E, 
        0x5B9E, 0x63BE, 0x6BDE, 0x6BFE, 0x743E, 0x743D, 0x6457, 0x64B3, 0x74F4, 0x7513, 0x7512, 0x7CF1, 0x6C6F, 0x536B, 0x3AC8, 0x5BAC, 0x84D1, 0x9513, 0xA4F3, 0x9CD3, 0xA472, 0xAC73, 0xAC73, 0xACB3, 0xACF3, 0xAD73, 0x9D52, 0x6C2D, 0x3B08, 0x2A85, 
        0x22A5, 0x22A5, 0x22C5, 0x22E5, 0x22E5, 0x2305, 0x2325, 0x2325, 0x2345, 0x2365, 0x2365, 0x2365, 0x2365, 0x2B46, 0x2345, 0x2325, 0x2325, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22C5, 0x1AA5, 0x1AA5, 0x1A85, 0x1A65, 0x1244, 0x1244, 0x1224, 0x1224, 
        0x1224, 0x1A44, 0x1A44, 0x1A44, 0x1A65, 0x1A65, 0x1A85, 0x22A5, 0x22C5, 0x22C5, 0x2AE6, 0x2B06, 0x2B26, 0x3346, 0x3366, 0x3387, 0x3BA7, 0x3BC7, 0x3BE7, 0x43E7, 0x4407, 0x4408, 0x4C28, 0x4C28, 0x4C48, 0x5448, 0x5448, 0x5C69, 0x5C69, 0x5C69, 
        0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x5C49, 0x5C49, 0x5429, 0x5429, 0x5429, 0x5409, 0x4C09, 0x4BE9, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x43C9, 0x4BC9, 0x4BE9, 0x4C09, 0x5409,
  0x5BA8, 0x5B89, 0x5BAA, 0x642C, 0x648D, 0x750F, 0x6D2E, 0x6D0D, 0x6D2D, 0x6D4D, 0x754D, 0x7D4D, 0x7D4D, 0x856E, 0x8D8E, 0x958E, 0x9D8E, 0x9DAE, 0x9DAE, 0x9DAE, 0x9D8E, 0x9D8E, 0x958E, 0x958E, 0x8D6E, 0x854E, 0x8D6F, 0x8D50, 0x8D51, 0x8D72, 0x8552, 
        0x7D12, 0x74F2, 0x74B2, 0x7492, 0x84B4, 0x8CB5, 0x8C74, 0x8431, 0x740F, 0x5309, 0x5B49, 0x42E7, 0x42E7, 0x3B07, 0x3B07, 0x3B07, 0x3B07, 0x3B27, 0x3B27, 0x3B27, 0x3B27, 0x3B47, 0x3B47, 0x3B67, 0x3B67, 0x3B67, 0x3387, 0x3B87, 0x3B67, 0x3386, 
        0x3386, 0x3366, 0x3366, 0x3366, 0x3386, 0x3386, 0x3386, 0x3BA6, 0x3B86, 0x3BA6, 0x4386, 0x43A6, 0x43A6, 0x43A6, 0x43A7, 0x43A7, 0x43A7, 0x4BA7, 0x4BA7, 0x4BA7, 0x4BA7, 0x4BA7, 0x43A7, 0x4387, 0x3B86, 0x3B66, 0x3B66, 0x3366, 0x3346, 0x3346, 
        0x3B66, 0x3B46, 0x4347, 0x4327, 0x4B28, 0x5B29, 0x6B4B, 0x73AD, 0x840E, 0x846F, 0x7C8F, 0x7C90, 0x6C90, 0x644F, 0x5C2E, 0x4BCD, 0x3B4B, 0x3B2A, 0x3B4A, 0x43AB, 0x43EB, 0x4C2C, 0x546C, 0x548C, 0x548B, 0x4429, 0x43C7, 0x43E7, 0x4C07, 0x5408, 
        0x5448, 0x5C49, 0x646A, 0x648C, 0x648D, 0x5CCE, 0x54EE, 0x54EE, 0x5CED, 0x5CCC, 0x64AB, 0x648B, 0x646A, 0x5C6A, 0x5C4A, 0x5C29, 0x5409, 0x53C8, 0x4BC8, 0x4BA8, 0x4B88, 0x4368, 0x4347, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B48, 0x3B48, 0x3B48, 
        0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3327, 0x3327, 0x3307, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x3AE8, 0x3AE8, 0x3AC8, 0x430A, 0x6BEF, 0x636E, 0x73F2, 0x8418, 0x8BBD, 0x93BE, 0x93BE, 0x8BBE, 0x8B9E, 0x8B9E, 0x837D, 0x837D, 0x8BBE, 0x93FE, 0x943F, 
        0x841E, 0x7BBE, 0x737D, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x5AFE, 0x52BD, 0x4A7D, 0x423D, 0x421D, 0x3A1D, 0x421D, 0x41FD, 0x41FD, 0x4A3D, 0x737E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x63BE, 
        0x639E, 0x639E, 0x5B7E, 0x5B7E, 0x535E, 0x535E, 0x533E, 0x533E, 0x531E, 0x4AFD, 0x4ADD, 0x4ABD, 0x4A9D, 0x4A5D, 0x4A5D, 0x4A9D, 0x633E, 0x7BDE, 0x83FE, 0x83DE, 0x737D, 0x5ABD, 0x523C, 0x41DD, 0x419D, 0x41FC, 0x6B5E, 0x5A9D, 0x39BC, 0x31BD, 
        0x39DD, 0x39FD, 0x39FD, 0x41FD, 0x421D, 0x423D, 0x423D, 0x423D, 0x423D, 0x421D, 0x39FD, 0x41DD, 0x4A5D, 0x633D, 0x6B5E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737F, 0x6B5E, 0x7BDF, 0x8C7E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x949E, 0x949E, 0x947E, 0x8C5E, 0x8C5E, 0x8C5E, 0x845E, 0x843E, 0x841E, 0x7C1E, 0x7BFE, 0x7BDE, 0x73BE, 0x6B9E, 0x6B7E, 0x635E, 0x631E, 0x631E, 0x5AFE, 0x52DE, 0x52BD, 0x4A7D, 0x4A5E, 0x423D, 0x421D, 0x3A1D, 0x39FD, 0x421D, 0x5ADE, 0x6B3E, 
        0x735E, 0x7B7E, 0x7B9E, 0x7B9E, 0x7BBE, 0x83DE, 0x8BFE, 0x8C5E, 0x9CBE, 0xA51F, 0xA51F, 0x9D1F, 0x94FF, 0x6BFE, 0x42BD, 0x3ABD, 0x3ADD, 0x3ADD, 0x3AFD, 0x3B1E, 0x3B1E, 0x431D, 0x433E, 0x433E, 0x433E, 0x433E, 0x4B5E, 0x4B5E, 0x4B5E, 0x537E, 
        0x537E, 0x5B9E, 0x5B9E, 0x639E, 0x63BE, 0x63BE, 0x639E, 0x531E, 0x429D, 0x3ABD, 0x3ABD, 0x3ADD, 0x3ADE, 0x3ADE, 0x42FE, 0x42FE, 0x42FE, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431E, 0x433E, 0x4B3E, 0x4B3E, 0x4B5E, 0x4B5E, 0x4B5D, 0x537E, 0x5B9E, 
        0x5B9E, 0x63BE, 0x6BDE, 0x73FE, 0x741E, 0x743D, 0x6C18, 0x6473, 0x74B4, 0x74F3, 0x7CF2, 0x7CD1, 0x640E, 0x42E9, 0x42E9, 0x744F, 0x94F2, 0x9CF2, 0x9CD3, 0x9C72, 0xA472, 0xAC73, 0xACB3, 0xAD13, 0xAD53, 0xA593, 0x84D0, 0x5369, 0x2AA6, 0x2AA5, 
        0x2AA5, 0x22A5, 0x22C5, 0x22C5, 0x22E5, 0x2305, 0x2305, 0x2325, 0x2345, 0x2365, 0x2365, 0x2365, 0x2365, 0x2345, 0x2325, 0x2325, 0x2305, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22C5, 0x1AC5, 0x1AA5, 0x1A85, 0x1A65, 0x1A44, 0x1244, 0x1224, 0x1224, 
        0x1224, 0x1A44, 0x1A44, 0x1A44, 0x1A65, 0x1A65, 0x1A85, 0x22A5, 0x22C5, 0x22E5, 0x2B06, 0x2B26, 0x3326, 0x3346, 0x3B66, 0x3BA7, 0x3BA7, 0x43C7, 0x43E7, 0x43E7, 0x4C08, 0x4C28, 0x5448, 0x5448, 0x5448, 0x5C69, 0x5C69, 0x5C69, 0x6469, 0x6469, 
        0x6489, 0x6469, 0x6469, 0x6489, 0x6489, 0x5C69, 0x5C69, 0x5C49, 0x5C49, 0x5429, 0x5429, 0x5429, 0x5409, 0x4C09, 0x4BE9, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x43C9, 0x4BC9, 0x4BE9, 0x4C09, 0x5409,
  0x5BA8, 0x5388, 0x5369, 0x640B, 0x646D, 0x6CEE, 0x752F, 0x6D0E, 0x6D2D, 0x6D2D, 0x6D4D, 0x7D4D, 0x7D4D, 0x856D, 0x8D8E, 0x958E, 0x958E, 0x9DAE, 0x9DAE, 0x9D8E, 0x958E, 0x958E, 0x958E, 0x958E, 0x8D6E, 0x8D6E, 0x8D4F, 0x8D30, 0x9551, 0x9551, 0x8D52, 
        0x8531, 0x7D11, 0x7D12, 0x7CD2, 0x7CB3, 0x84B4, 0x8C94, 0x8452, 0x636D, 0x52E9, 0x5B49, 0x4B07, 0x4307, 0x4307, 0x4307, 0x4327, 0x4327, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B87, 0x3B87, 0x3B87, 0x3B86, 
        0x3B86, 0x3B86, 0x3366, 0x3366, 0x3386, 0x3386, 0x3B86, 0x3BA6, 0x3BA6, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A6, 0x43A7, 0x43A7, 0x43A7, 0x4BA7, 0x4BA7, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x3B87, 0x3B66, 0x3B66, 0x3346, 0x3346, 0x3325, 0x3345, 
        0x3345, 0x3346, 0x3B46, 0x3B26, 0x4327, 0x4B08, 0x5309, 0x5B4A, 0x6BAC, 0x7C2E, 0x7C6F, 0x7C8F, 0x7490, 0x6C6F, 0x5C4F, 0x53EE, 0x438B, 0x3B2A, 0x3B4A, 0x43AB, 0x43EB, 0x4C2B, 0x4C6C, 0x548C, 0x548C, 0x4C4A, 0x43E8, 0x4C07, 0x4C07, 0x5428, 
        0x5449, 0x5C6A, 0x648B, 0x648C, 0x64AD, 0x54CE, 0x54EE, 0x550E, 0x5D2E, 0x5CED, 0x64CC, 0x64AB, 0x648A, 0x5C8A, 0x5C6A, 0x5449, 0x5429, 0x5409, 0x4BC9, 0x4BA8, 0x4388, 0x4368, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B48, 0x3B48, 
        0x3B48, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B27, 0x3B07, 0x3AE7, 0x3AE7, 0x3AC8, 0x3AC8, 0x3AC9, 0x534C, 0x7431, 0x8CD6, 0x94F8, 0x94B9, 0x9479, 0x941B, 0x8B9D, 0x8B7D, 0x835E, 0x835D, 0x833D, 0x833D, 0x833D, 0x833D, 0x833D, 0x833D, 0x837C, 
        0x8BDE, 0x8BFE, 0x83DE, 0x739E, 0x6B5D, 0x631E, 0x5AFE, 0x5AFE, 0x52BD, 0x4A7D, 0x423D, 0x421D, 0x3A1D, 0x421D, 0x41FD, 0x41FD, 0x523D, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x6BDE, 0x6BDE, 0x6BBE, 0x63BE, 0x63BD, 0x639E, 
        0x5B9E, 0x5B7E, 0x5B7E, 0x5B5E, 0x535E, 0x533E, 0x531E, 0x4B1E, 0x4AFE, 0x4ADD, 0x4ABD, 0x4A9D, 0x4A5D, 0x4A5D, 0x52BE, 0x6B5E, 0x6B7D, 0x6B5D, 0x6B1D, 0x62DD, 0x525D, 0x41FD, 0x399D, 0x317D, 0x315D, 0x41DC, 0x6B7E, 0x6B3E, 0x41DC, 0x299D, 
        0x299D, 0x299D, 0x31BD, 0x31BD, 0x31BD, 0x39DD, 0x39DD, 0x31DD, 0x31DD, 0x31BD, 0x399D, 0x399D, 0x41BD, 0x62BD, 0x733E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7BBE, 0x7BBE, 0x83DE, 0x947F, 0x9CDE, 0x9CBF, 0x9C9E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x949E, 0x947E, 0x947E, 0x8C5E, 0x8C5E, 0x8C5E, 0x843E, 0x843E, 0x841E, 0x7BFE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x635E, 0x633E, 0x631E, 0x5AFE, 0x5AFE, 0x52BD, 0x4A9D, 0x4A7D, 0x425D, 0x425E, 0x423D, 0x423D, 0x4A5D, 0x62DE, 0x6B3E, 0x735E, 
        0x737E, 0x7B9E, 0x7BBE, 0x83BE, 0x83DE, 0x83FE, 0x8C1E, 0x947E, 0x9CDE, 0x9D1E, 0xA53F, 0x9D1E, 0x9D1F, 0x7C3F, 0x42BD, 0x3ABE, 0x3ADE, 0x32DE, 0x3AFE, 0x3AFE, 0x3B1E, 0x431E, 0x433E, 0x433E, 0x433E, 0x433E, 0x435E, 0x4B5E, 0x4B5E, 0x537E, 
        0x537E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x533E, 0x42BD, 0x3ABD, 0x3ABE, 0x3ADD, 0x3ADE, 0x3ADD, 0x42DD, 0x42FE, 0x431D, 0x431E, 0x431E, 0x431D, 0x433D, 0x433D, 0x433E, 0x4B3E, 0x4B5E, 0x4B5E, 0x4B5E, 0x4B7E, 0x539E, 0x5B9E, 
        0x5B9E, 0x63BE, 0x6BDE, 0x73FE, 0x741E, 0x743D, 0x6C18, 0x6C74, 0x7494, 0x74D3, 0x74D2, 0x74B1, 0x5BED, 0x42E9, 0x5BAC, 0x8490, 0x94D2, 0x94B2, 0x9C92, 0xA472, 0xA473, 0xAC94, 0xACD3, 0xAD53, 0xA593, 0x9551, 0x642C, 0x3AE7, 0x2AA6, 0x2AA6, 
        0x2AA6, 0x22C6, 0x22C6, 0x2AE6, 0x22E5, 0x22E5, 0x2325, 0x2325, 0x2345, 0x2345, 0x2365, 0x2365, 0x2345, 0x2B45, 0x2325, 0x2325, 0x2325, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22C5, 0x1AC5, 0x1AA5, 0x1A85, 0x1A65, 0x1A65, 0x1A45, 0x1244, 0x1A44, 
        0x1A44, 0x1A44, 0x1A44, 0x1A64, 0x1A65, 0x1A85, 0x2285, 0x22A5, 0x22C5, 0x2AE6, 0x2B06, 0x3326, 0x3347, 0x3B67, 0x3B87, 0x3BA7, 0x43C7, 0x43E7, 0x4407, 0x4C08, 0x5428, 0x5448, 0x5448, 0x5C68, 0x5C69, 0x5C69, 0x6469, 0x6469, 0x6489, 0x6C89, 
        0x6C89, 0x6489, 0x6489, 0x6469, 0x6469, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5429, 0x5429, 0x5409, 0x4C09, 0x4BE8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BC8, 0x43C9, 0x43C9, 0x4BE9, 0x4C09, 0x5409,
  0x5BA8, 0x5388, 0x5368, 0x5BCA, 0x6C4D, 0x6CCE, 0x750F, 0x6D0E, 0x6D2E, 0x6D2D, 0x6D4D, 0x754D, 0x7D4D, 0x7D4D, 0x856D, 0x8D6E, 0x958E, 0x9DAE, 0x9DAE, 0x9D8E, 0x9D8E, 0x9D8E, 0x958E, 0x958E, 0x958E, 0x954E, 0x8D2F, 0x8D0F, 0x8D30, 0x8D51, 0x8D51, 
        0x8531, 0x7CF1, 0x74D1, 0x7CF2, 0x7492, 0x8494, 0x8494, 0x8473, 0x73CF, 0x530A, 0x5B69, 0x4B08, 0x4B27, 0x4B27, 0x4327, 0x4347, 0x4347, 0x4347, 0x4347, 0x4347, 0x4347, 0x4367, 0x4367, 0x4387, 0x3B87, 0x3B87, 0x3BA7, 0x3B87, 0x3B86, 0x3B86, 
        0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3BA7, 0x4387, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x3B86, 0x3B66, 0x3346, 0x3346, 0x3326, 0x2B26, 0x3325, 0x2B25, 
        0x2B25, 0x3325, 0x3326, 0x3326, 0x3B26, 0x3B07, 0x4308, 0x5309, 0x5B6A, 0x6BCC, 0x7C4E, 0x7C8F, 0x748F, 0x748F, 0x6C6F, 0x5C2E, 0x4BAC, 0x3B2A, 0x3B4A, 0x438B, 0x43CB, 0x4C0B, 0x4C4C, 0x546C, 0x548C, 0x546A, 0x4C09, 0x4C08, 0x4C28, 0x5428, 
        0x5C69, 0x5C8A, 0x648B, 0x648C, 0x5CAD, 0x54CE, 0x550E, 0x5D2E, 0x5D2E, 0x650D, 0x64EC, 0x64CC, 0x64AB, 0x5C8B, 0x5C8A, 0x546A, 0x544A, 0x4C0A, 0x4BE9, 0x4BC9, 0x4388, 0x4388, 0x3B68, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 
        0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B27, 0x3AE7, 0x3AC7, 0x42C9, 0x532C, 0x6BF1, 0x8CB5, 0x94F8, 0x9CDA, 0x949B, 0x8BFB, 0x8BBB, 0x83BC, 0x837D, 0x835E, 0x833D, 0x833E, 0x833E, 0x7B3E, 0x7B3E, 0x833E, 0x831E, 0x831E, 0x831D, 0x7B3D, 
        0x7B3D, 0x837D, 0x8BDE, 0x83DE, 0x739E, 0x6B3D, 0x631E, 0x5ADE, 0x52BE, 0x4A7D, 0x423D, 0x3A1D, 0x3A1D, 0x39FD, 0x41FD, 0x41FD, 0x525D, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x6BDE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 
        0x5B7E, 0x5B7E, 0x5B5E, 0x533E, 0x533E, 0x531E, 0x531E, 0x4AFE, 0x4ADE, 0x4ABD, 0x429D, 0x425D, 0x423D, 0x4A7D, 0x5ADE, 0x5ADD, 0x529D, 0x4A3D, 0x49FD, 0x41DD, 0x39BD, 0x319D, 0x295D, 0x295D, 0x295D, 0x423D, 0x6B9E, 0x6B7E, 0x529E, 0x297D, 
        0x215D, 0x217D, 0x297D, 0x295D, 0x297D, 0x297D, 0x317D, 0x317D, 0x317D, 0x315D, 0x315C, 0x395C, 0x41BC, 0x629D, 0x7B3E, 0x7B7E, 0x7B7E, 0x839E, 0x83BE, 0x8BBE, 0x8BFE, 0x9C7F, 0xA49E, 0x9C9E, 0x9C7E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x949E, 0x947E, 0x947E, 0x8C5E, 0x8C5E, 0x8C5E, 0x843E, 0x841E, 0x83FE, 0x7BDE, 0x73DE, 0x73BE, 0x6B9E, 0x6B7E, 0x633E, 0x631E, 0x5AFE, 0x5AFE, 0x52DD, 0x52BD, 0x4A9D, 0x4A7D, 0x4A5D, 0x425D, 0x4A5D, 0x527D, 0x62DE, 0x6B1E, 0x735E, 0x737E, 
        0x7B7E, 0x7B9E, 0x7BBE, 0x83DE, 0x83DE, 0x8C1E, 0x8C5E, 0x94BE, 0x9D1E, 0x9D1E, 0x9D3E, 0x9D3E, 0x9D1F, 0x847E, 0x4ADD, 0x3ABE, 0x3ADE, 0x3ADE, 0x3AFE, 0x3AFE, 0x3B1E, 0x3B1E, 0x433D, 0x433D, 0x433D, 0x435E, 0x4B5E, 0x4B5E, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x533E, 0x42BD, 0x3ABE, 0x3ABE, 0x3ADE, 0x3ADE, 0x3ADD, 0x3ADD, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431D, 0x433D, 0x433D, 0x433D, 0x4B3E, 0x4B5E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 
        0x5BBE, 0x63DE, 0x6BFE, 0x741E, 0x741E, 0x743D, 0x6BF8, 0x6C74, 0x7494, 0x74B3, 0x74D2, 0x74B1, 0x5BCD, 0x536B, 0x744F, 0x8CB2, 0x94B2, 0x9C92, 0x9C72, 0xA473, 0xA493, 0xA4B4, 0xA514, 0xA573, 0x9D92, 0x7CCF, 0x4BAA, 0x32C7, 0x32C6, 0x2AC6, 
        0x2AC6, 0x2AC6, 0x2AC6, 0x2AE6, 0x2AE6, 0x2305, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2325, 0x2326, 0x2326, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22E5, 0x22C5, 0x1AA5, 0x1AA5, 0x1A85, 0x1A85, 0x1A85, 0x1A65, 0x1A44, 
        0x1A44, 0x1A44, 0x1A44, 0x1A64, 0x1A65, 0x1A85, 0x1A85, 0x22C5, 0x22E6, 0x2B06, 0x3326, 0x3347, 0x3B67, 0x3B87, 0x43A7, 0x43C7, 0x43E8, 0x4C08, 0x4C28, 0x5428, 0x5448, 0x5448, 0x5C69, 0x5C69, 0x5C69, 0x6489, 0x6489, 0x6C89, 0x6C89, 0x6C8A, 
        0x6C8A, 0x6C89, 0x6489, 0x648A, 0x648A, 0x646A, 0x6469, 0x6449, 0x5C49, 0x5C29, 0x5C29, 0x5409, 0x5409, 0x4C09, 0x4BE8, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3BC8, 0x43C9, 0x4BC9, 0x4BE9, 0x5409, 0x5409,
  0x53A8, 0x5387, 0x5388, 0x5368, 0x640B, 0x646D, 0x6CEE, 0x750E, 0x6D2E, 0x752D, 0x6D4D, 0x752D, 0x752D, 0x7D4D, 0x854D, 0x8D6D, 0x956E, 0x9D8E, 0x9DAF, 0x9D8E, 0x9D8E, 0x9D8E, 0x9D8E, 0x9D8E, 0x9D8F, 0x954F, 0x8D2E, 0x8D0F, 0x9530, 0x9531, 0x8D31, 
        0x8511, 0x7CD0, 0x74B0, 0x7CF2, 0x8513, 0x84D4, 0x8494, 0x8473, 0x7C31, 0x5B4B, 0x5369, 0x4B48, 0x4B48, 0x4B27, 0x4B47, 0x4347, 0x4347, 0x4347, 0x4347, 0x4347, 0x4367, 0x4387, 0x4387, 0x43A7, 0x43A7, 0x3BA7, 0x3BA7, 0x3BA7, 0x3B87, 0x3B86, 
        0x3B86, 0x3B66, 0x3B66, 0x3B86, 0x3B86, 0x3B66, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B87, 0x4387, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3B67, 0x3346, 0x3346, 0x3326, 0x3326, 0x2B05, 0x2B05, 0x2B05, 
        0x2B05, 0x2B05, 0x2B25, 0x3325, 0x3306, 0x3326, 0x3B07, 0x4307, 0x4B28, 0x5B6A, 0x6BEC, 0x744E, 0x746F, 0x748F, 0x748F, 0x644F, 0x53ED, 0x434B, 0x3B2A, 0x436B, 0x43CB, 0x4C0B, 0x4C4C, 0x548C, 0x548C, 0x548B, 0x4C49, 0x4C08, 0x4C28, 0x5449, 
        0x5C6A, 0x5C8A, 0x648B, 0x648C, 0x5CAD, 0x54CE, 0x550F, 0x5D2F, 0x654E, 0x654E, 0x650D, 0x64EC, 0x64CB, 0x5CAB, 0x5C8B, 0x548A, 0x546A, 0x4C2A, 0x4C0A, 0x43C9, 0x43A9, 0x4388, 0x4388, 0x3B68, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 
        0x3B67, 0x3B47, 0x3B47, 0x3B47, 0x3B27, 0x3AE8, 0x4AEB, 0x6BF0, 0x8CB5, 0x9CD9, 0x947A, 0x941B, 0x8BDB, 0x8BBB, 0x839C, 0x837D, 0x837D, 0x835E, 0x835E, 0x835E, 0x835E, 0x833E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B1E, 0x7B1E, 0x7B1E, 0x7B1E, 0x7B1D, 
        0x7B1D, 0x7B3D, 0x7B1D, 0x839E, 0x83DF, 0x7B7E, 0x6B3D, 0x62FD, 0x529D, 0x4A5E, 0x423D, 0x3A1D, 0x39FD, 0x39FD, 0x41FD, 0x41DD, 0x525D, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6B9E, 0x639E, 0x639E, 
        0x5B7E, 0x5B5E, 0x535D, 0x533D, 0x4B1D, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ABE, 0x4A9E, 0x425D, 0x423D, 0x4A3D, 0x5ABE, 0x5AFD, 0x4A5D, 0x41FD, 0x39DD, 0x39BD, 0x319D, 0x317D, 0x297D, 0x295D, 0x215D, 0x295D, 0x4A9D, 0x6B9E, 0x6B7E, 0x5B1E, 0x39DD, 
        0x213D, 0x215D, 0x193D, 0x213D, 0x213D, 0x213D, 0x295D, 0x293D, 0x315C, 0x41DD, 0x5A7D, 0x737E, 0x8C1F, 0x945F, 0x9C7F, 0x93FE, 0x835E, 0x837E, 0x837E, 0x8B9E, 0x93FE, 0x9C5E, 0xA47E, 0x9C7E, 0x9C7E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x947E, 0x947E, 0x8C7E, 0x8C5E, 0x8C5E, 0x843E, 0x841E, 0x83FE, 0x7BDE, 0x73DE, 0x73BE, 0x6B9E, 0x637E, 0x635E, 0x633E, 0x5B1E, 0x5AFE, 0x52DE, 0x4ABD, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A5D, 0x4A5D, 0x529E, 0x62FE, 0x6B3E, 0x6B5E, 0x735E, 0x7B7E, 
        0x7B9E, 0x83BE, 0x83DE, 0x83DE, 0x83FE, 0x8C3E, 0x949E, 0x9CFF, 0xA51E, 0xA51E, 0xA53E, 0xA53E, 0x9D3E, 0x84DE, 0x4B1D, 0x3ABE, 0x3ADE, 0x32DE, 0x32DD, 0x3AFD, 0x3B1D, 0x3B1E, 0x3B3D, 0x3B3D, 0x433D, 0x435E, 0x4B5E, 0x435E, 0x4B5E, 0x4B7E, 
        0x537E, 0x539E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x63BE, 0x533E, 0x42BD, 0x3ABD, 0x3ABE, 0x3ABD, 0x3ADD, 0x3ADE, 0x3ADE, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431D, 0x433D, 0x433D, 0x433D, 0x4B5E, 0x4B5E, 0x4B5E, 0x537E, 0x537E, 0x539E, 0x5BBE, 
        0x5BBE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x741C, 0x6C18, 0x7494, 0x74B4, 0x74B3, 0x7CD3, 0x74B1, 0x640E, 0x640E, 0x8491, 0x8CB2, 0x94B2, 0x9C72, 0xA473, 0xA494, 0xA4B4, 0x9CF3, 0x9D53, 0x9D93, 0x8D30, 0x642C, 0x4348, 0x32E7, 0x32E7, 0x32E6, 
        0x32E6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2B05, 0x2B05, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2346, 0x2326, 0x2326, 0x2305, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22C5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1A85, 0x1A85, 0x1A65, 
        0x1A65, 0x1A65, 0x1A65, 0x1A64, 0x1A85, 0x1A85, 0x22A5, 0x22C5, 0x22E6, 0x2B06, 0x3326, 0x3B47, 0x3B87, 0x43A7, 0x43C7, 0x4BC7, 0x4BE8, 0x4C08, 0x5428, 0x5448, 0x5448, 0x5C69, 0x5C69, 0x5C69, 0x6489, 0x6489, 0x6489, 0x6CAA, 0x6CAA, 0x6C8A, 
        0x6C8A, 0x6C8A, 0x6489, 0x648A, 0x648A, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5C09, 0x5409, 0x5409, 0x4C09, 0x4BE8, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x33A8, 0x33A8, 0x33A8, 0x3BA8, 0x3BC8, 0x3BC8, 0x4BE8, 0x4BE9, 0x5409, 0x5429,
  0x53A8, 0x5387, 0x5388, 0x5368, 0x53AA, 0x6C6D, 0x646D, 0x6CEE, 0x752E, 0x752E, 0x6D2D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x854D, 0x8D6E, 0x958E, 0x9DAF, 0x9DAF, 0xA58E, 0xA58E, 0x9D8E, 0x9D8F, 0x9D6F, 0x9D4F, 0x950F, 0x950F, 0x9530, 0x9550, 0x8D30, 
        0x84F0, 0x84D0, 0x7CD1, 0x7CF2, 0x8513, 0x84D4, 0x8494, 0x8494, 0x8472, 0x6BCD, 0x5369, 0x5348, 0x5368, 0x4B68, 0x4B67, 0x4B67, 0x4367, 0x4B87, 0x4B87, 0x4B88, 0x4B88, 0x4BA8, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x3B86, 
        0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B65, 0x3B66, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B87, 0x3B87, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x3B87, 0x4387, 0x3B67, 0x3B67, 0x3B67, 0x3346, 0x3346, 0x3326, 0x3306, 0x3306, 0x2B05, 0x2AE5, 0x2B05, 
        0x2B05, 0x2B05, 0x2B05, 0x2B25, 0x3326, 0x3326, 0x3306, 0x3B06, 0x3B07, 0x4B28, 0x536A, 0x63CC, 0x742E, 0x746F, 0x748F, 0x6C8F, 0x5C2E, 0x4B8C, 0x432A, 0x434A, 0x43AB, 0x4BEB, 0x4C2C, 0x4C6C, 0x54AC, 0x5CCC, 0x548B, 0x4C49, 0x5449, 0x544A, 
        0x5C8A, 0x5C8B, 0x648C, 0x5CAD, 0x5CAD, 0x54EE, 0x5D2F, 0x5D6F, 0x658F, 0x656E, 0x654D, 0x650C, 0x64EC, 0x5CCB, 0x5CAB, 0x54AB, 0x548B, 0x4C6A, 0x4C2A, 0x440A, 0x43EA, 0x43A9, 0x4388, 0x3B88, 0x3B68, 0x3B68, 0x3B68, 0x3B67, 0x3B67, 0x4368, 
        0x4367, 0x3B47, 0x3B47, 0x3B27, 0x3AE8, 0x638F, 0x8C96, 0x9499, 0x8C3A, 0x8BDB, 0x8BBC, 0x8B7D, 0x835D, 0x835D, 0x835E, 0x835E, 0x7B3E, 0x7B3E, 0x7B3E, 0x835E, 0x835E, 0x7B5E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B3E, 0x731E, 0x7B1E, 
        0x7B1E, 0x7B1E, 0x7B1D, 0x7B3D, 0x7B7D, 0x8BDE, 0x839E, 0x6B1D, 0x5ABD, 0x527D, 0x423D, 0x421D, 0x39FD, 0x39FD, 0x41FD, 0x41DD, 0x525D, 0x737E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 
        0x5B5E, 0x5B5E, 0x533E, 0x533D, 0x4B1D, 0x4ADE, 0x4ADE, 0x42BE, 0x429D, 0x425E, 0x423D, 0x421D, 0x4A3D, 0x6B7E, 0x6B9E, 0x631D, 0x52BD, 0x4A5D, 0x39FD, 0x39DD, 0x31BD, 0x299D, 0x217D, 0x217D, 0x297D, 0x4A7D, 0x6B7E, 0x6B7E, 0x5B3D, 0x427D, 
        0x213C, 0x191D, 0x191D, 0x191D, 0x191D, 0x211C, 0x297C, 0x525E, 0x6B7E, 0x7BDE, 0x945E, 0x9C9F, 0xA4DF, 0xA4FE, 0xACDE, 0xA47E, 0x835D, 0x833E, 0x833D, 0x7B3D, 0x93FE, 0xA49F, 0xA49F, 0x9C9E, 0x9C9E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x947E, 0x947E, 0x8C5E, 0x8C5E, 0x843E, 0x841E, 0x7C1E, 0x7BFE, 0x73DE, 0x73BE, 0x6B9E, 0x6B7E, 0x635E, 0x5B3E, 0x5B1D, 0x52FD, 0x52DE, 0x4ABD, 0x4A9D, 0x4A9E, 0x4A7E, 0x4A7D, 0x4A7D, 0x52BE, 0x62FE, 0x6B1E, 0x6B3E, 0x737E, 0x7B7E, 0x7B9E, 
        0x83BE, 0x83BE, 0x83FE, 0x8BFE, 0x8C3E, 0x947E, 0x9CBE, 0xA4FF, 0xA51E, 0xA51E, 0xA53E, 0xA53E, 0x9D3E, 0x8CFE, 0x5B5D, 0x3ABE, 0x3ABE, 0x3ADE, 0x32DD, 0x3AFD, 0x3B1D, 0x3B1E, 0x3B3D, 0x3B3D, 0x433D, 0x433D, 0x435E, 0x435E, 0x4B5E, 0x4B7E, 
        0x537E, 0x5B9E, 0x5B9E, 0x63BE, 0x63BE, 0x63BE, 0x639E, 0x531E, 0x429D, 0x3A9D, 0x32BD, 0x3ABD, 0x3ADD, 0x3ADD, 0x3ADE, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431D, 0x433D, 0x433D, 0x433D, 0x4B5E, 0x4B5E, 0x4B5E, 0x4B7E, 0x537E, 0x539E, 0x5BBE, 
        0x5BDE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x743C, 0x6C37, 0x74B4, 0x74D3, 0x74D3, 0x7CF2, 0x74B1, 0x6C4F, 0x7490, 0x84B2, 0x94B3, 0x94B3, 0x9C93, 0xA4B4, 0xA4B4, 0x9CD4, 0x9D13, 0x9573, 0x8D72, 0x74AE, 0x4BC9, 0x3B27, 0x3307, 0x3307, 0x3307, 
        0x3307, 0x3306, 0x3306, 0x2B06, 0x2B05, 0x2B25, 0x2B25, 0x2325, 0x2325, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2325, 0x2326, 0x2326, 0x2305, 0x2305, 0x2305, 0x22E5, 0x22E5, 0x22E5, 0x22C5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1A85, 0x1A85, 
        0x1A65, 0x1A65, 0x1A65, 0x1A84, 0x1A85, 0x1A85, 0x22A5, 0x22C5, 0x2B06, 0x3306, 0x3347, 0x3B67, 0x4387, 0x43A7, 0x4BC7, 0x4BE8, 0x4C08, 0x5428, 0x5428, 0x5C48, 0x5C49, 0x5C69, 0x6469, 0x6489, 0x6489, 0x6489, 0x6CAA, 0x6CAA, 0x6CAA, 0x6C8A, 
        0x6C8A, 0x6C8A, 0x6C89, 0x6C8A, 0x6C8A, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5C09, 0x5409, 0x5409, 0x4BE8, 0x4BE8, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x33A8, 0x33A8, 0x33A8, 0x3BA8, 0x3BC8, 0x3BE8, 0x4BE8, 0x4BE9, 0x5409, 0x5429,
  0x53A7, 0x53A7, 0x5387, 0x5368, 0x5389, 0x642C, 0x5C0B, 0x6CAD, 0x752E, 0x752E, 0x6D2D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x854D, 0x8D4D, 0x9D8E, 0x9DAF, 0xA5AF, 0xA58F, 0xA58E, 0x9D6E, 0x9D6F, 0x9D4F, 0x9D50, 0x9D10, 0x9530, 0x9530, 0x9530, 0x9510, 
        0x8CF0, 0x84D0, 0x84D1, 0x84D1, 0x84D2, 0x84D3, 0x8494, 0x8C94, 0x8CB4, 0x7C4F, 0x5B6A, 0x5389, 0x5368, 0x5388, 0x5388, 0x4B87, 0x4B88, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC7, 0x43C7, 0x43A7, 0x43A7, 0x43A7, 0x43A7, 
        0x4386, 0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3B65, 0x3B66, 0x3B66, 0x3B66, 0x3B86, 0x3B86, 0x3B87, 0x3B87, 0x3B87, 0x3B87, 0x4387, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3367, 0x3346, 0x3346, 0x3326, 0x3306, 0x2B06, 0x2B06, 0x2AE5, 0x2AE5, 0x2B05, 
        0x2B05, 0x2B05, 0x2B05, 0x2B25, 0x2B26, 0x3326, 0x3326, 0x3326, 0x3306, 0x3B07, 0x4328, 0x538A, 0x63CC, 0x6C2E, 0x746F, 0x6C6F, 0x644E, 0x5BED, 0x436B, 0x434A, 0x438B, 0x43EB, 0x4C0C, 0x4C6C, 0x54AC, 0x5CCC, 0x5CCC, 0x548A, 0x546A, 0x548A, 
        0x5C8B, 0x5C8B, 0x5C6C, 0x5C8D, 0x5CCE, 0x550F, 0x5D4F, 0x658F, 0x6D8F, 0x6D8F, 0x6D6E, 0x652D, 0x64EC, 0x5CCC, 0x54AB, 0x54AB, 0x548B, 0x546B, 0x4C4B, 0x4C4B, 0x542B, 0x4BEA, 0x43A9, 0x4388, 0x4388, 0x3B88, 0x3B88, 0x4368, 0x4388, 0x4388, 
        0x4388, 0x4368, 0x4347, 0x3B08, 0x5B8E, 0x8C78, 0x8BFA, 0x8BBC, 0x8B9C, 0x837D, 0x833D, 0x833D, 0x833E, 0x833E, 0x7B3E, 0x7B3D, 0x7B5D, 0x7B3D, 0x7B3E, 0x7B5E, 0x7B5E, 0x7B3E, 0x7B3E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x7B1E, 
        0x7B1E, 0x7B1E, 0x7AFE, 0x7B1D, 0x7B1D, 0x7B5D, 0x8BBF, 0x839F, 0x6AFD, 0x527D, 0x4A3D, 0x421D, 0x39FD, 0x39FD, 0x41FD, 0x41DD, 0x4A1D, 0x735E, 0x739E, 0x739E, 0x739E, 0x739E, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6B9E, 0x639E, 0x637E, 0x637E, 
        0x5B5E, 0x533E, 0x533D, 0x4B1D, 0x4AFD, 0x42BE, 0x42BE, 0x429E, 0x425D, 0x423E, 0x3A1E, 0x41FD, 0x527D, 0x73BF, 0x73DE, 0x6B9E, 0x633E, 0x52DE, 0x427E, 0x3A3D, 0x31DD, 0x29BD, 0x217D, 0x217D, 0x299D, 0x4A5D, 0x6B5E, 0x635E, 0x633D, 0x4ADE, 
        0x297D, 0x191D, 0x18FD, 0x18FC, 0x295C, 0x423D, 0x635F, 0x73DE, 0x841E, 0x8C5E, 0x9C9E, 0xA4BE, 0xACFE, 0xACFE, 0xACFE, 0xA49F, 0x8B7D, 0x72BD, 0x625B, 0x7B3D, 0x941E, 0xA4BF, 0xA4BF, 0x9C9E, 0x9C9E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x947E, 0x8C5E, 0x8C5E, 0x8C3E, 0x843E, 0x841E, 0x7BFE, 0x7BDE, 0x73BE, 0x6B9E, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x52FD, 0x52DD, 0x4ABD, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A7D, 0x4A7D, 0x52BD, 0x631E, 0x6B3E, 0x735E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 
        0x83DE, 0x83DE, 0x8BFE, 0x943E, 0x945E, 0x949E, 0x9CBE, 0xA4FF, 0xA51E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0x951F, 0x63BE, 0x3A9E, 0x3ABE, 0x32BD, 0x32DD, 0x32DD, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B3D, 0x3B3D, 0x433D, 0x433D, 0x435E, 0x4B5E, 0x4B7E, 
        0x537E, 0x5B9E, 0x5BBE, 0x63BE, 0x63DE, 0x63BE, 0x639E, 0x4AFD, 0x3A9D, 0x329D, 0x329D, 0x3ABD, 0x3ADD, 0x3ABD, 0x3ADE, 0x42FE, 0x431E, 0x431E, 0x431E, 0x431D, 0x433D, 0x433D, 0x433D, 0x4B5E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 
        0x5BDE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x745B, 0x6C75, 0x74D3, 0x74D3, 0x74F2, 0x7CF2, 0x74B1, 0x6C70, 0x7CB1, 0x8CB3, 0x94D4, 0x94B4, 0x9C93, 0xA494, 0xA4B4, 0x9CF4, 0x9533, 0x9593, 0x7D30, 0x5C4C, 0x4388, 0x3B47, 0x3B27, 0x3327, 0x3327, 
        0x3307, 0x3306, 0x3306, 0x2B06, 0x2B05, 0x2B05, 0x2325, 0x2325, 0x2324, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2326, 0x2326, 0x2326, 0x2326, 0x2306, 0x2305, 0x2305, 0x22E5, 0x22C5, 0x22C5, 0x1AC5, 0x1AC5, 0x1AA5, 0x1AA5, 0x1AA5, 
        0x1A85, 0x1A85, 0x1A85, 0x1A85, 0x1AA5, 0x22A5, 0x22A5, 0x2AE6, 0x2B06, 0x3326, 0x3B47, 0x3B67, 0x43A7, 0x4BA7, 0x4BC8, 0x53E8, 0x5408, 0x5428, 0x5C48, 0x5C49, 0x6469, 0x6469, 0x6489, 0x6C89, 0x6C89, 0x6CAA, 0x6CAA, 0x6CAA, 0x6CAA, 0x6C8A, 
        0x6C8A, 0x6C8A, 0x6C8A, 0x6C6A, 0x6C6A, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5429, 0x5409, 0x53E8, 0x4BE8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3BA8, 0x33A8, 0x33A8, 0x3BA8, 0x3BA8, 0x3BC8, 0x3BE8, 0x4BE8, 0x4C09, 0x5409, 0x5429,
  0x5387, 0x5387, 0x5387, 0x4B67, 0x4B48, 0x4B89, 0x640C, 0x646C, 0x74EE, 0x752E, 0x6D2E, 0x752D, 0x750D, 0x752D, 0x7D2D, 0x854D, 0x8D4D, 0x9D8E, 0xA5CF, 0xA5AF, 0xA58E, 0xA56E, 0xA56F, 0xA54F, 0x9D2F, 0x9D0F, 0x9D0F, 0x9D10, 0x9530, 0x9530, 0x94F0, 
        0x94D0, 0x8CB0, 0x8C90, 0x84B0, 0x84B2, 0x84B3, 0x8493, 0x8474, 0x94D4, 0x8CB2, 0x6BCC, 0x5BA9, 0x5BA9, 0x5BA9, 0x53A8, 0x53A8, 0x5BC8, 0x5BE9, 0x5BE9, 0x53C8, 0x53C8, 0x53C8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC7, 0x4BA7, 0x43A7, 0x43A7, 
        0x4387, 0x4386, 0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B86, 0x3B87, 0x3B87, 0x3B87, 0x3B87, 0x3B87, 0x3B87, 0x3B87, 0x3B67, 0x3B67, 0x3346, 0x3326, 0x3326, 0x2B26, 0x2B06, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 
        0x2AE5, 0x2AE5, 0x2B05, 0x2B25, 0x2B26, 0x3326, 0x3326, 0x3326, 0x3326, 0x3B07, 0x3B07, 0x4B28, 0x536A, 0x63CC, 0x6C2D, 0x6C4E, 0x644F, 0x5C0D, 0x4B8C, 0x434A, 0x438B, 0x43CB, 0x4C0B, 0x4C4C, 0x548C, 0x54CD, 0x5CED, 0x5CCC, 0x548B, 0x5C8B, 
        0x5C8B, 0x5C6B, 0x5C6C, 0x5CAD, 0x5CCE, 0x5D2F, 0x5D6F, 0x6D90, 0x6DAF, 0x6DAF, 0x758F, 0x6D4E, 0x64ED, 0x5CAC, 0x548B, 0x548B, 0x548C, 0x4C6C, 0x4C4B, 0x544C, 0x5C2C, 0x5C0B, 0x53CA, 0x4BA9, 0x4B89, 0x4BA9, 0x4BA9, 0x4BA9, 0x4BA9, 0x53C9, 
        0x53C9, 0x4B89, 0x4B68, 0x5B6D, 0x8456, 0x83DB, 0x839D, 0x835D, 0x833E, 0x831D, 0x7B1D, 0x7B1E, 0x7B1E, 0x7B1E, 0x7B1E, 0x731E, 0x731E, 0x733E, 0x7B3E, 0x7B3E, 0x7B3D, 0x735E, 0x735E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x731E, 
        0x731E, 0x731E, 0x7AFE, 0x7B1D, 0x7AFD, 0x7B1D, 0x7B5D, 0x8BDF, 0x83DF, 0x6AFD, 0x525D, 0x41FD, 0x39FD, 0x39FD, 0x41FD, 0x41DD, 0x49FD, 0x6B3E, 0x737E, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x637E, 0x637E, 0x5B5E, 
        0x535D, 0x533D, 0x4B1D, 0x4AFD, 0x4ADD, 0x42BE, 0x429E, 0x427D, 0x3A3D, 0x3A1D, 0x39FD, 0x41DD, 0x5A9E, 0x739E, 0x73BE, 0x6B7E, 0x633E, 0x5B1E, 0x52BE, 0x4A7E, 0x3A3D, 0x29DD, 0x219D, 0x217D, 0x297D, 0x4A5D, 0x633E, 0x635E, 0x631D, 0x52FE, 
        0x3A1D, 0x20FD, 0x20DC, 0x39BD, 0x6B5F, 0x7BDF, 0x7BDE, 0x841E, 0x8C5E, 0x947E, 0x9C7E, 0xA4BE, 0xA4DE, 0xACDE, 0xACDE, 0xA49E, 0x93FE, 0x833D, 0x835E, 0x837E, 0x93FE, 0xA4BE, 0xA4BE, 0x9CBE, 0x9C9E, 0x949E, 0x949E, 0x949E, 0x949E, 0x949E, 
        0x947E, 0x8C5E, 0x8C3E, 0x843E, 0x841E, 0x83FE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x635E, 0x633E, 0x5B1E, 0x5AFE, 0x52DD, 0x4ABD, 0x4ABE, 0x429D, 0x429D, 0x427D, 0x4A9D, 0x52BE, 0x631E, 0x6B5E, 0x735E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 0x83BE, 
        0x83DE, 0x83FE, 0x8C3E, 0x947E, 0x949E, 0x9CBE, 0x9CDE, 0xA4FE, 0xA51E, 0xA51E, 0xA53E, 0xA53E, 0xA53E, 0x951F, 0x743E, 0x42BD, 0x3A9D, 0x329D, 0x32BD, 0x32DD, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B1D, 0x3B3E, 0x433D, 0x433D, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x63BE, 0x63DE, 0x63DE, 0x63BE, 0x5B9E, 0x42DD, 0x3A9D, 0x329D, 0x32BD, 0x32BD, 0x3ADD, 0x3ADD, 0x3ADE, 0x3AFE, 0x431E, 0x431E, 0x431E, 0x431E, 0x433D, 0x433D, 0x4B3D, 0x4B5E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 
        0x5BBE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x6C5A, 0x6C94, 0x6CD2, 0x74F2, 0x74F2, 0x7CF2, 0x7CD1, 0x74B1, 0x7CB2, 0x8CD3, 0x94D4, 0x94B4, 0x9C94, 0x9C94, 0x9CB4, 0x9513, 0x9553, 0x8D92, 0x74EE, 0x4C0A, 0x3B88, 0x3B67, 0x3B47, 0x3B47, 0x3B47, 
        0x3B47, 0x3346, 0x3326, 0x2B26, 0x2B26, 0x2B25, 0x2325, 0x2325, 0x2325, 0x2305, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2346, 0x2346, 0x2326, 0x2326, 0x2B26, 0x2326, 0x2306, 0x22E5, 0x22E5, 0x22E5, 0x22E6, 0x22E6, 0x22C6, 0x22C6, 0x22A5, 
        0x1AA5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1AA5, 0x22A5, 0x22C6, 0x2AE6, 0x2B06, 0x3327, 0x3B47, 0x4387, 0x43A7, 0x4BC7, 0x53E8, 0x5408, 0x5C28, 0x5C28, 0x5C49, 0x6469, 0x6469, 0x6C89, 0x6C89, 0x6C89, 0x6CAA, 0x6CAA, 0x6CAA, 0x74AA, 0x6CAA, 0x6C8A, 
        0x6C8A, 0x6C8A, 0x6C8A, 0x6C6A, 0x646A, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5429, 0x5409, 0x53E8, 0x4BE8, 0x43C8, 0x43A8, 0x3BA7, 0x3BA8, 0x33A8, 0x33A8, 0x33A8, 0x3BA8, 0x3BA8, 0x3BC8, 0x3BE8, 0x4BE9, 0x5409, 0x5409, 0x5C29,
  0x5387, 0x4B87, 0x4B87, 0x4B67, 0x4347, 0x4347, 0x538A, 0x642C, 0x6CAE, 0x750F, 0x750E, 0x750D, 0x752D, 0x752D, 0x7D2D, 0x854D, 0x8D6D, 0x9DAE, 0xA5CF, 0xA5AF, 0xA58F, 0xA56F, 0xA54F, 0xA52F, 0x9CEF, 0x9CEF, 0x9D0F, 0x9D2F, 0x952F, 0x950F, 0x94EF, 
        0x94CF, 0x8CAF, 0x8C6F, 0x844F, 0x8450, 0x8472, 0x8473, 0x7C32, 0x94B5, 0xA535, 0x7C4F, 0x63CA, 0x5BC9, 0x5BC9, 0x5BC9, 0x5BE9, 0x63EA, 0x63EA, 0x5BCA, 0x5BC9, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x53C8, 0x53E8, 0x53E7, 0x4BC7, 0x4BA7, 0x4BA7, 
        0x4B87, 0x4386, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B87, 0x3B87, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3B66, 0x3346, 0x3326, 0x2B26, 0x2B06, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 
        0x2AE5, 0x2AE5, 0x2B05, 0x3325, 0x3325, 0x3326, 0x3326, 0x3B26, 0x3B26, 0x3B27, 0x3B07, 0x4328, 0x4B49, 0x5B8B, 0x63CC, 0x6C2E, 0x644E, 0x5C0E, 0x53AC, 0x434B, 0x436A, 0x43AB, 0x440B, 0x4C2C, 0x4C6C, 0x54AD, 0x54ED, 0x5CED, 0x5CAC, 0x5CAC, 
        0x5C6C, 0x5C4C, 0x5C6C, 0x5CAD, 0x5CEE, 0x5D2F, 0x656F, 0x6DAF, 0x6DAF, 0x75AF, 0x758F, 0x754F, 0x6CEE, 0x648C, 0x5C4B, 0x5C4B, 0x5C4C, 0x542B, 0x542B, 0x5C2C, 0x642C, 0x640C, 0x640B, 0x5BCA, 0x53CA, 0x53CA, 0x53CA, 0x53CA, 0x53EA, 0x640B, 
        0x640B, 0x63CB, 0x5BAB, 0x8454, 0x8C1A, 0x837C, 0x7B3E, 0x7B1E, 0x7AFE, 0x72FD, 0x72FD, 0x72FE, 0x72DE, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x731E, 0x733E, 0x733E, 0x733D, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 0x731E, 
        0x731E, 0x731E, 0x731E, 0x7AFE, 0x7AFD, 0x7AFD, 0x7B1D, 0x837D, 0x93FE, 0x8BFF, 0x62FD, 0x4A1D, 0x41FD, 0x41DD, 0x41DD, 0x41DD, 0x49DD, 0x62FD, 0x735E, 0x6B7E, 0x6B9D, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x637E, 0x5B7E, 0x5B5E, 0x5B5E, 
        0x533D, 0x531E, 0x4AFE, 0x4ADE, 0x42BD, 0x429D, 0x3A7D, 0x3A5D, 0x3A1D, 0x39FD, 0x39DD, 0x41FD, 0x5ADE, 0x6B5E, 0x6B7E, 0x6B5E, 0x633E, 0x631E, 0x5ADE, 0x4ABD, 0x427D, 0x3A1D, 0x31BD, 0x297D, 0x297D, 0x4A5D, 0x633E, 0x633E, 0x62FE, 0x5AFE, 
        0x529E, 0x399C, 0x525D, 0x7BBE, 0x83FE, 0x8C1E, 0x8C3E, 0x945E, 0x9C9E, 0x9C9E, 0x9C9E, 0x9CBE, 0xA4DE, 0xA4BE, 0xA4BE, 0x9C9E, 0x943E, 0x839E, 0x731D, 0x7B5D, 0x8BBD, 0x9C7E, 0x9CBE, 0x9CBE, 0x9CBE, 0x949F, 0x949E, 0x949E, 0x949E, 0x947E, 
        0x8C7E, 0x8C5E, 0x843E, 0x841E, 0x7BFE, 0x7BDE, 0x73DE, 0x739E, 0x6B7E, 0x6B7E, 0x635E, 0x5B3E, 0x5B1E, 0x52FE, 0x4ABE, 0x4ABD, 0x429D, 0x429D, 0x427D, 0x4A9D, 0x52DE, 0x633E, 0x6B5E, 0x737E, 0x7B7E, 0x7B9E, 0x7B9E, 0x83BE, 0x83BE, 0x83DE, 
        0x83FE, 0x8C1E, 0x8C5E, 0x949E, 0x9CBE, 0x9CBE, 0x9CDE, 0xA51F, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53F, 0x9D1F, 0x849E, 0x4ADD, 0x3A9D, 0x329D, 0x32BD, 0x32BD, 0x32DE, 0x3AFE, 0x3AFE, 0x3B1E, 0x3B1D, 0x3B1E, 0x3B1D, 0x433D, 0x4B5E, 0x4B7E, 
        0x539E, 0x5B9E, 0x63BE, 0x63DE, 0x6BDE, 0x63BE, 0x5B7E, 0x42DD, 0x329E, 0x329D, 0x32BD, 0x32BD, 0x32DD, 0x3ADD, 0x3AFD, 0x3AFE, 0x3B1E, 0x3B1E, 0x431E, 0x431E, 0x433E, 0x433D, 0x435E, 0x4B5E, 0x4B5E, 0x4B7E, 0x537E, 0x539E, 0x539E, 0x5BBE, 
        0x5BBE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x6C5A, 0x6494, 0x6CF2, 0x6CF2, 0x7512, 0x7D12, 0x7CF2, 0x7CB2, 0x7C92, 0x8CB4, 0x8CB4, 0x9494, 0x9474, 0x9494, 0x94D4, 0x9533, 0x8D93, 0x8571, 0x648D, 0x4BC9, 0x4388, 0x4388, 0x4368, 0x3B67, 0x3B67, 
        0x3B67, 0x3366, 0x3366, 0x2B46, 0x2B45, 0x2B25, 0x2325, 0x2305, 0x2305, 0x2305, 0x2305, 0x2325, 0x2345, 0x2345, 0x2345, 0x2345, 0x2346, 0x2345, 0x2346, 0x2345, 0x2346, 0x2326, 0x2306, 0x22E5, 0x22E5, 0x22E6, 0x22E6, 0x22E6, 0x22C6, 0x22C5, 
        0x1AA5, 0x1AA5, 0x1AA5, 0x22A5, 0x22A5, 0x22A5, 0x2AC6, 0x2AE6, 0x3306, 0x3326, 0x3B47, 0x4387, 0x4BA7, 0x4BC7, 0x53E8, 0x5408, 0x5C28, 0x5C48, 0x5C69, 0x6469, 0x6489, 0x6C89, 0x6C8A, 0x6CA9, 0x6CAA, 0x6CAA, 0x6CAA, 0x74AA, 0x74AA, 0x6C8A, 
        0x6C8A, 0x6C8A, 0x6C8A, 0x646A, 0x6469, 0x6469, 0x5C49, 0x5C49, 0x5C29, 0x5429, 0x5409, 0x53E8, 0x4BE8, 0x43C8, 0x43C8, 0x3BA7, 0x3B87, 0x3387, 0x3388, 0x3388, 0x3388, 0x33A8, 0x33A8, 0x3BC8, 0x3BC8, 0x43E8, 0x5409, 0x5409, 0x5C29,
  0x4B87, 0x4B87, 0x4B87, 0x4367, 0x4347, 0x4347, 0x4B48, 0x640C, 0x644D, 0x6CAE, 0x750E, 0x750E, 0x750D, 0x752D, 0x752D, 0x854D, 0x8D6D, 0x958E, 0xA5AE, 0xA58E, 0xA58F, 0xA56F, 0xA54F, 0x9CEF, 0x948E, 0x94CF, 0x9D0F, 0x950F, 0x950F, 0x950F, 0x94EF, 
        0x94AF, 0x948F, 0x946F, 0x8C2F, 0x840F, 0x8431, 0x8432, 0x7C12, 0x8412, 0x8C93, 0x8CB1, 0x848E, 0x6C2B, 0x63E9, 0x5BC9, 0x63EA, 0x7CAE, 0x744D, 0x5BCA, 0x5BC9, 0x5BE8, 0x5BE8, 0x5BE8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x4BC7, 0x4BC7, 0x4BA7, 
        0x4B87, 0x4B86, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B46, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B87, 0x4387, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3346, 0x3326, 0x3326, 0x2B26, 0x2B06, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 
        0x2AE5, 0x2B05, 0x3305, 0x3326, 0x3326, 0x3B26, 0x3B46, 0x3B46, 0x3B46, 0x3B47, 0x3B27, 0x4328, 0x4328, 0x4B4A, 0x5BAB, 0x5C0D, 0x640E, 0x5C0E, 0x53CD, 0x436B, 0x436B, 0x43AB, 0x4BEB, 0x4C2C, 0x4C6C, 0x4C8C, 0x4CAC, 0x54CD, 0x5CCD, 0x64AC, 
        0x5C6C, 0x5C4C, 0x5C8D, 0x5CCD, 0x5D0E, 0x5D4F, 0x656F, 0x6D8F, 0x6D6F, 0x756F, 0x756E, 0x754F, 0x7D0E, 0x6C8D, 0x644C, 0x644C, 0x642C, 0x640B, 0x5C0B, 0x640B, 0x6C0C, 0x6C0C, 0x6C0C, 0x63EB, 0x63EB, 0x640B, 0x640B, 0x640B, 0x640B, 0x6C0C, 
        0x6C0C, 0x6BEC, 0x6BEC, 0x83F6, 0x839C, 0x7B1D, 0x7AFE, 0x72DE, 0x72DE, 0x72DD, 0x6ABE, 0x6ABE, 0x6ABD, 0x6ABE, 0x6ABE, 0x6ABE, 0x6ABE, 0x6ADE, 0x6AFE, 0x72FE, 0x731D, 0x6B1D, 0x731E, 0x731D, 0x733D, 0x733D, 0x733E, 0x733D, 0x733D, 0x733E, 
        0x6B3E, 0x731E, 0x731E, 0x7B1D, 0x7B1E, 0x7B1E, 0x7AFE, 0x7B1D, 0x835D, 0x8BBE, 0x83DF, 0x62BD, 0x49FD, 0x41DD, 0x41DD, 0x41BD, 0x49BD, 0x62BD, 0x6B5E, 0x6B5E, 0x6B7D, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 0x533E, 
        0x531E, 0x4AFE, 0x4ADD, 0x42BE, 0x42BE, 0x3A7D, 0x3A5D, 0x3A1D, 0x31FD, 0x31DD, 0x39BD, 0x421D, 0x5ADE, 0x631D, 0x633D, 0x631D, 0x631D, 0x5AFE, 0x5AFE, 0x52BE, 0x4A9D, 0x425D, 0x3A1D, 0x31BD, 0x319D, 0x4A5D, 0x631D, 0x6B3D, 0x6B3E, 0x6B3E, 
        0x6B5E, 0x737E, 0x7BBE, 0x83FE, 0x8C1E, 0x8C3E, 0x945E, 0x947E, 0x947E, 0x9C9E, 0x9C9E, 0x9CBE, 0xA4BE, 0xA4BE, 0x9C9E, 0x9C9E, 0x9C7F, 0x8C1F, 0x731D, 0x839E, 0x83DD, 0x947E, 0x9C9E, 0x949E, 0x949E, 0x949E, 0x949E, 0x947E, 0x8C7E, 0x8C7E, 
        0x8C5E, 0x8C3E, 0x841E, 0x7BFE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x635E, 0x5B3E, 0x5AFE, 0x52FE, 0x52DE, 0x4ABE, 0x4A9D, 0x429D, 0x427D, 0x4A9D, 0x52DD, 0x633E, 0x6B5E, 0x737E, 0x737E, 0x7B9E, 0x839E, 0x83BE, 0x83BE, 0x83DE, 0x83FE, 
        0x841E, 0x8C3E, 0x949E, 0x94BE, 0x94BE, 0x9CBE, 0x9CFE, 0xA51F, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0x9D1E, 0x8CDE, 0x533D, 0x3A7D, 0x327D, 0x329D, 0x32BD, 0x32DE, 0x32DE, 0x3AFE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B3E, 0x433E, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x63BE, 0x6BFE, 0x6BDE, 0x63BE, 0x5B7E, 0x3ABD, 0x329D, 0x329D, 0x2ABD, 0x32BD, 0x32DD, 0x3ADD, 0x3AFD, 0x3AFE, 0x3B1E, 0x3B1E, 0x431E, 0x431E, 0x433E, 0x433D, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x4B7E, 0x539D, 0x539E, 0x5BBE, 
        0x5BBE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x6C5A, 0x6493, 0x64D1, 0x6CF1, 0x7512, 0x7D12, 0x7D12, 0x7CB2, 0x7C93, 0x8494, 0x8C94, 0x8C74, 0x9474, 0x94B4, 0x9514, 0x8D53, 0x8572, 0x6CCE, 0x5C2B, 0x4BC9, 0x4BA8, 0x4B88, 0x4388, 0x4387, 0x4387, 
        0x3B87, 0x3B86, 0x3366, 0x3366, 0x2B46, 0x2B45, 0x2B25, 0x2305, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2345, 0x2345, 0x2345, 0x2346, 0x2345, 0x2346, 0x2345, 0x2346, 0x2B26, 0x2326, 0x2306, 0x22E6, 0x22E6, 0x22E6, 0x22E6, 0x22E5, 0x22E5, 
        0x22C5, 0x1AC5, 0x1AC5, 0x22A5, 0x22A5, 0x22C5, 0x2AC6, 0x2AE6, 0x3306, 0x3326, 0x3B67, 0x4387, 0x4BA7, 0x53C8, 0x53E8, 0x5C08, 0x5C28, 0x5C49, 0x6469, 0x6469, 0x6C89, 0x6C8A, 0x6CAA, 0x6CAA, 0x6CAA, 0x74AA, 0x74AA, 0x74AA, 0x74AA, 0x6C89, 
        0x6C89, 0x6C8A, 0x6469, 0x6469, 0x6449, 0x5C49, 0x5C49, 0x5C49, 0x5C29, 0x5409, 0x5408, 0x4BE8, 0x4BC8, 0x43C8, 0x43A7, 0x3BA7, 0x3B87, 0x3387, 0x3367, 0x3387, 0x3387, 0x3388, 0x33A8, 0x3BA8, 0x3BC8, 0x43E9, 0x5409, 0x5429, 0x5C49,
  0x4B87, 0x4B87, 0x4367, 0x4367, 0x4367, 0x4347, 0x4B48, 0x538A, 0x63EC, 0x644D, 0x74CF, 0x750E, 0x750D, 0x750C, 0x752D, 0x7D2D, 0x8D4D, 0x956E, 0x9D8E, 0xA58E, 0xA56F, 0xAD6F, 0xA530, 0x9CCF, 0x948E, 0x9CCF, 0x9D0F, 0x950F, 0x94EE, 0x94EE, 0x94CF, 
        0x9CAF, 0x94AF, 0x948F, 0x944F, 0x8C30, 0x8C30, 0x8C31, 0x8411, 0x7390, 0x8432, 0x8451, 0x7C2E, 0x6BCB, 0x6C0B, 0x6C0A, 0x6C0B, 0x84CF, 0x7C6F, 0x63EB, 0x5BE9, 0x5BE9, 0x5C09, 0x5C08, 0x5C08, 0x53E8, 0x53E8, 0x53E8, 0x53C8, 0x4BC7, 0x4BA7, 
        0x4BA7, 0x4386, 0x4386, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B87, 0x4387, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3B46, 0x3346, 0x2B26, 0x2B26, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x2B05, 0x2B05, 0x2B05, 
        0x3305, 0x3305, 0x3B05, 0x3B25, 0x3B26, 0x3B46, 0x4346, 0x4366, 0x4346, 0x3B66, 0x3B47, 0x3B47, 0x4328, 0x4B29, 0x4B6A, 0x53AB, 0x5BED, 0x5BED, 0x53CD, 0x4B6B, 0x436B, 0x4BAB, 0x4BEB, 0x4C0C, 0x444C, 0x444B, 0x444C, 0x4C8C, 0x5C8D, 0x648D, 
        0x644C, 0x648D, 0x64AD, 0x5CEE, 0x5D0E, 0x5D4F, 0x6D4F, 0x6D4F, 0x6D2E, 0x74ED, 0x74ED, 0x74CE, 0x7CAE, 0x7C6D, 0x744C, 0x744C, 0x742C, 0x740B, 0x6C0B, 0x6C0B, 0x740C, 0x740C, 0x740C, 0x740C, 0x740C, 0x742C, 0x742C, 0x742C, 0x742C, 0x7C2C, 
        0x7C2C, 0x7C0D, 0x7C0D, 0x7353, 0x7B5A, 0x833D, 0x7AFD, 0x72DE, 0x72DE, 0x6ABD, 0x629E, 0x629D, 0x629D, 0x627E, 0x629E, 0x629E, 0x629E, 0x629E, 0x62BE, 0x62DE, 0x6ADD, 0x6AFD, 0x6AFE, 0x731E, 0x731E, 0x733E, 0x733E, 0x733E, 0x733E, 0x733E, 
        0x6B3E, 0x6B1E, 0x731E, 0x731D, 0x7B1D, 0x7B1E, 0x7ADD, 0x7ADD, 0x7B1D, 0x833D, 0x837E, 0x837E, 0x6ADE, 0x5A5D, 0x49DD, 0x419D, 0x49BD, 0x62BD, 0x735E, 0x6B5D, 0x6B5D, 0x6B5E, 0x6B5E, 0x635D, 0x635D, 0x635E, 0x635E, 0x5B3E, 0x5B3E, 0x531E, 
        0x4AFE, 0x4ADE, 0x4ABE, 0x429E, 0x427E, 0x3A5D, 0x323D, 0x31FD, 0x31DD, 0x31BD, 0x31BD, 0x421D, 0x529D, 0x5ABD, 0x5ADD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ABD, 0x529D, 0x4A7D, 0x423D, 0x41DD, 0x39BD, 0x525C, 0x735E, 0x735E, 0x739E, 0x73BE, 
        0x7BDE, 0x7BDE, 0x83FE, 0x8C1E, 0x8C3E, 0x943E, 0x945E, 0x947E, 0x947E, 0x947E, 0x9C9E, 0x9C9E, 0x9C9E, 0x9C9E, 0x9CBE, 0x9CBE, 0x949F, 0x8C3E, 0x7B7D, 0x83FE, 0x945E, 0x949E, 0x949E, 0x949E, 0x949E, 0x8C7E, 0x8C7E, 0x8C7E, 0x8C5E, 0x845E, 
        0x843E, 0x841E, 0x841E, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x52FE, 0x52FE, 0x4ADE, 0x4ABD, 0x4A9E, 0x429D, 0x427D, 0x4A9D, 0x52DE, 0x631E, 0x6B5E, 0x737E, 0x737E, 0x7B9E, 0x7B9E, 0x83BE, 0x83BE, 0x83DE, 0x83FE, 0x841E, 
        0x8C3E, 0x947E, 0x949E, 0x94BE, 0x9CBF, 0x9CDE, 0x9CFE, 0xA51F, 0xA53E, 0xA53E, 0xA55E, 0xA55E, 0xA55E, 0x9D3E, 0x94FE, 0x639E, 0x3A9D, 0x2A7D, 0x2A9D, 0x32BD, 0x32BE, 0x32DE, 0x32DE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B3E, 0x433E, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x63DE, 0x6BFE, 0x6BFE, 0x63DE, 0x537E, 0x3ABD, 0x327D, 0x2A7D, 0x2A9D, 0x32BD, 0x32DD, 0x3ADE, 0x3AFD, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x4B7E, 0x539D, 0x53BE, 0x5BBE, 
        0x5BDE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x6C5A, 0x6473, 0x64D1, 0x6D11, 0x7512, 0x7D12, 0x7CF2, 0x7CB3, 0x7C73, 0x8474, 0x8C74, 0x8C74, 0x8C94, 0x94D4, 0x9534, 0x8D73, 0x7D10, 0x646C, 0x53E9, 0x4BC8, 0x4BC8, 0x4BA8, 0x4BA8, 0x43A7, 0x43A7, 
        0x4387, 0x3B87, 0x3B86, 0x3366, 0x3346, 0x2B26, 0x2B05, 0x2305, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2345, 0x2346, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2346, 0x2B46, 0x2326, 0x2326, 0x2305, 0x2306, 0x2306, 0x22E5, 0x22E5, 0x22E5, 
        0x22E5, 0x22C5, 0x22C5, 0x22C5, 0x22C5, 0x22C5, 0x2AC6, 0x2AE6, 0x3306, 0x3326, 0x3B67, 0x4387, 0x4BA7, 0x53C8, 0x5BE8, 0x5C08, 0x6429, 0x6449, 0x6469, 0x6C89, 0x6C89, 0x6CAA, 0x6CAA, 0x74AA, 0x74AA, 0x74CA, 0x74CA, 0x74AA, 0x7489, 0x6C89, 
        0x6C89, 0x6469, 0x6469, 0x6449, 0x5C49, 0x5C49, 0x5C29, 0x5429, 0x5409, 0x5408, 0x4BE8, 0x4BC8, 0x4BC7, 0x43C8, 0x43A7, 0x3B87, 0x3B67, 0x3367, 0x3367, 0x2B67, 0x2B87, 0x3387, 0x33A8, 0x3BC8, 0x3BE8, 0x43E9, 0x5409, 0x5429, 0x5C29,
  0x4367, 0x4367, 0x4367, 0x4367, 0x4367, 0x4347, 0x4B48, 0x4B28, 0x5BAB, 0x6C2D, 0x748E, 0x74EE, 0x74ED, 0x6CEC, 0x750C, 0x7D2D, 0x8D4E, 0x954E, 0x9D6E, 0xA56F, 0xA54F, 0xA52F, 0xA510, 0xA4F0, 0x9CF0, 0x9CF0, 0x9D0F, 0x950F, 0x94EE, 0x94CE, 0x9CCF, 
        0x9CCF, 0x9CAF, 0x9C8F, 0x946F, 0x944F, 0x8C30, 0x8C31, 0x8C31, 0x8412, 0x8C53, 0x8411, 0x8471, 0x7C4E, 0x73EC, 0x6C0B, 0x742C, 0x84B0, 0x742F, 0x63EC, 0x640A, 0x6409, 0x5C09, 0x5C08, 0x5C08, 0x5C08, 0x5BE8, 0x5BE8, 0x53C8, 0x53C7, 0x4BA7, 
        0x4BA7, 0x43A7, 0x4386, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B67, 0x4387, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3B46, 0x3326, 0x2B26, 0x2B06, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x2AE5, 0x3305, 0x3305, 
        0x3305, 0x3B05, 0x3B25, 0x3B25, 0x4346, 0x4346, 0x4366, 0x4366, 0x4367, 0x4367, 0x4347, 0x3B47, 0x4348, 0x4328, 0x4349, 0x4B8A, 0x53CC, 0x5BED, 0x53CD, 0x4B6C, 0x436B, 0x4B8B, 0x4BCB, 0x43EB, 0x440B, 0x3C0B, 0x3C0B, 0x442C, 0x544C, 0x644D, 
        0x646D, 0x648D, 0x64CE, 0x5D0E, 0x5D2E, 0x654F, 0x6D4F, 0x6D0E, 0x74CD, 0x748C, 0x748C, 0x748C, 0x7C6D, 0x7C4C, 0x7C2C, 0x7C4C, 0x7C2C, 0x7C0C, 0x7C0B, 0x740B, 0x740B, 0x740C, 0x7C2C, 0x7C2C, 0x7C2C, 0x842C, 0x844C, 0x7C4C, 0x844D, 0x844C, 
        0x844C, 0x842D, 0x840D, 0x7BB1, 0x7B36, 0x833C, 0x7AFD, 0x72DE, 0x6ABD, 0x6A9D, 0x627E, 0x5A7E, 0x5A7D, 0x5A7D, 0x5A7D, 0x527D, 0x527D, 0x527E, 0x527D, 0x5A7D, 0x5A9D, 0x62BD, 0x62BE, 0x6ADD, 0x6AFD, 0x6AFD, 0x6B1E, 0x6B1E, 0x731E, 0x6B3E, 
        0x6B3E, 0x6B1E, 0x6B1E, 0x731D, 0x731D, 0x72FE, 0x72DD, 0x7AFD, 0x7B1E, 0x7B1E, 0x7B1D, 0x7B3D, 0x7B5E, 0x7B5F, 0x72FE, 0x5A5D, 0x5A3D, 0x733E, 0x735E, 0x735D, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5D, 0x635D, 0x633D, 0x633E, 0x5B3E, 0x531D, 0x52FE, 
        0x4ADE, 0x4ABE, 0x4A9E, 0x427D, 0x3A5D, 0x3A3D, 0x321D, 0x31DD, 0x29BD, 0x299D, 0x31BD, 0x423D, 0x527D, 0x5A9D, 0x5A9D, 0x5ABD, 0x62DE, 0x5ADE, 0x5ADE, 0x5ABD, 0x529D, 0x4A7D, 0x4A5D, 0x527D, 0x62DE, 0x735E, 0x7B7E, 0x7B9E, 0x7BBE, 0x7BDE, 
        0x7BDE, 0x83FE, 0x83FE, 0x8C1E, 0x8C3E, 0x945E, 0x945E, 0x945E, 0x945E, 0x947E, 0x947E, 0x949E, 0x949E, 0x9C9E, 0x949E, 0x949E, 0x945E, 0x8C3E, 0x7B9D, 0x83DE, 0x947F, 0x947E, 0x947E, 0x947E, 0x8C7E, 0x8C7E, 0x8C5E, 0x8C5E, 0x843E, 0x843E, 
        0x841E, 0x7BFE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x5AFD, 0x52DE, 0x52DE, 0x4ABE, 0x4A9D, 0x429D, 0x429D, 0x4A9D, 0x52DD, 0x631E, 0x633E, 0x6B5E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 0x83BE, 0x83DE, 0x83FE, 0x8C1E, 0x8C3E, 
        0x947E, 0x949E, 0x9CBE, 0x94DE, 0x94DE, 0x9CDE, 0x9CDE, 0x9D1F, 0xA51E, 0xA53E, 0xA55F, 0xA55F, 0xA55F, 0xA53E, 0x9D1E, 0x6BDE, 0x3A9D, 0x327D, 0x2A9D, 0x2A9D, 0x32BD, 0x32DE, 0x32DD, 0x3B1E, 0x3B1E, 0x3B1E, 0x3B1E, 0x433E, 0x4B5E, 0x4B5E, 
        0x539E, 0x5BBE, 0x63DE, 0x6BFE, 0x6BDE, 0x63BE, 0x535E, 0x329D, 0x2A7D, 0x2A7D, 0x2A9D, 0x32BD, 0x32DD, 0x3ADE, 0x3AFE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B1E, 0x3B1E, 0x3B3E, 0x433E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 
        0x63DE, 0x63DE, 0x6BFE, 0x741E, 0x743E, 0x6C5A, 0x6493, 0x64D1, 0x6D11, 0x7512, 0x7D12, 0x7CF3, 0x7C93, 0x7C74, 0x8454, 0x8454, 0x8C75, 0x8C94, 0x8CF4, 0x8D54, 0x8532, 0x6CAE, 0x5C2B, 0x53E9, 0x4BE8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BA7, 
        0x43A7, 0x3B87, 0x3B87, 0x3B67, 0x3366, 0x3346, 0x2B25, 0x2B05, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2345, 0x2366, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2346, 0x2326, 0x2B26, 0x2326, 0x2305, 0x22E5, 0x22E5, 
        0x22E5, 0x22C5, 0x1AC5, 0x22C5, 0x22C5, 0x22C5, 0x2AE6, 0x2AE6, 0x3326, 0x3B47, 0x3B67, 0x4387, 0x4BA8, 0x53C8, 0x5BE8, 0x6428, 0x6429, 0x6449, 0x6C69, 0x6C89, 0x6C8A, 0x74AA, 0x74AA, 0x74AA, 0x74AA, 0x74AA, 0x74AA, 0x748A, 0x748A, 0x6C6A, 
        0x6C6A, 0x6469, 0x6449, 0x5C49, 0x5C49, 0x5429, 0x5428, 0x5409, 0x4C08, 0x4BE8, 0x4BE8, 0x4BC8, 0x43C7, 0x43A7, 0x3BA7, 0x3B87, 0x3367, 0x3367, 0x3367, 0x2B67, 0x2B67, 0x2B67, 0x3387, 0x33A8, 0x3BC8, 0x43E8, 0x4C09, 0x5409, 0x5C29,
  0x4387, 0x4387, 0x3B67, 0x4367, 0x3B47, 0x4347, 0x4B47, 0x4B28, 0x536A, 0x63EC, 0x644D, 0x74CF, 0x74EE, 0x74ED, 0x74ED, 0x852D, 0x8D2E, 0x8D2E, 0x9D2E, 0x9D2F, 0x9CEF, 0x9CEF, 0xA4F0, 0x9CF0, 0x9CEF, 0x9D0F, 0x950F, 0x94EE, 0x94EE, 0x94CE, 0x9CCF, 
        0x9CCF, 0x9CAF, 0x9C8F, 0x946F, 0x944F, 0x942F, 0x8C30, 0x8C31, 0x9452, 0x8C53, 0x7BF1, 0x8C52, 0x8450, 0x740D, 0x7C6E, 0x746E, 0x7CB0, 0x7451, 0x6C0E, 0x640B, 0x640A, 0x6429, 0x6409, 0x6409, 0x5C08, 0x5BE8, 0x5BE8, 0x53E8, 0x53C8, 0x4BC7, 
        0x4BA7, 0x4BA7, 0x4386, 0x4366, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B87, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3B46, 0x3346, 0x2B26, 0x2B06, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x3305, 0x3305, 0x3305, 
        0x3B25, 0x3B05, 0x3B26, 0x4346, 0x4346, 0x4366, 0x4B87, 0x53A8, 0x5388, 0x4B88, 0x4387, 0x4367, 0x4368, 0x4348, 0x4348, 0x4B69, 0x538B, 0x53AC, 0x53AC, 0x4B8C, 0x4B4B, 0x434B, 0x4BAB, 0x43CB, 0x43EB, 0x43EB, 0x3BEB, 0x43EB, 0x4C0C, 0x5C2D, 
        0x646D, 0x6CAE, 0x64CE, 0x5D0E, 0x5D4F, 0x5D6F, 0x6D4F, 0x750E, 0x748D, 0x744C, 0x744C, 0x744C, 0x744C, 0x7C2C, 0x7C2C, 0x7C2C, 0x7C2B, 0x7C2C, 0x7C2C, 0x7C2B, 0x7C2C, 0x7C2C, 0x7C2C, 0x842C, 0x844C, 0x844C, 0x8C4C, 0x8C6D, 0x8C6D, 0x846D, 
        0x8C6D, 0x8C4D, 0x8C4D, 0x842F, 0x83B2, 0x7B38, 0x7B1C, 0x72DD, 0x6ABE, 0x629D, 0x5A7E, 0x5A5E, 0x525D, 0x525D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A5D, 0x525D, 0x527D, 0x5A7D, 0x5A9D, 0x62BD, 0x62BD, 0x62DE, 0x62FE, 0x6AFE, 0x6B1E, 
        0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x731E, 0x72FE, 0x72FE, 0x72FE, 0x7AFE, 0x7B1E, 0x7B1E, 0x7B1D, 0x7B3D, 0x7B3D, 0x731D, 0x731E, 0x733E, 0x7B5E, 0x7B7E, 0x737E, 0x739E, 0x739E, 0x739E, 0x739E, 0x6B7E, 0x6B7E, 0x635E, 0x5B3D, 0x52FD, 0x4ADD, 
        0x4ABD, 0x4A9D, 0x427D, 0x425D, 0x3A3D, 0x3A1D, 0x31FD, 0x29BD, 0x299D, 0x299D, 0x31BD, 0x423E, 0x527D, 0x527D, 0x5A9E, 0x62BE, 0x62DE, 0x62DE, 0x62DD, 0x5ABD, 0x5A9C, 0x5ABD, 0x62FE, 0x735E, 0x737E, 0x737E, 0x7B7E, 0x7B9E, 0x7BBE, 0x83DE, 
        0x83FE, 0x8C1E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C5E, 0x8C5E, 0x8C5E, 0x8C5E, 0x8C5E, 0x8C5E, 0x947E, 0x947E, 0x8C7E, 0x8C5E, 0x8C3E, 0x841E, 0x7B7E, 0x7B7E, 0x841E, 0x8C5E, 0x8C5E, 0x8C5E, 0x8C3E, 0x8C3E, 0x8C3E, 0x843E, 0x841E, 0x7C1E, 
        0x7BFE, 0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x5AFD, 0x52FE, 0x52DE, 0x4ABE, 0x4ABE, 0x4A9D, 0x4A9D, 0x4A9D, 0x52DE, 0x631E, 0x633E, 0x6B5E, 0x6B7E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBD, 0x83DE, 0x83FE, 0x8C3E, 0x947E, 
        0x94BE, 0x94BE, 0x94DE, 0x94DE, 0x94DE, 0x9CDE, 0x9CFE, 0x9D1E, 0xA51E, 0xA53E, 0xA55E, 0xA55E, 0xA55E, 0xA53E, 0x9D1E, 0x7C3E, 0x429D, 0x327D, 0x2A7D, 0x2A9D, 0x32BE, 0x32BE, 0x32DD, 0x3B1D, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x4B5E, 0x4B5E, 
        0x537E, 0x5B9E, 0x63BE, 0x63DE, 0x6BDE, 0x63BE, 0x533D, 0x329D, 0x2A5D, 0x2A7D, 0x329D, 0x32BD, 0x32BE, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1D, 0x3B1D, 0x3B1D, 0x3B1D, 0x3B3E, 0x433E, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 
        0x63DE, 0x6BFE, 0x6BFE, 0x6BFE, 0x741E, 0x6419, 0x5C72, 0x64F1, 0x6D11, 0x6D12, 0x7512, 0x7CF3, 0x7C93, 0x7C74, 0x8475, 0x8C75, 0x8C75, 0x8494, 0x8CF4, 0x8553, 0x74F0, 0x646C, 0x5C2A, 0x5C09, 0x5C09, 0x5408, 0x53E8, 0x53E8, 0x53E8, 0x4BC8, 
        0x4BC8, 0x4387, 0x4387, 0x3B67, 0x3B66, 0x3346, 0x3326, 0x2B25, 0x2B05, 0x2325, 0x2325, 0x2325, 0x2345, 0x2345, 0x2365, 0x2B66, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2346, 0x2B26, 0x2326, 0x2306, 0x2305, 0x22E5, 
        0x22E5, 0x1AC5, 0x1AC5, 0x1AC5, 0x1AC5, 0x22E5, 0x22E6, 0x2B06, 0x3326, 0x3B47, 0x4367, 0x4388, 0x4BA8, 0x53C8, 0x5BE8, 0x6428, 0x6429, 0x6C49, 0x6C49, 0x6C69, 0x748A, 0x748A, 0x74AA, 0x74AA, 0x74AA, 0x748A, 0x748A, 0x748A, 0x746A, 0x6C6A, 
        0x6449, 0x6449, 0x5C29, 0x5C29, 0x5428, 0x5408, 0x4C08, 0x4BE8, 0x4BE8, 0x43E8, 0x43C8, 0x43A7, 0x43A7, 0x3BA7, 0x3B87, 0x3367, 0x3367, 0x3347, 0x3347, 0x2B47, 0x2B47, 0x2B67, 0x3387, 0x33A7, 0x3BC8, 0x43E8, 0x4BE8, 0x5409, 0x5C29,
  0x53E9, 0x53C9, 0x4BA8, 0x4387, 0x4367, 0x4347, 0x4B47, 0x4B28, 0x5349, 0x5B8B, 0x5BEC, 0x748E, 0x7D2F, 0x7CEE, 0x7CED, 0x850E, 0x8D0E, 0x950F, 0x9D0F, 0x9CEF, 0x9CCE, 0x9CCF, 0xA4D0, 0x9CF0, 0x9CEF, 0x950F, 0x950E, 0x94EE, 0x94CE, 0x94AE, 0x9CCE, 
        0x9CCF, 0x9CAF, 0x9C8F, 0x946F, 0x944F, 0x942F, 0x8C2F, 0x8C10, 0x9452, 0x9473, 0x8C33, 0x83D1, 0x8C51, 0x8C90, 0x7C4F, 0x7C6F, 0x84D2, 0x7C92, 0x7430, 0x6C2C, 0x6C2B, 0x6C2A, 0x642A, 0x6409, 0x6409, 0x63E9, 0x5BE8, 0x5BE8, 0x53C8, 0x53C8, 
        0x4BA7, 0x4BA7, 0x4387, 0x4386, 0x4366, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B46, 0x3B66, 0x4367, 0x4387, 0x3B87, 0x3B87, 0x3B87, 0x3B66, 0x3B66, 0x3346, 0x3326, 0x2B26, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x3305, 0x3305, 0x3305, 
        0x3B25, 0x3B25, 0x4326, 0x4346, 0x4B66, 0x5387, 0x5BE9, 0x6C0A, 0x6C0A, 0x5C0A, 0x53E9, 0x4BE9, 0x4BA9, 0x4B89, 0x4369, 0x4B69, 0x4B8B, 0x538C, 0x538C, 0x538C, 0x4B4B, 0x434B, 0x436B, 0x43AB, 0x43CB, 0x43CB, 0x3BCB, 0x3BAB, 0x43CB, 0x5BEC, 
        0x6C6E, 0x64AE, 0x64CE, 0x5D0E, 0x5D4F, 0x5D6F, 0x6D4F, 0x7CEE, 0x7C8D, 0x744B, 0x742B, 0x742B, 0x7C2B, 0x7C2B, 0x7C2B, 0x7C2B, 0x7C2B, 0x7C2C, 0x7C4C, 0x7C4C, 0x7C4C, 0x7C4C, 0x7C4C, 0x844C, 0x844C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 
        0x8C6C, 0x8C6D, 0x8C6D, 0x844D, 0x8410, 0x7BB4, 0x7B59, 0x72FD, 0x6ABE, 0x629D, 0x5A7D, 0x525D, 0x525D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x423D, 0x423D, 0x4A3D, 0x4A3D, 0x4A3D, 0x525D, 0x523D, 0x525D, 0x5A7D, 0x5A9D, 0x5ABD, 0x62DD, 0x62FE, 
        0x62FD, 0x6AFD, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x731E, 0x7B1D, 0x7B3E, 0x7B3E, 0x731D, 0x6AFD, 0x72FD, 0x731D, 0x731D, 0x731D, 0x731D, 0x733D, 0x733D, 0x6B3D, 0x6B3D, 0x6B3D, 0x633E, 0x633E, 0x633E, 0x635E, 
        0x633E, 0x52FE, 0x4A9D, 0x423D, 0x3A1D, 0x39FD, 0x31DD, 0x299D, 0x297D, 0x317D, 0x39BD, 0x423E, 0x4A5D, 0x527D, 0x5A9E, 0x62BE, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x6AFD, 0x733E, 0x737E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7BBE, 0x83DE, 
        0x83FE, 0x83FE, 0x8C1E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x8C3E, 0x843E, 0x8C3E, 0x841E, 0x83FE, 0x739E, 0x6B1D, 0x7BDE, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x7C1E, 0x7BFE, 0x7BFE, 
        0x7BDE, 0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x5AFE, 0x52DE, 0x52DE, 0x4ADD, 0x4ABE, 0x4A9E, 0x4A9D, 0x4ABD, 0x5AFD, 0x631E, 0x633E, 0x6B5E, 0x6B7E, 0x737E, 0x739E, 0x739E, 0x7BBE, 0x7BDE, 0x83DE, 0x83FE, 0x8C3E, 0x8C7E, 0x94BE, 
        0x94DE, 0x94DE, 0x94DE, 0x94DE, 0x94DE, 0x9CDE, 0x9CFE, 0x9D1E, 0xA51E, 0xA53E, 0xA55E, 0xA55E, 0xA55E, 0xA55F, 0x9D1E, 0x847F, 0x4ADD, 0x325D, 0x2A7D, 0x2A7D, 0x32BD, 0x32BE, 0x32DD, 0x32FD, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x4B3E, 0x4B5E, 
        0x537E, 0x539E, 0x63BD, 0x63DE, 0x6BDE, 0x63BE, 0x533E, 0x327D, 0x2A5D, 0x2A7D, 0x329D, 0x32BD, 0x32DE, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1E, 0x3B1D, 0x3B1D, 0x3B3D, 0x3B3D, 0x433E, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x537E, 0x539E, 0x5BBE, 0x5BBE, 
        0x63DE, 0x6BFE, 0x6BFE, 0x6BFE, 0x6C1D, 0x63F8, 0x5C72, 0x64F1, 0x6511, 0x6D12, 0x7512, 0x7CF3, 0x7CB4, 0x8494, 0x8475, 0x8C75, 0x8C75, 0x84B5, 0x8514, 0x8553, 0x74EF, 0x646B, 0x5C4A, 0x5C29, 0x5C29, 0x5C09, 0x5C08, 0x5C08, 0x53E8, 0x53E8, 
        0x4BC8, 0x4BA8, 0x4387, 0x3B67, 0x3B67, 0x3366, 0x3346, 0x2B26, 0x2B25, 0x2B25, 0x2325, 0x2325, 0x2345, 0x2345, 0x2B66, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2B46, 0x2346, 0x2326, 0x2305, 0x2305, 
        0x22E5, 0x1AC5, 0x1AC5, 0x1AC5, 0x1AC5, 0x22E5, 0x22E6, 0x2B06, 0x3326, 0x3B47, 0x4367, 0x4388, 0x4BC8, 0x53C8, 0x5BE8, 0x6428, 0x6429, 0x6C49, 0x6C49, 0x746A, 0x748A, 0x748A, 0x74AA, 0x74AA, 0x74AA, 0x748A, 0x7469, 0x746A, 0x6C49, 0x6C49, 
        0x6449, 0x5C29, 0x5C29, 0x5408, 0x5408, 0x4BE8, 0x43E8, 0x43C8, 0x43C8, 0x43C8, 0x3BA7, 0x3BA7, 0x3B87, 0x3B87, 0x3367, 0x3367, 0x3347, 0x3347, 0x2B46, 0x2B26, 0x2B47, 0x2B47, 0x3367, 0x3387, 0x3BA8, 0x43C8, 0x4BE8, 0x5409, 0x5C09,
  0x6C4B, 0x6C4B, 0x640A, 0x5BE9, 0x53A8, 0x4B68, 0x4B68, 0x5369, 0x536A, 0x5B8A, 0x538B, 0x6C6E, 0x7D30, 0x852F, 0x7CEE, 0x84EE, 0x8CEF, 0x8C8E, 0x8C6E, 0x946E, 0x9CAF, 0x9CCF, 0x9CF0, 0x9CEF, 0x94EF, 0x94EE, 0x950E, 0x8D0E, 0x94CE, 0x948E, 0x94AE, 
        0x9CAF, 0x9CAF, 0x9C8F, 0x946F, 0x946F, 0x944F, 0x8C2F, 0x8C10, 0x8C11, 0x9453, 0x8C33, 0x7B70, 0x9452, 0x7BEF, 0x8450, 0x7C90, 0x84D2, 0x7CD2, 0x7C91, 0x6C0D, 0x6C2C, 0x6C2B, 0x6C2A, 0x6C2A, 0x6409, 0x6409, 0x63E8, 0x5BC8, 0x53C8, 0x53C8, 
        0x4BA7, 0x43A7, 0x4387, 0x4386, 0x4366, 0x4366, 0x4366, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B67, 0x4367, 0x4367, 0x4387, 0x4387, 0x4387, 0x3B87, 0x3B87, 0x3B67, 0x3346, 0x3346, 0x2B26, 0x2B05, 0x2AE5, 0x2AE5, 0x2AE5, 0x3305, 0x3305, 0x3B25, 
        0x3B25, 0x4325, 0x4346, 0x4B46, 0x5387, 0x5BC8, 0x6C0A, 0x7C4B, 0x7C4B, 0x6C6B, 0x644B, 0x5C2A, 0x5C2A, 0x5C0A, 0x53CA, 0x538A, 0x538A, 0x538B, 0x538C, 0x536C, 0x4B2B, 0x432B, 0x434B, 0x438B, 0x43AB, 0x43CB, 0x43CB, 0x3B8B, 0x438A, 0x53AB, 
        0x642D, 0x64AE, 0x5CCE, 0x5D0E, 0x5D4F, 0x5D6F, 0x6D4F, 0x7CEE, 0x7C6C, 0x742B, 0x742B, 0x744B, 0x744B, 0x744B, 0x744B, 0x7C2B, 0x7C4B, 0x7C4B, 0x744B, 0x744B, 0x7C4C, 0x746C, 0x7C6C, 0x7C6C, 0x846C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 
        0x8C6C, 0x846C, 0x846C, 0x846D, 0x846E, 0x7C11, 0x7B96, 0x731C, 0x6ADE, 0x629E, 0x5A7D, 0x525D, 0x523D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x423D, 0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A1D, 0x4A1D, 0x4A3D, 0x525D, 0x525D, 0x527D, 0x5A9D, 0x62BD, 
        0x62DE, 0x62DE, 0x6AFD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6AFE, 0x72FE, 0x72FE, 0x72FE, 0x72FD, 0x731D, 0x733E, 0x733E, 0x731E, 0x6ADD, 0x6ADD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x6ADD, 0x62FD, 0x62FD, 0x62FD, 0x62FD, 
        0x631D, 0x633E, 0x633E, 0x5ADD, 0x4A7C, 0x39FD, 0x31BD, 0x297D, 0x295D, 0x317D, 0x39BD, 0x421D, 0x4A5D, 0x5A9E, 0x5ABE, 0x62BE, 0x62DE, 0x62DD, 0x62FD, 0x735E, 0x7B5E, 0x735E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 0x83DE, 
        0x83DE, 0x83FE, 0x841E, 0x841E, 0x8C3E, 0x8C1E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x7BFE, 0x739E, 0x62FD, 0x739E, 0x83FE, 0x841E, 0x841E, 0x841E, 0x83FE, 0x7BFE, 0x7BDE, 0x73DE, 0x73DE, 
        0x73BE, 0x739E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x5AFE, 0x52DD, 0x52BE, 0x52BD, 0x4ABD, 0x4ABE, 0x4A9D, 0x4ABD, 0x5ADD, 0x631E, 0x633E, 0x6B5E, 0x735E, 0x737E, 0x739E, 0x739E, 0x739E, 0x7BBE, 0x7BDE, 0x83FE, 0x841E, 0x8C5E, 0x949E, 0x94BE, 
        0x94DE, 0x94FE, 0x94FE, 0x94DE, 0x9CFE, 0x9CDE, 0x9CFE, 0x9D1E, 0x9D1E, 0xA53E, 0xA55E, 0xA55E, 0xA55E, 0xA55F, 0x9D3E, 0x8CBE, 0x531D, 0x325D, 0x2A5D, 0x2A7D, 0x2A9D, 0x32BE, 0x32DD, 0x32FD, 0x3AFE, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x4B5E, 
        0x537E, 0x539E, 0x63BE, 0x63DE, 0x63DE, 0x639E, 0x531E, 0x327D, 0x2A3D, 0x2A7D, 0x329D, 0x32BD, 0x32DE, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1E, 0x3B1E, 0x3B3D, 0x3B3D, 0x3B3D, 0x433E, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 
        0x63DE, 0x6BFE, 0x6BFE, 0x6C1E, 0x6BFD, 0x5BD7, 0x5C71, 0x5CF1, 0x6511, 0x6D11, 0x7512, 0x7CF3, 0x7CB4, 0x8495, 0x8475, 0x8475, 0x8475, 0x84B4, 0x8513, 0x7D31, 0x6CCE, 0x644B, 0x6449, 0x6449, 0x6429, 0x6429, 0x5C29, 0x5C28, 0x5C08, 0x53E8, 
        0x53C8, 0x4BA8, 0x4387, 0x4387, 0x3B67, 0x3B67, 0x3346, 0x2B46, 0x2B26, 0x2B26, 0x2346, 0x2345, 0x2345, 0x2365, 0x2B66, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2346, 0x2325, 0x2325, 0x2305, 
        0x22E5, 0x1AC5, 0x1AC5, 0x1AC5, 0x1AC5, 0x22E5, 0x22E6, 0x2B06, 0x3326, 0x3B47, 0x4367, 0x4388, 0x4BC8, 0x53C8, 0x5BE8, 0x6409, 0x6429, 0x6C49, 0x6C49, 0x746A, 0x748A, 0x748A, 0x748A, 0x748A, 0x748A, 0x748A, 0x746A, 0x6C4A, 0x6C49, 0x6C29, 
        0x5C29, 0x5409, 0x53E8, 0x4BE8, 0x4BE8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3BA7, 0x3B87, 0x3B87, 0x3B67, 0x3367, 0x3346, 0x3346, 0x3326, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B27, 0x2B47, 0x3367, 0x3B88, 0x43A8, 0x4BC8, 0x53E9, 0x5409,
  0x848C, 0x848C, 0x7C6C, 0x744B, 0x640A, 0x5BEA, 0x63EA, 0x6BCB, 0x6BCC, 0x6BCC, 0x63CC, 0x5BCC, 0x7CEF, 0x8530, 0x84EF, 0x84AE, 0x8C8F, 0x8C4E, 0x842D, 0x8C4D, 0x94CF, 0x9CCF, 0x9CEF, 0x94EF, 0x94EE, 0x94EE, 0x8CEE, 0x8CEE, 0x94AE, 0x948E, 0x948E, 
        0x94AE, 0x948E, 0x948E, 0x946E, 0x946E, 0x8C4E, 0x8C2F, 0x8C0F, 0x8BF0, 0x9411, 0x9C53, 0x83D1, 0x9452, 0x8C71, 0x8491, 0x84D1, 0x7D12, 0x7D12, 0x7CF1, 0x6C2E, 0x746E, 0x6C2C, 0x6C2B, 0x640A, 0x63E9, 0x63E9, 0x5BE8, 0x5BC8, 0x53C8, 0x53C8, 
        0x4BA7, 0x4B87, 0x4387, 0x4386, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B46, 0x3B67, 0x4367, 0x4367, 0x4367, 0x4387, 0x4387, 0x4387, 0x4387, 0x3B87, 0x3B67, 0x3346, 0x2B45, 0x2B25, 0x2B25, 0x2B05, 0x2B05, 0x2B05, 0x3305, 0x3B05, 0x3B25, 
        0x4325, 0x4325, 0x4B46, 0x4B66, 0x5387, 0x63E9, 0x7C2B, 0x846C, 0x848C, 0x7C8D, 0x74AC, 0x748C, 0x6C8C, 0x646C, 0x642B, 0x5BEB, 0x5BCB, 0x5BAC, 0x5BAD, 0x536C, 0x4B2B, 0x430A, 0x434B, 0x438B, 0x43AB, 0x43AB, 0x43AB, 0x3B8B, 0x436A, 0x53CC, 
        0x644E, 0x64AF, 0x5CCF, 0x5D0E, 0x5D4F, 0x656F, 0x6D4F, 0x74CD, 0x746C, 0x742B, 0x742A, 0x742B, 0x744B, 0x742A, 0x744B, 0x744B, 0x744B, 0x744B, 0x744B, 0x7C4B, 0x7C6C, 0x746C, 0x7C6C, 0x7C6C, 0x846C, 0x8C6C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 
        0x848C, 0x848C, 0x848C, 0x848C, 0x848D, 0x7C6E, 0x7BD3, 0x733A, 0x6ADD, 0x629D, 0x5A7D, 0x5A5E, 0x525D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A3D, 0x4A3D, 0x525D, 0x527E, 
        0x5A9E, 0x62DE, 0x62DD, 0x62DE, 0x62DE, 0x6ADE, 0x6AFD, 0x6AFE, 0x6AFE, 0x6AFD, 0x6AFD, 0x72FD, 0x731E, 0x731E, 0x6AFE, 0x6ADD, 0x6ADE, 0x6ADD, 0x6ADD, 0x6ADD, 0x6ADD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 
        0x5ADD, 0x5ADD, 0x5ADD, 0x631E, 0x6B3E, 0x62FE, 0x527E, 0x39DC, 0x317C, 0x317C, 0x39BD, 0x41FD, 0x4A3D, 0x5A7E, 0x5A9E, 0x62BD, 0x62DD, 0x6B1D, 0x735E, 0x735E, 0x7B5E, 0x737E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 
        0x83DE, 0x83DE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x841E, 0x7C1E, 0x7BFE, 0x7BFE, 0x7BDE, 0x73BE, 0x62FD, 0x6B5D, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x73DE, 0x73BE, 0x739E, 
        0x6B9E, 0x6B7E, 0x6B5E, 0x633E, 0x5B1E, 0x5AFE, 0x52DE, 0x52BE, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x52BE, 0x5B1E, 0x633E, 0x6B3E, 0x6B5E, 0x6B5E, 0x737E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 0x83FE, 0x843E, 0x8C5E, 0x8C7E, 0x949E, 0x94DE, 
        0x94DE, 0x94FE, 0x94FF, 0x9CFE, 0x9CFE, 0x9CDE, 0x9CFE, 0x9D1E, 0x9D1E, 0x9D1E, 0xA53E, 0xA55F, 0xA55E, 0xA55F, 0xA53E, 0x94DE, 0x637E, 0x325D, 0x2A5D, 0x2A7E, 0x2A9D, 0x2ABE, 0x32DD, 0x32DD, 0x32FD, 0x3AFE, 0x3B1E, 0x3B1E, 0x433E, 0x435E, 
        0x4B7E, 0x537E, 0x5B9E, 0x63BE, 0x63BE, 0x5B9E, 0x4ADE, 0x2A5D, 0x2A5D, 0x2A7D, 0x329D, 0x32BD, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1D, 0x3B1D, 0x3B1E, 0x3B3E, 0x3B3D, 0x433E, 0x435E, 0x435E, 0x4B5E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 0x63DE, 
        0x63DE, 0x6BFE, 0x6BFE, 0x6C1E, 0x63BB, 0x53D4, 0x5491, 0x5CD0, 0x6511, 0x6D12, 0x7532, 0x7D14, 0x84F5, 0x7C95, 0x7C75, 0x8475, 0x8495, 0x7CB4, 0x7D12, 0x74EF, 0x6C8C, 0x646A, 0x6469, 0x6449, 0x6449, 0x6449, 0x6429, 0x6429, 0x5C09, 0x5C08, 
        0x53E8, 0x4BC8, 0x4BA8, 0x4387, 0x4387, 0x3B67, 0x3366, 0x3346, 0x2B46, 0x2B46, 0x2B46, 0x2346, 0x2B66, 0x2B66, 0x2B86, 0x2B86, 0x2B86, 0x2BA6, 0x2BA6, 0x33A6, 0x33A6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2B46, 0x2326, 0x2305, 
        0x22E5, 0x22E5, 0x1AC5, 0x1AC5, 0x1AC5, 0x22C5, 0x22E6, 0x2B06, 0x3326, 0x3B47, 0x4367, 0x4B88, 0x4BA8, 0x53C8, 0x5BE8, 0x6409, 0x6429, 0x6C49, 0x6C49, 0x746A, 0x748A, 0x748A, 0x748A, 0x748A, 0x748A, 0x746A, 0x746A, 0x6C49, 0x6C29, 0x6409, 
        0x5C08, 0x53E8, 0x4BE8, 0x4BC8, 0x43C8, 0x43A8, 0x3BA7, 0x3B87, 0x3387, 0x3367, 0x3367, 0x3367, 0x3346, 0x3347, 0x3326, 0x3326, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2B26, 0x2B27, 0x2B47, 0x3367, 0x3B88, 0x3BA8, 0x43A8, 0x4BC9, 0x53E9,
  0x8C6D, 0x8C8D, 0x8C8D, 0x8C6C, 0x846C, 0x7C6C, 0x846C, 0x846D, 0x8C6D, 0x844D, 0x7C2D, 0x63AB, 0x746D, 0x8510, 0x84EF, 0x846E, 0x8C6E, 0x8C6E, 0x946E, 0x948F, 0x94AF, 0x94CF, 0x94EF, 0x94EE, 0x8CEE, 0x94EE, 0x8CEE, 0x8CCE, 0x948E, 0x8C6D, 0x948E, 
        0x948E, 0x948E, 0x948E, 0x8C6E, 0x8C6E, 0x946F, 0x944F, 0x942F, 0x9410, 0x8BF0, 0x8BF1, 0x8C11, 0x9471, 0x94B1, 0x84D1, 0x8531, 0x7D51, 0x7D51, 0x7D51, 0x7CF1, 0x748F, 0x6C0C, 0x63EB, 0x5BCA, 0x5389, 0x63EA, 0x5BE9, 0x5BC8, 0x53C8, 0x4BA8, 
        0x4B88, 0x4387, 0x4367, 0x3B67, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x4347, 0x4347, 0x4367, 0x4367, 0x4387, 0x4387, 0x4387, 0x4387, 0x4387, 0x4387, 0x3B87, 0x3B66, 0x3346, 0x2B45, 0x2B25, 0x2B05, 0x2B05, 0x2B05, 0x2B05, 0x3305, 0x3B25, 
        0x4325, 0x4346, 0x4B66, 0x5387, 0x5BA8, 0x6C09, 0x7C4B, 0x8C8C, 0x8CAD, 0x84AD, 0x7CCD, 0x7CCD, 0x7CCD, 0x74AD, 0x6C8D, 0x644C, 0x642C, 0x63EC, 0x63CD, 0x5B8C, 0x4B2B, 0x430A, 0x432B, 0x436B, 0x438B, 0x43AB, 0x3BAB, 0x3B8B, 0x438B, 0x53ED, 
        0x644E, 0x64AF, 0x5CCF, 0x5D0E, 0x5D4F, 0x656F, 0x6D4F, 0x74EE, 0x746C, 0x6C2B, 0x6C2A, 0x742B, 0x742B, 0x742A, 0x742B, 0x742B, 0x744B, 0x744B, 0x744B, 0x7C6B, 0x7C6B, 0x7C6C, 0x7C6C, 0x848C, 0x848C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 
        0x848C, 0x846C, 0x846C, 0x848C, 0x848D, 0x7C6E, 0x7C11, 0x7378, 0x6ADD, 0x629D, 0x5A7E, 0x5A7D, 0x525D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A3D, 
        0x527D, 0x5A9E, 0x62BE, 0x62BE, 0x62DE, 0x62DD, 0x62FD, 0x6AFE, 0x6AFD, 0x6AFD, 0x6AFE, 0x6AFD, 0x6AFE, 0x6AFD, 0x6AFD, 0x62DD, 0x62DE, 0x62DD, 0x6ADE, 0x62DD, 0x62DD, 0x62DE, 0x62DD, 0x62FE, 0x62FE, 0x62FE, 0x62DE, 0x62DE, 0x62DE, 0x62DD, 
        0x5ABD, 0x5ABE, 0x5A9D, 0x5ABD, 0x62BD, 0x62BD, 0x62FE, 0x6B3E, 0x631F, 0x5ABE, 0x4A5D, 0x4A1D, 0x4A3D, 0x5A7D, 0x5A9D, 0x62BD, 0x731E, 0x7B5E, 0x7B5E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 
        0x7BDE, 0x83DE, 0x83FE, 0x841E, 0x841E, 0x841E, 0x841E, 0x83FE, 0x83FE, 0x7BFE, 0x83FE, 0x83FE, 0x7BFE, 0x7BFE, 0x7BDE, 0x7BDE, 0x73DE, 0x7BDE, 0x73BE, 0x6B3D, 0x631D, 0x73DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 
        0x6B7E, 0x6B7E, 0x635E, 0x5B3D, 0x5AFE, 0x52DE, 0x52BD, 0x4ABE, 0x4A9E, 0x4A9D, 0x4A9D, 0x52BD, 0x631E, 0x6B5E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B5E, 0x737E, 0x737E, 0x739E, 0x739E, 0x7BBE, 0x7BDE, 0x841E, 0x8C7E, 0x8C9E, 0x8C9E, 0x94BE, 0x94DE, 
        0x94DE, 0x9CFF, 0x9CFF, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9D1E, 0x9D1E, 0xA53E, 0xA53E, 0xA55E, 0xA55E, 0xA53E, 0x94FE, 0x6BDE, 0x3A7D, 0x2A5D, 0x2A7D, 0x329D, 0x32BE, 0x32BE, 0x32DE, 0x32DD, 0x3ADD, 0x3AFE, 0x3B1E, 0x433E, 0x433D, 
        0x4B5E, 0x537E, 0x5B9D, 0x5B9E, 0x5B9E, 0x5B7E, 0x42BE, 0x2A3D, 0x2A5D, 0x2A7D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1D, 0x3B1D, 0x3B1E, 0x3B3D, 0x3B3D, 0x435D, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 0x63DE, 
        0x63DE, 0x6BFE, 0x6BFE, 0x73FE, 0x5BB9, 0x53F2, 0x5470, 0x5CD0, 0x64F1, 0x7512, 0x7533, 0x7D34, 0x8515, 0x7CD5, 0x7C95, 0x7C95, 0x7C94, 0x7CD3, 0x74D1, 0x6CAD, 0x6C8B, 0x646A, 0x6C8A, 0x6C69, 0x6C69, 0x6C49, 0x6C29, 0x6449, 0x6429, 0x5C09, 
        0x53E8, 0x53C8, 0x53C8, 0x4BA8, 0x4387, 0x3B87, 0x3B67, 0x3367, 0x3366, 0x2B66, 0x2B66, 0x2366, 0x2B66, 0x2386, 0x2B86, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x33A6, 0x33C6, 0x33C6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B87, 0x2B66, 0x2B46, 0x2326, 0x2B26, 
        0x2305, 0x22E5, 0x22C5, 0x1AC5, 0x1AC5, 0x22C5, 0x22E6, 0x2AE6, 0x3306, 0x3B27, 0x4347, 0x4B88, 0x4BA8, 0x53C8, 0x5BE8, 0x6409, 0x6C29, 0x6C49, 0x6C49, 0x7469, 0x748A, 0x748A, 0x748A, 0x748A, 0x746A, 0x6C49, 0x6C49, 0x6C29, 0x6409, 0x63E8, 
        0x5BE8, 0x53E8, 0x4BC8, 0x43C8, 0x3BA7, 0x3B87, 0x3367, 0x3367, 0x3367, 0x3347, 0x3327, 0x3327, 0x3327, 0x3327, 0x3326, 0x3326, 0x2B06, 0x2B06, 0x2B06, 0x2B06, 0x2B06, 0x2B27, 0x2B27, 0x3347, 0x3368, 0x3B88, 0x3BA8, 0x4BC9, 0x4BE9,
  0x948C, 0x948C, 0x948C, 0x948C, 0x8C8C, 0x8C8C, 0x948D, 0x948D, 0x948D, 0x946D, 0x8C6E, 0x7C0D, 0x742D, 0x84CF, 0x848F, 0x844E, 0x8C6E, 0x946E, 0x948F, 0x94AF, 0x94CF, 0x94CF, 0x94EE, 0x8CEE, 0x8CEE, 0x8CEE, 0x8CEE, 0x8CCE, 0x94AE, 0x948E, 0x948E, 
        0x948E, 0x948E, 0x8C8E, 0x8C8E, 0x8C6E, 0x8C6F, 0x946F, 0x944F, 0x9430, 0x9430, 0x9410, 0x9410, 0x9450, 0x8C90, 0x8CF0, 0x8570, 0x7D71, 0x7D70, 0x7D91, 0x8572, 0x7CD1, 0x6C0D, 0x63EC, 0x748E, 0x6C4D, 0x640A, 0x5BE9, 0x5BC9, 0x53A8, 0x4B88, 
        0x4367, 0x4388, 0x4367, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x4347, 0x4347, 0x4367, 0x3B26, 0x4388, 0x4367, 0x4387, 0x4387, 0x4387, 0x4387, 0x4387, 0x3B66, 0x3366, 0x2B45, 0x2B25, 0x2B25, 0x2B25, 0x2B25, 0x3305, 0x3325, 0x3B25, 
        0x4346, 0x4346, 0x4B66, 0x5387, 0x63C8, 0x6C0A, 0x7C6B, 0x8CAC, 0x8CCD, 0x84CD, 0x84CD, 0x84CD, 0x7CCD, 0x7CCD, 0x74AD, 0x6C8D, 0x6C4C, 0x6C0D, 0x63ED, 0x63CC, 0x536C, 0x4B2B, 0x432A, 0x436B, 0x438B, 0x3BAB, 0x3BAB, 0x43AB, 0x4BCC, 0x5C0D, 
        0x646F, 0x64AF, 0x5CCF, 0x5D0E, 0x5D4F, 0x656F, 0x6D4F, 0x74EE, 0x748C, 0x6C4B, 0x6C4A, 0x744A, 0x744A, 0x744A, 0x744A, 0x744B, 0x744B, 0x7C4B, 0x7C4B, 0x7C6B, 0x7C6B, 0x7C8C, 0x7C8C, 0x848C, 0x848C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C6C, 
        0x846C, 0x846B, 0x846C, 0x846C, 0x848C, 0x7C6D, 0x7C30, 0x7396, 0x6AFC, 0x629E, 0x5A7E, 0x5A7D, 0x525D, 0x4A5D, 0x4A3D, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x421D, 0x3A1D, 0x3A1D, 0x3A1D, 0x41FD, 0x41FD, 0x421D, 0x421D, 0x421D, 
        0x4A3D, 0x527E, 0x5A9E, 0x5ABE, 0x62BD, 0x62DD, 0x62DD, 0x62FD, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x62FD, 0x62FD, 0x62DD, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62FE, 0x62FE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 
        0x5ABD, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x62FD, 0x631E, 0x6B3E, 0x6B1E, 0x6AFE, 0x62BD, 0x733E, 0x735E, 0x7B5D, 0x7B5D, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x7B7E, 0x739E, 0x739E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 
        0x7BBE, 0x7BBE, 0x83DE, 0x841E, 0x841E, 0x841E, 0x841E, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x739E, 0x6B3E, 0x5ADD, 0x6B9E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x6B9E, 0x6B7E, 
        0x635E, 0x635E, 0x633D, 0x5B1D, 0x5AFE, 0x52DD, 0x4A9D, 0x4A9E, 0x4A9D, 0x529D, 0x5ADE, 0x631E, 0x6B5E, 0x737E, 0x737E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x739E, 0x739E, 0x73BD, 0x7BDD, 0x841E, 0x8C5E, 0x8C9E, 0x8C9E, 0x8C9E, 0x94BE, 0x94DE, 
        0x94FE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9D1E, 0x9D1E, 0xA51E, 0xA53E, 0xA55E, 0xA55E, 0xA53E, 0x9CFE, 0x7C1E, 0x3A7D, 0x2A5D, 0x2A7D, 0x2A7D, 0x329D, 0x32BD, 0x32BE, 0x32DD, 0x3ADE, 0x3AFE, 0x3B1E, 0x431E, 0x433D, 
        0x4B5E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x535E, 0x3A9D, 0x2A5D, 0x225D, 0x2A7D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x431E, 0x3B1D, 0x3B1D, 0x3B1E, 0x3B3D, 0x3B3D, 0x435D, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 0x63BE, 
        0x63DE, 0x63DE, 0x6BFE, 0x741E, 0x5BB9, 0x4BD2, 0x5470, 0x64D0, 0x6CF1, 0x7512, 0x7D33, 0x8554, 0x8535, 0x7CD5, 0x7C95, 0x7C95, 0x7C94, 0x74B2, 0x74B0, 0x6CAD, 0x6C8B, 0x6C8A, 0x6C8A, 0x6C89, 0x6C69, 0x6C49, 0x6C49, 0x6C49, 0x6449, 0x6409, 
        0x5BE9, 0x53E8, 0x53C8, 0x4BA8, 0x43A7, 0x43A7, 0x3B87, 0x3387, 0x3387, 0x3367, 0x2B66, 0x2B66, 0x2B66, 0x2B86, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BC6, 0x33C6, 0x33C7, 0x33C6, 0x33A6, 0x33A6, 0x2B86, 0x3387, 0x2B66, 0x2B46, 0x2B26, 0x2B26, 
        0x2306, 0x22E6, 0x22C6, 0x1AC5, 0x1AC5, 0x22C5, 0x22E6, 0x2AE6, 0x3306, 0x3B27, 0x4347, 0x4388, 0x4BA8, 0x53C8, 0x5BE8, 0x6409, 0x6429, 0x6C29, 0x6C49, 0x746A, 0x746A, 0x746A, 0x746A, 0x746A, 0x7449, 0x6C49, 0x6C29, 0x6409, 0x6409, 0x5BE8, 
        0x53C8, 0x4BC8, 0x43A8, 0x3B87, 0x3B87, 0x3367, 0x2B47, 0x2B47, 0x2B27, 0x2B07, 0x2B07, 0x2B07, 0x2B07, 0x2B07, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x22E6, 0x2B06, 0x2B27, 0x3327, 0x3348, 0x3368, 0x3B88, 0x43A8, 0x4BC9,
  0x948C, 0x948C, 0x8C8C, 0x948C, 0x948C, 0x948C, 0x946D, 0x9C8D, 0x9C8D, 0x9C8E, 0x948E, 0x8C4E, 0x73CC, 0x7C2E, 0x842E, 0x8C4E, 0x8C6E, 0x948E, 0x948E, 0x94AE, 0x94CE, 0x94EE, 0x94CF, 0x8CCE, 0x84ED, 0x84ED, 0x8CCD, 0x8CCE, 0x94AE, 0x948E, 0x948E, 
        0x948E, 0x948E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x946F, 0x946F, 0x9450, 0x944F, 0x9C50, 0x9430, 0x942F, 0x8C6F, 0x8CAF, 0x8570, 0x7D70, 0x7D90, 0x7DB1, 0x85B2, 0x7D51, 0x748F, 0x746E, 0x8511, 0x7CAF, 0x6C2C, 0x63EA, 0x5BC9, 0x53C9, 0x5C0B, 
        0x4B89, 0x4368, 0x4348, 0x3B48, 0x4BC9, 0x4389, 0x3B47, 0x3B27, 0x4347, 0x4347, 0x4347, 0x53A9, 0x642C, 0x53CA, 0x4B89, 0x4367, 0x4388, 0x4387, 0x4387, 0x4387, 0x3B67, 0x3366, 0x3346, 0x2B25, 0x2B25, 0x2B25, 0x2B25, 0x3325, 0x3B25, 0x3B25, 
        0x4346, 0x4B66, 0x4B66, 0x5387, 0x63C8, 0x742A, 0x7C6B, 0x8CAC, 0x8CCD, 0x8CCD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x7CAD, 0x74AD, 0x748C, 0x744C, 0x742C, 0x6BEC, 0x63AC, 0x536B, 0x4B4A, 0x436B, 0x438B, 0x438B, 0x3BAB, 0x43CC, 0x53EC, 0x5C2E, 
        0x646F, 0x64AF, 0x5CCF, 0x5CEF, 0x5D2F, 0x654F, 0x6D2F, 0x6CEE, 0x748C, 0x744B, 0x744A, 0x744A, 0x744A, 0x744A, 0x7C4A, 0x7C4A, 0x7C4B, 0x7C4B, 0x7C4B, 0x846B, 0x846B, 0x848B, 0x848C, 0x848B, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C6C, 0x8C6C, 0x846C, 
        0x846C, 0x846B, 0x846B, 0x846C, 0x848C, 0x7C8C, 0x7C4E, 0x73D5, 0x6B1B, 0x629D, 0x5A7E, 0x5A7D, 0x525D, 0x4A5D, 0x4A3D, 0x423D, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x39FD, 0x41FD, 0x41FD, 
        0x421D, 0x4A3D, 0x527E, 0x5A9E, 0x5ABD, 0x5ABD, 0x62DD, 0x62FE, 0x6AFE, 0x62FD, 0x62DE, 0x62DE, 0x62DE, 0x62FE, 0x62DE, 0x62DD, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x62DE, 0x62DE, 0x5ADE, 0x5ABE, 
        0x5ABD, 0x5A9D, 0x5A9E, 0x5A9E, 0x529E, 0x5A7D, 0x5A7E, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A9D, 0x5ABD, 0x62BD, 0x6ADD, 0x733E, 0x7B7E, 0x7B9E, 0x839E, 0x7B9E, 0x7B7E, 0x7B7E, 0x7B7D, 0x7B7E, 0x7B9E, 0x739D, 0x739D, 0x739D, 0x73BE, 0x7BBE, 0x7BBE, 
        0x7BBE, 0x7BBE, 0x83DE, 0x7BFE, 0x841E, 0x7C1E, 0x7C1E, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BDE, 0x73BE, 0x6B3E, 0x5ABD, 0x635E, 0x6B9E, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x635E, 
        0x635E, 0x633E, 0x5B1D, 0x5AFD, 0x52DD, 0x52BD, 0x529E, 0x529E, 0x52BD, 0x5AFE, 0x635E, 0x735E, 0x737E, 0x737E, 0x739E, 0x737E, 0x737E, 0x737E, 0x739E, 0x739E, 0x73BE, 0x7BDE, 0x843E, 0x8C7E, 0x8C9E, 0x94BE, 0x94BE, 0x94BE, 0x94DE, 0x94FE, 
        0x94FE, 0x951E, 0x951E, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9D1E, 0xA51E, 0xA53E, 0xA55E, 0xA55E, 0xA53E, 0x9CFE, 0x845E, 0x429D, 0x2A5D, 0x2A5E, 0x2A7D, 0x2A9D, 0x32BD, 0x32BE, 0x32BE, 0x32DD, 0x32DE, 0x3AFD, 0x3B1E, 0x433E, 
        0x4B5E, 0x535E, 0x537D, 0x537E, 0x5B9E, 0x533E, 0x3A7D, 0x2A3D, 0x225D, 0x2A5D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x431E, 0x3B1D, 0x3B3D, 0x3B3E, 0x3B3D, 0x3B3D, 0x435E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63DE, 
        0x63DE, 0x63DE, 0x6BFE, 0x6BFE, 0x5BB9, 0x4BD1, 0x5450, 0x5CD0, 0x6CF1, 0x7512, 0x7533, 0x7D74, 0x8555, 0x7CF4, 0x7C94, 0x7C94, 0x7CB3, 0x7CB2, 0x74AF, 0x6CAC, 0x6CAB, 0x6CAA, 0x74AA, 0x7489, 0x6C89, 0x6C69, 0x6C69, 0x6C49, 0x6C49, 0x6429, 
        0x5C09, 0x5BE9, 0x5BC8, 0x53C8, 0x4BC8, 0x43A8, 0x3BA7, 0x3B87, 0x3387, 0x3387, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2BA6, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BC6, 0x33C6, 0x33E7, 0x33C7, 0x33C7, 0x33A7, 0x3386, 0x3367, 0x3367, 0x2B46, 0x2B26, 0x2B26, 
        0x2B06, 0x2AE6, 0x22C6, 0x22C5, 0x1AC5, 0x22C5, 0x22E6, 0x2AE6, 0x3306, 0x3B27, 0x4347, 0x4367, 0x4B88, 0x53C8, 0x5BC8, 0x63E8, 0x6409, 0x6C29, 0x6C49, 0x7449, 0x7449, 0x744A, 0x744A, 0x744A, 0x6C49, 0x6C29, 0x6C09, 0x6409, 0x5BE8, 0x5BC8, 
        0x4BC8, 0x43A8, 0x3B88, 0x3B67, 0x3367, 0x2B47, 0x2B27, 0x2B07, 0x2B07, 0x2AE6, 0x2AE6, 0x2AE7, 0x2AE6, 0x2AE7, 0x2AE6, 0x2AE6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x22E6, 0x2B07, 0x2B27, 0x3328, 0x3348, 0x3B68, 0x4388, 0x43A9,
  0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 0x946C, 0x946C, 0x946C, 0x9C6D, 0x9C8E, 0x9CAF, 0x9C8F, 0x8C0E, 0x7BCD, 0x7BEE, 0x8C0F, 0x8C2F, 0x8C6E, 0x8C8E, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CEE, 0x8CCE, 0x8CCE, 0x84CD, 0x84CD, 0x8CCD, 0x8CCE, 0x94AE, 0x948E, 0x948E, 
        0x948E, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8C8E, 0x8C8F, 0x946F, 0x946F, 0x946F, 0x9C6F, 0x9C6F, 0x9C4F, 0x946E, 0x8C8E, 0x8D50, 0x7D6F, 0x756F, 0x7DD0, 0x85D1, 0x8591, 0x8571, 0x8572, 0x8D93, 0x8D72, 0x84F0, 0x748E, 0x5BCB, 0x748E, 0x74CF, 
        0x640C, 0x4349, 0x4348, 0x53EB, 0x6CCF, 0x6CAE, 0x644D, 0x4349, 0x4B49, 0x4348, 0x4B89, 0x7CCF, 0x7CEF, 0x74AF, 0x5C0C, 0x53A9, 0x4B68, 0x4B88, 0x4B88, 0x4BC8, 0x4387, 0x3B67, 0x3346, 0x2B26, 0x2B25, 0x2B25, 0x2B25, 0x3325, 0x3B25, 0x3B45, 
        0x4346, 0x4B66, 0x4B86, 0x5BA7, 0x63C8, 0x7C4A, 0x846B, 0x8CAC, 0x8CCD, 0x8CCD, 0x8CCD, 0x8CCD, 0x8CED, 0x84CD, 0x84CD, 0x7CAC, 0x7C8C, 0x744C, 0x744C, 0x742C, 0x6C0C, 0x5BAB, 0x4B6B, 0x4B4B, 0x4B6B, 0x438B, 0x43CB, 0x4BCC, 0x53ED, 0x644E, 
        0x648F, 0x64AF, 0x5CCF, 0x5CCE, 0x550E, 0x652F, 0x6D2F, 0x6D0E, 0x748D, 0x744B, 0x744A, 0x7C2A, 0x7C2A, 0x7C4A, 0x7C4A, 0x7C4A, 0x844A, 0x844B, 0x844B, 0x846B, 0x846B, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 
        0x844B, 0x846B, 0x846B, 0x846C, 0x848C, 0x846C, 0x844D, 0x73F2, 0x6B39, 0x62BD, 0x627E, 0x5A7D, 0x525D, 0x4A3D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 
        0x41FD, 0x421D, 0x4A3D, 0x525D, 0x5A9E, 0x5ABD, 0x62BE, 0x62DE, 0x62FD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABE, 0x62DE, 0x5ADD, 0x5ABE, 0x5ADE, 0x5ABE, 0x5ABE, 0x5ABE, 
        0x52BE, 0x529E, 0x529E, 0x529E, 0x529E, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x629C, 0x629C, 0x6ADD, 0x733D, 0x7B5E, 0x7B9E, 0x839E, 0x839E, 0x7B9E, 0x7B9D, 0x7B9D, 0x7B9D, 0x7B9D, 0x7B9E, 0x7B9E, 
        0x7BBE, 0x7BBE, 0x7BBE, 0x7BFE, 0x83FE, 0x7C1E, 0x7BFE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BDE, 0x73DE, 0x73BE, 0x739D, 0x6B5E, 0x62DD, 0x631E, 0x6B7E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x635E, 0x635E, 0x633E, 
        0x5B3E, 0x5B1E, 0x5AFE, 0x52DD, 0x52BD, 0x4A9D, 0x529D, 0x52DE, 0x631E, 0x6B3E, 0x6B7E, 0x737E, 0x737E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x7BFE, 0x843E, 0x8C7E, 0x8CBE, 0x94DE, 0x94DE, 0x94DE, 0x94DE, 0x94DE, 0x94FE, 
        0x94FE, 0x951E, 0x951E, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9D1E, 0xA51F, 0xA53F, 0xA55E, 0xA55E, 0xA53E, 0x9D1F, 0x8C7E, 0x4ADD, 0x323D, 0x2A5D, 0x2A7D, 0x2A9D, 0x329D, 0x2ABE, 0x32BD, 0x32DE, 0x32DE, 0x3AFD, 0x3B1D, 0x431E, 
        0x4B3E, 0x4B5E, 0x537D, 0x537E, 0x5B7E, 0x4B1E, 0x3A7D, 0x223D, 0x223D, 0x2A5D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1D, 0x3B1E, 0x3B3E, 0x3B3E, 0x433D, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x4B9E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63DE, 
        0x63DE, 0x63DE, 0x6BFE, 0x6BFE, 0x5378, 0x4BD1, 0x5450, 0x5CB0, 0x6CF1, 0x6D12, 0x7533, 0x7D54, 0x8534, 0x7CD4, 0x7494, 0x7474, 0x7493, 0x74B0, 0x6C8E, 0x6C8B, 0x6CAA, 0x6CAA, 0x74AA, 0x74AA, 0x748A, 0x6C8A, 0x6C69, 0x6C69, 0x6C49, 0x6429, 
        0x6409, 0x5C09, 0x5BE8, 0x53C8, 0x4BC8, 0x4BC8, 0x43A8, 0x3BA7, 0x3BA7, 0x3387, 0x2B87, 0x2B86, 0x2B86, 0x2B86, 0x2BA6, 0x2BC6, 0x2BC6, 0x33C6, 0x33C6, 0x33E7, 0x33E7, 0x33E7, 0x33C7, 0x33A7, 0x33A7, 0x3367, 0x3367, 0x3347, 0x2B26, 0x2B26, 
        0x2B06, 0x2AE6, 0x22C6, 0x22C6, 0x1AC5, 0x22C5, 0x22C6, 0x22E6, 0x2AE6, 0x3306, 0x3B47, 0x4367, 0x4B88, 0x53A8, 0x5BC8, 0x63E8, 0x6409, 0x6C29, 0x6C49, 0x6C49, 0x6C49, 0x6C2A, 0x6C29, 0x6C2A, 0x6C29, 0x6C09, 0x63E9, 0x5BC9, 0x53C8, 0x53A8, 
        0x4B88, 0x4368, 0x3B67, 0x3347, 0x2B27, 0x2B07, 0x2307, 0x22E6, 0x22E6, 0x22C6, 0x22C6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 0x22C6, 0x22E7, 0x2B07, 0x3328, 0x3348, 0x3368, 0x3B88, 0x43A8,
  0x844B, 0x844C, 0x846C, 0x844C, 0x842C, 0x8C2C, 0x8C4C, 0x944D, 0x9C8E, 0xA4AF, 0x9C4F, 0x940E, 0x8BCE, 0x8BCE, 0x8C0F, 0x8C4F, 0x946F, 0x8C8E, 0x8CAE, 0x8CCE, 0x8CCE, 0x8CCE, 0x8CCE, 0x84CE, 0x84CE, 0x84CE, 0x8CCD, 0x8CCE, 0x8CAE, 0x94AE, 0x94AF, 
        0x94AE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8C8F, 0x948F, 0x948F, 0x946F, 0x946F, 0x9C6F, 0x944E, 0x946E, 0x946E, 0x84CE, 0x74EE, 0x7D6F, 0x7D8F, 0x7DB0, 0x7DD0, 0x85D2, 0x8DD2, 0x95D3, 0x95D4, 0x8D73, 0x8511, 0x74B0, 0x8531, 0x7D10, 
        0x748F, 0x5BCC, 0x4BAA, 0x7D30, 0x7D30, 0x7510, 0x7D10, 0x6C6E, 0x6C4E, 0x536A, 0x746E, 0x8D72, 0x7D11, 0x8531, 0x7CD0, 0x63CC, 0x538A, 0x4B69, 0x644C, 0x6CAD, 0x53EA, 0x3B48, 0x3347, 0x3346, 0x2B26, 0x2B25, 0x2B25, 0x3305, 0x3B25, 0x4345, 
        0x4346, 0x4B66, 0x5387, 0x5BA7, 0x63E9, 0x7C4B, 0x846C, 0x8CAD, 0x94CD, 0x94CC, 0x8CCC, 0x8CCC, 0x8CCC, 0x8CCC, 0x84CC, 0x84AC, 0x7C8B, 0x7C6B, 0x746B, 0x7C4C, 0x742C, 0x6BEC, 0x5BAB, 0x4B6B, 0x4B6A, 0x438A, 0x43AB, 0x43CB, 0x540C, 0x5C2D, 
        0x648E, 0x64AF, 0x5CCF, 0x5CCE, 0x54EE, 0x5CEE, 0x650F, 0x6CEE, 0x74AD, 0x7C6B, 0x7C4A, 0x7C4A, 0x7C4A, 0x7C4A, 0x844A, 0x844B, 0x844B, 0x844B, 0x8C4B, 0x846B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C6C, 0x8C6B, 0x8C6B, 
        0x844B, 0x846B, 0x846C, 0x8C6C, 0x8C8C, 0x846C, 0x844D, 0x7C10, 0x7357, 0x6ABC, 0x627E, 0x5A7D, 0x525D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39DD, 
        0x41DD, 0x41FD, 0x4A1D, 0x4A3D, 0x525D, 0x5A9E, 0x5A9D, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 0x62DD, 0x62BD, 0x5ADD, 0x5ABD, 0x5ABD, 0x5ADE, 0x5ABE, 0x5ABE, 0x5ADD, 0x5ADD, 0x5ADE, 0x5ADD, 0x5ABD, 0x5ABD, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ABE, 0x52BE, 
        0x529E, 0x529E, 0x529E, 0x529D, 0x527E, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x525D, 0x5A7D, 0x5A5E, 0x5A5E, 0x5A5D, 0x5A5D, 0x625D, 0x627D, 0x627D, 0x629D, 0x6ABD, 0x731D, 0x7B5E, 0x839E, 0x83BE, 0x83BE, 0x839E, 0x7B9E, 0x7B9E, 
        0x7B9E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 0x7BDE, 0x7BBE, 0x739E, 0x739E, 0x739E, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BBE, 0x739D, 0x6B5E, 0x62FE, 0x62FE, 0x6B5E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x633E, 0x633E, 0x5B1E, 
        0x5AFE, 0x52FE, 0x52DD, 0x52BD, 0x529D, 0x529D, 0x5ADD, 0x631E, 0x6B3E, 0x737E, 0x737E, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x739E, 0x739E, 0x73BE, 0x7C1E, 0x845E, 0x8C7E, 0x8CBE, 0x94DE, 0x94DE, 0x94FE, 0x94FE, 0x94FE, 0x94FE, 0x94FE, 
        0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0xA51E, 0xA53F, 0xA53F, 0xA55E, 0xA53F, 0xA53F, 0xA51F, 0x94BE, 0x5B3E, 0x323D, 0x2A5D, 0x2A5D, 0x2A7E, 0x329D, 0x2A9D, 0x2ABD, 0x32DD, 0x32DD, 0x32FD, 0x3AFD, 0x431D, 
        0x433D, 0x4B5E, 0x537D, 0x537E, 0x537D, 0x4B1E, 0x327D, 0x2A3D, 0x223D, 0x2A5D, 0x2A9D, 0x32BE, 0x3ADE, 0x3AFE, 0x3AFE, 0x3B1D, 0x3B1E, 0x433E, 0x433E, 0x435E, 0x435E, 0x437E, 0x4B7E, 0x4B9E, 0x539E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63DE, 
        0x63DE, 0x63DE, 0x6BFE, 0x6BFE, 0x5377, 0x4BB1, 0x5430, 0x5CB1, 0x64F1, 0x6D11, 0x7532, 0x7D53, 0x7D14, 0x74B4, 0x6C93, 0x6C53, 0x6C72, 0x6C8F, 0x6C6C, 0x6C8B, 0x6C8A, 0x6CAA, 0x74AA, 0x74AA, 0x74AA, 0x6C8A, 0x6C89, 0x6C69, 0x6C69, 0x6449, 
        0x6429, 0x6409, 0x5BE8, 0x53E8, 0x4BC8, 0x4BC8, 0x43C8, 0x3BC7, 0x3BA7, 0x33A7, 0x33A6, 0x33A6, 0x2B86, 0x2BA6, 0x2BA6, 0x2BC6, 0x33C6, 0x33C6, 0x33C7, 0x33C7, 0x3BC7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3366, 0x2B46, 0x2B26, 0x2B26, 
        0x2B06, 0x22E6, 0x22C6, 0x22C6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x2AE6, 0x3306, 0x3B47, 0x4367, 0x4B88, 0x53A8, 0x53C8, 0x5BE8, 0x6409, 0x6408, 0x6C29, 0x6C49, 0x6C49, 0x6C29, 0x6C29, 0x6C09, 0x6409, 0x63E9, 0x5BC9, 0x53A9, 0x53A8, 0x4B88, 
        0x4368, 0x3B47, 0x3327, 0x3327, 0x2B07, 0x2AE7, 0x22C6, 0x22C6, 0x22C6, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E7, 0x2B07, 0x2B27, 0x2B28, 0x3348, 0x3368, 0x3B88,
  0x744C, 0x7C4C, 0x7C4C, 0x7C2C, 0x7BEC, 0x83EC, 0x8C2D, 0x944D, 0x9C6E, 0x9C8F, 0x9C4E, 0x93EE, 0x8BCE, 0x8BCE, 0x8C0F, 0x8C4F, 0x8C8F, 0x8C8E, 0x84CE, 0x84CE, 0x84CE, 0x84EE, 0x8CCE, 0x84CE, 0x84CE, 0x84CE, 0x8CCD, 0x8CEE, 0x8CCE, 0x94AE, 0x94AE, 
        0x94AE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x948F, 0x948F, 0x946F, 0x946F, 0x946E, 0x946E, 0x946E, 0x946E, 0x848E, 0x84CE, 0x7D4F, 0x756F, 0x758F, 0x7DAF, 0x7DB0, 0x85D1, 0x8DD2, 0x8DD2, 0x8DB2, 0x8D92, 0x9593, 0x8D72, 0x8552, 
        0x8512, 0x74AF, 0x6C8E, 0x8571, 0x7D51, 0x7D51, 0x8572, 0x8532, 0x8511, 0x7C8F, 0x8D31, 0x8D72, 0x8531, 0x8D73, 0x8D32, 0x7CB0, 0x640D, 0x5BCC, 0x8510, 0x74AF, 0x642D, 0x53CB, 0x5C2C, 0x3B47, 0x3346, 0x2B25, 0x2B25, 0x3325, 0x3B25, 0x4345, 
        0x4366, 0x4B66, 0x5387, 0x5BA8, 0x6BE9, 0x7C2B, 0x8C6C, 0x94AD, 0x94AC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x8CCC, 0x8CCC, 0x84AB, 0x84AB, 0x7C8B, 0x7C8B, 0x848C, 0x846C, 0x742C, 0x6BEB, 0x5BAB, 0x4B6A, 0x438A, 0x43AA, 0x43CB, 0x4C0C, 0x5C2D, 
        0x646E, 0x648E, 0x5C8E, 0x5CAE, 0x5CAE, 0x5CCF, 0x64CF, 0x6CCE, 0x74AD, 0x846B, 0x7C4A, 0x844A, 0x844A, 0x844A, 0x844A, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C6B, 0x8C6B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 
        0x8C4B, 0x8C6B, 0x8C6B, 0x8C8C, 0x8C8C, 0x8C6C, 0x844D, 0x7C2E, 0x7394, 0x6ADA, 0x627D, 0x5A5E, 0x523D, 0x4A3D, 0x4A3E, 0x421D, 0x421D, 0x3A1D, 0x39FD, 0x3A1D, 0x31FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39DD, 
        0x39DD, 0x41DD, 0x41FD, 0x4A1D, 0x4A3D, 0x525D, 0x5A7E, 0x5A9D, 0x5ABE, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADE, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x529E, 
        0x529E, 0x529E, 0x529E, 0x527D, 0x4A7D, 0x527D, 0x525D, 0x525D, 0x525D, 0x525D, 0x525D, 0x525D, 0x5A5D, 0x5A3D, 0x5A5D, 0x627D, 0x627D, 0x629D, 0x6A9D, 0x6ABD, 0x72DD, 0x72DD, 0x72FD, 0x7B1D, 0x7B3D, 0x7B5E, 0x7B7E, 0x7B5E, 0x731D, 0x72FD, 
        0x6ADD, 0x629C, 0x627C, 0x627C, 0x62BC, 0x6AFD, 0x6AFD, 0x6B1D, 0x6B1D, 0x733E, 0x7B7E, 0x7B9E, 0x7BBE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BBE, 0x7BDE, 0x7BBE, 0x737E, 0x6AFD, 0x6AFD, 0x6B1D, 0x6B3E, 0x6B5E, 0x633E, 0x633E, 0x5B1E, 0x5B1E, 0x5AFE, 
        0x52DE, 0x52DD, 0x52BD, 0x529D, 0x529D, 0x5ADD, 0x631E, 0x6B3E, 0x735E, 0x737E, 0x737E, 0x739E, 0x739E, 0x7BBE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x7BFE, 0x845E, 0x8C9E, 0x8C9E, 0x8CDE, 0x94DE, 0x94FE, 0x94FE, 0x951E, 0x951E, 0x94FE, 0x9D1E, 
        0x9D1E, 0x9CFF, 0x9CFF, 0x9D1E, 0x9D1E, 0x9CFE, 0x9CFE, 0x9CFE, 0x9D1E, 0xA51E, 0xA53F, 0xA53E, 0xA55E, 0xA53E, 0xA53E, 0xA51F, 0x94DE, 0x6B9E, 0x3A3D, 0x2A3D, 0x2A5D, 0x2A7D, 0x2A7D, 0x2A7D, 0x2A9D, 0x32BE, 0x32DE, 0x32DD, 0x3AFD, 0x3B1D, 
        0x433D, 0x4B5E, 0x4B5E, 0x537E, 0x537D, 0x4B1E, 0x327D, 0x2A3D, 0x223D, 0x2A5D, 0x2A9D, 0x32BE, 0x3ADE, 0x3AFE, 0x3AFE, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x435E, 0x435E, 0x437E, 0x4B7E, 0x4B9E, 0x539E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63DE, 
        0x63DE, 0x63DE, 0x6BFE, 0x6BFE, 0x5376, 0x4391, 0x5430, 0x5C90, 0x6CF1, 0x6D12, 0x7532, 0x7533, 0x7513, 0x74B3, 0x6C73, 0x6C72, 0x6C70, 0x646D, 0x646B, 0x646A, 0x6C8A, 0x6C89, 0x6C8A, 0x74AA, 0x74AA, 0x74AA, 0x6C8A, 0x6C8A, 0x6C6A, 0x6C49, 
        0x6429, 0x6409, 0x5C09, 0x5BE8, 0x53E8, 0x4BC8, 0x43C8, 0x43C7, 0x3BC7, 0x33A7, 0x33A7, 0x33A6, 0x33A6, 0x2BA6, 0x2BC6, 0x33C6, 0x33E6, 0x33C6, 0x33C7, 0x33C7, 0x33E7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x2B46, 0x2B26, 0x2B06, 
        0x2B06, 0x22E6, 0x22C6, 0x22C6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x2AE6, 0x3306, 0x3327, 0x4347, 0x4B67, 0x4BA8, 0x53C8, 0x5BC8, 0x63E8, 0x6409, 0x6C29, 0x6C29, 0x6C29, 0x6C29, 0x6C09, 0x6409, 0x63E9, 0x63C9, 0x5BC8, 0x53A8, 0x4B88, 0x4368, 
        0x3B47, 0x3327, 0x3307, 0x2B06, 0x2AE6, 0x22C6, 0x22A6, 0x1AA5, 0x1A85, 0x1A86, 0x1A86, 0x1A86, 0x22A6, 0x22A6, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E7, 0x2AE7, 0x2B07, 0x2B27, 0x3348, 0x3368, 0x3368,
  0x746D, 0x746D, 0x746D, 0x744D, 0x7C2D, 0x7C2D, 0x8C4E, 0x946E, 0x946F, 0x9C6F, 0x9C2F, 0x940E, 0x93EF, 0x940F, 0x8C2F, 0x8C4F, 0x8C8F, 0x8CAE, 0x84CE, 0x84CE, 0x84CD, 0x84ED, 0x84CE, 0x84CE, 0x84CD, 0x84CD, 0x84ED, 0x8CEE, 0x8CCE, 0x94AE, 0x94AE, 
        0x8CAE, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8C8F, 0x948F, 0x948F, 0x948F, 0x946E, 0x946E, 0x944E, 0x944E, 0x8C4E, 0x8CAE, 0x84EF, 0x754F, 0x756F, 0x75AF, 0x7DAF, 0x7DD0, 0x85F1, 0x85D1, 0x85D1, 0x85B2, 0x85B2, 0x8591, 0x8DB3, 
        0x8D72, 0x8551, 0x8D91, 0x8592, 0x7D51, 0x8592, 0x8DB3, 0x8D93, 0x8D73, 0x9593, 0x9592, 0x8D71, 0x8551, 0x8D93, 0x8D53, 0x8D33, 0x84D1, 0x84D0, 0x8D32, 0x7CF1, 0x74D1, 0x640E, 0x642E, 0x3B67, 0x3346, 0x2B25, 0x2B25, 0x3326, 0x3B26, 0x4346, 
        0x4B66, 0x5387, 0x5BA7, 0x63C8, 0x6BEA, 0x842B, 0x8C6C, 0x948D, 0x94AD, 0x94AC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x8CAB, 0x8CAB, 0x84AB, 0x84AB, 0x848B, 0x8C8B, 0x8C8C, 0x846C, 0x744C, 0x63EB, 0x4B89, 0x4369, 0x438A, 0x43AA, 0x4BCB, 0x5C0D, 
        0x5C4E, 0x648E, 0x5C8E, 0x5C8E, 0x5C8E, 0x5C8E, 0x64AF, 0x6CCE, 0x74AD, 0x846C, 0x844B, 0x844A, 0x844A, 0x844B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x946B, 0x946B, 0x946B, 0x946B, 0x8C4B, 0x8C4B, 0x8C4B, 
        0x8C4B, 0x8C6B, 0x8C6C, 0x8C6C, 0x8C8C, 0x8C6C, 0x846C, 0x844E, 0x7BF1, 0x6B18, 0x629C, 0x5A5D, 0x523D, 0x4A3D, 0x4A1D, 0x421D, 0x421D, 0x39FD, 0x39FD, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 
        0x39DD, 0x39DD, 0x41DD, 0x49FD, 0x4A1D, 0x4A3D, 0x525D, 0x527D, 0x5A9D, 0x5ABD, 0x5ABD, 0x5A9D, 0x5A9D, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABE, 0x5ABE, 0x5ABE, 0x52BE, 0x52BD, 0x529D, 0x529E, 0x529E, 0x529D, 0x529D, 0x527D, 
        0x527D, 0x527D, 0x527D, 0x527D, 0x525D, 0x525D, 0x525D, 0x525D, 0x525D, 0x5A7D, 0x5A9D, 0x62BD, 0x731E, 0x7B5E, 0x7B7E, 0x837E, 0x837E, 0x7B5E, 0x7B5E, 0x7B3E, 0x7B3D, 0x7B3D, 0x7B1D, 0x7AFD, 0x7AFD, 0x7AFD, 0x72FD, 0x72DD, 0x72DD, 0x72BD, 
        0x6ABD, 0x6ABE, 0x6A9E, 0x6A9E, 0x6A9D, 0x6A9D, 0x627D, 0x627D, 0x627D, 0x627D, 0x6ABD, 0x6AFD, 0x6B1D, 0x733D, 0x7B7E, 0x7B9E, 0x83BE, 0x83BE, 0x7BBE, 0x7B7E, 0x731D, 0x6ADD, 0x6AFD, 0x6B1E, 0x6B3E, 0x631E, 0x5AFE, 0x5AFE, 0x5ADE, 0x52DE, 
        0x52BE, 0x529E, 0x529D, 0x527D, 0x52BD, 0x631E, 0x6B3E, 0x737E, 0x737E, 0x737E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x7BDE, 0x7BFE, 0x7C1E, 0x843E, 0x8C7E, 0x8C9E, 0x8CBE, 0x8CDE, 0x94DE, 0x94FE, 0x951E, 0x951E, 0x951E, 0x9D1E, 0x9D1E, 
        0x9D1E, 0x9D1E, 0x9D1F, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0xA51E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA51E, 0x94DE, 0x7C1E, 0x3A3D, 0x2A1D, 0x2A3D, 0x2A5D, 0x2A7D, 0x2A7D, 0x2A9D, 0x32BE, 0x32BE, 0x32DD, 0x32FD, 0x3B1E, 
        0x431E, 0x433E, 0x4B5E, 0x4B5E, 0x4B5D, 0x4AFE, 0x327D, 0x2A1D, 0x223D, 0x2A5D, 0x2A9D, 0x32BD, 0x3ADE, 0x3ADE, 0x3AFD, 0x3B1E, 0x3B1E, 0x433E, 0x433E, 0x435E, 0x435E, 0x437E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63BE, 
        0x63BE, 0x63DE, 0x6BDE, 0x6BDD, 0x5356, 0x43B0, 0x5430, 0x5C90, 0x64D1, 0x6D11, 0x7532, 0x7533, 0x74F3, 0x6CB3, 0x6C93, 0x6CB2, 0x6C6F, 0x646C, 0x646B, 0x6469, 0x6469, 0x6C89, 0x6C89, 0x6C89, 0x6C8A, 0x6C8A, 0x6C8A, 0x6C8A, 0x6C6A, 0x6C4A, 
        0x6449, 0x6429, 0x6409, 0x5C08, 0x53E8, 0x4BE8, 0x4BE8, 0x43C7, 0x3BC7, 0x3BC7, 0x33C7, 0x33C6, 0x33C6, 0x2BC6, 0x33C6, 0x33C6, 0x33E7, 0x33C7, 0x33C7, 0x3BC7, 0x33E7, 0x3BC7, 0x33C7, 0x33C7, 0x33A7, 0x3367, 0x3347, 0x3327, 0x2B27, 0x2B06, 
        0x2AE6, 0x2AE6, 0x22C6, 0x22A6, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x2AC6, 0x2AE6, 0x3327, 0x3B47, 0x4367, 0x4B88, 0x53C8, 0x5BC8, 0x5BE8, 0x6409, 0x6409, 0x6C29, 0x6409, 0x6C09, 0x6409, 0x63E9, 0x63C8, 0x5BA8, 0x5388, 0x4B68, 0x4368, 0x4347, 
        0x3B27, 0x3307, 0x2AE6, 0x2AC6, 0x2AA6, 0x2286, 0x1A85, 0x1A65, 0x1A65, 0x1A65, 0x1A65, 0x1A86, 0x1A86, 0x2286, 0x22A6, 0x22A6, 0x22A6, 0x22C7, 0x22C7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B28, 0x3347, 0x3367,
  0x74AE, 0x74AE, 0x74AE, 0x7CAE, 0x7C8E, 0x848F, 0x848F, 0x8C6F, 0x946E, 0x946E, 0x944E, 0x942F, 0x942F, 0x944F, 0x8C4F, 0x8C6F, 0x8C8E, 0x8CAE, 0x84CE, 0x84CD, 0x84CD, 0x84CD, 0x84CE, 0x84CD, 0x84CE, 0x84CD, 0x84CD, 0x84CE, 0x8CCE, 0x94AE, 0x94AE, 
        0x948E, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x948E, 0x948E, 0x948E, 0x948E, 0x946E, 0x944E, 0x942E, 0x942E, 0x8C6E, 0x84AF, 0x7CEF, 0x754F, 0x758F, 0x7DAF, 0x7DF0, 0x85D0, 0x85D1, 0x85D1, 0x85D1, 0x85B1, 0x7DB1, 0x85B2, 
        0x8591, 0x8592, 0x8DB2, 0x8592, 0x7D51, 0x8DD2, 0x8DD3, 0x8DB3, 0x8D92, 0x95B3, 0x9592, 0x8D71, 0x95D3, 0x95B3, 0x8D72, 0x9573, 0x9573, 0x9573, 0x8D52, 0x8532, 0x8533, 0x7CD2, 0x6C4F, 0x4368, 0x3B47, 0x3326, 0x3326, 0x3B46, 0x3B26, 0x4346, 
        0x4B86, 0x5BC8, 0x6C09, 0x740A, 0x7C0B, 0x844C, 0x8C6D, 0x946D, 0x9C8D, 0x9CAC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x8CAB, 0x8CAB, 0x8CAB, 0x8CAB, 0x8CAB, 0x8CAB, 0x8C8C, 0x846C, 0x742C, 0x53AA, 0x4369, 0x3B6A, 0x3B8A, 0x43AB, 0x53EC, 
        0x5C2D, 0x5C4E, 0x5C6E, 0x5C4E, 0x546E, 0x5C6E, 0x64AF, 0x74CE, 0x7CAD, 0x846C, 0x844B, 0x846B, 0x8C6B, 0x8C6B, 0x8C6B, 0x946B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6C, 0x8C6C, 0x946C, 0x946B, 0x946C, 0x946B, 0x8C4B, 0x8C4B, 0x8C4B, 
        0x8C4B, 0x8C6C, 0x8C6C, 0x948C, 0x948C, 0x8C6C, 0x8C6C, 0x846D, 0x840F, 0x7375, 0x6ADA, 0x5A7C, 0x523D, 0x4A3D, 0x4A1D, 0x421D, 0x41FD, 0x41FD, 0x39FD, 0x39FD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x39DD, 0x31DD, 0x39DD, 0x31DD, 0x31DD, 0x39DD, 
        0x39DD, 0x39DD, 0x41DD, 0x41FD, 0x49FD, 0x4A1D, 0x523D, 0x525D, 0x527E, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A9E, 0x529D, 0x529D, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABE, 0x5A9E, 0x5A9D, 0x5A9D, 0x529D, 0x527D, 0x527D, 0x527D, 0x527D, 
        0x527D, 0x525D, 0x525D, 0x5A7D, 0x5A9D, 0x62BE, 0x6AFF, 0x731E, 0x7B7E, 0x7B9E, 0x83BE, 0x83BE, 0x7B7E, 0x7B3D, 0x7B1D, 0x7B1D, 0x72FD, 0x72FD, 0x7AFD, 0x7B1E, 0x7AFD, 0x7AFE, 0x7AFD, 0x7AFD, 0x7AFD, 0x7ADD, 0x7ADD, 0x7ADE, 0x72DE, 0x72DE, 
        0x72DE, 0x72DE, 0x72DE, 0x72DE, 0x72BE, 0x6ABE, 0x6A9E, 0x627D, 0x627D, 0x627D, 0x6A7D, 0x629D, 0x6ABD, 0x6ABC, 0x6ADD, 0x72FD, 0x7B3E, 0x7B7E, 0x7B9E, 0x7B7E, 0x735E, 0x6B1D, 0x6AFD, 0x6AFD, 0x6B1E, 0x62FE, 0x5ADD, 0x5ABD, 0x52BD, 0x529D, 
        0x529E, 0x529D, 0x529D, 0x5ABD, 0x631E, 0x6B3E, 0x6B5E, 0x737E, 0x737E, 0x737E, 0x737E, 0x739E, 0x739E, 0x7BBE, 0x7BDE, 0x7BFE, 0x7C1E, 0x843E, 0x847E, 0x8C9E, 0x94BE, 0x94DE, 0x94DE, 0x94DE, 0x94FE, 0x94FE, 0x951E, 0x9D1E, 0x9D1E, 0x9D1E, 
        0x9D1E, 0x9D1F, 0x9D1F, 0x9D1F, 0x9D1F, 0x9D1E, 0x9D1E, 0x9D1E, 0xA51E, 0xA51E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA51E, 0x9CFE, 0x845F, 0x427D, 0x29FD, 0x2A1D, 0x2A3D, 0x2A5D, 0x2A7D, 0x2A7D, 0x329E, 0x32BE, 0x32DD, 0x32FD, 0x3AFD, 
        0x431E, 0x433E, 0x4B3E, 0x4B5E, 0x4B5D, 0x4AFE, 0x325D, 0x221D, 0x223D, 0x2A5D, 0x2A9D, 0x32BD, 0x3ADE, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B3E, 0x433E, 0x433E, 0x435E, 0x437E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63BE, 
        0x63BE, 0x63DE, 0x6BDE, 0x6BDD, 0x4B35, 0x438F, 0x5410, 0x5C70, 0x64D1, 0x6D11, 0x7512, 0x7513, 0x74D3, 0x74B3, 0x74B4, 0x74B1, 0x646E, 0x5C4B, 0x646A, 0x6449, 0x6469, 0x6469, 0x6C89, 0x6C89, 0x6C89, 0x6C89, 0x6C89, 0x6C8A, 0x6C8A, 0x6C6A, 
        0x6C4A, 0x6449, 0x6429, 0x5C09, 0x5C09, 0x53E8, 0x4BE8, 0x4BE8, 0x43E7, 0x3BC7, 0x3BC7, 0x3BC7, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x33E7, 0x33C7, 0x33C7, 0x3BE7, 0x3BE7, 0x3BC7, 0x33C7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x3327, 0x2B07, 0x2B06, 
        0x2AE6, 0x2AE6, 0x2AC6, 0x22C6, 0x22C6, 0x22A6, 0x22A6, 0x22C6, 0x2AC6, 0x2AE6, 0x3327, 0x3B47, 0x4367, 0x4B88, 0x53A8, 0x53C8, 0x5BE8, 0x63E9, 0x6409, 0x6409, 0x6409, 0x63E8, 0x63C8, 0x63C8, 0x5BA8, 0x5B88, 0x5388, 0x4B68, 0x4347, 0x3B27, 
        0x3307, 0x2AE7, 0x2AC6, 0x22A6, 0x2285, 0x1A65, 0x1A65, 0x1A45, 0x1A45, 0x1245, 0x1A65, 0x1A65, 0x1A86, 0x1A86, 0x2286, 0x22A6, 0x22A6, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x3347, 0x3347,
  0x74EE, 0x74EE, 0x74CE, 0x7CCE, 0x7CAF, 0x7CAF, 0x848F, 0x8C6F, 0x946E, 0x946E, 0x946F, 0x946F, 0x946F, 0x8C6F, 0x8C6F, 0x8C8E, 0x848E, 0x84AE, 0x84CE, 0x84CE, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x7CCE, 0x7CAD, 0x84CD, 0x84CD, 0x8CCE, 0x8CAE, 0x94AE, 
        0x94AE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CAE, 0x8CAE, 0x8CAE, 0x948E, 0x948E, 0x948E, 0x946E, 0x946E, 0x944E, 0x9C2F, 0x942F, 0x846F, 0x7CCF, 0x752F, 0x7D6F, 0x7D8F, 0x7DAF, 0x7DB0, 0x7DB0, 0x85B0, 0x85B0, 0x85D1, 0x85D1, 0x7DB1, 
        0x7D91, 0x85D1, 0x85B1, 0x8591, 0x8591, 0x8DF2, 0x8DD2, 0x8DB2, 0x8D71, 0x8D71, 0x8551, 0x8D91, 0x95F3, 0x95D3, 0x95B3, 0x95B3, 0x9593, 0x8D72, 0x8532, 0x8D72, 0x8D73, 0x84F2, 0x7471, 0x53AC, 0x4BAA, 0x4BCA, 0x5C4B, 0x5C2B, 0x4327, 0x4B67, 
        0x5388, 0x6BE9, 0x7C2B, 0x7C4B, 0x842C, 0x8C4C, 0x946D, 0x946D, 0x9C8D, 0x9CAC, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CCC, 0x94CC, 0x94CC, 0x94AB, 0x94AB, 0x8CAB, 0x94CB, 0x94AC, 0x94AC, 0x948C, 0x846C, 0x640B, 0x438A, 0x3B69, 0x3B69, 0x438A, 0x4BAB, 
        0x53CD, 0x5C0D, 0x5C0D, 0x540E, 0x5C4E, 0x5C6E, 0x6CAF, 0x74CF, 0x7CAE, 0x8C8C, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C8B, 0x8C8B, 0x946B, 0x946B, 0x946B, 0x946B, 0x946B, 0x946C, 0x946C, 0x946C, 0x946C, 0x946B, 0x944B, 0x944B, 0x944C, 0x944C, 0x946C, 
        0x8C6C, 0x946C, 0x8C8C, 0x948C, 0x948C, 0x8C8C, 0x8C8C, 0x8C8D, 0x8C4E, 0x7BF1, 0x7337, 0x629B, 0x523D, 0x4A3D, 0x4A1D, 0x421D, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DC, 0x39DC, 0x31DC, 0x31DC, 0x39DC, 0x39DC, 0x39FD, 
        0x39FD, 0x39FD, 0x39FD, 0x41FD, 0x41FD, 0x421D, 0x4A1D, 0x4A3D, 0x525D, 0x527E, 0x5A9E, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 0x5A9E, 0x529D, 0x529D, 0x5A9D, 0x5A9D, 0x5ABD, 0x529D, 0x5A9D, 0x529D, 0x529D, 0x5A9D, 0x5ABD, 0x62DD, 0x62FE, 
        0x6B1E, 0x733E, 0x735E, 0x735E, 0x7B5E, 0x733E, 0x731D, 0x731D, 0x731D, 0x731D, 0x731D, 0x72FD, 0x72FD, 0x72FD, 0x7AFD, 0x7AFD, 0x7AFE, 0x7B1E, 0x7B1D, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFD, 0x7ADE, 0x7ADD, 0x7ADE, 0x7ADE, 0x7ADE, 
        0x7ADE, 0x72FE, 0x7AFE, 0x72DE, 0x72DD, 0x72DE, 0x6ABE, 0x6A9E, 0x6A7D, 0x6A7D, 0x6A9E, 0x6A9D, 0x6A9D, 0x6A9E, 0x6ABD, 0x6A9D, 0x6ABD, 0x6ADD, 0x72FE, 0x733E, 0x7B5E, 0x7B5E, 0x7B5E, 0x735E, 0x735E, 0x6B1E, 0x62FD, 0x62DD, 0x5A9D, 0x527D, 
        0x527D, 0x5A9D, 0x5ADD, 0x6B1E, 0x6B3E, 0x6B3E, 0x6B5E, 0x735E, 0x737E, 0x737E, 0x739E, 0x739E, 0x73BE, 0x7BDE, 0x7BFE, 0x7C1E, 0x843E, 0x845E, 0x849E, 0x8CBE, 0x8CBE, 0x94DE, 0x94DE, 0x94FE, 0x9CFE, 0x951E, 0x951E, 0x9D1E, 0x9D1E, 0x9D1E, 
        0x9D1E, 0x9D3E, 0xA53F, 0x9D3F, 0x9D3E, 0xA53E, 0xA53E, 0x9D1E, 0x9D1E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53F, 0xA53E, 0x9CFE, 0x8C7E, 0x52FD, 0x29FD, 0x21FD, 0x223D, 0x223D, 0x2A5D, 0x2A7D, 0x2A9D, 0x32BD, 0x32DE, 0x32DD, 0x3AFD, 
        0x3B1E, 0x431E, 0x4B3E, 0x4B3E, 0x4B3D, 0x42FE, 0x325D, 0x221D, 0x223D, 0x225D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1E, 0x3B3E, 0x3B1E, 0x3B3E, 0x433D, 0x433E, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 0x5BBE, 
        0x5BBE, 0x63DE, 0x6BFE, 0x6BBC, 0x42D4, 0x436F, 0x4BEF, 0x5C70, 0x64B1, 0x6CF2, 0x74F2, 0x74F3, 0x74D3, 0x74B4, 0x7CF4, 0x74D0, 0x646C, 0x5C4A, 0x5C49, 0x6449, 0x6469, 0x6469, 0x6C69, 0x6C89, 0x6C89, 0x6C89, 0x6C89, 0x6C8A, 0x6C6A, 0x6C6A, 
        0x6C49, 0x6C29, 0x6429, 0x5C08, 0x5C08, 0x53E8, 0x53E8, 0x4BE7, 0x43E7, 0x43C7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33C6, 0x33E6, 0x33E6, 0x33E7, 0x33E7, 0x33E7, 0x33E7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x3307, 
        0x2AE6, 0x2AC6, 0x2AC6, 0x2AC7, 0x2AC7, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x2AC6, 0x3306, 0x3B27, 0x3B47, 0x4387, 0x4BA8, 0x53C8, 0x53C8, 0x5BE8, 0x6408, 0x63E8, 0x5BE8, 0x5BC8, 0x5BC8, 0x5BA8, 0x5388, 0x5388, 0x4B67, 0x4347, 0x3B47, 0x3327, 
        0x32E7, 0x2AC6, 0x22A6, 0x2286, 0x1A65, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1245, 0x1245, 0x1A65, 0x1A86, 0x1A86, 0x1A86, 0x22A6, 0x22C6, 0x22C6, 0x22E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x3347,
  0x74EE, 0x74EE, 0x74EE, 0x7CCF, 0x7CAF, 0x84AF, 0x846F, 0x8C6F, 0x946E, 0x948E, 0x946F, 0x946E, 0x946F, 0x8C6F, 0x8C8E, 0x8C8E, 0x84AE, 0x84AE, 0x84CE, 0x84CE, 0x84CE, 0x84CE, 0x84CD, 0x84CD, 0x7CCE, 0x7CAD, 0x84CD, 0x84ED, 0x8CCE, 0x8CAE, 0x94AE, 
        0x948E, 0x8C8E, 0x8C8E, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CAE, 0x8CAE, 0x8CAE, 0x94AE, 0x94AE, 0x94AE, 0x948F, 0x946E, 0x946E, 0x9C4E, 0x942F, 0x8C4F, 0x848F, 0x7CEF, 0x7D2F, 0x7D4F, 0x7D4F, 0x7D6F, 0x7DB0, 0x85B0, 0x85D1, 0x85D1, 0x7D90, 0x7DB1, 
        0x7DB1, 0x85D1, 0x85B1, 0x8590, 0x8DD1, 0x8DD1, 0x8DB1, 0x8DD2, 0x8591, 0x8571, 0x7D50, 0x8DD2, 0x95F2, 0x95D2, 0x95B2, 0x95B3, 0x95B3, 0x8D72, 0x8D72, 0x8DB3, 0x8D73, 0x84F2, 0x74B1, 0x63EE, 0x5BCD, 0x6C6E, 0x6C8E, 0x5C0C, 0x5389, 0x5BC9, 
        0x6BEA, 0x742B, 0x844C, 0x8C6C, 0x8C6C, 0x946D, 0x9C6E, 0x9C8D, 0x9C8D, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CEC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x94CC, 0x94CB, 0x94CB, 0x9CCC, 0x9CAC, 0x9CAC, 0x8C8C, 0x742C, 0x4BAA, 0x4349, 0x3B49, 0x434A, 0x436B, 
        0x4BAC, 0x53CD, 0x53CD, 0x53ED, 0x5C0D, 0x5C4E, 0x6CAF, 0x74EF, 0x84CE, 0x8CAD, 0x8C8C, 0x948B, 0x948B, 0x948B, 0x94AC, 0x948B, 0x948B, 0x946B, 0x946B, 0x946C, 0x944C, 0x946D, 0x9C8E, 0x9C6D, 0x944D, 0x944C, 0x944C, 0x944C, 0x946C, 0x946C, 
        0x948C, 0x948C, 0x948C, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x948C, 0x8C4D, 0x842F, 0x7BB3, 0x6AF8, 0x5A5C, 0x521D, 0x4A1D, 0x421D, 0x421D, 0x41FD, 0x41DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DC, 0x31DC, 0x31DC, 0x31DC, 0x39DC, 0x39DD, 
        0x39DD, 0x39DD, 0x39DD, 0x41FD, 0x41FD, 0x421D, 0x4A1D, 0x4A3D, 0x525D, 0x525E, 0x5A9E, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A7D, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x62BD, 0x62BD, 0x62DD, 0x6AFE, 0x731E, 0x735E, 0x7B5F, 0x735E, 0x733E, 
        0x731E, 0x731D, 0x72DD, 0x6ABD, 0x72DD, 0x72DD, 0x72DD, 0x72DD, 0x72DD, 0x72FD, 0x72FD, 0x72FD, 0x72FD, 0x72FE, 0x72DE, 0x72DE, 0x7AFE, 0x731E, 0x7B1E, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFE, 0x7AFE, 0x7ADE, 0x72DD, 0x7ADE, 0x7ADE, 0x72DE, 
        0x7AFE, 0x72FE, 0x72FE, 0x72FE, 0x72DD, 0x72DD, 0x6ADE, 0x6ABE, 0x6A9D, 0x6A9E, 0x6A7D, 0x627D, 0x629D, 0x629E, 0x6A9E, 0x6A9E, 0x6A9D, 0x6A9D, 0x6A9D, 0x6ABD, 0x6ABD, 0x72FD, 0x733E, 0x735E, 0x7B5E, 0x735E, 0x735E, 0x733E, 0x6B1E, 0x62FE, 
        0x62FE, 0x6B1E, 0x733E, 0x735D, 0x735E, 0x735E, 0x733E, 0x6B3E, 0x735D, 0x737E, 0x737E, 0x739E, 0x73BE, 0x7BDE, 0x7BFE, 0x841E, 0x843E, 0x845E, 0x849E, 0x8CBE, 0x8CBE, 0x94DE, 0x94DE, 0x94FE, 0x9CFE, 0x951E, 0x951E, 0x9D1E, 0x9D1E, 0xA53E, 
        0xA53E, 0x9D3E, 0xA53F, 0xA53E, 0x9D3E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0x9D3E, 0xA53E, 0xA53E, 0xA53E, 0xA51E, 0x9D1E, 0x8CBE, 0x635D, 0x29FD, 0x21FD, 0x221D, 0x223E, 0x2A5D, 0x2A7E, 0x2A9E, 0x2ABD, 0x32BD, 0x32DD, 0x32FD, 
        0x3B1E, 0x431E, 0x431E, 0x4B3E, 0x4B3D, 0x42FE, 0x2A3D, 0x21FD, 0x223D, 0x225D, 0x2A9D, 0x32BD, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1E, 0x3B3E, 0x3B1E, 0x3B3E, 0x433D, 0x433E, 0x435D, 0x435E, 0x4B5E, 0x4B7E, 0x537E, 0x539E, 0x5B9E, 0x5BBE, 0x5BBE, 
        0x5BBE, 0x63BE, 0x6BDE, 0x639C, 0x42D3, 0x434F, 0x4BEF, 0x5C70, 0x64B1, 0x6CF1, 0x74F3, 0x74F3, 0x74D3, 0x74D4, 0x7CF3, 0x6C8F, 0x5C2B, 0x5C4A, 0x5C49, 0x5C69, 0x5C69, 0x6469, 0x6469, 0x6C89, 0x6C89, 0x6C89, 0x6C89, 0x6C8A, 0x6C6A, 0x6C49, 
        0x6C49, 0x6C29, 0x6429, 0x5C08, 0x5C08, 0x5C08, 0x53E8, 0x4BE7, 0x43E7, 0x43E8, 0x43E7, 0x3BE7, 0x3BE7, 0x3BE7, 0x33C7, 0x33E6, 0x33E6, 0x33E7, 0x33E7, 0x33E7, 0x33E7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E7, 
        0x2AE7, 0x2AC6, 0x2AC6, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x22C6, 0x22C6, 0x2AC6, 0x2B06, 0x3307, 0x3B47, 0x3B67, 0x4388, 0x4BA8, 0x53C8, 0x53C8, 0x5BE8, 0x5BE8, 0x5BC8, 0x53C8, 0x53A8, 0x5388, 0x5387, 0x4B67, 0x4347, 0x4347, 0x3B27, 0x3306, 
        0x2AC6, 0x22A6, 0x2286, 0x1A65, 0x1A45, 0x1225, 0x1225, 0x1225, 0x1225, 0x1245, 0x1245, 0x1A65, 0x1A86, 0x1A86, 0x1A86, 0x22A6, 0x22C6, 0x22C6, 0x22E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B07, 0x2B07, 0x2B27, 0x2B27, 0x2B27,
  0x74EE, 0x7CEE, 0x7CEF, 0x7CCF, 0x84AF, 0x848F, 0x846F, 0x8C4E, 0x8C8E, 0x948E, 0x948E, 0x8C6E, 0x8C6E, 0x8C6E, 0x8C8E, 0x84AE, 0x84AE, 0x84CE, 0x84CE, 0x84CE, 0x84CE, 0x84CE, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x8CEE, 0x8CCE, 0x8CAE, 0x948E, 
        0x8C8E, 0x8C8E, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x94AE, 0x948E, 0x948E, 0x946F, 0x944F, 0x942F, 0x8C2F, 0x846F, 0x848E, 0x84CF, 0x850F, 0x850F, 0x8570, 0x85B0, 0x85D0, 0x85D1, 0x85D1, 0x85D0, 0x85D1, 
        0x85D1, 0x85D1, 0x8590, 0x8DD1, 0x8DF1, 0x8DD1, 0x8DD1, 0x8DD2, 0x8DD2, 0x8591, 0x8570, 0x95F2, 0x95F2, 0x8DD2, 0x95B2, 0x95D2, 0x95B2, 0x8551, 0x8D92, 0x8DB2, 0x8D73, 0x8533, 0x7CB1, 0x63EE, 0x6C2F, 0x7490, 0x746F, 0x5BEC, 0x5BAB, 0x63EB, 
        0x740B, 0x842C, 0x8C4C, 0x8C6C, 0x8C6C, 0x946D, 0x9C8E, 0x9C8E, 0x9C8D, 0x9CAD, 0xA4AC, 0xA4CC, 0xA4EC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCB, 0x9CCC, 0x9CAC, 0x9CAC, 0x948C, 0x844C, 0x640B, 0x4B8A, 0x4349, 0x434A, 0x434A, 
        0x4B6B, 0x4B8C, 0x4B8C, 0x53AC, 0x5BED, 0x5C2E, 0x6C8E, 0x74AE, 0x84AE, 0x8CCD, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x9C8C, 0x948C, 0x948C, 0x946C, 0x944D, 0x836E, 0x8370, 0x93D2, 0x9C33, 0x9C72, 0x944F, 0x944D, 0x946C, 0x946C, 
        0x946D, 0x948D, 0x9CAC, 0x9CAC, 0x9CAC, 0x94CC, 0x94AC, 0x948C, 0x8C6C, 0x8C4D, 0x840F, 0x7374, 0x62B9, 0x523C, 0x4A1D, 0x4A1D, 0x421D, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31DC, 0x31DC, 0x31DC, 0x31DC, 0x39DC, 
        0x39DD, 0x39DD, 0x41DD, 0x41FD, 0x41FD, 0x4A1D, 0x4A1D, 0x4A1D, 0x523E, 0x525E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A9D, 0x62BD, 0x6AFD, 0x731E, 0x735E, 0x7B7E, 0x7B9E, 0x7B9E, 0x7B7E, 0x7B3D, 0x731D, 0x72FD, 0x72FD, 0x72DD, 
        0x72DD, 0x72BE, 0x6A9E, 0x6A9E, 0x72BE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x72FD, 0x72FD, 0x72FD, 0x72DD, 0x72FD, 0x72FE, 0x72FE, 0x72FE, 0x731E, 0x731D, 0x72FE, 0x731E, 0x731E, 0x731E, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x72DE, 0x72FE, 0x72FD, 
        0x72FE, 0x72FE, 0x731E, 0x72FE, 0x72FE, 0x72FE, 0x6ADE, 0x6ABE, 0x6ABE, 0x6A9E, 0x6A9E, 0x629E, 0x629D, 0x629D, 0x629E, 0x629E, 0x629D, 0x629D, 0x627E, 0x629D, 0x6A9D, 0x6A9D, 0x6ABD, 0x6ABD, 0x6ADD, 0x6ADD, 0x6AFD, 0x6B3E, 0x6B3E, 0x735E, 
        0x733E, 0x733E, 0x735E, 0x735E, 0x735E, 0x735E, 0x733E, 0x735E, 0x735E, 0x737E, 0x737E, 0x739E, 0x7BBE, 0x7BDE, 0x83FE, 0x841E, 0x843E, 0x845E, 0x847E, 0x8C9E, 0x8CBE, 0x94DE, 0x94DE, 0x94FE, 0x9CFE, 0x951E, 0x951E, 0x9D1E, 0x9D1E, 0x9D3E, 
        0x9D3E, 0x9D3E, 0xA53F, 0xA53E, 0x9D3E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0xA53E, 0x9D1E, 0x9D1E, 0x9D1E, 0xA51E, 0x9CFE, 0x94BE, 0x6BBE, 0x31FD, 0x21DD, 0x21FD, 0x221D, 0x225D, 0x2A7D, 0x2A7D, 0x2A9D, 0x32BD, 0x32DD, 0x32DD, 
        0x3AFD, 0x431E, 0x431E, 0x4B1E, 0x4B1D, 0x42DE, 0x2A3D, 0x19FD, 0x221D, 0x225D, 0x2A9D, 0x32BE, 0x3ADE, 0x3AFE, 0x3B1D, 0x3B1E, 0x3B3E, 0x3B3E, 0x3B3E, 0x3B3D, 0x3B3D, 0x433D, 0x435E, 0x4B5E, 0x4B7D, 0x537E, 0x537E, 0x539E, 0x539E, 0x5B9E, 
        0x5BBE, 0x63BE, 0x6BDE, 0x639B, 0x42D2, 0x434F, 0x4BEF, 0x5C70, 0x64B1, 0x6CF1, 0x74F2, 0x74D3, 0x74B3, 0x7CD3, 0x7CF2, 0x646D, 0x540A, 0x5429, 0x5C69, 0x5C69, 0x5C69, 0x6469, 0x6469, 0x6469, 0x6469, 0x6469, 0x6C69, 0x6C69, 0x6C69, 0x6C49, 
        0x6C49, 0x6429, 0x6428, 0x6408, 0x5C08, 0x53E8, 0x53E8, 0x4BE8, 0x4BE7, 0x43E7, 0x43E7, 0x43E7, 0x3BE7, 0x3BE7, 0x3BE7, 0x33E6, 0x33E6, 0x33E6, 0x33E6, 0x33E7, 0x33E7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x2B27, 0x3307, 0x32E7, 
        0x32C7, 0x2AC7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AA7, 0x2AC7, 0x22C6, 0x2AC6, 0x2AE7, 0x3307, 0x3B27, 0x3B47, 0x4388, 0x4BA8, 0x4BA8, 0x53C8, 0x53C8, 0x53C8, 0x53C8, 0x53A8, 0x53A7, 0x5388, 0x4B87, 0x4347, 0x4327, 0x3B27, 0x3306, 0x32E6, 
        0x2AC6, 0x2286, 0x1A65, 0x1A45, 0x1224, 0x1204, 0x1204, 0x1224, 0x1224, 0x1245, 0x1245, 0x1A65, 0x1A66, 0x1A86, 0x1AA6, 0x22A6, 0x22C6, 0x22C6, 0x2AE6, 0x2AE7, 0x2B07, 0x2B07, 0x3307, 0x3307, 0x3307, 0x3327, 0x3327, 0x2B27, 0x2B27,
  0x74CE, 0x7CEF, 0x84CF, 0x84AF, 0x848F, 0x846E, 0x8C4E, 0x8C4E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x84AE, 0x84CE, 0x84CE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x8CAD, 0x8CAD, 0x948E, 
        0x8C8E, 0x8C8E, 0x8C8E, 0x84AE, 0x84AE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x94AE, 0x948E, 0x8C8E, 0x948E, 0x946F, 0x944F, 0x942F, 0x8C2F, 0x840E, 0x846E, 0x94F0, 0x850F, 0x8D50, 0x8590, 0x85B0, 0x85B0, 0x85D0, 0x85D1, 0x85D1, 
        0x85B1, 0x85B0, 0x8DD1, 0x8DF1, 0x8DD1, 0x8DD1, 0x8DD1, 0x8DD1, 0x85B1, 0x7D50, 0x8DD2, 0x8DF2, 0x8DD2, 0x8DB2, 0x8DB2, 0x8DD2, 0x8DB2, 0x8571, 0x7D30, 0x8551, 0x8D72, 0x8552, 0x8512, 0x84F2, 0x84F2, 0x7CB1, 0x7470, 0x6BED, 0x63CC, 0x740C, 
        0x7C2C, 0x844C, 0x8C4C, 0x8C4C, 0x8C4C, 0x8C6D, 0x948D, 0x948E, 0x9C8E, 0x9C8D, 0xA4AD, 0xA4AD, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0xA4AC, 0xA4AC, 0x9CAC, 0x948D, 0x746C, 0x5BEB, 0x4B8A, 0x434A, 0x434A, 
        0x434A, 0x434B, 0x4B6B, 0x4B8C, 0x53CC, 0x5BED, 0x644E, 0x74AE, 0x84AE, 0x8CCD, 0x94CD, 0x9CAC, 0x9CCC, 0x9CAD, 0x9CAD, 0x948D, 0x9C8E, 0x9C8E, 0x9C6E, 0x944F, 0x9430, 0x8333, 0x6233, 0x6A34, 0x6A94, 0x8335, 0x9416, 0x9C94, 0x9490, 0x9CAF, 
        0x948E, 0x9CAD, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x94AC, 0x948C, 0x8C6C, 0x8C6C, 0x8C4E, 0x83F1, 0x7356, 0x627B, 0x521D, 0x49FD, 0x4A1D, 0x41FD, 0x41FD, 0x39FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31DC, 0x31DC, 0x31DC, 0x39DC, 0x39DC, 
        0x39DC, 0x41DD, 0x41DD, 0x41FD, 0x41FD, 0x49FD, 0x4A1D, 0x49FD, 0x521D, 0x5A3D, 0x629D, 0x6ADD, 0x6AFE, 0x6AFD, 0x72FE, 0x731E, 0x733E, 0x7B5E, 0x7B7E, 0x7B7E, 0x7B5E, 0x733D, 0x731D, 0x731D, 0x72FD, 0x72DD, 0x72DD, 0x72DE, 0x72DE, 0x72DE, 
        0x72DE, 0x6ADE, 0x6ABE, 0x6A9E, 0x6ABE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x72DD, 0x72FD, 0x72FD, 0x6AFD, 0x6AFD, 0x6AFE, 0x72FE, 0x6AFD, 0x72FD, 0x731D, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x731E, 
        0x731E, 0x72FE, 0x731E, 0x731E, 0x731E, 0x72FE, 0x6ADE, 0x6ADD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ABE, 0x62BE, 0x629D, 0x629E, 0x627E, 0x629D, 0x629D, 0x629E, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 0x62BD, 0x62DD, 0x6ADD, 
        0x6AFD, 0x6B1D, 0x731E, 0x733E, 0x735E, 0x735E, 0x7B5E, 0x735E, 0x737E, 0x737E, 0x7B9E, 0x7B9E, 0x7BBE, 0x7BBE, 0x83DE, 0x841E, 0x841E, 0x843E, 0x8C5E, 0x8C7E, 0x8C9E, 0x94BE, 0x94DE, 0x94DE, 0x9CFE, 0x951E, 0x9D1E, 0x9D1E, 0x9D3F, 0x9D3E, 
        0x9D3E, 0x9D3E, 0xA53F, 0xA53E, 0x9D3E, 0xA53E, 0xA53E, 0xA53E, 0xA51E, 0xA51E, 0xA51E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9CFE, 0x94DE, 0x7C1E, 0x3A3D, 0x21DD, 0x21FD, 0x221D, 0x223D, 0x2A5D, 0x2A7D, 0x2A9D, 0x2ABD, 0x32BD, 0x32DD, 
        0x32FD, 0x3B1D, 0x431E, 0x431E, 0x431E, 0x3ABE, 0x2A1D, 0x19DD, 0x221D, 0x227D, 0x2A9D, 0x32DD, 0x3ADE, 0x3AFE, 0x3B1E, 0x3B1E, 0x3B3E, 0x3B3E, 0x3B3E, 0x3B3D, 0x3B3D, 0x433D, 0x433D, 0x435E, 0x4B7E, 0x4B7E, 0x537E, 0x539E, 0x539E, 0x5B9E, 
        0x5B9E, 0x63BE, 0x6BDE, 0x637A, 0x42D2, 0x436F, 0x53EF, 0x5C70, 0x64B1, 0x6CF1, 0x6CD2, 0x74B3, 0x74B3, 0x7CD3, 0x74B0, 0x5C2C, 0x4BE9, 0x5429, 0x5448, 0x5448, 0x5C49, 0x5C49, 0x5C49, 0x5C69, 0x6469, 0x6469, 0x6469, 0x6C69, 0x6C69, 0x6C49, 
        0x6429, 0x6429, 0x6408, 0x6408, 0x5C08, 0x53E8, 0x53E8, 0x4C08, 0x4C07, 0x4C08, 0x43E7, 0x43E7, 0x43E7, 0x3C07, 0x3BE7, 0x3BE6, 0x33E6, 0x33E6, 0x33E6, 0x33E7, 0x33E7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E7, 
        0x32E7, 0x32C7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2B07, 0x3307, 0x3B47, 0x3B67, 0x4388, 0x4BA8, 0x4BA8, 0x53C8, 0x53C8, 0x4BA8, 0x4BA8, 0x4B87, 0x4B87, 0x4367, 0x4347, 0x3B26, 0x3B06, 0x32E6, 0x2AC6, 
        0x22A6, 0x2285, 0x1A45, 0x1224, 0x1204, 0x1204, 0x1204, 0x1204, 0x1224, 0x1245, 0x1245, 0x1A65, 0x1A66, 0x1A86, 0x1AA6, 0x22A6, 0x22C6, 0x22C6, 0x2AE6, 0x2AE7, 0x2B07, 0x3307, 0x3307, 0x3307, 0x3327, 0x3327, 0x3327, 0x2B27, 0x2B27,
  0x7CCE, 0x8CCF, 0x8CD0, 0x8C6F, 0x842E, 0x8C2E, 0x8C2E, 0x8C4E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8E, 0x8C8F, 0x8C8F, 0x84AE, 0x84AE, 0x84CE, 0x84CE, 0x84CD, 0x84EE, 0x84EE, 0x84EE, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x8CAD, 0x8CAD, 0x94AE, 
        0x8C8E, 0x8C8E, 0x8CAD, 0x84AD, 0x84AD, 0x84AE, 0x84AE, 0x84AE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x8CAE, 0x948E, 0x948F, 0x946F, 0x944F, 0x942F, 0x942F, 0x942F, 0x946F, 0x9CD0, 0x9510, 0x8D50, 0x8570, 0x8590, 0x85B0, 0x85B0, 0x85D1, 0x85D1, 
        0x7D90, 0x8590, 0x8DD1, 0x8DD1, 0x8DD1, 0x85B1, 0x8DD1, 0x85B1, 0x8570, 0x7D4F, 0x8DF2, 0x8DD2, 0x8DB2, 0x85B1, 0x8570, 0x8DB1, 0x8DB2, 0x8DB2, 0x7D31, 0x8571, 0x8592, 0x8572, 0x8552, 0x8532, 0x84F2, 0x7CB1, 0x7450, 0x6BEE, 0x73CD, 0x7C2D, 
        0x844C, 0x844C, 0x8C4B, 0x844B, 0x844C, 0x844C, 0x846C, 0x8C8D, 0x948D, 0x9C8D, 0x9CAD, 0x9CAD, 0xA4AC, 0xA4AC, 0xA4AC, 0xA4AC, 0xA4CC, 0x9CCC, 0x9CCC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4AC, 0x9CAD, 0x8C8C, 0x7C4C, 0x5BEB, 0x4B8A, 0x436A, 
        0x434A, 0x4B6B, 0x4B6B, 0x4B6B, 0x4B8C, 0x53CC, 0x5C0D, 0x6C6E, 0x84AE, 0x8CCE, 0x9CCD, 0x9CCD, 0x9CAD, 0x9C8E, 0x9C6E, 0x9430, 0x9411, 0x8BD1, 0x8391, 0x8392, 0x8373, 0x8357, 0x6A38, 0x61F8, 0x6218, 0x6217, 0x6A77, 0x8B98, 0x9C57, 0xA4D5, 
        0xA4F2, 0x9CAF, 0x9CAE, 0x9CAD, 0x9CAD, 0x9CAC, 0x948C, 0x8C6C, 0x8C6C, 0x8C6C, 0x946D, 0x8C4F, 0x83F2, 0x7318, 0x523B, 0x49FD, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31BC, 0x31BC, 0x31DC, 0x39DC, 0x39DC, 
        0x39BC, 0x41DC, 0x41DD, 0x49FD, 0x49DD, 0x49FD, 0x521D, 0x5A3D, 0x627D, 0x6ADD, 0x835E, 0x839F, 0x83BF, 0x83BE, 0x839E, 0x7B7D, 0x735D, 0x731D, 0x731D, 0x72FD, 0x72FD, 0x6ADD, 0x6ADD, 0x6ABD, 0x6ABD, 0x6ABD, 0x6ABD, 0x6ADE, 0x6ADE, 0x6ADE, 
        0x6ADE, 0x6ADE, 0x6ABE, 0x62BE, 0x62BD, 0x62BD, 0x62BE, 0x62BD, 0x6ABE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6AFE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6AFD, 0x6AFD, 0x6AFE, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x72FE, 0x731E, 0x72FE, 
        0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x731E, 0x6AFE, 0x6ADD, 0x6ADD, 0x6AFE, 0x6ADE, 0x62DE, 0x62DE, 0x62BE, 0x5ABE, 0x629E, 0x5ABE, 0x5ABE, 0x5A9E, 0x629E, 0x629D, 0x629D, 0x629D, 0x629D, 0x629E, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 
        0x629D, 0x629D, 0x6ABD, 0x6ADD, 0x72FE, 0x731E, 0x733E, 0x733E, 0x735E, 0x7B7E, 0x7B7E, 0x7B9E, 0x7B9D, 0x7BBD, 0x7BDE, 0x83FE, 0x841E, 0x841E, 0x8C5E, 0x8C7E, 0x8C9E, 0x94BE, 0x94BF, 0x94DE, 0x94DE, 0x94FE, 0x9D1E, 0x9D3F, 0x9D3E, 0xA53E, 
        0xA53E, 0xA55E, 0xA55E, 0xA55E, 0xA53E, 0xA53E, 0xA53E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9D1E, 0x9CFE, 0x9D1E, 0x9D1E, 0x9CFE, 0x94DE, 0x845E, 0x4ABE, 0x21DD, 0x19DD, 0x221D, 0x223D, 0x225D, 0x2A7E, 0x2A9D, 0x2A9D, 0x32BD, 0x32BD, 
        0x32DD, 0x3AFD, 0x3AFD, 0x42FD, 0x3AFD, 0x327D, 0x21FD, 0x19DD, 0x221D, 0x2A7D, 0x32BE, 0x32DE, 0x32FE, 0x32FE, 0x331E, 0x331D, 0x331D, 0x3B1D, 0x3B3E, 0x3B3D, 0x3B3E, 0x3B3D, 0x433D, 0x435E, 0x4B7E, 0x4B7E, 0x537D, 0x539E, 0x5B9E, 0x5BBE, 
        0x5BBE, 0x63BE, 0x63BE, 0x5318, 0x42F0, 0x4B8F, 0x53EF, 0x5C70, 0x64B1, 0x6CF1, 0x74F2, 0x74B3, 0x74B3, 0x7CD2, 0x6C6F, 0x540A, 0x4BE8, 0x4C08, 0x4C28, 0x5448, 0x5448, 0x5C49, 0x5C49, 0x5C69, 0x5C68, 0x5C69, 0x6469, 0x6449, 0x6449, 0x6449, 
        0x6449, 0x6429, 0x6408, 0x5C08, 0x5C08, 0x5408, 0x5408, 0x5408, 0x4C08, 0x4C07, 0x4C07, 0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BE7, 0x3BE6, 0x33E6, 0x33E6, 0x33E7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3367, 0x3347, 0x3347, 0x3327, 0x3307, 0x32E8, 
        0x32E7, 0x32E7, 0x32E7, 0x32C7, 0x32C7, 0x32C7, 0x32E7, 0x2AE7, 0x2AE7, 0x2AE7, 0x2B07, 0x2B07, 0x2B27, 0x3347, 0x3B67, 0x3B87, 0x4387, 0x43A7, 0x4BA8, 0x4BA8, 0x4BA7, 0x4387, 0x4387, 0x4367, 0x3B47, 0x3B27, 0x3306, 0x3306, 0x2AE6, 0x2AC6, 
        0x2285, 0x1A65, 0x1A44, 0x1224, 0x1204, 0x1204, 0x1204, 0x1224, 0x1224, 0x1245, 0x1245, 0x1A65, 0x1A85, 0x1A85, 0x1AA5, 0x22A6, 0x22C6, 0x2AE6, 0x2AE6, 0x2B07, 0x3307, 0x3307, 0x3307, 0x3327, 0x3327, 0x3327, 0x3327, 0x2B27, 0x2B27,
  0x84EE, 0x94EF, 0x94F0, 0x948F, 0x8C2E, 0x8C2E, 0x8C4E, 0x8C6E, 0x8C8E, 0x8C8E, 0x8CAE, 0x8C8F, 0x8C8F, 0x8C8F, 0x84AE, 0x84AE, 0x84CE, 0x84CE, 0x84CD, 0x84EE, 0x84EE, 0x84EE, 0x84CD, 0x84CD, 0x84EE, 0x84CD, 0x84CD, 0x84CD, 0x8CAD, 0x8CAD, 0x94AE, 
        0x8C8E, 0x8C8E, 0x8CAD, 0x8CAD, 0x84AD, 0x848D, 0x848D, 0x84AE, 0x8CAE, 0x8CCE, 0x8CCE, 0x8CCE, 0x8CAE, 0x94AF, 0x948F, 0x946F, 0x944F, 0x942F, 0x9C4F, 0x9C4F, 0x9C70, 0x9CB0, 0x94CF, 0x8D10, 0x8550, 0x8570, 0x7D90, 0x8590, 0x8590, 0x752F, 
        0x8590, 0x85B1, 0x8DD1, 0x8DD1, 0x8DD1, 0x8DB1, 0x85B1, 0x85B1, 0x7D4F, 0x8591, 0x8DD2, 0x8DB1, 0x8591, 0x8DB1, 0x8DB2, 0x8DB2, 0x8DB2, 0x8571, 0x7D31, 0x8592, 0x8592, 0x8592, 0x8572, 0x7D11, 0x7CF1, 0x84D1, 0x7C70, 0x7C2F, 0x7C0E, 0x7C2D, 
        0x7BEB, 0x846C, 0x8C6B, 0x844B, 0x7C4B, 0x744B, 0x744B, 0x7C6C, 0x848C, 0x8C8D, 0x94AD, 0x9C8D, 0x9C8D, 0xA48C, 0xA4AC, 0xA4AC, 0xA4AC, 0xA4AC, 0x9CCC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CCC, 0x9CAC, 0x94AC, 0x848D, 0x640B, 0x4B8A, 0x434A, 
        0x434A, 0x4B6B, 0x4B6B, 0x4B6B, 0x4B8C, 0x53CC, 0x5BED, 0x642D, 0x7C8E, 0x8CCE, 0x9CCE, 0x9CCD, 0x9C8E, 0x9450, 0x8BD1, 0x8355, 0x7B16, 0x7AF7, 0x72D7, 0x72B8, 0x6A98, 0x6A79, 0x621A, 0x59FB, 0x59FA, 0x59DA, 0x59FA, 0x6A39, 0x8B7C, 0x93DA, 
        0xA479, 0xB4F6, 0xA4B2, 0x9C8E, 0x9C8D, 0x948C, 0x948C, 0x8C6C, 0x946C, 0x948C, 0x946D, 0x946E, 0x8C4F, 0x7B75, 0x5A5A, 0x49FC, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31BC, 0x31BC, 0x31DC, 0x39DC, 0x39BC, 
        0x39BC, 0x41BC, 0x41DC, 0x49FC, 0x521C, 0x629D, 0x731E, 0x837E, 0x837F, 0x837E, 0x837E, 0x7B5E, 0x7B3D, 0x7B3D, 0x731D, 0x72FD, 0x72DD, 0x72DD, 0x6ADD, 0x6ADD, 0x6ADD, 0x6ABD, 0x6ABD, 0x6ABD, 0x6ABD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BE, 
        0x62BE, 0x62DE, 0x62DD, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x62DE, 0x62DE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6ADE, 0x6ADE, 0x6ADE, 0x62FD, 0x6AFD, 0x6AFE, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x731E, 0x731E, 0x731E, 0x731E, 
        0x731E, 0x731E, 0x6B1E, 0x731E, 0x733E, 0x6B1E, 0x6B1E, 0x6AFE, 0x6AFE, 0x6B1E, 0x6AFE, 0x6AFE, 0x62DD, 0x62DE, 0x5ADE, 0x5ABE, 0x5ADE, 0x5ABE, 0x5ABE, 0x5ABD, 0x5ABD, 0x5ABE, 0x62BE, 0x62BD, 0x629E, 0x629D, 0x629D, 0x5A9D, 0x5A9D, 0x5A9D, 
        0x629D, 0x629D, 0x629D, 0x629D, 0x6ABD, 0x6ADD, 0x6ADD, 0x6AFD, 0x731E, 0x733E, 0x7B5E, 0x7B5E, 0x735D, 0x735E, 0x737E, 0x7B9E, 0x7BDE, 0x7BDE, 0x83FE, 0x841E, 0x845E, 0x8C7E, 0x8C9F, 0x94BF, 0x94BE, 0x94DE, 0x9CFE, 0x9D1E, 0x9D1E, 0x9D3E, 
        0xA55F, 0xA55F, 0xA55F, 0xA55E, 0xA55E, 0xA55E, 0x9D3E, 0xA53E, 0x9D1E, 0x9D1E, 0x9CFE, 0x9D1E, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CFE, 0x94DE, 0x845E, 0x5B1E, 0x29DD, 0x21DD, 0x21FD, 0x221D, 0x223D, 0x225D, 0x2A7D, 0x2A7D, 0x2A9D, 0x2ABD, 
        0x32DD, 0x32DD, 0x3AFD, 0x3AFD, 0x3ADD, 0x2A5D, 0x19DD, 0x19DD, 0x1A1D, 0x2A7D, 0x32BE, 0x32DE, 0x32FE, 0x32FD, 0x331D, 0x331D, 0x331D, 0x3B3E, 0x3B3E, 0x3B3E, 0x3B3E, 0x3B3D, 0x3B3D, 0x435E, 0x4B7E, 0x4B7E, 0x537E, 0x539E, 0x5BBE, 0x5BBE, 
        0x5BBE, 0x63BE, 0x63BD, 0x4AF5, 0x430F, 0x438E, 0x53EF, 0x5C70, 0x64B1, 0x6CF1, 0x74F2, 0x74D3, 0x7CB3, 0x74D2, 0x646D, 0x4BE9, 0x4BE8, 0x4408, 0x4C08, 0x4C28, 0x5429, 0x5429, 0x5429, 0x5448, 0x5448, 0x5C48, 0x5C49, 0x6449, 0x6449, 0x6449, 
        0x6449, 0x6428, 0x6428, 0x5C08, 0x5C08, 0x5408, 0x5408, 0x5408, 0x4C08, 0x4C28, 0x4C07, 0x4C08, 0x4407, 0x4407, 0x3C07, 0x3BE7, 0x3BE6, 0x33E6, 0x33C6, 0x33E7, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3367, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E8, 
        0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E8, 0x32E7, 0x2AE7, 0x2B07, 0x2B07, 0x2B07, 0x2B07, 0x3347, 0x3367, 0x3367, 0x3B87, 0x3BA7, 0x43A7, 0x43A7, 0x43A7, 0x4387, 0x3B67, 0x3B67, 0x3B47, 0x3326, 0x3306, 0x2AE6, 0x2AC6, 0x22A5, 
        0x2285, 0x1A65, 0x1224, 0x1204, 0x1204, 0x1204, 0x1204, 0x1224, 0x1245, 0x1245, 0x1245, 0x1A65, 0x1A86, 0x1AA5, 0x1AA5, 0x22C6, 0x22C6, 0x2AE6, 0x2B06, 0x2B06, 0x3327, 0x3307, 0x3327, 0x3327, 0x3347, 0x3327, 0x3327, 0x2B27, 0x2B27,
  0x8CCE, 0x94EF, 0x9CD0, 0x9CB0, 0x948F, 0x946F, 0x946F, 0x8C8E, 0x8C8E, 0x84AE, 0x84AE, 0x8C8F, 0x8470, 0x848F, 0x84AF, 0x84AE, 0x84CE, 0x84CE, 0x84CD, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84CD, 0x84CD, 0x8CAD, 0x8C8D, 0x94CE, 
        0x94AE, 0x8C8D, 0x8CAD, 0x8CAD, 0x8CAD, 0x8C8E, 0x8C8E, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CCE, 0x8CEF, 0x94EF, 0x8CCF, 0x94AF, 0x948F, 0x946F, 0x944F, 0x9C6F, 0x9C6F, 0x9C6F, 0x9C8F, 0x94AF, 0x8D0F, 0x852F, 0x7D6F, 0x7D70, 0x7D6F, 0x752E, 0x7D90, 
        0x85B1, 0x85B0, 0x85B0, 0x8DD1, 0x8DD1, 0x8DD1, 0x85B1, 0x8590, 0x7D70, 0x8DB1, 0x8591, 0x7D70, 0x8591, 0x8DB1, 0x8DB2, 0x8DB2, 0x8571, 0x7D10, 0x8571, 0x8592, 0x8D92, 0x8592, 0x7D31, 0x7D31, 0x8532, 0x84F1, 0x742F, 0x7BEE, 0x8C70, 0x846E, 
        0x7C0B, 0x844B, 0x846B, 0x7C4B, 0x7C4B, 0x6C4A, 0x6C4B, 0x6C4B, 0x746B, 0x7C6C, 0x8C8D, 0x94AD, 0x9C8D, 0x9C8C, 0x9C8C, 0xA48C, 0xA4AC, 0xA4AC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CCC, 0x9CAC, 0x9CAD, 0x8C6D, 0x6C0C, 0x538B, 0x434A, 
        0x434A, 0x434A, 0x434B, 0x4B6B, 0x4B8B, 0x53AC, 0x5BCC, 0x640D, 0x746E, 0x84AE, 0x94CF, 0x9C8F, 0x9431, 0x8394, 0x7B37, 0x7ADA, 0x72BB, 0x729B, 0x6A9B, 0x6A7B, 0x625B, 0x623B, 0x5A1B, 0x51FB, 0x51FB, 0x51DA, 0x51DA, 0x59DA, 0x729C, 0x8B5E, 
        0x93BC, 0xA43A, 0xAC97, 0xA493, 0x944F, 0x946D, 0x946C, 0x946C, 0x946C, 0x948C, 0x948D, 0x9C8D, 0x946E, 0x83D3, 0x6AF8, 0x4A1B, 0x41DC, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x31DD, 0x31BC, 0x31BC, 0x31DC, 0x39DC, 0x39BC, 
        0x39BB, 0x41BB, 0x49DC, 0x5A7D, 0x733E, 0x837F, 0x8B7F, 0x837E, 0x835E, 0x7AFD, 0x72DD, 0x72DD, 0x72DD, 0x72DE, 0x6ADE, 0x6ADD, 0x6ADD, 0x6ADD, 0x6ADD, 0x62BD, 0x62BD, 0x629D, 0x629D, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BE, 0x62BE, 
        0x62BE, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x62DE, 0x62DE, 0x62BD, 0x62BD, 0x62BE, 0x62DE, 0x62DE, 0x62FE, 0x6AFE, 0x6AFE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6B1E, 0x731E, 0x731E, 0x731E, 0x6B1E, 
        0x6B1E, 0x6B1E, 0x6B1E, 0x6B3E, 0x6B3D, 0x6B3E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x62FE, 0x62DE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ABE, 0x5ADE, 0x62DE, 0x62BE, 0x62BE, 0x62BD, 0x62BD, 0x5ABD, 0x5ABD, 0x5ABD, 
        0x5ABD, 0x629D, 0x629D, 0x629D, 0x629D, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x6ADD, 0x6ADD, 0x6ADD, 0x6AFE, 0x6AFE, 0x733E, 0x735E, 0x737D, 0x739E, 0x739D, 0x7BBD, 0x7BDE, 0x841E, 0x8C5E, 0x949E, 0x94BE, 0x94DE, 0x9CFE, 0x9D1E, 0x9D3E, 
        0xA55F, 0xA55F, 0xA55F, 0xA55F, 0xA55F, 0xA55E, 0xA55E, 0xA53F, 0xA53E, 0x9D1F, 0x9D1E, 0x9CFE, 0x9CFE, 0x9CFE, 0x9CDE, 0x9CDE, 0x9CDE, 0x94DE, 0x8C9E, 0x6B9E, 0x29FD, 0x21BD, 0x21DD, 0x221D, 0x223D, 0x225D, 0x2A5D, 0x2A7D, 0x2A9D, 0x2A9D, 
        0x32BD, 0x32DD, 0x3ADD, 0x3ADD, 0x32BD, 0x2A5D, 0x19BD, 0x19DD, 0x1A1D, 0x2A9D, 0x2ABE, 0x32DD, 0x32DD, 0x32FD, 0x32FD, 0x331D, 0x331D, 0x3B3E, 0x3B3E, 0x3B5E, 0x435E, 0x435E, 0x435D, 0x437E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 
        0x63BE, 0x63BE, 0x5B5A, 0x42F2, 0x432E, 0x438E, 0x4BEF, 0x5470, 0x64B1, 0x6CF1, 0x74F2, 0x74D3, 0x7CD2, 0x74B0, 0x5C2C, 0x4BC9, 0x43E8, 0x43E8, 0x4C08, 0x4C08, 0x4C28, 0x4C29, 0x4C28, 0x4C28, 0x5448, 0x5448, 0x5C48, 0x5C49, 0x6449, 0x6449, 
        0x6449, 0x6428, 0x6428, 0x5C28, 0x5C28, 0x5C08, 0x5408, 0x5408, 0x5408, 0x5428, 0x4C28, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x3BE7, 0x3BE7, 0x3BC7, 0x3BC6, 0x33C7, 0x33C7, 0x33C7, 0x33A7, 0x3387, 0x3367, 0x3347, 0x3347, 0x3327, 0x3308, 0x32E8, 
        0x32E8, 0x32E8, 0x32E8, 0x3AE8, 0x3AE8, 0x3B08, 0x3308, 0x3308, 0x3308, 0x2B07, 0x2B07, 0x2B27, 0x2B27, 0x2B27, 0x2B47, 0x3367, 0x3387, 0x3B87, 0x3BA7, 0x3B87, 0x3B87, 0x3B87, 0x3B67, 0x3B47, 0x3327, 0x2B06, 0x2B06, 0x2AE6, 0x22C5, 0x22A5, 
        0x1A85, 0x1244, 0x1224, 0x1224, 0x1204, 0x1204, 0x1204, 0x1224, 0x1245, 0x1245, 0x1A65, 0x1A65, 0x1A85, 0x1AA5, 0x22C5, 0x22C6, 0x22E6, 0x2AE6, 0x2B06, 0x2B06, 0x3327, 0x3327, 0x3327, 0x3347, 0x3347, 0x3347, 0x2B46, 0x2B26, 0x2B26,
  0x8CAE, 0x9CCF, 0x9CCF, 0x9CB0, 0x9C8F, 0x9C8F, 0x948F, 0x8C8E, 0x8CAE, 0x84AE, 0x84AE, 0x848F, 0x8450, 0x8470, 0x848F, 0x84AE, 0x84CE, 0x84CD, 0x84CD, 0x84ED, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x84ED, 0x84CD, 0x84CD, 0x8CAD, 0x8C8D, 0x94CE, 
        0x94AE, 0x8C8D, 0x8C8D, 0x8C8D, 0x8C8D, 0x848D, 0x8C8E, 0x8CAE, 0x8CAE, 0x8CCE, 0x8CEE, 0x8D0F, 0x950F, 0x8CEF, 0x94AF, 0x948E, 0x946F, 0x946F, 0x9C6F, 0xA490, 0xA48F, 0x9C8F, 0x948F, 0x8CCF, 0x852F, 0x7D4F, 0x7D2F, 0x754F, 0x7D90, 0x8590, 
        0x8590, 0x8590, 0x8590, 0x8DD1, 0x85B1, 0x85B1, 0x85B1, 0x754F, 0x85B1, 0x8590, 0x8591, 0x85B1, 0x85B1, 0x85B1, 0x8591, 0x8591, 0x8551, 0x7D30, 0x8592, 0x8DB2, 0x8591, 0x8571, 0x8551, 0x8572, 0x8532, 0x7CB0, 0x6BEE, 0x7C50, 0x844F, 0x7C4E, 
        0x7C4C, 0x846B, 0x846B, 0x7C6B, 0x746B, 0x646A, 0x646A, 0x5C6A, 0x644A, 0x6C6B, 0x7C8C, 0x8C8D, 0x948D, 0x948D, 0x9C8D, 0x9C8C, 0x9CAC, 0xA4AC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CAD, 0x8C6D, 0x740C, 0x5BAB, 0x4B4A, 
        0x434A, 0x434A, 0x434A, 0x4B6B, 0x4B8B, 0x4B8C, 0x53AC, 0x63ED, 0x6C2E, 0x7C6F, 0x8C90, 0x9412, 0x83B5, 0x8338, 0x7AFB, 0x729C, 0x6A9C, 0x6A9C, 0x6A7C, 0x625B, 0x623B, 0x5A3B, 0x521B, 0x51FA, 0x51FA, 0x49DA, 0x49DA, 0x51BA, 0x621B, 0x82FE, 
        0x833E, 0x939D, 0x9BFB, 0xA459, 0xA494, 0x9C6F, 0x946D, 0x946C, 0x948C, 0x9C8D, 0x9C8D, 0x9C8D, 0x9C8D, 0x8C2F, 0x7B95, 0x5A99, 0x41FB, 0x41DC, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x31DD, 0x31DC, 0x31BC, 0x39DC, 0x39DC, 0x49FC, 
        0x5A7D, 0x62DE, 0x731E, 0x7B5E, 0x7B3E, 0x7B3E, 0x7B1D, 0x72DD, 0x72BD, 0x6ABD, 0x6ABD, 0x6ABD, 0x6ABD, 0x6ABE, 0x6ABE, 0x62DD, 0x6ADD, 0x6ADD, 0x62BD, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x5ABE, 0x62BE, 0x5ABD, 0x5ABD, 
        0x5ABE, 0x5ABD, 0x62DD, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x6B1E, 0x6B1E, 0x6B1E, 0x731E, 0x733E, 0x6B3E, 
        0x6B1E, 0x6B1E, 0x6B1E, 0x6B3D, 0x6B3D, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x62FE, 0x62FE, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x62DE, 0x62DE, 0x62BE, 0x62DE, 0x62DE, 0x5ABE, 0x5ABE, 0x5ABE, 
        0x5ABD, 0x5A9D, 0x5A9D, 0x5ABD, 0x5A9D, 0x629D, 0x629D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x629D, 0x629D, 0x629D, 0x629D, 0x629D, 0x5ABD, 0x62BD, 0x62DD, 0x6AFD, 0x6B1D, 0x735E, 0x739E, 0x7BDD, 0x841E, 0x8C5E, 0x949E, 0x94DE, 0x9D1E, 0x9D3E, 
        0xA55E, 0xA55E, 0xA55F, 0xA55F, 0xA55F, 0xA55E, 0xA55E, 0xA53F, 0xA53F, 0x9D1F, 0x9D1F, 0x94FE, 0x9CFE, 0x94DE, 0x9CDE, 0x9CDE, 0x9CDE, 0x94BE, 0x8C9E, 0x73DF, 0x3A3D, 0x21BD, 0x21DD, 0x21FD, 0x221D, 0x223D, 0x2A5D, 0x2A5D, 0x2A7D, 0x2A9D, 
        0x2A9D, 0x32BD, 0x32BE, 0x32BD, 0x329D, 0x2A1E, 0x19BD, 0x19DD, 0x223E, 0x2A9D, 0x2ABE, 0x32DD, 0x32DD, 0x32FD, 0x32FD, 0x331D, 0x333E, 0x3B3E, 0x3B3E, 0x433E, 0x435E, 0x435E, 0x435D, 0x437E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 
        0x63BE, 0x63BD, 0x4AF6, 0x3AEF, 0x432D, 0x438E, 0x4BEF, 0x5470, 0x64B1, 0x6CF1, 0x74F2, 0x74D3, 0x74F2, 0x6CAF, 0x540B, 0x43C8, 0x43E8, 0x43E8, 0x43E8, 0x4408, 0x4C08, 0x4C08, 0x4C28, 0x4C28, 0x4C28, 0x4C28, 0x5448, 0x5449, 0x5C49, 0x5C49, 
        0x5C49, 0x5C49, 0x5C48, 0x5C48, 0x5C29, 0x5C29, 0x5428, 0x5428, 0x5428, 0x5428, 0x5428, 0x4C28, 0x4C08, 0x4C08, 0x4407, 0x3BE7, 0x3BE7, 0x3BC7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x33A7, 0x3387, 0x3367, 0x3367, 0x3347, 0x3327, 0x3B28, 0x3B08, 
        0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3308, 0x3308, 0x3328, 0x3328, 0x2B28, 0x2B27, 0x2B47, 0x2B47, 0x2B67, 0x3367, 0x3387, 0x3386, 0x3387, 0x3386, 0x3367, 0x3367, 0x3347, 0x2B26, 0x2B06, 0x2AE6, 0x2AC6, 0x22A5, 0x1A85, 
        0x1A64, 0x1244, 0x1224, 0x1224, 0x1224, 0x1224, 0x1224, 0x1225, 0x1245, 0x1245, 0x1A65, 0x1A85, 0x1A86, 0x1AA5, 0x22C5, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x3326, 0x3327, 0x3327, 0x3347, 0x3347, 0x3347, 0x3347, 0x2B46, 0x2B26, 0x2B26,
  0x8C8E, 0x9CAF, 0x9CCF, 0x9CCF, 0x9CAF, 0x948E, 0x948E, 0x8C8E, 0x8CAE, 0x84AE, 0x84AE, 0x846F, 0x8431, 0x8451, 0x848F, 0x848E, 0x7CAD, 0x7CCD, 0x84CD, 0x7CCD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x8CCD, 0x8CCD, 0x8CAD, 0x94AE, 0x94AE, 
        0x948E, 0x8C8E, 0x8C6E, 0x8C6E, 0x846E, 0x848E, 0x84AE, 0x84AE, 0x8CCE, 0x8CCF, 0x8CEF, 0x8D0F, 0x950F, 0x94EF, 0x94AE, 0x948E, 0x948F, 0x948F, 0x9C8F, 0x9C90, 0x9C8F, 0x9C8F, 0x948F, 0x8CAF, 0x850F, 0x7D0F, 0x7D2F, 0x7D70, 0x8590, 0x8590, 
        0x8590, 0x8590, 0x7D90, 0x7D70, 0x7D70, 0x7D70, 0x750F, 0x752F, 0x8570, 0x8591, 0x85B1, 0x85B1, 0x85B1, 0x85B1, 0x85B1, 0x8591, 0x7D50, 0x7D51, 0x8591, 0x8591, 0x8571, 0x8571, 0x8DB2, 0x8572, 0x8511, 0x746F, 0x84D1, 0x8CD1, 0x846F, 0x7C2D, 
        0x7C4C, 0x7C4B, 0x7C6B, 0x7C6A, 0x746A, 0x646A, 0x648A, 0x5C8A, 0x5C6A, 0x5C6B, 0x646B, 0x7C6C, 0x8C8D, 0x94AD, 0x9C8D, 0x9C8D, 0x9CAD, 0xA4AC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4EC, 0xA4EC, 0xA4CC, 0xA4CD, 0x9CAD, 0x8C6E, 0x742D, 0x63EC, 0x538B, 
        0x434A, 0x3B4A, 0x434A, 0x434A, 0x4B6B, 0x4B8B, 0x53AC, 0x5BCC, 0x63EE, 0x7431, 0x8413, 0x8396, 0x8359, 0x7AFB, 0x7ADC, 0x72BC, 0x6ABC, 0x6ABC, 0x629B, 0x627B, 0x5A5B, 0x5A3B, 0x523A, 0x521A, 0x49FA, 0x49DA, 0x49D9, 0x49B9, 0x59DA, 0x7ADD, 
        0x831E, 0x8B5E, 0x937D, 0x9BDD, 0xA43A, 0xA477, 0x9C71, 0x946D, 0x9C8D, 0x9C8D, 0x9C8C, 0x9C8D, 0x9C8D, 0x948E, 0x8C11, 0x7356, 0x5259, 0x41DB, 0x39DC, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31DD, 0x39BD, 0x39DC, 0x525C, 0x733E, 
        0x735E, 0x731E, 0x6AFD, 0x6ADD, 0x6ABD, 0x6ABD, 0x6ABD, 0x62BD, 0x629E, 0x629D, 0x629D, 0x5A9D, 0x629D, 0x629D, 0x62BE, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x62BE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ABD, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 
        0x5A9E, 0x5ABE, 0x5ADE, 0x5ADE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FE, 0x631E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B3E, 0x6B3E, 
        0x6B3E, 0x6B3E, 0x6B3D, 0x6B3D, 0x6B3D, 0x6B3D, 0x6B3E, 0x6B3E, 0x6B3D, 0x6B3D, 0x6B1E, 0x6B1D, 0x631D, 0x62FD, 0x5AFD, 0x62FE, 0x5AFE, 0x62FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x62FE, 0x62DE, 0x62DE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABE, 
        0x5ABD, 0x5ABD, 0x5A9D, 0x5A9E, 0x5A9E, 0x5A7D, 0x5A7D, 0x5A7D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x5A7E, 0x527D, 0x527D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A9D, 0x6B1E, 0x735E, 0x737E, 0x7BBD, 0x841D, 0x8C7D, 0x94DE, 0x9D1E, 
        0xA53E, 0xA55E, 0xA53E, 0xA55E, 0xA55E, 0xA55E, 0xA55E, 0x9D3E, 0x9D3E, 0x9D3F, 0x9D1F, 0x9CFE, 0x94DE, 0x9CDE, 0x9CDE, 0x94DE, 0x9CDF, 0x94BF, 0x8C9E, 0x7C1E, 0x4ABD, 0x219C, 0x19BD, 0x21DD, 0x21FD, 0x221D, 0x223D, 0x225D, 0x227D, 0x2A7D, 
        0x2A9D, 0x329D, 0x329D, 0x329D, 0x2A7D, 0x221D, 0x199D, 0x19DD, 0x225E, 0x2A9D, 0x2ADD, 0x2ADD, 0x32FD, 0x32FE, 0x331E, 0x331E, 0x331E, 0x3B3D, 0x3B3E, 0x433E, 0x435E, 0x435D, 0x435D, 0x437E, 0x4B7E, 0x537E, 0x539E, 0x5B9E, 0x5BBE, 0x5BBE, 
        0x5BBE, 0x5B5B, 0x42D3, 0x432D, 0x432D, 0x438E, 0x4BEF, 0x5450, 0x64B1, 0x6CF1, 0x74F2, 0x74F2, 0x6CD1, 0x648E, 0x4C0A, 0x43C8, 0x43E8, 0x43E8, 0x43E8, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C28, 0x4C28, 0x4C28, 0x5448, 0x5449, 
        0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5C28, 0x5C28, 0x5428, 0x5428, 0x5428, 0x5428, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x3BE7, 0x3BE6, 0x3BC7, 0x3BC6, 0x33C7, 0x33A7, 0x33A7, 0x33A7, 0x3387, 0x3367, 0x3B67, 0x3B68, 0x3B48, 0x3B28, 0x3B28, 
        0x3B28, 0x4328, 0x4328, 0x3B28, 0x3B28, 0x3B28, 0x3B08, 0x3308, 0x3307, 0x3328, 0x3328, 0x2B48, 0x2B47, 0x2B47, 0x2B47, 0x2366, 0x2B67, 0x2B67, 0x2B67, 0x3367, 0x3366, 0x3366, 0x2B46, 0x2B46, 0x2B26, 0x2B06, 0x22E6, 0x22C5, 0x1AA5, 0x1A84, 
        0x1264, 0x1264, 0x1244, 0x1224, 0x0A24, 0x1224, 0x1224, 0x1224, 0x1245, 0x1265, 0x1285, 0x1A85, 0x1AA5, 0x1AA5, 0x22C5, 0x22E5, 0x22E6, 0x2B06, 0x2B26, 0x2B26, 0x3347, 0x3347, 0x3347, 0x3347, 0x3347, 0x3366, 0x2B46, 0x2B46, 0x2B26,
  0x8C8E, 0x9CAE, 0xA4CF, 0x9CCF, 0x9CAF, 0x948E, 0x8C8E, 0x8C8E, 0x8CAE, 0x84AE, 0x84AE, 0x846F, 0x7C31, 0x8431, 0x8470, 0x848E, 0x7CAE, 0x7CCD, 0x7CCD, 0x7CCD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x84CD, 0x8CCD, 0x8CEE, 0x94EE, 0x9CCE, 0x948E, 
        0x948E, 0x8C6D, 0x8C6D, 0x8C6D, 0x846E, 0x8CAE, 0x84AE, 0x8CCE, 0x8CEF, 0x8CCF, 0x8CEF, 0x8CEF, 0x8CEE, 0x8CEE, 0x8CAE, 0x94AE, 0x94AF, 0x9CAF, 0x9CB0, 0x9CB0, 0x9C8F, 0x9C8F, 0x948F, 0x948F, 0x84CF, 0x8530, 0x8570, 0x8570, 0x8590, 0x8590, 
        0x8590, 0x7D90, 0x7D70, 0x7D4F, 0x7D50, 0x752F, 0x6CEE, 0x7D50, 0x8570, 0x8591, 0x8571, 0x8591, 0x8591, 0x85B1, 0x85B1, 0x7D91, 0x750F, 0x8571, 0x7D51, 0x7D50, 0x8591, 0x8DB2, 0x8DB2, 0x8572, 0x7D11, 0x8512, 0x8D12, 0x8490, 0x7C0E, 0x7C0D, 
        0x7C2C, 0x7C4B, 0x7C6B, 0x7C6A, 0x746A, 0x646A, 0x648A, 0x5CAB, 0x5CAB, 0x5C8A, 0x5C6B, 0x6C6B, 0x84AD, 0x94AE, 0x94AE, 0x948D, 0x9CAD, 0x9CAC, 0x9CCC, 0x9CCC, 0xA4CC, 0xA4CC, 0xA4EC, 0xA4EC, 0xA4ED, 0x9CCD, 0x8C8E, 0x7C6E, 0x744E, 0x640C, 
        0x4B8B, 0x3B6A, 0x3B49, 0x434A, 0x4B8B, 0x4B8B, 0x538C, 0x5B8E, 0x6BD1, 0x73D4, 0x7B97, 0x833A, 0x7B1C, 0x7ADC, 0x72BC, 0x6ABC, 0x6ABC, 0x6ABC, 0x62BB, 0x629B, 0x5A9B, 0x5A7A, 0x525A, 0x523A, 0x49FA, 0x49DA, 0x49D9, 0x49B9, 0x51B9, 0x729C, 
        0x831E, 0x8B3E, 0x8B5E, 0x937E, 0x939D, 0x9BFB, 0xA458, 0xA494, 0x9C90, 0x9C8E, 0x9C8D, 0x9C8D, 0x9CAD, 0x9CAD, 0x946F, 0x7BF3, 0x6317, 0x4A3A, 0x41DC, 0x39DC, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x31DD, 0x31DD, 0x39DC, 0x4A1D, 0x6AFE, 0x6B1D, 
        0x6AFD, 0x6ADD, 0x6ABD, 0x6A9E, 0x629E, 0x629E, 0x629E, 0x5A9D, 0x5A7E, 0x5A7E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 0x5ABE, 0x5ABE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ADE, 0x5ADE, 0x5ABE, 0x5ABD, 0x5ABD, 0x5A9D, 0x529D, 0x529D, 0x5A9D, 
        0x5ABE, 0x5ABE, 0x5ADE, 0x5ADD, 0x62DE, 0x62DE, 0x62DE, 0x62FE, 0x62FE, 0x62DE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x631D, 0x62FE, 0x62FE, 0x631D, 0x631E, 0x62FE, 0x631E, 0x631E, 0x6B1E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 
        0x6B3E, 0x6B3E, 0x6B3D, 0x6B3D, 0x6B3D, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B1D, 0x631D, 0x62FD, 0x631D, 0x62FD, 0x62FE, 0x62FE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ADE, 0x52DE, 
        0x52BD, 0x52BD, 0x52BE, 0x529E, 0x527D, 0x527D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x525D, 0x525D, 0x527E, 0x527E, 0x525E, 0x525E, 0x525D, 0x525D, 0x525D, 0x5A7D, 0x5A9D, 0x62FE, 0x735E, 0x7B9D, 0x7BDD, 0x83FD, 0x845D, 
        0x949E, 0x9CFE, 0x9D1E, 0xA55E, 0xA55E, 0xA55E, 0xA53E, 0x9D3E, 0x9D3E, 0x9D3F, 0x9D1F, 0x94FE, 0x94DE, 0x94DE, 0x94DE, 0x94DE, 0x94DF, 0x94BF, 0x8C9E, 0x843E, 0x5B3D, 0x219C, 0x199D, 0x19BD, 0x21FD, 0x221D, 0x223D, 0x225D, 0x227D, 0x227D, 
        0x2A7D, 0x2A9D, 0x2A9D, 0x2A7D, 0x2A3D, 0x21DD, 0x119D, 0x19DD, 0x225E, 0x2A9D, 0x2ADD, 0x2ADD, 0x32FD, 0x32FE, 0x331E, 0x331E, 0x333E, 0x3B3D, 0x3B3E, 0x433E, 0x435E, 0x435E, 0x435E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x5BBE, 
        0x639D, 0x5317, 0x42F0, 0x432D, 0x432C, 0x436D, 0x43CE, 0x5450, 0x64B0, 0x6CF1, 0x7512, 0x74F2, 0x6CF0, 0x5C6D, 0x4C0A, 0x43C8, 0x43E8, 0x3BE8, 0x43E8, 0x3BE8, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4428, 0x4C28, 0x4C28, 0x4C48, 0x5449, 
        0x5449, 0x5C29, 0x5C29, 0x5C29, 0x5C29, 0x5C28, 0x5C28, 0x5428, 0x5428, 0x5428, 0x5428, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x43E7, 0x3BE6, 0x3BC7, 0x3BC6, 0x33C7, 0x33C7, 0x33A7, 0x33A7, 0x3387, 0x3388, 0x3B88, 0x3B68, 0x3B68, 0x3B48, 0x3B48, 
        0x4348, 0x4328, 0x4328, 0x4328, 0x4328, 0x3B08, 0x3B08, 0x3307, 0x3307, 0x3327, 0x3328, 0x2B48, 0x2B48, 0x2B47, 0x2B47, 0x2346, 0x2366, 0x2366, 0x2B67, 0x2B66, 0x2B66, 0x2B46, 0x2B46, 0x2B26, 0x2306, 0x22E6, 0x22E5, 0x1AC5, 0x1AA5, 0x1284, 
        0x1264, 0x1264, 0x1244, 0x1244, 0x1224, 0x1224, 0x1224, 0x1224, 0x1245, 0x1265, 0x1285, 0x1A85, 0x1AA5, 0x1AC5, 0x22C5, 0x22E5, 0x22E5, 0x2306, 0x2B26, 0x2B26, 0x3347, 0x3346, 0x3346, 0x3366, 0x3366, 0x3366, 0x2B46, 0x2B46, 0x2B26,
  0x948E, 0x9CAE, 0xA4CE, 0xA4CF, 0x9CAE, 0x948E, 0x8C8E, 0x8C8E, 0x8CAE, 0x84AE, 0x848E, 0x7C6F, 0x7C10, 0x8432, 0x7C70, 0x7C8E, 0x7C8D, 0x7CAD, 0x7CCD, 0x7CCD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84CD, 0x84CD, 0x84CD, 0x8CCD, 0x94EE, 0xAD71, 0x9CEF, 
        0x94AE, 0x8C8E, 0x8C6D, 0x846D, 0x846E, 0x8CAE, 0x84CE, 0x8CCE, 0x8CEF, 0x8CEF, 0x8CEF, 0x8CEF, 0x8CEE, 0x8CEE, 0x94CE, 0x94CF, 0x9CCF, 0x9CCF, 0x9CCF, 0x9CAF, 0x9C8F, 0x946F, 0x946F, 0x948F, 0x8CF0, 0x8530, 0x8530, 0x8550, 0x7D70, 0x8590, 
        0x7D90, 0x7D70, 0x7D70, 0x7D4F, 0x7D50, 0x6CEE, 0x7D71, 0x8591, 0x8591, 0x7D71, 0x7D71, 0x8591, 0x8591, 0x8591, 0x85B2, 0x7D91, 0x750F, 0x7D71, 0x7D50, 0x8591, 0x8DD2, 0x8DB2, 0x8D92, 0x8572, 0x8552, 0x8D32, 0x84D1, 0x73EE, 0x73AD, 0x7C0D, 
        0x842C, 0x7C4B, 0x7C6B, 0x7C6A, 0x746A, 0x646A, 0x5C8A, 0x5CAB, 0x64EB, 0x64CB, 0x5C8B, 0x646B, 0x748C, 0x848D, 0x8CAD, 0x8CAD, 0x94AD, 0x9CAD, 0x9CAC, 0x9CCC, 0xA4CC, 0xA4CC, 0xA4EC, 0xA4ED, 0xA4ED, 0x9CCE, 0x94AE, 0x848F, 0x7C8F, 0x744E, 
        0x5BEC, 0x4B8B, 0x3B4A, 0x434A, 0x4B6B, 0x4B6B, 0x4B6C, 0x63B1, 0x73D5, 0x7377, 0x7B1A, 0x7B1B, 0x7AFC, 0x72FC, 0x72DC, 0x6ADB, 0x62BB, 0x62BB, 0x62BB, 0x629A, 0x629B, 0x629A, 0x5A7A, 0x525A, 0x4A19, 0x49F9, 0x49D9, 0x49D9, 0x51B9, 0x6A5B, 
        0x833E, 0x8B3E, 0x8B3E, 0x8B5E, 0x8B5E, 0x939D, 0x9BDC, 0xA439, 0xA476, 0xA492, 0xA48E, 0x9CAD, 0x9CAD, 0x9CAD, 0x948E, 0x8C50, 0x7BD4, 0x62F8, 0x421A, 0x41BC, 0x39BC, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DC, 0x41FC, 0x62DE, 0x6AFE, 0x6ADE, 
        0x6ABE, 0x629D, 0x629D, 0x627E, 0x629E, 0x629E, 0x629E, 0x5A9D, 0x5A7D, 0x5A7D, 0x529D, 0x527D, 0x527D, 0x527D, 0x529D, 0x5A9E, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ABD, 0x5A9D, 0x5A9D, 0x5A9D, 
        0x5A9D, 0x5ABD, 0x5ADE, 0x5ADD, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x631E, 0x631D, 0x631D, 0x631D, 0x631D, 0x631E, 0x62FE, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 
        0x6B3E, 0x6B3E, 0x6B3E, 0x6B3D, 0x6B3D, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x631E, 0x631E, 0x631D, 0x631D, 0x631E, 0x631E, 0x62FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFE, 0x5ADE, 0x52DE, 0x52BD, 
        0x52BD, 0x52BD, 0x529D, 0x529D, 0x529D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x525D, 0x525D, 0x525D, 0x525D, 0x523D, 0x523D, 0x523D, 0x525D, 0x5ABD, 0x6B1E, 0x737E, 0x739D, 0x7BBD, 
        0x7BDD, 0x841D, 0x949E, 0x9CFE, 0xA53E, 0xA53E, 0xA53E, 0x9D3E, 0x9D3E, 0x9D1F, 0x9D1F, 0x9CFE, 0x94DE, 0x94DE, 0x94DE, 0x94BE, 0x94BE, 0x94BF, 0x94BE, 0x845E, 0x639D, 0x29DC, 0x197D, 0x19BD, 0x19DD, 0x21FD, 0x221D, 0x223D, 0x225D, 0x227D, 
        0x2A7D, 0x2A7D, 0x2A7D, 0x225D, 0x221D, 0x19BD, 0x119D, 0x19FD, 0x225D, 0x2A9D, 0x32BD, 0x32DD, 0x32DD, 0x32FE, 0x331E, 0x331E, 0x333E, 0x3B3E, 0x3B3E, 0x435E, 0x435E, 0x435E, 0x437E, 0x4B7E, 0x537E, 0x539E, 0x5B9E, 0x5B9E, 0x63BE, 0x639E, 
        0x5B5C, 0x4AD4, 0x4B0E, 0x432C, 0x430C, 0x434D, 0x4BCE, 0x5450, 0x64B0, 0x6CF1, 0x7512, 0x7512, 0x6CF0, 0x544D, 0x43EA, 0x3BE8, 0x3BE8, 0x3BE8, 0x3BE8, 0x3C07, 0x3C07, 0x3C08, 0x4408, 0x4408, 0x4408, 0x4428, 0x4428, 0x4C28, 0x4C28, 0x5429, 
        0x5429, 0x5428, 0x5C28, 0x5C28, 0x5C28, 0x5C28, 0x5C28, 0x5C28, 0x5408, 0x5428, 0x5428, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x4407, 0x3BE7, 0x3BE7, 0x3BE7, 0x33C7, 0x33C7, 0x33C7, 0x33A8, 0x33A7, 0x3B88, 0x3B88, 0x3B88, 0x4368, 0x4369, 0x4369, 
        0x4348, 0x4348, 0x4348, 0x4328, 0x4328, 0x3B28, 0x3B07, 0x3307, 0x3307, 0x3327, 0x3348, 0x2B48, 0x2B68, 0x2B67, 0x2B67, 0x2366, 0x2346, 0x2366, 0x2366, 0x2B66, 0x2B66, 0x2346, 0x2346, 0x2B26, 0x2306, 0x22E6, 0x22E5, 0x1AC5, 0x1AA5, 0x1284, 
        0x1264, 0x1264, 0x1264, 0x1244, 0x1244, 0x1244, 0x1244, 0x1244, 0x1244, 0x1264, 0x1285, 0x12A5, 0x1AA5, 0x1AC5, 0x1AC5, 0x22E5, 0x2306, 0x2306, 0x2B26, 0x2B26, 0x3346, 0x3366, 0x3366, 0x3366, 0x3366, 0x2B66, 0x2B46, 0x2B46, 0x2B26,
  0x94AF, 0x9CAE, 0xA4CE, 0x9CCE, 0x9CCE, 0x94AE, 0x8C8E, 0x8CAE, 0x84AE, 0x84AE, 0x848E, 0x7C6E, 0x7C30, 0x7C32, 0x7C70, 0x7C8F, 0x7C8D, 0x7C8D, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84AD, 0x84CD, 0x84CD, 0x8CCD, 0x8CAD, 0x94AD, 0x9CCF, 
        0x94AE, 0x948E, 0x8C8E, 0x846E, 0x848E, 0x84AE, 0x8CCE, 0x8CCE, 0x8CEF, 0x8CEE, 0x8CEE, 0x8D0E, 0x8CEE, 0x8CEE, 0x8CEE, 0x94EF, 0x9CEF, 0x9CEF, 0x9CCF, 0x9CAF, 0x9C6F, 0x944E, 0x9C4F, 0x948F, 0x8CD0, 0x8D10, 0x84F0, 0x850F, 0x8550, 0x7D70, 
        0x7D6F, 0x7D4F, 0x7D4F, 0x754F, 0x6CEE, 0x752F, 0x8591, 0x8591, 0x7D91, 0x7D91, 0x7D91, 0x7D91, 0x7D91, 0x7D91, 0x7550, 0x7530, 0x7530, 0x7D71, 0x85B2, 0x8DD2, 0x8DB2, 0x8591, 0x8D92, 0x8572, 0x8552, 0x8512, 0x7450, 0x73EE, 0x736C, 0x83ED, 
        0x840C, 0x844B, 0x7C6B, 0x7C6A, 0x6C4A, 0x644A, 0x5C6A, 0x64AA, 0x64CB, 0x64CB, 0x64AB, 0x648B, 0x646B, 0x748C, 0x7C8D, 0x84AD, 0x948D, 0x94AD, 0x9CAD, 0x9CAD, 0x9CCC, 0xA4CC, 0xA4EC, 0xA4ED, 0xA4ED, 0x9CCE, 0x94AE, 0x8CAE, 0x84AF, 0x7C8E, 
        0x6C2D, 0x5BAC, 0x432A, 0x432A, 0x4B4C, 0x5BAE, 0x6BD2, 0x73B7, 0x7359, 0x6AFA, 0x72FC, 0x7AFC, 0x7AFC, 0x72FC, 0x72FC, 0x6ADB, 0x6ADB, 0x6ADB, 0x62BA, 0x629A, 0x629A, 0x629A, 0x5A7A, 0x5A5A, 0x525A, 0x4A19, 0x49F9, 0x49F9, 0x51B9, 0x623A, 
        0x833E, 0x8B3E, 0x8B3E, 0x8B5E, 0x8B5E, 0x8B7E, 0x939D, 0x9BBD, 0x9BFA, 0xA438, 0xA494, 0x9C90, 0x9CAE, 0x9CAD, 0x9CAD, 0x948E, 0x8430, 0x7395, 0x5A99, 0x41DB, 0x39DC, 0x39BC, 0x39DD, 0x39DC, 0x39DC, 0x39BC, 0x523C, 0x6AFE, 0x6ADD, 0x62BD, 
        0x629E, 0x627E, 0x627D, 0x5A7D, 0x5A7D, 0x5A7E, 0x5A7E, 0x527D, 0x527D, 0x527D, 0x529D, 0x527E, 0x4A7D, 0x4A7D, 0x527D, 0x527E, 0x529E, 0x5A9E, 0x5ABE, 0x52BE, 0x52BE, 0x5ABE, 0x5ABE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 
        0x5ABD, 0x5ABD, 0x5ADE, 0x5ADE, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x62FD, 0x631D, 0x631E, 0x631D, 0x631D, 0x631E, 0x631D, 0x631E, 0x631E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 
        0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x735E, 0x735E, 0x735E, 0x6B5E, 0x6B3E, 0x633E, 0x631E, 0x633E, 0x631E, 0x631E, 0x633E, 0x631E, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 
        0x52BD, 0x52BD, 0x529D, 0x529D, 0x4A9D, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x525D, 0x5A9D, 0x62FD, 0x735E, 
        0x737E, 0x739D, 0x7BBD, 0x841D, 0x8C7D, 0x9CDE, 0x9D1E, 0x9D1E, 0x9D3E, 0x9D1F, 0x9D1F, 0x9CFF, 0x9CFF, 0x94DE, 0x94DE, 0x94BE, 0x94BE, 0x94BE, 0x949E, 0x8C5E, 0x73DE, 0x3A1D, 0x197D, 0x199D, 0x19DD, 0x21FD, 0x221D, 0x223D, 0x225D, 0x225D, 
        0x225D, 0x2A5D, 0x2A5D, 0x223D, 0x19FD, 0x199D, 0x119D, 0x19FD, 0x225D, 0x2A9D, 0x32BD, 0x32DD, 0x32DD, 0x32FE, 0x331E, 0x331E, 0x3B3E, 0x3B3E, 0x3B3E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5B9E, 0x5B9E, 0x63BE, 0x6BDD, 
        0x5B59, 0x4AF1, 0x4B4D, 0x4B2C, 0x430C, 0x434D, 0x4BCE, 0x5450, 0x64B0, 0x6CF1, 0x7512, 0x7512, 0x6CF0, 0x544C, 0x43EA, 0x43E8, 0x3BE8, 0x3C08, 0x4408, 0x3C08, 0x3C08, 0x3C08, 0x3C08, 0x4408, 0x4408, 0x4408, 0x4428, 0x4C28, 0x4C28, 0x4C28, 
        0x5428, 0x5428, 0x5428, 0x5428, 0x5428, 0x5C28, 0x5C28, 0x5C28, 0x5C08, 0x5408, 0x5408, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x4407, 0x4407, 0x3BE7, 0x3BE7, 0x3BE7, 0x3BE7, 0x33C7, 0x33C8, 0x3BA8, 0x3BA8, 0x3BA8, 0x3B88, 0x4389, 0x4389, 0x4369, 
        0x4369, 0x4348, 0x4348, 0x4328, 0x4328, 0x3B28, 0x3B08, 0x3B07, 0x3307, 0x3327, 0x3348, 0x2B48, 0x2B68, 0x2B67, 0x2B67, 0x2366, 0x2346, 0x2366, 0x2366, 0x2366, 0x2346, 0x2346, 0x2346, 0x2326, 0x1B05, 0x1AE5, 0x1AE5, 0x1AC5, 0x12C5, 0x1284, 
        0x1284, 0x1264, 0x1264, 0x1244, 0x1244, 0x1244, 0x1244, 0x1244, 0x1244, 0x1264, 0x1285, 0x12A5, 0x1AA5, 0x1AC5, 0x1AC5, 0x22E5, 0x2306, 0x2306, 0x2326, 0x2B46, 0x2B46, 0x3366, 0x3366, 0x3366, 0x2B66, 0x2B66, 0x2B46, 0x2B46, 0x2B26,
  0x9CCE, 0x9CAE, 0x9CEE, 0x9CEE, 0x9CCE, 0x94CE, 0x94AE, 0x8CAE, 0x84AE, 0x84AE, 0x84AE, 0x746E, 0x7C30, 0x8452, 0x7C91, 0x7C8F, 0x7C8D, 0x7C8D, 0x748D, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84AD, 0x84CD, 0x84CD, 0x8CAD, 0x8C8D, 0x94CE, 
        0x94AE, 0x8C6E, 0x846D, 0x846E, 0x848E, 0x84AE, 0x84CE, 0x84CF, 0x84EF, 0x84EE, 0x84EE, 0x84EE, 0x8D0E, 0x8D0E, 0x8CEE, 0x950F, 0x950F, 0x9D0F, 0x9CCF, 0x948F, 0x9C6E, 0x944E, 0x9C4F, 0x9C4F, 0x8C6F, 0x8CF0, 0x8D11, 0x8510, 0x7D30, 0x7D50, 
        0x754F, 0x754F, 0x752F, 0x6CEE, 0x752F, 0x7D70, 0x7D70, 0x7D91, 0x7D70, 0x7570, 0x7570, 0x7550, 0x7550, 0x7550, 0x7530, 0x6CCE, 0x7D51, 0x8592, 0x8DB2, 0x8DB2, 0x8591, 0x8571, 0x8572, 0x8D72, 0x8532, 0x7490, 0x7450, 0x6BAE, 0x6B4B, 0x83CC, 
        0x8BEC, 0x842C, 0x844B, 0x7C6B, 0x6C4A, 0x5C4A, 0x5449, 0x5C8A, 0x64AB, 0x6CCB, 0x6CCC, 0x64AB, 0x5C8B, 0x646B, 0x74AC, 0x7CCD, 0x84AD, 0x8C8D, 0x94AD, 0x94AD, 0x9CAC, 0x9CCC, 0xA4EC, 0xA4ED, 0x9CED, 0x9CED, 0x94CE, 0x94AE, 0x94AE, 0x8C8E, 
        0x7C4E, 0x6BCD, 0x5B8D, 0x6BF0, 0x7C74, 0x7C37, 0x7BB7, 0x731A, 0x6ADA, 0x731C, 0x7B1C, 0x7B1C, 0x7B1C, 0x731C, 0x731C, 0x6AFB, 0x6B1B, 0x6B1C, 0x6AFB, 0x62BA, 0x62BA, 0x62BA, 0x629A, 0x5A7A, 0x5A79, 0x525A, 0x5239, 0x5219, 0x51D9, 0x59D9, 
        0x7AFD, 0x833E, 0x8B5E, 0x8B5E, 0x8B7E, 0x937E, 0x937E, 0x9B9E, 0x9BBD, 0xA3DC, 0xA41A, 0xA495, 0x9CB2, 0x9CAE, 0x94AD, 0x94AD, 0x8C8E, 0x83F2, 0x7356, 0x4A1A, 0x39BC, 0x39BC, 0x39BC, 0x39DC, 0x41DC, 0x4A1D, 0x62BE, 0x6ADE, 0x62BD, 0x629D, 
        0x627D, 0x5A7D, 0x5A5D, 0x525D, 0x525D, 0x527D, 0x527D, 0x527D, 0x4A7D, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7E, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x5ABD, 0x5ADD, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ABD, 0x5ABD, 
        0x5ABD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5ADE, 0x62FD, 0x62FD, 0x62FD, 0x62FD, 0x62FE, 0x62FD, 0x62FD, 0x62FD, 0x631D, 0x631E, 0x631E, 0x631D, 0x631E, 0x631E, 0x633E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 
        0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B5E, 0x6B5E, 0x735E, 0x735E, 0x735E, 0x6B5E, 0x6B3E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1D, 0x5AFE, 0x5AFD, 0x5AFE, 0x5AFE, 0x52FE, 0x52FE, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 
        0x52BD, 0x529E, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9E, 0x429D, 0x429D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A3E, 0x423D, 0x423D, 0x423D, 0x423D, 0x4A3D, 0x4A3D, 0x4A1D, 0x4A3D, 0x523D, 0x525D, 
        0x62DD, 0x6B3E, 0x737E, 0x7B9E, 0x7BDD, 0x83FD, 0x8C7D, 0x9CFE, 0xA51F, 0xA51E, 0x9D1E, 0x9CFE, 0x9CDF, 0x94DE, 0x94BE, 0x94BE, 0x94BE, 0x949E, 0x8C7E, 0x8C5E, 0x73FE, 0x427D, 0x195C, 0x199D, 0x19BD, 0x19FD, 0x1A1D, 0x223D, 0x225D, 0x225D, 
        0x225D, 0x2A5D, 0x225D, 0x223D, 0x19DD, 0x117D, 0x119D, 0x1A1D, 0x227D, 0x2ABE, 0x32BE, 0x32DD, 0x32DE, 0x32FE, 0x331E, 0x331E, 0x3B3E, 0x3B3E, 0x3B3E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5B9E, 0x5BBE, 0x63BE, 0x6BBE, 0x8CFF, 
        0x6BB8, 0x5B90, 0x63AD, 0x534C, 0x430C, 0x434D, 0x4BCE, 0x5450, 0x64B0, 0x6CF1, 0x7511, 0x7511, 0x6CF0, 0x544C, 0x440A, 0x4408, 0x3C08, 0x3C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C28, 0x4C28, 0x4C28, 
        0x5428, 0x5428, 0x5428, 0x5428, 0x5428, 0x5C09, 0x5C09, 0x5408, 0x5408, 0x53E8, 0x53E8, 0x53E8, 0x4BE8, 0x4C08, 0x4C08, 0x4C07, 0x4407, 0x43E7, 0x43E7, 0x3BE7, 0x3BE7, 0x3BC7, 0x3BC7, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BA8, 0x43C9, 0x43A9, 0x4389, 
        0x4389, 0x4369, 0x4369, 0x4348, 0x4348, 0x3B28, 0x3B28, 0x3B28, 0x3307, 0x3327, 0x3348, 0x2B47, 0x2B67, 0x2B67, 0x2367, 0x2366, 0x2366, 0x1B66, 0x1B66, 0x2346, 0x1B46, 0x2326, 0x1B26, 0x1B06, 0x1B05, 0x1AE5, 0x1AE5, 0x1AC5, 0x12C5, 0x12A5, 
        0x1284, 0x1284, 0x1264, 0x1264, 0x1244, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x12A5, 0x12A5, 0x1AC5, 0x1AC5, 0x1AE5, 0x1AE5, 0x2305, 0x2325, 0x2326, 0x2B46, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B26, 0x2B26,
  0x94CE, 0x9CAE, 0x9CCE, 0x9CEE, 0x9CEE, 0x94CE, 0x8CAE, 0x8CAE, 0x84AE, 0x84AE, 0x7C8E, 0x744E, 0x7C51, 0x8473, 0x7C91, 0x7C8F, 0x7C8D, 0x746D, 0x748D, 0x748D, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84CD, 0x84CD, 0x8CAD, 0x8C8D, 0x94AE, 
        0x8C8E, 0x844D, 0x844D, 0x7C6D, 0x7C8E, 0x7CAE, 0x7CCE, 0x7CCE, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x8D0E, 0x8D0E, 0x8D0E, 0x8D0E, 0x950F, 0x9D0F, 0x9CCF, 0x948E, 0x9C6E, 0x946E, 0x9C4F, 0x9C4F, 0x944F, 0x8C8F, 0x84AF, 0x7CAF, 0x7D0F, 0x7D2F, 
        0x752F, 0x6CEE, 0x64CD, 0x752F, 0x7550, 0x7550, 0x7D70, 0x7D70, 0x7570, 0x7550, 0x6D4F, 0x754F, 0x754F, 0x7550, 0x6CEF, 0x7D50, 0x8592, 0x8592, 0x8592, 0x8571, 0x8D92, 0x8571, 0x8571, 0x8531, 0x7490, 0x7470, 0x63EE, 0x52CA, 0x630A, 0x7B4B, 
        0x83AB, 0x83EC, 0x842C, 0x744B, 0x644A, 0x5C4A, 0x5449, 0x5C69, 0x6CAB, 0x6CCC, 0x6CEC, 0x64CB, 0x5C8B, 0x5C6A, 0x6CAB, 0x74CC, 0x7CAD, 0x84AD, 0x8C8D, 0x948D, 0x9CAD, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CED, 0x9CED, 0x94CD, 0x9CCD, 0x9CAD, 0x948E, 
        0x8C4F, 0x8451, 0x8C95, 0x8C78, 0x8439, 0x7B9A, 0x733A, 0x6ADB, 0x731C, 0x7B3C, 0x7B3C, 0x7B1C, 0x7B1C, 0x731C, 0x731C, 0x6B1B, 0x6AFB, 0x6AFB, 0x6AFA, 0x62BA, 0x62BA, 0x62BA, 0x62BA, 0x62BA, 0x5A9A, 0x5A79, 0x5259, 0x5239, 0x51F9, 0x51D8, 
        0x6219, 0x7AFD, 0x8B3E, 0x8B3E, 0x8B5E, 0x8B5E, 0x937E, 0x939E, 0x9B9E, 0x9B9D, 0x9BBD, 0x9C1A, 0x9C77, 0x9CB3, 0x9CB0, 0x94AE, 0x948D, 0x8C4F, 0x7BF3, 0x5A98, 0x41DA, 0x39BB, 0x39BC, 0x41BC, 0x49FC, 0x62BE, 0x62BE, 0x62BE, 0x629D, 0x5A7D, 
        0x5A7D, 0x5A5D, 0x525D, 0x525D, 0x525D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x529D, 0x529E, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x5ABD, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x52DD, 
        0x5ABD, 0x5ABD, 0x5ADE, 0x5ADD, 0x5ADD, 0x5AFD, 0x62FD, 0x62FD, 0x631D, 0x62FE, 0x62FD, 0x62FD, 0x62FD, 0x631D, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B3D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 
        0x6B5D, 0x6B5E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x735E, 0x6B5E, 0x6B5E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633D, 0x631E, 0x631D, 0x5B1D, 0x5AFE, 0x5AFD, 0x5AFE, 0x5AFE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52BD, 0x4ABD, 
        0x4ABD, 0x4ABE, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABD, 0x42BE, 0x429D, 0x429D, 0x429D, 0x429D, 0x429D, 0x429D, 0x429E, 0x429E, 0x429E, 0x429E, 0x427D, 0x425D, 0x425E, 0x423D, 0x423D, 0x3A3D, 0x3A3D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x4A3D, 
        0x4A3D, 0x525D, 0x5ABD, 0x6B1E, 0x735E, 0x7BBE, 0x83FD, 0x8C3D, 0x949E, 0x9CDE, 0x9CFE, 0x9CFE, 0x94DE, 0x94DE, 0x94BE, 0x94BE, 0x8C9E, 0x949E, 0x8C7E, 0x8C5E, 0x841E, 0x52DD, 0x195C, 0x117D, 0x19BD, 0x19DD, 0x19FD, 0x223D, 0x223D, 0x225D, 
        0x223D, 0x223D, 0x223D, 0x221D, 0x19BD, 0x117C, 0x19BD, 0x221D, 0x227D, 0x2A9E, 0x32BE, 0x32DD, 0x32DE, 0x32FE, 0x331E, 0x331E, 0x3B3E, 0x3B3E, 0x3B3E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x539E, 0x5BBE, 0x5BBE, 0x63BE, 0x6BFE, 0x8CDD, 
        0x9D7C, 0xBEBA, 0x9D73, 0x63CE, 0x4B4E, 0x436E, 0x4BCF, 0x5C50, 0x64B0, 0x6CF1, 0x6D11, 0x7511, 0x6CEF, 0x544C, 0x4C0A, 0x4409, 0x4408, 0x3C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C28, 0x4C28, 0x4C28, 
        0x5428, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x4C08, 0x4C08, 0x4C07, 0x4BE7, 0x43E8, 0x43E7, 0x43E7, 0x43E7, 0x3BE7, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BE8, 0x3BC9, 0x43E9, 0x43C9, 0x43A9, 
        0x43A9, 0x4389, 0x4369, 0x4368, 0x4348, 0x3B48, 0x3B48, 0x3328, 0x3327, 0x3347, 0x3347, 0x2B47, 0x2B67, 0x2367, 0x2367, 0x1B66, 0x1B66, 0x1B65, 0x1B66, 0x1B46, 0x1B46, 0x1B26, 0x1B26, 0x1B06, 0x1B05, 0x1AE5, 0x1AE5, 0x1AC5, 0x12C5, 0x1AA5, 
        0x12A5, 0x12A4, 0x1284, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1264, 0x1284, 0x12A5, 0x12A5, 0x12C5, 0x1AC5, 0x1AE5, 0x1B05, 0x2306, 0x2326, 0x2346, 0x2B46, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B46, 0x2B26, 0x2B26,
  0x9CCE, 0x9CCE, 0x9CCE, 0x9CEE, 0x9CEE, 0x94CE, 0x8CAE, 0x8CAE, 0x84AE, 0x84AE, 0x7C8E, 0x744E, 0x7C71, 0x8493, 0x7C91, 0x7C8F, 0x7C8E, 0x746D, 0x746D, 0x746D, 0x748D, 0x748D, 0x748D, 0x748D, 0x7C8D, 0x7CAD, 0x7CCD, 0x84CD, 0x8CAD, 0x8C8D, 0x948E, 
        0x8C6E, 0x844D, 0x7C4D, 0x746D, 0x7C8D, 0x7CAE, 0x7CCE, 0x7CCE, 0x7CCE, 0x84CD, 0x84CD, 0x84EE, 0x850E, 0x84EE, 0x8CEE, 0x8CEE, 0x950F, 0x950F, 0x94CE, 0x948E, 0x9C8E, 0x946F, 0x9C6F, 0x9C4F, 0x9C4F, 0x946F, 0x846F, 0x7C8F, 0x7CEF, 0x750F, 
        0x64AD, 0x64CE, 0x754F, 0x754F, 0x754F, 0x7550, 0x7550, 0x754F, 0x6D2F, 0x6D2F, 0x6D2F, 0x6D2F, 0x6D2F, 0x6D0F, 0x7530, 0x85B2, 0x85B2, 0x8592, 0x8551, 0x8D92, 0x8D91, 0x8591, 0x8551, 0x74B0, 0x7490, 0x7490, 0x42EA, 0x3A88, 0x4AC9, 0x6B09, 
        0x734A, 0x83CB, 0x840C, 0x7C2B, 0x6C4A, 0x5C4A, 0x5449, 0x5C69, 0x6CAB, 0x74EC, 0x74EC, 0x6CCC, 0x64AB, 0x5C8A, 0x648B, 0x74AC, 0x84CD, 0x8CCE, 0x94AE, 0x948D, 0x94AD, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCD, 0x9CCD, 0xA4AF, 0xA491, 
        0x9C74, 0x9458, 0x9419, 0x83BB, 0x7B7B, 0x72FC, 0x6ABC, 0x72FC, 0x7B3C, 0x7B3C, 0x7B1B, 0x731C, 0x731B, 0x731B, 0x731B, 0x6B1B, 0x6B1B, 0x6B1A, 0x6AFA, 0x62DA, 0x62DA, 0x62BA, 0x62B9, 0x5AB9, 0x5A99, 0x5A99, 0x5279, 0x5259, 0x5219, 0x5A19, 
        0x59F9, 0x59FA, 0x72BC, 0x831E, 0x833E, 0x8B5E, 0x8B5E, 0x939E, 0x939E, 0x9B9E, 0x939E, 0x93BD, 0x9BFC, 0x9C59, 0x9C94, 0x9C90, 0x948E, 0x8C6E, 0x8410, 0x6B16, 0x49F9, 0x41BB, 0x399C, 0x41BC, 0x5A7E, 0x62DE, 0x62BD, 0x62BD, 0x629D, 0x5A7D, 
        0x5A7D, 0x525D, 0x525D, 0x525D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x425D, 0x423D, 0x4A5D, 0x4A9E, 0x529E, 0x529E, 0x529D, 0x529D, 0x52BD, 0x5ABD, 0x5ADE, 0x5ADE, 0x5ADE, 0x52DD, 
        0x5ABD, 0x5ABD, 0x5ADE, 0x5ADD, 0x5ADD, 0x62FD, 0x62FD, 0x62FD, 0x631E, 0x631D, 0x62FD, 0x62FD, 0x62FD, 0x631D, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 
        0x6B5D, 0x6B5E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5E, 0x735E, 0x6B5E, 0x6B3E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x631E, 0x631E, 0x5B3E, 0x5B1E, 0x5AFD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x4ADD, 0x4ABE, 
        0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABE, 0x42BE, 0x429D, 0x429D, 0x429D, 0x429D, 0x429D, 0x429E, 0x429D, 0x429D, 0x429D, 0x427D, 0x425D, 0x423E, 0x423D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x421D, 0x421D, 
        0x423D, 0x4A1D, 0x4A3D, 0x525D, 0x5A9C, 0x62FD, 0x7B9E, 0x7BDE, 0x83FD, 0x8C5E, 0x949E, 0x94DF, 0x94DE, 0x94DF, 0x94BE, 0x8C9E, 0x8C9E, 0x8C7E, 0x8C7E, 0x8C5E, 0x841E, 0x5B3E, 0x217C, 0x115D, 0x199D, 0x19DD, 0x19FD, 0x1A3D, 0x1A3D, 0x223D, 
        0x223D, 0x221D, 0x21FE, 0x19DE, 0x199D, 0x117D, 0x19BD, 0x221D, 0x2A7D, 0x2A9D, 0x32BE, 0x32DD, 0x32DE, 0x32FE, 0x331E, 0x331E, 0x333D, 0x3B3E, 0x3B3E, 0x433E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 0x5BBE, 0x63BE, 0x63BE, 0x6BBD, 0x6399, 
        0x63F2, 0x6C2F, 0x6BED, 0x5B8D, 0x4B4D, 0x436E, 0x4BCF, 0x5C50, 0x64B0, 0x6CF1, 0x6D11, 0x7511, 0x6CCF, 0x544C, 0x4C0A, 0x4C09, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4C08, 
        0x4C08, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x53E8, 0x4BE8, 0x4BE8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43E8, 0x43E7, 0x43E7, 0x4407, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E9, 0x43E9, 0x4BE9, 0x4BC9, 
        0x43C9, 0x4BA9, 0x4389, 0x4388, 0x4368, 0x3B68, 0x3B48, 0x3348, 0x3347, 0x2B47, 0x2B47, 0x2B47, 0x2B67, 0x2367, 0x2366, 0x1B66, 0x1B66, 0x1B65, 0x1B65, 0x1B46, 0x1B46, 0x1B46, 0x1B46, 0x1B26, 0x1B05, 0x1B05, 0x12E5, 0x12C5, 0x12C5, 0x12C5, 
        0x12C5, 0x12A5, 0x12A4, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x12A5, 0x12C5, 0x1AC5, 0x1AE5, 0x2305, 0x2325, 0x2346, 0x2346, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2346, 0x2326, 0x2326,
  0x94CE, 0x94AE, 0x94CE, 0x9CCE, 0x9CCE, 0x94CE, 0x8CAE, 0x8CAE, 0x84AE, 0x848E, 0x7C6E, 0x742E, 0x7C92, 0x8493, 0x7CB1, 0x7CAF, 0x7CAE, 0x7C8D, 0x748D, 0x748D, 0x748D, 0x748D, 0x748D, 0x748C, 0x7C8D, 0x7CAD, 0x7CAD, 0x84CD, 0x8CAE, 0x8CAD, 0x94AE, 
        0x8C8E, 0x7C4D, 0x746D, 0x748D, 0x7CAD, 0x7CAD, 0x7CAE, 0x7CAE, 0x7CCD, 0x7CCD, 0x84CD, 0x84EE, 0x850E, 0x8D0E, 0x8D0E, 0x8D0E, 0x950E, 0x94EF, 0x94CF, 0x94AF, 0x9C8F, 0x9C8F, 0x9C6F, 0xA44F, 0x9C4F, 0x9470, 0x8C90, 0x84B0, 0x748E, 0x646E, 
        0x6CEF, 0x752F, 0x754F, 0x7550, 0x7D70, 0x7550, 0x6D0F, 0x6D0F, 0x6D2F, 0x6D0F, 0x6D2F, 0x752F, 0x6D0F, 0x7530, 0x85B2, 0x85B2, 0x8592, 0x8551, 0x8551, 0x8571, 0x8D92, 0x8D92, 0x8551, 0x7CD1, 0x7C91, 0x4B4B, 0x3AA8, 0x3287, 0x3A87, 0x52A7, 
        0x6308, 0x736A, 0x7BEB, 0x7C2B, 0x744B, 0x646A, 0x5C49, 0x646A, 0x6CAB, 0x74EC, 0x74EC, 0x74EC, 0x6CCB, 0x64AB, 0x64AB, 0x74CC, 0x84EE, 0x8CEE, 0x94CE, 0x948D, 0x948D, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAD, 0x9CAE, 0xA4AF, 0xA493, 0xA455, 
        0xA3F8, 0x93BA, 0x8B7C, 0x831D, 0x72DC, 0x6ABC, 0x72FD, 0x731C, 0x731C, 0x731B, 0x731B, 0x731B, 0x72FB, 0x731B, 0x731B, 0x731B, 0x6B1B, 0x6B1A, 0x6B1A, 0x6AFA, 0x62DA, 0x62DA, 0x62D9, 0x62B9, 0x5AB9, 0x5AB9, 0x5A99, 0x5A79, 0x5259, 0x5A59, 
        0x5A3A, 0x5A19, 0x59FA, 0x6A7B, 0x82FD, 0x8B3E, 0x8B3E, 0x937E, 0x937E, 0x939E, 0x939E, 0x939E, 0x939D, 0x93DC, 0x9C39, 0x9C95, 0x9C91, 0x944F, 0x8C2F, 0x7374, 0x5258, 0x41DA, 0x419B, 0x51FD, 0x62BE, 0x62BD, 0x62BD, 0x629D, 0x5A7D, 0x5A7D, 
        0x525D, 0x525D, 0x525D, 0x4A5D, 0x4A3D, 0x4A3D, 0x4A3D, 0x423D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5E, 0x4A5D, 0x4A5D, 0x4A5D, 0x423D, 0x421D, 0x421D, 0x4A5D, 0x527E, 0x529D, 0x529D, 0x529E, 0x529D, 0x5ABE, 0x5ADE, 0x52DD, 0x5ADE, 0x5ADE, 
        0x5ADE, 0x5ABD, 0x5ADE, 0x5ADD, 0x5ADD, 0x62FD, 0x62FD, 0x631D, 0x631D, 0x62FD, 0x62FD, 0x62FD, 0x62FD, 0x631D, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 
        0x6B5E, 0x6B5E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B5D, 0x6B5E, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B5E, 0x6B5E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x5B1E, 0x5B1E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x4ADE, 
        0x4ADE, 0x4ABE, 0x4ABE, 0x4ADD, 0x4ADD, 0x42BD, 0x42BD, 0x42BE, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x429E, 0x429D, 0x429D, 0x429D, 0x427D, 0x427D, 0x425D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 
        0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A1D, 0x4A3D, 0x5A9C, 0x6B5D, 0x7BBE, 0x7BFE, 0x841D, 0x8C5E, 0x8C9E, 0x94BF, 0x8C9E, 0x8C9E, 0x8C9E, 0x8C7E, 0x8C7E, 0x8C3E, 0x841E, 0x637E, 0x29BD, 0x113D, 0x117D, 0x199D, 0x19DD, 0x1A1D, 0x1A1D, 0x1A3D, 
        0x221D, 0x19FD, 0x19DE, 0x19BD, 0x117D, 0x117D, 0x19DD, 0x223D, 0x227D, 0x2ABE, 0x32BD, 0x32DD, 0x2ADE, 0x32FD, 0x331E, 0x331E, 0x3B1D, 0x3B3E, 0x3B3E, 0x433E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 0x5BBE, 0x63BE, 0x63BD, 0x637C, 0x5354, 
        0x53AD, 0x5BAC, 0x63AC, 0x534C, 0x4B2D, 0x436E, 0x4BEF, 0x5C50, 0x64B0, 0x6CF1, 0x6D11, 0x7511, 0x6CCF, 0x5C8D, 0x542B, 0x4C29, 0x4C29, 0x4C08, 0x4C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4C08, 
        0x4C08, 0x5408, 0x5408, 0x5408, 0x5408, 0x53E8, 0x53E8, 0x4BE8, 0x4BE8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x5408, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4408, 0x43E7, 0x4408, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E9, 0x4BE9, 0x4BE9, 0x4BE9, 
        0x43C9, 0x4BA9, 0x4BA9, 0x4388, 0x4388, 0x3B88, 0x3B68, 0x3368, 0x3367, 0x3367, 0x2B47, 0x2B67, 0x2B67, 0x2367, 0x2366, 0x1B66, 0x1B66, 0x1B65, 0x1B65, 0x1B45, 0x1B46, 0x1B46, 0x1B46, 0x1B26, 0x1B05, 0x1B05, 0x1B05, 0x12E5, 0x12E5, 0x12C5, 
        0x12C5, 0x1AC5, 0x12A5, 0x12A5, 0x1285, 0x1284, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x12C4, 0x12C5, 0x1AE5, 0x1AE5, 0x2305, 0x2325, 0x2346, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B46, 0x2B46, 0x2346, 0x2326, 0x2306,
  0x94CF, 0x94AE, 0x94AD, 0x94CE, 0x94CE, 0x8CCE, 0x8CAE, 0x84AE, 0x848E, 0x7C8E, 0x7C6E, 0x742F, 0x8493, 0x8473, 0x84B0, 0x7CAF, 0x7CAE, 0x7CAD, 0x7C8D, 0x748D, 0x748D, 0x748D, 0x748D, 0x74AD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84AD, 0x8CCE, 0x8CAE, 0x948E, 
        0x848D, 0x7C4C, 0x7C8D, 0x7CAD, 0x74AD, 0x7CAD, 0x7CAD, 0x7CCD, 0x84CD, 0x84CD, 0x84CE, 0x84EE, 0x8D0E, 0x8D2F, 0x8D0E, 0x950E, 0x94EE, 0x950F, 0x94EF, 0x94CF, 0x9CAF, 0x9C8F, 0x9C6F, 0xA44F, 0x9C4F, 0x9C70, 0x9490, 0x8CB0, 0x7C8F, 0x74CF, 
        0x750F, 0x750F, 0x752F, 0x752F, 0x6D0F, 0x6D0F, 0x6D0F, 0x6D2F, 0x6D30, 0x752F, 0x7530, 0x6D0F, 0x752F, 0x85B1, 0x85B2, 0x85B2, 0x8D91, 0x7D30, 0x8591, 0x8D92, 0x8D92, 0x8D72, 0x8532, 0x7CD1, 0x5BCD, 0x3AC9, 0x3AA8, 0x3287, 0x3286, 0x3A86, 
        0x4AA7, 0x6329, 0x738A, 0x7C0B, 0x744B, 0x6C8B, 0x5C6A, 0x646A, 0x6CCB, 0x7CEC, 0x7CEC, 0x7CEC, 0x74CC, 0x6CCB, 0x6CCB, 0x7CEC, 0x8D0E, 0x8CEE, 0x94CE, 0x8C8D, 0x946C, 0x948C, 0x94AC, 0x94AC, 0x9CAD, 0x9CAE, 0xA491, 0xA474, 0xA417, 0x9BBA, 
        0x937C, 0x8B3D, 0x8B1D, 0x7ADC, 0x72DC, 0x7B1D, 0x7B1D, 0x731C, 0x731B, 0x731B, 0x731B, 0x731B, 0x72FB, 0x6B1B, 0x731B, 0x731B, 0x731B, 0x731B, 0x733B, 0x731B, 0x6AFA, 0x6ADA, 0x62DA, 0x62BA, 0x62B9, 0x62B9, 0x5A99, 0x5A99, 0x5279, 0x5259, 
        0x5A59, 0x5239, 0x5219, 0x59F9, 0x59FA, 0x729C, 0x831E, 0x833E, 0x8B5E, 0x8B7E, 0x8B7D, 0x8B7E, 0x8B7E, 0x939D, 0x93BD, 0x9C1B, 0x9C58, 0x9473, 0x8C30, 0x7BD2, 0x6317, 0x4A19, 0x41DB, 0x5A7E, 0x629E, 0x629E, 0x5A7D, 0x5A7D, 0x5A7D, 0x525D, 
        0x525D, 0x525D, 0x4A3D, 0x4A3E, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x4A3D, 0x4A5D, 0x4A5E, 0x4A5D, 0x4A5D, 0x4A5D, 0x423D, 0x421D, 0x421D, 0x421D, 0x4A5D, 0x4A5D, 0x4A7E, 0x529E, 0x529E, 0x529E, 0x5ABE, 0x52DD, 0x5ADD, 0x5ADE, 
        0x5ADE, 0x5ABD, 0x5ADE, 0x5ADD, 0x5ADD, 0x62DD, 0x62FE, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x633E, 0x633E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 
        0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B7D, 0x6B7D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B3E, 0x633D, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x5B3E, 0x5B3E, 0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 
        0x52DE, 0x52DE, 0x4ADE, 0x4ADD, 0x4ABE, 0x4ABE, 0x42BE, 0x42BE, 0x42BE, 0x429D, 0x429D, 0x429D, 0x429D, 0x42BE, 0x429E, 0x429D, 0x429D, 0x429D, 0x427D, 0x425D, 0x425E, 0x3A5D, 0x3A3D, 0x3A5E, 0x3A3D, 0x3A5E, 0x3A5E, 0x3A5D, 0x3A3D, 0x3A3D, 
        0x3A3D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A3C, 0x5ABC, 0x737E, 0x7BDE, 0x7BFE, 0x843E, 0x8C9E, 0x8C9E, 0x8C7E, 0x8C7E, 0x8C7E, 0x8C5E, 0x843E, 0x841E, 0x6B9E, 0x31FD, 0x111D, 0x115D, 0x117D, 0x11BD, 0x19FD, 0x19FD, 0x19FD, 
        0x19FD, 0x19DD, 0x11BD, 0x117D, 0x095C, 0x117D, 0x19DD, 0x223D, 0x2A7D, 0x2ABD, 0x2ADD, 0x2ADD, 0x32FD, 0x331D, 0x331D, 0x3B3E, 0x3B3E, 0x3B3E, 0x3B3E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 0x5BBE, 0x5BBE, 0x63BD, 0x5B78, 0x4B70, 
        0x5BCB, 0x5BEA, 0x5BAB, 0x4B2C, 0x4B2D, 0x4B6E, 0x4BEF, 0x5C50, 0x64B1, 0x6CF1, 0x7511, 0x7511, 0x6CCF, 0x64AD, 0x5C4B, 0x542A, 0x4C29, 0x4C29, 0x5429, 0x4C08, 0x4C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4408, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE9, 0x4BE9, 0x4BE9, 
        0x4BE9, 0x4BC9, 0x43A9, 0x43A8, 0x4388, 0x3B88, 0x3B88, 0x3B68, 0x3367, 0x3367, 0x2B67, 0x2B87, 0x2367, 0x2386, 0x2366, 0x1B66, 0x1B66, 0x1B65, 0x1B65, 0x1365, 0x1365, 0x1345, 0x1345, 0x1B25, 0x1B05, 0x1B05, 0x1305, 0x1B05, 0x12E5, 0x12E5, 
        0x12C5, 0x1AC5, 0x12A4, 0x1284, 0x1285, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x12A4, 0x12C4, 0x12C5, 0x1AE5, 0x1B05, 0x1B05, 0x2326, 0x2346, 0x2366, 0x2B86, 0x2B86, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B26, 0x2326, 0x2306,
  0x94CF, 0x94CE, 0x8CAD, 0x8CAD, 0x94CE, 0x8CCE, 0x84AE, 0x84AE, 0x7C8E, 0x7C6E, 0x744E, 0x7450, 0x8493, 0x8493, 0x7C90, 0x7CAE, 0x7C8E, 0x7CAD, 0x7CAD, 0x7C8D, 0x7CAD, 0x74AD, 0x74AD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84AD, 0x8CCE, 0x8CAD, 0x8C8E, 
        0x846D, 0x7C6D, 0x7C8D, 0x7CAD, 0x74AD, 0x7CAD, 0x7CCD, 0x7CCD, 0x84CD, 0x84CD, 0x84EE, 0x8D0E, 0x8D0F, 0x8D0F, 0x8D0F, 0x950F, 0x950F, 0x950F, 0x94EF, 0x94CF, 0x9CAF, 0x9C8F, 0x9C6F, 0xA44F, 0xA46F, 0x9C90, 0x9CB0, 0x8CB0, 0x7C8F, 0x74CF, 
        0x750F, 0x6D0F, 0x6D0F, 0x752F, 0x752F, 0x6D0F, 0x752F, 0x7530, 0x6D30, 0x6D30, 0x6D0F, 0x752F, 0x8591, 0x85B2, 0x85B2, 0x8591, 0x7D30, 0x8D91, 0x8D92, 0x8D92, 0x8D72, 0x8552, 0x8511, 0x63EE, 0x42EB, 0x3AC9, 0x3AA8, 0x32C7, 0x2A86, 0x2A85, 
        0x3A86, 0x52C7, 0x6348, 0x73EA, 0x7C4B, 0x6CAB, 0x648A, 0x6C8A, 0x74CB, 0x7CCC, 0x84EC, 0x84EC, 0x84EC, 0x7CEC, 0x7CEC, 0x850D, 0x8D0D, 0x8CEE, 0x8CCE, 0x8C8C, 0x8C6C, 0x948C, 0x948C, 0x948B, 0x9C8E, 0xA471, 0xA435, 0xA3D7, 0x9B7A, 0x931C, 
        0x8AFD, 0x8AFD, 0x82FD, 0x82FD, 0x833D, 0x7B3D, 0x7B3D, 0x7B3C, 0x731C, 0x733B, 0x731B, 0x731B, 0x731B, 0x6B1B, 0x6B1B, 0x6B1A, 0x6AFA, 0x6AFB, 0x6AFA, 0x6ADA, 0x6ADA, 0x6ADA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x5AB9, 0x5A99, 0x5278, 0x5258, 
        0x5258, 0x5239, 0x5219, 0x51F9, 0x51D9, 0x59D9, 0x623B, 0x7ADD, 0x831D, 0x835E, 0x8B7E, 0x8B7E, 0x8B7E, 0x8B7E, 0x8B7E, 0x8B9D, 0x93BD, 0x9C3A, 0x9C56, 0x8414, 0x7376, 0x5A79, 0x521B, 0x627E, 0x5A7E, 0x5A7D, 0x5A7D, 0x527D, 0x525D, 0x525D, 
        0x4A3E, 0x4A3D, 0x4A3D, 0x423E, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x423D, 0x423E, 0x423D, 0x4A3E, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A3E, 0x4A7E, 0x527E, 0x529E, 0x529E, 0x52BE, 0x5ABD, 0x5ABD, 0x5ADE, 
        0x5ADE, 0x5ADD, 0x5ADE, 0x5ADD, 0x5AFE, 0x62DE, 0x62FE, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B3E, 0x633D, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5B1E, 0x531E, 0x531E, 0x531E, 0x52FE, 
        0x52FE, 0x52FE, 0x4AFE, 0x4ADE, 0x4ADE, 0x4ADE, 0x4ABE, 0x4ABE, 0x4ABE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x429D, 0x429D, 0x429D, 0x429D, 0x429D, 0x427D, 0x425E, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5E, 0x3A5E, 0x3A5D, 0x325D, 0x3A5D, 0x3A5D, 
        0x3A5E, 0x3A3E, 0x3A3E, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x4A3D, 0x529C, 0x6B5E, 0x73BE, 0x7BFE, 0x7C1D, 0x845E, 0x8C7E, 0x8C5E, 0x8C5E, 0x8C5E, 0x843E, 0x841E, 0x73DE, 0x427D, 0x111D, 0x113D, 0x117D, 0x11BD, 0x19DD, 0x19DD, 0x19DD, 
        0x19DD, 0x11BD, 0x119D, 0x095D, 0x093C, 0x119D, 0x19FD, 0x225D, 0x2A9D, 0x2ABD, 0x2ADD, 0x32DE, 0x32FD, 0x331D, 0x331D, 0x3B3E, 0x3B3E, 0x3B3E, 0x433E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 0x5BBE, 0x5B9E, 0x639C, 0x4B53, 0x538E, 
        0x5BCB, 0x5BEA, 0x5BAB, 0x4B0B, 0x4B0D, 0x4B6E, 0x4BEF, 0x5C50, 0x64B1, 0x6CF1, 0x7511, 0x7511, 0x6CAE, 0x5C4C, 0x5C2A, 0x542A, 0x5429, 0x5429, 0x5429, 0x4C08, 0x4C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 
        0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x53E8, 0x53E8, 0x53E8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 
        0x4BE9, 0x4BE9, 0x43C9, 0x43C9, 0x43A8, 0x3BA8, 0x3B88, 0x3B88, 0x3388, 0x3387, 0x2B87, 0x2B87, 0x2387, 0x2386, 0x2386, 0x1B66, 0x1B66, 0x1B65, 0x1B65, 0x1365, 0x1365, 0x1345, 0x1345, 0x1B25, 0x1B25, 0x1B25, 0x1305, 0x1B05, 0x1305, 0x12E4, 
        0x12E4, 0x1AC5, 0x12A4, 0x1284, 0x12A4, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x12A5, 0x12C4, 0x12C5, 0x1AE5, 0x1B05, 0x1B05, 0x2326, 0x2346, 0x2366, 0x2B86, 0x2B87, 0x2B86, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2B26, 0x2326, 0x2306,
  0x94CF, 0x94CE, 0x8CAD, 0x8CAD, 0x8CCE, 0x8CCE, 0x84CE, 0x84AE, 0x7C8E, 0x7C8E, 0x744E, 0x7C71, 0x84B4, 0x7C93, 0x7C90, 0x7C8E, 0x7C8E, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x74AD, 0x7CAD, 0x7CAD, 0x84CD, 0x8CAD, 0x8C8D, 0x948E, 
        0x846D, 0x7C6D, 0x7C6D, 0x7C8D, 0x74AD, 0x7CAD, 0x74CD, 0x7CCD, 0x84CD, 0x84CE, 0x84EE, 0x8CEE, 0x8D0E, 0x8D0F, 0x8D0F, 0x950F, 0x950F, 0x950F, 0x950F, 0x94EF, 0x9CCF, 0x9C8F, 0x9C6F, 0x9C6F, 0xA46F, 0xA4B0, 0xA4D1, 0x94B0, 0x7C8F, 0x74CF, 
        0x750F, 0x750F, 0x754F, 0x752F, 0x752F, 0x752F, 0x752F, 0x7550, 0x7550, 0x64EF, 0x750F, 0x7D71, 0x8591, 0x8591, 0x7D50, 0x7D0F, 0x8D91, 0x95B2, 0x8D92, 0x8D72, 0x8D72, 0x8511, 0x6C2F, 0x63CE, 0x63CE, 0x5B8C, 0x32A8, 0x32C7, 0x2AA5, 0x2A85, 
        0x2A85, 0x3AA6, 0x4B07, 0x6BA9, 0x7C6B, 0x74AC, 0x6C8B, 0x6CAB, 0x7CCC, 0x84CC, 0x84ED, 0x8D0D, 0x8D2D, 0x850D, 0x850C, 0x850D, 0x850D, 0x8CEE, 0x8CAD, 0x8C8C, 0x8C6C, 0x8C6C, 0x946C, 0x946D, 0x9450, 0x9BF4, 0x9B98, 0x933A, 0x8AFB, 0x82DC, 
        0x82DD, 0x82DD, 0x831D, 0x833D, 0x833D, 0x7B3D, 0x7B3C, 0x733C, 0x733C, 0x733C, 0x733B, 0x733C, 0x733C, 0x6B1B, 0x6B1B, 0x6AFA, 0x6AFA, 0x6AFB, 0x6AFB, 0x62FA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x5ABA, 0x5AB9, 0x5AB9, 0x5A99, 
        0x5278, 0x5258, 0x5238, 0x5218, 0x51F9, 0x51D9, 0x51B9, 0x59DA, 0x72BC, 0x831E, 0x833D, 0x8B5E, 0x8B7E, 0x837E, 0x8B7E, 0x8B7E, 0x8B9E, 0x93BD, 0x93FB, 0x9439, 0x83F9, 0x6AFA, 0x627C, 0x5A7D, 0x5A7D, 0x5A5D, 0x525D, 0x525D, 0x525D, 0x523D, 
        0x4A3E, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x423D, 0x423E, 0x423D, 0x423D, 0x423D, 0x421E, 0x421D, 0x41FD, 0x421D, 0x4A3E, 0x4A7E, 0x527E, 0x529E, 0x529E, 0x52BE, 0x5ABD, 0x5ABE, 
        0x5ADE, 0x5ADD, 0x5ADE, 0x5ADE, 0x5ADE, 0x62DE, 0x62DD, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x62FE, 0x631E, 0x631E, 0x633E, 0x631E, 0x631E, 0x633E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B3D, 0x633D, 0x633D, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5B3E, 0x531E, 0x531E, 
        0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x4ADE, 0x4ADE, 0x4ADE, 0x4ADD, 0x4ADE, 0x4ABD, 0x4ABD, 0x4ABD, 0x42BD, 0x42BE, 0x42BE, 0x42BE, 0x429E, 0x429E, 0x429D, 0x429D, 0x427E, 0x3A9D, 0x3A7E, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A3E, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x421E, 0x421D, 0x4A1D, 0x4A3D, 0x5ADD, 0x737E, 0x7BDE, 0x841E, 0x843E, 0x8C5E, 0x845E, 0x843E, 0x843E, 0x7C1E, 0x73DE, 0x52DE, 0x193D, 0x091D, 0x115D, 0x119D, 0x11BD, 0x19DD, 0x11BD, 
        0x11BD, 0x119D, 0x097D, 0x095D, 0x011C, 0x119D, 0x1A1D, 0x225D, 0x2A9D, 0x2ABD, 0x32DD, 0x32DD, 0x32FD, 0x331D, 0x331D, 0x3B1D, 0x3B3D, 0x3B3E, 0x433E, 0x435E, 0x4B5E, 0x4B7E, 0x4B7E, 0x539E, 0x5B9E, 0x5B9E, 0x639D, 0x5337, 0x4B50, 0x53CC, 
        0x5BEA, 0x5BEA, 0x538A, 0x430B, 0x430C, 0x4B8E, 0x4BEF, 0x5C50, 0x64B1, 0x6CF1, 0x7511, 0x7510, 0x6CAE, 0x5C4C, 0x5C2A, 0x5C2A, 0x5429, 0x5429, 0x5428, 0x5428, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x5408, 0x5408, 0x5408, 0x5428, 0x5409, 0x5409, 0x5428, 0x4C08, 0x4C09, 0x4C09, 0x4C09, 
        0x4C09, 0x4BE9, 0x43E9, 0x43C9, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x33A8, 0x33A7, 0x33A7, 0x2BA7, 0x2BA7, 0x2386, 0x2386, 0x2386, 0x1B86, 0x1B65, 0x1B65, 0x1365, 0x1365, 0x1345, 0x1345, 0x1325, 0x1325, 0x1325, 0x1325, 0x1B25, 0x1B04, 0x1B04, 
        0x12E4, 0x1AC4, 0x1AA4, 0x1A84, 0x1AA4, 0x1284, 0x1284, 0x1284, 0x1284, 0x12A4, 0x1AA5, 0x1AC5, 0x1AE5, 0x1AE5, 0x1B05, 0x2306, 0x2326, 0x2346, 0x2367, 0x2B87, 0x2B87, 0x2B87, 0x2B66, 0x2B66, 0x2B66, 0x2B46, 0x2346, 0x2326, 0x2326,
  0x94EF, 0x94EF, 0x8CCE, 0x8CCD, 0x8CCD, 0x8CCE, 0x8CCE, 0x84AE, 0x7C8E, 0x7C6E, 0x744E, 0x8492, 0x84B4, 0x8493, 0x7C90, 0x7C8E, 0x7C8E, 0x7CAD, 0x7CAD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84CD, 0x84CD, 0x8C8D, 0x8C8E, 
        0x846D, 0x7C4C, 0x7C6D, 0x7C8D, 0x74AD, 0x7CAD, 0x7CAD, 0x7CCE, 0x7CCE, 0x84EE, 0x84EE, 0x84EE, 0x850E, 0x8D0F, 0x8D0F, 0x8D0F, 0x952F, 0x950F, 0x950F, 0x950F, 0x94EF, 0x9CAF, 0x9C8F, 0x9C8F, 0xA490, 0xA4B0, 0xACF1, 0xA4F1, 0x94F1, 0x7CCF, 
        0x74EF, 0x74EF, 0x750F, 0x6D0F, 0x752F, 0x752F, 0x7550, 0x7530, 0x6CEE, 0x6D2F, 0x7D91, 0x85B1, 0x85B1, 0x7D50, 0x7D30, 0x8D91, 0x8DB2, 0x8DB2, 0x8D92, 0x8D72, 0x8531, 0x6C4F, 0x7490, 0x7471, 0x6C30, 0x4B2B, 0x32A8, 0x2AC7, 0x2AC6, 0x22A5, 
        0x2285, 0x2A65, 0x3AC6, 0x63A9, 0x7C8C, 0x7CCC, 0x74CC, 0x74CB, 0x7CEC, 0x84EC, 0x8D0D, 0x952D, 0x954E, 0x954D, 0x8D2D, 0x850D, 0x850D, 0x8CEE, 0x8CCD, 0x848D, 0x8C6C, 0x8C6C, 0x946D, 0x944E, 0x93F2, 0x9397, 0x931A, 0x8AFB, 0x82DC, 0x8AFD, 
        0x8B1D, 0x8B1E, 0x833D, 0x833D, 0x7B3D, 0x7B3C, 0x7B5C, 0x733C, 0x733C, 0x733C, 0x733B, 0x733C, 0x6B3C, 0x6B1B, 0x6B1B, 0x6AFB, 0x6AFB, 0x6AFB, 0x62FB, 0x62FA, 0x62FA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x62DA, 0x5ABA, 0x5ABA, 0x5AD9, 0x5AB9, 
        0x5A99, 0x5278, 0x5238, 0x4A18, 0x49F8, 0x49D8, 0x49B9, 0x4999, 0x51DA, 0x729D, 0x7B1D, 0x833D, 0x835E, 0x837E, 0x837E, 0x837E, 0x837E, 0x837E, 0x8B9D, 0x8BDD, 0x8BDC, 0x839D, 0x72DD, 0x627D, 0x5A5D, 0x5A5D, 0x523D, 0x523D, 0x523E, 0x4A3E, 
        0x4A3E, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x421D, 0x41FD, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x423D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A5D, 0x4A5E, 0x527E, 0x529E, 0x529E, 0x52BE, 0x5ABE, 
        0x5ABE, 0x5ADD, 0x5ADE, 0x5ADE, 0x5ADE, 0x5ADE, 0x62DD, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x62FD, 0x62FD, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x739E, 0x6B7E, 0x6B5E, 0x6B5E, 0x6B3E, 0x6B3E, 0x6B3D, 0x633D, 0x633E, 0x633E, 0x633E, 0x633E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x531E, 
        0x531D, 0x52FE, 0x52FE, 0x52FE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x429E, 0x429E, 0x429E, 0x429E, 0x3A9E, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x325D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1E, 0x421D, 0x421D, 0x4A3C, 0x527C, 0x62FD, 0x739E, 0x7BDE, 0x841E, 0x843E, 0x843E, 0x841E, 0x7BFE, 0x7BDE, 0x633E, 0x215D, 0x091D, 0x095D, 0x117D, 0x119D, 0x119D, 0x119D, 
        0x119D, 0x097D, 0x095D, 0x011D, 0x011C, 0x11BD, 0x221D, 0x2A7D, 0x2A9E, 0x2ABD, 0x32BD, 0x32DE, 0x32FD, 0x32FD, 0x331E, 0x3B1E, 0x3B3E, 0x3B3E, 0x433E, 0x435E, 0x4B5E, 0x4B7E, 0x537E, 0x539E, 0x5B9E, 0x5B9E, 0x5B5B, 0x4B13, 0x4B8D, 0x53CB, 
        0x5BEA, 0x5BEA, 0x538B, 0x430B, 0x430C, 0x438E, 0x4BEF, 0x5C50, 0x64B1, 0x6CF1, 0x7511, 0x7510, 0x6CAE, 0x5C4C, 0x5C4A, 0x5C4A, 0x5449, 0x5C29, 0x5429, 0x5428, 0x5428, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x5428, 0x5408, 0x5428, 0x5428, 0x5428, 0x5428, 0x5429, 0x5429, 0x5428, 0x5429, 0x5429, 0x4C29, 0x4C29, 
        0x4C09, 0x4C09, 0x4C09, 0x4BE9, 0x43E9, 0x43C8, 0x3BC8, 0x3BC8, 0x3BC8, 0x33C8, 0x33A7, 0x2BC7, 0x2BA7, 0x2BA7, 0x2B86, 0x2387, 0x2386, 0x1B86, 0x1B86, 0x1B85, 0x1B65, 0x1B45, 0x1B45, 0x1B45, 0x1345, 0x1325, 0x1325, 0x1B25, 0x1304, 0x1AE4, 
        0x12E4, 0x1AC4, 0x1AA4, 0x1A84, 0x1AA4, 0x12A4, 0x12A4, 0x12A4, 0x12A4, 0x1AA4, 0x1AA5, 0x1AC5, 0x1AE5, 0x1AE5, 0x1B05, 0x2306, 0x2326, 0x2346, 0x2367, 0x2B87, 0x2B87, 0x2B87, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2346, 0x2326, 0x2326,
  0x9CEF, 0x94EE, 0x8CEE, 0x8CCE, 0x8CCE, 0x8CCE, 0x8CCE, 0x84AE, 0x7C8E, 0x746E, 0x744F, 0x84B3, 0x84D4, 0x84B3, 0x7C91, 0x7C8E, 0x7C8E, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CAD, 0x7CAD, 0x84CD, 0x8CCD, 0x8CAD, 0x8CAE, 
        0x848E, 0x7C6D, 0x7C6D, 0x7C8D, 0x748D, 0x7C8D, 0x7CAE, 0x7CAE, 0x84CE, 0x84EE, 0x850E, 0x84EE, 0x84EE, 0x8D0E, 0x8D0F, 0x8D2F, 0x952F, 0x952F, 0x950F, 0x950F, 0x94EF, 0x94CF, 0x9CAF, 0x9CAF, 0xA4B0, 0xACF1, 0xAD11, 0xA511, 0x9D11, 0x8CF0, 
        0x74CF, 0x74EF, 0x6CEF, 0x6D0F, 0x6D0F, 0x7530, 0x7550, 0x6CCE, 0x752F, 0x7D91, 0x8591, 0x8591, 0x7D50, 0x7D2F, 0x8DB2, 0x8DB2, 0x8DB2, 0x8D92, 0x8D92, 0x7D11, 0x6C6F, 0x7CD1, 0x7CD1, 0x6C50, 0x5BEF, 0x3AEA, 0x32C8, 0x2AC7, 0x2AC6, 0x2AC6, 
        0x22A5, 0x2284, 0x32E5, 0x5BE9, 0x74AC, 0x7CEC, 0x7CEC, 0x7CEC, 0x84EC, 0x8D0C, 0x952D, 0x9D4E, 0x9D4E, 0x9D6E, 0x954E, 0x8D2D, 0x850E, 0x84EE, 0x84CD, 0x7C8D, 0x846C, 0x8C8C, 0x948D, 0x9410, 0x9376, 0x9359, 0x933C, 0x8B3D, 0x8B3D, 0x8B3D, 
        0x8B3D, 0x833D, 0x833D, 0x833D, 0x7B5C, 0x7B5C, 0x7B5C, 0x735C, 0x733C, 0x733C, 0x733B, 0x6B3B, 0x6B1B, 0x6B1B, 0x6B1B, 0x633B, 0x631B, 0x631B, 0x62FB, 0x62FB, 0x62FB, 0x62DB, 0x5ADA, 0x5ADA, 0x5ADA, 0x5ADA, 0x5ADA, 0x5ADA, 0x5AD9, 0x5AB9, 
        0x5A99, 0x5279, 0x5258, 0x4A58, 0x4A38, 0x49F8, 0x41D8, 0x49B8, 0x4998, 0x49BA, 0x625C, 0x7AFE, 0x833E, 0x837E, 0x837E, 0x837E, 0x835D, 0x837E, 0x837E, 0x8B7E, 0x8B9E, 0x839E, 0x835E, 0x72FD, 0x627D, 0x525D, 0x523D, 0x4A3E, 0x4A3E, 0x4A3D, 
        0x4A1D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x41FD, 0x41FD, 0x421D, 0x421D, 0x421D, 0x423D, 0x423E, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x423D, 0x4A5D, 0x4A5D, 0x527D, 0x529E, 0x529E, 0x52BD, 
        0x5ABD, 0x5ADD, 0x5ADE, 0x5ADE, 0x5ADE, 0x5AFE, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x631D, 0x631D, 0x631D, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B3E, 0x6B5E, 0x6B5D, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B3E, 0x6B3E, 0x633D, 0x633E, 0x633E, 0x633E, 0x635E, 0x633E, 0x5B3E, 0x5B5E, 0x635E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 
        0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x52FE, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADD, 0x4ABD, 0x42DD, 0x42DD, 0x42DD, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x429E, 0x42BE, 0x429E, 0x3A9D, 0x3A9D, 0x3A7D, 0x427D, 0x3A7D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x41FD, 0x421D, 0x4A1C, 0x529C, 0x739E, 0x7BDE, 0x7C1E, 0x841E, 0x841E, 0x7BFE, 0x73DD, 0x633E, 0x29BD, 0x08FD, 0x093D, 0x095D, 0x097D, 0x099D, 0x099D, 
        0x099D, 0x097D, 0x013D, 0x011D, 0x011C, 0x19DD, 0x221D, 0x2A7D, 0x2A9D, 0x2ABD, 0x2ADE, 0x2ADE, 0x2ADE, 0x32FD, 0x32FD, 0x3B1E, 0x3B1E, 0x3B3D, 0x3B3E, 0x435E, 0x4B5E, 0x4B7E, 0x537E, 0x537D, 0x5B9E, 0x63BD, 0x5338, 0x4B4F, 0x4BAC, 0x53EA, 
        0x5BEA, 0x5BCB, 0x536B, 0x430B, 0x430C, 0x4B6E, 0x4BEF, 0x5C70, 0x64D0, 0x6D11, 0x7531, 0x7510, 0x6CAE, 0x6C6C, 0x644B, 0x644A, 0x5C4A, 0x5C29, 0x5C29, 0x5429, 0x5429, 0x4C08, 0x4C08, 0x4BE8, 0x4C08, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C09, 
        0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4BE8, 0x4C09, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x5428, 0x5428, 0x5428, 0x5428, 0x5C28, 0x5C28, 0x5C49, 0x5C49, 0x5C29, 0x5428, 0x5429, 0x5429, 0x4C29, 
        0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4409, 0x43E9, 0x43E8, 0x3BE8, 0x3BC8, 0x3BC8, 0x3BC7, 0x33C7, 0x33A7, 0x2BA7, 0x2BA6, 0x2BA6, 0x23A6, 0x2386, 0x2386, 0x1B86, 0x1B86, 0x1B65, 0x1B65, 0x1B45, 0x1345, 0x1345, 0x1324, 0x1B25, 0x1B05, 0x1B05, 
        0x1AE4, 0x1AC4, 0x12C4, 0x1AA4, 0x12A4, 0x1284, 0x1284, 0x1284, 0x12A4, 0x1AA5, 0x1AA5, 0x1AC5, 0x1AE6, 0x1AE5, 0x1B05, 0x2306, 0x2326, 0x2346, 0x2366, 0x2B87, 0x2B87, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B67, 0x2346, 0x2326, 0x2327,
  0x9CEF, 0x94EF, 0x8CEE, 0x8CEE, 0x8CCE, 0x8CCE, 0x84CE, 0x84AE, 0x7C8E, 0x744E, 0x7C70, 0x84D4, 0x8CD4, 0x8493, 0x7C71, 0x7C8E, 0x7CAE, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x74CD, 0x74CD, 0x74AD, 0x748C, 0x7CAC, 0x7CCD, 0x84CD, 0x84AD, 0x84AE, 
        0x848E, 0x7C6D, 0x7C6D, 0x748D, 0x748D, 0x7C8D, 0x7C8D, 0x7CAE, 0x7CAE, 0x84EE, 0x84EF, 0x84EF, 0x84EF, 0x8D0E, 0x8D0F, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x952F, 0x950F, 0x9CEF, 0x9CEF, 0xA4D0, 0xA4F0, 0xAD11, 0xAD11, 0xACF1, 0xA4F1, 0x8CD0, 
        0x7CAF, 0x74EF, 0x750F, 0x6D0F, 0x752F, 0x750F, 0x6CCE, 0x7D50, 0x85B1, 0x85B1, 0x85B1, 0x7D2F, 0x8570, 0x8DB1, 0x8DB2, 0x8DB2, 0x8D72, 0x8D92, 0x8D92, 0x7CF0, 0x7CD1, 0x7CD1, 0x6C50, 0x642F, 0x5BCE, 0x4B8C, 0x3B0A, 0x32C8, 0x2AC7, 0x2AC5, 
        0x22A5, 0x22A4, 0x4367, 0x644A, 0x7CEC, 0x850D, 0x850C, 0x850C, 0x8D0C, 0x952D, 0x9D4D, 0xA54E, 0xA56E, 0xA56E, 0x9D4E, 0x954E, 0x8D2E, 0x8D0E, 0x84EE, 0x7C8D, 0x846C, 0x8C6C, 0x8C8C, 0x8C10, 0x8B76, 0x8B3A, 0x8B3C, 0x833C, 0x8B3D, 0x8B3D, 
        0x833D, 0x833D, 0x833D, 0x7B3D, 0x7B3D, 0x7B3C, 0x7B5C, 0x7B5C, 0x733C, 0x733C, 0x733C, 0x6B1C, 0x6B3C, 0x6B1B, 0x6B1B, 0x6B1B, 0x6B1B, 0x631B, 0x631B, 0x62FB, 0x5AFB, 0x5ADB, 0x5ABA, 0x5ADA, 0x5ADA, 0x5ADA, 0x5ADA, 0x5ABA, 0x52B9, 0x5A99, 
        0x5279, 0x5279, 0x5279, 0x4A78, 0x4A58, 0x4A38, 0x4218, 0x41F8, 0x41B8, 0x4199, 0x4999, 0x5A3B, 0x72DE, 0x7B3E, 0x835E, 0x835D, 0x835D, 0x835E, 0x837E, 0x837E, 0x837E, 0x837E, 0x835E, 0x7B5E, 0x731E, 0x62BD, 0x525D, 0x523D, 0x4A1E, 0x4A1D, 
        0x421D, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x421D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x41FD, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x423D, 0x423E, 0x4A3D, 0x4A3D, 0x4A5D, 0x4A5D, 0x525D, 0x529E, 0x529E, 0x529E, 
        0x5ABE, 0x5ABD, 0x5ADD, 0x5ADE, 0x5ADD, 0x5AFE, 0x62DD, 0x62FE, 0x62FE, 0x62FE, 0x631D, 0x631D, 0x631D, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B3E, 0x6B5E, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737D, 0x6B5E, 0x6B5E, 0x6B3E, 0x633D, 0x633E, 0x633E, 0x633E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 
        0x5B3E, 0x531E, 0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x4B1E, 0x4AFE, 0x4AFE, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADD, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x429D, 0x3A9D, 0x3A9D, 0x427D, 0x427D, 0x3A7D, 0x3A7D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x41FD, 0x41FD, 0x421D, 0x529D, 0x6B7E, 0x73DE, 0x7BFE, 0x83FE, 0x7BFE, 0x7BDD, 0x6B5E, 0x31DD, 0x08FC, 0x00FD, 0x093D, 0x095D, 0x097D, 0x097D, 
        0x097D, 0x013D, 0x011D, 0x00FD, 0x013D, 0x19FD, 0x223E, 0x2A7E, 0x2A9D, 0x2ABD, 0x2ABD, 0x2ADE, 0x2ADE, 0x32FD, 0x32FD, 0x3B1E, 0x3B1E, 0x3B1D, 0x3B3D, 0x433E, 0x4B5E, 0x537E, 0x537E, 0x5B9E, 0x5B9E, 0x5B7C, 0x42F4, 0x438C, 0x4BCA, 0x53EA, 
        0x5BEA, 0x5BCB, 0x536A, 0x430B, 0x4B0D, 0x4B8E, 0x4BEF, 0x5C70, 0x64D0, 0x6D11, 0x7531, 0x7D30, 0x7D30, 0x852E, 0x74AC, 0x646A, 0x5C4A, 0x5C29, 0x5C29, 0x5429, 0x5429, 0x5409, 0x4C08, 0x4BE8, 0x4BE8, 0x4C09, 0x4C09, 0x4C08, 0x4C08, 0x4C09, 
        0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x5409, 0x4C09, 0x4C09, 0x4C09, 0x43E8, 0x43E8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x5408, 0x5428, 0x5428, 0x5C29, 0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5449, 0x5449, 0x5449, 
        0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4409, 0x4409, 0x43E8, 0x3BE8, 0x3BE8, 0x3BC8, 0x33C7, 0x33C7, 0x33C7, 0x2BA6, 0x2BA7, 0x2BA6, 0x23A6, 0x23A6, 0x23A6, 0x1BA6, 0x1B86, 0x1B65, 0x1B65, 0x1B45, 0x1B45, 0x1B25, 0x1B25, 0x1B05, 0x1B04, 
        0x1AE4, 0x1AC4, 0x12C4, 0x1AA4, 0x12A4, 0x1284, 0x1284, 0x12A4, 0x12A4, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE6, 0x1AE5, 0x1B05, 0x2306, 0x2326, 0x2346, 0x2367, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B67, 0x2347, 0x2347, 0x2327,
  0x9CEF, 0x94EE, 0x8CEE, 0x8CEE, 0x8CEE, 0x8CCE, 0x84AF, 0x7C8F, 0x7C6E, 0x744E, 0x7C91, 0x84D3, 0x84B3, 0x7C72, 0x7470, 0x7C8E, 0x748E, 0x748D, 0x7CAD, 0x7CCD, 0x7CAD, 0x7CAD, 0x74CD, 0x74CD, 0x74AD, 0x748C, 0x74AC, 0x7CAD, 0x84CD, 0x8CCD, 0x84CE, 
        0x84AE, 0x7C6D, 0x7C6D, 0x746D, 0x748D, 0x748D, 0x748D, 0x7C8D, 0x7CAE, 0x7CCE, 0x84EF, 0x84EF, 0x84EF, 0x850E, 0x8D0F, 0x8D0F, 0x8D2F, 0x954F, 0x952F, 0x952F, 0x952F, 0x9D10, 0xA510, 0xA510, 0xAD11, 0xAD11, 0xACF0, 0xACD0, 0xA4D0, 0x94AF, 
        0x7C8F, 0x7D10, 0x7510, 0x7510, 0x750F, 0x6CAE, 0x7D50, 0x7D91, 0x85B1, 0x8591, 0x750F, 0x8571, 0x8DB1, 0x8DB1, 0x8DB2, 0x8571, 0x8D92, 0x95B3, 0x8D92, 0x8532, 0x7CD1, 0x6C4F, 0x644F, 0x642E, 0x5C0E, 0x53CD, 0x434B, 0x3AE9, 0x2AC7, 0x2AC6, 
        0x22C5, 0x3306, 0x4BE9, 0x6CAB, 0x7D0C, 0x852D, 0x852D, 0x8D2D, 0x952D, 0x9D4D, 0xA54E, 0xAD6E, 0xAD6F, 0xA56E, 0xA54E, 0x9D4E, 0x9D4F, 0x8D2E, 0x84CD, 0x7C8D, 0x7C4C, 0x8C4D, 0x8C6D, 0x8C10, 0x8B94, 0x8B19, 0x831C, 0x831D, 0x833D, 0x833D, 
        0x833D, 0x833D, 0x833D, 0x7B3D, 0x7B3D, 0x7B3C, 0x7B5C, 0x7B3C, 0x7B3D, 0x7B3C, 0x733C, 0x733C, 0x6B1C, 0x6B1C, 0x6B1C, 0x6B1C, 0x6B1C, 0x631C, 0x631C, 0x62FB, 0x62FB, 0x5ADB, 0x5ADB, 0x5ADA, 0x5ADA, 0x5ADA, 0x52BA, 0x52B9, 0x52B9, 0x5299, 
        0x5299, 0x5279, 0x5279, 0x5279, 0x5258, 0x4A58, 0x4238, 0x4218, 0x41F8, 0x41B9, 0x4199, 0x4999, 0x51FB, 0x6A9D, 0x72FE, 0x7B3E, 0x7B5E, 0x837E, 0x8B9E, 0x8B9E, 0x837E, 0x839E, 0x837E, 0x837E, 0x835E, 0x7B3E, 0x6AFE, 0x627D, 0x51FD, 0x49FD, 
        0x41FD, 0x41DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x3A1D, 0x421D, 0x423E, 0x4A3D, 0x4A3E, 0x4A3D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x527E, 0x529E, 0x529E, 
        0x529E, 0x52BD, 0x52BD, 0x5ABD, 0x5ADD, 0x5AFD, 0x5AFD, 0x62FE, 0x62FE, 0x5AFE, 0x62FD, 0x62FD, 0x631E, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7E, 0x6B7D, 0x6B7D, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B5E, 0x633E, 0x633E, 0x633E, 0x633E, 0x635E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 
        0x5B3E, 0x531E, 0x533E, 0x531E, 0x531E, 0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x4AFD, 0x4AFD, 0x4AFD, 0x4AFD, 0x4ADE, 0x4ADE, 0x4ADE, 0x4ADE, 0x4ADE, 0x4ABE, 0x4ABE, 0x42BD, 0x42BD, 0x429D, 0x3A9D, 0x429D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 
        0x3A5D, 0x325D, 0x3A5D, 0x325E, 0x325D, 0x325D, 0x323D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x39FD, 0x421D, 0x421D, 0x529D, 0x6B3E, 0x73BE, 0x7BDE, 0x7BDE, 0x73DE, 0x6B5E, 0x421E, 0x08DC, 0x00DD, 0x011D, 0x093D, 0x093D, 0x093D, 
        0x013D, 0x011D, 0x011D, 0x011D, 0x013D, 0x19FD, 0x223E, 0x227D, 0x2A9D, 0x2ABD, 0x2ABD, 0x2ADE, 0x2ADE, 0x32DD, 0x32FD, 0x3AFD, 0x3B1D, 0x3B1D, 0x3B3D, 0x433E, 0x4B5E, 0x4B5E, 0x537E, 0x5B7E, 0x639E, 0x5319, 0x42F0, 0x4B8B, 0x4BC9, 0x53C9, 
        0x53CA, 0x5BAB, 0x4B2A, 0x42EB, 0x4B2D, 0x4B8E, 0x540F, 0x5C70, 0x64D0, 0x6CF1, 0x7511, 0x7D10, 0x7D0F, 0x850E, 0x74AC, 0x6C6A, 0x644A, 0x5C29, 0x5C29, 0x5C29, 0x5409, 0x5409, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 
        0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x5429, 0x5409, 0x4C09, 0x4408, 0x43E9, 0x43E8, 0x43E8, 0x43E8, 0x4BE8, 0x4BE8, 0x4BE8, 0x5408, 0x5409, 0x5409, 0x5C29, 0x5C29, 0x5C49, 0x5C49, 0x5C49, 0x5C49, 0x5C69, 0x5C69, 0x5C69, 0x5C69, 0x544A, 
        0x5449, 0x5449, 0x5449, 0x4C29, 0x4C29, 0x4C29, 0x4429, 0x4408, 0x3C08, 0x3BE8, 0x3BE7, 0x3BC7, 0x33C7, 0x33C7, 0x33C7, 0x2BC7, 0x2BA6, 0x2BA6, 0x2BA6, 0x23A6, 0x23A6, 0x2386, 0x1B86, 0x1B65, 0x1B65, 0x1B65, 0x1B45, 0x1B45, 0x1B24, 0x1B04, 
        0x1B04, 0x1AC4, 0x1AC4, 0x1AA4, 0x1A84, 0x1AA4, 0x1AA4, 0x12A4, 0x12A4, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE6, 0x1AE6, 0x2306, 0x2306, 0x2326, 0x2326, 0x2347, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B67, 0x2B67, 0x2347, 0x2327,
  0x9CEF, 0x94EE, 0x94EE, 0x8CCF, 0x8CCF, 0x8CAF, 0x84AF, 0x848F, 0x7C6E, 0x744F, 0x84B2, 0x84D3, 0x7CB3, 0x7471, 0x746F, 0x748E, 0x748D, 0x748D, 0x74AD, 0x74AD, 0x7CAD, 0x7CAD, 0x74AD, 0x74AD, 0x74CC, 0x74AC, 0x74AC, 0x7CCD, 0x84CD, 0x8CCE, 0x8CEE, 
        0x84CE, 0x7C6D, 0x744C, 0x746D, 0x746D, 0x746D, 0x748D, 0x748D, 0x7CAE, 0x7CCE, 0x84EF, 0x84EF, 0x84EF, 0x84EE, 0x8D0E, 0x8D0E, 0x8D2F, 0x8D4F, 0x952F, 0x954F, 0x952F, 0x9D2F, 0xA530, 0xA530, 0xAD31, 0xAD10, 0xA4CF, 0xA4AF, 0xA4B0, 0x9C90, 
        0x848F, 0x8510, 0x7D10, 0x74EF, 0x6CAE, 0x7D30, 0x7D50, 0x7D70, 0x7D50, 0x74EF, 0x8571, 0x8D91, 0x8DB1, 0x8DB2, 0x8D91, 0x8D91, 0x8DB2, 0x8D92, 0x8552, 0x8511, 0x6C4F, 0x640E, 0x646F, 0x5C4E, 0x5C2D, 0x53CD, 0x4B6B, 0x3B29, 0x3B08, 0x3306, 
        0x3306, 0x4BE8, 0x646B, 0x7CEC, 0x852D, 0x8D2D, 0x8D2D, 0x9D2D, 0xA54E, 0xAD6E, 0xAD6E, 0xB56F, 0xAD6F, 0xAD4E, 0xA54E, 0xA56F, 0xA56F, 0x952E, 0x84CD, 0x744C, 0x7C2C, 0x844C, 0x8C6D, 0x8C2E, 0x8BD2, 0x8318, 0x831B, 0x831D, 0x831D, 0x833D, 
        0x833D, 0x833D, 0x833D, 0x7B3D, 0x7B3D, 0x7B3D, 0x7B3D, 0x7B3D, 0x7B3D, 0x7B3D, 0x733D, 0x731C, 0x731D, 0x6B1C, 0x6B1C, 0x6B1C, 0x6B1C, 0x631C, 0x631C, 0x631C, 0x5AFC, 0x5AFB, 0x5ADB, 0x5ADB, 0x5ADB, 0x52DB, 0x52BA, 0x52BA, 0x529A, 0x5299, 
        0x5299, 0x5279, 0x5279, 0x5279, 0x5258, 0x4A58, 0x4258, 0x4238, 0x4218, 0x41D8, 0x41B9, 0x4199, 0x4179, 0x499A, 0x521B, 0x627C, 0x72FD, 0x835E, 0x837E, 0x837E, 0x837E, 0x839E, 0x8B9E, 0x8B9E, 0x839E, 0x837E, 0x7B5E, 0x733E, 0x629E, 0x521D, 
        0x41DD, 0x41BD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x39DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x3A1D, 0x421D, 0x423D, 0x4A5E, 0x4A5E, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525D, 0x527D, 0x527D, 
        0x529E, 0x529E, 0x52BD, 0x52BE, 0x5ADD, 0x5AFE, 0x5ADD, 0x5AFE, 0x62FE, 0x5AFE, 0x62FD, 0x62FD, 0x631E, 0x631E, 0x631E, 0x631E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 0x6B7D, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B5E, 0x635E, 0x635E, 0x635E, 0x635E, 0x637E, 0x637E, 0x6B9E, 0x639E, 0x639E, 0x637E, 0x637E, 0x635E, 0x635E, 0x635E, 0x5B5E, 
        0x5B5E, 0x5B3E, 0x5B3E, 0x533E, 0x531E, 0x531E, 0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x4AFE, 0x52FE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADE, 0x4ABE, 0x42BD, 0x42BE, 0x42BD, 0x3A9D, 0x429D, 0x3A9D, 0x3A9D, 0x3A7D, 0x3A7D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x39FE, 0x3A1D, 0x3A1D, 0x421C, 0x423C, 0x5ADD, 0x73BE, 0x7BDE, 0x73BE, 0x6B7E, 0x425E, 0x10DC, 0x00BD, 0x00FD, 0x011D, 0x011D, 0x011D, 
        0x011D, 0x00FD, 0x00FD, 0x00FD, 0x095D, 0x19FD, 0x223D, 0x227D, 0x229D, 0x2A9D, 0x2ABD, 0x2ABD, 0x2ADE, 0x32DD, 0x32FD, 0x3AFD, 0x3B1D, 0x3B1D, 0x3B1D, 0x433D, 0x4B5E, 0x4B5E, 0x535E, 0x5B7E, 0x533B, 0x3A94, 0x3B0D, 0x4389, 0x4BA9, 0x53C9, 
        0x53CA, 0x5BAB, 0x430A, 0x42EB, 0x434D, 0x4BAE, 0x540F, 0x5C70, 0x64D0, 0x6CF1, 0x7511, 0x7510, 0x74AE, 0x6C8C, 0x6C6B, 0x646A, 0x644A, 0x642A, 0x5C2A, 0x5C29, 0x5429, 0x5409, 0x5409, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 
        0x4C29, 0x4C29, 0x4C29, 0x5429, 0x5429, 0x5429, 0x4C09, 0x4C09, 0x4408, 0x43E9, 0x43E8, 0x43E8, 0x43E8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C08, 0x5409, 0x5409, 0x5C29, 0x5C29, 0x6449, 0x6469, 0x6469, 0x6469, 0x6469, 0x5C69, 0x5C69, 0x5C6A, 0x5C6A, 
        0x544A, 0x546A, 0x544A, 0x5449, 0x4C49, 0x4C29, 0x4C29, 0x4428, 0x4408, 0x3C08, 0x3BE8, 0x3BE7, 0x3BE7, 0x33E7, 0x33C7, 0x33C7, 0x33C6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BA6, 0x23A6, 0x2386, 0x1B86, 0x1B85, 0x1B65, 0x1B65, 0x1B45, 0x1B25, 0x1B04, 
        0x1B04, 0x1AC4, 0x1AC4, 0x1AA4, 0x1A84, 0x1AA4, 0x1AA4, 0x12A4, 0x12A4, 0x1AA5, 0x1AC5, 0x1AC5, 0x1AE6, 0x22E6, 0x2306, 0x2306, 0x2327, 0x2326, 0x2347, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B67, 0x2B67, 0x2B67, 0x2347,
  0x94EF, 0x94EE, 0x94CF, 0x8CAF, 0x848F, 0x84B0, 0x84B0, 0x84AF, 0x7C6F, 0x7C70, 0x84D3, 0x84D3, 0x7CB2, 0x748F, 0x746E, 0x748D, 0x748D, 0x748D, 0x748D, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x74CD, 0x74CD, 0x7CAD, 0x7CCE, 0x84EE, 0x8CEE, 0x8CEF, 
        0x84CE, 0x746D, 0x746D, 0x6C6D, 0x6C6D, 0x6C6D, 0x748D, 0x748D, 0x74AD, 0x7CAE, 0x84CE, 0x84CF, 0x84CE, 0x8CEE, 0x8D0E, 0x8D2F, 0x952F, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x9D50, 0xA550, 0xA551, 0xAD30, 0xA4F0, 0xA4AF, 0xA4B0, 0xA4B0, 0x9C70, 
        0x8C8F, 0x8CD0, 0x7CCF, 0x74AF, 0x7D30, 0x8550, 0x7D50, 0x7D30, 0x750F, 0x8571, 0x8591, 0x8D91, 0x8DB1, 0x8D91, 0x8571, 0x85B2, 0x8591, 0x8571, 0x8531, 0x74B0, 0x5C2D, 0x5C2D, 0x646E, 0x5C6D, 0x542D, 0x53ED, 0x4B8C, 0x432A, 0x4329, 0x4388, 
        0x4BC9, 0x5C6A, 0x74EC, 0x852D, 0x8D4D, 0x8D2D, 0x9D4D, 0xA54E, 0xAD6E, 0xAD8E, 0xB58E, 0xB58E, 0xB58E, 0xAD6E, 0xAD6E, 0xAD6F, 0xA56F, 0x9D2E, 0x84CD, 0x744C, 0x740B, 0x7C2C, 0x842D, 0x8C4D, 0x8BF0, 0x8356, 0x7B19, 0x82FC, 0x831C, 0x831D, 
        0x831D, 0x7B3D, 0x7B3D, 0x7B3C, 0x7B3C, 0x7B3C, 0x831D, 0x7B1D, 0x7B1D, 0x7B1D, 0x7B1D, 0x731D, 0x731D, 0x6B1D, 0x6B1D, 0x6AFD, 0x62FC, 0x62FC, 0x62FC, 0x5AFC, 0x5AFB, 0x5ADC, 0x5ADB, 0x5ADB, 0x5ADB, 0x5ABB, 0x52BA, 0x52BA, 0x529A, 0x529A, 
        0x529A, 0x527A, 0x5279, 0x5279, 0x4A59, 0x4A58, 0x4238, 0x4238, 0x4238, 0x41F8, 0x41D8, 0x41B8, 0x4199, 0x4199, 0x497A, 0x49BA, 0x59FB, 0x6A7C, 0x72FE, 0x7B3E, 0x7B3E, 0x835D, 0x837E, 0x839E, 0x839E, 0x837E, 0x837E, 0x7B7E, 0x7B5E, 0x6B1E, 
        0x527D, 0x41FC, 0x39BD, 0x399D, 0x399E, 0x31BD, 0x39BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x39BD, 0x39BD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x421D, 0x423D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x527D, 0x529D, 
        0x529D, 0x52BD, 0x52BD, 0x52DD, 0x52DD, 0x5ADD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5AFE, 0x631D, 0x631D, 0x631D, 0x631D, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 
        0x6B5D, 0x6B5D, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x635D, 0x6B5E, 0x635E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x637E, 0x637E, 0x637E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 
        0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B5E, 0x5B3E, 0x533E, 0x531E, 0x531E, 0x531E, 0x4B1E, 0x52FE, 0x4B1E, 0x4B1E, 0x4B1E, 0x4B1E, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADE, 0x4ADE, 0x42BE, 0x42BE, 0x42BE, 0x3A9E, 0x429D, 0x3A9D, 0x3A7D, 0x3A7D, 
        0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x421C, 0x5ABD, 0x739E, 0x73BE, 0x6B7E, 0x529E, 0x10FC, 0x00BC, 0x00FD, 0x00FD, 0x011D, 0x011D, 
        0x00FD, 0x00DD, 0x00FD, 0x00FC, 0x097D, 0x1A1E, 0x1A3D, 0x227D, 0x229D, 0x229D, 0x2ABD, 0x2ABD, 0x2ADE, 0x32DE, 0x32FE, 0x3B1E, 0x3B1E, 0x3B1D, 0x431E, 0x433D, 0x433D, 0x4B3E, 0x533E, 0x535D, 0x42B7, 0x32AE, 0x3B2B, 0x4389, 0x4BA9, 0x53A9, 
        0x53AA, 0x538A, 0x430A, 0x42EB, 0x434D, 0x43AE, 0x4C0F, 0x546F, 0x64B0, 0x6CF1, 0x7510, 0x74EF, 0x6C8D, 0x6C6B, 0x646A, 0x644A, 0x644A, 0x642A, 0x5C2A, 0x5C2A, 0x5429, 0x5429, 0x5409, 0x4C09, 0x4C09, 0x4C09, 0x5409, 0x4C09, 0x5409, 0x4C09, 
        0x4C09, 0x5429, 0x5429, 0x5429, 0x5429, 0x5409, 0x4C08, 0x4408, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x4C08, 0x4C08, 0x5409, 0x5429, 0x5C29, 0x5C29, 0x5C49, 0x6449, 0x646A, 0x646A, 0x646A, 0x646A, 0x648A, 0x5C6A, 0x5C6A, 
        0x5C6A, 0x5C6A, 0x5C6A, 0x5449, 0x5449, 0x5429, 0x4C29, 0x4C28, 0x4428, 0x4408, 0x3C08, 0x3C07, 0x3BE7, 0x3BE7, 0x33C7, 0x33E6, 0x33E6, 0x33C6, 0x33C6, 0x2BC6, 0x2BC6, 0x2BA6, 0x2BA6, 0x23A6, 0x23A5, 0x2385, 0x1B85, 0x1B65, 0x1B45, 0x1B24, 
        0x1B04, 0x1AE4, 0x1AC4, 0x1AA4, 0x1284, 0x1284, 0x1A84, 0x1AA5, 0x1AA5, 0x1AA5, 0x1AA5, 0x1AC5, 0x1AC6, 0x22C6, 0x22E6, 0x22E6, 0x2307, 0x2327, 0x2347, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2367, 0x2367, 0x2367,
  0x950F, 0x94EF, 0x8CCF, 0x8CB0, 0x8490, 0x8490, 0x84B0, 0x84CF, 0x7C8F, 0x84B0, 0x8CF3, 0x84D3, 0x7CB1, 0x746F, 0x746E, 0x6C8D, 0x6C6D, 0x6C8D, 0x748D, 0x748D, 0x748D, 0x748D, 0x74AC, 0x74AD, 0x74CD, 0x74CD, 0x7CCD, 0x7CCE, 0x84EE, 0x84CE, 0x84EF, 
        0x7CCE, 0x748D, 0x748D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x748D, 0x748D, 0x74AD, 0x7CCE, 0x84CE, 0x84CE, 0x8CEE, 0x8D0F, 0x8D2F, 0x952F, 0x8D2F, 0x954F, 0x954F, 0x954F, 0x9D50, 0xA550, 0xA551, 0xAD30, 0xA4F0, 0xA4CF, 0xA4B0, 0xA490, 0x9C70, 
        0x946F, 0x844E, 0x7C6E, 0x7CCF, 0x8510, 0x8531, 0x74EF, 0x750F, 0x8591, 0x8591, 0x8591, 0x8591, 0x8571, 0x7D50, 0x8591, 0x85B1, 0x8571, 0x8551, 0x74F0, 0x642D, 0x642D, 0x644D, 0x5C6D, 0x5C6D, 0x544C, 0x542D, 0x4BAC, 0x438B, 0x4B8A, 0x5C0B, 
        0x644B, 0x6CCC, 0x7D2D, 0x8D4D, 0x8D4D, 0x954D, 0x9D4E, 0xAD6E, 0xB58F, 0xB5AF, 0xBDAF, 0xB5AE, 0xB58E, 0xB56E, 0xB58F, 0xAD8F, 0xA56F, 0x950E, 0x7CAD, 0x6C2B, 0x6C0B, 0x740B, 0x840C, 0x8C4C, 0x8C2E, 0x8393, 0x8337, 0x82FB, 0x82FB, 0x7AFC, 
        0x7AFC, 0x7B1C, 0x7B1C, 0x7B1C, 0x7B1B, 0x7B1B, 0x82FC, 0x831D, 0x833D, 0x7B1D, 0x7B1D, 0x72FD, 0x731D, 0x6B1D, 0x6B1D, 0x6AFD, 0x62FD, 0x62FD, 0x62FD, 0x62FC, 0x5AFC, 0x5ADC, 0x5AFC, 0x5ADC, 0x52DC, 0x52BB, 0x52BB, 0x52BB, 0x529B, 0x529A, 
        0x529A, 0x529A, 0x527A, 0x5279, 0x4A59, 0x4A59, 0x4A39, 0x4238, 0x3A38, 0x4218, 0x39F8, 0x41D8, 0x41B8, 0x4199, 0x417A, 0x499A, 0x51BA, 0x51DB, 0x5A1C, 0x6A7D, 0x72DE, 0x7AFD, 0x7B3E, 0x7B3E, 0x7B5D, 0x7B7E, 0x7B7E, 0x837E, 0x7B7E, 0x7B7E, 
        0x735E, 0x62DE, 0x4A1D, 0x399D, 0x399E, 0x319D, 0x319D, 0x319D, 0x319D, 0x319D, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x39BD, 0x39DD, 0x39DD, 0x41DD, 0x41FD, 0x421D, 0x4A3D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x527D, 
        0x529D, 0x52BD, 0x52BD, 0x52DD, 0x5ADD, 0x52DD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5B1D, 0x5B1D, 0x5B1D, 0x631D, 0x631D, 0x633E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 
        0x6B5E, 0x6B5D, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6B9E, 0x6B9E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x5B7E, 0x637E, 
        0x635E, 0x5B5D, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B3E, 0x533E, 0x533E, 0x531E, 0x531E, 0x4B1E, 0x4B1D, 0x4B1E, 0x4B1E, 0x531E, 0x52FE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4ADE, 0x42DE, 0x42BE, 0x42BE, 0x42BE, 0x429D, 0x3A9D, 0x3A9D, 
        0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5E, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x31DD, 0x39DD, 0x421C, 0x5ADD, 0x6B7E, 0x6B7E, 0x52BE, 0x191C, 0x089C, 0x00DD, 0x00FD, 0x00FD, 0x00FD, 
        0x00FD, 0x00DD, 0x00DD, 0x011D, 0x119D, 0x1A1D, 0x1A3D, 0x227D, 0x227D, 0x229D, 0x229D, 0x2A9D, 0x2ABD, 0x32DE, 0x32DD, 0x3AFE, 0x3B1D, 0x3B1D, 0x431E, 0x431D, 0x431D, 0x4B1E, 0x533E, 0x4AFB, 0x2A32, 0x2AAC, 0x3B2A, 0x4369, 0x4B89, 0x4BA9, 
        0x53AA, 0x536A, 0x42EA, 0x42EB, 0x434D, 0x43AE, 0x4C0E, 0x546F, 0x64B0, 0x6CF1, 0x7510, 0x74EE, 0x6CAC, 0x6C6B, 0x646A, 0x644A, 0x644A, 0x642A, 0x5C2A, 0x5C29, 0x5429, 0x5429, 0x5409, 0x4C09, 0x4C0A, 0x4C0A, 0x5409, 0x5409, 0x5409, 0x5429, 
        0x5429, 0x5429, 0x5409, 0x5409, 0x4C09, 0x4C08, 0x4BE8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x3BE8, 0x43E8, 0x43E8, 0x43E8, 0x4C08, 0x4C08, 0x5429, 0x5429, 0x5C29, 0x5C49, 0x6449, 0x646A, 0x648A, 0x648A, 0x648A, 0x648A, 0x648A, 0x648A, 0x648A, 
        0x5C8A, 0x5C8A, 0x5C8A, 0x5C69, 0x5469, 0x5449, 0x5449, 0x4C49, 0x4C48, 0x4428, 0x4428, 0x3C08, 0x3C07, 0x3C07, 0x3BE7, 0x33E6, 0x33E6, 0x33E6, 0x33E6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x23A6, 0x23A6, 0x23A5, 0x2385, 0x2365, 0x1B65, 0x1B25, 
        0x1B04, 0x1AE4, 0x1AC4, 0x1AA4, 0x1284, 0x1284, 0x1A84, 0x1285, 0x1285, 0x1A85, 0x1AA5, 0x1AA5, 0x1AC6, 0x22C6, 0x22E6, 0x22E6, 0x2307, 0x2327, 0x2347, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B87, 0x2B67,
  0x94F0, 0x8CCF, 0x8CD0, 0x8490, 0x8471, 0x8491, 0x84B0, 0x84CF, 0x7C8F, 0x8CF2, 0x8D13, 0x7CD2, 0x7C90, 0x748E, 0x746D, 0x6C6D, 0x6C6D, 0x6C8D, 0x6C8D, 0x6C8D, 0x74AD, 0x6C8D, 0x74AD, 0x74AD, 0x74AD, 0x74CD, 0x7CCD, 0x7CCD, 0x84CE, 0x84CE, 0x84EF, 
        0x7CCE, 0x748D, 0x748D, 0x6C8D, 0x6C8D, 0x6C6D, 0x6C6D, 0x748D, 0x748D, 0x74AD, 0x7CCE, 0x84EE, 0x84EE, 0x8D0E, 0x952F, 0x952F, 0x954F, 0x954F, 0x954F, 0x954F, 0x9D70, 0x9D90, 0xA591, 0xA570, 0xA530, 0xA4F0, 0xA4D0, 0xA4B0, 0xA470, 0x9C4F, 
        0x9C70, 0x944F, 0x846F, 0x84AF, 0x8510, 0x74CF, 0x74EF, 0x8571, 0x8571, 0x8571, 0x8571, 0x8571, 0x750F, 0x7530, 0x8592, 0x85B2, 0x8571, 0x74F0, 0x5C2D, 0x5C2D, 0x642D, 0x5C4D, 0x5C6C, 0x546C, 0x544C, 0x4C2D, 0x4BCC, 0x4BAC, 0x5C0C, 0x6C6C, 
        0x74AC, 0x7CED, 0x852D, 0x8D4E, 0x954E, 0x9D6E, 0xA56E, 0xAD6E, 0xB58F, 0xBDAF, 0xBDAF, 0xBD8E, 0xB58E, 0xBD6E, 0xB56E, 0xB56F, 0xAD4E, 0x8CED, 0x7C6C, 0x6C2B, 0x6BEA, 0x73EB, 0x842C, 0x8C2C, 0x944D, 0x8BD0, 0x8374, 0x8317, 0x82F9, 0x7B19, 
        0x7B39, 0x8339, 0x8339, 0x8358, 0x8358, 0x8358, 0x833A, 0x82FC, 0x831D, 0x7B1E, 0x7B1E, 0x731D, 0x731D, 0x6B1D, 0x6B1D, 0x6B1D, 0x6B1D, 0x631D, 0x62FD, 0x62FD, 0x62FD, 0x5AFD, 0x5AFD, 0x52DC, 0x52DC, 0x52DC, 0x52BB, 0x52BB, 0x52BB, 0x529B, 
        0x529A, 0x529A, 0x527A, 0x525A, 0x5259, 0x4A59, 0x4239, 0x4238, 0x3A38, 0x3A18, 0x3A18, 0x39F8, 0x39D8, 0x3998, 0x4199, 0x499A, 0x499A, 0x51BB, 0x51BB, 0x59FC, 0x5A1C, 0x623C, 0x627D, 0x72BD, 0x731E, 0x733E, 0x7B5E, 0x7B7E, 0x7B7E, 0x7B9E, 
        0x7B7E, 0x735E, 0x6B3E, 0x5A9D, 0x41BC, 0x315D, 0x317D, 0x317D, 0x317D, 0x317D, 0x317D, 0x319D, 0x319D, 0x319D, 0x319D, 0x319D, 0x39BD, 0x39BD, 0x39BD, 0x39DD, 0x421D, 0x4A3D, 0x4A5D, 0x527D, 0x4A7D, 0x527E, 0x4A7D, 0x4A7D, 0x4A5D, 0x525D, 
        0x527D, 0x529D, 0x52BD, 0x52DD, 0x5ADD, 0x52BD, 0x5ADE, 0x5ADE, 0x5AFE, 0x5AFD, 0x5B1D, 0x631D, 0x631D, 0x631E, 0x631E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 
        0x6B5E, 0x6B5D, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B7D, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B7E, 0x637E, 0x637E, 0x637D, 0x637D, 0x637D, 0x637D, 
        0x637E, 0x5B7D, 0x5B7D, 0x5B7E, 0x5B5E, 0x635E, 0x635E, 0x5B5E, 0x5B5E, 0x5B5E, 0x533E, 0x533E, 0x533E, 0x531E, 0x4B1D, 0x4B1D, 0x4B1D, 0x52FE, 0x52FE, 0x52FE, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADD, 0x4ADD, 0x42BD, 0x42BE, 0x42BE, 0x429E, 0x429E, 
        0x429D, 0x3A9D, 0x3A7D, 0x3A7D, 0x3A5E, 0x3A5E, 0x3A3D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x39DD, 0x421C, 0x5AFE, 0x6B5E, 0x5B1F, 0x215C, 0x089C, 0x00BD, 0x00DD, 0x00DD, 0x00DD, 
        0x00DD, 0x00DD, 0x00DD, 0x013D, 0x11BD, 0x1A1E, 0x1A3D, 0x225D, 0x227D, 0x227D, 0x227D, 0x229D, 0x2ABD, 0x2ADD, 0x32DD, 0x3AFD, 0x3B1E, 0x3B1E, 0x431E, 0x431E, 0x431D, 0x4B3D, 0x533D, 0x3255, 0x2A2E, 0x32CA, 0x3B09, 0x3B48, 0x4369, 0x4B69, 
        0x538A, 0x534A, 0x42CA, 0x42EB, 0x434D, 0x43AE, 0x4C0E, 0x544F, 0x64B0, 0x6CF0, 0x7510, 0x74EE, 0x6CAC, 0x6C8B, 0x646A, 0x644A, 0x644A, 0x5C49, 0x5C49, 0x5C49, 0x5429, 0x5429, 0x5409, 0x4C0A, 0x540A, 0x542A, 0x540A, 0x5409, 0x5409, 0x5409, 
        0x5409, 0x5409, 0x4C09, 0x4C09, 0x4C09, 0x4BE8, 0x4BE8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x3BE8, 0x43E8, 0x43E8, 0x4BE8, 0x4BE8, 0x4C08, 0x5429, 0x5C29, 0x5C29, 0x6449, 0x6469, 0x646A, 0x648A, 0x648A, 0x6C8A, 0x6C8B, 0x6C8A, 0x648B, 0x648A, 
        0x64AA, 0x64AA, 0x648A, 0x5C8A, 0x5C69, 0x5469, 0x5469, 0x5449, 0x4C49, 0x4448, 0x4428, 0x4428, 0x4427, 0x3C07, 0x3C07, 0x3BE7, 0x3BE7, 0x33E6, 0x33E6, 0x33C6, 0x2BC6, 0x2BC6, 0x2BC6, 0x2BC6, 0x23A6, 0x2386, 0x2385, 0x2385, 0x2365, 0x2325, 
        0x1B04, 0x1AE5, 0x1AC4, 0x1AA4, 0x12A4, 0x1284, 0x1284, 0x1284, 0x1284, 0x1A85, 0x1AA5, 0x1AA5, 0x1AC6, 0x22E6, 0x22E6, 0x22E6, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B68, 0x2368,
  0x94F0, 0x8CD0, 0x84B0, 0x8491, 0x8452, 0x8491, 0x84B0, 0x7CAF, 0x7CAF, 0x8D12, 0x8D13, 0x7CD2, 0x7CAF, 0x748E, 0x746D, 0x6C8D, 0x6C6D, 0x6C8D, 0x6C8D, 0x6C8D, 0x74AD, 0x6CAD, 0x74AD, 0x74AD, 0x74AD, 0x74CD, 0x7CED, 0x7CEE, 0x84CE, 0x84CE, 0x84EF, 
        0x7CCE, 0x748D, 0x748D, 0x748D, 0x6C8D, 0x6C6D, 0x6C6D, 0x6C8D, 0x748D, 0x748D, 0x7CCE, 0x84CE, 0x84EE, 0x8D0F, 0x954F, 0x954F, 0x954F, 0x954F, 0x954F, 0x9D70, 0xA590, 0xA591, 0xA591, 0xA570, 0xA510, 0xA4EF, 0xA4CF, 0xA4AF, 0x9C6F, 0x9C2F, 
        0xA470, 0x9C70, 0x946F, 0x848F, 0x748E, 0x8510, 0x8551, 0x8571, 0x8571, 0x8571, 0x8570, 0x7D30, 0x74EF, 0x8571, 0x8572, 0x7D51, 0x74F0, 0x5C0D, 0x644E, 0x644D, 0x5C2D, 0x5C4C, 0x546C, 0x546C, 0x4C6C, 0x4C2C, 0x4BEC, 0x53AC, 0x640C, 0x74AD, 
        0x7CED, 0x850D, 0x8D4D, 0x956E, 0x9D6E, 0x9D6E, 0xA56E, 0xB56E, 0xB58F, 0xBDAF, 0xBDAF, 0xBD8E, 0xB56E, 0xBD6E, 0xB56E, 0xB54E, 0xA50E, 0x8CAD, 0x7C6C, 0x6C2B, 0x63EA, 0x73EB, 0x842C, 0x8C4C, 0x944D, 0x942E, 0x8BF0, 0x8BB2, 0x8374, 0x8395, 
        0x8395, 0x8BB4, 0x8BD4, 0x8BD3, 0x8BD3, 0x8BD4, 0x8376, 0x82FB, 0x7AFD, 0x7B1E, 0x7B1E, 0x731E, 0x731D, 0x731E, 0x6B1E, 0x6B1E, 0x6B1D, 0x631D, 0x62FD, 0x62FD, 0x62FD, 0x5AFD, 0x5AFD, 0x52FC, 0x52DC, 0x52DC, 0x52DC, 0x52BB, 0x52BB, 0x52BB, 
        0x529B, 0x529A, 0x527A, 0x527A, 0x4A59, 0x4A59, 0x4239, 0x4238, 0x3A38, 0x3A18, 0x3A18, 0x39F8, 0x39F8, 0x39D8, 0x4199, 0x4199, 0x499A, 0x51BB, 0x51BB, 0x51DC, 0x51DC, 0x51DC, 0x51DC, 0x51FC, 0x5A1C, 0x629D, 0x6ADD, 0x733E, 0x7B5E, 0x7B7E, 
        0x7B7E, 0x7B7E, 0x737E, 0x735E, 0x62DE, 0x4A1E, 0x397C, 0x315D, 0x315D, 0x297D, 0x295D, 0x317D, 0x297D, 0x315D, 0x315D, 0x317D, 0x317D, 0x319D, 0x399D, 0x39BD, 0x41FD, 0x421D, 0x4A5D, 0x4A7E, 0x529E, 0x4A9E, 0x529E, 0x4A9D, 0x4A7D, 0x525D, 
        0x527D, 0x527D, 0x52BD, 0x52BD, 0x52DD, 0x52BD, 0x5ADD, 0x5ADE, 0x5AFE, 0x5AFD, 0x5B1D, 0x631E, 0x631E, 0x631E, 0x631E, 0x633E, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 
        0x6B5E, 0x6B5D, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6BBE, 0x73BE, 0x6BBE, 0x6B9E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 
        0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x5B5E, 0x5B5E, 0x5B5E, 0x5B3E, 0x533E, 0x533E, 0x531D, 0x531D, 0x4B1D, 0x52FE, 0x52FE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4ADE, 0x4ADE, 0x4ADE, 0x42BD, 0x42BE, 0x42BE, 0x42BE, 0x429D, 
        0x429E, 0x429D, 0x3A7D, 0x3A7E, 0x3A5E, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x321D, 0x29FD, 0x31FD, 0x29FD, 0x29FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x39DD, 0x421C, 0x5ADE, 0x5B3E, 0x3A1E, 0x08BC, 0x009D, 0x00DD, 0x00DD, 0x00DD, 
        0x00DD, 0x00DD, 0x00DD, 0x013D, 0x11BD, 0x1A1D, 0x1A3D, 0x1A5D, 0x1A5D, 0x225D, 0x227D, 0x229D, 0x2ABD, 0x2ABD, 0x32DD, 0x3ADD, 0x3AFE, 0x3AFD, 0x42FE, 0x431E, 0x4B1D, 0x4B3D, 0x4299, 0x29D0, 0x2A4C, 0x2AA9, 0x32E8, 0x3B28, 0x4348, 0x4B69, 
        0x536A, 0x4B2A, 0x42AA, 0x42EC, 0x432D, 0x43AE, 0x4C0F, 0x544F, 0x64B0, 0x6CF0, 0x7510, 0x74EE, 0x6CAC, 0x6C8A, 0x648A, 0x646A, 0x644A, 0x5C49, 0x5C49, 0x5C49, 0x5429, 0x5429, 0x540A, 0x540A, 0x5C4C, 0x5C4C, 0x542A, 0x5409, 0x5409, 0x5409, 
        0x5409, 0x5409, 0x4C09, 0x4C09, 0x4BE8, 0x4BE8, 0x4BE8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x4BE8, 0x4C08, 0x5409, 0x5429, 0x5C29, 0x5C29, 0x6449, 0x6469, 0x646A, 0x648A, 0x6C8A, 0x6C8A, 0x6C8B, 0x6CAB, 0x6CAB, 0x6CAB, 
        0x6CAB, 0x6CAB, 0x64AA, 0x64AA, 0x648A, 0x5C8A, 0x5C69, 0x5469, 0x5449, 0x4C49, 0x4C49, 0x4448, 0x4448, 0x4428, 0x4427, 0x3C07, 0x3BE7, 0x33E6, 0x33E6, 0x33C6, 0x2BC6, 0x2BC5, 0x2BC6, 0x2BC6, 0x23A6, 0x23A6, 0x2386, 0x2385, 0x2365, 0x2345, 
        0x2325, 0x1AE5, 0x1AC4, 0x1AA4, 0x12A4, 0x1284, 0x1284, 0x1284, 0x1284, 0x1285, 0x1AA5, 0x1AA5, 0x1AC6, 0x22C6, 0x22E6, 0x22E6, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2B68, 0x2368,
  0x94D1, 0x8CB1, 0x8491, 0x8472, 0x8472, 0x8490, 0x7CAF, 0x7CAE, 0x7CD0, 0x8D13, 0x8D13, 0x7CD1, 0x7CAF, 0x748E, 0x748D, 0x6C8D, 0x6C6D, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CCD, 0x6CCE, 0x6CCE, 0x6CCD, 0x6CCD, 0x74AD, 0x74ED, 0x850E, 0x84EE, 0x84CE, 0x84CF, 
        0x7CAE, 0x748D, 0x748D, 0x748D, 0x6C8D, 0x6C6D, 0x6C8D, 0x6C8D, 0x748D, 0x74AD, 0x7CAE, 0x84CE, 0x84EF, 0x8D2F, 0x952F, 0x954F, 0x954F, 0x956F, 0x9570, 0x9D70, 0x9D70, 0x9D70, 0x9D50, 0x9D2F, 0x9D0F, 0x9CEF, 0x9CCF, 0x9CAF, 0x9C8F, 0x9C6F, 
        0xA470, 0x9C90, 0x948F, 0x84AF, 0x8D31, 0x8551, 0x8550, 0x8570, 0x7D50, 0x7D2F, 0x752F, 0x752F, 0x7D71, 0x8571, 0x7D30, 0x74D0, 0x53ED, 0x5C0D, 0x644E, 0x5C2D, 0x5C2D, 0x544C, 0x544C, 0x546C, 0x4C4C, 0x4C0C, 0x4BCC, 0x53AB, 0x640C, 0x7CAD, 
        0x84ED, 0x8D2E, 0x954E, 0x9D6E, 0x9D6E, 0xA56E, 0xAD6F, 0xB56F, 0xB58F, 0xBD8F, 0xBD8F, 0xB56E, 0xB54E, 0xB54E, 0xB54E, 0xAD2D, 0x94CD, 0x84AC, 0x744B, 0x640B, 0x63EA, 0x6BEB, 0x842C, 0x946C, 0x948C, 0x948C, 0x944E, 0x8C2F, 0x8C2F, 0x9430, 
        0x9430, 0x944F, 0x944F, 0x946E, 0x946E, 0x942F, 0x93D3, 0x8B57, 0x831A, 0x831C, 0x831D, 0x7B1E, 0x731E, 0x731E, 0x731E, 0x6B1E, 0x6B1E, 0x6B1D, 0x631D, 0x62FE, 0x62FD, 0x62FE, 0x5AFD, 0x5AFD, 0x5ADC, 0x5ADC, 0x5ADC, 0x52DC, 0x52DC, 0x52BB, 
        0x52BB, 0x529B, 0x4A9A, 0x4A7A, 0x4A7A, 0x4A59, 0x4259, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x39B8, 0x4199, 0x49BA, 0x49BA, 0x49BB, 0x51DB, 0x51DC, 0x51DC, 0x51DC, 0x51BD, 0x51DD, 0x51FD, 0x59FD, 0x625D, 0x6AFE, 0x733E, 
        0x735E, 0x737E, 0x737E, 0x735E, 0x6B3E, 0x6B3E, 0x5A9E, 0x41FD, 0x315C, 0x315D, 0x295D, 0x313D, 0x295D, 0x295D, 0x295D, 0x317D, 0x317D, 0x317D, 0x319D, 0x399D, 0x39DD, 0x41FD, 0x4A3D, 0x4A5D, 0x4A7E, 0x527E, 0x529D, 0x529D, 0x529E, 0x529D, 
        0x4A7D, 0x4A5D, 0x527D, 0x529E, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x5ADE, 0x5AFE, 0x5AFD, 0x631E, 0x631E, 0x631D, 0x633D, 0x633E, 0x633E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 
        0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x737E, 0x737E, 0x737E, 0x737E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x639E, 0x639E, 0x639E, 
        0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x637E, 0x637E, 0x637E, 0x5B7E, 0x5B5E, 0x5B5E, 0x5B5E, 0x533E, 0x533E, 0x533E, 0x531E, 0x531E, 0x531E, 0x4B1E, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x4ADD, 0x42DE, 0x42BE, 0x42BE, 0x42BE, 0x429D, 
        0x429D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x29FD, 0x29DD, 0x29FD, 0x29DD, 0x31DD, 0x29DD, 0x31DD, 0x31DD, 0x39DD, 0x421C, 0x52FD, 0x531F, 0x193C, 0x089C, 0x00BD, 0x00BD, 0x00BD, 
        0x00DD, 0x00DD, 0x00FD, 0x095D, 0x11BD, 0x1A1E, 0x1A3D, 0x1A3D, 0x1A5D, 0x1A5D, 0x227D, 0x227D, 0x229D, 0x2ABD, 0x32BD, 0x32DD, 0x3ADD, 0x3AFE, 0x3AFE, 0x42FE, 0x4B1D, 0x4ADC, 0x21B3, 0x21CC, 0x2A4A, 0x2A88, 0x32E8, 0x3B28, 0x4348, 0x4B69, 
        0x5349, 0x4B0A, 0x428A, 0x42EC, 0x434D, 0x43AE, 0x4C0F, 0x5C6F, 0x64B0, 0x6CF0, 0x7510, 0x6CED, 0x6CCC, 0x6CAB, 0x6C8A, 0x648A, 0x646A, 0x5C69, 0x5C49, 0x5C49, 0x542A, 0x540A, 0x4BEA, 0x4BEB, 0x5C2D, 0x5C6D, 0x5C4B, 0x540A, 0x5409, 0x5409, 
        0x5409, 0x5409, 0x4BE9, 0x53E9, 0x4BE8, 0x4BE8, 0x4BE8, 0x43E8, 0x43E8, 0x43E8, 0x3BE8, 0x43E8, 0x43E8, 0x43E8, 0x4408, 0x4C08, 0x4C08, 0x5428, 0x5C29, 0x5C29, 0x5C49, 0x646A, 0x646A, 0x6C8A, 0x6CAA, 0x6CAB, 0x6CAB, 0x6CAB, 0x74AB, 0x6CAB, 
        0x6CAB, 0x6CAB, 0x6CAB, 0x64AA, 0x648A, 0x648A, 0x5C8A, 0x5C6A, 0x5469, 0x5469, 0x4C49, 0x4C49, 0x4448, 0x4428, 0x4428, 0x3C08, 0x3BE7, 0x33E7, 0x33E6, 0x33E6, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BA5, 0x23A6, 0x23A6, 0x23A5, 0x2385, 0x2365, 
        0x2325, 0x1B05, 0x1AE4, 0x12C4, 0x12A4, 0x1264, 0x1264, 0x1265, 0x1265, 0x1A65, 0x1A85, 0x1A86, 0x1AA6, 0x22C6, 0x22C6, 0x22C6, 0x2AE7, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B68, 0x2B87, 0x2B87, 0x2B67, 0x2367,
  0x8CD1, 0x8CB2, 0x8492, 0x8473, 0x8472, 0x8490, 0x7CAF, 0x7CAE, 0x84F0, 0x8D33, 0x8512, 0x7CD1, 0x7CAF, 0x74AE, 0x74AD, 0x748D, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CCE, 0x6CCE, 0x6CCD, 0x6CAD, 0x6CAD, 0x74CD, 0x850E, 0x84EE, 0x84CE, 0x84CF, 
        0x7CAE, 0x748D, 0x748D, 0x746D, 0x6C6D, 0x6C6D, 0x6C8D, 0x6C8D, 0x6C8D, 0x748E, 0x7CAE, 0x7CCE, 0x84EF, 0x952F, 0x954F, 0x954F, 0x954F, 0x954F, 0x954F, 0x954F, 0x952F, 0x952F, 0x952F, 0x950F, 0x9D0F, 0x9CEF, 0xA4EF, 0xA4CF, 0xA4AF, 0xA48F, 
        0xA48F, 0xA490, 0x9C90, 0x8CD0, 0x8D31, 0x8551, 0x8571, 0x7D2F, 0x750E, 0x752F, 0x7D70, 0x7D71, 0x7D71, 0x7D51, 0x6CCF, 0x5BED, 0x5BCD, 0x642F, 0x642E, 0x5C0D, 0x540C, 0x540C, 0x542C, 0x544C, 0x4C2C, 0x4C0C, 0x4BAC, 0x538B, 0x63EC, 0x7C6D, 
        0x8CCE, 0x8D0E, 0x954E, 0x9D4E, 0x9D4E, 0xA56F, 0xAD6F, 0xAD6F, 0xB56F, 0xB58E, 0xB58E, 0xB56E, 0xAD4D, 0xAD2D, 0xAD2D, 0xA50D, 0x8CAC, 0x7C8B, 0x644A, 0x5C0A, 0x5BEA, 0x6BEB, 0x846C, 0x946C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948D, 0x946D, 
        0x948D, 0x948D, 0x948D, 0x9C8E, 0x9C8E, 0x9C8E, 0x9C50, 0x93F4, 0x8B97, 0x833A, 0x831C, 0x7B1D, 0x731E, 0x731E, 0x731E, 0x733E, 0x733E, 0x6B1E, 0x6B1E, 0x62FE, 0x62FE, 0x62FE, 0x5AFD, 0x5AFD, 0x5ADD, 0x5ADD, 0x5ABC, 0x5ADC, 0x52DC, 0x52BC, 
        0x52BB, 0x4A9B, 0x4A9B, 0x4A7A, 0x4A7A, 0x4A7A, 0x4259, 0x3A59, 0x3A39, 0x3A38, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x39D8, 0x3998, 0x4199, 0x41BA, 0x49BB, 0x49DB, 0x51DC, 0x51DD, 0x49DD, 0x49DD, 0x51DD, 0x51DD, 0x51DD, 0x51DD, 0x5A1D, 0x62BD, 
        0x6B1E, 0x733E, 0x735E, 0x735E, 0x735E, 0x6B5E, 0x6B3E, 0x631F, 0x5A9E, 0x39BD, 0x293D, 0x293D, 0x293D, 0x293D, 0x293D, 0x295D, 0x315D, 0x295D, 0x317D, 0x319D, 0x39BD, 0x39DD, 0x421D, 0x423D, 0x4A5D, 0x4A7D, 0x529D, 0x529D, 0x529D, 0x529E, 
        0x527D, 0x4A5D, 0x525D, 0x529D, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x631E, 0x631D, 0x633D, 0x633E, 0x633E, 0x633E, 0x635E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7D, 
        0x6B7D, 0x6B7D, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 0x737E, 0x737E, 0x6B5E, 0x6B7E, 0x6B5E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6BBE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x6B9E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6BBE, 
        0x6BBE, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x5B7E, 0x5B7E, 0x5B7E, 0x5B5E, 0x5B5E, 0x533E, 0x533E, 0x531E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FD, 0x4AFD, 0x4AFD, 0x4ADE, 0x42DE, 0x42BE, 0x42BE, 0x42BD, 0x429D, 
        0x3A9D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x2A1D, 0x29FD, 0x29FD, 0x29FD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x31DD, 0x31BD, 0x31BD, 0x39DD, 0x421C, 0x52DE, 0x3A5E, 0x08BC, 0x009C, 0x00BD, 0x00BD, 
        0x00BD, 0x00BD, 0x00FD, 0x095D, 0x11DD, 0x1A1D, 0x1A3D, 0x1A3D, 0x1A3D, 0x1A5D, 0x225D, 0x227D, 0x229D, 0x2A9D, 0x2ABD, 0x32BD, 0x3ADD, 0x3ADD, 0x3AFE, 0x42FE, 0x4B1D, 0x3216, 0x218E, 0x21EA, 0x2A48, 0x2A88, 0x32C7, 0x3B08, 0x3B48, 0x4B49, 
        0x5349, 0x4AEA, 0x428A, 0x42EC, 0x432D, 0x43AE, 0x4C0F, 0x5C70, 0x64B0, 0x6CF0, 0x750F, 0x6D0D, 0x6CCC, 0x6C8B, 0x648A, 0x648A, 0x646A, 0x5C6A, 0x5C6A, 0x5449, 0x542A, 0x4C0A, 0x4BEA, 0x4BCC, 0x540D, 0x5C2E, 0x5C4C, 0x540A, 0x5409, 0x4BE9, 
        0x53E9, 0x5409, 0x4BE9, 0x53E9, 0x4BE8, 0x4BC8, 0x43C8, 0x43C8, 0x43E8, 0x43E8, 0x3BE8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x4C08, 0x4C08, 0x5428, 0x5C29, 0x5C49, 0x6469, 0x646A, 0x646A, 0x6C8A, 0x6CAA, 0x6CAB, 0x74AB, 0x74AB, 0x74CB, 0x74CB, 
        0x74CB, 0x74CB, 0x6CCB, 0x6CAB, 0x64AA, 0x648A, 0x648A, 0x5C8A, 0x5C6A, 0x5469, 0x5469, 0x4C69, 0x4C49, 0x4448, 0x4428, 0x3C08, 0x3BE7, 0x3BE7, 0x33E7, 0x33E6, 0x33E6, 0x2BC5, 0x2BC5, 0x2BC6, 0x2BA5, 0x23A6, 0x23A6, 0x23A5, 0x2385, 0x2365, 
        0x2325, 0x1B05, 0x1AE4, 0x12C4, 0x12A4, 0x1264, 0x1264, 0x1265, 0x1265, 0x1265, 0x1A85, 0x1A86, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C7, 0x22E7, 0x2B07, 0x2B27, 0x2B47, 0x2B47, 0x2B67, 0x2B67, 0x2B67, 0x2B67, 0x2367, 0x2367, 0x2367,
  0x84B1, 0x84B2, 0x8492, 0x8473, 0x8492, 0x7CB0, 0x7CAE, 0x74AE, 0x8511, 0x8D33, 0x8512, 0x7CD0, 0x7CAE, 0x7CAE, 0x74AD, 0x74AD, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x64AD, 0x6CAD, 0x6CAC, 0x74CD, 0x850E, 0x84EE, 0x84CE, 0x84CF, 
        0x7CAE, 0x746D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x748E, 0x74AE, 0x84EE, 0x8D2F, 0x9570, 0x954F, 0x954F, 0x952F, 0x8D2F, 0x954F, 0x952F, 0x952F, 0x952F, 0x952F, 0x9D2F, 0x9D0F, 0x9D0F, 0x9CEF, 0x9CCF, 0xA4B0, 0xA48F, 
        0xA48F, 0xA490, 0x9CB0, 0x8CD0, 0x8D31, 0x7D30, 0x750F, 0x750F, 0x7D50, 0x7D70, 0x7D70, 0x7550, 0x7D30, 0x7510, 0x6C8F, 0x5BEE, 0x6C2F, 0x640F, 0x63EE, 0x5BEE, 0x53CD, 0x53CD, 0x53ED, 0x53ED, 0x53ED, 0x4BAC, 0x4B6C, 0x536C, 0x63CC, 0x742C, 
        0x848D, 0x8CAD, 0x94EE, 0x9D0E, 0x9D2E, 0x9D4F, 0xA54F, 0xA56F, 0xAD4F, 0xAD6F, 0xAD4E, 0xAD2E, 0xAD2D, 0xAD0D, 0xA50D, 0x94CC, 0x848B, 0x746B, 0x5C2A, 0x5BEA, 0x5BEA, 0x6C0B, 0x844C, 0x946C, 0x94AC, 0x94AC, 0x948C, 0x94AC, 0x94AC, 0x9CAC, 
        0x9CAC, 0x9CCD, 0xA4CD, 0xA4ED, 0xA4EE, 0xA4CE, 0xA4CF, 0x9C91, 0x9C33, 0x8BB7, 0x833A, 0x72FC, 0x72FD, 0x731E, 0x733E, 0x733E, 0x733E, 0x6B1E, 0x6B1E, 0x6AFE, 0x6AFE, 0x62FE, 0x62FD, 0x5AFD, 0x5ADD, 0x5ADD, 0x5ADD, 0x52DC, 0x52BC, 0x52BC, 
        0x4ABC, 0x4ABB, 0x4A9B, 0x4A9A, 0x427A, 0x427A, 0x4279, 0x3A59, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x39B8, 0x4199, 0x419A, 0x41BB, 0x49BB, 0x49DC, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x51FD, 
        0x5A5D, 0x62BE, 0x6B1E, 0x733E, 0x735E, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B3E, 0x631E, 0x4A5E, 0x315C, 0x291C, 0x291D, 0x293D, 0x293D, 0x293D, 0x295D, 0x315D, 0x317D, 0x319D, 0x31BD, 0x39FD, 0x421D, 0x4A3D, 0x4A7D, 0x527D, 0x529D, 0x529D, 0x529E, 
        0x529E, 0x4A7D, 0x4A5D, 0x527D, 0x529E, 0x52BE, 0x52BE, 0x52BD, 0x5ABD, 0x5AFD, 0x5AFD, 0x5AFE, 0x5AFD, 0x631E, 0x633D, 0x633E, 0x633E, 0x633E, 0x635E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 0x6B9E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 
        0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 0x737E, 0x737E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 
        0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x637E, 0x639D, 0x639D, 0x5B7E, 0x5B7E, 0x5B5E, 0x533E, 0x533E, 0x531E, 0x533E, 0x531E, 0x531E, 0x531E, 0x52FE, 0x52FE, 0x4AFD, 0x4AFE, 0x42DE, 0x42BE, 0x42BE, 0x42BD, 0x3A9D, 
        0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x29FD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x29BD, 0x29BD, 0x29BD, 0x31BD, 0x31BD, 0x31BD, 0x3A1D, 0x4ABE, 0x29BD, 0x009C, 0x009D, 0x009D, 
        0x009D, 0x00BD, 0x00FD, 0x097D, 0x11DD, 0x19FD, 0x1A1D, 0x1A3D, 0x1A3D, 0x1A5D, 0x1A5D, 0x227E, 0x227D, 0x2A9D, 0x2ABD, 0x32BD, 0x3ADD, 0x3ADD, 0x3ADD, 0x42FE, 0x3A9B, 0x1990, 0x21AB, 0x2209, 0x2A28, 0x2A68, 0x32A7, 0x32E8, 0x3B28, 0x4B29, 
        0x4B4A, 0x4AEA, 0x428B, 0x42EC, 0x434D, 0x43AE, 0x4C0F, 0x5C70, 0x6CD0, 0x6CF0, 0x74EF, 0x74ED, 0x6CAC, 0x6C8B, 0x6C8B, 0x648A, 0x646A, 0x646A, 0x5C6A, 0x544A, 0x542A, 0x4C0A, 0x4BEB, 0x4BAD, 0x4BCE, 0x4BCD, 0x53EC, 0x5C2C, 0x4BE9, 0x4BE9, 
        0x53EA, 0x4BE9, 0x4BE9, 0x53C9, 0x4BE8, 0x4BE8, 0x43C8, 0x43C8, 0x43E8, 0x3BC7, 0x3BC7, 0x3BE8, 0x3BE8, 0x43E8, 0x43E8, 0x4BE8, 0x4C08, 0x5428, 0x5C29, 0x5C29, 0x5C49, 0x646A, 0x648A, 0x6C8A, 0x6CAA, 0x74AB, 0x74AB, 0x74CB, 0x74CB, 0x74CB, 
        0x74CB, 0x74CB, 0x74CB, 0x6CCB, 0x6CAB, 0x6CAB, 0x64AA, 0x648A, 0x5C8A, 0x5C6A, 0x5469, 0x5469, 0x4C69, 0x4C49, 0x4428, 0x4408, 0x3BE8, 0x3BE7, 0x3BC7, 0x33E6, 0x33C6, 0x2BC6, 0x2BC5, 0x2BA5, 0x2BA5, 0x2BA5, 0x2BA5, 0x23A5, 0x2385, 0x2365, 
        0x2345, 0x2325, 0x1AE4, 0x1AC4, 0x12A4, 0x1284, 0x1264, 0x1264, 0x1265, 0x1A45, 0x1A65, 0x1A86, 0x2286, 0x22A6, 0x22A6, 0x22A6, 0x22C7, 0x22C7, 0x22E7, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x2B47, 0x2B67, 0x2367, 0x2367, 0x2367, 0x2367,
  0x7C90, 0x7C92, 0x7C73, 0x7C73, 0x7C92, 0x7CAF, 0x7CAE, 0x7CAF, 0x8D32, 0x8D53, 0x8511, 0x7CD0, 0x7CCE, 0x7CCE, 0x7CAD, 0x74AD, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x64AD, 0x648D, 0x648D, 0x648D, 0x6C8C, 0x6CAD, 0x7CEE, 0x84CE, 0x84AE, 0x84AF, 
        0x7C8E, 0x744D, 0x6C4D, 0x6C4C, 0x644C, 0x644D, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C8D, 0x74AE, 0x84EF, 0x9570, 0x9570, 0x954F, 0x8D2F, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x954F, 0x954F, 0x9D50, 0x952F, 0x9D10, 0x9D10, 0x9CEF, 0x9CCF, 0x9CB0, 0xA48F, 
        0x9C6F, 0x9C8F, 0x9CB0, 0x84D0, 0x7CD0, 0x74CF, 0x750F, 0x752F, 0x7D50, 0x7D70, 0x7D50, 0x7530, 0x750F, 0x6CCF, 0x6C8F, 0x6C50, 0x63EF, 0x5BAE, 0x538D, 0x53AD, 0x53AE, 0x53AE, 0x53AE, 0x53AD, 0x538D, 0x536D, 0x534D, 0x5B4C, 0x636C, 0x6BCC, 
        0x7BEC, 0x7C2C, 0x846D, 0x8CAD, 0x94EE, 0x950E, 0x9D2F, 0xA54F, 0xA54F, 0xAD4F, 0xA52E, 0xA50E, 0xA4ED, 0xA4EC, 0x9CEC, 0x8CAC, 0x7C6B, 0x6C4A, 0x5C0A, 0x53EA, 0x53EA, 0x6C0B, 0x844C, 0x946C, 0x9CAC, 0x94AC, 0x9CAC, 0x94AC, 0x94AC, 0x9CAC, 
        0x9CCC, 0xA4ED, 0xA50E, 0xAD0E, 0xAD0E, 0xAD0F, 0xACEF, 0xA4CF, 0xA4B1, 0x9C34, 0x83B7, 0x7B19, 0x6ADB, 0x72FD, 0x731E, 0x733E, 0x733E, 0x731E, 0x6B1E, 0x6AFE, 0x6AFE, 0x62FE, 0x62FD, 0x5AFD, 0x5AFD, 0x5ADD, 0x52DD, 0x52DC, 0x52BC, 0x52BC, 
        0x4ABC, 0x4ABB, 0x4A9B, 0x4A9B, 0x4A9A, 0x427A, 0x427A, 0x3A59, 0x3A39, 0x3A19, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x41D9, 0x41B9, 0x41BA, 0x41BA, 0x49DB, 0x49DC, 0x49DC, 0x49DC, 0x49DD, 0x49FD, 0x49FD, 0x49FD, 0x51DD, 0x49DD, 0x49BD, 
        0x49DD, 0x51FD, 0x5A7D, 0x6ADE, 0x6B1E, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B5D, 0x6B3E, 0x633E, 0x5ABE, 0x41DD, 0x293C, 0x291D, 0x293D, 0x293D, 0x293D, 0x295D, 0x295D, 0x317D, 0x319D, 0x39DD, 0x421D, 0x423D, 0x4A5D, 0x4A7D, 0x529D, 0x529D, 0x52BE, 
        0x529E, 0x529D, 0x4A5D, 0x4A5D, 0x529E, 0x52BE, 0x52BE, 0x52BE, 0x5ABD, 0x52DD, 0x52FD, 0x5AFE, 0x5B1E, 0x5B1E, 0x633D, 0x633E, 0x633E, 0x633E, 0x635E, 0x6B5D, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 
        0x739E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x6BBE, 0x73BE, 0x6BBE, 0x6BBE, 0x73BE, 0x73BE, 0x73DE, 0x73BE, 
        0x6BBE, 0x6B9E, 0x6BBE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x639D, 0x639E, 0x5B9E, 0x5B7E, 0x5B5E, 0x5B5D, 0x533D, 0x533E, 0x5B3E, 0x533E, 0x533E, 0x531E, 0x531E, 0x52FE, 0x4AFE, 0x4AFE, 0x4ADD, 0x42BE, 0x42BE, 0x42BD, 0x3A9D, 
        0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x29DD, 0x29DD, 0x21DD, 0x29DD, 0x29DD, 0x21BD, 0x21BD, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 0x319D, 0x31BD, 0x3A5D, 0x4AFF, 0x191C, 0x009D, 0x009D, 
        0x009D, 0x00BC, 0x00FC, 0x119D, 0x11DD, 0x19FD, 0x1A1D, 0x1A3D, 0x1A3D, 0x1A3D, 0x1A5D, 0x225D, 0x227D, 0x2A7D, 0x2A9D, 0x3ABE, 0x3ABE, 0x3ABD, 0x42DD, 0x4AFD, 0x29D6, 0x196D, 0x19A9, 0x21C8, 0x21E7, 0x2247, 0x2A88, 0x32C8, 0x3B08, 0x4B49, 
        0x4B4A, 0x4AEA, 0x428B, 0x42CC, 0x434E, 0x4BAF, 0x5410, 0x6490, 0x6CD1, 0x74F0, 0x74EF, 0x74CD, 0x6CAC, 0x6C8B, 0x6C8B, 0x648B, 0x646A, 0x646A, 0x5C6A, 0x544A, 0x542A, 0x4C0A, 0x4BEC, 0x4BEE, 0x540F, 0x4C0E, 0x4BED, 0x540C, 0x53EB, 0x4BEA, 
        0x53EA, 0x4BEA, 0x4BE9, 0x53C9, 0x4BC9, 0x4BC8, 0x43C8, 0x43C8, 0x43C8, 0x3BC7, 0x3BC7, 0x3BE8, 0x3BE8, 0x43E8, 0x43E8, 0x43E8, 0x4C08, 0x5428, 0x5428, 0x5C49, 0x6469, 0x646A, 0x648A, 0x6C8A, 0x6CAB, 0x74AB, 0x74AB, 0x74AB, 0x74CB, 0x74CB, 
        0x74CB, 0x74CB, 0x74CB, 0x74CB, 0x6CCB, 0x6CCB, 0x6CAB, 0x64AA, 0x648A, 0x5C8A, 0x5C8A, 0x5469, 0x4C69, 0x4C49, 0x4428, 0x4408, 0x4408, 0x3C07, 0x3BE7, 0x33E6, 0x33C6, 0x2BC6, 0x2BC6, 0x2BA5, 0x2BA5, 0x2BA5, 0x2BA5, 0x23A5, 0x2385, 0x2365, 
        0x2345, 0x2325, 0x1AE4, 0x1AC4, 0x12A4, 0x1284, 0x1264, 0x1264, 0x1265, 0x1A45, 0x1A45, 0x1A65, 0x1A86, 0x2286, 0x2286, 0x22A6, 0x22A7, 0x22C7, 0x22E7, 0x2AE7, 0x2B07, 0x2B27, 0x2B27, 0x2B47, 0x2B47, 0x2367, 0x2367, 0x2367, 0x2367,
  0x7470, 0x7C72, 0x7C72, 0x7C72, 0x7C91, 0x74AF, 0x7CAF, 0x7CD0, 0x8D52, 0x8D53, 0x8511, 0x7CCF, 0x7CCE, 0x7CCE, 0x7CCD, 0x74CD, 0x74AD, 0x748D, 0x6C8D, 0x6C8D, 0x6C8D, 0x648D, 0x648D, 0x646D, 0x646C, 0x6C6C, 0x748D, 0x7CCD, 0x7CCE, 0x84AE, 0x8CCF, 
        0x848E, 0x6C4D, 0x6C4C, 0x6C4C, 0x644C, 0x644C, 0x6C6D, 0x6CAD, 0x6CAD, 0x6CAD, 0x74CE, 0x7D0E, 0x852F, 0x8D2F, 0x850E, 0x8D0E, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x952F, 0x9530, 0x950F, 0x9510, 0x9D10, 0x9CEF, 0x9CCF, 0x9CAF, 0x9C8F, 
        0x9C6F, 0x9C6F, 0x948F, 0x84AF, 0x7CF0, 0x7D30, 0x752F, 0x752F, 0x752F, 0x752F, 0x752F, 0x6D0F, 0x6CCF, 0x6CAF, 0x6C6F, 0x5BCD, 0x5BAD, 0x5B8D, 0x5BAE, 0x5BAE, 0x5BAE, 0x5BAE, 0x5BAE, 0x5B8E, 0x536E, 0x534E, 0x532E, 0x5B4E, 0x636D, 0x6B8D, 
        0x6B8C, 0x6BAB, 0x73CB, 0x740C, 0x7C4C, 0x8C8D, 0x94CE, 0x9D2F, 0xA52F, 0x9D2F, 0x9D2E, 0x9D0D, 0x94ED, 0x94CC, 0x94AC, 0x8C8B, 0x7C4B, 0x642A, 0x5C0A, 0x53EA, 0x53EA, 0x6C0A, 0x844B, 0x946C, 0x948C, 0x94AC, 0x94AC, 0x9CCC, 0x9CAC, 0x9CCC, 
        0x9CED, 0xA50D, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD0E, 0xAD0E, 0xA4EE, 0xA4EE, 0xA491, 0x9C52, 0x83B6, 0x7318, 0x62BA, 0x6ADC, 0x731D, 0x731D, 0x6B1D, 0x6B1D, 0x6AFD, 0x62FE, 0x62FD, 0x62FD, 0x5ADE, 0x5ADD, 0x5ADD, 0x5ABD, 0x52BD, 0x52BD, 0x52BC, 
        0x4A9C, 0x4A9B, 0x4A9B, 0x4A9B, 0x427A, 0x427A, 0x425A, 0x3A59, 0x3A39, 0x3A39, 0x3A18, 0x3218, 0x3A18, 0x3A18, 0x3A18, 0x39F9, 0x41D9, 0x41B9, 0x41BA, 0x41DB, 0x49DC, 0x49FC, 0x49DC, 0x49DD, 0x49FD, 0x49FD, 0x49FD, 0x49DD, 0x49DD, 0x49DD, 
        0x49DD, 0x41BD, 0x41BD, 0x51FD, 0x5A9D, 0x62FE, 0x6B3E, 0x6B3E, 0x6B5E, 0x6B3D, 0x6B3D, 0x633E, 0x631E, 0x527E, 0x317C, 0x293C, 0x293D, 0x211D, 0x293D, 0x295D, 0x295D, 0x317D, 0x31BD, 0x39FD, 0x421D, 0x4A3D, 0x4A7D, 0x4A7D, 0x4A9D, 0x529E, 
        0x529E, 0x529D, 0x4A7D, 0x4A5D, 0x527D, 0x52BE, 0x52DE, 0x5ADE, 0x5ADE, 0x52DE, 0x52DE, 0x5AFE, 0x5AFE, 0x5B1E, 0x631E, 0x631E, 0x633E, 0x633E, 0x635E, 0x6B5E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 
        0x739E, 0x739E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x737E, 0x739E, 0x737E, 0x6B7E, 0x6B5D, 0x6B5E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x6BBE, 0x6BBE, 0x73BE, 0x73BE, 0x73DE, 0x73BE, 
        0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x639E, 0x5B7E, 0x5B5E, 0x5B5D, 0x5B3D, 0x5B3E, 0x533D, 0x533D, 0x531D, 0x531E, 0x52FE, 0x52FE, 0x4AFD, 0x4ADD, 0x42DD, 0x42BD, 0x42BE, 0x429D, 0x429D, 
        0x3A7D, 0x3A7D, 0x3A7E, 0x3A5E, 0x3A5E, 0x325E, 0x323D, 0x321D, 0x2A1D, 0x2A1D, 0x29FD, 0x29DD, 0x29DD, 0x21DD, 0x21BD, 0x21BD, 0x21BD, 0x21BD, 0x219D, 0x219D, 0x219D, 0x219D, 0x219D, 0x299D, 0x29BD, 0x31FD, 0x427E, 0x3A3E, 0x08BC, 0x007D, 
        0x009D, 0x00BC, 0x011D, 0x119D, 0x11DD, 0x19FD, 0x1A1D, 0x1A1D, 0x1A3D, 0x1A3D, 0x1A3D, 0x225E, 0x225D, 0x2A7D, 0x2A7E, 0x329E, 0x3ABE, 0x42BE, 0x4ABE, 0x3A3A, 0x29B4, 0x3A71, 0x5B72, 0x5B71, 0x4AEE, 0x3A8C, 0x326A, 0x3269, 0x32C9, 0x3AEA, 
        0x4B0B, 0x532C, 0x4B0D, 0x42ED, 0x432E, 0x4BAF, 0x5C30, 0x6470, 0x6CD0, 0x7510, 0x74EF, 0x6CAD, 0x6C8C, 0x6C6B, 0x644B, 0x646B, 0x646B, 0x646A, 0x5C4A, 0x5C4A, 0x542A, 0x540A, 0x4BEC, 0x4C0F, 0x4C4F, 0x546F, 0x544F, 0x4C0D, 0x4C0C, 0x540C, 
        0x540C, 0x4BEB, 0x4BCA, 0x4BC9, 0x4BC9, 0x43C9, 0x43C8, 0x43C8, 0x3BC8, 0x3BC8, 0x3BE8, 0x3BE7, 0x43E8, 0x43E8, 0x43E8, 0x4408, 0x4C08, 0x4C28, 0x5428, 0x5C49, 0x5C69, 0x646A, 0x6C8A, 0x6CAA, 0x6CCB, 0x74CB, 0x74CB, 0x74CB, 0x74CB, 0x74CB, 
        0x74CB, 0x74CB, 0x74CB, 0x74CB, 0x74CB, 0x6CCB, 0x6CCB, 0x6CCB, 0x64AA, 0x64AA, 0x5C8A, 0x546A, 0x4C49, 0x4C49, 0x4428, 0x4408, 0x3C08, 0x3C08, 0x3BE7, 0x33E6, 0x33C6, 0x33C6, 0x2BC6, 0x2BA5, 0x2BA5, 0x23A5, 0x23A5, 0x2385, 0x2365, 0x1B45, 
        0x1B25, 0x1B05, 0x1AE5, 0x1AC5, 0x1AA5, 0x1A85, 0x1265, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1A66, 0x2266, 0x2286, 0x2286, 0x2AA7, 0x22C7, 0x2AC7, 0x2AE7, 0x2B07, 0x2B07, 0x2B07, 0x2B27, 0x2B47, 0x2347, 0x2347, 0x2347, 0x2367,
  0x7470, 0x7471, 0x7472, 0x7C92, 0x7CD1, 0x7CF0, 0x7CD0, 0x84F1, 0x8D52, 0x8D52, 0x8510, 0x7CEF, 0x7CEE, 0x7CEE, 0x7CCD, 0x74CD, 0x74CE, 0x74AD, 0x6CAD, 0x6C8D, 0x6C8D, 0x648D, 0x648D, 0x6C8D, 0x646D, 0x6C6D, 0x748D, 0x74AD, 0x7CAE, 0x7C8E, 0x84CF, 
        0x7C8E, 0x6C4C, 0x6C4C, 0x6C4C, 0x644C, 0x644D, 0x6C6D, 0x74AE, 0x74CE, 0x74CE, 0x74CE, 0x7CEE, 0x84EE, 0x84EE, 0x850E, 0x850E, 0x8D0E, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x952F, 0x952F, 0x950F, 0x94EF, 0x9CF0, 0x9CEF, 0x9CCF, 0x9CAF, 0x9C8F, 
        0x9C4F, 0x9C6F, 0x8C8F, 0x84AF, 0x7D10, 0x7D0F, 0x750F, 0x6CEE, 0x6CEF, 0x750F, 0x6CEF, 0x6CCE, 0x6CAE, 0x5C0C, 0x53AC, 0x5BAC, 0x5BCC, 0x63CD, 0x63CD, 0x63CE, 0x5BCE, 0x5BAE, 0x5BAE, 0x5B8F, 0x536E, 0x534E, 0x532F, 0x5B2F, 0x634E, 0x636D, 
        0x634D, 0x5B2B, 0x634B, 0x6BAB, 0x6BCC, 0x740C, 0x844D, 0x8CAE, 0x94EE, 0x950E, 0x950E, 0x94EE, 0x8CCD, 0x8CAC, 0x8C8C, 0x846B, 0x7C4B, 0x6C2A, 0x640A, 0x53EA, 0x5BEA, 0x740A, 0x844B, 0x946B, 0x948C, 0x948C, 0x9CAC, 0x9CCC, 0x9CCD, 0xA50D, 
        0xA50D, 0xAD2E, 0xAD0E, 0xAD2E, 0xAD2E, 0xAD0E, 0xAD2E, 0xA50E, 0xA4EE, 0xA4EE, 0xA4AF, 0x9453, 0x83D6, 0x7B58, 0x6AD9, 0x6ABB, 0x6ADC, 0x6ADD, 0x6AFD, 0x6AFD, 0x62DD, 0x62FD, 0x62FD, 0x62DE, 0x5ADE, 0x5ADD, 0x5ADD, 0x52BD, 0x52BD, 0x52BC, 
        0x4ABC, 0x4A9C, 0x4A9B, 0x4A9B, 0x4A9A, 0x427B, 0x425A, 0x3A5A, 0x3A39, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3A19, 0x41F9, 0x41B9, 0x39B9, 0x41BA, 0x49DB, 0x49DC, 0x49DC, 0x49DD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49DD, 
        0x49DD, 0x41BD, 0x41BD, 0x41BD, 0x41DC, 0x521D, 0x5ABE, 0x6B1E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x6B3E, 0x631E, 0x5ADE, 0x39FD, 0x295C, 0x211D, 0x291D, 0x293D, 0x295D, 0x315D, 0x319D, 0x39BD, 0x421D, 0x4A3E, 0x4A5D, 0x4A7D, 0x4A9D, 0x4A9D, 
        0x529E, 0x529D, 0x4A7D, 0x4A5D, 0x4A7D, 0x529E, 0x52DE, 0x5ADE, 0x5AFD, 0x5ADD, 0x5ADD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1D, 0x5B1D, 0x633E, 0x633E, 0x633E, 0x635E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 0x739E, 
        0x739E, 0x739E, 0x6B9E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x6B7E, 0x6B7E, 0x737E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 
        0x6BDE, 0x6BDE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x533D, 0x533D, 0x531D, 0x531D, 0x52FE, 0x4AFE, 0x4AFD, 0x4ADD, 0x42DD, 0x42BD, 0x42BE, 0x42BD, 0x429E, 
        0x3A7D, 0x3A7D, 0x3A7D, 0x3A5D, 0x325D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x21FD, 0x21DD, 0x21DD, 0x21DD, 0x21BD, 0x21BD, 0x199D, 0x199D, 0x199D, 0x199D, 0x199D, 0x197D, 0x217D, 0x219D, 0x299D, 0x29BD, 0x31FD, 0x429F, 0x191C, 0x087D, 
        0x009D, 0x00BC, 0x093D, 0x11BD, 0x11DD, 0x19FD, 0x1A1D, 0x1A1D, 0x1A3D, 0x1A3D, 0x1A3D, 0x225D, 0x225D, 0x2A7D, 0x327E, 0x327D, 0x429E, 0x429E, 0x4ABD, 0x5ADD, 0x6B3B, 0x6B7A, 0x7399, 0x7BFA, 0x843A, 0x845A, 0x7C57, 0x7436, 0x7435, 0x7435, 
        0x7C55, 0x7C55, 0x7C36, 0x7436, 0x6C14, 0x6412, 0x6432, 0x6C72, 0x6CB1, 0x7511, 0x74EF, 0x6CAD, 0x6C6C, 0x642C, 0x5BEB, 0x640B, 0x644B, 0x5C4B, 0x5C4A, 0x5C2B, 0x540B, 0x4C0B, 0x4C0D, 0x4C2E, 0x4C6F, 0x4C8F, 0x4C6F, 0x4C4E, 0x4C2D, 0x4C0D, 
        0x542D, 0x4BEC, 0x4BCB, 0x4BCA, 0x43C9, 0x43C9, 0x43C9, 0x43A8, 0x3BC8, 0x3BC8, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BE7, 0x43E8, 0x4408, 0x4C08, 0x4C28, 0x5428, 0x5C49, 0x5C69, 0x646A, 0x6C8A, 0x6CAA, 0x74CB, 0x74CB, 0x74EC, 0x74EC, 0x74EC, 0x7CEC, 
        0x7CEC, 0x7CEC, 0x7CEC, 0x74EB, 0x74CB, 0x74CB, 0x6CCB, 0x6CCB, 0x64AA, 0x648A, 0x5C8A, 0x5469, 0x4C49, 0x4C29, 0x4428, 0x3C08, 0x3C08, 0x3C08, 0x3BE7, 0x33E6, 0x33C6, 0x33C6, 0x2BC6, 0x2BA5, 0x2BA5, 0x23A5, 0x23A5, 0x2385, 0x2365, 0x1B45, 
        0x1B25, 0x1B05, 0x1AE5, 0x1AC5, 0x1AA5, 0x1A85, 0x1A65, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1A46, 0x2266, 0x2266, 0x2286, 0x2A87, 0x22A7, 0x2AC7, 0x2AC7, 0x2AE7, 0x2AE7, 0x2B07, 0x2307, 0x2B27, 0x2327, 0x2327, 0x2347, 0x2367,
  0x6C4F, 0x6C71, 0x7491, 0x74B1, 0x7D12, 0x7D31, 0x7CF0, 0x8511, 0x8D52, 0x8532, 0x7CF0, 0x7CCF, 0x7CCE, 0x7CED, 0x7CCD, 0x74CD, 0x74CD, 0x74AD, 0x6CAD, 0x6C8D, 0x648D, 0x646C, 0x646C, 0x646D, 0x6C8D, 0x6C8D, 0x748D, 0x7CAD, 0x7CAE, 0x7CAE, 0x84CF, 
        0x7C8E, 0x6C4C, 0x6C2C, 0x6C4C, 0x644C, 0x644C, 0x646D, 0x74CE, 0x74EE, 0x74EE, 0x7CCE, 0x7CEE, 0x7CEE, 0x84EE, 0x850E, 0x850E, 0x8D0E, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x952F, 0x952F, 0x950F, 0x950F, 0x9CEF, 0x9CCF, 0x9CCF, 0x9CB0, 0x9C8F, 
        0x9C6F, 0x9C6F, 0x8C6F, 0x84AF, 0x7CF0, 0x6C8E, 0x6CAE, 0x6CCE, 0x6CEF, 0x750F, 0x6CCF, 0x646E, 0x53EC, 0x4BAB, 0x53AB, 0x5BCB, 0x5BEB, 0x63EC, 0x63EC, 0x63CD, 0x63CD, 0x5BCE, 0x5BCE, 0x5BAE, 0x536E, 0x534E, 0x532F, 0x5B2F, 0x5B4E, 0x634E, 
        0x634E, 0x5B2C, 0x5B2B, 0x5B6C, 0x63AC, 0x63CC, 0x6BEC, 0x742C, 0x7C4D, 0x7C6D, 0x7C6C, 0x848D, 0x848D, 0x848C, 0x846B, 0x7C4B, 0x742B, 0x6C2A, 0x640A, 0x5BEA, 0x640A, 0x7C2B, 0x844B, 0x8C4B, 0x948C, 0x948C, 0x9CAC, 0x9CED, 0xA50E, 0xA52E, 
        0xAD2E, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD0E, 0xA50D, 0xA50D, 0xA4EE, 0xA4CE, 0x9CAF, 0x9472, 0x83F4, 0x7B96, 0x7338, 0x6AD9, 0x629A, 0x5A9B, 0x5A9C, 0x5ABC, 0x62BD, 0x62DD, 0x5ADD, 0x5ADD, 0x5ADD, 0x5ADD, 0x52BD, 0x52BD, 0x52BC, 
        0x52BC, 0x4A9C, 0x4A9B, 0x4A9B, 0x4A9A, 0x427A, 0x427A, 0x3A5A, 0x3A3A, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A39, 0x3A18, 0x3A18, 0x4219, 0x41D9, 0x4199, 0x41BA, 0x49DB, 0x49DC, 0x49DC, 0x49DC, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49DD, 
        0x41DD, 0x41DD, 0x41BD, 0x41BD, 0x41BD, 0x41BD, 0x49DC, 0x525D, 0x62DE, 0x633E, 0x633E, 0x633D, 0x6B3E, 0x633E, 0x633D, 0x62FE, 0x527E, 0x319C, 0x211C, 0x291D, 0x293D, 0x295D, 0x317D, 0x319D, 0x41FD, 0x421D, 0x4A3D, 0x4A7D, 0x4A9D, 0x529E, 
        0x529D, 0x52BD, 0x4A9E, 0x4A7D, 0x4A7D, 0x529D, 0x52BE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x631E, 0x633D, 0x633D, 0x635E, 0x635E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 0x739E, 0x739E, 
        0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x6B7E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 0x6BBE, 0x73DE, 0x73DE, 0x73DE, 
        0x6BDE, 0x6BDE, 0x6BBE, 0x6BBD, 0x6BBD, 0x6BBE, 0x6B9E, 0x6BBE, 0x639E, 0x639E, 0x639E, 0x639E, 0x637E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x533D, 0x533D, 0x531D, 0x531D, 0x4AFE, 0x4AFD, 0x4AFD, 0x4ADD, 0x4ADD, 0x42BD, 0x42BE, 0x42BD, 0x429E, 
        0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x21DD, 0x21DD, 0x21DD, 0x21BD, 0x21BD, 0x219D, 0x199D, 0x197D, 0x197D, 0x197D, 0x197D, 0x197D, 0x197D, 0x217D, 0x219D, 0x299D, 0x29BD, 0x3A3D, 0x3A1E, 0x08BC, 
        0x009D, 0x00BC, 0x095D, 0x11BD, 0x11DD, 0x19FD, 0x19FD, 0x1A1D, 0x1A3D, 0x1A3D, 0x223D, 0x2A5D, 0x2A5D, 0x327D, 0x3A7D, 0x3A7D, 0x4A9D, 0x4A9D, 0x529D, 0x62BD, 0x6AFD, 0x733C, 0x733D, 0x7B5D, 0x735D, 0x6AFB, 0x62F9, 0x5296, 0x5275, 0x5AD7, 
        0x62F8, 0x62F8, 0x6B19, 0x6B79, 0x73D9, 0x7419, 0x7457, 0x7496, 0x7CD5, 0x7D13, 0x74F1, 0x6C8D, 0x644D, 0x5BCC, 0x538B, 0x5BCC, 0x5BEC, 0x5C0B, 0x53EB, 0x53EB, 0x53EB, 0x4BEC, 0x4C0D, 0x444D, 0x4C8E, 0x44AE, 0x44AE, 0x448E, 0x446E, 0x442D, 
        0x440D, 0x4BED, 0x43CC, 0x43CB, 0x43CA, 0x43CA, 0x43CA, 0x43C9, 0x43C9, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC7, 0x3BC7, 0x43C8, 0x43E8, 0x4C08, 0x4C28, 0x5428, 0x5C49, 0x5C69, 0x648A, 0x6C8A, 0x6CAA, 0x74CB, 0x74CB, 0x7CCB, 0x7CEC, 0x7CEC, 0x7CEC, 
        0x7CEC, 0x7CEC, 0x7CEC, 0x74CB, 0x74CB, 0x74CB, 0x74CB, 0x6CAB, 0x64AB, 0x5C8A, 0x5C6A, 0x5449, 0x4C49, 0x4C29, 0x4408, 0x3C08, 0x3C08, 0x3BE8, 0x33E7, 0x33E7, 0x33C6, 0x33C6, 0x2BA6, 0x2BA5, 0x2BA5, 0x23A5, 0x2BA5, 0x23A5, 0x2385, 0x1B65, 
        0x1B45, 0x1B05, 0x1AE5, 0x1AE5, 0x1AA5, 0x1A85, 0x1A85, 0x1A45, 0x1A45, 0x1A25, 0x1A25, 0x1A25, 0x2246, 0x2246, 0x2266, 0x2266, 0x2287, 0x2287, 0x2AA7, 0x2AC7, 0x2AC7, 0x2AC7, 0x2AE7, 0x22E7, 0x2B07, 0x2307, 0x2327, 0x2347, 0x2B48,
  0x6C4F, 0x6C70, 0x6C91, 0x74D1, 0x7D31, 0x7D52, 0x7D31, 0x8532, 0x8552, 0x7D11, 0x7CF0, 0x7CCF, 0x7CCE, 0x7CED, 0x74CD, 0x74CD, 0x74CD, 0x74CE, 0x74AD, 0x6C8D, 0x648D, 0x646C, 0x646D, 0x6C8D, 0x6C8D, 0x74AD, 0x74CE, 0x7CAE, 0x7CAE, 0x7CAE, 0x84CF, 
        0x7C8E, 0x6C4C, 0x642C, 0x644C, 0x644C, 0x646D, 0x6C8D, 0x74CE, 0x7CEE, 0x7CEE, 0x7CCE, 0x7CEE, 0x7CEE, 0x84EE, 0x850E, 0x8D0E, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x9530, 0x9530, 0x9530, 0x9D10, 0x9D10, 0x9CF0, 0x9CD0, 0x9CB0, 0x9C6F, 
        0x9C4F, 0x9C4F, 0x8C4F, 0x848F, 0x6C2D, 0x6C6E, 0x74AF, 0x6C8E, 0x5C2D, 0x53CB, 0x4BAB, 0x4B8B, 0x53AC, 0x53AB, 0x5BCB, 0x63EB, 0x63EB, 0x640B, 0x640B, 0x63EC, 0x63EC, 0x63EC, 0x63ED, 0x5BCD, 0x53AD, 0x536D, 0x534E, 0x534E, 0x5B4E, 0x5B4E, 
        0x5B6E, 0x5B6E, 0x5B6D, 0x5B6D, 0x5B8D, 0x63AC, 0x63AC, 0x6BEC, 0x6BEC, 0x6C0C, 0x6C0C, 0x6C0C, 0x742C, 0x7C4C, 0x7C4B, 0x742B, 0x6C2B, 0x6C0B, 0x6C0B, 0x640A, 0x6C2B, 0x7C2B, 0x844B, 0x8C4B, 0x948C, 0x94AC, 0x9CCD, 0xA4ED, 0xA50E, 0xA52E, 
        0xAD2E, 0xAD2E, 0xAD2E, 0xAD2E, 0xA52D, 0xA50D, 0xA50D, 0xA50D, 0xA4ED, 0xA4EE, 0x9CCE, 0x9CAE, 0x94AE, 0x8C70, 0x8412, 0x83D4, 0x7B96, 0x7357, 0x6B19, 0x62D9, 0x62BA, 0x5A9B, 0x5A9C, 0x5ABD, 0x5ABD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 
        0x52BC, 0x4A9C, 0x4A9B, 0x4A9B, 0x4A9B, 0x427A, 0x427A, 0x3A5A, 0x3A3A, 0x3A39, 0x3A39, 0x3A19, 0x3A18, 0x3A38, 0x3A18, 0x3A18, 0x3A19, 0x41F9, 0x4199, 0x419A, 0x49BB, 0x49BC, 0x49DC, 0x49DC, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 
        0x49DD, 0x41DD, 0x41DD, 0x41BD, 0x41BD, 0x41BD, 0x41BD, 0x41DD, 0x4A1D, 0x529D, 0x631E, 0x631E, 0x6B3E, 0x633E, 0x633D, 0x633D, 0x631E, 0x5ADE, 0x41DD, 0x293C, 0x291C, 0x293D, 0x315D, 0x317D, 0x39BD, 0x421D, 0x423D, 0x4A5D, 0x4A7D, 0x529E, 
        0x529D, 0x4A9D, 0x529E, 0x4A7E, 0x4A7D, 0x529D, 0x52BE, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x631E, 0x633D, 0x633E, 0x635E, 0x635E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 
        0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x737E, 0x739E, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 
        0x73DE, 0x6BDE, 0x6BBE, 0x6BBD, 0x6BBD, 0x6BBE, 0x6BBE, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 0x5B3E, 0x533D, 0x533D, 0x531D, 0x531D, 0x4AFD, 0x4AFD, 0x4AFD, 0x4ADD, 0x4ADD, 0x4ABD, 0x429D, 0x429D, 0x429E, 
        0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x21DD, 0x21DD, 0x21BD, 0x21BD, 0x199D, 0x199D, 0x197D, 0x197D, 0x117D, 0x115D, 0x115D, 0x115D, 0x195D, 0x197D, 0x217D, 0x217D, 0x299D, 0x31DD, 0x425E, 0x193D, 
        0x007C, 0x00BC, 0x115D, 0x11BD, 0x19DD, 0x19FD, 0x21FD, 0x221D, 0x223D, 0x2A3D, 0x2A5E, 0x325D, 0x327D, 0x427E, 0x427E, 0x429D, 0x4A9E, 0x527D, 0x5ABD, 0x6ADE, 0x72FE, 0x72FE, 0x72FE, 0x72FE, 0x5A5C, 0x5A3B, 0x523A, 0x523A, 0x523A, 0x521A, 
        0x521A, 0x521A, 0x5A3A, 0x5A5A, 0x527A, 0x52B9, 0x52D8, 0x5317, 0x6376, 0x6BF6, 0x7475, 0x7473, 0x6C11, 0x5B8F, 0x536E, 0x538E, 0x53AD, 0x53CC, 0x4BAB, 0x4BCB, 0x4BCB, 0x4BEC, 0x4C0D, 0x446D, 0x448E, 0x44AD, 0x44AD, 0x44AE, 0x44AE, 0x446D, 
        0x3C2D, 0x440D, 0x3BAB, 0x3BAB, 0x43CB, 0x43CB, 0x43EB, 0x43EB, 0x43EA, 0x3BC9, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC8, 0x43E8, 0x4BE8, 0x4C28, 0x5449, 0x5C49, 0x6469, 0x648A, 0x6C8A, 0x6CAA, 0x74CB, 0x74CB, 0x7CCB, 0x7CEC, 0x7CEC, 0x7CEC, 
        0x7CEC, 0x7CEC, 0x7CEC, 0x7CEC, 0x74EB, 0x74CB, 0x74CB, 0x6CAB, 0x64AB, 0x5C8A, 0x5C6A, 0x5449, 0x4C29, 0x4428, 0x4408, 0x3C08, 0x3BE8, 0x3BE7, 0x33C7, 0x33C7, 0x33C6, 0x33C6, 0x2BA6, 0x2BA5, 0x2BA5, 0x23A5, 0x2BA5, 0x23A5, 0x2385, 0x2365, 
        0x1B45, 0x1B25, 0x1AE5, 0x1AE6, 0x1AA5, 0x1A86, 0x1A86, 0x1A66, 0x1A46, 0x2226, 0x2226, 0x2226, 0x2226, 0x2246, 0x2246, 0x2266, 0x2266, 0x2287, 0x2A87, 0x2AA7, 0x2AA7, 0x22C7, 0x2AC7, 0x22C7, 0x2AE7, 0x2B07, 0x2B27, 0x2B27, 0x2B48,
  0x646F, 0x6C90, 0x6CD1, 0x7510, 0x7D51, 0x7D72, 0x8572, 0x8572, 0x8552, 0x7CF1, 0x7CCF, 0x74EE, 0x74ED, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x6CAD, 0x6C8D, 0x6C8D, 0x6C6D, 0x6C8D, 0x6C8D, 0x74CD, 0x7CCE, 0x7CEE, 0x7CCE, 0x7CAE, 0x7CCE, 
        0x7CAE, 0x6C4C, 0x644C, 0x644C, 0x644C, 0x6C6D, 0x6CAD, 0x74CE, 0x7CEE, 0x7CEE, 0x7CCE, 0x84EE, 0x84EE, 0x850E, 0x850E, 0x8D0E, 0x8D0F, 0x8D0F, 0x8D2F, 0x952F, 0x952F, 0x9D30, 0x9D50, 0x9D50, 0xA571, 0xA551, 0x9CF0, 0x9CD0, 0x9C8F, 0x944F, 
        0x942F, 0x9450, 0x9450, 0x7C2E, 0x744F, 0x746F, 0x642E, 0x538C, 0x4B6B, 0x53AB, 0x5C0D, 0x642E, 0x5BAC, 0x640D, 0x642D, 0x6C2C, 0x63EB, 0x640B, 0x6C0B, 0x640A, 0x640B, 0x640B, 0x63EB, 0x63CB, 0x5BCB, 0x538C, 0x536C, 0x534D, 0x532D, 0x534E, 
        0x5B4E, 0x5B6E, 0x5B6E, 0x5B8E, 0x5B8E, 0x5B8D, 0x5BAC, 0x63CC, 0x63EC, 0x63EC, 0x63EC, 0x63CB, 0x63CB, 0x6BEB, 0x740B, 0x740B, 0x740B, 0x6C0B, 0x6C0B, 0x6BEB, 0x740B, 0x7C2B, 0x844B, 0x8C6C, 0x948D, 0x9CAD, 0x9CCD, 0xA4ED, 0xA4ED, 0xA4ED, 
        0xA50D, 0xA50D, 0xA50D, 0xA4ED, 0xA50D, 0x9CED, 0xA4ED, 0x9CED, 0x9CCD, 0x9CCD, 0x94CD, 0x94AD, 0x94AD, 0x948E, 0x946E, 0x8C50, 0x8C31, 0x8C12, 0x8BF3, 0x73B5, 0x6B57, 0x62F8, 0x5A99, 0x4A7A, 0x4A7C, 0x529C, 0x529C, 0x52BD, 0x52BD, 0x52BC, 
        0x4ABC, 0x52BC, 0x4ABB, 0x4A9B, 0x4A7B, 0x427A, 0x427A, 0x427A, 0x3A59, 0x3A39, 0x3A39, 0x3A39, 0x3A39, 0x3A38, 0x3A18, 0x3A18, 0x3A18, 0x41F9, 0x41B9, 0x4199, 0x41BA, 0x41BB, 0x49BC, 0x49DC, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 0x49FD, 
        0x49FE, 0x41DE, 0x41DE, 0x41DD, 0x41DD, 0x41BD, 0x41BD, 0x39BD, 0x399D, 0x39BD, 0x4A5D, 0x5AFE, 0x631E, 0x633D, 0x633D, 0x633D, 0x633D, 0x633E, 0x631E, 0x4A5E, 0x315C, 0x291C, 0x293D, 0x315D, 0x319D, 0x39DD, 0x421D, 0x423D, 0x4A5D, 0x4A7D, 
        0x4A9D, 0x4A9D, 0x529E, 0x529E, 0x4A7D, 0x529D, 0x529E, 0x52DE, 0x5ADE, 0x5AFE, 0x5B1E, 0x5AFE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B1E, 0x631E, 0x633E, 0x633E, 0x633E, 0x6B5E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 0x739E, 0x6B9E, 
        0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x73BE, 0x7BBE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x7BFE, 0x73DE, 
        0x73DE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6BBE, 0x6B9E, 0x6B9D, 0x6B9D, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x637E, 0x635E, 0x5B5E, 0x5B3E, 0x5B3E, 0x533E, 0x531D, 0x531D, 0x52FD, 0x4AFD, 0x4ADD, 0x4ADD, 0x4ABD, 0x42DD, 0x42BD, 0x429E, 0x429D, 0x427D, 
        0x3A7D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x2A1D, 0x2A1D, 0x29FD, 0x29FD, 0x21DD, 0x21DD, 0x21BD, 0x19BD, 0x199D, 0x199D, 0x199D, 0x117D, 0x115D, 0x115D, 0x115D, 0x115D, 0x115D, 0x195D, 0x195D, 0x197D, 0x217D, 0x299D, 0x29BD, 0x3A1D, 0x31FD, 
        0x009B, 0x08FC, 0x117E, 0x11BD, 0x19DD, 0x21FD, 0x221D, 0x2A3D, 0x2A3E, 0x325E, 0x3A5E, 0x3A7D, 0x427D, 0x4A7D, 0x4A7E, 0x529D, 0x529D, 0x629D, 0x6ADE, 0x72DE, 0x6ABD, 0x627C, 0x5A3B, 0x5A3C, 0x523C, 0x523B, 0x523B, 0x523B, 0x523B, 0x523B, 
        0x523B, 0x523B, 0x521B, 0x521B, 0x523B, 0x525A, 0x525A, 0x5279, 0x5279, 0x5298, 0x5AD7, 0x6336, 0x6B96, 0x73F6, 0x6C14, 0x63F2, 0x53AE, 0x4BAD, 0x4BAC, 0x4BAB, 0x4BAC, 0x4BEC, 0x4C0D, 0x446D, 0x448D, 0x3CAC, 0x3CCD, 0x3CCD, 0x3CCD, 0x3CAD, 
        0x3C8D, 0x3C2D, 0x3BED, 0x3BEC, 0x3BEC, 0x43CD, 0x3BCC, 0x3BAB, 0x3BCB, 0x3BCB, 0x3BAA, 0x3BA9, 0x3BA9, 0x3BC9, 0x43C9, 0x43E9, 0x4BE9, 0x5409, 0x5C2A, 0x5C4A, 0x646A, 0x646A, 0x6C8A, 0x74AB, 0x74AB, 0x74AB, 0x7CAB, 0x7CCC, 0x7CCC, 0x7CCC, 
        0x7CEC, 0x7CEC, 0x7CEC, 0x7CEC, 0x74EC, 0x74CB, 0x74CB, 0x6CCB, 0x648B, 0x646A, 0x5C4A, 0x5449, 0x4C29, 0x4409, 0x3BE8, 0x3BE8, 0x3BE7, 0x33C7, 0x33C7, 0x33C7, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B85, 0x2385, 0x2385, 0x2385, 0x2385, 0x2366, 
        0x2346, 0x2326, 0x22E6, 0x1AC6, 0x1AA6, 0x1A86, 0x1A86, 0x2266, 0x2246, 0x2226, 0x2226, 0x2226, 0x2226, 0x2226, 0x2226, 0x2A46, 0x2A47, 0x2A67, 0x2A67, 0x2A87, 0x2287, 0x22A7, 0x22A7, 0x22C7, 0x22E7, 0x2B07, 0x2B07, 0x2B47, 0x2B48,
  0x6CB0, 0x6CD0, 0x6CF0, 0x6D30, 0x7530, 0x7D71, 0x8592, 0x8592, 0x8572, 0x7D10, 0x74CE, 0x74CE, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74CD, 0x74CD, 0x74CD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6C8D, 0x6CAD, 0x74CE, 0x7CEE, 0x84CF, 0x7CAE, 0x7CCE, 
        0x74AE, 0x6C6D, 0x644C, 0x644C, 0x6C6D, 0x6C8D, 0x74AE, 0x74CE, 0x7CCE, 0x7CEE, 0x7CEE, 0x7CCE, 0x84EE, 0x850E, 0x84EE, 0x8D0E, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x9550, 0x9D50, 0x9D50, 0xA570, 0xA571, 0x9D30, 0x9CEF, 0x9CAF, 0x946F, 0x944F, 
        0x942F, 0x942F, 0x8C30, 0x842F, 0x7C70, 0x742F, 0x5B8D, 0x5BAD, 0x5BED, 0x7490, 0x7CD1, 0x6C8F, 0x640E, 0x6C4E, 0x6C2D, 0x63EC, 0x63CB, 0x640B, 0x6C0A, 0x6C29, 0x6C29, 0x640A, 0x63EA, 0x63EA, 0x5BCA, 0x53AA, 0x538A, 0x4B6B, 0x4B2B, 0x432C, 
        0x4B4C, 0x536E, 0x5B6E, 0x5B8E, 0x5B8E, 0x538E, 0x5BAD, 0x5BCC, 0x5BCC, 0x5BCC, 0x5BCB, 0x5BCB, 0x5BCB, 0x63CB, 0x6BCB, 0x6BEB, 0x6BEB, 0x6BCB, 0x6BCB, 0x63CB, 0x6BEB, 0x740B, 0x7C2B, 0x846C, 0x948D, 0x9CAD, 0x9CAD, 0x9CCD, 0x9CCD, 0x9CCD, 
        0x9CCD, 0x9CED, 0x9CED, 0x9CCD, 0x9CCC, 0x9CCC, 0x9CCD, 0x9CCC, 0x9CCD, 0x94AC, 0x94AD, 0x94AD, 0x94AD, 0x94AC, 0x8C8D, 0x8C8D, 0x8C8E, 0x8C8F, 0x8C70, 0x8431, 0x73D3, 0x7394, 0x6B37, 0x5298, 0x4219, 0x4A3A, 0x4A7B, 0x4A7C, 0x4A9C, 0x4A9C, 
        0x4ABC, 0x52BC, 0x52BB, 0x4A9B, 0x4A9B, 0x427B, 0x427A, 0x427A, 0x3A59, 0x3A39, 0x3A19, 0x3A19, 0x3A19, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x41F9, 0x41B9, 0x41BA, 0x41BA, 0x49BB, 0x49BC, 0x49DC, 0x49FD, 0x51FD, 0x49FD, 0x4A1D, 0x49FD, 
        0x49FD, 0x41FD, 0x41DD, 0x41FD, 0x41DD, 0x39BD, 0x41BD, 0x39BD, 0x39BD, 0x399D, 0x39BC, 0x4A3D, 0x5ADE, 0x5B1D, 0x633D, 0x633E, 0x633D, 0x633D, 0x633E, 0x5AFE, 0x529E, 0x399C, 0x293C, 0x293D, 0x317D, 0x39BD, 0x41FD, 0x421D, 0x423D, 0x4A5E, 
        0x4A7E, 0x4A9D, 0x52BE, 0x52BE, 0x4A9D, 0x4A7D, 0x529D, 0x52BE, 0x52DE, 0x52FE, 0x5AFE, 0x5AFE, 0x52FD, 0x52FD, 0x5AFD, 0x5AFE, 0x5B1E, 0x5B3E, 0x633E, 0x633E, 0x633E, 0x6B5E, 0x6B7E, 0x6B9E, 0x6B9E, 0x739E, 0x6B9E, 0x739E, 0x739E, 0x739E, 
        0x6B9E, 0x6B9E, 0x739E, 0x73BE, 0x73BE, 0x739E, 0x73BE, 0x73BE, 0x7BBE, 0x7BDE, 0x73BE, 0x739E, 0x73BE, 0x7BDD, 0x73DD, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73DE, 0x73DE, 0x73DE, 0x73FE, 0x7C1E, 0x7C1E, 0x73DE, 
        0x73BE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9D, 0x6B9D, 0x6B9E, 0x639E, 0x6B9E, 0x639E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x531E, 0x531E, 0x52FD, 0x4AFD, 0x4ADD, 0x4ADD, 0x4ADD, 0x42BE, 0x429E, 0x429D, 0x429D, 0x427D, 
        0x3A5D, 0x3A5D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x29FD, 0x29FD, 0x29DD, 0x21DD, 0x21DD, 0x21BD, 0x199D, 0x199D, 0x199D, 0x197D, 0x117D, 0x115D, 0x115D, 0x115D, 0x115D, 0x115D, 0x195D, 0x115D, 0x195D, 0x217D, 0x297D, 0x299D, 0x31DC, 0x3A3D, 
        0x213C, 0x219C, 0x29DD, 0x29DD, 0x2A1E, 0x323E, 0x3A7E, 0x3A7E, 0x427E, 0x429E, 0x4A7E, 0x4A7D, 0x527D, 0x527E, 0x5A7D, 0x5A7D, 0x5A7D, 0x629D, 0x72BE, 0x6A9D, 0x623C, 0x51FB, 0x521B, 0x523C, 0x525C, 0x523C, 0x4A3C, 0x4A3C, 0x4A3C, 0x4A3B, 
        0x4A3B, 0x4A3B, 0x4A3B, 0x4A1B, 0x4A3B, 0x523B, 0x523B, 0x523B, 0x523B, 0x523B, 0x525A, 0x525A, 0x5258, 0x52B8, 0x5B37, 0x63D6, 0x6414, 0x53B0, 0x4BCE, 0x43CD, 0x43CC, 0x43EC, 0x442C, 0x3C6C, 0x3C8C, 0x3C8B, 0x348B, 0x34AB, 0x34AC, 0x34AC, 
        0x348C, 0x346D, 0x3C4D, 0x3C2D, 0x442D, 0x440D, 0x3BED, 0x3BCC, 0x3BCC, 0x3BAC, 0x3B8B, 0x338A, 0x3BAA, 0x3BCA, 0x43EA, 0x43EA, 0x4BEA, 0x4BCA, 0x542B, 0x5C4B, 0x53E9, 0x5C4A, 0x6C6B, 0x6C8B, 0x74AB, 0x74AB, 0x7CAB, 0x7CCC, 0x7CCC, 0x7CCC, 
        0x7CEC, 0x7CEC, 0x7CEC, 0x7CEC, 0x74EC, 0x74CB, 0x74CB, 0x6CAB, 0x648A, 0x646A, 0x5C4A, 0x5429, 0x4C09, 0x43E9, 0x3BE8, 0x3BE8, 0x33C7, 0x33C7, 0x33A7, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x2B85, 0x2385, 0x2385, 0x2365, 0x2365, 0x2365, 0x2366, 
        0x2346, 0x2326, 0x22E6, 0x22C6, 0x22C6, 0x22A6, 0x2286, 0x2266, 0x2266, 0x2246, 0x2226, 0x2226, 0x2226, 0x2226, 0x2226, 0x2A46, 0x2A47, 0x2A47, 0x2A67, 0x2267, 0x2266, 0x2286, 0x22A6, 0x22A6, 0x22C7, 0x2AE7, 0x2B07, 0x2B47, 0x2B48,
  0x6CD0, 0x6CF0, 0x6D10, 0x6D10, 0x6D30, 0x7570, 0x7DB2, 0x85B2, 0x8571, 0x74EF, 0x74CE, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74CD, 0x74CE, 0x74CE, 0x74CD, 0x6CAD, 0x6C8D, 0x6C8D, 0x74AD, 0x7CEE, 0x7CCE, 0x7CAE, 0x7CCE, 
        0x74AE, 0x6C6D, 0x6C4C, 0x6C6C, 0x6C8D, 0x6CAD, 0x74CE, 0x74CE, 0x7CCE, 0x7CEE, 0x7CEE, 0x7CCE, 0x84EE, 0x84EE, 0x84EE, 0x8D0F, 0x952F, 0x952F, 0x954F, 0x9570, 0x9D70, 0x9D70, 0x9D70, 0x9D70, 0xA550, 0x9D30, 0x94EF, 0x9CAF, 0x9C8F, 0x944F, 
        0x942F, 0x940F, 0x8BEF, 0x83EF, 0x7C30, 0x742F, 0x5B8D, 0x5BCD, 0x5BCD, 0x5BCD, 0x644E, 0x74D1, 0x7CD0, 0x6C4F, 0x63EC, 0x63EB, 0x63EA, 0x63EA, 0x6409, 0x6C29, 0x6409, 0x6408, 0x6409, 0x5BE9, 0x5BC9, 0x53C8, 0x53A8, 0x4B69, 0x434A, 0x3B2A, 
        0x432B, 0x4B4C, 0x536D, 0x536E, 0x536E, 0x5B6E, 0x538E, 0x5BAD, 0x5B8C, 0x538C, 0x538C, 0x538C, 0x5BAC, 0x5BAB, 0x5BCB, 0x5BCB, 0x5BAB, 0x63AB, 0x63AB, 0x63AB, 0x63AB, 0x6BEB, 0x6BEB, 0x740B, 0x842C, 0x8C6D, 0x948D, 0x9CAD, 0x9CAD, 0x9CAD, 
        0x9CAC, 0x9CCC, 0x9CCC, 0x94CD, 0x94CC, 0x94CC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AD, 0x94AD, 0x948C, 0x8C8C, 0x8C8D, 0x8C8D, 0x94AD, 0x94CE, 0x94AF, 0x846F, 0x7C10, 0x73F1, 0x6BB2, 0x5B15, 0x4A56, 0x41F8, 0x4219, 0x423A, 0x4A3B, 0x4A7B, 
        0x4A9B, 0x529B, 0x529B, 0x4A9B, 0x4A9B, 0x427B, 0x425A, 0x427A, 0x3A59, 0x3A39, 0x3A19, 0x3A19, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x41B9, 0x41B9, 0x41BA, 0x49DB, 0x49DC, 0x49DC, 0x51FD, 0x51FD, 0x49FD, 0x49FD, 0x49FD, 
        0x49FD, 0x41FD, 0x41FD, 0x41FD, 0x41DD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x399D, 0x399D, 0x39BD, 0x41FC, 0x4A7D, 0x5ADE, 0x5B1E, 0x633E, 0x633D, 0x633D, 0x633E, 0x633E, 0x5AFE, 0x421D, 0x315D, 0x295D, 0x319D, 0x39DD, 0x421D, 0x423E, 0x4A5E, 
        0x4A7E, 0x4A9D, 0x529D, 0x52BE, 0x529E, 0x527D, 0x4A7D, 0x529E, 0x52BE, 0x52DE, 0x52FE, 0x5AFE, 0x52DD, 0x52DD, 0x52FE, 0x52FE, 0x5B1E, 0x5B3E, 0x633E, 0x5B3E, 0x5B3E, 0x633E, 0x6B7E, 0x6B9E, 0x6B9E, 0x739E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 
        0x739E, 0x6B9E, 0x739E, 0x73BE, 0x73BE, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x7BDE, 0x7BDE, 0x73BE, 0x73BE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DD, 0x73FE, 0x73FE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73DE, 0x73FE, 0x73FE, 0x73FE, 0x73DE, 0x73BE, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9D, 0x6B9D, 0x6B9E, 0x639E, 0x6B9E, 0x639E, 0x637E, 0x635E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B1E, 0x531E, 0x52FE, 0x52FD, 0x4ADE, 0x4ADD, 0x4ADD, 0x4ABD, 0x42BD, 0x429D, 0x427E, 0x427D, 0x425D, 
        0x3A5D, 0x3A3D, 0x3A3D, 0x321D, 0x321D, 0x31FD, 0x29FD, 0x29DD, 0x29DD, 0x21DD, 0x21BD, 0x21BD, 0x199D, 0x199D, 0x197D, 0x197D, 0x197D, 0x115D, 0x115D, 0x195D, 0x195D, 0x195D, 0x195D, 0x195D, 0x217D, 0x299D, 0x39DD, 0x423D, 0x4A5E, 0x527E, 
        0x4A7E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x52BE, 0x52BE, 0x52DE, 0x5ABE, 0x5ABD, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x627D, 0x629D, 0x6A9D, 0x625C, 0x623C, 0x5A3C, 0x523C, 0x525D, 0x525D, 0x4A3C, 0x4A3C, 0x4A3C, 0x4A3C, 0x4A3C, 
        0x4A3C, 0x4A3C, 0x4A3C, 0x4A3C, 0x4A3C, 0x523C, 0x523C, 0x523B, 0x525C, 0x523B, 0x523C, 0x523B, 0x523B, 0x525B, 0x4A79, 0x4A97, 0x5316, 0x5BF5, 0x53F1, 0x43CD, 0x43ED, 0x440C, 0x442C, 0x3C6C, 0x3C8C, 0x346B, 0x348B, 0x2C8A, 0x2C8B, 0x2C8B, 
        0x348B, 0x348B, 0x346C, 0x346C, 0x344C, 0x3C2C, 0x342C, 0x3C2C, 0x3BEC, 0x3BCC, 0x338B, 0x338B, 0x3BCB, 0x3BEB, 0x43EB, 0x440B, 0x43CA, 0x43AA, 0x4BAB, 0x540C, 0x53EC, 0x4BAA, 0x5BEB, 0x644B, 0x6C8C, 0x74AC, 0x7CCC, 0x7CCC, 0x7CCC, 0x7CCC, 
        0x7CCC, 0x7CCC, 0x7CEC, 0x7CEC, 0x74EC, 0x74CB, 0x74CB, 0x6CAB, 0x648A, 0x646A, 0x5C4A, 0x4C29, 0x4C08, 0x43E8, 0x3BE8, 0x3BC7, 0x33C7, 0x33A7, 0x33A7, 0x2B86, 0x2B86, 0x2B86, 0x2B66, 0x2365, 0x2365, 0x2365, 0x2365, 0x2365, 0x2345, 0x2345, 
        0x2346, 0x2326, 0x2306, 0x22E6, 0x22C6, 0x22A6, 0x2286, 0x2286, 0x2266, 0x2A46, 0x2226, 0x2226, 0x2226, 0x2226, 0x2226, 0x2226, 0x2A46, 0x2A47, 0x2A47, 0x2247, 0x2266, 0x2266, 0x2286, 0x22A7, 0x2AC7, 0x2AE7, 0x2B07, 0x3328, 0x3348,
  0x6CF0, 0x6D10, 0x650F, 0x652F, 0x652F, 0x6D70, 0x7DB1, 0x85D2, 0x7D71, 0x74EF, 0x74CE, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x74EE, 0x7CEE, 0x74CE, 0x74CD, 0x74AD, 0x6C6C, 0x6C6C, 0x74AD, 0x7CEE, 0x7CCE, 0x7CAE, 0x7CAE, 
        0x74AD, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C8D, 0x74AD, 0x74CE, 0x74CE, 0x7CCE, 0x7CEE, 0x7CEE, 0x7CCE, 0x84EE, 0x84EE, 0x850E, 0x8D2F, 0x954F, 0x954F, 0x9D50, 0x9D70, 0x9D70, 0x9D70, 0x9D70, 0x9D50, 0x9D50, 0x9D30, 0x9CEF, 0x9CD0, 0x9CB0, 0x9C70, 
        0x9C50, 0x9C50, 0x940F, 0x83EE, 0x94B2, 0x742F, 0x63EE, 0x7CD1, 0x7D11, 0x7D11, 0x6CAF, 0x6CAF, 0x6C6F, 0x5C0D, 0x5BCB, 0x5BCA, 0x63CA, 0x63E9, 0x6409, 0x6428, 0x6408, 0x6408, 0x63E8, 0x63E8, 0x5BC8, 0x5BC8, 0x53A8, 0x4B68, 0x4348, 0x3B29, 
        0x3B29, 0x3B2A, 0x434C, 0x4B6D, 0x534E, 0x536E, 0x536E, 0x5B8E, 0x538D, 0x4B6C, 0x4B4C, 0x536C, 0x538C, 0x538C, 0x5BAC, 0x5BAC, 0x5BAB, 0x5B8C, 0x5B8C, 0x5B8C, 0x5BAB, 0x5BCB, 0x63CB, 0x6BEB, 0x740B, 0x7C0C, 0x842B, 0x8C6C, 0x948C, 0x948C, 
        0x948C, 0x948C, 0x948C, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x948C, 0x948C, 0x8C8C, 0x8C8C, 0x8C8D, 0x8C8D, 0x948D, 0x8CAE, 0x8C8E, 0x848D, 0x7C4D, 0x742D, 0x73EF, 0x6B91, 0x5B13, 0x5295, 0x4237, 0x39F8, 0x41F9, 0x421A, 
        0x4A5A, 0x4A7A, 0x4A7B, 0x4A7B, 0x4A7B, 0x427A, 0x425A, 0x4279, 0x4259, 0x3A39, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x41D8, 0x41B9, 0x41BA, 0x49DB, 0x49DC, 0x49FC, 0x51FD, 0x51FD, 0x521D, 0x4A1D, 0x4A1D, 
        0x49FD, 0x49FD, 0x41FD, 0x41FD, 0x41DD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x31BD, 0x319D, 0x399D, 0x399D, 0x399C, 0x421D, 0x529D, 0x5AFE, 0x5B3E, 0x5B3D, 0x633E, 0x635E, 0x633E, 0x5B1E, 0x527E, 0x399D, 0x317C, 0x39BD, 0x41FE, 0x421E, 0x423E, 
        0x4A5E, 0x4A7D, 0x4A9D, 0x529E, 0x529E, 0x529E, 0x4A7D, 0x529D, 0x52BE, 0x52DD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52DE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B3E, 0x5B3D, 0x5B3D, 0x633E, 0x635E, 0x6B7E, 0x6B9E, 0x739E, 0x739E, 0x6B9E, 0x739E, 0x739E, 
        0x739E, 0x6B9E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x7BDE, 0x7BDE, 0x73BE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73FE, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73BE, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639D, 0x639D, 0x639E, 0x6B9E, 0x639E, 0x6B9E, 0x637E, 0x637E, 0x635E, 0x5B5E, 0x5B3E, 0x5B1E, 0x5B1D, 0x52FE, 0x52FE, 0x52DD, 0x4ADE, 0x4ADD, 0x4ADD, 0x4ABD, 0x429D, 0x429D, 0x427D, 0x427D, 0x3A5D, 
        0x3A3E, 0x3A3D, 0x3A3D, 0x321D, 0x321D, 0x31FD, 0x29DD, 0x29DD, 0x29DD, 0x29DD, 0x21BD, 0x21BD, 0x21BD, 0x199D, 0x219D, 0x197D, 0x197D, 0x195D, 0x195D, 0x215D, 0x217D, 0x299D, 0x31DD, 0x39FE, 0x421E, 0x4A5E, 0x529D, 0x5A9D, 0x5ABE, 0x5ABE, 
        0x5ABE, 0x5ADD, 0x5ADD, 0x5ADD, 0x5ABD, 0x5A9D, 0x5A9D, 0x5A9D, 0x629D, 0x62BE, 0x6ADE, 0x62BE, 0x629E, 0x5A9D, 0x5A7D, 0x5A7D, 0x629D, 0x627D, 0x623D, 0x5A3C, 0x5A3D, 0x523D, 0x4A3D, 0x4A5D, 0x4A5D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A5D, 
        0x4A5D, 0x4A5D, 0x4A5D, 0x4A3C, 0x4A5C, 0x4A5C, 0x523C, 0x4A5C, 0x525C, 0x4A5C, 0x525C, 0x525C, 0x525C, 0x525C, 0x4A5B, 0x4A5A, 0x4278, 0x4AD7, 0x5BF6, 0x5431, 0x4BEF, 0x43ED, 0x442C, 0x3C6C, 0x3C6B, 0x346B, 0x2C6A, 0x2C8A, 0x2C8A, 0x2C8B, 
        0x2C8B, 0x2C8B, 0x2C6B, 0x2C6B, 0x2C6B, 0x2C4B, 0x2C4B, 0x344B, 0x342C, 0x33EC, 0x33CC, 0x33CC, 0x33CC, 0x3C0C, 0x3C0C, 0x440C, 0x43EC, 0x43CC, 0x43AB, 0x4BAB, 0x4BAC, 0x4B8B, 0x4B8B, 0x4BAB, 0x5C0B, 0x6C6C, 0x748C, 0x7CCC, 0x7CCC, 0x7CCC, 
        0x7CCC, 0x7CCC, 0x7CCC, 0x7CEC, 0x74EC, 0x74CB, 0x74CB, 0x6CAB, 0x648A, 0x644A, 0x5C49, 0x4C29, 0x4C08, 0x43E8, 0x3BE8, 0x3BC8, 0x33A7, 0x33A7, 0x2B87, 0x2B87, 0x2B66, 0x2B66, 0x2366, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 
        0x2346, 0x2326, 0x2306, 0x22E6, 0x22C6, 0x22A7, 0x22A7, 0x2287, 0x2A67, 0x2A46, 0x2A46, 0x2A46, 0x2A26, 0x2226, 0x2226, 0x2226, 0x2226, 0x2A47, 0x2A47, 0x2246, 0x2247, 0x2266, 0x2286, 0x2287, 0x2AC7, 0x2AE7, 0x3307, 0x3328, 0x3348,
  0x6D0F, 0x652F, 0x652F, 0x652F, 0x654E, 0x6D6F, 0x75B0, 0x85F2, 0x7D70, 0x750F, 0x74CE, 0x74CE, 0x74EE, 0x74EE, 0x750E, 0x74EE, 0x74EE, 0x74ED, 0x74ED, 0x74EE, 0x7D0E, 0x74EE, 0x74CD, 0x74AD, 0x6C6C, 0x6C6C, 0x6C8D, 0x7CCE, 0x7CEE, 0x7CAE, 0x7C8D, 
        0x748D, 0x748D, 0x6C8D, 0x6C8D, 0x6C8D, 0x6C8D, 0x74AD, 0x74AE, 0x74CE, 0x74CE, 0x7CEE, 0x7CEE, 0x84EE, 0x84EE, 0x850E, 0x8D2F, 0x954F, 0x952F, 0x9550, 0x9550, 0x9550, 0x954F, 0x9570, 0x9D70, 0x9D50, 0x9D30, 0x9D10, 0x9CD0, 0x9CD0, 0xA4B0, 
        0xA490, 0xA491, 0xA471, 0x9C91, 0x94D1, 0x7C4F, 0x7CD1, 0x7D31, 0x7D51, 0x7530, 0x6CCF, 0x648F, 0x5C0C, 0x53CB, 0x5BCA, 0x5BE9, 0x5BE9, 0x63E9, 0x63E8, 0x6409, 0x6408, 0x5BE8, 0x5BE8, 0x5BC8, 0x5BC8, 0x53A7, 0x4B87, 0x4B67, 0x4347, 0x3B27, 
        0x3B28, 0x3308, 0x3B29, 0x432B, 0x434C, 0x4B4D, 0x4B4D, 0x534D, 0x534E, 0x4B2D, 0x4B0C, 0x4AEC, 0x4B0C, 0x532C, 0x532C, 0x4B4C, 0x4B6C, 0x538C, 0x538C, 0x53AC, 0x53AC, 0x53CB, 0x53CB, 0x5BEB, 0x63EB, 0x6BEB, 0x73EB, 0x740B, 0x842B, 0x844C, 
        0x8C4C, 0x8C4C, 0x946C, 0x946C, 0x948C, 0x946C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948D, 0x948D, 0x946D, 0x8C6D, 0x8C6D, 0x846D, 0x7C4C, 0x7C2C, 0x740C, 0x6BCE, 0x638F, 0x6352, 0x52F4, 0x4A95, 0x4236, 0x39F8, 
        0x39F8, 0x4219, 0x4239, 0x425A, 0x425A, 0x425A, 0x423A, 0x4259, 0x3A39, 0x3A39, 0x3A39, 0x3A38, 0x3A18, 0x3A18, 0x3A18, 0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x39D8, 0x41B8, 0x41B9, 0x49BA, 0x49DB, 0x51FC, 0x49FD, 0x521D, 0x49FD, 0x521D, 0x521D, 
        0x4A1D, 0x49FD, 0x41FD, 0x41FD, 0x41DD, 0x41BD, 0x39BD, 0x39BD, 0x39BE, 0x39BD, 0x319D, 0x399D, 0x319D, 0x317D, 0x317D, 0x39BD, 0x423D, 0x52BD, 0x5B1E, 0x5B3E, 0x633E, 0x5B3E, 0x633E, 0x5B3E, 0x52DE, 0x4A3D, 0x39BC, 0x39DD, 0x421E, 0x421D, 
        0x423E, 0x4A7D, 0x4A7D, 0x529E, 0x529E, 0x529E, 0x529D, 0x4A9D, 0x529D, 0x52BD, 0x52DE, 0x52FE, 0x5AFE, 0x5AFE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B3D, 0x5B1D, 0x5B3D, 0x5B3D, 0x633E, 0x635E, 0x6B9E, 0x739E, 0x739E, 0x6B9E, 0x6B9E, 0x739E, 
        0x73BE, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BBE, 0x7BBE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x7BFE, 0x7BFE, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9D, 0x6B9E, 0x639E, 0x637E, 0x637E, 0x635E, 0x635D, 0x5B5E, 0x5B3E, 0x5B3E, 0x52FD, 0x52FD, 0x52DD, 0x52DD, 0x4ADD, 0x4ABD, 0x4ABD, 0x4A9D, 0x4A9D, 0x427D, 0x425D, 0x425D, 0x3A5D, 
        0x3A3D, 0x3A3D, 0x3A1D, 0x321D, 0x31FD, 0x31DD, 0x29DD, 0x29DD, 0x21DD, 0x21DD, 0x21BD, 0x21BD, 0x21BD, 0x219D, 0x219D, 0x217D, 0x219D, 0x217D, 0x299D, 0x39FD, 0x423D, 0x4A5D, 0x4A5D, 0x527D, 0x527D, 0x527D, 0x5A9D, 0x5A9D, 0x5ABE, 0x62DE, 
        0x62DE, 0x62DE, 0x62DD, 0x62DE, 0x62BD, 0x629D, 0x5A5D, 0x625D, 0x51FB, 0x4179, 0x4179, 0x5A1C, 0x629E, 0x629D, 0x627D, 0x5A7E, 0x5A7D, 0x523D, 0x523C, 0x523D, 0x4A3D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x425D, 
        0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5C, 0x4A5C, 0x525C, 0x525C, 0x525C, 0x4A5C, 0x4A5B, 0x4A7A, 0x4AD8, 0x63F7, 0x6C96, 0x5C73, 0x4C30, 0x3C4D, 0x344B, 0x344B, 0x344B, 0x2C6A, 0x2C6A, 0x2C6A, 
        0x2C8A, 0x2C8A, 0x2C8A, 0x2C8A, 0x2C8A, 0x246A, 0x246A, 0x246A, 0x244A, 0x2C2A, 0x242A, 0x240B, 0x2C0B, 0x342B, 0x342B, 0x342B, 0x3C2C, 0x3C0C, 0x3BCC, 0x3BAC, 0x3B6B, 0x3B6B, 0x3B8C, 0x43CC, 0x4BEC, 0x5C2C, 0x6C4C, 0x748C, 0x74AC, 0x7CAC, 
        0x7CCC, 0x7CCC, 0x7CCC, 0x74EC, 0x74CC, 0x74CB, 0x6CCB, 0x6CAB, 0x648A, 0x5C6A, 0x5449, 0x5429, 0x4C09, 0x43E8, 0x3BC8, 0x3BA8, 0x3387, 0x3387, 0x2B66, 0x2B46, 0x2B46, 0x2326, 0x2326, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2346, 
        0x2346, 0x2326, 0x2306, 0x22E6, 0x2AC6, 0x2AA7, 0x2AA7, 0x2A87, 0x2A87, 0x2A67, 0x2A46, 0x2A46, 0x2A47, 0x2A26, 0x2A26, 0x2A27, 0x2A27, 0x2A27, 0x2226, 0x2226, 0x2A27, 0x2246, 0x2266, 0x2A86, 0x2AC7, 0x2AE7, 0x3307, 0x3328, 0x3368,
  0x6D0F, 0x652F, 0x652E, 0x5D2E, 0x654E, 0x6D8F, 0x75D0, 0x85F2, 0x7D70, 0x750E, 0x74CE, 0x74CE, 0x74CD, 0x74ED, 0x74EE, 0x74ED, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x74CD, 0x74CD, 0x6CAD, 0x6C6C, 0x6C8D, 0x74CE, 0x7CCE, 0x7CAE, 0x7CAE, 
        0x748D, 0x74AD, 0x748D, 0x6C8D, 0x6C8D, 0x6C8D, 0x6C8D, 0x74AD, 0x74AE, 0x74CE, 0x7CEE, 0x7CEE, 0x84EE, 0x850E, 0x8D0F, 0x8D2F, 0x952F, 0x952F, 0x952F, 0x952F, 0x954F, 0x9550, 0x9D70, 0x9D70, 0x9D4F, 0x9D30, 0x9D10, 0x9CF0, 0x9CD0, 0xA4D1, 
        0xACD1, 0xACD1, 0xACD1, 0xA4D1, 0x94D1, 0x84B0, 0x7D31, 0x7D51, 0x6D50, 0x64EF, 0x64CF, 0x5C4D, 0x53EB, 0x53EA, 0x53E9, 0x5BE9, 0x5BE9, 0x5C09, 0x5C08, 0x63E8, 0x63E8, 0x5BE8, 0x5BC8, 0x5BC8, 0x53C7, 0x53A8, 0x4B87, 0x4367, 0x4367, 0x3B47, 
        0x3327, 0x2B07, 0x2B08, 0x3309, 0x3B2A, 0x432B, 0x434C, 0x4B4D, 0x4B2E, 0x530E, 0x4AED, 0x4ACD, 0x4ACC, 0x4ACC, 0x4ACC, 0x42EC, 0x4B4C, 0x4B6C, 0x4B8C, 0x4BAC, 0x4BAC, 0x4BCB, 0x4BEB, 0x53EB, 0x5BEB, 0x5BEB, 0x63CA, 0x63CA, 0x73EB, 0x740B, 
        0x7C0B, 0x83EB, 0x8C2B, 0x8C4C, 0x946C, 0x946C, 0x946C, 0x946C, 0x948D, 0x948D, 0x948D, 0x948C, 0x948D, 0x948D, 0x946D, 0x946D, 0x8C6D, 0x8C2C, 0x842C, 0x7C2C, 0x7C2C, 0x740B, 0x73EB, 0x6BEC, 0x63EC, 0x63CE, 0x638F, 0x5B71, 0x52F4, 0x4A56, 
        0x39F6, 0x39D7, 0x39F8, 0x39F8, 0x3A19, 0x39F9, 0x3A19, 0x3A39, 0x3A39, 0x3A18, 0x3A18, 0x3A18, 0x3A18, 0x3218, 0x31F7, 0x31F7, 0x31D7, 0x31D7, 0x31D7, 0x39D7, 0x39B8, 0x41B9, 0x41BA, 0x49DB, 0x49FC, 0x51FC, 0x51FD, 0x521D, 0x521D, 0x4A1D, 
        0x4A1D, 0x4A1D, 0x49FD, 0x41FD, 0x41DD, 0x41DD, 0x41BD, 0x39BD, 0x39BD, 0x39BD, 0x31BD, 0x399D, 0x399D, 0x317D, 0x317D, 0x317D, 0x317D, 0x39BD, 0x4A7D, 0x5AFE, 0x5B1E, 0x633E, 0x633E, 0x633D, 0x5B3E, 0x5AFE, 0x529E, 0x39DC, 0x39FD, 0x421D, 
        0x423D, 0x4A5D, 0x4A7D, 0x4A7D, 0x529E, 0x529E, 0x52BE, 0x52BD, 0x52BD, 0x52BE, 0x52DE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B1D, 0x5B3D, 0x5B1D, 0x633E, 0x635E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 
        0x73BE, 0x73BE, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x73DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x7C1E, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBE, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x639E, 0x639E, 0x637E, 0x637E, 0x635E, 0x635E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52FD, 0x52DE, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4A9D, 0x4A9D, 0x427D, 0x427D, 0x425D, 0x3A5D, 0x3A3D, 
        0x3A3D, 0x3A1D, 0x3A1D, 0x31FD, 0x31DD, 0x31DD, 0x29DD, 0x29DD, 0x29DD, 0x29BD, 0x21BD, 0x21BD, 0x21BD, 0x299D, 0x299D, 0x29BD, 0x31FD, 0x421E, 0x4A5E, 0x529E, 0x5ADD, 0x62FE, 0x62DD, 0x62BD, 0x5ABD, 0x5ABD, 0x5ABD, 0x62BD, 0x62BD, 0x62DE, 
        0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x62BE, 0x629D, 0x627D, 0x6A7E, 0x625D, 0x497A, 0x30B7, 0x30B7, 0x3959, 0x49FB, 0x521C, 0x521C, 0x521C, 0x521D, 0x4A1D, 0x4A3D, 0x4A3D, 0x423D, 0x423D, 0x423D, 0x423D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x425D, 
        0x425D, 0x425D, 0x425D, 0x423D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A3C, 0x4A3C, 0x4A5C, 0x4A5B, 0x4AB9, 0x5B79, 0x6C39, 0x6C77, 0x5C93, 0x444F, 0x3C2C, 0x342B, 0x344B, 0x2C4A, 0x2C6A, 
        0x2C8A, 0x2C8A, 0x2C8A, 0x2C8A, 0x2469, 0x2449, 0x2449, 0x2449, 0x2449, 0x244A, 0x244A, 0x242A, 0x242A, 0x2C2A, 0x2C4B, 0x344B, 0x342B, 0x340C, 0x33EC, 0x3BCC, 0x3B8C, 0x336B, 0x336B, 0x3BCD, 0x440C, 0x542C, 0x5C2C, 0x5C2C, 0x644B, 0x6C6C, 
        0x748C, 0x74AC, 0x74CC, 0x74CB, 0x6CCB, 0x6CCC, 0x6CAB, 0x6C8B, 0x648A, 0x5C4A, 0x5429, 0x4C09, 0x4BE8, 0x43E8, 0x43C8, 0x3BA8, 0x3387, 0x2B67, 0x2B46, 0x2B26, 0x2326, 0x2305, 0x2305, 0x2325, 0x2325, 0x2325, 0x2325, 0x2345, 0x2325, 0x2346, 
        0x2346, 0x2326, 0x2B06, 0x2B06, 0x2AE6, 0x2AC7, 0x2AA7, 0x2AA7, 0x2A87, 0x2A67, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A26, 0x2A26, 0x2226, 0x2226, 0x2226, 0x2226, 0x2246, 0x2266, 0x2A86, 0x2AC7, 0x2AE7, 0x3307, 0x3328, 0x3368,
  0x650F, 0x652F, 0x5D2E, 0x5D2E, 0x656E, 0x6D8F, 0x75D0, 0x85F2, 0x7D90, 0x74EE, 0x74CE, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74EE, 0x74CE, 0x6CAD, 0x6C8C, 0x6C8D, 0x74CE, 0x7CCE, 0x748E, 0x7CAE, 
        0x7CAE, 0x7CAE, 0x748D, 0x748D, 0x6C6D, 0x748D, 0x748D, 0x74AD, 0x74AE, 0x74CE, 0x7CEE, 0x7D0E, 0x84EE, 0x84EE, 0x850E, 0x8D2F, 0x954F, 0x952F, 0x952F, 0x952F, 0x9D2F, 0x9D50, 0x9D70, 0x9D50, 0x952F, 0x952F, 0x9D0F, 0x9CF0, 0x9CD0, 0xA4D0, 
        0xACD1, 0xA4D1, 0xACD1, 0xA4F1, 0x9D11, 0x84F0, 0x7D50, 0x7550, 0x652F, 0x5CEE, 0x5C6D, 0x4BEB, 0x4BCA, 0x4BC9, 0x53E9, 0x5BE9, 0x5C08, 0x5C08, 0x5BE8, 0x5BE8, 0x5BE8, 0x5BE8, 0x5BC7, 0x53C7, 0x53A7, 0x4BA7, 0x4B87, 0x4367, 0x4347, 0x3B47, 
        0x3326, 0x2B06, 0x2B07, 0x2B08, 0x3329, 0x3B2A, 0x434B, 0x432C, 0x4B2D, 0x4B0D, 0x4ACD, 0x4AAD, 0x4A8D, 0x4A8D, 0x428D, 0x42CD, 0x4B0D, 0x4B4D, 0x4B8D, 0x4B8C, 0x4BAB, 0x4BAB, 0x43CB, 0x4BCB, 0x53CB, 0x53CB, 0x53CB, 0x5BCA, 0x63CB, 0x63CB, 
        0x6BCB, 0x6BAA, 0x73EB, 0x840B, 0x842B, 0x842C, 0x8C2C, 0x8C4C, 0x8C4C, 0x8C6C, 0x8C6C, 0x8C8C, 0x8C8D, 0x8C6D, 0x8C6C, 0x844C, 0x842C, 0x7C0C, 0x740B, 0x740B, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEB, 0x640B, 0x640B, 0x640C, 0x63CE, 0x6390, 0x5B33, 
        0x52B5, 0x4255, 0x39F6, 0x39D6, 0x31B7, 0x31B7, 0x31D8, 0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x31F8, 0x31F8, 0x31F7, 0x31F7, 0x31F7, 0x31D7, 0x31D7, 0x31D7, 0x39B7, 0x39B8, 0x41B8, 0x41D9, 0x49DB, 0x49DB, 0x51FC, 0x51FD, 0x521D, 0x521D, 0x4A1D, 
        0x4A1D, 0x4A1D, 0x49FD, 0x41FD, 0x41FD, 0x41DD, 0x39DD, 0x39DD, 0x39DD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x319D, 0x319D, 0x317D, 0x317D, 0x317D, 0x319C, 0x4A5D, 0x5ADE, 0x5B1E, 0x633E, 0x633E, 0x635E, 0x633E, 0x5B1E, 0x52DE, 0x423D, 0x41FD, 
        0x421D, 0x423D, 0x4A5D, 0x4A5D, 0x4A7E, 0x529E, 0x52DE, 0x52BE, 0x52BE, 0x52DE, 0x52DE, 0x52FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 
        0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x73DE, 0x73DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7C1E, 0x7C1E, 0x7C1E, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x6BBD, 
        0x6BBE, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x639E, 0x637E, 0x637E, 0x637E, 0x635E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B3E, 0x5B1E, 0x5B1E, 0x52FD, 0x52BE, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A7D, 0x4A7D, 0x427D, 0x425D, 0x425D, 0x425D, 0x3A3D, 
        0x3A1D, 0x3A1D, 0x3A1D, 0x31FD, 0x31DD, 0x31DD, 0x31BD, 0x29DD, 0x29DD, 0x29BD, 0x29BD, 0x29DD, 0x29DD, 0x31FD, 0x3A1D, 0x4A5D, 0x529E, 0x5ABE, 0x62FE, 0x6B1E, 0x6B3D, 0x733E, 0x733E, 0x6B1E, 0x6AFE, 0x62FD, 0x62DD, 0x62DE, 0x62DD, 0x62DD, 
        0x62DD, 0x5ADD, 0x5ABD, 0x62DE, 0x62DE, 0x6ABE, 0x6ABE, 0x6A9E, 0x6A7E, 0x6A3D, 0x519B, 0x4139, 0x499A, 0x5A3D, 0x525D, 0x523D, 0x4A3D, 0x4A1D, 0x4A1D, 0x421D, 0x423D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A5D, 0x425D, 
        0x425D, 0x425D, 0x425D, 0x3A3D, 0x3A3D, 0x3A3D, 0x423D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5C, 0x4A5C, 0x4A5C, 0x4A5C, 0x529A, 0x5B1B, 0x6BDC, 0x6C38, 0x6476, 0x5C73, 0x442E, 0x340C, 0x342A, 0x2C6A, 
        0x2C8A, 0x2C8A, 0x2C8A, 0x246A, 0x2469, 0x2469, 0x2469, 0x2469, 0x2469, 0x2449, 0x2449, 0x2449, 0x2449, 0x244A, 0x244A, 0x2C4A, 0x2C4A, 0x2C2A, 0x2C2B, 0x340B, 0x33CC, 0x2BAB, 0x2B8B, 0x33EC, 0x3C2C, 0x4C2D, 0x542C, 0x542C, 0x5C0C, 0x642C, 
        0x6C6C, 0x748C, 0x74AC, 0x6CAC, 0x6CAC, 0x6CAB, 0x6C8B, 0x648A, 0x646A, 0x5C49, 0x5429, 0x4C09, 0x4BE9, 0x43C8, 0x3BA8, 0x3B88, 0x3367, 0x2B67, 0x2B46, 0x2B26, 0x2306, 0x2305, 0x2305, 0x2305, 0x2305, 0x2325, 0x2325, 0x2345, 0x2345, 0x2346, 
        0x2346, 0x2B46, 0x2B26, 0x2B07, 0x2AE7, 0x2AC7, 0x2AC7, 0x2AA7, 0x3287, 0x3287, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A27, 0x2A27, 0x2A27, 0x2226, 0x2206, 0x2206, 0x2226, 0x2246, 0x2266, 0x2A86, 0x2AC7, 0x2AE7, 0x3307, 0x3328, 0x3368,
  0x650E, 0x652E, 0x5D2E, 0x654E, 0x656E, 0x6DAF, 0x75D0, 0x8612, 0x7D90, 0x74CE, 0x74AD, 0x74CD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74EE, 0x74CE, 0x6CAD, 0x6C8D, 0x74AD, 0x7CCE, 0x7C8E, 0x7CAE, 
        0x7CCE, 0x7C8E, 0x746D, 0x746D, 0x6C6D, 0x748D, 0x748D, 0x74AD, 0x74AE, 0x74CE, 0x7CEE, 0x7D0E, 0x850E, 0x84EE, 0x850F, 0x8D2F, 0x8D2F, 0x952F, 0x952F, 0x9D2F, 0x9D2F, 0x954F, 0x9D50, 0x9D4F, 0x952F, 0x952F, 0x9D0F, 0x9CF0, 0x9CD0, 0xA4D0, 
        0xA4B0, 0xA4D0, 0xACF0, 0xAD11, 0xA531, 0x84CF, 0x7D30, 0x6D2F, 0x650E, 0x5CCD, 0x544B, 0x53EA, 0x53C9, 0x53E9, 0x53E8, 0x5C08, 0x5C08, 0x5C08, 0x5BE8, 0x5BE8, 0x5BE8, 0x5BE8, 0x5BC7, 0x53C7, 0x53A7, 0x4B87, 0x4367, 0x4347, 0x3B47, 0x3B47, 
        0x3326, 0x3326, 0x2B27, 0x2B07, 0x3328, 0x3B49, 0x3B69, 0x434B, 0x432C, 0x4B0D, 0x4ACD, 0x4AAD, 0x4A6D, 0x426D, 0x426D, 0x42CE, 0x4B2E, 0x4B6E, 0x4B8D, 0x4B8C, 0x4B8B, 0x4B8B, 0x438A, 0x438A, 0x4BAA, 0x4BCA, 0x53CB, 0x5BCB, 0x5BCB, 0x5BAB, 
        0x63AB, 0x63AB, 0x6BAB, 0x73CB, 0x7BEB, 0x7BEB, 0x83EB, 0x840B, 0x840B, 0x840B, 0x842B, 0x844C, 0x844C, 0x844C, 0x7C4C, 0x7C2C, 0x740B, 0x740B, 0x6C0B, 0x63EA, 0x63C9, 0x63CA, 0x63EA, 0x63EA, 0x640B, 0x642B, 0x6C2B, 0x6C2C, 0x6C0D, 0x6BAF, 
        0x6370, 0x5B32, 0x52F4, 0x4A95, 0x39F5, 0x31B6, 0x31B6, 0x3196, 0x31B6, 0x31B6, 0x31D7, 0x31D7, 0x31D7, 0x31D7, 0x31D7, 0x31D7, 0x31D7, 0x31B7, 0x31B7, 0x31B7, 0x39B7, 0x39B8, 0x41D9, 0x49DA, 0x49DB, 0x49FC, 0x51FC, 0x521D, 0x521D, 0x521D, 
        0x521D, 0x4A1D, 0x4A1D, 0x4A1D, 0x41FD, 0x41FD, 0x41DD, 0x41DD, 0x41DD, 0x39DD, 0x39BD, 0x39BD, 0x39BD, 0x319D, 0x319D, 0x319D, 0x317D, 0x317D, 0x317D, 0x319C, 0x421D, 0x52BE, 0x5B1E, 0x5B3E, 0x633E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5AFE, 0x529D, 
        0x423D, 0x423D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A9D, 0x52BE, 0x52DE, 0x52BE, 0x52DE, 0x52DE, 0x52FE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B3E, 0x5B3E, 0x633E, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x6B7E, 0x6B9E, 0x739E, 0x739E, 0x739E, 
        0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BDE, 0x7BFE, 0x7C1E, 0x7BFE, 0x7BDE, 0x73DE, 0x7BFE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x6BBD, 0x6BBD, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x637E, 0x637E, 0x637E, 0x635E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5AFE, 0x52FE, 0x52DD, 0x4ABE, 0x4A9D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A7D, 0x427D, 0x425D, 0x423D, 0x423D, 0x3A1D, 
        0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31FD, 0x3A1D, 0x423E, 0x4A5D, 0x529E, 0x5ABE, 0x62FD, 0x6AFD, 0x731E, 0x733E, 0x733E, 0x735E, 0x735E, 0x733D, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x62DE, 0x5ABD, 
        0x5ABE, 0x5ABE, 0x62DE, 0x62DE, 0x6AFE, 0x6AFE, 0x72FE, 0x6ABE, 0x625D, 0x623D, 0x59FD, 0x59DC, 0x5A1D, 0x523D, 0x4A3D, 0x4A3D, 0x4A3D, 0x423D, 0x423D, 0x423D, 0x423D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x425D, 
        0x425D, 0x425D, 0x425D, 0x423D, 0x3A3D, 0x3A3D, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525C, 0x525C, 0x62FD, 0x6B7C, 0x6BDC, 0x6C39, 0x6476, 0x5473, 0x3C2D, 0x344B, 
        0x2C4A, 0x2C6A, 0x2C6A, 0x246A, 0x2469, 0x2469, 0x2469, 0x2469, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x1C69, 0x2469, 0x2469, 0x2469, 0x2469, 0x244A, 0x244A, 0x2C2A, 0x2C0B, 0x2BEB, 0x2BEB, 0x340B, 0x342B, 0x3C4C, 0x444C, 0x442C, 0x4C2C, 0x540C, 
        0x5BEC, 0x642C, 0x644B, 0x646B, 0x6C8B, 0x6C8B, 0x648B, 0x646A, 0x5C6A, 0x5C49, 0x5429, 0x4BE9, 0x4BC9, 0x43C8, 0x3BA8, 0x3387, 0x3367, 0x2B46, 0x2B26, 0x2B06, 0x2306, 0x22E5, 0x22E5, 0x2305, 0x2305, 0x2325, 0x2345, 0x2345, 0x2346, 0x2B46, 
        0x2B46, 0x2B46, 0x2B26, 0x2B07, 0x3307, 0x32E7, 0x32C7, 0x32C7, 0x32A7, 0x3287, 0x2A67, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x2A26, 0x2A26, 0x2226, 0x2206, 0x2206, 0x2226, 0x2246, 0x2266, 0x2A86, 0x2AC7, 0x2AE7, 0x3307, 0x3348, 0x3B68,
  0x650D, 0x652D, 0x5D4D, 0x656D, 0x658E, 0x6DAE, 0x7DD1, 0x85F2, 0x7D70, 0x6CCE, 0x6CAD, 0x74AE, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x7CEE, 0x74AD, 0x6C8C, 0x74AD, 0x7CAE, 0x7C8D, 0x84AE, 
        0x84AE, 0x746D, 0x6C4D, 0x6C4D, 0x6C4D, 0x6C6D, 0x748D, 0x74AD, 0x74AD, 0x74CE, 0x7CEE, 0x850E, 0x850E, 0x850E, 0x850F, 0x8D2F, 0x8D2F, 0x950F, 0x950F, 0x950F, 0x9D2F, 0x9D30, 0x9D50, 0x9D4F, 0x952F, 0x9D2F, 0x9D0F, 0x9CF0, 0xA4F0, 0xA4F0, 
        0xA4CF, 0xAD10, 0xB531, 0xB552, 0xA552, 0x84EF, 0x7D30, 0x6D0F, 0x650E, 0x544C, 0x542B, 0x540A, 0x53E9, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x53E8, 0x5BE8, 0x5BE8, 0x53C7, 0x53A7, 0x53A7, 0x4B87, 0x4B67, 0x4366, 0x4346, 0x3B46, 0x3B46, 
        0x3B47, 0x3347, 0x3347, 0x3347, 0x3347, 0x3368, 0x3B69, 0x3B69, 0x436A, 0x432C, 0x42EC, 0x42AD, 0x3A6D, 0x3A6C, 0x3A8D, 0x42EE, 0x4B4E, 0x538E, 0x53AD, 0x53AC, 0x4B8B, 0x4B8A, 0x4B8A, 0x4B8A, 0x53AA, 0x53CB, 0x5BCB, 0x5BEB, 0x63EC, 0x63EC, 
        0x63EC, 0x6C0C, 0x6BEC, 0x73CB, 0x73CB, 0x73CB, 0x73CB, 0x73CA, 0x6BAA, 0x6BAA, 0x73CB, 0x7C2C, 0x7C2C, 0x7C2C, 0x742C, 0x740B, 0x6C0B, 0x6C0B, 0x63EA, 0x5BEA, 0x53C9, 0x53C9, 0x5BE9, 0x5BEA, 0x5BEA, 0x640A, 0x642B, 0x6C2B, 0x742C, 0x6C0C, 
        0x6BED, 0x6BAE, 0x6390, 0x6351, 0x5B13, 0x4AB4, 0x4235, 0x31D5, 0x3195, 0x3195, 0x2995, 0x2996, 0x2996, 0x2996, 0x31B6, 0x29B6, 0x29B6, 0x29B6, 0x29B6, 0x29B6, 0x31B6, 0x39B7, 0x41D8, 0x49DA, 0x49DB, 0x49DB, 0x51FC, 0x521C, 0x4A1D, 0x521D, 
        0x4A1D, 0x4A1D, 0x4A1D, 0x4A1D, 0x4A1D, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x31BD, 0x31BD, 0x319D, 0x319D, 0x317D, 0x297D, 0x317D, 0x317C, 0x39FC, 0x4ABD, 0x5B1E, 0x5B3E, 0x5B5E, 0x635E, 0x5B3E, 0x633E, 0x5B1E, 
        0x52BE, 0x4A7D, 0x425D, 0x4A5D, 0x4A5D, 0x4A7D, 0x52BE, 0x52DE, 0x52BD, 0x52BD, 0x52DD, 0x52FE, 0x5AFD, 0x5B1D, 0x5B1E, 0x5B1D, 0x5AFD, 0x5B1D, 0x5B3D, 0x5B3E, 0x633D, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x6B7E, 0x6B7E, 0x6B7E, 0x739E, 0x739E, 
        0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x7BDE, 0x7BFE, 0x7BFE, 0x7BFE, 0x73DE, 0x73DE, 0x7BFE, 0x7BFE, 0x73FE, 0x73FE, 0x73FE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x6BBE, 0x6BBE, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x637E, 0x637E, 0x637E, 0x635E, 0x635E, 0x5B3E, 0x5B1D, 0x5B1E, 0x5AFE, 0x5AFD, 0x5AFD, 0x52FD, 0x4ABD, 0x4A9E, 0x4A9E, 0x4A7E, 0x427D, 0x427D, 0x427D, 0x427D, 0x425D, 0x423D, 0x423D, 0x421D, 0x3A1D, 
        0x3A1D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x41FE, 0x421E, 0x4A3E, 0x4A3D, 0x4A5E, 0x525E, 0x5A9E, 0x5A9E, 0x62BE, 0x6ADE, 0x72FD, 0x731E, 0x7B3E, 0x7B3E, 0x731E, 0x731D, 0x731D, 0x731E, 0x731E, 0x6AFE, 0x62BE, 0x5A7D, 0x523C, 0x4A1C, 
        0x4A3C, 0x525D, 0x5A9D, 0x62FE, 0x6AFE, 0x6AFE, 0x6AFE, 0x629D, 0x623D, 0x5A3D, 0x521D, 0x521D, 0x4A1D, 0x4A1D, 0x423D, 0x423D, 0x423D, 0x423D, 0x423D, 0x425D, 0x3A5D, 0x3A5E, 0x3A5E, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 
        0x425D, 0x3A5D, 0x3A5D, 0x423D, 0x423D, 0x423D, 0x423D, 0x425D, 0x423D, 0x423D, 0x425D, 0x425D, 0x423D, 0x423D, 0x423D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525D, 0x523D, 0x525C, 0x527C, 0x5ADC, 0x633C, 0x6BBC, 0x6C39, 0x6475, 0x3C2E, 
        0x2C0B, 0x2C2A, 0x2429, 0x244A, 0x244A, 0x2449, 0x2469, 0x2C6A, 0x2469, 0x1C49, 0x1C48, 0x1C48, 0x1C48, 0x1C49, 0x1C69, 0x1C49, 0x2469, 0x2469, 0x2449, 0x2449, 0x2449, 0x2429, 0x242A, 0x244A, 0x2C4A, 0x344C, 0x3C4C, 0x3C4C, 0x3C2C, 0x43EC, 
        0x43AB, 0x4B8B, 0x53CB, 0x5BEB, 0x646B, 0x646B, 0x646B, 0x646A, 0x5C4A, 0x5429, 0x5409, 0x4BE9, 0x4BC8, 0x43A8, 0x3B88, 0x3B68, 0x3367, 0x3347, 0x2B26, 0x2B06, 0x22E6, 0x22E6, 0x22E6, 0x2305, 0x2305, 0x2B25, 0x2B46, 0x2B46, 0x2B46, 0x2B66, 
        0x2B66, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E7, 0x32C7, 0x32C7, 0x32A7, 0x3287, 0x2A67, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A26, 0x2A26, 0x2206, 0x2206, 0x2206, 0x2226, 0x2246, 0x2A67, 0x2A87, 0x2AC7, 0x32E7, 0x3308, 0x3328, 0x3B68,
  0x64ED, 0x5D2D, 0x5D4D, 0x656D, 0x658D, 0x6D8E, 0x7DD0, 0x85F2, 0x7D50, 0x74CE, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x6CCD, 0x6CAD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74CD, 0x74AD, 0x6C8D, 0x748D, 0x7CAE, 0x7C6D, 0x84CF, 
        0x84AE, 0x744D, 0x6C4D, 0x6C4D, 0x6C2D, 0x6C4D, 0x6C6D, 0x748D, 0x74AD, 0x74AE, 0x7CEE, 0x7D0F, 0x84EE, 0x850E, 0x852F, 0x8D2F, 0x8D0F, 0x950F, 0x950F, 0x9D30, 0x9D50, 0xA570, 0x9D50, 0x9D4F, 0x952F, 0x9D2F, 0x9D2F, 0xA530, 0xAD10, 0xAD10, 
        0xAD10, 0xB551, 0xB552, 0xB552, 0x9D11, 0x7CCF, 0x752F, 0x6D0F, 0x6CEE, 0x648D, 0x5C2B, 0x5C2A, 0x53E9, 0x53E8, 0x53E8, 0x53E8, 0x53E7, 0x53E7, 0x53E7, 0x53E8, 0x53C7, 0x4BA7, 0x4BA7, 0x4BA7, 0x4B86, 0x4366, 0x4366, 0x4346, 0x3B46, 0x3B46, 
        0x3B46, 0x3347, 0x3347, 0x3347, 0x3367, 0x3368, 0x3B88, 0x3BA9, 0x43A9, 0x436B, 0x432B, 0x3AAB, 0x3A6C, 0x326C, 0x3AAD, 0x42ED, 0x4B4E, 0x538D, 0x53AD, 0x53CB, 0x53AA, 0x53AA, 0x4BAA, 0x53AA, 0x53AA, 0x5BAB, 0x5BAB, 0x63AB, 0x63EC, 0x63EC, 
        0x6C0C, 0x744D, 0x7C6D, 0x7C6D, 0x7C4D, 0x744C, 0x740C, 0x6C0C, 0x6BCB, 0x6BCB, 0x6BEB, 0x7C2C, 0x7C2C, 0x742C, 0x742C, 0x6C0B, 0x640B, 0x5C0B, 0x5BEA, 0x53E9, 0x53E9, 0x53E9, 0x5BE9, 0x5C0A, 0x640A, 0x642A, 0x642B, 0x6C2B, 0x742B, 0x742C, 
        0x6C0C, 0x6BEC, 0x6BED, 0x6BCE, 0x638F, 0x6371, 0x5B32, 0x5AF3, 0x52B5, 0x4A75, 0x4235, 0x39D5, 0x2994, 0x2974, 0x2974, 0x2975, 0x2975, 0x2995, 0x2995, 0x2995, 0x2995, 0x3196, 0x39B7, 0x49D9, 0x49BA, 0x49DB, 0x51FC, 0x51FC, 0x521D, 0x521D, 
        0x521D, 0x521D, 0x4A3D, 0x4A1D, 0x4A1E, 0x4A1D, 0x4A1E, 0x421D, 0x41FD, 0x41FD, 0x39FD, 0x39FD, 0x39DD, 0x39DD, 0x31BD, 0x31BD, 0x319D, 0x319D, 0x299D, 0x317D, 0x297D, 0x297C, 0x31BC, 0x4A7D, 0x531E, 0x5B3E, 0x5B5E, 0x5B5E, 0x635E, 0x5B3E, 
        0x5B1E, 0x52DE, 0x4A9D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A9E, 0x52BE, 0x52BD, 0x52BD, 0x52DD, 0x52FE, 0x5AFE, 0x5AFE, 0x5B1E, 0x52FD, 0x5AFD, 0x5B1D, 0x5B1E, 0x5B3E, 0x5B3E, 0x633E, 0x635E, 0x635E, 0x635E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x739E, 
        0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x7BDE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x7BDE, 0x7BDE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x6B9E, 0x6B9E, 
        0x6B9E, 0x6B7E, 0x637E, 0x635E, 0x635E, 0x635E, 0x633E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5AFD, 0x5AFE, 0x52FD, 0x52DD, 0x52DD, 0x4ABD, 0x4A9E, 0x4A7D, 0x4A7D, 0x425D, 0x425D, 0x425D, 0x425D, 0x423D, 0x423D, 0x423D, 0x421D, 0x421D, 
        0x3A1D, 0x3A1D, 0x421D, 0x421D, 0x421D, 0x4A3E, 0x525E, 0x525E, 0x5A7E, 0x5A9E, 0x5A9E, 0x62BD, 0x62BD, 0x6ADD, 0x6ADE, 0x72DD, 0x72DD, 0x7AFD, 0x7B1E, 0x7AFD, 0x72BD, 0x72DD, 0x6ADD, 0x6AFE, 0x6ADE, 0x5A7D, 0x523D, 0x523D, 0x523D, 0x523D, 
        0x523D, 0x521D, 0x523D, 0x5A9D, 0x6B1E, 0x731E, 0x6ADE, 0x627D, 0x5A3D, 0x523D, 0x41FD, 0x41FD, 0x41FD, 0x421D, 0x423D, 0x423E, 0x425D, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x3A5D, 0x3A5D, 0x425D, 
        0x425D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525D, 0x525D, 0x525C, 0x525C, 0x525C, 0x527C, 0x5B3B, 0x6C1A, 0x5C94, 
        0x340C, 0x2409, 0x2429, 0x242A, 0x242A, 0x2449, 0x2C6A, 0x2C8A, 0x246A, 0x1C49, 0x1C48, 0x1C48, 0x1448, 0x1448, 0x1C68, 0x1C68, 0x1C69, 0x1C69, 0x2449, 0x2449, 0x2449, 0x2449, 0x2449, 0x2449, 0x244A, 0x2C6B, 0x346B, 0x344C, 0x342C, 0x3BEC, 
        0x3B8C, 0x434C, 0x434C, 0x4B4B, 0x53EB, 0x644B, 0x644B, 0x5C4A, 0x5C29, 0x5409, 0x4BE9, 0x4BC8, 0x43A8, 0x43A8, 0x3B88, 0x3B68, 0x3347, 0x3347, 0x2B26, 0x2B06, 0x22E6, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x2B26, 0x2B46, 0x2B66, 0x3366, 0x3366, 
        0x3387, 0x3367, 0x3347, 0x3327, 0x3307, 0x32E7, 0x32E7, 0x32C7, 0x32A8, 0x3287, 0x3267, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A26, 0x2A26, 0x2206, 0x2206, 0x2206, 0x2206, 0x2246, 0x2A67, 0x2A87, 0x2AC7, 0x32E7, 0x3308, 0x3328, 0x3B68,
  0x5CCC, 0x5D0D, 0x5D2D, 0x5D4D, 0x658D, 0x6D8E, 0x7DD1, 0x85F2, 0x7D50, 0x6CCE, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74AD, 0x74AD, 0x7CAE, 0x746D, 0x84CF, 
        0x7C8E, 0x746D, 0x748E, 0x748E, 0x644D, 0x6C4D, 0x6C4D, 0x6C6D, 0x6C8D, 0x74AE, 0x7CEE, 0x7D0F, 0x84EE, 0x850E, 0x850E, 0x8D0F, 0x8D0F, 0x8D0F, 0x9550, 0x9D50, 0x9D71, 0xA570, 0x9D50, 0x954F, 0x9D2F, 0x9D4F, 0xA550, 0xAD51, 0xAD51, 0xAD51, 
        0xB571, 0xB552, 0xB551, 0xAD52, 0x9D11, 0x74AE, 0x7530, 0x6D2F, 0x6D0F, 0x646D, 0x53EA, 0x5C09, 0x53E9, 0x53E8, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53E7, 0x53C8, 0x4BA7, 0x4BA7, 0x4B87, 0x4B87, 0x4386, 0x4366, 0x4366, 0x3B46, 0x3B46, 0x3B46, 
        0x3346, 0x3346, 0x3367, 0x3B67, 0x3B87, 0x3BA8, 0x3BA8, 0x43C9, 0x43C9, 0x43AB, 0x436B, 0x3AEB, 0x328B, 0x328B, 0x328B, 0x3AED, 0x4B4D, 0x538D, 0x5BCD, 0x5BCC, 0x53AB, 0x538A, 0x538A, 0x538A, 0x538A, 0x536A, 0x5349, 0x5B49, 0x5B8B, 0x63AB, 
        0x6BEC, 0x7C2D, 0x8C6E, 0x8C8E, 0x84AE, 0x84AD, 0x848D, 0x7C4D, 0x7C4D, 0x742C, 0x7C2D, 0x7C4C, 0x744C, 0x742C, 0x6C0B, 0x6C0B, 0x5C0B, 0x5C0A, 0x540A, 0x53EA, 0x53E9, 0x5409, 0x5C0A, 0x5C0A, 0x642B, 0x642B, 0x6C2B, 0x6C2A, 0x742B, 0x742B, 
        0x742B, 0x6C2B, 0x6C2B, 0x6C2C, 0x740D, 0x73ED, 0x6BCE, 0x6BB0, 0x6B71, 0x6372, 0x6373, 0x5B34, 0x52D4, 0x4A94, 0x3A34, 0x31B4, 0x2993, 0x2993, 0x2153, 0x2153, 0x2133, 0x2933, 0x3154, 0x41D7, 0x49D9, 0x49DB, 0x49DB, 0x49DC, 0x51FD, 0x521D, 
        0x521D, 0x521D, 0x4A3E, 0x4A1D, 0x4A1D, 0x4A1D, 0x4A1E, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x39FD, 0x39FD, 0x39DD, 0x39DD, 0x31BD, 0x31BD, 0x31BD, 0x319D, 0x317D, 0x297D, 0x297D, 0x295D, 0x31BC, 0x427D, 0x531E, 0x5B3E, 0x5B3E, 0x635E, 0x5B5E, 
        0x5B3E, 0x5B1E, 0x5AFE, 0x52BD, 0x4A5D, 0x425D, 0x4A7E, 0x4ABE, 0x4ABD, 0x4ABD, 0x52BD, 0x52DE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x5AFD, 0x5B1D, 0x5B1E, 0x5B3E, 0x635E, 0x633E, 0x635E, 0x635E, 0x635E, 0x6B7E, 0x6B7D, 0x6B7D, 0x6B9E, 0x739E, 
        0x73BE, 0x73BE, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73BE, 0x739E, 0x739E, 0x73DE, 0x73DE, 0x7BDE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 0x6B9E, 0x6B9E, 0x6B7E, 
        0x6B7E, 0x635E, 0x635E, 0x5B5D, 0x633E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x52FD, 0x5ADE, 0x52DD, 0x52BD, 0x52BD, 0x529D, 0x4A7D, 0x4A7D, 0x4A7D, 0x425D, 0x425D, 0x425D, 0x425D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 
        0x423D, 0x4A3D, 0x4A3E, 0x525D, 0x525D, 0x5A7E, 0x5A9E, 0x629E, 0x62BE, 0x62BE, 0x6ADE, 0x72FD, 0x731E, 0x731E, 0x7B3E, 0x731D, 0x7B1E, 0x831E, 0x7B1E, 0x7ADD, 0x6A9D, 0x6A9D, 0x6A9D, 0x5A5C, 0x523C, 0x523D, 0x523D, 0x523D, 0x523D, 0x523D, 
        0x523D, 0x523D, 0x523D, 0x523D, 0x5A7D, 0x629D, 0x5A7D, 0x525D, 0x523D, 0x41FD, 0x319D, 0x319D, 0x39BD, 0x39FD, 0x423D, 0x423E, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A5E, 0x525D, 0x527D, 0x525D, 0x4A5D, 0x4A3C, 0x4A3C, 0x4A3B, 0x4AB9, 0x5C17, 
        0x440F, 0x23EA, 0x2429, 0x242A, 0x242A, 0x2429, 0x2C6A, 0x2C8A, 0x2C6A, 0x2449, 0x1C28, 0x1C48, 0x1C48, 0x1C48, 0x1C68, 0x1C68, 0x1C69, 0x1C69, 0x2449, 0x2469, 0x1C49, 0x1C48, 0x1C48, 0x1C49, 0x2449, 0x246A, 0x2C6A, 0x2C4A, 0x2C4B, 0x33EB, 
        0x3BAC, 0x3B6C, 0x3B2C, 0x432C, 0x436B, 0x53EB, 0x5C2B, 0x5C2B, 0x540A, 0x5409, 0x4BC9, 0x4BC9, 0x43A8, 0x4388, 0x3B68, 0x3368, 0x3347, 0x3347, 0x2B27, 0x2B07, 0x2AE6, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x2B46, 0x3366, 0x3366, 0x3386, 0x3387, 
        0x3387, 0x3387, 0x3347, 0x3347, 0x3327, 0x3307, 0x32E8, 0x32C8, 0x32A8, 0x3288, 0x3287, 0x2A67, 0x2A47, 0x2A47, 0x2A47, 0x2A26, 0x2A06, 0x2206, 0x2206, 0x2206, 0x2206, 0x2226, 0x2A66, 0x2A87, 0x2AC7, 0x32C7, 0x32E7, 0x3327, 0x3B48,
  0x5CCC, 0x5CEC, 0x5D0C, 0x5D4D, 0x656D, 0x6D8E, 0x85D1, 0x8DF2, 0x7D2F, 0x74CE, 0x74AD, 0x74AE, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74CD, 0x74ED, 0x74CD, 0x7CCE, 0x7CAE, 0x7C8D, 0x84CF, 
        0x7C8E, 0x744D, 0x84EF, 0x8530, 0x6C4D, 0x644D, 0x6C6D, 0x6C6D, 0x6C8D, 0x74CE, 0x7CEE, 0x7D0E, 0x84EE, 0x850F, 0x850F, 0x850E, 0x8D0F, 0x8D2F, 0x954F, 0x9D70, 0x9D70, 0x9D50, 0x9D4F, 0x954F, 0x9D2F, 0x9D4F, 0xA550, 0xA551, 0xAD51, 0xB571, 
        0xB592, 0xB572, 0xB552, 0xAD52, 0x94F0, 0x74AF, 0x6D0F, 0x6D2F, 0x6D2F, 0x644D, 0x53CA, 0x53E9, 0x53E8, 0x53C7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BA7, 0x4BA7, 0x4387, 0x4386, 0x4386, 0x4366, 0x3B66, 0x3B46, 0x3B46, 0x3B66, 0x3B46, 
        0x3366, 0x3366, 0x3367, 0x3B67, 0x3B87, 0x43A8, 0x43C8, 0x43E8, 0x4BE9, 0x4BCA, 0x4B8B, 0x432B, 0x3ACB, 0x32AB, 0x32AB, 0x3ACC, 0x4B2D, 0x53AD, 0x5BCD, 0x5BCC, 0x538B, 0x538A, 0x5389, 0x4B69, 0x4B69, 0x4B29, 0x4AE8, 0x4AE8, 0x5309, 0x5329, 
        0x638A, 0x7BEC, 0x8C4D, 0x8C8D, 0x8CAD, 0x8CAD, 0x8CAE, 0x848E, 0x848E, 0x7C6D, 0x7C6D, 0x744D, 0x744C, 0x6C2C, 0x6C2B, 0x640B, 0x5C0B, 0x5C0A, 0x540A, 0x540A, 0x540A, 0x5409, 0x5C0A, 0x5C0A, 0x642B, 0x642B, 0x6C2B, 0x6C2A, 0x6C2B, 0x742B, 
        0x744B, 0x744B, 0x744B, 0x744B, 0x744B, 0x742B, 0x7C2C, 0x7BED, 0x73ED, 0x73EE, 0x73EE, 0x73CF, 0x6B90, 0x6B91, 0x5B52, 0x5B13, 0x5B14, 0x5B14, 0x5AF5, 0x5AF5, 0x5AF6, 0x62F6, 0x5AB6, 0x5237, 0x49B8, 0x49DA, 0x49DB, 0x49DC, 0x51FD, 0x521D, 
        0x523D, 0x523D, 0x4A3D, 0x4A1D, 0x4A1D, 0x4A1D, 0x4A1E, 0x421D, 0x421D, 0x421D, 0x421D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x31DD, 0x31DD, 0x31BD, 0x31BD, 0x319D, 0x299D, 0x297D, 0x297D, 0x297D, 0x31BC, 0x427D, 0x52FE, 0x5B3E, 0x5B5E, 0x5B5E, 
        0x5B3E, 0x5B3E, 0x5B3E, 0x5AFE, 0x52BD, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A9E, 0x4A9D, 0x52BD, 0x52BD, 0x52DE, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B3E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x637E, 0x637D, 0x637D, 0x6B9E, 0x6B9E, 
        0x6BBE, 0x73BE, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B7E, 0x739E, 0x73BE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x73DE, 0x73DE, 0x73DE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 
        0x635E, 0x635E, 0x633D, 0x5B3D, 0x5B1E, 0x5B1D, 0x5AFD, 0x52FD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x425D, 0x4A5D, 0x4A5D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A5D, 0x525D, 
        0x527E, 0x527E, 0x5A7E, 0x5A9E, 0x5A9D, 0x62BD, 0x62BD, 0x6ADE, 0x6AFE, 0x72FE, 0x731E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B3E, 0x7B3E, 0x833E, 0x831E, 0x7ADD, 0x72BD, 0x729D, 0x6A9D, 0x625D, 0x521C, 0x523D, 0x523D, 0x523D, 0x523D, 0x523D, 0x523D, 
        0x4A3D, 0x523D, 0x523D, 0x523E, 0x523E, 0x525D, 0x525D, 0x4A3D, 0x41FD, 0x293C, 0x211C, 0x213D, 0x297D, 0x31BD, 0x3A1D, 0x425D, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x425D, 0x427D, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425E, 0x4A5E, 0x4A5E, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A3D, 0x4A3C, 0x4A1C, 0x4A3B, 0x4B38, 
        0x4C13, 0x2BEB, 0x2409, 0x2409, 0x242A, 0x242A, 0x2C4A, 0x2C6A, 0x244A, 0x2449, 0x1C28, 0x1C28, 0x1C48, 0x1C48, 0x1C48, 0x1C68, 0x1C69, 0x1C69, 0x2469, 0x1C69, 0x1C48, 0x1C48, 0x1C48, 0x1C48, 0x1C49, 0x1C69, 0x246A, 0x246A, 0x2C4A, 0x2C0B, 
        0x33CC, 0x3B8C, 0x3B2C, 0x3B2C, 0x436C, 0x4BAB, 0x53EC, 0x5C0B, 0x53EA, 0x53E9, 0x4BC9, 0x4BA8, 0x4388, 0x4368, 0x3B48, 0x3348, 0x3327, 0x3327, 0x2B07, 0x2B07, 0x2B07, 0x2B06, 0x2B06, 0x2B26, 0x2B26, 0x2B47, 0x3367, 0x3387, 0x3387, 0x33A7, 
        0x3BA7, 0x3B87, 0x3367, 0x3347, 0x3B48, 0x3308, 0x32E8, 0x32C8, 0x32A8, 0x3288, 0x3287, 0x2A67, 0x2A67, 0x2A47, 0x2A47, 0x2A27, 0x2A26, 0x2206, 0x2206, 0x2206, 0x2A26, 0x2A47, 0x2A67, 0x2A87, 0x2AC7, 0x32C7, 0x32E7, 0x3327, 0x3B48,
  0x548B, 0x54CB, 0x5D0C, 0x5D2C, 0x656D, 0x758E, 0x85D1, 0x85D1, 0x7D2F, 0x74AE, 0x74AE, 0x74CE, 0x74CE, 0x6CAE, 0x6CAD, 0x6C8D, 0x6C8D, 0x6C8C, 0x6C8C, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x74ED, 0x74EE, 0x7CEE, 0x7CCE, 0x7CAE, 0x7C8D, 0x84EF, 
        0x7CAE, 0x6C4D, 0x6C6D, 0x6C6D, 0x644D, 0x646D, 0x6C6D, 0x6C8D, 0x6C8D, 0x74AE, 0x74CE, 0x7CEE, 0x84EF, 0x850F, 0x850F, 0x850F, 0x8D2F, 0x952F, 0x9550, 0x9D70, 0x9D70, 0x9D50, 0x954F, 0x9D4F, 0x9D6F, 0x9D6F, 0xA550, 0xA570, 0xAD71, 0xB592, 
        0xB592, 0xB572, 0xAD52, 0xAD53, 0x84B0, 0x748F, 0x6CEF, 0x6D2F, 0x6D2F, 0x6C6D, 0x5BEA, 0x53C9, 0x53C8, 0x53E7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BE7, 0x4BC7, 0x4BA7, 0x4387, 0x4386, 0x4366, 0x3B66, 0x3B66, 0x3B46, 0x3346, 0x3346, 0x3346, 0x3366, 
        0x3366, 0x3366, 0x3B86, 0x3B87, 0x43A7, 0x43C8, 0x4BE8, 0x4BE8, 0x4C09, 0x4C09, 0x4BEA, 0x4BAB, 0x438B, 0x3B2B, 0x32CA, 0x32CB, 0x430C, 0x538D, 0x5BED, 0x63ED, 0x5BAB, 0x538A, 0x4B69, 0x4B69, 0x4B48, 0x4308, 0x3AC7, 0x3AA7, 0x42C7, 0x42C8, 
        0x5308, 0x636A, 0x7BCB, 0x842C, 0x8C4C, 0x948D, 0x8C8D, 0x8C8D, 0x846D, 0x846D, 0x7C4D, 0x744C, 0x744C, 0x6C2C, 0x642B, 0x5C0A, 0x5BEA, 0x5C0A, 0x5C0A, 0x540A, 0x540A, 0x5C2A, 0x5C2A, 0x5C2A, 0x642A, 0x642A, 0x642A, 0x6C2A, 0x6C2A, 0x6C2A, 
        0x742A, 0x744B, 0x744B, 0x744B, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C2B, 0x7C2B, 0x7C0B, 0x840C, 0x840C, 0x840C, 0x7BED, 0x7BCD, 0x73AF, 0x7BB0, 0x7BF1, 0x8412, 0x8C53, 0x9474, 0x9475, 0x9456, 0x83B8, 0x51F7, 0x49DA, 0x51DB, 0x51DC, 0x521C, 0x521D, 
        0x523D, 0x523D, 0x523D, 0x4A1D, 0x4A1D, 0x421D, 0x421D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x39FD, 0x421D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x31DD, 0x31BD, 0x29BD, 0x299D, 0x297D, 0x297D, 0x297D, 0x297D, 0x319C, 0x3A1D, 0x52DE, 0x5B1E, 0x5B3E, 
        0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52DE, 0x4A9D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9D, 0x52BD, 0x52DE, 0x52FE, 0x52FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B3E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x637E, 0x6B7E, 0x6B9E, 
        0x6BBE, 0x6BBE, 0x739E, 0x6B9E, 0x6B9E, 0x6B9E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x6B7E, 0x6B9D, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x73BE, 0x739E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5D, 0x635D, 
        0x633E, 0x633E, 0x5B1E, 0x5B1D, 0x5AFE, 0x5AFE, 0x52DE, 0x52DD, 0x52BD, 0x52BD, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x529D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525D, 0x527D, 0x527E, 0x5A9E, 0x5A9E, 
        0x5A9E, 0x5A9E, 0x5A9E, 0x629D, 0x62BE, 0x6ADE, 0x6ADE, 0x72FE, 0x733E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B3E, 0x7AFD, 0x7ADD, 0x7AFE, 0x7ADE, 0x627D, 0x5A3D, 0x523D, 0x523D, 0x523D, 0x525D, 0x4A5D, 0x4A5D, 0x4A5D, 
        0x4A5D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A5D, 0x4A3D, 0x39DE, 0x293C, 0x211C, 0x215D, 0x297D, 0x29BD, 0x31DD, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x427D, 0x427D, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x427D, 0x425D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x41FC, 0x4279, 
        0x4B95, 0x33AD, 0x2BEA, 0x2C09, 0x2409, 0x2C2A, 0x2C4A, 0x2C6A, 0x2C4A, 0x2429, 0x1C08, 0x1C28, 0x1C48, 0x1C48, 0x1C48, 0x1C48, 0x1C69, 0x1C69, 0x1C69, 0x1C69, 0x1C68, 0x1C48, 0x1C48, 0x1C29, 0x1C49, 0x1C49, 0x2449, 0x244A, 0x244A, 0x2C2B, 
        0x2BEB, 0x33CB, 0x338B, 0x338C, 0x3B8C, 0x43AC, 0x4BCC, 0x53EB, 0x53EB, 0x53CA, 0x4BA9, 0x4BA9, 0x4389, 0x3B68, 0x3B48, 0x3328, 0x3307, 0x3307, 0x3307, 0x2B07, 0x2B07, 0x2B07, 0x2B27, 0x3327, 0x3347, 0x3367, 0x3367, 0x3B87, 0x3BA7, 0x3BA7, 
        0x3BA7, 0x3B87, 0x3B67, 0x3B47, 0x3B48, 0x3308, 0x32E7, 0x32C7, 0x32A7, 0x3288, 0x3288, 0x3268, 0x3268, 0x2A47, 0x2A47, 0x2A27, 0x2A06, 0x2A06, 0x2206, 0x2206, 0x2A27, 0x2A67, 0x3287, 0x2AA7, 0x2AA7, 0x32C7, 0x32E7, 0x3327, 0x3B48,
  0x4C6B, 0x4C8B, 0x54EB, 0x5D2C, 0x6D6D, 0x75AF, 0x8611, 0x8DD1, 0x7D2F, 0x74AE, 0x74AE, 0x7D0F, 0x750F, 0x6CCE, 0x6CAE, 0x6CAD, 0x6C8D, 0x648C, 0x648C, 0x6C8C, 0x648C, 0x6C8C, 0x6CAD, 0x6CCD, 0x74CD, 0x74EE, 0x7D0E, 0x7D0F, 0x7CCE, 0x7C8E, 0x84CF, 
        0x7CAE, 0x6C4D, 0x6C4C, 0x6C4D, 0x644D, 0x646D, 0x646D, 0x6C8D, 0x6C8D, 0x6CAD, 0x74CE, 0x7CEE, 0x84EF, 0x850F, 0x8D0F, 0x8D2F, 0x952F, 0x954F, 0x9D70, 0x9D70, 0x956F, 0x956F, 0x956F, 0x956F, 0x9D70, 0x9D70, 0xA570, 0xAD91, 0xB591, 0xB592, 
        0xB592, 0xB572, 0xAD52, 0xA532, 0x7C4F, 0x6C6F, 0x6CEF, 0x6D30, 0x6D30, 0x6C6D, 0x53A9, 0x53A8, 0x53C8, 0x4BE7, 0x4BE7, 0x4BE7, 0x43E7, 0x43C7, 0x43C7, 0x43A7, 0x4386, 0x3B86, 0x3B66, 0x3B66, 0x3B46, 0x3346, 0x3346, 0x3346, 0x3346, 0x3346, 
        0x3366, 0x3386, 0x3B86, 0x3B87, 0x43A7, 0x43C7, 0x4BE8, 0x4BE8, 0x4C09, 0x5409, 0x5409, 0x540A, 0x53EB, 0x43AB, 0x3B4B, 0x330A, 0x3B0B, 0x4B8C, 0x5BED, 0x640D, 0x5BEC, 0x5BAB, 0x4B69, 0x4B48, 0x4328, 0x3B08, 0x32E7, 0x32A6, 0x32A7, 0x3AA7, 
        0x3AC7, 0x4AE8, 0x6348, 0x7389, 0x83EB, 0x8C2B, 0x8C4C, 0x8C6D, 0x8C4D, 0x844D, 0x7C2C, 0x744C, 0x744C, 0x6C2B, 0x642B, 0x5C0A, 0x5C0A, 0x5C0A, 0x540A, 0x540A, 0x5C0A, 0x5C0A, 0x5C2A, 0x642A, 0x642A, 0x642A, 0x640A, 0x640A, 0x6C0A, 0x6C0A, 
        0x6C2A, 0x742A, 0x742A, 0x744A, 0x744A, 0x7C4B, 0x7C2B, 0x7C2B, 0x7C2B, 0x7C0B, 0x842B, 0x842B, 0x844C, 0x842C, 0x842C, 0x7C2C, 0x842D, 0x8C4E, 0x9C8F, 0x9CAF, 0xA4F0, 0xACF1, 0xACF2, 0xA476, 0x6256, 0x51D9, 0x49DA, 0x51DB, 0x51FC, 0x521C, 
        0x523D, 0x523D, 0x4A3D, 0x4A1D, 0x4A3E, 0x4A3E, 0x4A3E, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x3A1D, 0x39FD, 0x39FD, 0x31FE, 0x31DD, 0x29DD, 0x29BD, 0x29BD, 0x299D, 0x297D, 0x297D, 0x295D, 0x297D, 0x297C, 0x31DC, 0x4A9E, 0x52FE, 
        0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x5AFE, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A9D, 0x52BD, 0x52BE, 0x52DE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B3E, 0x635E, 0x633E, 0x633E, 0x635E, 0x635E, 0x635D, 0x6B7E, 0x6B7E, 
        0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7D, 0x6B7D, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x739E, 0x6B9E, 0x737E, 0x739E, 0x737E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x633E, 0x633E, 0x631E, 
        0x5B1E, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ADE, 0x52DE, 0x52BD, 0x52BD, 0x529D, 0x4A9D, 0x4A9E, 0x4A9D, 0x4A7E, 0x4A9D, 0x4A7E, 0x4A7E, 0x4A9D, 0x527D, 0x529D, 0x529D, 0x527E, 0x525D, 0x525D, 0x525D, 0x527E, 0x5A7D, 0x5A7E, 0x5A9E, 0x5A9E, 0x62BE, 
        0x62BE, 0x62BE, 0x62BD, 0x629D, 0x6ABE, 0x6ADE, 0x72FE, 0x731E, 0x7B3E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B5E, 0x7B3E, 0x7AFE, 0x72DE, 0x7ADE, 0x72DE, 0x6A7D, 0x625D, 0x5A3D, 0x523D, 0x525E, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 
        0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x423D, 0x39DE, 0x213D, 0x211D, 0x215D, 0x299D, 0x31DD, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x3A7D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x427D, 0x427D, 0x427D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5E, 0x3A3D, 0x3A3D, 0x425D, 0x423D, 0x423D, 0x421D, 0x41FD, 0x41FD, 0x41DC, 0x3A39, 
        0x3AF4, 0x338E, 0x2BEA, 0x2C09, 0x2409, 0x2C2A, 0x346B, 0x346B, 0x2C4A, 0x2429, 0x2408, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C48, 0x1C48, 0x1C69, 0x1C69, 0x1C69, 0x1C68, 0x1C48, 0x1C48, 0x1C48, 0x1C49, 0x1C49, 0x1C49, 0x2449, 0x244A, 0x242A, 
        0x240A, 0x2BEB, 0x2BCB, 0x2BAB, 0x33AB, 0x3BAC, 0x43CC, 0x53EC, 0x53EB, 0x53CA, 0x4BAA, 0x4BA9, 0x4369, 0x3B48, 0x3B28, 0x3328, 0x3307, 0x3307, 0x3307, 0x3307, 0x3328, 0x3328, 0x3348, 0x3347, 0x3347, 0x3367, 0x3B87, 0x3BA7, 0x3BA7, 0x3BA7, 
        0x3BA7, 0x3B87, 0x3B67, 0x3B47, 0x3B27, 0x3B08, 0x32E7, 0x32C7, 0x32A7, 0x3288, 0x3288, 0x3268, 0x3268, 0x2A47, 0x2A47, 0x2A27, 0x2A06, 0x2A06, 0x2206, 0x2206, 0x2A26, 0x2A47, 0x2A47, 0x2A87, 0x2AA7, 0x2AC7, 0x32E7, 0x3307, 0x3B27,
  0x548B, 0x54CB, 0x550C, 0x654D, 0x6D6E, 0x7DD0, 0x8E11, 0x8DD1, 0x7D0F, 0x74AE, 0x74CE, 0x8550, 0x7D50, 0x6CCE, 0x6CAE, 0x74AE, 0x6CAD, 0x6CAD, 0x648C, 0x6C8C, 0x6C8C, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CCD, 0x74ED, 0x7D0F, 0x7D2F, 0x84EF, 0x7CAE, 0x7CAE, 
        0x7C8E, 0x6C4D, 0x6C4D, 0x644D, 0x644D, 0x646D, 0x648D, 0x648D, 0x6C8D, 0x6CAD, 0x74CE, 0x7CEE, 0x850F, 0x850F, 0x8D2F, 0x8D4F, 0x9570, 0x9D90, 0x9D90, 0x9D6F, 0x956F, 0x956F, 0x956F, 0x9D90, 0x9D90, 0xA5B1, 0xADB1, 0xB5B1, 0xB5B2, 0xB5B2, 
        0xB592, 0xB592, 0xB573, 0x94F1, 0x744F, 0x644F, 0x6CD0, 0x6D30, 0x7550, 0x74EF, 0x6C6D, 0x53C9, 0x4BC8, 0x4BC7, 0x43C7, 0x43E7, 0x43C7, 0x43C6, 0x43A7, 0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3346, 0x3346, 0x3346, 0x2B45, 0x3346, 0x3326, 0x3346, 
        0x3366, 0x3366, 0x3B86, 0x43A7, 0x43A7, 0x43C7, 0x4BE8, 0x4BE8, 0x4C08, 0x5429, 0x5429, 0x542A, 0x540B, 0x4BCB, 0x43AB, 0x3B6B, 0x3B4B, 0x4B8C, 0x5BED, 0x640E, 0x642E, 0x640D, 0x53CB, 0x4B69, 0x4328, 0x3B08, 0x32E7, 0x2AC6, 0x2AA6, 0x2A86, 
        0x32A6, 0x3AA6, 0x42C6, 0x5B28, 0x6B89, 0x7BCA, 0x83EB, 0x840C, 0x842C, 0x7C2C, 0x7C2C, 0x744C, 0x6C4C, 0x6C2B, 0x642B, 0x640A, 0x5C0A, 0x5BEA, 0x53E9, 0x53E9, 0x5C09, 0x5C09, 0x5C0A, 0x642A, 0x640A, 0x6409, 0x63E9, 0x63E9, 0x63E9, 0x6409, 
        0x6C0A, 0x6C0A, 0x6C0A, 0x742A, 0x742A, 0x742A, 0x7C2A, 0x7C2A, 0x7C2A, 0x7C2B, 0x844B, 0x844B, 0x8C6C, 0x8C4C, 0x8C4C, 0x842C, 0x8C4C, 0x9C8D, 0xA4CE, 0xACEE, 0xB50E, 0xB52F, 0xB530, 0xACB3, 0x8336, 0x51F8, 0x49BA, 0x49DB, 0x51FC, 0x521C, 
        0x521D, 0x523D, 0x4A3D, 0x4A1D, 0x4A3E, 0x4A3E, 0x423D, 0x4A3D, 0x4A3D, 0x4A5D, 0x4A5D, 0x423D, 0x421D, 0x3A1D, 0x39FD, 0x39FD, 0x31FE, 0x31DD, 0x29DD, 0x29BD, 0x29BD, 0x299D, 0x299D, 0x297D, 0x295D, 0x215D, 0x215D, 0x295D, 0x29BC, 0x425D, 
        0x52FE, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5AFE, 0x52BD, 0x4A9D, 0x4A9D, 0x4A9D, 0x4ABD, 0x52BD, 0x52DE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5AFE, 0x5AFE, 0x5B1D, 0x5B1E, 0x5B3E, 0x5B3E, 0x633E, 0x633E, 0x635E, 0x635E, 0x635D, 0x6B7E, 
        0x6B7E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B5E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5D, 0x6B7E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x635E, 0x633E, 0x633E, 0x5B1E, 0x5AFE, 0x5AFE, 
        0x5AFE, 0x5ADE, 0x52BE, 0x52BE, 0x52BE, 0x529E, 0x529E, 0x4A9D, 0x4A9E, 0x4A7D, 0x4A7D, 0x425D, 0x425D, 0x427D, 0x4A7D, 0x4A7D, 0x4A7D, 0x529D, 0x529D, 0x529D, 0x529E, 0x527E, 0x525E, 0x5A7E, 0x5A7E, 0x5A9E, 0x5A9D, 0x5A9E, 0x62BE, 0x62BE, 
        0x62DE, 0x62BD, 0x62BD, 0x62BD, 0x6ABE, 0x6ADE, 0x72FE, 0x731E, 0x7B5E, 0x7B5E, 0x7B7E, 0x7B5E, 0x733D, 0x731E, 0x731E, 0x72FE, 0x72DE, 0x72DE, 0x72BE, 0x6A9D, 0x625D, 0x5A3D, 0x523D, 0x523D, 0x523E, 0x4A5E, 0x4A5E, 0x4A5D, 0x4A5D, 0x4A5D, 
        0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x421D, 0x295D, 0x211D, 0x215D, 0x217D, 0x299D, 0x31FD, 0x427E, 0x427D, 0x3A5E, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A7D, 0x3A9D, 0x429E, 0x3A9D, 0x3A9D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3E, 0x3A3E, 0x3A3D, 0x3A3D, 0x3A3D, 0x423D, 0x3A1D, 0x39FC, 0x39DC, 0x39FB, 0x3A19, 
        0x32B3, 0x338D, 0x2BEA, 0x2C0A, 0x2C0A, 0x2C2A, 0x2C4B, 0x2C4A, 0x2C2A, 0x2429, 0x2409, 0x2428, 0x2428, 0x1C28, 0x1C28, 0x1C28, 0x1C48, 0x1C68, 0x1C68, 0x1C68, 0x1C68, 0x1C68, 0x1C48, 0x1C48, 0x1449, 0x1C49, 0x1C49, 0x1C49, 0x2449, 0x242A, 
        0x242A, 0x240A, 0x23EA, 0x23EA, 0x2BCB, 0x33EB, 0x3BCB, 0x4BCB, 0x53CC, 0x53CB, 0x53CB, 0x53AA, 0x4369, 0x3B48, 0x3B28, 0x3308, 0x32E7, 0x32E7, 0x3307, 0x3308, 0x3328, 0x3328, 0x3348, 0x3B48, 0x3B47, 0x3B67, 0x3B67, 0x3B87, 0x3B87, 0x3B87, 
        0x3B87, 0x3B67, 0x3B47, 0x3B47, 0x3B27, 0x3B07, 0x32E7, 0x32C7, 0x32A7, 0x3288, 0x3288, 0x3268, 0x3268, 0x2A47, 0x2A47, 0x2A27, 0x2206, 0x2206, 0x2206, 0x21E6, 0x2206, 0x2A27, 0x2A47, 0x2A67, 0x2A87, 0x2AA7, 0x2AC7, 0x3307, 0x3327,
  0x5CED, 0x54EC, 0x550C, 0x5D2D, 0x6D8E, 0x85F0, 0x8E12, 0x8DD1, 0x852F, 0x7CCE, 0x7CCE, 0x8571, 0x8571, 0x74CF, 0x6CAE, 0x6CCE, 0x6CCE, 0x6CCD, 0x6CAD, 0x648D, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CCD, 0x74CD, 0x7D0E, 0x7D0F, 0x7CCE, 0x7C8E, 0x7CAE, 
        0x748E, 0x6C4D, 0x644C, 0x644D, 0x644D, 0x646D, 0x648D, 0x648D, 0x6C8D, 0x6CAD, 0x74CE, 0x7CEE, 0x850E, 0x852F, 0x8D4F, 0x9570, 0x9DB0, 0x9DB0, 0x9D70, 0x954F, 0x954F, 0x956F, 0x9D70, 0x9D90, 0xA5D1, 0xB612, 0xBE12, 0xB5B1, 0xB5B2, 0xB5B2, 
        0xB592, 0xB593, 0xA552, 0x8490, 0x7450, 0x642F, 0x648F, 0x6510, 0x6D50, 0x8571, 0x7D0F, 0x5C2B, 0x4BC8, 0x4BC7, 0x43C7, 0x43C7, 0x43C7, 0x43A6, 0x3B86, 0x3B86, 0x3B66, 0x3366, 0x3346, 0x3346, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x3326, 0x2B46, 
        0x3346, 0x3366, 0x3B86, 0x43A7, 0x43C7, 0x43C7, 0x4BE7, 0x4C08, 0x5428, 0x5429, 0x5429, 0x5C2A, 0x540A, 0x4C0A, 0x4BCB, 0x43AB, 0x3B6B, 0x4B8C, 0x53ED, 0x5C0E, 0x642E, 0x642E, 0x642D, 0x53CB, 0x4349, 0x3B28, 0x2AE7, 0x2AC6, 0x22A6, 0x2A86, 
        0x2AA6, 0x32A6, 0x3AA6, 0x42C6, 0x5307, 0x6369, 0x73CB, 0x840C, 0x7C0C, 0x7C2C, 0x7C2C, 0x744D, 0x6C4C, 0x6C4C, 0x642B, 0x642B, 0x5C0A, 0x5BEA, 0x5BE9, 0x5BE9, 0x5C09, 0x5C09, 0x6409, 0x6409, 0x640A, 0x63E9, 0x5BC9, 0x5BC9, 0x63E9, 0x63E9, 
        0x6409, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x742A, 0x742A, 0x7C0A, 0x7C0A, 0x7C2A, 0x844B, 0x8C6B, 0x8C8C, 0x8C6C, 0x8C4B, 0x842B, 0x946C, 0x9CAD, 0xACEE, 0xB50E, 0xBD0E, 0xBD2E, 0xBD2F, 0xB4F1, 0x9C15, 0x5A16, 0x51B9, 0x49DA, 0x49FB, 0x521C, 
        0x521D, 0x521D, 0x4A1D, 0x4A1D, 0x4A1E, 0x421E, 0x421D, 0x4A3D, 0x423D, 0x4A5D, 0x4A5D, 0x423D, 0x421D, 0x3A1D, 0x39FD, 0x39FD, 0x31FD, 0x31DD, 0x31DD, 0x29BD, 0x29BD, 0x29BD, 0x299D, 0x299D, 0x297D, 0x217D, 0x215D, 0x215D, 0x213C, 0x297C, 
        0x3A1D, 0x52DE, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5AFE, 0x4ABD, 0x4A9D, 0x4A9D, 0x4A9D, 0x52BD, 0x52BD, 0x52DD, 0x5AFE, 0x5B1E, 0x5AFE, 0x5AFE, 0x5AFD, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x633E, 0x635E, 0x635E, 0x635E, 0x635E, 
        0x6B7E, 0x6B7E, 0x6B9E, 0x6B7E, 0x6B7E, 0x6B5E, 0x6B5E, 0x635E, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B5E, 0x6B3D, 0x6B5E, 0x6B5E, 0x6B7E, 0x6B7D, 0x6B7D, 0x6B5E, 0x6B5E, 0x635E, 0x635E, 0x633E, 0x633E, 0x633E, 0x5B1E, 0x5AFE, 0x5AFE, 0x5AFE, 0x5ADE, 
        0x52BE, 0x52BE, 0x529E, 0x529E, 0x529E, 0x4A7E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x4A7D, 0x527E, 0x529E, 0x5A9D, 0x5A9D, 0x5A9E, 0x5A7E, 0x5A7E, 0x5A7E, 0x5A9E, 0x5A9D, 0x5ABD, 0x62BE, 0x62BE, 0x62DD, 
        0x62DD, 0x62BD, 0x62BD, 0x6ABD, 0x6ABD, 0x6ABD, 0x72DD, 0x72FE, 0x7B3E, 0x7B5E, 0x7B5E, 0x7B5E, 0x731E, 0x6AFD, 0x6AFE, 0x6ADE, 0x6ADE, 0x6A9E, 0x625D, 0x5A3D, 0x5A3D, 0x523D, 0x523D, 0x523D, 0x4A5E, 0x4A5E, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 
        0x4A7D, 0x4A5D, 0x4A5D, 0x4A5E, 0x423D, 0x39BD, 0x20FC, 0x211D, 0x217D, 0x299D, 0x299D, 0x31FD, 0x4A9E, 0x427D, 0x427D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A7D, 0x3A9D, 0x429E, 0x3A9E, 0x3A9D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FC, 0x39DB, 0x3A19, 0x3276, 
        0x32F1, 0x2BAC, 0x2BEA, 0x2C0A, 0x2C0A, 0x2C2A, 0x2C4A, 0x2C4A, 0x2C2A, 0x2429, 0x2409, 0x2408, 0x2408, 0x1C08, 0x1C08, 0x1C28, 0x1C48, 0x1C48, 0x1C68, 0x1C68, 0x1C68, 0x1C48, 0x1C48, 0x1C48, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x2449, 0x244A, 
        0x2429, 0x2409, 0x2409, 0x2409, 0x23EA, 0x2BEA, 0x33EB, 0x43CB, 0x4BAB, 0x4BAC, 0x53AC, 0x53AB, 0x4349, 0x3B48, 0x3B28, 0x3308, 0x32E7, 0x32E7, 0x32E7, 0x3308, 0x3328, 0x3328, 0x3B48, 0x3B48, 0x3B48, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B87, 
        0x3B87, 0x3B67, 0x3B47, 0x3B27, 0x3B28, 0x3B08, 0x3AE7, 0x3AC7, 0x32A7, 0x3288, 0x3288, 0x3268, 0x3267, 0x2A47, 0x2A27, 0x2A26, 0x2206, 0x2206, 0x2206, 0x21E6, 0x2206, 0x2A06, 0x2A27, 0x2A47, 0x2A67, 0x2AA7, 0x32C7, 0x32E7, 0x3328,
  0x5D0D, 0x54EC, 0x54EB, 0x5D2C, 0x758E, 0x85F0, 0x8DF1, 0x8D90, 0x852F, 0x7CCE, 0x74CD, 0x8591, 0x8592, 0x6CCF, 0x6CCE, 0x74CE, 0x6CCE, 0x6CCD, 0x6CCD, 0x648D, 0x6CAD, 0x6CCD, 0x6CCD, 0x6CAD, 0x6CAD, 0x74CD, 0x74EE, 0x7D0E, 0x7CEE, 0x7CAE, 0x7CCE, 
        0x748D, 0x6C4D, 0x644D, 0x644D, 0x646D, 0x646D, 0x648D, 0x648D, 0x648D, 0x6CAD, 0x74CD, 0x7CCE, 0x850E, 0x854F, 0x8D4F, 0x9590, 0x9590, 0x954F, 0x954F, 0x954F, 0x954F, 0x954F, 0x9D4F, 0x9D50, 0xA570, 0xADB1, 0xB5D2, 0xB5B2, 0xB5B2, 0xB592, 
        0xB592, 0xAD93, 0x94F1, 0x7450, 0x6C71, 0x5C0F, 0x5C4F, 0x64CF, 0x6D30, 0x7591, 0x7D50, 0x646C, 0x53C9, 0x4BA8, 0x43A7, 0x43C7, 0x43A6, 0x3BA6, 0x3B86, 0x3366, 0x3366, 0x3346, 0x3346, 0x2B26, 0x2B26, 0x2B25, 0x2B25, 0x2B25, 0x2B26, 0x2B46, 
        0x3346, 0x3366, 0x3B86, 0x3B86, 0x43A7, 0x43C7, 0x4BE7, 0x4C08, 0x4C08, 0x5428, 0x5429, 0x5429, 0x5429, 0x540A, 0x4BEA, 0x4BEA, 0x43CB, 0x438B, 0x4BAC, 0x53ED, 0x5C0E, 0x642E, 0x644E, 0x5C0D, 0x53AB, 0x4349, 0x32E8, 0x2AC7, 0x22A6, 0x22A6, 
        0x2AA6, 0x2AA6, 0x32C6, 0x3AC7, 0x42E7, 0x5308, 0x73CB, 0x842D, 0x842D, 0x844D, 0x7C6D, 0x744C, 0x744C, 0x6C4C, 0x644B, 0x642B, 0x642A, 0x5C0A, 0x5BE9, 0x63E9, 0x63E9, 0x63E9, 0x63E9, 0x6C09, 0x6C09, 0x63E9, 0x63E9, 0x63C9, 0x63E9, 0x63E9, 
        0x6C09, 0x6C09, 0x6C0A, 0x6C0A, 0x6C0A, 0x740A, 0x740A, 0x7C0A, 0x7C2A, 0x842A, 0x8C4B, 0x8C6B, 0x948C, 0x948C, 0x8C6B, 0x842B, 0x8C4B, 0x9CAD, 0xACED, 0xB50E, 0xBD2E, 0xBD2E, 0xBD2E, 0xBD0F, 0xACB4, 0x7B16, 0x51D7, 0x51BA, 0x51DB, 0x51FC, 
        0x521C, 0x521D, 0x4A1D, 0x4A1D, 0x4A1D, 0x4A3D, 0x4A1D, 0x421D, 0x421D, 0x423D, 0x4A3D, 0x421D, 0x421D, 0x3A1D, 0x39FD, 0x39FD, 0x39FD, 0x31DD, 0x31DD, 0x29BD, 0x31BD, 0x31BD, 0x31BE, 0x299D, 0x299D, 0x297D, 0x217D, 0x295D, 0x213D, 0x213D, 
        0x295C, 0x423D, 0x52FE, 0x5B3D, 0x5B3E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52DE, 0x4A9D, 0x4A9D, 0x529D, 0x52BD, 0x52BE, 0x52DE, 0x5B1E, 0x5B1E, 0x5B1D, 0x5AFD, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 0x633E, 0x635E, 0x635E, 0x635E, 0x635E, 
        0x635E, 0x637E, 0x6B7E, 0x6B7E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x635E, 0x6B5E, 0x6B5E, 0x633D, 0x6B3E, 0x6B5E, 0x635E, 0x635D, 0x635D, 0x635E, 0x633E, 0x633E, 0x633E, 0x631E, 0x631E, 0x5AFE, 0x5AFE, 0x5ADE, 0x52DE, 0x52BD, 0x52BD, 
        0x529D, 0x4A9E, 0x4A7E, 0x4A7E, 0x4A5E, 0x425D, 0x425D, 0x4A5D, 0x4A5D, 0x425D, 0x423E, 0x423E, 0x423D, 0x4A3E, 0x4A5D, 0x527D, 0x529E, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 0x5A9E, 0x5A9E, 0x629E, 0x629D, 0x629D, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 
        0x62DE, 0x62DD, 0x6ADD, 0x62DE, 0x6ADE, 0x6ABD, 0x6ABD, 0x72DD, 0x731D, 0x7B3D, 0x7B5E, 0x7B3E, 0x733E, 0x6AFE, 0x6ADE, 0x6ABE, 0x629D, 0x625D, 0x5A3D, 0x5A3D, 0x521D, 0x521D, 0x523D, 0x523D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 
        0x4A7D, 0x4A7D, 0x4A7D, 0x425E, 0x3A1D, 0x295D, 0x18FC, 0x215D, 0x29BD, 0x29BD, 0x297D, 0x31FC, 0x4A9E, 0x427D, 0x427D, 0x427D, 0x425D, 0x3A5D, 0x3A5D, 0x3A7D, 0x429D, 0x3A9D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x427D, 0x427D, 0x3A5D, 0x3A5D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x31FD, 0x31DD, 0x31DD, 0x31DB, 0x31F9, 0x3A75, 0x32F1, 
        0x2B4E, 0x2BEA, 0x2BE9, 0x23E9, 0x2409, 0x2C09, 0x2C2A, 0x2C2A, 0x2C09, 0x2409, 0x2409, 0x2408, 0x2408, 0x1C08, 0x1C08, 0x1C29, 0x1C29, 0x1C48, 0x1C48, 0x1C48, 0x1C68, 0x1C48, 0x1C48, 0x1C48, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x2449, 
        0x2449, 0x1C29, 0x2409, 0x2409, 0x2409, 0x2C0A, 0x33EA, 0x3BCB, 0x438B, 0x4B6C, 0x4B8B, 0x4B8B, 0x4B8B, 0x3B29, 0x3B28, 0x3B08, 0x32E8, 0x32E8, 0x3308, 0x3308, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B48, 0x3B47, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 
        0x3B67, 0x3B67, 0x3B47, 0x3B27, 0x3B08, 0x3B08, 0x3AE8, 0x32C8, 0x32A8, 0x3288, 0x3268, 0x3267, 0x2A47, 0x2A47, 0x2A27, 0x2A07, 0x2206, 0x2206, 0x21E6, 0x21E6, 0x2A06, 0x2206, 0x2A47, 0x2A67, 0x3288, 0x32A8, 0x32C8, 0x32E8, 0x3328,
  0x4CAB, 0x4CAB, 0x4CAA, 0x5D2C, 0x758E, 0x85F0, 0x8DB0, 0x856F, 0x852F, 0x84EE, 0x7CCD, 0x8DB1, 0x8DB2, 0x6CEF, 0x6CCE, 0x6CCE, 0x6CCE, 0x6CCD, 0x6CCD, 0x6CAD, 0x6CAD, 0x6CCE, 0x6CCD, 0x6CAD, 0x6C8C, 0x6CAD, 0x74CD, 0x7CEE, 0x7CEE, 0x7CCE, 0x7CCF, 
        0x748D, 0x6C4D, 0x644C, 0x646D, 0x646D, 0x646D, 0x648D, 0x648D, 0x648D, 0x6CAD, 0x6CCD, 0x74CD, 0x852F, 0x8D4F, 0x8D4F, 0x8D4F, 0x8D4F, 0x8D2E, 0x8D2E, 0x8D2F, 0x8D4F, 0x954F, 0x952F, 0x9D4F, 0x9D4F, 0xA570, 0xAD91, 0xB5B2, 0xB5B2, 0xAD92, 
        0xB592, 0xAD93, 0x8CD1, 0x7450, 0x6C71, 0x6410, 0x53EE, 0x5CAE, 0x650F, 0x6D70, 0x7550, 0x6CAE, 0x5C2B, 0x4BA8, 0x43A7, 0x43C6, 0x3BA6, 0x3BA6, 0x3B86, 0x3366, 0x3346, 0x2B46, 0x2B25, 0x2B25, 0x2305, 0x2305, 0x2B05, 0x2B05, 0x2B25, 0x2B25, 
        0x3346, 0x3346, 0x3B66, 0x3B86, 0x43A7, 0x43C7, 0x43C7, 0x4BE7, 0x4C08, 0x5408, 0x5428, 0x5428, 0x5429, 0x5429, 0x5409, 0x4BEA, 0x4BCA, 0x43AA, 0x438B, 0x4BCC, 0x53ED, 0x642D, 0x6C2E, 0x642E, 0x5C0D, 0x53AB, 0x3B49, 0x32E8, 0x2AC6, 0x22C6, 
        0x22C6, 0x2AC5, 0x32E6, 0x3B07, 0x4B08, 0x5329, 0x73EC, 0x842D, 0x844D, 0x7C6D, 0x746D, 0x744C, 0x744C, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C2B, 0x640A, 0x63E9, 0x6409, 0x63E9, 0x63E9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x63E9, 0x63E9, 0x6409, 
        0x6409, 0x6C09, 0x6C09, 0x6C09, 0x6C09, 0x740A, 0x740A, 0x7C2A, 0x842A, 0x8C4B, 0x8C4B, 0x946C, 0x948C, 0x948C, 0x946B, 0x842A, 0x842A, 0x9CAC, 0xACED, 0xBD0D, 0xBD0E, 0xBD2E, 0xBD2E, 0xBD2F, 0xB4F2, 0x93F6, 0x5A36, 0x51D9, 0x51DB, 0x51FC, 
        0x521C, 0x521D, 0x49FD, 0x4A1D, 0x4A1D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A1D, 0x4A3D, 0x421D, 0x421D, 0x3A1D, 0x39FD, 0x3A1D, 0x39FD, 0x31FD, 0x31DD, 0x31BD, 0x31DD, 0x31BD, 0x31BD, 0x29BD, 0x299D, 0x299D, 0x297D, 0x297D, 0x215D, 0x213D, 
        0x213D, 0x295C, 0x425D, 0x5AFD, 0x5B3D, 0x5B5D, 0x5B5E, 0x5B3D, 0x5B3E, 0x5B3E, 0x5B1E, 0x52DD, 0x4A9D, 0x4A7D, 0x529D, 0x52BD, 0x52DE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5AFE, 0x52FE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B3E, 0x633E, 0x635D, 0x635D, 0x635E, 
        0x635E, 0x635E, 0x635D, 0x635E, 0x635E, 0x633E, 0x633E, 0x633D, 0x635E, 0x635E, 0x635E, 0x633E, 0x631E, 0x631E, 0x633E, 0x633E, 0x633E, 0x633D, 0x631E, 0x631E, 0x5AFE, 0x5AFD, 0x5AFE, 0x5AFE, 0x5ADE, 0x52DE, 0x52BD, 0x52BE, 0x529E, 0x529D, 
        0x4A7D, 0x4A7E, 0x4A5E, 0x425E, 0x425E, 0x425D, 0x425D, 0x4A3D, 0x4A3D, 0x423D, 0x4A3D, 0x4A5D, 0x4A5D, 0x4A5E, 0x525E, 0x5A9E, 0x5ABE, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9E, 0x629D, 0x629D, 0x62BE, 0x62BE, 0x62BD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6AFE, 
        0x6AFE, 0x6AFD, 0x6AFE, 0x6AFE, 0x6AFE, 0x62BD, 0x6ABD, 0x6ABD, 0x72FD, 0x7B3E, 0x7B3E, 0x7B1E, 0x72FD, 0x6ADE, 0x62BE, 0x629E, 0x5A7D, 0x5A5D, 0x5A3D, 0x523D, 0x523E, 0x523D, 0x523E, 0x525D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 
        0x4A7D, 0x4A7D, 0x4A5D, 0x423D, 0x31BD, 0x18FC, 0x191D, 0x297D, 0x31DD, 0x31BD, 0x297D, 0x4A7D, 0x4ABD, 0x427D, 0x3A5D, 0x425E, 0x3A5E, 0x3A3D, 0x3A3D, 0x3A7D, 0x429E, 0x3A7D, 0x3A5E, 0x3A5E, 0x3A5E, 0x3A5D, 0x3A5D, 0x3A5E, 0x3A5E, 0x3A5D, 
        0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x425D, 0x425D, 0x3A7D, 0x3A7D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x31DC, 0x29BB, 0x3218, 0x3A95, 0x3B11, 0x336D, 
        0x2BAB, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2C09, 0x2C09, 0x2C09, 0x2C09, 0x2409, 0x2409, 0x2408, 0x2408, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C48, 0x1C49, 0x1C48, 0x1C28, 0x1C28, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 0x1C49, 
        0x1C49, 0x1C29, 0x1C29, 0x1C09, 0x1C09, 0x240A, 0x2C0A, 0x33CA, 0x3BAB, 0x436B, 0x4B6C, 0x4B6C, 0x538C, 0x434A, 0x3B29, 0x3B08, 0x32E8, 0x32E8, 0x3308, 0x3308, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B48, 0x3B47, 0x3B47, 0x3B67, 0x3B67, 0x3B67, 
        0x3B67, 0x3B47, 0x3B47, 0x3B27, 0x3B08, 0x3B08, 0x3B08, 0x3AC8, 0x32A8, 0x3288, 0x3268, 0x3267, 0x2A47, 0x2A27, 0x2A26, 0x2206, 0x21E6, 0x21E6, 0x21E6, 0x21E6, 0x2A06, 0x2A27, 0x2A67, 0x3288, 0x32A8, 0x32C8, 0x32E8, 0x3308, 0x3B28,
  0x444A, 0x446A, 0x4CAA, 0x5D0C, 0x758E, 0x85B0, 0x856F, 0x852E, 0x850E, 0x84EE, 0x7CED, 0x8DD1, 0x8DD2, 0x6CCF, 0x6CAE, 0x6CAD, 0x6CCE, 0x6CCD, 0x6CCD, 0x6CCE, 0x6CAD, 0x6CCD, 0x6CAD, 0x6C8D, 0x6C8C, 0x6CAD, 0x74CD, 0x7CEE, 0x7CEE, 0x7CCE, 0x7CCF, 
        0x748E, 0x6C4D, 0x644C, 0x646D, 0x646D, 0x646D, 0x648D, 0x648D, 0x648D, 0x6CAD, 0x74CD, 0x7D0E, 0x854F, 0x8D6F, 0x852E, 0x850D, 0x850E, 0x8D2E, 0x8D2F, 0x8D2F, 0x8D4F, 0x954F, 0x9D4F, 0x9D50, 0xA570, 0xA570, 0xAD91, 0xB591, 0xB592, 0xB592, 
        0xB592, 0xA573, 0x7C90, 0x6C30, 0x6C91, 0x6430, 0x53EE, 0x546E, 0x5CEF, 0x654F, 0x6D30, 0x74EF, 0x6CAE, 0x5C2B, 0x43A7, 0x3BA6, 0x3BA6, 0x3386, 0x3386, 0x3366, 0x2B46, 0x2B45, 0x2B25, 0x2305, 0x2305, 0x2305, 0x2305, 0x2B05, 0x2B05, 0x2B25, 
        0x2B45, 0x3346, 0x3B66, 0x3B86, 0x3B86, 0x43A7, 0x43C7, 0x4BE7, 0x4BE8, 0x5408, 0x5428, 0x5428, 0x5428, 0x5428, 0x5429, 0x4C09, 0x4BEA, 0x4BCA, 0x43AB, 0x43AB, 0x4BAB, 0x53EC, 0x640E, 0x642E, 0x642E, 0x5C0D, 0x4BCB, 0x3B49, 0x2AE7, 0x22E6, 
        0x22E6, 0x2AE5, 0x3307, 0x4B69, 0x538A, 0x5B6A, 0x73EC, 0x844D, 0x844D, 0x7C4C, 0x744C, 0x744C, 0x6C4C, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C2A, 0x640A, 0x6C0A, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 
        0x6BE9, 0x6BE9, 0x7409, 0x740A, 0x7409, 0x740A, 0x7C0A, 0x7C2A, 0x842A, 0x8C4B, 0x8C4B, 0x946B, 0x948C, 0x948B, 0x8C4B, 0x840A, 0x842A, 0x9C8C, 0xACED, 0xBD0D, 0xBD0D, 0xBD2E, 0xBD2E, 0xBD4F, 0xBD30, 0xA495, 0x6AB6, 0x51F8, 0x51DA, 0x51FB, 
        0x521C, 0x521D, 0x49FD, 0x4A1D, 0x4A1D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x3A1D, 0x3A1D, 0x39FD, 0x3A1D, 0x39FE, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x29BD, 0x29BD, 0x29BD, 0x299D, 0x297D, 0x217D, 0x215D, 
        0x213D, 0x293C, 0x319C, 0x4A9D, 0x5B1D, 0x5B5D, 0x5B5E, 0x5B5D, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52DE, 0x4A7D, 0x4A7D, 0x4A9D, 0x52BE, 0x52DE, 0x5B1E, 0x5B1E, 0x5AFE, 0x52FE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B3D, 0x633D, 0x633D, 0x633D, 
        0x633D, 0x635D, 0x635D, 0x633E, 0x633E, 0x631E, 0x633E, 0x633D, 0x633E, 0x633E, 0x633E, 0x631E, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5AFD, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ADD, 0x52DE, 0x52BD, 0x52BD, 0x529D, 0x4A9D, 0x4A9E, 0x4A7E, 0x4A7D, 
        0x427D, 0x425D, 0x423D, 0x423E, 0x423D, 0x421D, 0x423D, 0x4A3D, 0x4A3D, 0x4A5D, 0x4A7D, 0x527E, 0x527E, 0x525E, 0x527E, 0x5A9E, 0x5ABD, 0x5A9D, 0x5A9D, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x6ADE, 0x6ADE, 0x62BE, 0x62BE, 0x6ADE, 0x6ADE, 0x6AFE, 
        0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x62BD, 0x629E, 0x629D, 0x6ADD, 0x733E, 0x7B1E, 0x6ABD, 0x629D, 0x629D, 0x5A9D, 0x5A7D, 0x5A5D, 0x525D, 0x523D, 0x523D, 0x523E, 0x525E, 0x525E, 0x525D, 0x4A7E, 0x4A7E, 0x4A7E, 0x4A9E, 0x4A9E, 0x4A9E, 
        0x4A9D, 0x4A7D, 0x425D, 0x421D, 0x295D, 0x10DD, 0x193D, 0x299D, 0x31DD, 0x31BD, 0x39FD, 0x5B3E, 0x52FE, 0x425D, 0x3A5D, 0x3A5D, 0x3A5E, 0x3A3D, 0x3A3D, 0x427D, 0x427D, 0x3A5D, 0x323D, 0x321D, 0x3A3E, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5E, 
        0x3A5E, 0x3A5E, 0x3A5E, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5D, 0x3A5E, 0x3A5D, 0x3A5D, 0x3A5D, 0x323D, 0x323D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31DD, 0x31DD, 0x29BC, 0x29DA, 0x2A18, 0x3275, 0x3311, 0x3B8E, 0x33CB, 
        0x2BCA, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2C09, 0x2C09, 0x2C09, 0x2409, 0x2409, 0x2409, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C48, 0x1C48, 0x1C28, 0x1C28, 0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C49, 0x1C49, 
        0x1C49, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x2409, 0x240A, 0x2BEA, 0x3BCB, 0x3B8C, 0x3B4C, 0x436C, 0x4B8C, 0x4B8B, 0x4329, 0x3B08, 0x32E7, 0x3308, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B48, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 
        0x3B47, 0x3B47, 0x3B47, 0x3B27, 0x3B28, 0x3B28, 0x3B08, 0x3AC8, 0x32A8, 0x3288, 0x3267, 0x2A47, 0x2A27, 0x2A27, 0x2A06, 0x2206, 0x21E6, 0x21E6, 0x21E6, 0x21E6, 0x2A07, 0x3248, 0x3288, 0x3AA9, 0x3AC9, 0x3AC9, 0x3AE9, 0x3B09, 0x3B29,
  0x3C29, 0x4469, 0x4CCA, 0x5D2C, 0x758E, 0x7D8F, 0x7D2F, 0x7CEE, 0x84CE, 0x84CE, 0x7CED, 0x8DF2, 0x8DD2, 0x6CEF, 0x6CCE, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCE, 0x6CCD, 0x6CCD, 0x6CAD, 0x6C8D, 0x6C8D, 0x74AD, 0x7CEE, 0x7CEE, 0x7CCE, 0x84CF, 
        0x74AE, 0x6C4D, 0x644C, 0x646D, 0x646D, 0x648D, 0x648D, 0x648D, 0x648D, 0x6CAD, 0x74CE, 0x7D0E, 0x852F, 0x854F, 0x7D0E, 0x7CED, 0x850E, 0x8D2E, 0x8D2F, 0x8D4F, 0x954F, 0x9D4F, 0xA570, 0xA570, 0xAD90, 0xAD91, 0xAD91, 0xB591, 0xB592, 0xB592, 
        0xB593, 0x9D32, 0x742F, 0x63EE, 0x6C70, 0x6470, 0x542F, 0x544E, 0x5CAE, 0x5D2F, 0x6D50, 0x7551, 0x7510, 0x53EB, 0x43A8, 0x3BA6, 0x3B86, 0x3386, 0x3366, 0x3345, 0x2B45, 0x2B25, 0x2305, 0x2304, 0x2304, 0x2304, 0x2304, 0x2B05, 0x2B05, 0x2B25, 
        0x2B25, 0x3345, 0x3346, 0x3B66, 0x3B86, 0x43A6, 0x43C7, 0x43C7, 0x4BE7, 0x4C07, 0x5408, 0x5408, 0x5428, 0x5428, 0x5408, 0x4C08, 0x4C09, 0x4BE9, 0x43CA, 0x43AA, 0x438A, 0x4BAB, 0x53CC, 0x5BCD, 0x5BED, 0x5C0D, 0x53ED, 0x4BAC, 0x3B49, 0x2B07, 
        0x2AE6, 0x2AE6, 0x4368, 0x640C, 0x6C2D, 0x73EC, 0x740D, 0x844D, 0x844D, 0x744C, 0x744C, 0x744C, 0x744C, 0x744C, 0x744C, 0x746B, 0x744B, 0x6C2A, 0x6C2A, 0x740A, 0x740A, 0x73E9, 0x73E9, 0x73E9, 0x73E9, 0x73E9, 0x6BC9, 0x6BC9, 0x6BC9, 0x6BE9, 
        0x6BE9, 0x7409, 0x7409, 0x740A, 0x740A, 0x7C0A, 0x7C0A, 0x7C2A, 0x842A, 0x8C4A, 0x8C4B, 0x946B, 0x948B, 0x948B, 0x8C4A, 0x840A, 0x842A, 0x948B, 0xACED, 0xB50D, 0xBD2D, 0xBD2E, 0xBD4E, 0xBD4F, 0xBD50, 0xACF2, 0x8376, 0x5217, 0x51DA, 0x51FB, 
        0x51FC, 0x49FC, 0x49FD, 0x4A1D, 0x4A1D, 0x4A1D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x3A1D, 0x3A1D, 0x39FD, 0x3A1D, 0x3A1D, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x29DD, 0x29BD, 0x29BD, 0x29BD, 0x299D, 0x297D, 0x217D, 
        0x215D, 0x295D, 0x297D, 0x39FD, 0x52DE, 0x531D, 0x5B3E, 0x5B5E, 0x5B5E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52BD, 0x4A7D, 0x4A7D, 0x529E, 0x52BD, 0x52FE, 0x5AFE, 0x5AFE, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x5B1D, 0x5B1E, 0x5B3D, 0x633E, 
        0x633E, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1E, 0x5AFE, 0x5AFE, 0x5ADE, 0x5ADE, 0x5AFD, 0x5AFD, 0x5AFD, 0x5AFE, 0x52DE, 0x52BE, 0x52BD, 0x52BD, 0x529D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x425D, 
        0x425D, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x4A5D, 0x525D, 0x527E, 0x527E, 0x529E, 0x529E, 0x527E, 0x5A7E, 0x5A9D, 0x5ABD, 0x5ABD, 0x5A9D, 0x5ABD, 0x62BE, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 0x62BE, 0x62BE, 0x62BE, 0x6ADE, 0x6B1E, 
        0x6B1E, 0x6B3E, 0x733E, 0x6B1E, 0x6AFE, 0x62BD, 0x629D, 0x629D, 0x6ABD, 0x731E, 0x6ADE, 0x629D, 0x627D, 0x5A7D, 0x525D, 0x525D, 0x523D, 0x523D, 0x523D, 0x4A5D, 0x4A5E, 0x4A5E, 0x4A5E, 0x4A7E, 0x4A7E, 0x4A7E, 0x4A7E, 0x4A9E, 0x4A9E, 0x4A9E, 
        0x4A9E, 0x4A9D, 0x4A5D, 0x3A1D, 0x211C, 0x18DD, 0x215D, 0x29BD, 0x31FD, 0x31BC, 0x425D, 0x637E, 0x5B1E, 0x427D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A5D, 0x323C, 0x31FC, 0x31FC, 0x321D, 0x323D, 0x3A3D, 0x3A3D, 0x323D, 0x323D, 0x323D, 
        0x323D, 0x3A3D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x29DD, 0x29BD, 0x29BC, 0x29DA, 0x3257, 0x32B4, 0x3311, 0x336D, 0x33AC, 0x3BEB, 
        0x33CA, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2C09, 0x2C09, 0x2C09, 0x2409, 0x2409, 0x23E9, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C08, 0x1C08, 0x1C28, 0x1C29, 0x1C28, 0x1C28, 0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C49, 0x1C48, 
        0x1C48, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x240A, 0x240A, 0x33EA, 0x3B8C, 0x3B6C, 0x3B4B, 0x436C, 0x53AD, 0x4B6A, 0x3B08, 0x32E8, 0x3308, 0x3B08, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 
        0x3B47, 0x3B47, 0x3B47, 0x3B27, 0x3B28, 0x3B08, 0x32E8, 0x32C8, 0x32A8, 0x3288, 0x3267, 0x2A47, 0x2A27, 0x2A26, 0x2206, 0x21E6, 0x21E6, 0x21E6, 0x2A06, 0x2A27, 0x3248, 0x3288, 0x3289, 0x3AC9, 0x42EA, 0x432A, 0x434A, 0x4B6A, 0x4BAB,
  0x4429, 0x4C8A, 0x54EA, 0x654C, 0x75AE, 0x7D8F, 0x750E, 0x7CCE, 0x7CCD, 0x84CD, 0x7D2E, 0x9612, 0x8DD2, 0x6CCF, 0x6CAD, 0x6CAD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CEE, 0x74EE, 0x6CCD, 0x74AD, 0x6CAD, 0x74AD, 0x7CEE, 0x7CCE, 0x7CAE, 0x84CF, 
        0x74AE, 0x644C, 0x644C, 0x646C, 0x646C, 0x648D, 0x648D, 0x64AD, 0x6CAD, 0x6CCE, 0x74EE, 0x7D0E, 0x7D0E, 0x7D0E, 0x850E, 0x850E, 0x8D2E, 0x8D2E, 0x8D2F, 0x952F, 0x954F, 0x9D50, 0xA570, 0xA570, 0xAD71, 0xAD91, 0xB591, 0xB591, 0xB592, 0xB592, 
        0xB573, 0x9D12, 0x742F, 0x5BAE, 0x6C50, 0x6470, 0x544F, 0x542E, 0x546E, 0x5CCF, 0x6D30, 0x7571, 0x7530, 0x6CCE, 0x4C0A, 0x3B87, 0x3B86, 0x3366, 0x3345, 0x2B45, 0x2B45, 0x2325, 0x2304, 0x2304, 0x2304, 0x2304, 0x2304, 0x2304, 0x2305, 0x2B05, 
        0x2B25, 0x3345, 0x3346, 0x3B66, 0x3B86, 0x43A7, 0x43A7, 0x43E7, 0x4BE7, 0x4C07, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE9, 0x43C9, 0x43AA, 0x43AA, 0x438A, 0x438B, 0x4B8C, 0x53CD, 0x53ED, 0x540D, 0x53ED, 0x4BAB, 0x3B49, 
        0x3308, 0x3B28, 0x640B, 0x7C4D, 0x7C2D, 0x844D, 0x846D, 0x846D, 0x7C6D, 0x7C6D, 0x746C, 0x746C, 0x746C, 0x746C, 0x746C, 0x7C6C, 0x7C6B, 0x744B, 0x7C2B, 0x7C2A, 0x740A, 0x73EA, 0x73E9, 0x73E9, 0x73E9, 0x73E9, 0x73E9, 0x73C9, 0x6BC9, 0x73E9, 
        0x73E9, 0x7409, 0x740A, 0x740A, 0x7C0A, 0x7C0A, 0x7C2A, 0x7C2A, 0x842A, 0x8C4A, 0x8C4B, 0x946B, 0x948B, 0x948B, 0x8C4A, 0x842A, 0x842A, 0x946B, 0xA4CD, 0xB50D, 0xBD2D, 0xBD2E, 0xBD4E, 0xBD2E, 0xBD4F, 0xB531, 0x9C56, 0x5A56, 0x51F9, 0x51FA, 
        0x49FB, 0x49FC, 0x49FD, 0x49FD, 0x4A1D, 0x4A1D, 0x421D, 0x41FD, 0x41FD, 0x41FD, 0x421D, 0x3A1D, 0x421D, 0x3A1E, 0x3A1D, 0x3A1D, 0x3A1D, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31BD, 0x31BD, 0x29BD, 0x29BD, 0x299D, 0x217D, 
        0x217D, 0x297D, 0x297D, 0x317D, 0x423D, 0x52DE, 0x531E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5AFE, 0x52DE, 0x4A7D, 0x4A9D, 0x52BD, 0x52DD, 0x52FE, 0x52FE, 0x52BE, 0x52BD, 0x52DE, 0x52DE, 0x52FE, 0x52FE, 0x5AFE, 0x5B1E, 0x5B1E, 
        0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x529E, 0x4A9D, 0x4A9D, 0x4A7D, 0x4A5D, 0x425D, 0x425D, 0x425D, 0x423D, 0x423D, 
        0x423D, 0x423D, 0x421D, 0x4A1D, 0x4A3D, 0x4A5D, 0x527D, 0x529D, 0x529D, 0x5A9D, 0x5A9E, 0x5ABE, 0x5A9E, 0x5A7D, 0x5A9E, 0x5A9D, 0x5ABD, 0x5ABD, 0x62BD, 0x5A9D, 0x62BE, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 0x62BE, 0x62BE, 0x62BD, 0x62BD, 0x6AFD, 
        0x6B1D, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x62DD, 0x5A9D, 0x629E, 0x6ADE, 0x6ADE, 0x629D, 0x5A7D, 0x5A7D, 0x525D, 0x525D, 0x525D, 0x4A3D, 0x4A3D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7E, 0x4A7E, 0x527E, 0x529D, 0x529E, 0x529E, 0x529E, 0x52BD, 0x52BD, 
        0x529D, 0x4A9D, 0x425E, 0x31BD, 0x18DC, 0x191D, 0x299D, 0x31FE, 0x3A1D, 0x31DD, 0x4A7E, 0x5B7E, 0x5B3E, 0x429D, 0x3A7D, 0x3A5D, 0x3A3D, 0x3A1D, 0x321C, 0x31FA, 0x21B9, 0x29B9, 0x29DB, 0x31FD, 0x3A1D, 0x3A3D, 0x3A3D, 0x323D, 0x323D, 0x321D, 
        0x323D, 0x321D, 0x321D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x323D, 0x323D, 0x3A3D, 0x323D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x29DD, 0x29BC, 0x29BB, 0x29F9, 0x3296, 0x3AF3, 0x332F, 0x336D, 0x33CA, 0x33CA, 0x33EA, 
        0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C09, 0x2C09, 0x2C2A, 0x2C2A, 0x2C29, 0x2409, 0x2409, 0x23E9, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C08, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 
        0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x240A, 0x2BEA, 0x33AB, 0x338B, 0x3B6B, 0x3B2B, 0x4B6C, 0x4B6C, 0x3B29, 0x3308, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B48, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 
        0x3B47, 0x3B47, 0x3B48, 0x3B28, 0x3B28, 0x3B08, 0x3AE8, 0x32C8, 0x32A8, 0x3288, 0x3247, 0x2A27, 0x2A27, 0x2A06, 0x2A06, 0x21E6, 0x21E6, 0x2A07, 0x2A27, 0x3247, 0x3268, 0x3A88, 0x42E9, 0x4B4B, 0x5BAC, 0x63CD, 0x63ED, 0x640D, 0x6C6E,
  0x4428, 0x4C8A, 0x54EA, 0x652C, 0x75AF, 0x7D8F, 0x7D0F, 0x7CCE, 0x7CCD, 0x84CE, 0x852F, 0x9E33, 0x95F3, 0x74EF, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x64CD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74CD, 0x74CD, 0x7CCD, 0x7CEE, 0x7CAE, 0x7CAE, 0x84CF, 
        0x74AE, 0x644C, 0x644C, 0x644C, 0x646C, 0x648D, 0x64CD, 0x6CCD, 0x6CCD, 0x74CD, 0x74EE, 0x7CEE, 0x7D0E, 0x850E, 0x850E, 0x850E, 0x8D2F, 0x8D2E, 0x8D2F, 0x954F, 0x954F, 0x9D70, 0xA570, 0xAD70, 0xAD91, 0xB591, 0xB591, 0xB591, 0xB571, 0xB552, 
        0xAD32, 0x94F2, 0x7430, 0x63EE, 0x644F, 0x5C4F, 0x544F, 0x544E, 0x544E, 0x548E, 0x6510, 0x6D50, 0x7571, 0x7D51, 0x6CCE, 0x43A9, 0x3B67, 0x3346, 0x2B25, 0x2B25, 0x2325, 0x2304, 0x2304, 0x1AE4, 0x1AE4, 0x22E4, 0x22E4, 0x2304, 0x2304, 0x2305, 
        0x2B25, 0x2B25, 0x3345, 0x3346, 0x3B66, 0x3B86, 0x43A6, 0x43C7, 0x43E7, 0x4BE7, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BE8, 0x4BE8, 0x43E8, 0x43E9, 0x3BC9, 0x3BA9, 0x3B89, 0x3B89, 0x3B8B, 0x43AC, 0x4BCC, 0x53CD, 0x53ED, 0x53CD, 0x53CC, 
        0x53AB, 0x5BAB, 0x742D, 0x844E, 0x8C6E, 0x8C6E, 0x8C8E, 0x848E, 0x848D, 0x7C8D, 0x7C8C, 0x7C8C, 0x7C6C, 0x7C6C, 0x7C6C, 0x7C6C, 0x7C6C, 0x7C4B, 0x7C4B, 0x7C2A, 0x7C0A, 0x7BEA, 0x73EA, 0x73EA, 0x73EA, 0x73E9, 0x73C9, 0x73E9, 0x73E9, 0x73E9, 
        0x73E9, 0x73EA, 0x740A, 0x7C0A, 0x7C0A, 0x7C0A, 0x7C2A, 0x842A, 0x842A, 0x8C2A, 0x8C4B, 0x946B, 0x948B, 0x948B, 0x8C4A, 0x842A, 0x842A, 0x8C6B, 0xA4ED, 0xAD0D, 0xBD2D, 0xBD2D, 0xBD2E, 0xBD4E, 0xBD4F, 0xB551, 0xACD5, 0x7B36, 0x51F8, 0x51DA, 
        0x49FB, 0x49DB, 0x49DC, 0x49FD, 0x49FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x39FD, 0x421D, 0x3A1D, 0x421D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x321D, 0x321D, 0x31FD, 0x321D, 0x31FD, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x29DD, 0x29BD, 0x29BD, 0x299D, 
        0x299D, 0x297D, 0x217D, 0x295D, 0x297C, 0x3A1D, 0x4ABD, 0x52FE, 0x5B1E, 0x5B3E, 0x5B3E, 0x533D, 0x5B1D, 0x5B1E, 0x5B1E, 0x52DE, 0x52BD, 0x4A9D, 0x4A9D, 0x52BD, 0x52DE, 0x52BD, 0x529D, 0x52BE, 0x52BE, 0x52DE, 0x52DE, 0x52DE, 0x52FE, 0x5AFE, 
        0x5AFE, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5ADE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52BE, 0x52BD, 0x4A9D, 0x4A9D, 0x4A9D, 0x529D, 0x4A9D, 0x529D, 0x529D, 0x4A7D, 0x4A7D, 0x4A5D, 0x425D, 0x423E, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 
        0x421D, 0x4A5D, 0x4A5D, 0x525D, 0x527E, 0x5A9E, 0x5ABE, 0x5ABE, 0x5ABD, 0x62BD, 0x62DE, 0x62DE, 0x62DE, 0x5A9D, 0x5A9E, 0x5A9D, 0x5A9E, 0x5A9D, 0x5ABE, 0x5ABD, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 0x62DE, 0x62BE, 0x629D, 0x62BD, 0x62BE, 0x62DD, 
        0x6AFD, 0x6AFE, 0x6B1E, 0x6B1E, 0x6AFE, 0x62DD, 0x5ABD, 0x62BE, 0x62BE, 0x629D, 0x5A7D, 0x527D, 0x527D, 0x527D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A3D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7E, 0x527E, 0x529D, 0x529D, 0x529D, 0x529D, 0x529E, 0x52BD, 0x52BD, 
        0x52BD, 0x4A9D, 0x423D, 0x215D, 0x18DD, 0x215D, 0x29DE, 0x3A3D, 0x3A1D, 0x39DD, 0x4A5D, 0x5B5E, 0x635E, 0x4B1E, 0x42BE, 0x3A5D, 0x323D, 0x321C, 0x31FA, 0x29F7, 0x29D6, 0x29D7, 0x29D9, 0x31DC, 0x39DD, 0x39FD, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 
        0x31FD, 0x31FD, 0x31FD, 0x3A1E, 0x3A1E, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x29DD, 0x299D, 0x29BC, 0x29D9, 0x3276, 0x3B11, 0x3B4E, 0x338C, 0x33AB, 0x33CA, 0x33CA, 0x33CA, 
        0x33CA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C0A, 0x2C2A, 0x2C2A, 0x2C2A, 0x2409, 0x2409, 0x23E9, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C08, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 
        0x1C28, 0x1C29, 0x1C49, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x242A, 0x240A, 0x2BCB, 0x2BAB, 0x336B, 0x3B2B, 0x434C, 0x4B8C, 0x3B49, 0x3308, 0x3308, 0x3B08, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 
        0x3B28, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B08, 0x32E8, 0x32C7, 0x32A7, 0x3268, 0x2A47, 0x2A27, 0x2A07, 0x2A06, 0x2A06, 0x21E6, 0x2A06, 0x2A27, 0x3248, 0x3A88, 0x3AC9, 0x4B4B, 0x63ED, 0x6C4E, 0x746F, 0x746F, 0x74AF, 0x7CF0, 0x7D10,
  0x4428, 0x4C6A, 0x54CA, 0x652C, 0x758F, 0x7D8F, 0x8550, 0x7CEF, 0x7CCE, 0x84CE, 0x852F, 0x9E53, 0x9634, 0x74EF, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x64AD, 0x64AD, 0x6CCD, 0x6CCD, 0x6CAD, 0x6CAD, 0x74AD, 0x74CD, 0x7CEE, 0x7CEE, 0x748D, 0x7C8E, 0x84CF, 
        0x74AE, 0x644C, 0x644C, 0x644C, 0x646C, 0x64AD, 0x64CD, 0x6CCD, 0x6CCD, 0x74CD, 0x74CD, 0x7D0E, 0x7D0E, 0x850E, 0x852E, 0x852F, 0x8D2F, 0x8D2F, 0x8D2F, 0x954F, 0x9550, 0x9D70, 0xA570, 0xAD91, 0xAD91, 0xB5B1, 0xBDB2, 0xBD92, 0xB551, 0xAD31, 
        0xA512, 0x8CB1, 0x7450, 0x640F, 0x5C0E, 0x540E, 0x544F, 0x544E, 0x4C4E, 0x4C6E, 0x5CEF, 0x6530, 0x7551, 0x7D71, 0x7530, 0x6CAE, 0x43A9, 0x3326, 0x2B26, 0x2B25, 0x2304, 0x2304, 0x22E4, 0x22E4, 0x22E4, 0x1AE4, 0x1AE4, 0x22E4, 0x22E4, 0x2304, 
        0x2305, 0x2B25, 0x3325, 0x3345, 0x3B66, 0x3B86, 0x3BA6, 0x43C6, 0x43C7, 0x43E7, 0x4407, 0x4C07, 0x4C07, 0x4C08, 0x4408, 0x4408, 0x4408, 0x4408, 0x43E8, 0x3BE8, 0x3BC8, 0x33A8, 0x33A9, 0x3B8A, 0x3B8A, 0x438B, 0x4BAC, 0x4BAC, 0x53CD, 0x5BED, 
        0x63ED, 0x740C, 0x844D, 0x8C6D, 0x8C8E, 0x8C8E, 0x8CAD, 0x8C8E, 0x84AD, 0x7C8D, 0x7C8C, 0x7C8C, 0x7C6C, 0x7C6B, 0x7C6B, 0x7C6B, 0x7C6B, 0x7C4B, 0x844B, 0x842A, 0x7C0A, 0x7C0A, 0x7C0A, 0x7BEA, 0x73EA, 0x73E9, 0x73E9, 0x7BE9, 0x7BE9, 0x73E9, 
        0x7BEA, 0x73EA, 0x7C0A, 0x7C0A, 0x7C0A, 0x7C0A, 0x7C2A, 0x842A, 0x842A, 0x8C4B, 0x8C6B, 0x948B, 0x9C8B, 0x948B, 0x8C4A, 0x7C2A, 0x842A, 0x8C6B, 0xA4ED, 0xAD0D, 0xB52D, 0xB52D, 0xB52D, 0xBD2E, 0xB54E, 0xBD70, 0xB532, 0x9416, 0x5A36, 0x51D9, 
        0x49DA, 0x49DB, 0x49DC, 0x49FD, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x321D, 0x3A1D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x29BD, 
        0x29BD, 0x299D, 0x297D, 0x297D, 0x297C, 0x299C, 0x31FC, 0x4ABD, 0x52FD, 0x531E, 0x533E, 0x533D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x52DD, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9E, 0x4ABE, 0x4ABE, 0x4ABD, 0x52BD, 0x52DD, 
        0x52DD, 0x52DD, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BE, 0x529E, 0x529E, 0x4A9E, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x425D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x4A3D, 
        0x5A9E, 0x62DE, 0x62DE, 0x62BE, 0x62DE, 0x62DE, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x62FE, 0x631E, 0x62FE, 0x5ABE, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A9D, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x629D, 0x629D, 0x62DE, 0x62DE, 0x62DD, 
        0x62FD, 0x6AFD, 0x6AFE, 0x6B1E, 0x62FE, 0x62FE, 0x5ABD, 0x5ABE, 0x5ABE, 0x5A7D, 0x527D, 0x527D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5E, 0x4A7D, 0x527E, 0x527E, 0x529E, 0x529E, 0x529D, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x52BD, 
        0x52BD, 0x529E, 0x423D, 0x191D, 0x18FD, 0x217D, 0x31FE, 0x3A3D, 0x3A1D, 0x39FD, 0x423D, 0x5B3D, 0x637E, 0x5B5E, 0x4ADE, 0x3A5E, 0x323D, 0x323C, 0x31F9, 0x29F6, 0x29F5, 0x29F5, 0x3218, 0x423C, 0x39DC, 0x31DC, 0x31DD, 0x31DD, 0x31FD, 0x31DD, 
        0x31DD, 0x31DD, 0x31DD, 0x39FE, 0x39FE, 0x39FD, 0x39FD, 0x3A1D, 0x3A1D, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x31DD, 0x29DD, 0x29BD, 0x29BC, 0x299B, 0x29D9, 0x3256, 0x3B12, 0x3B8E, 0x33AC, 0x3BCA, 0x33CA, 0x33C9, 0x33C9, 0x33C9, 
        0x33EA, 0x2BE9, 0x2BE9, 0x23E9, 0x2BE9, 0x2C0A, 0x2C2A, 0x2C0A, 0x2C09, 0x2C09, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C08, 0x1C09, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C28, 
        0x1C28, 0x1C49, 0x1C69, 0x1C49, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x240A, 0x2BEA, 0x2BCA, 0x2B8B, 0x334B, 0x332C, 0x438C, 0x436A, 0x3B08, 0x3308, 0x3B08, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 0x3B28, 
        0x3B28, 0x3B48, 0x3B48, 0x3B28, 0x3B08, 0x32E8, 0x32C7, 0x32A7, 0x3287, 0x3268, 0x2A47, 0x2A27, 0x2207, 0x21E6, 0x21E6, 0x21E6, 0x2A07, 0x3268, 0x42EA, 0x536B, 0x5BCD, 0x6C4F, 0x7CD0, 0x7CF0, 0x8511, 0x8531, 0x8551, 0x8551, 0x8571,
  0x4429, 0x4C8A, 0x54CA, 0x652C, 0x758E, 0x7DB0, 0x8570, 0x8530, 0x7CEF, 0x84EE, 0x852F, 0x9E53, 0x9E55, 0x7D30, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CAC, 0x64AC, 0x64AD, 0x64AD, 0x6CAD, 0x64AD, 0x648C, 0x6CAC, 0x6CAD, 0x7CEE, 0x852F, 0x7CCE, 0x7C8E, 0x7CCE, 
        0x74AE, 0x6C6C, 0x644C, 0x646C, 0x648D, 0x64CD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74EE, 0x7D0E, 0x852E, 0x852F, 0x852F, 0x8D2F, 0x8D4F, 0x954F, 0x954F, 0x954F, 0x9D70, 0xA570, 0xAD90, 0xAD91, 0xB5B1, 0xBD91, 0xB591, 0xB551, 0xAD12, 
        0xA4F2, 0x8490, 0x7430, 0x640F, 0x5C0E, 0x542E, 0x544E, 0x544E, 0x4C4E, 0x4C4E, 0x548E, 0x5CEF, 0x6530, 0x7551, 0x7D51, 0x7510, 0x646D, 0x3327, 0x3326, 0x2325, 0x2304, 0x1B04, 0x1AE4, 0x22E4, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 0x22E4, 
        0x2304, 0x2B05, 0x2B25, 0x3345, 0x3366, 0x3B86, 0x3B86, 0x3BA6, 0x3BC7, 0x43E7, 0x43E7, 0x4407, 0x4407, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x3BE8, 0x3BE8, 0x33C8, 0x33A8, 0x33A9, 0x3BAA, 0x438B, 0x438C, 0x4B8C, 0x53AC, 0x63CD, 
        0x740E, 0x842D, 0x8C4D, 0x948D, 0x8C8D, 0x8C8D, 0x8CAD, 0x8C8D, 0x8CAD, 0x84AD, 0x848C, 0x848C, 0x7C6C, 0x846B, 0x7C6B, 0x7C4B, 0x7C4B, 0x844B, 0x844B, 0x842B, 0x842A, 0x840A, 0x7C0A, 0x7C0A, 0x7C0A, 0x7BEA, 0x7BE9, 0x7BE9, 0x7BE9, 0x7BE9, 
        0x7C0A, 0x7C0A, 0x7C0A, 0x7C0A, 0x7C2A, 0x7C0A, 0x842A, 0x842A, 0x8C4B, 0x8C6B, 0x946B, 0x948B, 0x9C8B, 0x948B, 0x8C4B, 0x842A, 0x842A, 0x946B, 0xA4ED, 0xAD0D, 0xB50D, 0xB52D, 0xB52D, 0xB52D, 0xB54E, 0xBD6F, 0xB551, 0x9C74, 0x6296, 0x51D9, 
        0x49DA, 0x49BB, 0x49BC, 0x49DD, 0x41DD, 0x41DD, 0x41DD, 0x39DD, 0x39FD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x423D, 0x423E, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x321D, 0x321D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 
        0x29BD, 0x29BD, 0x299D, 0x297D, 0x297D, 0x217D, 0x297C, 0x31FD, 0x4A9E, 0x52DE, 0x531E, 0x531E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x52DD, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A9E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 
        0x4ABE, 0x52BE, 0x52BE, 0x52BE, 0x529D, 0x529D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A7E, 0x4A7D, 0x425D, 0x423D, 0x423D, 0x423D, 0x4A5D, 0x423D, 0x423D, 0x423D, 0x423D, 0x421D, 0x421D, 0x421D, 0x39FD, 0x41FD, 0x41FD, 0x421D, 0x525D, 0x62DE, 
        0x6AFE, 0x6AFE, 0x6AFE, 0x62FE, 0x62DE, 0x62DE, 0x62DD, 0x62DD, 0x62DD, 0x6AFE, 0x6B3E, 0x6B3E, 0x62FE, 0x5ADE, 0x5ABE, 0x5A9E, 0x5A9E, 0x62BD, 0x62DD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x62BD, 0x62BD, 0x62DE, 0x62DE, 0x62FE, 
        0x62DD, 0x62FD, 0x62FE, 0x62FE, 0x62FE, 0x62DD, 0x5ABD, 0x5A9D, 0x5A9D, 0x529D, 0x527D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x527E, 0x527E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529D, 0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 
        0x52BE, 0x4A7E, 0x39FD, 0x18FC, 0x191D, 0x219D, 0x31FD, 0x3A3D, 0x3A1D, 0x41FD, 0x421C, 0x5B1D, 0x637E, 0x5B5E, 0x4ADD, 0x3A5D, 0x3A5D, 0x429C, 0x429B, 0x3A57, 0x3234, 0x31F4, 0x31F5, 0x633C, 0x633D, 0x421C, 0x31BC, 0x31BD, 0x31BD, 0x31BD, 
        0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x29BD, 0x29BC, 0x29BC, 0x29BC, 0x29BC, 0x29BC, 0x299B, 0x217B, 0x219A, 0x29B8, 0x3276, 0x3AF2, 0x3B6E, 0x3BAC, 0x33AB, 0x33CA, 0x33C9, 0x33C9, 0x33C9, 0x33C9, 
        0x33EA, 0x2BE9, 0x2BE9, 0x23E9, 0x2BE9, 0x2C09, 0x2C0A, 0x2C09, 0x2C09, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x1C09, 0x1C09, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C28, 
        0x1C28, 0x1C29, 0x1C49, 0x1C49, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x242A, 0x2C0A, 0x2BEA, 0x2BAB, 0x336B, 0x334B, 0x438C, 0x4B8B, 0x3B29, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 
        0x3B48, 0x3B48, 0x3B48, 0x3B08, 0x32E8, 0x32E8, 0x32C7, 0x2AA7, 0x2A67, 0x2A47, 0x2A27, 0x2A07, 0x2207, 0x3247, 0x3AA9, 0x4B2B, 0x534C, 0x5B8C, 0x6C0E, 0x744F, 0x7CB0, 0x8511, 0x8551, 0x8551, 0x8571, 0x8571, 0x8571, 0x8590, 0x8590,
  0x4429, 0x4C89, 0x54CA, 0x652C, 0x6D8E, 0x7DB0, 0x7D90, 0x8570, 0x8D50, 0x850F, 0x854F, 0x9E33, 0x9E95, 0x8591, 0x6C8D, 0x6C8D, 0x6C8D, 0x6C8D, 0x64AD, 0x64AD, 0x64AD, 0x64AD, 0x648D, 0x648C, 0x648C, 0x6CCD, 0x750E, 0x7D2F, 0x850F, 0x7CAE, 0x7CCE, 
        0x7CCE, 0x6C8D, 0x646C, 0x648C, 0x64CD, 0x6CED, 0x6CED, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x74ED, 0x7D0E, 0x852F, 0x854F, 0x854F, 0x852F, 0x8D2F, 0x954F, 0x9570, 0x9D70, 0xA570, 0xA570, 0xAD71, 0xB591, 0xB591, 0xB591, 0xB591, 0xB572, 0xB532, 
        0x9CF2, 0x8490, 0x7450, 0x6C2F, 0x5C2E, 0x542D, 0x4C4D, 0x4C4E, 0x4C4E, 0x4C4E, 0x4C6E, 0x54AE, 0x5CF0, 0x6D11, 0x7531, 0x7511, 0x74F0, 0x6C8E, 0x3B48, 0x22E5, 0x2304, 0x1AE4, 0x1AE4, 0x1B04, 0x1AE4, 0x1AE4, 0x1AC3, 0x1AC4, 0x1AC4, 0x1AE4, 
        0x2304, 0x2324, 0x2B25, 0x2B45, 0x3365, 0x3386, 0x3386, 0x3BA6, 0x3BA7, 0x3BE7, 0x43E7, 0x4407, 0x4407, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x3C07, 0x3C07, 0x3BE7, 0x33E7, 0x33C7, 0x33C8, 0x3BC9, 0x3BAB, 0x43AB, 0x438C, 0x4B8C, 0x6BCD, 
        0x7C2E, 0x844E, 0x8C6D, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x848C, 0x848C, 0x846C, 0x846B, 0x846B, 0x846B, 0x844B, 0x844B, 0x844B, 0x844A, 0x844A, 0x844A, 0x842A, 0x842A, 0x840A, 0x7C0A, 0x7C0A, 0x7BEA, 0x7BEA, 0x7BEA, 0x7BEA, 0x7C0A, 
        0x840A, 0x7C0A, 0x7C2A, 0x842A, 0x842A, 0x840A, 0x842B, 0x8C4B, 0x8C6C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948B, 0x8C6B, 0x844B, 0x7C2A, 0x948C, 0xA4ED, 0xB50D, 0xB50D, 0xB50D, 0xB52D, 0xB52D, 0xBD4E, 0xBD6E, 0xAD2F, 0xA4B2, 0x7B56, 0x51F7, 
        0x49B9, 0x49BB, 0x49BC, 0x41BC, 0x41BD, 0x41BD, 0x41BD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x421D, 0x421D, 0x423D, 0x423D, 0x3A3D, 0x3A1D, 0x3A3E, 0x3A3E, 0x3A3E, 0x3A3D, 0x3A3D, 0x323D, 0x3A1D, 0x321D, 0x321D, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 
        0x29DD, 0x29DD, 0x29BD, 0x299D, 0x299D, 0x297D, 0x217D, 0x295D, 0x39FD, 0x4A9E, 0x52FE, 0x531E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1E, 0x5B1E, 0x52DD, 0x4A7D, 0x425D, 0x425D, 0x425E, 0x425D, 0x425D, 0x425D, 0x427D, 0x4A7D, 0x4A7D, 0x4A7E, 
        0x4A7E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A7D, 0x4A7D, 0x425D, 0x423D, 0x423E, 0x423D, 0x423D, 0x423D, 0x423D, 0x421D, 0x39FD, 0x3A1D, 0x421D, 0x421D, 0x421D, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x41FD, 0x421D, 0x4A3D, 0x527D, 0x62DE, 0x6B1E, 
        0x6B3E, 0x6AFD, 0x6AFD, 0x6AFD, 0x6AFD, 0x62FE, 0x62DE, 0x62DD, 0x62DD, 0x6B3E, 0x735E, 0x633E, 0x62FE, 0x5ADE, 0x529E, 0x529E, 0x5A9E, 0x62BD, 0x6ADD, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x6ADE, 0x62BD, 0x62BE, 0x62DE, 0x62FE, 0x62FE, 
        0x62FE, 0x62FE, 0x62DE, 0x62DE, 0x5ABE, 0x5A9E, 0x529D, 0x529D, 0x529D, 0x529D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x527D, 0x527E, 0x529D, 0x529D, 0x529E, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BE, 
        0x52BE, 0x4A5E, 0x297D, 0x18DD, 0x215D, 0x29BD, 0x31FD, 0x3A3D, 0x423D, 0x421D, 0x421D, 0x52DD, 0x637E, 0x5B7E, 0x52FD, 0x42BD, 0x429D, 0x4ADD, 0x5B1D, 0x5B3A, 0x4296, 0x3A14, 0x31F2, 0x6337, 0x94BE, 0x7C1E, 0x633E, 0x423C, 0x31BC, 0x319D, 
        0x319D, 0x319D, 0x319D, 0x299C, 0x299C, 0x299C, 0x299C, 0x319C, 0x299C, 0x299C, 0x299C, 0x299B, 0x299B, 0x299B, 0x29BA, 0x29BA, 0x29B9, 0x3218, 0x3257, 0x3AB4, 0x3B31, 0x3B6E, 0x3BAC, 0x3BCA, 0x3BCA, 0x33C9, 0x33C9, 0x33C9, 0x33C9, 0x33E9, 
        0x33E9, 0x33EA, 0x2BE9, 0x23E9, 0x23E9, 0x2BE9, 0x2C09, 0x2C09, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1C08, 0x1C08, 0x1C08, 0x1BE8, 0x1BE8, 0x1BC8, 0x1BC8, 0x1BE8, 0x1BE8, 0x23E9, 0x1C09, 0x1C09, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 
        0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x242A, 0x2C0A, 0x240A, 0x2BEA, 0x2BAA, 0x2B6B, 0x3B6C, 0x438B, 0x432A, 0x3AE9, 0x3B08, 0x3AE8, 0x3B08, 0x3B08, 0x3B28, 0x3B48, 0x3B48, 0x3B48, 0x3B48, 0x4348, 0x4348, 0x4348, 
        0x4349, 0x4329, 0x3B28, 0x3B08, 0x32E8, 0x32C8, 0x32A7, 0x2A87, 0x2A67, 0x2A48, 0x2A48, 0x3289, 0x4B2C, 0x5BCE, 0x640F, 0x6C50, 0x6C70, 0x7490, 0x84D1, 0x8511, 0x8531, 0x8571, 0x8590, 0x8590, 0x8590, 0x8590, 0x85B0, 0x8590, 0x8590,
  0x4449, 0x4C69, 0x54CA, 0x5D2C, 0x6D8D, 0x75AF, 0x7DB0, 0x8590, 0x8D70, 0x8D50, 0x854F, 0x9633, 0x9E95, 0x8DD2, 0x74CE, 0x6C6D, 0x6C6D, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CAD, 0x648D, 0x648C, 0x648C, 0x6CCD, 0x750E, 0x7D2F, 0x850F, 0x7CAE, 0x7CCE, 
        0x7CCE, 0x6C8D, 0x646C, 0x64AD, 0x6CED, 0x6D0E, 0x6CED, 0x6CED, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x7D0E, 0x852F, 0x854F, 0x854F, 0x852F, 0x8D4F, 0x9570, 0x9D70, 0xA570, 0xA570, 0xAD91, 0xAD91, 0xB5B1, 0xB5B1, 0xB5B1, 0xB591, 0xB572, 0xB573, 
        0xA532, 0x8490, 0x7450, 0x642F, 0x542E, 0x4C2D, 0x442D, 0x4C4E, 0x4C6E, 0x4C6E, 0x4C6E, 0x4C6E, 0x5CAF, 0x64F0, 0x6D11, 0x7511, 0x8552, 0x6C8F, 0x5C0C, 0x3B68, 0x22E5, 0x1AE4, 0x1AE4, 0x1B04, 0x1AE4, 0x1AC3, 0x1AC3, 0x1AC3, 0x1AC4, 0x1AE4, 
        0x2304, 0x2304, 0x2325, 0x2B25, 0x2B45, 0x2B66, 0x3386, 0x3386, 0x33A7, 0x3BC7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C08, 0x3C08, 0x3C08, 0x4408, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3407, 0x2BE7, 0x33C8, 0x3BC9, 0x3BCA, 0x43AB, 0x4B8B, 0x538C, 0x6BAC, 
        0x842E, 0x8C4D, 0x946D, 0x94AD, 0x8CAC, 0x8C8C, 0x8C8C, 0x8C8C, 0x848C, 0x846B, 0x846B, 0x846B, 0x846B, 0x846B, 0x846B, 0x844B, 0x844B, 0x844A, 0x844A, 0x844A, 0x844A, 0x842A, 0x840A, 0x840A, 0x840A, 0x7C0A, 0x7C0A, 0x840A, 0x840A, 0x840A, 
        0x840A, 0x840A, 0x842B, 0x840B, 0x840B, 0x840B, 0x842B, 0x8C4B, 0x8C6C, 0x8C6C, 0x8C4B, 0x946B, 0x948C, 0x948C, 0x8C6C, 0x844B, 0x842B, 0x948C, 0xA4ED, 0xB4ED, 0xB4ED, 0xB50D, 0xB52D, 0xB54E, 0xBD6E, 0xBD4E, 0xB52E, 0xACF1, 0x9C56, 0x6256, 
        0x49B9, 0x499A, 0x499B, 0x41BC, 0x41BD, 0x39BD, 0x39BD, 0x39BD, 0x39DD, 0x41DD, 0x41FD, 0x421D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A3E, 0x3A5E, 0x3A5E, 0x3A5E, 0x3A3E, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x31FD, 0x321D, 0x31FD, 0x31FD, 
        0x31FD, 0x31FD, 0x31DD, 0x29BD, 0x29BD, 0x299D, 0x297D, 0x215D, 0x297D, 0x31FD, 0x429E, 0x52FE, 0x533E, 0x5B3E, 0x5B3E, 0x5B3D, 0x5B1E, 0x5B1E, 0x5B1E, 0x52BE, 0x425D, 0x423D, 0x423D, 0x3A3D, 0x3A3D, 0x3A3D, 0x423D, 0x425D, 0x425D, 0x425D, 
        0x425D, 0x425D, 0x4A5D, 0x425D, 0x425D, 0x423D, 0x421D, 0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x3A1D, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x39FD, 0x39DD, 0x39DD, 0x39DD, 0x41DD, 0x421D, 0x4A5E, 0x527E, 0x5ABE, 0x62DE, 0x6B1E, 0x6B3E, 
        0x6B3E, 0x6AFD, 0x62DD, 0x6AFD, 0x6AFD, 0x62FE, 0x62DE, 0x62DD, 0x62DD, 0x631E, 0x6B3E, 0x62FD, 0x5ADD, 0x52BD, 0x529E, 0x529E, 0x5ABE, 0x6ADE, 0x72FE, 0x731E, 0x731E, 0x731E, 0x72FE, 0x731E, 0x6AFE, 0x6ADE, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 
        0x5ADD, 0x5ABD, 0x5ABD, 0x5A9D, 0x529E, 0x527D, 0x527D, 0x529D, 0x529D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A7D, 0x529D, 0x529D, 0x529E, 0x529D, 0x529D, 0x529E, 0x52BE, 0x52DE, 0x5ADE, 0x5ADE, 0x52DD, 0x52DD, 0x52DD, 0x5ADE, 
        0x52BE, 0x423D, 0x213C, 0x18FD, 0x219D, 0x29DD, 0x3A1D, 0x423D, 0x4A3D, 0x4A3D, 0x4A3D, 0x52DD, 0x635E, 0x637E, 0x5B5E, 0x533E, 0x52FD, 0x52FE, 0x5B3D, 0x6B7B, 0x6B9A, 0x4254, 0x3A11, 0x6355, 0x9D1B, 0x94DB, 0x7C3B, 0x633B, 0x4A5B, 0x39BB, 
        0x319B, 0x317B, 0x317B, 0x297B, 0x297B, 0x299B, 0x29BA, 0x29BA, 0x29D9, 0x31D9, 0x29F8, 0x3218, 0x3218, 0x3A58, 0x3A97, 0x42D6, 0x42F5, 0x4313, 0x4331, 0x436F, 0x3B8D, 0x3BAB, 0x3BCA, 0x3BCA, 0x3BC9, 0x3BC9, 0x33C9, 0x33C9, 0x33E9, 0x33E9, 
        0x33E9, 0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C09, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1C08, 0x1C08, 0x1C08, 0x1BE8, 0x1BE8, 0x1BE8, 0x1BE8, 0x2409, 0x1BC8, 0x23E9, 0x2409, 0x1C09, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 
        0x1C29, 0x1C28, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x2429, 0x240A, 0x2409, 0x23E9, 0x23CA, 0x2B8A, 0x336B, 0x436B, 0x4B6B, 0x430A, 0x3B08, 0x3AE8, 0x3B08, 0x3B08, 0x3B28, 0x3B48, 0x4369, 0x4369, 0x4369, 0x4369, 0x4348, 0x4348, 
        0x4349, 0x4329, 0x3B08, 0x32E8, 0x32C8, 0x32C8, 0x2AA7, 0x2AA7, 0x32A8, 0x32A9, 0x42EA, 0x538C, 0x640F, 0x6CB0, 0x74F0, 0x7D11, 0x7D10, 0x7D31, 0x8551, 0x8571, 0x8570, 0x8590, 0x8590, 0x85B0, 0x85B0, 0x85AF, 0x85AF, 0x7DAF, 0x7D8F,
  0x4C69, 0x4C89, 0x4CCA, 0x5D0B, 0x656D, 0x75AF, 0x75CF, 0x85D0, 0x8DD0, 0x8D90, 0x858F, 0x9633, 0x9E74, 0x9613, 0x7D10, 0x6C8E, 0x6C8D, 0x6C8D, 0x6C8D, 0x6CAE, 0x6CCE, 0x6CCE, 0x6CAD, 0x64AC, 0x648C, 0x6CAD, 0x750E, 0x7D4F, 0x850F, 0x7CAE, 0x7CCE, 
        0x7CCE, 0x6C8D, 0x648C, 0x64CD, 0x6CCD, 0x6CED, 0x6CED, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74CD, 0x7D0E, 0x854F, 0x854F, 0x854F, 0x854F, 0x8D4F, 0x9570, 0x9D90, 0xA590, 0xAD91, 0xADB1, 0xB5D1, 0xB5D2, 0xBDD2, 0xBDB2, 0xB5B1, 0xBDB3, 0xBD93, 
        0xAD73, 0x84B0, 0x744F, 0x6C4F, 0x5C4E, 0x4C2D, 0x442D, 0x444D, 0x4C8E, 0x4C8F, 0x4C8F, 0x4C6E, 0x548F, 0x5CAF, 0x64B0, 0x7512, 0x7D12, 0x644E, 0x646E, 0x3B69, 0x22E5, 0x1AE4, 0x1AE4, 0x1B04, 0x1AE3, 0x1AC3, 0x1AC3, 0x1AC3, 0x1AC3, 0x1AE4, 
        0x1AE4, 0x1B04, 0x2304, 0x2325, 0x2B45, 0x2B65, 0x2B66, 0x3386, 0x3386, 0x33C6, 0x33C7, 0x3BC7, 0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3C07, 0x3C27, 0x3C07, 0x3C07, 0x3407, 0x33E7, 0x33E7, 0x3BE8, 0x43C9, 0x4BCA, 0x5BEC, 0x63CD, 0x73CC, 
        0x842D, 0x8C6D, 0x948D, 0x94AD, 0x8CAC, 0x8C8C, 0x8C8C, 0x8C8C, 0x846B, 0x844B, 0x846B, 0x848B, 0x848B, 0x848B, 0x846B, 0x844B, 0x844B, 0x844A, 0x844A, 0x844A, 0x8C4A, 0x842A, 0x842A, 0x840A, 0x840A, 0x840A, 0x840A, 0x840A, 0x840A, 0x840A, 
        0x840A, 0x840A, 0x8C2B, 0x8C2B, 0x8C2C, 0x842B, 0x842B, 0x842B, 0x7389, 0x5AE7, 0x73A9, 0x946B, 0x946C, 0x948C, 0x8C8C, 0x846B, 0x844B, 0x8C8C, 0xA4CD, 0xACED, 0xB4ED, 0xB50D, 0xB52E, 0xBD4E, 0xBD4E, 0xBD4E, 0xBD4E, 0xB530, 0xACD5, 0x7B37, 
        0x49B7, 0x499A, 0x419B, 0x41BC, 0x41BD, 0x399D, 0x39BD, 0x39BD, 0x39BD, 0x39DD, 0x39FE, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A5E, 0x425D, 0x425D, 0x3A5E, 0x3A5E, 0x3A5E, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x321D, 0x321D, 0x321D, 0x321D, 
        0x321D, 0x321D, 0x31FD, 0x31DD, 0x29DD, 0x29BD, 0x299D, 0x217D, 0x215D, 0x217C, 0x321D, 0x4ABD, 0x531E, 0x533E, 0x533E, 0x5B3D, 0x5B1D, 0x5B1E, 0x531E, 0x531E, 0x4ABD, 0x423D, 0x3A1D, 0x3A1D, 0x3A1D, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 
        0x421D, 0x421D, 0x421D, 0x3A1D, 0x3A1D, 0x39FD, 0x39FD, 0x39DD, 0x31DD, 0x31DD, 0x39DD, 0x39DD, 0x39DD, 0x31BD, 0x31BD, 0x31BD, 0x39BD, 0x39DD, 0x39DD, 0x39DD, 0x41DD, 0x4A1D, 0x525D, 0x527E, 0x5A7E, 0x5A9E, 0x62DE, 0x62FE, 0x6B1E, 0x6B3E, 
        0x6B1E, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x5ADD, 0x5ADD, 0x5ADD, 0x62FE, 0x631E, 0x5ADE, 0x52BD, 0x529D, 0x529D, 0x5A9D, 0x62DE, 0x72FE, 0x731E, 0x7B3E, 0x7B5E, 0x733E, 0x731E, 0x6AFE, 0x6AFE, 0x6ADD, 0x6ADE, 0x62DD, 0x5ABD, 0x5ABD, 
        0x5ABD, 0x5ABD, 0x5ABD, 0x529D, 0x529E, 0x529E, 0x529D, 0x529D, 0x52BD, 0x4A9D, 0x4A9D, 0x4A9E, 0x4A9E, 0x529E, 0x4A7D, 0x529D, 0x529D, 0x529D, 0x529E, 0x529D, 0x529D, 0x52BD, 0x52BE, 0x5ADE, 0x5AFE, 0x5AFD, 0x5ADD, 0x52DD, 0x52DD, 0x52DE, 
        0x52BD, 0x39FD, 0x18FC, 0x213D, 0x219D, 0x31DD, 0x3A1D, 0x425D, 0x4A5D, 0x4A3D, 0x4A5D, 0x5AFE, 0x6B9E, 0x6BBE, 0x6B9E, 0x637E, 0x635E, 0x633E, 0x633D, 0x73DD, 0x8C5D, 0x73B9, 0x4231, 0x5B13, 0x9D39, 0x9517, 0x8477, 0x6B98, 0x5AD9, 0x5ADB, 
        0x4A59, 0x39F8, 0x39F9, 0x39F9, 0x3219, 0x3A58, 0x3A77, 0x3A96, 0x3AB5, 0x3AD4, 0x32D3, 0x3AD3, 0x3AF3, 0x4312, 0x4352, 0x4B71, 0x4B90, 0x4BAF, 0x43CD, 0x43CC, 0x3BCB, 0x3BCA, 0x43CA, 0x3BCA, 0x3BC9, 0x442B, 0x3C0A, 0x33E9, 0x33E9, 0x33E9, 
        0x2BC9, 0x33E9, 0x2BEA, 0x2BE9, 0x2BE9, 0x2C09, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x1C08, 0x1BE9, 0x23E9, 0x23E8, 0x1BC8, 0x1BC8, 0x23E8, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1C09, 0x1C09, 0x1C09, 0x1C29, 
        0x1C29, 0x1C29, 0x1C29, 0x2449, 0x1C29, 0x1C29, 0x1C29, 0x2429, 0x2429, 0x2409, 0x2409, 0x1C09, 0x23E9, 0x2BAA, 0x338B, 0x3B6B, 0x4B8C, 0x434A, 0x3B09, 0x3AE8, 0x3B08, 0x3B08, 0x3B28, 0x3B28, 0x3B49, 0x4369, 0x4369, 0x4369, 0x4349, 0x4349, 
        0x3B29, 0x3B09, 0x3AE8, 0x32E8, 0x32A8, 0x32C8, 0x3AE8, 0x434A, 0x4B8B, 0x53AC, 0x5BED, 0x6C6F, 0x74D0, 0x7D30, 0x7D50, 0x7D50, 0x7D70, 0x8570, 0x8590, 0x8590, 0x85B0, 0x85B0, 0x85B0, 0x85B0, 0x85AF, 0x85AF, 0x85AF, 0x85AF, 0x85AF,
  0x4C69, 0x4469, 0x4CA9, 0x550B, 0x656D, 0x75CF, 0x75CF, 0x7DF0, 0x85D0, 0x85B0, 0x858F, 0x9632, 0x9653, 0x9E33, 0xA634, 0x8D51, 0x74AE, 0x748D, 0x6C8D, 0x6CAD, 0x6CCE, 0x6CCE, 0x6CAD, 0x6CAD, 0x648C, 0x6CAD, 0x750E, 0x854F, 0x850F, 0x7CAE, 0x7CCE, 
        0x7CCE, 0x6C8D, 0x648D, 0x64AD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74ED, 0x7D0E, 0x852F, 0x852F, 0x854F, 0x8D2F, 0x8D4F, 0x9570, 0x9D90, 0xA5B1, 0xADD1, 0xB5D2, 0xB5F2, 0xBDD2, 0xBDD2, 0xBDD2, 0xBDD2, 0xBDD3, 0xBDB3, 
        0xAD73, 0x8CD1, 0x7470, 0x7490, 0x648F, 0x4C4D, 0x442C, 0x442D, 0x4C8E, 0x4CAF, 0x54AF, 0x548F, 0x548F, 0x5C6F, 0x648F, 0x6CD1, 0x74D1, 0x6C4F, 0x4B8B, 0x32E7, 0x22C5, 0x22E5, 0x1AE4, 0x1B04, 0x1AE4, 0x1AE3, 0x1AC3, 0x1AE3, 0x1AC3, 0x1AE4, 
        0x1AE4, 0x1B04, 0x1B04, 0x2324, 0x2345, 0x2B45, 0x2B65, 0x2B66, 0x2B86, 0x2BA6, 0x33C6, 0x33C6, 0x33E6, 0x3BE7, 0x3C07, 0x3C07, 0x3C07, 0x3C27, 0x3C27, 0x3C27, 0x3407, 0x3407, 0x3407, 0x33E7, 0x3BE8, 0x43A9, 0x4BAA, 0x640D, 0x740D, 0x840D, 
        0x8C2D, 0x948D, 0x9CAD, 0x94AD, 0x94AD, 0x8CAC, 0x8C8C, 0x8C8C, 0x846B, 0x844B, 0x846B, 0x848B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C4A, 0x8C4A, 0x842A, 0x840A, 0x840A, 0x840A, 0x840B, 0x840B, 0x840B, 0x8C2B, 
        0x842C, 0x8C2B, 0x8C2C, 0x8C4C, 0x8C4C, 0x8C2C, 0x842C, 0x7BEB, 0x6B4A, 0x7C0C, 0x8C4C, 0x946C, 0x946C, 0x948C, 0x8C8C, 0x846C, 0x842B, 0x8C6C, 0x9CCD, 0xACED, 0xB4ED, 0xB50E, 0xB52E, 0xBD4E, 0xBD4E, 0xBD2E, 0xBD2E, 0xBD4F, 0xB512, 0x9416, 
        0x5A16, 0x4198, 0x417A, 0x419B, 0x399C, 0x399D, 0x399D, 0x399D, 0x39BD, 0x39BD, 0x39DD, 0x39FD, 0x39FD, 0x39FD, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A5D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x321D, 0x3A1D, 0x321D, 
        0x321D, 0x321D, 0x31FD, 0x31DD, 0x29DD, 0x29BD, 0x29BD, 0x219D, 0x217D, 0x215D, 0x297C, 0x31DD, 0x427E, 0x52FE, 0x531D, 0x531D, 0x533D, 0x531D, 0x531E, 0x531E, 0x52FE, 0x427D, 0x3A1D, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x39FD, 0x39FD, 0x39DD, 
        0x39DD, 0x39DD, 0x39DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x319D, 0x319D, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x319D, 0x319D, 0x319D, 0x39BD, 0x39BD, 0x41DD, 0x41FD, 0x525D, 0x5A9E, 0x5A9D, 0x5A9D, 0x5ABD, 0x5ABD, 0x62DE, 0x6AFE, 0x6AFE, 0x6AFE, 
        0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x5ADD, 0x5ABD, 0x5ADD, 0x62DD, 0x5ADD, 0x5ABD, 0x52BD, 0x52BD, 0x529D, 0x5ABE, 0x6AFE, 0x731E, 0x733E, 0x7B5E, 0x7B5E, 0x733E, 0x6AFE, 0x62DD, 0x62DD, 0x62DD, 0x62FE, 0x62DE, 0x5ADD, 0x5ABD, 
        0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529E, 0x529E, 0x529D, 0x52BD, 0x52BD, 0x4ABD, 0x4A9D, 0x4A9D, 0x4A9D, 0x529D, 0x4A9D, 0x529D, 0x529E, 0x529E, 0x529E, 0x529D, 0x52BD, 0x52BE, 0x52DE, 0x5ADE, 0x5AFE, 0x5AFD, 0x5ADD, 0x5ADD, 0x52DD, 0x5ADE, 
        0x52BD, 0x31DD, 0x10FD, 0x215D, 0x29BD, 0x321D, 0x3A3D, 0x4A7E, 0x4A5D, 0x4A3D, 0x4A5E, 0x5ADD, 0x6B9E, 0x73FE, 0x73FE, 0x73FE, 0x6BBE, 0x6B9E, 0x739E, 0x843E, 0x949D, 0x94BC, 0x7BB7, 0x52B1, 0x9CF7, 0x9515, 0x8495, 0x7396, 0x62F5, 0x6335, 
        0x5314, 0x4AF4, 0x4AF4, 0x4314, 0x42F4, 0x4313, 0x4332, 0x4350, 0x3B6F, 0x3B8E, 0x3B8E, 0x3B6E, 0x438E, 0x43AD, 0x4BCD, 0x4BED, 0x4C0C, 0x4BEB, 0x4BEB, 0x43CB, 0x3BCA, 0x43CA, 0x43CA, 0x3BCA, 0x3BEA, 0x4C6C, 0x444B, 0x33EA, 0x33C9, 0x2BC9, 
        0x2BC9, 0x2BE9, 0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x23E9, 0x23E8, 0x1BC8, 0x1BC8, 0x23C9, 0x23E9, 0x23E9, 0x23C8, 0x23E9, 0x1C09, 0x1C09, 0x1C09, 0x1C29, 
        0x1C29, 0x1C29, 0x1C08, 0x1C29, 0x1C29, 0x1C08, 0x1C28, 0x1C29, 0x1C28, 0x2409, 0x1C09, 0x1C09, 0x23E9, 0x23CA, 0x33AB, 0x3B8B, 0x4BCD, 0x4BAC, 0x3B09, 0x3AE8, 0x3AE8, 0x3B08, 0x3B28, 0x3B28, 0x3B49, 0x4369, 0x4369, 0x4369, 0x3B49, 0x3B29, 
        0x3B29, 0x4329, 0x4329, 0x432A, 0x434A, 0x4B8B, 0x5BEC, 0x646E, 0x6C8F, 0x74CF, 0x7D10, 0x7D10, 0x7D50, 0x7D4F, 0x7D6F, 0x7D8F, 0x7D8F, 0x85B0, 0x85B0, 0x8590, 0x85B0, 0x85AF, 0x85AF, 0x85CF, 0x85AF, 0x85AF, 0x85AF, 0x85AF, 0x7DAF,
  0x4C49, 0x4469, 0x4CA9, 0x550A, 0x5D6C, 0x6DCE, 0x75EF, 0x7DEF, 0x85D0, 0x858F, 0x7D8F, 0x8E31, 0x9632, 0x9E13, 0xB696, 0xAE75, 0x8D30, 0x748E, 0x6C8D, 0x6C8D, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCD, 0x64AD, 0x6CCD, 0x750E, 0x854F, 0x852F, 0x7CAE, 0x7CCE, 
        0x7CCE, 0x6CAD, 0x648D, 0x64AD, 0x64AD, 0x64AD, 0x64AD, 0x6CCD, 0x6CCD, 0x6CCD, 0x6CCD, 0x74EE, 0x7D0E, 0x7D2E, 0x852F, 0x852F, 0x8D4F, 0x954F, 0x9D90, 0xA5B0, 0xADD1, 0xB5F2, 0xBE12, 0xBDF2, 0xBDF2, 0xB5D2, 0xBDD2, 0xBDB2, 0xBDB2, 0xBD92, 
        0xB593, 0x9D32, 0x7C90, 0x6C8F, 0x64D0, 0x546E, 0x442D, 0x3C0D, 0x444E, 0x4CAF, 0x54AF, 0x548F, 0x546F, 0x5C6F, 0x5C50, 0x6470, 0x6C71, 0x6C70, 0x5BED, 0x32E8, 0x22C6, 0x22E5, 0x22E4, 0x1B04, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE3, 0x1AE3, 0x1AE4, 
        0x1AE4, 0x1B04, 0x1B04, 0x1B04, 0x2325, 0x2345, 0x2345, 0x2365, 0x2385, 0x2B86, 0x2BA6, 0x2BA6, 0x33C6, 0x33E6, 0x33E7, 0x3407, 0x3407, 0x3407, 0x3427, 0x3427, 0x3407, 0x3407, 0x3407, 0x3BE7, 0x4408, 0x43C9, 0x53A9, 0x6C0C, 0x7C2D, 0x8C2D, 
        0x946D, 0x948D, 0x9CAD, 0x94AD, 0x94CD, 0x94CC, 0x94AC, 0x8C8C, 0x848B, 0x846B, 0x846B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C4B, 0x842B, 0x840B, 0x840B, 0x840B, 0x842B, 0x8C2C, 0x8C2C, 
        0x840D, 0x8C0D, 0x8C0E, 0x8C0E, 0x8C0E, 0x83EE, 0x83EE, 0x738D, 0x738D, 0x842E, 0x8C4E, 0x946D, 0x946D, 0x946C, 0x946C, 0x8C4C, 0x842C, 0x8C4C, 0x9CAD, 0xACED, 0xB50E, 0xB50E, 0xB52E, 0xB54E, 0xB54E, 0xBD2E, 0xBD4E, 0xBD4F, 0xB531, 0xA4B4, 
        0x7B16, 0x49B7, 0x417A, 0x397B, 0x397C, 0x397C, 0x397D, 0x399D, 0x399D, 0x39BD, 0x39BD, 0x39DD, 0x39DD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 
        0x321D, 0x3A1D, 0x321D, 0x31FD, 0x31DD, 0x31DD, 0x29BD, 0x299D, 0x217D, 0x215D, 0x213D, 0x295D, 0x299D, 0x3A1D, 0x4ABE, 0x531D, 0x531D, 0x531D, 0x531D, 0x531E, 0x52FE, 0x52DE, 0x423D, 0x31DD, 0x31BD, 0x31BD, 0x31BD, 0x31DE, 0x31DE, 0x319D, 
        0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x299D, 0x299D, 0x319D, 0x319D, 0x319D, 0x319D, 0x317D, 0x317D, 0x317D, 0x399D, 0x41FD, 0x4A3D, 0x527D, 0x5ABE, 0x62DE, 0x62DE, 0x5ABD, 0x62BD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 
        0x62BD, 0x62BD, 0x62DE, 0x62DE, 0x62DD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5ADD, 0x5ADD, 0x62DE, 0x62FE, 0x62FE, 0x62DD, 0x62DD, 0x6AFE, 0x6AFD, 0x6AFD, 0x731D, 0x731E, 0x6AFE, 0x62DD, 0x5ABD, 0x5ABD, 0x5ADD, 0x62DE, 0x5AFE, 0x5ADE, 0x5ABD, 
        0x52BD, 0x52BE, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x4A9D, 0x4A9D, 0x4A9D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529E, 0x52BD, 0x52BD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFD, 0x5ADE, 0x5ADE, 0x5ADE, 
        0x4A9D, 0x299D, 0x191D, 0x219D, 0x29FD, 0x3A3D, 0x427E, 0x4A7E, 0x4A3D, 0x4A3D, 0x4A3D, 0x529D, 0x6B5D, 0x73DD, 0x7C1E, 0x843E, 0x7C1E, 0x841E, 0x8C7E, 0x9CDF, 0xAD1E, 0xB53E, 0xACFC, 0x7373, 0x8C95, 0x9515, 0x8494, 0x73B4, 0x6373, 0x6391, 
        0x536F, 0x4B6E, 0x4BAF, 0x4BAF, 0x4B8E, 0x43AE, 0x43AD, 0x43CC, 0x3BCC, 0x3BEB, 0x3BCB, 0x43EB, 0x43CB, 0x43EB, 0x4C0B, 0x4C0B, 0x4C2B, 0x4C0A, 0x4C0A, 0x43EA, 0x43EA, 0x43EA, 0x43EA, 0x3BCA, 0x3BEA, 0x440A, 0x442A, 0x33E9, 0x33C9, 0x33C9, 
        0x33C9, 0x33C9, 0x33EA, 0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23C9, 0x1BC8, 0x1BC8, 0x1BC8, 0x23E9, 0x2409, 0x23C9, 0x23C9, 0x1BE9, 0x2409, 0x1C09, 0x2409, 
        0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C28, 0x1C09, 0x1C09, 0x2409, 0x23CA, 0x2BCA, 0x338B, 0x43AC, 0x53CD, 0x434A, 0x3AE8, 0x3AE8, 0x3B08, 0x4329, 0x3B29, 0x4349, 0x4369, 0x438A, 0x436A, 0x4349, 0x4349, 
        0x434A, 0x53AB, 0x5C0D, 0x644D, 0x644E, 0x6C6E, 0x74CF, 0x7CF0, 0x7D30, 0x7D50, 0x7D70, 0x7D70, 0x7D70, 0x7D6F, 0x7D8F, 0x7DAF, 0x85AF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85AF, 0x85AF, 0x85AF, 0x7DAF, 0x85AF, 0x85AF, 0x7DAF, 0x7D8F,
  0x4469, 0x4489, 0x44A9, 0x4CEA, 0x5D8C, 0x6DCE, 0x75EF, 0x75EF, 0x7DAF, 0x7D6E, 0x7D6E, 0x8E11, 0x9612, 0x9DF2, 0x9DF3, 0x9DD3, 0x8D51, 0x7CAE, 0x748D, 0x6C8D, 0x6C8D, 0x6CCD, 0x6CCD, 0x74EE, 0x6CED, 0x6CED, 0x750E, 0x854F, 0x852F, 0x7CCE, 0x7CAE, 
        0x74AE, 0x6C8D, 0x648C, 0x648C, 0x648C, 0x64AD, 0x64AD, 0x64AD, 0x6CAD, 0x6CCD, 0x6CCD, 0x74EE, 0x750E, 0x7D0E, 0x7D2E, 0x852F, 0x8D4F, 0x956F, 0x9DB0, 0xADD0, 0xB5F1, 0xB632, 0xBE32, 0xBE12, 0xB5F1, 0xB5D1, 0xB5B1, 0xB591, 0xB571, 0xB572, 
        0xAD73, 0xA553, 0x7C8F, 0x74AF, 0x6CF0, 0x64CF, 0x4C4D, 0x3BEC, 0x442D, 0x4C8E, 0x54B0, 0x54B0, 0x5C90, 0x5C70, 0x5C50, 0x6430, 0x6C50, 0x7471, 0x5BEE, 0x3B29, 0x2AC6, 0x22E5, 0x2304, 0x1B04, 0x1B04, 0x1AE4, 0x1AE4, 0x12E4, 0x12E4, 0x1AE4, 
        0x1B04, 0x1B04, 0x1B04, 0x1B04, 0x1B24, 0x2345, 0x2345, 0x2365, 0x2385, 0x2385, 0x23A6, 0x2BA6, 0x2BC6, 0x33C6, 0x33E6, 0x3407, 0x3407, 0x3407, 0x3407, 0x3407, 0x3407, 0x3407, 0x3C07, 0x3C07, 0x4408, 0x4BE8, 0x4BA8, 0x6C0B, 0x842C, 0x944D, 
        0x948D, 0x9CAD, 0x94AD, 0x94CD, 0x94CD, 0x94CC, 0x94CC, 0x8CAC, 0x8C8C, 0x8C8B, 0x8C6B, 0x8C8C, 0x8C8C, 0x8CAC, 0x8CAC, 0x8C8C, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C4B, 0x842B, 0x842B, 0x842B, 0x842C, 0x840D, 0x83CE, 0x7BAF, 
        0x7B90, 0x7B71, 0x7B72, 0x7B92, 0x7B93, 0x7B73, 0x7B72, 0x7351, 0x7391, 0x7BB1, 0x83F0, 0x8C2F, 0x8C4E, 0x944E, 0x944D, 0x8C2E, 0x840D, 0x8C2D, 0x9C8E, 0xA4CE, 0xACEF, 0xB50F, 0xB50F, 0xB52F, 0xB52E, 0xB52E, 0xBD4E, 0xBD4E, 0xB550, 0xB4F2, 
        0x9C16, 0x51F6, 0x4179, 0x395A, 0x397B, 0x395C, 0x317D, 0x317D, 0x399D, 0x399D, 0x39BD, 0x31BD, 0x39BD, 0x39DD, 0x39FD, 0x39FD, 0x3A1D, 0x3A1E, 0x3A1E, 0x3A1D, 0x321D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A1D, 
        0x3A1D, 0x3A3D, 0x3A1D, 0x321D, 0x31FD, 0x31DD, 0x31DD, 0x29BD, 0x299D, 0x217D, 0x215D, 0x295D, 0x293D, 0x293D, 0x39FD, 0x4ADD, 0x531D, 0x533D, 0x531D, 0x531D, 0x531D, 0x52FE, 0x4A9D, 0x3A1C, 0x31BD, 0x299D, 0x299D, 0x31BD, 0x299D, 0x297D, 
        0x299D, 0x299D, 0x299D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 0x299D, 0x299D, 0x319D, 0x317D, 0x317C, 0x39BD, 0x4A1E, 0x527E, 0x5A9E, 0x5ABE, 0x62DE, 0x62DE, 0x62DD, 0x5ADD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62BD, 
        0x62BD, 0x62DD, 0x62DE, 0x62FE, 0x62DE, 0x5ADD, 0x5ABD, 0x5ADE, 0x5ADE, 0x62DE, 0x62FE, 0x62FE, 0x6B1E, 0x6B1E, 0x6AFD, 0x6AFD, 0x6AFE, 0x6AFE, 0x6AFD, 0x6AFD, 0x6AFD, 0x62DE, 0x62DE, 0x5ABD, 0x5ABD, 0x5ADD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5ADE, 
        0x52DE, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x529E, 0x4A9E, 0x4A9D, 0x4A9D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x52BD, 0x52DD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5ADE, 
        0x4A5D, 0x215D, 0x195D, 0x29DD, 0x323D, 0x425E, 0x4A7E, 0x4A7D, 0x4A5D, 0x4A3D, 0x525D, 0x5A7D, 0x62FC, 0x739C, 0x841D, 0x8C5E, 0x947E, 0x9C9E, 0xA4DE, 0xAD1E, 0xBD7F, 0xC57F, 0xBD3D, 0x9C98, 0x9495, 0x94D5, 0x8474, 0x73B2, 0x63B1, 0x5BAF, 
        0x4BAC, 0x4BAB, 0x4BEC, 0x540C, 0x4C0C, 0x4C0C, 0x4C0B, 0x43EB, 0x43EB, 0x440B, 0x43EA, 0x43EA, 0x43EA, 0x43EA, 0x43EA, 0x4C0A, 0x4C0A, 0x4C0A, 0x43EA, 0x43EA, 0x43EA, 0x440A, 0x440A, 0x43EA, 0x440A, 0x3BEA, 0x3BEA, 0x3BE9, 0x33C9, 0x33C9, 
        0x33C9, 0x33C9, 0x33EA, 0x33EA, 0x2BC9, 0x33E9, 0x33E9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23C9, 0x23C8, 0x1BC8, 0x1BC8, 0x1BC8, 0x23C8, 0x23E9, 0x23E9, 0x23C9, 0x23C8, 0x23E9, 0x2409, 0x2409, 
        0x2409, 0x2409, 0x1C08, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C28, 0x1C08, 0x1C09, 0x1C09, 0x23E9, 0x23CA, 0x2BAB, 0x3BAC, 0x53ED, 0x4B8B, 0x3AE9, 0x3AE9, 0x3B09, 0x4329, 0x3B49, 0x4349, 0x4369, 0x4B8A, 0x4B8A, 0x4B6A, 0x4BAB, 
        0x5BEC, 0x6CAF, 0x74CF, 0x7510, 0x7510, 0x7D10, 0x7D30, 0x7D50, 0x7D4F, 0x7D6F, 0x756F, 0x756F, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85AF, 0x85AF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85AF, 0x85AF,
  0x4469, 0x44A9, 0x44C9, 0x4CEA, 0x556C, 0x65AD, 0x6DCF, 0x75EF, 0x75AE, 0x756E, 0x7D6E, 0x8E11, 0x9611, 0x95F2, 0x9DB2, 0x95B2, 0x8D51, 0x7CCF, 0x748D, 0x6C8D, 0x648C, 0x64AD, 0x6CCD, 0x6CED, 0x6CED, 0x6CED, 0x752E, 0x7D4F, 0x852F, 0x7CCF, 0x74AE, 
        0x74AE, 0x6C8D, 0x648D, 0x648C, 0x648C, 0x648D, 0x64AD, 0x64AD, 0x64AD, 0x6CCD, 0x6CCD, 0x74ED, 0x74EE, 0x7D0E, 0x850E, 0x8D4F, 0x8D6F, 0x958F, 0x9DB0, 0xA5D0, 0xADF1, 0xB611, 0xB611, 0xB5F1, 0xB5F1, 0xBDD1, 0xB5B1, 0xB5B1, 0xB591, 0xB572, 
        0xB593, 0x9D52, 0x746F, 0x74CF, 0x7531, 0x6510, 0x5CAF, 0x440D, 0x3C0C, 0x444E, 0x54AF, 0x54B0, 0x5C90, 0x5C70, 0x5C30, 0x5BF0, 0x6410, 0x6C51, 0x642F, 0x436B, 0x3308, 0x22E6, 0x2305, 0x1B05, 0x1B04, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 
        0x1B04, 0x1B04, 0x1B04, 0x1B24, 0x1B24, 0x1B45, 0x1B45, 0x1B65, 0x2385, 0x2385, 0x23A6, 0x2BA6, 0x2BA6, 0x2BC6, 0x2BC6, 0x33E6, 0x3407, 0x33E7, 0x3407, 0x3407, 0x3407, 0x3C07, 0x3BE7, 0x3C07, 0x4408, 0x43E8, 0x4BA8, 0x63CA, 0x842C, 0x946D, 
        0x948D, 0x9CAD, 0x94AD, 0x94CD, 0x94CD, 0x94CC, 0x94CC, 0x94AC, 0x8CAC, 0x8C8C, 0x8C8B, 0x8C8C, 0x8C8C, 0x8CAC, 0x8CAC, 0x8C8C, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C2C, 0x8C0C, 0x840D, 0x83CF, 0x7B71, 0x6B33, 0x6AD5, 
        0x6AD6, 0x62B8, 0x6AB8, 0x6AB9, 0x6AB9, 0x6AD9, 0x6AD8, 0x6AD8, 0x6AF7, 0x6AF5, 0x72F4, 0x7313, 0x7332, 0x7B51, 0x7B70, 0x7370, 0x736F, 0x736F, 0x7B8F, 0x836F, 0x834F, 0x8B6F, 0x93CF, 0x9C4F, 0xACB0, 0xB52F, 0xBD4F, 0xBD4F, 0xB56F, 0xB530, 
        0xACB5, 0x7317, 0x4177, 0x3959, 0x315B, 0x315C, 0x315C, 0x317C, 0x317D, 0x399D, 0x319D, 0x319D, 0x39BD, 0x39BD, 0x39DD, 0x39DD, 0x39FD, 0x39FE, 0x3A1E, 0x31FD, 0x31FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A3D, 0x3A3D, 0x3A3D, 0x3A3D, 
        0x3A3D, 0x3A3D, 0x3A3D, 0x321D, 0x321E, 0x31FD, 0x31DD, 0x29BD, 0x29BD, 0x297D, 0x217D, 0x215D, 0x213D, 0x211D, 0x213D, 0x3A3D, 0x4ADE, 0x531D, 0x531D, 0x4B1E, 0x52FD, 0x52FE, 0x4ADD, 0x427E, 0x29BC, 0x297C, 0x299D, 0x297D, 0x297D, 0x295D, 
        0x297D, 0x297D, 0x297D, 0x295D, 0x295D, 0x297D, 0x297D, 0x297D, 0x295D, 0x295D, 0x295D, 0x297D, 0x317D, 0x39BD, 0x41FD, 0x527E, 0x5A9E, 0x62BE, 0x62DE, 0x62DE, 0x62FE, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62FD, 0x62FD, 0x62DD, 0x62DD, 
        0x62BD, 0x62DE, 0x62FE, 0x62FE, 0x62FE, 0x5ADE, 0x5ABD, 0x5ABD, 0x5ADD, 0x62DE, 0x62FE, 0x62FE, 0x62FD, 0x631D, 0x6B1D, 0x6B1D, 0x6AFD, 0x62FE, 0x62FD, 0x62FD, 0x62FE, 0x62FE, 0x5ADE, 0x52BD, 0x52BD, 0x52BD, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 
        0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52BE, 0x52BE, 0x529E, 0x4A9E, 0x4A9D, 0x4A9D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x52BD, 0x52DD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFE, 0x5AFE, 
        0x423D, 0x215D, 0x299E, 0x321E, 0x3A7D, 0x427D, 0x4A7D, 0x4A7D, 0x525D, 0x525D, 0x525D, 0x5A5D, 0x62DA, 0x739A, 0x7BBB, 0x8C5C, 0x9CBD, 0xA4DE, 0xB55F, 0xC59F, 0xC59F, 0xC55F, 0xBD1E, 0xACFA, 0x9CB7, 0x94B4, 0x8433, 0x73F1, 0x63AF, 0x53CD, 
        0x4BCB, 0x4BCA, 0x4C0B, 0x542B, 0x540B, 0x540B, 0x4C0B, 0x43EB, 0x43EB, 0x440A, 0x43EA, 0x43EA, 0x43E9, 0x43EA, 0x43E9, 0x43C9, 0x4BE9, 0x4C0A, 0x43EA, 0x43E9, 0x43EA, 0x440A, 0x440A, 0x43EA, 0x440A, 0x3BEA, 0x3BEA, 0x3BE9, 0x33C9, 0x33C9, 
        0x33C9, 0x33A9, 0x33EA, 0x33EA, 0x33E9, 0x33E9, 0x33E9, 0x33E9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23C9, 0x23C9, 0x23C8, 0x23C8, 0x23C9, 0x23C9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 
        0x2409, 0x1C08, 0x1C08, 0x1C09, 0x1C09, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C28, 0x1C29, 0x1C29, 0x1C09, 0x1BE9, 0x23C9, 0x2BAA, 0x3BAB, 0x53CD, 0x5BED, 0x4B6B, 0x432A, 0x4309, 0x4329, 0x4349, 0x4349, 0x436A, 0x436A, 0x4B8A, 0x53CB, 0x5C2D, 
        0x6CCF, 0x7510, 0x752F, 0x752F, 0x7550, 0x754F, 0x7D4F, 0x7D6F, 0x756F, 0x756F, 0x756F, 0x756F, 0x758F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DCF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85AF, 0x85AF, 0x85D0,
  0x4C89, 0x4CC9, 0x44C9, 0x4D0A, 0x556C, 0x65AD, 0x6DCE, 0x75CF, 0x75AF, 0x756E, 0x7D4E, 0x8E10, 0x8DF1, 0x8DD1, 0x95B2, 0x9DB2, 0xA5F4, 0x9592, 0x7CCF, 0x6C8D, 0x6C8C, 0x6CAC, 0x6CCD, 0x6CCD, 0x6CED, 0x6CED, 0x750E, 0x854F, 0x850F, 0x7CAE, 0x74AE, 
        0x74AE, 0x6CAD, 0x648D, 0x648C, 0x648C, 0x64AD, 0x64AD, 0x648D, 0x64AD, 0x6CCD, 0x6CCD, 0x6CED, 0x74ED, 0x74EE, 0x852F, 0x8D4F, 0x9590, 0x9DB0, 0xA5D0, 0xA5D1, 0xADF1, 0xB5F1, 0xB5F1, 0xB5F1, 0xB5D1, 0xB5D1, 0xB5B1, 0xBDB1, 0xBDB2, 0xB592, 
        0xAD73, 0x8CD0, 0x746F, 0x74AF, 0x6D10, 0x6D10, 0x5CCF, 0x546E, 0x3C0C, 0x442D, 0x4C8E, 0x54AF, 0x5C90, 0x5C70, 0x5C30, 0x5C10, 0x6410, 0x6C30, 0x6C71, 0x642E, 0x4BCB, 0x2B27, 0x2305, 0x2305, 0x1B04, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 
        0x1B04, 0x1B04, 0x1B04, 0x1B24, 0x1B24, 0x1B45, 0x1B45, 0x1B65, 0x2385, 0x2386, 0x23A6, 0x23A6, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BE6, 0x2BE7, 0x33E7, 0x33E7, 0x3407, 0x3407, 0x33E7, 0x3BE7, 0x3C07, 0x43E8, 0x43C8, 0x4BA8, 0x63C9, 0x7C0C, 0x946D, 
        0x948D, 0x9CAC, 0x94AC, 0x94CD, 0x94CD, 0x94CC, 0x94CC, 0x94CC, 0x94AC, 0x8CAC, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8B, 0x8C8B, 0x948B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C6B, 0x8C2C, 0x83AC, 0x7B50, 0x8374, 0x7317, 0x6AB9, 0x6A5B, 
        0x625B, 0x625B, 0x625C, 0x5A5C, 0x5A5C, 0x625C, 0x625C, 0x625C, 0x6A7B, 0x6A9A, 0x6A99, 0x6A99, 0x6A98, 0x6AB7, 0x6AB6, 0x62B6, 0x62B5, 0x6294, 0x6293, 0x6273, 0x6A53, 0x6A53, 0x6A72, 0x72B1, 0x7B2F, 0x9C50, 0xB530, 0xBD50, 0xBD4F, 0xB54F, 
        0xB4F3, 0x9C37, 0x51F6, 0x3959, 0x313A, 0x313B, 0x313C, 0x315C, 0x317D, 0x397D, 0x397D, 0x317D, 0x399D, 0x31BD, 0x31BD, 0x31DD, 0x39DD, 0x39DE, 0x39DD, 0x31DD, 0x31DD, 0x39FD, 0x39FD, 0x3A1D, 0x321D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 
        0x3A3D, 0x3A3D, 0x3A3D, 0x321D, 0x321E, 0x31FD, 0x31FD, 0x31DD, 0x29BD, 0x299D, 0x217D, 0x215D, 0x215D, 0x211D, 0x211D, 0x215C, 0x3A3D, 0x4AFD, 0x4B1D, 0x4B1D, 0x4AFD, 0x4ADD, 0x4ADD, 0x4A9E, 0x3A1E, 0x297C, 0x297D, 0x297D, 0x215D, 0x215D, 
        0x215D, 0x215D, 0x215D, 0x215D, 0x215D, 0x215D, 0x215D, 0x295D, 0x295D, 0x295D, 0x295D, 0x319D, 0x41FE, 0x525E, 0x5A9E, 0x62BE, 0x62BD, 0x62BD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62FD, 0x62FD, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 0x6ADD, 
        0x62DD, 0x62DE, 0x62FE, 0x62DE, 0x62DD, 0x5ABE, 0x5ABD, 0x5ABD, 0x5ADE, 0x62DE, 0x62DE, 0x62FE, 0x62FD, 0x631D, 0x6B1D, 0x6B1D, 0x6B1E, 0x631D, 0x62FD, 0x5AFD, 0x5AFE, 0x5AFE, 0x5AFE, 0x52DD, 0x52BD, 0x52DD, 0x52DE, 0x52FE, 0x52FE, 0x52DE, 
        0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x4A9E, 0x4A9E, 0x4A7D, 0x529D, 0x529E, 0x529E, 0x529E, 0x529D, 0x52BE, 0x52BD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5AFD, 0x5AFE, 0x52DE, 
        0x39FD, 0x215D, 0x29DE, 0x3A5E, 0x429E, 0x427E, 0x4A7D, 0x4A5D, 0x525D, 0x525D, 0x525D, 0x5A5C, 0x62D9, 0x6B79, 0x73B9, 0x843A, 0x9C9B, 0xAD1D, 0xC59E, 0xC5BF, 0xC59F, 0xC53E, 0xBD1E, 0xB4FB, 0xACF8, 0x8C73, 0x7BF1, 0x6BEF, 0x5BAD, 0x4BCB, 
        0x43CA, 0x43C9, 0x4C0A, 0x542B, 0x542B, 0x4C0A, 0x4C0A, 0x43EA, 0x43EA, 0x440A, 0x43EA, 0x3BE9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BEA, 0x4C0A, 0x4C0A, 0x43E9, 0x43E9, 0x440A, 0x440A, 0x43E9, 0x43EA, 0x3BE9, 0x3BE9, 0x3BC9, 0x3BC9, 0x33C9, 
        0x33C9, 0x33C9, 0x3BEA, 0x33EA, 0x33E9, 0x33E9, 0x33E9, 0x33E9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23C9, 0x23A9, 0x23A9, 0x23A9, 0x23A9, 0x23C9, 0x23C9, 0x23E9, 0x2BEA, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x2409, 
        0x2409, 0x1C09, 0x1BE8, 0x1C09, 0x1C09, 0x1C08, 0x1C28, 0x1C28, 0x1C28, 0x1C28, 0x1C29, 0x1C28, 0x1C09, 0x1BE9, 0x23E9, 0x2BAA, 0x338B, 0x4BAC, 0x5BED, 0x5BED, 0x4B6B, 0x4329, 0x434A, 0x434A, 0x436A, 0x4B8A, 0x53CB, 0x5C2D, 0x6C8E, 0x74CF, 
        0x7510, 0x752F, 0x754F, 0x754F, 0x756F, 0x756F, 0x756F, 0x756F, 0x756F, 0x758F, 0x758F, 0x758F, 0x758F, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DCF, 0x7DCF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85B0, 0x85D0, 0x85B0, 0x85B0, 0x7DB0,
  0x4CAA, 0x4CCA, 0x44E9, 0x44EA, 0x552B, 0x5D8D, 0x65CE, 0x6DCE, 0x7DCF, 0x758E, 0x754D, 0x8DCF, 0x8DD0, 0x8D90, 0x9DD2, 0x9DD3, 0x9DD3, 0x9592, 0x7CCF, 0x748D, 0x6C8D, 0x6CAC, 0x6CCD, 0x6CCC, 0x6CCC, 0x6CED, 0x7D2E, 0x854F, 0x850F, 0x748E, 0x748E, 
        0x7CCE, 0x74CE, 0x64AD, 0x648D, 0x64AD, 0x64AD, 0x64AD, 0x64AD, 0x64AD, 0x64CD, 0x6CCD, 0x6CED, 0x750E, 0x7D0E, 0x852F, 0x8D6F, 0x9590, 0x9DD1, 0xA611, 0xAE11, 0xADF1, 0xB5F1, 0xB5F1, 0xB5F1, 0xB5D1, 0xBDD1, 0xB5D1, 0xB5B1, 0xBDB2, 0xB593, 
        0xA552, 0x848F, 0x7CB0, 0x74B0, 0x6CCF, 0x6D30, 0x64EF, 0x54AF, 0x4C4D, 0x442C, 0x4C6E, 0x54AF, 0x54B0, 0x5C90, 0x6450, 0x6410, 0x6410, 0x6C51, 0x7491, 0x6C90, 0x53EC, 0x3348, 0x2B06, 0x2325, 0x1B05, 0x1B04, 0x1AE4, 0x1AE4, 0x1AE4, 0x1AE4, 
        0x1B04, 0x1B04, 0x1B04, 0x1B24, 0x1B24, 0x2345, 0x1B45, 0x1B65, 0x2385, 0x2385, 0x2386, 0x23A6, 0x2BA6, 0x2BC6, 0x2BC6, 0x2BC6, 0x33E7, 0x33E7, 0x33E7, 0x33E7, 0x33E7, 0x3BE6, 0x3BE7, 0x3BE7, 0x43E7, 0x43C8, 0x4BA8, 0x63CA, 0x740C, 0x8C4D, 
        0x948D, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x948B, 0x8C8C, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x8C6B, 0x8C6B, 0x8C2C, 0x8BEF, 0x8353, 0x8319, 0x7AFC, 0x72BD, 0x627D, 
        0x623D, 0x5A3D, 0x5A3D, 0x521D, 0x521D, 0x521D, 0x51FD, 0x51FD, 0x5A1D, 0x625D, 0x623D, 0x625C, 0x625C, 0x625B, 0x625A, 0x5A3A, 0x5A39, 0x5A39, 0x5A18, 0x59F9, 0x59F8, 0x59D8, 0x59F7, 0x5A16, 0x6253, 0x6AB1, 0x8391, 0xACD1, 0xBD51, 0xBD4F, 
        0xB511, 0xA4B5, 0x7B17, 0x3957, 0x3138, 0x311A, 0x311B, 0x313C, 0x315C, 0x315D, 0x317D, 0x317D, 0x317D, 0x319D, 0x319D, 0x31BD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x31DD, 0x39DD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 
        0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 0x321D, 0x321D, 0x31FD, 0x31DD, 0x29BD, 0x299D, 0x217D, 0x215D, 0x215D, 0x213D, 0x211D, 0x211C, 0x215C, 0x3A3D, 0x4ADE, 0x4AFE, 0x4AFD, 0x4ADD, 0x4ABD, 0x4A9E, 0x425E, 0x31DD, 0x215C, 0x215D, 0x215D, 0x193D, 
        0x193D, 0x193D, 0x193D, 0x213D, 0x213D, 0x213D, 0x213D, 0x213D, 0x295D, 0x397D, 0x41DD, 0x523E, 0x5A7E, 0x5A9E, 0x62BE, 0x62BD, 0x62BD, 0x62DD, 0x6ADE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x62FE, 0x6AFE, 0x6B1E, 0x6B1E, 0x6B1E, 0x6B1E, 0x6AFE, 
        0x62DE, 0x62DD, 0x62DD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADE, 0x5ADE, 0x5AFE, 0x5AFD, 0x62FE, 0x62FE, 0x631D, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1E, 0x5B1D, 0x5AFE, 0x5AFE, 0x5AFE, 0x52FE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 
        0x52FD, 0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x529E, 0x529E, 0x4A7D, 0x527D, 0x529E, 0x529E, 0x529E, 0x529D, 0x52BE, 0x52DE, 0x5ADE, 0x5AFE, 0x5B1E, 0x631E, 0x5AFE, 0x5AFD, 0x5B1D, 0x5B1D, 0x5B1D, 0x52BE, 
        0x39DD, 0x299D, 0x321E, 0x429D, 0x4A9E, 0x4A9E, 0x4A7D, 0x525D, 0x525D, 0x525D, 0x5A5D, 0x5A7C, 0x62F9, 0x6B97, 0x73B7, 0x73B6, 0x83F7, 0xA4DA, 0xBD9D, 0xC59E, 0xC55E, 0xBD1D, 0xC51D, 0xBD1C, 0xB539, 0x9C93, 0x73EF, 0x63CD, 0x53AB, 0x4BCA, 
        0x43CA, 0x4BC9, 0x540A, 0x542B, 0x542A, 0x4C0A, 0x440A, 0x43EA, 0x43EA, 0x440A, 0x43EA, 0x43E9, 0x3BC9, 0x3BC9, 0x43C9, 0x43C9, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C0A, 0x43E9, 0x4409, 0x440A, 0x440A, 0x43E9, 0x43EA, 0x3BE9, 0x3BE9, 0x3BC9, 0x3BC9, 
        0x3BC9, 0x3BEA, 0x3C0A, 0x3BEA, 0x33EA, 0x33E9, 0x33E9, 0x33E9, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BC9, 0x2BC9, 0x2BA9, 0x2BA9, 0x2BC9, 0x2BC9, 0x2BC9, 0x2BC9, 0x2BE9, 0x2BEA, 0x342B, 0x2C0A, 0x2BE9, 0x23E9, 0x2409, 
        0x2409, 0x23E9, 0x1BE9, 0x23E9, 0x2409, 0x2409, 0x1C29, 0x1C29, 0x1C28, 0x1C28, 0x1C28, 0x1C08, 0x1C09, 0x1C09, 0x23E9, 0x2BCA, 0x33AB, 0x3B6B, 0x4B6C, 0x53CD, 0x4B6C, 0x434A, 0x436A, 0x4B6A, 0x53CB, 0x644D, 0x6CCF, 0x74EF, 0x7510, 0x7D2F, 
        0x7D2F, 0x754F, 0x756F, 0x756F, 0x756F, 0x756F, 0x756F, 0x756E, 0x758E, 0x758E, 0x758E, 0x758F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85B0, 0x85B0, 0x85D0, 0x8DB0, 0x8590, 0x7D2F, 0x6CCE,
  0x4CCA, 0x4CCA, 0x44C9, 0x44E9, 0x4D0A, 0x556C, 0x65AE, 0x6DCE, 0x7DEF, 0x7DAF, 0x7D8E, 0x85AF, 0x85AF, 0x854F, 0x95D1, 0x9DF2, 0x9592, 0x8531, 0x7CCF, 0x748E, 0x6CAD, 0x6CAD, 0x6CAD, 0x6CCC, 0x6CCD, 0x6CED, 0x7D2E, 0x854F, 0x850F, 0x7C8E, 0x748E, 
        0x7CCE, 0x74CE, 0x64AD, 0x64AD, 0x64AD, 0x64AD, 0x5CAD, 0x64AD, 0x64AD, 0x64CD, 0x6CED, 0x6CEE, 0x750E, 0x7D2F, 0x852F, 0x8D6F, 0x9590, 0x9DB0, 0xA611, 0xAE12, 0xADF1, 0xB5F1, 0xB5F1, 0xB5D1, 0xB5D1, 0xB5D1, 0xB5B1, 0xBDB1, 0xB592, 0xAD72, 
        0x94F0, 0x84B0, 0x84F1, 0x7CF0, 0x74F0, 0x6D10, 0x6510, 0x5CEF, 0x54AF, 0x4C6D, 0x444E, 0x4C8F, 0x54B0, 0x5CB0, 0x6471, 0x6431, 0x6411, 0x6430, 0x6C71, 0x6C71, 0x53AC, 0x3308, 0x2B06, 0x2305, 0x1B05, 0x1B05, 0x1B05, 0x1B04, 0x1B04, 0x1B04, 
        0x1B04, 0x1B04, 0x1B04, 0x1B24, 0x1B24, 0x2345, 0x2345, 0x2365, 0x2385, 0x2385, 0x2386, 0x23A6, 0x2BA6, 0x2BA6, 0x2BC6, 0x2BC6, 0x33C6, 0x33C6, 0x33E6, 0x33E6, 0x33E6, 0x3BE6, 0x3BC7, 0x3BE7, 0x43E7, 0x43C7, 0x4BA8, 0x5BCA, 0x740B, 0x844C, 
        0x948D, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94CC, 0x94CC, 0x94AC, 0x94CC, 0x94CC, 0x94AC, 0x948C, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4C, 0x8C0E, 0x8392, 0x7AF8, 0x7ADD, 0x6ABE, 0x627D, 
        0x5A3E, 0x5A3D, 0x521D, 0x51FE, 0x49FE, 0x49FD, 0x49DD, 0x49DD, 0x51FD, 0x5A1D, 0x5A1D, 0x5A1D, 0x5A1D, 0x5A1C, 0x5A1C, 0x5A1C, 0x59FC, 0x59FC, 0x51FB, 0x51DC, 0x51DB, 0x51BB, 0x49BB, 0x49DA, 0x51D8, 0x59F7, 0x6254, 0x7B10, 0xA451, 0xBD50, 
        0xB530, 0xACF3, 0x9C17, 0x49D6, 0x3117, 0x30F9, 0x28FA, 0x291B, 0x293B, 0x313C, 0x313D, 0x315D, 0x317D, 0x317D, 0x319D, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x319D, 0x31BD, 0x31DD, 0x31DD, 0x31FD, 0x39FD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x3A1D, 
        0x3A1D, 0x3A1D, 0x3A1D, 0x39FE, 0x39FD, 0x31FD, 0x31DD, 0x31DD, 0x29BD, 0x299D, 0x217D, 0x217D, 0x215D, 0x215D, 0x213D, 0x191D, 0x211D, 0x217C, 0x423E, 0x4ABE, 0x42BD, 0x4ABE, 0x429D, 0x429D, 0x425E, 0x3A1E, 0x297D, 0x213D, 0x213D, 0x191D, 
        0x191D, 0x191D, 0x191D, 0x191D, 0x191D, 0x191D, 0x211D, 0x293D, 0x41DE, 0x4A3E, 0x525E, 0x5A7E, 0x629E, 0x6ABE, 0x6ADE, 0x62DD, 0x62DE, 0x62DE, 0x6ADE, 0x6AFE, 0x6AFE, 0x6AFE, 0x6AFE, 0x62DE, 0x62BE, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 
        0x62BD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5ADE, 0x5AFE, 0x5AFE, 0x62FE, 0x62FE, 0x631E, 0x633E, 0x633E, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1E, 0x5AFE, 0x5AFE, 0x5AFE, 0x52DE, 0x52DE, 0x52DD, 0x52DE, 0x52DD, 0x52FD, 0x52FD, 
        0x5AFD, 0x5AFE, 0x52FE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x529D, 0x529D, 0x529D, 0x529E, 0x529E, 0x529D, 0x52BE, 0x52DD, 0x5ADD, 0x5AFE, 0x5AFE, 0x631E, 0x631D, 0x631D, 0x631D, 0x631D, 0x5B1D, 0x4A9E, 
        0x31BD, 0x31DD, 0x425E, 0x4A9D, 0x4ABD, 0x529E, 0x527E, 0x527D, 0x525D, 0x525D, 0x5A7D, 0x5A7D, 0x631A, 0x6BB7, 0x73D6, 0x6BB5, 0x7394, 0x83D5, 0xA4B8, 0xB51A, 0xB4DB, 0xB4BB, 0xBCFB, 0xCD7B, 0xCDBA, 0xBDB6, 0x8490, 0x5BCC, 0x4BCA, 0x43CA, 
        0x43C9, 0x4BC9, 0x540A, 0x5C2B, 0x542A, 0x4C0A, 0x43E9, 0x43E9, 0x43E9, 0x440A, 0x43EA, 0x43E9, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x4BE9, 0x4C0A, 0x4C2A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x440A, 0x440A, 0x3BE9, 0x3BE9, 0x3BC9, 0x3BC9, 
        0x3BC9, 0x442B, 0x442B, 0x3C0A, 0x3BEA, 0x33E9, 0x33E9, 0x33E9, 0x2BC9, 0x2BC9, 0x2BEA, 0x2BC9, 0x2BEA, 0x2BC9, 0x2BC9, 0x2BC9, 0x2BA9, 0x2BA9, 0x33A9, 0x33C9, 0x33C9, 0x33C9, 0x33E9, 0x33EA, 0x340A, 0x3C4B, 0x342B, 0x2BEA, 0x2BE9, 0x23E9, 
        0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2429, 0x2429, 0x1C29, 0x1C28, 0x1C28, 0x1C28, 0x1C08, 0x1C09, 0x1C09, 0x23E9, 0x2BCA, 0x33AA, 0x3B6B, 0x434B, 0x5BED, 0x5BED, 0x5BEC, 0x5C2D, 0x646D, 0x6CAF, 0x6CEF, 0x750F, 0x752F, 0x752F, 0x754F, 
        0x754F, 0x756F, 0x756F, 0x756F, 0x756F, 0x756F, 0x758E, 0x758E, 0x758E, 0x758E, 0x758E, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7D8F, 0x7D8F, 0x7D8F, 0x85AF, 0x85B0, 0x8DD0, 0x8DD0, 0x85B0, 0x7D2F, 0x6C8D, 0x5C0C, 0x4BAA,
  0x4CCA, 0x4CEA, 0x4CEA, 0x44E9, 0x4D2A, 0x556C, 0x65CE, 0x75EF, 0x760F, 0x7DEF, 0x7DEF, 0x85F0, 0x8DD0, 0x856F, 0x95D0, 0x9DF2, 0x9592, 0x8531, 0x7CCF, 0x74AE, 0x6C8D, 0x6CAD, 0x64AC, 0x6CAC, 0x6CCC, 0x74ED, 0x7D2E, 0x854F, 0x850F, 0x7CCF, 0x7CAE, 
        0x7CAE, 0x74CE, 0x6CCE, 0x64AD, 0x648D, 0x5C8D, 0x5C8D, 0x64AD, 0x64AD, 0x64CD, 0x6CCD, 0x6CEE, 0x750E, 0x852F, 0x854F, 0x8D4F, 0x9590, 0x9DD1, 0xAE12, 0xAE12, 0xADF1, 0xB5D1, 0xB5D1, 0xB5D1, 0xB5D1, 0xB5B1, 0xB5B2, 0xB592, 0xAD92, 0xA531, 
        0x848F, 0x8490, 0x7CB0, 0x84F0, 0x7D10, 0x6D10, 0x650F, 0x650F, 0x5CCF, 0x548E, 0x4C6E, 0x4C8E, 0x54AF, 0x5CB0, 0x6491, 0x6451, 0x6431, 0x6430, 0x6C51, 0x6C70, 0x4B8C, 0x32E7, 0x2B26, 0x2325, 0x2305, 0x1B05, 0x1B05, 0x1B04, 0x1B04, 0x1B04, 
        0x1B04, 0x1B04, 0x1B24, 0x1B24, 0x1B45, 0x2345, 0x2345, 0x2365, 0x2385, 0x2386, 0x2386, 0x23A6, 0x23A6, 0x2BA6, 0x2BA6, 0x2BC6, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x33C6, 0x3BC7, 0x3BE7, 0x43C7, 0x43C7, 0x4BA8, 0x5BA9, 0x6C0B, 0x844D, 
        0x8C6D, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94CC, 0x94CC, 0x94AC, 0x94AC, 0x94AC, 0x94AB, 0x948B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4C, 0x8C4D, 0x83D0, 0x72F6, 0x72FC, 0x6ABD, 0x625D, 
        0x5A3D, 0x521D, 0x51FD, 0x51FD, 0x51DD, 0x49DD, 0x49DD, 0x49DD, 0x49DD, 0x51FD, 0x51FD, 0x51FD, 0x59FD, 0x5A1D, 0x5A1D, 0x5A1D, 0x521D, 0x51FD, 0x51FC, 0x51DC, 0x51BC, 0x51BC, 0x49BC, 0x49BC, 0x499B, 0x499B, 0x51B9, 0x6A35, 0x72D1, 0xACB1, 
        0xB530, 0xAD31, 0xA4B4, 0x7337, 0x3936, 0x30F8, 0x28F9, 0x291A, 0x291B, 0x293C, 0x293C, 0x295C, 0x315D, 0x317D, 0x317D, 0x319D, 0x319D, 0x319D, 0x299D, 0x319D, 0x31BD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31FD, 0x31FD, 0x39FD, 0x39FD, 
        0x39FD, 0x39FD, 0x39FD, 0x39FD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x29BD, 0x299D, 0x217D, 0x217D, 0x215D, 0x213D, 0x213D, 0x191D, 0x18FD, 0x213C, 0x31FD, 0x427E, 0x429D, 0x427D, 0x427D, 0x425E, 0x3A3E, 0x31DD, 0x213C, 0x191D, 0x191C, 
        0x10FD, 0x18FD, 0x18FD, 0x18FD, 0x18FD, 0x18FD, 0x293D, 0x39DD, 0x525E, 0x527D, 0x5A9D, 0x5A9E, 0x629E, 0x6ABE, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x629D, 0x62BD, 0x62BE, 0x62BE, 0x62BE, 0x629D, 0x5A9D, 0x5A9D, 0x629D, 0x5A9D, 0x5ABD, 0x5A9D, 
        0x5ABD, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ABD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1D, 0x631E, 0x631E, 0x633D, 0x633D, 0x633D, 0x633D, 0x633E, 0x631E, 0x5B1E, 0x5B1E, 0x5AFE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 
        0x5AFD, 0x5AFE, 0x52FD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x529D, 0x529D, 0x527D, 0x529D, 0x529E, 0x529E, 0x5ABE, 0x52DD, 0x5ADD, 0x5AFE, 0x631E, 0x631E, 0x631D, 0x631D, 0x633D, 0x631E, 0x5B1D, 0x4A7E, 
        0x319C, 0x3A1D, 0x429E, 0x52BD, 0x52BD, 0x52BE, 0x529E, 0x527E, 0x525D, 0x5A5D, 0x5A7D, 0x5A7D, 0x6319, 0x6BB6, 0x6BF4, 0x6BD3, 0x6BB3, 0x73B3, 0x83F4, 0x9456, 0xA478, 0xA478, 0xAC98, 0xAC96, 0xA4D4, 0xA513, 0x848F, 0x5BCB, 0x4BCA, 0x43CA, 
        0x43C9, 0x4BC9, 0x540A, 0x5C2B, 0x542A, 0x4C09, 0x4BE9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x4BE9, 0x4C0A, 0x542A, 0x4C2A, 0x4C0A, 0x542A, 0x542A, 0x4C2A, 0x440A, 0x440A, 0x43EA, 0x3BE9, 0x3BE9, 0x3BC9, 
        0x3BC9, 0x3BCA, 0x3BEA, 0x440B, 0x3C0A, 0x33E9, 0x33C9, 0x33E9, 0x2BC9, 0x33C9, 0x2BC9, 0x2BC9, 0x2BCA, 0x2BC9, 0x33A9, 0x33A9, 0x33A9, 0x33A9, 0x33A9, 0x3BA9, 0x3BC9, 0x33C9, 0x33CA, 0x33EA, 0x33EA, 0x340A, 0x340A, 0x2BEA, 0x2BE9, 0x23E9, 
        0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x1C08, 0x1C09, 0x1C09, 0x1C09, 0x1C09, 0x2409, 0x2BEA, 0x33CA, 0x338B, 0x3B6B, 0x53CC, 0x644F, 0x74CF, 0x74EF, 0x7510, 0x752F, 0x6D2F, 0x6D2F, 0x6D4E, 0x756E, 0x756F, 
        0x756F, 0x756F, 0x756F, 0x758F, 0x758F, 0x756E, 0x756E, 0x756F, 0x758E, 0x758E, 0x7D8F, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85AF, 0x85B0, 0x85B0, 0x8590, 0x7D2F, 0x6CAD, 0x5C0C, 0x4B8A, 0x436A, 0x434A,
  0x4CCA, 0x550B, 0x552B, 0x4D2B, 0x554A, 0x556B, 0x65AD, 0x6DEE, 0x760F, 0x7DEF, 0x7DF0, 0x8E10, 0x9611, 0x8DD0, 0x8DD0, 0x9DF2, 0x95D2, 0x8D91, 0x7CF0, 0x7CCF, 0x6C8D, 0x6C8D, 0x64AC, 0x64AC, 0x6CCC, 0x6CED, 0x7D2E, 0x852F, 0x8510, 0x8D31, 0x7CCF, 
        0x7CAE, 0x6CAE, 0x6CEE, 0x64CD, 0x5C8D, 0x5CAD, 0x5CAD, 0x64AD, 0x64AD, 0x64AC, 0x6CCD, 0x6CEE, 0x750E, 0x852F, 0x8D4F, 0x954F, 0x9DB1, 0xAE12, 0xAE32, 0xB612, 0xADF1, 0xADB1, 0xADB1, 0xB591, 0xB5B1, 0xADB1, 0xB592, 0xAD92, 0xAD72, 0x9D11, 
        0x7C2E, 0x7C2F, 0x746F, 0x84F0, 0x7D30, 0x6D0F, 0x650F, 0x6530, 0x5CEF, 0x54CF, 0x4CAE, 0x4C8E, 0x54AF, 0x5CD0, 0x64B1, 0x6491, 0x6451, 0x6430, 0x6C51, 0x6C50, 0x53AD, 0x3308, 0x2B26, 0x2B25, 0x2305, 0x2305, 0x2305, 0x2305, 0x1B05, 0x1B05, 
        0x1B04, 0x1B24, 0x1B24, 0x2325, 0x1B45, 0x2345, 0x2365, 0x2365, 0x2385, 0x2386, 0x2386, 0x23A6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x33A6, 0x33A6, 0x33C6, 0x33C7, 0x3BC7, 0x3BC7, 0x43A7, 0x4BA8, 0x63EA, 0x740C, 0x844D, 
        0x8C6D, 0x94AD, 0x94AD, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x94AC, 0x94AC, 0x94AC, 0x94AB, 0x948B, 0x948B, 0x948B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x840D, 0x7333, 0x72DA, 0x6ABD, 0x5A5D, 
        0x523E, 0x521D, 0x51FD, 0x49FD, 0x49DD, 0x49DD, 0x51DD, 0x51DD, 0x51DD, 0x51FD, 0x59FD, 0x59FE, 0x51FD, 0x51FD, 0x51FD, 0x5A1D, 0x5A1D, 0x5A1D, 0x59FD, 0x51FD, 0x51FD, 0x51DD, 0x51DD, 0x51DD, 0x49BD, 0x499C, 0x499C, 0x59D9, 0x6236, 0x7B31, 
        0xACD1, 0xAD11, 0xA4F3, 0x8C17, 0x49D6, 0x30D7, 0x28D9, 0x28FA, 0x28FA, 0x291B, 0x291C, 0x291C, 0x293C, 0x295C, 0x315D, 0x317D, 0x317D, 0x297D, 0x297D, 0x297D, 0x319D, 0x31BD, 0x31BD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 
        0x31DD, 0x31FD, 0x31FD, 0x31DD, 0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x29BD, 0x29BD, 0x29BD, 0x219D, 0x217D, 0x215D, 0x193D, 0x213D, 0x191D, 0x18FD, 0x18DC, 0x18FC, 0x31BD, 0x3A3D, 0x3A5D, 0x3A3D, 0x3A3D, 0x3A1D, 0x31DD, 0x299D, 0x191D, 0x10FC, 
        0x10DD, 0x10DD, 0x18DD, 0x18DD, 0x18FD, 0x211D, 0x41DD, 0x525D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7E, 0x5A7E, 0x5A7E, 0x5A7D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 
        0x5A9D, 0x5A9E, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ADE, 0x52DE, 0x5AFE, 0x5B1E, 0x5B1D, 0x5B1D, 0x631E, 0x631E, 0x633E, 0x633D, 0x635E, 0x635E, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1E, 0x5AFE, 0x52FE, 0x52DE, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 
        0x5AFD, 0x5AFE, 0x52FD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x529D, 0x529E, 0x529E, 0x529D, 0x527D, 0x529D, 0x529E, 0x529E, 0x5ABD, 0x5ADD, 0x5AFD, 0x62FE, 0x631E, 0x631E, 0x631D, 0x631D, 0x633E, 0x5B3E, 0x5AFE, 0x423D, 
        0x31BD, 0x425E, 0x4ABD, 0x52BD, 0x52BE, 0x52BE, 0x529E, 0x527D, 0x527D, 0x5A5D, 0x5A5D, 0x5A7C, 0x5AF9, 0x6BD4, 0x6C13, 0x6BF2, 0x6BF2, 0x73F2, 0x7C13, 0x8C54, 0x9455, 0x9414, 0x8BF3, 0x83CF, 0x73AD, 0x73AC, 0x63CB, 0x53CA, 0x43C9, 0x43E9, 
        0x43C9, 0x4BC9, 0x53EA, 0x5C2A, 0x542A, 0x4C09, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43EA, 0x43E9, 0x43E9, 0x43E9, 0x4BE9, 0x4C0A, 0x542A, 0x542A, 0x544B, 0x544B, 0x544B, 0x542A, 0x4C0A, 0x4C0A, 0x43EA, 0x3BE9, 0x3BE9, 0x3BC9, 
        0x33A9, 0x33A9, 0x3BEA, 0x440B, 0x3C0A, 0x33E9, 0x33E9, 0x33C9, 0x33E9, 0x33C9, 0x33C9, 0x33C9, 0x33C9, 0x33C9, 0x33A9, 0x33A9, 0x3389, 0x3BA9, 0x3BA9, 0x3BA9, 0x3BC9, 0x3BCA, 0x3BCA, 0x33EA, 0x33EA, 0x33EA, 0x340A, 0x33EA, 0x2BE9, 0x2BE9, 
        0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C09, 0x1C09, 0x1C09, 0x1C09, 0x2409, 0x2C0A, 0x2BCA, 0x338B, 0x3B6B, 0x4BCC, 0x646F, 0x7510, 0x7530, 0x754F, 0x754F, 0x6D4F, 0x6D6E, 0x6D6E, 0x756E, 0x756E, 
        0x758E, 0x758F, 0x758F, 0x758E, 0x758E, 0x756E, 0x756F, 0x7D6F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DAF, 0x85B0, 0x7DB0, 0x7D6F, 0x6CEE, 0x646C, 0x4BAA, 0x4349, 0x3B09, 0x3AE9, 0x3B09, 0x432A,
  0x54EA, 0x5D2B, 0x5D6B, 0x556C, 0x554B, 0x556C, 0x5D8C, 0x6DCE, 0x75EF, 0x7DEF, 0x85F0, 0x8E10, 0x9610, 0x9611, 0x8DF0, 0x9612, 0x9612, 0x8DD1, 0x8551, 0x7D10, 0x74AE, 0x6C8D, 0x6C8D, 0x6CAC, 0x6CCC, 0x6CCD, 0x7D2E, 0x852F, 0x84EF, 0x84EF, 0x7CAF, 
        0x74AE, 0x6CAD, 0x64AD, 0x64AD, 0x5CAD, 0x5CAD, 0x5CAD, 0x64AD, 0x64AD, 0x64AD, 0x6CCD, 0x6CEE, 0x7D0E, 0x854E, 0x8D4F, 0x9590, 0xA5D1, 0xAE12, 0xAE12, 0xADF1, 0xADD1, 0xADB0, 0xAD90, 0xAD91, 0xB591, 0xB5B1, 0xB592, 0xAD92, 0xA572, 0x94F1, 
        0x7C2F, 0x740E, 0x744E, 0x7CF0, 0x7D10, 0x6D0F, 0x650F, 0x6530, 0x5D0F, 0x5CEF, 0x54CE, 0x4CAE, 0x4C8E, 0x54AF, 0x64D0, 0x6491, 0x6471, 0x6430, 0x6C51, 0x6C71, 0x5BEE, 0x3B09, 0x3327, 0x2B26, 0x2B25, 0x2325, 0x2325, 0x2325, 0x2325, 0x1B25, 
        0x1B25, 0x1B24, 0x1B25, 0x1B45, 0x2345, 0x2345, 0x2365, 0x2365, 0x2385, 0x23A5, 0x23A6, 0x23A6, 0x23A6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2BA6, 0x2B86, 0x2B86, 0x2B86, 0x3386, 0x33A6, 0x33A6, 0x3BC7, 0x43A7, 0x43C8, 0x53C9, 0x640B, 0x742C, 0x844D, 
        0x8C6D, 0x94AD, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x948B, 0x948B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C4B, 0x844B, 0x842C, 0x7B91, 0x72F8, 0x72DD, 0x625E, 
        0x523E, 0x521D, 0x51FD, 0x49DD, 0x49DD, 0x49BD, 0x51DD, 0x51FD, 0x59FD, 0x5A1D, 0x5A3D, 0x5A1E, 0x5A1E, 0x521D, 0x51FC, 0x4139, 0x3918, 0x59FB, 0x621D, 0x621E, 0x621E, 0x5A1E, 0x623E, 0x5A3E, 0x5A3E, 0x5A3E, 0x5A3D, 0x625D, 0x729B, 0x8317, 
        0x93F4, 0xA493, 0x9CD4, 0x9497, 0x6AF9, 0x30D7, 0x28D8, 0x28D9, 0x28FA, 0x28FA, 0x28FB, 0x20FB, 0x211C, 0x293C, 0x293C, 0x295D, 0x295D, 0x295D, 0x295D, 0x297D, 0x297D, 0x299D, 0x29BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31DD, 
        0x31DD, 0x31DD, 0x31DD, 0x31BD, 0x31BD, 0x31DD, 0x31BD, 0x31BD, 0x29BD, 0x29BD, 0x299D, 0x299D, 0x217D, 0x215D, 0x215D, 0x193D, 0x191D, 0x18DD, 0x18DD, 0x18DC, 0x18DC, 0x297C, 0x31FD, 0x321D, 0x321D, 0x31FD, 0x31DD, 0x29BD, 0x213D, 0x10DC, 
        0x109D, 0x10BD, 0x18DD, 0x18DD, 0x20FD, 0x39BD, 0x4A3E, 0x527D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A7D, 0x525D, 0x527E, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x529E, 
        0x529E, 0x529E, 0x529D, 0x52BE, 0x5ADE, 0x52DE, 0x52DE, 0x5AFD, 0x5B1E, 0x5B1D, 0x5B1E, 0x5B3E, 0x633E, 0x5B3D, 0x633D, 0x635D, 0x635D, 0x633E, 0x633E, 0x633E, 0x631E, 0x5B1E, 0x5B1E, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 
        0x52FD, 0x52FD, 0x5AFE, 0x52DE, 0x52DD, 0x52DD, 0x52DE, 0x5ADE, 0x52DE, 0x52BD, 0x52BD, 0x529D, 0x529E, 0x529D, 0x527D, 0x529E, 0x529E, 0x5ABE, 0x5ABE, 0x5ADD, 0x5AFD, 0x5AFE, 0x631E, 0x631E, 0x631D, 0x631D, 0x633E, 0x5B1E, 0x52DE, 0x39FD, 
        0x31DD, 0x427E, 0x52BD, 0x52BD, 0x52BE, 0x5ABE, 0x5A9E, 0x5A7D, 0x5A7D, 0x5A5D, 0x5A5D, 0x5A7C, 0x6318, 0x6C14, 0x6C52, 0x6C52, 0x7452, 0x7C73, 0x8473, 0x8473, 0x7C11, 0x7BD0, 0x7BCF, 0x636B, 0x638B, 0x63AA, 0x5BCA, 0x4BC9, 0x43C9, 0x43E9, 
        0x43C9, 0x4BC9, 0x53EA, 0x5C2A, 0x540A, 0x53E9, 0x4BC9, 0x43C9, 0x43E9, 0x43C9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43C9, 0x4BE9, 0x540A, 0x542A, 0x5C4B, 0x5C4B, 0x5C4B, 0x5C2B, 0x542A, 0x542A, 0x542A, 0x4C0A, 0x440A, 0x43EA, 0x3BC9, 
        0x33A9, 0x33A9, 0x3BC9, 0x440A, 0x3C0A, 0x3BE9, 0x33C9, 0x33C9, 0x33E9, 0x33C9, 0x33C9, 0x33C9, 0x33A9, 0x33A9, 0x3389, 0x3B89, 0x3B89, 0x3BA9, 0x43AA, 0x43CA, 0x43CA, 0x3BCA, 0x3BCA, 0x33CA, 0x33EA, 0x33EA, 0x33EA, 0x33EA, 0x2BEA, 0x2BE9, 
        0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x1C08, 0x1C08, 0x1C09, 0x2409, 0x2409, 0x2BE9, 0x2BAA, 0x336B, 0x4BCC, 0x646F, 0x7510, 0x754F, 0x756F, 0x756F, 0x6D6F, 0x6D6E, 0x6D6E, 0x756E, 0x758E, 
        0x758F, 0x758F, 0x758F, 0x758E, 0x756E, 0x756E, 0x756E, 0x7D6F, 0x7D8E, 0x758E, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D6F, 0x752F, 0x64AD, 0x540B, 0x4369, 0x3B08, 0x2AA7, 0x32A8, 0x32A9, 0x32C9, 0x3AEA, 0x3B0A,
  0x5D0B, 0x5D4C, 0x5D8C, 0x5D8C, 0x5D6C, 0x5D8C, 0x5D8C, 0x6DCE, 0x75EF, 0x7DEF, 0x85EF, 0x85F0, 0x8E10, 0x8E10, 0x8DF0, 0x9611, 0x9632, 0x9611, 0x8D91, 0x8551, 0x7CEF, 0x6CAE, 0x6C8D, 0x6C8D, 0x64AC, 0x6CCC, 0x7D2E, 0x854F, 0x84EF, 0x7C8E, 0x7C8E, 
        0x74AE, 0x6CAD, 0x64AD, 0x5CAD, 0x5CAD, 0x5CCD, 0x5CCD, 0x64AD, 0x64AD, 0x64AD, 0x6CCD, 0x6CEE, 0x7D0E, 0x854E, 0x8D6F, 0x9DB0, 0xA5D1, 0xADF1, 0xADF1, 0xADB0, 0xA590, 0xAD70, 0xAD70, 0xAD91, 0xAD91, 0xB591, 0xB5B2, 0xAD93, 0x9D52, 0x8CB1, 
        0x742F, 0x740F, 0x746F, 0x7CB0, 0x74F0, 0x74EF, 0x6D0F, 0x652F, 0x652F, 0x5D2F, 0x550F, 0x4CCE, 0x4CAE, 0x4CAE, 0x5CD0, 0x64B1, 0x6491, 0x5C30, 0x6430, 0x6C71, 0x6450, 0x4B6B, 0x3B49, 0x2B26, 0x2B26, 0x2B25, 0x2325, 0x2325, 0x2325, 0x2325, 
        0x2325, 0x1B45, 0x1B45, 0x1B45, 0x2345, 0x2345, 0x2365, 0x2365, 0x2385, 0x23A5, 0x2386, 0x23A6, 0x23A6, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x2B86, 0x3386, 0x33A6, 0x3BA7, 0x43A7, 0x5409, 0x640A, 0x6BEB, 0x7C0C, 0x844D, 
        0x8C8D, 0x94AC, 0x94CC, 0x94CC, 0x94EC, 0x94CC, 0x94CC, 0x94CC, 0x94CC, 0x9CCC, 0x9CAC, 0x94AC, 0x948C, 0x948C, 0x948B, 0x948B, 0x8C6B, 0x8C6B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x844B, 0x842C, 0x83CF, 0x7334, 0x72FB, 0x627E, 
        0x5A1E, 0x51FD, 0x49DD, 0x49DD, 0x51DD, 0x51FD, 0x59FD, 0x5A1D, 0x5A1C, 0x59FC, 0x623D, 0x625D, 0x5A3D, 0x5A1D, 0x49BA, 0x30B5, 0x4136, 0x5198, 0x6A3B, 0x6A5D, 0x6A5E, 0x6A5E, 0x6A5E, 0x6A7E, 0x627E, 0x6A7E, 0x6A7E, 0x6A9E, 0x72BE, 0x7AFC, 
        0x8359, 0x8377, 0x83B5, 0x83B6, 0x7B5B, 0x4178, 0x28B8, 0x28B8, 0x28B9, 0x28DA, 0x28FA, 0x20DA, 0x20FB, 0x211B, 0x211C, 0x293C, 0x293D, 0x293D, 0x295D, 0x295D, 0x297D, 0x297D, 0x299D, 0x299D, 0x299D, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 
        0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x31BD, 0x29BD, 0x299D, 0x299D, 0x299D, 0x299D, 0x217D, 0x215D, 0x213D, 0x193D, 0x18FD, 0x18DD, 0x18DD, 0x18BD, 0x10BC, 0x10DC, 0x297D, 0x29DD, 0x31DD, 0x29DD, 0x29DD, 0x29DD, 0x299D, 0x10FD, 
        0x109D, 0x107D, 0x189D, 0x18BC, 0x315D, 0x4A1E, 0x527D, 0x5A9D, 0x5ABD, 0x5ABD, 0x5A9D, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A7D, 0x5A7D, 0x527D, 0x527D, 0x527D, 0x527D, 0x527D, 0x525E, 0x527D, 0x527D, 0x527D, 0x527D, 0x529D, 0x529D, 0x529E, 
        0x529E, 0x4ABD, 0x52BD, 0x52BD, 0x5ADE, 0x52DE, 0x52FD, 0x5AFD, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B3E, 0x5B3E, 0x5B3D, 0x5B3D, 0x633E, 0x633E, 0x633E, 0x633D, 0x633E, 0x633E, 0x5B1E, 0x5AFE, 0x5AFE, 0x52FD, 0x52FD, 0x5AFD, 0x5AFE, 0x5AFE, 0x52FD, 
        0x52FD, 0x5AFD, 0x5AFE, 0x52DD, 0x52DD, 0x52DD, 0x52DE, 0x5ADE, 0x5ADE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x527D, 0x529E, 0x5ABE, 0x5ADE, 0x5ADD, 0x5AFD, 0x5B1D, 0x633E, 0x633E, 0x631E, 0x631D, 0x631E, 0x5B1E, 0x52BD, 0x39DD, 
        0x39FD, 0x4A7E, 0x52BD, 0x52BD, 0x5ADD, 0x5ABE, 0x5A9D, 0x5A7D, 0x5A7D, 0x5A5D, 0x5A5D, 0x5A9B, 0x6337, 0x7454, 0x7493, 0x7CB3, 0x7CB3, 0x84B3, 0x7C71, 0x7410, 0x63AE, 0x63AD, 0x6BCD, 0x63AC, 0x5B8A, 0x5BCB, 0x53EB, 0x4BEA, 0x4BC9, 0x43C9, 
        0x43C9, 0x4BC8, 0x53E9, 0x5C2A, 0x540A, 0x53E9, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x43E9, 0x4BE9, 0x540A, 0x646B, 0x74AD, 0x644B, 0x5C2A, 0x5C2A, 0x540A, 0x540A, 0x542B, 0x4C2A, 0x440A, 0x43EA, 0x3BC9, 
        0x33A9, 0x33A9, 0x3BC9, 0x3BEA, 0x3BEA, 0x3BC9, 0x33C9, 0x33E9, 0x3BE9, 0x33E9, 0x33C9, 0x33C9, 0x3389, 0x3B89, 0x3BA9, 0x43AA, 0x43AA, 0x43AA, 0x4BCA, 0x4BEB, 0x4BEB, 0x43CA, 0x3BCA, 0x3BCA, 0x3BEA, 0x33C9, 0x33CA, 0x33EA, 0x33EA, 0x2BE9, 
        0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C09, 0x2409, 0x2409, 0x2BCA, 0x338A, 0x43CC, 0x5C4E, 0x6CCF, 0x754F, 0x756F, 0x756F, 0x758F, 0x6D6E, 0x756E, 0x758F, 0x758E, 
        0x758F, 0x7DAF, 0x7D8F, 0x758F, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D8E, 0x7D8F, 0x7D8F, 0x7DAF, 0x7D8F, 0x7D8F, 0x7D8F, 0x754F, 0x6CEE, 0x5C6C, 0x53EA, 0x3B48, 0x2AC6, 0x2266, 0x2246, 0x2267, 0x2A88, 0x3289, 0x32A9, 0x3ACA, 0x3AEB,
  0x650C, 0x656C, 0x65AC, 0x5DAC, 0x5D8C, 0x5D6C, 0x658D, 0x6DCE, 0x75EF, 0x7DEF, 0x7DEF, 0x85EF, 0x8610, 0x8E10, 0x8DF0, 0x8E11, 0x9631, 0x9611, 0x8DD2, 0x8D91, 0x8550, 0x74EF, 0x6CCE, 0x6CAD, 0x6CAD, 0x6CCC, 0x7D2E, 0x8D4F, 0x84EF, 0x746D, 0x7C8E, 
        0x74AE, 0x6CAD, 0x64AD, 0x64AD, 0x64AD, 0x5CCD, 0x64CD, 0x64CD, 0x64AD, 0x64AD, 0x6CCD, 0x74EE, 0x7D0E, 0x854E, 0x8D6F, 0x9DB0, 0xA5D0, 0xA5D0, 0xA5B0, 0xA570, 0xA54F, 0xA54F, 0xA54F, 0xAD71, 0xAD91, 0xB5B1, 0xB5B2, 0xAD93, 0x9511, 0x8490, 
        0x742F, 0x744F, 0x7C8F, 0x74AF, 0x74CF, 0x6CCF, 0x6D0F, 0x650F, 0x6D50, 0x6550, 0x5D0F, 0x4CEE, 0x4CCE, 0x4CAE, 0x54AF, 0x5CD0, 0x5CB0, 0x5C50, 0x5C30, 0x6C71, 0x6C71, 0x5C0F, 0x436B, 0x3327, 0x2B26, 0x2B25, 0x2325, 0x2B45, 0x2B45, 0x2345, 
        0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2365, 0x2365, 0x2365, 0x2385, 0x2386, 0x2386, 0x2386, 0x2B86, 0x2B66, 0x2B66, 0x2B66, 0x2366, 0x2B66, 0x2B66, 0x2B66, 0x3386, 0x3386, 0x3BA7, 0x4BE8, 0x5409, 0x53A8, 0x63AA, 0x73EB, 0x844D, 
        0x8C8D, 0x94AD, 0x94CC, 0x94EC, 0x94EC, 0x94EC, 0x94EC, 0x9CED, 0x9CED, 0x9CCD, 0x9CCD, 0x9CCC, 0x94AC, 0x94AC, 0x94AC, 0x948C, 0x948C, 0x8C6B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x844B, 0x840D, 0x7B72, 0x72D9, 0x6A7D, 
        0x59FD, 0x51DD, 0x51DC, 0x51FC, 0x5A1C, 0x623D, 0x623D, 0x59DB, 0x4117, 0x4938, 0x4979, 0x59FB, 0x59FB, 0x51BA, 0x4177, 0x38F3, 0x6A97, 0x6276, 0x6A78, 0x729B, 0x729C, 0x6A7C, 0x6A7D, 0x6A7D, 0x6A7D, 0x6A7E, 0x6A5D, 0x6A7D, 0x72BE, 0x72DD, 
        0x7AFC, 0x7B1B, 0x72FA, 0x731A, 0x6ADC, 0x6A9D, 0x5A3D, 0x49BC, 0x3119, 0x28D8, 0x20B9, 0x20B9, 0x20DA, 0x20FB, 0x20FB, 0x211B, 0x211C, 0x211C, 0x213C, 0x293D, 0x295D, 0x215D, 0x295D, 0x297D, 0x297D, 0x299D, 0x299D, 0x299D, 0x319D, 0x299D, 
        0x299D, 0x299D, 0x299D, 0x299D, 0x31BD, 0x31BD, 0x299D, 0x299D, 0x299D, 0x297D, 0x297D, 0x297D, 0x297D, 0x215D, 0x213D, 0x193D, 0x18FD, 0x18FD, 0x18DD, 0x10BD, 0x109D, 0x10BD, 0x18FD, 0x217D, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 0x29BD, 0x215D, 
        0x109D, 0x107D, 0x187C, 0x20FC, 0x41DE, 0x4A3E, 0x529E, 0x5A9D, 0x5ABD, 0x5A9E, 0x5A9D, 0x5A9E, 0x529E, 0x529E, 0x529D, 0x527D, 0x527D, 0x527D, 0x527D, 0x525D, 0x525D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x527D, 0x529D, 0x4A9D, 0x529E, 
        0x529E, 0x4ABD, 0x4ABD, 0x52BD, 0x5ADE, 0x52FE, 0x52FE, 0x52FD, 0x5AFD, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B3E, 0x5B3E, 0x5B3E, 0x5B1D, 0x5AFE, 0x5AFD, 0x52FD, 0x52FD, 0x52FD, 0x5AFE, 0x5AFE, 0x5AFD, 
        0x52FD, 0x5AFD, 0x5AFE, 0x52DD, 0x52BD, 0x52DD, 0x52BD, 0x5ADE, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x529E, 0x527D, 0x529E, 0x5ABE, 0x5ADE, 0x5AFD, 0x5AFD, 0x631E, 0x633E, 0x633E, 0x631E, 0x631E, 0x631E, 0x5AFD, 0x4A7D, 0x31DD, 
        0x3A1D, 0x4A9E, 0x52BD, 0x52BD, 0x5ABD, 0x5ABD, 0x5A9E, 0x5A9D, 0x5A5D, 0x5A5D, 0x5A5D, 0x5A7A, 0x6B98, 0x84B5, 0x84F4, 0x8CF4, 0x84B2, 0x7471, 0x63EE, 0x536C, 0x536B, 0x5BAC, 0x5BCC, 0x5BCB, 0x53AA, 0x53AA, 0x4BCA, 0x4BCA, 0x4BC9, 0x43E9, 
        0x43C8, 0x4BC8, 0x5409, 0x5C2A, 0x5C0A, 0x53E9, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x43E9, 0x43C9, 0x43E9, 0x43E9, 0x43E9, 0x4BE9, 0x53EA, 0x644B, 0x74CC, 0x6C6B, 0x5C2A, 0x5C0A, 0x540A, 0x540A, 0x4C0A, 0x4C0A, 0x4C0A, 0x43EA, 0x3BC9, 
        0x33A9, 0x33A9, 0x3BC9, 0x3BEA, 0x3BEA, 0x3BC9, 0x3BE9, 0x3BE9, 0x3BC9, 0x3BC9, 0x3BC9, 0x3BC9, 0x3B89, 0x3B89, 0x3BA9, 0x43AA, 0x43AA, 0x4BAA, 0x4BEB, 0x5C4C, 0x4C0B, 0x43CA, 0x3BCA, 0x3BCA, 0x33CA, 0x33C9, 0x33C9, 0x33EA, 0x33EA, 0x2BE9, 
        0x2BE9, 0x23E9, 0x23E9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C09, 0x2409, 0x2409, 0x23C9, 0x338A, 0x43AB, 0x53ED, 0x648E, 0x754F, 0x756F, 0x758F, 0x758E, 0x758E, 0x758E, 0x758E, 0x758E, 
        0x7D8F, 0x7D8F, 0x7D8F, 0x758F, 0x7D6F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x858F, 0x858F, 0x8590, 0x7D8F, 0x752F, 0x6CCD, 0x5C2B, 0x43A9, 0x3307, 0x2285, 0x1A45, 0x1A04, 0x1A25, 0x1A25, 0x1A26, 0x2A68, 0x2A89, 0x32A9, 0x3ACA, 0x3B0A,
  0x652C, 0x656C, 0x6DAD, 0x65AD, 0x5D6C, 0x5D6C, 0x658D, 0x6DCE, 0x760F, 0x7E0F, 0x7E0F, 0x85F0, 0x8610, 0x8E30, 0x8E30, 0x8E31, 0x8E31, 0x8E11, 0x8DD1, 0x8DD1, 0x8591, 0x7D2F, 0x74EE, 0x6CCE, 0x6CCD, 0x6CCD, 0x7D2E, 0x854F, 0x84EF, 0x746D, 0x7C8E, 
        0x748E, 0x6CAD, 0x64AD, 0x64AD, 0x64AD, 0x5CCD, 0x64CD, 0x64CD, 0x5CAD, 0x64AD, 0x6CCD, 0x750D, 0x7D2E, 0x854E, 0x8D6F, 0x9DB0, 0xA5D0, 0xA5B0, 0xA590, 0xA56F, 0xA56F, 0xA54F, 0xAD70, 0xAD70, 0xB591, 0xB5B1, 0xADB2, 0xA572, 0x8CD1, 0x7C6F, 
        0x6C2F, 0x746F, 0x7CAF, 0x74AF, 0x74AF, 0x6CAE, 0x6CEF, 0x64EE, 0x652F, 0x652F, 0x5D2F, 0x550E, 0x4CEE, 0x4CAE, 0x4CAF, 0x5CD0, 0x5CD0, 0x6491, 0x5C50, 0x6471, 0x6C71, 0x6C92, 0x642F, 0x3B48, 0x3347, 0x2B46, 0x2B45, 0x2B45, 0x2B65, 0x2B45, 
        0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2365, 0x2365, 0x2365, 0x2365, 0x2365, 0x2386, 0x2386, 0x2366, 0x2346, 0x2345, 0x2345, 0x2346, 0x2346, 0x2B46, 0x2B46, 0x3366, 0x3B86, 0x4BE8, 0x5409, 0x4BA8, 0x5367, 0x6389, 0x73EB, 0x844C, 
        0x8C8D, 0x94AD, 0x94CD, 0x9CED, 0x94EC, 0x94EC, 0x94EC, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CCD, 0x9CCD, 0x9CCC, 0x94CC, 0x94AC, 0x94AC, 0x948B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x842B, 0x842C, 0x83CF, 0x7B15, 0x6A9B, 
        0x59FC, 0x51BB, 0x49D9, 0x5A18, 0x5A39, 0x6239, 0x6219, 0x4115, 0x30B4, 0x4116, 0x38F6, 0x4157, 0x51DA, 0x51B9, 0x3935, 0x49B2, 0x7353, 0x7B73, 0x7B55, 0x7B17, 0x7B38, 0x7B39, 0x7B1A, 0x72FA, 0x6259, 0x4957, 0x4117, 0x4138, 0x4979, 0x51BA, 
        0x61FB, 0x6A9D, 0x729D, 0x6A9D, 0x6A9D, 0x6A9D, 0x627E, 0x627E, 0x627E, 0x521D, 0x395A, 0x20B8, 0x20B9, 0x20DA, 0x28DB, 0x28FB, 0x20FC, 0x20FC, 0x211C, 0x213C, 0x293D, 0x211D, 0x213D, 0x215D, 0x295D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 
        0x297D, 0x297D, 0x297D, 0x297D, 0x299D, 0x299D, 0x299D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 0x217D, 0x215D, 0x193D, 0x191D, 0x18FD, 0x18FD, 0x18DD, 0x10BC, 0x109D, 0x109D, 0x10BC, 0x10FC, 0x215D, 0x217D, 0x299D, 0x29BD, 0x29BD, 0x297D, 
        0x18FD, 0x105C, 0x20BC, 0x39DD, 0x4A1D, 0x527E, 0x5A9E, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A9E, 0x529E, 0x529D, 0x529D, 0x527D, 0x527D, 0x527D, 0x527D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A9D, 0x4A9D, 0x4A9E, 
        0x4A9E, 0x52BD, 0x52BD, 0x52DD, 0x52DE, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x5AFD, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B3E, 0x5B1D, 0x5AFD, 0x5AFD, 0x5AFD, 0x52FE, 0x52FD, 0x5AFE, 0x5AFE, 0x52FE, 
        0x52FE, 0x52FE, 0x52FD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52DD, 0x52BD, 0x52BE, 0x529E, 0x529E, 0x527D, 0x529E, 0x5ABE, 0x5ADE, 0x5AFD, 0x5AFD, 0x631E, 0x633E, 0x633E, 0x633D, 0x633E, 0x631D, 0x5AFE, 0x423D, 0x39DD, 
        0x423E, 0x529E, 0x52BD, 0x5ABD, 0x5ABD, 0x5ABE, 0x5A9E, 0x5A7D, 0x5A5D, 0x5A5D, 0x5A5D, 0x5A5A, 0x73B8, 0x8CD6, 0x84D4, 0x7C92, 0x6C2F, 0x63CD, 0x538B, 0x538B, 0x53AB, 0x5BAB, 0x5BCB, 0x5BCB, 0x53AA, 0x4BAA, 0x4BCA, 0x43C9, 0x43C9, 0x43C9, 
        0x43C8, 0x4BE9, 0x5409, 0x5C2A, 0x5C0A, 0x53E9, 0x4BC9, 0x43C9, 0x43C9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 0x43C9, 0x43C9, 0x4BE9, 0x53EA, 0x5C0A, 0x644A, 0x644B, 0x5C0A, 0x5C0A, 0x5409, 0x540A, 0x4C0A, 0x4C0A, 0x4C0A, 0x43EA, 0x3BC9, 
        0x3BA9, 0x33A9, 0x3BC9, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BC9, 0x3BC9, 0x3B89, 0x3B89, 0x43A9, 0x43AA, 0x4BAA, 0x4BAA, 0x4BEB, 0x5C4C, 0x4C0B, 0x43CA, 0x3BAA, 0x3BCA, 0x3BCA, 0x33A9, 0x33C9, 0x33EA, 0x33EA, 0x2BE9, 
        0x2BE9, 0x23E9, 0x23E9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C09, 0x2409, 0x2409, 0x23E9, 0x33AA, 0x3B6B, 0x43AB, 0x648E, 0x754F, 0x756F, 0x758F, 0x758F, 0x758E, 0x758F, 0x7DAF, 0x7DAF, 
        0x7DAF, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x7D8F, 0x85B0, 0x7DB0, 0x85B0, 0x8590, 0x7D70, 0x754F, 0x6CCD, 0x5C4C, 0x43A9, 0x32E7, 0x2286, 0x1A25, 0x1A04, 0x1A04, 0x1A05, 0x1A05, 0x1A06, 0x1A27, 0x2A68, 0x32A9, 0x32CA, 0x3B0A, 0x432B,
  0x652C, 0x6D6C, 0x6DAD, 0x6DCD, 0x65AD, 0x65AD, 0x65AD, 0x6DCE, 0x760F, 0x760F, 0x7E0F, 0x860F, 0x8610, 0x8E30, 0x8E10, 0x8E31, 0x8E31, 0x8E10, 0x85B0, 0x8590, 0x8591, 0x7D50, 0x750F, 0x74EE, 0x6CED, 0x74ED, 0x7D0E, 0x8D50, 0x84EF, 0x744D, 0x746E, 
        0x6C8D, 0x64AD, 0x64AD, 0x5CAD, 0x5CAD, 0x5CAD, 0x5CAD, 0x5CAD, 0x64AD, 0x64AD, 0x6CCD, 0x750D, 0x7D2E, 0x854E, 0x8D6F, 0x9DB0, 0x9DB0, 0x9D8F, 0x9D8F, 0xA56F, 0xA590, 0xAD90, 0xAD90, 0xAD90, 0xAD91, 0xADB2, 0xADB2, 0x9D52, 0x84B0, 0x744F, 
        0x63ED, 0x748F, 0x74CF, 0x74CF, 0x74AF, 0x6CAE, 0x64AE, 0x64AE, 0x64CE, 0x650E, 0x652F, 0x5D0F, 0x54EE, 0x4CCE, 0x4CAE, 0x54CF, 0x5CF0, 0x64D1, 0x5C91, 0x5C50, 0x6451, 0x6C72, 0x6C51, 0x4B6B, 0x3B69, 0x3367, 0x3366, 0x3366, 0x2B66, 0x2B45, 
        0x2B45, 0x2B45, 0x2B45, 0x2345, 0x2345, 0x2345, 0x2365, 0x2365, 0x2345, 0x2365, 0x2365, 0x2365, 0x2366, 0x2346, 0x2346, 0x2345, 0x2345, 0x2325, 0x2325, 0x2345, 0x2B45, 0x3345, 0x3B66, 0x4BE8, 0x4BC8, 0x4366, 0x4B67, 0x5BA9, 0x7C2C, 0x844D, 
        0x948D, 0x94AD, 0x94CD, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CCD, 0x94CC, 0x94AC, 0x94AC, 0x948C, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C4B, 0x844B, 0x840D, 0x8391, 0x72D7, 
        0x6239, 0x51B8, 0x6256, 0x6B15, 0x72F5, 0x72F4, 0x72F5, 0x6A75, 0x5194, 0x4975, 0x59F6, 0x5A16, 0x51F7, 0x51F7, 0x3952, 0x6AF3, 0x7BD0, 0x83CF, 0x8BF0, 0x8C13, 0x9C34, 0x9C55, 0x9C56, 0x9C36, 0x93F8, 0x5A15, 0x4135, 0x4136, 0x3916, 0x3916, 
        0x38F6, 0x4958, 0x59FB, 0x627D, 0x627E, 0x627E, 0x627E, 0x627D, 0x627E, 0x627E, 0x5A7E, 0x49DC, 0x28D9, 0x2099, 0x209A, 0x20BA, 0x20BB, 0x20DB, 0x20FB, 0x211C, 0x20FC, 0x211C, 0x211D, 0x213D, 0x213D, 0x295D, 0x295D, 0x295D, 0x295D, 0x295D, 
        0x295D, 0x295D, 0x295D, 0x297D, 0x297D, 0x297D, 0x297D, 0x297D, 0x295D, 0x295D, 0x215D, 0x215D, 0x215D, 0x193D, 0x191D, 0x191D, 0x18FD, 0x10DD, 0x10BD, 0x109D, 0x109D, 0x109C, 0x089C, 0x08BC, 0x10DC, 0x193D, 0x215D, 0x217D, 0x299D, 0x217D, 
        0x295D, 0x18BC, 0x39BE, 0x4A1D, 0x527E, 0x5A9E, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A9D, 0x529D, 0x529E, 0x529D, 0x529E, 0x529D, 0x527E, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7E, 0x4A7E, 0x4A9E, 0x4A9D, 0x4A9D, 0x529D, 
        0x52BD, 0x52BD, 0x52BD, 0x52DD, 0x5ADE, 0x52DE, 0x52FE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5AFD, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5AFD, 0x5AFD, 0x5AFD, 0x5B1D, 0x5B1E, 0x5B1D, 0x5AFD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 
        0x52FD, 0x52FD, 0x52FD, 0x52DE, 0x52BE, 0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 0x529E, 0x529D, 0x527D, 0x52BD, 0x5ADD, 0x5AFE, 0x5AFD, 0x62FE, 0x631E, 0x631E, 0x633D, 0x633D, 0x633E, 0x631D, 0x52BE, 0x39FC, 0x39FD, 
        0x4A7E, 0x52BE, 0x5ADE, 0x5ABE, 0x5ABD, 0x5A9E, 0x5A9E, 0x5A7D, 0x5A5D, 0x5A5D, 0x625C, 0x5A78, 0x73B6, 0x7433, 0x7431, 0x63EE, 0x5BAC, 0x5BAB, 0x53AB, 0x53AB, 0x5BCB, 0x53CA, 0x53AA, 0x53AA, 0x4BAA, 0x4BAA, 0x4BCA, 0x4BEA, 0x4BEA, 0x43A9, 
        0x43A9, 0x4BC9, 0x5C0A, 0x5C2A, 0x540A, 0x4BE9, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x4BC9, 0x53EA, 0x5C0A, 0x642A, 0x644A, 0x5C2A, 0x5C09, 0x5409, 0x540A, 0x540A, 0x4C0A, 0x4BEA, 0x43C9, 0x3BC9, 
        0x3BA9, 0x3BA9, 0x3BC9, 0x43EA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BEA, 0x3BC9, 0x3BA9, 0x3BA9, 0x4389, 0x4389, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x43CA, 0x43CA, 0x3BCA, 0x3BAA, 0x33CA, 0x33A9, 0x33CA, 0x33CA, 0x33EA, 0x2BEA, 
        0x2BC9, 0x23C9, 0x2BE9, 0x2C09, 0x2C09, 0x23E9, 0x2409, 0x23E9, 0x23E9, 0x1BE8, 0x1BE8, 0x1C08, 0x1C08, 0x1C09, 0x1C09, 0x2409, 0x2409, 0x23E9, 0x2BAA, 0x334A, 0x3B2A, 0x542D, 0x752F, 0x756F, 0x756E, 0x758F, 0x7D8E, 0x7D8F, 0x7DAF, 0x7DAF, 
        0x7DAF, 0x7D8F, 0x7D8F, 0x858F, 0x8590, 0x8590, 0x8590, 0x8590, 0x8590, 0x7D50, 0x6CAD, 0x540B, 0x4BA9, 0x3307, 0x2AA6, 0x2245, 0x1A45, 0x1A25, 0x1A05, 0x1A05, 0x1A05, 0x1A06, 0x1A26, 0x2247, 0x2A88, 0x32CA, 0x3B0B, 0x432B, 0x4B6C,
  0x650C, 0x6D4C, 0x6D8D, 0x6DAD, 0x6DCD, 0x6DCD, 0x6DCD, 0x6DCE, 0x6DEE, 0x75EF, 0x7E0F, 0x7E0F, 0x8610, 0x8610, 0x8610, 0x8E10, 0x8E31, 0x8E31, 0x8E31, 0x8DF1, 0x85D1, 0x7D70, 0x752F, 0x750E, 0x750E, 0x750E, 0x7D2E, 0x8D70, 0x84CF, 0x744E, 0x746E, 
        0x6C8D, 0x648D, 0x64AD, 0x5CAC, 0x5CAD, 0x5CAD, 0x5CAD, 0x5CAD, 0x5C8C, 0x64AD, 0x6CCD, 0x750E, 0x7D2E, 0x856E, 0x8D6F, 0x958F, 0x958F, 0x9D6F, 0x9D6F, 0xA590, 0xA5B0, 0xADB0, 0xAD91, 0xAD91, 0xAD91, 0xADB2, 0xA592, 0x8CF1, 0x7C6F, 0x63ED, 
        0x53AC, 0x644D, 0x6C8E, 0x74CE, 0x6CCE, 0x6CCE, 0x64CE, 0x648E, 0x64CE, 0x5CCE, 0x650E, 0x5D2F, 0x5D0F, 0x4CEE, 0x4CAE, 0x54CF, 0x5CF0, 0x5CD1, 0x5CB1, 0x5C70, 0x6451, 0x6C72, 0x6C51, 0x640F, 0x4B8A, 0x3B48, 0x3367, 0x3366, 0x3366, 0x2B66, 
        0x2B46, 0x2B45, 0x2B45, 0x2B45, 0x2B45, 0x2365, 0x2365, 0x2365, 0x2345, 0x2345, 0x2345, 0x1B45, 0x2345, 0x2346, 0x2346, 0x2345, 0x2325, 0x2325, 0x2325, 0x2325, 0x2B25, 0x2B25, 0x3B66, 0x4BE7, 0x4386, 0x4366, 0x4367, 0x5388, 0x73EB, 0x844D, 
        0x948D, 0x94AD, 0x94CD, 0x9CED, 0x9D0D, 0x9D0D, 0x9D0D, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0xA50D, 0x9CED, 0x9CED, 0x94CC, 0x94AC, 0x94AC, 0x948C, 0x948B, 0x946B, 0x946B, 0x946B, 0x946B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C4B, 0x8C2C, 0x83EE, 0x7B52, 
        0x72B5, 0x6A75, 0x7B54, 0x7B91, 0x7BB0, 0x7BB0, 0x7B90, 0x7B72, 0x7313, 0x72F3, 0x7334, 0x6B33, 0x5AB3, 0x5A74, 0x62D3, 0x73B0, 0x7C0E, 0x83EE, 0x8C2E, 0x9C6F, 0xA4B0, 0xA4D0, 0xA4D0, 0xACD1, 0xA4B3, 0x8375, 0x4993, 0x4155, 0x4156, 0x4156, 
        0x3936, 0x3916, 0x3937, 0x51DA, 0x625D, 0x627E, 0x627D, 0x627D, 0x627E, 0x5A7D, 0x627E, 0x627E, 0x5A5E, 0x49BC, 0x393B, 0x28B9, 0x2099, 0x209A, 0x20BB, 0x20FC, 0x20FC, 0x20FC, 0x211C, 0x211D, 0x213D, 0x213D, 0x213D, 0x213D, 0x293D, 0x213D, 
        0x213D, 0x293D, 0x295D, 0x295D, 0x295D, 0x217D, 0x217D, 0x217D, 0x215D, 0x215D, 0x215D, 0x215D, 0x215D, 0x193D, 0x191D, 0x18FD, 0x10DD, 0x10DD, 0x10BD, 0x109D, 0x107D, 0x087C, 0x087C, 0x087C, 0x089C, 0x10BC, 0x18FD, 0x193D, 0x217D, 0x217D, 
        0x297D, 0x39BE, 0x4A1E, 0x4A7D, 0x5A9D, 0x5ABE, 0x5ABD, 0x5ABE, 0x529E, 0x529E, 0x529E, 0x529D, 0x529D, 0x529D, 0x529D, 0x4A9D, 0x4A7D, 0x4A9D, 0x4A9E, 0x4A9E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52DD, 0x52DD, 0x52DD, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 
        0x5AFD, 0x5AFE, 0x52FD, 0x52DE, 0x52DE, 0x52BD, 0x52BE, 0x52BD, 0x52BD, 0x5ABD, 0x5ABD, 0x52BD, 0x52BD, 0x529E, 0x529E, 0x527D, 0x52BD, 0x5ADD, 0x5AFD, 0x62FE, 0x631E, 0x631E, 0x631E, 0x631D, 0x631D, 0x633E, 0x631E, 0x527E, 0x39BD, 0x423D, 
        0x4A9E, 0x52DE, 0x5ADE, 0x5ADE, 0x5ABE, 0x5A9E, 0x5A7E, 0x627E, 0x5A5D, 0x5A5C, 0x5A5B, 0x5A97, 0x6354, 0x6390, 0x638E, 0x5BAC, 0x53AA, 0x53AA, 0x4BAA, 0x4BAA, 0x4BAA, 0x4BA9, 0x43A9, 0x43A9, 0x43A9, 0x4BAA, 0x4BCA, 0x4BEA, 0x53EA, 0x53EA, 
        0x4BA9, 0x4BC9, 0x53EA, 0x5C0A, 0x540A, 0x4BC9, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x43C9, 0x43C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x53E9, 0x5C0A, 0x644A, 0x644A, 0x5C29, 0x5C0A, 0x5C2A, 0x542A, 0x540A, 0x4C0A, 0x4BEA, 0x43C9, 0x43A9, 
        0x3BA9, 0x3BA9, 0x43CA, 0x43EA, 0x43EA, 0x3BCA, 0x3BCA, 0x3BCA, 0x43CA, 0x43CA, 0x3BCA, 0x3BC9, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x438A, 0x3B89, 0x3B89, 0x3BAA, 0x43AA, 0x3BAA, 0x3BCA, 0x3BCA, 0x33CA, 0x33CA, 0x33CA, 0x33CA, 0x33CA, 0x2BEA, 
        0x2BC9, 0x23C9, 0x2BE9, 0x2C09, 0x2C09, 0x2409, 0x2409, 0x2409, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x1C09, 0x1C09, 0x2409, 0x23E9, 0x2BCA, 0x2B4A, 0x332B, 0x53CC, 0x750F, 0x756F, 0x7D8E, 0x7D8F, 0x7D8E, 0x7DAF, 0x7DAF, 0x7DAF, 
        0x7D8F, 0x7D8F, 0x8590, 0x8590, 0x8590, 0x8590, 0x7D70, 0x752F, 0x6CAD, 0x5C0B, 0x4B8A, 0x3307, 0x2AA6, 0x2265, 0x2245, 0x2245, 0x1A45, 0x1A25, 0x1A25, 0x1A25, 0x1A26, 0x1A26, 0x2247, 0x2268, 0x2AA9, 0x330A, 0x3B2B, 0x436C, 0x4B8C,
  0x650C, 0x652C, 0x6D6C, 0x6DAD, 0x75EE, 0x6DCD, 0x6DCD, 0x6DCE, 0x6DEE, 0x75EF, 0x7E0F, 0x7E0F, 0x8610, 0x85F0, 0x85F0, 0x85F0, 0x8E10, 0x8E31, 0x8E31, 0x8DF1, 0x85D1, 0x7D90, 0x752F, 0x750E, 0x750E, 0x7D2E, 0x854F, 0x8D70, 0x84F0, 0x746E, 0x746E, 
        0x6C8D, 0x648C, 0x5C8C, 0x5C8C, 0x5C8C, 0x5C8C, 0x5CAC, 0x5C8C, 0x5C8C, 0x648C, 0x6CCD, 0x750D, 0x7D4E, 0x856E, 0x8D6E, 0x8D6F, 0x8D6F, 0x954F, 0x9D6F, 0xA590, 0xA5B0, 0xADB1, 0xADB1, 0xADB1, 0xADB2, 0xADB2, 0x9D51, 0x7C90, 0x6C2E, 0x536A, 
        0x4B6A, 0x5C0B, 0x5C2B, 0x646C, 0x6CCE, 0x6CEE, 0x6CEF, 0x64AE, 0x64CE, 0x64CE, 0x5CCE, 0x5CEE, 0x5D0F, 0x54CE, 0x4C8D, 0x4CAE, 0x54EF, 0x5CF1, 0x64D1, 0x6471, 0x6451, 0x6C51, 0x7472, 0x6C30, 0x4B4B, 0x4348, 0x3B67, 0x3366, 0x3366, 0x3366, 
        0x3366, 0x2B66, 0x2B66, 0x2B66, 0x2B66, 0x2B65, 0x2B45, 0x2345, 0x2345, 0x2345, 0x2345, 0x2345, 0x2325, 0x2325, 0x2325, 0x2325, 0x1B25, 0x1B25, 0x2325, 0x2325, 0x2B25, 0x2B25, 0x3B66, 0x4BC7, 0x3B66, 0x3B66, 0x4366, 0x4B67, 0x6389, 0x7C2C, 
        0x8C8D, 0x94AD, 0x94CD, 0x9CED, 0x9D0D, 0x9D0D, 0x9D0D, 0x94ED, 0x94CD, 0x9CED, 0x9D0D, 0xA50D, 0x9CED, 0x9CED, 0x9CCD, 0x94AC, 0x948C, 0x948B, 0x946B, 0x946B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x842C, 0x83CF, 
        0x83B1, 0x83B0, 0x83EF, 0x840D, 0x840D, 0x840D, 0x83ED, 0x7BCE, 0x7BAF, 0x7BCE, 0x7BEE, 0x73D0, 0x6B90, 0x6331, 0x6370, 0x6BCE, 0x740C, 0x7BEC, 0x840C, 0x94AE, 0xA4EE, 0xAD0E, 0xAD0E, 0xAD0E, 0xACEF, 0x9C34, 0x6253, 0x4975, 0x4156, 0x4176, 
        0x4176, 0x3956, 0x3116, 0x3116, 0x3958, 0x51DB, 0x5A3D, 0x627D, 0x5A5D, 0x5A5D, 0x5A5D, 0x625D, 0x627E, 0x625E, 0x5A5E, 0x523E, 0x41BC, 0x311B, 0x28BB, 0x20DA, 0x20DB, 0x20FB, 0x20FC, 0x211C, 0x211C, 0x211C, 0x213D, 0x213D, 0x213D, 0x213D, 
        0x213D, 0x213D, 0x213D, 0x213D, 0x213D, 0x215D, 0x215D, 0x215D, 0x215D, 0x213D, 0x213D, 0x213D, 0x193D, 0x191D, 0x18FD, 0x10FD, 0x10DD, 0x10DD, 0x10BD, 0x109D, 0x109C, 0x087C, 0x087C, 0x087C, 0x107C, 0x087C, 0x109D, 0x18DD, 0x211D, 0x215D, 
        0x299D, 0x41FE, 0x4A5D, 0x529E, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABE, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A9E, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52DD, 0x52DE, 0x5ADD, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5AFE, 0x52FD, 0x52FD, 0x52DD, 0x52FD, 0x52FD, 0x5AFE, 
        0x5AFE, 0x5AFE, 0x52FD, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x529D, 0x527D, 0x52BD, 0x5ADD, 0x5AFD, 0x62FE, 0x631E, 0x631E, 0x631D, 0x631E, 0x631E, 0x631E, 0x5AFE, 0x423D, 0x39FD, 0x4A7E, 
        0x52BD, 0x52DE, 0x5ADE, 0x5ADE, 0x5ABE, 0x5A9E, 0x5A7E, 0x5A7D, 0x5A5D, 0x5A5C, 0x5A59, 0x5AB4, 0x5B30, 0x5B6C, 0x5B8B, 0x5BAA, 0x53C9, 0x4BC9, 0x4BA9, 0x43A9, 0x43A9, 0x43A8, 0x43A8, 0x43A9, 0x4389, 0x43A9, 0x43A9, 0x4BC9, 0x53EA, 0x540B, 
        0x53EA, 0x4BA9, 0x53CA, 0x53EA, 0x53EA, 0x4BC9, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x43C9, 0x43C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x53EA, 0x5C0A, 0x642A, 0x644A, 0x5C2A, 0x5C2A, 0x5C2A, 0x542A, 0x540A, 0x4C0A, 0x4BEA, 0x43C9, 0x43A9, 
        0x3BA9, 0x3BA9, 0x43CA, 0x43EA, 0x43EA, 0x43CA, 0x43EA, 0x43EA, 0x43CA, 0x43CA, 0x43CA, 0x43A9, 0x43AA, 0x43AA, 0x438A, 0x438A, 0x438A, 0x3B89, 0x3389, 0x3B89, 0x3BAA, 0x3BAA, 0x33CA, 0x33AA, 0x33AA, 0x33CA, 0x33CA, 0x2BC9, 0x33CA, 0x2BEA, 
        0x2BC9, 0x2BC9, 0x2BE9, 0x2C09, 0x2409, 0x23E9, 0x2409, 0x2409, 0x2409, 0x23E9, 0x23E9, 0x1BE8, 0x1BE8, 0x1C09, 0x1C09, 0x1C09, 0x1C09, 0x23E9, 0x23C9, 0x2B6A, 0x334B, 0x43AC, 0x64CE, 0x756F, 0x7D8F, 0x7D8F, 0x7DAF, 0x7DAF, 0x85AF, 0x7DAF, 
        0x858F, 0x858F, 0x8590, 0x8590, 0x7D70, 0x7D2F, 0x6CAD, 0x53EB, 0x4389, 0x3307, 0x2AA6, 0x2A86, 0x2265, 0x2245, 0x2245, 0x1A45, 0x1A45, 0x1A45, 0x1A45, 0x1A46, 0x1A66, 0x1A66, 0x2267, 0x2288, 0x2AC9, 0x332A, 0x3B4B, 0x4B8C, 0x53AD,
  0x650C, 0x6D4C, 0x6D8D, 0x75CE, 0x75CE, 0x6DCD, 0x6DCD, 0x6DEE, 0x6E0F, 0x760F, 0x760F, 0x7DF0, 0x85F0, 0x85D0, 0x85CF, 0x85D0, 0x85F0, 0x8E10, 0x8E11, 0x85F0, 0x85D0, 0x7D90, 0x752F, 0x750F, 0x752E, 0x854F, 0x8D90, 0x8D70, 0x8510, 0x7C6E, 0x746E, 
        0x6C8D, 0x648C, 0x5C8C, 0x5C8C, 0x5C8C, 0x548C, 0x548C, 0x5C8C, 0x5C8C, 0x5C8C, 0x64CC, 0x6D0D, 0x7D4D, 0x856E, 0x856E, 0x8D6F, 0x8D4F, 0x954F, 0x9D6F, 0xA590, 0xADB0, 0xADB1, 0xADB1, 0xADB2, 0xADB2, 0xA592, 0x8CF0, 0x7C6F, 0x63CC, 0x4B29, 
        0x4B69, 0x53EA, 0x540A, 0x53EA, 0x5C6C, 0x6CEE, 0x6D0E, 0x64EF, 0x64EE, 0x64CE, 0x5CAE, 0x5CAE, 0x5CEF, 0x54CE, 0x4C8D, 0x4C8D, 0x54CF, 0x5CF0, 0x5CD1, 0x6491, 0x6C72, 0x7472, 0x7CB3, 0x6C11, 0x5B8D, 0x53CB, 0x4BA9, 0x43A8, 0x3B86, 0x3386, 
        0x3386, 0x3366, 0x3366, 0x3386, 0x3366, 0x2B65, 0x2B45, 0x2B45, 0x2345, 0x2325, 0x2325, 0x1B25, 0x2325, 0x2325, 0x1B25, 0x1B05, 0x1B05, 0x1B25, 0x2325, 0x2325, 0x2325, 0x2B25, 0x3B86, 0x43A7, 0x3B66, 0x3B66, 0x3B46, 0x4346, 0x5B68, 0x740B, 
        0x8C6D, 0x94AD, 0x94CD, 0x9CED, 0x9D0D, 0x9D2D, 0x9D2D, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CCD, 0x94AC, 0x948C, 0x948B, 0x946B, 0x946B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C4B, 0x8C6B, 0x8C2C, 
        0x8C2D, 0x842D, 0x842D, 0x844C, 0x844B, 0x842B, 0x842B, 0x842B, 0x842B, 0x842C, 0x842C, 0x7C0D, 0x73EE, 0x638E, 0x638E, 0x63ED, 0x640C, 0x6BEC, 0x6BCA, 0x948D, 0xA4EE, 0xAD0E, 0xAD0D, 0xAD0D, 0xAD0F, 0xA492, 0x7B34, 0x4994, 0x4176, 0x4196, 
        0x4197, 0x3976, 0x3956, 0x3136, 0x3116, 0x3117, 0x4159, 0x625D, 0x5A3D, 0x5A3D, 0x5A3D, 0x625D, 0x627D, 0x627D, 0x627D, 0x627D, 0x627D, 0x5A5E, 0x521D, 0x41BD, 0x313C, 0x20DB, 0x20DB, 0x20FB, 0x20FC, 0x20FC, 0x20FC, 0x211C, 0x211C, 0x211C, 
        0x211D, 0x211D, 0x213D, 0x213D, 0x213D, 0x213D, 0x213D, 0x213D, 0x213D, 0x193D, 0x191D, 0x191D, 0x18FD, 0x10DD, 0x10DC, 0x10DD, 0x10DD, 0x10DD, 0x10BC, 0x109C, 0x109C, 0x087C, 0x087C, 0x087C, 0x087C, 0x087C, 0x087C, 0x109C, 0x18DD, 0x213D, 
        0x39BD, 0x4A1E, 0x527E, 0x5A9E, 0x5ABD, 0x5ABD, 0x5ABD, 0x529D, 0x529E, 0x529E, 0x529E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9E, 0x4A9E, 0x4A7E, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A7D, 0x4A9E, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52DD, 0x52DE, 0x52DD, 0x52DE, 0x52FD, 0x5AFE, 0x5AFD, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1E, 0x5AFE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x5AFE, 
        0x5AFD, 0x52FD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x5ABD, 0x5ABD, 0x529E, 0x529D, 0x527D, 0x529D, 0x5ABD, 0x5ADD, 0x62FE, 0x62FE, 0x62FD, 0x5AFD, 0x631E, 0x631E, 0x631E, 0x5ADE, 0x421D, 0x423D, 0x4A9E, 
        0x52DE, 0x5ADE, 0x5ADE, 0x5ADE, 0x5A9E, 0x5A9E, 0x5A7D, 0x5A5D, 0x5A5D, 0x5A5B, 0x5A78, 0x5AD2, 0x534D, 0x538A, 0x53AA, 0x53C9, 0x4BC9, 0x4BC9, 0x43A8, 0x43A8, 0x43A8, 0x43C8, 0x43C8, 0x43A8, 0x3BA8, 0x3B88, 0x3B88, 0x4389, 0x4BA9, 0x4BCA, 
        0x53CA, 0x4BA9, 0x53CA, 0x53CA, 0x53CA, 0x4BCA, 0x4BC9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x43C9, 0x4BC9, 0x43C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x53EA, 0x5C09, 0x5C2A, 0x644A, 0x5C2A, 0x5C2A, 0x5C2A, 0x542A, 0x5409, 0x4BE9, 0x4BE9, 0x43C9, 0x43A9, 
        0x3BA9, 0x3BA9, 0x43CA, 0x43EA, 0x43EA, 0x43CA, 0x43EA, 0x43EA, 0x43CA, 0x43CA, 0x43A9, 0x43A9, 0x43AA, 0x438A, 0x438A, 0x438A, 0x3B89, 0x3389, 0x3389, 0x33AA, 0x33AA, 0x3BAA, 0x33CA, 0x33AA, 0x33CA, 0x33CA, 0x33A9, 0x33A9, 0x33CA, 0x33CA, 
        0x2BC9, 0x2BC9, 0x2BE9, 0x2409, 0x2409, 0x23E9, 0x23E9, 0x2C09, 0x2409, 0x23E9, 0x23E9, 0x1BE8, 0x1C09, 0x2409, 0x1C09, 0x1C09, 0x1C09, 0x2409, 0x23E9, 0x236A, 0x336A, 0x43AB, 0x64CE, 0x7D6F, 0x7D8F, 0x7D8F, 0x7DAF, 0x8590, 0x7D8F, 0x7D8F, 
        0x7D70, 0x856F, 0x7D4F, 0x7D2F, 0x6CAD, 0x5C0B, 0x4369, 0x32E7, 0x2AA6, 0x2A86, 0x2A86, 0x2266, 0x2266, 0x2266, 0x2266, 0x2265, 0x2265, 0x2266, 0x2286, 0x2286, 0x2286, 0x2286, 0x22A7, 0x2AC8, 0x32E9, 0x3B4B, 0x436B, 0x4BAC, 0x53CD,
  0x754D, 0x756D, 0x75AE, 0x7DEE, 0x75EE, 0x75EE, 0x6DEE, 0x760E, 0x762F, 0x7E50, 0x7E10, 0x7DCF, 0x85CF, 0x85CF, 0x85D0, 0x8DF0, 0x8DF0, 0x85F0, 0x85F0, 0x85F0, 0x85B0, 0x7D90, 0x754F, 0x750E, 0x752E, 0x858F, 0x95D1, 0x8D50, 0x84F0, 0x7C8F, 0x746E, 
        0x6C8D, 0x646D, 0x5C6C, 0x5C8C, 0x548C, 0x548C, 0x548C, 0x548C, 0x548B, 0x5C8C, 0x64CC, 0x6D0D, 0x754D, 0x7D4E, 0x856F, 0x8D6F, 0x9570, 0x956F, 0x9D6F, 0xA590, 0xADB0, 0xADD1, 0xB5B1, 0xB5D2, 0xADB2, 0x9D52, 0x84AF, 0x744E, 0x5B8B, 0x4B49, 
        0x4B88, 0x4BA9, 0x53E9, 0x5409, 0x540A, 0x648C, 0x64AD, 0x6D0F, 0x6D2F, 0x6D0E, 0x5CCE, 0x5C8E, 0x5CAE, 0x546E, 0x4C6E, 0x446D, 0x4C8E, 0x5CD0, 0x64B1, 0x64B2, 0x6C92, 0x7492, 0x7C93, 0x6BD0, 0x6BCF, 0x6C0E, 0x642C, 0x43A8, 0x3B87, 0x3B86, 
        0x3B86, 0x3B86, 0x3B87, 0x3B86, 0x3366, 0x3366, 0x2B45, 0x2B45, 0x2B45, 0x2325, 0x2325, 0x2325, 0x2325, 0x2325, 0x1B25, 0x1B05, 0x1B05, 0x1B05, 0x2305, 0x2305, 0x2B25, 0x2B45, 0x3B86, 0x3B66, 0x3345, 0x3345, 0x3345, 0x3B66, 0x4B67, 0x6BCA, 
        0x844C, 0x948D, 0x94CE, 0x9CED, 0x9D0D, 0x9D0E, 0xA52E, 0x9CED, 0x9CED, 0x9CED, 0x9CCD, 0x9CED, 0xA4ED, 0xA4ED, 0x9CCD, 0x94AC, 0x94AC, 0x948C, 0x948B, 0x946B, 0x946B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6C, 
        0x8C4C, 0x8C4C, 0x8C4C, 0x8C6B, 0x8C6B, 0x8C4B, 0x842B, 0x842B, 0x842B, 0x842B, 0x842B, 0x840C, 0x7C0C, 0x6BED, 0x5BAD, 0x5BED, 0x640D, 0x640C, 0x63CA, 0x844C, 0xA50E, 0xAD0D, 0xAD0D, 0xAD0D, 0xAD0E, 0xACF0, 0x9C34, 0x6233, 0x4995, 0x4996, 
        0x41B6, 0x4196, 0x3976, 0x3976, 0x3955, 0x3935, 0x3916, 0x499A, 0x5A1D, 0x5A1D, 0x5A3D, 0x625D, 0x625D, 0x627D, 0x627D, 0x627D, 0x627D, 0x629E, 0x629E, 0x5A9E, 0x5A7E, 0x523E, 0x49DD, 0x397C, 0x291B, 0x20DB, 0x20DB, 0x20DC, 0x20FC, 0x20FC, 
        0x20FC, 0x20FC, 0x211C, 0x211C, 0x211D, 0x211C, 0x191D, 0x191D, 0x191D, 0x18FD, 0x18FD, 0x18FD, 0x10DC, 0x10DC, 0x10BC, 0x10BC, 0x10BC, 0x10BD, 0x10BC, 0x109C, 0x089C, 0x087B, 0x087B, 0x085B, 0x085B, 0x085C, 0x085C, 0x107C, 0x10BC, 0x293D, 
        0x41FD, 0x4A3D, 0x525E, 0x5A9E, 0x5ABD, 0x5ABD, 0x5ABD, 0x529D, 0x529D, 0x529E, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A7E, 0x4A7E, 0x4A7D, 0x4A7D, 0x427D, 0x427D, 0x4A7D, 0x4A9E, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52DD, 0x52DD, 0x52FD, 0x52DE, 0x52DE, 0x5AFE, 0x5AFD, 0x5AFD, 0x5B1E, 0x5B1E, 0x5B1E, 0x5B1D, 0x52FD, 0x52FD, 0x5AFD, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1D, 0x5B1E, 0x5B1D, 0x52FD, 0x52FD, 0x5AFE, 0x5AFE, 0x5AFE, 
        0x5AFD, 0x52FD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529E, 0x529D, 0x527D, 0x529D, 0x5ADD, 0x5AFE, 0x5AFE, 0x62FE, 0x62FE, 0x5B1E, 0x631D, 0x631E, 0x5AFD, 0x527D, 0x41FD, 0x4A7E, 0x52BE, 
        0x52DE, 0x5ABE, 0x5ABE, 0x5ABE, 0x5A9E, 0x5A7D, 0x5A5D, 0x5A5D, 0x5A3C, 0x5A5A, 0x5A96, 0x5310, 0x538B, 0x53AA, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BC8, 0x43A8, 0x43A8, 0x43C8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x4389, 0x4389, 
        0x4BA9, 0x4BCA, 0x53CA, 0x53AA, 0x53AA, 0x4BCA, 0x43A9, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x4BC9, 0x4BC9, 0x53C9, 0x53E9, 0x5C09, 0x5C2A, 0x642A, 0x642A, 0x5C2A, 0x5C2A, 0x5409, 0x4C09, 0x4BE9, 0x4BE9, 0x43C9, 0x43A9, 
        0x43A9, 0x43C9, 0x43CA, 0x43EA, 0x43CA, 0x43CA, 0x43CA, 0x43CA, 0x43CA, 0x43A9, 0x43AA, 0x43AA, 0x3BAA, 0x3BA9, 0x43AA, 0x43AA, 0x3BA9, 0x33A9, 0x33A9, 0x33AA, 0x33AA, 0x33AA, 0x33CA, 0x33CA, 0x33CA, 0x33CA, 0x33AA, 0x33CA, 0x33CA, 0x33EA, 
        0x33EA, 0x2BCA, 0x2BCA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E8, 0x23E8, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x2409, 0x2409, 0x23E9, 0x238A, 0x336A, 0x43AB, 0x6CAE, 0x7D4F, 0x7D8F, 0x858F, 0x85AF, 0x85B0, 0x8590, 0x856F, 
        0x7D4F, 0x74EE, 0x6C8D, 0x5C2B, 0x4BAA, 0x4328, 0x32C7, 0x32C7, 0x2AA6, 0x2A86, 0x2286, 0x2286, 0x2286, 0x2286, 0x2286, 0x2286, 0x2285, 0x2286, 0x22A6, 0x22A6, 0x22C6, 0x22C7, 0x22C7, 0x2AE8, 0x3309, 0x3B6A, 0x438C, 0x4BCD, 0x53ED,
  0x7DAF, 0x7DEF, 0x860F, 0x860F, 0x7E2F, 0x760E, 0x760E, 0x760E, 0x762F, 0x7E4F, 0x7DEF, 0x75AF, 0x7D8F, 0x85D0, 0x8E11, 0x8E11, 0x8DF0, 0x85D0, 0x85CF, 0x7DCF, 0x7DB0, 0x7D90, 0x754F, 0x752F, 0x7D4F, 0x858F, 0x8DB0, 0x8550, 0x7CB0, 0x7C8F, 0x748E, 
        0x6C8D, 0x648D, 0x5C6C, 0x5C8C, 0x548C, 0x548C, 0x548C, 0x548C, 0x548B, 0x5CAB, 0x64EC, 0x6D2D, 0x754E, 0x7D6F, 0x8D90, 0x95D1, 0x9DD1, 0x9DB0, 0x9D90, 0xA5B1, 0xADD1, 0xADD1, 0xB5D1, 0xADB2, 0xADB3, 0x9D31, 0x846F, 0x63CC, 0x536A, 0x4B89, 
        0x4BA8, 0x4BC8, 0x53E9, 0x5C2A, 0x5409, 0x5409, 0x5C4B, 0x6D0E, 0x6D4F, 0x6D4F, 0x64EF, 0x5CAE, 0x5C8E, 0x546E, 0x4C2D, 0x4C2D, 0x4C6E, 0x5CAF, 0x64B0, 0x6CD1, 0x6CB2, 0x7492, 0x7C72, 0x7411, 0x6BD0, 0x63AE, 0x538B, 0x4387, 0x4387, 0x4387, 
        0x3B87, 0x3B87, 0x3B87, 0x3B67, 0x3B66, 0x3366, 0x3365, 0x3345, 0x2B45, 0x2325, 0x2325, 0x2325, 0x1B05, 0x2305, 0x2304, 0x1B04, 0x2304, 0x1B05, 0x2305, 0x2305, 0x2B05, 0x3345, 0x3B86, 0x3B65, 0x3365, 0x3345, 0x3345, 0x3B66, 0x4367, 0x5B89, 
        0x7C0B, 0x8C6D, 0x94AE, 0x9CED, 0x9CED, 0x9D0D, 0x9D0D, 0x9CED, 0x9CED, 0x9CCD, 0x9CCD, 0x9CCD, 0x9CCD, 0x9CCD, 0x9CCC, 0x94AC, 0x94AC, 0x94AC, 0x948C, 0x948B, 0x948B, 0x8C8B, 0x8C6B, 0x948B, 0x948B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6C, 
        0x8C6C, 0x8C6C, 0x8C6C, 0x8C6C, 0x8C6B, 0x8C4B, 0x8C4B, 0x844B, 0x842B, 0x842B, 0x842B, 0x842B, 0x7C2B, 0x740C, 0x6BED, 0x5BCC, 0x63ED, 0x640D, 0x63EB, 0x7C2B, 0xA4EE, 0xACED, 0xACED, 0xACED, 0xAD0E, 0xAD0F, 0xA492, 0x8355, 0x51D4, 0x49B5, 
        0x49B6, 0x41B6, 0x41B6, 0x3996, 0x3975, 0x3975, 0x3935, 0x3917, 0x51BB, 0x5A1D, 0x623D, 0x625D, 0x6A5D, 0x625D, 0x627D, 0x627D, 0x629D, 0x629D, 0x629E, 0x629D, 0x62BE, 0x62BE, 0x629E, 0x5A7E, 0x523E, 0x49DD, 0x395C, 0x291B, 0x20FB, 0x20DB, 
        0x20DC, 0x20FC, 0x20FC, 0x20FC, 0x20FC, 0x18FC, 0x18DC, 0x18DC, 0x10DC, 0x10DC, 0x10DC, 0x10DC, 0x10BC, 0x10BC, 0x089C, 0x089C, 0x089C, 0x10BC, 0x109C, 0x089C, 0x087C, 0x087B, 0x087B, 0x085B, 0x085B, 0x083B, 0x085C, 0x085C, 0x107B, 0x319D, 
        0x421D, 0x4A3D, 0x525D, 0x5A9E, 0x5A9D, 0x5A9D, 0x5A9D, 0x529D, 0x529D, 0x4A7E, 0x4A7E, 0x4A7D, 0x4A7E, 0x4A7E, 0x4A7D, 0x4A7D, 0x4A7D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 
        0x52BE, 0x52BD, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 0x52DE, 0x52FE, 0x52FD, 0x52FE, 0x5AFE, 0x5AFE, 0x5AFE, 0x52FD, 0x52FD, 0x5AFD, 0x5B1D, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5B1E, 0x5B1D, 0x5AFD, 0x52DE, 0x52DE, 0x5AFE, 0x5AFD, 0x52FD, 
        0x52FD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x527D, 0x527D, 0x529E, 0x5ABD, 0x5ADD, 0x5AFE, 0x62FE, 0x5AFE, 0x631E, 0x631D, 0x5B1E, 0x5ABD, 0x421C, 0x421D, 0x4A9E, 0x52BE, 
        0x52BD, 0x5ABE, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A5D, 0x5A3D, 0x5A3D, 0x5A3C, 0x5A58, 0x52B3, 0x532E, 0x53AB, 0x53CA, 0x53C9, 0x4BE9, 0x4BE9, 0x4BC9, 0x4BC8, 0x4BC9, 0x4BC9, 0x43C8, 0x43C9, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x3BA8, 0x4389, 0x4389, 
        0x4B89, 0x4BA9, 0x53AA, 0x53AA, 0x53CB, 0x53EB, 0x4BAA, 0x43AA, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BE9, 0x4BE9, 0x53E9, 0x53E9, 0x5BE9, 0x5C0A, 0x5C2A, 0x642A, 0x5C2A, 0x5C2A, 0x5409, 0x4BE9, 0x4BE9, 0x4BC9, 0x4BC9, 0x43C9, 
        0x43C9, 0x43C9, 0x43E9, 0x43EA, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43A9, 0x43A9, 0x43AA, 0x43AA, 0x3B8A, 0x3BA9, 0x3BAA, 0x3BAA, 0x3BA9, 0x33A9, 0x33A9, 0x33AA, 0x33AA, 0x33AA, 0x33CA, 0x33CA, 0x33CA, 0x33CA, 0x3BCA, 0x440B, 0x440B, 0x3C0B, 
        0x3C0B, 0x33EA, 0x2BCA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E8, 0x23E8, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C08, 0x2408, 0x2409, 0x23E9, 0x2BAA, 0x338A, 0x438B, 0x5C2D, 0x6CEE, 0x7D6F, 0x8590, 0x8590, 0x8590, 0x7D70, 0x750E, 
        0x6CAD, 0x5C0B, 0x4BAA, 0x4369, 0x3B28, 0x3AE7, 0x32C7, 0x32C7, 0x2AA7, 0x2AA7, 0x2286, 0x2286, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E7, 0x2AE7, 0x2B08, 0x3329, 0x336A, 0x43AB, 0x4BCD, 0x5BED,
  0x8610, 0x8610, 0x8630, 0x862F, 0x7E2F, 0x760E, 0x760E, 0x6DEE, 0x6E0E, 0x760F, 0x75AF, 0x758E, 0x7DAF, 0x85D0, 0x85D0, 0x85D0, 0x85D0, 0x85CF, 0x7DAF, 0x7DAF, 0x7DAF, 0x7DB0, 0x756F, 0x752F, 0x752F, 0x858F, 0x8590, 0x7D0F, 0x74AF, 0x7C90, 0x74AF, 
        0x6CAD, 0x648D, 0x5C8C, 0x5C8C, 0x548C, 0x548C, 0x5C8C, 0x5CAC, 0x5CAC, 0x64EC, 0x6D2D, 0x6D2D, 0x754E, 0x7D6F, 0x85B0, 0x95F2, 0x9DF2, 0x9DB1, 0x9D90, 0xA5B1, 0xADD1, 0xADD1, 0xB5B1, 0xAD92, 0xAD92, 0x94F1, 0x7C4E, 0x5B8B, 0x536A, 0x53A9, 
        0x53C8, 0x4BE8, 0x53E8, 0x5C29, 0x5C29, 0x5429, 0x5C4A, 0x5C8B, 0x64AD, 0x754F, 0x7550, 0x6CCF, 0x5C6E, 0x5C4E, 0x544D, 0x4C4E, 0x544E, 0x5CAF, 0x5CB0, 0x6CD1, 0x74D2, 0x74B2, 0x7C93, 0x7452, 0x6BD0, 0x6BCF, 0x5B8C, 0x4B68, 0x4368, 0x4B87, 
        0x4B88, 0x4B88, 0x4B88, 0x4BA8, 0x4BA8, 0x3B66, 0x3366, 0x3346, 0x2B45, 0x2B25, 0x2325, 0x2325, 0x2305, 0x2305, 0x2305, 0x22E5, 0x2305, 0x2305, 0x2305, 0x2305, 0x2B25, 0x3B86, 0x43A6, 0x3B65, 0x3365, 0x3345, 0x3365, 0x3B66, 0x4367, 0x5368, 
        0x6BCA, 0x8C4C, 0x948D, 0x9CCD, 0x9CED, 0x9CED, 0x9CED, 0x9CED, 0x9CCD, 0x9CCD, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x948C, 0x948B, 0x948B, 0x948B, 0x8C6B, 0x948B, 0x948B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 
        0x8C6B, 0x8C8B, 0x8C8C, 0x8C8B, 0x8C6B, 0x8C4B, 0x844A, 0x844A, 0x844A, 0x844B, 0x842A, 0x842B, 0x842B, 0x842C, 0x742C, 0x63EC, 0x5BAC, 0x5BED, 0x5BEC, 0x742C, 0x9CCE, 0xA4ED, 0xA4ED, 0x9C8C, 0xA4CD, 0xAD0E, 0xA4D0, 0x9C53, 0x6AB4, 0x51D5, 
        0x49B6, 0x41B6, 0x41D6, 0x41B6, 0x3996, 0x3995, 0x3955, 0x3936, 0x3917, 0x499A, 0x5A1C, 0x625D, 0x625D, 0x625D, 0x627D, 0x627D, 0x627D, 0x629D, 0x629D, 0x62BD, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BE, 0x629E, 0x5A7E, 0x49FD, 0x399C, 
        0x28FB, 0x20DB, 0x20DB, 0x20DB, 0x18DC, 0x18DC, 0x18BC, 0x10BC, 0x10BC, 0x10BC, 0x10BC, 0x10BC, 0x10BC, 0x089C, 0x089C, 0x089C, 0x089C, 0x109B, 0x089B, 0x087B, 0x087B, 0x085B, 0x085B, 0x003B, 0x083B, 0x085B, 0x083B, 0x085B, 0x107B, 0x39DE, 
        0x421D, 0x4A3D, 0x525D, 0x5A9E, 0x5A9E, 0x527E, 0x527E, 0x527D, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x4A5D, 0x427D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x427D, 0x427D, 0x427D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 
        0x52BD, 0x52BD, 0x52DD, 0x52DE, 0x5AFE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5AFE, 0x5B1D, 0x52FE, 0x52FE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 
        0x52DE, 0x52DD, 0x52BD, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x527E, 0x527D, 0x529D, 0x5ABD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x62FE, 0x5AFD, 0x5AFE, 0x4A5D, 0x39DC, 0x4A5D, 0x4A9D, 0x52BE, 
        0x52BD, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A7E, 0x5A3D, 0x5A1D, 0x5A3C, 0x5A3A, 0x5276, 0x52F1, 0x5B8C, 0x53CA, 0x53EA, 0x53E9, 0x53E9, 0x4BE9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC8, 0x4BC8, 0x4BC8, 0x4BC8, 0x43A8, 0x43A8, 0x43A8, 0x43A8, 0x43A8, 0x4389, 
        0x4389, 0x4B89, 0x4B89, 0x53AA, 0x5BCB, 0x5C0B, 0x540B, 0x4BCB, 0x43AA, 0x43AA, 0x43A9, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x4BE9, 0x4BC9, 0x53C9, 0x5BE9, 0x5C09, 0x5C2A, 0x642A, 0x642A, 0x5C2A, 0x5409, 0x5409, 0x53E9, 0x4BC9, 0x4BC9, 0x4BC9, 
        0x43C9, 0x43C9, 0x4BEA, 0x4BEA, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x43AA, 0x3BAA, 0x3B8A, 0x3BAA, 0x3BAA, 0x3BAA, 0x3BA9, 0x3389, 0x33A9, 0x3BAA, 0x3BAA, 0x33CA, 0x33CA, 0x33CA, 0x33CA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BEB, 0x3BEB, 
        0x3C0B, 0x3C0B, 0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x23E9, 0x2BAA, 0x2B8A, 0x3B8B, 0x53EC, 0x74CF, 0x8570, 0x8590, 0x8570, 0x7D2F, 0x6CAD, 0x5C4B, 
        0x53EA, 0x4B89, 0x4348, 0x3B28, 0x3307, 0x32E7, 0x32E7, 0x32C7, 0x2AC7, 0x2AC7, 0x2AA6, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x2306, 0x2306, 0x2B07, 0x2B07, 0x2B28, 0x3348, 0x3B89, 0x43AB, 0x4BEC, 0x540D,
  0x8630, 0x8630, 0x7E2F, 0x7E0F, 0x7E0E, 0x75EE, 0x6DED, 0x6DED, 0x6DEE, 0x6DEE, 0x6DAE, 0x75AF, 0x7DCF, 0x7DD0, 0x85F0, 0x85D0, 0x7DCF, 0x7DCF, 0x7DCF, 0x75AF, 0x75AF, 0x75AF, 0x756F, 0x750F, 0x752E, 0x7D4F, 0x858F, 0x8570, 0x7CF0, 0x7C8F, 0x74AE, 
        0x6CAE, 0x648D, 0x5C8D, 0x5C8C, 0x548C, 0x548C, 0x5CAC, 0x5CAC, 0x5CCC, 0x64EC, 0x6D2D, 0x6D2E, 0x756F, 0x8DF1, 0x9E32, 0x9E33, 0x9DF2, 0x9DD1, 0x9DB1, 0xA5D1, 0xADD1, 0xB5D1, 0xB5D2, 0xB592, 0xA511, 0x9CD1, 0x7C0E, 0x5B6B, 0x5BCB, 0x5BEA, 
        0x53E9, 0x53E8, 0x5408, 0x5C28, 0x5C29, 0x5C29, 0x5C29, 0x5C2A, 0x64AC, 0x6D0E, 0x752F, 0x74F0, 0x6CAF, 0x648F, 0x5C4E, 0x4C0D, 0x544E, 0x5C8F, 0x64B0, 0x6CD1, 0x74D1, 0x7CD2, 0x7CB2, 0x7C72, 0x7411, 0x6BF0, 0x6BED, 0x63EB, 0x6C0B, 0x6C4C, 
        0x6C4C, 0x6C4C, 0x6C4C, 0x6C4C, 0x53C9, 0x4367, 0x3B66, 0x3B66, 0x3346, 0x2B25, 0x2B25, 0x2325, 0x2305, 0x2305, 0x2305, 0x2305, 0x2305, 0x2305, 0x2305, 0x2B05, 0x2B25, 0x43C7, 0x3B86, 0x3345, 0x3345, 0x3365, 0x3365, 0x3B65, 0x3B66, 0x4B48, 
        0x6369, 0x7BEB, 0x8C4C, 0x9CAD, 0x9CCD, 0x9CED, 0x9CCD, 0x9CCD, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x948C, 0x948B, 0x948B, 0x946B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 
        0x8C6B, 0x8C6B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C4B, 0x844A, 0x842A, 0x842B, 0x842A, 0x842A, 0x842B, 0x842B, 0x842B, 0x7C2C, 0x6C0C, 0x5BCC, 0x53AC, 0x53EC, 0x63EC, 0x8C8D, 0xA4EE, 0xA50E, 0x9C8D, 0x944C, 0xAD0E, 0xAD0F, 0xA4D2, 0x8BF5, 0x5A54, 
        0x49D5, 0x49B6, 0x49D6, 0x41D6, 0x41B6, 0x41B6, 0x3995, 0x3976, 0x3136, 0x3117, 0x3938, 0x499A, 0x59FC, 0x623D, 0x625D, 0x627D, 0x627D, 0x627E, 0x629D, 0x629D, 0x62BD, 0x629D, 0x62BD, 0x62BD, 0x6ABE, 0x6ABE, 0x6ABE, 0x62BE, 0x62BE, 0x5A9E, 
        0x525D, 0x41DC, 0x397C, 0x293B, 0x20DB, 0x18BB, 0x189B, 0x189B, 0x189B, 0x189B, 0x189C, 0x109C, 0x109C, 0x109B, 0x109B, 0x109B, 0x109B, 0x107B, 0x087B, 0x087B, 0x085B, 0x085B, 0x085B, 0x083A, 0x083A, 0x083B, 0x083B, 0x085B, 0x20DC, 0x41DE, 
        0x41FD, 0x4A1D, 0x4A5D, 0x527E, 0x527E, 0x525D, 0x4A5E, 0x4A5D, 0x4A5D, 0x4A5E, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x4A5D, 0x425D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x427D, 0x427D, 0x427D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 
        0x52BD, 0x52BD, 0x52DD, 0x52DD, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x5AFE, 0x5B1D, 0x5B1E, 0x52FE, 0x52FD, 0x52DE, 0x52DE, 0x52DD, 
        0x52DD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529E, 0x527D, 0x527D, 0x529D, 0x5ABD, 0x5ADE, 0x5AFE, 0x5AFE, 0x5AFE, 0x62FE, 0x5AFE, 0x5ABE, 0x39DC, 0x421D, 0x529E, 0x52BD, 0x52BD, 
        0x52BD, 0x5A9D, 0x5A9E, 0x5A7D, 0x5A7D, 0x5A3C, 0x5A1C, 0x5A1B, 0x5A39, 0x52B4, 0x532F, 0x5BAB, 0x5BEA, 0x53EA, 0x53E9, 0x53E9, 0x53E9, 0x53E9, 0x4BC9, 0x4BE9, 0x4BC9, 0x4BC8, 0x4BC8, 0x4BC8, 0x43A8, 0x43A8, 0x43A8, 0x43C9, 0x4BC9, 0x43C9, 
        0x43A9, 0x43A9, 0x4BA9, 0x53CA, 0x5BEB, 0x5C0C, 0x5C2C, 0x53EC, 0x4BAB, 0x4BCB, 0x43CA, 0x43A9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x4BC9, 0x53C9, 0x53E9, 0x5BE9, 0x5C0A, 0x642A, 0x642A, 0x5C2A, 0x5C0A, 0x5409, 0x53E9, 0x4BE9, 0x4BC9, 0x4BC9, 
        0x4BC9, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BC9, 0x4BC9, 0x4BE9, 0x43C9, 0x43C9, 0x43C9, 0x43AA, 0x3BAA, 0x3B89, 0x3BAA, 0x43CA, 0x3BCA, 0x3389, 0x3389, 0x33A9, 0x3BAA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x33CA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BEB, 
        0x442C, 0x3C0C, 0x33EA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2429, 0x2409, 0x23E9, 0x23CA, 0x2B8A, 0x3B8B, 0x53ED, 0x74D0, 0x8550, 0x7D30, 0x74EE, 0x646C, 0x540A, 0x4BA9, 
        0x4389, 0x4369, 0x3B48, 0x3B28, 0x3308, 0x3307, 0x32E7, 0x32E7, 0x32E7, 0x2AE7, 0x2AC6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x22E6, 0x22E6, 0x2306, 0x2306, 0x2326, 0x2327, 0x2B27, 0x2B27, 0x2B48, 0x3348, 0x3389, 0x43AA, 0x43CB, 0x53EC,
  0x860F, 0x7E2F, 0x7E0F, 0x75EE, 0x75CE, 0x6DCD, 0x6DED, 0x6E0E, 0x6E0E, 0x6DEE, 0x6DEF, 0x75CF, 0x7DF0, 0x7DF0, 0x7DF0, 0x7DF0, 0x7DCF, 0x75CF, 0x75CE, 0x75AE, 0x758E, 0x758F, 0x754F, 0x750F, 0x750F, 0x7D2E, 0x856F, 0x8D90, 0x8531, 0x7CB0, 0x748F, 
        0x6C8D, 0x64AD, 0x5CAC, 0x5CAC, 0x5CAC, 0x5CAC, 0x5CCC, 0x5CCC, 0x5CCC, 0x5CEC, 0x6D2D, 0x752E, 0x7D6F, 0x8DD1, 0x9612, 0x9E13, 0x9DF2, 0x9DD2, 0xA5D2, 0xADD2, 0xB5D2, 0xB5F2, 0xBDF3, 0xAD31, 0x9CB0, 0x9490, 0x840E, 0x6BAC, 0x63EC, 0x5C0A, 
        0x5409, 0x5408, 0x5408, 0x5428, 0x5C29, 0x5C49, 0x5C29, 0x5C29, 0x646B, 0x646B, 0x648C, 0x6CCE, 0x6CCF, 0x6CAF, 0x646E, 0x5C0D, 0x5C0D, 0x5C4E, 0x6490, 0x6CD0, 0x74B1, 0x7491, 0x7450, 0x7430, 0x7410, 0x7410, 0x742F, 0x744E, 0x746D, 0x7C6D, 
        0x7C6D, 0x744D, 0x6BEC, 0x5B8A, 0x5369, 0x4347, 0x4347, 0x4347, 0x3B47, 0x3326, 0x3326, 0x3306, 0x2B06, 0x2AE6, 0x2AE5, 0x2AE5, 0x2B05, 0x2B05, 0x2B05, 0x2B05, 0x3B46, 0x43A7, 0x3345, 0x3345, 0x2B45, 0x3365, 0x3385, 0x3385, 0x3B66, 0x4347, 
        0x5368, 0x6BA9, 0x8C2C, 0x948D, 0x9CAD, 0x9CAD, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x948C, 0x948C, 0x948B, 0x948B, 0x948B, 0x948B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 0x8C6B, 
        0x8C6B, 0x8C6B, 0x8C8B, 0x8C6B, 0x8C4B, 0x844A, 0x842A, 0x842A, 0x842B, 0x842A, 0x842A, 0x842B, 0x842B, 0x842B, 0x842B, 0x7C2C, 0x6C0C, 0x53CB, 0x4BAB, 0x5BCB, 0x740C, 0x8C8D, 0x9CCE, 0x9CAE, 0x83CA, 0x9CCD, 0xA50E, 0xA4EF, 0x9C92, 0x7B95, 
        0x5234, 0x49B5, 0x49D6, 0x49D6, 0x41D6, 0x41B6, 0x4196, 0x3995, 0x3975, 0x3155, 0x3136, 0x3917, 0x3938, 0x4158, 0x417A, 0x51FC, 0x5A3C, 0x625D, 0x627D, 0x629D, 0x629D, 0x629D, 0x62BD, 0x62BD, 0x629D, 0x629D, 0x6A9E, 0x629E, 0x629D, 0x629D, 
        0x629D, 0x5A9E, 0x5A9E, 0x5A7E, 0x523D, 0x399C, 0x315B, 0x291B, 0x20DB, 0x209A, 0x189A, 0x187A, 0x107A, 0x105B, 0x105B, 0x105A, 0x107A, 0x105B, 0x105B, 0x105B, 0x105B, 0x083B, 0x085B, 0x083A, 0x083A, 0x083A, 0x083A, 0x083A, 0x295D, 0x41DE, 
        0x41FD, 0x4A1D, 0x4A3D, 0x523D, 0x4A3D, 0x4A3D, 0x4A3D, 0x421D, 0x421D, 0x421D, 0x421D, 0x421D, 0x423D, 0x423D, 0x425D, 0x425D, 0x425D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x427D, 0x427D, 0x427D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 
        0x529E, 0x52BD, 0x52BE, 0x52DE, 0x52DE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52DD, 0x52BD, 0x52BD, 0x52BD, 
        0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x527D, 0x527D, 0x529D, 0x529D, 0x52BD, 0x5ADD, 0x5ADE, 0x5ADE, 0x5AFD, 0x5AFE, 0x5ADE, 0x4A3D, 0x41FC, 0x4A7E, 0x52BE, 0x52BD, 0x529E, 
        0x529D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A5D, 0x5A1C, 0x51FB, 0x51FA, 0x5A57, 0x5AF1, 0x5B6D, 0x5BCA, 0x5BE9, 0x5BEA, 0x5BE9, 0x53E9, 0x53E9, 0x53E9, 0x53E9, 0x4BE9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC8, 0x43A8, 0x43A8, 0x43C8, 0x43C9, 0x4BC9, 0x4BC9, 
        0x4BE9, 0x4BE9, 0x53EA, 0x5BEA, 0x5BEB, 0x5BEB, 0x53CB, 0x53CB, 0x53EB, 0x5C2D, 0x5C2C, 0x4C0B, 0x43C9, 0x43C9, 0x43C9, 0x43C9, 0x4BC9, 0x4BC9, 0x53C9, 0x53E9, 0x5C0A, 0x642A, 0x642A, 0x5C2A, 0x5C0A, 0x5409, 0x53E9, 0x53C9, 0x4BC9, 0x4BC9, 
        0x4BEA, 0x53EA, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43C9, 0x43AA, 0x3BAA, 0x3B89, 0x3BAA, 0x3BCA, 0x3BAA, 0x3B89, 0x3B89, 0x3B8A, 0x3BAA, 0x3BAA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BAA, 0x3BAA, 0x3BCA, 
        0x440C, 0x440B, 0x33EA, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x23E9, 0x23CA, 0x2B8A, 0x3B8B, 0x540D, 0x74D0, 0x74AF, 0x6C6E, 0x5C2C, 0x53EA, 0x4BC9, 0x4389, 
        0x4389, 0x4369, 0x3B68, 0x3B48, 0x3B48, 0x3B28, 0x3307, 0x3307, 0x2B07, 0x2B07, 0x2AE7, 0x2AE7, 0x2AE7, 0x2307, 0x2306, 0x2306, 0x2306, 0x2326, 0x2326, 0x2326, 0x2B46, 0x2B47, 0x3347, 0x2B47, 0x3368, 0x3389, 0x3BAA, 0x43CA, 0x53EB,
  0x7DCE, 0x7E0F, 0x760F, 0x760E, 0x75EE, 0x75EE, 0x6DED, 0x6E0E, 0x6E0E, 0x6E0F, 0x6E0F, 0x75EF, 0x75EF, 0x75EF, 0x75EF, 0x75EF, 0x75EF, 0x6DCF, 0x6DCE, 0x6DAE, 0x6D8E, 0x758E, 0x756F, 0x7D50, 0x7D30, 0x7D2F, 0x858F, 0x8D90, 0x8D51, 0x84F0, 0x74AF, 
        0x6CAE, 0x64AD, 0x64AC, 0x5CAC, 0x64AD, 0x64CD, 0x5CCC, 0x5CCC, 0x5CCC, 0x5CCC, 0x6D0D, 0x754E, 0x8590, 0x95D1, 0x9DF2, 0x9DF2, 0x9DD2, 0xA5D2, 0xA5D2, 0xADF2, 0xB5F2, 0xB5D2, 0xB552, 0xA4D0, 0x9C90, 0x946F, 0x8C2F, 0x7C0E, 0x6BED, 0x5C0A, 
        0x5409, 0x5C08, 0x5C08, 0x5428, 0x5C29, 0x5C49, 0x5C49, 0x5C4A, 0x5C4A, 0x5C4A, 0x5C4B, 0x646C, 0x74AE, 0x74CF, 0x6C6E, 0x642E, 0x640E, 0x642E, 0x6C4F, 0x6C6F, 0x6C4F, 0x6C4F, 0x6BEE, 0x6BEF, 0x740F, 0x7C2F, 0x7C4F, 0x7C8E, 0x84AE, 0x84AE, 
        0x848E, 0x740D, 0x6BCC, 0x6BED, 0x63EC, 0x63EB, 0x63EB, 0x5BCB, 0x5BCA, 0x53A9, 0x4B89, 0x4B69, 0x4B48, 0x4328, 0x3B27, 0x3B06, 0x32E6, 0x32E6, 0x32E6, 0x3305, 0x43A7, 0x3B87, 0x3325, 0x2B25, 0x2B45, 0x3385, 0x3385, 0x3385, 0x3B66, 0x3B67, 
        0x4B67, 0x63A9, 0x7BEA, 0x8C2C, 0x946C, 0x948C, 0x94AC, 0x9CAC, 0x9CCC, 0x94CC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x948C, 0x948B, 0x948B, 0x948B, 0x948B, 0x8C6B, 0x8C6B, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C6B, 0x8C8B, 0x8C6B, 0x844B, 0x844A, 0x842A, 0x842A, 0x844B, 0x844B, 0x844B, 0x844B, 0x844B, 0x8C2B, 0x842B, 0x7C2B, 0x742C, 0x63EC, 0x5BCB, 0x53CB, 0x5BAB, 0x6BEC, 0x844D, 0x94AE, 0x842C, 0x7BEA, 0x9CEE, 0xA50E, 0x9CCF, 0x9473, 
        0x7B95, 0x51F3, 0x49D5, 0x49D6, 0x41D6, 0x41D6, 0x41B6, 0x3995, 0x3995, 0x3976, 0x3956, 0x3936, 0x3136, 0x3116, 0x3937, 0x3917, 0x3939, 0x419A, 0x521C, 0x5A5D, 0x5A7D, 0x629D, 0x629D, 0x629D, 0x629D, 0x5A9D, 0x5A9E, 0x5A7E, 0x5A7E, 0x5A9D, 
        0x5A9E, 0x5A9D, 0x5A9D, 0x629D, 0x62BE, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A7E, 0x525E, 0x4A1E, 0x41DD, 0x399C, 0x397C, 0x313C, 0x291B, 0x28FB, 0x20BA, 0x187A, 0x105A, 0x103A, 0x083A, 0x083A, 0x083A, 0x083A, 0x083A, 0x083A, 0x083A, 0x399E, 0x41DD, 
        0x41FD, 0x41FD, 0x4A1D, 0x4A1D, 0x4A1D, 0x49FD, 0x41FD, 0x41FD, 0x41DD, 0x41FD, 0x39FD, 0x39FD, 0x421D, 0x421D, 0x423D, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x425D, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9E, 
        0x529E, 0x52BD, 0x52BE, 0x52BE, 0x52DE, 0x52DE, 0x52FE, 0x52FE, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DE, 0x52BD, 0x4ABD, 0x52BD, 
        0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x527D, 0x527D, 0x529D, 0x52BD, 0x52BD, 0x5ABD, 0x5ABD, 0x5ADD, 0x5AFE, 0x5ADE, 0x4A7D, 0x41FC, 0x4A5D, 0x527E, 0x529E, 0x529E, 0x529E, 
        0x527D, 0x525D, 0x523D, 0x523C, 0x521C, 0x521B, 0x51FA, 0x5238, 0x5A94, 0x5B2F, 0x5BAB, 0x5BC9, 0x5BC9, 0x5BE9, 0x5BE9, 0x53E9, 0x53E9, 0x53E9, 0x53E9, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC8, 0x4BC8, 0x4BE9, 0x4BE9, 0x4C09, 
        0x540A, 0x540A, 0x53EA, 0x53EA, 0x53CA, 0x53CA, 0x538A, 0x538B, 0x5BEC, 0x5C0C, 0x5C2D, 0x5C4C, 0x4C0B, 0x43C9, 0x3BA9, 0x43A9, 0x43A9, 0x4BC9, 0x4BC9, 0x53E9, 0x5C0A, 0x642A, 0x642A, 0x5C2A, 0x5C0A, 0x53E9, 0x53E9, 0x53C9, 0x4BC9, 0x4BC9, 
        0x53EA, 0x5C0A, 0x540A, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43CA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x43CB, 0x3BAA, 0x3B8A, 0x3B8A, 0x3B8A, 0x3B8A, 0x3BAA, 0x3BAA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BAA, 0x3389, 0x33AA, 0x3BCA, 
        0x440C, 0x440B, 0x33CA, 0x33CA, 0x2BC9, 0x2BC9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x2409, 0x2408, 0x2409, 0x2409, 0x23CA, 0x2B8A, 0x3B8B, 0x53ED, 0x646E, 0x640D, 0x5BEC, 0x53CB, 0x4BCA, 0x4BC9, 0x4BA9, 
        0x4389, 0x4388, 0x4368, 0x3B68, 0x3B68, 0x3B48, 0x3348, 0x3348, 0x3347, 0x2B27, 0x2307, 0x2307, 0x2307, 0x2326, 0x2326, 0x2B26, 0x2B26, 0x2346, 0x2346, 0x2B46, 0x2B47, 0x2B46, 0x3346, 0x2B47, 0x3367, 0x3368, 0x3BA9, 0x43CA, 0x4BCA,
  0x758D, 0x7E0E, 0x7E2F, 0x760E, 0x75EE, 0x6DED, 0x6DED, 0x6DED, 0x6E0E, 0x6E0F, 0x6E0F, 0x6DEF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCE, 0x6DAD, 0x6D8E, 0x6D8E, 0x756F, 0x7D50, 0x7D51, 0x7D2F, 0x8D8F, 0x8D90, 0x8D71, 0x8510, 0x74AF, 
        0x6CAD, 0x64AD, 0x64CD, 0x64CD, 0x64CD, 0x64CD, 0x5CCC, 0x5CAC, 0x5CAC, 0x5CCC, 0x650D, 0x754F, 0x8DD1, 0x9E12, 0x9E13, 0x9DD2, 0x9DD1, 0xA5D1, 0xADD2, 0xB5F2, 0xC654, 0xBDD2, 0xAD10, 0xA4D0, 0x9C90, 0x944F, 0x8C2F, 0x7C2E, 0x6BEC, 0x5C09, 
        0x5C09, 0x5C28, 0x5C28, 0x5C28, 0x5C28, 0x5C48, 0x6449, 0x644A, 0x644A, 0x644A, 0x642A, 0x644B, 0x746D, 0x746E, 0x746E, 0x6C0E, 0x6C0D, 0x6C0E, 0x744E, 0x744E, 0x744E, 0x746F, 0x7C6F, 0x7C6F, 0x7C90, 0x7C8F, 0x848F, 0x84AF, 0x84CF, 0x8CEF, 
        0x8CCF, 0x7C6E, 0x7C4E, 0x848F, 0x7C4E, 0x744E, 0x744E, 0x744D, 0x744D, 0x744D, 0x6C4D, 0x6C4D, 0x6C4D, 0x6C4D, 0x6C4D, 0x6C0C, 0x63EB, 0x5BEB, 0x5BEB, 0x4B88, 0x4387, 0x3346, 0x3325, 0x2B25, 0x2B45, 0x2B85, 0x3385, 0x3385, 0x3B86, 0x3B86, 
        0x4B87, 0x5387, 0x6388, 0x73A9, 0x840B, 0x8C6C, 0x946C, 0x948C, 0x94AC, 0x94AC, 0x94CC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x94AC, 0x948C, 0x948C, 0x948B, 0x948B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C8B, 0x8C6B, 0x844B, 0x844A, 0x844A, 0x842A, 0x842A, 0x842A, 0x844A, 0x844A, 0x844A, 0x844A, 0x8C4B, 0x8C4B, 0x844B, 0x7C2C, 0x6C0C, 0x640C, 0x5BCB, 0x53AB, 0x5BAB, 0x6BCC, 0x742D, 0x848E, 0x73EB, 0x8C8C, 0x9CEE, 0xA50F, 0xA4F1, 
        0x9C94, 0x7B75, 0x5214, 0x49D5, 0x41D6, 0x41D6, 0x41B6, 0x41B6, 0x3996, 0x3996, 0x3175, 0x3155, 0x3155, 0x3135, 0x3956, 0x3957, 0x3937, 0x3938, 0x4159, 0x49DB, 0x523C, 0x627E, 0x5A9E, 0x5A9E, 0x527E, 0x525D, 0x525D, 0x525D, 0x527D, 0x527D, 
        0x5A7D, 0x5A7D, 0x5A9D, 0x629D, 0x62BD, 0x62BD, 0x62DD, 0x62DD, 0x62DE, 0x62DD, 0x62DD, 0x62BD, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ABE, 0x5A9E, 0x527E, 0x523D, 0x41DD, 0x395C, 0x28FB, 0x20BB, 0x189A, 0x185A, 0x1039, 0x0819, 0x189B, 0x39BE, 0x41DD, 
        0x39DD, 0x41DD, 0x41FD, 0x41FD, 0x41DD, 0x41DD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x39DD, 0x39DD, 0x39DD, 0x39FD, 0x39FD, 0x3A1D, 0x423D, 0x423D, 0x425D, 0x425D, 0x425E, 0x427E, 0x427D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x4A9D, 
        0x529D, 0x4A9D, 0x52BD, 0x52BD, 0x52BD, 0x52DE, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52DE, 0x52BD, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x527D, 0x529D, 0x529E, 0x52BE, 0x52BD, 0x5ABD, 0x5ABD, 0x62FE, 0x631E, 0x52BD, 0x39DB, 0x41FC, 0x4A5D, 0x527E, 0x527D, 0x527D, 0x527D, 
        0x525D, 0x523D, 0x523C, 0x521B, 0x521A, 0x5219, 0x5237, 0x5274, 0x5AF1, 0x5B8D, 0x63CB, 0x63EA, 0x5BEA, 0x5BE9, 0x5BE9, 0x5BE9, 0x53E9, 0x53E9, 0x53E9, 0x53E9, 0x53E9, 0x53C9, 0x53C9, 0x4BC9, 0x4BE9, 0x53E9, 0x4BE9, 0x4BE9, 0x4C09, 0x4BE9, 
        0x4BE9, 0x4BE9, 0x53C9, 0x4BC9, 0x4BA9, 0x4BA9, 0x4BAA, 0x53AA, 0x53CB, 0x5BEB, 0x5C0C, 0x542B, 0x542B, 0x4C0A, 0x4BEA, 0x43A9, 0x43A9, 0x43A9, 0x4BC9, 0x53EA, 0x5C2B, 0x642B, 0x644B, 0x644A, 0x5C2A, 0x5BE9, 0x53E9, 0x53C9, 0x53C9, 0x53C9, 
        0x53EA, 0x5C0A, 0x540A, 0x540A, 0x53EA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x43CB, 0x3BAA, 0x3BAA, 0x3BAA, 0x3BAA, 0x3B8A, 0x3B8A, 0x3BAA, 0x3BCA, 0x43EA, 0x3BCA, 0x3BAA, 0x3BAA, 0x3389, 0x338A, 0x3BCA, 
        0x440B, 0x442B, 0x33EA, 0x33C9, 0x2BC9, 0x2BC9, 0x2BC9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C08, 0x1C08, 0x2409, 0x2409, 0x23C9, 0x2BAA, 0x338B, 0x4BAC, 0x5C0D, 0x5BCC, 0x5BEC, 0x5BEC, 0x4BCA, 0x4BC9, 0x4BA9, 
        0x43A9, 0x4388, 0x4388, 0x4388, 0x3B88, 0x3B88, 0x3B68, 0x3368, 0x3367, 0x2B47, 0x2B27, 0x2B27, 0x2B27, 0x2326, 0x2326, 0x2B26, 0x2B26, 0x2346, 0x2346, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B47, 0x3367, 0x3368, 0x3B89, 0x43A9, 0x43CA,
  0x6D6C, 0x7DEE, 0x7E0E, 0x760E, 0x75EE, 0x6DCD, 0x6DCD, 0x65ED, 0x660E, 0x6E0F, 0x6DEF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCF, 0x6DCE, 0x65CE, 0x65AD, 0x658D, 0x6D6E, 0x756E, 0x7D50, 0x7D30, 0x7D0F, 0x858F, 0x8DB0, 0x8D91, 0x8511, 0x74AE, 
        0x74AD, 0x6CCD, 0x64CD, 0x64CD, 0x64CC, 0x64CC, 0x5CAC, 0x5CAC, 0x5CAC, 0x5CAC, 0x650D, 0x7D8F, 0x9612, 0x9E33, 0x9E33, 0x9DD2, 0x9DB1, 0xA5B1, 0xADD1, 0xB612, 0xCE95, 0xCE75, 0xB551, 0xAD11, 0xA4D1, 0x9C90, 0x9470, 0x7C0E, 0x6BEC, 0x6409, 
        0x5C09, 0x5C28, 0x5C28, 0x5C29, 0x5C29, 0x6449, 0x6449, 0x644A, 0x6C4A, 0x644A, 0x6C4B, 0x7C8D, 0x7CAE, 0x7C8E, 0x7C8E, 0x7C6E, 0x7C4E, 0x7C6E, 0x7C8F, 0x7C8E, 0x7CAF, 0x7CAF, 0x7CAF, 0x84CF, 0x84CF, 0x84CF, 0x84CF, 0x84EF, 0x84EF, 0x8D0F, 
        0x8D0F, 0x8CF0, 0x84D0, 0x84AF, 0x848F, 0x848F, 0x848F, 0x7C8E, 0x848E, 0x7CAE, 0x7C8E, 0x7C6E, 0x7C6E, 0x7C6E, 0x7C6E, 0x744E, 0x742E, 0x6C0D, 0x5BAB, 0x4B48, 0x3B66, 0x3325, 0x3325, 0x2B25, 0x2B45, 0x2B85, 0x3385, 0x3385, 0x3BA6, 0x43A6, 
        0x4387, 0x4366, 0x4B47, 0x5B47, 0x6BA9, 0x840A, 0x844B, 0x8C6B, 0x8C6C, 0x948C, 0x94AC, 0x9CAC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x846B, 0x846B, 0x844B, 0x844B, 0x844B, 0x844A, 0x844A, 0x844A, 0x8C4B, 0x8C4B, 0x8C4B, 0x844B, 0x7C2B, 0x740C, 0x6C0C, 0x640C, 0x640C, 0x5BCB, 0x5BAB, 0x5BEC, 0x640C, 0x63EB, 0x742B, 0x94EE, 0xA52F, 0xA52F, 
        0xA4F1, 0x9C94, 0x7B75, 0x5213, 0x49F5, 0x49D6, 0x41D6, 0x41D6, 0x39B5, 0x3996, 0x3975, 0x3175, 0x3975, 0x3175, 0x3135, 0x3956, 0x3957, 0x3937, 0x3938, 0x3959, 0x417A, 0x51FC, 0x523C, 0x4A3D, 0x4A3D, 0x4A1D, 0x423D, 0x4A3D, 0x4A5D, 0x525D, 
        0x525D, 0x527D, 0x527E, 0x5A7D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5A9D, 0x5ABD, 0x62BD, 0x62BD, 0x5ABD, 0x5ABD, 0x5ABD, 0x62DD, 0x62DD, 0x5ABD, 0x5ABD, 0x62DD, 0x62DD, 0x5ABE, 0x5A9E, 0x527E, 0x527E, 0x525E, 0x49FD, 0x397C, 0x397C, 0x41DD, 0x41BD, 
        0x41BD, 0x41BD, 0x49FD, 0x41FD, 0x41BD, 0x39BD, 0x399D, 0x399D, 0x399D, 0x31BD, 0x31BD, 0x39BD, 0x39BD, 0x39BD, 0x39BD, 0x31DD, 0x39DD, 0x39FD, 0x421E, 0x3A3D, 0x423D, 0x423D, 0x425E, 0x425D, 0x425D, 0x425D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 
        0x4A9D, 0x4A9D, 0x4ABD, 0x52BD, 0x52BD, 0x52DE, 0x52FE, 0x52FE, 0x52FD, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52DD, 0x52BD, 0x52BD, 0x4A9D, 
        0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BE, 0x52BE, 0x529D, 0x529D, 0x527D, 0x529D, 0x529E, 0x52BE, 0x52BD, 0x5ABD, 0x5ADD, 0x631E, 0x633E, 0x423B, 0x39DC, 0x4A3D, 0x4A5D, 0x4A5D, 0x4A5D, 0x525D, 0x4A5C, 
        0x523C, 0x4A3B, 0x4A1A, 0x4A1A, 0x5238, 0x5236, 0x5274, 0x5AF1, 0x5B6E, 0x63CB, 0x63EB, 0x63EA, 0x5BEA, 0x5BEA, 0x5BE9, 0x5BE9, 0x5C09, 0x5409, 0x5409, 0x5C09, 0x5BE9, 0x53E9, 0x53E9, 0x53E9, 0x540A, 0x5409, 0x5409, 0x4BE9, 0x4BE9, 0x53E9, 
        0x53E9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BAA, 0x53EA, 0x53EA, 0x53EB, 0x53EA, 0x53EA, 0x4BEA, 0x4BEA, 0x540B, 0x4BEA, 0x4BA9, 0x4BCA, 0x5BEA, 0x5C2B, 0x644B, 0x644B, 0x642A, 0x642A, 0x5BE9, 0x5BE9, 0x5BEA, 0x5BEA, 0x5BEA, 
        0x53EA, 0x5C0A, 0x5C2B, 0x540A, 0x53EA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x3BAA, 0x3BAA, 0x43AA, 0x43AA, 0x43AA, 0x3BAA, 0x3BAA, 0x3BCA, 0x43EB, 0x43CA, 0x3BAA, 0x3BAA, 0x3389, 0x3389, 0x3BCA, 
        0x440B, 0x442B, 0x3C0A, 0x33C9, 0x2BC9, 0x2BC9, 0x2BC9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C08, 0x1C08, 0x2409, 0x2409, 0x23C9, 0x2BCA, 0x338B, 0x438B, 0x5BED, 0x53CC, 0x4B8B, 0x5BEC, 0x53CA, 0x4BCA, 0x4BCA, 
        0x4BC9, 0x43A9, 0x4388, 0x4388, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 0x3367, 0x3367, 0x2B47, 0x2B47, 0x2B47, 0x2346, 0x2346, 0x2B46, 0x2B46, 0x2346, 0x2346, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B47, 0x3347, 0x3367, 0x3388, 0x3BA9, 0x43C9,
  0x652B, 0x75AD, 0x75EE, 0x75EE, 0x75EE, 0x6DCD, 0x6DCD, 0x65CD, 0x65CD, 0x65CE, 0x65AE, 0x65AE, 0x6DCF, 0x7E31, 0x7E31, 0x7610, 0x6DEF, 0x6DCE, 0x65CE, 0x65AD, 0x656D, 0x656D, 0x6D4E, 0x752F, 0x7D2F, 0x7D2F, 0x8D8F, 0x9DF1, 0x95B2, 0x8511, 0x748E, 
        0x74AD, 0x6CCD, 0x64CD, 0x5CCC, 0x5CCC, 0x5CAC, 0x5CAC, 0x54AC, 0x5CAC, 0x5CAC, 0x6CED, 0x8DD1, 0xA673, 0x9E33, 0x9E12, 0x9590, 0x9D70, 0xA591, 0xADD1, 0xB5D2, 0xBE13, 0xBDF3, 0xB592, 0xB572, 0xAD72, 0x9D11, 0x8C6F, 0x73ED, 0x6BEB, 0x6409, 
        0x5C29, 0x5C28, 0x5C49, 0x6429, 0x6429, 0x6429, 0x642A, 0x6C4A, 0x6C6B, 0x746B, 0x748C, 0x7CCD, 0x84CE, 0x84CF, 0x84CF, 0x84CF, 0x84CF, 0x84CF, 0x84AF, 0x84CF, 0x84EF, 0x84EF, 0x84EF, 0x84EF, 0x84EF, 0x84EF, 0x84EF, 0x850E, 0x850E, 0x850E, 
        0x8D0F, 0x8D10, 0x8CF0, 0x84D0, 0x84CF, 0x84CF, 0x84CF, 0x84CF, 0x84EF, 0x84EF, 0x84EF, 0x84CF, 0x84CF, 0x84AF, 0x848F, 0x7C2E, 0x740E, 0x5B4B, 0x4AE9, 0x4B08, 0x4326, 0x3B25, 0x3325, 0x3345, 0x3365, 0x3365, 0x3386, 0x3B86, 0x3B86, 0x43A6, 
        0x4386, 0x4346, 0x4346, 0x4B27, 0x5347, 0x6BA9, 0x7BEA, 0x842B, 0x8C4B, 0x8C6B, 0x946C, 0x948C, 0x94AC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C8B, 0x8C8B, 0x8C8B, 0x846B, 0x8C6B, 0x844B, 0x844A, 0x844A, 0x844A, 0x8C4B, 0x8C4B, 0x844B, 0x7C2B, 0x740B, 0x6BEB, 0x6C2C, 0x6C4D, 0x6C4E, 0x5BEC, 0x53CC, 0x53EC, 0x53EB, 0x63EB, 0x7C6C, 0x9CEE, 0xA50F, 
        0xA50F, 0xA4F1, 0x9473, 0x7355, 0x5214, 0x49D5, 0x49D5, 0x49D6, 0x41B5, 0x3996, 0x3995, 0x3975, 0x3175, 0x3995, 0x3155, 0x3155, 0x3976, 0x3936, 0x3957, 0x3938, 0x3939, 0x3939, 0x3959, 0x317A, 0x397B, 0x399C, 0x39BC, 0x39DC, 0x421D, 0x4A3D, 
        0x525D, 0x525D, 0x525E, 0x525D, 0x525E, 0x525D, 0x525D, 0x5A5D, 0x5A7D, 0x5A9D, 0x5A9D, 0x5A9D, 0x629D, 0x629D, 0x62BE, 0x62BD, 0x62BD, 0x62DD, 0x62DD, 0x62DD, 0x62DD, 0x62DE, 0x5ABD, 0x62BE, 0x62BE, 0x62DE, 0x62BE, 0x5A9E, 0x5A7E, 0x525E, 
        0x525E, 0x523D, 0x523E, 0x4A1D, 0x49FD, 0x41BD, 0x419D, 0x397D, 0x317D, 0x317D, 0x317D, 0x317D, 0x317D, 0x319D, 0x319D, 0x319D, 0x31BD, 0x31DD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A1D, 0x423D, 0x425D, 0x425D, 0x425D, 0x427D, 0x425D, 0x4A7D, 0x4A7D, 
        0x4A9D, 0x4A9E, 0x4A9E, 0x4ABD, 0x52BE, 0x52DE, 0x52DE, 0x52FE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52DD, 0x52BD, 0x52BD, 
        0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BE, 0x529E, 0x529E, 0x527D, 0x527E, 0x529E, 0x529D, 0x52BD, 0x5ABD, 0x5ABD, 0x62DE, 0x529D, 0x39DB, 0x421C, 0x4A5D, 0x4A5D, 0x4A5C, 0x4A5C, 0x4A3C, 0x4A3C, 
        0x4A3B, 0x49FA, 0x4A19, 0x4A37, 0x5256, 0x5AB4, 0x5AF1, 0x5B4F, 0x63AC, 0x63EB, 0x63EA, 0x63EA, 0x640A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C09, 0x5C09, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5BEA, 0x5BE9, 0x53E9, 0x4BC9, 0x4BC9, 0x53C9, 
        0x53E9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BCA, 0x53EA, 0x53EB, 0x53EA, 0x53EA, 0x53EB, 0x5C0B, 0x5C0B, 0x642B, 0x642B, 0x642B, 0x642A, 0x5BEA, 0x5BEA, 0x5BCA, 0x5BCA, 0x5BEA, 
        0x5BEA, 0x642B, 0x642B, 0x5C0A, 0x53EA, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BCA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x3BAA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 0x3B89, 0x3389, 0x3389, 0x3BAA, 
        0x440B, 0x444B, 0x3C0A, 0x33C9, 0x2BE9, 0x2BC9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x2429, 0x2409, 0x23E9, 0x2BCA, 0x2BAA, 0x3B6B, 0x53AC, 0x53AC, 0x538C, 0x5BEC, 0x53EA, 0x4BEA, 0x4BCA, 
        0x4BC9, 0x4BC9, 0x43A9, 0x43A9, 0x43A8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B88, 0x3367, 0x3367, 0x3367, 0x3367, 0x2B47, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B26, 0x2B47, 0x3347, 0x3347, 0x3368, 0x3B88, 0x3BA9,
  0x650B, 0x6D6C, 0x6D8C, 0x6DAD, 0x6DCD, 0x6DCD, 0x65CD, 0x65AD, 0x5DAD, 0x5DAD, 0x658E, 0x658E, 0x75CF, 0x8ED3, 0x9F35, 0x8EB3, 0x7630, 0x6DEE, 0x65CD, 0x65AD, 0x656C, 0x656D, 0x6D4D, 0x752E, 0x7D2E, 0x7D2E, 0x95AF, 0xA611, 0x9DF3, 0x9572, 0x7CCF, 
        0x74CE, 0x74CE, 0x6CCD, 0x64CD, 0x5CCC, 0x5CCC, 0x5CAC, 0x5CCC, 0x5CCC, 0x64CC, 0x750E, 0x9E32, 0xA673, 0xA633, 0x9DD1, 0x8D2F, 0x9570, 0xA590, 0xADB1, 0xB5D1, 0xB5F2, 0xB5F2, 0xB5D3, 0xADB2, 0xA572, 0x8CAF, 0x740C, 0x6BEB, 0x640A, 0x6429, 
        0x5C29, 0x6449, 0x6449, 0x6C4B, 0x6C4B, 0x6C2B, 0x744B, 0x746C, 0x7C8C, 0x7CAD, 0x84CD, 0x84EE, 0x8D0F, 0x8D0F, 0x8D0F, 0x8D10, 0x8D0F, 0x850F, 0x84EF, 0x850F, 0x850F, 0x850F, 0x850F, 0x7D0E, 0x7D0E, 0x7D0E, 0x7D0E, 0x7D0E, 0x7D2E, 0x852E, 
        0x852E, 0x852F, 0x850F, 0x84EF, 0x84EF, 0x84EE, 0x84EE, 0x850E, 0x850E, 0x850E, 0x850E, 0x850F, 0x84EF, 0x84CF, 0x84AF, 0x7C4F, 0x6B8C, 0x6B8C, 0x6BAC, 0x638B, 0x5369, 0x4B68, 0x4347, 0x3B46, 0x3B46, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B86, 
        0x3B66, 0x3B45, 0x3B46, 0x3B26, 0x4326, 0x5347, 0x6389, 0x7BEA, 0x842B, 0x842B, 0x8C4B, 0x8C4C, 0x948C, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x94AC, 0x94AC, 0x94AC, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C6B, 0x846B, 0x846B, 0x846B, 0x848B, 0x8C8C, 0x8C8C, 0x8C6C, 0x8C6B, 0x844B, 0x844B, 0x842A, 0x842A, 0x844A, 0x844B, 0x844A, 0x7C2A, 0x740A, 0x6BEA, 0x6C0B, 0x742C, 0x7C8F, 0x748F, 0x5C0C, 0x53CC, 0x53CB, 0x53CB, 0x63CB, 0x844D, 0x9CEF, 
        0xA50F, 0xA510, 0xA4D0, 0x9455, 0x6B14, 0x49F4, 0x49D5, 0x49D5, 0x41B5, 0x3996, 0x3995, 0x3995, 0x3154, 0x3154, 0x3154, 0x3154, 0x3155, 0x3976, 0x3957, 0x4157, 0x3958, 0x3958, 0x3958, 0x3959, 0x315A, 0x315A, 0x315A, 0x317A, 0x319A, 0x39BC, 
        0x39BC, 0x39BC, 0x39BC, 0x39BC, 0x41FD, 0x4A1D, 0x4A3D, 0x4A3D, 0x523D, 0x525D, 0x5A7D, 0x5A7D, 0x5A7D, 0x5A9E, 0x5A9E, 0x5A9D, 0x62BD, 0x62BD, 0x62BE, 0x62BD, 0x62BD, 0x62BD, 0x5ABD, 0x62BD, 0x5ABD, 0x62DD, 0x62DD, 0x62DE, 0x5ABD, 0x5ABD, 
        0x5ABD, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A7E, 0x525E, 0x523E, 0x49FD, 0x39BD, 0x397D, 0x317C, 0x315D, 0x315D, 0x315D, 0x315D, 0x297D, 0x317D, 0x319D, 0x31BD, 0x31DD, 0x39FD, 0x39FD, 0x3A1D, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x427D, 0x4A7E, 
        0x4A9E, 0x4A9E, 0x4A9E, 0x4ABD, 0x4ABE, 0x52DE, 0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52DD, 0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x52DE, 0x52DE, 0x52BD, 
        0x52BD, 0x52BE, 0x52BE, 0x52DE, 0x52DE, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BE, 0x529E, 0x529E, 0x529D, 0x529E, 0x529D, 0x529D, 0x52BD, 0x5ABD, 0x5ADE, 0x527D, 0x41FB, 0x41DB, 0x4A3D, 0x4A5D, 0x527D, 0x527D, 0x4A5B, 0x4A3B, 0x4A3A, 
        0x4238, 0x4217, 0x4A55, 0x5294, 0x5AF2, 0x5B4F, 0x5B6E, 0x63AC, 0x63EB, 0x640A, 0x640A, 0x640A, 0x640A, 0x640B, 0x642B, 0x642A, 0x5C2A, 0x640A, 0x640A, 0x640A, 0x640A, 0x5C0A, 0x5C09, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BE9, 0x53E9, 0x53E9, 0x53C9, 
        0x53C9, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BA9, 0x4BA9, 0x53AA, 0x53CA, 0x53CA, 0x5BCB, 0x5BEB, 0x5BEB, 0x5BEB, 0x5C0B, 0x5C0B, 0x640B, 0x640B, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BCA, 0x5BCA, 
        0x5BEA, 0x644C, 0x644B, 0x5C0A, 0x53EA, 0x53EA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43CA, 0x43AA, 0x43CA, 0x4BCA, 0x43CA, 0x43CA, 0x4BCA, 0x4BCA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BA9, 0x3BA9, 0x33A9, 0x3389, 0x3BA9, 
        0x440B, 0x4C6C, 0x440B, 0x33C9, 0x2BC9, 0x2BC9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x1C28, 0x1C08, 0x23E9, 0x23EA, 0x2BAA, 0x3B6A, 0x436B, 0x4B8C, 0x53CD, 0x644E, 0x540A, 0x53EA, 0x4BEA, 
        0x4BC9, 0x4BC9, 0x43C9, 0x43A9, 0x43A9, 0x43C8, 0x43A8, 0x3BA8, 0x3BA8, 0x3387, 0x3387, 0x3387, 0x3367, 0x2B47, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B26, 0x2B47, 0x3347, 0x3347, 0x3B68, 0x3B88,
  0x650B, 0x654C, 0x658C, 0x65AC, 0x6DAD, 0x6DCD, 0x65AD, 0x65AD, 0x65AD, 0x5D8D, 0x658D, 0x658E, 0x6DCF, 0x8651, 0x86B2, 0x7E71, 0x7610, 0x65EE, 0x65CD, 0x5DAD, 0x656C, 0x656C, 0x6D4D, 0x752E, 0x7D0E, 0x7D0E, 0x8D8F, 0x95D0, 0x95B1, 0x9D92, 0x84EF, 
        0x7CEE, 0x74ED, 0x6CCD, 0x64CD, 0x5CCC, 0x5CCC, 0x5CEC, 0x650C, 0x650D, 0x6D0D, 0x8DF1, 0xAEB4, 0xAEB4, 0xAE73, 0x9DF2, 0x9D90, 0x9D91, 0xA5B1, 0xA5B1, 0xADB1, 0xADD1, 0xA5B1, 0x9D91, 0x8CEF, 0x7C6D, 0x6C0C, 0x6BEB, 0x640A, 0x642A, 0x6429, 
        0x6429, 0x6C4A, 0x6C4A, 0x7C8C, 0x7C6C, 0x746C, 0x7C8D, 0x7CCD, 0x7CCD, 0x84EE, 0x8D0F, 0x8D4F, 0x8D2F, 0x8D4F, 0x8D2F, 0x8D4F, 0x8D4F, 0x852F, 0x852F, 0x7D2E, 0x7D2E, 0x852E, 0x852E, 0x7D0E, 0x7D0E, 0x7D0E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2E, 
        0x854E, 0x854E, 0x852E, 0x7D0E, 0x7D0E, 0x850E, 0x850E, 0x7D2E, 0x7D0E, 0x852E, 0x852E, 0x852E, 0x852F, 0x8D0F, 0x8CEF, 0x84B0, 0x844F, 0x7C4F, 0x7C2F, 0x742E, 0x742D, 0x6C2C, 0x63EB, 0x5BCA, 0x53A9, 0x53A8, 0x4B88, 0x4367, 0x4367, 0x3B66, 
        0x3B46, 0x3345, 0x3346, 0x3B46, 0x4346, 0x4B47, 0x5347, 0x5B68, 0x63A9, 0x6BCA, 0x7C0B, 0x842B, 0x8C4B, 0x948C, 0x948C, 0x9C8C, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x948C, 0x948C, 0x948C, 0x948C, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C6B, 0x846B, 0x846B, 0x846B, 0x846B, 0x8C6C, 0x8C6C, 0x846B, 0x846B, 0x844B, 0x844B, 0x844B, 0x844B, 0x844A, 0x844A, 0x844A, 0x7C2A, 0x73EA, 0x6BCA, 0x6C0B, 0x740B, 0x740C, 0x746E, 0x6C6E, 0x5C0C, 0x4BAB, 0x4B8B, 0x538A, 0x63AB, 0x7C2C, 
        0x94AE, 0x9CCF, 0x9CCF, 0x9CB2, 0x9435, 0x62B4, 0x51F4, 0x49D5, 0x41B5, 0x3995, 0x41B5, 0x3995, 0x3975, 0x3154, 0x3154, 0x3154, 0x3154, 0x3155, 0x3976, 0x3956, 0x3957, 0x3957, 0x3957, 0x3978, 0x3979, 0x3159, 0x317A, 0x317A, 0x317A, 0x315A, 
        0x315A, 0x315A, 0x315A, 0x315A, 0x315A, 0x315B, 0x39BC, 0x421D, 0x4A3E, 0x4A5E, 0x525D, 0x525D, 0x525D, 0x525D, 0x527D, 0x5A9D, 0x5A9D, 0x62BD, 0x62BD, 0x62BD, 0x62BE, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BD, 
        0x62BD, 0x62BD, 0x62BE, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A7E, 0x525E, 0x4A3E, 0x41DD, 0x39BD, 0x317D, 0x317D, 0x315D, 0x293D, 0x295D, 0x317D, 0x317D, 0x319D, 0x31BD, 0x31DD, 0x39FD, 0x423D, 0x423D, 0x423D, 0x423D, 0x425D, 0x425D, 0x427D, 
        0x427E, 0x4A9D, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABD, 0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x52DE, 0x52DE, 0x52BD, 
        0x4A9D, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BE, 0x529E, 0x529E, 0x529E, 0x529D, 0x529D, 0x529D, 0x52BD, 0x5ABD, 0x527D, 0x39BA, 0x41FB, 0x4A5D, 0x4A7D, 0x529D, 0x529C, 0x4A7B, 0x4A5A, 0x4239, 0x4237, 
        0x4235, 0x4A73, 0x4AB2, 0x5310, 0x5B4E, 0x5B8D, 0x5B8D, 0x63CC, 0x63EB, 0x640A, 0x640B, 0x642A, 0x642A, 0x642B, 0x642B, 0x642B, 0x642A, 0x640A, 0x640A, 0x640A, 0x640A, 0x5BE9, 0x5BE9, 0x5BE9, 0x5C09, 0x5BE9, 0x5BE9, 0x53E9, 0x53E9, 0x53E9, 
        0x53C9, 0x53C9, 0x53C9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC9, 0x53E9, 0x53E9, 0x53C9, 0x53C9, 0x53A9, 0x53C9, 0x53A9, 0x53AA, 0x53AA, 0x5BCA, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BEB, 0x5BEB, 0x5BEB, 0x5BEA, 0x5BCA, 0x5BCA, 0x53CA, 
        0x53C9, 0x5C0B, 0x5BEB, 0x53EA, 0x53CA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BAA, 0x43AA, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BAA, 0x43AA, 0x43AA, 0x43CA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BA9, 0x3BA9, 0x33A9, 0x3389, 0x3BA9, 
        0x43EA, 0x4C4B, 0x442B, 0x33C9, 0x2BA9, 0x2BC9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x1BE9, 0x1BE8, 0x1C09, 0x1C28, 0x1C08, 0x2409, 0x23E9, 0x23CA, 0x33AA, 0x3BAB, 0x43AB, 0x4BED, 0x648E, 0x540B, 0x53E9, 0x4BEA, 
        0x4BE9, 0x4BC9, 0x4BC9, 0x4BC9, 0x4BC8, 0x43C8, 0x43C8, 0x43C8, 0x3BA8, 0x3BA8, 0x3387, 0x3387, 0x3367, 0x3346, 0x2B46, 0x2B46, 0x2B26, 0x2B26, 0x2B26, 0x2B06, 0x2B06, 0x2B06, 0x2B06, 0x2B26, 0x2B26, 0x3326, 0x3347, 0x3347, 0x3B68,
  0x5CEB, 0x654C, 0x658C, 0x65AC, 0x65AD, 0x65AD, 0x65AD, 0x65AD, 0x658D, 0x658D, 0x658D, 0x6D8E, 0x6DAE, 0x6DCF, 0x6E0F, 0x6E0F, 0x6DEF, 0x65CE, 0x5DCD, 0x5D8D, 0x5D6C, 0x654C, 0x6D4C, 0x750D, 0x750D, 0x7D0D, 0x8D8F, 0x8D8F, 0x8D50, 0x84F0, 0x7CCF, 
        0x7CCE, 0x74CE, 0x6CAD, 0x64CC, 0x5CCC, 0x5CCC, 0x64ED, 0x6D2D, 0x6D4E, 0x7D6E, 0x95F1, 0xAE94, 0xB6B4, 0xAE74, 0xAE33, 0xA5F2, 0xA5F2, 0xA5B1, 0xA570, 0x9D70, 0x952F, 0x8D0F, 0x7CCE, 0x746D, 0x640C, 0x6C0B, 0x6C0A, 0x640A, 0x6429, 0x6C29, 
        0x6C4A, 0x746B, 0x748C, 0x7CAD, 0x84AE, 0x84AE, 0x84CE, 0x84CE, 0x84EE, 0x850E, 0x8D4F, 0x8D6F, 0x854E, 0x854E, 0x854F, 0x854F, 0x854F, 0x854F, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D4E, 0x7D4E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D4E, 
        0x7D4E, 0x854E, 0x852E, 0x7D2E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x852D, 0x854E, 0x854E, 0x852F, 0x852F, 0x8D2F, 0x8D10, 0x84D0, 0x84B0, 0x8490, 0x7C6F, 0x7C6F, 0x7C6E, 0x746E, 0x744E, 0x744D, 0x744D, 0x6C4D, 0x6C4C, 0x644C, 0x644B, 
        0x4B88, 0x3B46, 0x3B46, 0x3B66, 0x4346, 0x4346, 0x4B47, 0x5347, 0x5347, 0x5B68, 0x6BAA, 0x740B, 0x842B, 0x8C4B, 0x8C6C, 0x948B, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x948C, 0x948C, 0x948C, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C8B, 0x848B, 0x846B, 0x846B, 0x846B, 0x846B, 0x846B, 0x844B, 0x844B, 0x844B, 0x844B, 0x844B, 0x844A, 0x842A, 0x7C2A, 0x7C0A, 0x73EA, 0x6BCA, 0x6C0A, 0x740B, 0x6BAB, 0x5329, 0x5B8B, 0x5BEC, 0x4BAC, 0x438B, 0x436A, 0x4B2A, 0x5329, 
        0x73CC, 0x7C0D, 0x946E, 0x9CD0, 0x9CB3, 0x8C15, 0x62B4, 0x51F4, 0x41B5, 0x4195, 0x41B5, 0x4195, 0x3995, 0x3975, 0x3154, 0x3154, 0x3154, 0x3133, 0x3975, 0x3115, 0x3115, 0x3936, 0x3936, 0x3957, 0x3978, 0x3998, 0x3179, 0x3179, 0x317A, 0x3179, 
        0x317A, 0x317A, 0x317A, 0x3179, 0x315A, 0x2959, 0x295A, 0x39BC, 0x39FC, 0x421D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x4A3D, 0x525D, 0x5A7D, 0x5A9E, 0x62BE, 0x62BE, 0x62BE, 0x5ABD, 0x5ABD, 0x5A9D, 0x5ABD, 0x62BD, 0x62BD, 0x62BE, 0x62BE, 0x62BD, 
        0x62BD, 0x62BD, 0x62BE, 0x5ABE, 0x5ABE, 0x5A9E, 0x5A9E, 0x5A9E, 0x5A9E, 0x527E, 0x527E, 0x527E, 0x525E, 0x4A3E, 0x421D, 0x39DD, 0x315D, 0x295C, 0x295D, 0x295D, 0x299D, 0x299D, 0x31BD, 0x39FD, 0x421D, 0x3A1D, 0x423D, 0x423D, 0x425E, 0x425E, 
        0x427D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ADE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x4ADD, 0x52DE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52BD, 0x52DD, 0x52DE, 0x52FE, 0x52FE, 0x52DE, 0x52DD, 0x52BE, 
        0x4A9D, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x529E, 0x529D, 0x529E, 0x529D, 0x529D, 0x527C, 0x529C, 0x4A3B, 0x3199, 0x39B9, 0x4A3B, 0x4A5C, 0x4A5B, 0x4A5A, 0x4239, 0x3A17, 0x3A15, 0x3A13, 0x3A32, 
        0x4271, 0x4AAF, 0x530E, 0x536C, 0x5BAB, 0x5BAB, 0x63CB, 0x640B, 0x640B, 0x642B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2B, 0x642B, 0x642A, 0x640A, 0x63EA, 0x640A, 0x640A, 0x6409, 0x6409, 0x6409, 0x640A, 0x640A, 0x5BEA, 0x5BEA, 0x53E9, 0x53E9, 
        0x53C9, 0x53C9, 0x53C9, 0x53C9, 0x53C9, 0x53C9, 0x53C9, 0x53E9, 0x53E9, 0x53E9, 0x53C9, 0x53C9, 0x53A9, 0x53C9, 0x5BCA, 0x5BCA, 0x5BAA, 0x5BAA, 0x5BCA, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCB, 0x5BCA, 0x53AA, 0x53AA, 0x53CA, 
        0x53CA, 0x5BEB, 0x53EB, 0x53CA, 0x53CA, 0x4BCA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4BA9, 0x43AA, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BAA, 0x43AA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x4BEA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 0x3BAA, 0x3BAA, 0x3BC9, 
        0x3BCA, 0x440A, 0x440A, 0x33C9, 0x2BA9, 0x23C8, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x23E9, 0x1BE8, 0x1BE8, 0x1C08, 0x1C28, 0x1C08, 0x1C09, 0x2409, 0x23E9, 0x2BCA, 0x33AA, 0x3BAB, 0x4BEC, 0x64AE, 0x542B, 0x4BE9, 0x4BE9, 
        0x53E9, 0x4BE9, 0x4BE9, 0x4BE9, 0x4BE8, 0x4BE8, 0x43E8, 0x43C8, 0x43C8, 0x3BA7, 0x3387, 0x3387, 0x3367, 0x3367, 0x2B46, 0x2B46, 0x2B26, 0x2B06, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x2AE6, 0x2B06, 0x2B06, 0x2B06, 0x2B26, 0x3327, 0x3347,
  0x5CCB, 0x5D0B, 0x656C, 0x65AC, 0x65CD, 0x5DAD, 0x5D8D, 0x5D8D, 0x5D6C, 0x5D6C, 0x654D, 0x656D, 0x6D8E, 0x6D8E, 0x65AE, 0x65EE, 0x65EE, 0x5DCE, 0x5DAD, 0x558C, 0x554B, 0x5D2B, 0x6D0C, 0x6D0D, 0x74ED, 0x7D0D, 0x8D8F, 0x95B0, 0x8D50, 0x84EF, 0x7CCF, 
        0x74CE, 0x6CAD, 0x64AC, 0x5CAC, 0x5CCC, 0x5CCD, 0x650D, 0x6D4E, 0x756E, 0x7D8F, 0x9611, 0xAE93, 0xB694, 0xB673, 0xAE33, 0xAE12, 0xA5D1, 0x9D90, 0x9550, 0x8D2F, 0x84CE, 0x748D, 0x6C6C, 0x642B, 0x640A, 0x6C2A, 0x6C2A, 0x6429, 0x6C49, 0x6C4A, 
        0x746B, 0x7C8C, 0x7C8C, 0x84CD, 0x84EE, 0x84EE, 0x84EF, 0x850E, 0x850E, 0x850E, 0x854F, 0x854E, 0x854E, 0x856E, 0x856E, 0x856E, 0x7D6E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x7D2D, 
        0x7D2E, 0x854E, 0x7D2E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854E, 0x852E, 0x854E, 0x854E, 0x852F, 0x852F, 0x8510, 0x84F0, 0x84CF, 0x84CF, 0x84CF, 0x84AF, 0x84AF, 0x84AF, 0x7C8F, 0x7C6F, 0x746E, 0x6C0D, 0x5BAB, 0x538A, 
        0x4B69, 0x4B68, 0x4367, 0x4347, 0x4347, 0x4347, 0x4B47, 0x4B47, 0x4B47, 0x5348, 0x5B69, 0x6BCA, 0x73EB, 0x7C0A, 0x844B, 0x8C6B, 0x948C, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x948C, 0x948C, 0x948C, 0x948C, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 
        0x8C8B, 0x8C8C, 0x8C8C, 0x848C, 0x846B, 0x846B, 0x846B, 0x846B, 0x7C4B, 0x7C4B, 0x844B, 0x844B, 0x844B, 0x844A, 0x842A, 0x7C2A, 0x7C2A, 0x740A, 0x6BEA, 0x6C0B, 0x740B, 0x740C, 0x7C2D, 0x742D, 0x640D, 0x53CC, 0x4BCC, 0x4BCC, 0x53CC, 0x538C, 
        0x5B8B, 0x63AC, 0x73CC, 0x8C8E, 0x9490, 0x8C52, 0x83D5, 0x6294, 0x49D4, 0x49D5, 0x41D5, 0x41B5, 0x39B5, 0x3995, 0x3174, 0x3153, 0x3153, 0x2953, 0x3133, 0x3134, 0x3114, 0x28F4, 0x28D4, 0x28F5, 0x3157, 0x3178, 0x3998, 0x3998, 0x3199, 0x3199, 
        0x3999, 0x3999, 0x3999, 0x3999, 0x3999, 0x3179, 0x2959, 0x295A, 0x295A, 0x295A, 0x295A, 0x317B, 0x39DC, 0x41FD, 0x41FD, 0x4A3D, 0x527D, 0x527D, 0x5A9D, 0x5ABD, 0x52BD, 0x529E, 0x529E, 0x529D, 0x5A9D, 0x5ABD, 0x5ABD, 0x62BD, 0x62BE, 0x5ABE, 
        0x5ABD, 0x5A9D, 0x5A9E, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ABD, 0x5A9D, 0x529D, 0x527E, 0x529E, 0x529E, 0x529E, 0x527E, 0x4A5E, 0x4A3E, 0x41FD, 0x39BD, 0x319D, 0x297D, 0x297D, 0x319D, 0x39BD, 0x39DD, 0x39FD, 0x3A1D, 0x3A1D, 0x3A3D, 0x425E, 
        0x425D, 0x427D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4ABE, 0x4ABE, 0x4ADD, 0x52DE, 0x52DE, 0x52DE, 0x52DD, 0x4ADD, 0x52DD, 0x52FD, 0x52FE, 0x52FE, 0x52FD, 0x52FD, 0x52FE, 0x52FE, 0x52DD, 0x52BD, 0x52BD, 0x52DD, 0x52DD, 0x52DD, 0x52DD, 0x52BD, 0x52BD, 
        0x52BD, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x529C, 0x4A7B, 0x421A, 0x3198, 0x41DA, 0x4A1A, 0x39D9, 0x3197, 0x2975, 0x31B4, 0x31D3, 0x31F2, 0x3A30, 0x3A8F, 0x42AE, 
        0x42ED, 0x4B2B, 0x536B, 0x538A, 0x53AA, 0x5BCA, 0x63EB, 0x640B, 0x6C2B, 0x6C0B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2A, 0x6C0A, 0x6C0A, 0x640A, 0x640A, 0x63EA, 0x63E9, 0x63E9, 0x63E9, 0x640A, 0x6409, 0x640A, 0x640A, 0x640A, 0x5C0A, 0x5BEA, 0x53E9, 
        0x53E9, 0x53C9, 0x53E9, 0x53E9, 0x53E9, 0x53EA, 0x53EA, 0x5BEA, 0x5BC9, 0x53C9, 0x5BC9, 0x5BCA, 0x5BCA, 0x5BEA, 0x5BEA, 0x5BCA, 0x5BA9, 0x5BA9, 0x53AA, 0x5BAA, 0x5BCA, 0x5BCA, 0x5BCB, 0x5BAB, 0x5BCB, 0x5BAB, 0x53AB, 0x538A, 0x53AA, 0x53AA, 
        0x53CB, 0x53EB, 0x53EB, 0x53CB, 0x53CB, 0x4BCB, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43AA, 0x4BAA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x43AA, 0x43AA, 0x43AA, 0x43CA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 0x3BA9, 0x3BA9, 
        0x43CA, 0x440B, 0x440B, 0x33C9, 0x2BA9, 0x23C8, 0x2BC9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x2409, 0x23E9, 0x2BEA, 0x2BCA, 0x33CB, 0x4C0C, 0x648E, 0x542B, 0x53E9, 0x4BE9, 
        0x4BE9, 0x4BE9, 0x4BE9, 0x4BE9, 0x4BE8, 0x4BE8, 0x4BE8, 0x43E8, 0x43C8, 0x3BA8, 0x3B87, 0x3B87, 0x3367, 0x3367, 0x2B46, 0x2B26, 0x2B26, 0x2B06, 0x2AE6, 0x2AE6, 0x2AE6, 0x22E6, 0x22E6, 0x22E6, 0x22E6, 0x2B06, 0x2B06, 0x2B27, 0x3327,
  0x5CCB, 0x54CB, 0x5D4B, 0x65AC, 0x65CD, 0x5DAD, 0x556C, 0x556C, 0x5D4C, 0x5D2C, 0x654D, 0x6D6E, 0x6D6D, 0x6D8D, 0x65AD, 0x65CE, 0x5DCD, 0x5DCD, 0x5DAD, 0x556C, 0x5D2B, 0x652C, 0x6D0C, 0x6CED, 0x74ED, 0x7D0E, 0x8D8F, 0x8D90, 0x8550, 0x7CCF, 0x74AE, 
        0x74AE, 0x6CAD, 0x648C, 0x5C8C, 0x5CCC, 0x5CED, 0x652E, 0x6D2E, 0x754F, 0x85AF, 0x95F0, 0xA652, 0xB673, 0xB673, 0xAE32, 0xADF2, 0xA5B1, 0x9570, 0x8D30, 0x7CCE, 0x748D, 0x644C, 0x5C2B, 0x5C2A, 0x642A, 0x6C2A, 0x6C2A, 0x6C2A, 0x744A, 0x746B, 
        0x7CAC, 0x7CCD, 0x84ED, 0x84EE, 0x850E, 0x850E, 0x850E, 0x852E, 0x7D2E, 0x7D2D, 0x7D2E, 0x854E, 0x854E, 0x856E, 0x856E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x754E, 0x7D2D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854E, 0x7D2E, 0x7D4E, 0x854E, 0x852E, 0x854E, 0x852F, 0x852F, 0x852F, 0x850F, 0x850F, 0x84EF, 0x84EF, 0x84EF, 0x84CF, 0x84CF, 0x7C8F, 0x742E, 0x6C0D, 0x742D, 
        0x744D, 0x6C6D, 0x6C4C, 0x642B, 0x6C2B, 0x6C4C, 0x6C4C, 0x6C4C, 0x6C0C, 0x63EB, 0x63EB, 0x6BCB, 0x6BCB, 0x6BEA, 0x7C0A, 0x844B, 0x8C6B, 0x948B, 0x948B, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x948C, 0x8C8B, 0x8C8B, 0x8CAC, 0x8CAC, 0x8CAC, 
        0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x846C, 0x846B, 0x7C6B, 0x7C6B, 0x7C4B, 0x7C4B, 0x844B, 0x844B, 0x846B, 0x844B, 0x7C2B, 0x7C2B, 0x740A, 0x6C0A, 0x6C2B, 0x742B, 0x7C4C, 0x8CAE, 0x8CCF, 0x8CEF, 0x7CCF, 0x6C6E, 0x542D, 0x540D, 0x53ED, 
        0x5BCD, 0x5BAC, 0x638C, 0x638C, 0x6BAD, 0x7BEF, 0x7BF2, 0x7BB5, 0x5273, 0x49F4, 0x49D5, 0x41D5, 0x41D5, 0x39B5, 0x3994, 0x3173, 0x3173, 0x3173, 0x3153, 0x3154, 0x3134, 0x28F3, 0x28D3, 0x28D4, 0x2916, 0x3157, 0x3978, 0x3998, 0x3998, 0x3998, 
        0x3998, 0x3998, 0x3998, 0x3999, 0x39B9, 0x3199, 0x3179, 0x3179, 0x3179, 0x2959, 0x293A, 0x293A, 0x293A, 0x319C, 0x39DD, 0x39FD, 0x423D, 0x4A7D, 0x529D, 0x529D, 0x529D, 0x529E, 0x529E, 0x529D, 0x529D, 0x529D, 0x5A9D, 0x5A9E, 0x5ABE, 0x5ABE, 
        0x5ABD, 0x5A9E, 0x5A9E, 0x5ABD, 0x5ABD, 0x5ABE, 0x5ABE, 0x5ABD, 0x529D, 0x529D, 0x527D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529E, 0x529E, 0x529E, 0x4A5E, 0x4A5D, 0x421E, 0x39DD, 0x319D, 0x319D, 0x319D, 0x39BD, 0x39DD, 0x39FD, 0x3A1D, 0x3A3E, 
        0x425D, 0x427D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABD, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x4ABD, 0x4ADD, 0x52DE, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52BD, 0x4ABD, 0x4ABD, 0x4ABD, 0x52BD, 0x52BD, 0x52BD, 0x4ABD, 0x52BD, 
        0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x529D, 0x529D, 0x52BD, 0x52BD, 0x529D, 0x52BD, 0x52BD, 0x52BC, 0x4A7A, 0x4239, 0x39F7, 0x39F7, 0x3196, 0x2954, 0x1912, 0x1910, 0x2150, 0x29AE, 0x320D, 0x326D, 0x3AAD, 0x42EC, 0x432B, 
        0x434A, 0x4B69, 0x4B69, 0x5389, 0x5BAA, 0x5BCA, 0x640B, 0x640B, 0x6C0B, 0x6C0B, 0x6C0B, 0x6C0A, 0x6C0A, 0x640A, 0x640A, 0x640A, 0x63EA, 0x640A, 0x640A, 0x63EA, 0x63E9, 0x63EA, 0x640A, 0x640A, 0x640A, 0x640A, 0x640A, 0x640A, 0x5BEA, 0x5C09, 
        0x5BE9, 0x5BE9, 0x5BE9, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BCA, 0x5BEA, 0x5BCA, 0x63EA, 0x640A, 0x640B, 0x640A, 0x5BEA, 0x5BC9, 0x5BA9, 0x53A9, 0x53A9, 0x53AA, 0x53AA, 0x5BCA, 0x5BAA, 0x5BAA, 0x5BAB, 0x5BAB, 0x53AB, 0x53AB, 0x53AB, 0x53CB, 
        0x53EB, 0x53EB, 0x53EB, 0x4BCB, 0x4BCA, 0x4BCA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4BAA, 0x4BCA, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4BAA, 0x43AA, 0x43CA, 0x4BCA, 0x4BEB, 0x4BEA, 0x4BCA, 0x43CA, 0x43CA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 0x3BAA, 
        0x43CA, 0x4C0B, 0x4C2B, 0x3BCA, 0x2BC9, 0x2BC9, 0x2BC9, 0x23C8, 0x23C8, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x1C09, 0x1C09, 0x2409, 0x2409, 0x23E9, 0x23EA, 0x2BEA, 0x4C2C, 0x648D, 0x542B, 0x53E9, 0x4BE9, 
        0x4BE9, 0x4BE9, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x43C8, 0x3BA8, 0x3BA7, 0x3B87, 0x3367, 0x3367, 0x2B26, 0x2B26, 0x2B06, 0x22E6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22C6, 0x22E6, 0x2AE6, 0x2AE6, 0x2B07, 0x2B27,
  0x5CCB, 0x54CA, 0x552B, 0x5D8C, 0x5DAC, 0x5D8C, 0x556C, 0x554B, 0x5D2B, 0x652C, 0x8630, 0x9692, 0x7DCF, 0x6D8D, 0x5D8D, 0x5DAD, 0x5DAD, 0x55AD, 0x558D, 0x556C, 0x5D4C, 0x652C, 0x6D0D, 0x750D, 0x854F, 0x8D90, 0x8D90, 0x9590, 0x8D50, 0x7CCF, 0x74AE, 
        0x74AE, 0x6C8D, 0x648D, 0x5CAC, 0x5CCD, 0x64ED, 0x6D2D, 0x6D2E, 0x756F, 0x85AF, 0x95D0, 0xAE52, 0xBE93, 0xB673, 0xAE32, 0xADF2, 0x9DB1, 0x9571, 0x8D30, 0x74AE, 0x6C4C, 0x642B, 0x5C2A, 0x5C2A, 0x642A, 0x6C29, 0x748B, 0x748B, 0x7C8C, 0x7CCC, 
        0x84ED, 0x850E, 0x852E, 0x852E, 0x7D0E, 0x7D0E, 0x7D0E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x7D4E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4D, 0x752D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x7D2E, 0x7D2E, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x856E, 0x854E, 0x854E, 0x854F, 0x854F, 0x852F, 0x852F, 0x852F, 0x850F, 0x850F, 0x84EF, 0x84CF, 0x84B0, 0x84B0, 0x84AF, 
        0x7CAF, 0x7CAF, 0x7CCF, 0x84CF, 0x84CF, 0x84CF, 0x84CF, 0x7CAF, 0x7CAE, 0x7CAE, 0x6C0D, 0x63AB, 0x63AB, 0x63EB, 0x6C0A, 0x7C2A, 0x844A, 0x844B, 0x8C6B, 0x8C6B, 0x8C6B, 0x948B, 0x948B, 0x8C8C, 0x8C8C, 0x8C8B, 0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 
        0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x8C8C, 0x846B, 0x7C6B, 0x7C6B, 0x7C6B, 0x844B, 0x7C4B, 0x844B, 0x8C6C, 0xA550, 0x844B, 0x7C2B, 0x7C2B, 0x742B, 0x742B, 0x6C2B, 0x744C, 0x7C4C, 0x94AD, 0x9CEE, 0x9CEF, 0x950F, 0x8D0F, 0x7CCF, 0x6C8E, 0x644E, 
        0x53CD, 0x53AC, 0x5B8C, 0x534B, 0x532B, 0x5B2C, 0x5B0D, 0x6B92, 0x7375, 0x5253, 0x49F4, 0x49F5, 0x41D5, 0x41D5, 0x39B5, 0x3994, 0x3194, 0x3173, 0x3173, 0x3153, 0x3154, 0x3134, 0x28F3, 0x2914, 0x3136, 0x3177, 0x3978, 0x3998, 0x3998, 0x3998, 
        0x3998, 0x3998, 0x3998, 0x3998, 0x39B8, 0x3999, 0x3199, 0x3178, 0x3178, 0x3179, 0x2959, 0x2959, 0x2959, 0x295A, 0x297B, 0x39DD, 0x421D, 0x425D, 0x4A7D, 0x4A7D, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x529E, 0x529E, 0x52BD, 0x52BE, 0x52BE, 
        0x52BD, 0x529E, 0x529E, 0x52BD, 0x5ABD, 0x5ABE, 0x5ABE, 0x52BD, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x527E, 0x4A5E, 0x421E, 0x41FD, 0x41FD, 0x39DD, 0x39DD, 0x39FD, 0x3A1D, 
        0x423D, 0x423D, 0x425E, 0x4A7E, 0x4A7E, 0x4A7E, 0x4A9E, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ADD, 0x4ADD, 0x4ADD, 0x4ADE, 0x4ADD, 0x52BD, 0x52DD, 0x52DD, 0x52DD, 0x52DE, 0x52DE, 0x4ABD, 0x4A9D, 0x4ABE, 0x4ABE, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x529D, 0x529D, 0x529D, 0x529C, 0x4A9C, 0x52BB, 0x4A9A, 0x4259, 0x4237, 0x4237, 0x4276, 0x4254, 0x31F2, 0x29D0, 0x216E, 0x112C, 0x198D, 0x21EC, 0x2A4B, 0x32AA, 0x3AEA, 0x430A, 0x434A, 
        0x4349, 0x4369, 0x4B69, 0x5389, 0x5BA9, 0x5BCA, 0x640B, 0x640B, 0x640B, 0x640B, 0x6C0A, 0x640A, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x6C0A, 0x6C0A, 0x640A, 0x640A, 0x640A, 0x640A, 0x640A, 0x63EA, 0x6409, 
        0x6409, 0x63E9, 0x5BE9, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x63EA, 0x6C2B, 0x6C2B, 0x63EA, 0x5BEA, 0x640A, 0x5BEA, 0x5BCA, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53AA, 0x53AA, 0x53AA, 0x53AA, 0x53AA, 0x53AB, 0x53AB, 0x53AB, 0x53AB, 0x53CB, 
        0x53CC, 0x53EC, 0x53CB, 0x4BCB, 0x4BAB, 0x4BAA, 0x43CA, 0x43CA, 0x43AA, 0x43AA, 0x4BAA, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4BAA, 0x4BAA, 0x43AA, 0x4BCA, 0x4BEA, 0x4BEA, 0x4BCA, 0x4BCA, 0x43CA, 0x4BCA, 0x43EA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 
        0x43CA, 0x4C0B, 0x4C0B, 0x3BEA, 0x33C9, 0x2BC9, 0x2BC9, 0x23C9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C09, 0x1C09, 0x2409, 0x23E9, 0x2BEA, 0x4C2B, 0x5C8D, 0x542B, 0x5409, 0x4BE9, 
        0x4BE9, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C8, 0x43C8, 0x3BA7, 0x3B87, 0x3B67, 0x3347, 0x2B26, 0x2B06, 0x22E6, 0x22C6, 0x22A6, 0x22A6, 0x22A6, 0x2286, 0x2286, 0x22A6, 0x22A6, 0x22C6, 0x22C6, 0x22E6, 0x2B06,
  0x5CCB, 0x54CA, 0x550A, 0x554B, 0x4D4B, 0x4D4B, 0x4D2B, 0x552B, 0x650B, 0x650B, 0x9692, 0xA715, 0x7E11, 0x658D, 0x5D8D, 0x5D8D, 0x5D8D, 0x5DAD, 0x5D8D, 0x5D4C, 0x5D4C, 0x6D4C, 0x750D, 0x74ED, 0x9E13, 0xAE54, 0x95B0, 0x95B1, 0x9591, 0x84F0, 0x74AF, 
        0x74AE, 0x64AD, 0x5CAD, 0x5CAC, 0x5CCD, 0x64ED, 0x650D, 0x6D2E, 0x7D6F, 0x8DAF, 0x95AF, 0xA611, 0xB673, 0xB653, 0xAE12, 0xA5D2, 0x9D91, 0x9571, 0x8D10, 0x746D, 0x640C, 0x642B, 0x642A, 0x6449, 0x6449, 0x6C4A, 0x84ED, 0x850D, 0x850E, 0x852E, 
        0x852E, 0x854E, 0x854E, 0x7D2E, 0x7D2E, 0x7D0E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D4D, 0x7D4D, 0x7D4E, 0x754D, 0x752D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D4D, 0x7D4E, 0x7D4E, 0x854E, 0x854E, 0x854E, 0x856E, 0x856E, 0x856E, 0x856E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D4E, 0x854E, 0x852F, 0x852F, 0x852F, 0x850F, 0x84EF, 0x84EF, 0x84EF, 0x84EF, 
        0x84EF, 0x84EF, 0x84EF, 0x84EF, 0x84CF, 0x84AF, 0x7CAF, 0x744E, 0x6BEC, 0x63CB, 0x5B8A, 0x538B, 0x5BAB, 0x5BEB, 0x63EA, 0x6C0A, 0x742A, 0x7C4A, 0x7C4A, 0x844B, 0x8C4B, 0x8C4B, 0x8C6B, 0x8C8B, 0x8C8B, 0x8C6B, 0x8C6B, 0x8C8B, 0x8C8B, 0x8C8B, 
        0x8C8B, 0x8C8C, 0x8C8C, 0x8C8C, 0x846B, 0x7C4B, 0x7C4B, 0x7C6B, 0x7C6B, 0x844B, 0x844B, 0x844C, 0x846C, 0x8C6C, 0x844B, 0x7C2B, 0x7C2B, 0x7C4B, 0x744B, 0x744B, 0x7C4C, 0x846C, 0x94CD, 0xA4EE, 0xA50E, 0x9D0E, 0x9D0E, 0x8CEF, 0x84EF, 0x7CEF, 
        0x644E, 0x4B8B, 0x4B6B, 0x4B4A, 0x4B2B, 0x530B, 0x428A, 0x426A, 0x52B0, 0x5292, 0x4A13, 0x49F4, 0x41D5, 0x41D5, 0x41D5, 0x39B4, 0x39B4, 0x3994, 0x3173, 0x3173, 0x3153, 0x3154, 0x3134, 0x3135, 0x3156, 0x3977, 0x3978, 0x3998, 0x3998, 0x3978, 
        0x3178, 0x3198, 0x3998, 0x39B8, 0x39B8, 0x3998, 0x3199, 0x3198, 0x3198, 0x3179, 0x3179, 0x3159, 0x3159, 0x315A, 0x315B, 0x319C, 0x39FD, 0x423D, 0x425D, 0x427D, 0x427D, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x529E, 0x52BE, 0x52BE, 0x52BE, 0x52BE, 
        0x52BD, 0x529E, 0x529E, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x529D, 0x4A9D, 0x4A9D, 0x529D, 0x529D, 0x529D, 0x529D, 0x529E, 0x529E, 0x52BE, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x4A7D, 0x4A5D, 0x4A5D, 0x4A3D, 0x423D, 0x421D, 0x421D, 
        0x421D, 0x421D, 0x423D, 0x425E, 0x425E, 0x425D, 0x427D, 0x4A9D, 0x4A9D, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABE, 0x4ADE, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4A9D, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9D, 0x4A9D, 0x52BD, 
        0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x52BD, 0x529D, 0x527D, 0x527D, 0x4A9C, 0x4ABB, 0x4AB9, 0x4AB8, 0x4296, 0x4295, 0x4AB4, 0x4AF4, 0x4B13, 0x4B11, 0x4B10, 0x42F0, 0x3AAE, 0x2A2C, 0x19AA, 0x21EA, 0x2A4A, 0x328A, 0x3AE9, 0x4329, 0x4349, 
        0x4349, 0x4369, 0x4B69, 0x4BA9, 0x53A9, 0x5BCA, 0x640A, 0x640B, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x640A, 0x6C0A, 0x6C0A, 0x63EA, 
        0x63EA, 0x63E9, 0x63E9, 0x63E9, 0x63EA, 0x63EA, 0x63EA, 0x63CA, 0x63EA, 0x63EA, 0x5BCA, 0x5BCA, 0x5BCA, 0x53CA, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53AA, 0x53AA, 0x53AA, 0x53AA, 0x53AA, 0x5BAB, 0x5BCB, 0x5BCB, 0x5BCC, 
        0x53AC, 0x53AC, 0x53CC, 0x5BED, 0x4B8B, 0x43AB, 0x43AB, 0x43AA, 0x43AA, 0x43AA, 0x4BAA, 0x4BAA, 0x4BAA, 0x4BAA, 0x4BAA, 0x4BAA, 0x43A9, 0x43AA, 0x4BEA, 0x540B, 0x4BEB, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BEA, 0x4BEA, 0x43EA, 0x43AA, 0x3BAA, 0x3BA9, 
        0x43CA, 0x4C0B, 0x4C0B, 0x440B, 0x33EA, 0x2BC9, 0x2BC9, 0x2BE9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2429, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x2409, 0x23E9, 0x2BEA, 0x4C2B, 0x5C8D, 0x542B, 0x5409, 0x4BE9, 
        0x4C09, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x4C08, 0x4BE8, 0x4BC8, 0x43C7, 0x3BA7, 0x3B87, 0x3B67, 0x3347, 0x2B27, 0x2B06, 0x22E6, 0x22C6, 0x22A6, 0x1A86, 0x1A86, 0x1A86, 0x1A66, 0x1A85, 0x2286, 0x22A5, 0x22C6, 0x22E6, 0x22E6,
  0x54AB, 0x54AA, 0x4CE9, 0x4D0A, 0x4D2A, 0x4D0A, 0x4D0A, 0x54EA, 0x5CCA, 0x6CEB, 0x9672, 0xAF35, 0x8631, 0x656E, 0x5D6D, 0x5D6C, 0x5D6C, 0x65AD, 0x6DEF, 0x658E, 0x654D, 0x6D4D, 0x7D2D, 0x854F, 0xB6D5, 0xB695, 0x9DB1, 0x9DD2, 0x9591, 0x7CF0, 0x748F, 
        0x74AE, 0x64AD, 0x5CAC, 0x5CCC, 0x5CED, 0x5CED, 0x650D, 0x6D0D, 0x7D6E, 0x95D0, 0xA611, 0xAE52, 0xB652, 0xB612, 0xADF2, 0xA5D1, 0x9D91, 0x8D51, 0x84F0, 0x6C6D, 0x640C, 0x642B, 0x644A, 0x6C6A, 0x74AB, 0x7CCC, 0x850E, 0x852E, 0x8D4E, 0x854E, 
        0x856E, 0x854E, 0x854E, 0x7D4E, 0x7D4E, 0x7D2E, 0x752D, 0x752D, 0x752D, 0x754D, 0x754D, 0x7D2D, 0x7D4E, 0x7D4E, 0x7D6E, 0x7D8E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D2E, 0x7D2E, 0x7D2D, 0x752D, 0x750D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x854E, 0x7D6E, 0x856E, 0x7D6E, 0x7D4E, 0x7D4E, 0x854E, 0x854E, 0x854E, 0x852E, 0x850E, 0x852E, 0x850E, 0x850F, 
        0x850F, 0x850F, 0x84EF, 0x84EF, 0x84EF, 0x84D0, 0x742D, 0x5B8A, 0x534A, 0x534A, 0x4B4A, 0x536A, 0x53AB, 0x5BCB, 0x5BEA, 0x63EA, 0x640A, 0x6C2A, 0x742A, 0x7C2A, 0x7C4A, 0x7C4A, 0x844B, 0x844B, 0x844B, 0x846B, 0x846B, 0x846B, 0x846B, 0x846B, 
        0x846B, 0x846B, 0x846B, 0x846B, 0x844B, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C4B, 0x848C, 0x950F, 0x846C, 0x842B, 0x842B, 0x7C4B, 0x7C4B, 0x7C4B, 0x742B, 0x744C, 0x7C6C, 0x848C, 0x9CCD, 0xA50D, 0xA50E, 0xA50E, 0xA50E, 0x9D0E, 0x94EE, 0x8D0F, 
        0x84EF, 0x6C4D, 0x4B6A, 0x432A, 0x432A, 0x432B, 0x42EB, 0x428A, 0x3A2B, 0x420E, 0x4211, 0x49F4, 0x49F4, 0x41F5, 0x41D5, 0x39D5, 0x39B4, 0x3994, 0x3173, 0x3153, 0x3153, 0x3153, 0x3154, 0x3154, 0x3155, 0x3977, 0x3977, 0x3998, 0x3998, 0x3998, 
        0x3998, 0x3178, 0x3998, 0x39B8, 0x39B8, 0x39B9, 0x3998, 0x3998, 0x3198, 0x3198, 0x3178, 0x3179, 0x3179, 0x315A, 0x315A, 0x317B, 0x319C, 0x39FD, 0x3A3D, 0x425E, 0x425E, 0x427E, 0x429E, 0x4A9E, 0x4ABE, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABD, 
        0x4ABD, 0x4A9D, 0x4ABD, 0x4ABD, 0x52BD, 0x52BD, 0x52BD, 0x4ABD, 0x4A9D, 0x4A9D, 0x4A9E, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529E, 0x529D, 0x529D, 0x529E, 0x529E, 0x529E, 0x529E, 0x4A5D, 
        0x423D, 0x421D, 0x3A1D, 0x423D, 0x423D, 0x423D, 0x425D, 0x425D, 0x4A7D, 0x4A9D, 0x4ABD, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4A9D, 0x4A7D, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9E, 0x529E, 0x529E, 0x52BD, 
        0x52BD, 0x52BD, 0x52BE, 0x52BE, 0x52BE, 0x529D, 0x529D, 0x529C, 0x529C, 0x4ABA, 0x4AB9, 0x4AF6, 0x5335, 0x5373, 0x5392, 0x5391, 0x5390, 0x53AF, 0x4B8D, 0x4B6D, 0x434C, 0x432C, 0x3AEC, 0x326B, 0x2A2A, 0x2A49, 0x2A69, 0x32A9, 0x3B09, 0x4329, 
        0x4329, 0x4349, 0x4B69, 0x4B89, 0x53A9, 0x5BC9, 0x5BCA, 0x5BCA, 0x63CA, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 
        0x6BE9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63CA, 0x63CA, 0x63A9, 0x5BAA, 0x5BA9, 0x53A9, 0x53A9, 0x53A9, 0x4B89, 0x4BA9, 0x4BA9, 0x4BA9, 0x53C9, 0x53CA, 0x53CA, 0x53AA, 0x53AA, 0x53CA, 0x5BCB, 0x5BCB, 0x5BCB, 0x63EC, 0x63EC, 0x63CC, 
        0x5BAC, 0x538C, 0x53AC, 0x5C0E, 0x53CC, 0x438B, 0x43AA, 0x43AA, 0x438A, 0x438A, 0x43AA, 0x4BAA, 0x4BAA, 0x438A, 0x438A, 0x438A, 0x43AA, 0x43AA, 0x4BEA, 0x542B, 0x542B, 0x4BEA, 0x4BCA, 0x4BEA, 0x4BEA, 0x4BEA, 0x43CA, 0x43CA, 0x3BAA, 0x3BAA, 
        0x43CA, 0x43EB, 0x4C2C, 0x442B, 0x3BEA, 0x2BC9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x242A, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C29, 0x2409, 0x2409, 0x2C0A, 0x442B, 0x548C, 0x540B, 0x53EA, 0x53E9, 
        0x4C09, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x4C08, 0x4BE8, 0x4BC8, 0x43C7, 0x3BA7, 0x3B87, 0x3B67, 0x3327, 0x2B07, 0x22E6, 0x22C6, 0x22A6, 0x2286, 0x1A86, 0x1A66, 0x1A45, 0x1A45, 0x1A65, 0x1A65, 0x1A85, 0x22A5, 0x22C5, 0x22C6,
  0x4C8B, 0x4C8A, 0x44C9, 0x4509, 0x450A, 0x450A, 0x44EA, 0x4CEA, 0x5CCA, 0x64CB, 0x7DAF, 0x8E52, 0x7E11, 0x656E, 0x5D4D, 0x5D2C, 0x550B, 0x656E, 0x8651, 0x7DCF, 0x6D2D, 0x752D, 0x7D2D, 0x95D1, 0xBEF5, 0xA633, 0x95B1, 0x9DD2, 0x9592, 0x7CD0, 0x748F, 
        0x74AE, 0x64AD, 0x5CAC, 0x5CCC, 0x5CEC, 0x5CEC, 0x650D, 0x6D0D, 0x858F, 0x9E11, 0xA611, 0xA611, 0xAE11, 0xADF1, 0xADD2, 0xA5B1, 0x9570, 0x8D30, 0x7CEF, 0x6C6E, 0x642C, 0x6C4B, 0x6C8B, 0x7CEC, 0x852D, 0x852D, 0x854E, 0x8D4E, 0x8D6E, 0x856E, 
        0x856E, 0x856E, 0x856E, 0x854E, 0x7D4E, 0x7D4E, 0x752D, 0x752D, 0x752D, 0x754D, 0x754D, 0x7D4D, 0x7D4E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D2E, 0x7D2D, 0x752D, 0x750D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 
        0x7D2D, 0x7D0D, 0x7D2D, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x854E, 0x7D4E, 0x7D4E, 0x7D4E, 0x854E, 0x854E, 0x856E, 0x856E, 0x854E, 0x854D, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x852E, 0x852E, 0x852E, 
        0x850E, 0x850F, 0x7CCE, 0x7CAE, 0x746E, 0x63EC, 0x538A, 0x5369, 0x4B68, 0x4B68, 0x4B69, 0x4B69, 0x538A, 0x53AA, 0x5BEA, 0x5BEA, 0x640A, 0x640A, 0x6C29, 0x6C29, 0x742A, 0x742A, 0x7C2A, 0x7C4A, 0x844A, 0x7C4A, 0x7C4B, 0x844B, 0x846B, 0x844B, 
        0x7C4B, 0x7C4B, 0x846B, 0x846B, 0x844B, 0x7C4B, 0x7C4B, 0x7C2B, 0x7C2B, 0x848D, 0xADB2, 0x950F, 0x7C2B, 0x7C2B, 0x842B, 0x844B, 0x7C4B, 0x7C4B, 0x742B, 0x744B, 0x7C6C, 0x848C, 0x9CED, 0xA50D, 0xAD0E, 0xAD0E, 0xAD0E, 0xA50E, 0xA50E, 0x9D0E, 
        0x950F, 0x84EF, 0x746E, 0x4B6B, 0x430A, 0x430A, 0x42EA, 0x3AAA, 0x3A6A, 0x31EB, 0x31AD, 0x39F0, 0x4A33, 0x4A14, 0x41F5, 0x41D5, 0x41B5, 0x3994, 0x3973, 0x3173, 0x3153, 0x3173, 0x3173, 0x3174, 0x3175, 0x3976, 0x3977, 0x3997, 0x3997, 0x3998, 
        0x3178, 0x3178, 0x3998, 0x39B8, 0x39B8, 0x39B9, 0x3998, 0x3198, 0x3198, 0x3198, 0x3199, 0x3199, 0x3179, 0x3179, 0x317A, 0x317A, 0x317B, 0x319C, 0x31DD, 0x3A1D, 0x3A3D, 0x3A5D, 0x427E, 0x429E, 0x42BE, 0x4ABE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABD, 
        0x4ABD, 0x4ABE, 0x4ABD, 0x4ADE, 0x52DE, 0x4ADE, 0x4ADE, 0x4ABE, 0x4A9E, 0x429D, 0x429D, 0x429D, 0x429E, 0x429E, 0x42BE, 0x4ABE, 0x4ABE, 0x4ABE, 0x4ABE, 0x4ABE, 0x4A9E, 0x529E, 0x529E, 0x4A9D, 0x4A9D, 0x529E, 0x52BD, 0x529E, 0x52BD, 0x529E, 
        0x529E, 0x4A7E, 0x4A7E, 0x427D, 0x425D, 0x3A1D, 0x3A1D, 0x423D, 0x425D, 0x4A7D, 0x4A9D, 0x4A9E, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABE, 0x4ABE, 0x4A9D, 0x4ABD, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A9E, 0x4A9D, 0x529E, 0x529E, 0x52BD, 
        0x52BD, 0x52BD, 0x529D, 0x529E, 0x52BD, 0x52BD, 0x529C, 0x529B, 0x52B9, 0x5318, 0x6397, 0x5372, 0x53B1, 0x53EF, 0x540E, 0x540D, 0x53ED, 0x4BEC, 0x4BEB, 0x4BAA, 0x436A, 0x432A, 0x3AE9, 0x328A, 0x2A4A, 0x2209, 0x2208, 0x2A69, 0x32C9, 0x3B29, 
        0x4328, 0x4348, 0x4B68, 0x4B88, 0x5389, 0x5BA9, 0x5BC9, 0x63CA, 0x63C9, 0x63CA, 0x63EA, 0x6BCA, 0x6BCA, 0x63EA, 0x63EA, 0x63C9, 0x63EA, 0x6BCA, 0x6BEA, 0x63EA, 0x63EA, 0x6C0A, 0x6C0A, 0x63EA, 0x63EA, 0x6BEA, 0x6BCA, 0x63E9, 0x6BC9, 0x63E9, 
        0x6BE9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63CA, 0x63CA, 0x63AA, 0x63AA, 0x5BAA, 0x53A9, 0x4BA9, 0x4BA9, 0x4BA9, 0x53A9, 0x53AA, 0x53CA, 0x53CA, 0x53CA, 0x53EA, 0x53CA, 0x53CA, 0x53EA, 0x5BEB, 0x5BEB, 0x5BEB, 0x63EC, 0x63EC, 0x63CC, 
        0x5BCC, 0x5BAC, 0x53AC, 0x5BCD, 0x5C0E, 0x4BCC, 0x43AB, 0x43AA, 0x3B8A, 0x3B8A, 0x43AA, 0x43AA, 0x438A, 0x4389, 0x4389, 0x438A, 0x43AA, 0x43CA, 0x4BCA, 0x4BCA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4C0A, 0x43EA, 0x43CA, 0x3BCA, 0x3BCA, 0x3BAA, 
        0x43CA, 0x43EB, 0x4C2C, 0x442C, 0x3BEA, 0x33CA, 0x2BC9, 0x2BC9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x1C08, 0x1C08, 0x1C28, 0x1C29, 0x1C09, 0x2409, 0x2C09, 0x340A, 0x442B, 0x4BCA, 0x53EA, 0x53E9, 
        0x5409, 0x5408, 0x5408, 0x5408, 0x5408, 0x5408, 0x4C08, 0x4BE8, 0x43C8, 0x43A7, 0x43A7, 0x3B67, 0x3B47, 0x3327, 0x2AE6, 0x22C6, 0x22A6, 0x2286, 0x2286, 0x1A65, 0x1A45, 0x1A25, 0x1A25, 0x1A45, 0x1A45, 0x1A65, 0x2285, 0x22A5, 0x22A5,
  0x4C6A, 0x4C8A, 0x44C9, 0x44E9, 0x3CE9, 0x450A, 0x44EA, 0x4CCA, 0x54CA, 0x64EB, 0x6D4C, 0x6D8E, 0x6D8E, 0x5D4D, 0x5D2C, 0x5D0C, 0x54EB, 0x6D6E, 0x8E32, 0x7DB0, 0x6D0D, 0x750D, 0x7D2D, 0x9DF1, 0xB6B4, 0x9DD1, 0x9590, 0x9DD1, 0x9592, 0x7CD0, 0x748E, 
        0x74AE, 0x64AD, 0x5CAC, 0x5CAC, 0x5CCC, 0x5CEC, 0x64ED, 0x6D0D, 0x856F, 0x8D8F, 0x9DF0, 0xAE11, 0xA5F1, 0xA5F1, 0xA5D1, 0x9D91, 0x9550, 0x8510, 0x7CAF, 0x6C6E, 0x6C6C, 0x748C, 0x74CC, 0x7D0D, 0x854D, 0x852E, 0x854E, 0x854E, 0x856E, 0x856E, 
        0x856E, 0x856E, 0x856E, 0x7D6E, 0x7D4E, 0x7D4D, 0x752D, 0x752D, 0x752D, 0x754D, 0x754D, 0x7D4D, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D4E, 0x7D2E, 0x7D2D, 0x7D2D, 0x750D, 0x7D0D, 0x752E, 0x752E, 0x752D, 0x7D0D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D0D, 0x7D2D, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854D, 0x854D, 0x8D4D, 0x8D4E, 0x8D6E, 0x8D4E, 0x8D4E, 0x8D2E, 0x8D2E, 0x850E, 
        0x8CEF, 0x84CF, 0x7CAE, 0x6C2D, 0x5BAA, 0x4B69, 0x4B88, 0x4B88, 0x4B88, 0x4B87, 0x4B68, 0x4B68, 0x4B89, 0x53AA, 0x53CA, 0x5BEA, 0x5C0A, 0x5C09, 0x6409, 0x6409, 0x6409, 0x6C09, 0x742A, 0x7C2A, 0x7C4A, 0x7C4A, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C4B, 
        0x7C4B, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C4B, 0x7C2B, 0x742B, 0x742B, 0x742C, 0x9530, 0x9D91, 0x7C4C, 0x742B, 0x7C2B, 0x7C2B, 0x7C4B, 0x7C4B, 0x7C4B, 0x742B, 0x742B, 0x7C4C, 0x846C, 0x94ED, 0xA50D, 0xAD2E, 0xAD0D, 0xAD0D, 0xA50E, 0xAD0E, 0xA50E, 
        0x9D0F, 0x950F, 0x84CF, 0x6C4E, 0x3B0A, 0x32C9, 0x32C9, 0x32AA, 0x328A, 0x2A2A, 0x2A0B, 0x31EE, 0x3A11, 0x4233, 0x4A14, 0x41F5, 0x41B5, 0x39B4, 0x3994, 0x3173, 0x3173, 0x3173, 0x3173, 0x3153, 0x3174, 0x3975, 0x3976, 0x3997, 0x3997, 0x3997, 
        0x3997, 0x3177, 0x3978, 0x3998, 0x3998, 0x3998, 0x3198, 0x3198, 0x3198, 0x3198, 0x3199, 0x3999, 0x3199, 0x3179, 0x3179, 0x319A, 0x319B, 0x299C, 0x29BC, 0x31DD, 0x321D, 0x323D, 0x3A5E, 0x3A7D, 0x429E, 0x42BE, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABE, 
        0x4ABE, 0x4ADE, 0x4ADD, 0x4ADE, 0x4AFE, 0x52FE, 0x4ADE, 0x4ADE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x42BE, 0x4ABD, 0x4ADD, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABE, 0x4ABD, 0x4ABE, 0x52BE, 0x52BD, 0x52BD, 0x52DD, 0x52DD, 
        0x52DD, 0x52BD, 0x52DD, 0x52DE, 0x4ABE, 0x4A7E, 0x3A1D, 0x3A1D, 0x423D, 0x423D, 0x425E, 0x4A7E, 0x4A9E, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABD, 0x52BE, 0x52BD, 0x4A9E, 0x4A9E, 0x4A7D, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x529D, 0x52BD, 
        0x52BD, 0x52BD, 0x529D, 0x5A9D, 0x5ABC, 0x52BB, 0x529A, 0x5AF9, 0x6398, 0x7437, 0x7CB7, 0x6C72, 0x5C0E, 0x542C, 0x542C, 0x542C, 0x542B, 0x4C0A, 0x4BEA, 0x43C9, 0x4389, 0x3B49, 0x3B09, 0x32EA, 0x32AA, 0x2A4A, 0x2229, 0x2228, 0x2A68, 0x32C8, 
        0x3B29, 0x4348, 0x4B68, 0x4B88, 0x5389, 0x5BA9, 0x5BA9, 0x63CA, 0x63C9, 0x63EA, 0x63EA, 0x6BEA, 0x6BEA, 0x63EA, 0x63EA, 0x63C9, 0x63C9, 0x63C9, 0x63EA, 0x63EA, 0x63EA, 0x6BEA, 0x6C0A, 0x63EA, 0x63EA, 0x6BEA, 0x6BEA, 0x6BCA, 0x6BCA, 0x6BE9, 
        0x6BE9, 0x6BC9, 0x6BC9, 0x63C9, 0x63C9, 0x6BC9, 0x6BCA, 0x63CA, 0x63CA, 0x63CA, 0x5BCA, 0x53C9, 0x53C9, 0x53CA, 0x53CA, 0x5BCA, 0x5BCA, 0x53CA, 0x5BEA, 0x5BEA, 0x5BEA, 0x53EA, 0x53EB, 0x5BEB, 0x5BEB, 0x5BEB, 0x5BEB, 0x63CB, 0x63CB, 0x63CB, 
        0x5BCB, 0x5BAC, 0x538C, 0x53AC, 0x53AC, 0x53CC, 0x4BCC, 0x43AB, 0x3B8A, 0x3B8A, 0x3B8A, 0x438A, 0x3B8A, 0x43AA, 0x438A, 0x43AA, 0x43CA, 0x43CA, 0x43CA, 0x4BCA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4C0A, 0x43EA, 0x43CA, 0x3BCA, 0x3BCA, 0x43CA, 
        0x43CA, 0x43EB, 0x4C0C, 0x440C, 0x3BEB, 0x33CA, 0x2BCA, 0x2BC9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C29, 0x2409, 0x2C09, 0x33EA, 0x3BEA, 0x4BEA, 0x4BEA, 0x4BC9, 
        0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C7, 0x43A7, 0x3B87, 0x3B67, 0x3B47, 0x3327, 0x2AE7, 0x2AC6, 0x22A6, 0x2286, 0x1A65, 0x1A45, 0x1225, 0x1A05, 0x1204, 0x1A24, 0x1A25, 0x1A44, 0x1A65, 0x1A85, 0x22A5,
  0x4C6A, 0x4C6A, 0x44C9, 0x3CE9, 0x3CE9, 0x3D09, 0x3CE9, 0x44EA, 0x54EA, 0x5D2B, 0x654C, 0x654D, 0x5D4D, 0x5D2D, 0x5D0C, 0x5CEC, 0x5CCC, 0x650D, 0x754F, 0x6CED, 0x64AC, 0x6CCC, 0x7CEC, 0x8D6F, 0x9DD1, 0x9570, 0x8D4F, 0x9590, 0x9571, 0x7CCF, 0x748E, 
        0x6CAE, 0x64AD, 0x5CAC, 0x5CAC, 0x5CCC, 0x5CCC, 0x64EC, 0x6D0D, 0x7D2D, 0x8D6E, 0x9DD0, 0xA5F1, 0xA5F1, 0xA5D1, 0xA5D1, 0x9D91, 0x8D50, 0x7CEF, 0x748E, 0x6C8D, 0x6C8D, 0x74CD, 0x74ED, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D6E, 0x856E, 
        0x856E, 0x856E, 0x856E, 0x7D6E, 0x7D4E, 0x7D4D, 0x7D2D, 0x754D, 0x7D4D, 0x754D, 0x7D4D, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D6E, 0x7D6E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2E, 0x7D2D, 0x752D, 0x752D, 0x7D0D, 0x750D, 0x750D, 0x7D2D, 
        0x7D2D, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x854E, 0x854E, 0x854E, 0x7D4D, 0x854D, 0x854D, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x8D4E, 0x8D6D, 0x8D6E, 0x956E, 0x956E, 0x954E, 0x952E, 0x8D2E, 0x8D0E, 0x8CEF, 
        0x84EF, 0x7C6E, 0x640C, 0x5BCB, 0x4B69, 0x4B68, 0x4B87, 0x4B87, 0x4B87, 0x4B87, 0x4B87, 0x4B87, 0x4368, 0x4B89, 0x53CA, 0x53EA, 0x5C0A, 0x5C09, 0x5C09, 0x5C09, 0x5BE9, 0x6409, 0x6409, 0x742A, 0x742A, 0x744A, 0x744A, 0x7C4B, 0x7C4B, 0x7C4B, 
        0x7C4B, 0x7C2A, 0x7C2B, 0x7C2B, 0x7C2B, 0x7C2B, 0x740B, 0x7C2C, 0x848E, 0x9531, 0x7C8D, 0x740B, 0x742B, 0x7C2B, 0x7C2B, 0x7C4B, 0x7C4B, 0x7C4B, 0x744B, 0x742B, 0x744B, 0x7C6B, 0x94CD, 0xA50D, 0xAD0D, 0xAD0D, 0xA4ED, 0xA4CD, 0xA50D, 0xA50E, 
        0x9D0E, 0x94EF, 0x84EF, 0x7CD0, 0x642E, 0x4BCC, 0x4BCD, 0x4BAD, 0x438D, 0x436D, 0x3B0D, 0x326D, 0x322F, 0x4252, 0x4A33, 0x4214, 0x41F4, 0x39D4, 0x39B4, 0x3993, 0x3173, 0x2952, 0x3172, 0x3153, 0x39B5, 0x39B6, 0x3175, 0x3996, 0x3977, 0x3977, 
        0x3177, 0x3157, 0x3177, 0x3998, 0x3998, 0x3998, 0x3198, 0x3198, 0x3198, 0x3198, 0x3199, 0x3999, 0x3199, 0x3179, 0x3199, 0x3199, 0x319A, 0x319B, 0x299C, 0x29BC, 0x31DD, 0x31FD, 0x323D, 0x3A5E, 0x3A7E, 0x429E, 0x42BE, 0x4ABE, 0x4ABD, 0x4ABE, 
        0x4ADE, 0x4ADE, 0x4AFE, 0x4AFD, 0x4AFE, 0x4AFE, 0x4AFE, 0x4AFE, 0x42DE, 0x42DD, 0x42BD, 0x42BD, 0x42BD, 0x42BD, 0x42DE, 0x4ADE, 0x4AFE, 0x4AFE, 0x4ADD, 0x4ABD, 0x4ABD, 0x4ABD, 0x4ABE, 0x4ABD, 0x4ABE, 0x52DE, 0x52DE, 0x52DD, 0x52DD, 0x52DD, 
        0x52DD, 0x52DD, 0x52DD, 0x52DE, 0x52DE, 0x52DE, 0x4A9E, 0x3A1D, 0x39DD, 0x39FD, 0x421D, 0x423D, 0x4A7E, 0x4A9E, 0x4ABE, 0x4ABD, 0x4ABD, 0x4ABE, 0x52BD, 0x52BD, 0x4A9D, 0x4A7D, 0x425D, 0x425D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A7D, 0x527D, 0x52BD, 
        0x52BD, 0x529C, 0x529C, 0x5A9B, 0x5ADB, 0x5AD9, 0x73BA, 0x849A, 0x84B7, 0x84F5, 0x8534, 0x7CF1, 0x5C4D, 0x544C, 0x542B, 0x4C2B, 0x4C2B, 0x4C0A, 0x4BEA, 0x43C9, 0x4389, 0x3B68, 0x3B28, 0x3309, 0x3AEA, 0x3AEB, 0x3AAA, 0x2229, 0x2228, 0x2A68, 
        0x3AE9, 0x4329, 0x4B69, 0x4B69, 0x5389, 0x5BA9, 0x5BA9, 0x63C9, 0x63CA, 0x63EA, 0x63EA, 0x63CA, 0x63CA, 0x63C9, 0x63EA, 0x63EA, 0x63EA, 0x63C9, 0x63C9, 0x6BCA, 0x63EA, 0x6BEA, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BE9, 
        0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BE9, 0x63C9, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x5BEA, 0x5BEA, 0x5BEA, 0x640B, 0x5C0A, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEA, 0x53CA, 0x53CB, 0x5BEB, 0x5BEB, 0x5BCB, 0x5BCA, 0x5BAA, 0x5BAA, 
        0x5B8B, 0x538A, 0x536A, 0x536B, 0x538B, 0x538B, 0x4BAB, 0x4BAB, 0x43AB, 0x43AB, 0x438B, 0x3B8A, 0x3B8A, 0x3BAA, 0x3BAA, 0x43AB, 0x4BCB, 0x43EA, 0x43CA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4C0A, 0x43EA, 0x43EA, 0x3BCA, 0x3BCA, 0x3BCA, 
        0x3BCA, 0x43EB, 0x4C0C, 0x440C, 0x3BEB, 0x33CA, 0x33CA, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C29, 0x2409, 0x2BE9, 0x33EA, 0x3BEA, 0x4C0B, 0x4BEA, 0x4BC9, 
        0x4BC8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C7, 0x43A7, 0x3B87, 0x3B67, 0x3347, 0x3B48, 0x3B48, 0x3B28, 0x22A6, 0x2266, 0x1A45, 0x1A25, 0x1204, 0x11E4, 0x11E4, 0x1204, 0x1A04, 0x1A24, 0x1A45, 0x1A65, 0x22A6,
  0x4C4A, 0x444A, 0x44A9, 0x3CE9, 0x3CE9, 0x3D09, 0x3CE9, 0x450A, 0x552B, 0x5D4B, 0x5D4C, 0x5D4C, 0x5D2D, 0x5D2D, 0x5D0C, 0x5CEC, 0x64EC, 0x64ED, 0x6D0E, 0x6CCD, 0x64AC, 0x6CAC, 0x74CC, 0x850E, 0x84CD, 0x84EE, 0x8D2F, 0x9570, 0x9571, 0x7CCF, 0x748E, 
        0x6CAE, 0x64CD, 0x5CAC, 0x5CAC, 0x5CCC, 0x64CC, 0x64ED, 0x6D0D, 0x7D2E, 0x8D8F, 0x95B0, 0x9DB0, 0x9DB1, 0xA5B1, 0x9D91, 0x8D50, 0x7CEF, 0x74AE, 0x6C6C, 0x6C8D, 0x74CD, 0x74ED, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x856E, 
        0x856E, 0x858E, 0x856E, 0x7D6E, 0x7D4E, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D4D, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854E, 0x854E, 0x854E, 0x854D, 0x854D, 0x854D, 0x854D, 0x854E, 0x854E, 0x854E, 0x854E, 0x8D4E, 0x8D4E, 0x8D4E, 0x8D4E, 0x8D4E, 0x956E, 0x956E, 0x954E, 0x9D4E, 0x950E, 0x94EE, 0x8CCE, 0x84AE, 0x7C6D, 
        0x6C0C, 0x5B8A, 0x5369, 0x4B69, 0x4B68, 0x4B87, 0x4B87, 0x4BA7, 0x4BA7, 0x4BA7, 0x4387, 0x4367, 0x4367, 0x4368, 0x4BA9, 0x53CA, 0x53EA, 0x5409, 0x5409, 0x5409, 0x5C09, 0x5C09, 0x6409, 0x642A, 0x6C2A, 0x6C4A, 0x744A, 0x7C4A, 0x744B, 0x744B, 
        0x744B, 0x742B, 0x742B, 0x742B, 0x742B, 0x740C, 0x740C, 0x844E, 0x84B0, 0x7C8F, 0x742C, 0x740B, 0x742B, 0x742B, 0x7C2B, 0x7C4B, 0x7C6B, 0x7C6B, 0x744B, 0x6C0A, 0x6C2B, 0x7C4B, 0x94CD, 0xA4ED, 0xA50D, 0xA50D, 0xA4ED, 0x946B, 0x7388, 0x7368, 
        0x73AA, 0x73CB, 0x6C0C, 0x640D, 0x5C0D, 0x540D, 0x4BED, 0x43ED, 0x43ED, 0x43CD, 0x438D, 0x3B0D, 0x328D, 0x324F, 0x3A31, 0x4233, 0x4214, 0x41F4, 0x39D4, 0x39B3, 0x3173, 0x2952, 0x3172, 0x3173, 0x3173, 0x3174, 0x3975, 0x3976, 0x3976, 0x3177, 
        0x3177, 0x3177, 0x3177, 0x3998, 0x3998, 0x3998, 0x3198, 0x3999, 0x3198, 0x3198, 0x3199, 0x3999, 0x3999, 0x3199, 0x3199, 0x3999, 0x39B9, 0x31BA, 0x319B, 0x319C, 0x299C, 0x29DD, 0x31FD, 0x321D, 0x3A3D, 0x3A7D, 0x42BE, 0x4ABE, 0x4ABE, 0x4ABE, 
        0x4ADE, 0x4AFE, 0x4AFD, 0x4AFD, 0x531E, 0x52FE, 0x4AFE, 0x4AFE, 0x42FE, 0x42DE, 0x42DD, 0x3ADE, 0x3ADE, 0x3ADE, 0x42DD, 0x42DD, 0x42FE, 0x42FE, 0x42FD, 0x42DD, 0x42DD, 0x42DD, 0x42BD, 0x42DD, 0x4ADD, 0x4ADE, 0x4ADD, 0x52FD, 0x52FD, 0x52FE, 
        0x52FE, 0x52DE, 0x52DD, 0x52DD, 0x52FE, 0x52FE, 0x52FE, 0x4ABE, 0x39DC, 0x39BD, 0x39DD, 0x3A1D, 0x423D, 0x4A7E, 0x4A9E, 0x4ABD, 0x4ABD, 0x4A9D, 0x529D, 0x529D, 0x4A9D, 0x4A7D, 0x427D, 0x425D, 0x4A7D, 0x4A7D, 0x4A9D, 0x4A7D, 0x4A7C, 0x529C, 
        0x529C, 0x529B, 0x529B, 0x5AFA, 0x739B, 0x9CFD, 0xA59D, 0x9D78, 0x9555, 0x8D32, 0x8D52, 0x750F, 0x544C, 0x4C4B, 0x440A, 0x4C0A, 0x4C0A, 0x4C0A, 0x43EA, 0x43C9, 0x4388, 0x3B68, 0x3B48, 0x3328, 0x3B09, 0x3AE9, 0x3ACB, 0x326A, 0x2209, 0x2A49, 
        0x32C9, 0x4329, 0x4349, 0x4B69, 0x5369, 0x5BA9, 0x5BA9, 0x5BA9, 0x63CA, 0x63CA, 0x63CA, 0x63CA, 0x63CA, 0x63E9, 0x63EA, 0x63EA, 0x63EA, 0x63C9, 0x6BCA, 0x6BEA, 0x6BEA, 0x6C0A, 0x740B, 0x742B, 0x740A, 0x740B, 0x6BEA, 0x6BEA, 0x6BEA, 0x73EA, 
        0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x640A, 0x642B, 0x640B, 0x63EA, 0x63EA, 0x5BEA, 0x5BEA, 0x5BEA, 0x5BEB, 0x5BCB, 0x5BCA, 0x53CA, 0x5BCA, 0x5BCA, 0x5BCA, 0x53AA, 0x53AA, 0x53AA, 
        0x538A, 0x536A, 0x4B6A, 0x4B4A, 0x536A, 0x538B, 0x538B, 0x538B, 0x4B8B, 0x4BAC, 0x4BAC, 0x438B, 0x3B8B, 0x3B8A, 0x3BAA, 0x43AB, 0x43CB, 0x43CA, 0x43CA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4BEA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4BEA, 0x43EA, 0x3BCA, 0x3BCA, 
        0x43CA, 0x43EB, 0x4C2C, 0x4C0C, 0x3BCA, 0x33CA, 0x2BCA, 0x2BC9, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x2408, 0x2409, 0x3409, 0x3C0A, 0x440B, 0x4C0A, 0x43C9, 
        0x4BC8, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C8, 0x43A7, 0x3B87, 0x3B67, 0x4368, 0x4BCA, 0x5C2C, 0x4BCB, 0x32E7, 0x2246, 0x1A25, 0x1205, 0x11E4, 0x11C4, 0x11C4, 0x11E4, 0x1204, 0x1A24, 0x1A45, 0x1A65, 0x22A6,
  0x4C4A, 0x4429, 0x3C68, 0x3CC8, 0x3CE9, 0x3D09, 0x3D09, 0x452A, 0x4D2B, 0x4D4C, 0x554C, 0x5D4C, 0x5D4C, 0x5D2D, 0x5D2D, 0x650D, 0x650E, 0x64ED, 0x64CD, 0x64AD, 0x6C8C, 0x6C8C, 0x74AC, 0x6C6C, 0x6C2B, 0x7C8D, 0x8D0F, 0x9DB1, 0x9592, 0x84F0, 0x74AE, 
        0x6CAE, 0x64CD, 0x5CAC, 0x5CAC, 0x5CCC, 0x64ED, 0x6CED, 0x750E, 0x7D4E, 0x8D6F, 0x958F, 0x9590, 0x9590, 0x9590, 0x852F, 0x74CE, 0x6C6D, 0x646C, 0x646C, 0x6CAC, 0x74ED, 0x750D, 0x7D2D, 0x7D4D, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x856E, 
        0x856E, 0x856E, 0x856E, 0x7D4E, 0x7D4E, 0x7D4D, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4D, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4E, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x852E, 0x852E, 0x854E, 0x854E, 0x854E, 0x856D, 0x854D, 0x854D, 0x8D4D, 0x8D4D, 0x8D4E, 0x8D4E, 0x8D4E, 0x954E, 0x8D4E, 0x954E, 0x954E, 0x954E, 0x954E, 0x9D4E, 0x9D4F, 0x9D2F, 0x94AE, 0x8C6D, 0x846E, 0x7C4E, 0x63AB, 
        0x5349, 0x4B68, 0x4B68, 0x4B68, 0x4B87, 0x4B87, 0x43A6, 0x4BA6, 0x43A6, 0x43A6, 0x4386, 0x4366, 0x4347, 0x4347, 0x4389, 0x4BC9, 0x4BE9, 0x4BE9, 0x4C09, 0x5409, 0x5409, 0x5C09, 0x5C09, 0x6429, 0x6429, 0x6C2A, 0x742A, 0x744A, 0x742B, 0x742A, 
        0x744B, 0x742B, 0x742B, 0x740B, 0x7C4D, 0x844E, 0x844F, 0x8470, 0x8490, 0x742D, 0x740C, 0x740B, 0x742B, 0x742A, 0x7C4B, 0x7C4B, 0x7C6B, 0x746B, 0x744A, 0x640A, 0x6C2B, 0x744B, 0x94CD, 0xA4ED, 0xA4ED, 0xA4ED, 0x9CCD, 0x9CCD, 0x948D, 0x842B, 
        0x7C0C, 0x7C0C, 0x740D, 0x6C2D, 0x642D, 0x540D, 0x4C0D, 0x4C2C, 0x440C, 0x43EC, 0x3BCC, 0x3B8D, 0x3B2D, 0x3ACD, 0x3A6E, 0x3A31, 0x4212, 0x4214, 0x39F4, 0x39B3, 0x3193, 0x3153, 0x3152, 0x3973, 0x3993, 0x3152, 0x3174, 0x3975, 0x3976, 0x3976, 
        0x3976, 0x3177, 0x3197, 0x3197, 0x3998, 0x3998, 0x3998, 0x3998, 0x3999, 0x3999, 0x3999, 0x39B9, 0x39B9, 0x31B9, 0x3199, 0x39B9, 0x39B9, 0x39BA, 0x31BA, 0x319B, 0x299C, 0x299C, 0x319C, 0x31BD, 0x31FD, 0x3A3D, 0x425D, 0x427E, 0x4A9E, 0x4ABE, 
        0x4ADE, 0x4ADE, 0x4ADE, 0x52FE, 0x52FE, 0x52FE, 0x4AFE, 0x4AFE, 0x42FE, 0x42DD, 0x42DD, 0x3ADE, 0x3ADE, 0x3ADE, 0x42DD, 0x42DD, 0x42FE, 0x4B1E, 0x4AFD, 0x42FE, 0x42FD, 0x42DD, 0x42DD, 0x42BD, 0x42DE, 0x4ADD, 0x4ADE, 0x52FE, 0x52FE, 0x52FD, 
        0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FD, 0x52FE, 0x531E, 0x531E, 0x427D, 0x31DD, 0x39FD, 0x39FD, 0x3A3D, 0x425D, 0x427D, 0x4A7D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A9D, 0x4A7D, 0x427D, 0x425C, 0x425C, 0x427C, 0x4A7C, 0x4A7C, 0x4A7C, 0x4A7B, 0x4A9B, 
        0x4ABA, 0x52F9, 0x6BBA, 0x8CBC, 0xA59D, 0xB63D, 0xBE7B, 0xA616, 0x9593, 0x8D51, 0x8D71, 0x74EE, 0x4C2B, 0x442A, 0x442A, 0x440A, 0x4C0A, 0x4C0A, 0x43E9, 0x43A9, 0x3B88, 0x3B68, 0x3B48, 0x3327, 0x3308, 0x32C8, 0x2A48, 0x2209, 0x21E9, 0x2A29, 
        0x328A, 0x3B0A, 0x4349, 0x4B49, 0x4B69, 0x53A9, 0x5BA9, 0x5BA9, 0x5BA9, 0x63C9, 0x63CA, 0x63CA, 0x63EA, 0x63E9, 0x63E9, 0x63E9, 0x63EA, 0x6BCA, 0x6BEA, 0x73EA, 0x740A, 0x740A, 0x742B, 0x7C4B, 0x7C2B, 0x740B, 0x740A, 0x740A, 0x740A, 0x73EA, 
        0x73EA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x6C0A, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63CA, 0x63EB, 0x640B, 0x5BEA, 0x5BCA, 0x5BCA, 0x5BCA, 0x53CA, 0x53CA, 0x53CA, 0x53AA, 0x53AA, 
        0x538A, 0x53AA, 0x538A, 0x538A, 0x538A, 0x5BAB, 0x5BAB, 0x5B8B, 0x538B, 0x538B, 0x538C, 0x4BAC, 0x43AC, 0x3BAB, 0x3BAB, 0x3B8A, 0x3BAA, 0x43AA, 0x43AA, 0x4BEA, 0x4BEA, 0x4C0A, 0x4BEA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4BEA, 0x43EA, 0x43CA, 0x43CA, 
        0x43CA, 0x4BEB, 0x4C2C, 0x4C0C, 0x3BCA, 0x2BCA, 0x2BCA, 0x2BC9, 0x2BE9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2409, 0x2409, 0x2409, 0x1C09, 0x1C08, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x2428, 0x2408, 0x2C09, 0x342A, 0x442A, 0x440A, 0x43C9, 
        0x43C8, 0x43E8, 0x43E8, 0x43E7, 0x4C08, 0x4C08, 0x4BE8, 0x43C8, 0x43A8, 0x3BA8, 0x3B88, 0x4388, 0x53EA, 0x6C6D, 0x6CAE, 0x5C2C, 0x3B08, 0x2246, 0x1A05, 0x11E5, 0x11C4, 0x11C4, 0x11C4, 0x11E4, 0x1A04, 0x1A24, 0x1A45, 0x2285, 0x22A6,
  0x4C2A, 0x4409, 0x4428, 0x3C68, 0x3CA9, 0x3CE9, 0x3D09, 0x452A, 0x4D4B, 0x4D4B, 0x554C, 0x554C, 0x5D4D, 0x654D, 0x654E, 0x6D2E, 0x6D2E, 0x6CEE, 0x64CD, 0x64AD, 0x648C, 0x6C8C, 0x6C6C, 0x6C6C, 0x6C4C, 0x84EF, 0x9D90, 0xA5F3, 0x95B2, 0x8510, 0x7CAF, 
        0x6CAE, 0x6CCD, 0x64AD, 0x5CCC, 0x64ED, 0x64ED, 0x6D0D, 0x752E, 0x854F, 0x8D90, 0x9DD1, 0x9591, 0x8D70, 0x852F, 0x74AD, 0x646C, 0x644C, 0x648C, 0x6CAD, 0x6CED, 0x750D, 0x752D, 0x754E, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x856E, 
        0x856E, 0x856E, 0x854E, 0x854E, 0x7D4D, 0x7D2D, 0x7D4D, 0x854E, 0x854E, 0x7D4E, 0x7D4E, 0x854E, 0x7D4E, 0x7D2E, 0x854E, 0x854E, 0x854E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x7D2D, 0x852E, 0x854E, 0x854E, 0x8D4E, 0x854E, 0x8D4D, 0x8D4D, 0x8D4E, 0x8D4E, 0x954E, 0x954E, 0x954E, 0x954E, 0x954E, 0x954E, 0x954E, 0x954E, 0x954E, 0x9D2E, 0x9D0E, 0x9D0F, 0x9CEF, 0x948E, 0x8C4E, 0x73ED, 0x638B, 0x5349, 
        0x4B28, 0x4B67, 0x4B67, 0x4367, 0x4387, 0x4386, 0x43A6, 0x43A6, 0x43A6, 0x43A6, 0x4386, 0x4366, 0x4346, 0x3B47, 0x4347, 0x4BC9, 0x43C9, 0x43E9, 0x4BE9, 0x4C09, 0x5409, 0x5409, 0x5409, 0x5C09, 0x6429, 0x6C2A, 0x6C2A, 0x742B, 0x742B, 0x6C2B, 
        0x742B, 0x742B, 0x740B, 0x740C, 0x73CC, 0x7C2E, 0x8C91, 0x8491, 0x8490, 0x742C, 0x742C, 0x742B, 0x742B, 0x742A, 0x7C4A, 0x7C4A, 0x7C4A, 0x744B, 0x6C4A, 0x63EA, 0x640A, 0x744B, 0x94AC, 0x9CED, 0xA4ED, 0x9CED, 0x9CCC, 0x9CEE, 0x9CCE, 0x9CEF, 
        0x94EF, 0x94EF, 0x8CCF, 0x84EF, 0x7CEF, 0x74EF, 0x6CEF, 0x64CE, 0x5C8E, 0x43EB, 0x3B8A, 0x336B, 0x3B4B, 0x3B0C, 0x32CC, 0x322E, 0x3A10, 0x3A12, 0x39F3, 0x39B3, 0x3193, 0x3193, 0x3152, 0x3972, 0x3993, 0x3152, 0x3132, 0x3154, 0x3155, 0x3976, 
        0x3176, 0x3177, 0x3997, 0x3997, 0x3998, 0x3998, 0x3998, 0x3999, 0x39B9, 0x3999, 0x3999, 0x39B9, 0x39B9, 0x39B9, 0x3999, 0x39B9, 0x39B9, 0x39B9, 0x39BA, 0x31BA, 0x319B, 0x319B, 0x319C, 0x319C, 0x31BC, 0x31FD, 0x39FD, 0x423D, 0x425D, 0x425D, 
        0x423D, 0x3A1C, 0x3A1C, 0x3A1C, 0x425D, 0x4ABE, 0x4ABE, 0x4ABE, 0x42BE, 0x3A9E, 0x3ABE, 0x3ABD, 0x3ABE, 0x3ABE, 0x42BD, 0x42DD, 0x42DE, 0x4B1E, 0x4B1E, 0x42FE, 0x42DD, 0x42FD, 0x42DD, 0x3ABD, 0x42DD, 0x42DD, 0x42BD, 0x4ADE, 0x52FE, 0x52FE, 
        0x52DE, 0x52DD, 0x52DD, 0x52DD, 0x52FD, 0x531E, 0x531E, 0x531E, 0x4ABD, 0x297B, 0x423E, 0x423D, 0x425D, 0x425D, 0x425D, 0x425D, 0x427D, 0x427D, 0x427D, 0x4A7D, 0x4A7D, 0x4A5C, 0x425C, 0x423B, 0x425B, 0x4A7B, 0x4A9B, 0x4A9A, 0x52B9, 0x5B19, 
        0x6BBA, 0x7C9A, 0x8D1A, 0x9D9B, 0xAE1B, 0xBE9A, 0xC6D9, 0xAE56, 0x9DD3, 0x9591, 0x8D91, 0x752F, 0x4C4B, 0x442A, 0x442A, 0x444A, 0x442A, 0x440A, 0x43C9, 0x3BA8, 0x3B88, 0x3368, 0x3347, 0x3327, 0x3328, 0x3B09, 0x3AE9, 0x3AAB, 0x326A, 0x2A29, 
        0x3269, 0x3AC9, 0x4309, 0x4349, 0x4B49, 0x5389, 0x5BA9, 0x5BA9, 0x5BA9, 0x63A9, 0x63C9, 0x63CA, 0x63CA, 0x63E9, 0x63E9, 0x6BEA, 0x6BEA, 0x6BEA, 0x73EA, 0x740B, 0x7C0B, 0x7C0B, 0x7C2B, 0x844C, 0x7C2B, 0x740B, 0x7C0B, 0x740B, 0x73EA, 0x73EA, 
        0x73EA, 0x73EA, 0x73EA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63EA, 0x63EA, 0x63EA, 0x6BEA, 0x6BCA, 0x6BEA, 0x6BEA, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63CA, 0x63CA, 0x5BCA, 0x5BCA, 0x5BCA, 0x63EA, 0x642B, 0x5BEA, 0x5BCA, 0x5BCA, 0x5BCA, 
        0x5BCA, 0x5BCA, 0x5BAA, 0x5BAA, 0x5BAB, 0x63CB, 0x63AB, 0x5BAB, 0x5B8B, 0x5BAB, 0x5BAC, 0x53AC, 0x4BAC, 0x43AC, 0x43AC, 0x3B8B, 0x3BAA, 0x3B8A, 0x3BAA, 0x43CA, 0x43EA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4BEA, 0x43EA, 0x43EA, 0x43CA, 
        0x43CA, 0x4BEB, 0x4C0C, 0x4C0C, 0x3BEA, 0x33CA, 0x2BCA, 0x2BC9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2409, 0x2C0A, 0x2409, 0x2409, 0x2409, 0x2408, 0x1C08, 0x1C08, 0x1C28, 0x1C28, 0x2428, 0x2408, 0x2C29, 0x3C2A, 0x442A, 0x440A, 0x43C8, 
        0x43C8, 0x43C7, 0x43E7, 0x43E7, 0x43E7, 0x43E8, 0x43E8, 0x43C8, 0x43A8, 0x3BA8, 0x43A8, 0x4BEA, 0x644C, 0x74AD, 0x74AE, 0x642C, 0x3B28, 0x2246, 0x1A05, 0x11E4, 0x11C4, 0x11C4, 0x11C4, 0x11C4, 0x1A04, 0x1A25, 0x2265, 0x2285, 0x22C6,
  0x4C0A, 0x4C2A, 0x4C29, 0x4448, 0x4489, 0x44C9, 0x44EA, 0x450A, 0x4D2B, 0x4D4C, 0x554C, 0x552C, 0x5D4D, 0x654E, 0x6D4F, 0x6D2E, 0x6D0E, 0x64ED, 0x64CD, 0x64AD, 0x648C, 0x648C, 0x648C, 0x6C6C, 0x748D, 0x8D2F, 0x95B1, 0x9DD2, 0x9592, 0x8511, 0x7CCF, 
        0x6CAE, 0x6CCD, 0x64CD, 0x64CD, 0x6CED, 0x6D0D, 0x752E, 0x7D70, 0x8590, 0x8DD1, 0x95D1, 0x8D70, 0x850F, 0x74AE, 0x644C, 0x644C, 0x64AD, 0x6CCD, 0x6CED, 0x750D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x856E, 
        0x856E, 0x856E, 0x856E, 0x854E, 0x854D, 0x7D4D, 0x854E, 0x854E, 0x854E, 0x856E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x7D2D, 0x7D2D, 0x852E, 0x852E, 0x8D4E, 0x8D4E, 0x852D, 0x8D2D, 0x8D4D, 0x954D, 0x954E, 0x954E, 0x954E, 0x9D4E, 0x9D4E, 0x9D4E, 0x9D4E, 0x9D4E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D0E, 0x9CEE, 0x9CCE, 0x8C6E, 0x844E, 0x6BAB, 0x5329, 0x4B08, 0x4B48, 
        0x4347, 0x4367, 0x4366, 0x4366, 0x4386, 0x4386, 0x43A5, 0x43A6, 0x43A6, 0x4386, 0x4366, 0x4366, 0x3B46, 0x3B26, 0x3B27, 0x43A9, 0x43CA, 0x43C9, 0x43E9, 0x4BE9, 0x4C09, 0x5409, 0x5429, 0x5409, 0x5C09, 0x640A, 0x6C2A, 0x6C2A, 0x6C2B, 0x742B, 
        0x744C, 0x7C4D, 0x73EC, 0x7C4D, 0x846F, 0x8CD1, 0x7C30, 0x7C2F, 0x7C4F, 0x742C, 0x742B, 0x742B, 0x742B, 0x744B, 0x7C4B, 0x7C4A, 0x7C4A, 0x744B, 0x6C2A, 0x63EA, 0x640A, 0x744B, 0x94AC, 0xA50D, 0xA4ED, 0x9CED, 0x9CCC, 0x9CED, 0xA4EE, 0xA50F, 
        0x9D2F, 0x9D0F, 0x950F, 0x950F, 0x8D0F, 0x8D0F, 0x850F, 0x7CEF, 0x74CE, 0x648E, 0x4BEB, 0x3B6A, 0x3B4A, 0x332A, 0x3B0B, 0x3AAC, 0x3A6E, 0x3A30, 0x3A12, 0x39F3, 0x39B3, 0x39B3, 0x3993, 0x3972, 0x3972, 0x3152, 0x3132, 0x2933, 0x3134, 0x3155, 
        0x3976, 0x3976, 0x3997, 0x3997, 0x3998, 0x3998, 0x3998, 0x3999, 0x3998, 0x39B9, 0x3999, 0x39B9, 0x39B9, 0x3999, 0x3999, 0x39B9, 0x39B9, 0x3999, 0x39B9, 0x39B9, 0x31BA, 0x31BA, 0x31BB, 0x31BB, 0x31BB, 0x31DC, 0x31DC, 0x31DC, 0x31BC, 0x31DC, 
        0x31BC, 0x31DC, 0x31BC, 0x31BC, 0x31DC, 0x423D, 0x425D, 0x3A5D, 0x3A5D, 0x3A5D, 0x325D, 0x327D, 0x3A7D, 0x3A9E, 0x3A9D, 0x3A9D, 0x42BD, 0x42FE, 0x4AFE, 0x4ADE, 0x42DE, 0x42DE, 0x42BE, 0x3A9D, 0x3A7D, 0x3A7D, 0x29BA, 0x31DA, 0x52DE, 0x52FE, 
        0x52DE, 0x52DD, 0x4ADD, 0x52DD, 0x52FD, 0x52FE, 0x531E, 0x531E, 0x52BE, 0x295A, 0x31DC, 0x4A7E, 0x4A9E, 0x4A9E, 0x4A9E, 0x4A9D, 0x4A7D, 0x4A7D, 0x425C, 0x427C, 0x4A7B, 0x427B, 0x425A, 0x425A, 0x4259, 0x4A79, 0x4AB9, 0x5319, 0x6BB9, 0x7C9A, 
        0x8519, 0x8D58, 0x9597, 0xA5F8, 0xB658, 0xBEB8, 0xC719, 0xB676, 0xA613, 0x9DD2, 0x95D2, 0x8590, 0x546B, 0x442A, 0x3C2A, 0x446A, 0x444A, 0x4409, 0x3BC9, 0x3BA8, 0x3388, 0x3367, 0x3347, 0x3347, 0x3B47, 0x3B28, 0x3B09, 0x3B0A, 0x430B, 0x3AEB, 
        0x2A49, 0x2A48, 0x3288, 0x3AE9, 0x4B29, 0x4B69, 0x5389, 0x5389, 0x5BA9, 0x5BA9, 0x63CA, 0x63CA, 0x63C9, 0x63EA, 0x63EA, 0x6BEA, 0x6BEA, 0x6BEA, 0x740B, 0x7C0B, 0x7C2B, 0x7C2B, 0x7C2C, 0x7C2B, 0x7C0B, 0x842C, 0x844C, 0x7C2B, 0x7BEB, 0x7BEA, 
        0x73CA, 0x73CA, 0x73CA, 0x73EA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BCA, 0x6BCA, 0x6BEA, 0x6BEB, 0x63EA, 0x63CA, 0x63CA, 0x63AA, 0x63A9, 0x5BAA, 0x63EB, 0x63EA, 0x63EB, 0x63EB, 0x63CA, 
        0x63CB, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63CB, 0x63CA, 0x63AA, 0x5BAA, 0x5BCB, 0x5BCB, 0x5BCB, 0x53CC, 0x4BAC, 0x4BCC, 0x4BCC, 0x43EC, 0x3BCB, 0x3BAA, 0x3BCA, 0x3BCA, 0x43CA, 0x4BCA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BCA, 
        0x43CA, 0x4BEB, 0x4BEB, 0x4C0C, 0x3BEA, 0x33CA, 0x2BCA, 0x2BC9, 0x23C9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x23E9, 0x2C0A, 0x2C09, 0x2409, 0x2409, 0x2408, 0x1C08, 0x1C28, 0x2428, 0x2428, 0x2428, 0x2408, 0x2C29, 0x3C4A, 0x444B, 0x4C4A, 0x43E8, 
        0x3BA7, 0x43C7, 0x43E7, 0x43E7, 0x43E7, 0x43E8, 0x43E8, 0x43E8, 0x43E9, 0x4BE9, 0x53EA, 0x644B, 0x6C6C, 0x7CAD, 0x7CAE, 0x642C, 0x3B08, 0x2246, 0x1A05, 0x11E5, 0x11C4, 0x11C4, 0x11C4, 0x11E4, 0x1A05, 0x1A45, 0x2265, 0x22A6, 0x2AC6,
  0x540A, 0x6CAD, 0x5C8B, 0x4C69, 0x4C89, 0x4CAA, 0x4CCA, 0x4D0B, 0x4D0B, 0x4D0B, 0x550C, 0x550C, 0x5D0C, 0x650D, 0x64ED, 0x64CD, 0x64CD, 0x64AD, 0x64AD, 0x64AD, 0x64AC, 0x64AC, 0x648C, 0x6C8C, 0x74AD, 0x850E, 0x9590, 0x95D1, 0x9591, 0x8531, 0x7CF0, 
        0x6CAE, 0x6CCD, 0x6CCD, 0x6CED, 0x6CEE, 0x752E, 0x85B1, 0x8DF2, 0x8DD2, 0x85B1, 0x8570, 0x7D2F, 0x6CCE, 0x646C, 0x5C6C, 0x648C, 0x6CED, 0x6D0D, 0x6D0D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854D, 0x856E, 
        0x856E, 0x856E, 0x856D, 0x7D6D, 0x7D4D, 0x7D4D, 0x856E, 0x856E, 0x856E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 
        0x852D, 0x852E, 0x852E, 0x8D2E, 0x8D4E, 0x8D4E, 0x952E, 0x954E, 0x9D4E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D4E, 0xA54E, 0xA54E, 0xA54E, 0xA54E, 0xA54E, 0xA52E, 0xA52E, 0x9D0E, 0x9CCE, 0x9CAE, 0x8C6E, 0x7BEC, 0x636A, 0x5308, 0x4B08, 0x4327, 0x4347, 
        0x4347, 0x4366, 0x3B66, 0x4386, 0x3B86, 0x3B86, 0x3BA6, 0x4386, 0x4386, 0x4366, 0x3B66, 0x4346, 0x3B26, 0x3B06, 0x3B06, 0x3B68, 0x43CA, 0x43CA, 0x43E9, 0x43E9, 0x4BE9, 0x4C0A, 0x540A, 0x540A, 0x53EA, 0x5BEA, 0x640A, 0x6C0B, 0x740B, 0x740C, 
        0x7C2D, 0x7C2D, 0x8C8F, 0x9511, 0x9D33, 0x94F3, 0x740F, 0x7C4F, 0x742D, 0x742C, 0x742B, 0x742B, 0x744B, 0x744B, 0x7C4B, 0x7C4A, 0x7C2A, 0x742A, 0x6C2A, 0x640A, 0x640A, 0x742B, 0x8CAC, 0x9D0D, 0xA50D, 0x9CCC, 0x9CED, 0x9CED, 0xA50E, 0xA52E, 
        0xA52E, 0xA52E, 0xA52E, 0x9D2E, 0x9D0E, 0x94EE, 0x8CEE, 0x8CEE, 0x7CCD, 0x6C8D, 0x540B, 0x4BCB, 0x4BEB, 0x438B, 0x3B0A, 0x3B0B, 0x42EC, 0x3A8E, 0x3A4F, 0x3A11, 0x39D2, 0x39B3, 0x39B3, 0x39B3, 0x3972, 0x3172, 0x3152, 0x3133, 0x3133, 0x3154, 
        0x3175, 0x3976, 0x3996, 0x3997, 0x3997, 0x3177, 0x3197, 0x3998, 0x3998, 0x39B8, 0x3998, 0x3198, 0x39B9, 0x3999, 0x3998, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x31B9, 0x31B9, 0x31B9, 0x39BA, 0x39DA, 0x39DB, 0x31DB, 0x31BB, 0x31BB, 0x31BB, 0x31BB, 
        0x31BB, 0x39BC, 0x31DC, 0x39DC, 0x39FC, 0x3A1D, 0x39FD, 0x31FD, 0x31FD, 0x31FD, 0x31FD, 0x321D, 0x321D, 0x321D, 0x321C, 0x321C, 0x321C, 0x323C, 0x3A5D, 0x3A3D, 0x3A3D, 0x427D, 0x323D, 0x29DB, 0x21BB, 0x219A, 0x217A, 0x29BA, 0x52DE, 0x52DE, 
        0x52DE, 0x4ABD, 0x4ABD, 0x4ADD, 0x52FE, 0x52FE, 0x531E, 0x5B1E, 0x52BD, 0x297A, 0x297A, 0x427D, 0x52BE, 0x52BE, 0x52BD, 0x52BD, 0x52BD, 0x52BD, 0x4A9C, 0x4A5B, 0x4A7A, 0x4279, 0x4A98, 0x4A97, 0x4A96, 0x5B17, 0x6BD8, 0x7C59, 0x84D7, 0x8D37, 
        0x8D76, 0x8D95, 0x95D5, 0xA636, 0xAE76, 0xBEB7, 0xC6F8, 0xBEB7, 0xAE13, 0x9DD2, 0x9DD2, 0x8DD1, 0x64AD, 0x444A, 0x3C4A, 0x3C4A, 0x444A, 0x3C09, 0x3BC8, 0x3B88, 0x3367, 0x3347, 0x3347, 0x3347, 0x3B47, 0x3B47, 0x3B48, 0x3B48, 0x4349, 0x434B, 
        0x430B, 0x326A, 0x3269, 0x3AA9, 0x3AE8, 0x4B28, 0x4B49, 0x5369, 0x5B89, 0x5B89, 0x5BA9, 0x5BA9, 0x63A9, 0x63C9, 0x63C9, 0x63EA, 0x6BEA, 0x6BEA, 0x73EA, 0x7C0B, 0x844C, 0x844C, 0x842C, 0x7C2B, 0x842C, 0x842C, 0x8C6D, 0x844C, 0x7BEB, 0x842C, 
        0x842C, 0x842C, 0x7BEB, 0x73EA, 0x73EA, 0x6BEA, 0x73EA, 0x73EA, 0x73EA, 0x6BEA, 0x6BEA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x6BCA, 0x6BCA, 0x6BEB, 0x740B, 0x6BEB, 0x6BCA, 0x6BCA, 0x6BAA, 0x6BAA, 0x6BCA, 0x6BEB, 0x6BEA, 0x6BEA, 0x73EB, 0x6BEA, 
        0x6BCA, 0x6BCA, 0x6BEA, 0x6BEB, 0x6BEA, 0x6BEA, 0x63CA, 0x63CA, 0x63CA, 0x63CB, 0x5BEB, 0x5BEB, 0x5BCB, 0x5BCB, 0x53CB, 0x53CC, 0x4BCC, 0x4BEC, 0x43CC, 0x3BAB, 0x3BAA, 0x3BAA, 0x43CA, 0x4BCA, 0x4C0B, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4BEA, 
        0x4BCA, 0x4BEA, 0x4BEB, 0x4C0C, 0x3BEB, 0x33CA, 0x2BCA, 0x2BE9, 0x2BE9, 0x23E9, 0x23E9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C0A, 0x2C09, 0x23E9, 0x23E9, 0x2408, 0x2428, 0x2428, 0x2428, 0x2428, 0x2428, 0x2428, 0x2C29, 0x3C4A, 0x4C6B, 0x546B, 0x43E9, 
        0x3BA7, 0x43C7, 0x43C7, 0x43E7, 0x43E7, 0x43E8, 0x43E8, 0x43E9, 0x542A, 0x5C4B, 0x6C4C, 0x746C, 0x748D, 0x7CAD, 0x7CAD, 0x640B, 0x3B07, 0x2245, 0x1A05, 0x19E5, 0x11E4, 0x19C4, 0x19E4, 0x19E4, 0x2225, 0x2245, 0x2286, 0x2AA6, 0x2AE7,
  0x648C, 0x7D2F, 0x750E, 0x546B, 0x546A, 0x4C8A, 0x4CAA, 0x54CB, 0x4CCB, 0x4CCB, 0x4CCB, 0x4CAB, 0x54AB, 0x54AC, 0x5C8C, 0x648D, 0x64AD, 0x64CD, 0x64CD, 0x64AD, 0x64CD, 0x64AC, 0x64AD, 0x6CAC, 0x6CAC, 0x74CD, 0x8D6F, 0x95B1, 0x8D91, 0x8D52, 0x7CD0, 
        0x6C8E, 0x6CCD, 0x6CED, 0x6CEE, 0x750E, 0x7D90, 0x9633, 0x9E33, 0x9613, 0x8DB1, 0x7D50, 0x750E, 0x64AD, 0x648C, 0x64AD, 0x6CED, 0x6D0D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x752D, 0x7D2D, 0x7D2D, 0x7D4D, 0x854E, 0x856D, 
        0x856D, 0x856D, 0x856D, 0x7D4D, 0x7D4D, 0x856E, 0x858E, 0x856E, 0x856E, 0x7D6E, 0x854E, 0x854E, 0x854E, 0x854E, 0x854E, 0x7D2D, 0x7D2D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854E, 0x852D, 0x852D, 0x850D, 0x850D, 
        0x8D2D, 0x8D2E, 0x8D2E, 0x8D4E, 0x954E, 0x9D4E, 0x9D4E, 0x9D4E, 0x9D4E, 0xA54E, 0xA54E, 0xA54E, 0xA54E, 0xAD6E, 0xAD6E, 0xAD6F, 0xAD6F, 0xAD4F, 0xA52F, 0xA50E, 0x9CCE, 0x946E, 0x8C2D, 0x7BCC, 0x5B29, 0x5308, 0x4AE7, 0x4307, 0x4326, 0x4346, 
        0x3B66, 0x3B66, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B86, 0x3B66, 0x3B66, 0x3B46, 0x3B46, 0x3B26, 0x3B06, 0x3B06, 0x3AE6, 0x3307, 0x43AA, 0x43CA, 0x43CA, 0x43C9, 0x4BE9, 0x53EA, 0x5C2B, 0x5C2B, 0x5BEB, 0x63EB, 0x63CB, 0x6BEC, 0x73EC, 0x7C0D, 
        0x73CB, 0x8C8F, 0x9D11, 0x9D12, 0x9512, 0x8491, 0x73EF, 0x7C4E, 0x744D, 0x742C, 0x744B, 0x744B, 0x744B, 0x7C4B, 0x7C4A, 0x7C4A, 0x7C2A, 0x744A, 0x6C2A, 0x640A, 0x640A, 0x6C2A, 0x8CAC, 0x9CED, 0x9CED, 0x94CC, 0x9CED, 0xA4ED, 0xA50D, 0xA52E, 
        0xA52E, 0xA52E, 0xA52E, 0xA52E, 0x9D0E, 0x9D0D, 0x94ED, 0x8CCD, 0x7CAD, 0x644B, 0x53EA, 0x4BEB, 0x5C2C, 0x5C4D, 0x4B8B, 0x3B29, 0x432A, 0x430C, 0x42AD, 0x3A2F, 0x31D0, 0x39D2, 0x39D3, 0x39B2, 0x3992, 0x3992, 0x3172, 0x3132, 0x3133, 0x3154, 
        0x3154, 0x3175, 0x3176, 0x3197, 0x3177, 0x3197, 0x3177, 0x3198, 0x3998, 0x39B8, 0x3998, 0x3198, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x39B9, 0x39D9, 0x39D9, 0x39D9, 0x39DA, 0x39DA, 0x31DB, 0x31DB, 0x31DB, 0x31BB, 0x31BB, 
        0x39DB, 0x39DB, 0x39DC, 0x39FC, 0x39FC, 0x3A1C, 0x39FD, 0x31FC, 0x31DD, 0x31DD, 0x31DC, 0x31FC, 0x29FC, 0x29DC, 0x29FC, 0x29DC, 0x29DB, 0x29FB, 0x321C, 0x321C, 0x31DC, 0x29DB, 0x29BB, 0x219B, 0x21BB, 0x219B, 0x299B, 0x31DB, 0x4ABE, 0x52DE, 
        0x52BE, 0x4ABD, 0x4ABD, 0x4ADD, 0x52DD, 0x52FE, 0x5B1E, 0x5B1E, 0x4A9D, 0x319A, 0x2999, 0x39DB, 0x52BE, 0x52DE, 0x52DE, 0x5AFE, 0x5AFE, 0x5B1E, 0x5AFD, 0x4A9B, 0x4278, 0x3A76, 0x4294, 0x4AF3, 0x4AF2, 0x63D4, 0x7CB6, 0x8515, 0x8514, 0x8D74, 
        0x8DB4, 0x95D4, 0x9E14, 0xA655, 0xAE55, 0xB676, 0xC6D7, 0xCF18, 0xB655, 0xA5D2, 0x9DD2, 0x9DD2, 0x752E, 0x444A, 0x3C6B, 0x3C6A, 0x3C4A, 0x33E9, 0x33A8, 0x3388, 0x3367, 0x3367, 0x3347, 0x3346, 0x3346, 0x3B47, 0x3B67, 0x3B67, 0x4368, 0x4369, 
        0x436A, 0x432C, 0x42CC, 0x3AAA, 0x3AA9, 0x3AA8, 0x42E8, 0x4B29, 0x5349, 0x5369, 0x5B89, 0x5B89, 0x5BA9, 0x63A9, 0x63CA, 0x63CA, 0x63CA, 0x6BCA, 0x73EA, 0x7C0B, 0x840B, 0x7C0B, 0x7C0B, 0x8C6D, 0x94AE, 0x8C6C, 0x8C6D, 0x8C4C, 0x840B, 0x8C6D, 
        0x8C6D, 0x844C, 0x842C, 0x7BEA, 0x73CA, 0x73CA, 0x73CA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x73EA, 0x6BEA, 0x6BEA, 0x73EB, 0x740B, 0x73EB, 0x6BCA, 0x6BEA, 0x7C2B, 0x73EB, 0x73EB, 0x7BEB, 0x73EB, 0x73EB, 0x73EB, 0x73EA, 
        0x73CA, 0x73CA, 0x73EB, 0x73EB, 0x6BEB, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63EA, 0x640A, 0x63EA, 0x63EB, 0x5BCB, 0x5BCB, 0x5BCC, 0x5BEC, 0x53EC, 0x4BCC, 0x43CC, 0x43AB, 0x3B8A, 0x3B6A, 0x3BAA, 0x43CB, 0x43CB, 0x4BEB, 0x4BEB, 0x4C0B, 0x4BEA, 
        0x4BEA, 0x4BEA, 0x4BEB, 0x4C0C, 0x43EB, 0x33CA, 0x2BCA, 0x2BC9, 0x2BE9, 0x23E9, 0x2BE9, 0x2BE9, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BE9, 0x23E9, 0x2409, 0x2408, 0x2428, 0x2428, 0x2428, 0x2448, 0x2428, 0x2428, 0x2C28, 0x3C4A, 0x4C8B, 0x548C, 0x4C0A, 
        0x43A8, 0x4408, 0x3BE7, 0x3BE7, 0x43E8, 0x43E8, 0x4BE8, 0x4C0A, 0x644B, 0x6C4C, 0x746C, 0x7C6C, 0x7C8C, 0x7CAD, 0x748D, 0x5BEA, 0x32E6, 0x2244, 0x1A04, 0x1A04, 0x19E4, 0x19E4, 0x19E4, 0x1A05, 0x2225, 0x2A66, 0x2A86, 0x2AC6, 0x2AE7,
  0x74CE, 0x8530, 0x74CE, 0x5C6C, 0x5C8C, 0x5CAC, 0x5CAC, 0x54AB, 0x54AC, 0x54CC, 0x54CC, 0x54AB, 0x548B, 0x5C6B, 0x648C, 0x64CD, 0x6CEE, 0x6D0D, 0x6CCD, 0x64CD, 0x64CD, 0x64CD, 0x64AD, 0x64AD, 0x6CCC, 0x74ED, 0x856F, 0x8DB0, 0x8D71, 0x8511, 0x748F, 
        0x6C4D, 0x6CCD, 0x6CED, 0x6CED, 0x750E, 0x8E12, 0x9E53, 0x9E33, 0x95F3, 0x8D91, 0x7D30, 0x6CAD, 0x648C, 0x6CCD, 0x6CED, 0x6D0D, 0x752D, 0x754D, 0x752D, 0x752D, 0x754D, 0x7D2D, 0x752D, 0x754D, 0x754D, 0x7D2D, 0x7D2D, 0x854E, 0x854D, 0x856D, 
        0x854D, 0x854D, 0x856D, 0x7D4D, 0x7D4D, 0x856E, 0x858E, 0x856E, 0x856E, 0x856E, 0x854E, 0x7D4D, 0x854D, 0x854E, 0x854D, 0x7D2D, 0x7D2D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x850D, 0x850D, 0x850D, 0x8D0D, 0x8D0D, 0x8D0D, 
        0x8D0D, 0x952E, 0x952E, 0x952E, 0x9D4E, 0x9D4E, 0xA54E, 0xA56E, 0xA54E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD6F, 0xB56F, 0xB56F, 0xB56F, 0xAD4F, 0xAD2F, 0xA50E, 0x9CCE, 0x948E, 0x8C2D, 0x7BEC, 0x6B8B, 0x52E8, 0x4AE7, 0x4306, 0x3B06, 0x3B26, 0x3B46, 
        0x3B66, 0x3B86, 0x3B86, 0x3B66, 0x3B66, 0x3B66, 0x3B66, 0x3B46, 0x3B46, 0x3B26, 0x3B26, 0x3B06, 0x3B06, 0x3AE6, 0x3AC6, 0x32C7, 0x4349, 0x43AA, 0x43AA, 0x4BEA, 0x4BCA, 0x53CA, 0x640B, 0x63EC, 0x5BCB, 0x6BCC, 0x6BAB, 0x73EC, 0x8C6E, 0x9CAF, 
        0x842D, 0x94D0, 0x9511, 0x94F1, 0x8CF1, 0x7C2F, 0x6BCE, 0x742D, 0x744D, 0x744C, 0x744B, 0x744B, 0x744B, 0x7C4B, 0x7C4A, 0x7C2A, 0x7C2A, 0x742A, 0x6C2A, 0x63EA, 0x640A, 0x6C2A, 0x8C8C, 0x9CED, 0x9CED, 0x94CC, 0x9CEC, 0xA4ED, 0xA50D, 0xA52D, 
        0xA52D, 0xA52E, 0xA52E, 0xA52D, 0x9D0D, 0x9D0D, 0x94ED, 0x84CC, 0x746B, 0x5C0A, 0x4BC9, 0x4C0B, 0x5C4C, 0x5C4D, 0x53CB, 0x436A, 0x436A, 0x434B, 0x42EB, 0x3A8D, 0x320E, 0x39F0, 0x39F1, 0x39D2, 0x39B3, 0x39B3, 0x3992, 0x3952, 0x3132, 0x3132, 
        0x3153, 0x3174, 0x3975, 0x3996, 0x3197, 0x3197, 0x3197, 0x3177, 0x3198, 0x3998, 0x39B8, 0x3198, 0x39B8, 0x39B8, 0x39B8, 0x39B8, 0x39D9, 0x39B8, 0x39B9, 0x39D9, 0x39D9, 0x39D9, 0x39D9, 0x39DA, 0x39FA, 0x39DA, 0x39DB, 0x39DA, 0x39DB, 0x39DB, 
        0x39DB, 0x39DB, 0x39FC, 0x3A1C, 0x3A1C, 0x3A1C, 0x3A1C, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x29DB, 0x29DB, 0x31FB, 0x321C, 0x321C, 0x31FB, 0x29DB, 0x29BB, 0x29BB, 0x29BB, 0x29BB, 0x29BB, 0x31DB, 0x4A7D, 0x4ABE, 
        0x52BE, 0x4ABE, 0x4ABD, 0x4ADD, 0x52DE, 0x5AFE, 0x5AFD, 0x52DD, 0x423B, 0x31D9, 0x31B9, 0x31BA, 0x425C, 0x5AFE, 0x5B1E, 0x633E, 0x633E, 0x633E, 0x633E, 0x635D, 0x5318, 0x42B3, 0x3ACF, 0x3AED, 0x3AED, 0x4B4D, 0x6C90, 0x8552, 0x8D93, 0x8DB2, 
        0x95D3, 0x95F3, 0x9E14, 0xA655, 0xA654, 0xAE55, 0xBEB6, 0xCF38, 0xBEB6, 0xAE13, 0xA5D2, 0x9DD2, 0x8DD1, 0x546B, 0x3C6B, 0x3C6A, 0x3C4A, 0x3C29, 0x33C8, 0x3387, 0x3367, 0x3367, 0x3347, 0x3346, 0x3B47, 0x3B67, 0x3B67, 0x4387, 0x43A7, 0x4388, 
        0x4BA9, 0x4B4C, 0x4B4C, 0x430C, 0x42EC, 0x328A, 0x2A48, 0x3A88, 0x4AE8, 0x4B29, 0x5369, 0x5B89, 0x5B89, 0x5BA9, 0x63A9, 0x63A9, 0x63CA, 0x6BCA, 0x73CA, 0x73EB, 0x7BEA, 0x73EA, 0x7BEB, 0x7BEB, 0x7C0B, 0x7BEB, 0x840B, 0x7BEB, 0x7BCA, 0x7BEB, 
        0x840B, 0x844C, 0x842C, 0x7C0B, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73EA, 0x73EA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x6BEA, 0x6BEA, 0x73EB, 0x740B, 0x73EB, 0x73EB, 0x73EA, 0x7C0B, 0x7BEB, 0x7BEB, 0x7BEB, 0x7BEB, 0x7BEB, 0x73EA, 0x73EB, 
        0x740B, 0x73EB, 0x73EB, 0x73EB, 0x73EB, 0x6BEB, 0x6C0B, 0x6C2B, 0x6C2B, 0x6C0B, 0x6C0B, 0x6C0B, 0x63EB, 0x63EB, 0x5BCA, 0x5BCB, 0x63EB, 0x5BCC, 0x53AB, 0x43AB, 0x43AB, 0x438B, 0x436A, 0x438B, 0x43AB, 0x43AB, 0x43CB, 0x4BEB, 0x4C0B, 0x4C0A, 
        0x4BEA, 0x4BEA, 0x4BEB, 0x540C, 0x4C0C, 0x33CA, 0x2BCA, 0x2BC9, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BC9, 0x2BC9, 0x340A, 0x2BE9, 0x2BE9, 0x2409, 0x2409, 0x2428, 0x2428, 0x2428, 0x2428, 0x2428, 0x2428, 0x2C29, 0x3C49, 0x4C4A, 0x546B, 0x540A, 
        0x4BC9, 0x542A, 0x43C8, 0x3BA7, 0x43C8, 0x4BE9, 0x542A, 0x644B, 0x6C6B, 0x746C, 0x746C, 0x7C6C, 0x7C8C, 0x7C8C, 0x746C, 0x53A9, 0x32C6, 0x2244, 0x1A24, 0x1A04, 0x19E4, 0x19E4, 0x21E5, 0x21E5, 0x2A26, 0x3287, 0x3B08, 0x3B08, 0x3308,
  0x748D, 0x74AE, 0x6C8D, 0x6C8D, 0x74EE, 0x7D4F, 0x754F, 0x64CD, 0x5CCC, 0x5CCD, 0x64ED, 0x64ED, 0x64CD, 0x64CD, 0x6CED, 0x74EE, 0x750E, 0x750E, 0x6CED, 0x6CCD, 0x6CED, 0x6CCD, 0x64CD, 0x64CD, 0x6CCC, 0x750D, 0x7D8E, 0x85D0, 0x8570, 0x7CF0, 0x6C6E, 
        0x6C4D, 0x74CD, 0x6CCD, 0x6CCD, 0x6D0E, 0x8E12, 0x9E53, 0x9E33, 0x95F2, 0x8571, 0x7D2F, 0x6C8D, 0x6CAD, 0x74EE, 0x752E, 0x752E, 0x754E, 0x7D4E, 0x7D4D, 0x752D, 0x7D4D, 0x7D4E, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D4D, 0x7D4D, 
        0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D6D, 0x856E, 0x7D6D, 0x856D, 0x856E, 0x856D, 0x854E, 0x854E, 0x854E, 0x854D, 0x852D, 0x852D, 0x852D, 0x852D, 0x852D, 0x850D, 0x850D, 0x84EC, 0x84EC, 0x84ED, 0x850D, 0x952E, 0x952E, 0x950E, 0x950D, 
        0x9D0E, 0x9D2E, 0x9D2E, 0xA52E, 0xA54E, 0xA54E, 0xA54E, 0xAD6E, 0xAD6F, 0xAD6F, 0xB56F, 0xB56F, 0xB56F, 0xB56F, 0xB54F, 0xAD2F, 0xA4CE, 0xA4AE, 0x9C8E, 0x9C6E, 0x942E, 0x840E, 0x6B6B, 0x5B2A, 0x4AE8, 0x42E7, 0x3B06, 0x3B06, 0x3325, 0x3345, 
        0x3B46, 0x3B66, 0x3B66, 0x3B66, 0x3B46, 0x3B46, 0x3B46, 0x3B26, 0x3B26, 0x3B06, 0x3B06, 0x3B06, 0x3AE6, 0x3AC6, 0x3AA6, 0x3287, 0x3AE8, 0x4B8A, 0x4BAA, 0x53EA, 0x5BEB, 0x63CB, 0x6BEC, 0x73ED, 0x73CC, 0x842E, 0x7C0D, 0x948F, 0x9CF0, 0x9CCF, 
        0x9CCF, 0x9D11, 0x9510, 0x8CF0, 0x84B0, 0x73EF, 0x73EE, 0x742D, 0x744C, 0x744C, 0x744C, 0x744B, 0x744B, 0x744B, 0x744B, 0x742A, 0x742A, 0x742A, 0x6C0A, 0x5BEA, 0x5C0A, 0x6C2A, 0x846B, 0x94AC, 0x94EC, 0x94CC, 0x9CED, 0xA4ED, 0xA50D, 0xA52D, 
        0xA52E, 0xA52E, 0xA52D, 0xA52D, 0x9D0D, 0x950D, 0x8CCC, 0x748B, 0x5C2A, 0x43C8, 0x43C9, 0x544B, 0x648D, 0x5C4C, 0x53EB, 0x4BAB, 0x53AB, 0x53AB, 0x4B8B, 0x3ACB, 0x3AAC, 0x3A4D, 0x3A0F, 0x3A11, 0x41F2, 0x41F2, 0x41B3, 0x3992, 0x3952, 0x3152, 
        0x3153, 0x3154, 0x3974, 0x3975, 0x3996, 0x3197, 0x3177, 0x3177, 0x3197, 0x39B7, 0x39B7, 0x39B7, 0x39B8, 0x39B8, 0x39D8, 0x39D8, 0x39D8, 0x39D8, 0x39B8, 0x39D9, 0x39D9, 0x39F9, 0x39F9, 0x39F9, 0x41FA, 0x39FA, 0x39DA, 0x39DA, 0x39DA, 0x39DA, 
        0x31DA, 0x39DB, 0x39DB, 0x39DB, 0x39FB, 0x3A1C, 0x3A1C, 0x31FC, 0x31FC, 0x31FC, 0x31FC, 0x31DB, 0x31DB, 0x31DB, 0x31DB, 0x29DB, 0x31FB, 0x31FB, 0x321B, 0x321B, 0x31FB, 0x29DB, 0x29DB, 0x29BB, 0x29BA, 0x29BA, 0x29BB, 0x31DB, 0x3A1C, 0x425D, 
        0x4A7D, 0x4A9E, 0x4ABE, 0x4ADD, 0x52DE, 0x5AFE, 0x52DD, 0x423A, 0x3A19, 0x39F9, 0x39F8, 0x3A18, 0x423A, 0x5AFD, 0x633E, 0x635E, 0x6B3E, 0x6B5E, 0x6B5E, 0x6B5D, 0x6BBA, 0x5374, 0x430E, 0x3B2B, 0x434B, 0x434A, 0x5C0C, 0x5C4C, 0x7D30, 0x95F3, 
        0x9E13, 0x9E13, 0xA634, 0xA654, 0xAE54, 0xAE54, 0xAE75, 0xCF38, 0xC717, 0xAE54, 0xA5D2, 0xA5F2, 0x9E12, 0x7D6F, 0x444A, 0x3C4A, 0x3C4A, 0x3C4A, 0x3C09, 0x3387, 0x3367, 0x3367, 0x3367, 0x3B47, 0x3B67, 0x3B67, 0x3B87, 0x43A7, 0x43A7, 0x43A8, 
        0x4BC9, 0x438A, 0x438B, 0x434C, 0x4B4E, 0x4B4E, 0x2A49, 0x21E8, 0x3248, 0x42A8, 0x5329, 0x5369, 0x5B6A, 0x5B8A, 0x63A9, 0x5BA9, 0x63A9, 0x63AA, 0x6BAA, 0x6BAA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73AA, 0x73AA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 
        0x73CA, 0x7BEB, 0x7C0B, 0x7BEB, 0x73CA, 0x73CA, 0x6BCA, 0x6BCA, 0x6BCA, 0x6BCA, 0x6BCA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73EA, 0x73EB, 0x73EA, 0x73EB, 0x73EA, 0x7BEA, 0x7BCA, 0x7BEA, 0x7BEB, 0x7BEB, 0x7BEB, 0x7BEB, 0x7C0B, 
        0x7C2B, 0x7C2C, 0x7C0B, 0x740B, 0x740B, 0x6C0B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2A, 0x6C0A, 0x640A, 0x63EA, 0x63EA, 0x5BCA, 0x5BCA, 0x5BAA, 0x538A, 0x4BAB, 0x4B8B, 0x4B8B, 0x4B8B, 0x4BAC, 0x4BAC, 0x4BAB, 0x4BAB, 0x4BCB, 0x4BEB, 0x4BEA, 
        0x4BEA, 0x4BEA, 0x4BEB, 0x540C, 0x4C2C, 0x3BCB, 0x33CA, 0x33CA, 0x2BC9, 0x2BE9, 0x2BE9, 0x2BE9, 0x2BC9, 0x33EA, 0x3C2B, 0x340A, 0x2BE9, 0x2C29, 0x2C29, 0x2C29, 0x2C28, 0x2C28, 0x2C49, 0x2C49, 0x2C48, 0x3449, 0x3C4A, 0x4C6B, 0x546B, 0x540B, 
        0x5C2B, 0x648C, 0x540A, 0x43C9, 0x4BE9, 0x5C4A, 0x646B, 0x6C6B, 0x746B, 0x746B, 0x744B, 0x746B, 0x7C6C, 0x746C, 0x640B, 0x4B68, 0x2AA5, 0x2245, 0x1A24, 0x1A04, 0x19E4, 0x21E5, 0x21E5, 0x2205, 0x2A26, 0x3287, 0x4B4A, 0x5C0C, 0x5C2C,
  0x640B, 0x642C, 0x642C, 0x642C, 0x648D, 0x750E, 0x750E, 0x64CD, 0x64CD, 0x64CD, 0x6D0E, 0x754F, 0x7D4F, 0x750F, 0x750E, 0x750E, 0x750E, 0x750D, 0x6CED, 0x6CED, 0x6CED, 0x64CD, 0x64CD, 0x64CD, 0x6CCD, 0x6D0D, 0x7D8E, 0x85D0, 0x8590, 0x7CEF, 0x6C6E, 
        0x6C8E, 0x6CCD, 0x6CCD, 0x64AD, 0x6CED, 0x7D6F, 0x8DF1, 0x9612, 0x95D2, 0x8D91, 0x8530, 0x74CE, 0x750E, 0x750E, 0x7D2E, 0x7D4E, 0x7D4D, 0x7D4E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D4D, 0x7D4D, 
        0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D6D, 0x7D4E, 0x7D4D, 0x7D4D, 0x854E, 0x854D, 0x854E, 0x856E, 0x854E, 0x852D, 0x7D2D, 0x852D, 0x852D, 0x852D, 0x852D, 0x850D, 0x8D2D, 0x8D2E, 0x8D2E, 0x8D2E, 0x952E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D0E, 
        0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA54E, 0xA54E, 0xAD4E, 0xAD6E, 0xB56F, 0xB56F, 0xB56F, 0xB56F, 0xB56F, 0xB54F, 0xB52F, 0xACCE, 0xA46E, 0x9C4E, 0x942E, 0x8C0E, 0x7BAD, 0x738C, 0x5B09, 0x4AC8, 0x42E7, 0x3AE6, 0x3B06, 0x3306, 0x3325, 0x3325, 
        0x3325, 0x3B46, 0x3B46, 0x3B46, 0x3B26, 0x3B26, 0x3B26, 0x3B06, 0x3AE6, 0x3AE6, 0x3AE6, 0x3AC6, 0x3AC6, 0x3A86, 0x3A66, 0x3246, 0x42A8, 0x5B8B, 0x5BCC, 0x6C2D, 0x7C6D, 0x7C0C, 0x844E, 0x948F, 0x948F, 0x9CB0, 0xA4F0, 0xA510, 0xA4F0, 0x9CCF, 
        0xA510, 0xA550, 0x9510, 0x8CCF, 0x7C4F, 0x6BCE, 0x73EE, 0x6C2D, 0x744C, 0x744C, 0x744C, 0x744B, 0x744B, 0x744B, 0x744B, 0x742A, 0x742A, 0x6C2A, 0x640A, 0x5BEA, 0x5C0A, 0x6C2A, 0x7C4B, 0x8C8C, 0x94CC, 0x94ED, 0x9CED, 0xA50D, 0xA50D, 0xA52D, 
        0xA52E, 0xA52E, 0xA52D, 0xA50D, 0x9D0D, 0x8CCC, 0x7C8B, 0x642A, 0x4BC9, 0x43C9, 0x546B, 0x5CAD, 0x648D, 0x5C2C, 0x53CB, 0x53AA, 0x53AA, 0x5BAB, 0x53AB, 0x4B4B, 0x4B2C, 0x42ED, 0x428E, 0x3A2F, 0x4210, 0x39F1, 0x41D2, 0x41B2, 0x3992, 0x3172, 
        0x3152, 0x3153, 0x3174, 0x3174, 0x3996, 0x3996, 0x3196, 0x3197, 0x3197, 0x39B7, 0x39B7, 0x39B7, 0x39B8, 0x39B8, 0x39D8, 0x41D8, 0x41D9, 0x39D8, 0x39D8, 0x39D8, 0x39D9, 0x39F9, 0x39F9, 0x39F9, 0x39FA, 0x39FA, 0x39FA, 0x39DA, 0x39DA, 0x39DA, 
        0x39DA, 0x39DA, 0x39DB, 0x39DB, 0x39FB, 0x39FB, 0x39FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x321B, 0x31FB, 0x29FA, 0x31FB, 0x29DA, 0x29DA, 0x29DA, 0x31FB, 0x31FB, 0x39FB, 0x39FB, 
        0x421C, 0x4A5D, 0x4A9D, 0x52DD, 0x5ADD, 0x5ADD, 0x4A5A, 0x4238, 0x4258, 0x52D8, 0x639A, 0x741B, 0x7C3C, 0x73FD, 0x6B7D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5E, 0x73BC, 0x6BF7, 0x4B4E, 0x434B, 0x436A, 0x436A, 0x4B8A, 0x4389, 0x540B, 0x7D2F, 
        0x95F2, 0xA634, 0x9E13, 0x9E13, 0xAE54, 0xAE54, 0xB675, 0xC6D6, 0xC6F7, 0xB674, 0xA5F3, 0x9DD2, 0x9DF2, 0x8590, 0x4C4B, 0x33E9, 0x3C2A, 0x3C4A, 0x3C4A, 0x33C8, 0x3387, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x4387, 0x4387, 0x43A7, 0x43C7, 0x4BC8, 
        0x4BE9, 0x4BE9, 0x43AA, 0x438C, 0x434D, 0x4B8F, 0x538F, 0x3ACC, 0x2A08, 0x3248, 0x42C9, 0x532A, 0x534A, 0x5B6A, 0x5B8A, 0x5B8A, 0x5BA9, 0x63A9, 0x6BAA, 0x6BAA, 0x6BA9, 0x6BAA, 0x6BAA, 0x73CA, 0x73CA, 0x73CA, 0x73CA, 0x73AA, 0x73AA, 0x73AA, 
        0x73AA, 0x73CA, 0x73CA, 0x73CA, 0x6BCA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BCA, 0x6BCA, 0x6BCA, 0x6BCA, 0x6BCA, 0x73CA, 0x73EA, 0x73CA, 0x73EB, 0x73EA, 0x73CA, 0x73CA, 0x7BCA, 0x7BEA, 0x7BEB, 0x740B, 0x740B, 0x7C2B, 
        0x7C2B, 0x7C4C, 0x7C4C, 0x742B, 0x6C0B, 0x6C0B, 0x6C2B, 0x6C2B, 0x6C2B, 0x640A, 0x640A, 0x6C0A, 0x640A, 0x63EA, 0x63EA, 0x63EA, 0x63CA, 0x5BAA, 0x5BAA, 0x5BAB, 0x5BAB, 0x5BAC, 0x5BAC, 0x538C, 0x4B8C, 0x4B8C, 0x4BAC, 0x4BCC, 0x4BCB, 0x4BCB, 
        0x4BCA, 0x4BCA, 0x4BCB, 0x53EC, 0x544D, 0x3BEB, 0x33CA, 0x33CA, 0x2BEA, 0x2BEA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C0A, 0x342A, 0x3409, 0x2C09, 0x2C29, 0x2C29, 0x2C29, 0x2C29, 0x2C29, 0x2C49, 0x2C49, 0x2C49, 0x3449, 0x446A, 0x546B, 0x5C6B, 0x644B, 
        0x74CD, 0x74EE, 0x646B, 0x5C4B, 0x5C4B, 0x648B, 0x6C8B, 0x6C8B, 0x746B, 0x744A, 0x744B, 0x746B, 0x7C8C, 0x744B, 0x5BCA, 0x4307, 0x2A85, 0x2245, 0x2225, 0x2205, 0x2A46, 0x42C9, 0x4B0A, 0x532B, 0x5B8B, 0x63AC, 0x5B8B, 0x63EC, 0x748E,
  0x5C0B, 0x5C0B, 0x53EA, 0x53EA, 0x5C0B, 0x648C, 0x64AC, 0x64CD, 0x64ED, 0x6CED, 0x752E, 0x7D70, 0x8550, 0x7D0F, 0x7CEF, 0x7D0F, 0x7D0E, 0x7D0E, 0x750D, 0x6D0D, 0x6CED, 0x6CED, 0x64ED, 0x64ED, 0x6CED, 0x6D0D, 0x7D8E, 0x85D0, 0x8DB1, 0x7D10, 0x74AF, 
        0x6C8E, 0x6CAE, 0x64AD, 0x64AC, 0x6CEE, 0x8590, 0x8DD1, 0x95D1, 0x95B2, 0x8D71, 0x7D10, 0x7D0E, 0x7D2F, 0x854E, 0x854E, 0x856D, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D0D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 0x7D2D, 0x7D4D, 0x7D2D, 0x7D4D, 0x7D4D, 
        0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D4D, 0x7D6D, 0x7D4E, 0x7D6D, 0x7D6E, 0x856E, 0x856E, 0x856E, 0x856E, 0x854E, 0x852D, 0x850D, 0x7CED, 0x850D, 0x8D2D, 0x8D2D, 0x8D2D, 0x8D2D, 0x952E, 0x952E, 0x952E, 0x9D2E, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 
        0xA52E, 0xA52E, 0xA52E, 0xA54E, 0xAD4E, 0xAD2E, 0xAD4E, 0xB56E, 0xB56F, 0xB56F, 0xB56F, 0xBD6F, 0xBD6F, 0xB54F, 0xB50F, 0xACAE, 0x9C4E, 0x9C2E, 0x940E, 0x7B8C, 0x6B4B, 0x5B29, 0x4AE8, 0x42C7, 0x3AE6, 0x32E6, 0x3305, 0x3305, 0x2B05, 0x3325, 
        0x3325, 0x3325, 0x3306, 0x3B26, 0x3B06, 0x3B06, 0x3AE6, 0x3AE6, 0x3AE6, 0x3AE6, 0x3AC6, 0x3AA6, 0x3A86, 0x3A66, 0x4287, 0x634B, 0x634B, 0x73CC, 0x8C8F, 0x94D0, 0x94AF, 0x9C8F, 0xA4D0, 0xA4CF, 0xA4CF, 0xA4D0, 0xAD10, 0xAD10, 0xA50F, 0x9D0F, 
        0xA52F, 0x9D2F, 0x94EF, 0x848F, 0x740E, 0x73EF, 0x73EE, 0x6C0D, 0x6C2C, 0x6C4C, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x744B, 0x6C4A, 0x6C2A, 0x6C2A, 0x640A, 0x5BEA, 0x5C0A, 0x642B, 0x742B, 0x8C8C, 0x94CC, 0x9D0D, 0x9D0D, 0xA50D, 0xA52D, 0xA52D, 
        0xA52D, 0xA52D, 0x9D2D, 0x9CED, 0x94ED, 0x7C8B, 0x640A, 0x53EA, 0x43C9, 0x548C, 0x5CED, 0x64CD, 0x64AD, 0x644C, 0x5BEB, 0x5BCA, 0x5BAA, 0x5BAA, 0x5BAA, 0x538A, 0x4B6B, 0x4B4C, 0x4B2C, 0x4B0E, 0x42AF, 0x3A2F, 0x4211, 0x41F2, 0x39B2, 0x3992, 
        0x3172, 0x3152, 0x3153, 0x3153, 0x3175, 0x3195, 0x3176, 0x3176, 0x3197, 0x31B7, 0x39B7, 0x39B7, 0x39B7, 0x39B8, 0x39D8, 0x41D8, 0x41F8, 0x39D8, 0x39B8, 0x39D8, 0x39D8, 0x39D8, 0x39D9, 0x39D9, 0x39F9, 0x39FA, 0x39FA, 0x39D9, 0x39DA, 0x39FA, 
        0x39FA, 0x39FA, 0x39FA, 0x39FB, 0x39FB, 0x39FB, 0x31FB, 0x31DB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x31FB, 0x321A, 0x31FA, 0x31FA, 0x31FB, 0x31FB, 0x31FA, 0x31FA, 0x321A, 0x3A1A, 0x3A1A, 0x3A1A, 
        0x421B, 0x423B, 0x4A5C, 0x527C, 0x529C, 0x529A, 0x5AD9, 0x6B9A, 0x847C, 0x951C, 0x957B, 0x957A, 0x8D79, 0x84DB, 0x73FB, 0x6B5D, 0x6B5E, 0x6B5E, 0x6B5E, 0x6B5D, 0x6B7D, 0x7419, 0x4B6F, 0x436B, 0x438A, 0x436A, 0x438A, 0x43AA, 0x4BA9, 0x5C2B, 
        0x7D0F, 0x8DB1, 0x95D2, 0x9DD3, 0xA614, 0xAE55, 0xB676, 0xBE96, 0xC6D7, 0xBE75, 0xA5F3, 0x9DB2, 0x95B1, 0x85B0, 0x5CCD, 0x3C09, 0x33E9, 0x342A, 0x3C4A, 0x3C09, 0x3367, 0x3B67, 0x3B67, 0x4387, 0x4387, 0x4387, 0x43A8, 0x43C8, 0x43C8, 0x4BE8, 
        0x4BE8, 0x4BE9, 0x4BCA, 0x43AB, 0x436C, 0x436E, 0x53F0, 0x6451, 0x6431, 0x4B4D, 0x3A89, 0x3A68, 0x4AC9, 0x4AE9, 0x4B29, 0x5349, 0x5B89, 0x5BA9, 0x6389, 0x63AA, 0x6BA9, 0x6BAA, 0x6BAA, 0x6BAA, 0x73AA, 0x73AA, 0x73CA, 0x73CA, 0x6BAA, 0x6BC9, 
        0x6BCA, 0x73CA, 0x6BEA, 0x6BEA, 0x6C0B, 0x6C0B, 0x6C0A, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63CA, 0x63AA, 0x6BA9, 0x6BA9, 0x6BC9, 0x6BCA, 0x6BCA, 0x6BAA, 0x73AA, 0x73AA, 0x73CA, 0x73CA, 0x7BEA, 0x7BEB, 0x740B, 0x740B, 0x742B, 0x742B, 
        0x744C, 0x744C, 0x744C, 0x744B, 0x742B, 0x6C2B, 0x6C4B, 0x6C2B, 0x6C2B, 0x640B, 0x6C0A, 0x6C0A, 0x6C2A, 0x6C0A, 0x6C0A, 0x6C0A, 0x63EA, 0x63EB, 0x63CA, 0x63EB, 0x63CB, 0x5BCB, 0x5BAC, 0x538C, 0x4B6C, 0x4B4C, 0x53AD, 0x53ED, 0x4BCC, 0x4BCB, 
        0x43AA, 0x4BAA, 0x4BAB, 0x53CC, 0x5C2D, 0x440C, 0x33AA, 0x33CA, 0x2BEA, 0x2BEA, 0x2BE9, 0x2BE9, 0x2BE9, 0x2C09, 0x340A, 0x2C09, 0x2C09, 0x2C29, 0x2C29, 0x2C29, 0x2C29, 0x2C29, 0x2C49, 0x3449, 0x3449, 0x3449, 0x4C8A, 0x5CCC, 0x74EE, 0x7CEE, 
        0x850F, 0x850E, 0x74CD, 0x6C8C, 0x6C8C, 0x6C8B, 0x6C6B, 0x6C6B, 0x6C4A, 0x744A, 0x744A, 0x746B, 0x746C, 0x6C4B, 0x53A9, 0x3AC7, 0x2A86, 0x2A46, 0x2225, 0x2205, 0x2A26, 0x3A68, 0x532B, 0x6BAD, 0x7C4F, 0x846F, 0x846F, 0x7C6E, 0x84AF,
  0x5C0A, 0x5C0A, 0x53EA, 0x53EA, 0x53EA, 0x5C2B, 0x648C, 0x64CD, 0x64ED, 0x6D0D, 0x752E, 0x7D4F, 0x8550, 0x8530, 0x8D50, 0x852F, 0x7D2F, 0x7D0E, 0x752E, 0x752D, 0x6D0D, 0x6D0D, 0x64ED, 0x64ED, 0x6CED, 0x6D0D, 0x7D8E, 0x8DF0, 0x8DB1, 0x8530, 0x7CD0, 
        0x74AF, 0x6CAE, 0x6C8D, 0x648D, 0x750E, 0x8DD1, 0x95D1, 0x95D2, 0x9DF2, 0x8530, 0x7CCF, 0x852F, 0x854F, 0x854E, 0x854E, 0x854D, 0x854D, 0x7D2D, 0x7D2D, 0x7D0D, 0x7D0D, 0x7D2D, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D4D, 
        0x7D4D, 0x7D4D, 0x7D4D, 0x854D, 0x856D, 0x856E, 0x856E, 0x858E, 0x858E, 0x856E, 0x856E, 0x854E, 0x854E, 0x852E, 0x852E, 0x850D, 0x850D, 0x850D, 0x8D2E, 0x8D0D, 0x8D0D, 0x950D, 0x950D, 0x9D2E, 0x9D2E, 0x9D2E, 0xA52E, 0xA52E, 0xAD2E, 0xAD2E, 
        0xA52E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD4E, 0xB54E, 0xB56F, 0xB56F, 0xB54F, 0xBD4F, 0xBD4F, 0xB52F, 0xACEF, 0xACAF, 0xA46E, 0x942E, 0x8C0E, 0x7BAD, 0x6B2A, 0x5B29, 0x4AE8, 0x3AC7, 0x32C6, 0x32E6, 0x32E5, 0x2B05, 0x2B05, 0x2B05, 0x2B05, 
        0x2B05, 0x3305, 0x32E6, 0x32E6, 0x32E6, 0x32E6, 0x32C6, 0x3AC6, 0x3AC6, 0x3AC6, 0x3AA6, 0x3AA7, 0x3A66, 0x4A87, 0x6B6B, 0x736B, 0x83CD, 0x9CB0, 0xA4F0, 0xA4F0, 0xA4EF, 0xACF0, 0xAD10, 0xACEF, 0xACEF, 0xAD10, 0xAD30, 0xA50F, 0xA50E, 0x9D2E, 
        0x9D0F, 0x94EE, 0x8CCE, 0x848F, 0x740E, 0x6BCE, 0x6BED, 0x6C0C, 0x6C2B, 0x642B, 0x642A, 0x642A, 0x642A, 0x6C2A, 0x6C2A, 0x6C4A, 0x6C4A, 0x642A, 0x640A, 0x5BEA, 0x5C0A, 0x642B, 0x742B, 0x8CAC, 0x9CCC, 0x9D0D, 0xA50D, 0xA52D, 0xA52D, 0xA52D, 
        0xA52D, 0xA52D, 0x9D0D, 0x9CED, 0x84AC, 0x6C4B, 0x5C0A, 0x540A, 0x544B, 0x64ED, 0x652E, 0x650E, 0x6CEE, 0x6C8D, 0x640B, 0x63EB, 0x5BAA, 0x5BA9, 0x5389, 0x4B49, 0x4329, 0x4329, 0x434A, 0x536D, 0x536E, 0x42AD, 0x4AB0, 0x4251, 0x4211, 0x39D2, 
        0x3992, 0x3172, 0x3152, 0x3152, 0x3153, 0x3175, 0x3175, 0x3176, 0x3176, 0x3196, 0x31B7, 0x39B7, 0x39B7, 0x39B7, 0x41B7, 0x41D8, 0x41D8, 0x39D8, 0x39B7, 0x39B8, 0x39D8, 0x39D8, 0x39D8, 0x39D9, 0x39F9, 0x39F9, 0x41FA, 0x39F9, 0x39FA, 0x39FA, 
        0x39FA, 0x39FA, 0x39FA, 0x39FA, 0x39FB, 0x39FA, 0x31DA, 0x31DB, 0x31FB, 0x39FB, 0x39FB, 0x31FB, 0x39FB, 0x39FB, 0x321B, 0x321B, 0x31FB, 0x321B, 0x321B, 0x321B, 0x321B, 0x321B, 0x321A, 0x321A, 0x31FA, 0x321A, 0x3A1A, 0x3A3A, 0x3A3A, 0x425A, 
        0x425A, 0x425A, 0x4A7A, 0x529A, 0x631B, 0x843C, 0x9D1E, 0xADBD, 0xADFC, 0xAE1B, 0xA619, 0x9DF7, 0x95D6, 0x8D77, 0x7C97, 0x6BDA, 0x6B5C, 0x6B3D, 0x6B5E, 0x6B5D, 0x6B5D, 0x6BD9, 0x4B4F, 0x438A, 0x438A, 0x4389, 0x4389, 0x43AA, 0x4389, 0x4BA9, 
        0x5C4B, 0x74CE, 0x8D71, 0x95B2, 0x9DD3, 0xAE14, 0xB655, 0xB675, 0xBE96, 0xC6D6, 0xAE34, 0x9DB2, 0x8D91, 0x8DB1, 0x7D90, 0x444B, 0x33C8, 0x33E9, 0x3C2A, 0x442A, 0x3BA8, 0x3B88, 0x3B67, 0x4387, 0x43A7, 0x43A7, 0x43A7, 0x43C8, 0x4BE8, 0x4C08, 
        0x4BE8, 0x4BE8, 0x4BC9, 0x43CA, 0x438B, 0x3B6D, 0x4BAE, 0x5C51, 0x6CB2, 0x74B2, 0x640F, 0x42EA, 0x3A69, 0x3A69, 0x3AA9, 0x42C9, 0x4B09, 0x5369, 0x5B8A, 0x5B8A, 0x638A, 0x6389, 0x63A9, 0x6BA9, 0x6BAA, 0x73AA, 0x73AA, 0x6BCA, 0x6BAA, 0x6BCA, 
        0x6BCA, 0x6BCA, 0x6BEA, 0x6BEA, 0x6C0A, 0x6C0B, 0x6C0B, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BC9, 0x63C9, 0x63A9, 0x6BAA, 0x6BA9, 0x6BAA, 0x6BCA, 0x6BCA, 0x6BAA, 0x6BAA, 0x73CA, 0x73CA, 0x7BEB, 0x7BEB, 0x7C0B, 0x740B, 0x740B, 0x742B, 0x744C, 
        0x744C, 0x744C, 0x746C, 0x746C, 0x744B, 0x6C4B, 0x6C6C, 0x6C6C, 0x6C6C, 0x6C4B, 0x6C2B, 0x6C2B, 0x6C4B, 0x744B, 0x742B, 0x6C2B, 0x6C2B, 0x6C0B, 0x6BEB, 0x6BEB, 0x63EA, 0x63CB, 0x63CB, 0x5BAB, 0x5BAC, 0x538C, 0x53AD, 0x53CD, 0x5BED, 0x5C0C, 
        0x4BAB, 0x4B8B, 0x4B8B, 0x53CC, 0x540D, 0x4BEC, 0x33CB, 0x33CA, 0x2BEA, 0x2BEA, 0x2BE9, 0x2BE9, 0x2C09, 0x340A, 0x340A, 0x3409, 0x3409, 0x3429, 0x3429, 0x2C29, 0x2C09, 0x2C29, 0x3449, 0x3449, 0x3449, 0x3C69, 0x4C8A, 0x64EC, 0x752E, 0x852F, 
        0x852E, 0x850E, 0x7CCD, 0x74AC, 0x74AC, 0x748B, 0x746A, 0x6C4A, 0x6C4A, 0x746A, 0x746B, 0x746B, 0x746C, 0x640B, 0x5369, 0x3AC7, 0x32C7, 0x4329, 0x4B4B, 0x534B, 0x534B, 0x5B4B, 0x634C, 0x73CD, 0x8C6F, 0x94B0, 0x94CF, 0x94CF, 0x9510,
  0x53EA, 0x53EA, 0x53EA, 0x53EA, 0x540A, 0x542A, 0x5C6B, 0x64AC, 0x64CC, 0x6CED, 0x750D, 0x7D0E, 0x8D91, 0x9DD3, 0xA5F3, 0x8D50, 0x852E, 0x7D0E, 0x7D0D, 0x752D, 0x752D, 0x6D0D, 0x64ED, 0x64EC, 0x64ED, 0x6D0D, 0x756E, 0x85F0, 0x8DB1, 0x7D30, 0x74D0, 
        0x74AF, 0x6CCE, 0x6CAD, 0x648C, 0x750E, 0x8D90, 0x95B1, 0x95D1, 0x8D50, 0x7CCE, 0x7CEF, 0x852F, 0x854F, 0x854E, 0x854E, 0x854D, 0x852D, 0x852D, 0x852D, 0x7D0D, 0x7D2D, 0x7D2E, 0x852E, 0x7D4E, 0x7D2E, 0x7D2E, 0x7D2E, 0x7D2D, 0x7D2D, 0x7D4D, 
        0x7D6E, 0x7D6E, 0x856E, 0x858E, 0x856E, 0x856E, 0x856E, 0x856E, 0x854E, 0x7D0D, 0x7D0D, 0x850D, 0x850D, 0x8D2E, 0x8D2E, 0x8D2E, 0x8D0E, 0x8D0E, 0x950E, 0x950D, 0x950D, 0x950D, 0x9D0D, 0x9D0E, 0x9D2E, 0xA52E, 0xA52E, 0xAD2E, 0xAD2E, 0xAD2E, 
        0xAD4E, 0xAD4E, 0xAD2E, 0xAD4E, 0xB54E, 0xB54F, 0xB54F, 0xB56F, 0xBD4F, 0xBD4F, 0xB52F, 0xB50F, 0xACEE, 0xA48E, 0x9C4E, 0x942E, 0x8BEE, 0x7BCD, 0x73AC, 0x5B2A, 0x5308, 0x42E7, 0x3AE6, 0x32E6, 0x2AE5, 0x2AE5, 0x2AE5, 0x2B05, 0x2B05, 0x2AE5, 
        0x2AE5, 0x2AE5, 0x32E5, 0x32C6, 0x32C6, 0x32C6, 0x32C6, 0x3AC6, 0x3AA6, 0x3AA6, 0x3A86, 0x3A46, 0x52C8, 0x738B, 0x7BAC, 0x942E, 0xACD1, 0xACF0, 0xACF0, 0xAD0F, 0xAD0F, 0xB50F, 0xB50F, 0xACEF, 0xAD2F, 0xB54F, 0xAD2F, 0xA50E, 0xA50E, 0x9D0E, 
        0x94EE, 0x8C8D, 0x8C8E, 0x7C2E, 0x73CD, 0x6BCD, 0x63EC, 0x640B, 0x642B, 0x642A, 0x642A, 0x6409, 0x6429, 0x642A, 0x642A, 0x6C4A, 0x6C4A, 0x642A, 0x642A, 0x5C0A, 0x5C2B, 0x644B, 0x744B, 0x8CAC, 0x9CED, 0x9D0D, 0xA50D, 0xA50D, 0xA52D, 0xA52D, 
        0xA52D, 0xA52D, 0x9D0D, 0x94ED, 0x7C8C, 0x642A, 0x540A, 0x4BEA, 0x4C2B, 0x64EE, 0x6D2F, 0x6D2F, 0x750F, 0x74CE, 0x644C, 0x5BEB, 0x53A9, 0x5388, 0x4348, 0x3B27, 0x3B27, 0x3B48, 0x4389, 0x4BAB, 0x53AC, 0x538D, 0x536F, 0x4B10, 0x4270, 0x4231, 
        0x39F1, 0x3191, 0x3171, 0x3172, 0x3152, 0x3174, 0x3174, 0x3175, 0x3196, 0x39B6, 0x39B6, 0x39B6, 0x3997, 0x39B7, 0x39B7, 0x39D7, 0x41D8, 0x39D7, 0x39D7, 0x39D7, 0x39D7, 0x39D8, 0x39F8, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39FA, 
        0x39FA, 0x39FA, 0x39FA, 0x39FA, 0x39FA, 0x31DA, 0x31DA, 0x31FB, 0x31FB, 0x39FB, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A3B, 0x3A3A, 0x3A3A, 0x3A3A, 0x3A3A, 0x3A3A, 0x3A1A, 0x3A3A, 0x3A3A, 0x4259, 0x4279, 0x4A99, 
        0x4AB9, 0x52D9, 0x635A, 0x845D, 0xA57F, 0xB61E, 0xB63C, 0xB65A, 0xB698, 0xAE78, 0xA676, 0x9E34, 0x9614, 0x95F4, 0x7D34, 0x6C75, 0x6BF7, 0x6379, 0x6B3B, 0x6B3D, 0x6B5D, 0x6396, 0x4B4E, 0x438A, 0x4389, 0x4389, 0x4389, 0x43A9, 0x4BCA, 0x4BC9, 
        0x53EA, 0x5C2B, 0x74CE, 0x8D51, 0x9DD3, 0xA5F4, 0xAE35, 0xAE35, 0xB655, 0xBEB6, 0xB675, 0x9DB2, 0x8D71, 0x8DB1, 0x85B1, 0x5CCD, 0x33C9, 0x33C8, 0x33E9, 0x442A, 0x4C2A, 0x3BA8, 0x3B88, 0x4387, 0x43A7, 0x43A7, 0x43C8, 0x4BE8, 0x4C08, 0x4C08, 
        0x4C08, 0x4C08, 0x4BE8, 0x43E9, 0x43AA, 0x3B8C, 0x438D, 0x544F, 0x64D1, 0x6CF1, 0x6CB1, 0x4B6C, 0x3AAA, 0x326A, 0x326A, 0x3A69, 0x3A89, 0x4AC9, 0x532A, 0x534A, 0x5B6A, 0x5B6A, 0x638A, 0x638A, 0x6B89, 0x6BAA, 0x6BAA, 0x6BAA, 0x6BAA, 0x6BAA, 
        0x6BAA, 0x63C9, 0x63CA, 0x6BCA, 0x63CA, 0x63EA, 0x6BEA, 0x6BEA, 0x7C4C, 0x7C4C, 0x740B, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEB, 0x6BEB, 0x6BEB, 0x6BEB, 0x740B, 0x73EB, 0x740B, 0x7C2B, 0x7C2C, 0x7C2C, 0x7C2B, 0x742B, 0x742B, 0x742B, 0x744C, 
        0x744C, 0x6C6C, 0x748C, 0x748D, 0x6C6C, 0x6C6C, 0x746C, 0x746C, 0x746C, 0x746C, 0x6C4B, 0x6C2B, 0x6C4B, 0x742B, 0x742B, 0x6C2B, 0x6C2A, 0x6C0B, 0x6BEA, 0x6BEA, 0x6BEA, 0x63EA, 0x63CB, 0x63CB, 0x63AB, 0x5BAC, 0x5BAC, 0x53AC, 0x53AC, 0x5BED, 
        0x5BCD, 0x4BAC, 0x4B8B, 0x538B, 0x53CC, 0x4C0D, 0x3BCB, 0x33CA, 0x2BEA, 0x2BEA, 0x33E9, 0x3409, 0x340A, 0x340A, 0x340A, 0x3409, 0x3409, 0x3429, 0x3429, 0x2C29, 0x2C29, 0x2C29, 0x3449, 0x3449, 0x3C69, 0x3C69, 0x4CAA, 0x64EC, 0x74ED, 0x7CED, 
        0x850D, 0x84ED, 0x74AB, 0x6C8B, 0x6C6B, 0x6C6A, 0x6C4A, 0x6449, 0x6C4A, 0x746A, 0x7C6B, 0x7C8C, 0x744C, 0x5BCA, 0x4328, 0x32C7, 0x32A7, 0x42C9, 0x5B8C, 0x6C0E, 0x846F, 0x8C90, 0x8C6F, 0x8C4F, 0x94B0, 0x9CCF, 0x9CCF, 0x9CEF, 0x950F,
  0x540A, 0x53EA, 0x540A, 0x540A, 0x542A, 0x544A, 0x5C6B, 0x5C6B, 0x5C8B, 0x64CC, 0x74ED, 0x7D0E, 0x9571, 0xA5F3, 0xA5F3, 0x9570, 0x852F, 0x7D0E, 0x7D0E, 0x750E, 0x752D, 0x6D2D, 0x650D, 0x650D, 0x650D, 0x6D0D, 0x756E, 0x85F0, 0x8DD1, 0x7D30, 0x74D0, 
        0x74AF, 0x74AE, 0x6C8D, 0x6CAD, 0x74EE, 0x8530, 0x9571, 0x9571, 0x84EF, 0x7CEF, 0x850F, 0x854E, 0x854E, 0x854E, 0x854E, 0x854D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2E, 0x854E, 0x854E, 0x854E, 0x7D4E, 0x7D2E, 0x7D4D, 0x7D4E, 0x856E, 
        0x858F, 0x856E, 0x856F, 0x8D6E, 0x852D, 0x7D0D, 0x7D0D, 0x7D0D, 0x7D0D, 0x7CED, 0x850D, 0x84ED, 0x8CED, 0x8D0E, 0x950E, 0x952E, 0x952E, 0x952E, 0x952E, 0x9D2E, 0x9D0D, 0x9D0E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD4E, 
        0xAD4F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xBD4F, 0xBD50, 0xB50F, 0xB4EF, 0xA48E, 0x942E, 0x8BEE, 0x83EE, 0x7BCE, 0x73CE, 0x6BAD, 0x5B4A, 0x4308, 0x3AC7, 0x32E6, 0x32E6, 0x2AE5, 0x2AE5, 0x2AE5, 0x22E5, 0x2AE5, 0x2AE5, 
        0x2AC5, 0x2AC5, 0x2AC6, 0x32A6, 0x32A6, 0x32A6, 0x3AA6, 0x3286, 0x3266, 0x3A66, 0x4266, 0x5B09, 0x840D, 0x8BED, 0x9C6F, 0xB511, 0xB510, 0xB510, 0xB50F, 0xB50F, 0xB50F, 0xB50F, 0xB50E, 0xB52F, 0xB54F, 0xB54F, 0xAD2F, 0xA50E, 0xA4EE, 0x9CEE, 
        0x7C2B, 0x844D, 0x844E, 0x740E, 0x6BCD, 0x63CC, 0x63EB, 0x640B, 0x642A, 0x5C2A, 0x5C09, 0x5C09, 0x5C29, 0x642A, 0x642A, 0x644A, 0x6C4A, 0x644A, 0x642B, 0x642B, 0x642B, 0x6C4C, 0x746C, 0x8CCC, 0x9CED, 0x9CED, 0x9D0D, 0xA50D, 0xA50D, 0xA52D, 
        0xA52D, 0x9D0D, 0x94ED, 0x84AD, 0x6C6B, 0x53EA, 0x4BEA, 0x4BEB, 0x546C, 0x6D0E, 0x6D4F, 0x754F, 0x754F, 0x750F, 0x6C8D, 0x5BEB, 0x4B89, 0x4348, 0x3327, 0x3326, 0x3347, 0x3BA8, 0x43C9, 0x4C0A, 0x540B, 0x53EC, 0x53ED, 0x538E, 0x4B2E, 0x4ACF, 
        0x4291, 0x3A11, 0x31B1, 0x3191, 0x3171, 0x3152, 0x3153, 0x3174, 0x3195, 0x3195, 0x3196, 0x39B6, 0x3996, 0x3996, 0x39B6, 0x39D7, 0x39D7, 0x39D7, 0x39D7, 0x39D7, 0x39D7, 0x39F8, 0x39F8, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39F9, 
        0x39F9, 0x39D9, 0x39D9, 0x39FA, 0x39F9, 0x31FA, 0x39FA, 0x31FA, 0x39FA, 0x39FA, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A1B, 0x3A3B, 0x3A3B, 0x3A3B, 0x3A3A, 0x3A3A, 0x3A3A, 0x3A3A, 0x425A, 0x425A, 0x3A3A, 0x3A3A, 0x4259, 0x4259, 0x4278, 0x4AB8, 0x5B19, 
        0x6379, 0x73FA, 0x849A, 0x9D3B, 0xB61C, 0xBE9B, 0xBEBA, 0xBEB8, 0xB6B7, 0xB6B6, 0xAE95, 0x9E34, 0x9633, 0x8DF3, 0x7D72, 0x6CD2, 0x6C73, 0x63F5, 0x6BB6, 0x6B98, 0x7C3A, 0x6C14, 0x4B6D, 0x438A, 0x4389, 0x43A9, 0x43A9, 0x43A9, 0x4BCA, 0x4BEA, 
        0x4BEA, 0x53EA, 0x5C0B, 0x644D, 0x8530, 0xA614, 0xAE35, 0xAE35, 0xAE35, 0xBE76, 0xBEB6, 0xAE14, 0x9591, 0x8D90, 0x85B1, 0x754F, 0x546C, 0x3BE9, 0x33A8, 0x3BE9, 0x442A, 0x440A, 0x3B88, 0x3B87, 0x43A7, 0x43C8, 0x43C8, 0x4BE8, 0x4C08, 0x4C08, 
        0x4C08, 0x4C08, 0x4BE8, 0x4BE9, 0x43C9, 0x3BAB, 0x3B8C, 0x4C0E, 0x64D0, 0x6D31, 0x6D10, 0x542D, 0x3B2B, 0x3ACA, 0x3AAA, 0x3A8A, 0x3A69, 0x3A69, 0x3A69, 0x4289, 0x4AA9, 0x4AC9, 0x5309, 0x5B29, 0x636A, 0x638A, 0x638A, 0x638A, 0x638A, 0x63AA, 
        0x63AA, 0x63AA, 0x63AA, 0x63A9, 0x63A9, 0x63CA, 0x63A9, 0x63A9, 0x6BCA, 0x6BEA, 0x6BEA, 0x6BCA, 0x6BCA, 0x6BCA, 0x6BEA, 0x6BEB, 0x6BEB, 0x6C0B, 0x740B, 0x740B, 0x7C2C, 0x7C4C, 0x846C, 0x846C, 0x848D, 0x848D, 0x742B, 0x742B, 0x6C2B, 0x6C4C, 
        0x6C4C, 0x6C6C, 0x6C6C, 0x746C, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2A, 0x6C0A, 0x740B, 0x6C0A, 0x6C0A, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x63CA, 0x63CA, 0x5BCB, 0x5BAB, 0x5BAB, 0x53AB, 0x5BAC, 
        0x5BCC, 0x53AC, 0x53AD, 0x5BAC, 0x53AC, 0x4BAC, 0x3BCB, 0x33CA, 0x33CA, 0x33EA, 0x340A, 0x340A, 0x342A, 0x340A, 0x340A, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3449, 0x3C49, 0x3C69, 0x4489, 0x54AA, 0x64EC, 0x74ED, 0x7CEC, 
        0x74CC, 0x74AB, 0x6C8A, 0x646A, 0x644A, 0x6449, 0x6C49, 0x6C49, 0x744A, 0x7C6B, 0x7C6C, 0x7C4C, 0x6C0B, 0x5389, 0x4308, 0x4329, 0x4B4A, 0x5B4B, 0x636C, 0x73EE, 0x8C90, 0x94B0, 0x94D0, 0x94B0, 0x9CF0, 0x9D0F, 0x9D0F, 0x9D0F, 0x952F,
  0x542B, 0x5C2B, 0x542B, 0x544B, 0x546B, 0x5C6B, 0x5CAC, 0x64CC, 0x64CC, 0x6CED, 0x74EE, 0x7CAD, 0x7C8D, 0x7C6D, 0x8D10, 0x9550, 0x8D0F, 0x850E, 0x7D0E, 0x7D0E, 0x752D, 0x6D0D, 0x6D2D, 0x6D4D, 0x6D4E, 0x6D4D, 0x75AF, 0x85F0, 0x8DD2, 0x7D51, 0x74D0, 
        0x6C8F, 0x74AE, 0x6C8D, 0x6C8D, 0x74CE, 0x8510, 0x8D51, 0x84EF, 0x84EF, 0x850F, 0x850F, 0x854E, 0x854E, 0x854E, 0x854E, 0x7D4D, 0x7D2D, 0x7D2D, 0x7D2D, 0x7D2D, 0x854E, 0x854E, 0x854E, 0x856E, 0x856E, 0x7D4E, 0x856E, 0x856E, 0x856E, 0x856F, 
        0x856F, 0x7D2E, 0x7D0D, 0x7D0D, 0x850D, 0x852E, 0x852E, 0x852E, 0x852E, 0x8D0E, 0x8D0D, 0x8D0D, 0x8CED, 0x950D, 0x950E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D2E, 0xA52E, 0xA54E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD4F, 0xAD4F, 0xAD4F, 
        0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB52F, 0xB52F, 0xB50F, 0xB50F, 0xB4EF, 0xAC8E, 0xA46E, 0x9C2E, 0x93EE, 0x83AE, 0x73AE, 0x73CF, 0x6BCE, 0x63CD, 0x536B, 0x42E8, 0x32C7, 0x32E6, 0x2AE5, 0x2AE5, 0x2AC6, 0x2AC6, 0x2AE5, 0x2AC5, 0x2AC5, 
        0x2AC5, 0x2AC5, 0x2AA6, 0x3286, 0x3286, 0x3A86, 0x3A86, 0x3A66, 0x3A46, 0x4A87, 0x738B, 0x8C4E, 0x9C8F, 0xA4AF, 0xB4F0, 0xBD30, 0xB52F, 0xB50F, 0xB52F, 0xB50F, 0xB50E, 0xB50E, 0xB50E, 0xB52F, 0xB54F, 0xB54F, 0xAD2E, 0xA50E, 0x9CEE, 0x948D, 
        0x842C, 0x842D, 0x7C0E, 0x73EE, 0x6BCD, 0x63EC, 0x5C0A, 0x5C0A, 0x5C2A, 0x5C2A, 0x5429, 0x5409, 0x5C29, 0x642A, 0x642A, 0x644A, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C4C, 0x644C, 0x6C4C, 0x7C8C, 0x8CCC, 0x94EC, 0x9CEC, 0x9CED, 0x9D0D, 0xA50D, 0xA50D, 
        0x9D0D, 0x9D0D, 0x8CCC, 0x748C, 0x642A, 0x53EA, 0x4BEA, 0x5C4C, 0x6CEE, 0x754F, 0x754F, 0x756F, 0x7D4F, 0x7D2F, 0x6CCD, 0x53EA, 0x3B47, 0x3327, 0x2B47, 0x2B67, 0x33A7, 0x33C8, 0x43E9, 0x4C0A, 0x4C2B, 0x542B, 0x542B, 0x53EC, 0x4BAC, 0x4B8D, 
        0x4B4E, 0x4AD0, 0x4271, 0x31D0, 0x3190, 0x2951, 0x2951, 0x2952, 0x3174, 0x3174, 0x3195, 0x3195, 0x3195, 0x3996, 0x39B6, 0x39D6, 0x39D6, 0x39D6, 0x39D7, 0x39D7, 0x39D7, 0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x3A19, 0x3A19, 0x39F9, 0x39F9, 0x39F9, 
        0x39F9, 0x39F9, 0x39F9, 0x39F9, 0x39D9, 0x31FA, 0x39FA, 0x39FA, 0x39FA, 0x3A1A, 0x3A1A, 0x3A1A, 0x3A3A, 0x423A, 0x425B, 0x423B, 0x423A, 0x423A, 0x425A, 0x425A, 0x425A, 0x4259, 0x4259, 0x4259, 0x4279, 0x4A98, 0x4AB8, 0x52F8, 0x5B78, 0x745A, 
        0x7C79, 0x84B8, 0x9559, 0xA5B9, 0xC6BB, 0xC6D9, 0xC6F9, 0xC6F8, 0xB6B6, 0xAEB5, 0xAEB5, 0x9E53, 0x9612, 0x85D2, 0x7571, 0x6D11, 0x6CD0, 0x6451, 0x63F2, 0x63D2, 0x84B5, 0x7471, 0x53CC, 0x4BAA, 0x4BAA, 0x43A9, 0x43A9, 0x43C9, 0x4BCA, 0x4BEA, 
        0x4C0A, 0x4C0A, 0x4BEA, 0x648D, 0x74EF, 0x9592, 0xAE14, 0xAE14, 0xAE14, 0xB655, 0xBEB6, 0xB695, 0x9DF2, 0x9591, 0x8590, 0x8591, 0x7D90, 0x546C, 0x33A8, 0x33A8, 0x3BC9, 0x43EA, 0x43C9, 0x3B88, 0x43A8, 0x43C8, 0x43C8, 0x4BE8, 0x4C08, 0x4C08, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE9, 0x43AA, 0x3BAB, 0x43CC, 0x548E, 0x6510, 0x6D30, 0x5CAE, 0x438B, 0x3B2A, 0x3B0A, 0x3B0A, 0x3AEA, 0x3ACA, 0x428A, 0x3A6A, 0x3A69, 0x3A89, 0x534B, 0x534B, 0x4B0A, 0x5309, 0x5309, 0x5B4A, 0x636A, 0x638A, 
        0x638A, 0x638A, 0x63AA, 0x63AA, 0x63AA, 0x63AA, 0x63A9, 0x6389, 0x63A9, 0x6BA9, 0x63A9, 0x63A9, 0x63A9, 0x63A9, 0x63C9, 0x63CA, 0x6C0B, 0x744C, 0x744C, 0x6C0B, 0x6BEA, 0x6C0B, 0x742B, 0x742B, 0x742B, 0x7C6C, 0x744C, 0x6C2B, 0x6C0B, 0x6C0B, 
        0x63EA, 0x640A, 0x6C0A, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C2A, 0x6C2A, 0x742A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2A, 0x742A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6BEA, 0x6C0A, 0x6C0A, 0x63EA, 0x63EA, 0x5BCA, 0x5BCA, 0x5BCA, 0x5BCA, 0x5BAB, 
        0x5BAC, 0x5BAC, 0x5BCD, 0x5BCE, 0x5BCE, 0x53AD, 0x43CD, 0x3BCB, 0x33CA, 0x33EA, 0x340A, 0x342A, 0x342A, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3429, 0x3C29, 0x3C49, 0x3C69, 0x448A, 0x54AB, 0x6CEC, 0x750D, 0x74CC, 
        0x6C8B, 0x646A, 0x5C69, 0x5C49, 0x5C49, 0x5C29, 0x6429, 0x6C49, 0x746A, 0x846B, 0x846C, 0x7C4D, 0x6C2C, 0x63EB, 0x63EC, 0x6BEC, 0x7C2E, 0x844F, 0x8C4F, 0x8C4F, 0x94AF, 0x94F0, 0x94F0, 0x94EF, 0x94EF, 0x950E, 0x950E, 0x8D2E, 0x8D2E,
  0x5C2B, 0x5C2B, 0x5C2B, 0x5C6C, 0x5CAC, 0x5CAC, 0x650D, 0x6D2D, 0x756E, 0x756F, 0x7D2F, 0x6C0B, 0x4AA7, 0x4A86, 0x6369, 0x742C, 0x7C6D, 0x84CE, 0x7CEE, 0x7CEE, 0x750D, 0x6D0D, 0x6D0D, 0x6D4E, 0x756E, 0x756E, 0x7DCF, 0x85F1, 0x8DD2, 0x8551, 0x7CF0, 
        0x6C8F, 0x74AE, 0x6C8E, 0x6CAE, 0x8530, 0x8D71, 0x84EF, 0x84CF, 0x84EF, 0x850F, 0x852F, 0x854E, 0x854E, 0x854E, 0x854E, 0x7D2D, 0x7D2D, 0x854D, 0x854E, 0x854E, 0x854E, 0x856F, 0x8D6F, 0x856E, 0x7D2E, 0x7D2E, 0x852E, 0x7D2E, 0x7D2D, 0x7D0D, 
        0x7D0D, 0x7CED, 0x7CED, 0x84ED, 0x8D2E, 0x8D4E, 0x8D4E, 0x8D4E, 0x954E, 0x8D2E, 0x952D, 0x952E, 0x950E, 0x950D, 0x950E, 0x9D2E, 0x9D2E, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xAD4E, 0xAD4E, 0xAD4E, 0xAD4F, 0xB54F, 0xB54F, 0xB56F, 
        0xB56F, 0xB56F, 0xB54F, 0xB54F, 0xB52E, 0xB52F, 0xB50F, 0xB4EF, 0xAC8E, 0xA44D, 0x9C2E, 0x9C2E, 0x940F, 0x8C0F, 0x7BEF, 0x73CF, 0x6BCF, 0x63CE, 0x5BCD, 0x5BCC, 0x4329, 0x3AE7, 0x32E6, 0x32E6, 0x2AC6, 0x2AA6, 0x2AC6, 0x2AC6, 0x2AC6, 0x2AC6, 
        0x2AA6, 0x2AA5, 0x2A86, 0x3266, 0x3266, 0x3A46, 0x42A7, 0x634A, 0x5AE9, 0x7BCC, 0x9C8E, 0xA4AF, 0xA4D0, 0xACF0, 0xB510, 0xBD30, 0xBD2F, 0xB52E, 0xB50E, 0xB50E, 0xB50E, 0xB50E, 0xB52E, 0xBD4F, 0xB54F, 0xB54E, 0xAD0E, 0xA4EE, 0x9CAD, 0x842B, 
        0x8C6D, 0x840D, 0x7BEE, 0x7C0E, 0x6BED, 0x5BCB, 0x53EA, 0x540A, 0x5429, 0x5429, 0x542A, 0x542A, 0x5C2A, 0x642A, 0x644A, 0x646A, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C4C, 0x6C4C, 0x6C4C, 0x7C8C, 0x8CEC, 0x94EC, 0x94EC, 0x94EC, 0x9D0D, 0xA52D, 0xA52E, 
        0x9D0D, 0x94ED, 0x84AC, 0x6C4B, 0x5C0A, 0x540B, 0x5C4C, 0x6CCF, 0x7530, 0x7550, 0x754F, 0x754F, 0x752F, 0x6CCD, 0x5C4B, 0x4388, 0x3347, 0x2B46, 0x2B67, 0x2B87, 0x33C7, 0x3BE8, 0x4409, 0x4429, 0x4C4A, 0x4C4A, 0x4C2A, 0x4C0A, 0x4C0A, 0x4BEB, 
        0x4BAC, 0x4B6E, 0x430F, 0x3A90, 0x3210, 0x2990, 0x2970, 0x2971, 0x2952, 0x3173, 0x3194, 0x3194, 0x3195, 0x39B5, 0x39B6, 0x39B6, 0x39D6, 0x39D6, 0x39D6, 0x39D6, 0x39D6, 0x39D7, 0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x3A19, 0x4219, 0x41F9, 0x39F8, 
        0x39F8, 0x39F9, 0x39F9, 0x39F9, 0x39D9, 0x39F9, 0x39F9, 0x3A1A, 0x3A1A, 0x3A1A, 0x3A3A, 0x3A3A, 0x423A, 0x425A, 0x425A, 0x423A, 0x423A, 0x4259, 0x425A, 0x4279, 0x4279, 0x4A79, 0x4258, 0x4277, 0x52F8, 0x5B38, 0x6BD8, 0x7459, 0x7478, 0x7CD8, 
        0x84F7, 0x8D17, 0x9DB8, 0xADF8, 0xCEFA, 0xCF19, 0xCF18, 0xCF18, 0xC717, 0xB6D5, 0xB6F6, 0x9E74, 0x8E12, 0x85D1, 0x7571, 0x6D10, 0x64CF, 0x5C6F, 0x5C0F, 0x6410, 0x7D13, 0x7490, 0x53EC, 0x4BCA, 0x4BCA, 0x4BCA, 0x4BCA, 0x43CA, 0x4BEA, 0x4C0A, 
        0x4C0A, 0x4C0A, 0x4C0B, 0x64AD, 0x750F, 0x74AE, 0x8D71, 0xAE14, 0xAE34, 0xB655, 0xBE96, 0xBEB6, 0xAE34, 0x95B1, 0x8D90, 0x85B1, 0x85D1, 0x6D2E, 0x3BEA, 0x33A8, 0x33A8, 0x3BA9, 0x43C9, 0x43A8, 0x43A8, 0x43A8, 0x43C8, 0x4BE8, 0x4BE8, 0x4C08, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE9, 0x43C9, 0x3BAB, 0x3BAB, 0x4C2D, 0x64F0, 0x6D50, 0x5CEE, 0x440B, 0x3B89, 0x3B69, 0x3B69, 0x3B29, 0x432A, 0x430A, 0x42EB, 0x42CB, 0x4B4C, 0x53CD, 0x640E, 0x642E, 0x5BCD, 0x534B, 0x4B0A, 0x4AE9, 0x532A, 
        0x5B4A, 0x638B, 0x638A, 0x638A, 0x638A, 0x638A, 0x638A, 0x638A, 0x63AA, 0x63AA, 0x63A9, 0x63A9, 0x63A9, 0x63A9, 0x63CA, 0x63CA, 0x6BEA, 0x6C0B, 0x6C0B, 0x63EA, 0x63CA, 0x63CA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6C0B, 0x6C0B, 0x6C0B, 0x6C0B, 
        0x6C0A, 0x63EA, 0x63EA, 0x640A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2A, 0x742A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x63EA, 0x63EA, 0x63CA, 0x5BCA, 0x5BCA, 0x63CB, 
        0x63CB, 0x63CC, 0x63CC, 0x63CD, 0x63EE, 0x5BAE, 0x4BCE, 0x43CD, 0x3BCB, 0x3BEA, 0x3C2B, 0x3C4A, 0x342A, 0x342A, 0x3C2A, 0x3429, 0x3C29, 0x3C29, 0x3429, 0x3429, 0x3429, 0x3429, 0x3C29, 0x3C49, 0x4469, 0x4C8A, 0x54AB, 0x6D0C, 0x750D, 0x74CC, 
        0x648A, 0x5C6A, 0x5C49, 0x5429, 0x5429, 0x5C29, 0x644A, 0x746A, 0x7C6B, 0x7C6C, 0x846D, 0x7C4D, 0x742D, 0x744D, 0x7C6E, 0x846E, 0x8C8F, 0x8CAF, 0x94AF, 0x94AF, 0x94EF, 0x94EF, 0x8CEF, 0x8CCE, 0x8CEE, 0x8CEE, 0x8D0E, 0x850E, 0x852D,
  0x53EB, 0x53EA, 0x5C2B, 0x648C, 0x64AD, 0x64CD, 0x650D, 0x6D4E, 0x758F, 0x7590, 0x7D4F, 0x744D, 0x632A, 0x5AA8, 0x4A26, 0x4AA7, 0x6BCB, 0x7C8D, 0x7CCE, 0x74ED, 0x74ED, 0x6D0D, 0x6D0D, 0x6D2D, 0x756E, 0x758E, 0x7DCF, 0x85F1, 0x85D2, 0x8552, 0x7CD1, 
        0x6C6F, 0x74AF, 0x74CF, 0x8571, 0x9DF3, 0x8D92, 0x8510, 0x850F, 0x850F, 0x850F, 0x852F, 0x854E, 0x854E, 0x854E, 0x854E, 0x7D2E, 0x854E, 0x8D6F, 0x8D6F, 0x8D6F, 0x854F, 0x854F, 0x852E, 0x7CED, 0x74AC, 0x74CC, 0x7CED, 0x7CED, 0x7D0D, 0x84EE, 
        0x84EE, 0x84EE, 0x84ED, 0x84ED, 0x8D0D, 0x8D2E, 0x954E, 0x954E, 0x952E, 0x952D, 0x9D2E, 0x9D2E, 0x9D2E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xAD2E, 0xAD2E, 0xAD4E, 0xAD4F, 0xB54F, 0xB54F, 0xB56F, 0xB56F, 
        0xB54F, 0xB54F, 0xB52F, 0xB52E, 0xB50F, 0xB4EF, 0xB4EF, 0xB4AF, 0xA46E, 0x9C2E, 0x9C2E, 0x942E, 0x8C2F, 0x7C2F, 0x742F, 0x6C0F, 0x63EF, 0x5BEE, 0x5BCE, 0x53CC, 0x4B6A, 0x3AE8, 0x32C7, 0x32C6, 0x2AA6, 0x32C7, 0x32C7, 0x2AA6, 0x2A86, 0x2AA6, 
        0x2AA6, 0x2A85, 0x3266, 0x3266, 0x3246, 0x4AA8, 0x738B, 0x736A, 0x8C2E, 0x9CAF, 0xACEF, 0xB4F0, 0xB50F, 0xB50F, 0xBD2F, 0xBD0F, 0xBD0E, 0xBD0E, 0xBD0E, 0xB50E, 0xB52E, 0xB52E, 0xB54E, 0xBD6F, 0xB54E, 0xB52E, 0xAD0E, 0x9C8C, 0x946C, 0x8C4C, 
        0x842D, 0x83ED, 0x7C0E, 0x73EE, 0x63CC, 0x53EA, 0x4BE9, 0x4C09, 0x4C09, 0x4C29, 0x4C29, 0x542A, 0x5C4A, 0x644A, 0x644A, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C6B, 0x644C, 0x642C, 0x6C4C, 0x746C, 0x84CC, 0x94EC, 0x94EC, 0x9D0D, 0x9D0D, 0xA52D, 0xA52E, 
        0x950D, 0x8CED, 0x7C8B, 0x642B, 0x542B, 0x5C4C, 0x64AE, 0x74EF, 0x7530, 0x7550, 0x6D2F, 0x5CCD, 0x544B, 0x43C9, 0x3388, 0x2B47, 0x2B66, 0x2B67, 0x2B87, 0x33A7, 0x3BC8, 0x3BE8, 0x4409, 0x4C29, 0x4C29, 0x4C09, 0x4C09, 0x4C0A, 0x4C0A, 0x4C0A, 
        0x4BEB, 0x43AB, 0x436C, 0x3B0D, 0x3ACE, 0x3A70, 0x3210, 0x2990, 0x2971, 0x2972, 0x2973, 0x3194, 0x3194, 0x39B5, 0x39B5, 0x39B5, 0x39B5, 0x39B5, 0x39D5, 0x39D5, 0x39D6, 0x39D6, 0x39F7, 0x39F7, 0x39F7, 0x39F8, 0x4218, 0x4218, 0x4218, 0x39F8, 
        0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x39F9, 0x39F9, 0x3A19, 0x3A19, 0x3A19, 0x3A3A, 0x3A3A, 0x423A, 0x423A, 0x427A, 0x425A, 0x4239, 0x4259, 0x4A79, 0x4A99, 0x4A98, 0x4A98, 0x4AB8, 0x5B18, 0x6398, 0x7438, 0x7477, 0x7496, 0x7CD6, 0x7CF5, 0x7D14, 
        0x8535, 0x9596, 0xA5D7, 0xADF6, 0xC6D9, 0xD719, 0xCF18, 0xCF18, 0xC737, 0xC737, 0xBF37, 0xA694, 0x8DF2, 0x7DB1, 0x7550, 0x6D10, 0x64AF, 0x5C6E, 0x5C2E, 0x642F, 0x7D12, 0x74D0, 0x53EB, 0x4BCA, 0x4BCA, 0x4BEA, 0x4BEA, 0x43EA, 0x4BEA, 0x4C0A, 
        0x4C0A, 0x440A, 0x4C0A, 0x544C, 0x6CCE, 0x648D, 0x644C, 0x8D30, 0xA614, 0xB655, 0xB675, 0xBEB6, 0xB695, 0xA633, 0x8D91, 0x8DB1, 0x8DD1, 0x7D90, 0x5CCD, 0x33A9, 0x3388, 0x3388, 0x3BA9, 0x43A9, 0x43A8, 0x43A8, 0x43C8, 0x4BE8, 0x4BE8, 0x4BE8, 
        0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C9, 0x3BAA, 0x3B8B, 0x43EC, 0x5CCF, 0x6D51, 0x6530, 0x4C6B, 0x3BC8, 0x3BA8, 0x3BA8, 0x3B88, 0x3B68, 0x4349, 0x3B4A, 0x434A, 0x4BCC, 0x4C0D, 0x544E, 0x5C6F, 0x6C70, 0x6C90, 0x7490, 0x6C4F, 0x63CC, 
        0x530A, 0x5B6B, 0x63AB, 0x638B, 0x6B8A, 0x636A, 0x5B49, 0x5B29, 0x6349, 0x638A, 0x638A, 0x63AA, 0x63AA, 0x63CA, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63EA, 0x63CA, 0x63C9, 0x63C9, 0x63C9, 0x63CA, 0x63CA, 0x63CA, 0x6BEA, 0x6BEA, 0x6BEA, 0x742B, 
        0x6C2B, 0x6C0A, 0x6C0A, 0x6C0A, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6BEA, 0x6C09, 0x6BE9, 0x6BE9, 0x6BEA, 0x6BEA, 0x6C0A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 
        0x63EB, 0x63EC, 0x63EC, 0x63CD, 0x63CE, 0x5BCF, 0x53CF, 0x540E, 0x43ED, 0x3BEB, 0x3C2B, 0x3C4B, 0x342A, 0x342A, 0x3C2A, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3429, 0x3429, 0x3C29, 0x3C29, 0x3C49, 0x4469, 0x4C8A, 0x54AA, 0x6CEC, 0x6D0C, 0x6CAB, 
        0x5C6A, 0x5C6A, 0x5429, 0x5429, 0x5409, 0x5C29, 0x6C6A, 0x7C6B, 0x7C6B, 0x7C6C, 0x7C6D, 0x7C2D, 0x740D, 0x844D, 0x8C8E, 0x8CAE, 0x94AE, 0x94CF, 0x94EE, 0x94CE, 0x94EE, 0x8CEE, 0x84EE, 0x84CD, 0x84CD, 0x7CEE, 0x7D0E, 0x7D0E, 0x7D0D,
  0x5BEB, 0x5C0B, 0x5C4B, 0x64AD, 0x64AD, 0x5CCC, 0x64EC, 0x652D, 0x6D6E, 0x758F, 0x7D4F, 0x84EF, 0x8C4F, 0x83CD, 0x6B0A, 0x5AC8, 0x5309, 0x742C, 0x7CAE, 0x74CD, 0x74ED, 0x6CED, 0x6CEC, 0x6D0D, 0x754D, 0x758E, 0x7DAF, 0x85D1, 0x8591, 0x8531, 0x7CD1, 
        0x6C6F, 0x748F, 0x7CCF, 0x95B2, 0x8D71, 0x7D0F, 0x8530, 0x8530, 0x852F, 0x852F, 0x852F, 0x854E, 0x854F, 0x854F, 0x852E, 0x7D0E, 0x854E, 0x854F, 0x854F, 0x852E, 0x7CEE, 0x74AD, 0x74AD, 0x74AD, 0x7CCD, 0x84EE, 0x850E, 0x850E, 0x850D, 0x84EE, 
        0x8CEE, 0x850E, 0x8CEE, 0x8CED, 0x8CED, 0x950E, 0x952E, 0x9D2E, 0x950E, 0x9D0E, 0x9D0E, 0xA52E, 0xA54F, 0x9D2E, 0x9D2E, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD2E, 0xAD4E, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 0xB54F, 
        0xB54F, 0xB52F, 0xB50F, 0xB50F, 0xB4EF, 0xB4CF, 0xACAF, 0xA46F, 0xA42E, 0x9C0E, 0x940E, 0x8C4F, 0x7C6F, 0x746F, 0x6C4F, 0x644F, 0x5C0F, 0x5C0E, 0x5BCE, 0x5BCD, 0x538C, 0x3AE9, 0x3AC8, 0x536A, 0x746E, 0x748E, 0x3B08, 0x2A86, 0x2A86, 0x2A86, 
        0x2A86, 0x3266, 0x3266, 0x3A26, 0x4AA8, 0x7BCC, 0x7BAB, 0x9C8E, 0xA4CF, 0xACF0, 0xB530, 0xBD2F, 0xB50F, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD2E, 0xB52E, 0xBD2E, 0xBD4E, 0xBD4F, 0xBD4F, 0xB52E, 0xAD0E, 0xA4EE, 0x8C4C, 0x8C4C, 0x8C6D, 
        0x842D, 0x83EE, 0x7BCE, 0x6BCD, 0x5BEC, 0x53EA, 0x4C09, 0x4C09, 0x4C09, 0x4C29, 0x4C29, 0x542A, 0x5C4A, 0x646A, 0x646B, 0x6C8B, 0x6C8B, 0x6C8B, 0x6C6B, 0x642B, 0x5C2B, 0x642C, 0x744B, 0x84AC, 0x8CCC, 0x94EC, 0x9CED, 0x9D0D, 0x9D0D, 0x9D0D, 
        0x8CED, 0x84CC, 0x6C4B, 0x644B, 0x5C6C, 0x648D, 0x6CEF, 0x7510, 0x7530, 0x6D0F, 0x5C8C, 0x3BC9, 0x3387, 0x2B47, 0x2B46, 0x2B66, 0x2B87, 0x2BA7, 0x33A7, 0x33C8, 0x3BE8, 0x4409, 0x4C09, 0x4C29, 0x4C09, 0x4C09, 0x4C09, 0x4BE9, 0x4409, 0x440A, 
        0x440A, 0x43EA, 0x43AA, 0x3B8B, 0x3B4C, 0x3B0E, 0x3ACE, 0x326F, 0x3210, 0x29B0, 0x2991, 0x2992, 0x3193, 0x3194, 0x31B4, 0x39B5, 0x39B5, 0x39D5, 0x39D5, 0x31B5, 0x39B5, 0x39D6, 0x39F6, 0x39F7, 0x39F7, 0x3A17, 0x4217, 0x4218, 0x4218, 0x39F8, 
        0x39F8, 0x39F8, 0x39F8, 0x39F8, 0x3A18, 0x3A19, 0x3A19, 0x3A39, 0x3A39, 0x4239, 0x4259, 0x4239, 0x425A, 0x425A, 0x4259, 0x4259, 0x4A99, 0x4AB9, 0x4AB8, 0x52F7, 0x6378, 0x7439, 0x84BA, 0x84D8, 0x84F6, 0x8515, 0x7CF4, 0x7D34, 0x7D33, 0x7D33, 
        0x8553, 0x9DB5, 0xA5F6, 0xA5B5, 0xC698, 0xCF19, 0xCF18, 0xC6F7, 0xC6F6, 0xC737, 0xBF16, 0xA694, 0x85D2, 0x7570, 0x6D2F, 0x64EF, 0x5CAE, 0x546E, 0x542E, 0x5C0E, 0x7CF2, 0x74D0, 0x53EC, 0x53EA, 0x4BEA, 0x4BEA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C0A, 
        0x4C0A, 0x440A, 0x4C0A, 0x4C0A, 0x5C6C, 0x648D, 0x4BAA, 0x53CA, 0x7CEF, 0xA614, 0xB655, 0xBE95, 0xB695, 0xAE74, 0x9DD2, 0x8DB1, 0x8DB1, 0x7DB0, 0x7D90, 0x54AC, 0x33A8, 0x3388, 0x3BA8, 0x43A8, 0x4388, 0x43A8, 0x43C8, 0x4BE8, 0x4BE8, 0x4BE8, 
        0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C9, 0x3BAA, 0x3B8B, 0x3BCB, 0x548E, 0x6550, 0x6D70, 0x54CC, 0x3BE8, 0x3BC7, 0x3BC7, 0x3BA8, 0x3B88, 0x3B88, 0x3B89, 0x3B89, 0x440B, 0x4C4D, 0x546E, 0x5C8F, 0x6490, 0x6CB0, 0x74D1, 0x74D1, 0x74D0, 
        0x642D, 0x5BCB, 0x63AB, 0x5B6A, 0x5B2A, 0x5B29, 0x5309, 0x52E9, 0x5309, 0x636A, 0x6BAB, 0x63AA, 0x63CA, 0x63CA, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63CA, 0x63CA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x6BEA, 0x6BEA, 0x6C0B, 0x744B, 
        0x6C2B, 0x6C0A, 0x6BEA, 0x63E9, 0x6BE9, 0x6BC9, 0x6BE9, 0x63C9, 0x6BC9, 0x63E9, 0x6BE9, 0x6BE9, 0x6BE9, 0x6BEA, 0x6C0A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C09, 0x63E9, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x640A, 0x6C0A, 
        0x6C2B, 0x6C2B, 0x6C2C, 0x6C0D, 0x63EE, 0x5BCE, 0x5BCF, 0x5C0F, 0x542F, 0x4C0D, 0x3C0C, 0x3C2B, 0x3C2A, 0x342A, 0x3C2A, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x4429, 0x4449, 0x4C69, 0x4C6A, 0x5CAA, 0x6D0C, 0x6CEC, 0x648B, 
        0x5C6A, 0x5449, 0x5429, 0x5408, 0x5429, 0x644A, 0x746B, 0x846B, 0x846C, 0x846D, 0x844D, 0x7C0D, 0x844E, 0x8C6E, 0x94AE, 0x8CAE, 0x8CCE, 0x8CCE, 0x8CEE, 0x8CEE, 0x8CEE, 0x84EE, 0x84EE, 0x7CCD, 0x7CCD, 0x7CED, 0x7CED, 0x7D0D, 0x7D0D,
  0x6C4D, 0x6C4C, 0x6C8C, 0x7D2F, 0x754F, 0x64CD, 0x5CAC, 0x650D, 0x654E, 0x756F, 0x754F, 0x8510, 0x9CD0, 0x8C0F, 0x7B8C, 0x7BCC, 0x73EC, 0x740C, 0x746D, 0x74AD, 0x74CD, 0x6CCD, 0x6CCC, 0x6CEC, 0x6D2D, 0x756E, 0x7DB0, 0x85B0, 0x8551, 0x8552, 0x8512, 
        0x6C6F, 0x74AF, 0x8530, 0x8D72, 0x7D10, 0x7D2F, 0x8550, 0x8550, 0x7D4F, 0x7D4F, 0x854F, 0x854F, 0x8D6F, 0x854F, 0x7D0E, 0x74CD, 0x74CE, 0x74CD, 0x74AD, 0x748C, 0x748D, 0x748C, 0x7CAD, 0x7CAD, 0x84CD, 0x84CD, 0x8CEE, 0x8CED, 0x8CED, 0x8CED, 
        0x8CED, 0x8CED, 0x8CED, 0x94ED, 0x94ED, 0x950D, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D2E, 0xA54E, 0x9D2E, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xA52E, 0xAD2E, 0xAD2E, 0xAD0E, 0xAD2E, 0xAD2E, 0xB54F, 0xB54F, 0xB54F, 0xB52F, 0xAD2F, 
        0xAD2F, 0xACEF, 0xACCE, 0xACAE, 0xACAE, 0xAC8E, 0xA46E, 0x9C2E, 0x93ED, 0x8BEE, 0x840E, 0x744F, 0x6C8F, 0x6CAF, 0x648F, 0x648F, 0x5C4F, 0x5C0E, 0x5BCE, 0x5BAE, 0x5B8D, 0x532C, 0x530B, 0x7C2F, 0x742E, 0x4B09, 0x3287, 0x3266, 0x2A66, 0x3266, 
        0x3266, 0x3246, 0x3A26, 0x5288, 0x840E, 0x944E, 0x9C8F, 0xACCF, 0xB510, 0xBD50, 0xC570, 0xBD4F, 0xBD0E, 0xBD0E, 0xB4ED, 0xB4EE, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD4E, 0xBD4E, 0xBD4E, 0xBD2E, 0xB52E, 0xB52E, 0xAD0E, 0xA4CD, 0x944C, 0x8C6C, 0x8C6E, 
        0x8C6F, 0x83EE, 0x7BCE, 0x63CD, 0x53CB, 0x4BEA, 0x4409, 0x43E9, 0x4409, 0x4429, 0x4C29, 0x5449, 0x5C4A, 0x646A, 0x648B, 0x6CAB, 0x6CAB, 0x6C8B, 0x646B, 0x5C2B, 0x5C0B, 0x644B, 0x6C4B, 0x84AC, 0x8CCC, 0x94CC, 0x94ED, 0x950D, 0x950D, 0x94ED, 
        0x84AC, 0x746B, 0x642A, 0x5C4B, 0x64AD, 0x6CCE, 0x74EF, 0x74EF, 0x6CCE, 0x544C, 0x3BA8, 0x2B47, 0x2B67, 0x2367, 0x2B87, 0x2BA7, 0x33A7, 0x33C8, 0x3BE8, 0x43E8, 0x4409, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x43E9, 0x43E9, 0x4409, 
        0x4C0A, 0x4C2B, 0x4C0B, 0x43EB, 0x43AB, 0x3B4B, 0x332B, 0x330C, 0x32CE, 0x328E, 0x324F, 0x29F0, 0x29D1, 0x31B2, 0x3193, 0x31B4, 0x39B4, 0x39D4, 0x39D4, 0x39B4, 0x39B4, 0x39B5, 0x39D5, 0x39F5, 0x39F6, 0x41F6, 0x41F7, 0x4217, 0x4217, 0x4217, 
        0x39F7, 0x39F7, 0x39F7, 0x3A18, 0x3A18, 0x3A18, 0x3A38, 0x4239, 0x4239, 0x4239, 0x4259, 0x4279, 0x4279, 0x4A79, 0x4A78, 0x4A78, 0x52B8, 0x52F8, 0x6378, 0x7418, 0x84B8, 0x8D38, 0x9556, 0x8D54, 0x8573, 0x8573, 0x8552, 0x8552, 0x7D32, 0x8573, 
        0x8D94, 0x95B4, 0xAE16, 0xAE37, 0xBE77, 0xCED8, 0xCF18, 0xC6F7, 0xBED6, 0xBED5, 0xA653, 0x9612, 0x85B1, 0x7550, 0x650F, 0x5CCF, 0x548E, 0x544E, 0x542E, 0x5C0E, 0x7CF1, 0x74D0, 0x5C0C, 0x53EB, 0x53EB, 0x4BEB, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 
        0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C2A, 0x64CD, 0x4C0A, 0x4369, 0x53AA, 0x748E, 0x9D92, 0xB675, 0xBE96, 0xB675, 0xAE54, 0x95D1, 0x8591, 0x8590, 0x7D90, 0x6D4F, 0x548C, 0x43EA, 0x3BA8, 0x3BA8, 0x43A8, 0x43A8, 0x43C8, 0x4BE8, 0x4BE8, 0x4BE8, 
        0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x43C9, 0x43AA, 0x3B8B, 0x3BAB, 0x4C4D, 0x5D0F, 0x6D90, 0x5D2D, 0x4449, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BA7, 0x3BA8, 0x3BA8, 0x3BC9, 0x442B, 0x4C4D, 0x4C8E, 0x54AF, 0x5CB0, 0x64D0, 0x6CF1, 0x6CF1, 0x74F0, 
        0x644D, 0x53CB, 0x5BAB, 0x638B, 0x5B6B, 0x5B4A, 0x5B4A, 0x5B6B, 0x5B8B, 0x638B, 0x6BCC, 0x6BEC, 0x6BCB, 0x6BCB, 0x6BEA, 0x6BEA, 0x640A, 0x640A, 0x63EA, 0x640A, 0x6C0B, 0x6C0B, 0x6C2B, 0x6C2B, 0x6C2B, 0x6C0B, 0x6C0B, 0x6C2B, 0x742B, 0x744B, 
        0x6C0A, 0x6C0A, 0x6C0A, 0x63E9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x63C9, 0x6BE9, 0x6BEA, 0x6BEA, 0x63EA, 0x6C0A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C09, 0x63E9, 0x63E9, 0x63E9, 0x63EA, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2B, 0x6C2B, 
        0x6C4B, 0x6C4B, 0x6C4C, 0x6C4C, 0x6C2D, 0x640E, 0x5BEF, 0x5BEF, 0x5C2F, 0x542E, 0x440D, 0x3C0C, 0x3C2B, 0x3C2A, 0x3C2A, 0x3C29, 0x3C29, 0x3C09, 0x3C09, 0x3C29, 0x4429, 0x4429, 0x4449, 0x4C6A, 0x4C6A, 0x546A, 0x5CAB, 0x650C, 0x64CB, 0x5C6A, 
        0x5449, 0x5449, 0x4C29, 0x5429, 0x5C29, 0x746B, 0x7C6B, 0x844C, 0x8C6C, 0x8C4D, 0x844E, 0x7BED, 0x8C6E, 0x8C8F, 0x94CE, 0x94EE, 0x84CE, 0x84CD, 0x84CD, 0x84ED, 0x84ED, 0x84EE, 0x850E, 0x7CEE, 0x7CEE, 0x7D0E, 0x7D2E, 0x7D2E, 0x7D2E,
  0x744E, 0x6C4C, 0x6C4C, 0x74EE, 0x7D2F, 0x6CCD, 0x5CAC, 0x5CED, 0x652D, 0x6D2E, 0x752F, 0x7CCF, 0x73CD, 0x5AA9, 0x5A68, 0x6309, 0x636A, 0x63CB, 0x63EB, 0x6C6C, 0x6CAD, 0x6CCD, 0x6CCC, 0x64CC, 0x6D2D, 0x756E, 0x85D0, 0x85D1, 0x7D51, 0x8532, 0x8512, 
        0x6C4F, 0x748F, 0x7D10, 0x7D10, 0x7D10, 0x8550, 0x8570, 0x8570, 0x8570, 0x854F, 0x7D2F, 0x7D2E, 0x7D0E, 0x7CEE, 0x74CD, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x748D, 0x7CAD, 0x7CAD, 0x7CAD, 0x7CAD, 0x84AD, 0x84CD, 0x84CD, 0x8CCD, 0x8CED, 0x8CED, 
        0x8CED, 0x8CCD, 0x8CCD, 0x94CD, 0x94ED, 0x950E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0D, 0x9D0E, 0x9D0D, 0x9D2E, 0xA52E, 0xA52E, 0xA52E, 0xA50E, 0xA50E, 0xA50E, 0xAD0E, 0xAD0E, 0xAD0E, 0xAD2E, 0xAD2E, 0xAD0E, 0xAD0E, 0xACCE, 0xACCE, 
        0xA4CE, 0xA48E, 0xA46E, 0xA44E, 0x9C2E, 0x9C2D, 0x940D, 0x8BCD, 0x7BAC, 0x73AC, 0x6C0D, 0x6C6E, 0x64AE, 0x64CE, 0x5CCE, 0x5CAF, 0x5C6F, 0x540E, 0x53AD, 0x538E, 0x5B8E, 0x5B6D, 0x5B0C, 0x52CB, 0x4AA9, 0x530A, 0x530A, 0x3A67, 0x3246, 0x3246, 
        0x3246, 0x3A25, 0x5AC8, 0x8C0E, 0xA4B0, 0xA4AF, 0xACCF, 0xB50F, 0xBD50, 0xC570, 0xC54F, 0xBD0E, 0xBD0E, 0xB50D, 0xB4ED, 0xB4ED, 0xBD0E, 0xBD2E, 0xB52E, 0xBD4E, 0xBD4E, 0xBD4E, 0xB52E, 0xB50E, 0xAD0E, 0xA4CD, 0x944C, 0x8C4C, 0x8C6D, 0x8C6D, 
        0x844E, 0x7BEE, 0x73EE, 0x63CC, 0x4BCA, 0x4BEA, 0x4409, 0x4409, 0x4409, 0x4C29, 0x4C4A, 0x544A, 0x5C6A, 0x648B, 0x648B, 0x6CAB, 0x6CAB, 0x648B, 0x646B, 0x5C2A, 0x540A, 0x642B, 0x6C4B, 0x7CAC, 0x8CCD, 0x94CC, 0x9CED, 0x94ED, 0x950D, 0x8CCD, 
        0x746B, 0x642B, 0x5C2B, 0x648C, 0x6CEE, 0x6D0E, 0x6CEE, 0x648D, 0x4C0A, 0x3388, 0x2B47, 0x2347, 0x2367, 0x2B87, 0x2BA7, 0x33A8, 0x33C8, 0x3BC8, 0x43E8, 0x4BE8, 0x4C09, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x4C09, 0x4BE9, 0x4C09, 0x4C2A, 
        0x4C2A, 0x544B, 0x4C0A, 0x43CA, 0x3BAA, 0x3B89, 0x3389, 0x3B6A, 0x3B4B, 0x3B4C, 0x3B2D, 0x3AEF, 0x3A70, 0x3210, 0x29B1, 0x31B2, 0x39D3, 0x39D4, 0x39D4, 0x31D3, 0x31D3, 0x39B4, 0x39B4, 0x39D4, 0x39D5, 0x39F5, 0x41F6, 0x4216, 0x41F6, 0x4216, 
        0x41F7, 0x39F7, 0x3A17, 0x4217, 0x4217, 0x4238, 0x4238, 0x4238, 0x4238, 0x4238, 0x4258, 0x4A78, 0x4A78, 0x4A98, 0x5297, 0x6318, 0x73D9, 0x7C18, 0x7C57, 0x84B5, 0x8D15, 0x9595, 0x95B4, 0x8D72, 0x8D72, 0x8D92, 0x8572, 0x8572, 0x8532, 0x8D73, 
        0x95B4, 0x95B4, 0xA616, 0xAE36, 0xC6B8, 0xC6B7, 0xD738, 0xCF38, 0xC6F6, 0xB6B5, 0xA674, 0x95F2, 0x8591, 0x6D2F, 0x5CCE, 0x5CAE, 0x546E, 0x544D, 0x542E, 0x540E, 0x74F1, 0x7CF1, 0x5C0C, 0x540B, 0x53EB, 0x4BEB, 0x4C0B, 0x4C2A, 0x4C0A, 0x4C0A, 
        0x4C0A, 0x4C0A, 0x440A, 0x440A, 0x4C2A, 0x5CAC, 0x5C8C, 0x4C0A, 0x53CA, 0x5C0C, 0x74AE, 0x9DB2, 0xB655, 0xBE96, 0xAE54, 0x9DF2, 0x8DB1, 0x8590, 0x7D90, 0x758F, 0x6D2E, 0x5CAC, 0x4C2A, 0x43C9, 0x43C8, 0x43C8, 0x43C8, 0x4BC8, 0x4BE8, 0x4BE8, 
        0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BC9, 0x43C9, 0x3B8A, 0x3BAB, 0x440C, 0x54CE, 0x6D90, 0x656E, 0x54AB, 0x3C08, 0x3BC7, 0x3BC7, 0x3BC7, 0x3BC8, 0x3BE8, 0x3BE9, 0x444C, 0x4C6D, 0x4CAE, 0x54CF, 0x5CD0, 0x64F0, 0x6D11, 0x6D11, 0x6CEF, 
        0x5C4C, 0x4BEA, 0x53CA, 0x5BCA, 0x5BAA, 0x5BAB, 0x5BAB, 0x5BCB, 0x5BCB, 0x63CB, 0x63AB, 0x6C0C, 0x7C6D, 0x7C4D, 0x742C, 0x746C, 0x746C, 0x748C, 0x748C, 0x746C, 0x746C, 0x6C4B, 0x6C4B, 0x744B, 0x744B, 0x6C2B, 0x742B, 0x744B, 0x744B, 0x744B, 
        0x6C2B, 0x742A, 0x742A, 0x6C2A, 0x6BEA, 0x63E9, 0x63E9, 0x63E9, 0x6BEA, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2A, 0x6C4A, 0x6C2A, 0x6C4A, 0x6C2A, 0x6C2A, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2B, 0x6C4B, 0x744B, 0x744B, 0x744B, 0x744B, 0x746B, 
        0x748C, 0x748C, 0x746C, 0x746C, 0x6C6D, 0x6C6E, 0x6C6F, 0x644F, 0x5C2F, 0x5C0F, 0x540E, 0x442D, 0x3C0B, 0x3C2A, 0x3C0A, 0x442A, 0x442A, 0x442A, 0x4409, 0x440A, 0x4C2A, 0x4C2A, 0x4C6A, 0x4C6A, 0x4C6A, 0x548A, 0x64CB, 0x64CB, 0x5C8A, 0x5449, 
        0x5449, 0x4C29, 0x5429, 0x5429, 0x644A, 0x7C6C, 0x846C, 0x844C, 0x8C4D, 0x8C6E, 0x8C6E, 0x8C6E, 0x8C8E, 0x8CAE, 0x8CCE, 0x8CCE, 0x84CD, 0x7CCD, 0x7CCD, 0x7CED, 0x7CED, 0x7D0D, 0x7D0D, 0x7D0D, 0x7D0D, 0x7D0E, 0x7D2E, 0x7D2E, 0x7D2E,
  0x744E, 0x6C2C, 0x642B, 0x644B, 0x750E, 0x752F, 0x64CD, 0x64ED, 0x650D, 0x6D2E, 0x752F, 0x74CF, 0x636B, 0x5289, 0x5268, 0x4206, 0x4266, 0x5308, 0x5B89, 0x5BEA, 0x6C6C, 0x6CCD, 0x6CCC, 0x64CC, 0x6D0D, 0x756E, 0x7DB0, 0x85B0, 0x8571, 0x8532, 0x84D2, 
        0x6C10, 0x744F, 0x6C6E, 0x74CF, 0x7D30, 0x8571, 0x8570, 0x8570, 0x7D2F, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x74AD, 0x748D, 0x748D, 0x748D, 0x748D, 0x7C8D, 0x7C8D, 0x7C8D, 0x7CAD, 0x84AD, 0x84AD, 0x84AD, 0x84AD, 0x84CD, 0x84CD, 0x8CCD, 0x8CCD, 
        0x8CCD, 0x8CCD, 0x94CD, 0x94CD, 0x94EE, 0x94EE, 0x950E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0x9D0E, 0xA52E, 0xA52E, 0xA50E, 0xA50E, 0xA50E, 0xAD0F, 0xAD0F, 0xAD0F, 0xAD0F, 0xACEE, 0xA4CE, 0xA4AE, 0xA4AE, 0xA48E, 0xA48E, 
        0xA46E, 0xA46E, 0x9C2E, 0x93ED, 0x8BAC, 0x83AC, 0x7BAB, 0x738B, 0x6B8A, 0x638B, 0x642C, 0x648E, 0x5CCE, 0x5CEE, 0x5CEE, 0x5CCE, 0x5C8F, 0x542E, 0x4B8D, 0x4B4D, 0x638F, 0x5B2E, 0x52CC, 0x528B, 0x73EF, 0x740F, 0x530A, 0x3A47, 0x3226, 0x3A26, 
        0x4246, 0x6B4A, 0x8C2D, 0xA4AF, 0xACCF, 0xB4EF, 0xB4EF, 0xBD2F, 0xC54F, 0xC54F, 0xC52E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD0E, 0xB50E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD4E, 0xBD4E, 0xBD4E, 0xB52E, 0xAD0E, 0xA4AD, 0x946C, 0x944C, 0x946D, 0x946D, 0x8C4D, 
        0x7C0D, 0x7BED, 0x73ED, 0x5BCC, 0x4BEA, 0x43EA, 0x4409, 0x4429, 0x444A, 0x4C4A, 0x4C6A, 0x546A, 0x5C6B, 0x5C8B, 0x648B, 0x648B, 0x648B, 0x646B, 0x5C4B, 0x542A, 0x540A, 0x644B, 0x6C6B, 0x7CAC, 0x8CCD, 0x94ED, 0x9CED, 0x94ED, 0x94ED, 0x7C8C, 
        0x642B, 0x5C0B, 0x5C2B, 0x6CCD, 0x6D0E, 0x64ED, 0x546B, 0x43C9, 0x3367, 0x2B46, 0x2366, 0x2387, 0x2B87, 0x2BA7, 0x33C7, 0x33C8, 0x3BC8, 0x43E8, 0x4BE8, 0x4C09, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x53E9, 0x4C09, 0x544A, 0x544B, 
        0x4C2A, 0x4C0A, 0x43E9, 0x43C9, 0x3BA9, 0x3BC9, 0x3BC9, 0x3BCA, 0x3BCA, 0x3BCA, 0x3BAB, 0x3B6C, 0x432E, 0x42CF, 0x3A70, 0x3A30, 0x3210, 0x31F2, 0x31D2, 0x31D2, 0x31D2, 0x31B2, 0x31B3, 0x31D3, 0x39D4, 0x39F4, 0x41F5, 0x41F5, 0x41F5, 0x4216, 
        0x41F6, 0x39F6, 0x4216, 0x4216, 0x4237, 0x4237, 0x4237, 0x3A37, 0x4237, 0x4237, 0x4256, 0x4A76, 0x4A76, 0x4A75, 0x52D4, 0x8438, 0x9D3A, 0x94F7, 0x8CF5, 0x8D13, 0x8D52, 0x9593, 0x95B3, 0x8D72, 0x8D72, 0x8D71, 0x8572, 0x8572, 0x8552, 0x95B4, 
        0x95B4, 0x95B4, 0xA5F5, 0xAE56, 0xBE97, 0xC6B7, 0xD759, 0xD778, 0xC6F7, 0xAE94, 0x9E33, 0x8DD1, 0x7D70, 0x6D0F, 0x5CAE, 0x548E, 0x4C4D, 0x4C2D, 0x540D, 0x540E, 0x74B0, 0x8511, 0x5C0C, 0x540B, 0x540B, 0x540B, 0x4C2B, 0x542B, 0x542A, 0x4C0A, 
        0x4C0A, 0x4C0A, 0x4409, 0x4409, 0x442A, 0x4C6B, 0x5CAC, 0x4C2B, 0x4BEA, 0x4BA9, 0x53AA, 0x642C, 0x9571, 0xB675, 0xB695, 0xA633, 0x95D1, 0x85B0, 0x7D90, 0x7D90, 0x756F, 0x6D2E, 0x5CCC, 0x4C6A, 0x4C2A, 0x4C09, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 
        0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4BE8, 0x4BC8, 0x43C8, 0x3BA9, 0x3BAA, 0x3BCC, 0x4C6D, 0x6D50, 0x6D6F, 0x5D0C, 0x4449, 0x3BE7, 0x3BE7, 0x43E7, 0x43C8, 0x43E8, 0x4409, 0x4C4C, 0x4C8D, 0x4CAE, 0x54CF, 0x5CF0, 0x6510, 0x6531, 0x6D31, 0x64EE, 
        0x546B, 0x4C09, 0x4BE9, 0x53E9, 0x53EA, 0x53EA, 0x53EA, 0x53EA, 0x5BEA, 0x5BEA, 0x5BCB, 0x63CB, 0x742D, 0x8CCF, 0x84CE, 0x7C8D, 0x7CAD, 0x7CAD, 0x7CCD, 0x7CAD, 0x7CAD, 0x7C8C, 0x746C, 0x744B, 0x744B, 0x744B, 0x742B, 0x742B, 0x742B, 0x742B, 
        0x6C0A, 0x740B, 0x742B, 0x744B, 0x744B, 0x6C0A, 0x6C0A, 0x6C0A, 0x6C2B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4B, 0x746B, 0x746B, 0x746B, 0x744B, 0x6C2A, 0x6C2A, 0x6C2A, 0x744B, 0x744B, 0x746B, 0x746B, 0x748C, 0x7C8C, 0x7CAC, 0x7CCC, 
        0x7CCC, 0x7CCC, 0x74AC, 0x748C, 0x6C8D, 0x6C8D, 0x6C8E, 0x6C6F, 0x644F, 0x5BEF, 0x5C0F, 0x544F, 0x4C2D, 0x442B, 0x440A, 0x440A, 0x442A, 0x442A, 0x442A, 0x4C2A, 0x4C4B, 0x4C4A, 0x4C6A, 0x548A, 0x548A, 0x5CAB, 0x64EB, 0x5CAA, 0x5469, 0x5449, 
        0x5449, 0x4C29, 0x5429, 0x6429, 0x746B, 0x844C, 0x8C6C, 0x8C4D, 0x842D, 0x842D, 0x8C8E, 0x94AE, 0x94CE, 0x8CCE, 0x84CD, 0x7CCD, 0x7CCD, 0x74CD, 0x7CED, 0x74ED, 0x74ED, 0x7CED, 0x74ED, 0x74ED, 0x7CED, 0x7D0D, 0x852E, 0x852E, 0x854E,
  0x744D, 0x6C4D, 0x6C2B, 0x644B, 0x7D2F, 0x7D4F, 0x64CD, 0x6CED, 0x6D2D, 0x6D4E, 0x7D70, 0x8551, 0x7C6F, 0x6B8C, 0x5AA9, 0x4206, 0x39E5, 0x3A25, 0x3A66, 0x4308, 0x53A9, 0x642B, 0x646C, 0x6CAC, 0x6D0D, 0x754E, 0x7D8F, 0x8590, 0x8551, 0x8532, 0x84D2, 
        0x6C10, 0x6BEF, 0x6C4F, 0x7CD0, 0x7D10, 0x7D30, 0x74CE, 0x6C8D, 0x6C8D, 0x746D, 0x746D, 0x748D, 0x748D, 0x746E, 0x746D, 0x746D, 0x748D, 0x746D, 0x748D, 0x746D, 0x7C6D, 0x7C8D, 0x7CAD, 0x84AE, 0x84AD, 0x84AD, 0x84AD, 0x84AD, 0x8CAE, 0x8CAE, 
        0x8CCE, 0x8CCE, 0x94CE, 0x94CE, 0x94EE, 0x94EE, 0x94EE, 0x94EE, 0x9CEE, 0x9CEE, 0x9CEE, 0x9CEE, 0x9CEE, 0x9D0E, 0xA50E, 0xA50E, 0xA50F, 0xA4EE, 0xA4EE, 0xA4EE, 0xA4EE, 0xA4EE, 0xA4CE, 0x9CAE, 0x9CAE, 0x9C8D, 0x9C4D, 0x9C2D, 0x9C2D, 0x9C2D, 
        0x940D, 0x940D, 0x8BCC, 0x83AB, 0x7B8B, 0x73AB, 0x73AA, 0x6BAA, 0x63A9, 0x5BAA, 0x53EB, 0x5C8C, 0x54CD, 0x54ED, 0x54EE, 0x54EE, 0x5CAF, 0x544F, 0x53CE, 0x53AE, 0x5B8F, 0x5B2E, 0x52CD, 0x5ACC, 0x5ACC, 0x4AAA, 0x4268, 0x3A27, 0x3206, 0x4206, 
        0x6B2A, 0x8C2D, 0xA4CF, 0xACCF, 0xACCF, 0xB4EF, 0xBD0F, 0xBD2E, 0xBD2E, 0xC52E, 0xBD2E, 0xBD2E, 0xBD2E, 0xBD2E, 0xBD0E, 0xB4ED, 0xB50E, 0xB50E, 0xBD2E, 0xBD2E, 0xBD2E, 0xB52E, 0xAD0E, 0x9C8C, 0x8C2B, 0x8C2B, 0x8C4C, 0x8C6D, 0x8C6D, 0x842D, 
        0x842E, 0x7C0E, 0x6C0D, 0x5C0C, 0x4C2A, 0x442A, 0x4429, 0x444A, 0x446A, 0x4C8B, 0x4C6B, 0x546B, 0x5C6B, 0x5C8B, 0x648B, 0x646A, 0x646B, 0x646A, 0x5C6A, 0x542A, 0x540A, 0x5C4B, 0x6C6C, 0x7CAC, 0x8CCD, 0x94ED, 0x9CED, 0x94ED, 0x84AC, 0x6C2A, 
        0x5C0A, 0x53EA, 0x5C2B, 0x64AD, 0x5CAC, 0x4C0A, 0x3BA8, 0x2B67, 0x2346, 0x2366, 0x2386, 0x2B87, 0x2BA7, 0x33C7, 0x3BC8, 0x43E8, 0x43E8, 0x4BE8, 0x5409, 0x5409, 0x5409, 0x5C09, 0x5C09, 0x5C09, 0x5409, 0x5409, 0x542A, 0x5C6B, 0x5C6B, 0x542A, 
        0x4C0A, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x3BE9, 0x3BE9, 0x440A, 0x440A, 0x43E9, 0x43E9, 0x3BAA, 0x3B6B, 0x432C, 0x3AEC, 0x3AAD, 0x3A6E, 0x324F, 0x3230, 0x3230, 0x3211, 0x31F1, 0x31F2, 0x31D2, 0x39F2, 0x39F2, 0x39F3, 0x39F3, 0x39F3, 0x3A14, 
        0x3A14, 0x3A15, 0x4215, 0x4235, 0x4236, 0x4236, 0x4236, 0x4235, 0x4234, 0x3A33, 0x31F2, 0x31F1, 0x3210, 0x4270, 0x5B31, 0x8434, 0xA578, 0xA576, 0x9534, 0x8D32, 0x8D51, 0x8D51, 0x8D71, 0x8D72, 0x8D71, 0x8571, 0x8571, 0x8552, 0x8D72, 0x95B4, 
        0x9593, 0x95B4, 0x9DD4, 0xAE56, 0xB676, 0xBE76, 0xCF18, 0xCF38, 0xBED6, 0xAE54, 0x95F2, 0x8591, 0x7530, 0x64CF, 0x5C8E, 0x4C4E, 0x4C0D, 0x4C0D, 0x4BED, 0x53EE, 0x6C70, 0x8532, 0x5C0C, 0x53EB, 0x540B, 0x540B, 0x4C2B, 0x542A, 0x542A, 0x4C2A, 
        0x4C0A, 0x4409, 0x4409, 0x4409, 0x4429, 0x442A, 0x54AC, 0x4C6B, 0x4C0A, 0x43C9, 0x4389, 0x4B89, 0x644C, 0x95B2, 0xB695, 0xAE94, 0x9E12, 0x8DD1, 0x85B0, 0x7D90, 0x758F, 0x6D4F, 0x64ED, 0x4C6A, 0x4C6A, 0x548A, 0x544A, 0x4C29, 0x4C08, 0x4BE8, 
        0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x43C8, 0x43C8, 0x3B89, 0x3B8A, 0x3BAB, 0x440C, 0x5D0F, 0x6D90, 0x654E, 0x548B, 0x4408, 0x43E7, 0x43E8, 0x43E8, 0x43E9, 0x442A, 0x4C6C, 0x4C8E, 0x54CF, 0x5CEF, 0x5D10, 0x6531, 0x6531, 0x6D30, 0x5CCE, 
        0x544B, 0x4409, 0x4C09, 0x4C09, 0x5409, 0x53E9, 0x5409, 0x53E9, 0x5409, 0x53EA, 0x5BEA, 0x5BCB, 0x63CB, 0x742D, 0x7C4D, 0x746C, 0x7C8D, 0x7C8D, 0x7C8D, 0x7CAD, 0x7CAD, 0x7C8C, 0x7C8C, 0x7C6C, 0x7C4C, 0x742B, 0x740B, 0x6C0B, 0x6C0B, 0x6C0B, 
        0x6C0A, 0x6C0B, 0x742B, 0x742B, 0x6C0B, 0x63EA, 0x63EA, 0x63EA, 0x63EA, 0x640A, 0x640A, 0x642A, 0x6C2A, 0x640A, 0x642A, 0x642A, 0x642A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C4B, 0x6C4B, 0x6C6B, 0x746B, 0x748B, 0x748B, 0x746B, 0x746B, 
        0x6C6B, 0x6C8B, 0x74AC, 0x748C, 0x6C8C, 0x6C6C, 0x6C6D, 0x6C4D, 0x6C2E, 0x640F, 0x5BEE, 0x5C2F, 0x5C6E, 0x4C2C, 0x440B, 0x440A, 0x440A, 0x442A, 0x4C2A, 0x544B, 0x546B, 0x546B, 0x546B, 0x5C8B, 0x64CB, 0x64EC, 0x64CB, 0x5469, 0x5449, 0x5429, 
        0x5429, 0x5429, 0x642A, 0x6C4B, 0x7C4C, 0x8C2C, 0x944D, 0x946D, 0x8C4D, 0x844D, 0x8C8E, 0x8CAE, 0x8CCE, 0x84CE, 0x7CCD, 0x7CCD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x7CED, 0x7D0D, 0x852E, 0x854E, 0x854E,
  0x7CAE, 0x7CAE, 0x746C, 0x6C4B, 0x852F, 0x7D2F, 0x64CD, 0x6D0D, 0x6D2E, 0x754E, 0x7D6F, 0x8571, 0x7CAF, 0x63AD, 0x5AEA, 0x39E6, 0x39C5, 0x39E5, 0x3205, 0x3225, 0x3286, 0x3AE7, 0x4B89, 0x540A, 0x648C, 0x752E, 0x7D8F, 0x8590, 0x7D30, 0x8532, 0x8CF3, 
        0x6BF0, 0x5B6E, 0x6C0F, 0x7470, 0x746F, 0x6C4E, 0x6C2D, 0x6C2D, 0x744D, 0x744D, 0x744D, 0x744D, 0x7C4D, 0x744D, 0x742D, 0x744D, 0x744D, 0x744C, 0x6C2C, 0x6C0C, 0x6C0C, 0x6BEC, 0x6C0C, 0x742D, 0x7C4D, 0x7C4D, 0x7C6D, 0x846D, 0x844D, 0x846D, 
        0x846D, 0x8C8E, 0x8C8E, 0x948E, 0x948E, 0x948E, 0x948E, 0x8CAE, 0x8CAE, 0x94AE, 0x94CE, 0x94AE, 0x94AE, 0x94CE, 0x9CCF, 0x9CCF, 0x9CCF, 0x9CAE, 0x9CAE, 0x9C8E, 0x9C6E, 0x946E, 0x944E, 0x944D, 0x942D, 0x9C2D, 0x9C2D, 0x940D, 0x940E, 0x942E, 
        0x8BED, 0x7BAB, 0x73AB, 0x73AA, 0x73AA, 0x6BCA, 0x63C9, 0x5BC9, 0x53E9, 0x53C9, 0x4BE9, 0x546B, 0x54CC, 0x54ED, 0x54ED, 0x54EE, 0x5CCF, 0x5C8F, 0x5C2F, 0x5BEF, 0x5B8E, 0x5B4F, 0x5AEE, 0x5ACD, 0x5AED, 0x634C, 0x634C, 0x52EA, 0x4247, 0x62E9, 
        0x8C2D, 0xA4CF, 0xACEF, 0xB4EF, 0xB4EF, 0xBD0F, 0xBD2E, 0xBD2E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD2E, 0xBD2E, 0xBD2E, 0xBD0E, 0xB4ED, 0xB50E, 0xB50E, 0xB50E, 0xB50E, 0xB50E, 0xB50E, 0xA4AD, 0x8C0A, 0x8C0A, 0x8C2B, 0x8C6C, 0x8C6D, 0x8C6D, 0x842D, 
        0x8CAF, 0x7C4E, 0x6C2D, 0x5C2B, 0x4C4A, 0x444A, 0x4429, 0x3C4A, 0x444A, 0x4C6B, 0x4C6B, 0x546B, 0x546B, 0x5C6B, 0x5C6A, 0x5C6A, 0x646B, 0x5C6A, 0x546B, 0x542A, 0x4C0A, 0x5C4C, 0x6C6C, 0x7C8C, 0x8CAD, 0x94CD, 0x94CD, 0x8CCD, 0x746C, 0x5C0A, 
        0x53EA, 0x53EB, 0x540B, 0x4C2B, 0x3BC9, 0x3387, 0x2B67, 0x2366, 0x2387, 0x2B87, 0x2BA7, 0x33A7, 0x33C7, 0x3BC8, 0x43E8, 0x4BE8, 0x4C08, 0x5409, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5409, 0x5C2A, 0x5C4A, 0x5C6B, 0x5C4B, 0x542A, 0x4C0A, 
        0x4BE9, 0x43C9, 0x43C9, 0x43C9, 0x43E9, 0x440A, 0x440A, 0x440A, 0x440A, 0x440A, 0x43EA, 0x43C9, 0x3BA9, 0x438A, 0x3B49, 0x3B2A, 0x3AEB, 0x32CC, 0x32AD, 0x32AD, 0x328E, 0x326E, 0x324F, 0x324F, 0x324F, 0x3A50, 0x3A50, 0x3A50, 0x3A50, 0x3A51, 
        0x3A51, 0x3A32, 0x3A31, 0x3A11, 0x3A11, 0x39F2, 0x3A11, 0x4231, 0x4250, 0x3A4F, 0x3A4F, 0x426E, 0x428D, 0x52ED, 0x5B2D, 0x6B6D, 0x94B2, 0xB5F6, 0xA594, 0x9552, 0x8D31, 0x8530, 0x8D51, 0x8D92, 0x8571, 0x8551, 0x8571, 0x8551, 0x8D72, 0x8D93, 
        0x8552, 0x8D73, 0x95B4, 0xAE35, 0xAE36, 0xB655, 0xB696, 0xBEB6, 0xB695, 0x9DF2, 0x8D71, 0x7D30, 0x6D10, 0x64CF, 0x546E, 0x4C0D, 0x43ED, 0x440D, 0x4BED, 0x4BCD, 0x5C2F, 0x8D73, 0x640C, 0x53EA, 0x540A, 0x540A, 0x4C2A, 0x4C2A, 0x4C2A, 0x4C2A, 
        0x4C2A, 0x4C29, 0x4409, 0x4409, 0x4429, 0x442A, 0x4C6B, 0x54AC, 0x442A, 0x43E9, 0x43C9, 0x43A9, 0x4BCA, 0x74AE, 0x8D70, 0xAE74, 0xA674, 0x9632, 0x8DF1, 0x7DB0, 0x7590, 0x6D6E, 0x5CEC, 0x4C8B, 0x4C8A, 0x4C8A, 0x54AA, 0x54AB, 0x54AB, 0x4C29, 
        0x43E8, 0x4BE8, 0x4BC8, 0x43C8, 0x43C8, 0x43C8, 0x43C7, 0x4389, 0x3B8A, 0x3B8B, 0x3BCC, 0x54AE, 0x6530, 0x656E, 0x5CEC, 0x4C49, 0x4408, 0x43E8, 0x43E8, 0x4409, 0x442A, 0x446C, 0x4C8E, 0x54CF, 0x5D10, 0x6530, 0x6531, 0x6D51, 0x6D30, 0x5CCD, 
        0x4C4A, 0x4409, 0x4BE9, 0x4C09, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x5409, 0x53CA, 0x5BAB, 0x6BEC, 0x84AF, 0x84CF, 0x84CE, 0x7CAD, 0x746C, 0x744C, 0x6C4B, 0x744C, 0x7C6C, 0x846D, 0x7C4C, 0x7C2B, 0x740B, 0x740B, 0x6BEA, 0x6BEA, 
        0x63EA, 0x63EA, 0x6BEA, 0x63CA, 0x63CA, 0x63AA, 0x63CA, 0x63CB, 0x5BCB, 0x5BCA, 0x5BCA, 0x5BCA, 0x5BC9, 0x5BC9, 0x5BE9, 0x5BE9, 0x5BE9, 0x6409, 0x6409, 0x642A, 0x6C2A, 0x6C2A, 0x642A, 0x642B, 0x6C6B, 0x6C8B, 0x748B, 0x6C6B, 0x6C6A, 0x6C4A, 
        0x6C4A, 0x6C6A, 0x6C8B, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C4B, 0x6C2C, 0x642C, 0x63ED, 0x5BCD, 0x5BEE, 0x644F, 0x5C6E, 0x4C0C, 0x440B, 0x4C0A, 0x4C0A, 0x4C2A, 0x544B, 0x5C6B, 0x5C8B, 0x64AC, 0x64CC, 0x6D0C, 0x6D0C, 0x64AB, 0x5469, 0x5429, 0x5429, 
        0x5429, 0x5C0A, 0x63CA, 0x73EB, 0x83EC, 0x8C2C, 0x944D, 0x946D, 0x948E, 0x8C8E, 0x8CAE, 0x84AE, 0x84CD, 0x7CAD, 0x74CC, 0x74AC, 0x6CAC, 0x6CAC, 0x74AD, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x74ED, 0x7D0D, 0x850E, 0x852E, 0x852E, 0x8D4E,
  0x7CAE, 0x7CAE, 0x744C, 0x6C6B, 0x7CEE, 0x6CAD, 0x648C, 0x6CCD, 0x6D2D, 0x6D2E, 0x754E, 0x7D50, 0x7CF0, 0x746F, 0x6BAD, 0x4248, 0x39E6, 0x41E6, 0x39E5, 0x31E5, 0x3204, 0x3224, 0x3265, 0x3AE6, 0x4BA8, 0x6CCD, 0x752F, 0x7D50, 0x7D30, 0x8512, 0x8D14, 
        0x73F1, 0x6B8F, 0x6BAF, 0x6BEF, 0x6BEE, 0x6C0E, 0x6C0D, 0x6BED, 0x740D, 0x7C2D, 0x7C0D, 0x740D, 0x73EC, 0x73AC, 0x6BAB, 0x6BAB, 0x63AB, 0x63AB, 0x63AB, 0x6C0C, 0x6BEC, 0x5B6B, 0x5B2A, 0x636B, 0x638B, 0x6B8B, 0x638A, 0x636A, 0x6329, 0x636A, 
        0x6B6A, 0x73CB, 0x73CB, 0x7BCC, 0x7BCB, 0x7BCC, 0x7BCC, 0x7BEC, 0x7C0C, 0x840C, 0x842C, 0x842C, 0x842D, 0x8C4D, 0x944D, 0x944E, 0x944E, 0x944D, 0x944D, 0x942D, 0x940D, 0x8C0D, 0x8C0D, 0x8BED, 0x8BEC, 0x8BCC, 0x8BCC, 0x83AC, 0x83AC, 0x83CC, 
        0x73AB, 0x73AA, 0x6BCA, 0x6BCA, 0x6BC9, 0x63E9, 0x5BE9, 0x53E8, 0x5408, 0x53E8, 0x4BE9, 0x4C2A, 0x4C8B, 0x54CD, 0x54ED, 0x54EE, 0x54CE, 0x5CAF, 0x5C8F, 0x5C4F, 0x6410, 0x63AF, 0x5B2E, 0x630D, 0x6B6E, 0x7BEF, 0x8450, 0x844F, 0x736B, 0x944E, 
        0xACF0, 0xACEF, 0xB4EF, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xB4ED, 0xBCED, 0xBD2E, 0xBD4E, 0xBD2E, 0xBD2E, 0xB50E, 0xB4ED, 0xB4ED, 0xB50D, 0xB4ED, 0xB4ED, 0xB4EE, 0xACCD, 0x942B, 0x8BEA, 0x8C2B, 0x8C4C, 0x8C4D, 0x8C6E, 0x8C6E, 0x846E, 
        0x84AF, 0x7CAF, 0x6C8D, 0x5C6C, 0x4C6B, 0x4C6A, 0x446A, 0x3C6A, 0x446A, 0x4C6A, 0x4C6B, 0x4C6B, 0x546B, 0x546B, 0x5C6A, 0x5C6A, 0x5C6A, 0x5C6A, 0x544B, 0x4C2A, 0x4C0A, 0x5C4C, 0x6C6C, 0x7C8C, 0x84AC, 0x94AD, 0x94CD, 0x848C, 0x6C4B, 0x5C0B, 
        0x4BEA, 0x4BAA, 0x438A, 0x3388, 0x2B47, 0x2B67, 0x2387, 0x2387, 0x2BA7, 0x33A7, 0x33C7, 0x3BC7, 0x3BC8, 0x43E8, 0x4BE8, 0x4BE8, 0x5409, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5BE9, 0x5C0A, 0x5C2A, 0x5C4A, 0x5C4A, 0x544A, 0x540A, 0x540A, 0x4BE9, 
        0x4BE9, 0x4BE9, 0x43C9, 0x4BE9, 0x4C0A, 0x4C2A, 0x4C2A, 0x4C2A, 0x440A, 0x440A, 0x4409, 0x43E9, 0x43C9, 0x3BA9, 0x3B88, 0x3B69, 0x3B4A, 0x3B4A, 0x3B2B, 0x3B2B, 0x3B0B, 0x3AEC, 0x3ACC, 0x3AAC, 0x3AAD, 0x32AD, 0x32AD, 0x32AD, 0x328D, 0x326E, 
        0x326E, 0x324E, 0x324D, 0x3A2D, 0x3A4E, 0x424E, 0x4A6E, 0x4AAE, 0x4ACE, 0x52ED, 0x530D, 0x532C, 0x5B2B, 0x5B2A, 0x5B2A, 0x5B09, 0x6B8B, 0xAD73, 0xBE15, 0x9D72, 0x8D51, 0x8D31, 0x8D31, 0x8551, 0x8551, 0x7D30, 0x8551, 0x8551, 0x8572, 0x8D72, 
        0x8531, 0x8532, 0x8D73, 0x9DD4, 0xA5F5, 0xAE35, 0xAE15, 0xAE55, 0xAE34, 0x95B1, 0x8550, 0x7510, 0x6CF0, 0x64AF, 0x544E, 0x4C0D, 0x43ED, 0x43ED, 0x43CD, 0x4BCD, 0x5C0E, 0x9DD4, 0x642D, 0x53EA, 0x540A, 0x540A, 0x4C2A, 0x4C2A, 0x4C2A, 0x4C2A, 
        0x4C29, 0x4C29, 0x4409, 0x4409, 0x4429, 0x444A, 0x444A, 0x4C8B, 0x4C4A, 0x440A, 0x43EA, 0x43EA, 0x4BA9, 0x53EA, 0x540A, 0x8550, 0xA674, 0x9E53, 0x9612, 0x85B0, 0x7D90, 0x6D8F, 0x5CCC, 0x4CAB, 0x4CAB, 0x4CAA, 0x4CAA, 0x4CAA, 0x54CB, 0x54AA, 
        0x4C29, 0x43E8, 0x43C7, 0x43C7, 0x43A7, 0x43C7, 0x43C8, 0x4388, 0x3B89, 0x3B6A, 0x3BAC, 0x4C4D, 0x5D0F, 0x656F, 0x652E, 0x548A, 0x4408, 0x43E8, 0x43E8, 0x4409, 0x442B, 0x4C8C, 0x4CAE, 0x54EF, 0x5D30, 0x6551, 0x6551, 0x6D51, 0x6D30, 0x5CAD, 
        0x4C2A, 0x4409, 0x4409, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x53EA, 0x53CA, 0x5B8A, 0x63EB, 0x7C8E, 0x84EE, 0x7CAE, 0x6C4C, 0x63EB, 0x5BCA, 0x63AA, 0x740B, 0x7C0C, 0x7C0C, 0x7C0C, 0x7C0B, 0x73EB, 0x6BCA, 0x6BAA, 
        0x63AA, 0x63AA, 0x63AA, 0x638A, 0x638A, 0x5B8B, 0x63CB, 0x63EC, 0x63CB, 0x63EB, 0x640C, 0x642C, 0x640B, 0x63EA, 0x5BEA, 0x5C0A, 0x5C0A, 0x5C0A, 0x6409, 0x6409, 0x63E9, 0x63E9, 0x5BE9, 0x5BEA, 0x642A, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C4A, 0x6C4A, 
        0x6C6A, 0x6C6A, 0x6C6B, 0x6C4B, 0x6C4B, 0x6C4A, 0x6C2A, 0x6C2B, 0x6C2B, 0x6C0C, 0x63ED, 0x63CE, 0x5BEE, 0x5C2E, 0x542D, 0x4BEC, 0x4BEB, 0x4BEB, 0x4C2B, 0x544B, 0x5C8C, 0x64AC, 0x6CCC, 0x750D, 0x7D2D, 0x6CEC, 0x5C6A, 0x5C49, 0x5C49, 0x5C29, 
        0x5C2A, 0x6C2B, 0x7C4C, 0x842C, 0x83EC, 0x8C0C, 0x946D, 0x948D, 0x8C8E, 0x8CAD, 0x84AD, 0x84AD, 0x7CAD, 0x74CD, 0x74AC, 0x6CAC, 0x6C8C, 0x6CAC, 0x6CAC, 0x74AD, 0x74CD, 0x74CD, 0x74ED, 0x74ED, 0x7D0D, 0x850E, 0x8D2E, 0x8D4E, 0x8D4F,
  0x746D, 0x746D, 0x746C, 0x6C6B, 0x6C6C, 0x644B, 0x5C6B, 0x64AC, 0x6D0D, 0x6D4E, 0x754E, 0x752F, 0x74EF, 0x7CAF, 0x742E, 0x5B4B, 0x4227, 0x4A27, 0x41E5, 0x39E5, 0x39E5, 0x39E5, 0x31E5, 0x3204, 0x3265, 0x4B89, 0x6C8D, 0x6CCE, 0x74F0, 0x7CF1, 0x84D3, 
        0x73F1, 0x6B90, 0x6B8F, 0x6BAF, 0x73CF, 0x6BCE, 0x6BAD, 0x638C, 0x634B, 0x5AEA, 0x5AC9, 0x52A8, 0x4A68, 0x5288, 0x5288, 0x52A8, 0x4AA8, 0x4287, 0x52E9, 0x42A8, 0x530A, 0x3206, 0x31E6, 0x4268, 0x4A88, 0x4A67, 0x4A67, 0x4A87, 0x5AE9, 0x6309, 
        0x5AC8, 0x5B09, 0x5B29, 0x6309, 0x6309, 0x6329, 0x6329, 0x6329, 0x6349, 0x634A, 0x6B4A, 0x634A, 0x738B, 0x7BCC, 0x83CC, 0x7BCC, 0x83CC, 0x83CC, 0x83CC, 0x83AC, 0x7B8C, 0x736B, 0x734A, 0x732A, 0x734A, 0x734A, 0x734A, 0x734A, 0x736A, 0x6B8A, 
        0x638A, 0x63AA, 0x63C9, 0x63E9, 0x63E9, 0x63E9, 0x5C08, 0x53E8, 0x5408, 0x53E8, 0x4BC8, 0x4BE9, 0x4C6A, 0x4CCC, 0x54CD, 0x4CCD, 0x4CAD, 0x54CF, 0x5CAF, 0x5C8F, 0x646F, 0x6410, 0x638F, 0x634E, 0x634D, 0x6B6D, 0x73CE, 0x7BED, 0x8C0D, 0xACCF, 
        0xACCF, 0xB4CE, 0xBD0E, 0xC52F, 0xBD2E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD4E, 0xBD2E, 0xBD2E, 0xB4ED, 0xB4ED, 0xB4ED, 0xB4ED, 0xACCD, 0xACCD, 0xA48C, 0x940B, 0x8C0B, 0x8C2B, 0x8C2C, 0x8C4D, 0x8C6D, 0x8C6E, 0x8C6E, 0x8CCF, 
        0x8D10, 0x8530, 0x74EE, 0x64AC, 0x5CAB, 0x54AB, 0x4C8A, 0x448A, 0x448A, 0x448A, 0x4C8B, 0x4C8B, 0x4C6A, 0x546A, 0x546A, 0x5C6A, 0x5C6A, 0x5C6A, 0x544A, 0x4C2A, 0x4C0A, 0x5C4C, 0x6C4C, 0x746C, 0x848C, 0x8CAD, 0x8C8C, 0x744C, 0x642B, 0x53EA, 
        0x3B89, 0x3348, 0x3348, 0x2B67, 0x2B67, 0x2B87, 0x2B87, 0x2BA7, 0x33C8, 0x33C8, 0x3BC8, 0x3BC8, 0x43E8, 0x4BE8, 0x4BE8, 0x53E8, 0x5C09, 0x5BE9, 0x5BE9, 0x5C09, 0x5BE9, 0x5BE9, 0x5BEA, 0x5C2A, 0x5C2A, 0x5C2A, 0x542A, 0x5C0A, 0x540A, 0x53E9, 
        0x53E9, 0x4BE9, 0x4BE9, 0x4C09, 0x4C2A, 0x544A, 0x4C4A, 0x4C2A, 0x4409, 0x4409, 0x4409, 0x43E9, 0x3BC8, 0x3BA8, 0x3388, 0x3388, 0x3388, 0x3B89, 0x3B89, 0x3B89, 0x3B69, 0x3B4A, 0x3B2A, 0x3B0A, 0x3B0A, 0x3309, 0x32E9, 0x32E9, 0x32AA, 0x32AA, 
        0x328A, 0x32AA, 0x3AAA, 0x3AAA, 0x42AB, 0x4ACB, 0x52EB, 0x530B, 0x532B, 0x5B2A, 0x5B2A, 0x5B2A, 0x5B4A, 0x5B49, 0x5B29, 0x6309, 0x6B29, 0x8C4E, 0xC635, 0xB615, 0x9572, 0x8D11, 0x8D11, 0x8511, 0x8510, 0x7D10, 0x7D10, 0x7D11, 0x8531, 0x8531, 
        0x7D11, 0x7D11, 0x8532, 0x8D53, 0x9DD4, 0xA5F5, 0xA5D4, 0xA615, 0xA614, 0x8D92, 0x8531, 0x7510, 0x6CD0, 0x5C8F, 0x542D, 0x4C0D, 0x43ED, 0x43CD, 0x43CD, 0x4BED, 0x5BEE, 0xA615, 0x6C4D, 0x53EA, 0x53EA, 0x4C0A, 0x4C0A, 0x4C2A, 0x4C2A, 0x4C2A, 
        0x4C2A, 0x4C29, 0x4408, 0x4429, 0x4429, 0x4449, 0x444A, 0x444A, 0x4C4A, 0x440A, 0x4409, 0x43EA, 0x43C9, 0x43A9, 0x4BC9, 0x646C, 0x8DB1, 0x9E53, 0x9E32, 0x8DD1, 0x7DB0, 0x7DAF, 0x64EC, 0x4C8A, 0x4CAB, 0x4CAB, 0x4CAB, 0x44AA, 0x4CCB, 0x54CB, 
        0x5CCB, 0x548A, 0x4C08, 0x43C7, 0x43A7, 0x43C7, 0x43A7, 0x43A8, 0x3B89, 0x3B6A, 0x3B8B, 0x440C, 0x54AE, 0x654F, 0x654F, 0x54CC, 0x4C49, 0x43E8, 0x43E9, 0x440A, 0x4C4B, 0x4C8D, 0x4CCE, 0x550F, 0x5D30, 0x6551, 0x6551, 0x6D51, 0x6530, 0x548C, 
        0x442A, 0x4409, 0x4409, 0x4429, 0x4429, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4BEA, 0x4BCA, 0x53AA, 0x5BAA, 0x63EB, 0x63EB, 0x5BCA, 0x538A, 0x4B29, 0x4B09, 0x5B4A, 0x738C, 0x73AC, 0x7BCC, 0x73CC, 0x6BAB, 0x6B8A, 0x636A, 
        0x6BAB, 0x6BAB, 0x6BCC, 0x740D, 0x6BED, 0x5B4A, 0x4AE9, 0x42C8, 0x3AC8, 0x4B29, 0x640C, 0x74AE, 0x7CCE, 0x74AD, 0x6C6C, 0x644C, 0x646C, 0x646B, 0x644B, 0x640A, 0x63E9, 0x5BC9, 0x53C9, 0x53C9, 0x5BE9, 0x5C0A, 0x5C2A, 0x6429, 0x640A, 0x642A, 
        0x6C4A, 0x6C6A, 0x6C4A, 0x6C4A, 0x6C4A, 0x6C4A, 0x744B, 0x744B, 0x6C2B, 0x6C2C, 0x6C0C, 0x6C0D, 0x640D, 0x640E, 0x644F, 0x542D, 0x43CB, 0x43CB, 0x4C0B, 0x5C4B, 0x648B, 0x6CAC, 0x74CC, 0x7D0D, 0x7D0D, 0x6C8B, 0x644A, 0x644A, 0x5C49, 0x6429, 
        0x6C4B, 0x7C8C, 0x8CAE, 0x948E, 0x944D, 0x8C0C, 0x946D, 0x8C8D, 0x8CAD, 0x84AD, 0x84AD, 0x7CAD, 0x7CAD, 0x74AD, 0x6CAD, 0x6CAC, 0x6CAC, 0x6CAC, 0x74AC, 0x74CC, 0x74CD, 0x74ED, 0x74ED, 0x74ED, 0x7D0E, 0x852E, 0x8D4E, 0x8D4F, 0x8D4F,
  0x746D, 0x748D, 0x6C6C, 0x644B, 0x644B, 0x5C4B, 0x5C6B, 0x5C8B, 0x64CC, 0x6D2D, 0x6D2E, 0x6D0E, 0x750E, 0x74CF, 0x7CD0, 0x7C90, 0x634B, 0x4A68, 0x41E6, 0x39C6, 0x39C6, 0x41E6, 0x39C5, 0x39E5, 0x4266, 0x3A66, 0x4B28, 0x644D, 0x6CAF, 0x74B0, 0x7472, 
        0x6BF1, 0x636F, 0x636F, 0x6B6E, 0x634D, 0x634C, 0x52CA, 0x52AA, 0x5289, 0x39A5, 0x3164, 0x3144, 0x2924, 0x3143, 0x3144, 0x2943, 0x2964, 0x2983, 0x4288, 0x532A, 0x6C0E, 0x532B, 0x42A9, 0x4AC9, 0x4A88, 0x3A26, 0x4247, 0x5AE9, 0x6309, 0x52A7, 
        0x52A7, 0x52C8, 0x52C8, 0x52C7, 0x5AE8, 0x5AE8, 0x5AE8, 0x5AE8, 0x52E8, 0x52C8, 0x52C8, 0x52C8, 0x5AC8, 0x5AE9, 0x62E9, 0x62E9, 0x62E9, 0x6AE9, 0x62E9, 0x62C9, 0x62C9, 0x62C9, 0x62C9, 0x62E9, 0x62E9, 0x6309, 0x6329, 0x6349, 0x6368, 0x5B89, 
        0x5BA9, 0x5BA9, 0x63C9, 0x63E9, 0x5BE9, 0x5C09, 0x5C08, 0x5C08, 0x5408, 0x53E8, 0x4BC8, 0x53E9, 0x544B, 0x54CC, 0x54CD, 0x54ED, 0x54EE, 0x54EF, 0x5CCF, 0x5CAF, 0x6490, 0x6450, 0x640F, 0x63AF, 0x638D, 0x6BAD, 0x7BCD, 0x840D, 0xA4AF, 0xACCF, 
        0xB4EF, 0xBD0F, 0xC54F, 0xC52F, 0xBD2E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD2E, 0xBD0E, 0xBD0E, 0xBD2E, 0xBD2E, 0xBD0E, 0xB50E, 0xB4ED, 0xACED, 0xACCD, 0xACAD, 0x9C4B, 0x8BEA, 0x8C0B, 0x8C2C, 0x8C4C, 0x8C4D, 0x8C6D, 0x844E, 0x7C2D, 0x7C6E, 0x8CF0, 
        0x8D50, 0x8D91, 0x8570, 0x754E, 0x6D2D, 0x5D0C, 0x54EC, 0x4CCB, 0x44AB, 0x44AB, 0x4C8B, 0x4C8B, 0x4C8A, 0x4C6A, 0x546A, 0x5C6B, 0x5C6A, 0x546A, 0x544A, 0x4C0A, 0x4C0A, 0x644C, 0x6C4C, 0x744C, 0x744C, 0x7C6C, 0x744B, 0x6C2B, 0x53EA, 0x3B89, 
        0x2B48, 0x2B47, 0x2B67, 0x3387, 0x33A7, 0x33C7, 0x33A8, 0x3BC8, 0x3BE8, 0x3BE8, 0x43C8, 0x43C8, 0x4BE8, 0x4BE8, 0x53E8, 0x53E9, 0x5C09, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BEA, 0x5C2A, 0x5C2A, 0x5C4B, 0x5C2B, 0x5C2A, 0x540A, 0x53E9, 
        0x53E9, 0x4BE9, 0x4C09, 0x542A, 0x542A, 0x542A, 0x4C2A, 0x4C09, 0x43E9, 0x43E9, 0x43E9, 0x43C8, 0x3BA8, 0x3B88, 0x3B88, 0x3368, 0x3368, 0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B68, 0x3B48, 0x3B48, 0x3B48, 0x3328, 0x3308, 0x3307, 0x32E8, 0x32E8, 
        0x3AE8, 0x3AE9, 0x42E9, 0x4B09, 0x4B09, 0x5309, 0x5309, 0x5B29, 0x5B29, 0x5B29, 0x5B29, 0x5B49, 0x5B49, 0x6349, 0x6349, 0x6329, 0x6329, 0x6B6A, 0x9CF0, 0xBE35, 0xA593, 0x9532, 0x8D11, 0x84F0, 0x7CD0, 0x7CD0, 0x74D0, 0x74D0, 0x7CD0, 0x7CF1, 
        0x7CF0, 0x74D0, 0x7CF1, 0x8532, 0x9594, 0x9DD4, 0x9573, 0x9DB4, 0x95B3, 0x8D73, 0x7D31, 0x6CB0, 0x5C6E, 0x5C4E, 0x540D, 0x4C0D, 0x4BED, 0x43CD, 0x43CD, 0x4BCD, 0x5BEE, 0x9DF5, 0x7CAF, 0x53CA, 0x53EA, 0x4C0A, 0x4C2A, 0x4C2A, 0x4C2A, 0x4C2A, 
        0x4C2A, 0x4C29, 0x4429, 0x4429, 0x4429, 0x4429, 0x444A, 0x444A, 0x4C6A, 0x4409, 0x4409, 0x4409, 0x43E9, 0x4BEA, 0x4BC9, 0x4BEA, 0x5C6B, 0x7D4F, 0x9E53, 0x9612, 0x85D1, 0x85D0, 0x756F, 0x548B, 0x4C6A, 0x4CAB, 0x4CAB, 0x44AA, 0x4CCB, 0x54EB, 
        0x54EC, 0x5D0C, 0x54CB, 0x4C29, 0x43C8, 0x3BA7, 0x3BA7, 0x3BA7, 0x3B88, 0x3B49, 0x336A, 0x3BAC, 0x4C6D, 0x5D2F, 0x656F, 0x652D, 0x548B, 0x4408, 0x4409, 0x4C2A, 0x4C6B, 0x4CAD, 0x54CE, 0x5510, 0x6551, 0x6551, 0x6D71, 0x6D51, 0x650F, 0x548C, 
        0x440A, 0x4409, 0x4409, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x440A, 0x4BEA, 0x4BCA, 0x4BCA, 0x4BAA, 0x4328, 0x3AE8, 0x3AE9, 0x3AC9, 0x42C9, 0x52EA, 0x5AEA, 0x632B, 0x634B, 0x634B, 0x5B4A, 0x5B29, 0x52E9, 
        0x5B6A, 0x638B, 0x6BAC, 0x6BEC, 0x63AC, 0x4B09, 0x3A87, 0x3246, 0x3226, 0x3A67, 0x4B09, 0x63EC, 0x6C2D, 0x746D, 0x7CCE, 0x7D0F, 0x852F, 0x852F, 0x7CEE, 0x74CD, 0x748C, 0x6C4B, 0x642A, 0x5C09, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BE9, 0x5BE9, 0x640A, 
        0x642A, 0x644A, 0x644A, 0x6C2A, 0x6C4A, 0x746B, 0x746B, 0x746B, 0x744B, 0x744B, 0x744C, 0x742D, 0x6C2D, 0x6C2E, 0x642E, 0x644F, 0x53CD, 0x4B8C, 0x4BAC, 0x5C0C, 0x644C, 0x6C8C, 0x74CC, 0x7CED, 0x7CEC, 0x6C8B, 0x6C6A, 0x646A, 0x644A, 0x6C6B, 
        0x7C8C, 0x8CAD, 0x948E, 0x944D, 0x8C2D, 0x944D, 0x8C8D, 0x8CAD, 0x84AD, 0x7CAD, 0x7CAD, 0x74AD, 0x74AD, 0x74EE, 0x74CD, 0x6CAD, 0x6CAD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x74CD, 0x7CED, 0x850E, 0x852E, 0x8D4E, 0x8D4F, 0x8D4F,
  0x7C8D, 0x84EF, 0x746D, 0x644C, 0x644B, 0x5C4B, 0x5C6B, 0x5CAB, 0x64CC, 0x650D, 0x650D, 0x64ED, 0x6D0E, 0x750F, 0x7D10, 0x8D31, 0x84D0, 0x73EE, 0x5B0A, 0x4A48, 0x41E6, 0x41C6, 0x41C5, 0x41C5, 0x5246, 0x634A, 0x7C8E, 0x6C2D, 0x748F, 0x74B0, 0x7471, 
        0x63B0, 0x6390, 0x6BB0, 0x6BB0, 0x7C10, 0x7C10, 0x62EB, 0x41E7, 0x3165, 0x2924, 0x2903, 0x28E3, 0x28E3, 0x2903, 0x20E3, 0x20E3, 0x2103, 0x1923, 0x31E5, 0x63CC, 0x744E, 0x744F, 0x6C2F, 0x744F, 0x6C0E, 0x5B8C, 0x532A, 0x4AC9, 0x4287, 0x4A87, 
        0x4AA7, 0x4AA7, 0x4AC7, 0x4AE7, 0x52E7, 0x5307, 0x5307, 0x4AE7, 0x4AE7, 0x4AC7, 0x4AC7, 0x4AC7, 0x52C7, 0x52A8, 0x52A8, 0x52A8, 0x5288, 0x5288, 0x5267, 0x5267, 0x5287, 0x5288, 0x52A8, 0x52A8, 0x5AE8, 0x5B08, 0x5328, 0x5B68, 0x5B88, 0x5B88, 
        0x5BA8, 0x5BC8, 0x5BC8, 0x5BE9, 0x5C09, 0x6429, 0x642A, 0x642A, 0x642A, 0x640A, 0x5C09, 0x640A, 0x646C, 0x64AC, 0x5CCD, 0x5D0E, 0x5D0E, 0x550E, 0x5D0F, 0x5CEF, 0x64AF, 0x646F, 0x642F, 0x63EF, 0x6BCE, 0x73CD, 0x840D, 0xA4F0, 0xACCF, 0xB4CE, 
        0xBD0E, 0xC52F, 0xC52F, 0xC52F, 0xBD4F, 0xBD2E, 0xB50E, 0xBD0E, 0xBD2E, 0xBD0E, 0xB50D, 0xB4ED, 0xB4ED, 0xB4ED, 0xB4ED, 0xACCD, 0xACCD, 0xA4AD, 0x9C6C, 0x8C0B, 0x8C0B, 0x8C2B, 0x8C4C, 0x8C6D, 0x8C6D, 0x8C6E, 0x844E, 0x73ED, 0x6BEC, 0x74AE, 
        0x854F, 0x8DB1, 0x8DD0, 0x85B0, 0x7D8F, 0x6D2D, 0x5D0D, 0x54EC, 0x4CCB, 0x44AB, 0x44AA, 0x4CAA, 0x4C8A, 0x4C8A, 0x548B, 0x548B, 0x548A, 0x546A, 0x544A, 0x4C0A, 0x4BEA, 0x5C2C, 0x642C, 0x6C0C, 0x6C0C, 0x6C0B, 0x640B, 0x53EA, 0x3B68, 0x2B47, 
        0x2B47, 0x2B67, 0x3388, 0x3BC8, 0x3BC8, 0x3BE8, 0x43E8, 0x43C8, 0x43C8, 0x43C8, 0x4BC8, 0x4BE8, 0x4BE8, 0x53E9, 0x5409, 0x5C09, 0x5C0A, 0x5C0A, 0x5C09, 0x5BE9, 0x5BEA, 0x5BEA, 0x5C0A, 0x5C2B, 0x5C4B, 0x5C4B, 0x5C4B, 0x5C2A, 0x53E9, 0x4BE9, 
        0x4BC8, 0x4BC8, 0x4BC9, 0x4C09, 0x4BE9, 0x43C8, 0x43C8, 0x43A8, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B67, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3367, 0x3348, 0x3B47, 0x3B47, 0x3B47, 0x3B47, 0x3B48, 0x3B28, 0x3B27, 0x3307, 0x3B07, 
        0x4328, 0x4328, 0x4B29, 0x5349, 0x5329, 0x5349, 0x5B49, 0x5B49, 0x5B49, 0x6369, 0x6369, 0x5B69, 0x5B69, 0x6369, 0x6369, 0x6349, 0x6329, 0x5B08, 0x634A, 0x9D11, 0xB5F4, 0x9D73, 0x9511, 0x84F0, 0x7CD0, 0x748F, 0x748F, 0x748F, 0x74B0, 0x74B0, 
        0x74B0, 0x74B0, 0x74D1, 0x8512, 0x8D53, 0x9573, 0x8D53, 0x8D32, 0x8532, 0x8532, 0x74F1, 0x646F, 0x5C2E, 0x540D, 0x4C0D, 0x4BED, 0x4BEE, 0x4BAE, 0x43AD, 0x4BAD, 0x5BEE, 0x9DF5, 0x74AF, 0x53CA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C2A, 
        0x4C29, 0x4C29, 0x4429, 0x4429, 0x4429, 0x4429, 0x444A, 0x4C8B, 0x4C8B, 0x4429, 0x4429, 0x4409, 0x4409, 0x4C0A, 0x43C9, 0x3B88, 0x4BEA, 0x648C, 0x95F2, 0x9E53, 0x8DF1, 0x85D1, 0x85D1, 0x6D0D, 0x4C4A, 0x4C6A, 0x4CAB, 0x44AA, 0x44CA, 0x4CEB, 
        0x4CEB, 0x54EC, 0x550C, 0x5CEC, 0x546A, 0x43E8, 0x3BA7, 0x3BA7, 0x3B88, 0x3B69, 0x3B6A, 0x3B8B, 0x4C2D, 0x54EE, 0x654F, 0x654E, 0x5D2D, 0x4C6A, 0x4429, 0x4C4B, 0x4C6C, 0x4CAD, 0x54EF, 0x5530, 0x6551, 0x6571, 0x6D71, 0x6D50, 0x64EF, 0x4C6C, 
        0x440A, 0x4409, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x4449, 0x444A, 0x442A, 0x4429, 0x4429, 0x440A, 0x4BE9, 0x4BEA, 0x4BEA, 0x4BAA, 0x434A, 0x32CA, 0x3AEB, 0x430C, 0x4B0C, 0x530D, 0x5B4D, 0x636D, 0x5B6C, 0x5B4C, 0x4AEA, 0x42A9, 
        0x42A8, 0x4288, 0x4287, 0x3A87, 0x3A67, 0x3267, 0x3246, 0x3246, 0x3226, 0x3247, 0x42A8, 0x63CC, 0x6BEC, 0x63EB, 0x642C, 0x6C6D, 0x74AE, 0x8550, 0x7D0F, 0x6C6C, 0x6C8C, 0x74AC, 0x74AC, 0x6C8C, 0x6C6B, 0x6C6B, 0x6C6B, 0x644B, 0x644B, 0x642B, 
        0x642B, 0x644A, 0x644A, 0x6C4A, 0x6C6A, 0x746B, 0x748B, 0x7C6B, 0x746B, 0x7C6B, 0x7C6B, 0x7C4C, 0x744D, 0x6C2D, 0x63ED, 0x63EE, 0x5BEE, 0x53CE, 0x4B4C, 0x53EC, 0x5C2C, 0x6C6C, 0x74AC, 0x7CCD, 0x7CCD, 0x748B, 0x746B, 0x6C6A, 0x6C4A, 0x7C8B, 
        0x84AD, 0x842C, 0x83CB, 0x8BEC, 0x942D, 0x946E, 0x8C8D, 0x848D, 0x7C8D, 0x7C8C, 0x74AC, 0x74AC, 0x6CAD, 0x7D0F, 0x74EE, 0x6CAD, 0x74AD, 0x7CCD, 0x7CED, 0x7CED, 0x7CED, 0x7CED, 0x7CED, 0x7CED, 0x850D, 0x852E, 0x8D4E, 0x8D4E, 0x8D6F,
  0x848E, 0x8D10, 0x7CCE, 0x6C6C, 0x646B, 0x646B, 0x5C8B, 0x5CAB, 0x64EC, 0x64ED, 0x650D, 0x64ED, 0x650D, 0x6D2F, 0x7D30, 0x9592, 0xA5D4, 0xA593, 0x8C90, 0x73CD, 0x62EA, 0x5268, 0x5247, 0x5206, 0x4A05, 0x842D, 0xBE35, 0x744E, 0x744F, 0x7491, 0x7451, 
        0x63D0, 0x6BD1, 0x6BB0, 0x636E, 0x6B6E, 0x4A69, 0x3186, 0x2904, 0x2903, 0x28E3, 0x28E3, 0x28E3, 0x28E3, 0x20E3, 0x20E3, 0x20E3, 0x2103, 0x1922, 0x29C4, 0x4B09, 0x4B29, 0x640D, 0x642E, 0x6C6F, 0x6C6F, 0x6C4E, 0x6C2E, 0x5B8C, 0x3AA7, 0x3A86, 
        0x42A6, 0x42C7, 0x4AC7, 0x42E7, 0x4AE7, 0x4AE7, 0x4AE7, 0x42E7, 0x42C7, 0x42C7, 0x42A6, 0x42A6, 0x4AA7, 0x4AA7, 0x4AA7, 0x4A88, 0x4A67, 0x4A67, 0x4A47, 0x4A47, 0x4A47, 0x4A67, 0x4A87, 0x4AA7, 0x4AC7, 0x4B07, 0x5327, 0x5368, 0x5367, 0x5387, 
        0x53A8, 0x5BC8, 0x5BC8, 0x5BE9, 0x640A, 0x642A, 0x644A, 0x6C4A, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4C, 0x6C6C, 0x64AC, 0x5CCD, 0x54ED, 0x550E, 0x5D0E, 0x5D0F, 0x64EF, 0x64CF, 0x5C6F, 0x644F, 0x642F, 0x6BCE, 0x73CC, 0x946E, 0xA4CF, 0xACCE, 0xB50E, 
        0xBD2E, 0xC52E, 0xBD2F, 0xBD2E, 0xBD0E, 0xB4EE, 0xB4ED, 0xB4ED, 0xB50E, 0xB50E, 0xB4ED, 0xACCD, 0xACAC, 0xACAC, 0xA4AC, 0xA4AC, 0xA48C, 0x9C6C, 0x942C, 0x8C0B, 0x8C2B, 0x8C2C, 0x8C4C, 0x8C6D, 0x8C4D, 0x8C6E, 0x7C2D, 0x5B6B, 0x536A, 0x5BEB, 
        0x6CAD, 0x854F, 0x85D0, 0x85B0, 0x758F, 0x652D, 0x5D0D, 0x54EC, 0x4CCC, 0x44CB, 0x44AA, 0x44AA, 0x4C8A, 0x4C8A, 0x548B, 0x548B, 0x548A, 0x546A, 0x4C4A, 0x440A, 0x4BEB, 0x5C2D, 0x640D, 0x63CC, 0x5BAB, 0x5BCB, 0x53CB, 0x4389, 0x2B48, 0x2B67, 
        0x2B88, 0x33A8, 0x3BC8, 0x43C8, 0x43C8, 0x43E8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4BE8, 0x4C09, 0x5429, 0x5C2A, 0x5C4A, 0x5C4A, 0x5C4A, 0x5C2A, 0x5C0A, 0x5BEA, 0x5BE9, 0x5BEA, 0x5C0A, 0x5C2A, 0x5C2A, 0x5C2A, 0x540A, 0x53E9, 0x4BC8, 0x4BC8, 
        0x43A8, 0x43A8, 0x43A8, 0x43A8, 0x43A8, 0x3B87, 0x3B87, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B68, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B67, 0x3B68, 0x3B67, 0x3B67, 0x3B67, 0x3B47, 0x3B48, 0x3B48, 0x3B47, 0x3B27, 0x3B27, 
        0x4327, 0x4B28, 0x4B28, 0x5348, 0x5349, 0x5B49, 0x5B49, 0x5B69, 0x5B69, 0x6389, 0x6B89, 0x6389, 0x6B89, 0x6B89, 0x6B89, 0x6B69, 0x6349, 0x6329, 0x6309, 0x6B6B, 0xAD93, 0xADB4, 0x9D32, 0x8CF1, 0x84D0, 0x7C90, 0x7490, 0x748F, 0x6C6F, 0x6C6F, 
        0x6C6F, 0x6C8F, 0x74B0, 0x7CF1, 0x7D12, 0x8513, 0x8533, 0x84F2, 0x7CF2, 0x7CF1, 0x74B0, 0x644F, 0x540E, 0x540D, 0x4BED, 0x4BCD, 0x43CD, 0x43AD, 0x43AD, 0x4BAD, 0x5BEE, 0x9DF5, 0x7CCF, 0x53EA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C29, 
        0x4C29, 0x4429, 0x4429, 0x4429, 0x4429, 0x4429, 0x442A, 0x4C6B, 0x54CC, 0x444A, 0x4429, 0x4429, 0x4409, 0x43E9, 0x43C9, 0x43C9, 0x43C9, 0x542A, 0x750E, 0x8E12, 0x9612, 0x8E12, 0x8DD1, 0x7D90, 0x5CAB, 0x4409, 0x4449, 0x446A, 0x4CAA, 0x4CEB, 
        0x4CEC, 0x550C, 0x550D, 0x5D2D, 0x650D, 0x5CCC, 0x4C29, 0x3BA8, 0x3B88, 0x3B69, 0x3B6A, 0x336B, 0x43EC, 0x4CAE, 0x5D2F, 0x654F, 0x654E, 0x5D0D, 0x4C6A, 0x4C4B, 0x4C8C, 0x4CCE, 0x54EF, 0x5D30, 0x6551, 0x6D71, 0x6D71, 0x6D50, 0x5CEE, 0x4C4B, 
        0x442A, 0x4429, 0x4429, 0x3C29, 0x4429, 0x4429, 0x4429, 0x442A, 0x444A, 0x444A, 0x444A, 0x3C4A, 0x3C49, 0x3C29, 0x440A, 0x4C0A, 0x4C0B, 0x4BEB, 0x4BCC, 0x4B8D, 0x4B8E, 0x4B6E, 0x536F, 0x536F, 0x5B8E, 0x5B6E, 0x536D, 0x4B4C, 0x4B0A, 0x42CA, 
        0x3AA9, 0x3A88, 0x3A88, 0x3268, 0x3247, 0x3247, 0x3247, 0x2A27, 0x3227, 0x3227, 0x42A8, 0x6BED, 0x6C0D, 0x63EC, 0x538A, 0x4308, 0x3B08, 0x53AA, 0x5BEB, 0x5BEB, 0x6C6C, 0x74CE, 0x7CEE, 0x7CED, 0x7CED, 0x7CEE, 0x7CCD, 0x74AD, 0x748C, 0x6C6C, 
        0x6C4C, 0x6C6B, 0x6C8B, 0x6C6B, 0x6C6A, 0x748B, 0x7C8B, 0x7C8B, 0x7C6B, 0x7C6B, 0x7C6B, 0x7C8C, 0x7C4C, 0x742D, 0x6C0D, 0x63CD, 0x5BAE, 0x63AF, 0x5BAE, 0x5BCD, 0x5BEC, 0x6C2C, 0x744C, 0x7C8D, 0x7C8D, 0x7C6C, 0x7C8C, 0x746B, 0x7C6B, 0x84AC, 
        0x8CAD, 0x8C2C, 0x83CB, 0x8C0C, 0x8C4D, 0x948E, 0x84AD, 0x7C8D, 0x748C, 0x748C, 0x6C8C, 0x6C8C, 0x6CAD, 0x7D0F, 0x7CEE, 0x74AD, 0x74AD, 0x7CCD, 0x7CED, 0x7CED, 0x7CED, 0x7CED, 0x7D0D, 0x850E, 0x852E, 0x8D4E, 0x8D4E, 0x8D6F, 0x956F,
  0x7C6D, 0x7CAE, 0x748D, 0x644C, 0x644B, 0x5C6B, 0x5C6B, 0x5CAB, 0x64CC, 0x64ED, 0x650D, 0x650D, 0x6D2E, 0x6D4F, 0x754F, 0x8571, 0x9592, 0x9551, 0x84D0, 0x848F, 0x844E, 0x7BCC, 0x7B8B, 0x730A, 0x732A, 0x948F, 0xBE56, 0x84B0, 0x6C2F, 0x7C91, 0x7451, 
        0x6BF1, 0x6BF1, 0x63AF, 0x3A29, 0x2965, 0x2945, 0x2904, 0x2903, 0x28E3, 0x28E3, 0x28E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x2103, 0x1922, 0x2183, 0x3246, 0x19E4, 0x3B08, 0x5C4D, 0x5C8E, 0x64AF, 0x74F1, 0x7511, 0x6C8F, 0x640D, 0x42E8, 
        0x3AA6, 0x42C6, 0x42C6, 0x42E6, 0x42E7, 0x42E7, 0x42E7, 0x42E7, 0x42C6, 0x3AC6, 0x3AA6, 0x42A6, 0x42A6, 0x4286, 0x4287, 0x4267, 0x4267, 0x4246, 0x4246, 0x4A67, 0x4A88, 0x4AA8, 0x5329, 0x63AB, 0x63CB, 0x63AA, 0x63CA, 0x63EA, 0x5BE9, 0x53A8, 
        0x53A8, 0x5BA9, 0x5BC9, 0x5BCA, 0x63EA, 0x642B, 0x644B, 0x6C6B, 0x6C4B, 0x6C4B, 0x6C6B, 0x744C, 0x6C6C, 0x648C, 0x5CAC, 0x54CC, 0x550D, 0x550E, 0x5D0F, 0x5D0F, 0x5CCF, 0x5C8F, 0x646F, 0x6C2F, 0x6BCD, 0x840D, 0x9CAE, 0xACCE, 0xB4CE, 0xBD0E, 
        0xC52F, 0xC54F, 0xC52F, 0xBD0E, 0xBD2E, 0xB4ED, 0xB4CD, 0xB4ED, 0xB4ED, 0xACED, 0xACAD, 0xA48C, 0xA46C, 0xA48C, 0xA48C, 0x9C6C, 0x944B, 0x8C2B, 0x8C0B, 0x8C2B, 0x8C2C, 0x8C4C, 0x8C4D, 0x8C4D, 0x8C6E, 0x7C4E, 0x532A, 0x4B2A, 0x4B8A, 0x4BCA, 
        0x542B, 0x64AC, 0x6D0D, 0x6D4E, 0x6D2D, 0x652D, 0x5D0C, 0x54EC, 0x4CEC, 0x44CB, 0x44CB, 0x4CAB, 0x4CAB, 0x4CAB, 0x548B, 0x548B, 0x548B, 0x544A, 0x4C2A, 0x43EB, 0x4BCB, 0x640D, 0x63CD, 0x538C, 0x538B, 0x53CB, 0x43AA, 0x3389, 0x2B68, 0x2B88, 
        0x33A8, 0x43E9, 0x4BE9, 0x4BE9, 0x4BE9, 0x4BE9, 0x5409, 0x5429, 0x5C2A, 0x5C4A, 0x5C2A, 0x540A, 0x5C2A, 0x5C2A, 0x5C2A, 0x5C4A, 0x5C2A, 0x5C2A, 0x5C0A, 0x5BEA, 0x5BC9, 0x53C9, 0x53EA, 0x53C9, 0x53E9, 0x4BC9, 0x4BC9, 0x4BC8, 0x4BC8, 0x4BC8, 
        0x4BA8, 0x4388, 0x43A8, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x3B88, 0x4368, 0x4388, 0x4368, 0x4367, 0x4347, 0x4348, 0x4348, 0x4347, 0x3B47, 0x4327, 
        0x4327, 0x4B28, 0x4B48, 0x5348, 0x5348, 0x5B48, 0x5B68, 0x5B68, 0x5B69, 0x5B69, 0x6389, 0x6389, 0x6B89, 0x6B89, 0x6B89, 0x6B69, 0x6B6A, 0x6B49, 0x6329, 0x5AE8, 0x73EC, 0xB5D4, 0xADB4, 0x9D53, 0x8CD1, 0x7C90, 0x7490, 0x7490, 0x6C6F, 0x6C6F, 
        0x642E, 0x642E, 0x6C6F, 0x74B0, 0x74D1, 0x7CD1, 0x7CF2, 0x7CD2, 0x74D1, 0x74D1, 0x6CB0, 0x644F, 0x540E, 0x4BCD, 0x43AD, 0x43AD, 0x43AD, 0x438D, 0x438D, 0x4B8D, 0x5BCE, 0x9DD5, 0x7CF0, 0x53CA, 0x4BEA, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C29, 
        0x4C29, 0x4429, 0x4429, 0x4449, 0x4429, 0x442A, 0x442A, 0x444B, 0x54CC, 0x4C8B, 0x4429, 0x4429, 0x4409, 0x4409, 0x43E9, 0x43E9, 0x43C8, 0x43C8, 0x542A, 0x6CCD, 0x754E, 0x8E12, 0x9612, 0x8DF1, 0x7D8F, 0x5C8B, 0x4409, 0x3C09, 0x4449, 0x4CCB, 
        0x4CEC, 0x550C, 0x552D, 0x5D2D, 0x5D2E, 0x654E, 0x652D, 0x546B, 0x43C9, 0x3B89, 0x3B6A, 0x334A, 0x3BCC, 0x4C8D, 0x550E, 0x654F, 0x654F, 0x652E, 0x5CCC, 0x4C8C, 0x4C8C, 0x4CCE, 0x54EF, 0x5D30, 0x6551, 0x6D71, 0x6D71, 0x6D50, 0x5CCE, 0x4C4B, 
        0x442A, 0x3C29, 0x4429, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C2A, 0x444A, 0x444A, 0x444A, 0x3C4A, 0x3C4A, 0x3C4A, 0x442A, 0x442B, 0x4C0B, 0x43EC, 0x43EC, 0x4BCE, 0x4BAE, 0x4B8F, 0x4B8F, 0x4B8F, 0x4B8E, 0x4B8D, 0x436C, 0x434A, 0x432A, 0x3B09, 
        0x3AE9, 0x3AC8, 0x32A8, 0x3287, 0x2A67, 0x2A47, 0x2A47, 0x2A47, 0x2A47, 0x3227, 0x3A88, 0x5B8C, 0x63CC, 0x536A, 0x42E8, 0x32A7, 0x32A7, 0x4329, 0x5BEC, 0x640C, 0x746E, 0x7CCE, 0x7CCE, 0x74AD, 0x7CCD, 0x7CCD, 0x74AD, 0x642B, 0x640B, 0x640B, 
        0x642B, 0x748D, 0x7CCD, 0x74CC, 0x74AC, 0x7CAB, 0x7CAC, 0x84AC, 0x848B, 0x848B, 0x848C, 0x848C, 0x7C6C, 0x744C, 0x742D, 0x6BEE, 0x6BCE, 0x638F, 0x63B0, 0x63CF, 0x63CD, 0x63CC, 0x6C0C, 0x742C, 0x740C, 0x744C, 0x846D, 0x848C, 0x848C, 0x8C8C, 
        0x8C6C, 0x8C2C, 0x8C0D, 0x942D, 0x8C6E, 0x8C8D, 0x7C8D, 0x748C, 0x748C, 0x6C8C, 0x6CAC, 0x6C8C, 0x6C8C, 0x7D0F, 0x7CEE, 0x74CD, 0x74CC, 0x7CCD, 0x7CCD, 0x7CED, 0x7CED, 0x7CED, 0x7D0E, 0x852E, 0x852E, 0x8D4E, 0x8D4E, 0x956F, 0x956F,
  0x7C4C, 0x7C8D, 0x746D, 0x644C, 0x646C, 0x646B, 0x5C6B, 0x5C8C, 0x64CC, 0x64CC, 0x64CC, 0x6CED, 0x6D2E, 0x6D2E, 0x6D0E, 0x750E, 0x7D2F, 0x850F, 0x850F, 0x8D10, 0x9531, 0x9D10, 0x9CD0, 0x946E, 0x9C8E, 0xA4F0, 0x9D31, 0x7C6F, 0x744F, 0x7491, 0x7472, 
        0x7452, 0x7431, 0x638F, 0x3A08, 0x3186, 0x39A6, 0x2904, 0x28E3, 0x28E3, 0x28E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x2103, 0x1903, 0x1923, 0x2163, 0x2A05, 0x2205, 0x19E3, 0x4369, 0x5C8D, 0x5CAE, 0x6CF0, 0x7531, 0x6CAF, 0x5C0D, 0x3AE8, 
        0x3AA6, 0x3AC6, 0x3AC6, 0x42E6, 0x42E6, 0x42E7, 0x42E7, 0x42C6, 0x3AC6, 0x3AA6, 0x3AA6, 0x3A85, 0x3265, 0x3265, 0x3A46, 0x4286, 0x73EC, 0x7C2D, 0x844E, 0x844E, 0x846E, 0x846E, 0x846E, 0x846E, 0x846E, 0x7C6E, 0x7C6D, 0x7C6D, 0x7C8D, 0x748D, 
        0x6C4B, 0x6C4B, 0x640B, 0x640B, 0x640B, 0x6C2C, 0x644C, 0x6C6B, 0x6C6B, 0x6C6B, 0x6C6B, 0x746C, 0x6C8C, 0x648B, 0x5CAB, 0x54CC, 0x54ED, 0x550E, 0x5D0E, 0x5D0E, 0x5CEF, 0x64AF, 0x6C6F, 0x640E, 0x73ED, 0x8C6D, 0xA4EF, 0xB50F, 0xBCEE, 0xC52E, 
        0xCD4F, 0xCD4F, 0xBD2E, 0xBD0E, 0xC54F, 0xBD0E, 0xB4ED, 0xACCD, 0xACCD, 0xA4AC, 0xA48C, 0x9C6C, 0x9C6C, 0x9C6C, 0x9C2B, 0x940B, 0x8C2B, 0x8C2C, 0x8C4C, 0x8C4C, 0x8C4C, 0x8C4C, 0x8C4D, 0x8C6E, 0x8C8F, 0x638B, 0x4288, 0x3AC8, 0x4349, 0x43AA, 
        0x43EA, 0x4C2A, 0x4C8A, 0x54CB, 0x54EC, 0x54EC, 0x54EC, 0x4CEC, 0x4CEC, 0x4CEB, 0x4CEB, 0x4CCB, 0x4CCB, 0x4CAB, 0x54AB, 0x548B, 0x548B, 0x546B, 0x4C4B, 0x43EB, 0x4BAC, 0x63EE, 0x5B8D, 0x536C, 0x4B6B, 0x43AB, 0x3B8A, 0x3389, 0x33A9, 0x3BC9, 
        0x43E9, 0x4BE9, 0x53EA, 0x53EA, 0x53EA, 0x53EA, 0x5BEA, 0x5C2A, 0x5C2A, 0x5C2A, 0x5C2A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C0A, 0x5C2A, 0x642A, 0x5C0A, 0x5BEA, 0x5BEA, 0x5BC9, 0x5BC9, 0x53C9, 0x53A9, 0x53A8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BC8, 
        0x4BC8, 0x4BC8, 0x4BA8, 0x43A8, 0x43A8, 0x4388, 0x4388, 0x4BA8, 0x4B88, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4388, 0x4B88, 0x4388, 0x4388, 0x4368, 0x4368, 0x4348, 0x4348, 0x4348, 0x4347, 
        0x4B48, 0x4B48, 0x5368, 0x5368, 0x5368, 0x5B68, 0x5B68, 0x5B89, 0x6389, 0x6389, 0x6389, 0x6B89, 0x6B89, 0x6BA9, 0x6B8A, 0x6B69, 0x6B8A, 0x6B6A, 0x6309, 0x52A8, 0x52C8, 0x8C8F, 0xB5D5, 0xA574, 0x9D33, 0x84B1, 0x7C90, 0x7470, 0x6C4F, 0x6C4F, 
        0x642F, 0x640E, 0x6C4F, 0x6C4F, 0x6C70, 0x7471, 0x7CD2, 0x74B2, 0x7491, 0x74B1, 0x6C90, 0x644F, 0x540E, 0x4BCD, 0x43AD, 0x438D, 0x438D, 0x436D, 0x436D, 0x4B8E, 0x5BCE, 0x9DB4, 0x8D51, 0x53CA, 0x53EA, 0x4C0A, 0x4C0A, 0x4C0A, 0x4C29, 0x4C29, 
        0x4409, 0x4429, 0x4429, 0x4C29, 0x4C4A, 0x4C2A, 0x4C2B, 0x442B, 0x54AC, 0x54AC, 0x4429, 0x4429, 0x4408, 0x4408, 0x4408, 0x43E9, 0x43E9, 0x4BE9, 0x4BE9, 0x4C0A, 0x544B, 0x754F, 0x8DF1, 0x8E12, 0x8DF1, 0x756F, 0x548B, 0x43E9, 0x3C09, 0x3C29, 
        0x3C29, 0x3C6A, 0x4CAB, 0x54EC, 0x5D0D, 0x652D, 0x652E, 0x650D, 0x64CD, 0x540B, 0x3B8A, 0x334A, 0x3BAC, 0x442D, 0x54EF, 0x5D2F, 0x654F, 0x6D4E, 0x650D, 0x54AD, 0x4CAD, 0x4CCE, 0x550F, 0x5D30, 0x6551, 0x6D71, 0x6D71, 0x6530, 0x54AD, 0x444B, 
        0x3C2A, 0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C4B, 0x3C4B, 0x3C4B, 0x3C4B, 0x442B, 0x442B, 0x442C, 0x440C, 0x43ED, 0x43EE, 0x43CE, 0x43AF, 0x43AF, 0x43AE, 0x43AD, 0x438C, 0x3B8B, 0x3B6A, 0x3B49, 0x3B29, 
        0x3328, 0x32E8, 0x32E8, 0x2AA7, 0x2A87, 0x2A67, 0x2A66, 0x2A46, 0x2A47, 0x3247, 0x3247, 0x42C9, 0x4B09, 0x42C8, 0x3AA7, 0x32A7, 0x3AA7, 0x42E9, 0x4B29, 0x4B49, 0x4B49, 0x5369, 0x5BAA, 0x640B, 0x642B, 0x6C4B, 0x642B, 0x640B, 0x5C0A, 0x5BEB, 
        0x640B, 0x6C6C, 0x7CCD, 0x84ED, 0x84ED, 0x84ED, 0x84CD, 0x8CCC, 0x84AC, 0x848C, 0x848C, 0x848C, 0x848D, 0x7C8D, 0x744D, 0x740E, 0x73EE, 0x6BAF, 0x6B6F, 0x638E, 0x636D, 0x5B2C, 0x638C, 0x6BAC, 0x73CC, 0x740C, 0x7BEB, 0x7C0B, 0x8C8D, 0x948C, 
        0x946D, 0x8C0C, 0x8C2C, 0x946D, 0x8C8D, 0x848D, 0x7C8C, 0x748C, 0x6C8C, 0x6C8C, 0x6C8C, 0x6C8C, 0x6C8C, 0x850F, 0x7CEE, 0x7CCD, 0x74CD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CED, 0x7CED, 0x850D, 0x852E, 0x852E, 0x8D2E, 0x8D4E, 0x956E, 0x956F,
  0x7C2C, 0x7C6D, 0x746D, 0x6C6D, 0x6C8D, 0x646C, 0x5C4B, 0x5C6B, 0x6CED, 0x64AD, 0x5C8C, 0x64AD, 0x6D2E, 0x6D2E, 0x6D0E, 0x750E, 0x7D0E, 0x7D0E, 0x84EE, 0x8D0F, 0x9530, 0xA551, 0xA571, 0xA551, 0xA550, 0xA530, 0x9D10, 0x8CD0, 0x7CB0, 0x7491, 0x7492, 
        0x7472, 0x7451, 0x6BAF, 0x4A69, 0x4A28, 0x6B2C, 0x4A08, 0x3124, 0x28E4, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x20E3, 0x1903, 0x1923, 0x1943, 0x2163, 0x21A4, 0x3A87, 0x1A04, 0x1A24, 0x3B48, 0x544C, 0x5C6D, 0x5C6E, 0x542D, 0x3B29, 0x3AC6, 
        0x3AA6, 0x3AC6, 0x42C6, 0x42C6, 0x42C6, 0x42C7, 0x42A6, 0x42C6, 0x3AA6, 0x3A86, 0x42C6, 0x63CB, 0x63EC, 0x5B8A, 0x6BCC, 0x7C4D, 0x9CF0, 0x9D11, 0x9CF0, 0x94D0, 0x94D0, 0x94B0, 0x8C8F, 0x8C6F, 0x8C6F, 0x8C6F, 0x8C6F, 0x846E, 0x7C8E, 0x7C8E, 
        0x7C8E, 0x7C6E, 0x7C4D, 0x744E, 0x744D, 0x6C2D, 0x644C, 0x6C6C, 0x648B, 0x646B, 0x648B, 0x648B, 0x648B, 0x64AB, 0x5CAB, 0x54CC, 0x54CC, 0x5D0D, 0x5D0E, 0x5D2E, 0x64EE, 0x64AF, 0x642D, 0x63EC, 0x7C0D, 0x9CAE, 0xB50F, 0xBD2E, 0xBD2F, 0xC54F, 
        0xCD4F, 0xC54E, 0xBCED, 0xC52E, 0xC56F, 0xBD4F, 0xACCD, 0xACAD, 0xA4AD, 0x9C8C, 0x9C6C, 0x9C4C, 0x9C6C, 0x942B, 0x8BEA, 0x8C0B, 0x8C2C, 0x8C4C, 0x8C6C, 0x8C6C, 0x8C6C, 0x844C, 0x844D, 0x948F, 0x842E, 0x638C, 0x42C9, 0x3AC8, 0x3B08, 0x3348, 
        0x33A9, 0x3BE9, 0x3C29, 0x446A, 0x4C8A, 0x4CAB, 0x44AB, 0x44AB, 0x4CEC, 0x4D0C, 0x550C, 0x54EC, 0x54EC, 0x54CB, 0x5CCB, 0x5CCB, 0x5CAB, 0x548B, 0x546C, 0x4BCB, 0x53AC, 0x63EF, 0x534D, 0x534C, 0x4B4B, 0x438A, 0x3B8A, 0x3BAA, 0x43CA, 0x4BCA, 
        0x4BEA, 0x53CA, 0x53CA, 0x5BEA, 0x5BEA, 0x5BEB, 0x5C0B, 0x5BCB, 0x5BEB, 0x5C0A, 0x5BEA, 0x5BEA, 0x640A, 0x5C0A, 0x5C0A, 0x640A, 0x640A, 0x640A, 0x63EA, 0x5BE9, 0x5BE9, 0x5BC9, 0x5BC9, 0x5BC9, 0x53C8, 0x53A9, 0x5388, 0x4B88, 0x4B88, 0x53A8, 
        0x53A8, 0x53A8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4BA8, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4BA9, 0x4BA9, 0x4BA9, 0x4B88, 0x4B88, 0x4B88, 0x4388, 0x4388, 0x4368, 0x4368, 0x4B68, 0x4368, 0x4B68, 
        0x4B68, 0x5368, 0x5368, 0x5368, 0x5B68, 0x5B68, 0x5B89, 0x5B89, 0x6389, 0x6BA9, 0x6BAA, 0x6BA9, 0x6B89, 0x6B89, 0x6B89, 0x6B69, 0x6349, 0x5B09, 0x52C8, 0x4A88, 0x4A87, 0x6309, 0x9CB1, 0xAD94, 0x9D12, 0x94F2, 0x8490, 0x7450, 0x6C2F, 0x6C2F, 
        0x6C2F, 0x640F, 0x640F, 0x642F, 0x6C30, 0x6C51, 0x7C92, 0x7492, 0x6C71, 0x7491, 0x7491, 0x644F, 0x5C0E, 0x4BCD, 0x438D, 0x438D, 0x436D, 0x436D, 0x436D, 0x538E, 0x5BAE, 0x9574, 0x9592, 0x5BEA, 0x53EA, 0x4C0A, 0x4C09, 0x4C09, 0x4C09, 0x4429, 
        0x4429, 0x4429, 0x442A, 0x4C2A, 0x4C2B, 0x5C8D, 0x546C, 0x4C2B, 0x546B, 0x54CD, 0x442A, 0x4409, 0x4408, 0x4408, 0x4408, 0x43E9, 0x43E9, 0x4C09, 0x43E9, 0x43E9, 0x4C2A, 0x5CAC, 0x6D2E, 0x85D0, 0x8E12, 0x9612, 0x7D70, 0x64CC, 0x4C09, 0x43E9, 
        0x3BE9, 0x3C09, 0x3C29, 0x444A, 0x446A, 0x4C6B, 0x54AB, 0x5CAC, 0x5C8D, 0x5C6D, 0x4BAB, 0x3B4B, 0x3B8C, 0x440D, 0x54AE, 0x5D0F, 0x652F, 0x652E, 0x650E, 0x54CD, 0x4CAD, 0x4CCE, 0x550F, 0x6550, 0x6D71, 0x6D71, 0x6D51, 0x6530, 0x54AD, 0x442B, 
        0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2A, 0x3C2B, 0x3C2B, 0x442B, 0x442C, 0x444C, 0x4C4C, 0x442D, 0x440D, 0x3BED, 0x43CE, 0x43EE, 0x43EE, 0x43EE, 0x3BCD, 0x3BCC, 0x3BAB, 0x3BAA, 0x3B89, 0x3369, 0x3349, 
        0x3348, 0x3308, 0x32E8, 0x2AC8, 0x2A87, 0x2A87, 0x2A67, 0x2A46, 0x2A47, 0x2A47, 0x3267, 0x3A87, 0x3A87, 0x3AA7, 0x3AA7, 0x3AC7, 0x42E8, 0x4309, 0x4B09, 0x4309, 0x4309, 0x4B49, 0x5BAA, 0x640B, 0x642B, 0x6C2B, 0x642B, 0x642B, 0x640A, 0x5BEA, 
        0x5BEA, 0x5BEA, 0x5C0A, 0x6C4B, 0x7CCD, 0x84ED, 0x8CED, 0x8CED, 0x8CED, 0x8CED, 0x8CCD, 0x8CAD, 0x848D, 0x7C8D, 0x7C4D, 0x7C4E, 0x7C0E, 0x7BF0, 0x73B0, 0x6B6F, 0x6B8F, 0x634E, 0x530C, 0x5B2C, 0x6BAC, 0x7C0D, 0x842D, 0x948D, 0xA4EE, 0xA4EE, 
        0x9C8E, 0x8C0C, 0x8C2C, 0x8C8D, 0x848D, 0x7C8C, 0x748C, 0x748C, 0x748C, 0x6C8C, 0x6C8C, 0x6C8C, 0x748D, 0x852F, 0x7CEE, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CED, 0x850D, 0x850D, 0x8D2E, 0x8D2E, 0x8D2E, 0x8D2E, 0x8D4E,
  0x740C, 0x742C, 0x744D, 0x6C6D, 0x644C, 0x5C4B, 0x5C2B, 0x5C4B, 0x6CCD, 0x64CD, 0x5C8C, 0x64AD, 0x64ED, 0x6D0E, 0x6D0E, 0x750E, 0x750E, 0x7CEE, 0x7CEE, 0x850E, 0x8D2E, 0x9D4F, 0x9D6F, 0xA590, 0xA590, 0xA570, 0x9D50, 0x94F0, 0x7CB0, 0x74B1, 0x74B2, 
        0x7492, 0x7472, 0x7C51, 0x73AD, 0x5AA9, 0x6B2B, 0x83CE, 0x7B8D, 0x5248, 0x3165, 0x2904, 0x20E3, 0x20E3, 0x2104, 0x2103, 0x1903, 0x1923, 0x1943, 0x2143, 0x2183, 0x2A05, 0x2A45, 0x2204, 0x2245, 0x32E7, 0x3B49, 0x3B28, 0x3B28, 0x3AE8, 0x3AA6, 
        0x42A6, 0x42C7, 0x42E7, 0x4AE7, 0x42C6, 0x42C6, 0x42C7, 0x4AE7, 0x5328, 0x5B8A, 0x6BEB, 0x84CF, 0x8D10, 0x8CF0, 0x94F0, 0x9CF0, 0xA531, 0xA531, 0xA532, 0xA512, 0xA4F1, 0xA4F1, 0xA4F1, 0xA4F1, 0x9CD1, 0x9CD1, 0x9CD1, 0x94D0, 0x94D0, 0x8CAF, 
        0x8CAF, 0x848F, 0x846E, 0x7C4E, 0x7C4E, 0x6C2D, 0x6C4D, 0x6C6D, 0x6C8C, 0x646B, 0x646B, 0x648B, 0x648B, 0x64AB, 0x5CAB, 0x5CCC, 0x54CC, 0x5CED, 0x5D0D, 0x5D0E, 0x650F, 0x648E, 0x5BEC, 0x740D, 0x8C4D, 0xACEF, 0xBD4F, 0xC52F, 0xC52F, 0xCD4F, 
        0xCD4F, 0xBCED, 0xBD0E, 0xC54F, 0xBD4E, 0xB4ED, 0xA4AC, 0xA4AD, 0xA4AD, 0x9C8C, 0x942C, 0x944C, 0x942C, 0x8BCB, 0x8C0B, 0x8C2B, 0x8C2C, 0x8C4C, 0x8C4C, 0x844C, 0x844C, 0x844C, 0x842D, 0x8C6F, 0x7C0E, 0x63AD, 0x536B, 0x4B4A, 0x436A, 0x3369, 
        0x2347, 0x2347, 0x2346, 0x2387, 0x33E8, 0x3C09, 0x3C4A, 0x446A, 0x44AB, 0x4CEC, 0x54EC, 0x54EC, 0x5CEC, 0x5CEC, 0x5CEC, 0x5CEC, 0x5CCC, 0x5CAC, 0x546C, 0x4BCC, 0x538C, 0x63AF, 0x532D, 0x534D, 0x4B4C, 0x436B, 0x438A, 0x43AA, 0x4BAA, 0x4BAA, 
        0x53AA, 0x53CA, 0x5BCA, 0x5C0B, 0x642C, 0x6C2D, 0x642C, 0x53AB, 0x53AA, 0x5BCB, 0x63CB, 0x63EA, 0x63EA, 0x63EA, 0x640A, 0x63EB, 0x63EB, 0x63EB, 0x63EA, 0x63EA, 0x5BCA, 0x63CA, 0x63C9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5389, 0x4B68, 0x4B68, 0x4B88, 
        0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x5388, 0x4B88, 0x4B88, 0x4BA8, 0x53A8, 0x4BA8, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4BA9, 0x4BA9, 0x4B89, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B68, 0x4B68, 0x4368, 0x4B68, 0x4B68, 
        0x4B68, 0x5368, 0x5368, 0x5368, 0x5B89, 0x5B89, 0x6389, 0x5B89, 0x6389, 0x63A9, 0x6BA9, 0x6B89, 0x6B69, 0x6348, 0x6348, 0x5B08, 0x52E8, 0x4AA8, 0x4A88, 0x4247, 0x4247, 0x4A67, 0x6B6C, 0xA513, 0xA553, 0x94F2, 0x8470, 0x742F, 0x6C0F, 0x6BEF, 
        0x6C0F, 0x63EF, 0x5BEE, 0x63EE, 0x63EF, 0x6C30, 0x7471, 0x7472, 0x7451, 0x7471, 0x6C71, 0x642F, 0x5BEE, 0x4BAE, 0x438D, 0x436D, 0x436E, 0x436E, 0x4B6E, 0x538E, 0x5BAE, 0x8D33, 0xA5F4, 0x642B, 0x540A, 0x4C09, 0x4C09, 0x4409, 0x4409, 0x4429, 
        0x4429, 0x442A, 0x4C2A, 0x4C2B, 0x4C2B, 0x64AE, 0x544C, 0x4C0B, 0x4C2A, 0x5CED, 0x4C6A, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4409, 0x43E9, 0x43E9, 0x4409, 0x4C4A, 0x5CAC, 0x548B, 0x64ED, 0x7D70, 0x8E12, 0x8E12, 0x85B0, 0x6D0E, 0x4C0A, 
        0x43E9, 0x43E9, 0x43E9, 0x3BE9, 0x3BE9, 0x3BE8, 0x3BE9, 0x43E9, 0x43EA, 0x4BCA, 0x438B, 0x3B4B, 0x438C, 0x43ED, 0x548E, 0x5CCF, 0x650F, 0x652E, 0x5D0E, 0x4CCE, 0x4CAD, 0x4CCE, 0x5510, 0x6551, 0x6D71, 0x6D71, 0x6D50, 0x652F, 0x4C8C, 0x442A, 
        0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x3C2A, 0x3C2A, 0x3C2A, 0x342A, 0x3C2A, 0x3C2B, 0x3C2B, 0x442C, 0x444C, 0x444C, 0x4C4D, 0x4C4D, 0x4C2D, 0x440D, 0x43ED, 0x43EE, 0x43EE, 0x440E, 0x43ED, 0x3BEC, 0x3BCB, 0x3BCA, 0x3BAA, 0x3BAA, 0x3B89, 0x3388, 
        0x3348, 0x3328, 0x3308, 0x32E8, 0x2AA8, 0x2AA7, 0x2A87, 0x2A87, 0x2A67, 0x2A67, 0x3287, 0x3A87, 0x3A87, 0x3AA7, 0x3AC7, 0x4329, 0x536A, 0x538A, 0x538B, 0x538B, 0x538B, 0x5BCB, 0x63EB, 0x640B, 0x642B, 0x642B, 0x642A, 0x642A, 0x5C0A, 0x53EA, 
        0x53EA, 0x53EA, 0x5BEA, 0x5BE9, 0x63E9, 0x6409, 0x6C0A, 0x6C0A, 0x7C8C, 0x8D0E, 0x952F, 0x8CEE, 0x7C8C, 0x7C6D, 0x7C6D, 0x7C4D, 0x73CD, 0x6B6D, 0x632D, 0x6B4F, 0x6B4F, 0x6B70, 0x5B0E, 0x5B0D, 0x6B6D, 0x840E, 0x948E, 0x9CCE, 0xA4EE, 0xA4EE, 
        0x944C, 0x8C2C, 0x8C6D, 0x8C8D, 0x84AD, 0x7C8C, 0x74AC, 0x74AC, 0x6C8C, 0x6C8C, 0x6C8C, 0x6C8D, 0x74AD, 0x852F, 0x7CEE, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CED, 0x84ED, 0x850D, 0x8D2E, 0x8D2E, 0x8D2E, 0x8D2D, 0x8D2D,
  0x7C2C, 0x742C, 0x744D, 0x6C4D, 0x642C, 0x5C4B, 0x5C2B, 0x5C2B, 0x5C6C, 0x64CD, 0x6CEE, 0x64CD, 0x64CD, 0x64EE, 0x6D0E, 0x750E, 0x750E, 0x7CEE, 0x7CED, 0x7CED, 0x7CEC, 0x8D0D, 0x954E, 0x9D6E, 0x9D6F, 0x9D6F, 0x9D4F, 0x950F, 0x7CB0, 0x74B1, 0x74B2, 
        0x7CB2, 0x7CB2, 0x8CF2, 0x9CF1, 0x9CD0, 0x9CB0, 0x9CB1, 0x9CB1, 0x9CB1, 0x8C0F, 0x736C, 0x5ACA, 0x4207, 0x62EB, 0x4228, 0x2144, 0x2965, 0x2985, 0x29C5, 0x3206, 0x3226, 0x3226, 0x3286, 0x4308, 0x4B49, 0x4B69, 0x4308, 0x4308, 0x4328, 0x5369, 
        0x63AA, 0x63AA, 0x6BEB, 0x742C, 0x7C6D, 0x7C8D, 0x7C8E, 0x8CAF, 0x8CF0, 0x9510, 0x9510, 0x9531, 0x9D52, 0x9D32, 0x9D11, 0xA531, 0xAD32, 0xAD52, 0xA511, 0x9CD1, 0x9C90, 0x9C90, 0x9470, 0x942F, 0x942F, 0x944F, 0x9450, 0x8C6F, 0x8C70, 0x9490, 
        0x9490, 0x8CB0, 0x8C90, 0x8470, 0x844F, 0x7C4F, 0x744E, 0x746E, 0x6C6D, 0x6C6C, 0x646C, 0x646C, 0x646C, 0x648B, 0x64AB, 0x5CAC, 0x5CAC, 0x5CCD, 0x5D0D, 0x5D0E, 0x6CEE, 0x5BEB, 0x6C0C, 0x844D, 0x9C8E, 0xB52F, 0xC54F, 0xC54F, 0xC52F, 0xCD4F, 
        0xC52E, 0xBCED, 0xC54F, 0xC54F, 0xBD0E, 0xB4ED, 0xACCD, 0x9C6C, 0xA48D, 0x9C6D, 0x8BEB, 0x8BEB, 0x8BEB, 0x8BEC, 0x8C0C, 0x8C2B, 0x8C2C, 0x842C, 0x842C, 0x842C, 0x842C, 0x7BEC, 0x7C0D, 0x7C2E, 0x740E, 0x63ED, 0x5C0C, 0x53EC, 0x4BEB, 0x43CA, 
        0x33A9, 0x2347, 0x1284, 0x12A4, 0x12E5, 0x2326, 0x2BA8, 0x3C09, 0x3C6A, 0x44AB, 0x4CCB, 0x54EC, 0x5CEC, 0x5D0C, 0x5D0C, 0x650C, 0x64EC, 0x5CAC, 0x546C, 0x4BCB, 0x4B6C, 0x5B4E, 0x52ED, 0x4B0D, 0x4B0C, 0x4B2B, 0x4B4B, 0x4B8B, 0x538B, 0x53AB, 
        0x53CB, 0x5BCB, 0x5C0C, 0x644D, 0x6C6E, 0x6C8E, 0x6C6E, 0x5BCC, 0x538B, 0x5BAB, 0x63CB, 0x63CB, 0x63EB, 0x63EB, 0x63EB, 0x63EB, 0x63EB, 0x63EB, 0x63CB, 0x5BCA, 0x5BAA, 0x63AA, 0x63AA, 0x63A9, 0x63A9, 0x63A9, 0x5BA9, 0x5368, 0x5388, 0x5368, 
        0x5388, 0x4B88, 0x4B88, 0x4B68, 0x4B68, 0x4B68, 0x4B88, 0x5388, 0x53E9, 0x53C9, 0x4B88, 0x4B88, 0x53A9, 0x53A8, 0x53A8, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x4B88, 0x53A8, 0x4BA8, 0x4B88, 0x4B88, 0x4B88, 0x4B88, 0x4B68, 0x4B68, 0x4B68, 
        0x4B68, 0x5368, 0x5368, 0x5368, 0x5368, 0x5B88, 0x5B89, 0x5B89, 0x5B89, 0x6389, 0x6369, 0x6328, 0x5B08, 0x52E7, 0x4AA7, 0x4AA7, 0x4287, 0x4267, 0x3A47, 0x3A27, 0x3A06, 0x3A06, 0x4227, 0x6B6D, 0xA513, 0x9D12, 0x8CB2, 0x7C50, 0x740F, 0x6C0F, 
        0x6BEF, 0x63EF, 0x63EF, 0x640F, 0x640F, 0x63EF, 0x6C10, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6410, 0x5BCE, 0x538E, 0x4B6D, 0x4B6D, 0x4B6E, 0x4B6E, 0x4B6E, 0x536E, 0x5B8E, 0x8D33, 0xB697, 0x6C4C, 0x53EA, 0x4BE9, 0x43E9, 0x43E9, 0x4409, 0x4409, 
        0x440A, 0x440A, 0x440B, 0x4C0B, 0x5C6D, 0x5C8D, 0x4C2B, 0x440A, 0x440A, 0x54AC, 0x54CB, 0x4409, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4409, 0x43E9, 0x4409, 0x4C2A, 0x54AB, 0x548C, 0x546B, 0x64CD, 0x7D70, 0x9633, 0x9632, 0x8DF1, 0x6D2F, 
        0x5C8C, 0x4BE9, 0x43E9, 0x43E8, 0x43E8, 0x3BE8, 0x3BE8, 0x43A8, 0x4388, 0x4388, 0x434A, 0x3B2B, 0x3B4B, 0x3B8C, 0x544E, 0x5CAF, 0x5CEF, 0x5D0E, 0x5CEE, 0x4CCE, 0x4CAE, 0x4CCE, 0x5D30, 0x6551, 0x6D51, 0x6D71, 0x6D50, 0x650F, 0x4C6C, 0x442A, 
        0x3C29, 0x3C29, 0x3C29, 0x3C29, 0x340A, 0x340A, 0x3C2A, 0x342A, 0x3C2A, 0x3C2B, 0x444C, 0x4C6D, 0x548D, 0x4C6D, 0x4C4D, 0x4C2D, 0x440D, 0x440D, 0x43ED, 0x440E, 0x440E, 0x440D, 0x440D, 0x3C0C, 0x3BEB, 0x3BEA, 0x3BCA, 0x3BCA, 0x3BC9, 0x3BA9, 
        0x3389, 0x3368, 0x3348, 0x3328, 0x32E8, 0x32E8, 0x32C7, 0x2AA7, 0x3287, 0x3287, 0x3287, 0x3A87, 0x3AA7, 0x3AC7, 0x4328, 0x538A, 0x5BAB, 0x5BCB, 0x5BCB, 0x5BCB, 0x63EB, 0x63EB, 0x640B, 0x642B, 0x642A, 0x642A, 0x5C2A, 0x5C0A, 0x540A, 0x5409, 
        0x5409, 0x5409, 0x53EA, 0x5C09, 0x5C09, 0x5C09, 0x63EA, 0x5BA9, 0x5368, 0x6C2B, 0x7C8C, 0x7C6C, 0x744C, 0x742C, 0x742C, 0x7C0C, 0x7BED, 0x6B6C, 0x634D, 0x6B4E, 0x6B2F, 0x6330, 0x6350, 0x632F, 0x6B2D, 0x842F, 0x944E, 0x948D, 0x946D, 0x8C0B, 
        0x8C0C, 0x8C4D, 0x946D, 0x8C8D, 0x848D, 0x748C, 0x748C, 0x6CAC, 0x748C, 0x6C8D, 0x6C8D, 0x6C8C, 0x74AD, 0x852F, 0x7CEE, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x84ED, 0x850D, 0x8D2E, 0x8D4E, 0x8D4E, 0x8D2E, 0x8D2D,
  0x7C2C, 0x742C, 0x742C, 0x6C4C, 0x642C, 0x5C2B, 0x5C2B, 0x5C2B, 0x5C6B, 0x64AD, 0x64ED, 0x64CD, 0x5CAD, 0x5CCD, 0x6CEE, 0x750E, 0x750E, 0x74CE, 0x6C8C, 0x6C6B, 0x6C6B, 0x7CAC, 0x8D2D, 0x954D, 0x954E, 0x954E, 0x8D2E, 0x84EF, 0x7CB0, 0x74B1, 0x7CD2, 
        0x7CD2, 0x84D2, 0x8D11, 0x9D11, 0x9D10, 0xA510, 0xA531, 0xA531, 0xA531, 0xA511, 0x9CF1, 0x9CD1, 0x94B1, 0x9491, 0x842F, 0x6B8D, 0x6BAD, 0x73CE, 0x740E, 0x740E, 0x742E, 0x742E, 0x744E, 0x84AF, 0x84D0, 0x7CCF, 0x7CCF, 0x7CCF, 0x84CF, 0x8D0F, 
        0x9530, 0x9510, 0x9530, 0x9D51, 0x9D72, 0xA572, 0x9510, 0x94D0, 0x9CF0, 0x9D31, 0xA552, 0xA552, 0xA552, 0xA531, 0x9CB0, 0x9CB0, 0x948F, 0x944F, 0x8C0E, 0x8BEE, 0x8BCD, 0x8BEE, 0x8BEE, 0x8BEE, 0x8C0F, 0x8C0F, 0x840E, 0x83EE, 0x840E, 0x842F, 
        0x842F, 0x8C6F, 0x8C6F, 0x7C2F, 0x844F, 0x7C6F, 0x742E, 0x744E, 0x746E, 0x6C6D, 0x6C6D, 0x6C6D, 0x6C6D, 0x648C, 0x648C, 0x64AC, 0x5CAC, 0x5CCD, 0x5CED, 0x64EE, 0x5C2C, 0x6BEB, 0x848E, 0x948E, 0xACCE, 0xBD4F, 0xC54F, 0xC54F, 0xC54F, 0xC52E, 
        0xBD0D, 0xC54E, 0xC52E, 0xB50E, 0xB4ED, 0xACCD, 0xACAD, 0xA46D, 0xA48E, 0xA48E, 0x8BEB, 0x8BEB, 0x8BEC, 0x840C, 0x842C, 0x842C, 0x842C, 0x842C, 0x7C2C, 0x7C0C, 0x7C0C, 0x7BED, 0x7C0D, 0x740D, 0x744D, 0x6C6D, 0x646C, 0x5C6C, 0x544B, 0x4C0B, 
        0x3BEA, 0x33A9, 0x1AA5, 0x01E2, 0x0202, 0x1264, 0x1B06, 0x2B67, 0x3409, 0x446A, 0x4CAB, 0x54CC, 0x5CEC, 0x650C, 0x650C, 0x650D, 0x64CD, 0x5CAC, 0x544C, 0x4BAC, 0x4B2C, 0x530E, 0x426C, 0x4AAD, 0x4AAC, 0x4B0C, 0x534C, 0x538C, 0x5BAC, 0x5BCC, 
        0x640C, 0x642D, 0x6C6D, 0x6C8E, 0x6CAE, 0x6C8E, 0x646E, 0x642D, 0x5BEC, 0x5BCB, 0x63CB, 0x63EB, 0x6BEC, 0x63CB, 0x5BAB, 0x63CB, 0x6BEC, 0x6BEC, 0x63EC, 0x63CB, 0x5BAB, 0x638A, 0x63AA, 0x6BCA, 0x6BCA, 0x63CA, 0x63AA, 0x5BA9, 0x5BA9, 0x5BA9, 
        0x5BAA, 0x53A9, 0x5389, 0x4B68, 0x4B68, 0x4B68, 0x4B68, 0x5388, 0x5BA9, 0x53A9, 0x5389, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A9, 0x53A8, 0x53A8, 0x53A8, 0x4B88, 0x4B88, 0x4B88, 0x4B68, 0x4B68, 0x4B68, 
        0x5368, 0x5368, 0x5368, 0x5368, 0x5368, 0x5368, 0x5368, 0x5369, 0x5369, 0x5B48, 0x5B28, 0x52E8, 0x4AC7, 0x4287, 0x4267, 0x3A47, 0x3A27, 0x3A06, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x39E6, 0x4227, 0x7C0F, 0x9D13, 0x94D2, 0x8491, 0x7410, 0x7410, 
        0x6BEF, 0x63CF, 0x63CF, 0x63CE, 0x63EF, 0x5BCF, 0x63CF, 0x6C31, 0x7C72, 0x7451, 0x7452, 0x6C31, 0x5BAE, 0x538E, 0x4B4D, 0x4B4D, 0x4B6E, 0x4B4E, 0x4B6E, 0x5B8F, 0x63AE, 0x8CD2, 0xBE97, 0x642C, 0x4BC9, 0x4BE9, 0x43E9, 0x43E9, 0x43E9, 0x43E9, 
        0x440A, 0x43EB, 0x4C0C, 0x542C, 0x5C6D, 0x544C, 0x4C2B, 0x4C0A, 0x440A, 0x4C6A, 0x5CEC, 0x4429, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C09, 0x4C09, 0x4409, 0x4C29, 0x4C4A, 0x548C, 0x54AC, 0x5C8C, 0x6CEE, 0x7D70, 0x9612, 0x9612, 0x8E12, 
        0x756F, 0x648C, 0x5C6B, 0x4C0A, 0x43E9, 0x43E8, 0x43C8, 0x43A8, 0x43A8, 0x3B88, 0x3B69, 0x3B4A, 0x3B4B, 0x3B6C, 0x4C0E, 0x548F, 0x5CCF, 0x5CEE, 0x54CE, 0x44AD, 0x44AE, 0x4CEF, 0x5D30, 0x6571, 0x6D71, 0x6D51, 0x6D30, 0x5CCE, 0x4C6B, 0x442A, 
        0x3C2A, 0x3C29, 0x3C09, 0x3C09, 0x340A, 0x340A, 0x3C2A, 0x3C0B, 0x444B, 0x4C6C, 0x4C8D, 0x54AE, 0x548E, 0x4C6D, 0x4C2D, 0x440D, 0x440D, 0x440D, 0x440E, 0x442E, 0x442E, 0x442D, 0x442C, 0x3C2C, 0x3C0B, 0x3C0A, 0x3C0A, 0x3BEA, 0x3BC9, 0x3BC9, 
        0x3BA9, 0x3B89, 0x3B69, 0x3B49, 0x3B29, 0x3B08, 0x3308, 0x32E8, 0x3AC8, 0x3AC7, 0x3AC7, 0x3AC7, 0x3AE8, 0x4B28, 0x5389, 0x5BCA, 0x63EB, 0x63EB, 0x640B, 0x640B, 0x640B, 0x640B, 0x640B, 0x642A, 0x642A, 0x5C2A, 0x5C09, 0x5409, 0x5409, 0x5409, 
        0x5409, 0x5409, 0x5C09, 0x5C09, 0x5C09, 0x53A9, 0x4B88, 0x4B48, 0x4B27, 0x5389, 0x63CA, 0x63CA, 0x6C0A, 0x744C, 0x7C4C, 0x7C2C, 0x73CC, 0x73AC, 0x840F, 0x73B0, 0x5AEE, 0x5ACF, 0x6331, 0x6B51, 0x632E, 0x7BCF, 0x83ED, 0x9CAE, 0x948D, 0x8C2C, 
        0x840C, 0x946D, 0x8C8D, 0x848D, 0x7C8D, 0x748C, 0x6C8C, 0x6CAC, 0x6C8C, 0x748C, 0x748D, 0x6C8D, 0x7CCE, 0x852F, 0x7CEE, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x84ED, 0x850D, 0x8D4E, 0x954E, 0x954E, 0x954E, 0x8D2E,
  0x844C, 0x7C4C, 0x7C4D, 0x744D, 0x644C, 0x5C0B, 0x5C0A, 0x5C4B, 0x5C6B, 0x5C8C, 0x64AC, 0x5C8C, 0x5C8C, 0x5C8D, 0x64CD, 0x6CEE, 0x74EE, 0x6C8D, 0x642B, 0x6C4B, 0x6C4B, 0x746B, 0x7CAC, 0x850D, 0x8D2D, 0x8D2D, 0x850E, 0x7CCE, 0x746F, 0x7490, 0x7CB1, 
        0x7CD1, 0x84F1, 0x9531, 0x9D51, 0x9D30, 0x9D30, 0xA530, 0xA510, 0x9D10, 0x9CF0, 0x9CF0, 0x9CF1, 0x9CD1, 0x94D2, 0x94D2, 0x94D2, 0x8CD1, 0x8CB1, 0x8490, 0x8CB1, 0x8CD1, 0x8CD1, 0x8CF1, 0x9531, 0x8D10, 0x8D10, 0x9551, 0x9571, 0x9571, 0xA5B2, 
        0xA592, 0xA591, 0xA592, 0xA592, 0xADB3, 0xADB3, 0xA532, 0xA511, 0xA511, 0xA511, 0xA4F1, 0xA4F1, 0x9CB0, 0x8C4E, 0x8C0E, 0x8C0E, 0x940E, 0x940E, 0x940F, 0x942F, 0x942F, 0x940F, 0x8BEE, 0x83AD, 0x83EE, 0x840E, 0x7C0E, 0x7C2E, 0x7C2E, 0x7C2E, 
        0x7C4E, 0x742E, 0x742E, 0x742E, 0x7C4F, 0x744F, 0x742E, 0x744E, 0x744F, 0x746F, 0x746F, 0x748E, 0x746E, 0x6C4D, 0x6C4C, 0x6C4C, 0x646C, 0x5CAC, 0x64AD, 0x5C2B, 0x63EB, 0x846D, 0x94CE, 0x9C8D, 0xB4EE, 0xCD70, 0xCD6F, 0xC56F, 0xC52E, 0xBD2E, 
        0xC54E, 0xBD2E, 0xB4ED, 0xACAD, 0xACAD, 0xAC8D, 0xA48D, 0xB4CE, 0xAC8E, 0x942C, 0x8BEC, 0x8C0C, 0x8C0C, 0x8C2C, 0x842C, 0x844C, 0x846C, 0x7C4C, 0x7C2C, 0x7C0C, 0x7C0D, 0x7C0D, 0x7C2E, 0x744E, 0x6C8D, 0x64AC, 0x64AC, 0x5C8C, 0x548B, 0x4C6B, 
        0x444B, 0x440A, 0x3B89, 0x22A6, 0x0A04, 0x09C3, 0x0A04, 0x22E7, 0x33C9, 0x3C2A, 0x446A, 0x54AB, 0x64EC, 0x6D0D, 0x6CED, 0x6CED, 0x6CCD, 0x5C8C, 0x542C, 0x438C, 0x42EC, 0x4AAD, 0x420B, 0x422C, 0x52AD, 0x5B2D, 0x5B6D, 0x5BAD, 0x63ED, 0x6C2D, 
        0x6C6E, 0x6C8E, 0x6C8E, 0x6CAE, 0x6CAE, 0x6CAF, 0x6C8E, 0x648E, 0x6C6E, 0x746E, 0x744E, 0x744E, 0x744E, 0x746E, 0x746E, 0x7CAF, 0x7CCF, 0x7CF0, 0x74CF, 0x748F, 0x6C2D, 0x5B8B, 0x5B2A, 0x638A, 0x6BAA, 0x6BAA, 0x5B69, 0x5B69, 0x5B6A, 0x5B8A, 
        0x5BAB, 0x5BAB, 0x4B29, 0x4308, 0x4B49, 0x5369, 0x5368, 0x5368, 0x5B88, 0x5389, 0x5389, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA8, 0x5BA8, 0x53C8, 0x53C8, 0x53A8, 0x5388, 0x4B88, 0x4B88, 0x4B68, 0x4B88, 0x4B88, 
        0x4B88, 0x4B68, 0x4B68, 0x4B68, 0x4B68, 0x4B47, 0x4B48, 0x4B48, 0x4B28, 0x4B08, 0x4AE8, 0x42A8, 0x3A67, 0x3A47, 0x3207, 0x3207, 0x3206, 0x31E6, 0x29C6, 0x29A6, 0x29C6, 0x3207, 0x31E6, 0x31E6, 0x4AA9, 0x7C4F, 0x94F2, 0x7C50, 0x7C30, 0x6BCF, 
        0x63CF, 0x63AF, 0x63AF, 0x63CF, 0x5BAF, 0x5BAF, 0x63CF, 0x7430, 0x7C72, 0x7C72, 0x8492, 0x7451, 0x5BAF, 0x5BAE, 0x536D, 0x4B4D, 0x4B6E, 0x4B6E, 0x4B6E, 0x5BAF, 0x63AE, 0x8491, 0xC698, 0x6C4C, 0x4BC9, 0x43E9, 0x43E9, 0x43CA, 0x43CA, 0x43CA, 
        0x43CB, 0x43EB, 0x542C, 0x5C8D, 0x544C, 0x542B, 0x542A, 0x4C2A, 0x4C29, 0x4429, 0x5CEC, 0x548B, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4409, 0x4409, 0x4429, 0x4C4A, 0x548C, 0x546C, 0x4C4B, 0x5C8C, 0x7550, 0x85B1, 0x8DD2, 
        0x85B1, 0x754F, 0x6D0E, 0x6CED, 0x5C8C, 0x544A, 0x4C4A, 0x4C09, 0x43C9, 0x43C8, 0x3B89, 0x3B6A, 0x3B6B, 0x3B6C, 0x43CD, 0x544E, 0x5C8E, 0x5CCE, 0x54AE, 0x44AD, 0x44CE, 0x54EF, 0x5D31, 0x6D71, 0x6D72, 0x6D31, 0x6510, 0x5CAE, 0x4C4B, 0x442A, 
        0x3C29, 0x3C09, 0x3C09, 0x3C0A, 0x3C0A, 0x3C0A, 0x3C0A, 0x442B, 0x54AD, 0x5CCE, 0x54AE, 0x548E, 0x544E, 0x4C2D, 0x4C0D, 0x440D, 0x440E, 0x4C0E, 0x4C2E, 0x442E, 0x444D, 0x444D, 0x444C, 0x3C4C, 0x444B, 0x442B, 0x442A, 0x440A, 0x43EA, 0x43CA, 
        0x43A9, 0x4389, 0x4389, 0x436A, 0x436A, 0x4349, 0x4349, 0x4B49, 0x4329, 0x3B08, 0x3B08, 0x4308, 0x4B49, 0x5BAA, 0x63EA, 0x63EA, 0x640B, 0x640A, 0x642A, 0x642B, 0x642B, 0x642B, 0x642B, 0x642A, 0x5C2A, 0x5C29, 0x5429, 0x5429, 0x5429, 0x5429, 
        0x5429, 0x5429, 0x5C09, 0x5C29, 0x5C29, 0x5BEA, 0x5BCA, 0x5BCA, 0x5BEA, 0x642B, 0x744C, 0x744B, 0x744B, 0x7C6C, 0x848C, 0x846C, 0x844D, 0x8C6E, 0x946F, 0x8431, 0x632F, 0x5ACE, 0x5AF0, 0x6331, 0x6B4F, 0x632D, 0x7BAC, 0x9CAE, 0x9CAE, 0x944D, 
        0x840C, 0x8C6D, 0x8CAD, 0x7C8D, 0x748C, 0x74AC, 0x6CAC, 0x6CAC, 0x6CAC, 0x74AC, 0x748D, 0x74AD, 0x7CEE, 0x850F, 0x7CED, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x74CD, 0x7CCD, 0x7CCD, 0x7CED, 0x850D, 0x8D4E, 0x954E, 0x954E, 0x954E, 0x954E,
  0x844C, 0x844C, 0x7C6D, 0x746D, 0x6C4C, 0x642B, 0x5C4B, 0x5C6B, 0x5C6B, 0x5C6B, 0x5C6B, 0x5C8C, 0x5CCD, 0x64CD, 0x64CE, 0x6CAD, 0x6C8D, 0x644C, 0x642B, 0x642B, 0x6C4B, 0x748C, 0x7CCC, 0x84ED, 0x84ED, 0x84ED, 0x84ED, 0x7CAE, 0x7C8F, 0x7490, 0x7CB1, 
        0x7CB1, 0x84F1, 0x9D52, 0xA571, 0x9D30, 0x9D2F, 0x9D0F, 0x94EF, 0x94CF, 0x94CF, 0x94CF, 0x94CF, 0x94D0, 0x94B1, 0x94F2, 0x94F2, 0x8470, 0x7C2F, 0x740F, 0x740E, 0x740E, 0x7C2E, 0x84B0, 0x9531, 0x8D10, 0x8CF0, 0x8D10, 0x8D30, 0x8D10, 0x8D0F, 
        0x9530, 0x9530, 0x9D30, 0x9D30, 0x9D11, 0x9D11, 0x9CF0, 0x9CD0, 0x9C8F, 0x9C90, 0x9C90, 0x948F, 0x948F, 0x946F, 0x942E, 0x8C0E, 0x83CD, 0x838C, 0x836C, 0x732B, 0x6B0A, 0x5AA9, 0x5267, 0x4A67, 0x52A8, 0x634B, 0x6BED, 0x742D, 0x742D, 0x6C4D, 
        0x6C4D, 0x6C2D, 0x6C2D, 0x6C2D, 0x6C2D, 0x6C2E, 0x6C2E, 0x744E, 0x744E, 0x744E, 0x744F, 0x748F, 0x746F, 0x6C6E, 0x6C4D, 0x6C4D, 0x644C, 0x646C, 0x5C2B, 0x5BEA, 0x7C4C, 0x94CE, 0x9CCE, 0xA4AD, 0xBD4F, 0xCD90, 0xCD6F, 0xC54E, 0xC52E, 0xC52E, 
        0xBD0D, 0xB4ED, 0xB4CD, 0xAC8C, 0xACAC, 0xACCD, 0xB50F, 0xA46D, 0x940C, 0x940C, 0x8C0C, 0x8C2C, 0x8C2D, 0x8C4D, 0x8C4D, 0x846C, 0x846C, 0x7C4C, 0x7C2C, 0x7C0C, 0x7C0D, 0x7C2D, 0x7C8E, 0x748E, 0x6CAC, 0x64CC, 0x64CC, 0x5CCC, 0x54AB, 0x54AB, 
        0x4C8B, 0x4C4B, 0x4BEB, 0x43AA, 0x22A7, 0x09A3, 0x09A3, 0x1A45, 0x2B07, 0x3BC9, 0x4409, 0x4C4A, 0x6CED, 0x752E, 0x7D0E, 0x74ED, 0x6CAD, 0x5C6D, 0x53EC, 0x434C, 0x42CD, 0x4AAD, 0x4A6D, 0x5AEF, 0x634F, 0x638F, 0x63AE, 0x6BEE, 0x6C2E, 0x6C4E, 
        0x6C6E, 0x6C8E, 0x648E, 0x64AE, 0x64AE, 0x6CCF, 0x6CCF, 0x74F0, 0x74F0, 0x7CF0, 0x7CD0, 0x7CAF, 0x7CCF, 0x7CF0, 0x8511, 0x8551, 0x8552, 0x7D52, 0x7D52, 0x7D11, 0x6C70, 0x63AD, 0x42A8, 0x3A67, 0x4287, 0x4267, 0x3A46, 0x3A26, 0x3A46, 0x3A66, 
        0x3AA7, 0x3AA8, 0x3A87, 0x3AA7, 0x4B08, 0x5349, 0x5368, 0x5368, 0x5388, 0x5369, 0x5388, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BC9, 0x5BC9, 0x53A8, 0x53A8, 0x5388, 0x5388, 0x5388, 0x5388, 0x5388, 
        0x4B88, 0x4B88, 0x4B68, 0x4B68, 0x4B48, 0x4B48, 0x4328, 0x4B08, 0x4B08, 0x42E8, 0x42A8, 0x3A67, 0x3227, 0x2A06, 0x29E6, 0x31E7, 0x31E7, 0x29E6, 0x29C6, 0x29A6, 0x29C6, 0x3207, 0x31E6, 0x29E6, 0x3206, 0x530A, 0x8470, 0x94F3, 0x7C50, 0x7C50, 
        0x6BCF, 0x6BCF, 0x6BCF, 0x63AF, 0x5B8E, 0x5BAE, 0x63CF, 0x7430, 0x8492, 0x7C72, 0x7C72, 0x7410, 0x63CF, 0x63AF, 0x538E, 0x536E, 0x536E, 0x536E, 0x536E, 0x63AF, 0x63AF, 0x8471, 0xCED9, 0x748D, 0x4BC9, 0x43C9, 0x3BC9, 0x3BCA, 0x43CA, 0x3BAA, 
        0x43CB, 0x43CB, 0x4C2C, 0x544C, 0x4C2B, 0x4C2A, 0x4C2A, 0x4C29, 0x4C29, 0x4409, 0x548B, 0x5CEC, 0x4C29, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4409, 0x4409, 0x442A, 0x548C, 0x4C2A, 0x4C2B, 0x5C6C, 0x6D0E, 0x7D90, 
        0x7D90, 0x7D90, 0x754F, 0x752E, 0x6D2E, 0x6D0D, 0x6D0D, 0x64ED, 0x64CC, 0x64CD, 0x5C8D, 0x5C4D, 0x53ED, 0x43AD, 0x43AD, 0x4C2E, 0x546E, 0x54AE, 0x54CE, 0x4CCE, 0x4CCE, 0x550F, 0x6551, 0x6D71, 0x6D51, 0x6D31, 0x6510, 0x5CAD, 0x4C4B, 0x440A, 
        0x3C29, 0x3C09, 0x3C0A, 0x3C0A, 0x3C0A, 0x3C0A, 0x3C0B, 0x4C8D, 0x5CCE, 0x5CCE, 0x548E, 0x4C4D, 0x4C2D, 0x4C0D, 0x4C0D, 0x442E, 0x4C2E, 0x4C2E, 0x4C4E, 0x444E, 0x446D, 0x446D, 0x446C, 0x446C, 0x444B, 0x444B, 0x444B, 0x442B, 0x440A, 0x43EA, 
        0x4BEA, 0x4BAA, 0x4BAA, 0x4BAA, 0x4B8A, 0x53AA, 0x5BAB, 0x53AB, 0x4B6A, 0x4B69, 0x4B69, 0x538A, 0x5BAA, 0x63EB, 0x6C0B, 0x640A, 0x640A, 0x642A, 0x642A, 0x642A, 0x642A, 0x5C2A, 0x5C2A, 0x5C2A, 0x5C2A, 0x5429, 0x5429, 0x5428, 0x5429, 0x5429, 
        0x5C29, 0x5C29, 0x5C29, 0x5C29, 0x642A, 0x642A, 0x642B, 0x642B, 0x6C4B, 0x746C, 0x7C6C, 0x7C6C, 0x7C6C, 0x846B, 0x846C, 0x8C6C, 0x948D, 0x948E, 0x948E, 0x8C6F, 0x7BD0, 0x630F, 0x5ACF, 0x62F0, 0x7391, 0x738F, 0x83EE, 0x948E, 0x946E, 0x8C0C, 
        0x840C, 0x8C8D, 0x84AD, 0x7C8D, 0x748C, 0x74AC, 0x6CAC, 0x6CAC, 0x6CAC, 0x74AC, 0x74AD, 0x74AD, 0x7D0E, 0x850E, 0x7CED, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CED, 0x850E, 0x8D4E, 0x954E, 0x954E, 0x954E, 0x954E,
  0x842B, 0x7C2C, 0x7C2C, 0x742C, 0x6C2C, 0x644C, 0x646C, 0x5C6C, 0x5C6C, 0x544B, 0x542A, 0x546C, 0x5CCD, 0x64EE, 0x6CEE, 0x6CCE, 0x6C8D, 0x644C, 0x642B, 0x6C2B, 0x746C, 0x7CAD, 0x84ED, 0x8CEE, 0x850D, 0x850D, 0x84ED, 0x7CCE, 0x7CAF, 0x7CD1, 0x7CF2, 
        0x84F2, 0x84F1, 0x9D72, 0xAD92, 0x9D30, 0x9D0F, 0x94EE, 0x94CE, 0x94EF, 0x94EF, 0x94EF, 0x94CF, 0x94D0, 0x8C90, 0x844F, 0x73EE, 0x6BCE, 0x73EE, 0x740E, 0x73EE, 0x7C2F, 0x7C4F, 0x84B0, 0x8CF0, 0x8CF0, 0x84CF, 0x8CCF, 0x8CEF, 0x84CF, 0x84AE, 
        0x7C6D, 0x8CCF, 0x94CF, 0x94CF, 0x94AF, 0x94AF, 0x946F, 0x8C4E, 0x8C0E, 0x8BED, 0x83ED, 0x83ED, 0x7BAC, 0x6B2B, 0x5AA9, 0x5A88, 0x5227, 0x5247, 0x5227, 0x4206, 0x39E6, 0x39E5, 0x4226, 0x4A87, 0x636B, 0x6BED, 0x6C2D, 0x6C6C, 0x646C, 0x646C, 
        0x648C, 0x646C, 0x646C, 0x646C, 0x646C, 0x6C6D, 0x6C4D, 0x6C4D, 0x6C2E, 0x6C2E, 0x6C2E, 0x6C4E, 0x744E, 0x746F, 0x7C8F, 0x746F, 0x6C2E, 0x640C, 0x5BAA, 0x742B, 0x94AE, 0x9C8D, 0xA4CE, 0xB4EE, 0xC56F, 0xCD6F, 0xCD4F, 0xC54E, 0xC54E, 0xBD0E, 
        0xB4CD, 0xBCEE, 0xB4AD, 0xAC8C, 0xB4CD, 0xB4EE, 0xA46C, 0x9C4C, 0xA48D, 0x946D, 0x942D, 0x8C2D, 0x8C4D, 0x844D, 0x844C, 0x7C4C, 0x7C4C, 0x7C4C, 0x742C, 0x73EC, 0x6BCC, 0x7C4D, 0x7CAE, 0x74CD, 0x6CEC, 0x64EB, 0x5CEB, 0x5CEB, 0x5CCB, 0x54EB, 
        0x54CB, 0x4CAB, 0x4C4B, 0x4BEB, 0x3B69, 0x2AC8, 0x2246, 0x11E4, 0x1A85, 0x2B07, 0x3367, 0x43C8, 0x5C4B, 0x6CAC, 0x74CD, 0x74AD, 0x6C6D, 0x5C4D, 0x53CC, 0x430B, 0x42CD, 0x52EE, 0x6B70, 0x73D1, 0x7411, 0x7471, 0x7C70, 0x7470, 0x6C4E, 0x642D, 
        0x644D, 0x5C6E, 0x648E, 0x64AE, 0x64CF, 0x6CEF, 0x6CF0, 0x74F0, 0x7D11, 0x7D10, 0x74F0, 0x74F0, 0x7CF0, 0x7D11, 0x7D31, 0x7D72, 0x7D92, 0x7D92, 0x7D92, 0x7D32, 0x7491, 0x63EE, 0x42A9, 0x29C6, 0x29A4, 0x2184, 0x2164, 0x2163, 0x2184, 0x21C5, 
        0x29E5, 0x2A06, 0x2A06, 0x2A06, 0x3247, 0x42A7, 0x4B08, 0x4B48, 0x5369, 0x5349, 0x5369, 0x5B89, 0x5B89, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x63C9, 0x63C9, 0x5BA9, 0x5BA9, 0x5BC9, 0x5BC9, 0x5BA8, 0x5BA8, 0x53A9, 0x53A8, 0x53A8, 0x53A8, 0x5388, 
        0x5388, 0x5388, 0x4B68, 0x4B48, 0x4348, 0x4328, 0x4308, 0x4308, 0x4B49, 0x42C8, 0x3247, 0x3227, 0x2A06, 0x29E6, 0x29E6, 0x31E6, 0x29E6, 0x29E6, 0x29E6, 0x29C6, 0x29E6, 0x29E6, 0x29E6, 0x29E6, 0x3206, 0x3A27, 0x636C, 0x9CF3, 0x9D14, 0x8451, 
        0x73F0, 0x6BCF, 0x6BCF, 0x5B8F, 0x5B6E, 0x63AF, 0x63CF, 0x7411, 0x8472, 0x7C72, 0x7C31, 0x7410, 0x6BEF, 0x63AE, 0x5B8E, 0x538E, 0x536E, 0x536E, 0x538E, 0x638F, 0x6BAF, 0x8471, 0xCEB8, 0x7CCE, 0x4BC9, 0x43C9, 0x3BC9, 0x3BCA, 0x3BAB, 0x43CC, 
        0x43CC, 0x4BCB, 0x4C0C, 0x4C4B, 0x4C2A, 0x4C2A, 0x4C29, 0x4C29, 0x4C09, 0x43E9, 0x4409, 0x548B, 0x4C29, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4409, 0x4409, 0x4C4B, 0x548C, 0x4C4B, 0x4C2A, 0x546C, 0x64CD, 
        0x6D0E, 0x7D70, 0x7D91, 0x7D90, 0x7D70, 0x7D8F, 0x754F, 0x64ED, 0x64ED, 0x64CD, 0x64AD, 0x5C8D, 0x542D, 0x43AD, 0x3B6C, 0x43AC, 0x4C0D, 0x548E, 0x54AE, 0x4CCE, 0x4CCE, 0x5D10, 0x6551, 0x6D51, 0x6D51, 0x6511, 0x64F0, 0x548D, 0x4C4B, 0x4409, 
        0x3C09, 0x3C09, 0x3C0A, 0x3C0A, 0x3C2B, 0x444B, 0x4C6C, 0x54CE, 0x54CE, 0x54AE, 0x4C6E, 0x4C4D, 0x4C2D, 0x4C2E, 0x4C2E, 0x4C4E, 0x4C4E, 0x4C4E, 0x4C4D, 0x446D, 0x446D, 0x446D, 0x446C, 0x448C, 0x448C, 0x446B, 0x4C6B, 0x4C4B, 0x4C2B, 0x4C0B, 
        0x4BEA, 0x53EA, 0x53CA, 0x53CA, 0x53CA, 0x5BCB, 0x5BCB, 0x5BCB, 0x53AA, 0x53AA, 0x53AA, 0x5BCA, 0x63EA, 0x6C0B, 0x6C0A, 0x6C2A, 0x642A, 0x642A, 0x642A, 0x642A, 0x642A, 0x5C2A, 0x5C4A, 0x5C2A, 0x5C4A, 0x5449, 0x5429, 0x5429, 0x5429, 0x5C49, 
        0x5C49, 0x5C49, 0x6429, 0x6429, 0x642A, 0x6C2A, 0x6C2B, 0x6C4B, 0x746B, 0x7C8C, 0x7C8C, 0x848C, 0x848C, 0x848C, 0x8C8C, 0x948C, 0x94AD, 0x9CAD, 0x94AD, 0x8C6E, 0x8C30, 0x6B4F, 0x5ACF, 0x52AF, 0x6B51, 0x7BB1, 0x7BAE, 0x840D, 0x8C2D, 0x8C2D, 
        0x8C4D, 0x8C8D, 0x84AD, 0x7C8C, 0x74AC, 0x74AC, 0x74AC, 0x6CAC, 0x6CAC, 0x74AC, 0x748C, 0x74AD, 0x850E, 0x850E, 0x7CED, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x850E, 0x8D4E, 0x956F, 0x954E, 0x956E, 0x956F,
  0x7C2B, 0x7C2B, 0x7C2C, 0x744C, 0x6C4C, 0x644C, 0x646C, 0x5C8C, 0x5C6C, 0x546B, 0x546B, 0x548C, 0x5CED, 0x650E, 0x6D2F, 0x6D0F, 0x6CAE, 0x644D, 0x642C, 0x6C2C, 0x744C, 0x7C8D, 0x84CD, 0x84EE, 0x84EE, 0x84EE, 0x84EE, 0x7CAE, 0x7CAF, 0x84F1, 0x84F2, 
        0x7CD2, 0x84D1, 0x9532, 0xA572, 0xA531, 0x9CEF, 0x9CEF, 0x94AF, 0x94AF, 0x8C8E, 0x844E, 0x7C0D, 0x842E, 0x6BAC, 0x52C9, 0x52EA, 0x5B2B, 0x5B4C, 0x5B6C, 0x740F, 0x8470, 0x8470, 0x8490, 0x848F, 0x7C8E, 0x7C6D, 0x744D, 0x744C, 0x742C, 0x6BCB, 
        0x638A, 0x740C, 0x7C2C, 0x846E, 0x7BEC, 0x73AB, 0x6329, 0x62E9, 0x5AC8, 0x5AA8, 0x5287, 0x5287, 0x4A46, 0x4226, 0x4206, 0x4206, 0x41E6, 0x4206, 0x4226, 0x4226, 0x4A87, 0x5B2A, 0x6BAB, 0x6C0D, 0x6C2D, 0x6C4D, 0x646D, 0x648C, 0x648C, 0x5C8B, 
        0x5CAC, 0x5C8B, 0x648C, 0x648C, 0x648C, 0x648C, 0x648C, 0x646C, 0x6C4C, 0x6C2D, 0x6C2D, 0x6C4D, 0x6C4E, 0x746F, 0x7C90, 0x746F, 0x746F, 0x63CB, 0x6BCB, 0x844C, 0x948D, 0x9C8D, 0xB4EE, 0xBD2F, 0xC56F, 0xC54E, 0xC52E, 0xBD0E, 0xBD0E, 0xBCEE, 
        0xB4CD, 0xB4CD, 0xAC8C, 0xACAD, 0xACAD, 0xA46C, 0x9C6C, 0x9C8D, 0x9C8D, 0x946D, 0x944D, 0x8C4D, 0x8C6D, 0x844C, 0x844C, 0x7C4C, 0x7C4C, 0x7C2C, 0x740C, 0x6BCC, 0x742D, 0x7C8D, 0x74CD, 0x6CCD, 0x6CEC, 0x64EB, 0x5CEB, 0x5CEB, 0x5CEB, 0x54EB, 
        0x54EB, 0x54CC, 0x548C, 0x546B, 0x4C0B, 0x4BCB, 0x436A, 0x32C8, 0x1224, 0x1A65, 0x22C5, 0x3326, 0x4368, 0x53A9, 0x5C0A, 0x642C, 0x640D, 0x5BED, 0x4BCD, 0x3AEB, 0x42CC, 0x5B8F, 0x7451, 0x7C92, 0x7CD1, 0x7CD1, 0x74B0, 0x6C2E, 0x5BEC, 0x4BAB, 
        0x540C, 0x544D, 0x5C8D, 0x64CE, 0x64CE, 0x6CEF, 0x74F0, 0x7510, 0x7D31, 0x7D31, 0x74F0, 0x74F0, 0x74F0, 0x7D31, 0x7D51, 0x7D92, 0x7DB2, 0x7DB2, 0x7DB2, 0x7D52, 0x74D1, 0x642F, 0x4B0B, 0x29C7, 0x2164, 0x1944, 0x1944, 0x1944, 0x1964, 0x2184, 
        0x2185, 0x21C6, 0x29E6, 0x29E6, 0x29E6, 0x29E5, 0x3246, 0x4287, 0x42C8, 0x4AC8, 0x4AE8, 0x4B08, 0x5328, 0x5369, 0x5B89, 0x5B89, 0x5BA9, 0x63A9, 0x63A9, 0x63A9, 0x63A9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5BA9, 0x5389, 0x5388, 0x5389, 0x5389, 
        0x5368, 0x4B48, 0x4308, 0x4308, 0x4308, 0x4308, 0x42E8, 0x42C8, 0x42C8, 0x3247, 0x2A06, 0x2A06, 0x29E6, 0x29E6, 0x29E6, 0x29E6, 0x29E6, 0x29E6, 0x2A06, 0x29E6, 0x29E6, 0x2A06, 0x29E6, 0x2A06, 0x2A06, 0x3206, 0x4288, 0x8430, 0xAD95, 0x94D2, 
        0x73F0, 0x73F0, 0x73F0, 0x63AF, 0x638F, 0x63AF, 0x63AF, 0x7410, 0x8472, 0x8472, 0x8471, 0x7C51, 0x7410, 0x6BCF, 0x63AF, 0x63AF, 0x5B6E, 0x534E, 0x5B6E, 0x63AF, 0x6BCF, 0x8451, 0xCED8, 0x8510, 0x4BAA, 0x4389, 0x3BAA, 0x3BCB, 0x3BAB, 0x4BED, 
        0x542D, 0x542D, 0x540C, 0x4C2B, 0x4C2A, 0x4C29, 0x4C29, 0x4C29, 0x4C08, 0x43E9, 0x43E9, 0x4409, 0x4409, 0x43E8, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4BE8, 0x4C08, 0x4C09, 0x4C09, 0x4409, 0x4C2A, 0x54AC, 0x5CAD, 0x4C2A, 0x4C0A, 0x542B, 
        0x5C8C, 0x6D0E, 0x754F, 0x7D90, 0x85D1, 0x8DF1, 0x85D1, 0x754F, 0x6D0E, 0x6CEE, 0x64EE, 0x6CEE, 0x64CF, 0x542E, 0x43CD, 0x43ED, 0x4C4E, 0x548E, 0x54CF, 0x54CF, 0x54EF, 0x5D10, 0x6551, 0x6D51, 0x6D31, 0x6510, 0x64CF, 0x548C, 0x442A, 0x3C09, 
        0x3C09, 0x3BE9, 0x3C0A, 0x3C2B, 0x446C, 0x54AD, 0x54CE, 0x54CE, 0x54AE, 0x4C6D, 0x4C4D, 0x4C4D, 0x4C2E, 0x4C4E, 0x4C4E, 0x4C4D, 0x4C6D, 0x446D, 0x4C6D, 0x4C6D, 0x448D, 0x448D, 0x4C8D, 0x4C8C, 0x4C8C, 0x4C8C, 0x4C6C, 0x546C, 0x544B, 0x542B, 
        0x540B, 0x5C0B, 0x5C0B, 0x5BEB, 0x63EB, 0x63EB, 0x63EB, 0x63EB, 0x63EB, 0x5BEA, 0x63EA, 0x63EA, 0x6C0B, 0x6C0A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x642A, 0x644A, 0x644A, 0x5C4A, 0x5C4A, 0x5C4A, 0x5C49, 0x5449, 0x5449, 0x5449, 0x5C49, 0x5C49, 
        0x6449, 0x6449, 0x6C49, 0x6C4A, 0x6C4A, 0x744A, 0x744B, 0x746B, 0x7C6B, 0x848B, 0x848C, 0x8CAC, 0x8CAC, 0x8C8C, 0x94AC, 0x94AC, 0x9CAD, 0x9CAD, 0x9CAD, 0x948E, 0x946F, 0x8411, 0x6B50, 0x6331, 0x5ACF, 0x7391, 0x7BAF, 0x840E, 0x83ED, 0x840D, 
        0x8C4D, 0x8C8D, 0x848D, 0x7C8C, 0x74AC, 0x74AC, 0x6CAC, 0x6CAC, 0x6CAC, 0x6CAC, 0x6C8C, 0x74AD, 0x850E, 0x852E, 0x7CED, 0x7CCD, 0x7CCC, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CED, 0x84ED, 0x8D2E, 0x954E, 0x956E, 0x956F, 0x956F,
  0x840B, 0x7C0B, 0x7C2C, 0x744C, 0x6C4C, 0x644C, 0x5C6C, 0x5C6C, 0x5C8C, 0x548C, 0x54AC, 0x54AC, 0x5CED, 0x652E, 0x6D4F, 0x752F, 0x6CEF, 0x646D, 0x640C, 0x5BCB, 0x63CB, 0x742C, 0x744C, 0x7C8D, 0x7C8D, 0x7CAD, 0x84AE, 0x84CF, 0x84D0, 0x8512, 0x8512, 
        0x7CD2, 0x7CB1, 0x84B0, 0x9D31, 0xAD72, 0x94D0, 0x8C8F, 0x842E, 0x73AB, 0x6B8B, 0x73AC, 0x6B8C, 0x6BAC, 0x638C, 0x6BAD, 0x6C0E, 0x742F, 0x742F, 0x7C4F, 0x7C70, 0x7C4F, 0x740E, 0x6BCD, 0x6BCC, 0x63AB, 0x5329, 0x4B08, 0x42E7, 0x42E7, 0x42C7, 
        0x42C7, 0x4AE7, 0x4AC7, 0x4AC7, 0x4AA6, 0x4286, 0x4266, 0x4266, 0x4246, 0x4246, 0x4246, 0x4246, 0x3A25, 0x3A26, 0x3A26, 0x3A26, 0x3206, 0x3A06, 0x3A26, 0x4267, 0x5B6A, 0x742D, 0x746D, 0x748D, 0x6C8D, 0x648D, 0x64AC, 0x5CAC, 0x5CAC, 0x5CAB, 
        0x54AB, 0x5CCB, 0x5CAB, 0x5CCB, 0x64CC, 0x64AC, 0x64AC, 0x646B, 0x646C, 0x646C, 0x6C6C, 0x6C4D, 0x6C4D, 0x6C6E, 0x746F, 0x7CD0, 0x6C2D, 0x63AB, 0x73EC, 0x8C8D, 0x946D, 0xACEE, 0xB4EE, 0xC54F, 0xC54F, 0xC52E, 0xBD0D, 0xB4ED, 0xBD0E, 0xBCEE, 
        0xB4AD, 0xA46C, 0xACAD, 0xACAD, 0x940B, 0x9C4C, 0xA48D, 0xA48D, 0x9C8D, 0x9C6D, 0x8C2C, 0x7BCA, 0x842C, 0x8C6C, 0x846C, 0x7C4C, 0x7C2C, 0x7C2C, 0x73EC, 0x7C6D, 0x7C8E, 0x7CAD, 0x74CD, 0x74CD, 0x6CEC, 0x64EB, 0x5CEB, 0x5CEB, 0x5CEB, 0x5CEB, 
        0x5CEC, 0x5CEC, 0x5CEC, 0x5CCC, 0x54AC, 0x546C, 0x4C2B, 0x43AA, 0x22A6, 0x1224, 0x1A65, 0x22A5, 0x32E6, 0x3B27, 0x4B48, 0x538A, 0x53AB, 0x4B8B, 0x438C, 0x3B0B, 0x432C, 0x6C50, 0x7CD1, 0x7D11, 0x7D11, 0x74CF, 0x644D, 0x4BAB, 0x436A, 0x3B8A, 
        0x43EA, 0x4C2B, 0x546C, 0x5CAD, 0x5CCE, 0x6CEF, 0x6CF0, 0x7510, 0x7D31, 0x7D31, 0x7D10, 0x74F0, 0x74F0, 0x7530, 0x7D51, 0x7D91, 0x7DB2, 0x7DD2, 0x7DD2, 0x7592, 0x7512, 0x6471, 0x536E, 0x3228, 0x1965, 0x1944, 0x1924, 0x1944, 0x1944, 0x1944, 
        0x1965, 0x2185, 0x29C6, 0x29E6, 0x29E6, 0x29E6, 0x29C5, 0x29C5, 0x29E5, 0x29E5, 0x29E5, 0x3205, 0x3A66, 0x42A7, 0x4B08, 0x5328, 0x5B69, 0x5B89, 0x5BA9, 0x5BA9, 0x5B89, 0x5BA9, 0x5BA9, 0x5BA9, 0x5B89, 0x5B89, 0x5B89, 0x5389, 0x5369, 0x5369, 
        0x5348, 0x4B28, 0x42E8, 0x42E8, 0x3AE8, 0x3AC8, 0x3A67, 0x3227, 0x3226, 0x2A06, 0x29E6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x29E6, 0x31E6, 0x31E6, 0x3206, 0x2A06, 0x2A06, 0x2A06, 0x2A06, 0x2A06, 0x2A06, 0x3206, 0x3A47, 0x5B2B, 0x8450, 0x94B3, 
        0x73CF, 0x6BCF, 0x6BCF, 0x6BCF, 0x63AF, 0x63AF, 0x63AF, 0x6BD0, 0x7C11, 0x7C31, 0x8471, 0x8471, 0x7C31, 0x73F0, 0x6BD0, 0x63D0, 0x5B8F, 0x5B6E, 0x638F, 0x63AF, 0x6BCF, 0x8471, 0xC6B8, 0x7CCF, 0x4B89, 0x3B69, 0x43AB, 0x3BAB, 0x3B8B, 0x438B, 
        0x4BED, 0x5C2D, 0x5C2C, 0x4C0A, 0x4C29, 0x4C29, 0x4C29, 0x4C09, 0x4408, 0x43E8, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4408, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4C09, 0x4C4B, 0x5CAC, 0x548C, 0x440A, 0x4C2A, 
        0x544B, 0x5C8C, 0x64CD, 0x7550, 0x8591, 0x85B1, 0x8DD1, 0x85B1, 0x8570, 0x750E, 0x6CEE, 0x7550, 0x7551, 0x7531, 0x6D11, 0x64F0, 0x64CF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CEE, 0x5D0F, 0x6530, 0x6531, 0x6530, 0x64EF, 0x5CAE, 0x4C4B, 0x3C0A, 0x3BE9, 
        0x3BE9, 0x3BEA, 0x442B, 0x4C6D, 0x54CE, 0x5CEE, 0x5CEE, 0x4CAE, 0x4C6D, 0x4C4D, 0x4C2D, 0x4C4E, 0x4C6E, 0x546E, 0x4C6E, 0x444D, 0x446C, 0x446C, 0x446C, 0x446C, 0x446D, 0x4C8D, 0x4C8D, 0x4CAD, 0x54AD, 0x548D, 0x548C, 0x548C, 0x546B, 0x5C4B, 
        0x5C2B, 0x642B, 0x640B, 0x640B, 0x640B, 0x6C0B, 0x6C0B, 0x6C2B, 0x6C2B, 0x640A, 0x640A, 0x6C0A, 0x6C2A, 0x642A, 0x642A, 0x6429, 0x6449, 0x642A, 0x642A, 0x6449, 0x644A, 0x644A, 0x644A, 0x5C49, 0x5C49, 0x5C4A, 0x5C49, 0x6429, 0x6429, 0x6429, 
        0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x744A, 0x7C4A, 0x7C6B, 0x846B, 0x8C8B, 0x8CAC, 0x94AC, 0x94AC, 0x94AC, 0x94AC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAD, 0x94AE, 0x9491, 0x8411, 0x6350, 0x5ACF, 0x6310, 0x7BB1, 0x83EF, 0x7BAD, 0x7BAC, 
        0x842D, 0x7C8D, 0x7CAD, 0x7CAC, 0x74AC, 0x74AC, 0x6C8C, 0x6CAC, 0x6C8C, 0x6C8C, 0x6CAC, 0x74CD, 0x7D0E, 0x7D0E, 0x74CD, 0x74AC, 0x7CAC, 0x7CCC, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x8D0E, 0x8D4E, 0x954E, 0x956E, 0x956F,
  0x840B, 0x7C0B, 0x7C0B, 0x6C2B, 0x6C6C, 0x6C8D, 0x64AD, 0x64AD, 0x5CCD, 0x5CCD, 0x5CCC, 0x54AC, 0x5CEC, 0x652D, 0x6D4F, 0x754F, 0x752F, 0x6CAE, 0x6C8E, 0x6C0C, 0x6C2C, 0x7CAF, 0x7C8E, 0x7C8E, 0x7CAE, 0x84CF, 0x84F0, 0x8511, 0x8511, 0x8512, 0x7CF2, 
        0x7CD1, 0x7CD1, 0x84B0, 0x94D0, 0xA552, 0x94F0, 0x94D0, 0x94D0, 0x94D0, 0x8CD0, 0x8CB0, 0x848F, 0x8490, 0x8490, 0x84B1, 0x7CB0, 0x744F, 0x63CD, 0x742F, 0x742F, 0x6BEE, 0x532B, 0x4288, 0x42A8, 0x4AE8, 0x3AA7, 0x3A86, 0x3A86, 0x3A86, 0x3A86, 
        0x3A86, 0x3A86, 0x3A66, 0x3A66, 0x3A65, 0x3A65, 0x3A66, 0x3A66, 0x3A66, 0x3A46, 0x3A46, 0x3A45, 0x3A45, 0x3245, 0x3246, 0x3246, 0x3246, 0x3226, 0x3AA7, 0x5B8B, 0x742D, 0x746D, 0x748D, 0x6C8D, 0x648C, 0x64AC, 0x5CCC, 0x5CCC, 0x54CB, 0x54AB, 
        0x54CB, 0x5CCB, 0x5CCB, 0x5CCB, 0x5CCC, 0x64CB, 0x64CB, 0x64AB, 0x648B, 0x648C, 0x6C8C, 0x6C8C, 0x6C6D, 0x6C6D, 0x746E, 0x746E, 0x63CC, 0x6BCB, 0x842D, 0x946D, 0x9C8D, 0xB52F, 0xBD0E, 0xC54F, 0xC54E, 0xBD2E, 0xB4CD, 0xBD0E, 0xB4CD, 0xACAD, 
        0xA46C, 0xB4CE, 0xACAD, 0xA44C, 0x9C4C, 0xACAD, 0xACAD, 0xACAE, 0xA48D, 0x9C8D, 0x8C0C, 0x7BEA, 0x8C6C, 0x8C6D, 0x846C, 0x7C2C, 0x7C2C, 0x73EC, 0x740C, 0x84AE, 0x7CAE, 0x7CCD, 0x74EC, 0x6CEC, 0x6CEC, 0x64EB, 0x5CEB, 0x64EB, 0x64EB, 0x64EB, 
        0x650C, 0x5D0C, 0x5D0C, 0x5CEC, 0x5CCD, 0x54AC, 0x546C, 0x4C0B, 0x3B89, 0x2265, 0x2265, 0x2AA5, 0x32E6, 0x3AE6, 0x4307, 0x4B49, 0x536A, 0x436B, 0x3B4B, 0x3B0B, 0x53CD, 0x74D1, 0x7D31, 0x7D51, 0x750F, 0x5C4C, 0x4BAA, 0x4369, 0x3B48, 0x3368, 
        0x3BC9, 0x440A, 0x4C4B, 0x546C, 0x5CAD, 0x64CE, 0x6CEF, 0x74F0, 0x7D11, 0x7D31, 0x7D11, 0x7510, 0x7510, 0x7530, 0x7D71, 0x7D91, 0x7DD2, 0x75F2, 0x7DF2, 0x7DB3, 0x7D52, 0x6C91, 0x5BCF, 0x3A89, 0x2186, 0x1965, 0x1944, 0x1944, 0x1944, 0x1944, 
        0x1944, 0x1964, 0x2185, 0x21C6, 0x29E6, 0x29E6, 0x29E6, 0x29C6, 0x29A5, 0x29A5, 0x29C5, 0x29C5, 0x29C5, 0x3205, 0x42A7, 0x4AC8, 0x4B08, 0x5328, 0x5B48, 0x5368, 0x5B68, 0x5B68, 0x5B68, 0x5368, 0x5B68, 0x5369, 0x5369, 0x5348, 0x4B28, 0x4B28, 
        0x4B08, 0x4B08, 0x42C8, 0x3AA8, 0x3AA8, 0x3247, 0x2A06, 0x29E6, 0x29E6, 0x29C6, 0x29C6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x29E6, 0x31E6, 0x31E6, 0x3206, 0x3206, 0x2A06, 0x2A06, 0x2A06, 0x2A26, 0x2A26, 0x3227, 0x3227, 0x4ACA, 0x5B2C, 0x636E, 
        0x7C11, 0x8452, 0x6BCF, 0x6BCF, 0x6BAF, 0x636E, 0x5B4E, 0x5B4E, 0x6BD0, 0x7C31, 0x8472, 0x8C92, 0x8471, 0x7C31, 0x73F0, 0x6BD0, 0x63B0, 0x5B6F, 0x5B8F, 0x5B6E, 0x638F, 0x73F0, 0x84B0, 0x5BAB, 0x4B8A, 0x43CB, 0x43CB, 0x3B8B, 0x3B6B, 0x4BCC, 
        0x53ED, 0x648F, 0x6CCF, 0x4C0A, 0x4C09, 0x4C09, 0x4408, 0x4408, 0x4408, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x43E8, 0x4408, 0x4BE8, 0x4BE8, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4C09, 0x440A, 0x546B, 0x54AC, 0x4C2A, 0x4C2A, 
        0x542B, 0x542B, 0x5C8D, 0x6D0F, 0x7D70, 0x7D70, 0x7D6F, 0x7D4F, 0x7D6F, 0x6CEE, 0x64AD, 0x6CEE, 0x750F, 0x7550, 0x7551, 0x7551, 0x7551, 0x6D31, 0x6530, 0x650F, 0x5D0F, 0x5D0F, 0x6510, 0x6530, 0x5D10, 0x5CEF, 0x548D, 0x444B, 0x3BE9, 0x33E9, 
        0x33E9, 0x3C0A, 0x4C4C, 0x5CCE, 0x5CEF, 0x5CEF, 0x5CCF, 0x4C6D, 0x4C4D, 0x4C2E, 0x4C4E, 0x546E, 0x548E, 0x4C6E, 0x4C6D, 0x444C, 0x444C, 0x446C, 0x446C, 0x446C, 0x446C, 0x4C6D, 0x4C8D, 0x54AD, 0x54AD, 0x548D, 0x548D, 0x5C8C, 0x5C6C, 0x644C, 
        0x642B, 0x642B, 0x642B, 0x6C0A, 0x6C0A, 0x642A, 0x6C2B, 0x642B, 0x6C2B, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C2A, 0x642A, 0x6429, 0x6449, 0x642A, 0x642A, 0x6449, 0x644A, 0x644A, 0x644A, 0x5C49, 0x5C49, 0x5C4A, 0x644A, 0x642A, 0x642A, 0x6C2A, 
        0x6C4A, 0x744A, 0x744A, 0x744A, 0x744A, 0x7C4A, 0x7C6B, 0x846B, 0x8C8B, 0x8C8C, 0x94AC, 0x94AC, 0x94CC, 0x94AC, 0x9CAC, 0x9C8C, 0x9CAC, 0x9CAC, 0xA4AC, 0x9CCC, 0x9CCD, 0x9CAF, 0x8C71, 0x6B90, 0x5AF0, 0x62F0, 0x7BB2, 0x7BB0, 0x738E, 0x738D, 
        0x73EC, 0x7C8C, 0x7CAD, 0x74AC, 0x74AC, 0x74AC, 0x6C8C, 0x6CAC, 0x6C8C, 0x6C8C, 0x6CAC, 0x74ED, 0x7D0E, 0x7CED, 0x74AC, 0x74AC, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x84CD, 0x84CD, 0x84ED, 0x8D0D, 0x8D2E, 0x954E, 0x954E,
  0x842B, 0x7C0B, 0x7C0B, 0x6C0B, 0x6C6C, 0x6CAD, 0x6CEE, 0x6D0E, 0x650E, 0x5CED, 0x5CCC, 0x54AC, 0x5CEC, 0x5D2D, 0x654E, 0x754F, 0x752F, 0x6CCF, 0x6C6E, 0x63EC, 0x6C4D, 0x8510, 0x7CEF, 0x84F0, 0x8510, 0x8531, 0x8D51, 0x8D72, 0x8532, 0x7D11, 0x7D12, 
        0x7CF2, 0x84F1, 0x8CF1, 0x9D52, 0xB615, 0xBE55, 0xADF4, 0xA573, 0x9531, 0x9511, 0x8D11, 0x8D11, 0x84F0, 0x7CB0, 0x6C2E, 0x534B, 0x3A88, 0x5BAC, 0x742F, 0x5B4B, 0x4289, 0x3A68, 0x3247, 0x3247, 0x3266, 0x3266, 0x3266, 0x3265, 0x3265, 0x3265, 
        0x3265, 0x3A66, 0x3A66, 0x3265, 0x3A65, 0x3265, 0x3265, 0x3265, 0x3265, 0x3265, 0x3266, 0x3265, 0x3265, 0x3265, 0x3245, 0x3245, 0x3266, 0x4B09, 0x63CB, 0x6C0D, 0x6C4D, 0x6C8D, 0x6CAD, 0x64AC, 0x64AC, 0x5CCB, 0x5CCB, 0x54CB, 0x54CB, 0x54CB, 
        0x54CB, 0x5CEB, 0x5CEB, 0x5CEB, 0x64EB, 0x64EB, 0x64CB, 0x64CB, 0x64AB, 0x6CAB, 0x6CAB, 0x6CAC, 0x6C8C, 0x6C8D, 0x6C6D, 0x640C, 0x6BEC, 0x73EB, 0x8C6D, 0x9C8D, 0xACCE, 0xB50E, 0xBD0E, 0xC54F, 0xCD6F, 0xB4CD, 0xBD2E, 0xB4CD, 0xA46C, 0xACAD, 
        0xB4EE, 0xB4CD, 0x9C2B, 0x9C2B, 0xACAD, 0xACAE, 0xACCE, 0xACAE, 0xA48D, 0xA4AE, 0x9C8D, 0x948D, 0x948D, 0x8C6D, 0x844C, 0x7C2C, 0x7C0C, 0x6BEC, 0x848E, 0x84CE, 0x7CCE, 0x7CED, 0x74EC, 0x74EC, 0x6CEB, 0x6CEB, 0x64EB, 0x64EB, 0x64EB, 0x64EB, 
        0x650C, 0x650C, 0x650C, 0x5D0C, 0x5CEC, 0x5CCC, 0x5CAC, 0x546C, 0x4C2B, 0x3328, 0x2AA6, 0x2AC6, 0x32E6, 0x3AE7, 0x4307, 0x4329, 0x4B4A, 0x434B, 0x3B2B, 0x332B, 0x5C2F, 0x7511, 0x7550, 0x7530, 0x648D, 0x4BEA, 0x4389, 0x3B48, 0x3328, 0x3348, 
        0x3388, 0x3BEA, 0x442B, 0x4C4C, 0x548D, 0x64AE, 0x6CCF, 0x74F0, 0x7D10, 0x7D11, 0x7D11, 0x7510, 0x7510, 0x7530, 0x7D71, 0x7DB1, 0x7DD2, 0x75F2, 0x7DF2, 0x7DD3, 0x7D73, 0x74F2, 0x640F, 0x42EB, 0x21C6, 0x1965, 0x1964, 0x1944, 0x1144, 0x1144, 
        0x1924, 0x1944, 0x1964, 0x1985, 0x2185, 0x21A6, 0x29C6, 0x29C6, 0x29C5, 0x21A5, 0x21A5, 0x21A5, 0x2184, 0x2184, 0x3206, 0x3A88, 0x42C8, 0x4AE8, 0x4AE7, 0x4AE7, 0x4B07, 0x4B28, 0x4B28, 0x4B28, 0x4B28, 0x4B28, 0x4B28, 0x4B08, 0x4308, 0x42E8, 
        0x42C8, 0x42A8, 0x3A67, 0x3247, 0x3267, 0x3247, 0x29E6, 0x29E6, 0x29C6, 0x29C6, 0x29C6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x29E6, 0x31E6, 0x31E6, 0x31E6, 0x2A06, 0x2A06, 0x2A06, 0x2A26, 0x2A26, 0x2A26, 0x2A47, 0x3A68, 0x530B, 0x532C, 0x5B2D, 
        0x6B8F, 0x8CB3, 0x63AE, 0x63AE, 0x6BCF, 0x6BCF, 0x5B6E, 0x530D, 0x73F0, 0x8451, 0x8472, 0x8472, 0x8472, 0x73F0, 0x6BCF, 0x6BCF, 0x63AF, 0x532D, 0x4B0C, 0x4B0C, 0x532D, 0x532C, 0x4B4B, 0x4B6B, 0x4BAB, 0x4BCC, 0x43AB, 0x3B8B, 0x438C, 0x4BCD, 
        0x540D, 0x5C2D, 0x540C, 0x4BEA, 0x4C09, 0x4408, 0x43E8, 0x43E8, 0x3BE8, 0x3BE8, 0x43E8, 0x3BE8, 0x3BE8, 0x43E8, 0x43E8, 0x43E7, 0x43E7, 0x43E7, 0x4BE7, 0x4C07, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4C2A, 0x4C4B, 0x544B, 0x542A, 
        0x4C0A, 0x542B, 0x5C6C, 0x64CD, 0x6D0F, 0x752F, 0x64AD, 0x646C, 0x648C, 0x5C6C, 0x5C4C, 0x5C4C, 0x5C6D, 0x64CE, 0x6D0F, 0x64EF, 0x64EF, 0x6D30, 0x7571, 0x7591, 0x6D70, 0x6530, 0x6550, 0x6530, 0x5CEF, 0x5CCF, 0x548D, 0x440B, 0x3BC9, 0x33C9, 
        0x3BC9, 0x442B, 0x54AD, 0x5CCF, 0x5CCF, 0x5CCE, 0x54AE, 0x4C6D, 0x4C4D, 0x4C4E, 0x546F, 0x548E, 0x546E, 0x4C4D, 0x444C, 0x444C, 0x444C, 0x444C, 0x446C, 0x446C, 0x446C, 0x448C, 0x4C8D, 0x54AD, 0x54AD, 0x54AD, 0x5CAD, 0x5CAC, 0x5C6C, 0x644C, 
        0x644B, 0x6C2B, 0x6C2B, 0x6C2A, 0x6C2A, 0x6C2A, 0x6C4B, 0x6C4B, 0x6C4B, 0x6C4A, 0x6C2A, 0x6C2A, 0x6C2A, 0x644A, 0x6429, 0x6429, 0x6449, 0x6429, 0x6449, 0x6449, 0x6449, 0x6449, 0x6449, 0x6449, 0x6449, 0x644A, 0x644A, 0x642A, 0x6C2A, 0x744A, 
        0x744A, 0x744A, 0x7C4A, 0x7C4A, 0x7C4A, 0x844B, 0x846B, 0x8C8B, 0x8C8B, 0x94AC, 0x94AC, 0x94CC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0x9CAC, 0x9CAC, 0xA4CC, 0xA4EC, 0xA4CD, 0x9CCE, 0x9490, 0x8411, 0x630F, 0x62D0, 0x7352, 0x7BD2, 0x7BD0, 0x73AE, 
        0x73EC, 0x7C8D, 0x7CAC, 0x74AC, 0x74AC, 0x74AC, 0x6CAC, 0x6CAC, 0x6C8C, 0x6C8C, 0x6CAC, 0x74CD, 0x74ED, 0x74CD, 0x74AC, 0x74AC, 0x7CCD, 0x84CD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x7CCD, 0x84CD, 0x84ED, 0x84ED, 0x8D0D, 0x8D2D, 0x8D2E,
  0x842B, 0x7C2B, 0x7C0B, 0x6C0A, 0x6C4B, 0x6C8D, 0x64CD, 0x6D0E, 0x650E, 0x64ED, 0x5CAC, 0x54AC, 0x5CEC, 0x5D2D, 0x654D, 0x6D4E, 0x754F, 0x7530, 0x6C8E, 0x5C0C, 0x6CAE, 0x7D0F, 0x74EF, 0x7D10, 0x7D30, 0x7D31, 0x7D71, 0x7D71, 0x7D51, 0x7531, 0x7512, 
        0x7512, 0x7D11, 0x8511, 0x8D51, 0xA5F3, 0xC6D7, 0xADF4, 0x9D72, 0x9531, 0x84F0, 0x7CAF, 0x6C2E, 0x5BCC, 0x538B, 0x4B2A, 0x3A88, 0x532B, 0x6BCD, 0x530A, 0x3A48, 0x3227, 0x3227, 0x3226, 0x3246, 0x3246, 0x3246, 0x3245, 0x3266, 0x3265, 0x3265, 
        0x3265, 0x3265, 0x3266, 0x3265, 0x3265, 0x3265, 0x3265, 0x3265, 0x3285, 0x3285, 0x3285, 0x3265, 0x3285, 0x2A65, 0x3265, 0x3A86, 0x538A, 0x640C, 0x6C4D, 0x6C6D, 0x6C8D, 0x64AC, 0x64AC, 0x64AC, 0x5CCB, 0x5CCB, 0x54CB, 0x54CB, 0x5CEB, 0x5CEC, 
        0x5CEB, 0x5D0C, 0x650C, 0x64EB, 0x64EB, 0x64EB, 0x64CB, 0x64CB, 0x6CAB, 0x6CCB, 0x6CCB, 0x6CAC, 0x6CAC, 0x748C, 0x6C2C, 0x746D, 0x73EB, 0x7C0C, 0x94AE, 0x9C8D, 0xACAD, 0xB4ED, 0xC52F, 0xC56F, 0xBD0E, 0xB4CD, 0xBD0E, 0xAC8C, 0xA46C, 0xB4CE, 
        0xBCEE, 0xA42B, 0x9C2B, 0xAC8D, 0xB4CE, 0xB4CE, 0xACEE, 0xA4AE, 0xA4AE, 0xA4EE, 0xA4EF, 0x94AD, 0x8C6D, 0x8C6D, 0x842C, 0x7C0C, 0x73AC, 0x740D, 0x84AE, 0x84CE, 0x84ED, 0x7D0D, 0x7CED, 0x74EC, 0x6CEB, 0x6CEB, 0x6CCB, 0x64CB, 0x64CB, 0x64EB, 
        0x6CEB, 0x650C, 0x650C, 0x5CEC, 0x5CEC, 0x5CCC, 0x5CCD, 0x5C8D, 0x5C4C, 0x4BEB, 0x3307, 0x3B07, 0x3B07, 0x3B07, 0x4307, 0x4329, 0x4B4A, 0x432B, 0x3B2B, 0x3B6C, 0x648F, 0x7551, 0x7550, 0x6CEF, 0x4C0B, 0x4389, 0x3B69, 0x3B48, 0x3327, 0x2B27, 
        0x3368, 0x3BA9, 0x440A, 0x4C2C, 0x546D, 0x648D, 0x6CCF, 0x74D0, 0x74F0, 0x7D10, 0x7D10, 0x7D11, 0x7510, 0x7531, 0x7D71, 0x7D91, 0x7DD1, 0x7612, 0x7E12, 0x7DF3, 0x7D93, 0x7D32, 0x6C50, 0x4B4C, 0x21E7, 0x1965, 0x1965, 0x1964, 0x1944, 0x1144, 
        0x1924, 0x1944, 0x1944, 0x1944, 0x1944, 0x1965, 0x1965, 0x2185, 0x2185, 0x2165, 0x2164, 0x2164, 0x1944, 0x1123, 0x1964, 0x29E6, 0x3A67, 0x42A8, 0x42A7, 0x3AA7, 0x42C7, 0x42C7, 0x42E7, 0x42E7, 0x42E8, 0x3AC7, 0x3AA7, 0x3286, 0x3266, 0x3247, 
        0x2A26, 0x2A06, 0x29E6, 0x2A06, 0x2A06, 0x2A07, 0x2A06, 0x29E6, 0x29E6, 0x29E6, 0x29E6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x29E6, 0x31E6, 0x31E6, 0x31E6, 0x2A06, 0x2A06, 0x2A06, 0x2A26, 0x2A26, 0x2A46, 0x2A47, 0x3288, 0x4B2C, 0x534D, 0x5B6E, 
        0x532D, 0x63AE, 0x6C0F, 0x7471, 0x7CB1, 0x7CB2, 0x7451, 0x5B8E, 0x63AF, 0x6BCF, 0x63AE, 0x5B6D, 0x5B4C, 0x532D, 0x63AE, 0x5B6E, 0x4B4D, 0x430C, 0x432C, 0x4B2C, 0x4B4C, 0x4B6B, 0x4B8C, 0x4BCC, 0x4BCC, 0x43AB, 0x3B6A, 0x3B8B, 0x3B8B, 0x4B8C, 
        0x4BCC, 0x4BCB, 0x4BCB, 0x4BE9, 0x43E9, 0x43E8, 0x43E8, 0x3BE8, 0x3BE8, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC7, 0x3BC7, 0x43C7, 0x43E7, 0x43E7, 0x43E7, 0x4BE8, 0x4C08, 0x4C08, 0x4C08, 0x4C08, 0x4C09, 0x4C09, 0x4C09, 0x4C09, 0x4C0A, 0x540A, 
        0x4C0A, 0x4C0A, 0x542B, 0x64AD, 0x6CEE, 0x6D0F, 0x6CEE, 0x540A, 0x53EA, 0x540A, 0x540B, 0x4BEA, 0x4BEA, 0x4C0B, 0x544C, 0x5CAE, 0x5CAE, 0x64AE, 0x650F, 0x6D50, 0x650F, 0x5CEF, 0x5CEF, 0x54EF, 0x54CF, 0x5CCF, 0x54AE, 0x4C4C, 0x3BEA, 0x33CA, 
        0x3C0A, 0x548D, 0x5CCF, 0x5CCF, 0x5CCF, 0x546E, 0x4C4D, 0x4C2D, 0x4C4E, 0x546F, 0x548F, 0x548E, 0x4C6D, 0x4C4C, 0x444C, 0x444B, 0x446C, 0x446C, 0x446C, 0x446C, 0x446C, 0x4C6C, 0x4C8C, 0x4CAD, 0x54AD, 0x5CAD, 0x5CAD, 0x648C, 0x646C, 0x644B, 
        0x642B, 0x642B, 0x642A, 0x6C2A, 0x6C2A, 0x6C4A, 0x6C4A, 0x644A, 0x644A, 0x642A, 0x6C2A, 0x6C2A, 0x6C2A, 0x6449, 0x6429, 0x6429, 0x6449, 0x6429, 0x6449, 0x6449, 0x6449, 0x6449, 0x6449, 0x644A, 0x644A, 0x644A, 0x644A, 0x6C2A, 0x6C2A, 0x744A, 
        0x7C4A, 0x7C4A, 0x7C4B, 0x7C4A, 0x846B, 0x8C6B, 0x8C6B, 0x8C8B, 0x94AC, 0x94AC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CCC, 0x9CAC, 0x9CAC, 0xA4CC, 0xA4CC, 0xA4EC, 0xA4EC, 0x9CCD, 0x948E, 0x842F, 0x634F, 0x5AD0, 0x6B31, 0x7391, 0x7BD1, 0x7BCF, 
        0x7C0E, 0x7C6D, 0x7CAC, 0x74AC, 0x74AC, 0x74AC, 0x6CAC, 0x6CAC, 0x6CAC, 0x6C8C, 0x6C8C, 0x74CD, 0x74ED, 0x74CD, 0x74AC, 0x74AC, 0x7CCD, 0x84CC, 0x7CCD, 0x7CCD, 0x84CD, 0x84CC, 0x84CC, 0x84CD, 0x84CD, 0x84ED, 0x8CED, 0x8CED, 0x8D0D,
  0x842B, 0x7C2B, 0x7C2B, 0x6C2A, 0x6C4B, 0x646C, 0x64AD, 0x6D0E, 0x6D2F, 0x64EE, 0x5CAC, 0x54AB, 0x5CEC, 0x5D2D, 0x5D2D, 0x654E, 0x6D6F, 0x752F, 0x6CAE, 0x646D, 0x74CF, 0x74EF, 0x74EF, 0x6CAE, 0x6CEF, 0x7530, 0x7570, 0x7571, 0x7551, 0x6D31, 0x6D11, 
        0x7511, 0x7511, 0x7D11, 0x7D10, 0x852F, 0x95D2, 0x8D71, 0x84CF, 0x744D, 0x5BAB, 0x4B49, 0x3AC8, 0x3A87, 0x3AA7, 0x3AA8, 0x4AE9, 0x6BED, 0x530A, 0x3A68, 0x3A27, 0x3227, 0x3226, 0x3226, 0x3226, 0x2A46, 0x3246, 0x3266, 0x3265, 0x3265, 0x3266, 
        0x3265, 0x3265, 0x3245, 0x3265, 0x3265, 0x3265, 0x3265, 0x3285, 0x3285, 0x3285, 0x3285, 0x3285, 0x3285, 0x3285, 0x3285, 0x42E8, 0x63CB, 0x642C, 0x6C4C, 0x648C, 0x64AC, 0x64CC, 0x5CCC, 0x5CCB, 0x5CCB, 0x54CB, 0x54CB, 0x54EB, 0x5CCB, 0x5D0B, 
        0x650C, 0x650C, 0x652C, 0x64EC, 0x64EB, 0x6CEB, 0x6CCB, 0x6CCB, 0x6CCB, 0x6CCB, 0x74CB, 0x74CC, 0x74CC, 0x746C, 0x744C, 0x744C, 0x7C0B, 0x844C, 0x9CAD, 0x9C8C, 0xA48C, 0xB50E, 0xC56F, 0xC58F, 0xB4ED, 0xB4CD, 0xACAD, 0xA44C, 0xB4AD, 0xB4CE, 
        0xAC6D, 0xAC4C, 0xBCEE, 0xBD0F, 0xB4EE, 0xBD0F, 0xACCD, 0xA4AD, 0xAD0F, 0xAD2F, 0x9CCE, 0x8C6C, 0x8C6D, 0x8C6D, 0x7BEC, 0x738B, 0x73AB, 0x8CAF, 0x84CE, 0x84CD, 0x7CED, 0x7D0D, 0x7D0C, 0x74EC, 0x6CEB, 0x6CEB, 0x64CB, 0x6CCB, 0x6CCB, 0x6CEB, 
        0x6CEB, 0x64EB, 0x64EC, 0x64EC, 0x64EC, 0x64EC, 0x64EC, 0x64CD, 0x64AD, 0x5C2C, 0x53EB, 0x53CA, 0x3B28, 0x3B27, 0x4328, 0x4349, 0x434A, 0x3B0B, 0x3B0C, 0x438C, 0x64B0, 0x7551, 0x7530, 0x64AD, 0x43A9, 0x4368, 0x3B68, 0x3B48, 0x3B27, 0x3307, 
        0x3347, 0x3B89, 0x43EA, 0x4C0B, 0x544C, 0x5C6D, 0x64AE, 0x6CCF, 0x74F0, 0x7510, 0x7D10, 0x7D11, 0x7D11, 0x7D30, 0x7D51, 0x7D91, 0x7DD1, 0x7611, 0x7E12, 0x7DF3, 0x7DB3, 0x7D52, 0x6C90, 0x538D, 0x2A07, 0x1965, 0x1944, 0x1944, 0x1944, 0x1944, 
        0x1924, 0x1124, 0x1124, 0x1124, 0x1124, 0x1144, 0x1944, 0x1944, 0x1944, 0x1944, 0x1944, 0x1123, 0x1123, 0x1123, 0x1123, 0x1944, 0x21A5, 0x29E6, 0x3226, 0x3226, 0x3226, 0x3246, 0x3267, 0x3267, 0x3287, 0x3267, 0x2A26, 0x2A05, 0x2205, 0x2A06, 
        0x2A06, 0x2A06, 0x2A06, 0x2A06, 0x2A06, 0x2A26, 0x2A06, 0x2A07, 0x2A06, 0x2A06, 0x2A06, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x31E6, 0x29E6, 0x29E6, 0x2A06, 0x29E6, 0x2A06, 0x2A06, 0x2A26, 0x2A26, 0x2A27, 0x3AA9, 0x4B4C, 0x538D, 0x5BEF, 
        0x63F0, 0x642F, 0x6C90, 0x7CD1, 0x7CD1, 0x7CD1, 0x7CD2, 0x63EE, 0x5BAE, 0x5B8D, 0x536D, 0x534C, 0x534C, 0x4B2C, 0x536D, 0x4B4C, 0x434C, 0x436C, 0x436C, 0x436C, 0x4B8C, 0x4BAC, 0x4BEC, 0x4BCB, 0x43AB, 0x3B6A, 0x3329, 0x3B6B, 0x438C, 0x4BAC, 
        0x4BAC, 0x4BCB, 0x4BCA, 0x4BEA, 0x43E8, 0x43E8, 0x3BC8, 0x3BC8, 0x3BC7, 0x3BC7, 0x3BC8, 0x3BC8, 0x3BC8, 0x3BC7, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x43C7, 0x4BE8, 0x4BE8, 0x4BE8, 0x5408, 0x5429, 0x5429, 0x4C29, 0x4C08, 0x4C09, 0x4C09, 0x540A, 
        0x540A, 0x5409, 0x4C0A, 0x546B, 0x64CD, 0x650E, 0x6D4F, 0x64CD, 0x4BEA, 0x4BE9, 0x4BE9, 0x43C9, 0x43A9, 0x43AA, 0x43AB, 0x4BEC, 0x542D, 0x544D, 0x5C8E, 0x5C8D, 0x546D, 0x4C8D, 0x4C6D, 0x448D, 0x448D, 0x44AE, 0x4CAE, 0x548E, 0x4C6E, 0x4C4D, 
        0x4C2E, 0x5C6F, 0x5C8F, 0x546F, 0x4C2E, 0x338B, 0x3BCC, 0x4C2D, 0x546E, 0x5CAF, 0x548E, 0x546D, 0x444B, 0x444B, 0x444B, 0x444B, 0x446B, 0x3C6B, 0x446C, 0x446C, 0x446C, 0x4C6C, 0x4C8C, 0x54AD, 0x54AD, 0x5CAD, 0x5CAD, 0x64AC, 0x646C, 0x644B, 
        0x642A, 0x642A, 0x642A, 0x644A, 0x644A, 0x644A, 0x644A, 0x644A, 0x644A, 0x642A, 0x642A, 0x6429, 0x6429, 0x6C29, 0x6409, 0x6C29, 0x6C29, 0x6C29, 0x6C29, 0x6C29, 0x6C29, 0x6C29, 0x6C4A, 0x6C4A, 0x6C4A, 0x6C4A, 0x6C2A, 0x6C2A, 0x6C2A, 0x744A, 
        0x7C4A, 0x7C4A, 0x844B, 0x844B, 0x8C6B, 0x8C6B, 0x948B, 0x948B, 0x9CAC, 0x9CCC, 0xA4CC, 0xA4EC, 0xA4EC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0xA4CC, 0x9CCC, 0x948D, 0x844E, 0x73EF, 0x6350, 0x6331, 0x6310, 0x7BB1, 0x8411, 
        0x7C2F, 0x7C6D, 0x7CAD, 0x748C, 0x748C, 0x6C8C, 0x6CAC, 0x6CAC, 0x6CAC, 0x6C8C, 0x6C6C, 0x74CC, 0x74ED, 0x74CC, 0x74AC, 0x7CAC, 0x7CAC, 0x7CCC, 0x7CCC, 0x7CCC, 0x84CC, 0x84CC, 0x84CC, 0x84CC, 0x84CC, 0x8CCC, 0x8CCC, 0x8CED, 0x8CED,
  0x844B, 0x7C4B, 0x7C4B, 0x742B, 0x6C4B, 0x646C, 0x6CAD, 0x6CEE, 0x6D0E, 0x5CAD, 0x546B, 0x546B, 0x54CC, 0x5D0D, 