/* ---------------------------------------------------------------------------------------
 * @file:    startup_LPC54608.c
 * @purpose: CMSIS Cortex-M4 Core Device Startup File
 *           LPC54608
 * @version: 1.1
 * @date:    2016-11-25
 * ---------------------------------------------------------------------------------------
 *
 * Copyright 1997 - 2016 Freescale Semiconductor, Inc.
 * Copyright 2016 - 2017 NXP
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --------------------------------------------------------------------------------------
 * Version: GCC for ARM Embedded Processors
 * ----------------------------------------------------------------------------------- */

#if defined (__cplusplus)
extern "C" {
  #ifdef __REDLIB__
    #error Redlib does not support C++
  #else
/* The entry point for the C++ library startup */
extern void __libc_init_array(void);
  #endif
#endif

/* Declaration of external SystemInit function */
extern void SystemInit(void);

#if !defined (DONT_ENABLE_SWVTRACECLK) && defined(__CODE_RED)
/* Allow confirmation that SWV trace has been enabled */
unsigned int __SWVtrace_Enabled;
#endif

/*
 * The entry point for the application.
 * __main() is the entry point for Redlib based applications
 * main() is the entry point for Newlib based applications
 */
#if defined (__REDLIB__)
extern void __main(void);
#endif
extern int main(void);

/* External declaration for the pointer to the stack top from the Linker Script */
extern void _vStackTop(void);

/* External declaration for LPC MCU vector table checksum from  Linker Script */
extern void __valid_user_code_checksum() __attribute__ ((weak));

/*
 * Reset handler declaration
 */
void ResetISR(void);

/*
 * Forward declaration of the default exception handlers. When the application
 * defines a handler (with the same name), this will automatically take
 * precedence over the weak definition
 */
void IntDefaultHandler(void)   __attribute__ ((weak));

/*
 * Forward declaration of the core exception handlers. When the application
 * defines a handler (with the same name), this will automatically take
 * precedence over weak definitions
 */
void NMI_Handler(void)         __attribute__ ((weak));
void HardFault_Handler(void)   __attribute__ ((weak));
void MemManage_Handler(void)   __attribute__ ((weak));
void BusFault_Handler(void)    __attribute__ ((weak));
void UsageFault_Handler(void)  __attribute__ ((weak));
void SVC_Handler(void)         __attribute__ ((weak));
void DebugMon_Handler(void)    __attribute__ ((weak));
void PendSV_Handler(void)      __attribute__ ((weak));
void SysTick_Handler(void)     __attribute__ ((weak));

/*
 * Forward declaration of the application IRQ handlers. When the application
 * defines a handler (with the same name), this will automatically take
 * precedence over weak definitions below
 */
void WDT_BOD_IRQHandler(void)     __attribute__ ((weak));
void DMA0_IRQHandler(void)     __attribute__ ((weak));
void GINT0_IRQHandler(void)     __attribute__ ((weak));
void GINT1_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT0_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT1_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT2_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT3_IRQHandler(void)     __attribute__ ((weak));
void UTICK0_IRQHandler(void)     __attribute__ ((weak));
void MRT0_IRQHandler(void)     __attribute__ ((weak));
void CTIMER0_IRQHandler(void)     __attribute__ ((weak));
void CTIMER1_IRQHandler(void)     __attribute__ ((weak));
void SCT0_IRQHandler(void)     __attribute__ ((weak));
void CTIMER3_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM0_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM1_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM2_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM3_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM4_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM5_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM6_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM7_IRQHandler(void)     __attribute__ ((weak));
void ADC0_SEQA_IRQHandler(void)     __attribute__ ((weak));
void ADC0_SEQB_IRQHandler(void)     __attribute__ ((weak));
void ADC0_THCMP_IRQHandler(void)     __attribute__ ((weak));
void DMIC0_IRQHandler(void)     __attribute__ ((weak));
void HWVAD0_IRQHandler(void)     __attribute__ ((weak));
void USB0_NEEDCLK_IRQHandler(void)     __attribute__ ((weak));
void USB0_IRQHandler(void)     __attribute__ ((weak));
void RTC_IRQHandler(void)     __attribute__ ((weak));
void Reserved46_IRQHandler(void)     __attribute__ ((weak));
void Reserved47_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT4_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT5_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT6_IRQHandler(void)     __attribute__ ((weak));
void PIN_INT7_IRQHandler(void)     __attribute__ ((weak));
void CTIMER2_IRQHandler(void)     __attribute__ ((weak));
void CTIMER4_IRQHandler(void)     __attribute__ ((weak));
void RIT_IRQHandler(void)     __attribute__ ((weak));
void SPIFI0_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM8_IRQHandler(void)     __attribute__ ((weak));
void FLEXCOMM9_IRQHandler(void)     __attribute__ ((weak));
void SDIO_IRQHandler(void)     __attribute__ ((weak));
void CAN0_IRQ0_IRQHandler(void)     __attribute__ ((weak));
void CAN0_IRQ1_IRQHandler(void)     __attribute__ ((weak));
void CAN1_IRQ0_IRQHandler(void)     __attribute__ ((weak));
void CAN1_IRQ1_IRQHandler(void)     __attribute__ ((weak));
void USB1_IRQHandler(void)     __attribute__ ((weak));
void USB1_NEEDCLK_IRQHandler(void)     __attribute__ ((weak));
void ETHERNET_IRQHandler(void)     __attribute__ ((weak));
void ETHERNET_PMT_IRQHandler(void)     __attribute__ ((weak));
void ETHERNET_MACLP_IRQHandler(void)     __attribute__ ((weak));
void EEPROM_IRQHandler(void)     __attribute__ ((weak));
void LCD_IRQHandler(void)     __attribute__ ((weak));
void SHA_IRQHandler(void)     __attribute__ ((weak));
void SMARTCARD0_IRQHandler(void)     __attribute__ ((weak));
void SMARTCARD1_IRQHandler(void)     __attribute__ ((weak));

/*
 * Forward declaration of the driver IRQ handlers. These are aliased
 * to the IntDefaultHandler, which is a 'forever' loop. When the driver
 * defines a handler (with the same name), this will automatically take
 * precedence over weak definitions
 */
void WDT_BOD_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void DMA0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void GINT0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void GINT1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT2_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT3_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void UTICK0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void MRT0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CTIMER0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CTIMER1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SCT0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CTIMER3_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM2_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM3_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM4_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM5_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM6_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM7_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ADC0_SEQA_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ADC0_SEQB_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ADC0_THCMP_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void DMIC0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void HWVAD0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void USB0_NEEDCLK_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void USB0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void RTC_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void Reserved46_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void Reserved47_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT4_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT5_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT6_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void PIN_INT7_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CTIMER2_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CTIMER4_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void RIT_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SPIFI0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM8_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void FLEXCOMM9_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SDIO_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CAN0_IRQ0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CAN0_IRQ1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CAN1_IRQ0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void CAN1_IRQ1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void USB1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void USB1_NEEDCLK_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ETHERNET_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ETHERNET_PMT_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void ETHERNET_MACLP_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void EEPROM_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void LCD_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SHA_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SMARTCARD0_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));
void SMARTCARD1_DriverIRQHandler(void)    __attribute__ ((weak, alias ("IntDefaultHandler")));

#if defined (__cplusplus)
} /* extern "C" */
#endif

/*
 * The vector table.
 * This relies on the linker script to place at correct location in memory.
 */
extern void (* const g_pfnVectors[])(void);

__attribute__ ((used,section(".isr_vector")))
void (* const g_pfnVectors[])(void) = {
    /* Core Level - CM4 */
    &_vStackTop,                /* The initial stack pointer */
    ResetISR,                   /* The reset handler */
    NMI_Handler,                /* The NMI handler */
    HardFault_Handler,          /* The hard fault handler */
    MemManage_Handler,          /* The MPU fault handler */
    BusFault_Handler,           /* The bus fault handler */
    UsageFault_Handler,         /* The usage fault handler */
    __valid_user_code_checksum, /* LPC MCU Checksum */
    0xFFFFFFFF,                 /* ECRP */
    0,                          /* Reserved */
    0,                          /* Reserved */
    SVC_Handler,                /* SVCall handler */
    DebugMon_Handler,           /* Debug monitor handler */
    0,                          /* Reserved */
    PendSV_Handler,             /* The PendSV handler */
    SysTick_Handler,            /* The SysTick handler */
    /* External Interrupts - Available on M0/M4  */
    WDT_BOD_IRQHandler,         /* Windowed watchdog timer, Brownout detect */
    DMA0_IRQHandler,         /* DMA controller */
    GINT0_IRQHandler,         /* GPIO group 0 */
    GINT1_IRQHandler,         /* GPIO group 1 */
    PIN_INT0_IRQHandler,         /* Pin interrupt 0 or pattern match engine slice 0 */
    PIN_INT1_IRQHandler,         /* Pin interrupt 1or pattern match engine slice 1 */
    PIN_INT2_IRQHandler,         /* Pin interrupt 2 or pattern match engine slice 2 */
    PIN_INT3_IRQHandler,         /* Pin interrupt 3 or pattern match engine slice 3 */
    UTICK0_IRQHandler,         /* Micro-tick Timer */
    MRT0_IRQHandler,         /* Multi-rate timer */
    CTIMER0_IRQHandler,         /* Standard counter/timer CTIMER0 */
    CTIMER1_IRQHandler,         /* Standard counter/timer CTIMER1 */
    SCT0_IRQHandler,         /* SCTimer/PWM */
    CTIMER3_IRQHandler,         /* Standard counter/timer CTIMER3 */
    FLEXCOMM0_IRQHandler,         /* Flexcomm Interface 0 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM1_IRQHandler,         /* Flexcomm Interface 1 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM2_IRQHandler,         /* Flexcomm Interface 2 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM3_IRQHandler,         /* Flexcomm Interface 3 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM4_IRQHandler,         /* Flexcomm Interface 4 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM5_IRQHandler,         /* Flexcomm Interface 5 (USART, SPI, I2C,, FLEXCOMM) */
    FLEXCOMM6_IRQHandler,         /* Flexcomm Interface 6 (USART, SPI, I2C, I2S,, FLEXCOMM) */
    FLEXCOMM7_IRQHandler,         /* Flexcomm Interface 7 (USART, SPI, I2C, I2S,, FLEXCOMM) */
    ADC0_SEQA_IRQHandler,         /* ADC0 sequence A completion. */
    ADC0_SEQB_IRQHandler,         /* ADC0 sequence B completion. */
    ADC0_THCMP_IRQHandler,         /* ADC0 threshold compare and error. */
    DMIC0_IRQHandler,         /* Digital microphone and DMIC subsystem */
    HWVAD0_IRQHandler,         /* Hardware Voice Activity Detector */
    USB0_NEEDCLK_IRQHandler,         /* USB Activity Wake-up Interrupt */
    USB0_IRQHandler,         /* USB device */
    RTC_IRQHandler,         /* RTC alarm and wake-up interrupts */
    Reserved46_IRQHandler,         /* Reserved interrupt */
    Reserved47_IRQHandler,         /* Reserved interrupt */
    PIN_INT4_IRQHandler,         /* Pin interrupt 4 or pattern match engine slice 4 int */
    PIN_INT5_IRQHandler,         /* Pin interrupt 5 or pattern match engine slice 5 int */
    PIN_INT6_IRQHandler,         /* Pin interrupt 6 or pattern match engine slice 6 int */
    PIN_INT7_IRQHandler,         /* Pin interrupt 7 or pattern match engine slice 7 int */
    CTIMER2_IRQHandler,         /* Standard counter/timer CTIMER2 */
    CTIMER4_IRQHandler,         /* Standard counter/timer CTIMER4 */
    RIT_IRQHandler,         /* Repetitive Interrupt Timer */
    SPIFI0_IRQHandler,         /* SPI flash interface */
    FLEXCOMM8_IRQHandler,         /* Flexcomm Interface 8 (USART, SPI, I2C, FLEXCOMM) */
    FLEXCOMM9_IRQHandler,         /* Flexcomm Interface 9 (USART, SPI, I2C, FLEXCOMM) */
    SDIO_IRQHandler,         /* SD/MMC  */
    CAN0_IRQ0_IRQHandler,         /* CAN0 interrupt0 */
    CAN0_IRQ1_IRQHandler,         /* CAN0 interrupt1 */
    CAN1_IRQ0_IRQHandler,         /* CAN1 interrupt0 */
    CAN1_IRQ1_IRQHandler,         /* CAN1 interrupt1 */
    USB1_IRQHandler,         /* USB1 interrupt */
    USB1_NEEDCLK_IRQHandler,         /* USB1 activity */
    ETHERNET_IRQHandler,         /* Ethernet */
    ETHERNET_PMT_IRQHandler,         /* Ethernet power management interrupt */
    ETHERNET_MACLP_IRQHandler,         /* Ethernet MAC interrupt */
    EEPROM_IRQHandler,         /* EEPROM interrupt */
    LCD_IRQHandler,         /* LCD interrupt */
    SHA_IRQHandler,         /* SHA interrupt */
    SMARTCARD0_IRQHandler,         /* Smart card 0 interrupt */
    SMARTCARD1_IRQHandler,         /* Smart card 1 interrupt */
}; /* End of g_pfnVectors */

/*
 * Functions to carry out the initialization of RW and BSS data sections. These
 * are written as separate functions rather than being inlined within the
 * ResetISR() function in order to cope with MCUs with multiple banks of
 * memory.
 */
__attribute__ ((section(".after_vectors")))
void data_init(unsigned int romstart, unsigned int start, unsigned int len) {
    unsigned int *pulDest = (unsigned int*) start;
    unsigned int *pulSrc = (unsigned int*) romstart;
    unsigned int loop;
    for (loop = 0; loop < len; loop = loop + 4)
        *pulDest++ = *pulSrc++;
}

__attribute__ ((section(".after_vectors")))
void bss_init(unsigned int start, unsigned int len) {
    unsigned int *pulDest = (unsigned int*) start;
    unsigned int loop;
    for (loop = 0; loop < len; loop = loop + 4)
        *pulDest++ = 0;
}

/*
 * The following symbols are constructs generated by the linker, indicating
 * the location of various points in the "Global Section Table". This table is
 * created by the linker via the Code Red managed linker script mechanism. It
 * contains the load address, execution address and length of each RW data
 * section and the execution and length of each BSS (zero initialized) section.
 */
extern unsigned int __data_section_table;
extern unsigned int __data_section_table_end;
extern unsigned int __bss_section_table;
extern unsigned int __bss_section_table_end;

/*
 * Reset entry point for your code.
 * Sets up a simple runtime environment and initializes the C/C++
 * library.
 */

__attribute__ ((section(".after_vectors.reset")))
void ResetISR(void) {
    /* Copy the data sections from flash to SRAM. */
    unsigned int LoadAddr, ExeAddr, SectionLen;
    unsigned int *SectionTableAddr;
    SystemInit();
    /* Load base address of Global Section Table */
    SectionTableAddr = &__data_section_table;
    /* Copy the data sections from flash to SRAM. */
    while (SectionTableAddr < &__data_section_table_end) {
        LoadAddr = *SectionTableAddr++;
        ExeAddr = *SectionTableAddr++;
        SectionLen = *SectionTableAddr++;
        data_init(LoadAddr, ExeAddr, SectionLen);
    }
    /* At this point, SectionTableAddr = &__bss_section_table;
     * Zero fill the bss segment
     */
    while (SectionTableAddr < &__bss_section_table_end) {
        ExeAddr = *SectionTableAddr++;
        SectionLen = *SectionTableAddr++;
        bss_init(ExeAddr, SectionLen);
    }
	/*
     * Optionally enable Cortex-M4 SWV trace (off by default at reset)
     * Note - your board support must also set up pinmuxing such that
     * SWO is output on GPIO PIO0-15 (FUNC2) or PIO1_1 (FUNC2).
     */
#if !defined (DONT_ENABLE_SWVTRACECLK) && defined(__CODE_RED)
	volatile unsigned int *TRACECLKDIV = (unsigned int *) 0x40000304;
	volatile unsigned int *SYSAHBCLKCTRLSET = (unsigned int *) 0x40000220;
	volatile unsigned int *SYSAHBCLKCTRL = (unsigned int *) 0x40000200;
	/* Write 0x00000000 to TRACECLKDIV – Trace divider */
	*TRACECLKDIV = 0;
	/* Enable IOCON peripheral clock (for SWO on PIO0-15 or PIO1_1) by setting bit13 via SYSAHBCLKCTRLSET[0] */
	*SYSAHBCLKCTRLSET = 1 << 13; // 0x2000
	/* Read  SYSAHBCLKCTRL[0] and check bit 13 */
	__SWVtrace_Enabled = ((*SYSAHBCLKCTRL & 1 << 13) == 1 << 13);
#endif
#if defined (__cplusplus)
    /* Call C++ library initialisation */
    __libc_init_array();
#endif
#if defined (__REDLIB__)
    /* Call the Redlib library, which in turn calls main() */
    __main();
#else
    main();
#endif
    /* main() shouldn't return, but if it does, we'll just enter an infinite loop */
    while (1) {
        ;
    }
}

/*
 * Processor ends up here if an unexpected interrupt occurs or a specific
 * handler is not present in the application code.
 */__attribute__ ((weak ,section(".after_vectors")))
void IntDefaultHandler(void)
{
    while(1) {}
}

/*
 * Default core exception handlers. Override the ones here by defining your own
 * handler routines in your application code.
 */

__attribute__ ((weak ,section(".after_vectors")))
void NMI_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void HardFault_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void MemManage_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void BusFault_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void UsageFault_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void SVC_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void DebugMon_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void PendSV_Handler(void)
{
    while(1) {}
}

__attribute__ ((weak ,section(".after_vectors")))
void SysTick_Handler(void)
{
    while(1) {}
}

/*
 * Default application exception handlers. Override the ones here by defining your own
 * handler routines in your application code. These routines call driver exception handlers
 * or IntDefaultHandler() if no driver exception handler is included.
 */

__attribute__ ((weak))
void WDT_BOD_IRQHandler(void)
{
    WDT_BOD_DriverIRQHandler();
}

__attribute__ ((weak))
void DMA0_IRQHandler(void)
{
    DMA0_DriverIRQHandler();
}

__attribute__ ((weak))
void GINT0_IRQHandler(void)
{
    GINT0_DriverIRQHandler();
}

__attribute__ ((weak))
void GINT1_IRQHandler(void)
{
    GINT1_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT0_IRQHandler(void)
{
    PIN_INT0_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT1_IRQHandler(void)
{
    PIN_INT1_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT2_IRQHandler(void)
{
    PIN_INT2_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT3_IRQHandler(void)
{
    PIN_INT3_DriverIRQHandler();
}

__attribute__ ((weak))
void UTICK0_IRQHandler(void)
{
    UTICK0_DriverIRQHandler();
}

__attribute__ ((weak))
void MRT0_IRQHandler(void)
{
    MRT0_DriverIRQHandler();
}

__attribute__ ((weak))
void CTIMER0_IRQHandler(void)
{
    CTIMER0_DriverIRQHandler();
}

__attribute__ ((weak))
void CTIMER1_IRQHandler(void)
{
    CTIMER1_DriverIRQHandler();
}

__attribute__ ((weak))
void SCT0_IRQHandler(void)
{
    SCT0_DriverIRQHandler();
}

__attribute__ ((weak))
void CTIMER3_IRQHandler(void)
{
    CTIMER3_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM0_IRQHandler(void)
{
    FLEXCOMM0_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM1_IRQHandler(void)
{
    FLEXCOMM1_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM2_IRQHandler(void)
{
    FLEXCOMM2_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM3_IRQHandler(void)
{
    FLEXCOMM3_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM4_IRQHandler(void)
{
    FLEXCOMM4_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM5_IRQHandler(void)
{
    FLEXCOMM5_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM6_IRQHandler(void)
{
    FLEXCOMM6_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM7_IRQHandler(void)
{
    FLEXCOMM7_DriverIRQHandler();
}

__attribute__ ((weak))
void ADC0_SEQA_IRQHandler(void)
{
    ADC0_SEQA_DriverIRQHandler();
}

__attribute__ ((weak))
void ADC0_SEQB_IRQHandler(void)
{
    ADC0_SEQB_DriverIRQHandler();
}

__attribute__ ((weak))
void ADC0_THCMP_IRQHandler(void)
{
    ADC0_THCMP_DriverIRQHandler();
}

__attribute__ ((weak))
void DMIC0_IRQHandler(void)
{
    DMIC0_DriverIRQHandler();
}

__attribute__ ((weak))
void HWVAD0_IRQHandler(void)
{
    HWVAD0_DriverIRQHandler();
}

__attribute__ ((weak))
void USB0_NEEDCLK_IRQHandler(void)
{
    USB0_NEEDCLK_DriverIRQHandler();
}

__attribute__ ((weak))
void USB0_IRQHandler(void)
{
    USB0_DriverIRQHandler();
}

__attribute__ ((weak))
void RTC_IRQHandler(void)
{
    RTC_DriverIRQHandler();
}

__attribute__ ((weak))
void Reserved46_IRQHandler(void)
{
    Reserved46_DriverIRQHandler();
}

__attribute__ ((weak))
void Reserved47_IRQHandler(void)
{
    Reserved47_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT4_IRQHandler(void)
{
    PIN_INT4_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT5_IRQHandler(void)
{
    PIN_INT5_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT6_IRQHandler(void)
{
    PIN_INT6_DriverIRQHandler();
}

__attribute__ ((weak))
void PIN_INT7_IRQHandler(void)
{
    PIN_INT7_DriverIRQHandler();
}

__attribute__ ((weak))
void CTIMER2_IRQHandler(void)
{
    CTIMER2_DriverIRQHandler();
}

__attribute__ ((weak))
void CTIMER4_IRQHandler(void)
{
    CTIMER4_DriverIRQHandler();
}

__attribute__ ((weak))
void RIT_IRQHandler(void)
{
    RIT_DriverIRQHandler();
}

__attribute__ ((weak))
void SPIFI0_IRQHandler(void)
{
    SPIFI0_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM8_IRQHandler(void)
{
    FLEXCOMM8_DriverIRQHandler();
}

__attribute__ ((weak))
void FLEXCOMM9_IRQHandler(void)
{
    FLEXCOMM9_DriverIRQHandler();
}

__attribute__ ((weak))
void SDIO_IRQHandler(void)
{
    SDIO_DriverIRQHandler();
}

__attribute__ ((weak))
void CAN0_IRQ0_IRQHandler(void)
{
    CAN0_IRQ0_DriverIRQHandler();
}

__attribute__ ((weak))
void CAN0_IRQ1_IRQHandler(void)
{
    CAN0_IRQ1_DriverIRQHandler();
}

__attribute__ ((weak))
void CAN1_IRQ0_IRQHandler(void)
{
    CAN1_IRQ0_DriverIRQHandler();
}

__attribute__ ((weak))
void CAN1_IRQ1_IRQHandler(void)
{
    CAN1_IRQ1_DriverIRQHandler();
}

__attribute__ ((weak))
void USB1_IRQHandler(void)
{
    USB1_DriverIRQHandler();
}

__attribute__ ((weak))
void USB1_NEEDCLK_IRQHandler(void)
{
    USB1_NEEDCLK_DriverIRQHandler();
}

__attribute__ ((weak))
void ETHERNET_IRQHandler(void)
{
    ETHERNET_DriverIRQHandler();
}

__attribute__ ((weak))
void ETHERNET_PMT_IRQHandler(void)
{
    ETHERNET_PMT_DriverIRQHandler();
}

__attribute__ ((weak))
void ETHERNET_MACLP_IRQHandler(void)
{
    ETHERNET_MACLP_DriverIRQHandler();
}

__attribute__ ((weak))
void EEPROM_IRQHandler(void)
{
    EEPROM_DriverIRQHandler();
}

__attribute__ ((weak))
void LCD_IRQHandler(void)
{
    LCD_DriverIRQHandler();
}

__attribute__ ((weak))
void SHA_IRQHandler(void)
{
    SHA_DriverIRQHandler();
}

__attribute__ ((weak))
void SMARTCARD0_IRQHandler(void)
{
    SMARTCARD0_DriverIRQHandler();
}

__attribute__ ((weak))
void SMARTCARD1_IRQHandler(void)
{
    SMARTCARD1_DriverIRQHandler();
}

