/****************************************************************************
 *
 * MODULE:             Demo coordinator code
 *
 * COMPONENT:          $RCSfile: SensorDemoCoord.c,v $
 *
 * VERSION:            $Name:  $
 *
 * REVISION:           $Revision: 1.2 $
 *
 * DATED:              $Date: 2008/05/08 14:53:30 $
 *
 * STATUS:             $State: Exp $
 *
 * AUTHOR:             CJG
 *
 * DESCRIPTION:
 * Coordinator for demonstrator. Acts as time coordinator for up to four
 * sensor endpoints and manages LCD panel and keys on central coordinator.
 *
 * LAST MODIFIED BY:   $Author: cjg $
 *                     $Modtime: $
 *
 ****************************************************************************
 *
 *  (c) Copyright 2007 JENNIC Ltd
 *
 ****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include "jendefs.h"
#include "AppHardwareApi.h"
#include "Printf.h"

extern void vLoadBootImage(uint32 u32AppId);

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/
void Task(void);

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/
/****************************************************************************
 *
 * NAME: AppColdStart
 *
 * DESCRIPTION:
 * Entry point for application from boot loader. Initialises system and runs
 * main loop.
 *
 * RETURNS:
 * Never returns.
 *
 ****************************************************************************/
PUBLIC void AppColdStart(void)
{

	uint16 AppID = 0;
	volatile uint32 u32ctr = 0;

	vAHI_WatchdogStop();

	// Wait for clock to switch to crystal so UART is at correct rate
	while (bAHI_GetClkSource() == TRUE);
	vAHI_OptimiseWaitStates();

    vUART_printInit();
	u32AHI_Init();

#if IMAGE_ID==0
	vPrintf("Running Boot Image 0\n\n");
	AppID = 1;
#elif  IMAGE_ID==1
	vPrintf("Running Boot Image 1\n\n");
	AppID = 0;
#else
#pragma message  "* Application ID not defined  *"
#endif

	// Add a delay
	for (u32ctr=0;u32ctr<500000; u32ctr++);

	// Run the other application
	vLoadBootImage(AppID);

	// should never get here
	while(1);
}


/****************************************************************************
 *
 * NAME: AppWarmStart
 *
 * DESCRIPTION:
 * Entry point for application from boot loader. Simply jumps to AppColdStart
 * as, in this instance, application will never warm start.
 *
 * RETURNS:
 * Never returns.
 *
 ****************************************************************************/
PUBLIC void AppWarmStart(void)
{
    vUART_printInit();
    vPrintf("Warm Started. We should not get here.\n\r");
    while (1);
}

/****************************************************************************/
/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
