#!/bin/sh
# ------------------------------------------------------------------
# SW Update shell script
# - Note: altered by Makefile for site-diversity reasons
# ------------------------------------------------------------------
# Author:    nlv10677
# Copyright: NXP B.V. 2014. All rights reserved
# ------------------------------------------------------------------

# NOTE: following line is generated by Makefile (site-diversity)
CLOUD=http://www.nxpcloud.com/images/IoT_EHV

IMAGE=iot_image_rel.tgz

# Make sure persmissions are ok
chmod +x /usr/bin/iot_*
chmod +x /usr/bin/killbyname

# Stop all IoT processes
/usr/bin/iot_stop.sh > /dev/null

# Remove all existing iot files in /tmp
rm /tmp/iot_*.log
rm /tmp/iot_*.bck
rm /tmp/iot_*.queue
rm /tmp/iot_*.zip

# Create iot directory in /usr/share if not already exists
if [ ! -d /usr/share/iot ]; then
    mkdir /usr/share/iot
fi

# Get the new SW image from the cloud
if [ -f /usr/bin/iot_wget.sh ]; then
	/usr/bin/iot_wget.sh $CLOUD/$IMAGE -O /tmp/$IMAGE > /dev/null
else
	/usr/bin/wget $CLOUD/$IMAGE -O /tmp/$IMAGE > /dev/null
fi

# UNZIP new SW image, prepare permissions, copy and remove
tar -xzf /tmp/$IMAGE -C /tmp
chown -R root:root /tmp/images
chmod -R +r /tmp/images/tmp
chmod -R +r /tmp/images/www
chmod -R +r /tmp/images/etc/*
chmod +x /tmp/images/usr/bin/*
cp -pR /tmp/images/* /
rm -R /tmp/images
rm /tmp/$IMAGE

# Make the new DB structure
/usr/bin/iot_dm -f /etc/config/iot_dm.cfg > /dev/null

# Init as usual
/usr/bin/iot_init.sh > /dev/null

# and finally restart all IoT processes
/usr/bin/iot_start.sh > /dev/null

