/****************************************************************************
 *
 * MODULE:
 *
 * COMPONENT:          Timer.c
 *
 * DESCRIPTION:
 *
 ****************************************************************************
 *
 ****************************************************************************
 *  Copyright (c) 2015 NXP B.V.  All rights are reserved.
 *  Reproduction in whole or in part is prohibited without the prior
 *  written consent of the copyright owner.
 *
 *  This software and any compilation or derivative thereof is, and
 *  shall remain the proprietary information of NXP and is
 *  highly confidential in nature. Any and all use hereof is restricted
 *  and is subject to the terms and conditions set forth in the
 *  software license agreement concluded with NXP B.V.
 *
 *  Under no circumstances is this software or any derivative thereof
 *  to be combined with any Open Source Software, exposed to, or in any
 *  way licensed under any Open License Terms without the express prior
 *  written permission of the copyright owner.
 *
 *  For the purpose of the above, the term Open Source Software means
 *  any software that is licensed under Open License Terms. Open
 *  License Terms means terms in any license that require as a
 *  condition of use, modification and/or distribution of a work
 *
 *  1. the making available of source code or other materials
 *     preferred for modification, or
 *
 *  2. the granting of permission for creating derivative
 *     works, or
 *
 *  3. the reproduction of certain notices or license terms
 *     in derivative works or accompanying documentation, or
 *
 *  4. the granting of a royalty-free license to any party
 *     under Intellectual Property Rights
 *
 *  regarding the work and/or any work that contains, is combined with,
 *  requires or otherwise is based on the work.
 *
 *  This software is provided for ease of recompilation only.
 *  Modification and reverse engineering of this software are strictly
 *  prohibited.
 *
 ****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/

#include <jendefs.h>
#include "os.h"
#include "os_gen.h"
#include "dbg.h"
#include "AppHardwareApi.h"
#include "app_timer_driver.h"
#include "Timer.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

static bool_t bUseOsTickTimer = TRUE;

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

void vDelayUseOsTickTimer(bool_t bUseOsTimer)
{
    bUseOsTickTimer = bUseOsTimer;
    if (!bUseOsTimer)
    {
        vAHI_TickTimerConfigure(E_AHI_TICK_TIMER_CONT);
        vAHI_TickTimerWrite(0);
    }
}

void vDelayMs(uint32 ms)
{
    uint32 t_cur;
    uint32 t_stop;
    uint32 t_shift = 0;
    bool   delay_more = TRUE;

    if (bUseOsTickTimer)
    {
        t_cur = os_u32APP_cbGetTickTimer();
        if (t_cur >= 0x80000000)
        {
            t_shift = 0x80000000;
        }
        t_stop = t_cur + t_shift + (ms * APP_TIME_MS(1));
        while(delay_more)
        {
            t_cur = os_u32APP_cbGetTickTimer() + t_shift;
            if (t_cur > t_stop)
            {
                delay_more = FALSE;
            }
        }
    }
    else
    {
        t_cur = u32AHI_TickTimerRead();
        if (t_cur >= 0x80000000)
        {
            t_shift = 0x80000000;
        }
        t_stop = t_cur + t_shift + (ms * APP_TIME_MS(1));
        while(delay_more)
        {
            t_cur = u32AHI_TickTimerRead() + t_shift;
            if (t_cur > t_stop)
            {
                delay_more = FALSE;
            }
        }
    }
}

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
