/*****************************************************************************
 *
 * MODULE:             JN-AN-xxxx
 *
 * COMPONENT:          I2C_Driver.h
 *
 * DESCRIPTION:        I2C driver - include file
 *
 *****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 *
 ****************************************************************************/

#ifndef _I2C_Driver_H_
#define _I2C_Driver_H_

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/

#include <jendefs.h>

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

void i2c_init(bool bUseDio16Dio17, bool bI2Cclk400khz);
void i2c_EnableBusLocking(bool_t bEnable);
void i2c_LockBus(void);
void i2c_UnlockBus(void);
bool i2c_BusWriteReg(uint8 u8Address, uint8 u8Command, uint8 u8Length, uint8* pu8Data);
bool i2c_BusReadData(uint8 u8Address, uint8 u8Command, uint8 u8Length, uint8* pu8Data);
bool i2c_ReadNtagReg(uint8 u8Address, uint8 u8Command, uint8 u8Reg, uint8* pu8Data);
bool i2c_CheckSlaveAvailable(uint8 u8Address);
void i2c_ToggleDBG(void);

#if defined __cplusplus
}
#endif

#endif  // _I2C_Driver_H_

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
