/*****************************************************************************
 *
 * MODULE:             JN-AN-xxxx
 *
 * COMPONENT:          app_config.h
 *
 * DESCRIPTION:
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 *
 ***************************************************************************/

#ifndef APP_CONFIG_H
#define APP_CONFIG_H

#define VERSION_INFO_LINE_1   "NXP Semiconductors"
#define VERSION_INFO_LINE_2   "Color Dimmable Light NFC/OTA/OCC"
#define VERSION_NR_MAJOR      2
#define VERSION_NR_MINOR      0

#define HALT_ON_EXCEPTION     FALSE

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable I2C support.
 *          When I2C_SUPPORT is defined the functions in the source file
 *          I2C_Driver.c will become available.
 *          Commenting out this define results in I2C driver not being supported.
 *          The assigned value to this build flag is not relevant.
 */
#define I2C_SUPPORT                       1

#ifdef I2C_SUPPORT

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable mutex support by I2C driver.
 *          When I2C_USE_MUTEX is defined the I2C driver will use the mutex
 *          'mutexI2Cbus' to lock and unlock the access to the I2C bus.
 *          This is needed to solve re-entrance problems when multiple SW
 *          modules needs to access multiple I2C slaves connected to the I2C
 *          bus via the I2C driver.
 *          Commenting out this define results in no mutex being used by I2C driver.
 *          The assigned value to this build flag is not relevant.
 */
//#define I2C_USE_MUTEX                     1

#endif  // I2C_SUPPORT

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable NFC support.
 *          When NFC_SUPPORT is defined the functions in the source files
 *          nfc.c , ndef.c and ntag.c will become available.
 *          Commenting out this define results in NFC not being supported.
 *          The assigned value to this build flag is not relevant.
 */
// set via makefile conf  #define NFC_SUPPORT                       1

#ifdef NFC_SUPPORT

/* Doxygen info, do not remove! */
/**
 * @brief   The definition of NTAG_FD_PIN must specify the DIO pin of the JN516x chip
 *          that is connected with the FD output pin of the NTAG-I2C IC on the used PCB.
 *          The nfc software will configure this DIO pin as interrupt input.
 *          Commenting out this define results in no interrupt being used.
 */
#define NTAG_FD_PIN                       (17)     //!< NTAG FD pin connected to DIO17

/* Doxygen info, do not remove! */
/**
 * @brief   CONFIG_NUMBER_OF_APP_NDEF_MSGS specifies the number of NDEF messages that
 *          the application software wants to support in the NTAG IC.
 *          This number doesn't include the NDEF message needed for commissioning.
 * @warning CONFIG_NUMBER_OF_APP_NDEF_MSGS must exactly match the number of NDEF messages
 *          that will be registered by the application, in order for the format of the NTAG
 *          to take place at startup of the application software when the last NDEF message
 *          was registered by the application.
 *          Also be aware that this define is used in array length definition (RAM usage).
 */
#define CONFIG_NUMBER_OF_APP_NDEF_MSGS    0

/* Doxygen info, do not remove! */
/**
 * @brief   CONFIG_NDEF_MAX_TYPE_LENGTH specifies the maximum length (in bytes) of the
 *          NDEF payload type being used in the application software.
 *          During parsing of the NTAG contents the NDEF payload type field of an NDEF
 *          message is being used to find out which registered callback function needs
 *          to be called.
 * @note    The maximum allowed value is 255.
 * @warning Be aware that this define is used in array length definition (RAM usage).
 */
#define CONFIG_NDEF_MAX_TYPE_LENGTH       16

/* Doxygen info, do not remove! */
/**
 * @brief   CONFIG_NDEF_MAX_ID_LENGTH specifies the maximum length (in bytes) of the
 *          NDEF payload identifier being used in the application software.
 * @note    The maximum allowed value is 255.
 * @warning Be aware that this define is used in array length definition (RAM usage).
 */
#define CONFIG_NDEF_MAX_ID_LENGTH         4

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable NFC commissioning.
 *          When NFC_COMMISSIONING is defined the functions in the source file
 *          nsc.c will become available, and an NDEF message for commissioning
 *          via NFC is automatically created in the NTAG.
 *          Commenting out this define results in no support for NFC commissioning.
 *          The assigned value to this build flag is not relevant.
 */
#define NFC_COMMISSIONING                 1

#ifdef NFC_COMMISSIONING

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable the handling of factory new command via NFC.
 *          Commenting out this define results in factory new command via NFC being ignored.
 *          The assigned value to this build flag is not relevant.
 */
#define NFC_ALLOW_FACTORY_NEW_CMD         1

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable the handling of not secure (not using ECC) join network command via NFC.
 *          Commenting out this define results in not secure join network command via NFC being ignored.
 *          The assigned value to this build flag is not relevant.
 */
#define NFC_ALLOW_UNSECURE_JOIN_NWK       1

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable the handling of leave network (decommission) command via NFC.
 *          Commenting out this define results in leave network command via NFC being ignored.
 *          The assigned value to this build flag is not relevant.
 */
#define NFC_ALLOW_LEAVE_NWK               1

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to allow joining (secure or not) of other network
 *          without first leaving the current joined network.
 *          Commenting out this define results in join network command (secure or not) via NFC
 *          being ignored when already joined in a network.
 *          The assigned value to this build flag is not relevant.
 */
#define NFC_ALLOW_JOIN_OTHER_NWK          1

/* Doxygen info, do not remove! */
/**
 * @brief   Build flag to enable the handling of secure join network command via NFC.
 *          Commenting out this define results in secure join network command via NFC being ignored.
 *          The assigned value to this build flag is not relevant.
 */

#endif  // NFC_COMMISSIONING

#endif  // NFC_SUPPORT


#endif /* APP_CONFIG_H */
