/****************************************************************************
 *
 * MODULE:             Buffered, interrupt driven serial I/O
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5179].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 ****************************************************************************/

#ifndef  UARTBUFFERED_H_INCLUDED
#define  UARTBUFFERED_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

#define UART_TX_BUFFER_LEN  10000           /* size of tx buffer in bytes */
#define UART_RX_BUFFER_LEN  100             /* size of rx buffer in bytes */

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/* Holds all data required for 1 uart */
typedef struct {
    volatile bool_t bTxInProgress;
    uint32 u32TxInPtr;
    volatile uint32 u32TxOutPtr;
    volatile uint32 u32RxInPtr;
    uint32 u32RxOutPtr;
    uint8 u8UartTxBuff[UART_TX_BUFFER_LEN];
    uint8 u8UartRxBuff[UART_RX_BUFFER_LEN];
} tsUartFifo;

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

PUBLIC void vUartInit(uint8 u8Uart, uint8 u8BaudRate, tsUartFifo *psFifo);
PUBLIC bool_t bUartReadBinary(uint8 u8Uart, uint8 *pu8Ptr, uint32 u32Len, uint32 u32TimeoutTime);
PUBLIC bool_t bUartReadWithTimeout(uint8 u8Uart, uint8 *pu8Data, uint32 u32TimeoutTime);
PUBLIC uint8 u8UartRead(uint8 u8Uart);
PUBLIC bool_t bUartTxInProgress(uint8 u8Uart);
PUBLIC bool_t bUartRxDataAvailable(uint8 u8Uart);
PUBLIC void vUartWriteBinary(uint8 u8Uart, uint8 *pu8Ptr, uint32 u32Len);
PUBLIC void vUartWriteString(uint8 u8Uart, uint8 *pu8String);
PUBLIC void vUartWrite(uint8 u8Uart, uint8 u8Data);
PUBLIC void vUartDeInit(uint8 u8Uart);
PUBLIC void vUartFlush(uint8 u8Uart);

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif  /* UARTBUFFERED_H_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/

