/*****************************************************************************
 *
 * MODULE:              PER Test
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5179].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2015. All rights reserved
 ****************************************************************************/

#ifndef  PERTEST_H_INCLUDED
#define  PERTEST_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/

#include <jendefs.h>
#include <JPT.h>

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

typedef enum {
	E_PER_MODE_LOCATE				= 1,
	E_PER_MODE_STOPPED				= 2,
	E_PER_MODE_RUNNING_ACKS		    = 3,
	E_PER_MODE_RUNNING_NO_ACKS		= 4,
	E_PER_MODE_RESTART				= 5,
} tePT_Mode;

typedef struct {
	tePT_Mode eMode;
	uint8 u8Channel;
	uint8 u8Retries;
	uint32 u32Total;
	uint32 u32Seen;
	uint32 u32Errors;
	uint8 u8Lqi;
	uint8 u8PacketLength;
	int8  i8PowerLevel;
#ifdef RXPOWERADJUST_SUPPORT
	uint8 u8InputLevel;
#endif
} tsPER_MasterState;

typedef struct {
	tePT_Mode eMode;
	uint8 u8Channel;
	uint8 u8PacketLength;
	int8  i8PowerLevel;
#ifdef RXPOWERADJUST_SUPPORT
	uint8 u8InputLevel;
#endif
} tsPER_SlaveState;


/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/* Site Survey PER Test functions */
PUBLIC void vPER_MasterInit(void);
PUBLIC bool_t bPER_MasterSetState(tsPER_MasterState *psState);
PUBLIC void vPER_MasterGetState(tsPER_MasterState *psState);
PUBLIC void vPER_SlaveInit(void);
PUBLIC void vPER_SlaveGetState(tsPER_SlaveState *psState);

PUBLIC void vPER_HandleMcps(void);

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif  /* PERTEST_H_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
