/*****************************************************************************
 *
 * MODULE:             JN-AN-1200-ZigBee-RF4CE-Application-Template
 *
 * COMPONENT:          Config.h
 *
 * DESCRIPTION:        Configuration file
 *
 * $HeadURL $
 *
 * $Revision: 12086 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2013-12-16 12:22:44 +0530 (Mon, 16 Dec 2013) $
 *
 * $Id: Config.h 12086 2013-12-16 06:52:44Z nxp46755 $
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN516x, JN514x,
 * JN513x].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 *
 ***************************************************************************/

#ifndef CONFIG_INCLUDED
#define CONFIG_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/**********************************************/
/***        Common Configuration            ***/
/**********************************************/
#define CPU_FREQUENCY_MHz               (32)    /* 32MHz or 16MHz */
#define ZRC_PROFILE_ID                  (0x01)  /* ZRCv1.1 profile ID Constant*/


/**********************************************/
/***        Receiver Configuration          ***/
/**********************************************/
#if defined(Receiver)
    #define NODE_CAPABILITY (RF4CE_NODECAP_TYPE_TARGET       \
                             | RF4CE_NODECAP_PWRSRC_MAINS    \
                             | RF4CE_NODECAP_SECURITY_CAPABLE\
                             | RF4CE_NODECAP_CHANNORM_CAPABLE) /* nwkcNodeCapabilities*/
    #define VENDOR_ID       (0xfff1) /* TestVendor#1 - ZigBeeDoc 094949r00ZB*/
    #define VENDOR_STRING   "NXP"

    #define ALWAYS_OPEN_FOR_PAIRING         (TRUE)      /* TRUE or FALSE */
    #define ENABLE_NWK_POWER_SAVING_MODE    (FALSE)     /* TRUE or FALSE */
    #define NWK_DUTY_CYCLE                  (0x000627)  /* nwkDutyCycle in MAC symbols (e.g.,25.2ms) */
    #define NWK_ACTIVE_PERIOD               (0x00041A)  /* nwkActivePeriod in MAC symbols (e.g., Default 16.8ms) */

    #define AUTO_DISCOVERY_DURATION         (5 *62500)  /* in MAC Symbols */
    #define NIB_ATTR_NWK_DISC_LQI_THRESHOLD (0x99)      /* nwkDiscoveryLQIThreshold */
    #define APLC_MAX_PAIR_IND_WAIT_TIME     (3)         /* in Seconds; Wait time for receiver after discovery */

    #define PAIR_TABLE_UPDATE_WINDOW        (5)         /* in Seconds */

    /* Required for Binding - Discovery and Pairing */
    #define USER_STRING_SPECIFIED           (1)
    #define NUM_OF_SUPPORTED_DEVICE_TYPES   (1) /* RF4CE_DEVICE_TYPE_MEDIA_CENTER */
    #define RESERVED                        (0)
    #define NUM_OF_SUPPORTED_PROFILES       (1) /* ZRCv1.1 */
    #define USER_STRING_LEN                 (8)
    #define USER_STRING                     "Receiver"
    #define SUPPORTED_DEVICE_TYPES          {RF4CE_DEVICE_TYPE_MEDIA_CENTER}
#endif //#if defined(Receiver)


/**********************************************/
/***        Remote Configuration            ***/
/**********************************************/
#if defined(Remote)
    #define NODE_CAPABILITY (RF4CE_NODECAP_TYPE_CONTROLLER     \
                              | RF4CE_NODECAP_PWRSRC_MAINS     \
                              | RF4CE_NODECAP_SECURITY_CAPABLE \
                              | RF4CE_NODECAP_CHANNORM_CAPABLE) /* nwkcNodeCapabilities*/
    #define VENDOR_ID       (0xfff1) /* TestVendor#1 - ZigBeeDoc 094949r00ZB*/
    #define VENDOR_STRING   "NXP"

    /* Required for Binding - Discovery and Pairing */
    #define USER_STRING_SPECIFIED           (1)
    #define NUM_OF_SUPPORTED_DEVICE_TYPES   (1) /* RF4CE_DEVICE_TYPE_MEDIA_CENTER */
    #define RESERVED                        (0)
    #define NUM_OF_SUPPORTED_PROFILES       (1) /* ZRCv1.1 */
    #define NUM_OF_DISCOVERABLE_PROFILES    (1) /* ZRCv1.1 */
    #define USER_STRING_LEN                 (8)
    #define USER_STRING                     "Remote"

    #define MAX_DISCOVERY_REPETITIONS       (4)
    #define MAX_DISCOVERY_DURATION          (6250)
    #define KEY_EXCHANGE_TRANSFER_COUNT     (5)

    #define TIME_BEFORE_SLEEP_IN_100MS      (600) /*In 100 milliseconds */

    #define CERC_CONTROL_PRESSED_CMD_LENGTH (2)
#endif //#if defined(Remote)



/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/*ZRC Command Code*/
typedef enum
{
    E_ZRC_USER_CONTROL_PRESSED     = 0x01,
    E_ZRC_USER_CONTROL_REPEATED    = 0x02,
    E_ZRC_USER_CONTROL_RELEASED    = 0x03,
    E_ZRC_CMD_DISCOVERY_REQUEST    = 0x04,
    E_ZRC_CMD_DISCOVERY_RESPONSE   = 0x05,
} teZRC_CmdCode;

/* CEC Table 27 User Control Codes */
typedef enum
{
    SELECT,
    UP,
    DOWN,
    LEFT,
    RIGHT,
    RIGHT_UP,
    RIGHT_DOWN,
    LEFT_UP,
    LEFT_DOWN,
    ROOT_MENU,
    SETUP_MENU,
    CONTENTS_MENU,
    FAVORITE_MENU,
    EXIT,

    ZERO_DIGIT = 0x20,
    ONE_DIGIT,
    TWO_DIGIT,
    THREE_DIGIT,
    FOUR_DIGIT,
    FIVE_DIGIT,
    SIX_DIGIT,
    SEVEN_DIGIT,
    EIGHT_DIGIT,
    NINE_DIGIT,
    DOT,
    ENTER,
    CLEAR,

    NEXT_FAVORITE = 0x2F,
    CHANNEL_UP,
    CHANNEL_DOWN,
    PREVIOUS_CHANNEL,
    SOUND_SELECT,
    INPUT_SELECT,
    DISPLAY_INFO,
    HELP,
    PAGE_UP,
    PAGE_DOWN,

    POWER = 0x40,
    VOLUME_UP,
    VOLUME_DOWN,
    MUTE,
    PLAY,
    STOP,
    PAUSE,
    RECORD,
    REWIND,
    FAST_FORWARD,
    EJECT,
    FORWARD,
    BACKWARD,
    STOP_RECORD,
    PAUSE_RECORD,

    ANGLE = 0x50,
    SUB_PICTURE,
    VIDEO_ON_DEMAND,
    PROGRAM_GUIDE,
    TIMER_PROGRAMMING,
    INITIAL_CONFIGURATION,
    PLAY_FUNCTION = 0x60,
    PAUSE_PLAY_FUNCTION,
    RECORD_FUNCTION,
    PAUSE_RECORD_FUNCTION,
    STOP_FUNCTION,
    MUTE_FUNCTION,
    RESTORE_VOLUME_FUNCTION,
    TUNE_FUNCTION,
    SELECT_MEDIA_FUNCTION,
    SELECT_AV_INPUT_FUNCTION,
    SELECT_AUDIO_INPUT_FUNCTION,
    POWER_TOGGLE_FUNCTION,
    POWER_OFF_FUNCTION,
    POWER_ON_FUNCTION,

    F1_BLUE = 0x71,
    F2_RED,
    F3_GREEN,
    F4_BLUE,
    F5,
    DATA,
} teRC_CmdCode;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif  /* CONFIG_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
