/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         DioStatus MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBDIOCONFIG_H_INCLUDED
#define  MIBDIOCONFIG_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Dio permament data */
typedef struct
{
	uint32              	u32Direction;
	uint32              	u32Pullup;
	uint32              	u32InterruptEnabled;
	uint32              	u32InterruptEdge;
} tsMibDioConfigPerm;

/* Bulb status temporary data */
typedef struct
{
	uint32 			    	u32DirectionInput;
	uint32 			    	u32DirectionOutput;
	uint32 			    	u32PullupEnable;
	uint32					u32PullupDisable;
	uint32 			    	u32InterruptEnable;
	uint32					u32InterruptDisable;
	uint32 			    	u32InterruptRising;
	uint32					u32InterruptFalling;
} tsMibDioConfigTemp;

/* Network control mib */
typedef struct
{
	/* MIB handles */
	thJIP_Mib 			   	hMib;

	/* PDM record descriptor */
	PDM_tsRecordDescriptor 	sDesc;

	/* Data pointers */
	tsMibDioConfigPerm 	   	sPerm;
	tsMibDioConfigTemp 	   	sTemp;

	/* Other data */
	uint32				  u32NotifyChanged;

} tsMibDioConfig;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
/* Unpatched functions in MibDio.c */
PUBLIC void 		MibDioConfig_vInit(thJIP_Mib        hMibDioConfigInit,
						 		       tsMibDioConfig *psMibDioConfigInit);
PUBLIC void 		MibDioConfig_vRegister(void);
PUBLIC void 		MibDioConfig_vTick(void);
PUBLIC teJIP_Status MibDioConfig_eSetDirection       (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetPullup          (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptEnabled(uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptEdge   (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetDirectionInput  (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetDirectionOutput (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetPullupEnable    (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetPullupDisable   (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptEnable (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptDisable(uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptRising (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status MibDioConfig_eSetInterruptFalling(uint32 u32Val, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBDIOCONFIG_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
