/*****************************************************************************
 *
 * MODULE:              JN-AN-1180 Demo configuration
 *
 * COMPONENT:           $RCSfile: HomeSensorConfig.h,v $
 *
 * VERSION:             $Name:  $
 *
 * REVISION:            $Revision: 1.5 $
 *
 * DATED:               $20012/11/20 15:24:59 $
 *
 * STATUS:              $State: Exp $
 *
 * AUTHOR:
 *
 * DESCRIPTION:
 * Configuration settings for demo system
 */
/****************************************************************************
*
* This software is owned by NXP B.V. and/or its supplier and is protected
* under applicable copyright laws. All rights are reserved. We grant You,
* and any third parties, a license to use this software solely and
* exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142, JN5139].
* You, and any third parties must reproduce the copyright and warranty notice
* and any other legend of ownership on each copy or partial copy of the
* software.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.

* Copyright NXP B.V. 2012. All rights reserved
*

****************************************************************************/

#ifndef  DEMO_CONFIG_INCLUDED
#define  DEMO_CONFIG_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
#include "jendefs.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Number of points in graph of previous values. Must be multiple of 2 */
#define DEMO_HISTORY_LEN                  32
/* Number of endpoints in system */
#define DEMO_ENDPOINTS                    4
/* First byte of payload from coordinator, as frame identity */
#define DEMO_BEACON_IDENTIFIER            0xb5
/* First byte of payload from endpoint, as frame identity */
#define DEMO_ENDPOINT_IDENTIFIER          0x5b
/* PAN ID on which demo operates */
#define DEMO_PAN_ID                       0x0e1c
/* Coordinator short address */
#define DEMO_COORD_ADDR                   0x0e00
/* Endpoint short address base */
#define DEMO_ENDPOINT_ADDR_BASE           0x0e01
/* Channels available */
#define CHANNEL_MIN                       11
#define CHANNEL_MID                       18
#define CHANNEL_MAX                       26
#define DEMO_CHANNEL_BITMAP               0x7fff800

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
typedef enum
{
    E_SENSOR_TEMP = 0,
    E_SENSOR_HTS,
    E_SENSOR_ALS,
    DEMO_SENSOR_LIST_LEN
} teSensor;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif  /* DEMO_CONFIG_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/

