/*****************************************************************************
 *
 * MODULE:              PER Test Slave
 *
 * COMPONENT:           $RCSfile: PerSlave.c,v $
 *
 * VERSION:             $Name: JN5148_alpha_release $
 *
 * REVISION:            $Revision: 1.7 $
 *
 * DATED:               $Date: 2009/02/25 10:41:13 $
 *
 * STATUS:              $State: Exp $
 *
 * AUTHOR:
 *
 * DESCRIPTION:
 *
 * CHANGE HISTORY:
 *
 * $Log: PerSlave.c,v $
 * Revision 1.7  2009/02/25 10:41:13
 * Changed position of watchdog timer disable.
 *
 * Revision 1.3  2009/02/23 16:39:15
 * Changes made for JN5148 release.
 *
 * Revision 1.2  2008/08/07 13:26:41
 * gdb stub removed as not required for x47 hardware debug (jtag)
 *
 * Revision 1.1  2008/05/06 13:57:19
 * Project added to cvs
 *
 */
/****************************************************************************
*
* This software is owned by NXP B.V. and/or its supplier and is protected
* under applicable copyright laws. All rights are reserved. We grant You,
* and any third parties, a license to use this software solely and
* exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142, JN5139].
* You, and any third parties must reproduce the copyright and warranty notice
* and any other legend of ownership on each copy or partial copy of the
* software.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.

* Copyright NXP B.V. 2012. All rights reserved
*/

/****************************************************************************/

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/

#include <jendefs.h>
#include <AppHardwareApi.h>
#include <JPT.h>

#include "LedControl.h"

#include "UartBuffered.h"
#include "Printf.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

#define UART_TO_PC          E_AHI_UART_0            /* Uart to PC           */
#define BAUD_RATE           E_AHI_UART_RATE_38400   /* Baud rate to use     */

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

PRIVATE void vPutC(uint8 u8Data);


/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

tsJPT_SSPT_SlaveState sSlaveData;       /* will hold slave state data */

tsUartFifo sFifo;                       /* TX & RX Buffers for the UART */

uint32 u32RadioMode     = E_JPT_MODE_LOPOWER;
uint32 u32JPT_RadioModes = 0;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

PUBLIC void AppColdStart(void)
{
    volatile int i;

    /* Disable watchdog if enabled by default */
    #ifdef WATCHDOG_ENABLED
    vAHI_WatchdogStop();
    #endif

    /* Initialise the production test API */
    u32JPT_Init();

    /* Initialise the hardware API */
    u32AHI_Init();

    u32JPT_RadioModes = u32JPT_RadioModesAvailable(); /* Get the Modes supported by this device */

    if (u32JPT_RadioModes & (1<<E_JPT_MODE_HIPOWER)){
    /* Initialise the radio - if HI power available use high power -else low poewr*/
         bJPT_RadioInit(E_JPT_MODE_HIPOWER);
    }
    else if (u32JPT_RadioModes & (1<<E_JPT_MODE_LOPOWER)){
    /* Initialise the radio */
         bJPT_RadioInit(E_JPT_MODE_LOPOWER);
    }

    /* Set up the serial console */
    vUartInit(UART_TO_PC, BAUD_RATE, &sFifo);   /* uart for console */
    vInitPrintf((void*)vPutC);

    vLedControl(0, FALSE);
    vLedControl(1, FALSE);

    vLedInitFfd();

    /* Initialise the site survey PER test slave */
    vJPT_SSPT_SlaveInit();

    while(1){

        /* Doze CPU until an interrupt occurs */
        vAHI_CpuDoze();

        /* wait here a while */
        for(i = 0; i < 1000000; i++);

        /* get current PER test state */
        vJPT_SSPT_SlaveGetState(&sSlaveData);

        /* Display status of the test on the UART console and LED's */
        vPrintf("\nChannel = %d\t",sSlaveData.u8Channel);

        switch(sSlaveData.u8Mode){

        case E_JPT_SSPT_MODE_STOPPED:
            vPrintf("Stopped");
            vLedControl(0, TRUE);
            break;

        case E_JPT_SSPT_MODE_RUNNING_ACKS:
            vPrintf("Running (Acks)");
            vLedControl(0, FALSE);
            vLedControl(1, TRUE);
            break;

        case E_JPT_SSPT_MODE_RUNNING_NO_ACKS:
            vPrintf("Running (No Acks)");
            vLedControl(0, FALSE);
            vLedControl(1, FALSE);
            break;

        }

    }

}


PUBLIC void AppWarmStart(void)
{
    AppColdStart();
}

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/

/****************************************************************************
 *
 * NAME:       vPutC
 *
 * DESCRIPTION:
 * Writes characters to the UART connected to the PC
 *
 * PARAMETERS: Name     RW  Usage
 *          u8Data      R   Character to write to the UART
 *
 * RETURNS:
 * void
 *
 ****************************************************************************/

PRIVATE void vPutC(uint8 u8Data)
{
    vUartWrite(UART_TO_PC, u8Data);
}

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
