/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyControl MIB Implementation
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* Standard includes */
#include <string.h>
/* SDK includes */
#include <jendefs.h>
/* Hardware includes */
#include <AppHardwareApi.h>
#include <PeripheralRegs.h>
/* Stack includes */
#include <Api.h>
#include <AppApi.h>
#include <JIP.h>
#include <6LP.h>
#include <AccessFunctions.h>
/* JenOS includes */
#include <dbg.h>
#include <dbg_uart.h>
#include <os.h>
#include <pdm.h>
/* Application device includes */
#include "DeviceDefs.h"
#include "Node.h"
#include "Address.h"
#include "MibSensor.h"
#include "MibOccupancyControl.h"
#include "MibGroup.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/
PRIVATE tsMibOccupancyControl *psMibOccupancyControl;  /* MIB data */

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/****************************************************************************
 *
 * NAME: MibOccupancyControl_vInit
 *
 * DESCRIPTION:
 * Initialises data
 *
 ****************************************************************************/
PUBLIC void MibOccupancyControl_vInit(thJIP_Mib        hMibOccupancyControlInit,
                         	   tsMibOccupancyControl *psMibOccupancyControlInit)
{
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%sMibOccupancyControl_vInit() {%d}", acDebugIndent, sizeof(tsMibOccupancyControl));
    Node_vDebugIndent(DEBUG_MIB_OCCUPANCY_CONTROL);

    /* Valid data pointer ? */
    if (psMibOccupancyControlInit != (tsMibOccupancyControl *) NULL)
    {
        /* Take copy of pointer to data */
        psMibOccupancyControl = psMibOccupancyControlInit;
        /* Take a copy of the MIB handle */
        psMibOccupancyControl->hMib = hMibOccupancyControlInit;

        /* Load Dio mib data */
        (void) PDM_eLoadRecord(&psMibOccupancyControl->sDesc,
							   (uint16)(MIB_ID_OCCUPANCY_CONTROL & 0xFFFF),
                               (void *) &psMibOccupancyControl->sPerm,
                               sizeof(psMibOccupancyControl->sPerm),
                               FALSE);
		/* Debug */
		DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%sPDM_eLoadRecord(OccupancyControl) = %d", acDebugIndent, psMibOccupancyControl->sDesc.eState);

		/* Building Group MIB ? */
		#if MK_BLD_MIB_GROUP
		{
			/* Was the group's MIB PDM not recovered ? */
			if (MibGroup_ePdmStateInit() != PDM_RECOVERY_STATE_RECOVERED)
			{
				in6_addr sAddr;

				/* Build "All Occupancy Sensors" group address */
				Address_vBuildGroup(&sAddr, NULL, (uint16)(MIB_ID_OCCUPANCY_CONTROL & 0xffff));
				/* Make a dummy call to get it in the group address array */
				bJIP_GroupCallback(E_JIP_GROUP_JOIN, &sAddr);
			}
		}
		#endif
    }

    /* Debug */
    Node_vDebugOutdent(DEBUG_MIB_OCCUPANCY_CONTROL);
}

/****************************************************************************
 *
 * NAME: MibOccupancyControl_vRegister
 *
 * DESCRIPTION:
 * Registers MIB
 *
 ****************************************************************************/
PUBLIC void MibOccupancyControl_vRegister(void)
{
    teJIP_Status eStatus;

    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%sMibOccupancyControl_vRegister()", acDebugIndent);
    Node_vDebugIndent(DEBUG_MIB_OCCUPANCY_CONTROL);

    /* Register MIB */
    eStatus = eJIP_RegisterMib(psMibOccupancyControl->hMib);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%seJIP_RegisterMib(OccupancyControl)=%d", acDebugIndent, eStatus);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyControl->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%sPDM_vSaveRecord(OccupancyControl) = %d", acDebugIndent, psMibOccupancyControl->sDesc.eState);

    /* Debug */
    Node_vDebugOutdent(DEBUG_MIB_OCCUPANCY_CONTROL);
}

/****************************************************************************
 *
 * NAME: MibOccupancyControl_vTick
 *
 * DESCRIPTION:
 * Timer function
 *
 ****************************************************************************/
PUBLIC void MibOccupancyControl_vTick(void)
{
	/* Are there any variable notifications pending ? */
	if ((psMibOccupancyControl->u32NotifyChanged & VAR_MASK_OCCUPANCY_CONTROL) != 0)
	{
		/* Use common function to output notifications */
		Node_vJipNotifyChanged(psMibOccupancyControl->hMib, &psMibOccupancyControl->u32NotifyChanged, VAR_MASK_OCCUPANCY_CONTROL, VAR_COUNT_OCCUPANCY_CONTROL);
	}
}

/****************************************************************************
 *
 * NAME: MibOccupancyControl_eSetMode
 *
 * DESCRIPTION:
 * Generic set data callback
 *
 ****************************************************************************/
PUBLIC teJIP_Status MibOccupancyControl_eSetMode(uint8 u8Val, void *pvCbData)
{
	teJIP_Status eReturn;

	/* Call standard function */
	eReturn = eSetUint8(u8Val, pvCbData);

    /* Make sure permament data is saved */
    PDM_vSaveRecord(&psMibOccupancyControl->sDesc);
    /* Debug */
    DBG_vPrintf(DEBUG_MIB_OCCUPANCY_CONTROL, "\n%sMibOccupancyControl_eSetMode(%d) = %d { PDM_vSaveRecord(OccupancyControl) = %d }", acDebugIndent, u8Val, eReturn, psMibOccupancyControl->sDesc.eState);

	return eReturn;
}

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
