/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyConfig MIB Declaration
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "Address.h"
#include "MibSensor.h"
#include "MibOccupancyConfig.h"

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibOccupancyConfig sMibOccupancyConfig =
{
	/* Permament data defaults - may be overridden from flash during initialisation */
	.sPerm.u8Sensitivity       = 255,	/* Full sensitivity */
	.sPerm.u32UnoccupiedDelay  = 3000,	/* 30 seconds */
	.sPerm.u8StateVarIdx       = 255,	/* Most likely invalid value to prevent incorrect writes */
	.sPerm.u16StateRefresh     = 3000	/* 30 seconds */
};

/****************************************************************************/
/***        MIB declaration                                               ***/
/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_OCCUPANCY_CONFIG

#define DECLARE_MIB
#include "MibOccupancyConfigDef.h"
JIP_START_DECLARE_MIB(OccupancyConfigDef, OccupancyConfig)
JIP_CALLBACK(Sensitivity,     MibOccupancyConfig_eSetUint8,   vGetUint8,    &sMibOccupancyConfig.sPerm.u8Sensitivity     )
JIP_CALLBACK(UnoccupiedDelay, MibOccupancyConfig_eSetUint32,  vGetUint32,   &sMibOccupancyConfig.sPerm.u32UnoccupiedDelay)
JIP_CALLBACK(OccupiedDelay,   MibOccupancyConfig_eSetUint16,  vGetUint16,   &sMibOccupancyConfig.sPerm.u16OccupiedDelay  )
JIP_CALLBACK(OccupiedEvents,  MibOccupancyConfig_eSetUint8,   vGetUint8,    &sMibOccupancyConfig.sPerm.u8OccupiedEvents  )
JIP_CALLBACK(StateMibId,      MibOccupancyConfig_eSetUint32,  vGetUint32,   &sMibOccupancyConfig.sPerm.u32StateMibId     )
JIP_CALLBACK(StateVarIdx,     MibOccupancyConfig_eSetUint8,   vGetUint8,    &sMibOccupancyConfig.sPerm.u8StateVarIdx     )
JIP_CALLBACK(StateAddress,    MibOccupancyConfig_eSetAddress, Address_vGet, &sMibOccupancyConfig.sPerm.sStateAddress     )
JIP_CALLBACK(StateRefresh,    MibOccupancyConfig_eSetUint16,  vGetUint16,   &sMibOccupancyConfig.sPerm.u16StateRefresh   )
JIP_END_DECLARE_MIB(OccupancyConfig, hOccupancyConfig)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibOccupancyConfig = &sOccupancyConfigMib.sMib;

#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibOccupancyConfig = NULL;

#endif

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
