/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         IlluminanceControl MIB Declaration
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "MibSensor.h"
#include "MibIlluminanceControl.h"

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibIlluminanceControl sMibIlluminanceControl =
{
	/* Permament data defaults - may be overridden from flash during initialisation */
	.sPerm.u8Mode       = VAR_VAL_ILLUMINANCE_CONTROL_MODE_ON,
	.sPerm.u16LuxTarget = 750,
	.sPerm.u16LuxBand   = 50
};

/****************************************************************************/
/***        MIB declaration                                               ***/
/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_ILLUMINANCE_CONTROL

#define DECLARE_MIB
#include "MibIlluminanceControlDef.h"
JIP_START_DECLARE_MIB(IlluminanceControlDef, IlluminanceControl)
JIP_CALLBACK(Mode,            MibIlluminanceControl_eSetMode,            vGetUint8,  &sMibIlluminanceControl.sPerm.u8Mode)
JIP_CALLBACK(SceneId,         MibIlluminanceControl_eSetSceneId,         vGetUint16, &sMibIlluminanceControl.sPerm.u16SceneId)
JIP_CALLBACK(LuxTarget,       MibIlluminanceControl_eSetUint16,          vGetUint16, &sMibIlluminanceControl.sPerm.u16LuxTarget)
JIP_CALLBACK(LuxBand,         MibIlluminanceControl_eSetUint16,          vGetUint16, &sMibIlluminanceControl.sPerm.u16LuxBand)
JIP_CALLBACK(LuxAdjust,       MibIlluminanceControl_eSetLuxAdjust,       vGetUint8,  &sMibIlluminanceControl.sTemp.u8LuxAdjust)
JIP_CALLBACK(LuxTargetChange, MibIlluminanceControl_eSetLuxTargetChange, vGetInt16,  &sMibIlluminanceControl.sTemp.i16LuxTargetChange)
JIP_CALLBACK(LuxBandChange,   MibIlluminanceControl_eSetLuxBandChange,   vGetInt16,  &sMibIlluminanceControl.sTemp.i16LuxBandChange)
JIP_END_DECLARE_MIB(IlluminanceControl, hIlluminanceControl)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibIlluminanceControl = &sIlluminanceControlMib.sMib;

#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibIlluminanceControl = NULL;

#endif

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
