/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         Sensor MIB IDs, indicies and values
 */
/*****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBSENSOR_H_INCLUDED
#define  MIBSENSOR_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Occupancy MIBs *******************************************/

/* OccupancyStatus MIB */
#define MIB_ID_OCCUPANCY_STATUS						0xFFFFFE30
#define VAR_IX_OCCUPANCY_STATUS_OCCUPANCY          			 0
#define VAR_IX_OCCUPANCY_STATUS_SENSOR_TYPE        			 1
#define VAR_MASK_OCCUPANCY_STATUS					0x00000003
#define VAR_COUNT_OCCUPANCY_STATUS							 2

/* OccupancyConfig MIB */
#define MIB_ID_OCCUPANCY_CONFIG						0xFFFFFE31
#define VAR_IX_OCCUPANCY_CONFIG_SENSITIVITY					 0
#define VAR_IX_OCCUPANCY_CONFIG_UNOCCUPIED_DELAY			 1
#define VAR_IX_OCCUPANCY_CONFIG_OCCUPIED_DELAY				 2
#define VAR_IX_OCCUPANCY_CONFIG_OCCUPIED_EVENTS				 3
#define VAR_IX_OCCUPANCY_CONFIG_STATE_MIB_ID 				 4
#define VAR_IX_OCCUPANCY_CONFIG_STATE_VAR_IDX                5
#define VAR_IX_OCCUPANCY_CONFIG_STATE_ADDRESS				 6
#define VAR_IX_OCCUPANCY_CONFIG_STATE_REFRESH				 7
#define VAR_MASK_OCCUPANCY_CONFIG					0x000000ff
#define VAR_COUNT_OCCUPANCY_CONFIG							 8

/* OccupancyMonitor MIB */
#define MIB_ID_OCCUPANCY_MONITOR					0xFFFFFE32
#define VAR_IX_OCCUPANCY_MONITOR_MODE						 0
#define VAR_IX_OCCUPANCY_MONITOR_TIMEOUT					 1
#define VAR_IX_OCCUPANCY_MONITOR_OCCUPANCY  				 2
#define VAR_IX_OCCUPANCY_MONITOR_ENABLED					 3
#define VAR_IX_OCCUPANCY_MONITOR_OCCUPIED					 4
#define VAR_IX_OCCUPANCY_MONITOR_UNOCCUPIED					 5
#define VAR_IX_OCCUPANCY_MONITOR_MAX_DEVICES				 6
#define VAR_IX_OCCUPANCY_MONITOR_DEVICE_TABLE				 7
#define VAR_MASK_OCCUPANCY_MONITOR					0x000000ff
#define VAR_COUNT_OCCUPANCY_MONITOR							 8

#define VAR_VAL_OCCUPANCY_MONITOR_MODE_OFF			  		 0
#define VAR_VAL_OCCUPANCY_MONITOR_MODE_ON			  		 1

/* OccupancyControl MIB */
#define MIB_ID_OCCUPANCY_CONTROL					0xFFFFFE34
#define VAR_IX_OCCUPANCY_CONTROL_MODE  						 0
#define VAR_MASK_OCCUPANCY_CONTROL					0x00000001
#define VAR_COUNT_OCCUPANCY_CONTROL							 1

#define VAR_VAL_OCCUPANCY_CONTROL_MODE_OFF			  		 0
#define VAR_VAL_OCCUPANCY_CONTROL_MODE_ON			  		 1

/* Illuminance MIBs *****************************************/

/* IlluminanceStatus MIB */
#define MIB_ID_ILLUMINANCE_STATUS					0xFFFFFE38
#define VAR_IX_ILLUMINANCE_STATUS_LUX_CURRENT          		 0
#define VAR_IX_ILLUMINANCE_STATUS_TARGET_STATUS        		 1
#define VAR_IX_ILLUMINANCE_STATUS_SENSOR_TYPE				 2
#define VAR_IX_ILLUMINANCE_STATUS_LUX_MIN					 3
#define VAR_IX_ILLUMINANCE_STATUS_LUX_MAX					 4
#define VAR_IX_ILLUMINANCE_STATUS_LUX_TOLERANCE				 5
#define VAR_MASK_ILLUMINANCE_STATUS					0x0000003f
#define VAR_COUNT_ILLUMINANCE_STATUS						 6

#define VAR_VAL_ILLUMINANCE_STATUS_TARGET_STATUS_DISABLED	 0
#define VAR_VAL_ILLUMINANCE_STATUS_TARGET_STATUS_OK			 1
#define VAR_VAL_ILLUMINANCE_STATUS_TARGET_STATUS_LOW		 2
#define VAR_VAL_ILLUMINANCE_STATUS_TARGET_STATUS_HIGH		 3

/* IlluminanceConfig MIB */
#define MIB_ID_ILLUMINANCE_CONFIG					0xFFFFFE39
#define VAR_IX_ILLUMINANCE_CONFIG_STATE_MIB_ID 				 0
#define VAR_IX_ILLUMINANCE_CONFIG_STATE_VAR_IDX              1
#define VAR_IX_ILLUMINANCE_CONFIG_STATE_ADDRESS				 2
#define VAR_IX_ILLUMINANCE_CONFIG_STATE_REFRESH				 3
#define VAR_MASK_ILLUMINANCE_CONFIG					0x0000000f
#define VAR_COUNT_ILLUMINANCE_CONFIG						 4

/* IlluminanceScene MIB */
#define MIB_ID_ILLUMINANCE_SCENE					0xFFFFFE3B
#define VAR_IX_ILLUMINANCE_SCENE_ADD_SCENE_ID		         0
#define VAR_IX_ILLUMINANCE_SCENE_DEL_SCENE_ID		         1
#define VAR_IX_ILLUMINANCE_SCENE_SET_SCENE			         2
#define VAR_IX_ILLUMINANCE_SCENE_SCENE_TABLE		         3
#define VAR_MASK_ILLUMINANCE_SCENE					0x0000000f
#define VAR_COUNT_ILLUMINANCE_SCENE							 4

/* IlluminanceControl MIB */
#define MIB_ID_ILLUMINANCE_CONTROL					0xFFFFFE3C
#define VAR_IX_ILLUMINANCE_CONTROL_MODE  					 0
#define VAR_IX_ILLUMINANCE_CONTROL_SCENE_ID					 1
#define VAR_IX_ILLUMINANCE_CONTROL_LUX_TARGET				 2
#define VAR_IX_ILLUMINANCE_CONTROL_LUX_BAND      		     3
#define VAR_IX_ILLUMINANCE_CONTROL_LUX_ADJUST				 4
#define VAR_IX_ILLUMINANCE_CONTROL_LUX_TARGET_CHANGE		 5
#define VAR_IX_ILLUMINANCE_CONTROL_LUX_BAND_CHANGE			 6
#define VAR_MASK_ILLUMINANCE_CONTROL				0x0000007f
#define VAR_COUNT_ILLUMINANCE_CONTROL						 7

#define VAR_VAL_ILLUMINANCE_CONTROL_MODE_OFF		  		 0
#define VAR_VAL_ILLUMINANCE_CONTROL_MODE_ON			  		 1

#define VAR_VAL_ILLUMINANCE_CONTROL_LUX_ADJUST_NONE			 0
#define VAR_VAL_ILLUMINANCE_CONTROL_LUX_ADJUST_TARGET_DOWN	 1
#define VAR_VAL_ILLUMINANCE_CONTROL_LUX_ADJUST_TARGET_UP	 2
#define VAR_VAL_ILLUMINANCE_CONTROL_LUX_ADJUST_BAND_NARROW	 3
#define VAR_VAL_ILLUMINANCE_CONTROL_LUX_ADJUST_BAND_WIDEN	 4

/* Combined Bulb MIBs ***************************************/

/* OccIllBulbConfig MIB */
#define MIB_ID_OCC_ILL_BULB_CONFIG					0xFFFFFE3F
#define VAR_IX_OCC_ILL_BULB_CONFIG_MODE  		 			 0
#define VAR_IX_OCC_ILL_BULB_CONFIG_LUMINANCE_DELTA			 1
#define VAR_IX_OCC_ILL_BULB_CONFIG_ADJUST_INTERVAL			 2
#define VAR_IX_OCC_ILL_BULB_CONFIG_REFRESH_INTERVAL			 3
#define VAR_IX_OCC_ILL_BULB_CONFIG_ADDRESS					 4
#define VAR_MASK_OCC_ILL_BULB_CONFIG				0x0000001f
#define VAR_COUNT_OCC_ILL_BULB_CONFIG						 5

#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_OFF		  		 0
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_OCCUPANCY	  		 1
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_ILLUMINANCE  		 2
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_OCC_ILL_AUTO	 	 3
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_OCC_ILL_MAX	 	 4
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_ALWAYS_OFF		 	 5
#define VAR_VAL_OCC_ILL_BULB_CONFIG_MODE_ALWAYS_ON		 	 6

#if defined __cplusplus
}
#endif

#endif  /* MIBSENSOR_H_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
