/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccupancyStatus MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBOCCUPANCYSTATUS_H_INCLUDED
#define  MIBOCCUPANCYSTATUS_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Bulb status temporary data */
typedef struct
{
	uint8              	u8Occupancy;
	uint8              	u8SensorType;
} tsMibOccupancyStatusTemp;

/* Network control mib */
typedef struct
{
	/* MIB handles */
	thJIP_Mib 			   		hMib;

	/* Data pointers */
	tsMibOccupancyStatusTemp  	sTemp;

	/* Pointers to other MIBs */
	void  					  *pvMibOccupancyConfig;
	void 					  *pvMibOccupancyControl;

	/* Other data */
	bool_t						bRead; 				/* Most recent raw reading from sensor */
	uint32					  u32UnoccupiedTimer; 	/* Timer for entering unoccupied state */
	uint16					  u16OccupiedTimer;		/* Timer for entering occupied state */
	uint8					   u8OccupiedEvents;	/* Counter of events for entering occupied state */
	uint16					  u16StateRefreshTimer;	/* State tranmission refresh timer */
   	uint32					  u32NotifyChanged;		/* Trap notification flags */
   	bool_t						bTxState;			/* Transmit occupancy state flag */

} tsMibOccupancyStatus;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void MibOccupancyStatus_vInit(thJIP_Mib         		 hMibOccupancyStatusInit,
                               		 tsMibOccupancyStatus  *psMibOccupancyStatusInit,
                               		 void  				   *pvMibOccupancyConfigInit,
                               		 void 				   *pvMibOccupancyControlInit);
PUBLIC void MibOccupancyStatus_vRegister(void);
PUBLIC void MibOccupancyStatus_vTick(void);
PUBLIC void MibOccupancyStatus_vAppTimer100ms(void);
PUBLIC void MibOccupancyStatus_vQueueTxState(bool_t bImmediate);

#if defined __cplusplus
}
#endif

#endif  /* MIBOCCUPANCYSTATUS_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
