/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         OccIllBulbConfig MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBOCCILLBULBCONFIG_H_INCLUDED
#define  MIBOCCILLBULBCONFIG_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Dio permament data */
typedef struct
{
	uint8     u8Mode;
	uint8     u8LuminanceDelta;
	uint16   u16AdjustInterval;
	uint16   u16RefreshInterval;
	in6_addr   sAddress;
} tsMibOccIllBulbConfigPerm;

/* Network control mib */
typedef struct
{
	/* MIB handles */
	thJIP_Mib 			   		hMib;

	/* PDM record descriptor */
	PDM_tsRecordDescriptor 		sDesc;

	/* Data pointers */
	tsMibOccIllBulbConfigPerm	sPerm;

	/* Pointers to other MIBs */
	void  					  *pvMibOccupancyStatus;
	void  					  *pvMibOccupancyMonitor;
	void 					  *pvMibOccupancyControl;
	void  					  *pvMibIlluminanceStatus;
	void 					  *pvMibIlluminanceControl;

	/* Other data */
	uint32					   u32IlluminanceReading;	/* Last processed illuminance reading */
	uint16					   u16AdjustTimer;			/* Adjustment timer */
	uint16					   u16RefreshTimer;			/* Refresh timer */
	uint8 						u8BulbControlMode;		/* Current BulbControl Mode */
	uint8 						u8BulbControlLumTarget;	/* Current BulbControl LumTarget */
	uint8                       u8ModeTick;				/* Used to detect mode changes in tick function */
	bool_t						 bTxBulb;				/* Transmit to bulbs flag */

} tsMibOccIllBulbConfig;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void 		MibOccIllBulbConfig_vInit(thJIP_Mib        hMibOccIllBulbConfigInit,
						 		       tsMibOccIllBulbConfig *psMibOccIllBulbConfigInit,
   			                      	   void					 *pvMibOccupancyStatusInit,
   			                      	   void					 *pvMibOccupancyMonitorInit,
            		             	   void					 *pvMibOccupancyControlInit,
                    		     	   void					 *pvMibIlluminanceStatusInit,
                         			   void					 *pvMibIlluminanceControlInit);
PUBLIC void 		MibOccIllBulbConfig_vRegister(void);
PUBLIC void 		MibOccIllBulbConfig_vTick(void);
PUBLIC void 		MibOccIllBulbConfig_vAppTimer100ms(void);
PUBLIC bool_t 		MibOccIllBulbConfig_bOccupancy(uint8 u8Occupancy);
PUBLIC bool_t 		MibOccIllBulbConfig_bIlluminanceAuto(uint8 u8TargetStatus);
PUBLIC bool_t 		MibOccIllBulbConfig_bIlluminanceMax(uint8 u8TargetStatus);
PUBLIC void 		MibOccIllBulbConfig_vRefreshIntervalUpdate(void);
PUBLIC void 		MibOccIllBulbConfig_vQueueTxBulb(bool_t bImmediate);
PUBLIC teJIP_Status MibOccIllBulbConfig_eSetUint8(uint8 u8Val, void *pvCbData);
PUBLIC teJIP_Status MibOccIllBulbConfig_eSetUint16(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status MibOccIllBulbConfig_eSetAddress(const uint8 *pu8Val, uint8 u8Len, void *pvCbData);
PUBLIC void 		MibOccIllBulbConfig_vGetAddress(thJIP_Packet hPacket, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBOCCILLBULBCONFIG_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
