/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         IlluminanceStatus MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBILLUMINANCESTATUS_H_INCLUDED
#define  MIBILLUMINANCESTATUS_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Bulb status temporary data */
typedef struct
{
	uint16              	  u16LuxCurrent;
	uint8              		   u8TargetStatus;
	uint8              	       u8SensorType;
	uint16              	  u16LuxMin;
	uint16              	  u16LuxMax;
	uint16              	  u16LuxTolerance;
} tsMibIlluminanceStatusTemp;

/* Network control mib */
typedef struct
{
	/* MIB handles */
	thJIP_Mib 			   		hMib;

	/* Data pointers */
	tsMibIlluminanceStatusTemp	sTemp;

	/* Pointers to other MIBs */
	void 					  *pvMibIlluminanceConfig;
	void 					  *pvMibIlluminanceControl;

	/* Other data */
	uint8 					   u8Mode;				/* Local copy of IlluminanceControl Mode */
	bool_t					    bLuxCurrentChanged;	/* Lux Current changed flag to limit notifications */
	uint32					  u32Reading;			/* Occupancy reading count */
	uint16					  u16StateRefreshTimer;	/* State tranmission refresh timer */
   	uint32					  u32NotifyChanged;		/* Trap notification flags */
   	bool_t						bTxState;			/* Transmit occupancy state flag */

} tsMibIlluminanceStatus;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void MibIlluminanceStatus_vInit(thJIP_Mib         	  hMibIlluminanceStatusInit,
                               		 tsMibIlluminanceStatus *psMibIlluminanceStatusInit,
                               		 void  				    *pvMibIlluminanceConfigInit,
									 void 				    *pvMibIlluminanceControlInit);
PUBLIC void MibIlluminanceStatus_vRegister(void);
PUBLIC void MibIlluminanceStatus_vAppTimer100ms(void);
PUBLIC void MibIlluminanceStatus_vTick(void);
PUBLIC void MibIlluminanceStatus_vQueueTxState(bool_t bImmediate);
#ifdef MK_BLD_NODE_TYPE_END_DEVICE
PUBLIC void MibIlluminanceStatus_vResume(void);
PUBLIC void MibIlluminanceStatus_vSleep(void);
#endif

#if defined __cplusplus
}
#endif

#endif  /* MIBILLUMINANCESTATUS_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
