/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         IlluminanceControl MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBILLUMINANCECONTROL_H_INCLUDED
#define  MIBILLUMINANCECONTROL_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
#include <JIP.h>
#include <6LP.h>
/* Application common includes */
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Constants */
#define MIB_ILLUMINANCE_CONTROL_LUX_TARGET_ADJUST	5
#define MIB_ILLUMINANCE_CONTROL_LUX_BAND_ADJUST		1
#define MIB_ILLUMINANCE_CONTROL_LUX_BAND_MIN	   10
#define MIB_ILLUMINANCE_CONTROL_LUX_BAND_MAX	  150

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Permament data */
typedef struct
{
	uint8              			u8Mode;
	uint16              		u16SceneId;
	uint16              	  u16LuxTarget;
	uint16              	  u16LuxBand;
} tsMibIlluminanceControlPerm;

/* Temporary data */
typedef struct
{
	uint8              			u8LuxAdjust;
	int16              	  		i16LuxTargetChange;
	int16              	  	    i16LuxBandChange;
} tsMibIlluminanceControlTemp;

/* Network control mib */
typedef struct
{
	/* MIB handles */
	thJIP_Mib 			   		hMib;

	/* PDM record descriptor */
	PDM_tsRecordDescriptor 		sDesc;

	/* Data pointers */
	tsMibIlluminanceControlPerm	sPerm;
	tsMibIlluminanceControlTemp	sTemp;

	/* Other MIB pointers */
	void 					  *pvMibIlluminanceStatus;
	void 					  *pvMibIlluminanceScene;

	/* Other data */
	bool_t   			   		bSaveRecord;
	bool_t						bJoined;
	uint32					  u32NotifyChanged;		/* Trap notification flags */

} tsMibIlluminanceControl;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
/* Unpatched functions in MibIlluminanceControl.c */
PUBLIC void 				MibIlluminanceControl_vInit(thJIP_Mib   hMibIlluminanceControlInit,
								 		 tsMibIlluminanceControl  *psMibIlluminanceControlInit,
			                         	 void 				      *pvMibIlluminanceStatusInit,
			                         	 void 				      *pvMibIlluminanceSceneInit);
PUBLIC void 				MibIlluminanceControl_vRegister(void);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetMode(uint8 u8Val, void *pvCbData);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetSceneId(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetUint16(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetLuxAdjust(uint8 u8Val, void *pvCbData);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetLuxTargetChange(int16 i16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibIlluminanceControl_eSetLuxBandChange(int16 i16Val, void *pvCbData);
#ifndef MK_BLD_NODE_TYPE_END_DEVICE
PUBLIC void 				MibIlluminanceControl_vTick(void);
#endif

#if defined __cplusplus
}
#endif

#endif  /* MIBILLUMINANCECONTROL_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
