/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         NwkSecurity MIB - Declaration
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "MibCommon.h"
#include "MibNwkSecurity.h"

/****************************************************************************/
/***        External Variables                                            ***/
/****************************************************************************/
extern uint16 u16MibNwkSecurityPatchRejoin;					/* Rejoin timer */

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibNwkSecurity sMibNwkSecurity;

/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_NWK_SECURITY

#define DECLARE_MIB
#include "MibNwkSecurityDef.h"

JIP_START_DECLARE_MIB(NwkSecurityDef, NwkSecurity)
JIP_CALLBACK(KeyNetwork,    MibNwkSecurity_eSetKey, 	MibNwkSecurity_vGetKey, &sMibNwkSecurity.sPerm.asSecurityKey[0])
JIP_CALLBACK(KeyGateway,    MibNwkSecurity_eSetKey, 	MibNwkSecurity_vGetKey, &sMibNwkSecurity.sPerm.asSecurityKey[1])
JIP_CALLBACK(KeyStandalone, MibNwkSecurity_eSetKey, 	MibNwkSecurity_vGetKey, &sMibNwkSecurity.sPerm.asSecurityKey[2])
JIP_CALLBACK(Channel, 		NULL,			 		 	vGetUint8, 			 	&sMibNwkSecurity.sPerm.u8Channel)
JIP_CALLBACK(PanId, 		NULL,			 		 	vGetUint16, 		 	&sMibNwkSecurity.sPerm.u16PanId)
JIP_CALLBACK(Rejoin, 		MibNwkSecurity_eSetRejoin,	vGetUint16, 		 	&sMibNwkSecurity.sTemp.u16Rejoin)
JIP_END_DECLARE_MIB(NwkSecurity, hNwkSecurity)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibNwkSecurity = &sNwkSecurityMib.sMib;

#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibNwkSecurity = NULL;

#endif
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
