/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         ColourControl MIB Declaration
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Stack includes */
#include <JIP.h>
#include <AccessFunctions.h>
/* Application common includes */
#include "MibColour.h"
#include "MibColourControl.h"
/* Application colour conversion includes */
#include "ColourConversion.h"

/****************************************************************************/
/***        MIB structure                                                 ***/
/****************************************************************************/
PUBLIC tsMibColourControl sMibColourControl;

/****************************************************************************/
/***        MIB declaration                                               ***/
/****************************************************************************/
/* Registering MIB ? */
#if MK_REG_MIB_COLOUR_CONTROL

#define DECLARE_MIB
#include "MibColourControlDef.h"

JIP_START_DECLARE_MIB(ColourControlDef, ColourControl)
JIP_CALLBACK(Mode         ,	MibColourControl_eSetMode			, vGetUint8 , &sMibColourControl.sPerm.u8Mode          )
JIP_CALLBACK(SceneId      ,	MibColourControl_eSetSceneId		, vGetUint16, &sMibColourControl.sPerm.u16SceneId      )
JIP_CALLBACK(XYTarget     ,	MibColourControl_eSetXYTarget       , vGetUint32, &sMibColourControl.sPerm.u32XYTarget     )
JIP_CALLBACK(XYCurrent    , MibColourControl_eSetXYCurrent      , vGetUint32, &sMibColourControl.sTemp.u32XYCurrent    )
JIP_CALLBACK(XTarget      ,	MibColourControl_eSetXTarget	 	, vGetUint16, &sMibColourControl.sTemp.u16XTarget      )
JIP_CALLBACK(YTarget      , MibColourControl_eSetYTarget	 	, vGetUint16, &sMibColourControl.sTemp.u16YTarget      )
JIP_CALLBACK(HueTarget    , MibColourControl_eSetHueTarget	 	, vGetUint16, &sMibColourControl.sTemp.u16HueTarget    )
JIP_CALLBACK(HueChange    ,	MibColourControl_eSetHueChange 		, vGetInt16 , &sMibColourControl.sTemp.i16HueChange    )
JIP_CALLBACK(SatTarget    ,	MibColourControl_eSetSatTarget 		, vGetUint8 , &sMibColourControl.sTemp.u8SatTarget     )
JIP_CALLBACK(SatChange    ,	MibColourControl_eSetSatChange 		, vGetInt8  , &sMibColourControl.sTemp.i8SatChange     )
JIP_CALLBACK(HueSatTarget , MibColourControl_eSetHueSatTarget	, vGetUint32, &sMibColourControl.sTemp.u32HueSatTarget )
JIP_CALLBACK(HueSatCurrent,	MibColourControl_eSetHueSatCurrent  , vGetUint32, &sMibColourControl.sTemp.u32HueSatCurrent)
JIP_CALLBACK(CctTarget    , MibColourControl_eSetCctTarget		, vGetUint16, &sMibColourControl.sTemp.u16CctTarget    )
JIP_CALLBACK(CctCurrent   , MibColourControl_eSetCctCurrent		, vGetUint16, &sMibColourControl.sTemp.u16CctCurrent   )
JIP_CALLBACK(CctChange    , MibColourControl_eSetCctChange 		, vGetInt16 , &sMibColourControl.sTemp.i16CctChange    )
JIP_CALLBACK(RedCurrent   , NULL    					 	    , vGetUint8 , &sMibColourControl.sTemp.u8RedCurrent    )
JIP_CALLBACK(GreenCurrent , NULL    					 	    , vGetUint8 , &sMibColourControl.sTemp.u8GreenCurrent  )
JIP_CALLBACK(BlueCurrent  , NULL    					 	    , vGetUint8 , &sMibColourControl.sTemp.u8BlueCurrent   )
JIP_END_DECLARE_MIB(ColourControl, hColourControl)

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibColourControl   = &sColourControlMib.sMib;

#else

/* Public MIB handle */
PUBLIC const thJIP_Mib hMibColourControl   = NULL;

#endif

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
