/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         ColourControl MIB Definition
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#undef MIB_HEADER
#define MIB_HEADER "MibColourControlDef.h"

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* Stack includes */
#include <jip_define_mib.h>
/* Application common includes */
#include "MibColour.h"

/****************************************************************************/
/***        MIB definition                                                ***/
/****************************************************************************/
START_DEFINE_MIB(MIB_ID_COLOUR_CONTROL, ColourControlDef)
/*         ID 					   		 	 	  Type    Name  	   	 Disp  Flags Access 	            Cache Security */
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_MODE			, UINT8 , Mode         , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_SCENE_ID		, UINT16, SceneId      , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_XY_TARGET		, UINT32, XYTarget     , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_XY_CURRENT		, UINT32, XYCurrent    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_X_TARGET		, UINT16, XTarget      , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_Y_TARGET		, UINT16, YTarget      , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_HUE_TARGET		, UINT16, HueTarget    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_HUE_CHANGE		, INT16 , HueChange    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_SAT_TARGET		, UINT8 , SatTarget    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_SAT_CHANGE		, INT8  , SatChange    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_HUE_SAT_TARGET , UINT32, HueSatTarget , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_HUE_SAT_CURRENT, UINT32, HueSatCurrent, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_CCT_TARGET		, UINT16, CctTarget    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_CCT_CURRENT	, UINT16, CctCurrent   , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_CCT_CHANGE		, INT16 , CctChange    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_RED_CURRENT	, UINT8 , RedCurrent   , NULL, 0,    (READ         | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_GREEN_CURRENT	, UINT8 , GreenCurrent , NULL, 0,    (READ         | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONTROL_BLUE_CURRENT	, UINT8 , BlueCurrent  , NULL, 0,    (READ         | TRAP), NONE, NONE)
END_DEFINE_MIB(ColourControlDef)

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
