/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         ColourControl MIB Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBCOLOURCONTROL_H_INCLUDED
#define  MIBCOLOURCONTROL_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
/* Application common includes */
#include "Table.h"
/* Application colour conversion includes */
#include "ColourConversion.h"
#include "ColourTransition.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Colour space defines */
#define MIB_COLOUR_CONTROL_CCT_MODE_OFF   0 /* Not on CCT line */
#define MIB_COLOUR_CONTROL_CCT_MODE_ON    1 /* On CCT line */
#define MIB_COLOUR_CONTROL_CCT_MODE_TRANS 2 /* Transitioning to CCT line */

/* Transition defines */
#define MIB_COLOUR_CONTROL_RGB_INTERPOLATION_STEPS_POWER_OF_TWO 3

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Colour status permament data */
typedef struct
{
	uint8   u8Mode;
	uint16 u16SceneId;
	uint32 u32XYTarget;
} tsMibColourControlPerm;

/* Colour control temporary data */
typedef struct
{
	uint16 u16XTarget;
	uint16 u16YTarget;
	uint32 u32XYCurrent;
	uint16 u16XCurrent;
	uint16 u16YCurrent;
	uint16 u16HueTarget;
	int16  i16HueChange;
	uint8   u8SatTarget;
	int8    i8SatChange;
	uint32 u32HueSatTarget;
	uint32 u32HueSatCurrent;
	uint16 u16HueCurrent;
	uint8   u8SatCurrent;
	uint16 u16CctTarget;
	uint16 u16CctCurrent;
	int16  i16CctChange;
	uint8   u8RedCurrent;
	uint8   u8GreenCurrent;
	uint8   u8BlueCurrent;
} tsMibColourControlTemp;

/* Network control mib */
typedef struct
{
	/* PDM record descriptor */
	PDM_tsRecordDescriptor  sDesc;

	/* Data pointers */
	tsMibColourControlPerm sPerm;
	tsMibColourControlTemp sTemp;

	/* Other data */
	bool_t    bSaveRecord;
	uint32  u32NotifyChanged;
	uint8    u8Discard;
	uint8    u8CctMode;
	uint16	u16Random;
	uint32 	u32TestMode_XYTarget;
	uint8 	 u8TestMode_BulbControlLumTarget;
	uint8 	 u8TestMode_BulbConfigLumRate;
	/* Colour data structures */
	tsColourTransition					     sColourTransition;

} tsMibColourControl;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void 				MibColourControl_vInit			    (void);
PUBLIC void 				MibColourControl_vRegister		    (void);
PUBLIC void 				MibColourControl_vSecond			(void);
PUBLIC void 				MibColourControl_vTick			    (void);
PUBLIC void 				MibColourControl_vStackEvent	    (te6LP_StackEvent eEvent);
PUBLIC bool_t 				MibColourControl_bModeStop			(bool_t bInternal);
PUBLIC teJIP_Status			MibColourControl_eSetMode           (uint8   u8Val, void *pvCbData);
PUBLIC teJIP_Status			MibColourControl_eSetSceneId        (uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status			MibColourControl_eSetXYTarget       (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status			MibColourControl_eSetXTarget        (uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status			MibColourControl_eSetYTarget        (uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetXYCurrent	    (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetHueTarget      (uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetHueChange      ( int16 i16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetSatTarget      ( uint8  u8Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetSatChange      (  int8  i8Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetHueSatTarget   (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetHueSatCurrent  (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetCctTarget	    (uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetCctChange	    ( int16 i16Val, void *pvCbData);
PUBLIC teJIP_Status 		MibColourControl_eSetCctCurrent	    (uint16 u16Val, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBCOLOURCONTROL_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
