/****************************************************************************/
/*\PROJECT 		JN-AN-1162 JenNet-IP Smart Home								*/
/*!
 *\MODULE 		MibColour
 *
 *\FILE			MibColourConfigDef.h
 *
 *\DESCRIPTION	ColourConfig MIB definition
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#undef MIB_HEADER
#define MIB_HEADER "MibColourConfigDef.h"

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* Stack includes */
#include <jip_define_mib.h>
/* Application common includes */
#include "MibColour.h"

/****************************************************************************/
/***        MIB definition                                                ***/
/****************************************************************************/
START_DEFINE_MIB(MIB_ID_COLOUR_CONFIG, ColourConfigDef)
/*         ID 					   		 		  Type    Name  	   	  Disp  Flags Access 	             Cache Security */
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_TRANSITION_TIME , UINT16, TransitionTime, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_INIT_MODE	    , UINT8 , InitMode	    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_INIT_XY_TARGET  , UINT32, InitXYTarget  , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_WHITE, UINT32, XYPrimaryWhite, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_1	, UINT32, XYPrimary1	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_2	, UINT32, XYPrimary2	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_3	, UINT32, XYPrimary3	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_4	, UINT32, XYPrimary4	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_5	, UINT32, XYPrimary5	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_XY_PRIMARY_6	, UINT32, XYPrimary6	, NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_CCT_MIN	 		, UINT16, CctMin	    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
DEFINE_VAR(VAR_IX_COLOUR_CONFIG_CCT_MAX	 		, UINT16, CctMax	    , NULL, 0,    (READ | WRITE | TRAP), NONE, NONE)
END_DEFINE_MIB(ColourConfigDef)

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
