/****************************************************************************/
/*\PROJECT 		JN-AN-1162 JenNet-IP Smart Home								*/
/*!
 *\MODULE 		MibColour
 *
 *\FILE			MibColourConfig.h
 *
 *\DESCRIPTION	ColourConfig MIB public interface
 *
 * This header file contains typedefs, defines and prototypes for the
 * ColourConfig MIB
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBCOLOURCONFIG_H_INCLUDED
#define  MIBCOLOURCONFIG_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
/* Application common includes */
#include "Table.h"
/* Application colour conversion includes */
#include "ColourConversion.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#define MIB_COLOUR_CONFIG_TRANS_TIME_DEFAULT		500			/*!< Default transition time in 10ms intervals */

/* NOT USED - KEPT FOR FUTURE REFERENCE AS PROABLY FOR SOME HARDWARE BOARD */
//#define MIB_COLOUR_CONFIG_XY_TARGET_DEFAULT    	0x616B607D	/* White */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_1			0xA93751EB	/* Red */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_2			0x36C8AABF	/* Green */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_3			0x256010A3	/* Blue */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_4			0			/* Not used at present */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_5			0			/* Not used at present */
//#define MIB_COLOUR_CONFIG_XY_PRIMARY_6			0			/* Not used at present */

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/*! ColourConfig MIB permament data (stored in EEPROM) */
typedef struct
{
	/* Config MIB variable data */
	uint16 u16TransitionTime;	/*!< Time to transition to a new colour in 10ms intervals */
	uint8   u8InitMode;			/*!< Initial mode for ColourControl MIB at power on */
	uint32 u32InitXYTarget;		/*!< Initial colour for ColourControl MIB at power on */
	uint32 u32XYPrimaryWhite;	/*!< Primary white point for calibrated colours */
	uint32 u32XYPrimary1;		/*!< Primary 1 (usually red) point for calibrated colours */
	uint32 u32XYPrimary2;		/*!< Primary 2 (usually green) point for calibrated colours */
	uint32 u32XYPrimary3;		/*!< Primary 3 (usually blue) point for calibrated colours */
	uint32 u32XYPrimary4;		/*!< Primary 4 (usually unused) point for calibrated colours */
	uint32 u32XYPrimary5;		/*!< Primary 5 (usually unused) point for calibrated colours */
	uint32 u32XYPrimary6;		/*!< Primary 6 (usually unused) point for calibrated colours */
	uint16 u16CctMin;
	uint16 u16CctMax;
}  tsMibColourConfigPerm;

/*! ColourConfig MIB data structure */
typedef struct
{
	PDM_tsRecordDescriptor  			   sDesc; 		/*!< PDM record descriptor */
	tsMibColourConfigPerm 				   sPerm;		/*!< Permament data structure */
	tsCLD_ColourControlCustomDataStructure sColourData;	/*!< Colour calibration values */
} tsMibColourConfig;

/****************************************************************************/
/***        Public Function Prototypes                                     ***/
/****************************************************************************/
PUBLIC void 			 MibColourConfig_vInit             (void);
PUBLIC void 			 MibColourConfig_vRegister         (void);
PUBLIC teJIP_Status 	 MibColourConfig_eSetTransitionTime(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status 	 MibColourConfig_eSetInitMode      ( uint8  u8Val, void *pvCbData);
PUBLIC teJIP_Status 	 MibColourConfig_eSetInitXYTarget  (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status 	 MibColourConfig_eSetPrimary       (uint32 u32Val, void *pvCbData);
PUBLIC teJIP_Status 	 MibColourConfig_eSetCct   		   (uint16 u16Val, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBCOLOURCONFIG_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
