/****************************************************************************/
/*\PROJECT 		JN-AN-1162 JenNet-IP Smart Home								*/
/*!
 *\MODULE 		MibColour
 *
 *\FILE			MibColour.h
 *
 *\DESCRIPTION	MibColour IDs, indicies and values
 *
 * This header file contains definitions for the following MibColour values:
 * - MIB Identifiers
 * - Variable indicies
 * - Variable bitmasks for notifications
 * - Variable counts per MIB for notifications
 * - Variable values where limited
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBCOLOUR_H_INCLUDED
#define  MIBCOLOUR_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
#include <jendefs.h>

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Colour MIBs ********************************************/
/* ColourConfig MIB */
#define MIB_ID_COLOUR_CONFIG						0xfffffe09
#define VAR_IX_COLOUR_CONFIG_TRANSITION_TIME				 0
#define VAR_IX_COLOUR_CONFIG_INIT_MODE						 1
#define VAR_IX_COLOUR_CONFIG_INIT_XY_TARGET					 2
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_WHITE				 3
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_1					 4
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_2					 5
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_3					 6
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_4					 7
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_5					 8
#define VAR_IX_COLOUR_CONFIG_XY_PRIMARY_6					 9
#define	VAR_IX_COLOUR_CONFIG_CCT_MIN						10
#define VAR_IX_COLOUR_CONFIG_CCT_MAX						11
#define VAR_MASK_COLOUR_CONFIG						0x00000fff
#define VAR_COUNT_COLOUR_CONFIG								12

/* ColourControl MIB */
#define MIB_ID_COLOUR_CONTROL						0xfffffe0c
#define VAR_IX_COLOUR_CONTROL_MODE							 0
#define VAR_IX_COLOUR_CONTROL_SCENE_ID					   	 1
#define VAR_IX_COLOUR_CONTROL_XY_TARGET						 2
#define VAR_IX_COLOUR_CONTROL_XY_CURRENT					 3
#define VAR_IX_COLOUR_CONTROL_X_TARGET				 		 4
#define VAR_IX_COLOUR_CONTROL_Y_TARGET						 5
#define VAR_IX_COLOUR_CONTROL_HUE_TARGET					 6
#define VAR_IX_COLOUR_CONTROL_HUE_CHANGE					 7
#define VAR_IX_COLOUR_CONTROL_SAT_TARGET					 8
#define VAR_IX_COLOUR_CONTROL_SAT_CHANGE					 9
#define VAR_IX_COLOUR_CONTROL_HUE_SAT_TARGET				10
#define VAR_IX_COLOUR_CONTROL_HUE_SAT_CURRENT				11
#define VAR_IX_COLOUR_CONTROL_CCT_TARGET				 	12
#define VAR_IX_COLOUR_CONTROL_CCT_CURRENT				 	13
#define VAR_IX_COLOUR_CONTROL_CCT_CHANGE					14
#define VAR_IX_COLOUR_CONTROL_RED_CURRENT					15
#define VAR_IX_COLOUR_CONTROL_GREEN_CURRENT					16
#define VAR_IX_COLOUR_CONTROL_BLUE_CURRENT					17
#define VAR_MASK_COLOUR_CONTROL						0x0003ffff
#define VAR_COUNT_COLOUR_CONTROL							18
#define VAR_MASK_COLOUR_CONTROL_TARGET			    0x00001574
#define VAR_MASK_COLOUR_CONTROL_CURRENT				0x0003A808

#define VAR_VAL_COLOUR_CONTROL_MODE_STOP				  	 0
#define VAR_VAL_COLOUR_CONTROL_MODE_LOOP_DOWN			 	 1
#define VAR_VAL_COLOUR_CONTROL_MODE_LOOP_UP				 	 2
#define VAR_VAL_COLOUR_CONTROL_MODE_TEST_HUE_SAT		   	 3
#define VAR_VAL_COLOUR_CONTROL_MODE_TEST_CCT			  	 4
#define VAR_VAL_COLOUR_CONTROL_MODE_HUE_DOWN 				 5
#define VAR_VAL_COLOUR_CONTROL_MODE_HUE_UP	  				 6
#define VAR_VAL_COLOUR_CONTROL_MODE_SAT_DOWN	  			 7
#define VAR_VAL_COLOUR_CONTROL_MODE_SAT_UP	  				 8
#define VAR_VAL_COLOUR_CONTROL_MODE_CCT_DOWN	  			 9
#define VAR_VAL_COLOUR_CONTROL_MODE_CCT_UP	  				10
#define VAR_VAL_COLOUR_CONTROL_MODE_FAILED				  0xFF
#define VAR_VAL_COLOUR_CONTROL_MODE_COUNT	  			   	11

#if defined __cplusplus
}
#endif

#endif  /* MIBCOLOUR_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
