/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         Colour Transition Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  COLOURTRANSITION_H_INCLUDED
#define  COLOURTRANSITION_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Application common includes */
#include <ovly.h> /* Local implementation to remove overlays (normally in JenOS) */
#include <zcl.h>  /* Local implementation used status codes only */
/* Colour conversion includes */
#include "ColourConversion.h"
#include "Interpolation.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Transition modes */
#define COLOUR_TRANSITION_MODE_NONE	0 /* No transition running */
#define COLOUR_TRANSITION_MODE_XY   1 /* Transitioning across XY space */
#define COLOUR_TRANSITION_MODE_HS   2 /* Transitioning across HS space */
#define COLOUR_TRANSITION_MODE_CCT  3 /* Transitioning across CCT space */

/* Interpolation dimensions for XY transitions */
#define X_DIM   0
#define Y_DIM   1
#define XY_DIMS 2

/* Interpolation dimensions for HS transitions */
#define H_DIM   0
#define S_DIM   1
#define HS_DIMS 2

/* Interpolation dimensions for CCT transitions */
#define CCT_DIM  0
#define CCT_DIMS 1

/* Interpolation dimensions for RGB transitions */
#define R_DIM    0
#define G_DIM    1
#define B_DIM    2
#define RGB_DIMS 3

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Transition structure */
typedef struct
{
	tsCLD_ColourControlCustomDataStructure *psColourData; /* Structure with colour conversion matricies */

	tsInterpolation sXYInterpolation;  /* Interpolation structure for moving across XY  space (coarse) */
	tsInterpolation sHSInterpolation;  /* Interpolation structure for moving across HS  space (coarse) */
	tsInterpolation sCctInterpolation; /* Interpolation structure for moving across CCT space (coarse) */
	tsInterpolation sRGBInterpolation; /* Interpolation structure for moving across RGB space (fine) */

	uint8		   u8Mode;			   /* Transition mode */

} tsColourTransition;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC bool_t ColourTransition_bXYStart(tsColourTransition *psColourTransition);
PUBLIC bool_t ColourTransition_bXYNext(tsColourTransition *psColourTransition);
PUBLIC bool_t ColourTransition_bHSStart(tsColourTransition *psColourTransition, bool_t bOptimise);
PUBLIC bool_t ColourTransition_bHSNext(tsColourTransition *psColourTransition);
PUBLIC bool_t ColourTransition_bCctStart(tsColourTransition *psColourTransition);
PUBLIC bool_t ColourTransition_bCctNext(tsColourTransition *psColourTransition);
PUBLIC bool_t ColourTransition_bEnd(tsColourTransition *psColourTransition);

#if defined __cplusplus
}
#endif

#endif  /* COLOURTRANSITION_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
