/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         Colour Conversion MIB Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  COLOURCONVERSION_H_INCLUDED
#define  COLOURCONVERSION_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* Application common includes */
#include <ovly.h> /* Local implementation to remove overlays (normally in JenOS) */
#include <zcl.h>  /* Local implementation used status codes only */

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
/* Define primaries x and y coordinates */
#ifndef CLD_COLOURCONTROL_RED_X
#define CLD_COLOURCONTROL_RED_X     (0.73467)
#endif
#ifndef CLD_COLOURCONTROL_RED_Y
#define CLD_COLOURCONTROL_RED_Y     (0.26533)
#endif
#ifndef CLD_COLOURCONTROL_GREEN_X
#define CLD_COLOURCONTROL_GREEN_X   (0.27376)
#endif
#ifndef CLD_COLOURCONTROL_GREEN_Y
#define CLD_COLOURCONTROL_GREEN_Y   (0.71741)
#endif
#ifndef CLD_COLOURCONTROL_BLUE_X
#define CLD_COLOURCONTROL_BLUE_X    (0.16658)
#endif
#ifndef CLD_COLOURCONTROL_BLUE_Y
#define CLD_COLOURCONTROL_BLUE_Y    (0.00886)
#endif
/* Define white point x and y coordinates */
#ifndef CLD_COLOURCONTROL_WHITE_X
#define CLD_COLOURCONTROL_WHITE_X   (1.0 / 3.0)
#endif
#ifndef CLD_COLOURCONTROL_WHITE_Y
#define CLD_COLOURCONTROL_WHITE_Y   (1.0 / 3.0)
#endif

/* Mins and Maxs */
#define CLD_CCT_MIRED_MIN	 15
#define CLD_CCT_MIRED_MAX  1000

/* 3 way MAX and MIN macro's */
#define MIN3(X,Y,Z)     ((Y) <= (Z) ? ((X) <= (Y) ? (X) : (Y)) : ((X) <= (Z) ? (X) : (Z)))
#define MAX3(X,Y,Z)     ((Y) >= (Z) ? ((X) >= (Y) ? (X) : (Y)) : ((X) >= (Z) ? (X) : (Z)))

/* Scaling functions between floats and integers */
#define U16_TO_F(u16Val)     ((float)  ((float)u16Val / 65535.0))
#define F_TO_U16(fVal)       ((uint16) ((float)fVal   * 65535.0))
#define U8_TO_F(u8Val)       ((float)  ((float)u8Val  /   255.0))
#define F_TO_U8(fVal)        ((uint8)  ((float)fVal   *   255.0))
#define HUE_U16_TO_F(u16Hue) ((float)  ((float)u16Hue /    10.0))
#define HUE_F_TO_U16(fHue)   ((uint16) ((float)fHue   *    10.0))

/* Packing functions */
#define X_Y_TO_U32(u16X,u16Y)    (((uint32) u16X  << 16) | (uint32) u16Y)
#define HUE_SAT_TO_U32(u16H,u8S) (((uint32) u16H  <<  8) | (uint32)  u8S)
#define U32_TO_X(u32XY)          ((uint16)((u32XY >> 16) & 0xFFFF))
#define U32_TO_Y(u32XY)          ((uint16)( u32XY        & 0xFFFF))
#define U32_TO_HUE(u32HS)        ((uint16)((u32HS >>  8) & 0xFFFF))
#define U32_TO_SAT(u32HS)        ((uint8) ( u32HS        &   0xFF))

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Custom data structure */
typedef struct
{
//  teCLD_ColourControl_ColourMode                                  eColourMode;
//  uint16                                                          u16CurrentHue;
//  tsCLD_ColourControl_Transition                                  sTransition;

    /* Matrices for XYZ <> RGB conversions */
    float                                                           afXYZ2RGB[3][3];
    float                                                           afRGB2XYZ[3][3];

//  tsZCL_ReceiveEventAddress                                         sReceiveEventAddress;
//  tsZCL_CallBackEvent                                             sCustomCallBackEvent;
//  tsCLD_ColourControlCallBackMessage                              sCallBackMessage;
} tsCLD_ColourControlCustomDataStructure;

/****************************************************************************/
/***        Public Data                                     			  ***/
/****************************************************************************/

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC OVERLAY(COLOUR_CONTROL) teZCL_Status eCLD_ColourControl_GetRGB( /* xyY2RGB */
#ifdef RTOS
        uint8                       			u8SourceEndPointId,
#endif
#if MK_BLD_MIB_COLOUR_CONTROL
	    tsCLD_ColourControlCustomDataStructure *psCommon,
		uint16						  		   u16X,
		uint16						  		   u16Y,
#endif
        uint8                       		  *pu8Red,
        uint8                       		  *pu8Green,
        uint8                       		  *pu8Blue);

PUBLIC OVERLAY(COLOUR_CONTROL) teZCL_Status eCLD_ColourControl_RGB2xyY(
        tsCLD_ColourControlCustomDataStructure  *psCustomDataStructPtr,
        uint8                       u8Red,
        uint8                       u8Green,
        uint8                       u8Blue,
        uint16                      *pu16x,
        uint16                      *pu16y,
        uint8                       *pu8Y);

PUBLIC OVERLAY(COLOUR_CONTROL) teZCL_Status eCLD_ColourControl_HSV2xyY(
        tsCLD_ColourControlCustomDataStructure  *psCustomDataStructPtr,
        uint16                      u16Hue,
        uint8                       u8Saturation,
        uint8                       u8Value,
        uint16                      *pu16x,
        uint16                      *pu16y,
        uint8                       *pu8Y);

PUBLIC OVERLAY(COLOUR_CONTROL) void vCLD_ColourControl_CCT2xyY(
        uint16                      u16ColourTemperature,
        uint16                      *pu16x,
        uint16                      *pu16y,
        uint8                       *pu8Y);

PUBLIC OVERLAY(COLOUR_CONTROL) teZCL_Status eCLD_ColourControl_xyY2HSV(
        tsCLD_ColourControlCustomDataStructure  *psCustomDataStructPtr,
        uint16                      u16x,
        uint16                      u16y,
        uint8                       u8Y,
        uint16                      *pu16Hue,
        uint8                       *pu8Saturation,
        uint8                       *pu8Value);

PUBLIC OVERLAY(COLOUR_CONTROL2) void vCLD_ColourControl_xyY2CCT(
        uint16                      u16x,
        uint16                      u16y,
        uint8                       u8Y,
        uint16                      *pu16ColourTemperature);

PUBLIC OVERLAY(COLOUR_CONTROL) teZCL_Status eCLD_ColourControlCalculateConversionMatrices(
        tsCLD_ColourControlCustomDataStructure  *psCustomDataStructure,
        float                                   fRedX,
        float                                   fRedY,
        float                                   fGreenX,
        float                                   fGreenY,
        float                                   fBlueX,
        float                                   fBlueY,
        float                                   fWhiteX,
        float                                   fWhiteY);

#if defined __cplusplus
}
#endif

#endif  /* COLOURCONVERSION_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
