/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         DeviceColour DeviceScene MIB Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBDEVICESCENE_H_INCLUDED
#define  MIBDEVICESCENE_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
/* Application common includes */
#include "DeviceDefs.h"
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Scene data structure */
#pragma GCC diagnostic ignored "-Wpacked"
#pragma GCC diagnostic ignored "-Wattributes"
typedef struct
{
	uint16 u16DeviceTypeId;
	uint16 u16SceneId;
	#if MK_BLD_MIB_BULB_CONTROL
		uint8   u8BulbControlMode;
		uint8   u8BulbControlLumTarget;
	#endif
	#if MK_BLD_MIB_COLOUR_CONTROL
		uint8   u8ColourControlMode;
		#if MK_DRIVER_TYPE_TEMPERATURE
			uint16 u16ColourControlCctTarget;
		#else
			uint32 u32ColourControlXYTarget;
		#endif
	#endif
} PACK tsDeviceScene;
#pragma GCC diagnostic pop

/* Colour configuration permament data */
typedef struct
{
	/* Config MIB variable data */
   	tsDeviceScene asSceneTable[DEVICE_SCENES];

}  tsMibDeviceScenePerm;

/* Colour configuration temporary data */
typedef struct
{
	/* Config MIB variable data */
	uint16 	   		u16AddSceneId;
	uint16 	   		u16DelSceneId;
	tsDeviceScene	  sAddScene;

} tsMibDeviceSceneTemp;

/* Colour configuration mib */
typedef struct
{
	/* Table handle */
   	tsTable sSceneTable;

	/* PDM record descriptor */
	PDM_tsRecordDescriptor  sDesc;

	/* Data pointers */
	tsMibDeviceScenePerm 	sPerm;
	tsMibDeviceSceneTemp 	sTemp;

	/* Other data */
	uint32	u32NotifyChanged;

} tsMibDeviceScene;

/****************************************************************************/
/***        Public Function Prototypes                                    ***/
/****************************************************************************/
PUBLIC void 		MibDeviceScene_vInit(void);
PUBLIC void 		MibDeviceScene_vRegister(void);
PUBLIC void 		MibDeviceScene_vTick(void);
PUBLIC uint8 		MibDeviceScene_u8FindSceneId(uint16 u16SceneId);
PUBLIC teJIP_Status MibDeviceScene_eMakeScene(uint16 u16SceneId);
PUBLIC teJIP_Status MibDeviceScene_eAddScene(tsDeviceScene *psAddScene);
PUBLIC teJIP_Status MibDeviceScene_eActivateScene(uint16 u16SceneId);
PUBLIC teJIP_Status MibDeviceScene_eDelScene(uint16 u16SceneId);
#if MK_BLD_MIB_BULB_SCENE
PUBLIC void 		MibDeviceScene_vBulbScene(uint8 u8Scene, bool_t bNotifyChange);
#endif
PUBLIC teJIP_Status	MibDeviceScene_eSetAddSceneId(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status MibDeviceScene_eSetDelSceneId(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status MibDeviceScene_eSetAddScene(const uint8 *pu8Val, uint8 u8Len, void *pvCbData);
PUBLIC void 		MibDeviceScene_vGetAddScene(thJIP_Packet hPacket, void *pvCbData);

#if defined __cplusplus
}
#endif

#endif  /* MIBDEVIVESCENE_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
