/*****************************************************************************
 *
 * MODULE:             JN-AN-1158 (Remote)
 *
 * COMPONENT:          ZID.h
 *
 * AUTHOR:             JV
 *
 * DESCRIPTION:        ZigBee Input Device profile functionalities
 *
 * $HeadURL $
 *
 * $Revision: 9938 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2012-11-15 19:26:23 +0000 (Thu, 15 Nov 2012) $
 *
 * $Id: ZID.h 9938 2012-11-15 19:26:23Z nxp46755 $
 *
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/

#ifndef ZID_INCLUDED
#define ZID_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include Files                                                 ***/
/****************************************************************************/
#include "jendefs.h"
#include "RF4CE_API.h"
/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/
#define CHANGES4_ZID             (1)
#define MOUSE_XY_STEP_POSITIVE   (0x00)
#define MOUSE_XY_STEP_NEGATIVE   (0x80)
#define MOUSE_BTN_LEFT           (0x01)
#define MOUSE_BTN_RIGHT          (0x02)

/* ZID Profile Initial NIB attribute settings */
#define ZID_PROFILE_ID            (0x02)

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

typedef enum
{
    E_ZID_ReportData_MOUSE         = 0x00,
    E_ZID_ReportData_KEYBOARD      = 0x01,
    E_ZID_ReportData_TOUCHPAD      = 0x02,
}teZID_ReportData;

typedef enum
{
    E_ZID_ReportType_RESERVED       = 0x00,
    E_ZID_ReportType_INPUT          = 0x01,
    E_ZID_ReportType_OUTPUT         = 0x02,
    E_ZID_ReportType_FEATURE        = 0x03,
}teZID_ReportType;

typedef enum
{
    E_ZID_ReportId_MOUSE            = 0x01,
    E_ZID_ReportId_KEYBOARD         = 0x02,
}teZID_ReportID;

typedef enum
{
    E_ZID_CMD_GET_REPORT            = 0x01,
    E_ZID_CMD_REPORT_DATA           = 0x02,
    E_ZID_CMD_SET_REPORT            = 0x03,
} teZID_CmdCode;

typedef enum
{
    E_TX_CMD_ZID_MOUSE_LEFT        = 0xF1,
    E_TX_CMD_ZID_MOUSE_RIGHT       = 0xF2,
    E_TX_CMD_ZID_MOUSE_UP          = 0xF3,
    E_TX_CMD_ZID_MOUSE_DOWN        = 0xF4,
    E_TX_CMD_ZID_MOUSE_LCLICK      = 0xF5,
}teMouseCode_JNtoLPC;

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

PUBLIC void vZID_SendReportData(uint8 u8ReceiverPairingRef, uint8 u8ReportSize,\
        teZID_ReportType eReportType, teZID_ReportID eReportId, teZID_ReportData eReportData);
PUBLIC void vZID_SendGetReport(uint8 u8ReceiverPairingRef,\
        teZID_ReportType eReportType, uint8 u8ReportId);

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

typedef struct {

    uint8 bmButtons;        // Bitmap state of three mouse buttons.
    int8 bX;                // Pointer displacement along the X axis.
    int8 bY;                // Pointer displacement along the Y axis.
}HIDDMouseInputReport;

#if defined __cplusplus
}
#endif

#endif  /* CERC_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
