/****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/
 /****************************************************************************
 *
 * Battery Indicator for the LCD display
 *
 ****************************************************************************/
const uint8 au8Batt[] = {

		0xFC, 0x6, 0x6, 0x6, 0xFC, 0x0, 0x00, 0x00,
		0xFF, 0x80, 0x80, 0x80, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0x6, 0x6, 0x6, 0xFC, 0x0, 0x00, 0x00,
		0xFF, 0xE0, 0xE0, 0xE0, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0x6, 0x6, 0x6, 0xFC, 0x0, 0x00, 0x00,
		0xFF, 0xF8, 0xF8, 0xF8, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0x6, 0x6, 0x6, 0xFC, 0x0, 0x00, 0x00,
		0xFF, 0xFE, 0xFE, 0xFE, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0x86, 0x86, 0x86, 0xFC, 0x0, 0x00, 0x00,
	    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0xE6, 0xE6, 0xE6, 0xFC, 0x0, 0x00, 0x00,
	    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,

		0xFC, 0xFE, 0xFE, 0xFE, 0xFC, 0x0, 0x00, 0x00,
		0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,


};

const uint32 au32Batt_offsets[] = {
  		     0, /* 0 */
  		    16, /* 1 */
  		    32, /* 2 */
  		    48, /* 3 */
  		    64, /* 4 */
  		    80, /* 5 */
  		    96, /* 6 */
};

/**************************************************************************
 *
 * Energy LinkQuality symbol for the LCD display
 *
 *************************************************************************/

const uint8 au8EnergyMeterBar[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //0 //0
		0xFC, 0x84, 0xFC, 0x00, 0xFF, 0x81, 0xFF, 0x00,

		0xF0, 0x10, 0xF0, 0x00, 0xFC, 0x4, 0xFC, 0x00,		//16
		0xFF, 0x80, 0xFF, 0x00, 0xFF, 0x80, 0xFF, 0x00,

		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //1 //32
		0xFC, 0xFC, 0xFC, 0x00, 0xFF, 0x81, 0xFF, 0x00,

		0xF0, 0x10, 0xF0, 0x00, 0xFC, 0x4, 0xFC, 0x00,		 //48
		0xFF, 0x80, 0xFF, 0x00, 0xFF, 0x80, 0xFF, 0x00,

		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //2 //64
		0xFC, 0xFC, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0x00,

		0xF0, 0x10, 0xF0, 0x00, 0xFC, 0x4, 0xFC, 0x00,		 //80
		0xFF, 0x80, 0xFF, 0x00, 0xFF, 0x80, 0xFF, 0x00,

		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //3 //96
	    0xFC, 0xFC, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0x00,

	    0xF0, 0xF0, 0xF0, 0x00, 0xFC, 0x4, 0xFC, 0x00,		//112
	    0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x80, 0xFF, 0x00,

		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //4 //128
	    0xFC, 0xFC, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0x00,

	    0xF0, 0xF0, 0xF0, 0x00, 0xFC, 0xFC, 0xFC, 0x00,	     //144
	    0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0x00,

};

const uint32 au32Energy_offsets[] = {
  		     0,  /* 0 */
  		     16, /* 1 */
  		     32, /* 2 */
  		     48, /* 3 */
  		     64, /* 4 */
  		     80, /* 5 */
  		     96, /* 6 */
  		     112,/* 7 */
  		     128,/* 8 */
  		     144,/* 9 */
};

/**************************************************************************
 *
 * Symbols for the LCD display
 *
 *************************************************************************/
const uint8 au8Energy_Symbol[] = {

		0x00, 0x18, 0x7E, 0xDB, 0xC3, 0x66, 0x00, 0x00, //Euro Sign
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		0x00, 0xD8, 0xFE, 0xDB, 0xC3, 0xC6, 0x00, 0x00, //Pound Sign
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		0x00, 0xCE, 0xDB, 0xFF, 0xDB, 0x76, 0x00, 0x00, //Dollar Sign
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		0x0E, 0x11, 0x11, 0x00, 0x0E, 0x11, 0x51, 0xCE, //C02
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x02,

		0xFF, 0x18, 0xE7, 0xFF, 0xC0, 0xFF, 0xC0, 0xFF, //KWh
		0x00, 0xFE, 0x30, 0xF0, 0x00, 0x00, 0x00, 0x00,

		0x00, 0x00, 0xF0, 0x8F, 0x0F, 0xF0, 0x00, 0x00, //Light Bulb
		0xF0, 0xDF, 0xC0, 0xC7, 0xFF, 0xC0, 0xCF, 0xF0,

		0xF8, 0x08, 0x30, 0x08, 0xF8, 0x11, 0x15, 0x0A, //M3
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

		0x00, 0x00, 0x7E, 0x40, 0x40, 0x40, 0x00, 0x00, //L
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint32 au32EnergySymbol_offsets[] = {
  		     0, /* 0 Euro   */
  		    16, /* 1 Pound  */
  		    32, /* 2 Doller */
  		    48, /* 3 CO2    */
  		    64, /* 4 Kwh    */
  		    80, /* 5 Light Bulb  */
  		    96, /* 6 m3  	*/
  		    112	/* 7 L		*/
};


/**************************************************************************
 *
 * Misc symbols for the LCD display
 *
 *************************************************************************/

const uint8 au8Symbols[] = {
		0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, //Full Stop

		0x00, 0x00, 0x7E, 0x81, 0x7E, 0x00, 0x00, 0x00, //0
		0x9F, 0x99, 0xF9, 0x00, 0x7E, 0x81, 0x7E, 0x00, //50
		0xFF, 0x00, 0x7E, 0x81, 0x7E, 0x7E, 0x81, 0x7E, //100
		0x00, 0xC0, 0x63, 0x18, 0xC6, 0x00, 0x00, 0x00, //%
		0xFF, 0x00, 0x7E, 0x81, 0x7E, 0x00, 0x00, 0x00, //10
		0x7E, 0x18, 0x66, 0x7E, 0x40, 0x7E, 0x40, 0x7E, //kw


};

const uint32 au32symbol_offsets[] = {
  		     0, /* Full Stop*/
  		     8, /* 0   */
  		    16, /* 50  */
  		    24, /* 100 */
  		    32, /*  %  */
  		    40, /* 10  */
  		    48, /* kw  */
};


/**************************************************************************
 *
 * constant xy coordinates for energy bar.
 *
 *************************************************************************/

const uint8 xx1[]={28,30,31,33,34,36,38,39,41,43,44,46,47,49,51,52,54,56,57,59,61,62,64,65,67,69,70,72,74,75,77,78,80,82,83,85,87,88,90,91,93,95};
const uint8 xx2[]={55,57,59,60,62,63,65,67,68,70,72,73,75,76,78,80,81,83,85,86,88,90,91,93,94,96,98,99,101,102,104,106,107,109,111,112,114,116,117,119,120,122};
const uint8 yyy[]={46,45,44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5};


/**************************************************************************
 *
 * constant xy coordinates for right arrow
 *
 *************************************************************************/
const uint8 au8RightArrow[] = {

		0xFF, 0x81, 0xC3, 0x42, 0x24, 0x24, 0x18, 0x18
};


/**************************************************************************
 *
 * constant xy coordinates for left arrow
 *
 *************************************************************************/
const uint8 au8LeftArrow[] = {

		0x18, 0x18, 0x24, 0x24, 0x42, 0xC3, 0x81, 0xFF
};
