/*
 * The Clear BSD License
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided
 * that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS LICENSE.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v3.0
processor: LPC54608J512
package_id: LPC54608J512ET180
mcu_data: ksdk2_0
processor_version: 0.0.11
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iocon.h"
#include "pin_mux.h"



/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: B13, peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA(2), mode: inactive, invert: disabled,
    glitch_filter: disabled, slew_rate: standard, open_drain: disabled}
  - {pin_num: A2, peripheral: FLEXCOMM0, signal: TXD_SCL_MISO, pin_signal: PIO0_30/FC0_TXD_SCL_MISO/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA(1), mode: inactive, invert: disabled,
    glitch_filter: disabled, slew_rate: standard, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Core #0 (ARM Cortex-M4) */
void BOARD_InitPins(void)
{
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);

    const uint32_t port0_pin29_config = (/* Pin is configured as FC0_RXD_SDA_MOSI */
                                         IOCON_PIO_FUNC1 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Input filter disabled */
                                         IOCON_PIO_INPFILT_OFF |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN29 (coords: B13) is configured as FC0_RXD_SDA_MOSI */
    IOCON_PinMuxSet(IOCON, 0U, 29U, port0_pin29_config);

    const uint32_t port0_pin30_config = (/* Pin is configured as FC0_TXD_SCL_MISO */
                                         IOCON_PIO_FUNC1 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Input filter disabled */
                                         IOCON_PIO_INPFILT_OFF |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI);
    /* PORT0 PIN30 (coords: A2) is configured as FC0_TXD_SCL_MISO */
    IOCON_PinMuxSet(IOCON, 0U, 30U, port0_pin30_config);

	/* EMC SDRAM Pins setting. */
    const uint32_t port0_pin18_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[0]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 18U, port0_pin18_config); /* PORT0 PIN18 (coords: C14) is configured as EMC_A[0] */

    const uint32_t port0_pin19_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[1]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 19U, port0_pin19_config); /* PORT0 PIN19 (coords: C6) is configured as EMC_A[1] */	

    const uint32_t port0_pin20_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[2]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 20U, port0_pin20_config); /* PORT0 PIN20 (coords: D13) is configured as EMC_A[2] */
    const uint32_t port0_pin21_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[3]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 21U, port0_pin21_config); /* PORT0 PIN21 (coords: C13) is configured as EMC_A[3] */
    const uint32_t port1_pin5_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[4]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 5U, port1_pin5_config); /* PORT1 PIN5 (coords: E4) is configured as EMC_A[4] */
    const uint32_t port1_pin6_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[5]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 6U, port1_pin6_config); /* PORT1 PIN6 (coords: G4) is configured as EMC_A[5] */
    const uint32_t port1_pin7_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[6]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 7U, port1_pin7_config); /* PORT1 PIN7 (coords: N1) is configured as EMC_A[6] */ 
    const uint32_t port1_pin8_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[7]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 8U, port1_pin8_config); /* PORT1 PIN8 (coords: P8) is configured as EMC_A[7] */
    const uint32_t port1_pin26_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[8]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 26U, port1_pin26_config); /* PORT1 PIN26 (coords: J10) is configured as EMC_A[8] */
    const uint32_t port1_pin27_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[9]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 27U, port1_pin27_config); /* PORT1 PIN27 (coords: F10) is configured as EMC_A[9] */
    const uint32_t port1_pin16_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[10]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 16U, port1_pin16_config); /* PORT1 PIN16 (coords: B7) is configured as EMC_A[10] */ 
    const uint32_t port1_pin23_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[11]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 23U, port1_pin23_config); /* PORT1 PIN23 (coords: M10) is configured as EMC_A[11] */
    const uint32_t port1_pin24_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[12]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 24U, port1_pin24_config); /* PORT1 PIN24 (coords: N14) is configured as EMC_A[12] */    
    const uint32_t port1_pin25_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[13]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 25U, port1_pin25_config); /* PORT1 PIN25 (coords: M12) is configured as EMC_A[13] */
    const uint32_t port3_pin25_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_A[14]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 3U, 25U, port3_pin25_config); /* PORT3 PIN25 (coords: P9) is configured as EMC_A[14] */
    const uint32_t port0_pin2_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[0]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 2U, port0_pin2_config); /* PORT0 PIN2 (coords: E9) is configured as EMC_D[0] */    
    const uint32_t port0_pin3_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[1]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 3U, port0_pin3_config); /* PORT0 PIN3 (coords: A10) is configured as EMC_D[1] */  
    const uint32_t port0_pin4_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[2]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 4U, port0_pin4_config); /* PORT0 PIN4 (coords: C8) is configured as EMC_D[2] */ 
    const uint32_t port0_pin5_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[3]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 5U, port0_pin5_config); /* PORT0 PIN5 (coords: E7) is configured as EMC_D[3] */ 	
    const uint32_t port0_pin6_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[4]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 6U, port0_pin6_config); /* PORT0 PIN6 (coords: A5) is configured as EMC_D[4] */ 
    const uint32_t port0_pin7_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[5]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 7U, port0_pin7_config); /* PORT0 PIN7 (coords: H12) is configured as EMC_D[5] */ 
    const uint32_t port0_pin8_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[6]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 8U, port0_pin8_config); /* PORT0 PIN8 (coords: H10) is configured as EMC_D[6] */ 
    const uint32_t port0_pin9_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[7]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 9U, port0_pin9_config); /* PORT0 PIN9 (coords: G12) is configured as EMC_D[7] */ 
    const uint32_t port1_pin19_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[8]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 19U, port1_pin19_config); /* PORT1 PIN19 (coords: L1) is configured as EMC_D[8] */  
    const uint32_t port1_pin20_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[9]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 20U, port1_pin20_config); /* PORT1 PIN20 (coords: M1) is configured as EMC_D[9] */  	
    const uint32_t port1_pin21_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[10]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 21U, port1_pin21_config); /* PORT1 PIN21 (coords: N8) is configured as EMC_D[10] */  
    const uint32_t port1_pin4_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[11]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 4U, port1_pin4_config); /* PORT1 PIN4 (coords: D4) is configured as EMC_D[11] */  	
    const uint32_t port1_pin28_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[12]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 28U, port1_pin28_config); /* PORT1 PIN28 (coords: E12) is configured as EMC_D[12] */  
    const uint32_t port1_pin29_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[13]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 29U, port1_pin29_config); /* PORT1 PIN29 (coords: C11) is configured as EMC_D[13] */  
    const uint32_t port1_pin30_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[14]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 30U, port1_pin30_config); /* PORT1 PIN30 (coords: A8) is configured as EMC_D[14] */  
    const uint32_t port1_pin31_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_D[15]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 31U, port1_pin31_config); /* PORT1 PIN31 (coords: C5) is configured as EMC_D[15] */  
    const uint32_t port1_pin9_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_CASN  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 9U, port1_pin9_config); /* PORT1 PIN9 (coords: K6) is configured as EMC_CASN */  
    const uint32_t port1_pin10_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_RASN  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 10U, port1_pin10_config); /* PORT1 PIN10 (coords: N9) is configured as EMC_RASN */  
    const uint32_t port1_pin11_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_CLK[0]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 11U, port1_pin11_config); /* PORT1 PIN11 (coords: B4) is configured as EMC_CLK[0] */  
    const uint32_t port1_pin12_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_DYCSN[0]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 12U, port1_pin12_config); /* PORT1 PIN12 (coords: K9) is configured as EMC_DYCSN[0] */  
    const uint32_t port1_pin13_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_DQM[0]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 13U, port1_pin13_config); /* PORT1 PIN13 (coords: G10) is configured as EMC_DQM[0] */  
    const uint32_t port1_pin14_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_DQM[1]  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 14U, port1_pin14_config); /* PORT1 PIN14 (coords: C12) is configured as EMC_DQM[1] */  
    const uint32_t port1_pin15_config = (
      IOCON_FUNC6 |                     /* Pin is configured as EMC_CKE[0]  */
      IOCON_PIO_MODE_INACT |            /* No addition pin function */
      IOCON_PIO_INV_DI |                /* Input function is not inverted */
      IOCON_PIO_DIGITAL_EN |            /* Enables digital function */
      IOCON_PIO_INPFILT_OFF |           /* Input filter disabled */
      IOCON_FASTI2C_EN |                /* Fast mode, output slew rate control is enabled */
      IOCON_PIO_OPENDRAIN_DI            /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 1U, 15U, port1_pin15_config); /* PORT1 PIN15 (coords: A11) is configured as EMC_CKE[0] */  
    const uint32_t port0_pin15_config = (
        IOCON_FUNC6 |                   /* Pin is configured as EMC_WEN  */
        IOCON_PIO_MODE_INACT |          /* No addition pin function */
        IOCON_PIO_INV_DI |              /* Input function is not inverted */
        IOCON_PIO_DIGITAL_EN |          /* Enables digital function */
        IOCON_PIO_INPFILT_OFF |         /* Input filter disabled */
        IOCON_FASTI2C_EN |              /* Fast mode, output slew rate control is enabled */
        IOCON_PIO_OPENDRAIN_DI          /* Open drain is disabled */
    );
    IOCON_PinMuxSet(IOCON, 0U, 15U, port0_pin15_config); /* PORT0 PIN15 (coords: L4) is configured as EMC_WEN */  

}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
