/*
 * @brief Secondary loader common
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef SL_COMMON_H
#define SL_COMMON_H

#include "chip.h"

#ifdef __cplusplus
extern "C" {
#endif

/* This configuration is for LPC11U6X */
//#define SBL_LPC11U6X

/* SBL will check timeout to entry user application code */
#define SBL_CHECKTIMEOUT		1

#include "sl_protocol.h"

/************************************************
    Secondary dfu boot loader version history.
   0.1	Initial version based on niobe sec loader version 0.5
 **************************************************/
/* Bit 7 (MSB) of the major version number is set when SL function is active in rom */
#define CFG_MAJOR_VERSION   0x00
#define CFG_MINOR_VERSION   0x01

#define CRP_ADDR            0x2FC
#define Get_CRP()           (*(uint32_t *) CRP_ADDR)
#define CRP_PAGE_ADDR       (CRP_ADDR & ~(SL_FLASH_PAGE_SZ - 1))
#define CRP_PAGE_NUM        (CRP_PAGE_ADDR / SL_FLASH_PAGE_SZ)
#define CRP_SECT_NUM        (CRP_PAGE_ADDR / SL_FLASH_SECT_SZ)
#define CRP2_VALUE          0x87654321

/* Verify that application's CRC is correct. Used to determine if a valid
   application is located in FLASH before jumping to it. Returns 0 if
   the check is valid or computed CRC32 value. */
extern uint32_t checkAppCRC(uint32_t imgAddr);
extern uint32_t computeAppCRC(uint32_t imgAddr);

extern uint32_t computeCrc32(uint32_t *data, uint32_t len);

/* Cleanup function, should be called before booting App */
extern void LPC_SBL_CleanUpSystem(void);

/* App boot function (loads SP and jumper to reset vector for app) */
extern void bootValidApp(uint32_t appBootAddr);

/* Clean-up System then re-boot */
extern void doCleanBoot(uint32_t imgAddr);


#ifdef __cplusplus
}
#endif

#endif /* SL_COMMON_H */
