
#include <stdlib.h>
#include <string.h>
#include "board.h"
#include "chip.h"

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/**
 * @brief	Event router interrupt handler
 * @return	Nothing
 */
__ramfunc void EVRT_IRQHandler(void)
{
	/* Toggle LED6 to know the MCU has woken up */
	LPC_GPIO_PORT->B[4][13] = 1;
	if (Chip_EVRT_IsSourceInterrupting(EVRT_SRC_WAKEUP0)) {
		Chip_EVRT_ClrPendIntSrc(EVRT_SRC_WAKEUP0);
		Chip_EVRT_SetUpIntSrc(EVRT_SRC_WAKEUP0, DISABLE);
	}

	if (Chip_EVRT_IsSourceInterrupting(EVRT_SRC_RTC)) {
		if (Chip_RTC_GetIntPending(LPC_RTC, RTC_INT_ALARM)) {
			Chip_RTC_ClearIntPending(LPC_RTC, RTC_INT_ALARM);
			Chip_EVRT_ClrPendIntSrc(EVRT_SRC_RTC);
			Chip_RTC_Enable(LPC_RTC, DISABLE);
			Chip_EVRT_SetUpIntSrc(EVRT_SRC_RTC, DISABLE);
		}
	}
}

