/*
 * @brief Image programming code
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include <stdint.h>
#include <string.h>
#include "app_usbd_cfg.h"
#include "chip.h"
#include "sl_protocol.h"



volatile uint32_t dfu_detach_sig=0;

extern SL_PINSETUP_T PINONLYCFGTABLEFLASH;
SL_DFU_ID_STR_T APP_USB_DESCRIPTOR;

/* return
 * DFU_STATUS_ : values defined in mw_usbd_dfu.h in case of errors
 * 0 : If end of memory reached
 * length : Amount of data copied to destination buffer
 */
uint32_t dfu_rd(uint32_t block_num, uint8_t * *pBuff, uint32_t length)
{
	return length;
}

/* return DFU_STATUS_ values defined in mw_usbd_dfu.h */
uint8_t dfu_wr(uint32_t block_num, uint8_t * *pBuff, uint32_t length,
			   uint8_t *bwPollTimeout)
{
	return DFU_STATUS_OK;
}

void dfu_done(void)
{}

void dfu_detach(USBD_HANDLE_T hUsb)
{

	/* Set detach flag */
	dfu_detach_sig = 1; 
}

void enter_DFU_SL(USBD_HANDLE_T hUsb)
{
	LPC_GPIO->DIR[1] |= (1<<0);
	
	/* 1. disconnect USB */
	USBD_API->hw->Connect(hUsb, 0);

	/* 2. Do application clean-up */

	/* 3. Disable IRQs */
	__disable_irq();

	/* 4. Setup USB descriptor parameters */
	APP_USB_DESCRIPTOR.usbVendorId = 0x1FC9;
	APP_USB_DESCRIPTOR.usbProductId = 0x5002;
	APP_USB_DESCRIPTOR.usbStringDesc = (uint8_t *) USB_StringDescriptor;
	
/* 5. Invoke secondary loader from app. Will not return if successful */
bootSecondaryLoader(&PINONLYCFGTABLEFLASH, &APP_USB_DESCRIPTOR);
			LPC_GPIO->DIR[1] |= (1<<2);while(1); /* Error Should not come here*/
}

/* Main Program */
ErrorCode_t usb_dfu_init(USBD_HANDLE_T hUsb,
						 USB_INTERFACE_DESCRIPTOR *pIntfDesc,
						 uint32_t *mem_base,
						 uint32_t *mem_size)
{
	USBD_DFU_INIT_PARAM_T dfu_param;
	ErrorCode_t ret = LPC_OK;

	memset((void *) &dfu_param, 0, sizeof(USBD_DFU_INIT_PARAM_T));
	dfu_param.mem_base = *mem_base;
	dfu_param.mem_size = *mem_size;
	/* DFU params */
	dfu_param.wTransferSize = USB_DFU_XFER_SIZE;

	if ((pIntfDesc == 0) ||
		(pIntfDesc->bInterfaceClass != USB_DEVICE_CLASS_APP) ||
		(pIntfDesc->bInterfaceSubClass != USB_DFU_SUBCLASS) ) {
		return ERR_FAILED;
	}

	dfu_param.intf_desc = (uint8_t *) pIntfDesc;
	/* user defined functions */
	dfu_param.DFU_Write = dfu_wr;
	dfu_param.DFU_Read = dfu_rd;
	dfu_param.DFU_Done = dfu_done;
	dfu_param.DFU_Detach = dfu_detach;

	ret = USBD_API->dfu->init(hUsb, &dfu_param, DFU_STATE_appIDLE);	
	/* update memory variables */
	*mem_base = dfu_param.mem_base;
	*mem_size = dfu_param.mem_size;
	return ret;
}
