/*
 * @brief Image programming code
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include <string.h>
#include "app_usbd_cfg.h"
#include "usbd_bb.h"


/* USB Standard Device Descriptor */
USB_DEVICE_DESCRIPTOR USB_DeviceDescriptor = {
	USB_DEVICE_DESC_SIZE,			/* bLength */
	USB_DEVICE_DESCRIPTOR_TYPE,		/* bDescriptorType */
	0x0201,	/* 2.00 */          /* bcdUSB */
	0x00,							/* bDeviceClass */
	0x00,							/* bDeviceSubClass */
	0x00,							/* bDeviceProtocol */
	USB_MAX_PACKET0,				/* bMaxPacketSize0 */
	0x1FC9,					/* idVendor */
	0x5002,					/* idProduct */
	0x0100,	        /* 1.00 */          /* bcdDevice */
	0x01,							/* iManufacturer */
	0x02,							/* iProduct */
	0x03,							/* iSerialNumber */
	0x01							/* bNumConfigurations */
};

/* USB FSConfiguration Descriptor */
/*   All Descriptors (Configuration, Interface, Endpoint, Class, Vendor */
const uint8_t USB_FsConfigDescriptor[] = {
	/* Configuration 1 */
		USB_CONFIGURATION_DESC_SIZE,	/* bLength */
	USB_CONFIGURATION_DESCRIPTOR_TYPE,	/* bDescriptorType */
	WBVAL(							/* wTotalLength */
		1 * USB_CONFIGURATION_DESC_SIZE +
		1 * USB_INTERFACE_DESC_SIZE     +
		1 * DFU_FUNC_DESC_SIZE					
		),
	0x01,							/* bNumInterfaces */
	0x01,							/* bConfigurationValue */
	0x05,							/* iConfiguration */
	USB_CONFIG_BUS_POWERED,			/* bmAttributes */
	USB_CONFIG_POWER_MA(100),		/* bMaxPower */
	/* Interface 0, Alternate Setting 0, DFU Class */
	USB_INTERFACE_DESC_SIZE,		/* bLength */
	USB_INTERFACE_DESCRIPTOR_TYPE,	/* bDescriptorType */
	0x00,							/* bInterfaceNumber */
	0x00,							/* bAlternateSetting */
	0x00,							/* bNumEndpoints */
	USB_DEVICE_CLASS_APP,			/* bInterfaceClass */
	USB_DFU_SUBCLASS,				/* bInterfaceSubClass */
	0x01,								/* bInterfaceProtocol */
	0x04,							/* iInterface */
	/* DFU RunTime/DFU Mode Functional Descriptor */
	DFU_FUNC_DESC_SIZE,				/* bLength */
	USB_DFU_DESCRIPTOR_TYPE,		/* bDescriptorType */
	USB_DFU_CAN_DOWNLOAD | USB_DFU_CAN_UPLOAD | USB_DFU_MANIFEST_TOL | USB_DFU_WILL_DETACH,	/* bmAttributes */
	WBVAL(0xFF00),					/* wDetachTimeout */
	WBVAL(USB_DFU_XFER_SIZE),		/* wTransferSize */
	WBVAL(0x100),					/* bcdDFUVersion */
	
	/* Terminator */
	0								/* bLength */
};


/* USB String Descriptor (optional) */
const uint8_t USB_StringDescriptor[] = {
	/* Index 0x00: LANGID Codes */
	0x04,							/* bLength */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	WBVAL(0x0409),	/* US English */    /* wLANGID */
	/* Index 0x01: Manufacturer */
	(18 * 2 + 2),					/* bLength (13 Char + Type + lenght) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'N', 0,
	'X', 0,
	'P', 0,
	' ', 0,
	'S', 0,
	'e', 0,
	'm', 0,
	'i', 0,
	'c', 0,
	'o', 0,
	'n', 0,
	'd', 0,
	'u', 0,
	'c', 0,
	't', 0,
	'o', 0,
	'r', 0,
	's', 0,
	/* Index 0x02: Product */
	(3 * 2 + 2),					/* bLength (3 Char + Type + lenght) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'L', 0,
	'P', 0,
	'K', 0,
	/* Index 0x03: Serial Number */
	(13 * 2 + 2),					/* bLength (13 Char + Type + lenght) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'A', 0,
	'B', 0,
	'C', 0,
	'D', 0,
	'1', 0,
	'2', 0,
	'3', 0,
	'4', 0,
	'5', 0,
	'6', 0,
	'7', 0,
	'8', 0,
	'9', 0,
	/* Index 0x04: Interface 0, Alternate Setting 0 */
	(3 * 2 + 2),					/* bLength (3 Char + Type + lenght) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'D', 0,
	'F', 0,
	'U', 0,
	/* Index 0x05: Interface 1, Alternate Setting 0 */
	(9 * 2 + 2),					/* bLength (9 Char + Type + lenght) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'B', 0,
	'I', 0,
	'L', 0,
	'L', 0,
	'B', 0,
	'O', 0,
	'A', 0,
	'R', 0,
	'D', 0,
};

/* USB BOS Descriptor */
uint8_t USB_BOSDescriptor[] = {
    USB_BOS_DESC_SIZE,                 /* bLength */
    USB_BOS_TYPE,                      /* bDescriptorType, BOS */
    WBVAL(                             /* wTotalLength */
        USB_BOS_DESC_SIZE +
		USB_DEVICE_CAPABILITY_SIZE +
        USB_CONTAINER_ID_DEV_CAP_SIZE +
        USB_BILLBOARD_DEV_CAP_SIZE
        ),
    0x03,                               /* bNumDeviceCaps */

	/* Device Capabilities, USB 2.0 Extension Descriptor */
	USB_DEVICE_CAPABILITY_SIZE,        /* bLength */
	USB_DEVICE_CAPABILITY_TYPE,        /* bDescriptorType, DEVICE CAPABILITY */
	0x02,                              /* bDeviceCapabilityType, USB2.0 EXTENSION */
	0x6,                               /* bmAttributes, (LPM=1) */
	0x00,
	0x00,
	0x00,
	
    /* Container ID */
    USB_CONTAINER_ID_DEV_CAP_SIZE,     /* bLength */
    USB_DEVICE_CAPABILITY_TYPE,        /* bDescriptorType, DEVICE CAPABILITY */
    USB_DEVICE_CONTAINER_ID_TYPE,      /* bDeviceCapabilityType, Container ID */
    0x00,                              /* bReserved */
    0x00, 0x00, 0x00, 0x00,            /* ContainerId */
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,

    /* Billboard capability descriptor */
    USB_BILLBOARD_DEV_CAP_SIZE,     /* bLength */
    USB_DEVICE_CAPABILITY_TYPE,     /* bDescriptorType, DEVICE CAPABILITY */
    USB_DEVICE_BILLBOARD_TYPE,      /* bDeviceCapabilityType, Billboard */
    0x04,                           /* iAdditionalInfoURL */
    0x01,                           /* bNumberOfAlternateModes */
    0x00,                           /* bPreferredAlternateMode */
    WBVAL(0x00),                    /* vconnPower - 1W is enough */
    0x00,                           /* bmConfigured -- alt mode 1 will be set before
                                       initial connection */
    0x00, 0x00, 0x00,               /* 1-3 */
    0x00, 0x00, 0x00, 0x00,         /* 4-7 */
    0x00, 0x00, 0x00, 0x00,         /* 8-11 */
    0x00, 0x00, 0x00, 0x00,         /* 12-15 */
    0x00, 0x00, 0x00, 0x00,         /* 16-19 */
    0x00, 0x00, 0x00, 0x00,         /* 20-23 */
    0x00, 0x00, 0x00, 0x00,         /* 24-27 */
    0x00, 0x00, 0x00, 0x00,         /* 28-31 */
    0x00, 0x00, 0x00, 0x00,         /* bReserved */
    WBVAL(0xFF01),                  /* wSVID0 - DP Alt-mode */
    0x01,                           /* bAlternateMode0 */
    0x05,                           /* iAlterateModeString0 */
};

/* index to the first byte of bmConfigured */
const int USB_BillboardConfiguredIndexInBOS = 5 + 20 + 8;

/* WCID USB: Microsoft String Descriptor */
ALIGNED(4) const uint8_t WCID_String_Descriptor[] = {
	(8 * 2 + 2),					/* bLength (8 Char + Type + length) */
	USB_STRING_DESCRIPTOR_TYPE,		/* bDescriptorType */
	'M', 0,
	'S', 0,
	'F', 0,
	'T', 0,
	'1', 0,
	'0', 0,
	'0', 0,
	WCID_VENDOR_CODE, 0,
};

/* WCID USB: Microsoft Compatible ID Feature Descriptor */
ALIGNED(4) const uint8_t WCID_CompatID_Descriptor[] = {
	0x28, 0x00, 0x00, 0x00,						/* Length 40 bytes */
	0x00, 0x01,									/* Version */
	0x04, 0x00,									/* Compatibility ID Descriptor index  */
	0x01,										/* Number of sections */
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,							/* Reserved: 7 bytes */
	0x00,										/* Interface Number */
	0x01,										/* Reserved */
	'W', 'I', 'N', 'U', 'S', 'B', 0x00, 0x00,	/* Compatible ID: 8 bytes ASCII */
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,						/* Sub-Compatible ID: 8 bytes ASCII*/
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00,									/* Reserved: 6 bytes */
};

/* WCID USB: Microsoft Extended Properties Feature Descriptor */
ALIGNED(4) const uint8_t WCID_ExtProp_Descriptor[] = {
	0x92, 0x00, 0x00, 0x00,						/* Length 142 bytes */
	0x00, 0x01,									/* Version */
	0x05, 0x00,									/* Extended Properties Feature Descriptor index  */
	0x01, 0x00,									/* Number of sections */
	0x88, 0x00, 0x00, 0x00,						/* Size of the property section  */
	0x07, 0x00, 0x00, 0x00,						/* Property data type (1 = Unicode REG_SZ, see table below)  */
	0x2a, 0x00,									/* Property name length (40 bytes) */
	/* Property Name (L"DeviceInterfaceGUID")  */
	'D', 0, 'e', 0, 'v', 0, 'i', 0, 'c', 0, 'e', 0, 'I', 0, 'n', 0,
	't', 0, 'e', 0, 'r', 0, 'f', 0, 'a', 0, 'c', 0, 'e', 0, 'G', 0,
	'U', 0, 'I', 0, 'D', 0, 's', 0, 0, 0,
	0x50, 0x00, 0x00, 0x00,						/* Property name length (80 bytes) */
	/* Property Name "{a01674b4-c5f6-485c-af94-3271701d57b4}" */
	'{', 0, 'a', 0, '0', 0, '1', 0, '6', 0, '7', 0, '4', 0, 'b', 0,
	'4', 0, '-', 0, 'c', 0, '5', 0, 'f', 0, '6', 0, '-', 0, '4', 0,
	'8', 0, '5', 0, 'c', 0, '-', 0, 'a', 0, 'f', 0, '9', 0, '4', 0,
	'-', 0, '3', 0, '2', 0, '7', 0, '1', 0, '7', 0, '0', 0, '1', 0,
	'd', 0, '5', 0, '7', 0, 'b', 0, '4', 0, '}', 0, 0, 0, 0, 0,
};


