/***********************************************************************
* $Id:: mw_usbd_bb.h 575 2012-11-20 01:35:56Z usb10131                           $
*
* Project: USB device ROM Stack
*
* Description:
*     USB Definitions.
*
***********************************************************************
*   Copyright(C) 2011, NXP Semiconductor
*   All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.
**********************************************************************/

#ifndef __MW_USBD_BB_H__
#define __MW_USBD_BB_H__

/** \file
 *  \brief BillBoard class descriptors
 *  
 *  Definition of Billboard class descriptors and their bit defines.
 */

typedef enum {
    AMR_UNSPECIFIED_ERROR    = 0,
    AMR_CONFIG_NOT_ATTEMPTED = 1,
    AMR_CONFIG_FAILED        = 2,
    AMR_CONFIG_SUCCESSFUL    = 3
} ALT_MODE_RESULT_T;

#define BILLBOARD_CLASS                0x11
#define BILLBOARD_SUBCLASS             0x00
#define BILLBOARD_PROTOCOL             0x00

#define USB_DEVICE_CONTAINER_ID_TYPE   0x04
#define USB_DEVICE_BILLBOARD_TYPE      0x0d

#define USB_BOS_DESC_SIZE	        (sizeof(USB_BOS_DESCRIPTOR))
#define USB_CONTAINER_ID_DEV_CAP_SIZE  (sizeof(USB_CONTAINER_ID_DEVICE_CAPABILITY_DESCRIPTOR))
#define USB_BILLBOARD_DEV_CAP_SIZE     (sizeof(USB_BILLBOARD_DEVICE_CAPABILITY_DESCRIPTOR))
#define USB_SS_DEVICE_CAPABILITY_SIZE	(sizeof(USB_SS_DEVICE_CAPABILITY_DESCRIPTOR))
#define USB_DEVICE_CAPABILITY_SIZE		(sizeof(USB_DEVICE_CAPABILITY_DESCRIPTOR))

/* USB BOS Descriptor. */
 PRE_PACK struct _USB_BOS_DESCRIPTOR {
  uint8_t  bLength;
  uint8_t  bDescriptorType;
  uint16_t wTotalLength;
  uint8_t  bNumDeviceCaps;
} POST_PACK USB_BOS_DESCRIPTOR;

/* USB Device Capability Descriptor, Container ID */
typedef PRE_PACK struct _USB_CONTAINER_ID_DEVICE_CAPABILITY_DESCRIPTOR {
  uint8_t  bLength;
  uint8_t  bDescriptorType;
  uint8_t  bDeviceCapabilityType;
  uint8_t  bReserved;
  uint8_t  ContainerId[16];
} POST_PACK USB_CONTAINER_ID_DEVICE_CAPABILITY_DESCRIPTOR;

/* USB Device Capability Descriptor, Billboard */
typedef PRE_PACK struct _USB_BILLBOARD_DEVICE_CAPABILITY_DESCRIPTOR {
  uint8_t  bLength;
  uint8_t  bDescriptorType;
  uint8_t  bDeviceCapabilityType;
  uint8_t  iAdditionalInfoURL;
  uint8_t  bNumberOfAlternateModes;
  uint8_t  bPreferredAlternateMode;
  uint16_t vconnPower;
  uint8_t  bmConfigured[32];
  uint8_t  bReserved[4];
  uint16_t wSVID0;
  uint8_t  bAlternateMode0;
  uint8_t  iAlterateModeString0;
} POST_PACK USB_BILLBOARD_DEVICE_CAPABILITY_DESCRIPTOR;

/* USB Super Speed Device Capability Descriptor. */
PRE_PACK struct POST_PACK _USB_SS_DEVICE_CAPABLITY_DESCRIPTOR {
  uint8_t  bLength;
  uint8_t  bDescriptorType;
  uint8_t  bDeviceCapabilityType;
  uint8_t  bAttributes;
  uint16_t wSpeedsSupported;
  uint8_t  bFunctionalitySupport;
  uint8_t  bU1DevExitLat;
  uint16_t bU2DevExitLat;
};
typedef struct _USB_SS_DEVICE_CAPABLITY_DESCRIPTOR USB_SS_DEVICE_CAPABILITY_DESCRIPTOR;

/* USB Device Capability Descriptor, USB 2.0 extension for LPM. */
PRE_PACK struct POST_PACK _USB_DEVICE_CAPABLITY_DESCRIPTOR {
  uint8_t  bLength;
  uint8_t  bDescriptorType;
  uint8_t  bDeviceCapabilityType;
  uint32_t bmAttributes;
};
typedef struct _USB_DEVICE_CAPABLITY_DESCRIPTOR USB_DEVICE_CAPABILITY_DESCRIPTOR;

/** @}*/

#endif  /* __USBD_H__ */
