@echo off

setlocal enabledelayedexpansion

SET count=0

:: Check if we have 1 .dfu file in the current directory; quit if we don't have only 1.

for %%x in (*.dfu) do set /a count+=1

IF /I "%count%" NEQ "1" ( 
	ECHO Found !count! .dfu files. Make sure there is exactly 1 .dfu file in the script directory. Exiting...
	timeout 5
	EXIT

) ELSE (
	:: Download FW with dfu-util with the single .dfu we found.
	for %%x in (*.dfu) do set dfu_file=%%x
	ECHO Found one .dfu: !dfu_file!
	ECHO Make sure the device is connected and ready to receive the update.
	pause
	dfu-util_windows.exe -e
	timeout 2
	dfu-util_windows.exe -t 64 -D !dfu_file!
	timeout 2
	EXIT
)
endlocal