#!/bin/bash
BASEDIR="$( dirname "$0" )"
SCRIPT=$(basename $0)

#change to script directory
cd "$BASEDIR"
printf "\n"

#count number of .dfu in script directory. if 1, download .dfu, else quit
FILENUM=$(find . -maxdepth 1 -type f -name "*.dfu" | wc -l | tr -d ' ')

if [ $FILENUM -eq 1 ]
then
	DFUNAME=$(find . -maxdepth 1 -type f -name "*.dfu")
	DFUNAME=${DFUNAME:2}
  	printf "Found one .dfu: %s\n" "$DFUNAME"
  	printf "Make sure the device is connected and ready to receive the update.\n"
  	read -n1 -rs -p "Press any key to continue..."
  	printf "\n"
  	./dfu-util_linux -e
  	sleep 2
  	./dfu-util_linux -t 64 -D "$DFUNAME"
  	sleep 2
  	exit 0
else
	printf "Found %s .dfu files. Make sure there is exactly 1 .dfu file in the script directory. Exiting...\n" $FILENUM
	sleep 5
	exit 0
fi

