/*
 * @brief PMU example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2013
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/* Change this value to increase/decrease the time between power state changes */
#define POWER_CYCLE_SEC_DELAY 4

/* Index of PMU GP registers */
#define PWR_CYCLE_COUNT_REG_INDEX 0

#define ISP_Pin_Port				0
#define ISP_Pin_Pin					1

#define CURRENT_MEASUREMENT_MODE 1

#define LPCXpresso11U68_v2_RevC					1

#define CURRENT_POWER_SETTING		PMU_MCU_SLEEP
//#define CURRENT_POWER_SETTING		PMU_MCU_DEEP_SLEEP
//#define CURRENT_POWER_SETTING		PMU_MCU_POWER_DOWN
//#define CURRENT_POWER_SETTING		PMU_MCU_DEEP_PWRDOWN

#define GPIO_PININT_PIN     16	/* GPIO pin number mapped to PININT */
#define GPIO_PININT_PORT    0 /* GPIO port number mapped to PININT */
#define GPIO_PININT_INDEX   0	/* PININT index used for GPIO mapping */
#define PININT_IRQ_HANDLER  PIN_INT0_IRQHandler	/* GPIO interrupt IRQ function name */
#define PININT_NVIC_NAME    PIN_INT0_IRQn	/* GPIO interrupt NVIC interrupt name */

STATIC const PINMUX_GRP_T pinmuxingLowPower[] = {
	/* LPCXpresso pin			- Base board function		- Mapped function */

	
	{0, 2,  (IOCON_FUNC0 | IOCON_MODE_INACT)},
	
	{0, 3,  (IOCON_FUNC0 | IOCON_MODE_INACT)},
	
	{0, 6,  (IOCON_FUNC0 | IOCON_MODE_INACT )},
	
	{0, 7,  (IOCON_FUNC0 | IOCON_MODE_INACT )},
	
	{0, 8,  (IOCON_FUNC0 | IOCON_MODE_INACT )},
	
	{0, 9,  (IOCON_FUNC0 | IOCON_MODE_INACT )},
	
	{0, 11, (IOCON_FUNC2 | IOCON_MODE_INACT)},
	
	{0, 12, (IOCON_FUNC2 | IOCON_MODE_INACT)},

	{0, 13, (IOCON_FUNC2 | IOCON_MODE_INACT)},

	{0, 14, (IOCON_FUNC2 | IOCON_MODE_INACT)},
	
	
	
	{0, 21, (IOCON_FUNC0 | IOCON_MODE_INACT )},
	

	{0, 22, (IOCON_FUNC0 | IOCON_MODE_INACT )},
	
	
	{0, 23, (IOCON_FUNC1 | IOCON_MODE_INACT)},

#if LPCXpresso11U68_v2_RevC
	{1, 2, (IOCON_FUNC0 | IOCON_MODE_INACT )},
	{1, 14, (IOCON_FUNC0 | IOCON_MODE_INACT )},

	{1, 20, (IOCON_FUNC0 | IOCON_MODE_INACT )},

	{1, 21, (IOCON_FUNC0 | IOCON_MODE_INACT )},
	{1, 22, (IOCON_FUNC0 | IOCON_MODE_INACT )},
	{1, 23, (IOCON_FUNC0 | IOCON_MODE_INACT )},
#endif


{2, 16, (IOCON_FUNC0 | IOCON_MODE_INACT)},
{2, 17, (IOCON_FUNC0 | IOCON_MODE_INACT)},
{2, 18, (IOCON_FUNC0 | IOCON_MODE_INACT)},


};

void HandleUnusedPins(void)
{
		/* set pin P0.7 to output mode to do the wakeup time measurement*/
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 2);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 2, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 3);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 3, 0);

	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 6);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 6, 0);
    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 7);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 7, 0);

    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 8);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 8, 0);
    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 9);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 9, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 21);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 21, 0);
    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 22);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 22, 0);
    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 23);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 23, 0);
#if LPCXpresso11U68_v2_RevC
	Chip_GPIO_SetPinDIRInput(LPC_GPIO, 1, 2);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 14);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 14, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 16);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 16, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 20);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 20, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 21);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 21, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 22);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 22, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 23);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 23, 1);
#endif
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 2, 16);
	Chip_GPIO_SetPinState(LPC_GPIO, 2, 16, 1);
    Chip_GPIO_SetPinDIROutput(LPC_GPIO, 2, 17);
	Chip_GPIO_SetPinState(LPC_GPIO, 2, 17, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 2, 18);
	Chip_GPIO_SetPinState(LPC_GPIO, 2, 18, 1);
	

}
/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/* Handle interrupt from GPIO pin or GPIO pin mapped to PININT */
static void ProcessPowerState(CHIP_PMU_MCUPOWER_T crntPowerSetting)
{

	/* Switch on current selected power setting */
	switch (crntPowerSetting) {
	case PMU_MCU_SLEEP:
	default:
		
		/* Enter MCU Sleep mode */
		Chip_PMU_SleepState(LPC_PMU);
		break;

	case PMU_MCU_DEEP_SLEEP:
		
		/* We can optionally call Chip_SYSCTL_SetDeepSleepPD() to power down the
		   BOD and WDT if we aren't using them in deep sleep modes. */
		Chip_SYSCTL_SetDeepSleepPD(SYSCTL_DEEPSLP_BOD_PD | SYSCTL_DEEPSLP_WDTOSC_PD);

		/* We should call Chip_SYSCTL_SetWakeup() to setup any peripherals we want
		   to power back up on wakeup. For this example, we'll power back up the IRC,
		   FLASH, the system oscillator, and the PLL */
		Chip_SYSCTL_SetWakeup(~(SYSCTL_SLPWAKE_IRCOUT_PD | SYSCTL_SLPWAKE_IRC_PD |
								SYSCTL_SLPWAKE_FLASH_PD  ));

		/* Enter MCU Deep Sleep mode */
		Chip_PMU_DeepSleepState(LPC_PMU);

		/* Power anything back up here that isn't powered up on wakeup. The example
		   code below powers back up the BOD and WDT oscillator, which weren't setup to
		   power up in the Chip_SYSCTL_SetWakeup() function. */
		Chip_SYSCTL_SetDeepSleepPD(0);

		break;

	case PMU_MCU_POWER_DOWN:
		
		/* We can optionally call Chip_SYSCTL_SetDeepSleepPD() to power down the
		   BOD and WDT if we aren't using them in deep sleep modes. */
		Chip_SYSCTL_SetDeepSleepPD(SYSCTL_DEEPSLP_BOD_PD | SYSCTL_DEEPSLP_WDTOSC_PD);

		/* We should call Chip_SYSCTL_SetWakeup() to setup any peripherals we want
		   to power back up on wakeup. For this example, we'll power back up the IRC,
		   FLASH, the system oscillator, and the PLL */
		Chip_SYSCTL_SetWakeup(~(SYSCTL_SLPWAKE_IRCOUT_PD | SYSCTL_SLPWAKE_IRC_PD |
								SYSCTL_SLPWAKE_FLASH_PD ));

		/* Enter MCU Power down mode */
		Chip_PMU_PowerDownState(LPC_PMU);

		break;

	case PMU_MCU_DEEP_PWRDOWN:
		
	
		/* Enter MCU Deep Power down mode - chip will reset on wakeup */
		Chip_PMU_DeepPowerDownState(LPC_PMU);

		break;
	}
}
void PININT_IRQ_HANDLER(void)
{
//	LPC_SYSCTL->SYSAHBCLKCTRL |= (1 << SYSCTL_CLOCK_IOCON);//Chip_GPIO_SetPinState(LPC_GPIO, 0, 7, 1);
	LPC_GPIO->B[0][7] = 1;
	Chip_PININT_ClearIntStatus(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	
}
/*****************************************************************************
 * Public functions
 ****************************************************************************/
void ConfigureWakeupPin(void)
{	
	
		Chip_Clock_SetIOCONFiltClockDiv(0, 64);
	Chip_GPIO_SetPinDIRInput(LPC_GPIO, GPIO_PININT_PORT, GPIO_PININT_PIN);


	Chip_IOCON_PinMuxSet(LPC_IOCON, GPIO_PININT_PORT, GPIO_PININT_PIN,
		      (IOCON_DIGMODE_EN | IOCON_MODE_INACT) ) ;
	/* Enable PININT clock */
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_PINT);

	/* Configure interrupt channel for the GPIO pin in SysCon block */
	Chip_SYSCTL_SetPinInterrupt(GPIO_PININT_INDEX, GPIO_PININT_PORT, GPIO_PININT_PIN);

	/* Configure channel interrupt as edge sensitive and falling edge interrupt */
	Chip_PININT_ClearIntStatus(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	Chip_PININT_SetPinModeEdge(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	Chip_PININT_EnableIntLow(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	
	/*this line of code is only needed for deep sleep and power down mode*/
	Chip_SYSCTL_EnableStartPin(GPIO_PININT_INDEX);

	/* Enable interrupt in the NVIC */
	NVIC_ClearPendingIRQ(PININT_NVIC_NAME);
	NVIC_EnableIRQ(PININT_NVIC_NAME);
}

/**
 * @brief	Main program body
 * @return	int
 */
int main(void)
{
	int i, j;
	CHIP_SYSCTL_MAINCLKSRC_T saved_clksrc;
		
		/* Setup SystemCoreClock and any needed board code */
		SystemCoreClockUpdate();
	    Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);
	    Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_GPIO);
	    Chip_IOCON_PinMuxSet(LPC_IOCON, ISP_Pin_Port, ISP_Pin_Pin,
			      (IOCON_DIGMODE_EN | IOCON_MODE_PULLUP) ) ;
		Chip_GPIO_SetPinDIRInput(LPC_GPIO, ISP_Pin_Port, ISP_Pin_Pin);
		ConfigureWakeupPin();


		/*Only enter low power mode after ISP button is pressed*/

		while (Chip_GPIO_ReadPortBit(LPC_GPIO, ISP_Pin_Port, ISP_Pin_Pin)) ;

		Chip_IOCON_SetPinMuxing(LPC_IOCON, pinmuxingLowPower, sizeof(pinmuxingLowPower) / sizeof(PINMUX_GRP_T));
		HandleUnusedPins();

		// set P0_7 Low
		LPC_GPIO->B[0][7] = 0;
		LPC_SYSCTL->SYSAHBCLKCTRL = 0x80055;

		#if CURRENT_MEASUREMENT_MODE
	//	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_RAM0);
		Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_IOCON);
	    Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_GPIO);
    	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_PINT);

		#endif
    	saved_clksrc = Chip_Clock_GetMainClockSource();
    		  if (saved_clksrc == SYSCTL_MAINCLKSRC_PLLOUT) {
    			Chip_Clock_SetMainClockSource(SYSCTL_MAINCLKSRC_IRC);
    	     Chip_SYSCTL_PowerDown(SYSCTL_POWERDOWN_SYSPLL_PD);

    		  }

		/* Enter selected power state */
		ProcessPowerState(CURRENT_POWER_SETTING);

		/* On wakeup, restore PLL power if needed */
			   if (saved_clksrc == SYSCTL_MAINCLKSRC_PLLOUT) {

			    /* Turn on the PLL by clearing the power down bit */
			    Chip_SYSCTL_PowerUp(SYSCTL_POWERDOWN_SYSPLL_PD);

			   /* Wait for PLL to lock */
			    while (!Chip_Clock_IsSystemPLLLocked()) {}

			    /* Set system clock divider to 1 */
			    Chip_Clock_SetSysClockDiv(1);

			    /* Set main clock source to the system PLL. This will drive 48MHz
			    for the main clock and 48MHz for the system clock */
				Chip_Clock_SetMainClockSource(SYSCTL_MAINCLKSRC_PLLOUT);
		               }

		for (j=1; j<4; j++)
		{

			Board_LED_Toggle(0);
			for (i=0; i<1000000; i++);

		};


		while(1);

		return 0;
}
