/*
 * @brief Heart-rate Monitor Software Example (Cortex-M4F core)
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"

/** @defgroup PERIPH_M4MASTER_5410X Multicore blinky example (M4 core as master)
 * @ingroup EXAMPLES_CORE_5410X
 * @include "multicore\m4master_blinky\readme.txt"
 */

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

#ifdef __CODE_RED
extern uint32_t __core_m0slave_START__[];
#define M0_BOOT_STACKADDR &__core_m0slave_START__[0]
#define M0_BOOT_ENTRYADDR &__core_m0slave_START__[1]

#else
/* The M0 slave core's boot code is loaded to execute at address 0x2000.
   These address contain the needed M0 boot entry point and the M0 stack
     pointer that the M4 master core sets up for boot. */
#define M0_BOOT_STACKADDR           0x20000
#define M0_BOOT_ENTRYADDR           0x20004
#endif

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/


/*****************************************************************************
 * Private functions
 ****************************************************************************/
 

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/**
 * @brief	main routine for M4 core heart-rate example
 * @return	Function should not exit.
 */
int main(void)
{
	uint32_t *jumpAddr, *stackAddr;
	
	SystemCoreClockUpdate();
	Board_Init();
		
	/* Boot M0 core, using reset vector and stack pointer from the CM0+
	   image in FLASH. */
	stackAddr = (uint32_t *) (*(uint32_t *) M0_BOOT_STACKADDR);
	jumpAddr = (uint32_t *) (*(uint32_t *) M0_BOOT_ENTRYADDR);
	Chip_CPU_CM0Boot(jumpAddr, stackAddr);
	
	while (1) {
		__WFI();
	}
	
	return 0;
}
