/*
 * @brief Coremark Framework Project
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"
#include "core_portme.h"
#include "chip.h"

/**
 * @}
 */

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/* Saved clock source */
static volatile CHIP_SYSCON_MAINCLKSRC_T saved_clksrc;
/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
/* Pin muxing table, only items that need changing from their default pin
   state are in this table. Not every pin is mapped. */
STATIC const PINMUX_GRP_T pinmuxing_lowpower[] = {
	{0, 0,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* UART0 RX */
	{0, 1,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* UART0 TX */
	{0, 2,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 
	{0, 3,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 	
	{0, 4,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 
	{0, 5,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 
	{0, 6,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 
	{0, 7,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, 
	{0, 8,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 9,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 10,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* */
	{0, 11,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 12,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 13,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 14,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 15,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	//{0, 16,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  swd */ 
	//{0, 17,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  swd */
	{0, 18,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 19,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 20,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 21,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 22,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 23,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 24,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 25,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 26,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 27,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{0, 28,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 9,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)},  /*  */
	{1, 10,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 11,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 12,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 13,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 14,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 15,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 16,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
	{1, 17,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /*  */
};

void SetupUnusedPins(void)
{
Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 1);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 1, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 2);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 2, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 3);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 3, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 4);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 4, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 5);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 5, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 6);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 6, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 7);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 7, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 8);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 8, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 9);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 9, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 10);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 10, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 11);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 11, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 12);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 12, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 13);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 13, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 14);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 14, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 15);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 15, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 18);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 18, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 19);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 19, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 20);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 20, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 21);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 21, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 22);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 22, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 23);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 23, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 24);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 24, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 25);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 25, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 26);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 26, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 27);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 27, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 28);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 28, 0);	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 9);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 9, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 10);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 10, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 11);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 11, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 12);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 12, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 13);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 13, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 14);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 14, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 15);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 15, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 16);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 16, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 17);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 17, 0);
}

void ConfigureUnusedPins(void)
{
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_IOCON);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO0);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO1);
	Chip_IOCON_SetPinMuxing(LPC_IOCON, pinmuxing_lowpower, sizeof(pinmuxing_lowpower) / sizeof(PINMUX_GRP_T));
	SetupUnusedPins();
}

/**
 * @brief	main routine for COREMARK example
 * @return	Function should not exit.
 */
int main(void)
{
	int counter =0;
	CHIP_SYSCON_MAINCLKSRC_T saved_clksrc;

	/* Run the CoreMark configuration test */
	
#if defined(COREMARK_SCORE_TEST) // COREMARK_SCORE_TEST defined in core_portme.h
	
	Board_SetupClocking();
	SystemCoreClockUpdate();
	Board_Init();
	
	/* Show ROM version */
	DEBUGOUT("ROM version = %04x\r\n", Chip_POWER_GetROMVersion());	
	DEBUGSTR("CoreMark Start \r\n");
	
	/* Initialize and enable timer for CoreMark benchmark */
	Chip_TIMER_Init(LPC_TIMER0);
	Chip_TIMER_Enable(LPC_TIMER0);	

	/* Run coremark */
  core_main(); 

	DEBUGSTR("CoreMark Finish \r\n");
	
	Chip_TIMER_Disable(LPC_TIMER0);

	while (1) {
		Chip_POWER_EnterPowerMode(POWER_SLEEP, 0);
	}

	/* End run of the CoreMark configuration test */

#else

	/* Run the uA/MHz configuration test */

	/* Setup MCU clocking */
	Chip_SetupIrcClocking(BOARD_MAINCLOCKRATE);
	SystemCoreClockUpdate();

	/* Set async bus clock source to the 12 MHz IRC, independent of BOARD_MAINCLOCKRATE */
	Chip_Clock_SetAsyncSysconClockSource(SYSCON_ASYNC_IRC);

	/* set pins to inactive state */
	ConfigureUnusedPins();

	/* powerdown blocks and turn off clocks */
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SRAM2);
	//Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SRAM1); 	//Leave SRAM1 on as that is the scatterload destination
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SRAM0B);
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SRAM0A);	
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_ROM);
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_32K_OSC);
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_BOD_RST);

	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_ROM);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_DMA);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_IOCON);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_GPIO0);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_GPIO1);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_PINT);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_GINT);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_CRC);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_WWDT);
	Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_RTC);
		
	/* Switch main system clock to IRC and power down PLL if we are are running at 12 MHz or lower */
	saved_clksrc = Chip_Clock_GetMainClockSource();
	if (saved_clksrc == SYSCON_MAINCLKSRC_PLLOUT) {
		if(Chip_Clock_GetSystemClockRate() == 12000000){
			Chip_Clock_SetMainClockSource(SYSCON_MAINCLKSRC_IRC);
			Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SYS_PLL);
		}
	}
	
	/* Initialize and enable timer for CoreMark benchmark */
	Chip_TIMER_Init(LPC_TIMER0); 
	Chip_TIMER_Enable(LPC_TIMER0);	
	
	/* Turn off flash to save power after scatterloading to SRAM */
	Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_FLASH);

	/* Run coremark forever */
	while(1){
		core_main(); 
	}
	
#endif
	
	/* End run of the uA/MHz configuration test */		
	
	return 0;
}
