/*
 * @brief CRP example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2013
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"
#include <stdio.h>

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

#define TICKRATE_HZ1 (1000)	/* 10 ticks per second */
#define TIMEOUT     10000				/* Timeout   (0 to disable)           */
volatile unsigned long SysTickCnt;

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/**
 * @brief	Handle interrupt from SysTick timer
 * @return	Nothing
 */
void SysTick_Handler(void)
{
	
	static int x = 0;
	if (x++ > 100) {
		
		Board_LED_Toggle(0);
		x = 0;
	}
	SysTickCnt++;
}

/**
 * @brief	main routine for blinky example
 * @return	Function should not exit.
 */
int main(void)
{

	SystemCoreClockUpdate();
	Board_Init();
	Chip_GPIO_Init(LPC_GPIO_PORT);
	
	Chip_SCU_PinMuxSet(9, 1, (SCU_MODE_PULLUP | SCU_MODE_FUNC0)); // P9_1 used for LED  
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 4,13);         // GPIO0 4[13] set as output 
	Chip_GPIO_SetPinState(LPC_GPIO_PORT, 4, 13, false);     // GPIO0 4[13] set to low state
	
	/* Re-Invoke trigger button*/
	// On Keil MCB board, P4_0 used to trigger Re-Invoke Button , disable pull up and pull down rsistors, enable input buffer
	Chip_SCU_PinMuxSet(4, 0, (SCU_MODE_INBUFF_EN | SCU_MODE_INACT | SCU_MODE_FUNC0));     
	Chip_GPIO_SetPinDIRInput(LPC_GPIO_PORT, 2,0);											// GPIO	2[0] set as input 
	
	/* Enable and setup SysTick Timer at a periodic rate */
	SysTick_Config(SystemCoreClock / TICKRATE_HZ1);

	while(1)
	{
		/* Detect if user pressed Re-Invoke button */
		if((Chip_GPIO_GetPinState(LPC_GPIO_PORT,2,0)== false))
		{
			Chip_GPIO_SetPinState(LPC_GPIO_PORT, 4, 13, true);
			break;
		}
		
		/* if timeout is enabled, check timeout     */
	if (SysTickCnt > TIMEOUT && TIMEOUT)          // timeout is ~10 seconds
	  break;
		
	}
	
		Chip_GPIO_SetPinState(LPC_GPIO_PORT, 6, 24, false);     // LED PD_10 is OFF on button press or timeout
		Chip_GPIO_SetPinState(LPC_GPIO_PORT, 4, 13, true); // LED P9_1 is ON on button press or timeout

	
	/* Disable interrupt mode so it doesn't fire during FLASH updates */
	__disable_irq();
	/* Re-Invoke ISP */
	Chip_IAP_ReinvokeISP();
	
	/* code should not get here */
	while(1);
	
	return 0;
}
